/*****************************************************************************

			       XCopilot

This code is part of XCopilot, a port of copilot

     Portions of this code are Copyright (C) 1997 Ivan A. Curtis
		       icurtis@radlogic.com.au

The original MS-Windows95 copilot emulator was written by Greg Hewgill.
The following copyright notice appeared on the original copilot sources:

		  Copyright (c) 1996 Greg Hewgill

 MC68000 Emulation code is from Bernd Schmidt's Unix Amiga Emulator.
       The following copyright notice appeared in those files:

	  Original UAE code Copyright (c) 1995 Bernd Schmidt

This code must not be distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	memory.h

Description:	Copilot Memory management

Update History:   (most recent first)
   Ian Goldberg 26-Jun-98 10:30 -- moved bank locations into this header
                                -- increased SCRATCH_SIZE
   I. Curtis    26-Feb-97 14:59 -- modified from win95 version

******************************************************************************/
#define ram_start     0x00000000
#define sram_start    0x10000000
#define rom_start     0x10c00000
#define scratch_start 0xf0000000
#define custom_start  0xffff0000

/* Palm 3 can load larger .prc files.  This can be increased to 0x1000000
   at the expense of disk space.  - Ian */
#define SCRATCH_SIZE 0x40000

#define PILOTCPU_ROM_NOT_FOUND     1
#define PILOTCPU_ERROR_LOADING_ROM 2
#define PILOTCPU_ERROR_LOADING_RAM 3

extern int memory_init(int ramsize, const char *dir, const char *romfile,
                       const char *ramfile, const char *scratchfile,
		       int reset, int nocheck);

/* Default memory access functions */

extern UWORD *default_xlate(CPTR a);
extern int default_check(CPTR a, ULONG b);

extern int buserr;

typedef ULONG (*lget_func)(CPTR);
typedef UWORD (*wget_func)(CPTR);
typedef UBYTE (*bget_func)(CPTR);
typedef void (*lput_func)(CPTR,ULONG);
typedef void (*wput_func)(CPTR,UWORD);
typedef void (*bput_func)(CPTR,UBYTE);
typedef UWORD *(*xlate_func)(CPTR);
typedef int (*check_func)(CPTR, ULONG);

typedef struct {
    lget_func lget;
    wget_func wget;
    bget_func bget;
    lput_func lput;
    wput_func wput;
    bput_func bput;
    xlate_func xlateaddr;
    check_func check;
} addrbank;

extern addrbank ram_bank;
extern addrbank rom_bank;
extern addrbank custom_bank;

extern addrbank *membanks;
extern UBYTE *scratchmemory;

extern unsigned int bankindex(CPTR a);

extern ULONG longget(CPTR addr);
extern UWORD wordget(CPTR addr);
extern UBYTE byteget(CPTR addr) ;

extern void longput(CPTR addr, ULONG l);
extern void wordput(CPTR addr, UWORD w);
extern void byteput(CPTR addr, UBYTE b);
extern int check_addr(CPTR a);

extern ULONG get_long(CPTR addr) ;
extern UWORD get_word(CPTR addr) ;
extern UBYTE get_byte(CPTR addr) ;

extern void put_long(CPTR addr, ULONG l) ;
extern void put_word(CPTR addr, UWORD w) ;
extern void put_byte(CPTR addr, UBYTE b) ;

extern UWORD *get_real_address(CPTR addr);
extern int valid_address(CPTR addr, ULONG size);
void mem_setscratchaddr(UBYTE *addr);
