/*****************************************************************************

			       XCopilot

This code is part of XCopilot, a port of copilot

     Portions of this code are Copyright (C) 1997 Ivan A. Curtis
		       icurtis@radlogic.com.au

The original MS-Windows95 copilot emulator was written by Greg Hewgill.
The following copyright notice appeared on the original copilot sources:

		  Copyright (c) 1996 Greg Hewgill

 MC68000 Emulation code is from Bernd Schmidt's Unix Amiga Emulator.
       The following copyright notice appeared in those files:

	  Original UAE code Copyright (c) 1995 Bernd Schmidt

This code must not be distributed without these copyright notices intact.

*******************************************************************************
*******************************************************************************

Filename:	fakecall.c

Description:	support for Copilot debug module

Update History:   (most recent first)
   I. Curtis  28-Feb-97 22:52 -- created

******************************************************************************/

typedef struct _FakeCall {
  struct regstruct origregs, regs;
  unsigned long nextaddr;
  char *SaveMemory;
} FakeCall;

FakeCall *fc_New(shared_img *shptr);
void fc_Dispose(FakeCall *fc, shared_img *shptr);
void fc_PushWord(FakeCall *, UWORD x);
void fc_PushLong(FakeCall *, unsigned long x);
void *fc_PushPtr(FakeCall *, int size);
void fc_Call(FakeCall *fc, shared_img *shptr, UWORD api, int debug);
unsigned long fc_GetResultD0(FakeCall *);
unsigned long fc_GetResultA0(FakeCall *);

#define sysTrapMemNumRAMHeaps             40968
#define sysTrapMemHeapID                  40969
#define sysTrapMemHeapFreeBytes           40971
#define sysTrapMemChunkNew                40977
#define sysTrapMemChunkFree               40978
#define sysTrapMemPtrNew                  40979
#define sysTrapMemHandleLock              40993
#define sysTrapMemHandleUnlock            40994
#define sysTrapDmCreateDatabase           41025
#define sysTrapDmDeleteDatabase           41026
#define sysTrapDmGetDatabase              41028
#define sysTrapDmFindDatabase             41029
#define sysTrapDmDatabaseInfo             41030
#define sysTrapDmOpenDatabase             41033
#define sysTrapDmCloseDatabase            40134
#define sysTrapDmNewRecord                41045
#define sysTrapDmReleaseRecord            41054
#define sysTrapDmCreateDatabaseFromImage  41087

#define memErrNotEnoughSpace              0x102
#define dmErrDatabaseOpen                 0x205
#define dmModeReadWrite                   3
