/* Colormap management library
   Copyright 1998 Cuspy Solutions, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <X11/Xlib.h>
#include <X11/xpm.h>

typedef struct cmap *CMAP;

extern CMAP CMAP_Create(Display *display, int screen, Visual *visual,
			int alloc, int use_pcmap);

extern void CMAP_SetColor(CMAP cmap, Pixel index, XColor *color);

extern Colormap CMAP_GetColormap(CMAP cmap);

extern int CMAP_AllocColor(CMAP cmap, XColor *color);
extern int CMAP_AllocNamedColor(CMAP cmap, char *colorname, XColor *color);

/* We need to have a version of Xpm the supports the colormap closures.  The
 * earliest one that does this is 4.9 which is also known as 3.4i.
 */
#if XpmIncludeVersion < 30409

extern XpmAllocColorFunc CMAP_GetXPMAllocColorFunc(void);
extern XpmFreeColorsFunc CMAP_GetXPMFreeColorsFunc(void);
extern void *CMAP_GetXPMClosure(CMAP cmap);

#endif
