/*

------------------------------------------------------------------------------

A license is hereby granted to reproduce this software source code and
to create executable versions from this source code for personal,
non-commercial use.  The copyright notice included with the software
must be maintained in all copies produced.

THIS PROGRAM IS PROVIDED "AS IS". THE AUTHOR PROVIDES NO WARRANTIES
WHATSOEVER, EXPRESSED OR IMPLIED, INCLUDING WARRANTIES OF
MERCHANTABILITY, TITLE, OR FITNESS FOR ANY PARTICULAR PURPOSE.  THE
AUTHOR DOES NOT WARRANT THAT USE OF THIS PROGRAM DOES NOT INFRINGE THE
INTELLECTUAL PROPERTY RIGHTS OF ANY THIRD PARTY IN ANY COUNTRY.

Copyright (c) 1995, John Conover, All Rights Reserved.

Comments and/or bug reports should be addressed to:

    john@johncon.com (John Conover)

------------------------------------------------------------------------------

stack.h, general include file for stack operations

(void) PUSH (stack,element);
element POP (stack);

for stack operations, a singly linked list will suffice, which can be
implemented with simple in line macros-the macros are PUSH(), and
POP() and require that the structure used has a linked list element
with a name "next," that is used to reference the next structure in
the list; the typedef of the structure operated on does not matter,
and the stack reference should be initialized to null before any stack
operations are performed

usage is to call PUSH() and POP() as stack operations, for example:

    typdef struct my_struct
    {
        .
        .
        .
        struct my_struct *next;
    } MY_STRUCT;

    MY_STRUCT *stack = (MY_STRUCT *) 0,
              *element;

    while (something)
    {
        .
        .
        .
        element = allocate_element ();
        PUSH(stack, element);
    }

    while (stack != (MY_STRUCT *) 0)
    {
        element = POP(stack);
        .
        .
        .
        deallocate_element (element);
    }

to test the macros, since most compilers will not accept a ".h" file
extension to compile into an object module, copy stack.h as
teststack.c, and compile teststack.c with -DTEST_STACK

note that the ';' inside of the PUSH() and POP() macros will prohibit
their usage inside of the arguments in while() constructs

$Revision: 1.0 $
$Date: 1995/04/22 05:14:50 $
$Id: stack.h,v 1.0 1995/04/22 05:14:50 john Exp $
$Log: stack.h,v $
 * Revision 1.0  1995/04/22  05:14:50  john
 * Initial revision
 *

*/

#ifndef _STACK_H /* if not defined then stack.h has not yet been included */

#define _STACK_H

#define STACK_H_ID "$Id: stack.h,v 1.0 1995/04/22 05:14:50 john Exp $" /* module version */

#define PUSH(x,y) (y)->next=(x);(x)=(y)

#define POP(x) (x);(x)=(x)->next

#endif

#ifdef TEST_STACK

/*

simple exerciser for testing the stack macros, push many elements onto
the stack, and pop them off, printing the element number to stdout

*/

#include <stdio.h>
#include <stdlib.h>

typedef struct stack_element /* stack element structure */
{
    int i; /* integer data element */
    struct stack_element *next; /* reference to next element in the stack's list */
} ELEMENT;

#ifdef __STDC__

int main (int argc, char *argv[])

#else

int main (argc, argv)
    int argc;
    char *argv[];

#endif

{
    int number = 100, /* number of elements that will be pushed/poped on the stack */
        i; /* stack element counter */

    ELEMENT *stack = (ELEMENT *) 0, /* stack reference */
            *ptr; /* reference to a stack element */

    if (argc > 1) /* any arguments? */
    {
        number = atoi (argv[1]); /* yes, assume the first argument is the number of stack elements */
    }

    for (i = 0; i < number; i++) /* for number many elements */
    {

        if ((ptr = (ELEMENT *) malloc (sizeof (ELEMENT))) != 0) /* allocate a stack element */
        {
            ptr->i = i; /* store the element's number */
            PUSH (stack, ptr); /* push it on the stack */
        }

        else
        {
            (void) fprintf (stderr, "Error allocating memory\n"); /* couldn't allocate a stack element, print the error and exit */
            exit (1);
        }

    }

    while (stack != (ELEMENT *) 0) /* there is a 100000 elements on the stack, pop them off, printing the number to stdout */
    {
        ptr = POP (stack); /* get the stack element */
        (void) printf ("%d\n", ptr->i); /* print the element number to stdout */
        free (ptr); /* and free the stack element */
    }

    exit (0); /* sucessful */

#ifdef LINT /* include only if running lint */

    return (0); /* for LINT formality */

#endif

}

#endif
