/*

------------------------------------------------------------------------------

A license is hereby granted to reproduce this software source code and
to create executable versions from this source code for personal,
non-commercial use.  The copyright notice included with the software
must be maintained in all copies produced.

THIS PROGRAM IS PROVIDED "AS IS". THE AUTHOR PROVIDES NO WARRANTIES
WHATSOEVER, EXPRESSED OR IMPLIED, INCLUDING WARRANTIES OF
MERCHANTABILITY, TITLE, OR FITNESS FOR ANY PARTICULAR PURPOSE.  THE
AUTHOR DOES NOT WARRANT THAT USE OF THIS PROGRAM DOES NOT INFRINGE THE
INTELLECTUAL PROPERTY RIGHTS OF ANY THIRD PARTY IN ANY COUNTRY.

Copyright (c) 1995, John Conover, All Rights Reserved.

Comments and/or bug reports should be addressed to:

    john@johncon.com (John Conover)

------------------------------------------------------------------------------

relclose.c, relclose module for rel

void relclose (int err);

    close program operations-this module is used primarily for
    handling SIGINT, although use as a general shutdown procedure is
    permitted

    all elements should be returned to their initialized values prior
    to termination of this module in such a manner that the program
    could be restarted at the conclusion of execution of this module,
    indefinitely many times

    this module should not be used as a general way of closing files,
    deallocating memory, or printing error messages-these should be
    handled by the appropriate modules in the program; the sole
    exception is for interrupt vectoring

the algorithm is as follows:

    ignore signals of all kinds

    if the error number was a system interrupt

        print the error message for the interrupt number
        if any file or directory is open, close it

    if any memory is allocated, deallocate it

    restore signaling to its original state when the program was
    invoked

    exit with the error argument (if any)

Usage is a call with the error, for example

    int retval;

    relclose (retval);

The argument, err, represents the error code that the program will
terminate with-zero means no error

On any error encountered by this module, print the error, immediately;
there is no return from this module

There is no test case for this module.

$Revision: 1.0 $
$Date: 1995/04/22 05:13:18 $
$Id: relclose.c,v 1.0 1995/04/22 05:13:18 john Exp $
$Log: relclose.c,v $
 * Revision 1.0  1995/04/22  05:13:18  john
 * Initial revision
 *

*/

#include "rel.h"

#ifndef LINT /* include rcsid only if not running lint */

static char rcsid[] = "$Id: relclose.c,v 1.0 1995/04/22 05:13:18 john Exp $"; /* module version */
static char rcsid_h[] = RELCLOSE_H_ID; /* module include version */

#endif

#ifdef __STDC__

void relclose (int err)

#else

void relclose (err)
    int err;

#endif

{

    if (signal (SIGINT, SIG_IGN) == SIG_ERR) /* ignore intrrupts during this routine */
    {
        message (URIGN_ERR, (char *) 0); /* couldn't install it, print the error and continue */
    }

    if (err <= max_interrupts) /* error a signal interrupt error? */
    {
        message (err, (char *) 0); /* yes, print the error */
        int_searchfile (); /* yes, check if the searchfile module is shutdown, if not shut it down */
        int_searchpath (); /* check if the searchpath module is shutdown, if not shut it down */
    }

    memdealloc (); /* deallocate memory */

    if (signal (SIGINT, SIG_DFL) == SIG_ERR) /* restore default interrupts */
    {
        message (URRSG_ERR, (char *) 0); /* couldn't install it, print the error and continue */
    }

    exit (err); /* exit to the OS with any error */
}
