static char working_c_rcsid[]="working.c,v 1.1.1.1 1994/06/18 19:43:29 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * working.c,v
 * Revision 1.1.1.1  1994/06/18  19:43:29  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/AsciiText.h>
#include "h.h"
#include "def.h"
#include "struct.h"
#include "dqs.h"
#include "globals.h"
#include "stdstuff.h"
#include "working.h"

extern XtAppContext XAppContext;

static Widget DQSUsageWorkingPopupTextW;
static Widget DQSUsageWorkingPopupParentW;
static BOOLEAN PoppedUp = FALSE;

void
DQSUsageWorkingUpdatePercentage (TextString)
     char *TextString;
{
  DENTER ((DQS_EVENT, "DQSUsageWorkingUpdatePercentage"));

  if (PoppedUp == TRUE)
    {
      Arg wargs[1];

      XtSetArg (wargs[0], XtNstring, TextString);
      XtSetValues (DQSUsageWorkingPopupTextW, wargs, ONE);
    }

  DEXIT;
}

void
DQSUsageWorkingPopdown ()
{
  XEvent theEvent;
  XtInputMask TheMask;

  DENTER ((DQS_EVENT, "DQSUsageWorkingPopdown"));

  if (PoppedUp == TRUE)
    {
      CPUUsageRemoveWorkProc ();
      XtUnmapWidget (DQSUsageWorkingPopupParentW);
      XtPopdown (DQSUsageWorkingPopupParentW);

      while (TheMask = XtAppPending (XAppContext))
	XtAppProcessEvent (XAppContext, TheMask);

      PoppedUp = FALSE;
    }

  DEXIT;
}

static void
DQSUsageWorkingPopupCancel (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "DQSUsageWorkingPopupCancel"));

  if (PoppedUp == TRUE)
    {
      DQSUsageWorkingPopdown ();
      PoppedUp = FALSE;
    }

  DEXIT;
}

void
DQSUsageWorkingPopup (W)
     Widget W;
{
  static Widget DQSUsageWorkingPopupFormW;
  static Widget DQSUsageWorkingPopupTitleLabelW;
  static Widget DQSUsageWorkingPopupCancelButtonW;
  static int DejaVu = 0;
  Arg wargs[1];

  DENTER ((DQS_EVENT, "DQSUsageWorkingPopup"));

  if (DejaVu == 0)
    {
      DQSUsageWorkingPopupParentW =
	XtCreatePopupShell ("DQSUsageWorkingPopup", transientShellWidgetClass,
			    W, NULL, ZERO);
      
      DQSUsageWorkingPopupFormW =
	XtCreateManagedWidget ("DQSUsageWorkingPopupForm", formWidgetClass,
			       DQSUsageWorkingPopupParentW, NULL, ZERO);
      
      DQSUsageWorkingPopupTitleLabelW =
	XtCreateManagedWidget("DQSUsageWorkingPopupTitle", labelWidgetClass,
			      DQSUsageWorkingPopupFormW, NULL, ZERO);
      
      DQSUsageWorkingPopupTextW =
	XtCreateManagedWidget("DQSUsageWorkingPopupText", asciiTextWidgetClass,
			      DQSUsageWorkingPopupFormW, NULL, ZERO);

      DQSUsageWorkingPopupCancelButtonW =
	XtCreateManagedWidget ("DQSUsageWorkingPopupCancel",
			       commandWidgetClass, DQSUsageWorkingPopupFormW,
			       NULL, ZERO);
      XtAddCallback(DQSUsageWorkingPopupCancelButtonW, XtNcallback,
		    (XtCallbackProc) DQSUsageWorkingPopupCancel,
		    DQSUsageWorkingPopupParentW);

      DejaVu = 1;
    }
  
  if (PoppedUp == FALSE)
    {
      XtSetArg (wargs[0], XtNstring, "Reading accounting file...");
      XtSetValues (DQSUsageWorkingPopupTextW, wargs, ONE);
      
      XtPopup (DQSUsageWorkingPopupParentW, XtGrabNonexclusive);

      PoppedUp = TRUE;
    }

  DEXIT;
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
