static char dqs_resolve_rcsid[]="$Id: dqs_resolve.c,v 1.1.1.1 1997/04/10 15:10:33 green Exp $";

/*----------------------------------------------------
 * dqs_resolve.c Tom Green Mon Jan 31 10:42:59 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_resolve.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:33  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.5  1996/11/20 23:04:09  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.4  1996/06/27  01:55:58  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.3  1996/03/22  04:21:03  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.2  1994/03/26  16:33:36  green
 * added "-srl" support.
 *
 * dqs_resolve.c:dqs_read_resolve_file() now returns the primary qmaster
 * name for fields marked as "none"
 *
 * Revision 3.1  1994/03/22  21:49:26  green
 * added dqs_get_cwd() to dqs_resolve.c<this is a temporary fix>
 *
 * minor DPRINTF(()) format change in dqs_setup.c
 *
 * Revision 3.0  1994/03/07  04:14:24  green
 * 3.0 freeze
 *
 * Revision 1.8  1994/03/01  22:03:03  green
 * setsockopt on mips-dec-OSF1-1.0 requires s_in.sin_addr.s_addr
 * to be set before a bind.<dqs_execd.c>
 *
 * removed some debug code from dqs_resolve.c
 *
 * Revision 1.7  1994/03/01  19:23:37  green
 * removed "test" from the default dependancy list in Makefile.proto.
 *
 * changed dqs_show_all_cofigurations() to dqs_show_all_configurations()
 * in dqs_execd.c, qmaster.c and dqs_utility.c.
 *
 * fixed the broken comment exclusion feature in dqs_resolve.c.
 *
 * fixed bug in me.default_cell in dqs_setup.c where conf_file
 * default_cell was not updating me.default_cell.
 *
 * getenv(DQS_CELL) mved out of dqs_getme() into dqs_setup()
 * to allow dqs_getme() to be called on forks.
 *
 * remade func.h.
 *
 * pulled garbage out of test.c.
 *
 * added syntax instructions to resolve_file
 *
 * Revision 1.6  1994/02/28  13:47:46  green
 * fixed incoorect addressing of request_list->who in dqs_c_qconf.c
 * should have been request_list->user
 *
 * enabled comments in "resolve_file"
 *
 * dqs_execd now uses me.default_cell rather than conf.default_cell
 * to allow use of "dqs_execd -cell cell_name" and $DQS_CELL
 *
 * Revision 1.5  1994/02/25  00:08:47  green
 * added some debugging to dqs_resolve.c
 * this routine needs beefing up - BAD
 *
 * forgot to "nullify" a pointer in dqs_get_ack() causing SEGVs
 * in dqs_free_list();
 *
 * Revision 1.4  1994/02/24  00:03:56  green
 * changed the variable "st_mtime" to "st_m_time" as IRIX 5.1.1
 * couldn't digest "st_mtime"
 *
 * tried to figure out what IRIX 5.1.1 thinks it is in defined.c
 * couldn't - but apparently IRIX doesn't consider itself SV anymore...
 *
 * Revision 1.3  1994/02/23  20:38:38  green
 * yanked some bug-hunt code
 *
 * Revision 1.2  1994/02/23  19:27:19  green
 * fixed memory leak numbers 503 and 504
 *
 * added additional logging into dqs_resolve.c to track
 * memory leaks 505-510
 *
 * Revision 1.1.1.1  1994/02/01  17:57:46  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/
void dqs_read_resolve_file()
{

     int              i;
     int              line=0;
     char             *s0;
     static time_t    st_m_time=0;
     FILE             *fp;
     string           str;
     dqs_list_type    *head=NULL;
     dqs_list_type    el;
     dqs_list_type    chained_el;
     struct stat      statbuf;

     DENTER_EXT((DQS_EVENT,"dqs_read_resolve_file"));

     if (stat(RESOLVE_FILE,&statbuf))
     {
	  ERROR((DQS_EVENT,"DQS_ERROR_0412 error: stating %s\n",RESOLVE_FILE));
	  DEXITE;
	  return;
     }
     
     if (statbuf.st_mtime==st_m_time)
     {
	  DEXIT;
	  return;
     }
     
     st_m_time=statbuf.st_mtime;

     fp=fopen(RESOLVE_FILE,"r");
     if (fp==NULL)
     {
	  ERROR((DQS_EVENT,"DQS_ERROR_0413 error: opening %s\n",RESOLVE_FILE));
     }

     while (1)
     {
	  line++;
	  i=fscanf(fp,"%[^\n]",str);
	  if ((i<1)||(i==EOF))
	       break;
	  
	  if (strncmp(str,"#",1))
	  {
	       bzero((char *)&el,sizeof(el));
	       bzero((char *)&chained_el,sizeof(chained_el));
	       
	       s0=dqs_strtok(str," ");
	       if (!s0)
	       {
		    ERROR((DQS_EVENT,"DQS_ERROR_0414 error: invalid entry at line %d in %s\n",
			   line,RESOLVE_FILE));
		    break;
	       }
	       el.str0=dqs_string_insert(NULL,s0);
	       
	       s0=dqs_strtok(NULL," ");
	       if (!s0)
	       {
		    ERROR((DQS_EVENT,"DQS_ERROR_0415 error: invalid entry at line %d in %s\n",
			   line,RESOLVE_FILE));
		    break;
	       }
	       chained_el.str0=dqs_string_insert(NULL,s0);
	       
	       s0=dqs_strtok(NULL," ");
	       if (!s0)
	       {
		    ERROR((DQS_EVENT,"DQS_ERROR_0416 error: invalid entry at line %d in %s\n",
			   line,RESOLVE_FILE));
		    break;
	       }
	       
               if (!dqs_strcasecmp("none",s0))
               chained_el.str1=dqs_string_insert(NULL,chained_el.str0);
               else
               chained_el.str1=dqs_string_insert(NULL,s0);

	       s0=dqs_strtok(NULL," ");
	       if (!s0)
	       {
		    ERROR((DQS_EVENT,"DQS_ERROR_0417 error: invalid entry at line %d in %s\n",
			   line,RESOLVE_FILE));
		    break;
	       }

               if (!dqs_strcasecmp("none",s0))
               chained_el.str2=dqs_string_insert(NULL,chained_el.str0);
               else
               chained_el.str2=dqs_string_insert(NULL,s0);

	       s0=dqs_strtok(NULL," ");
	       if (!s0)
	       {
		    ERROR((DQS_EVENT,"DQS_ERROR_0418 error: invalid entry at line %d in %s\n",
			   line,RESOLVE_FILE));
		    break;
	       }
               if (!dqs_strcasecmp("none",s0))
               chained_el.str3=dqs_string_insert(NULL,chained_el.str0);
               else
               chained_el.str3=dqs_string_insert(NULL,s0);
	       
	       el.chain=dqs_insert(DQS_STR0,TAIL,el.chain,&chained_el);
	       head=dqs_insert(DQS_STR0,TAIL,head,&el);
	  }

	  i=fscanf(fp,"\n",str);
          if ((i<0)||(i==EOF))
               break;

     }

     fclose(fp);

     Resolver_head=dqs_free_list(Resolver_head);
     Resolver_head=head;
     dqs_showlist(Resolver_head,DQS_DEBUG|DQS_STR0|DQS_STR1|DQS_STR2|DQS_CHAIN,8);
     DEXIT;

}


/************************************************************************/
dqs_list_type *dqs_resolve_cell(cell)
char *cell;

{

     dqs_list_type *lp;

     DENTER_EXT((DQS_EVENT,"dqs_resolve_cell"));

     lp=Resolver_head;
     while (lp)
     {
	  if (!strcmp(cell,lp->str0))
	  {
	       DEXIT;
	       return(lp->chain);
	  }
	  lp=lp->next;
     }

     DEXITE;
     return((dqs_list_type *) NULL);

}

/************************************************************************/
char *dqs_get_cell_wd(default_cell)
char *default_cell;

{

     dqs_list_type *lp;
     char *cp=NULL;

     DENTER_EXT((DQS_EVENT,"dqs_get_cell_wd"));

     lp=dqs_resolve_cell(default_cell);

     if (!lp)
     {
          DEXITE;
          return(NULL);
     }

     cp=dqs_strtok(lp->str0, ".");
     lp=dqs_free_list(lp);
     DEXITE;
     return(cp);
}

