static char dqs_c_qstat_rcsid[]="$Id: dqs_c_qstat.c,v 1.1.1.1 1997/04/10 15:10:32 green Exp $";

/*----------------------------------------------------
 * dqs_c_qstat.c Tom Green Mon Jan 31 10:42:39 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_c_qstat.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:32  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.3  1996/11/20 23:03:26  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.2  1996/03/22  04:20:10  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.1  1995/02/23  23:13:46  nrl
 * Cleaned up some dangling pointers which were causing memory
 * corruption.
 *
 * Revision 3.0  1994/03/07  04:13:29  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:38  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/
void dqs_c_qstat(sfd,request_head)
int           sfd;
dqs_list_type **request_head;

/*
  dqs_c_qstat - is utilized solely by the qmaster and provides service
  to the qstat ancillary.
*/

{
     
     string             str;
     dqs_list_type      *req_list;

     DENTER((DQS_EVENT,"dqs_c_qstat"));
     
     DPRINTF((DQS_EVENT,"------------------------------------------------------"));

     switch((*request_head)->type) 
     {
	  /*------------------------------------------------------*/
	case QSTAT:

	  DPRINTF((DQS_EVENT,"===>QSTAT:"));
	  (*request_head)->status=DQS_ACK;
	  (*request_head)->chain=Queue_head;
	  (*request_head)->tid=Complex_head;
	  (*request_head)->next=Job_head;
	  dqs_send_list(NULL,NULL,sfd,*request_head);
	  (*request_head)->chain=NULL;
          (*request_head)->tid=NULL;
	  (*request_head)->next=NULL;
	  dqs_close_sfd(sfd);
	  *request_head=dqs_free_list(*request_head);

	  DEXIT;
	  return;
	  
	  /*------------------------------------------------------*/
	default:
	  INFO((DQS_EVENT,"DQS_ERROR_0199 CASE unknown list type %d",(*request_head)->type));
	  (*request_head)->status=DQS_NAK;
	  sprintf(str,"error: unknown list type %d",(*request_head)->type);
	  DPRINTF((DQS_EVENT,"%s",str));
	  (*request_head)->str0=dqs_string_insert(NULL,str);
	  dqs_send_list(NULL,NULL,sfd,*request_head);
	  dqs_close_sfd(sfd);
	  *request_head=dqs_free_list(*request_head);
	  DEXIT;
	  return;
     }
     
}
