/* tailor.h -- LZO packer

   This file is part of the LZO real-time data compression package.

   Copyright (C) 1997 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996 Markus Franz Xaver Johannes Oberhumer

   The LZO library and packer is free software; you can redistribute it
   and/or modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer
   markus.oberhumer@jk.uni-linz.ac.at
 */



/*************************************************************************
//
**************************************************************************/

#if defined(__LZO_DOS) && !defined(__LZO_DOS16) && !defined(__LZO_DOS32)
#  define __LZO_DOS32
#endif
#if defined(__LZO_WIN) && !defined(__LZO_WIN16) && !defined(__LZO_WIN32)
#  define __LZO_WIN32
#endif
#if !defined(__LZO_DOS) && !defined(__LZO_WIN) && !defined(__LZO_OS2)
#  if defined(__OS2__) || defined(__OS2V2__) || defined(OS2)
#    define __LZO_OS2
#  elif defined(__TOS__) || defined(__atarist__)
#    define __LZO_TOS
#  endif
#endif
#if !defined(DOSISH)
#  if defined(__LZO_DOS) || defined(__LZO_WIN)
#    define DOSISH
#  elif defined(__LZO_OS2) || defined(__EMX__)
#    define DOSISH
#  elif defined(__LZO_TOS)
#    define DOSISH
#  endif
#endif

#if defined(DOSISH)
#  define OPT_NAME_DEFAULT
#  define HAVE_SIGNAL_H 1
#  define HAVE_CTIME 1
#  define HAVE_FILENO 1
#  define HAVE_GMTIME 1
#  define HAVE_LOCALTIME 1
#  define HAVE_MEMCMP 1
#  define HAVE_MEMCPY 1
#  define HAVE_MEMMOVE 1
#  define HAVE_MEMSET 1
#  define HAVE_SETMODE 1
#  define HAVE_STRCHR 1
#  define HAVE_STRDUP 1
#  define HAVE_STRFTIME 1
#  if defined(__CYGWIN32__)
#    define HAVE_STRCASECMP 1
#    define HAVE_STRNCASECMP 1
#  else
#    define HAVE_STRICMP 1
#    define HAVE_STRNICMP 1
#  endif
#  if !defined(DIR_SEP)
#    define DIR_SEP			"/\\"
#  endif
#  if !defined(fn_tolower)
#    define fn_tolower(x)	tolower(((unsigned char)(x)))
#  endif
#  undef __UNIX__
#  undef UNIX
#  undef __unix__
#  undef unix
#endif

#if defined(__DJGPP__) || defined(__EMX__) || defined(__CYGWIN32__)
#  define TIME_WITH_SYS_TIME 1
#  define HAVE_IO_H 1
#  define HAVE_UNISTD_H 1
#  define HAVE_UTIME_H 1
#  define HAVE_CHMOD 1
#  define HAVE_UTIME 1
#elif defined(__GNUC__) && defined(__LZO_TOS)
#  define TIME_WITH_SYS_TIME 1
#  define HAVE_UNISTD_H 1
#  define HAVE_UTIME_H 1
#  define HAVE_CHMOD 1
#  define HAVE_UTIME 1
#elif defined(_MSC_VER)
#  define SIGTYPEENTRY		__cdecl
#  define HAVE_IO_H 1
#  define HAVE_CHMOD 1
#  if (_MSC_VER >= 1000)
#    define HAVE_SYS_UTIME_H 1
#    define HAVE_UTIME 1
#  endif
#elif defined(__WATCOMC__)
#  define HAVE_IO_H 1
#  define HAVE_SYS_UTIME_H 1
#  define HAVE_CHMOD 1
#  define HAVE_UTIME 1
#endif


/*************************************************************************
//
**************************************************************************/

#if defined(__EMX__)
#  define F_OS			(_osmode == DOS ? F_OS_FAT : F_OS_OS2)
#  define F_CS			(_osmode == DOS ? F_CS_DOS : F_CS_NATIVE)
#elif defined(__LZO_DOS)
#  define F_OS			F_OS_FAT
#  define F_CS			F_CS_DOS
#elif defined(__LZO_OS2)
#  define F_OS			F_OS_OS2
#elif defined(__LZO_TOS)
#  define F_OS			F_OS_ATARI
#elif defined(__LZO_WIN16)
#  define F_OS			F_OS_FAT
#  define F_CS			F_CS_WIN16
#elif defined(__LZO_WIN32)
#  define F_OS			F_OS_FAT
#  define F_CS			F_CS_WIN32
#endif


#ifndef F_OS
#  define F_OS			F_OS_UNIX
#endif
#ifndef F_CS
#  define F_CS			F_CS_NATIVE
#endif

#ifndef DIR_SEP
#  define DIR_SEP		"/"
#endif

#ifndef OPTIONS_VAR
#  define OPTIONS_VAR	"LZOP"
#endif

#ifndef fn_tolower
#  define fn_tolower(x)	(x)
#endif


/*
vi:ts=4
*/

