/* title.h -- fprintf that underlines
   Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
   Copyright (c) 1995, 96, 97, 98 Akim Demaille, Miguel Santana

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* 
 * Note:
 * very strong inspiration was taken in error.[ch] by
 * David MacKenzie <djm@gnu.ai.mit.edu>
 */

/* Get prototypes for the functions defined here.  */
#include "title.h"
#include "printlen.h"

/* Print the message FORMAT, which is a printf-style
   format string*/

void
#if defined(VA_START) && __STDC__
title (FILE * stream, char c, const char *format, ...)
#else
title (stream, c, format, va_alist)
     FILE * stream;
     char c;
     char *format;
     va_dcl
#endif
{
  int len;
#ifdef VA_START
  va_list args;
#endif
  
#ifdef VA_START
  VA_START (args, format);
  
  len = vprintflen (format, args);
# if HAVE_VPRINTF || _LIBC
  vfprintf (stream, format, args);
# else
  _doprnt (format, args, stream);
# endif
  va_end (args);
#else
  fprintf (stream, format, a1, a2, a3, a4, a5, a6, a7, a8);
#endif
  putc ('\n', stream);

  /* Draw the line */
  for (/* nothing */ ; len ; len --)
    putc (c, stream);
  putc ('\n', stream);
  
  fflush (stream);
}
