/*
 * CDTOOL is a program to play and catalog audio compact discs on
 * a cdrom drive
 *
 * Copyright 1994 Thomas Insel.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 *
 * For information on CDTOOL, alternate licensing, or whatever, 
 * contact Thomas Insel via email (tinsel@uiuc.edu) or write to
 * Thomas Insel, 210 Parkview Drive, Bloomington, IL 61701-2038.
 * 
 * Multiple cdrom drive support
 * cdinfo command
 * skip track option
 * some minor enhanchments
 * and some bugs fixed
 * by
 * Sven Oliver Moll
 * 
 * Copyright 1995,96 Sven Oliver Moll
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

#include "config.h"
#include "commands.h"
#include "info.h"
#include "main.h"

static char *rcsid = "$Id: main.c,v 1.5 1998/01/06 21:00:33 wadeh Exp wadeh $";

main(int argc, char *argv[]) 
{
  int		info=I_AUDIOSTATUS, error=0, opt, i, cdfile, trk0=0, trk1=0;
  char		*progname, *cd_device;
  extern int	optind, getopt();
  extern char	*optarg;

  int usedb = 1;
  char p_format = P_LONG;

  if ( (progname=rindex(argv[0],'/')) != 0)
    progname++;
  else
    progname = argv[0];

  if ( (cd_device=getenv("CDTOOLDEV")) == NULL) 
    cd_device = strdup(CD_DEVICE);

  while((opt = getopt(argc,argv,"01234567?ad:hi:nrstvV")) != EOF)
    {
      switch(opt)
	{    
	 case '0':
	 case '1':
	 case '2':
	 case '3':
	 case '4':
	 case '5':
	 case '6':
	 case '7':
	  cd_device=strdup(CD_DEVICE_BASE "?");
	  *(cd_device+sizeof(CD_DEVICE_BASE)-1)=opt;
	  break;
	 case 'a':
	  error = 1;
	  if ( strcmp(progname, "cdinfo") == 0 )
	    {
	      error = 0;
	      info = I_DISP_ABS;
	    }
	  break;
	 case 'd':
	  cd_device=optarg;
	  break;
	 case 'n':
	  error = 1;
	  if ( strcmp(progname, "cdir") == 0 )
	    {
	      error = 0;
	      usedb = 0;
	    }
	  break;
	 case 'r':
	  error = 1;
	  if ( strcmp(progname, "cdir") == 0 )
	    {
	      error = 0;
	      p_format = P_RAW; 
	    }
	  if ( strcmp(progname, "cdinfo") == 0 )
	    {
	      error = 0;
	      info = I_DISP_REL;
	    }
	  break;
	 case 's':
	  error = 1;
	  if ( strcmp(progname, "cdir") == 0 )
	    {
	      error = 0;
	      p_format = P_QUICK;
	    }
	  if ( strcmp(progname, "cdinfo") == 0 )
	    {
	      error = 0;
	      info = I_AUDIOSTATUS;
	    }
	  break;
	 case 't':
	  error = 1;
	  if ( strcmp(progname, "cdir") == 0 )
	    {
	      error = 0;
	      p_format = P_TEMPL;
	    }
	  if ( strcmp(progname, "cdinfo") == 0 )
	    {
	      error = 0;
	      info = I_TRACK;
	    }
	  break;

	  /* verbose info printout */
	 case 'v':
	  error = 1;
	  if ( strcmp(progname, "cdir") == 0 )
	    {
	      error = 0;
	      usedb = 0;
	    }
	  if ( strcmp(progname, "cdinfo") == 0 )
	    {
	      error = 0;
	      info = I_DISP_ALL;
	    }
	  break;

	 /* print verison number and then standard HELP */
	 case 'V':
	     printf ("%s\n  ID=%s\n", progname, rcsid);
	     printf ("  Build:  %s %s\n",__DATE__,__TIME__);

	  /* general options */
	 case '?':
	 case 'h':
	 default:
	  error = 1;
	  break;
	}
    }

  if (error)
    {
      do_usage(progname);
      exit(0);
    }

  if ( (cdfile=open(cd_device, O_RDONLY)) == -1 ) 
    {
      fprintf(stderr, "%s: can't open cdrom (%s)\n", progname, cd_device);
      exit(1);
    }

#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", device=%s\n",
	 progname, cd_device);
#endif

  if ( strcmp(progname, "cdplay") == 0 )
    {
	if ( optind < argc ) {
	    trk0=atoi(argv[optind++]);
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", trk0=%d\n",
	 progname, trk0);
#endif
	}
	if ( optind < argc ) {
	    trk1=atoi(argv[optind]);
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", trk1=%d\n",
	 progname, trk0);
#endif
	}
	optind--;
	if (strcmp(argv[optind],"-") == 0 ) {
	    trk0=SKIPBACK;
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", trk0=SKIPBACK(%d)\n",
	 progname, trk0);
#endif
	}
	if (strcmp(argv[optind],"+") == 0 ) {
	    trk0=SKIPFORWARD;
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", trk0=SKIPFORWARD(%d)\n",
	 progname, trk0);
#endif
	}
	if ((strcmp(argv[optind],"start") == 0) ||
	     (strcmp(argv[optind],"x") == 0 ) ||
	     (strcmp(argv[optind],"0") == 0 )) {
	    trk0=SKIPSTART;
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", trk0=SKIPSTART(%d)\n",
	 progname, trk0);
#endif
        }

	if (strcmp(argv[optind],"stop") == 0) {
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", stop\n",
	 progname);
#endif
            do_stop(progname, cdfile);
	    close(cdfile);
	    exit(0);
        }
	if (strcmp(argv[optind],"pause") == 0) {
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", pause\n",
	 progname);
#endif
            do_pause(progname, cdfile);
	    close(cdfile);
	    exit(0);
        }
	if (strcmp(argv[optind],"eject") == 0) {
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", eject\n",
	 progname);
#endif
            do_eject(progname, cdfile);
	    close(cdfile);
	    exit(0);
        }
	if (strcmp(argv[optind],"info") == 0) {
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", info\n",
	 progname);
#endif
            do_info(progname, cdfile, I_DISP_ALL, DONADA);
	    fputc ('\n', stdout);
	    close(cdfile);
	    exit(0);
        }

	if (strcmp(argv[optind],"dir") == 0) {
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", dir\n",
	 progname);
#endif
            do_dir(progname, cdfile,P_RAW,0, DOLF);
	    close(cdfile);
	    exit(0);
        }
	if (strcmp(argv[optind],"resume") == 0) {
#ifdef DEBUG
fprintf (stderr,"main:  called as \"%s\", resume\n",
	 progname);
#endif
        }

      do_play(progname, cdfile, trk0, trk1);
    }

  else if ( strcmp(progname, "cdstop") == 0 )
    do_stop(progname, cdfile);
  else if ( strcmp(progname, "cdeject") == 0 )
    do_eject(progname, cdfile);
  else if ( strcmp(progname, "cdreset") == 0 )
    do_reset(progname, cdfile);
  else if ( strcmp(progname, "cdpause") == 0 )
    do_pause(progname, cdfile);
  else if ( strcmp(progname, "cdinfo") == 0 ) {
    do_info(progname, cdfile, info, DONADA);
    fputc ('\n', stdout);
  }
  else if ( strcmp(progname, "cdir") == 0 )
    do_dir(progname, cdfile,p_format,usedb, DOLF);
  else do_usage(progname);

  close(cdfile);
}

do_usage(char *progname)
{
  fprintf(stderr,VERSION_STRING); fprintf(stderr,"\n");
  
  if ( strcmp(progname, "cdplay") == 0 ) {
    fprintf(stderr, "usage: cdplay [start [stop]]\n");
    fprintf(stderr, " +             next track\n");
    fprintf(stderr, " -             previous track\n");
    fprintf(stderr, " x             resetart at track 1\n");
    fprintf(stderr, " S             play track S\n");
    fprintf(stderr, " S E           play track S..E\n");
    fprintf(stderr, " start         play from track 1\n");
    fprintf(stderr, " stop          stop playing\n");
    fprintf(stderr, " resume        resume playing\n");
    fprintf(stderr, " eject         eject CD-ROM\n");
    fprintf(stderr, " info          display info\n");
    fprintf(stderr, " dir           display directory\n");
  }
  else if ( strcmp(progname, "cdstop") == 0 )
    fprintf(stderr, "usage: cdstop\n");
  else if ( strcmp(progname, "cdeject") == 0 )
    fprintf(stderr, "usage: cdeject\n");
  else if ( strcmp(progname, "cdpause") == 0 )
    {
      fprintf(stderr, "usage: cdpause\n");
      fprintf(stderr, "  resume play with cdplay\n");
    } 
  else if ( strcmp(progname, "cdir") == 0 ) 
    {
      fprintf(stderr, "usage: cdir [ [-n] {-s|-t} ]\n");
      fprintf(stderr, " -n            listing without titles\n");
      fprintf(stderr, " -r            raw read of toc\n");
      fprintf(stderr, " -s            short listing (title/artist/track)\n");
      fprintf(stderr, " -t            print template for database entry\n");
    } 
  else if ( strcmp(progname, "cdinfo") == 0 ) 
    {
      fprintf(stderr, "usage: cdinfo [ {-a|-r|-s|-t} ]\n");
      fprintf(stderr, " -a            print absolute disc time\n");
      fprintf(stderr, " -r            print relative track time\n");
      fprintf(stderr, " -s            print audiostatus\n");
      fprintf(stderr, " -t            print current track\n");
      fprintf(stderr, " -v            print status, track, absolute, relative\n");
    }
  else 
    fprintf(stderr, "call as cdplay, cdstop, cdeject, cdpause, cdir or cdinfo\n");
  
  fprintf(stderr, " -V            build, version, and this help\n");
  fprintf(stderr, " -? -h         print this message\n");
  fprintf(stderr, " -[0-7]        use device "CD_DEVICE_BASE"[0-7]\n");
  fprintf(stderr, " -d dev        use device dev\n");
}
