/* "commands.c" copyright 1994 thomas insel
 *              copyright 1995 sven oliver moll */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>

#ifdef sun
#  include <sundev/srreg.h>
#elif defined linux
#  include <linux/cdrom.h>
#else
#  error Please fix includes for your system in commands.c
#endif

#include "config.h"
#include "commands.h"
#include "hardware.h"
#include "main.h"

/* if trk0 is -1, skip back
 * if trk0 is -2, skip forward
 */
void do_play(char *progname, int cdfile, int trk0, int trk1)
{
  struct cdrom_tochdr tochdr;
  struct cdrom_ti ti;
  struct cdrom_subchnl subchnl;

#ifdef DEBUG
fprintf (stderr,"do_play:  called, name=%s, cdfile=%d, trk0=%d, trk1=%d\n",
	 progname, cdfile, trk0, trk1);
#endif

  subchnl.cdsc_format = CDROM_MSF;
  if ( (( trk0 == 0 ) && ( trk1 == 0 )) || ( trk0 < 0 ) )
    {
#ifdef DEBUG
	fprintf (stderr, "do_play:  trk0=%d\n", trk0);
#endif

      if ( ioctl(cdfile, CDROMSUBCHNL, &subchnl) == -1 )
	{
	  fprintf(stderr, "%s: ioctl cdromsubchnl\n", progname);
	  EXIT(1);
        }
    }

  /* if starting play.... */
  if ( ( trk0 == 0 ) && ( trk1 == 0 ) )
    {
#ifdef DEBUG
	fprintf (stderr, "do_play:  trk[0.1]==0, status=%s\n",
		 (subchnl.cdsc_audiostatus == CDROM_AUDIO_PAUSED)?
		 "PAUSED":"PLAY");
#endif

	/* subchannel status returns PLAY, PAUSED, COMPLETED, or none */
	switch ( subchnl.cdsc_audiostatus ) {
	case CDROM_AUDIO_PAUSED:
	    if ( ioctl(cdfile, CDROMRESUME) == -1 ) {
		fprintf(stderr, "%s: ioctl cdromresume\n", progname);
		EXIT(1);
	    }
	    return;
	case CDROM_AUDIO_PLAY:
	    trk0=subchnl.cdsc_trk;
	    break;
	case CDROM_AUDIO_COMPLETED:  /* WWH added */
	    trk0=1;
	    break;
#ifdef USE_THIS
	default:
	    fprintf(stderr, "%s: error subchnl=%d\n", 
		    progname, subchnl.cdsc_audiostatus);
	    EXIT(1);
#endif	    
	}
    }
  

  if ( ioctl(cdfile, CDROMREADTOCHDR, &tochdr) == -1 ) 
    {
      fprintf(stderr, "%s: ioctl cdromreadtochdr\n", progname);
      EXIT(1);
    }

  /* handle previous and next track */
  if ( trk0 < 0 )
    {
      if ( trk1 == 0 )
      	trk1=1;
      switch (trk0)
	{
	 case SKIPBACK:
	  trk1=subchnl.cdsc_trk-trk1;
	  break;
	 case SKIPFORWARD:
	  trk1=subchnl.cdsc_trk+trk1;
	}
      if ((trk1 < tochdr.cdth_trk0) || (trk1 > tochdr.cdth_trk1))
      	trk1=1;
      ti.cdti_trk0 = trk1;
      ti.cdti_trk1 = tochdr.cdth_trk1;
    }
  else
    {
      if ( trk0 ) 
      	ti.cdti_trk0 = trk0;
      else
      	ti.cdti_trk0 = tochdr.cdth_trk0;
      
      if ( trk1 )
      	ti.cdti_trk1 = trk1;
      else
      	ti.cdti_trk1 = tochdr.cdth_trk1;
    }
  
  ti.cdti_ind0 = 1;
  ti.cdti_ind1 = 99;
  
  /* check range */
#ifdef DEBUG
  fprintf (stderr, "do_play:  ti.cdti_trk0=%d, ti.cdti_trk1=%d\n",
      	ti.cdti_trk0, ti.cdti_trk1);
#endif

#ifndef SCSI
  if ( ioctl(cdfile, CDROMPLAYTRKIND, &ti) == -1 ) 
    {
      fprintf(stderr, "%s: ioctl cdromplaytrkind\n", progname);
      EXIT(1);
    }
#else
  /* SCSI - convert track index into MSF format */
  {
      cdhw_t *hw;
      struct cdrom_msf msf;
      int i;
      
      hw = read_hw(progname, cdfile);
      if (hw == NULL)
	  EXIT(1);
      
      if ( ioctl(cdfile, CDROMSTART) == -1 ) {
	  fprintf(stderr, "%s: ioctl cdromstart\n", progname);
	  free_hw_buf(hw);
	  EXIT(1);
      }

      /* convert track offset to MSF format */
      i=ti.cdti_trk0;
      if (i >hw->tochdr.cdth_trk1) {
	  fprintf(stderr, "%s: invalid track %d\n", progname, i);
	  free_hw_buf(hw);
	  EXIT(1);
      }
	  
      msf.cdmsf_min0=hw->tocentries[i-1].cdte_addr.msf.minute;
      msf.cdmsf_sec0=hw->tocentries[i-1].cdte_addr.msf.second;
      msf.cdmsf_frame0=hw->tocentries[i-1].cdte_addr.msf.frame;

      i=ti.cdti_trk1;
      if (i == 0)
	  i = hw->tochdr.cdth_trk1+1;
      else
	  i++;
      msf.cdmsf_min1=hw->tocentries[i-1].cdte_addr.msf.minute;
	  msf.cdmsf_sec1=hw->tocentries[i-1].cdte_addr.msf.second;
      msf.cdmsf_frame1=hw->tocentries[i-1].cdte_addr.msf.frame;
      
      free_hw_buf(hw);
      if ( ioctl(cdfile, CDROMPLAYMSF, &msf) == -1 ) {
	  fprintf(stderr, "%s: ioctl cdrommsf\n", progname);
	  EXIT(1);
      }
  }
#endif
}

void do_pause(char *progname, int cdfile) 
{
#ifdef DEBUG
fprintf (stderr,"do_pause:  called, name=%s, cdfile=%d,\n",
	 progname, cdfile);
#endif
  if ( ioctl(cdfile, CDROMPAUSE) == -1 ) 
    {
      fprintf(stderr, "%s: ioctl cdrompause\n", progname);
      EXIT(1);
    }
}

void do_stop(char *progname, int cdfile) 
{
#ifdef DEBUG
fprintf (stderr,"do_stop:  called, name=%s, cdfile=%d,\n",
	 progname, cdfile);
#endif
  if ( ioctl(cdfile, CDROMSTOP) == -1 ) 
    {
      fprintf(stderr, "%s: ioctl cdromstop\n", progname);
      EXIT(1);
    }
}

void do_eject(char *progname, int cdfile)
{
#ifdef DEBUG
fprintf (stderr,"do_eject:  called, name=%s, cdfile=%d,\n",
	 progname, cdfile);
#endif
  if ( ioctl(cdfile, CDROMEJECT) == -1 ) 
    {
      fprintf(stderr, "%s: ioctl cdromeject\n", progname);
      EXIT(1);
    }
}

void do_reset(char *progname, int cdfile)
{
#ifdef DEBUG
fprintf (stderr,"do_reset:  called, name=%s, cdfile=%d,\n",
	 progname, cdfile);
#endif
  if ( ioctl(cdfile, CDROMRESET) == -1 ) 
    {
      fprintf(stderr, "%s: ioctl cdromreset\n", progname);
      EXIT(1);
    }
  if ( ioctl(cdfile, CDROMSTART) == -1 ) 
    {
      fprintf(stderr, "%s: ioctl cdromstart\n", progname);
      EXIT(1);
    }
}
