/*----------------------------------------------------------------
 * general options for AWElib
 *----------------------------------------------------------------*/

#ifndef SFOPTS_H_DEF
#define SFOPTS_H_DEF

#include "util.h"

/* options */
typedef struct _sf_options {
	int auto_add_blank;	/* bool: add 48 blank samples */
	int default_bank;	/* int: bank map number for bank #0 */
	int default_chorus;	/* int: chorus effects in percent */
	int default_reverb;	/* int: reverb effects in percent */
	int default_volume;	/* int: total volume in percent */
	double atten_sense;	/* attenuation sensitivity (default is 10.0) */
	int default_atten;	/* zero attenuation level (default is 32) */
	double decay_sense;	/* decay sensitivity (default is 50.0) */
	char *search_path;	/* search path for soundfont files */
} sf_options;

void awe_init_option(void);
int awe_calc_def_atten(double sense);	/* calculate zero atten level */

extern sf_options awe_option;

void awe_read_option_file(char *fname);
int awe_parse_options(int argc, char **argv, char *optflags,
		      awe_option_args *long_opts, int *optidx);

#endif
