/*	-*- C -*-
 * ifcico v3.0.cm - dbz nodelist support
 * Copyright (C) 1997  Christof Meerwald.
 *
 * $RCSfile: nldbz.c,v $ - $Author: mirus $
 * $Revision: 1.3 $ - $Date: 1997/06/01 13:24:55 $
 */
#ifdef USE_DBZ

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "lutil.h"
#include "xutil.h"
#include "nldbz.h"
#include "dbz.h"


/* allocate some other zonelist entries */
int allocentryvector(struct _zonelist *zonelist)
{
  zonelist->entries++;

  if (zonelist->entries > zonelist->size)
  {
    zonelist->size += ZONELIST_INCR_SIZE;
    zonelist->entryvector = realloc(zonelist->entryvector,
				    zonelist->size * sizeof(struct _zoneentry));

  }

  return (zonelist->entryvector == NULL);
}


/* append zonelist entry */
int appendentryvector(struct _zonelist *zonelist, int beg, int end, int zone)
{
  int i;

  i = zonelist->entries;
  allocentryvector(zonelist);

  zonelist->entryvector[i].beg = beg;
  zonelist->entryvector[i].end = end;
  zonelist->entryvector[i].zone = zone;

  return 0;
}


/* get the zone number of the nodelist entry pointed to by the given
 * offset */
unsigned short getzone(struct _zonelist *zonelist, off_t offset)
{
  int first, last;
  int middle;


  /* check if there are entries in the zone-listing */
  if (zonelist->entries <= 0)
  {
    return 0;
  }

  first = 0;
  last = zonelist->entries - 1;

  /* search for the zone-list entry using binary search */
  while (last - first > 0)
  {
    middle = (first + last + 1)/2;

    if (offset >= zonelist->entryvector[middle].beg)
    {
      first = middle;
    }
    else
    {
      last = middle - 1;
    }
  }

  /* check if the found entry applies to the given offset */
  if ((offset >= zonelist->entryvector[first].beg) &&
      (offset < zonelist->entryvector[first].end))
  {
    return zonelist->entryvector[first].zone;
  }
  else
  {
    debug(DBG_NODELIST, "warning: zone-list entry not found - %d - %d (%d)",
	  zonelist->entryvector[first].beg, zonelist->entryvector[first].end,
	  offset);

    return 0;			/* bad luck - wrong entry */
  }
}


/* append the zone-listing to the end of the database */
int putzonelist(struct _zonelist *zonelist, int num)
{
  int i;
  FILE *dirf;


  dirf = dbzgetdirf();		/* get the dbz .dir-file */
  fseek(dirf, 0L, SEEK_END);	/* and seek to EOF */

  for (i = 0; i < zonelist->entries; i++)
  {
    debug(DBG_NODELIST, "Offsets %d - %d: Zone %d",
	  zonelist->entryvector[i].beg,
	  zonelist->entryvector[i].end,
	  zonelist->entryvector[i].zone);

    fprintf(dirf, "%d %d %d %d\n", num,
	    zonelist->entryvector[i].beg,
	    zonelist->entryvector[i].end,
	    zonelist->entryvector[i].zone);
  }

  return 0;
}


/* read the zone-listing from the database */
int getzonelist(struct _nodelist *nodevector)
{
  FILE *dirf;
  int num, beg, end, zone;


  dirf = dbzgetdirf();
  /* TODO: perhaps we should search for the beginning of the zone-listing */

  while (fscanf(dirf, "%d %d %d %d\n", &num, &beg, &end, &zone) == 4)
  {
    debug(DBG_NODELIST, "NL %d Offsets %d - %d: Zone %d",
	  num, beg, end, zone);

    appendentryvector(&nodevector[num].zonelist, beg, end, zone);
  }

  return 0;
}
#endif
