/*	$Id: TriggerRef.h,v 1.2 1996/06/24 03:00:45 sam Rel $ */
/*
 * Copyright (c) 1995-1996 Sam Leffler
 * Copyright (c) 1995-1996 Silicon Graphics, Inc.
 * HylaFAX is a trademark of Silicon Graphics
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#ifndef _TriggerRef_
#define	_TriggerRef_
/*
 * HylaFAX Trigger Support.
 */
#include "QLink.h"

class Trigger;

/*
 * A reference to a Trigger.  Instances of this
 * class are held on lists in objects like Job
 * and Modem so that when events are posted that
 * pertain to a specific thing we can quickly
 * determine which triggers should be notified.
 */
class TriggerRef : public QLink {
private:
    Trigger&	ref;

    friend class Trigger;

    static void purge(QLink&, Trigger*);
public:
    TriggerRef(Trigger&);
    ~TriggerRef();

    static void purge(QLink&);		// purge all references in a list
};
#endif /* _TriggerRef_ */
