#!	/bin/sh
# Boot Disk maker. Bruce Perens, July-September 1995
# Eric Delaunay, 1998 [silo boot]
# This is free software under the GNU General Public License.

# Abort on any non-zero return.
set -e

# Verbose shell execution.
#set -x
#set -v

#-----------------------------------------------
# write SILO boot infos
#
write_silo () {
	cat > $mnt/etc/silo.conf << EOF
partition=1
root=/dev/fd0
timeout=100
image=/linux
label=linux
append="load_ramdisk=1 prompt_ramdisk=1"
read-write
EOF
	sed -e s/__version__/$KERNEL_VERSION/ -e s/__arch__/$ARCHITECTURE/ \
		<scripts/rescue/install.sh >$mnt/install.sh
	chmod 755 $mnt/install.sh
}

#-----------------------------------------------
# write SysLinux boot infos
#
write_syslinux () {
	cat scripts/rescue/syslinux.cfg |\
		m4 -D__size${blocks}__ -D__tecra__=${revext} | \
		$nlfmt >$mnt/syslinux.cfg
	sed -e s/__arch__/$ARCHITECTURE/ \
		<scripts/rescue/rdev.sh >$mnt/rdev.sh
	chmod 777 $mnt/rdev.sh
	sed -e s/__version__/$KERNEL_VERSION/ -e s/__arch__/$ARCHITECTURE/ \
		<scripts/rescue/install.sh >$mnt/install.sh
	chmod 777 $mnt/install.sh
}


# Print a usage message and exit if the argument count is wrong.
if [ $# != 6 ]; then
echo "Usage: "$0" revision-extension kernel-package root-image blocks debian-version system" 1>&2
	cat 1>&2 << EOF

	revision-extension: the revision extension of the kernel.
	kernel-package: the Debian package containing the kernel.
	root-image: a compressed disk image to load in ramdisk and mount as root.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440.
	debian-version: version of the Debian release.
	system: name of the target system.
EOF

	exit -1
fi

revext=$1

# Set this to the location of the package archive.
archive=$2

# Set this to the location of the root filesystem image
rootimage=$3

# Set to the number of blocks per floppy.
blocks=$4

#Set this to the Debian version
debianversion=$5

# Set this to the system
system=$6

# Set this to the block device for the floppy disk.
floppy=/var/tmp/floppy-image.$$

mnt=/var/tmp/mnt.$$

loopdevice=/dev/loop3

# Make sure the kernel package is available.
if [ ! -f $archive ]; then
	echo "Can't find $archive" 1>&2
	exit -1
fi

# Try to unmount anything that should not be mounted. Aborted runs of this
# script may have left things mounted.
(umount /mnt; umount $mnt; umount $floppy; true)2>/dev/null >/dev/null

mkdir -p $mnt

# Zero the entire disk, so that when I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=$floppy bs=1k count=$blocks

# Get the kernel version from its package name.
KERNEL_VERSION=`basename $archive | sed -e 's/kernel-image-//' -e 's/_.*//'`
ARCHITECTURE=`dpkg --print-architecture`
DEBIAN_KERNEL_IMAGE=`basename $archive .deb | sed -e s/_$ARCHITECTURE\$//`

# Do the actual work of making the disk bootable.
if [ $blocks -le 1400 ]; then
    rootimage=/var/tmp/root.$$
    echo -n >$rootimage
fi

# Make the filesystem using the loop device, so that the floppy image file
# won't be truncated if the filesystem is shorter than the image file.
(umount $loopdevice; true)
(/sbin/losetup -d $loopdevice; true)
/sbin/losetup $loopdevice $floppy

if [ "$system" = atari -o "$system" = amiga ]; then
	mkdosfs -r 112 -F 12 $floppy $blocks
	fstype=msdos
	fsopts="-o fat=12"
	nlfmt=unix2dos	# MSDOS newline convention
elif [ "$ARCHITECTURE" = sparc ]; then
	# [ED] sparc uses ext2 formatted floppies & SILO boot loader
	# silo1440k is an floppy image with Sun Disklabel & SILO installed
	gunzip < silo1440k.gz > $loopdevice
	fstype=ext2
	nlfmt='cat -'	# UNIX newline convention
else
	gunzip</usr/lib/syslinux/img$blocks""k.gz > $loopdevice
	fstype=msdos
	nlfmt=unix2dos	# MSDOS newline convention
	fsopts="-o fat=12"
fi

# mount the disk image to install additional files
mount $fsopts -t $fstype $loopdevice $mnt

# For atari copy bootloader and linux on disk
if [ "$system" = atari ]; then
	mkdir $mnt/auto
	cp ../bootstra.ttp $mnt/auto/bootstra.prg
	cp ../bootstra.ttp $mnt/bootstra.ttp
fi

cp linux$revext $mnt/linux

# [ED] sparc does not use rdev
if [ ! "$ARCHITECTURE" = sparc ]; then
    if [ "$system" != atari -a "$system" != amiga ]; then
        /usr/sbin/rdev -R $mnt/linux 1
        /usr/sbin/rdev -r $mnt/linux 0
        /usr/sbin/rdev -v $mnt/linux -1
        /usr/sbin/rdev $mnt/linux /dev/ram0
    fi
fi

# [ED] sparc root image is to big for now (full libc6 included)
#      don't put it on the boot floppy
if [ ! "$ARCHITECTURE" = sparc ]; then
	cp $rootimage $mnt/root.bin
fi

if [ $blocks -le 1400 ]; then
    rm -f $rootimage
fi

# Copy system.map to the floppy.
# FIXME The kernel file is HUGE! There's no space left for the sys_map file.
# if [ "$revext" != lowmem ]; then
# 	cp sys_map${revext}.gz $mnt/sys_map.gz
# fi

# Install the greeting and help messages (f6.txt f7.txt f8.txt contain
#   no information at all, so don't copy them to save some space.
for i in debian.txt readme.txt f1.txt f10.txt f2.txt f3.txt \
		f4.txt f5.txt f9.txt ; do
	cat scripts/rescue/$i | \
		m4 -P -D__kernel_version__=$KERNEL_VERSION \
				-D__kernel_image__=$DEBIAN_KERNEL_IMAGE \
				-D__size${blocks}__ \
				-D__debianversion__=$debianversion \
			| unix2dos > $mnt/$i
done

# [ED] sparc does not use syslinux
if [ "$ARCHITECTURE" = sparc ]; then
	# but SILO
	write_silo
else
	write_syslinux
fi

echo rescue >$mnt/type.txt

umount $mnt
/sbin/losetup -d $loopdevice
rmdir $mnt

(rm -f -r /var/tmp/extract-tmp-$$ resc${blocks}${revext}.bin;true)
mv $floppy resc${blocks}${revext}.bin
ls -l resc${blocks}${revext}.bin
exit 0
