#!/bin/sh
# Copyright (c) 1993, 1994 Rick Sladkey <jrs@world.std.com>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by Paul Kranenburg,
#      Branko Lankester and Rick Sladkey.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#	ioctlent.sh,v 2.18 1994/03/12 23:12:14 jrs Exp

if [ $# -ne 1 ]
then
	echo "usage: $0 include-directory" >&2
	exit 1
fi

COMBLINE=`pwd`/combline

# Step 1: Find all the ioctls that look like 0xNNNN.
bad_includes='/config\.h$|^linux/tpqic02\.h$|fs\.h$|/nfs_mount\.h$|/tty\.h|/xd\.h|/timex\.h|^linux/smp'
#
(
	cd $1 || exit
	find linux/. -name '*.h' -print | sed 's/^linux\/\./linux/' |
		egrep -v "$bad_includes" | 
		xargs $COMBLINE | egrep '^[	 ]*#[	 ]*define[	 ][ 	]*[A-Z_][A-Za-z0-9_]*[ 	][	 ]*0[Xx][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]([ 	]|$)' /dev/null |
		sed 's/\(.*\):#[ 	]*define[ 	]*\([A-Z_][A-Za-z0-9_]*\)[ 	]*\(0[Xx][0-9A-Fa-f]*\)[ 	]*\(.*\)/	{ "\1",	"\2",	\2	},/'
) >ioctlent.tmp

# Step 2: Find all the ioctls that look like _IO[RW]?(...).
bad_includes='xxx-no-badincludes-xxx'
(
	cd $1 || exit
	find linux/. -name '*.h' -print | sed 's/^linux\/\./linux/' |
		egrep -v "$bad_includes" |
		xargs $COMBLINE | egrep '^[	 ]*#[	 ]*define[ 	]+[A-Z_][A-Za-z0-9_]*[	 ]+_IO[RW]?[ 	]*\(' /dev/null |
		sed 's/\(.*\):#[ 	]*define[ 	]*\([A-Z_][A-Za-z0-9_]*\)[ 	]*\(_IO[^)]*)\)[ 	]*\(.*\)/	{ "\1",	"\2",	\2	},	\4/'
) >>ioctlent.tmp

# Generate the output file.
echo "
#include <sys/types.h>
#define __KERNEL__
#include <linux/fs.h>
#undef __KERNEL__
#include <linux/tqueue.h>
#include <linux/termios.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_tcp.h>
#include <netinet/ip_icmp.h>
#include <netinet/ip_udp.h>

typedef signed char s8;
typedef unsigned char u8;

typedef signed short s16;
typedef unsigned short u16;

typedef signed int s32;
typedef unsigned int u32;

typedef signed long long s64;
typedef unsigned long long u64;

/* WTA: For some reason the following is only defined in the kernel Makefile
 * (see drivers/net/Config.in). So we have to specify it here manually.
 */
#define CONFIG_DLCI_MAX	8

#define __KERNEL__
/* WTA: Nasty, but necessary since isdn.h apparently does something strange
 * with struct tcphdrd (redefinition in linux/tcp.h)
 */
#define tcphdr	__sysxxx_tcphdr
#include <linux/isdn.h>
#include <linux/isdn_ppp.h>
#undef tcphdr

"
bad_defines='_MAGIC|"LP_|"NFS_|_PATCH"|"ADJ_'
cat ioctlent.tmp | fgrep -v "isdn" |
	awk '{ print "#include <" substr($2, 2, length($2) - 3) ">" }' |
	sort -u
echo "struct ioctlent ioctlent[] = {"
egrep -v "$bad_defines" ioctlent.tmp
echo "};
#undef __KERNEL__

"
#rm -f ioctlent.tmp
