/* generic network support functions */

#include <stdio.h>
#include <signal.h>

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
extern void *memset();
#endif

#if defined(_POSIX_SOURCE)
#include <unistd.h>
#else
extern int close();
#endif

#include "P_.h"
#include "net.h"

extern char *syserrstr P_((void));

#define	TOUT	60		/* max secs to wait for socket data */

/* establish a TCP connection to the named host on port.
 * if ok return file descriptor, else -1 with excuse in msg[].
 */
int
mkconnection (host, port, msg)
char *host;	/* name of server */
int port;	/* TCP port */
char msg[];	/* return diagnostic message here, if returning -1 */
{

	struct sockaddr_in serv_addr;
	struct hostent *hp;
	int sockfd;

	/* don't want signal if loose connection to server */
	(void) signal (SIGPIPE, SIG_IGN);

	/* lookup host address.
	 * TODO: time out but even SIGALRM doesn't awaken this if it's stuck.
	 */
	hp = gethostbyname (host);
	if (!hp) {
	    char *errmsg = "Try entering IP directly";

/* how portable is h_errno? */
#if defined(HOST_NOT_FOUND) && defined(TRY_AGAIN)
	    extern int h_errno;
	    switch (h_errno) {
	    case HOST_NOT_FOUND:
		errmsg = "Host Not Found";
		break;
	    case TRY_AGAIN:
		errmsg = "Might be a temporary condition -- try again later";
		break;
	    }
#endif
	    (void) sprintf (msg, "%s:\nCan not get IP:\n%s.", host, errmsg);
	    return (-1);
	}

	/* create a socket to the host's server */
	(void) memset ((char *)&serv_addr, 0, sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr =
			    ((struct in_addr *)(hp->h_addr_list[0]))->s_addr;
	serv_addr.sin_port = htons(port);
	if ((sockfd = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
	    (void) sprintf (msg, "%s/%d: %s", host, port, syserrstr());
	    return (-1);
	}

	/* connect */
	if (connect (sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr))<0){
	    (void) sprintf (msg, "%s: %s", host, syserrstr());
	    (void) close(sockfd);
	    return (-1);
	}

	return (sockfd);
}

/* send n bytes from buf to socket fd.
 * return 0 if ok else -1
 */
int
sendbytes (fd, buf, n)
int fd;
unsigned char buf[];
int n;
{
	int ns, tot;

	for (tot = 0; tot < n; tot += ns) {
	    if (tout (fd, 1) < 0)
		return (-1);
	    ns = send (fd, (void *)(buf+tot), n-tot, 0);
	    if (ns <= 0)
		return (-1);
	}
	return (0);
}

/* receive exactly n bytes from socket fd into buf.
 * return n if ok else -1
 */
int
recvbytes (fd, buf, n)
int fd;
unsigned char buf[];
int n;
{
	int ns, tot;

	for (tot = 0; tot < n; tot += ns) {
	    if (tout (fd, 0) < 0)
		return (-1);
	    ns = recv (fd, (void *)(buf+tot), n-tot, 0);
	    if (ns <= 0)
		return (-1);
	}
	return (n);
}

/* read up to and including the next '\n' from socket fd into buf[max].
 * we silently ignore all '\r'. we add a trailing '\0'.
 * return line lenth (not counting \0) if all ok, else -1.
 * N.B. this never reads ahead -- if readahead is ok, sfgets() is more efficient
 */
int
recvline (fd, buf, max)
int fd;
char buf[];
int max;
{
	unsigned char c;
	int n;

	max--;	/* leave room for trailing \0 */

	for (n = 0; n < max && recvbytes (fd, &c, 1) == 1; ) {
	    if (c != '\r') {
		buf[n++] = c;
		if (c == '\n') {
		    buf[n] = '\0';
		    return (n);
		}
	    }
	}

	return (-1);
}

/* wait up to TOUT secs for the ability to read/write using fd.
 * w is 1 for writing, 0 for reading.
 * return 0 if ok to proceed, else -1 if trouble or timeout.
 */
int
tout (fd, w)
int fd;
int w;
{
	fd_set fdset, *rset, *wset;
	struct timeval tv;

	FD_ZERO (&fdset);
	FD_SET (fd, &fdset);
	if (w) {
	    rset = NULL;
	    wset = &fdset;
	} else {
	    rset = &fdset;
	    wset = NULL;
	}

	tv.tv_sec = TOUT;
	tv.tv_usec = 0;

	return (select (fd+1, rset, wset, NULL, &tv) <= 0 ? -1 : 0);
}

/* rather like fgets(3) but uses a socket instead of a FILE *.
 * N.B. we silently swallow all '\r'.
 * N.B. we read ahead and can hide bytes after each call.
 */
char *
sfgets (buf, size, sock)
char *buf;
int size;
int sock;
{
	static char linebuf[512];	/* [next .. bad-1] are good */
	static int next;		/* index of next good char */
	static int bad;			/* index of first undefined char */
	char *origbuf = buf;		/* save for success return */
	char c;

	/* always leave room for trailing \n */
	size -= 1;

	/* read and copy linebuf[next] to buf until buf fills or copied a \n */
	do {
	    if (next >= bad) {
		/* linebuf is empty -- refill */
		if (tout (sock, 0) < 0 ||
			(bad = recv (sock, linebuf, sizeof(linebuf), 0)) < 0)
		    break;
		next = 0;
	    }
	    if ((c = linebuf[next++]) != '\r')
		*buf++ = c;
	} while (buf-origbuf < size && c != '\n');

	/* reset and return NULL if didn't copy out anything */
	if (buf == origbuf) {
	    next = bad = 0;
	    return (NULL);
	}

	*buf = '\0';

	return (origbuf);
}
