.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.ny0
.TH XStringToKeysym __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XStringToKeysym, XKeysymToString, XKeycodeToKeysym, XKeysymToKeycode, XConvertCase \- convert keysyms
.SH SYNTAX
.HP
KeySym XStringToKeysym\^(\^char *\fIstring\fP\^); 
.HP
char *XKeysymToString\^(\^KeySym \fIkeysym\fP\^); 
.HP
KeySym XKeycodeToKeysym\^(\^Display *\fIdisplay\fP\^, KeyCode \fIkeycode\fP\^,
int \fIindex\fP\^); 
.HP
KeyCode XKeysymToKeycode\^(\^Display *\fIdisplay\fP\^, KeySym \fIkeysym\fP\^);
.HP
void XConvertCase(\^KeySym \fIkeysym\fP\^, KeySym *\fIlower_return\fP\^,
KeySym *\fIupper_return\fP\^); 
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIindex\fP 1i
Specifies the element of KeyCode vector.
.IP \fIkeycode\fP 1i
Specifies the KeyCode.
.ds Fn searched for or converted
.IP \fIkeysym\fP 1i
Specifies the KeySym that is to be \*(Fn.
.IP \fIlower_return\fP 1i
Returns the lowercase form of keysym, or keysym.
.IP \fIstring\fP 1i
Specifies the name of the KeySym that is to be converted.
.IP \fIupper_return\fP 1i
Returns the uppercase form of keysym, or keysym.
.SH DESCRIPTION
Standard KeySym names are obtained from
.hN X11/keysymdef.h
by removing the XK_ prefix from each name.
KeySyms that are not part of the Xlib standard also may be obtained
with this function.
The set of KeySyms that are available in this manner 
and the mechanisms by which Xlib obtains them is implementation-dependent.
.LP
If the KeySym name is not in the Host Portable Character Encoding,
the result is implementation-dependent.
If the specified string does not match a valid KeySym,
.ZN XStringToKeysym
returns
.ZN NoSymbol .
.LP
The returned string is in a static area and must not be modified.
The returned string is in the Host Portable Character Encoding.
If the specified KeySym is not defined,
.ZN XKeysymToString
returns a NULL.
.LP
The
.ZN XKeycodeToKeysym
function uses internal Xlib tables
and returns the KeySym defined for the specified KeyCode and
the element of the KeyCode vector.
If no symbol is defined,
.ZN XKeycodeToKeysym
returns
.ZN NoSymbol .
.ZN XKeycodeToKeysym
predates the XKB extension. If you want to lookup a KeySym while
using XKB you have to use
.ZN XkbKeycodeToKeysym .
.LP
If the specified KeySym is not defined for any KeyCode,
.ZN XKeysymToKeycode
returns zero.
.LP
The
.ZN XConvertCase
function returns the uppercase and lowercase forms of the specified Keysym,
if the KeySym is subject to case conversion;
otherwise, the specified KeySym is returned to both lower_return and
upper_return.
Support for conversion of other than Latin and Cyrillic KeySyms is
implementation-dependent.
.SH "SEE ALSO"
XkbKeycodeToKeysym(__libmansuffix__),
XLookupKeysym(__libmansuffix__)
.br
\fI\*(xL\fP
