/*
 * ctable.c
 *
 * All rights reserved. Copyright (C) 1996-1999 by NARITA Tomio.
 * $Id: ctable.c,v 1.2 1999/05/13 16:55:41 nrt Exp $
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>

#include <import.h>
#include <itable.h>
#include <begin.h>
#include <ctable_t.h>

/*
 * coding system table
 */

public c_table_t cTable[ C_TABLE_SIZE ] = {
  /*
   * Auto select: decoding on iso-2022-kr and encoding on iso-2022-jp
   */
  { AUTOSELECT, FALSE, "a",
      {{0, 1}, {ASCII, KSC5601, ASCII, ASCII}, NULL, NULL } },

  /*
   * 7bit
   */
  { UTF_7, FALSE, "u7",
      {{0, 1}, {ASCII, ASCII, ASCII, ASCII}, NULL, NULL } },
  { HZ_GB, FALSE, "hz",
      {{0, 1}, {ASCII, GB2312, ASCII, ASCII}, NULL, NULL } },

  /*
   * EUC encoding
   */
  { EUC_KOREA, FALSE, "ek",
      {{0, 1}, {ASCII, KSC5601, ASCII, ASCII}, NULL, NULL } },
  { EUC_JAPAN, FALSE, "ej",
      {{0, 1}, {ASCII, X0208, X0201KANA, X0212}, NULL, NULL } },
  { EUC_TAIWAN, FALSE, "et",
      {{0, 1}, {ASCII, CNS_1, CNS_1, ASCII}, NULL, NULL } },
  { EUC_CHINA, FALSE, "ec",
      {{0, 1}, {ASCII, GB2312, ASCII, ASCII}, NULL, NULL } },

  /*
   * non iso-2022 encoding
   */
  { BIG_FIVE, FALSE, "b",
      {{0, 1}, {ASCII, ASCII, ASCII, ASCII}, NULL, NULL } },
  { SHIFT_JIS, FALSE, "s",
      {{0, 1}, {ASCII, X0201KANA, ASCII, ASCII}, NULL, NULL } },
  { UTF_8, FALSE, "u8",
      {{0, 1}, {ASCII, ASCII, ASCII, ASCII}, NULL, NULL } },

  /*
   * ISO 2022 8bit encoding
   */
  { ISO_8859_1, TRUE, "l",
      {{0, 1}, {ASCII, ISO8859_1, ASCII, ASCII}, NULL, NULL } },
  { ISO_8859_2, TRUE, "l2",
      {{0, 1}, {ASCII, ISO8859_2, ASCII, ASCII}, NULL, NULL } },
  { ISO_8859_3,	TRUE, "l3",
      {{0, 1}, {ASCII, ISO8859_3, ASCII, ASCII}, NULL, NULL } },
  { ISO_8859_4, TRUE, "l4",
      {{0, 1}, {ASCII, ISO8859_4, ASCII, ASCII}, NULL, NULL } },
  { ISO_8859_5, TRUE, "cy",
      {{0, 1}, {ASCII, ISO8859_5, ASCII, ASCII}, NULL, NULL } },
  { ISO_8859_6, TRUE, "ar",
      {{0, 1}, {ASCII, ISO8859_6, ASCII, ASCII}, NULL, NULL } },
  { ISO_8859_7, TRUE, "gr",
      {{0, 1}, {ASCII, ISO8859_7, ASCII, ASCII}, NULL, NULL } },
  { ISO_8859_8, TRUE, "he",
      {{0, 1}, {ASCII, ISO8859_8, ASCII, ASCII}, NULL, NULL } },
  { ISO_8859_9, TRUE, "l5",
      {{0, 1}, {ASCII, ISO8859_9, ASCII, ASCII}, NULL, NULL } },

  /*
   * ISO 2022 7bit encoding
   */
  { ISO_2022_CN, FALSE, "c",
      {{0, 1}, {ASCII, GB2312, ASCII, ASCII}, NULL, NULL } },
  { ISO_2022_JP, FALSE, "j",
      {{0, 3}, {ASCII, X0201KANA, X0201KANA, X0208}, NULL, NULL } },
  { ISO_2022_KR, FALSE, "k",
      {{0, 1}, {ASCII, KSC5601, ASCII, ASCII}, NULL, NULL } },

  /*
   * Raw encoding
   */
  { RAW, FALSE, "r",
      {{0, 1}, {ASCII, ASCII, ASCII, ASCII}, NULL, NULL } }
};

public void CtableInit()
{
  int i;

  for( i = 0 ; i < C_TABLE_SIZE ; i++ )
    if( cTable[ i ].codingSystem != i )
      fprintf( stderr, "lv: invalid charset table\n" ), exit( -1 );
}
