/* data.cc fr logwatchd 

   Michael Krax

   $Id: data.cc,v 1.6 2001/02/07 13:23:07 krax Exp $

   GPL

   michael.krax@innominate.com

 */

#include "includes.h"
#include <stdio.h>
#include <syslog.h>
#include <unistd.h>

int inPattern::matches(char *aLine) {
  return (regexec(&rPattern, aLine, 0, 0, 0) == 0);
}

int inLogfile::checkPatternIn(list<inMsg*>& msgQ, char *eing) {
  list<inPattern*>::iterator first = pattern.begin();
  list<inPattern*>::iterator last  = pattern.end();

  while (first != last) {
    if ((*first)->matches(eing)) {
      int done = 0;
      list<inMsg*>::iterator fi = msgQ.begin();
      list<inMsg*>::iterator la = msgQ.end();
      while (fi != la) {
	/* for every mailto one addZeile */
	if ( ((*fi)->mailto->pattern->logfile == this) && 
	     ((*fi)->mailto->pattern == *first) ) {
	  (*fi)->addZeile(eing);
#ifdef DEBUG
	  printlog(LOG_DEBUG, "inLogfile::checkPatternIn(): called addZeile with \"%s\"\n", eing);
#endif
	  done++;
	}
	fi++;
      }
      if (!done) {
	/* do add msgQ entry for every mailto in pattern */
	list<inMailTo*>::iterator mt1 = (*first)->mailto.begin();
	list<inMailTo*>::iterator mt2 = (*first)->mailto.end();
	while (mt1 != mt2) {
	  msgQ.insert(msgQ.end(), new inMsg((*mt1), eing));
	  mt1++;
#ifdef DEBUG
	  printlog(LOG_DEBUG, 
		   "inLogfile::checkPatternIn(): new inMsg added for \"%s\"\n", 
		   eing);
#endif
	}
      }
    }
    first++;
  }
}

/* substitute :
   %f thisDaemon->glFromAdr     Absenderadresse
   %n                           Hufigkeit der Meldung
   %l                           die letzten Zeilen
   %t pattern->getMailadr()     die Empfngeradresse
   %m                           das Muster, das passte 
   %F                           logfile-name
   (%d                          Uhrzeit)
   %h                           hostname
*/

char* lastTry(const char *tmpl, const char *f, const char *n,
	      const char *t, const char *m,
	      const char *F, const char *l,
	      const char *h) {

  int iRes = 5000>?(strlen(tmpl)*3), i = 0;
  char *res = new char [iRes], *cOR = res;
  char c[2];
  char *cTmpl = new char [strlen(tmpl)+1], *cOT = cTmpl;

  memset (res, 0, iRes);

  strcpy(cTmpl, tmpl);

  while (*cTmpl != '\0') {
    switch (*cTmpl) 
      {
      case '%':
	cTmpl++;
	switch (*cTmpl)
	  {
	  case 'f': strncat(res, f, iRes-strlen(res)-1); break;
	  case 'n': strncat(res, n, iRes-strlen(res)-1); break;
	  case 't': strncat(res, t, iRes-strlen(res)-1); break;
	  case 'm': strncat(res, m, iRes-strlen(res)-1); break;
	  case 'F': strncat(res, F, iRes-strlen(res)-1); break;
	  case 'l': strncat(res, l, iRes-strlen(res)-1); break;
	  case 'h': strncat(res, h, iRes-strlen(res)-1); break;
	  case '%': strncat(res, "%", iRes-strlen(res)-1); break;
	  default: if ((iRes-strlen(res)) > 2) {
		     *res = '%'; res++; *res = *cTmpl; res++; *res = '\0'; 
		   }
	  }
	i = strlen(res);
	break;

      default:
       if ((iRes-strlen(res)) > 1) {
	*res = *cTmpl; res++; *res = '\0';
       }
	i++;
	if (i>iRes) break;
      }
    cTmpl++;
  }

  free(cOT);

  return cOR;
}

char* inMsg::build() {
  inMailTo *mt = mailto;
  char s1[100];
  bzero(s1, 100);
  snprintf(s1, 100, "%i", lines);

  list<char *>::iterator b = zeilen.begin(),
    e = zeilen.end();
  char s[2500];
  bzero(s, 2500);
  while ( b != e ) {
    strncat(s, *b, 2500-strlen(s)-1);
    b++;
    if (b != e) strncat(s, "\n", 2500-strlen(s)-1);
  }

  /* get hostname */
  char hostname[L2M_MAX_STR];
  if (0 != gethostname(hostname, L2M_MAX_STR)) {
    printlog(LOG_ERR, "nMsg::build: Couldn't determine host name: %m\n");
    return NULL;
  }

#ifdef DEBUG
  printlog(LOG_DEBUG, "inMsg::build: Preparing message to %s\n", mt->getMailto());
#endif 

  char *cRes = lastTry(thisDaemon->konfig.getTemplate(mt->getParams()->getParamValue("template"))->getContents(),
		       mt->getParams()->getParamValue("fromaddr"),
		       s1,
		       mt->getMailto(),
		       mt->getPattern(),
		       mt->getLogfile(),
		       s,
		       hostname);

  char *res = (char*)malloc(strlen(cRes)+1);
  strncpy(res, cRes, strlen(cRes)+1);

  free(cRes);

  return res;
}

int inMsg::addZeile(char *zeile) {
  char *myline = (char*)malloc(strlen(zeile)+1);
  if (myline) {
    strncpy(myline, zeile, strlen(zeile)+1);
    zeilen.insert(zeilen.end(), myline);
    lines++;
  }
  if (zeilen.size() > mailto->getParams()->getParamValueAsInt("maxlines")) {
    zeilen.erase(zeilen.begin());
  }
  if (lines == 1) zaehler = 0;
}


char *inMailTo::getPattern() { return pattern->getPattern(); }
char *inMailTo::getLogfile() { return pattern->getLogfile(); }

char *inPattern::getLogfile() { return logfile->getFilename(); }
