// $Id: event.cpp,v 1.1 2001/04/18 23:28:58 cschumac Exp $

#include <kglobal.h>
#include <klocale.h>

#include "event.h"

using namespace KCal;

Event::Event()
{
  mTransparency = 0;
}

Event::~Event()
{
}

void Event::setDtEnd(const QDateTime &dtEnd)
{  
  if (mReadOnly) return;
  mDtEnd = dtEnd;
  emit eventUpdated(this);
}

const QDateTime &Event::dtEnd() const
{
  return mDtEnd;
}

QString Event::dtEndTimeStr() const
{
  return KGlobal::locale()->formatTime(mDtEnd.time());
}

QString Event::dtEndDateStr(bool shortfmt) const
{
  return KGlobal::locale()->formatDate(mDtEnd.date(),shortfmt);
}

QString Event::dtEndStr() const
{
  return KGlobal::locale()->formatDateTime(mDtEnd);
}


bool Event::isMultiDay() const
{
  bool multi = !(dtStart().date() == dtEnd().date());
  return multi;
}


void Event::setTransparency(int transparency)
{
  if (mReadOnly) return;
  mTransparency = transparency;
  emit eventUpdated(this);
}

int Event::transparency() const
{
  return mTransparency;
}


