/* $Id: treeview.h,v 1.5 2000/02/20 21:45:37 bergo Exp $ */

#ifndef TREEVIEW_H
#define TREEVIEW_H

#include "polling.h"
#include "netpolling.h"
#include <gtk/gtk.h>

void pop_treeview(GtkWidget *gw,gpointer data);
void close_treeview_box(GtkWidget *w, gpointer data);
void destroy_treeview_box(GtkWidget *w,gpointer data);

void expand_treeview_box(GtkWidget *gw,gpointer data);
void collapse_treeview_box(GtkWidget *gw,gpointer data);
void frobnicate_the_tree(GtkTreeItem *gti,gpointer data);
void refresh_treeview(GtkWidget *gw,gpointer data);

void tv_select_item(GtkItem *gi,gpointer data);
void tv_deselect_item(GtkItem *gi,gpointer data);

void tv_details(GtkWidget *gw,gpointer data);

void load_pix();
GtkWidget *host_entry_new(char *hname);

void update_ptree();
void update_local_subtree(GtkWidget *parent);
void update_remote_subtrees(GtkWidget *parent,
			    NetworkListPoller *nlp,
			    NetworkDetailsPoller *ndp,
			    NetworkSystemInfoProvider *nsp);

void reset_tnodes();

void PosixKillOne(GtkWidget *gw,gpointer data);
void PosixKillChildren(GtkWidget *gw,gpointer data);
void PosixKillFamily(GtkWidget *gw,gpointer data);

class ProcessLeaf *findNode(GtkTreeItem *sti);
void               signal_it_friendly(int pid,int zignal);
void               tv_kill_family(class ProcessLeaf *pl,int zignal);
void               tv_kill_children(class ProcessLeaf *pl,int zignal);

/// a leaf in the process tree
class ProcessLeaf {
 public:
  ~ProcessLeaf();

  /// returns the label as it is to appear in the widget
  char *get_tree_label();

  /// polls the given (local) pid and fills object
  void poll_pid(int n);

  /// polls the given pid and net pollers,fills object
  void poll_net_pid(int n,
		    NetworkDetailsPoller *ndp,
		    NetworkSystemInfoProvider *nsp);

  /// builds the sole item (above is a tree)
  void build_item(GtkWidget *above);

  /// calls build on offspring and adds them as subtree
  void compose_item();

  /// a descent into the maelstrom
  void recursive_compose_offspring();

  char machine[GPS_MAXHOSTNAME];
  char process_title[GPS_MAXPROCESSNAME];
  int  pid;
  int  ppid;
  char owner[GPS_MAXOWNER];
  char size[GPS_MAXMEMSTRING];
  char cpu[32];

  GtkWidget *treeitem;
  GtkWidget *thistree;
  GList *sonlist;
  class ProcessLeaf *father;

 private:
  char local_buffer[512];
  guint sigid[4];
};

#endif
