/* $Id: pipedtop.h,v 1.4 2000/02/20 21:45:36 bergo Exp $ */

#ifdef HAVETOP

#ifndef PIPEDTOP_H
#define PIPEDTOP_H

#include "polling.h"

/// piped top connection and communication manager
class PiperAtTheGatesOfDawn {
 public:
  /// constructor, forks off top and opens a pipe for IPC.
  PiperAtTheGatesOfDawn();

  /// kill top, close pipe. (Yes, Elvis IS dead).
  void top_meets_elvis();
  
  /// read all data available (garbage ?) from pipe without blocking
  void read_dead_output();

  /// reads one line from the pipe, return NULL if an error occurs.
  char *read_top_line(char *buffer,int size);

  /// send refresh request (space character) to top
  void request_refresh();

 private:
  char *myfgets(char *buffer,int bsize,int descriptor);

  char toppath[512];
  int pipe_to_top[2],pipe_from_top[2];
  int toppid;
};

/// process list polling via piped top
class PipedTopListPoller :
 public ProcessListPoller, public PiperAtTheGatesOfDawn {

 public:
  /// trivial constructor
  PipedTopListPoller();

  /// clean up code (closes pipe).
  void terminate();

  /// actual polling implementation.
  void poll();
};

/// process details via piped top
class PipedTopDetailsPoller : 
 public ProcessDetailsPoller, public PiperAtTheGatesOfDawn {

 public:

  /// actual polling implementation.
  void poll(int whichpid);

  /// clean up code (closes pipe).
  void terminate();
};

/// system information via piped top
class PipedTopInfoProvider : 
 public SystemInfoProvider, public PiperAtTheGatesOfDawn {

 public:

  /// trivial constructor
  PipedTopInfoProvider();

  /** actual information gathering (memory information isn't as
      accurate as it could be, top is guilty) */
  void update();

  /// clean up code (closes pipe)
  void terminate();
};

#endif

#endif /* HAVETOP */
