%%
%% %CopyrightBegin%
%% 
%% Copyright Ericsson AB 2006-2013. All Rights Reserved.
%% 
%% The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% %CopyrightEnd%
%%
%%
%%% Purpose : Test suite for the xmerl application

%% Do NOT edit this file. It is generated by the generate_xsd_suite module
%% For more info read the comments in the header of that file.

-module('xmerl_xsd_MS2002-01-16_SUITE').

-compile(export_all).

-include_lib("test_server/include/test_server.hrl").
-include_lib("xmerl/include/xmerl.hrl").
-include_lib("xmerl/include/xmerl_xsd.hrl").


all() -> 
    [att, ct, elem, model_group, idc_, id, mgABCD, mgEFG, mgHIJ,
     mgK, mgLM, mgN, mgOP, mgQR, mgS, particlesAB,
     particlesCDE, particlesFHI, particlesJ,
     particlesKOSRTQUVW, stABCDE, stFGH, stIJK, stZ,
     wildABCDEF, wildGHI, wildJKLMNQOP, wildZ].

groups() -> 
    [].

init_per_group(_GroupName, Config) ->
    Config.

end_per_group(_GroupName, Config) ->
    Config.



%% initialization before the test suite
init_per_suite(Config) ->
  Dog=test_server:timetrap({minutes,10}),
  xmerl_xsd_lib:unpack(Config,msx),
  {ok,LogFile} = xmerl_xsd_lib:create_error_log_file(Config,msx),
  test_server:timetrap_cancel(Dog),
  [{suite,msx},{xmerl_error_log,LogFile}|Config].

end_per_suite(Config) ->
  xmerl_xsd_lib:rmdir(Config,msx),
  xmerl_xsd_lib:close_error_log_file(Config),
  ok.

%% initialization before each testcase
init_per_testcase(TestCase,Config) ->
  Dog=test_server:timetrap({minutes,3}),
  [{testcase,TestCase},{watchdog, Dog}|Config].

%% clean up after each testcase
end_per_testcase(_Func,Config) ->
  Dog=?config(watchdog, Config),
  test_server:timetrap_cancel(Dog),
  ok.

%% Syntax Checking for Attribute Declaration

att(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attA001.xsd','./msxsdtest/attribute',invalid),
  STResList1 = [STRes0|STResList0],


  ?line {STRes1,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attA002.xsd','./msxsdtest/attribute',invalid),
  STResList2 = [STRes1|STResList1],


  ?line {STRes2,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attA003.xsd','./msxsdtest/attribute',invalid),
  STResList3 = [STRes2|STResList2],


  ?line {STRes3,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attA004.xsd','./msxsdtest/attribute',invalid),
  STResList4 = [STRes3|STResList3],


  ?line {STRes4,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attA005.xsd','./msxsdtest/attribute',invalid),
  STResList5 = [STRes4|STResList4],


  ?line {STRes5,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attA006.xsd','./msxsdtest/attribute',invalid),
  STResList6 = [STRes5|STResList5],


  ?line {STRes6,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attA007.xsd','./msxsdtest/attribute',valid),
  STResList7 = [STRes6|STResList6],


  ?line {STRes7,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attA008.xsd','./msxsdtest/attribute',valid),
  STResList8 = [STRes7|STResList7],


  ?line {STRes8,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attB001.xsd','./msxsdtest/attribute',valid),
  STResList9 = [STRes8|STResList8],


  ?line {STRes9,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attB002.xsd','./msxsdtest/attribute',valid),
  STResList10 = [STRes9|STResList9],


  ?line {STRes10,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attB003.xsd','./msxsdtest/attribute',valid),
  STResList11 = [STRes10|STResList10],


  ?line {STRes11,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attB004.xsd','./msxsdtest/attribute',valid),
  STResList12 = [STRes11|STResList11],


  ?line {STRes12,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attB005.xsd','./msxsdtest/attribute',invalid),
  STResList13 = [STRes12|STResList12],


  ?line {STRes13,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attB006.xsd','./msxsdtest/attribute',invalid),
  STResList14 = [STRes13|STResList13],


  ?line {STRes14,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attC001.xsd','./msxsdtest/attribute',valid),
  STResList15 = [STRes14|STResList14],




  ?line {STRes15,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attC003.xsd','./msxsdtest/attribute',valid),
  STResList16 = [STRes15|STResList15],


  ?line {STRes16,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attC004.xsd','./msxsdtest/attribute',invalid),
  STResList17 = [STRes16|STResList16],


  ?line {STRes17,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attC005.xsd','./msxsdtest/attribute',invalid),
  STResList18 = [STRes17|STResList17],


  ?line {STRes18,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attC006.xsd','./msxsdtest/attribute',invalid),
  STResList19 = [STRes18|STResList18],


  ?line {STRes19,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attC007.xsd','./msxsdtest/attribute',invalid),
  STResList20 = [STRes19|STResList19],


  ?line {STRes20,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attC008.xsd','./msxsdtest/attribute',invalid),
  STResList21 = [STRes20|STResList20],


  ?line {STRes21,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attC009.xsd','./msxsdtest/attribute',invalid),
  STResList22 = [STRes21|STResList21],


  ?line {STRes22,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attC010.xsd','./msxsdtest/attribute',invalid),
  STResList23 = [STRes22|STResList22],


  ?line {STRes23,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attD001.xsd','./msxsdtest/attribute',valid),
  STResList24 = [STRes23|STResList23],


  ?line {STRes24,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attD002.xsd','./msxsdtest/attribute',invalid),
  STResList25 = [STRes24|STResList24],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attD003.xsd','./msxsdtest/attribute',valid),
  STResList26 = [STRes25|STResList25],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attD003.xml','./msxsdtest/attribute',valid,S25),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attD004.xsd','./msxsdtest/attribute',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attD004.xml','./msxsdtest/attribute',valid,S26),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes27,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attD005.xsd','./msxsdtest/attribute',invalid),
  STResList28 = [STRes27|STResList27],


  ?line {STRes28,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attD006.xsd','./msxsdtest/attribute',invalid),
  STResList29 = [STRes28|STResList28],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attD007.xsd','./msxsdtest/attribute',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attD007.xml','./msxsdtest/attribute',valid,S29),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attE001.xsd','./msxsdtest/attribute',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attE001.xml','./msxsdtest/attribute',valid,S30),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes31,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attE002.xsd','./msxsdtest/attribute',invalid),
  STResList32 = [STRes31|STResList31],


  ?line {STRes32,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attE003.xsd','./msxsdtest/attribute',invalid),
  STResList33 = [STRes32|STResList32],


  ?line {STRes33,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attE004.xsd','./msxsdtest/attribute',invalid),
  STResList34 = [STRes33|STResList33],


  ?line {STRes34,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attE005.xsd','./msxsdtest/attribute',invalid),
  STResList35 = [STRes34|STResList34],


  ?line {STRes35,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attE006.xsd','./msxsdtest/attribute',invalid),
  STResList36 = [STRes35|STResList35],


  ?line {STRes36,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attE007.xsd','./msxsdtest/attribute',invalid),
  STResList37 = [STRes36|STResList36],


  ?line {STRes37,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attE008.xsd','./msxsdtest/attribute',valid),
  STResList38 = [STRes37|STResList37],


  ?line {STRes38,S38} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF001.xsd','./msxsdtest/attribute',valid),
  STResList39 = [STRes38|STResList38],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attF001.xml','./msxsdtest/attribute',invalid,S38),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes39,S39} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF002.xsd','./msxsdtest/attribute',valid),
  STResList40 = [STRes39|STResList39],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attF002.xml','./msxsdtest/attribute',valid,S39),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes40,S40} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF003.xsd','./msxsdtest/attribute',valid),
  STResList41 = [STRes40|STResList40],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attF003.xml','./msxsdtest/attribute',valid,S40),
  ITResList7 = [ITRes6|ITResList6],


  ?line {STRes41,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF004.xsd','./msxsdtest/attribute',invalid),
  STResList42 = [STRes41|STResList41],


  ?line {STRes42,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF005.xsd','./msxsdtest/attribute',invalid),
  STResList43 = [STRes42|STResList42],


  ?line {STRes43,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF006.xsd','./msxsdtest/attribute',invalid),
  STResList44 = [STRes43|STResList43],


  ?line {STRes44,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF007.xsd','./msxsdtest/attribute',invalid),
  STResList45 = [STRes44|STResList44],


  ?line {STRes45,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF008.xsd','./msxsdtest/attribute',invalid),
  STResList46 = [STRes45|STResList45],


  ?line {STRes46,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF009.xsd','./msxsdtest/attribute',invalid),
  STResList47 = [STRes46|STResList46],


  ?line {STRes47,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF010.xsd','./msxsdtest/attribute',invalid),
  STResList48 = [STRes47|STResList47],


  ?line {STRes48,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attF011.xsd','./msxsdtest/attribute',invalid),
  STResList49 = [STRes48|STResList48],


  ?line {STRes49,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attG001.xsd','./msxsdtest/attribute',valid),
  STResList50 = [STRes49|STResList49],


  ?line {STRes50,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attG002.xsd','./msxsdtest/attribute',valid),
  STResList51 = [STRes50|STResList50],


  ?line {STRes51,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attG003.xsd','./msxsdtest/attribute',valid),
  STResList52 = [STRes51|STResList51],


  ?line {STRes52,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attH001.xsd','./msxsdtest/attribute',invalid),
  STResList53 = [STRes52|STResList52],


  ?line {STRes53,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attI001.xsd','./msxsdtest/attribute',valid),
  STResList54 = [STRes53|STResList53],


  ?line {STRes54,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attI002.xsd','./msxsdtest/attribute',valid),
  STResList55 = [STRes54|STResList54],


  ?line {STRes55,S55} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attI003.xsd','./msxsdtest/attribute',valid),
  STResList56 = [STRes55|STResList55],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attI003.xml','./msxsdtest/attribute',valid,S55),
  ITResList8 = [ITRes7|ITResList7],


  ?line {STRes56,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attI004.xsd','./msxsdtest/attribute',invalid),
  STResList57 = [STRes56|STResList56],


  ?line {STRes57,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attI005.xsd','./msxsdtest/attribute',invalid),
  STResList58 = [STRes57|STResList57],


  ?line {STRes58,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attI006.xsd','./msxsdtest/attribute',invalid),
  STResList59 = [STRes58|STResList58],


  ?line {STRes59,S59} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ001.xsd','./msxsdtest/attribute',valid),
  STResList60 = [STRes59|STResList59],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ001.xml','./msxsdtest/attribute',valid,S59),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes60,S60} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ002.xsd','./msxsdtest/attribute',valid),
  STResList61 = [STRes60|STResList60],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ002.xml','./msxsdtest/attribute',invalid,S60),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes61,S61} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ003.xsd','./msxsdtest/attribute',valid),
  STResList62 = [STRes61|STResList61],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ003.xml','./msxsdtest/attribute',invalid,S61),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes62,S62} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ004.xsd','./msxsdtest/attribute',valid),
  STResList63 = [STRes62|STResList62],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ004.xml','./msxsdtest/attribute',valid,S62),
  ITResList12 = [ITRes11|ITResList11],


  ?line {STRes63,S63} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ005.xsd','./msxsdtest/attribute',valid),
  STResList64 = [STRes63|STResList63],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ005.xml','./msxsdtest/attribute',valid,S63),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes64,S64} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ006.xsd','./msxsdtest/attribute',valid),
  STResList65 = [STRes64|STResList64],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ006.xml','./msxsdtest/attribute',valid,S64),
  ITResList14 = [ITRes13|ITResList13],


  ?line {STRes65,S65} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ007.xsd','./msxsdtest/attribute',valid),
  STResList66 = [STRes65|STResList65],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ007.xml','./msxsdtest/attribute',valid,S65),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes66,S66} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ008.xsd','./msxsdtest/attribute',valid),
  STResList67 = [STRes66|STResList66],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ008.xml','./msxsdtest/attribute',invalid,S66),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes67,S67} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ009.xsd','./msxsdtest/attribute',valid),
  STResList68 = [STRes67|STResList67],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ009.xml','./msxsdtest/attribute',invalid,S67),
  ITResList17 = [ITRes16|ITResList16],


  ?line {STRes68,S68} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ010.xsd','./msxsdtest/attribute',valid),
  STResList69 = [STRes68|STResList68],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ010.xml','./msxsdtest/attribute',invalid,S68),
  ITResList18 = [ITRes17|ITResList17],


  ?line {STRes69,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ011.xsd','./msxsdtest/attribute',invalid),
  STResList70 = [STRes69|STResList69],


  ?line {STRes70,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ012.xsd','./msxsdtest/attribute',invalid),
  STResList71 = [STRes70|STResList70],


  ?line {STRes71,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ013.xsd','./msxsdtest/attribute',invalid),
  STResList72 = [STRes71|STResList71],


  ?line {STRes72,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ014.xsd','./msxsdtest/attribute',invalid),
  STResList73 = [STRes72|STResList72],


  ?line {STRes73,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ015.xsd','./msxsdtest/attribute',invalid),
  STResList74 = [STRes73|STResList73],


  ?line {STRes74,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ016.xsd','./msxsdtest/attribute',invalid),
  STResList75 = [STRes74|STResList74],


  ?line {STRes75,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ017.xsd','./msxsdtest/attribute',invalid),
  STResList76 = [STRes75|STResList75],


  ?line {STRes76,S76} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attJ018.xsd','./msxsdtest/attribute',valid),
  STResList77 = [STRes76|STResList76],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attJ018.xml','./msxsdtest/attribute',valid,S76),
  ITResList19 = [ITRes18|ITResList18],


  ?line {STRes77,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa001.xsd','./msxsdtest/attribute',invalid),
  STResList78 = [STRes77|STResList77],


  ?line {STRes78,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa002.xsd','./msxsdtest/attribute',valid),
  STResList79 = [STRes78|STResList78],


  ?line {STRes79,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa003.xsd','./msxsdtest/attribute',invalid),
  STResList80 = [STRes79|STResList79],


  ?line {STRes80,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa004.xsd','./msxsdtest/attribute',invalid),
  STResList81 = [STRes80|STResList80],


  ?line {STRes81,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa005.xsd','./msxsdtest/attribute',invalid),
  STResList82 = [STRes81|STResList81],


  ?line {STRes82,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa006.xsd','./msxsdtest/attribute',valid),
  STResList83 = [STRes82|STResList82],


  ?line {STRes83,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa007.xsd','./msxsdtest/attribute',invalid),
  STResList84 = [STRes83|STResList83],


  ?line {STRes84,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa008.xsd','./msxsdtest/attribute',invalid),
  STResList85 = [STRes84|STResList84],


  ?line {STRes85,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa009.xsd','./msxsdtest/attribute',invalid),
  STResList86 = [STRes85|STResList85],


  ?line {STRes86,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa010.xsd','./msxsdtest/attribute',invalid),
  STResList87 = [STRes86|STResList86],


  ?line {STRes87,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa011.xsd','./msxsdtest/attribute',invalid),
  STResList88 = [STRes87|STResList87],


  ?line {STRes88,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa012.xsd','./msxsdtest/attribute',invalid),
  STResList89 = [STRes88|STResList88],


  ?line {STRes89,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa013.xsd','./msxsdtest/attribute',invalid),
  STResList90 = [STRes89|STResList89],


  ?line {STRes90,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa014.xsd','./msxsdtest/attribute',invalid),
  STResList91 = [STRes90|STResList90],


  ?line {STRes91,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKa015.xsd','./msxsdtest/attribute',invalid),
  STResList92 = [STRes91|STResList91],


  ?line {STRes92,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb001.xsd','./msxsdtest/attribute',invalid),
  STResList93 = [STRes92|STResList92],


  ?line {STRes93,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb002.xsd','./msxsdtest/attribute',valid),
  STResList94 = [STRes93|STResList93],


  ?line {STRes94,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb003.xsd','./msxsdtest/attribute',valid),
  STResList95 = [STRes94|STResList94],


  ?line {STRes95,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb004.xsd','./msxsdtest/attribute',invalid),
  STResList96 = [STRes95|STResList95],


  ?line {STRes96,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb005.xsd','./msxsdtest/attribute',invalid),
  STResList97 = [STRes96|STResList96],


  ?line {STRes97,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb006.xsd','./msxsdtest/attribute',valid),
  STResList98 = [STRes97|STResList97],


  ?line {STRes98,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb007.xsd','./msxsdtest/attribute',valid),
  STResList99 = [STRes98|STResList98],


  ?line {STRes99,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb008.xsd','./msxsdtest/attribute',valid),
  STResList100 = [STRes99|STResList99],


  ?line {STRes100,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb009.xsd','./msxsdtest/attribute',valid),
  STResList101 = [STRes100|STResList100],


  ?line {STRes101,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb010.xsd','./msxsdtest/attribute',invalid),
  STResList102 = [STRes101|STResList101],


  ?line {STRes102,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb011.xsd','./msxsdtest/attribute',invalid),
  STResList103 = [STRes102|STResList102],


  ?line {STRes103,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb012.xsd','./msxsdtest/attribute',invalid),
  STResList104 = [STRes103|STResList103],


  ?line {STRes104,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb013.xsd','./msxsdtest/attribute',invalid),
  STResList105 = [STRes104|STResList104],


  ?line {STRes105,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb014.xsd','./msxsdtest/attribute',invalid),
  STResList106 = [STRes105|STResList105],


  ?line {STRes106,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb015.xsd','./msxsdtest/attribute',invalid),
  STResList107 = [STRes106|STResList106],


  ?line {STRes107,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb016.xsd','./msxsdtest/attribute',invalid),
  STResList108 = [STRes107|STResList107],


  ?line {STRes108,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb017.xsd','./msxsdtest/attribute',invalid),
  STResList109 = [STRes108|STResList108],


  ?line {STRes109,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKb018.xsd','./msxsdtest/attribute',invalid),
  STResList110 = [STRes109|STResList109],


  ?line {STRes110,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc001.xsd','./msxsdtest/attribute',invalid),
  STResList111 = [STRes110|STResList110],


  ?line {STRes111,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc002.xsd','./msxsdtest/attribute',valid),
  STResList112 = [STRes111|STResList111],


  ?line {STRes112,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc003.xsd','./msxsdtest/attribute',valid),
  STResList113 = [STRes112|STResList112],


  ?line {STRes113,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc004.xsd','./msxsdtest/attribute',invalid),
  STResList114 = [STRes113|STResList113],


  ?line {STRes114,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc005.xsd','./msxsdtest/attribute',invalid),
  STResList115 = [STRes114|STResList114],


  ?line {STRes115,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc006.xsd','./msxsdtest/attribute',valid),
  STResList116 = [STRes115|STResList115],


  ?line {STRes116,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc007.xsd','./msxsdtest/attribute',valid),
  STResList117 = [STRes116|STResList116],


  ?line {STRes117,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc008.xsd','./msxsdtest/attribute',valid),
  STResList118 = [STRes117|STResList117],


  ?line {STRes118,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc009.xsd','./msxsdtest/attribute',valid),
  STResList119 = [STRes118|STResList118],


  ?line {STRes119,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc010.xsd','./msxsdtest/attribute',invalid),
  STResList120 = [STRes119|STResList119],


  ?line {STRes120,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc011.xsd','./msxsdtest/attribute',invalid),
  STResList121 = [STRes120|STResList120],


  ?line {STRes121,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc012.xsd','./msxsdtest/attribute',invalid),
  STResList122 = [STRes121|STResList121],


  ?line {STRes122,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc013.xsd','./msxsdtest/attribute',invalid),
  STResList123 = [STRes122|STResList122],


  ?line {STRes123,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc014.xsd','./msxsdtest/attribute',invalid),
  STResList124 = [STRes123|STResList123],


  ?line {STRes124,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc015.xsd','./msxsdtest/attribute',invalid),
  STResList125 = [STRes124|STResList124],


  ?line {STRes125,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc016.xsd','./msxsdtest/attribute',invalid),
  STResList126 = [STRes125|STResList125],


  ?line {STRes126,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc017.xsd','./msxsdtest/attribute',invalid),
  STResList127 = [STRes126|STResList126],


  ?line {STRes127,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attKc018.xsd','./msxsdtest/attribute',invalid),
  STResList128 = [STRes127|STResList127],


  ?line {STRes128,S128} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLa001.xsd','./msxsdtest/attribute',valid),
  STResList129 = [STRes128|STResList128],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLa001.xml','./msxsdtest/attribute',valid,S128),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes129,S129} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLa002.xsd','./msxsdtest/attribute',valid),
  STResList130 = [STRes129|STResList129],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLa002.xml','./msxsdtest/attribute',valid,S129),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes130,S130} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLa003.xsd','./msxsdtest/attribute',valid),
  STResList131 = [STRes130|STResList130],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLa003.xml','./msxsdtest/attribute',valid,S130),
  ITResList22 = [ITRes21|ITResList21],


  ?line {STRes131,S131} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLa004.xsd','./msxsdtest/attribute',valid),
  STResList132 = [STRes131|STResList131],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLa004.xml','./msxsdtest/attribute',valid,S131),
  ITResList23 = [ITRes22|ITResList22],


  ?line {STRes132,S132} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLa005.xsd','./msxsdtest/attribute',valid),
  STResList133 = [STRes132|STResList132],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLa005.xml','./msxsdtest/attribute',invalid,S132),
  ITResList24 = [ITRes23|ITResList23],


  ?line {STRes133,S133} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLa006.xsd','./msxsdtest/attribute',valid),
  STResList134 = [STRes133|STResList133],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLa006.xml','./msxsdtest/attribute',valid,S133),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes134,S134} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLb001.xsd','./msxsdtest/attribute',valid),
  STResList135 = [STRes134|STResList134],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLb001.xml','./msxsdtest/attribute',valid,S134),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes135,S135} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLb002.xsd','./msxsdtest/attribute',valid),
  STResList136 = [STRes135|STResList135],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLb002.xml','./msxsdtest/attribute',valid,S135),
  ITResList27 = [ITRes26|ITResList26],


  ?line {STRes136,S136} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLb003.xsd','./msxsdtest/attribute',valid),
  STResList137 = [STRes136|STResList136],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLb003.xml','./msxsdtest/attribute',valid,S136),
  ITResList28 = [ITRes27|ITResList27],


  ?line {STRes137,S137} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLb004.xsd','./msxsdtest/attribute',valid),
  STResList138 = [STRes137|STResList137],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLb004.xml','./msxsdtest/attribute',valid,S137),
  ITResList29 = [ITRes28|ITResList28],


  ?line {STRes138,S138} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLb005.xsd','./msxsdtest/attribute',valid),
  STResList139 = [STRes138|STResList138],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLb005.xml','./msxsdtest/attribute',invalid,S138),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes139,S139} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLb006.xsd','./msxsdtest/attribute',valid),
  STResList140 = [STRes139|STResList139],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLb006.xml','./msxsdtest/attribute',valid,S139),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes140,S140} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLc001.xsd','./msxsdtest/attribute',valid),
  STResList141 = [STRes140|STResList140],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLc001.xml','./msxsdtest/attribute',valid,S140),
  ITResList32 = [ITRes31|ITResList31],


  ?line {STRes141,S141} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLc002.xsd','./msxsdtest/attribute',valid),
  STResList142 = [STRes141|STResList141],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLc002.xml','./msxsdtest/attribute',valid,S141),
  ITResList33 = [ITRes32|ITResList32],


  ?line {STRes142,S142} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLc003.xsd','./msxsdtest/attribute',valid),
  STResList143 = [STRes142|STResList142],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLc003.xml','./msxsdtest/attribute',valid,S142),
  ITResList34 = [ITRes33|ITResList33],


  ?line {STRes143,S143} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLc004.xsd','./msxsdtest/attribute',valid),
  STResList144 = [STRes143|STResList143],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLc004.xml','./msxsdtest/attribute',valid,S143),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes144,S144} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLc005.xsd','./msxsdtest/attribute',valid),
  STResList145 = [STRes144|STResList144],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLc005.xml','./msxsdtest/attribute',invalid,S144),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes145,S145} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attLc006.xsd','./msxsdtest/attribute',valid),
  STResList146 = [STRes145|STResList145],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attLc006.xml','./msxsdtest/attribute',valid,S145),
  ITResList37 = [ITRes36|ITResList36],


  ?line {STRes146,S146} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMa001.xsd','./msxsdtest/attribute',valid),
  STResList147 = [STRes146|STResList146],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMa001.xml','./msxsdtest/attribute',invalid,S146),
  ITResList38 = [ITRes37|ITResList37],


  ?line {STRes147,S147} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMa002.xsd','./msxsdtest/attribute',valid),
  STResList148 = [STRes147|STResList147],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMa002.xml','./msxsdtest/attribute',invalid,S147),
  ITResList39 = [ITRes38|ITResList38],


  ?line {STRes148,S148} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMa003.xsd','./msxsdtest/attribute',valid),
  STResList149 = [STRes148|STResList148],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMa003.xml','./msxsdtest/attribute',valid,S148),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes149,S149} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMa004.xsd','./msxsdtest/attribute',valid),
  STResList150 = [STRes149|STResList149],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMa004.xml','./msxsdtest/attribute',valid,S149),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes150,S150} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb001.xsd','./msxsdtest/attribute',valid),
  STResList151 = [STRes150|STResList150],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb001.xml','./msxsdtest/attribute',invalid,S150),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes151,S151} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb002.xsd','./msxsdtest/attribute',valid),
  STResList152 = [STRes151|STResList151],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb002.xml','./msxsdtest/attribute',invalid,S151),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes152,S152} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb003.xsd','./msxsdtest/attribute',valid),
  STResList153 = [STRes152|STResList152],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb003.xml','./msxsdtest/attribute',invalid,S152),
  ITResList44 = [ITRes43|ITResList43],


  ?line {STRes153,S153} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb004.xsd','./msxsdtest/attribute',valid),
  STResList154 = [STRes153|STResList153],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb004.xml','./msxsdtest/attribute',valid,S153),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes154,S154} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb005.xsd','./msxsdtest/attribute',valid),
  STResList155 = [STRes154|STResList154],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb005.xml','./msxsdtest/attribute',valid,S154),
  ITResList46 = [ITRes45|ITResList45],


  ?line {STRes155,S155} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb006.xsd','./msxsdtest/attribute',valid),
  STResList156 = [STRes155|STResList155],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb006.xml','./msxsdtest/attribute',valid,S155),
  ITResList47 = [ITRes46|ITResList46],


  ?line {STRes156,S156} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb007.xsd','./msxsdtest/attribute',valid),
  STResList157 = [STRes156|STResList156],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb007.xml','./msxsdtest/attribute',valid,S156),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes157,S157} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb008.xsd','./msxsdtest/attribute',valid),
  STResList158 = [STRes157|STResList157],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb008.xml','./msxsdtest/attribute',valid,S157),
  ITResList49 = [ITRes48|ITResList48],


  ?line {STRes158,S158} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb009.xsd','./msxsdtest/attribute',valid),
  STResList159 = [STRes158|STResList158],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb009.xml','./msxsdtest/attribute',valid,S158),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes159,S159} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb010.xsd','./msxsdtest/attribute',valid),
  STResList160 = [STRes159|STResList159],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb010.xml','./msxsdtest/attribute',invalid,S159),
  ITResList51 = [ITRes50|ITResList50],


  ?line {STRes160,S160} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb011.xsd','./msxsdtest/attribute',valid),
  STResList161 = [STRes160|STResList160],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb011.xml','./msxsdtest/attribute',invalid,S160),
  ITResList52 = [ITRes51|ITResList51],


  ?line {STRes161,S161} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMb012.xsd','./msxsdtest/attribute',valid),
  STResList162 = [STRes161|STResList161],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMb012.xml','./msxsdtest/attribute',invalid,S161),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes162,S162} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc001.xsd','./msxsdtest/attribute',valid),
  STResList163 = [STRes162|STResList162],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc001.xml','./msxsdtest/attribute',invalid,S162),
  ITResList54 = [ITRes53|ITResList53],


  ?line {STRes163,S163} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc002.xsd','./msxsdtest/attribute',valid),
  STResList164 = [STRes163|STResList163],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc002.xml','./msxsdtest/attribute',invalid,S163),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes164,S164} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc003.xsd','./msxsdtest/attribute',valid),
  STResList165 = [STRes164|STResList164],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc003.xml','./msxsdtest/attribute',invalid,S164),
  ITResList56 = [ITRes55|ITResList55],


  ?line {STRes165,S165} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc004.xsd','./msxsdtest/attribute',valid),
  STResList166 = [STRes165|STResList165],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc004.xml','./msxsdtest/attribute',valid,S165),
  ITResList57 = [ITRes56|ITResList56],


  ?line {STRes166,S166} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc005.xsd','./msxsdtest/attribute',valid),
  STResList167 = [STRes166|STResList166],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc005.xml','./msxsdtest/attribute',valid,S166),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes167,S167} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc006.xsd','./msxsdtest/attribute',valid),
  STResList168 = [STRes167|STResList167],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc006.xml','./msxsdtest/attribute',valid,S167),
  ITResList59 = [ITRes58|ITResList58],


  ?line {STRes168,S168} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc007.xsd','./msxsdtest/attribute',valid),
  STResList169 = [STRes168|STResList168],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc007.xml','./msxsdtest/attribute',valid,S168),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes169,S169} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc008.xsd','./msxsdtest/attribute',valid),
  STResList170 = [STRes169|STResList169],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc008.xml','./msxsdtest/attribute',valid,S169),
  ITResList61 = [ITRes60|ITResList60],


  ?line {STRes170,S170} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc009.xsd','./msxsdtest/attribute',valid),
  STResList171 = [STRes170|STResList170],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc009.xml','./msxsdtest/attribute',valid,S170),
  ITResList62 = [ITRes61|ITResList61],


  ?line {STRes171,S171} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc010.xsd','./msxsdtest/attribute',valid),
  STResList172 = [STRes171|STResList171],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc010.xml','./msxsdtest/attribute',invalid,S171),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes172,S172} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc011.xsd','./msxsdtest/attribute',valid),
  STResList173 = [STRes172|STResList172],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc011.xml','./msxsdtest/attribute',invalid,S172),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes173,S173} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attMc012.xsd','./msxsdtest/attribute',valid),
  STResList174 = [STRes173|STResList173],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attMc012.xml','./msxsdtest/attribute',invalid,S173),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes174,S174} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO001.xsd','./msxsdtest/attribute',valid),
  STResList175 = [STRes174|STResList174],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attO001.xml','./msxsdtest/attribute',invalid,S174),
  ITResList66 = [ITRes65|ITResList65],


  ?line {STRes175,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO002.xsd','./msxsdtest/attribute',invalid),
  STResList176 = [STRes175|STResList175],


  ?line {STRes176,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO003.xsd','./msxsdtest/attribute',invalid),
  STResList177 = [STRes176|STResList176],


  ?line {STRes177,S177} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO004.xsd','./msxsdtest/attribute',valid),
  STResList178 = [STRes177|STResList177],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attO004.xml','./msxsdtest/attribute',invalid,S177),
  ITResList67 = [ITRes66|ITResList66],


  ?line {STRes178,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO005.xsd','./msxsdtest/attribute',invalid),
  STResList179 = [STRes178|STResList178],


  ?line {STRes179,S179} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO006.xsd','./msxsdtest/attribute',valid),
  STResList180 = [STRes179|STResList179],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attO006.xml','./msxsdtest/attribute',valid,S179),
  ITResList68 = [ITRes67|ITResList67],


  ?line {STRes180,S180} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO007.xsd','./msxsdtest/attribute',valid),
  STResList181 = [STRes180|STResList180],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attO007.xml','./msxsdtest/attribute',valid,S180),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes181,S181} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO008.xsd','./msxsdtest/attribute',valid),
  STResList182 = [STRes181|STResList181],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attO008.xml','./msxsdtest/attribute',invalid,S181),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes182,S182} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO009.xsd','./msxsdtest/attribute',valid),
  STResList183 = [STRes182|STResList182],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attO009.xml','./msxsdtest/attribute',valid,S182),
  ITResList71 = [ITRes70|ITResList70],


  ?line {STRes183,S183} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO010.xsd','./msxsdtest/attribute',valid),
  STResList184 = [STRes183|STResList183],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attO010.xml','./msxsdtest/attribute',valid,S183),
  ITResList72 = [ITRes71|ITResList71],


  ?line {STRes184,S184} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO011.xsd','./msxsdtest/attribute',valid),
  STResList185 = [STRes184|STResList184],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attO011.xml','./msxsdtest/attribute',valid,S184),
  ITResList73 = [ITRes72|ITResList72],


  ?line {STRes185,S185} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO012.xsd','./msxsdtest/attribute',valid),
  STResList186 = [STRes185|STResList185],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attO012.xml','./msxsdtest/attribute',invalid,S185),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes186,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO013.xsd','./msxsdtest/attribute',invalid),
  STResList187 = [STRes186|STResList186],


  ?line {STRes187,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO014.xsd','./msxsdtest/attribute',invalid),
  STResList188 = [STRes187|STResList187],


  ?line {STRes188,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO015.xsd','./msxsdtest/attribute',invalid),
  STResList189 = [STRes188|STResList188],


  ?line {STRes189,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO016.xsd','./msxsdtest/attribute',invalid),
  STResList190 = [STRes189|STResList189],


  ?line {STRes190,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO017.xsd','./msxsdtest/attribute',invalid),
  STResList191 = [STRes190|STResList190],


  ?line {STRes191,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO018.xsd','./msxsdtest/attribute',valid),
  STResList192 = [STRes191|STResList191],


  ?line {STRes192,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO019.xsd','./msxsdtest/attribute',invalid),
  STResList193 = [STRes192|STResList192],


  ?line {STRes193,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO020.xsd','./msxsdtest/attribute',invalid),
  STResList194 = [STRes193|STResList193],


  ?line {STRes194,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO021.xsd','./msxsdtest/attribute',invalid),
  STResList195 = [STRes194|STResList194],


  ?line {STRes195,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO022.xsd','./msxsdtest/attribute',invalid),
  STResList196 = [STRes195|STResList195],


  ?line {STRes196,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO023.xsd','./msxsdtest/attribute',invalid),
  STResList197 = [STRes196|STResList196],


  ?line {STRes197,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO024.xsd','./msxsdtest/attribute',invalid),
  STResList198 = [STRes197|STResList197],


  ?line {STRes198,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attO025.xsd','./msxsdtest/attribute',valid),
  STResList199 = [STRes198|STResList198],


  ?line {STRes199,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP001.xsd','./msxsdtest/attribute',invalid),
  STResList200 = [STRes199|STResList199],


  ?line {STRes200,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP002.xsd','./msxsdtest/attribute',invalid),
  STResList201 = [STRes200|STResList200],


  ?line {STRes201,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP003.xsd','./msxsdtest/attribute',invalid),
  STResList202 = [STRes201|STResList201],


  ?line {STRes202,S202} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP004.xsd','./msxsdtest/attribute',valid),
  STResList203 = [STRes202|STResList202],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP004.xml','./msxsdtest/attribute',valid,S202),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes203,S203} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP005.xsd','./msxsdtest/attribute',valid),
  STResList204 = [STRes203|STResList203],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP005.xml','./msxsdtest/attribute',invalid,S203),
  ITResList76 = [ITRes75|ITResList75],


  ?line {STRes204,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP006.xsd','./msxsdtest/attribute',invalid),
  STResList205 = [STRes204|STResList204],


  ?line {STRes205,S205} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP007.xsd','./msxsdtest/attribute',valid),
  STResList206 = [STRes205|STResList205],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP007.xml','./msxsdtest/attribute',valid,S205),
  ITResList77 = [ITRes76|ITResList76],


  ?line {STRes206,S206} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP008.xsd','./msxsdtest/attribute',valid),
  STResList207 = [STRes206|STResList206],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP008.xml','./msxsdtest/attribute',invalid,S206),
  ITResList78 = [ITRes77|ITResList77],


  ?line {STRes207,S207} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP009.xsd','./msxsdtest/attribute',valid),
  STResList208 = [STRes207|STResList207],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP009.xml','./msxsdtest/attribute',valid,S207),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes208,S208} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP010.xsd','./msxsdtest/attribute',valid),
  STResList209 = [STRes208|STResList208],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP010.xml','./msxsdtest/attribute',invalid,S208),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes209,S209} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP011.xsd','./msxsdtest/attribute',valid),
  STResList210 = [STRes209|STResList209],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP011.xml','./msxsdtest/attribute',valid,S209),
  ITResList81 = [ITRes80|ITResList80],


  ?line {STRes210,S210} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP012.xsd','./msxsdtest/attribute',valid),
  STResList211 = [STRes210|STResList210],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP012.xml','./msxsdtest/attribute',invalid,S210),
  ITResList82 = [ITRes81|ITResList81],


  ?line {STRes211,S211} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP013.xsd','./msxsdtest/attribute',valid),
  STResList212 = [STRes211|STResList211],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP013.xml','./msxsdtest/attribute',valid,S211),
  ITResList83 = [ITRes82|ITResList82],


  ?line {STRes212,S212} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP014.xsd','./msxsdtest/attribute',valid),
  STResList213 = [STRes212|STResList212],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP014.xml','./msxsdtest/attribute',invalid,S212),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes213,S213} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP015.xsd','./msxsdtest/attribute',valid),
  STResList214 = [STRes213|STResList213],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP015.xml','./msxsdtest/attribute',valid,S213),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes214,S214} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP016.xsd','./msxsdtest/attribute',valid),
  STResList215 = [STRes214|STResList214],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP016.xml','./msxsdtest/attribute',invalid,S214),
  ITResList86 = [ITRes85|ITResList85],


  ?line {STRes215,S215} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP017.xsd','./msxsdtest/attribute',valid),
  STResList216 = [STRes215|STResList215],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP017.xml','./msxsdtest/attribute',valid,S215),
  ITResList87 = [ITRes86|ITResList86],


  ?line {STRes216,S216} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP018.xsd','./msxsdtest/attribute',valid),
  STResList217 = [STRes216|STResList216],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP018.xml','./msxsdtest/attribute',invalid,S216),
  ITResList88 = [ITRes87|ITResList87],


  ?line {STRes217,S217} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP019.xsd','./msxsdtest/attribute',valid),
  STResList218 = [STRes217|STResList217],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP019.xml','./msxsdtest/attribute',valid,S217),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes218,S218} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP020.xsd','./msxsdtest/attribute',valid),
  STResList219 = [STRes218|STResList218],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP020.xml','./msxsdtest/attribute',invalid,S218),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes219,S219} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP021.xsd','./msxsdtest/attribute',valid),
  STResList220 = [STRes219|STResList219],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP021.xml','./msxsdtest/attribute',valid,S219),
  ITResList91 = [ITRes90|ITResList90],


  ?line {STRes220,S220} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP022.xsd','./msxsdtest/attribute',valid),
  STResList221 = [STRes220|STResList220],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP022.xml','./msxsdtest/attribute',valid,S220),
  ITResList92 = [ITRes91|ITResList91],


  ?line {STRes221,S221} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP023.xsd','./msxsdtest/attribute',valid),
  STResList222 = [STRes221|STResList221],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP023.xml','./msxsdtest/attribute',valid,S221),
  ITResList93 = [ITRes92|ITResList92],


  ?line {STRes222,S222} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP024.xsd','./msxsdtest/attribute',valid),
  STResList223 = [STRes222|STResList222],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP024.xml','./msxsdtest/attribute',valid,S222),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes223,S223} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP025.xsd','./msxsdtest/attribute',valid),
  STResList224 = [STRes223|STResList223],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP025.xml','./msxsdtest/attribute',valid,S223),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes224,S224} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP026.xsd','./msxsdtest/attribute',valid),
  STResList225 = [STRes224|STResList224],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP026.xml','./msxsdtest/attribute',valid,S224),
  ITResList96 = [ITRes95|ITResList95],


  ?line {STRes225,S225} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP027.xsd','./msxsdtest/attribute',valid),
  STResList226 = [STRes225|STResList225],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP027.xml','./msxsdtest/attribute',invalid,S225),
  ITResList97 = [ITRes96|ITResList96],


  ?line {STRes226,S226} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP028.xsd','./msxsdtest/attribute',valid),
  STResList227 = [STRes226|STResList226],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP028.xml','./msxsdtest/attribute',valid,S226),
  ITResList98 = [ITRes97|ITResList97],


  ?line {STRes227,S227} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP029.xsd','./msxsdtest/attribute',valid),
  STResList228 = [STRes227|STResList227],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP029.xml','./msxsdtest/attribute',valid,S227),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes228,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP030.xsd','./msxsdtest/attribute',invalid),
  STResList229 = [STRes228|STResList228],


  ?line {STRes229,S229} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP031.xsd','./msxsdtest/attribute',valid),
  STResList230 = [STRes229|STResList229],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP031.xml','./msxsdtest/attribute',invalid,S229),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes230,S230} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attP032.xsd','./msxsdtest/attribute',valid),
  STResList231 = [STRes230|STResList230],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attP032.xml','./msxsdtest/attribute',valid,S230),
  ITResList101 = [ITRes100|ITResList100],


  ?line {STRes231,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ001.xsd','./msxsdtest/attribute',invalid),
  STResList232 = [STRes231|STResList231],


  ?line {STRes232,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ002.xsd','./msxsdtest/attribute',invalid),
  STResList233 = [STRes232|STResList232],


  ?line {STRes233,S233} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ003.xsd','./msxsdtest/attribute',valid),
  STResList234 = [STRes233|STResList233],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attQ003.xml','./msxsdtest/attribute',valid,S233),
  ITResList102 = [ITRes101|ITResList101],


  ?line {STRes234,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ004.xsd','./msxsdtest/attribute',invalid),
  STResList235 = [STRes234|STResList234],


  ?line {STRes235,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ005.xsd','./msxsdtest/attribute',invalid),
  STResList236 = [STRes235|STResList235],


  ?line {STRes236,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ006.xsd','./msxsdtest/attribute',invalid),
  STResList237 = [STRes236|STResList236],


  ?line {STRes237,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ007.xsd','./msxsdtest/attribute',invalid),
  STResList238 = [STRes237|STResList237],


  ?line {STRes238,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ008.xsd','./msxsdtest/attribute',invalid),
  STResList239 = [STRes238|STResList238],


  ?line {STRes239,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ009.xsd','./msxsdtest/attribute',invalid),
  STResList240 = [STRes239|STResList239],


  ?line {STRes240,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ010.xsd','./msxsdtest/attribute',valid),
  STResList241 = [STRes240|STResList240],


  ?line {STRes241,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ011.xsd','./msxsdtest/attribute',invalid),
  STResList242 = [STRes241|STResList241],


  ?line {STRes242,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ012.xsd','./msxsdtest/attribute',invalid),
  STResList243 = [STRes242|STResList242],


  ?line {STRes243,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ013.xsd','./msxsdtest/attribute',invalid),
  STResList244 = [STRes243|STResList243],


  ?line {STRes244,S244} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ014.xsd','./msxsdtest/attribute',valid),
  STResList245 = [STRes244|STResList244],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attQ014.xml','./msxsdtest/attribute',valid,S244),
  ITResList103 = [ITRes102|ITResList102],


  ?line {STRes245,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ015.xsd','./msxsdtest/attribute',invalid),
  STResList246 = [STRes245|STResList245],


  ?line {STRes246,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ016.xsd','./msxsdtest/attribute',invalid),
  STResList247 = [STRes246|STResList246],


  ?line {STRes247,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ017.xsd','./msxsdtest/attribute',invalid),
  STResList248 = [STRes247|STResList247],


  ?line {STRes248,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ018.xsd','./msxsdtest/attribute',invalid),
  STResList249 = [STRes248|STResList248],


  ?line {STRes249,S249} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attQ019.xsd','./msxsdtest/attribute',valid),
  STResList250 = [STRes249|STResList249],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attQ019.xml','./msxsdtest/attribute',valid,S249),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes250,S250} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attZ001.xsd','./msxsdtest/attribute',valid),
  STResList251 = [STRes250|STResList250],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attZ001.xml','./msxsdtest/attribute',invalid,S250),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes251,S251} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attZ002.xsd','./msxsdtest/attribute',valid),
  STResList252 = [STRes251|STResList251],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attZ002.xml','./msxsdtest/attribute',invalid,S251),
  ITResList106 = [ITRes105|ITResList105],


  ?line {STRes252,S252} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attribute/attZ003.xsd','./msxsdtest/attribute',valid),
  STResList253 = [STRes252|STResList252],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attribute/attZ003.xml','./msxsdtest/attribute',invalid,S252),
  ITResList107 = [ITRes106|ITResList106],


  ?line {STRes253,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgA001.xsd','./msxsdtest/attributeGroup',valid),
  STResList254 = [STRes253|STResList253],


  ?line {STRes254,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgA002.xsd','./msxsdtest/attributeGroup',invalid),
  STResList255 = [STRes254|STResList254],


  ?line {STRes255,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgA003.xsd','./msxsdtest/attributeGroup',invalid),
  STResList256 = [STRes255|STResList255],


  ?line {STRes256,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgA004.xsd','./msxsdtest/attributeGroup',invalid),
  STResList257 = [STRes256|STResList256],


  ?line {STRes257,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgA005.xsd','./msxsdtest/attributeGroup',invalid),
  STResList258 = [STRes257|STResList257],


  ?line {STRes258,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgA006.xsd','./msxsdtest/attributeGroup',invalid),
  STResList259 = [STRes258|STResList258],


  ?line {STRes259,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgA007.xsd','./msxsdtest/attributeGroup',invalid),
  STResList260 = [STRes259|STResList259],


  ?line {STRes260,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgA008.xsd','./msxsdtest/attributeGroup',invalid),
  STResList261 = [STRes260|STResList260],


  ?line {STRes261,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgA009.xsd','./msxsdtest/attributeGroup',invalid),
  STResList262 = [STRes261|STResList261],


  ?line {STRes262,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB001.xsd','./msxsdtest/attributeGroup',valid),
  STResList263 = [STRes262|STResList262],


  ?line {STRes263,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB002.xsd','./msxsdtest/attributeGroup',invalid),
  STResList264 = [STRes263|STResList263],


  ?line {STRes264,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB003.xsd','./msxsdtest/attributeGroup',invalid),
  STResList265 = [STRes264|STResList264],


  ?line {STRes265,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB004.xsd','./msxsdtest/attributeGroup',invalid),
  STResList266 = [STRes265|STResList265],


  ?line {STRes266,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB005.xsd','./msxsdtest/attributeGroup',valid),
  STResList267 = [STRes266|STResList266],


  ?line {STRes267,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB006.xsd','./msxsdtest/attributeGroup',invalid),
  STResList268 = [STRes267|STResList267],


  ?line {STRes268,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB007.xsd','./msxsdtest/attributeGroup',invalid),
  STResList269 = [STRes268|STResList268],


  ?line {STRes269,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB008.xsd','./msxsdtest/attributeGroup',valid),
  STResList270 = [STRes269|STResList269],


  ?line {STRes270,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB009.xsd','./msxsdtest/attributeGroup',valid),
  STResList271 = [STRes270|STResList270],


  ?line {STRes271,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB010.xsd','./msxsdtest/attributeGroup',invalid),
  STResList272 = [STRes271|STResList271],


  ?line {STRes272,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB011.xsd','./msxsdtest/attributeGroup',invalid),
  STResList273 = [STRes272|STResList272],


  ?line {STRes273,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB012.xsd','./msxsdtest/attributeGroup',valid),
  STResList274 = [STRes273|STResList273],


  ?line {STRes274,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB013.xsd','./msxsdtest/attributeGroup',invalid),
  STResList275 = [STRes274|STResList274],


  ?line {STRes275,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB014.xsd','./msxsdtest/attributeGroup',valid),
  STResList276 = [STRes275|STResList275],


  ?line {STRes276,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgB015.xsd','./msxsdtest/attributeGroup',invalid),
  STResList277 = [STRes276|STResList276],


  ?line {STRes277,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC001.xsd','./msxsdtest/attributeGroup',invalid),
  STResList278 = [STRes277|STResList277],


  ?line {STRes278,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC002.xsd','./msxsdtest/attributeGroup',valid),
  STResList279 = [STRes278|STResList278],


  ?line {STRes279,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC003.xsd','./msxsdtest/attributeGroup',valid),
  STResList280 = [STRes279|STResList279],


  ?line {STRes280,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC004.xsd','./msxsdtest/attributeGroup',valid),
  STResList281 = [STRes280|STResList280],


  ?line {STRes281,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC005.xsd','./msxsdtest/attributeGroup',valid),
  STResList282 = [STRes281|STResList281],


  ?line {STRes282,S282} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC006.xsd','./msxsdtest/attributeGroup',valid),
  STResList283 = [STRes282|STResList282],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC006.xml','./msxsdtest/attributeGroup',invalid,S282),
  ITResList108 = [ITRes107|ITResList107],


  ?line {STRes283,S283} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC007.xsd','./msxsdtest/attributeGroup',valid),
  STResList284 = [STRes283|STResList283],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC007.xml','./msxsdtest/attributeGroup',valid,S283),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes284,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC008.xsd','./msxsdtest/attributeGroup',invalid),
  STResList285 = [STRes284|STResList284],


  ?line {STRes285,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC009.xsd','./msxsdtest/attributeGroup',invalid),
  STResList286 = [STRes285|STResList285],


  ?line {STRes286,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC010.xsd','./msxsdtest/attributeGroup',invalid),
  STResList287 = [STRes286|STResList286],


  ?line {STRes287,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC011.xsd','./msxsdtest/attributeGroup',invalid),
  STResList288 = [STRes287|STResList287],


  ?line {STRes288,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC012.xsd','./msxsdtest/attributeGroup',valid),
  STResList289 = [STRes288|STResList288],


  ?line {STRes289,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC013.xsd','./msxsdtest/attributeGroup',valid),
  STResList290 = [STRes289|STResList289],


  ?line {STRes290,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC014.xsd','./msxsdtest/attributeGroup',valid),
  STResList291 = [STRes290|STResList290],


  ?line {STRes291,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC015.xsd','./msxsdtest/attributeGroup',valid),
  STResList292 = [STRes291|STResList291],


  ?line {STRes292,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC016.xsd','./msxsdtest/attributeGroup',valid),
  STResList293 = [STRes292|STResList292],


  ?line {STRes293,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC017.xsd','./msxsdtest/attributeGroup',valid),
  STResList294 = [STRes293|STResList293],


  ?line {STRes294,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC018.xsd','./msxsdtest/attributeGroup',invalid),
  STResList295 = [STRes294|STResList294],


  ?line {STRes295,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC019.xsd','./msxsdtest/attributeGroup',invalid),
  STResList296 = [STRes295|STResList295],


  ?line {STRes296,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC020.xsd','./msxsdtest/attributeGroup',invalid),
  STResList297 = [STRes296|STResList296],


  ?line {STRes297,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC021.xsd','./msxsdtest/attributeGroup',invalid),
  STResList298 = [STRes297|STResList297],


  ?line {STRes298,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC022.xsd','./msxsdtest/attributeGroup',valid),
  STResList299 = [STRes298|STResList298],


  ?line {STRes299,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC023.xsd','./msxsdtest/attributeGroup',valid),
  STResList300 = [STRes299|STResList299],


  ?line {STRes300,S300} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC024.xsd','./msxsdtest/attributeGroup',valid),
  STResList301 = [STRes300|STResList300],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC024.xml','./msxsdtest/attributeGroup',valid,S300),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes301,S301} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC025.xsd','./msxsdtest/attributeGroup',valid),
  STResList302 = [STRes301|STResList301],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC025.xml','./msxsdtest/attributeGroup',invalid,S301),
  ITResList111 = [ITRes110|ITResList110],


  ?line {STRes302,S302} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC026.xsd','./msxsdtest/attributeGroup',valid),
  STResList303 = [STRes302|STResList302],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC026.xml','./msxsdtest/attributeGroup',valid,S302),
  ITResList112 = [ITRes111|ITResList111],


  ?line {STRes303,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC027.xsd','./msxsdtest/attributeGroup',valid),
  STResList304 = [STRes303|STResList303],


  ?line {STRes304,S304} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC028.xsd','./msxsdtest/attributeGroup',valid),
  STResList305 = [STRes304|STResList304],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC028.xml','./msxsdtest/attributeGroup',invalid,S304),
  ITResList113 = [ITRes112|ITResList112],


  ?line {STRes305,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC029.xsd','./msxsdtest/attributeGroup',invalid),
  STResList306 = [STRes305|STResList305],


  ?line {STRes306,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC030.xsd','./msxsdtest/attributeGroup',invalid),
  STResList307 = [STRes306|STResList306],


  ?line {STRes307,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC031.xsd','./msxsdtest/attributeGroup',invalid),
  STResList308 = [STRes307|STResList307],


  ?line {STRes308,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC032.xsd','./msxsdtest/attributeGroup',invalid),
  STResList309 = [STRes308|STResList308],


  ?line {STRes309,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC033.xsd','./msxsdtest/attributeGroup',valid),
  STResList310 = [STRes309|STResList309],


  ?line {STRes310,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC034.xsd','./msxsdtest/attributeGroup',valid),
  STResList311 = [STRes310|STResList310],


  ?line {STRes311,S311} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC035.xsd','./msxsdtest/attributeGroup',valid),
  STResList312 = [STRes311|STResList311],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC035.xml','./msxsdtest/attributeGroup',valid,S311),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes312,S312} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC036.xsd','./msxsdtest/attributeGroup',valid),
  STResList313 = [STRes312|STResList312],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC036.xml','./msxsdtest/attributeGroup',valid,S312),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes313,S313} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC037.xsd','./msxsdtest/attributeGroup',valid),
  STResList314 = [STRes313|STResList313],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC037.xml','./msxsdtest/attributeGroup',valid,S313),
  ITResList116 = [ITRes115|ITResList115],


  ?line {STRes314,S314} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC038.xsd','./msxsdtest/attributeGroup',valid),
  STResList315 = [STRes314|STResList314],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgC038.xml','./msxsdtest/attributeGroup',valid,S314),
  ITResList117 = [ITRes116|ITResList116],


  ?line {STRes315,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC039.xsd','./msxsdtest/attributeGroup',invalid),
  STResList316 = [STRes315|STResList315],


  ?line {STRes316,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC040.xsd','./msxsdtest/attributeGroup',invalid),
  STResList317 = [STRes316|STResList316],


  ?line {STRes317,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC041.xsd','./msxsdtest/attributeGroup',valid),
  STResList318 = [STRes317|STResList317],


  ?line {STRes318,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC042.xsd','./msxsdtest/attributeGroup',invalid),
  STResList319 = [STRes318|STResList318],


  ?line {STRes319,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC043.xsd','./msxsdtest/attributeGroup',valid),
  STResList320 = [STRes319|STResList319],


  ?line {STRes320,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC044.xsd','./msxsdtest/attributeGroup',invalid),
  STResList321 = [STRes320|STResList320],


  ?line {STRes321,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgC045.xsd','./msxsdtest/attributeGroup',valid),
  STResList322 = [STRes321|STResList321],


  ?line {STRes322,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD001.xsd','./msxsdtest/attributeGroup',valid),
  STResList323 = [STRes322|STResList322],


  ?line {STRes323,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD002.xsd','./msxsdtest/attributeGroup',invalid),
  STResList324 = [STRes323|STResList323],


  ?line {STRes324,S324} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD003.xsd','./msxsdtest/attributeGroup',valid),
  STResList325 = [STRes324|STResList324],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD003.xml','./msxsdtest/attributeGroup',valid,S324),
  ITResList118 = [ITRes117|ITResList117],


  ?line {STRes325,S325} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD004.xsd','./msxsdtest/attributeGroup',valid),
  STResList326 = [STRes325|STResList325],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD004.xml','./msxsdtest/attributeGroup',valid,S325),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes326,S326} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD005.xsd','./msxsdtest/attributeGroup',valid),
  STResList327 = [STRes326|STResList326],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD005.xml','./msxsdtest/attributeGroup',valid,S326),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes327,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD006.xsd','./msxsdtest/attributeGroup',invalid),
  STResList328 = [STRes327|STResList327],


  ?line {STRes328,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD007.xsd','./msxsdtest/attributeGroup',invalid),
  STResList329 = [STRes328|STResList328],


  ?line {STRes329,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD008.xsd','./msxsdtest/attributeGroup',invalid),
  STResList330 = [STRes329|STResList329],


  ?line {STRes330,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD009.xsd','./msxsdtest/attributeGroup',invalid),
  STResList331 = [STRes330|STResList330],


  ?line {STRes331,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD010.xsd','./msxsdtest/attributeGroup',valid),
  STResList332 = [STRes331|STResList331],


  ?line {STRes332,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD011.xsd','./msxsdtest/attributeGroup',invalid),
  STResList333 = [STRes332|STResList332],


  ?line {STRes333,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD012.xsd','./msxsdtest/attributeGroup',invalid),
  STResList334 = [STRes333|STResList333],


  ?line {STRes334,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD013.xsd','./msxsdtest/attributeGroup',invalid),
  STResList335 = [STRes334|STResList334],


  ?line {STRes335,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD014.xsd','./msxsdtest/attributeGroup',invalid),
  STResList336 = [STRes335|STResList335],


  ?line {STRes336,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD015.xsd','./msxsdtest/attributeGroup',invalid),
  STResList337 = [STRes336|STResList336],


  ?line {STRes337,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD016.xsd','./msxsdtest/attributeGroup',invalid),
  STResList338 = [STRes337|STResList337],


  ?line {STRes338,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD017.xsd','./msxsdtest/attributeGroup',invalid),
  STResList339 = [STRes338|STResList338],


  ?line {STRes339,S339} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD018.xsd','./msxsdtest/attributeGroup',valid),
  STResList340 = [STRes339|STResList339],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD018.xml','./msxsdtest/attributeGroup',valid,S339),
  ITResList121 = [ITRes120|ITResList120],


  ?line {STRes340,S340} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD019.xsd','./msxsdtest/attributeGroup',valid),
  STResList341 = [STRes340|STResList340],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD019.xml','./msxsdtest/attributeGroup',valid,S340),
  ITResList122 = [ITRes121|ITResList121],


  ?line {STRes341,S341} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD020.xsd','./msxsdtest/attributeGroup',valid),
  STResList342 = [STRes341|STResList341],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD020.xml','./msxsdtest/attributeGroup',valid,S341),
  ITResList123 = [ITRes122|ITResList122],


  ?line {STRes342,S342} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD021.xsd','./msxsdtest/attributeGroup',valid),
  STResList343 = [STRes342|STResList342],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD021.xml','./msxsdtest/attributeGroup',valid,S342),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes343,S343} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD022.xsd','./msxsdtest/attributeGroup',valid),
  STResList344 = [STRes343|STResList343],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD022.xml','./msxsdtest/attributeGroup',valid,S343),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes344,S344} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD023.xsd','./msxsdtest/attributeGroup',valid),
  STResList345 = [STRes344|STResList344],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD023.xml','./msxsdtest/attributeGroup',invalid,S344),
  ITResList126 = [ITRes125|ITResList125],


  ?line {STRes345,S345} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD024.xsd','./msxsdtest/attributeGroup',valid),
  STResList346 = [STRes345|STResList345],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD024.xml','./msxsdtest/attributeGroup',invalid,S345),
  ITResList127 = [ITRes126|ITResList126],


  ?line {STRes346,S346} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD025.xsd','./msxsdtest/attributeGroup',valid),
  STResList347 = [STRes346|STResList346],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD025.xml','./msxsdtest/attributeGroup',valid,S346),
  ITResList128 = [ITRes127|ITResList127],


  ?line {STRes347,S347} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD026.xsd','./msxsdtest/attributeGroup',valid),
  STResList348 = [STRes347|STResList347],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD026.xml','./msxsdtest/attributeGroup',invalid,S347),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes348,S348} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD027.xsd','./msxsdtest/attributeGroup',valid),
  STResList349 = [STRes348|STResList348],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD027.xml','./msxsdtest/attributeGroup',valid,S348),
  ITResList130 = [ITRes129|ITResList129],


  ?line {STRes349,S349} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD028.xsd','./msxsdtest/attributeGroup',valid),
  STResList350 = [STRes349|STResList349],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD028.xml','./msxsdtest/attributeGroup',invalid,S349),
  ITResList131 = [ITRes130|ITResList130],


  ?line {STRes350,S350} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD029.xsd','./msxsdtest/attributeGroup',valid),
  STResList351 = [STRes350|STResList350],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD029.xml','./msxsdtest/attributeGroup',valid,S350),
  ITResList132 = [ITRes131|ITResList131],


  ?line {STRes351,S351} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD030.xsd','./msxsdtest/attributeGroup',valid),
  STResList352 = [STRes351|STResList351],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD030.xml','./msxsdtest/attributeGroup',invalid,S351),
  ITResList133 = [ITRes132|ITResList132],


  ?line {STRes352,S352} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD031.xsd','./msxsdtest/attributeGroup',valid),
  STResList353 = [STRes352|STResList352],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD031.xml','./msxsdtest/attributeGroup',valid,S352),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes353,S353} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD032.xsd','./msxsdtest/attributeGroup',valid),
  STResList354 = [STRes353|STResList353],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD032.xml','./msxsdtest/attributeGroup',valid,S353),
  ITResList135 = [ITRes134|ITResList134],


  ?line {STRes354,S354} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD033.xsd','./msxsdtest/attributeGroup',valid),
  STResList355 = [STRes354|STResList354],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD033.xml','./msxsdtest/attributeGroup',valid,S354),
  ITResList136 = [ITRes135|ITResList135],


  ?line {STRes355,S355} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD034.xsd','./msxsdtest/attributeGroup',valid),
  STResList356 = [STRes355|STResList355],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD034.xml','./msxsdtest/attributeGroup',valid,S355),
  ITResList137 = [ITRes136|ITResList136],


  ?line {STRes356,S356} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD035.xsd','./msxsdtest/attributeGroup',valid),
  STResList357 = [STRes356|STResList356],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD035.xml','./msxsdtest/attributeGroup',invalid,S356),
  ITResList138 = [ITRes137|ITResList137],


  ?line {STRes357,S357} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD036.xsd','./msxsdtest/attributeGroup',valid),
  STResList358 = [STRes357|STResList357],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD036.xml','./msxsdtest/attributeGroup',valid,S357),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes358,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD037.xsd','./msxsdtest/attributeGroup',invalid),
  STResList359 = [STRes358|STResList358],


  ?line {STRes359,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD038.xsd','./msxsdtest/attributeGroup',invalid),
  STResList360 = [STRes359|STResList359],


  ?line {STRes360,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD039.xsd','./msxsdtest/attributeGroup',invalid),
  STResList361 = [STRes360|STResList360],


  ?line {STRes361,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD040.xsd','./msxsdtest/attributeGroup',valid),
  STResList362 = [STRes361|STResList361],


  ?line {STRes362,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD041.xsd','./msxsdtest/attributeGroup',invalid),
  STResList363 = [STRes362|STResList362],


  ?line {STRes363,S363} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/attributeGroup/attgD042.xsd','./msxsdtest/attributeGroup',valid),
  STResList364 = [STRes363|STResList363],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/attributeGroup/attgD042.xml','./msxsdtest/attributeGroup',invalid,S363),
  ITResList140 = [ITRes139|ITResList139],


  xmerl_xsd_lib:compare_test_results(Config,STResList364,ITResList140).

%% Syntax Checking for top level complexType Declaration.
%% Syntax Checking for simpleContent complexType Declaration.
%% Syntax Checking for comlexContent complexType Declaration
%% complexType Validation checking
%% complexType Schema Component Constraints

ct(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA001.xsd','./msxsdtest/complexType',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA001.xml','./msxsdtest/complexType',valid,S0),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA002.xsd','./msxsdtest/complexType',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA002.xml','./msxsdtest/complexType',valid,S1),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA003.xsd','./msxsdtest/complexType',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA003.xml','./msxsdtest/complexType',valid,S2),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes3,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA004.xsd','./msxsdtest/complexType',invalid),
  STResList4 = [STRes3|STResList3],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA005.xsd','./msxsdtest/complexType',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA005.xml','./msxsdtest/complexType',valid,S4),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes5,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA006.xsd','./msxsdtest/complexType',invalid),
  STResList6 = [STRes5|STResList5],


  ?line {STRes6,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA007.xsd','./msxsdtest/complexType',invalid),
  STResList7 = [STRes6|STResList6],


  ?line {STRes7,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA008.xsd','./msxsdtest/complexType',invalid),
  STResList8 = [STRes7|STResList7],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA009.xsd','./msxsdtest/complexType',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA009.xml','./msxsdtest/complexType',valid,S8),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA010.xsd','./msxsdtest/complexType',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA010.xml','./msxsdtest/complexType',valid,S9),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA011.xsd','./msxsdtest/complexType',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA011.xml','./msxsdtest/complexType',valid,S10),
  ITResList7 = [ITRes6|ITResList6],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA012.xsd','./msxsdtest/complexType',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA012.xml','./msxsdtest/complexType',valid,S11),
  ITResList8 = [ITRes7|ITResList7],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA013.xsd','./msxsdtest/complexType',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA013.xml','./msxsdtest/complexType',valid,S12),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes13,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA014.xsd','./msxsdtest/complexType',invalid),
  STResList14 = [STRes13|STResList13],


  ?line {STRes14,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA015.xsd','./msxsdtest/complexType',invalid),
  STResList15 = [STRes14|STResList14],


  ?line {STRes15,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA016.xsd','./msxsdtest/complexType',invalid),
  STResList16 = [STRes15|STResList15],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA017.xsd','./msxsdtest/complexType',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA017.xml','./msxsdtest/complexType',valid,S16),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA018.xsd','./msxsdtest/complexType',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA018.xml','./msxsdtest/complexType',valid,S17),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA019.xsd','./msxsdtest/complexType',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA019.xml','./msxsdtest/complexType',valid,S18),
  ITResList12 = [ITRes11|ITResList11],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA020.xsd','./msxsdtest/complexType',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA020.xml','./msxsdtest/complexType',valid,S19),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA021.xsd','./msxsdtest/complexType',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA021.xml','./msxsdtest/complexType',valid,S20),
  ITResList14 = [ITRes13|ITResList13],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA022.xsd','./msxsdtest/complexType',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA022.xml','./msxsdtest/complexType',valid,S21),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes22,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA023.xsd','./msxsdtest/complexType',invalid),
  STResList23 = [STRes22|STResList22],


  ?line {STRes23,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA024.xsd','./msxsdtest/complexType',invalid),
  STResList24 = [STRes23|STResList23],


  ?line {STRes24,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA025.xsd','./msxsdtest/complexType',invalid),
  STResList25 = [STRes24|STResList24],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA026.xsd','./msxsdtest/complexType',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA026.xml','./msxsdtest/complexType',valid,S25),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA027.xsd','./msxsdtest/complexType',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA027.xml','./msxsdtest/complexType',valid,S26),
  ITResList17 = [ITRes16|ITResList16],


  ?line {STRes27,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA028.xsd','./msxsdtest/complexType',invalid),
  STResList28 = [STRes27|STResList27],


  ?line {STRes28,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA029.xsd','./msxsdtest/complexType',invalid),
  STResList29 = [STRes28|STResList28],


  ?line {STRes29,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA030.xsd','./msxsdtest/complexType',invalid),
  STResList30 = [STRes29|STResList29],


  ?line {STRes30,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA031.xsd','./msxsdtest/complexType',invalid),
  STResList31 = [STRes30|STResList30],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA032.xsd','./msxsdtest/complexType',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA032.xml','./msxsdtest/complexType',valid,S31),
  ITResList18 = [ITRes17|ITResList17],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA033.xsd','./msxsdtest/complexType',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA033.xml','./msxsdtest/complexType',valid,S32),
  ITResList19 = [ITRes18|ITResList18],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA034.xsd','./msxsdtest/complexType',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA034.xml','./msxsdtest/complexType',valid,S33),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA035.xsd','./msxsdtest/complexType',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA035.xml','./msxsdtest/complexType',valid,S34),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes35,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA036.xsd','./msxsdtest/complexType',invalid),
  STResList36 = [STRes35|STResList35],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA037.xsd','./msxsdtest/complexType',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA037.xml','./msxsdtest/complexType',valid,S36),
  ITResList22 = [ITRes21|ITResList21],


  ?line {STRes37,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA038.xsd','./msxsdtest/complexType',invalid),
  STResList38 = [STRes37|STResList37],


  ?line {STRes38,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA039.xsd','./msxsdtest/complexType',invalid),
  STResList39 = [STRes38|STResList38],


  ?line {STRes39,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA040.xsd','./msxsdtest/complexType',invalid),
  STResList40 = [STRes39|STResList39],


  ?line {STRes40,S40} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA041.xsd','./msxsdtest/complexType',valid),
  STResList41 = [STRes40|STResList40],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA041.xml','./msxsdtest/complexType',valid,S40),
  ITResList23 = [ITRes22|ITResList22],


  ?line {STRes41,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA042.xsd','./msxsdtest/complexType',invalid),
  STResList42 = [STRes41|STResList41],


  ?line {STRes42,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA043.xsd','./msxsdtest/complexType',invalid),
  STResList43 = [STRes42|STResList42],


  ?line {STRes43,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA044.xsd','./msxsdtest/complexType',invalid),
  STResList44 = [STRes43|STResList43],


  ?line {STRes44,S44} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA045.xsd','./msxsdtest/complexType',valid),
  STResList45 = [STRes44|STResList44],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA045.xml','./msxsdtest/complexType',valid,S44),
  ITResList24 = [ITRes23|ITResList23],


  ?line {STRes45,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA046.xsd','./msxsdtest/complexType',invalid),
  STResList46 = [STRes45|STResList45],


  ?line {STRes46,S46} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA047.xsd','./msxsdtest/complexType',valid),
  STResList47 = [STRes46|STResList46],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA047.xml','./msxsdtest/complexType',valid,S46),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes47,S47} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA048.xsd','./msxsdtest/complexType',valid),
  STResList48 = [STRes47|STResList47],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA048.xml','./msxsdtest/complexType',valid,S47),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes48,S48} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctA049.xsd','./msxsdtest/complexType',valid),
  STResList49 = [STRes48|STResList48],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctA049.xml','./msxsdtest/complexType',valid,S48),
  ITResList27 = [ITRes26|ITResList26],


  ?line {STRes49,S49} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB001.xsd','./msxsdtest/complexType',valid),
  STResList50 = [STRes49|STResList49],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB001.xml','./msxsdtest/complexType',valid,S49),
  ITResList28 = [ITRes27|ITResList27],


  ?line {STRes50,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB002.xsd','./msxsdtest/complexType',invalid),
  STResList51 = [STRes50|STResList50],


  ?line {STRes51,S51} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB003.xsd','./msxsdtest/complexType',valid),
  STResList52 = [STRes51|STResList51],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB003.xml','./msxsdtest/complexType',valid,S51),
  ITResList29 = [ITRes28|ITResList28],


  ?line {STRes52,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB004.xsd','./msxsdtest/complexType',invalid),
  STResList53 = [STRes52|STResList52],


  ?line {STRes53,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB005.xsd','./msxsdtest/complexType',invalid),
  STResList54 = [STRes53|STResList53],


  ?line {STRes54,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB006.xsd','./msxsdtest/complexType',invalid),
  STResList55 = [STRes54|STResList54],


  ?line {STRes55,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB007.xsd','./msxsdtest/complexType',invalid),
  STResList56 = [STRes55|STResList55],


  ?line {STRes56,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB008.xsd','./msxsdtest/complexType',invalid),
  STResList57 = [STRes56|STResList56],


  ?line {STRes57,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB009.xsd','./msxsdtest/complexType',invalid),
  STResList58 = [STRes57|STResList57],


  ?line {STRes58,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB010.xsd','./msxsdtest/complexType',invalid),
  STResList59 = [STRes58|STResList58],


  ?line {STRes59,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB011.xsd','./msxsdtest/complexType',invalid),
  STResList60 = [STRes59|STResList59],


  ?line {STRes60,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB012.xsd','./msxsdtest/complexType',invalid),
  STResList61 = [STRes60|STResList60],


  ?line {STRes61,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB013.xsd','./msxsdtest/complexType',invalid),
  STResList62 = [STRes61|STResList61],


  ?line {STRes62,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB014.xsd','./msxsdtest/complexType',invalid),
  STResList63 = [STRes62|STResList62],


  ?line {STRes63,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB015.xsd','./msxsdtest/complexType',invalid),
  STResList64 = [STRes63|STResList63],


  ?line {STRes64,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB016.xsd','./msxsdtest/complexType',invalid),
  STResList65 = [STRes64|STResList64],


  ?line {STRes65,S65} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB017.xsd','./msxsdtest/complexType',valid),
  STResList66 = [STRes65|STResList65],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB017.xml','./msxsdtest/complexType',valid,S65),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes66,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB018.xsd','./msxsdtest/complexType',invalid),
  STResList67 = [STRes66|STResList66],


  ?line {STRes67,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB019.xsd','./msxsdtest/complexType',invalid),
  STResList68 = [STRes67|STResList67],


  ?line {STRes68,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB020.xsd','./msxsdtest/complexType',invalid),
  STResList69 = [STRes68|STResList68],


  ?line {STRes69,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB021.xsd','./msxsdtest/complexType',invalid),
  STResList70 = [STRes69|STResList69],


  ?line {STRes70,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB022.xsd','./msxsdtest/complexType',invalid),
  STResList71 = [STRes70|STResList70],


  ?line {STRes71,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB023.xsd','./msxsdtest/complexType',invalid),
  STResList72 = [STRes71|STResList71],


  ?line {STRes72,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB024.xsd','./msxsdtest/complexType',invalid),
  STResList73 = [STRes72|STResList72],


  ?line {STRes73,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB025.xsd','./msxsdtest/complexType',invalid),
  STResList74 = [STRes73|STResList73],


  ?line {STRes74,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB026.xsd','./msxsdtest/complexType',invalid),
  STResList75 = [STRes74|STResList74],


  ?line {STRes75,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB027.xsd','./msxsdtest/complexType',invalid),
  STResList76 = [STRes75|STResList75],


  ?line {STRes76,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB028.xsd','./msxsdtest/complexType',invalid),
  STResList77 = [STRes76|STResList76],


  ?line {STRes77,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB029.xsd','./msxsdtest/complexType',invalid),
  STResList78 = [STRes77|STResList77],


  ?line {STRes78,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB030.xsd','./msxsdtest/complexType',invalid),
  STResList79 = [STRes78|STResList78],


  ?line {STRes79,S79} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB031.xsd','./msxsdtest/complexType',valid),
  STResList80 = [STRes79|STResList79],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB031.xml','./msxsdtest/complexType',valid,S79),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes80,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB032.xsd','./msxsdtest/complexType',invalid),
  STResList81 = [STRes80|STResList80],


  ?line {STRes81,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB033.xsd','./msxsdtest/complexType',invalid),
  STResList82 = [STRes81|STResList81],


  ?line {STRes82,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB034.xsd','./msxsdtest/complexType',invalid),
  STResList83 = [STRes82|STResList82],


  ?line {STRes83,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB035.xsd','./msxsdtest/complexType',invalid),
  STResList84 = [STRes83|STResList83],


  ?line {STRes84,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB036.xsd','./msxsdtest/complexType',invalid),
  STResList85 = [STRes84|STResList84],


  ?line {STRes85,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB037.xsd','./msxsdtest/complexType',invalid),
  STResList86 = [STRes85|STResList85],


  ?line {STRes86,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB038.xsd','./msxsdtest/complexType',invalid),
  STResList87 = [STRes86|STResList86],


  ?line {STRes87,S87} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB039.xsd','./msxsdtest/complexType',valid),
  STResList88 = [STRes87|STResList87],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB039.xml','./msxsdtest/complexType',valid,S87),
  ITResList32 = [ITRes31|ITResList31],


  ?line {STRes88,S88} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB040.xsd','./msxsdtest/complexType',valid),
  STResList89 = [STRes88|STResList88],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB040.xml','./msxsdtest/complexType',valid,S88),
  ITResList33 = [ITRes32|ITResList32],


  ?line {STRes89,S89} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB041.xsd','./msxsdtest/complexType',valid),
  STResList90 = [STRes89|STResList89],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB041.xml','./msxsdtest/complexType',valid,S89),
  ITResList34 = [ITRes33|ITResList33],


  ?line {STRes90,S90} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB042.xsd','./msxsdtest/complexType',valid),
  STResList91 = [STRes90|STResList90],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB042.xml','./msxsdtest/complexType',valid,S90),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes91,S91} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB043.xsd','./msxsdtest/complexType',valid),
  STResList92 = [STRes91|STResList91],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB043.xml','./msxsdtest/complexType',valid,S91),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes92,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB044.xsd','./msxsdtest/complexType',invalid),
  STResList93 = [STRes92|STResList92],


  ?line {STRes93,S93} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB045.xsd','./msxsdtest/complexType',valid),
  STResList94 = [STRes93|STResList93],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB045.xml','./msxsdtest/complexType',valid,S93),
  ITResList37 = [ITRes36|ITResList36],


  ?line {STRes94,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB046.xsd','./msxsdtest/complexType',invalid),
  STResList95 = [STRes94|STResList94],


  ?line {STRes95,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB047.xsd','./msxsdtest/complexType',invalid),
  STResList96 = [STRes95|STResList95],


  ?line {STRes96,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB048.xsd','./msxsdtest/complexType',invalid),
  STResList97 = [STRes96|STResList96],


  ?line {STRes97,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB049.xsd','./msxsdtest/complexType',invalid),
  STResList98 = [STRes97|STResList97],


  ?line {STRes98,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB050.xsd','./msxsdtest/complexType',invalid),
  STResList99 = [STRes98|STResList98],


  ?line {STRes99,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB051.xsd','./msxsdtest/complexType',invalid),
  STResList100 = [STRes99|STResList99],


  ?line {STRes100,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB052.xsd','./msxsdtest/complexType',invalid),
  STResList101 = [STRes100|STResList100],


  ?line {STRes101,S101} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB053.xsd','./msxsdtest/complexType',valid),
  STResList102 = [STRes101|STResList101],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB053.xml','./msxsdtest/complexType',valid,S101),
  ITResList38 = [ITRes37|ITResList37],


  ?line {STRes102,S102} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB054.xsd','./msxsdtest/complexType',valid),
  STResList103 = [STRes102|STResList102],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB054.xml','./msxsdtest/complexType',valid,S102),
  ITResList39 = [ITRes38|ITResList38],


  ?line {STRes103,S103} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB055.xsd','./msxsdtest/complexType',valid),
  STResList104 = [STRes103|STResList103],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB055.xml','./msxsdtest/complexType',valid,S103),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes104,S104} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB056.xsd','./msxsdtest/complexType',valid),
  STResList105 = [STRes104|STResList104],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB056.xml','./msxsdtest/complexType',valid,S104),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes105,S105} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB057.xsd','./msxsdtest/complexType',valid),
  STResList106 = [STRes105|STResList105],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB057.xml','./msxsdtest/complexType',valid,S105),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes106,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB058.xsd','./msxsdtest/complexType',invalid),
  STResList107 = [STRes106|STResList106],


  ?line {STRes107,S107} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB059.xsd','./msxsdtest/complexType',valid),
  STResList108 = [STRes107|STResList107],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB059.xml','./msxsdtest/complexType',valid,S107),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes108,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB060.xsd','./msxsdtest/complexType',invalid),
  STResList109 = [STRes108|STResList108],


  ?line {STRes109,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB061.xsd','./msxsdtest/complexType',invalid),
  STResList110 = [STRes109|STResList109],


  ?line {STRes110,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB062.xsd','./msxsdtest/complexType',invalid),
  STResList111 = [STRes110|STResList110],


  ?line {STRes111,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB063.xsd','./msxsdtest/complexType',invalid),
  STResList112 = [STRes111|STResList111],


  ?line {STRes112,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB064.xsd','./msxsdtest/complexType',invalid),
  STResList113 = [STRes112|STResList112],


  ?line {STRes113,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB065.xsd','./msxsdtest/complexType',invalid),
  STResList114 = [STRes113|STResList113],


  ?line {STRes114,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB066.xsd','./msxsdtest/complexType',invalid),
  STResList115 = [STRes114|STResList114],


  ?line {STRes115,S115} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB067.xsd','./msxsdtest/complexType',valid),
  STResList116 = [STRes115|STResList115],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB067.xml','./msxsdtest/complexType',valid,S115),
  ITResList44 = [ITRes43|ITResList43],


  ?line {STRes116,S116} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB068.xsd','./msxsdtest/complexType',valid),
  STResList117 = [STRes116|STResList116],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB068.xml','./msxsdtest/complexType',valid,S116),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes117,S117} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB069.xsd','./msxsdtest/complexType',valid),
  STResList118 = [STRes117|STResList117],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB069.xml','./msxsdtest/complexType',valid,S117),
  ITResList46 = [ITRes45|ITResList45],


  ?line {STRes118,S118} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB070.xsd','./msxsdtest/complexType',valid),
  STResList119 = [STRes118|STResList118],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB070.xml','./msxsdtest/complexType',valid,S118),
  ITResList47 = [ITRes46|ITResList46],


  ?line {STRes119,S119} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB071.xsd','./msxsdtest/complexType',valid),
  STResList120 = [STRes119|STResList119],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB071.xml','./msxsdtest/complexType',valid,S119),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes120,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB072.xsd','./msxsdtest/complexType',invalid),
  STResList121 = [STRes120|STResList120],


  ?line {STRes121,S121} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB073.xsd','./msxsdtest/complexType',valid),
  STResList122 = [STRes121|STResList121],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB073.xml','./msxsdtest/complexType',valid,S121),
  ITResList49 = [ITRes48|ITResList48],


  ?line {STRes122,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB074.xsd','./msxsdtest/complexType',invalid),
  STResList123 = [STRes122|STResList122],


  ?line {STRes123,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB075.xsd','./msxsdtest/complexType',invalid),
  STResList124 = [STRes123|STResList123],


  ?line {STRes124,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB076.xsd','./msxsdtest/complexType',invalid),
  STResList125 = [STRes124|STResList124],


  ?line {STRes125,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB077.xsd','./msxsdtest/complexType',invalid),
  STResList126 = [STRes125|STResList125],


  ?line {STRes126,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB078.xsd','./msxsdtest/complexType',invalid),
  STResList127 = [STRes126|STResList126],


  ?line {STRes127,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB079.xsd','./msxsdtest/complexType',invalid),
  STResList128 = [STRes127|STResList127],


  ?line {STRes128,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB080.xsd','./msxsdtest/complexType',invalid),
  STResList129 = [STRes128|STResList128],


  ?line {STRes129,S129} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB081.xsd','./msxsdtest/complexType',valid),
  STResList130 = [STRes129|STResList129],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB081.xml','./msxsdtest/complexType',valid,S129),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes130,S130} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB082.xsd','./msxsdtest/complexType',valid),
  STResList131 = [STRes130|STResList130],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB082.xml','./msxsdtest/complexType',valid,S130),
  ITResList51 = [ITRes50|ITResList50],


  ?line {STRes131,S131} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB083.xsd','./msxsdtest/complexType',valid),
  STResList132 = [STRes131|STResList131],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB083.xml','./msxsdtest/complexType',valid,S131),
  ITResList52 = [ITRes51|ITResList51],


  ?line {STRes132,S132} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB084.xsd','./msxsdtest/complexType',valid),
  STResList133 = [STRes132|STResList132],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB084.xml','./msxsdtest/complexType',valid,S132),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes133,S133} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB085.xsd','./msxsdtest/complexType',valid),
  STResList134 = [STRes133|STResList133],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB085.xml','./msxsdtest/complexType',valid,S133),
  ITResList54 = [ITRes53|ITResList53],


  ?line {STRes134,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB086.xsd','./msxsdtest/complexType',invalid),
  STResList135 = [STRes134|STResList134],


  ?line {STRes135,S135} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB087.xsd','./msxsdtest/complexType',valid),
  STResList136 = [STRes135|STResList135],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB087.xml','./msxsdtest/complexType',valid,S135),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes136,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB088.xsd','./msxsdtest/complexType',invalid),
  STResList137 = [STRes136|STResList136],


  ?line {STRes137,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB089.xsd','./msxsdtest/complexType',invalid),
  STResList138 = [STRes137|STResList137],


  ?line {STRes138,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB090.xsd','./msxsdtest/complexType',invalid),
  STResList139 = [STRes138|STResList138],


  ?line {STRes139,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB091.xsd','./msxsdtest/complexType',invalid),
  STResList140 = [STRes139|STResList139],


  ?line {STRes140,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB092.xsd','./msxsdtest/complexType',invalid),
  STResList141 = [STRes140|STResList140],


  ?line {STRes141,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB093.xsd','./msxsdtest/complexType',invalid),
  STResList142 = [STRes141|STResList141],


  ?line {STRes142,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB094.xsd','./msxsdtest/complexType',invalid),
  STResList143 = [STRes142|STResList142],


  ?line {STRes143,S143} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB095.xsd','./msxsdtest/complexType',valid),
  STResList144 = [STRes143|STResList143],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB095.xml','./msxsdtest/complexType',valid,S143),
  ITResList56 = [ITRes55|ITResList55],


  ?line {STRes144,S144} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB096.xsd','./msxsdtest/complexType',valid),
  STResList145 = [STRes144|STResList144],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB096.xml','./msxsdtest/complexType',valid,S144),
  ITResList57 = [ITRes56|ITResList56],


  ?line {STRes145,S145} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB097.xsd','./msxsdtest/complexType',valid),
  STResList146 = [STRes145|STResList145],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB097.xml','./msxsdtest/complexType',valid,S145),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes146,S146} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB098.xsd','./msxsdtest/complexType',valid),
  STResList147 = [STRes146|STResList146],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB098.xml','./msxsdtest/complexType',valid,S146),
  ITResList59 = [ITRes58|ITResList58],


  ?line {STRes147,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB099.xsd','./msxsdtest/complexType',invalid),
  STResList148 = [STRes147|STResList147],


  ?line {STRes148,S148} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB100.xsd','./msxsdtest/complexType',valid),
  STResList149 = [STRes148|STResList148],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB100.xml','./msxsdtest/complexType',valid,S148),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes149,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB101.xsd','./msxsdtest/complexType',invalid),
  STResList150 = [STRes149|STResList149],


  ?line {STRes150,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB102.xsd','./msxsdtest/complexType',invalid),
  STResList151 = [STRes150|STResList150],


  ?line {STRes151,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB103.xsd','./msxsdtest/complexType',invalid),
  STResList152 = [STRes151|STResList151],


  ?line {STRes152,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB104.xsd','./msxsdtest/complexType',invalid),
  STResList153 = [STRes152|STResList152],


  ?line {STRes153,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB105.xsd','./msxsdtest/complexType',invalid),
  STResList154 = [STRes153|STResList153],


  ?line {STRes154,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB106.xsd','./msxsdtest/complexType',invalid),
  STResList155 = [STRes154|STResList154],


  ?line {STRes155,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB107.xsd','./msxsdtest/complexType',invalid),
  STResList156 = [STRes155|STResList155],


  ?line {STRes156,S156} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB108.xsd','./msxsdtest/complexType',valid),
  STResList157 = [STRes156|STResList156],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB108.xml','./msxsdtest/complexType',valid,S156),
  ITResList61 = [ITRes60|ITResList60],


  ?line {STRes157,S157} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB109.xsd','./msxsdtest/complexType',valid),
  STResList158 = [STRes157|STResList157],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB109.xml','./msxsdtest/complexType',valid,S157),
  ITResList62 = [ITRes61|ITResList61],


  ?line {STRes158,S158} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB110.xsd','./msxsdtest/complexType',valid),
  STResList159 = [STRes158|STResList158],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB110.xml','./msxsdtest/complexType',valid,S158),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes159,S159} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB111.xsd','./msxsdtest/complexType',valid),
  STResList160 = [STRes159|STResList159],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB111.xml','./msxsdtest/complexType',valid,S159),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes160,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB112.xsd','./msxsdtest/complexType',invalid),
  STResList161 = [STRes160|STResList160],


  ?line {STRes161,S161} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB113.xsd','./msxsdtest/complexType',valid),
  STResList162 = [STRes161|STResList161],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctB113.xml','./msxsdtest/complexType',valid,S161),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes162,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB114.xsd','./msxsdtest/complexType',invalid),
  STResList163 = [STRes162|STResList162],


  ?line {STRes163,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB115.xsd','./msxsdtest/complexType',invalid),
  STResList164 = [STRes163|STResList163],


  ?line {STRes164,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB116.xsd','./msxsdtest/complexType',invalid),
  STResList165 = [STRes164|STResList164],


  ?line {STRes165,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB117.xsd','./msxsdtest/complexType',invalid),
  STResList166 = [STRes165|STResList165],


  ?line {STRes166,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB118.xsd','./msxsdtest/complexType',invalid),
  STResList167 = [STRes166|STResList166],


  ?line {STRes167,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB119.xsd','./msxsdtest/complexType',invalid),
  STResList168 = [STRes167|STResList167],


  ?line {STRes168,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB120.xsd','./msxsdtest/complexType',invalid),
  STResList169 = [STRes168|STResList168],


  ?line {STRes169,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB121.xsd','./msxsdtest/complexType',invalid),
  STResList170 = [STRes169|STResList169],


  ?line {STRes170,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB122.xsd','./msxsdtest/complexType',invalid),
  STResList171 = [STRes170|STResList170],


  ?line {STRes171,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB123.xsd','./msxsdtest/complexType',invalid),
  STResList172 = [STRes171|STResList171],


  ?line {STRes172,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB124.xsd','./msxsdtest/complexType',invalid),
  STResList173 = [STRes172|STResList172],


  ?line {STRes173,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctB125.xsd','./msxsdtest/complexType',invalid),
  STResList174 = [STRes173|STResList173],


  ?line {STRes174,S174} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC001.xsd','./msxsdtest/complexType',valid),
  STResList175 = [STRes174|STResList174],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctC001.xml','./msxsdtest/complexType',valid,S174),
  ITResList66 = [ITRes65|ITResList65],


  ?line {STRes175,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC002.xsd','./msxsdtest/complexType',invalid),
  STResList176 = [STRes175|STResList175],


  ?line {STRes176,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC003.xsd','./msxsdtest/complexType',invalid),
  STResList177 = [STRes176|STResList176],


  ?line {STRes177,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC004.xsd','./msxsdtest/complexType',invalid),
  STResList178 = [STRes177|STResList177],


  ?line {STRes178,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC005.xsd','./msxsdtest/complexType',invalid),
  STResList179 = [STRes178|STResList178],


  ?line {STRes179,S179} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC006.xsd','./msxsdtest/complexType',valid),
  STResList180 = [STRes179|STResList179],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctC006.xml','./msxsdtest/complexType',valid,S179),
  ITResList67 = [ITRes66|ITResList66],


  ?line {STRes180,S180} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC007.xsd','./msxsdtest/complexType',valid),
  STResList181 = [STRes180|STResList180],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctC007.xml','./msxsdtest/complexType',valid,S180),
  ITResList68 = [ITRes67|ITResList67],


  ?line {STRes181,S181} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC008.xsd','./msxsdtest/complexType',valid),
  STResList182 = [STRes181|STResList181],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctC008.xml','./msxsdtest/complexType',valid,S181),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes182,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC009.xsd','./msxsdtest/complexType',invalid),
  STResList183 = [STRes182|STResList182],


  ?line {STRes183,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC010.xsd','./msxsdtest/complexType',invalid),
  STResList184 = [STRes183|STResList183],


  ?line {STRes184,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC011.xsd','./msxsdtest/complexType',invalid),
  STResList185 = [STRes184|STResList184],


  ?line {STRes185,S185} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctC012.xsd','./msxsdtest/complexType',valid),
  STResList186 = [STRes185|STResList185],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctC012.xml','./msxsdtest/complexType',valid,S185),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes186,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD001.xsd','./msxsdtest/complexType',invalid),
  STResList187 = [STRes186|STResList186],


  ?line {STRes187,S187} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD002.xsd','./msxsdtest/complexType',valid),
  STResList188 = [STRes187|STResList187],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD002.xml','./msxsdtest/complexType',valid,S187),
  ITResList71 = [ITRes70|ITResList70],


  ?line {STRes188,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD003.xsd','./msxsdtest/complexType',invalid),
  STResList189 = [STRes188|STResList188],


  ?line {STRes189,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD004.xsd','./msxsdtest/complexType',invalid),
  STResList190 = [STRes189|STResList189],


  ?line {STRes190,S190} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD005.xsd','./msxsdtest/complexType',valid),
  STResList191 = [STRes190|STResList190],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD005.xml','./msxsdtest/complexType',valid,S190),
  ITResList72 = [ITRes71|ITResList71],


  ?line {STRes191,S191} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD006.xsd','./msxsdtest/complexType',valid),
  STResList192 = [STRes191|STResList191],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD006.xml','./msxsdtest/complexType',valid,S191),
  ITResList73 = [ITRes72|ITResList72],


  ?line {STRes192,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD007.xsd','./msxsdtest/complexType',invalid),
  STResList193 = [STRes192|STResList192],


  ?line {STRes193,S193} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD008.xsd','./msxsdtest/complexType',valid),
  STResList194 = [STRes193|STResList193],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD008.xml','./msxsdtest/complexType',valid,S193),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes194,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD009.xsd','./msxsdtest/complexType',invalid),
  STResList195 = [STRes194|STResList194],


  ?line {STRes195,S195} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD010.xsd','./msxsdtest/complexType',valid),
  STResList196 = [STRes195|STResList195],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD010.xml','./msxsdtest/complexType',valid,S195),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes196,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD011.xsd','./msxsdtest/complexType',invalid),
  STResList197 = [STRes196|STResList196],


  ?line {STRes197,S197} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD012.xsd','./msxsdtest/complexType',valid),
  STResList198 = [STRes197|STResList197],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD012.xml','./msxsdtest/complexType',valid,S197),
  ITResList76 = [ITRes75|ITResList75],


  ?line {STRes198,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD013.xsd','./msxsdtest/complexType',invalid),
  STResList199 = [STRes198|STResList198],


  ?line {STRes199,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD014.xsd','./msxsdtest/complexType',invalid),
  STResList200 = [STRes199|STResList199],


  ?line {STRes200,S200} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD015.xsd','./msxsdtest/complexType',valid),
  STResList201 = [STRes200|STResList200],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD015.xml','./msxsdtest/complexType',valid,S200),
  ITResList77 = [ITRes76|ITResList76],


  ?line {STRes201,S201} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD016.xsd','./msxsdtest/complexType',valid),
  STResList202 = [STRes201|STResList201],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD016.xml','./msxsdtest/complexType',valid,S201),
  ITResList78 = [ITRes77|ITResList77],


  ?line {STRes202,S202} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD017.xsd','./msxsdtest/complexType',valid),
  STResList203 = [STRes202|STResList202],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD017.xml','./msxsdtest/complexType',valid,S202),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes203,S203} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD018.xsd','./msxsdtest/complexType',valid),
  STResList204 = [STRes203|STResList203],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD018.xml','./msxsdtest/complexType',valid,S203),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes204,S204} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD019.xsd','./msxsdtest/complexType',valid),
  STResList205 = [STRes204|STResList204],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD019.xml','./msxsdtest/complexType',valid,S204),
  ITResList81 = [ITRes80|ITResList80],


  ?line {STRes205,S205} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD020.xsd','./msxsdtest/complexType',valid),
  STResList206 = [STRes205|STResList205],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD020.xml','./msxsdtest/complexType',valid,S205),
  ITResList82 = [ITRes81|ITResList81],


  ?line {STRes206,S206} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD021.xsd','./msxsdtest/complexType',valid),
  STResList207 = [STRes206|STResList206],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD021.xml','./msxsdtest/complexType',valid,S206),
  ITResList83 = [ITRes82|ITResList82],


  ?line {STRes207,S207} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD022.xsd','./msxsdtest/complexType',valid),
  STResList208 = [STRes207|STResList207],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD022.xml','./msxsdtest/complexType',valid,S207),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes208,S208} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD023.xsd','./msxsdtest/complexType',valid),
  STResList209 = [STRes208|STResList208],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD023.xml','./msxsdtest/complexType',valid,S208),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes209,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD024.xsd','./msxsdtest/complexType',invalid),
  STResList210 = [STRes209|STResList209],


  ?line {STRes210,S210} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD025.xsd','./msxsdtest/complexType',valid),
  STResList211 = [STRes210|STResList210],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD025.xml','./msxsdtest/complexType',valid,S210),
  ITResList86 = [ITRes85|ITResList85],


  ?line {STRes211,S211} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD026.xsd','./msxsdtest/complexType',valid),
  STResList212 = [STRes211|STResList211],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD026.xml','./msxsdtest/complexType',valid,S211),
  ITResList87 = [ITRes86|ITResList86],


  ?line {STRes212,S212} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD027.xsd','./msxsdtest/complexType',valid),
  STResList213 = [STRes212|STResList212],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD027.xml','./msxsdtest/complexType',valid,S212),
  ITResList88 = [ITRes87|ITResList87],


  ?line {STRes213,S213} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD028.xsd','./msxsdtest/complexType',valid),
  STResList214 = [STRes213|STResList213],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD028.xml','./msxsdtest/complexType',valid,S213),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes214,S214} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD029.xsd','./msxsdtest/complexType',valid),
  STResList215 = [STRes214|STResList214],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD029.xml','./msxsdtest/complexType',valid,S214),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes215,S215} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD030.xsd','./msxsdtest/complexType',valid),
  STResList216 = [STRes215|STResList215],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD030.xml','./msxsdtest/complexType',valid,S215),
  ITResList91 = [ITRes90|ITResList90],


  ?line {STRes216,S216} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD031.xsd','./msxsdtest/complexType',valid),
  STResList217 = [STRes216|STResList216],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD031.xml','./msxsdtest/complexType',valid,S216),
  ITResList92 = [ITRes91|ITResList91],


  ?line {STRes217,S217} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD032.xsd','./msxsdtest/complexType',valid),
  STResList218 = [STRes217|STResList217],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD032.xml','./msxsdtest/complexType',valid,S217),
  ITResList93 = [ITRes92|ITResList92],


  ?line {STRes218,S218} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD033.xsd','./msxsdtest/complexType',valid),
  STResList219 = [STRes218|STResList218],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD033.xml','./msxsdtest/complexType',valid,S218),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes219,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD034.xsd','./msxsdtest/complexType',invalid),
  STResList220 = [STRes219|STResList219],


  ?line {STRes220,S220} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD035.xsd','./msxsdtest/complexType',valid),
  STResList221 = [STRes220|STResList220],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctD035.xml','./msxsdtest/complexType',valid,S220),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes221,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD036.xsd','./msxsdtest/complexType',invalid),
  STResList222 = [STRes221|STResList221],


  ?line {STRes222,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD037.xsd','./msxsdtest/complexType',invalid),
  STResList223 = [STRes222|STResList222],


  ?line {STRes223,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD038.xsd','./msxsdtest/complexType',invalid),
  STResList224 = [STRes223|STResList223],


  ?line {STRes224,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD039.xsd','./msxsdtest/complexType',invalid),
  STResList225 = [STRes224|STResList224],


  ?line {STRes225,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD040.xsd','./msxsdtest/complexType',invalid),
  STResList226 = [STRes225|STResList225],


  ?line {STRes226,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD041.xsd','./msxsdtest/complexType',invalid),
  STResList227 = [STRes226|STResList226],


  ?line {STRes227,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD042.xsd','./msxsdtest/complexType',invalid),
  STResList228 = [STRes227|STResList227],


  ?line {STRes228,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctD043.xsd','./msxsdtest/complexType',invalid),
  STResList229 = [STRes228|STResList228],


  ?line {STRes229,S229} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE001.xsd','./msxsdtest/complexType',valid),
  STResList230 = [STRes229|STResList229],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctE001.xml','./msxsdtest/complexType',valid,S229),
  ITResList96 = [ITRes95|ITResList95],


  ?line {STRes230,S230} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE002.xsd','./msxsdtest/complexType',valid),
  STResList231 = [STRes230|STResList230],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctE002.xml','./msxsdtest/complexType',valid,S230),
  ITResList97 = [ITRes96|ITResList96],


  ?line {STRes231,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE003.xsd','./msxsdtest/complexType',invalid),
  STResList232 = [STRes231|STResList231],


  ?line {STRes232,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE004.xsd','./msxsdtest/complexType',invalid),
  STResList233 = [STRes232|STResList232],


  ?line {STRes233,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE005.xsd','./msxsdtest/complexType',invalid),
  STResList234 = [STRes233|STResList233],


  ?line {STRes234,S234} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE006.xsd','./msxsdtest/complexType',valid),
  STResList235 = [STRes234|STResList234],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctE006.xml','./msxsdtest/complexType',valid,S234),
  ITResList98 = [ITRes97|ITResList97],


  ?line {STRes235,S235} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE007.xsd','./msxsdtest/complexType',valid),
  STResList236 = [STRes235|STResList235],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctE007.xml','./msxsdtest/complexType',valid,S235),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes236,S236} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE008.xsd','./msxsdtest/complexType',valid),
  STResList237 = [STRes236|STResList236],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctE008.xml','./msxsdtest/complexType',valid,S236),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes237,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE009.xsd','./msxsdtest/complexType',invalid),
  STResList238 = [STRes237|STResList237],


  ?line {STRes238,S238} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE010.xsd','./msxsdtest/complexType',valid),
  STResList239 = [STRes238|STResList238],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctE010.xml','./msxsdtest/complexType',valid,S238),
  ITResList101 = [ITRes100|ITResList100],


  ?line {STRes239,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE011.xsd','./msxsdtest/complexType',invalid),
  STResList240 = [STRes239|STResList239],


  ?line {STRes240,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE012.xsd','./msxsdtest/complexType',invalid),
  STResList241 = [STRes240|STResList240],


  ?line {STRes241,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE013.xsd','./msxsdtest/complexType',invalid),
  STResList242 = [STRes241|STResList241],


  ?line {STRes242,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE014.xsd','./msxsdtest/complexType',invalid),
  STResList243 = [STRes242|STResList242],


  ?line {STRes243,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE015.xsd','./msxsdtest/complexType',invalid),
  STResList244 = [STRes243|STResList243],


  ?line {STRes244,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE016.xsd','./msxsdtest/complexType',invalid),
  STResList245 = [STRes244|STResList244],


  ?line {STRes245,S245} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctE017.xsd','./msxsdtest/complexType',valid),
  STResList246 = [STRes245|STResList245],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctE017.xml','./msxsdtest/complexType',valid,S245),
  ITResList102 = [ITRes101|ITResList101],


  ?line {STRes246,S246} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF001.xsd','./msxsdtest/complexType',valid),
  STResList247 = [STRes246|STResList246],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctF001.xml','./msxsdtest/complexType',valid,S246),
  ITResList103 = [ITRes102|ITResList102],


  ?line {STRes247,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF002.xsd','./msxsdtest/complexType',invalid),
  STResList248 = [STRes247|STResList247],


  ?line {STRes248,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF003.xsd','./msxsdtest/complexType',invalid),
  STResList249 = [STRes248|STResList248],


  ?line {STRes249,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF004.xsd','./msxsdtest/complexType',invalid),
  STResList250 = [STRes249|STResList249],


  ?line {STRes250,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF005.xsd','./msxsdtest/complexType',invalid),
  STResList251 = [STRes250|STResList250],


  ?line {STRes251,S251} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF006.xsd','./msxsdtest/complexType',valid),
  STResList252 = [STRes251|STResList251],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctF006.xml','./msxsdtest/complexType',valid,S251),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes252,S252} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF007.xsd','./msxsdtest/complexType',valid),
  STResList253 = [STRes252|STResList252],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctF007.xml','./msxsdtest/complexType',valid,S252),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes253,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF008.xsd','./msxsdtest/complexType',invalid),
  STResList254 = [STRes253|STResList253],


  ?line {STRes254,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF009.xsd','./msxsdtest/complexType',invalid),
  STResList255 = [STRes254|STResList254],


  ?line {STRes255,S255} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF010.xsd','./msxsdtest/complexType',valid),
  STResList256 = [STRes255|STResList255],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctF010.xml','./msxsdtest/complexType',valid,S255),
  ITResList106 = [ITRes105|ITResList105],


  ?line {STRes256,S256} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF011.xsd','./msxsdtest/complexType',valid),
  STResList257 = [STRes256|STResList256],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctF011.xml','./msxsdtest/complexType',valid,S256),
  ITResList107 = [ITRes106|ITResList106],


  ?line {STRes257,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF012.xsd','./msxsdtest/complexType',invalid),
  STResList258 = [STRes257|STResList257],


  ?line {STRes258,S258} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF013.xsd','./msxsdtest/complexType',valid),
  STResList259 = [STRes258|STResList258],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctF013.xml','./msxsdtest/complexType',valid,S258),
  ITResList108 = [ITRes107|ITResList107],


  ?line {STRes259,S259} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF014.xsd','./msxsdtest/complexType',valid),
  STResList260 = [STRes259|STResList259],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctF014.xml','./msxsdtest/complexType',valid,S259),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes260,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF015.xsd','./msxsdtest/complexType',invalid),
  STResList261 = [STRes260|STResList260],


  ?line {STRes261,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF016.xsd','./msxsdtest/complexType',invalid),
  STResList262 = [STRes261|STResList261],


  ?line {STRes262,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctF017.xsd','./msxsdtest/complexType',invalid),
  STResList263 = [STRes262|STResList262],


  ?line {STRes263,S263} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG001.xsd','./msxsdtest/complexType',valid),
  STResList264 = [STRes263|STResList263],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG001.xml','./msxsdtest/complexType',valid,S263),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes264,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG002.xsd','./msxsdtest/complexType',invalid),
  STResList265 = [STRes264|STResList264],


  ?line {STRes265,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG003.xsd','./msxsdtest/complexType',invalid),
  STResList266 = [STRes265|STResList265],


  ?line {STRes266,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG004.xsd','./msxsdtest/complexType',invalid),
  STResList267 = [STRes266|STResList266],


  ?line {STRes267,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG005.xsd','./msxsdtest/complexType',invalid),
  STResList268 = [STRes267|STResList267],


  ?line {STRes268,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG006.xsd','./msxsdtest/complexType',invalid),
  STResList269 = [STRes268|STResList268],


  ?line {STRes269,S269} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG007.xsd','./msxsdtest/complexType',valid),
  STResList270 = [STRes269|STResList269],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG007.xml','./msxsdtest/complexType',valid,S269),
  ITResList111 = [ITRes110|ITResList110],


  ?line {STRes270,S270} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG008.xsd','./msxsdtest/complexType',valid),
  STResList271 = [STRes270|STResList270],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG008.xml','./msxsdtest/complexType',valid,S270),
  ITResList112 = [ITRes111|ITResList111],


  ?line {STRes271,S271} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG009.xsd','./msxsdtest/complexType',valid),
  STResList272 = [STRes271|STResList271],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG009.xml','./msxsdtest/complexType',valid,S271),
  ITResList113 = [ITRes112|ITResList112],


  ?line {STRes272,S272} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG010.xsd','./msxsdtest/complexType',valid),
  STResList273 = [STRes272|STResList272],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG010.xml','./msxsdtest/complexType',valid,S272),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes273,S273} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG011.xsd','./msxsdtest/complexType',valid),
  STResList274 = [STRes273|STResList273],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG011.xml','./msxsdtest/complexType',valid,S273),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes274,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG012.xsd','./msxsdtest/complexType',invalid),
  STResList275 = [STRes274|STResList274],


  ?line {STRes275,S275} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG013.xsd','./msxsdtest/complexType',valid),
  STResList276 = [STRes275|STResList275],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG013.xml','./msxsdtest/complexType',valid,S275),
  ITResList116 = [ITRes115|ITResList115],


  ?line {STRes276,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG014.xsd','./msxsdtest/complexType',invalid),
  STResList277 = [STRes276|STResList276],


  ?line {STRes277,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG015.xsd','./msxsdtest/complexType',invalid),
  STResList278 = [STRes277|STResList277],


  ?line {STRes278,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG016.xsd','./msxsdtest/complexType',invalid),
  STResList279 = [STRes278|STResList278],


  ?line {STRes279,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG017.xsd','./msxsdtest/complexType',invalid),
  STResList280 = [STRes279|STResList279],


  ?line {STRes280,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG018.xsd','./msxsdtest/complexType',invalid),
  STResList281 = [STRes280|STResList280],


  ?line {STRes281,S281} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG019.xsd','./msxsdtest/complexType',valid),
  STResList282 = [STRes281|STResList281],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG019.xml','./msxsdtest/complexType',valid,S281),
  ITResList117 = [ITRes116|ITResList116],


  ?line {STRes282,S282} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG020.xsd','./msxsdtest/complexType',valid),
  STResList283 = [STRes282|STResList282],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG020.xml','./msxsdtest/complexType',valid,S282),
  ITResList118 = [ITRes117|ITResList117],


  ?line {STRes283,S283} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG021.xsd','./msxsdtest/complexType',valid),
  STResList284 = [STRes283|STResList283],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG021.xml','./msxsdtest/complexType',valid,S283),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes284,S284} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG022.xsd','./msxsdtest/complexType',valid),
  STResList285 = [STRes284|STResList284],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG022.xml','./msxsdtest/complexType',valid,S284),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes285,S285} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG023.xsd','./msxsdtest/complexType',valid),
  STResList286 = [STRes285|STResList285],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG023.xml','./msxsdtest/complexType',valid,S285),
  ITResList121 = [ITRes120|ITResList120],


  ?line {STRes286,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG024.xsd','./msxsdtest/complexType',invalid),
  STResList287 = [STRes286|STResList286],


  ?line {STRes287,S287} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG025.xsd','./msxsdtest/complexType',valid),
  STResList288 = [STRes287|STResList287],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG025.xml','./msxsdtest/complexType',valid,S287),
  ITResList122 = [ITRes121|ITResList121],


  ?line {STRes288,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG026.xsd','./msxsdtest/complexType',invalid),
  STResList289 = [STRes288|STResList288],


  ?line {STRes289,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG027.xsd','./msxsdtest/complexType',invalid),
  STResList290 = [STRes289|STResList289],


  ?line {STRes290,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG028.xsd','./msxsdtest/complexType',invalid),
  STResList291 = [STRes290|STResList290],


  ?line {STRes291,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG029.xsd','./msxsdtest/complexType',invalid),
  STResList292 = [STRes291|STResList291],


  ?line {STRes292,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG030.xsd','./msxsdtest/complexType',invalid),
  STResList293 = [STRes292|STResList292],


  ?line {STRes293,S293} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG031.xsd','./msxsdtest/complexType',valid),
  STResList294 = [STRes293|STResList293],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG031.xml','./msxsdtest/complexType',valid,S293),
  ITResList123 = [ITRes122|ITResList122],


  ?line {STRes294,S294} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG032.xsd','./msxsdtest/complexType',valid),
  STResList295 = [STRes294|STResList294],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG032.xml','./msxsdtest/complexType',valid,S294),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes295,S295} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG033.xsd','./msxsdtest/complexType',valid),
  STResList296 = [STRes295|STResList295],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG033.xml','./msxsdtest/complexType',valid,S295),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes296,S296} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG034.xsd','./msxsdtest/complexType',valid),
  STResList297 = [STRes296|STResList296],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG034.xml','./msxsdtest/complexType',valid,S296),
  ITResList126 = [ITRes125|ITResList125],


  ?line {STRes297,S297} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG035.xsd','./msxsdtest/complexType',valid),
  STResList298 = [STRes297|STResList297],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG035.xml','./msxsdtest/complexType',valid,S297),
  ITResList127 = [ITRes126|ITResList126],


  ?line {STRes298,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG036.xsd','./msxsdtest/complexType',invalid),
  STResList299 = [STRes298|STResList298],


  ?line {STRes299,S299} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG037.xsd','./msxsdtest/complexType',valid),
  STResList300 = [STRes299|STResList299],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG037.xml','./msxsdtest/complexType',valid,S299),
  ITResList128 = [ITRes127|ITResList127],


  ?line {STRes300,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG038.xsd','./msxsdtest/complexType',invalid),
  STResList301 = [STRes300|STResList300],


  ?line {STRes301,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG039.xsd','./msxsdtest/complexType',invalid),
  STResList302 = [STRes301|STResList301],


  ?line {STRes302,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG040.xsd','./msxsdtest/complexType',invalid),
  STResList303 = [STRes302|STResList302],


  ?line {STRes303,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG041.xsd','./msxsdtest/complexType',invalid),
  STResList304 = [STRes303|STResList303],


  ?line {STRes304,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG042.xsd','./msxsdtest/complexType',invalid),
  STResList305 = [STRes304|STResList304],


  ?line {STRes305,S305} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG043.xsd','./msxsdtest/complexType',valid),
  STResList306 = [STRes305|STResList305],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG043.xml','./msxsdtest/complexType',valid,S305),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes306,S306} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG044.xsd','./msxsdtest/complexType',valid),
  STResList307 = [STRes306|STResList306],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG044.xml','./msxsdtest/complexType',valid,S306),
  ITResList130 = [ITRes129|ITResList129],


  ?line {STRes307,S307} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG045.xsd','./msxsdtest/complexType',valid),
  STResList308 = [STRes307|STResList307],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG045.xml','./msxsdtest/complexType',valid,S307),
  ITResList131 = [ITRes130|ITResList130],


  ?line {STRes308,S308} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG046.xsd','./msxsdtest/complexType',valid),
  STResList309 = [STRes308|STResList308],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG046.xml','./msxsdtest/complexType',valid,S308),
  ITResList132 = [ITRes131|ITResList131],


  ?line {STRes309,S309} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG047.xsd','./msxsdtest/complexType',valid),
  STResList310 = [STRes309|STResList309],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG047.xml','./msxsdtest/complexType',valid,S309),
  ITResList133 = [ITRes132|ITResList132],


  ?line {STRes310,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG048.xsd','./msxsdtest/complexType',invalid),
  STResList311 = [STRes310|STResList310],


  ?line {STRes311,S311} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG049.xsd','./msxsdtest/complexType',valid),
  STResList312 = [STRes311|STResList311],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG049.xml','./msxsdtest/complexType',valid,S311),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes312,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG050.xsd','./msxsdtest/complexType',invalid),
  STResList313 = [STRes312|STResList312],


  ?line {STRes313,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG051.xsd','./msxsdtest/complexType',invalid),
  STResList314 = [STRes313|STResList313],


  ?line {STRes314,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG052.xsd','./msxsdtest/complexType',invalid),
  STResList315 = [STRes314|STResList314],


  ?line {STRes315,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG053.xsd','./msxsdtest/complexType',invalid),
  STResList316 = [STRes315|STResList315],


  ?line {STRes316,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG054.xsd','./msxsdtest/complexType',invalid),
  STResList317 = [STRes316|STResList316],


  ?line {STRes317,S317} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG055.xsd','./msxsdtest/complexType',valid),
  STResList318 = [STRes317|STResList317],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG055.xml','./msxsdtest/complexType',valid,S317),
  ITResList135 = [ITRes134|ITResList134],


  ?line {STRes318,S318} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG056.xsd','./msxsdtest/complexType',valid),
  STResList319 = [STRes318|STResList318],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG056.xml','./msxsdtest/complexType',valid,S318),
  ITResList136 = [ITRes135|ITResList135],


  ?line {STRes319,S319} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG057.xsd','./msxsdtest/complexType',valid),
  STResList320 = [STRes319|STResList319],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG057.xml','./msxsdtest/complexType',valid,S319),
  ITResList137 = [ITRes136|ITResList136],


  ?line {STRes320,S320} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG058.xsd','./msxsdtest/complexType',valid),
  STResList321 = [STRes320|STResList320],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG058.xml','./msxsdtest/complexType',valid,S320),
  ITResList138 = [ITRes137|ITResList137],


  ?line {STRes321,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG059.xsd','./msxsdtest/complexType',invalid),
  STResList322 = [STRes321|STResList321],


  ?line {STRes322,S322} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG060.xsd','./msxsdtest/complexType',valid),
  STResList323 = [STRes322|STResList322],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG060.xml','./msxsdtest/complexType',valid,S322),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes323,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG061.xsd','./msxsdtest/complexType',invalid),
  STResList324 = [STRes323|STResList323],


  ?line {STRes324,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG062.xsd','./msxsdtest/complexType',invalid),
  STResList325 = [STRes324|STResList324],


  ?line {STRes325,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG063.xsd','./msxsdtest/complexType',invalid),
  STResList326 = [STRes325|STResList325],


  ?line {STRes326,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG064.xsd','./msxsdtest/complexType',invalid),
  STResList327 = [STRes326|STResList326],


  ?line {STRes327,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG065.xsd','./msxsdtest/complexType',invalid),
  STResList328 = [STRes327|STResList327],


  ?line {STRes328,S328} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG066.xsd','./msxsdtest/complexType',valid),
  STResList329 = [STRes328|STResList328],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG066.xml','./msxsdtest/complexType',valid,S328),
  ITResList140 = [ITRes139|ITResList139],


  ?line {STRes329,S329} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG067.xsd','./msxsdtest/complexType',valid),
  STResList330 = [STRes329|STResList329],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG067.xml','./msxsdtest/complexType',valid,S329),
  ITResList141 = [ITRes140|ITResList140],


  ?line {STRes330,S330} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG068.xsd','./msxsdtest/complexType',valid),
  STResList331 = [STRes330|STResList330],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG068.xml','./msxsdtest/complexType',valid,S330),
  ITResList142 = [ITRes141|ITResList141],


  ?line {STRes331,S331} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG069.xsd','./msxsdtest/complexType',valid),
  STResList332 = [STRes331|STResList331],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG069.xml','./msxsdtest/complexType',valid,S331),
  ITResList143 = [ITRes142|ITResList142],


  ?line {STRes332,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG070.xsd','./msxsdtest/complexType',invalid),
  STResList333 = [STRes332|STResList332],


  ?line {STRes333,S333} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG071.xsd','./msxsdtest/complexType',valid),
  STResList334 = [STRes333|STResList333],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctG071.xml','./msxsdtest/complexType',valid,S333),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes334,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG072.xsd','./msxsdtest/complexType',invalid),
  STResList335 = [STRes334|STResList334],


  ?line {STRes335,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG073.xsd','./msxsdtest/complexType',invalid),
  STResList336 = [STRes335|STResList335],


  ?line {STRes336,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG074.xsd','./msxsdtest/complexType',invalid),
  STResList337 = [STRes336|STResList336],


  ?line {STRes337,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG075.xsd','./msxsdtest/complexType',invalid),
  STResList338 = [STRes337|STResList337],


  ?line {STRes338,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG076.xsd','./msxsdtest/complexType',invalid),
  STResList339 = [STRes338|STResList338],


  ?line {STRes339,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG077.xsd','./msxsdtest/complexType',invalid),
  STResList340 = [STRes339|STResList339],


  ?line {STRes340,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG078.xsd','./msxsdtest/complexType',invalid),
  STResList341 = [STRes340|STResList340],


  ?line {STRes341,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG079.xsd','./msxsdtest/complexType',invalid),
  STResList342 = [STRes341|STResList341],


  ?line {STRes342,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG080.xsd','./msxsdtest/complexType',invalid),
  STResList343 = [STRes342|STResList342],


  ?line {STRes343,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctG081.xsd','./msxsdtest/complexType',invalid),
  STResList344 = [STRes343|STResList343],


  ?line {STRes344,S344} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH001.xsd','./msxsdtest/complexType',valid),
  STResList345 = [STRes344|STResList344],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH001.xml','./msxsdtest/complexType',valid,S344),
  ITResList145 = [ITRes144|ITResList144],


  ?line {STRes345,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH002.xsd','./msxsdtest/complexType',invalid),
  STResList346 = [STRes345|STResList345],


  ?line {STRes346,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH003.xsd','./msxsdtest/complexType',invalid),
  STResList347 = [STRes346|STResList346],


  ?line {STRes347,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH004.xsd','./msxsdtest/complexType',invalid),
  STResList348 = [STRes347|STResList347],


  ?line {STRes348,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH005.xsd','./msxsdtest/complexType',invalid),
  STResList349 = [STRes348|STResList348],


  ?line {STRes349,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH006.xsd','./msxsdtest/complexType',invalid),
  STResList350 = [STRes349|STResList349],


  ?line {STRes350,S350} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH007.xsd','./msxsdtest/complexType',valid),
  STResList351 = [STRes350|STResList350],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH007.xml','./msxsdtest/complexType',valid,S350),
  ITResList146 = [ITRes145|ITResList145],


  ?line {STRes351,S351} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH008.xsd','./msxsdtest/complexType',valid),
  STResList352 = [STRes351|STResList351],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH008.xml','./msxsdtest/complexType',valid,S351),
  ITResList147 = [ITRes146|ITResList146],


  ?line {STRes352,S352} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH009.xsd','./msxsdtest/complexType',valid),
  STResList353 = [STRes352|STResList352],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH009.xml','./msxsdtest/complexType',valid,S352),
  ITResList148 = [ITRes147|ITResList147],


  ?line {STRes353,S353} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH010.xsd','./msxsdtest/complexType',valid),
  STResList354 = [STRes353|STResList353],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH010.xml','./msxsdtest/complexType',valid,S353),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes354,S354} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH011.xsd','./msxsdtest/complexType',valid),
  STResList355 = [STRes354|STResList354],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH011.xml','./msxsdtest/complexType',valid,S354),
  ITResList150 = [ITRes149|ITResList149],


  ?line {STRes355,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH012.xsd','./msxsdtest/complexType',invalid),
  STResList356 = [STRes355|STResList355],


  ?line {STRes356,S356} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH013.xsd','./msxsdtest/complexType',valid),
  STResList357 = [STRes356|STResList356],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH013.xml','./msxsdtest/complexType',valid,S356),
  ITResList151 = [ITRes150|ITResList150],


  ?line {STRes357,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH014.xsd','./msxsdtest/complexType',invalid),
  STResList358 = [STRes357|STResList357],


  ?line {STRes358,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH015.xsd','./msxsdtest/complexType',invalid),
  STResList359 = [STRes358|STResList358],


  ?line {STRes359,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH016.xsd','./msxsdtest/complexType',invalid),
  STResList360 = [STRes359|STResList359],


  ?line {STRes360,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH017.xsd','./msxsdtest/complexType',invalid),
  STResList361 = [STRes360|STResList360],


  ?line {STRes361,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH018.xsd','./msxsdtest/complexType',invalid),
  STResList362 = [STRes361|STResList361],


  ?line {STRes362,S362} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH019.xsd','./msxsdtest/complexType',valid),
  STResList363 = [STRes362|STResList362],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH019.xml','./msxsdtest/complexType',valid,S362),
  ITResList152 = [ITRes151|ITResList151],


  ?line {STRes363,S363} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH020.xsd','./msxsdtest/complexType',valid),
  STResList364 = [STRes363|STResList363],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH020.xml','./msxsdtest/complexType',valid,S363),
  ITResList153 = [ITRes152|ITResList152],


  ?line {STRes364,S364} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH021.xsd','./msxsdtest/complexType',valid),
  STResList365 = [STRes364|STResList364],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH021.xml','./msxsdtest/complexType',valid,S364),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes365,S365} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH022.xsd','./msxsdtest/complexType',valid),
  STResList366 = [STRes365|STResList365],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH022.xml','./msxsdtest/complexType',valid,S365),
  ITResList155 = [ITRes154|ITResList154],


  ?line {STRes366,S366} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH023.xsd','./msxsdtest/complexType',valid),
  STResList367 = [STRes366|STResList366],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH023.xml','./msxsdtest/complexType',valid,S366),
  ITResList156 = [ITRes155|ITResList155],


  ?line {STRes367,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH024.xsd','./msxsdtest/complexType',invalid),
  STResList368 = [STRes367|STResList367],


  ?line {STRes368,S368} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH025.xsd','./msxsdtest/complexType',valid),
  STResList369 = [STRes368|STResList368],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH025.xml','./msxsdtest/complexType',valid,S368),
  ITResList157 = [ITRes156|ITResList156],


  ?line {STRes369,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH026.xsd','./msxsdtest/complexType',invalid),
  STResList370 = [STRes369|STResList369],


  ?line {STRes370,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH027.xsd','./msxsdtest/complexType',invalid),
  STResList371 = [STRes370|STResList370],


  ?line {STRes371,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH028.xsd','./msxsdtest/complexType',invalid),
  STResList372 = [STRes371|STResList371],


  ?line {STRes372,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH029.xsd','./msxsdtest/complexType',invalid),
  STResList373 = [STRes372|STResList372],


  ?line {STRes373,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH030.xsd','./msxsdtest/complexType',invalid),
  STResList374 = [STRes373|STResList373],


  ?line {STRes374,S374} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH031.xsd','./msxsdtest/complexType',valid),
  STResList375 = [STRes374|STResList374],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH031.xml','./msxsdtest/complexType',valid,S374),
  ITResList158 = [ITRes157|ITResList157],


  ?line {STRes375,S375} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH032.xsd','./msxsdtest/complexType',valid),
  STResList376 = [STRes375|STResList375],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH032.xml','./msxsdtest/complexType',valid,S375),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes376,S376} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH033.xsd','./msxsdtest/complexType',valid),
  STResList377 = [STRes376|STResList376],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH033.xml','./msxsdtest/complexType',valid,S376),
  ITResList160 = [ITRes159|ITResList159],


  ?line {STRes377,S377} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH034.xsd','./msxsdtest/complexType',valid),
  STResList378 = [STRes377|STResList377],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH034.xml','./msxsdtest/complexType',valid,S377),
  ITResList161 = [ITRes160|ITResList160],


  ?line {STRes378,S378} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH035.xsd','./msxsdtest/complexType',valid),
  STResList379 = [STRes378|STResList378],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH035.xml','./msxsdtest/complexType',valid,S378),
  ITResList162 = [ITRes161|ITResList161],


  ?line {STRes379,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH036.xsd','./msxsdtest/complexType',invalid),
  STResList380 = [STRes379|STResList379],


  ?line {STRes380,S380} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH037.xsd','./msxsdtest/complexType',valid),
  STResList381 = [STRes380|STResList380],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH037.xml','./msxsdtest/complexType',valid,S380),
  ITResList163 = [ITRes162|ITResList162],


  ?line {STRes381,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH038.xsd','./msxsdtest/complexType',invalid),
  STResList382 = [STRes381|STResList381],


  ?line {STRes382,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH039.xsd','./msxsdtest/complexType',invalid),
  STResList383 = [STRes382|STResList382],


  ?line {STRes383,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH040.xsd','./msxsdtest/complexType',invalid),
  STResList384 = [STRes383|STResList383],


  ?line {STRes384,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH041.xsd','./msxsdtest/complexType',invalid),
  STResList385 = [STRes384|STResList384],


  ?line {STRes385,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH042.xsd','./msxsdtest/complexType',invalid),
  STResList386 = [STRes385|STResList385],


  ?line {STRes386,S386} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH043.xsd','./msxsdtest/complexType',valid),
  STResList387 = [STRes386|STResList386],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH043.xml','./msxsdtest/complexType',valid,S386),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes387,S387} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH044.xsd','./msxsdtest/complexType',valid),
  STResList388 = [STRes387|STResList387],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH044.xml','./msxsdtest/complexType',valid,S387),
  ITResList165 = [ITRes164|ITResList164],


  ?line {STRes388,S388} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH045.xsd','./msxsdtest/complexType',valid),
  STResList389 = [STRes388|STResList388],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH045.xml','./msxsdtest/complexType',valid,S388),
  ITResList166 = [ITRes165|ITResList165],


  ?line {STRes389,S389} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH046.xsd','./msxsdtest/complexType',valid),
  STResList390 = [STRes389|STResList389],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH046.xml','./msxsdtest/complexType',valid,S389),
  ITResList167 = [ITRes166|ITResList166],


  ?line {STRes390,S390} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH047.xsd','./msxsdtest/complexType',valid),
  STResList391 = [STRes390|STResList390],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH047.xml','./msxsdtest/complexType',valid,S390),
  ITResList168 = [ITRes167|ITResList167],


  ?line {STRes391,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH048.xsd','./msxsdtest/complexType',invalid),
  STResList392 = [STRes391|STResList391],


  ?line {STRes392,S392} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH049.xsd','./msxsdtest/complexType',valid),
  STResList393 = [STRes392|STResList392],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH049.xml','./msxsdtest/complexType',valid,S392),
  ITResList169 = [ITRes168|ITResList168],


  ?line {STRes393,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH050.xsd','./msxsdtest/complexType',invalid),
  STResList394 = [STRes393|STResList393],


  ?line {STRes394,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH051.xsd','./msxsdtest/complexType',invalid),
  STResList395 = [STRes394|STResList394],


  ?line {STRes395,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH052.xsd','./msxsdtest/complexType',invalid),
  STResList396 = [STRes395|STResList395],


  ?line {STRes396,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH053.xsd','./msxsdtest/complexType',invalid),
  STResList397 = [STRes396|STResList396],


  ?line {STRes397,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH054.xsd','./msxsdtest/complexType',invalid),
  STResList398 = [STRes397|STResList397],


  ?line {STRes398,S398} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH055.xsd','./msxsdtest/complexType',valid),
  STResList399 = [STRes398|STResList398],
  ?line ITRes169 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH055.xml','./msxsdtest/complexType',valid,S398),
  ITResList170 = [ITRes169|ITResList169],


  ?line {STRes399,S399} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH056.xsd','./msxsdtest/complexType',valid),
  STResList400 = [STRes399|STResList399],
  ?line ITRes170 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH056.xml','./msxsdtest/complexType',valid,S399),
  ITResList171 = [ITRes170|ITResList170],


  ?line {STRes400,S400} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH057.xsd','./msxsdtest/complexType',valid),
  STResList401 = [STRes400|STResList400],
  ?line ITRes171 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH057.xml','./msxsdtest/complexType',valid,S400),
  ITResList172 = [ITRes171|ITResList171],


  ?line {STRes401,S401} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH058.xsd','./msxsdtest/complexType',valid),
  STResList402 = [STRes401|STResList401],
  ?line ITRes172 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH058.xml','./msxsdtest/complexType',valid,S401),
  ITResList173 = [ITRes172|ITResList172],


  ?line {STRes402,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH059.xsd','./msxsdtest/complexType',invalid),
  STResList403 = [STRes402|STResList402],


  ?line {STRes403,S403} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH060.xsd','./msxsdtest/complexType',valid),
  STResList404 = [STRes403|STResList403],
  ?line ITRes173 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH060.xml','./msxsdtest/complexType',valid,S403),
  ITResList174 = [ITRes173|ITResList173],


  ?line {STRes404,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH061.xsd','./msxsdtest/complexType',invalid),
  STResList405 = [STRes404|STResList404],


  ?line {STRes405,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH062.xsd','./msxsdtest/complexType',invalid),
  STResList406 = [STRes405|STResList405],


  ?line {STRes406,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH063.xsd','./msxsdtest/complexType',invalid),
  STResList407 = [STRes406|STResList406],


  ?line {STRes407,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH064.xsd','./msxsdtest/complexType',invalid),
  STResList408 = [STRes407|STResList407],


  ?line {STRes408,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH065.xsd','./msxsdtest/complexType',invalid),
  STResList409 = [STRes408|STResList408],


  ?line {STRes409,S409} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH066.xsd','./msxsdtest/complexType',valid),
  STResList410 = [STRes409|STResList409],
  ?line ITRes174 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH066.xml','./msxsdtest/complexType',valid,S409),
  ITResList175 = [ITRes174|ITResList174],


  ?line {STRes410,S410} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH067.xsd','./msxsdtest/complexType',valid),
  STResList411 = [STRes410|STResList410],
  ?line ITRes175 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH067.xml','./msxsdtest/complexType',valid,S410),
  ITResList176 = [ITRes175|ITResList175],


  ?line {STRes411,S411} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH068.xsd','./msxsdtest/complexType',valid),
  STResList412 = [STRes411|STResList411],
  ?line ITRes176 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH068.xml','./msxsdtest/complexType',valid,S411),
  ITResList177 = [ITRes176|ITResList176],


  ?line {STRes412,S412} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH069.xsd','./msxsdtest/complexType',valid),
  STResList413 = [STRes412|STResList412],
  ?line ITRes177 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH069.xml','./msxsdtest/complexType',valid,S412),
  ITResList178 = [ITRes177|ITResList177],


  ?line {STRes413,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH070.xsd','./msxsdtest/complexType',invalid),
  STResList414 = [STRes413|STResList413],


  ?line {STRes414,S414} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH071.xsd','./msxsdtest/complexType',valid),
  STResList415 = [STRes414|STResList414],
  ?line ITRes178 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH071.xml','./msxsdtest/complexType',valid,S414),
  ITResList179 = [ITRes178|ITResList178],


  ?line {STRes415,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH072.xsd','./msxsdtest/complexType',invalid),
  STResList416 = [STRes415|STResList415],


  ?line {STRes416,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH073.xsd','./msxsdtest/complexType',invalid),
  STResList417 = [STRes416|STResList416],


  ?line {STRes417,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH074.xsd','./msxsdtest/complexType',invalid),
  STResList418 = [STRes417|STResList417],


  ?line {STRes418,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH075.xsd','./msxsdtest/complexType',invalid),
  STResList419 = [STRes418|STResList418],


  ?line {STRes419,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH076.xsd','./msxsdtest/complexType',invalid),
  STResList420 = [STRes419|STResList419],


  ?line {STRes420,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH077.xsd','./msxsdtest/complexType',invalid),
  STResList421 = [STRes420|STResList420],


  ?line {STRes421,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH078.xsd','./msxsdtest/complexType',invalid),
  STResList422 = [STRes421|STResList421],


  ?line {STRes422,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH079.xsd','./msxsdtest/complexType',invalid),
  STResList423 = [STRes422|STResList422],


  ?line {STRes423,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH080.xsd','./msxsdtest/complexType',invalid),
  STResList424 = [STRes423|STResList423],


  ?line {STRes424,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH081.xsd','./msxsdtest/complexType',invalid),
  STResList425 = [STRes424|STResList424],


  ?line {STRes425,S425} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctH082.xsd','./msxsdtest/complexType',valid),
  STResList426 = [STRes425|STResList425],
  ?line ITRes179 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctH082.xml','./msxsdtest/complexType',valid,S425),
  ITResList180 = [ITRes179|ITResList179],


  ?line {STRes426,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI001.xsd','./msxsdtest/complexType',invalid),
  STResList427 = [STRes426|STResList426],


  ?line {STRes427,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI002.xsd','./msxsdtest/complexType',invalid),
  STResList428 = [STRes427|STResList427],


  ?line {STRes428,S428} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI003.xsd','./msxsdtest/complexType',valid),
  STResList429 = [STRes428|STResList428],
  ?line ITRes180 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI003.xml','./msxsdtest/complexType',valid,S428),
  ITResList181 = [ITRes180|ITResList180],


  ?line {STRes429,S429} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI004.xsd','./msxsdtest/complexType',valid),
  STResList430 = [STRes429|STResList429],
  ?line ITRes181 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI004.xml','./msxsdtest/complexType',valid,S429),
  ITResList182 = [ITRes181|ITResList181],


  ?line {STRes430,S430} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI005.xsd','./msxsdtest/complexType',valid),
  STResList431 = [STRes430|STResList430],
  ?line ITRes182 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI005.xml','./msxsdtest/complexType',valid,S430),
  ITResList183 = [ITRes182|ITResList182],


  ?line {STRes431,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI006.xsd','./msxsdtest/complexType',invalid),
  STResList432 = [STRes431|STResList431],


  ?line {STRes432,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI007.xsd','./msxsdtest/complexType',invalid),
  STResList433 = [STRes432|STResList432],


  ?line {STRes433,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI008.xsd','./msxsdtest/complexType',invalid),
  STResList434 = [STRes433|STResList433],


  ?line {STRes434,S434} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI009.xsd','./msxsdtest/complexType',valid),
  STResList435 = [STRes434|STResList434],
  ?line ITRes183 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI009.xml','./msxsdtest/complexType',valid,S434),
  ITResList184 = [ITRes183|ITResList183],


  ?line {STRes435,S435} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI010.xsd','./msxsdtest/complexType',valid),
  STResList436 = [STRes435|STResList435],
  ?line ITRes184 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI010.xml','./msxsdtest/complexType',valid,S435),
  ITResList185 = [ITRes184|ITResList184],


  ?line {STRes436,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI011.xsd','./msxsdtest/complexType',invalid),
  STResList437 = [STRes436|STResList436],


  ?line {STRes437,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI012.xsd','./msxsdtest/complexType',invalid),
  STResList438 = [STRes437|STResList437],


  ?line {STRes438,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI013.xsd','./msxsdtest/complexType',invalid),
  STResList439 = [STRes438|STResList438],


  ?line {STRes439,S439} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI014.xsd','./msxsdtest/complexType',valid),
  STResList440 = [STRes439|STResList439],
  ?line ITRes185 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI014.xml','./msxsdtest/complexType',valid,S439),
  ITResList186 = [ITRes185|ITResList185],


  ?line {STRes440,S440} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI015.xsd','./msxsdtest/complexType',valid),
  STResList441 = [STRes440|STResList440],
  ?line ITRes186 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI015.xml','./msxsdtest/complexType',valid,S440),
  ITResList187 = [ITRes186|ITResList186],


  ?line {STRes441,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI016.xsd','./msxsdtest/complexType',invalid),
  STResList442 = [STRes441|STResList441],


  ?line {STRes442,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI017.xsd','./msxsdtest/complexType',invalid),
  STResList443 = [STRes442|STResList442],


  ?line {STRes443,S443} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI018.xsd','./msxsdtest/complexType',valid),
  STResList444 = [STRes443|STResList443],
  ?line ITRes187 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI018.xml','./msxsdtest/complexType',valid,S443),
  ITResList188 = [ITRes187|ITResList187],


  ?line {STRes444,S444} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI019.xsd','./msxsdtest/complexType',valid),
  STResList445 = [STRes444|STResList444],
  ?line ITRes188 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI019.xml','./msxsdtest/complexType',valid,S444),
  ITResList189 = [ITRes188|ITResList188],


  ?line {STRes445,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI020.xsd','./msxsdtest/complexType',invalid),
  STResList446 = [STRes445|STResList445],


  ?line {STRes446,S446} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI021.xsd','./msxsdtest/complexType',valid),
  STResList447 = [STRes446|STResList446],
  ?line ITRes189 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI021.xml','./msxsdtest/complexType',valid,S446),
  ITResList190 = [ITRes189|ITResList189],


  ?line {STRes447,S447} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI022.xsd','./msxsdtest/complexType',valid),
  STResList448 = [STRes447|STResList447],
  ?line ITRes190 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI022.xml','./msxsdtest/complexType',valid,S447),
  ITResList191 = [ITRes190|ITResList190],


  ?line {STRes448,S448} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI023.xsd','./msxsdtest/complexType',valid),
  STResList449 = [STRes448|STResList448],
  ?line ITRes191 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI023.xml','./msxsdtest/complexType',valid,S448),
  ITResList192 = [ITRes191|ITResList191],


  ?line {STRes449,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI024.xsd','./msxsdtest/complexType',invalid),
  STResList450 = [STRes449|STResList449],


  ?line {STRes450,S450} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI025.xsd','./msxsdtest/complexType',valid),
  STResList451 = [STRes450|STResList450],
  ?line ITRes192 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI025.xml','./msxsdtest/complexType',valid,S450),
  ITResList193 = [ITRes192|ITResList192],


  ?line {STRes451,S451} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI026.xsd','./msxsdtest/complexType',valid),
  STResList452 = [STRes451|STResList451],
  ?line ITRes193 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI026.xml','./msxsdtest/complexType',valid,S451),
  ITResList194 = [ITRes193|ITResList193],


  ?line {STRes452,S452} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI027.xsd','./msxsdtest/complexType',valid),
  STResList453 = [STRes452|STResList452],
  ?line ITRes194 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI027.xml','./msxsdtest/complexType',valid,S452),
  ITResList195 = [ITRes194|ITResList194],


  ?line {STRes453,S453} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI028.xsd','./msxsdtest/complexType',valid),
  STResList454 = [STRes453|STResList453],
  ?line ITRes195 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI028.xml','./msxsdtest/complexType',valid,S453),
  ITResList196 = [ITRes195|ITResList195],


  ?line {STRes454,S454} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI029.xsd','./msxsdtest/complexType',valid),
  STResList455 = [STRes454|STResList454],
  ?line ITRes196 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI029.xml','./msxsdtest/complexType',valid,S454),
  ITResList197 = [ITRes196|ITResList196],


  ?line {STRes455,S455} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI030.xsd','./msxsdtest/complexType',valid),
  STResList456 = [STRes455|STResList455],
  ?line ITRes197 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI030.xml','./msxsdtest/complexType',invalid,S455),
  ITResList198 = [ITRes197|ITResList197],


  ?line {STRes456,S456} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI031.xsd','./msxsdtest/complexType',valid),
  STResList457 = [STRes456|STResList456],
  ?line ITRes198 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI031.xml','./msxsdtest/complexType',invalid,S456),
  ITResList199 = [ITRes198|ITResList198],


  ?line {STRes457,S457} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI032.xsd','./msxsdtest/complexType',valid),
  STResList458 = [STRes457|STResList457],
  ?line ITRes199 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI032.xml','./msxsdtest/complexType',invalid,S457),
  ITResList200 = [ITRes199|ITResList199],


  ?line {STRes458,S458} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI033.xsd','./msxsdtest/complexType',valid),
  STResList459 = [STRes458|STResList458],
  ?line ITRes200 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI033.xml','./msxsdtest/complexType',valid,S458),
  ITResList201 = [ITRes200|ITResList200],


  ?line {STRes459,S459} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI034.xsd','./msxsdtest/complexType',valid),
  STResList460 = [STRes459|STResList459],
  ?line ITRes201 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI034.xml','./msxsdtest/complexType',valid,S459),
  ITResList202 = [ITRes201|ITResList201],


  ?line {STRes460,S460} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI035.xsd','./msxsdtest/complexType',valid),
  STResList461 = [STRes460|STResList460],
  ?line ITRes202 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI035.xml','./msxsdtest/complexType',invalid,S460),
  ITResList203 = [ITRes202|ITResList202],


  ?line {STRes461,S461} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI036.xsd','./msxsdtest/complexType',valid),
  STResList462 = [STRes461|STResList461],
  ?line ITRes203 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI036.xml','./msxsdtest/complexType',valid,S461),
  ITResList204 = [ITRes203|ITResList203],


  ?line {STRes462,S462} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI037.xsd','./msxsdtest/complexType',valid),
  STResList463 = [STRes462|STResList462],
  ?line ITRes204 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI037.xml','./msxsdtest/complexType',valid,S462),
  ITResList205 = [ITRes204|ITResList204],


  ?line {STRes463,S463} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI038.xsd','./msxsdtest/complexType',valid),
  STResList464 = [STRes463|STResList463],
  ?line ITRes205 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI038.xml','./msxsdtest/complexType',invalid,S463),
  ITResList206 = [ITRes205|ITResList205],


  ?line {STRes464,S464} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI039.xsd','./msxsdtest/complexType',valid),
  STResList465 = [STRes464|STResList464],
  ?line ITRes206 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI039.xml','./msxsdtest/complexType',invalid,S464),
  ITResList207 = [ITRes206|ITResList206],


  ?line {STRes465,S465} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI040.xsd','./msxsdtest/complexType',valid),
  STResList466 = [STRes465|STResList465],
  ?line ITRes207 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI040.xml','./msxsdtest/complexType',valid,S465),
  ITResList208 = [ITRes207|ITResList207],


  ?line {STRes466,S466} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI041.xsd','./msxsdtest/complexType',valid),
  STResList467 = [STRes466|STResList466],
  ?line ITRes208 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI041.xml','./msxsdtest/complexType',valid,S466),
  ITResList209 = [ITRes208|ITResList208],


  ?line {STRes467,S467} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI042.xsd','./msxsdtest/complexType',valid),
  STResList468 = [STRes467|STResList467],
  ?line ITRes209 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI042.xml','./msxsdtest/complexType',invalid,S467),
  ITResList210 = [ITRes209|ITResList209],


  ?line {STRes468,S468} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI043.xsd','./msxsdtest/complexType',valid),
  STResList469 = [STRes468|STResList468],
  ?line ITRes210 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI043.xml','./msxsdtest/complexType',valid,S468),
  ITResList211 = [ITRes210|ITResList210],


  ?line {STRes469,S469} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI044.xsd','./msxsdtest/complexType',valid),
  STResList470 = [STRes469|STResList469],
  ?line ITRes211 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI044.xml','./msxsdtest/complexType',valid,S469),
  ITResList212 = [ITRes211|ITResList211],


  ?line {STRes470,S470} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI045.xsd','./msxsdtest/complexType',valid),
  STResList471 = [STRes470|STResList470],
  ?line ITRes212 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI045.xml','./msxsdtest/complexType',invalid,S470),
  ITResList213 = [ITRes212|ITResList212],


  ?line {STRes471,S471} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI046.xsd','./msxsdtest/complexType',valid),
  STResList472 = [STRes471|STResList471],
  ?line ITRes213 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI046.xml','./msxsdtest/complexType',valid,S471),
  ITResList214 = [ITRes213|ITResList213],


  ?line {STRes472,S472} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI047.xsd','./msxsdtest/complexType',valid),
  STResList473 = [STRes472|STResList472],
  ?line ITRes214 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI047.xml','./msxsdtest/complexType',valid,S472),
  ITResList215 = [ITRes214|ITResList214],


  ?line {STRes473,S473} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI048.xsd','./msxsdtest/complexType',valid),
  STResList474 = [STRes473|STResList473],
  ?line ITRes215 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI048.xml','./msxsdtest/complexType',invalid,S473),
  ITResList216 = [ITRes215|ITResList215],


  ?line {STRes474,S474} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI049.xsd','./msxsdtest/complexType',valid),
  STResList475 = [STRes474|STResList474],
  ?line ITRes216 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI049.xml','./msxsdtest/complexType',invalid,S474),
  ITResList217 = [ITRes216|ITResList216],


  ?line {STRes475,S475} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctI050.xsd','./msxsdtest/complexType',valid),
  STResList476 = [STRes475|STResList475],
  ?line ITRes217 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctI050.xml','./msxsdtest/complexType',valid,S475),
  ITResList218 = [ITRes217|ITResList217],


  ?line {STRes476,S476} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctJ001.xsd','./msxsdtest/complexType',valid),
  STResList477 = [STRes476|STResList476],
  ?line ITRes218 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctJ001.xml','./msxsdtest/complexType',valid,S476),
  ITResList219 = [ITRes218|ITResList218],


  ?line {STRes477,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctJ002.xsd','./msxsdtest/complexType',invalid),
  STResList478 = [STRes477|STResList477],


  ?line {STRes478,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctJ003.xsd','./msxsdtest/complexType',invalid),
  STResList479 = [STRes478|STResList478],


  ?line {STRes479,S479} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctK001.xsd','./msxsdtest/complexType',valid),
  STResList480 = [STRes479|STResList479],
  ?line ITRes219 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctK001.xml','./msxsdtest/complexType',valid,S479),
  ITResList220 = [ITRes219|ITResList219],


  ?line {STRes480,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctK002.xsd','./msxsdtest/complexType',invalid),
  STResList481 = [STRes480|STResList480],


  ?line {STRes481,S481} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL001.xsd','./msxsdtest/complexType',valid),
  STResList482 = [STRes481|STResList481],
  ?line ITRes220 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL001.xml','./msxsdtest/complexType',invalid,S481),
  ITResList221 = [ITRes220|ITResList220],


  ?line {STRes482,S482} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL002.xsd','./msxsdtest/complexType',valid),
  STResList483 = [STRes482|STResList482],
  ?line ITRes221 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL002.xml','./msxsdtest/complexType',invalid,S482),
  ITResList222 = [ITRes221|ITResList221],


  ?line {STRes483,S483} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL003.xsd','./msxsdtest/complexType',valid),
  STResList484 = [STRes483|STResList483],
  ?line ITRes222 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL003.xml','./msxsdtest/complexType',valid,S483),
  ITResList223 = [ITRes222|ITResList222],


  ?line {STRes484,S484} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL004.xsd','./msxsdtest/complexType',valid),
  STResList485 = [STRes484|STResList484],
  ?line ITRes223 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL004.xml','./msxsdtest/complexType',invalid,S484),
  ITResList224 = [ITRes223|ITResList223],


  ?line {STRes485,S485} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL005.xsd','./msxsdtest/complexType',valid),
  STResList486 = [STRes485|STResList485],
  ?line ITRes224 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL005.xml','./msxsdtest/complexType',valid,S485),
  ITResList225 = [ITRes224|ITResList224],


  ?line {STRes486,S486} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL006.xsd','./msxsdtest/complexType',valid),
  STResList487 = [STRes486|STResList486],
  ?line ITRes225 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL006.xml','./msxsdtest/complexType',invalid,S486),
  ITResList226 = [ITRes225|ITResList225],


  ?line {STRes487,S487} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL007.xsd','./msxsdtest/complexType',valid),
  STResList488 = [STRes487|STResList487],
  ?line ITRes226 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL007.xml','./msxsdtest/complexType',valid,S487),
  ITResList227 = [ITRes226|ITResList226],


  ?line {STRes488,S488} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL008.xsd','./msxsdtest/complexType',valid),
  STResList489 = [STRes488|STResList488],
  ?line ITRes227 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL008.xml','./msxsdtest/complexType',valid,S488),
  ITResList228 = [ITRes227|ITResList227],


  ?line {STRes489,S489} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL009.xsd','./msxsdtest/complexType',valid),
  STResList490 = [STRes489|STResList489],
  ?line ITRes228 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL009.xml','./msxsdtest/complexType',invalid,S489),
  ITResList229 = [ITRes228|ITResList228],


  ?line {STRes490,S490} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL010.xsd','./msxsdtest/complexType',valid),
  STResList491 = [STRes490|STResList490],
  ?line ITRes229 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL010.xml','./msxsdtest/complexType',invalid,S490),
  ITResList230 = [ITRes229|ITResList229],


  ?line {STRes491,S491} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL011.xsd','./msxsdtest/complexType',valid),
  STResList492 = [STRes491|STResList491],
  ?line ITRes230 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL011.xml','./msxsdtest/complexType',valid,S491),
  ITResList231 = [ITRes230|ITResList230],


  ?line {STRes492,S492} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL012.xsd','./msxsdtest/complexType',valid),
  STResList493 = [STRes492|STResList492],
  ?line ITRes231 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL012.xml','./msxsdtest/complexType',invalid,S492),
  ITResList232 = [ITRes231|ITResList231],


  ?line {STRes493,S493} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL013.xsd','./msxsdtest/complexType',valid),
  STResList494 = [STRes493|STResList493],
  ?line ITRes232 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL013.xml','./msxsdtest/complexType',invalid,S493),
  ITResList233 = [ITRes232|ITResList232],


  ?line {STRes494,S494} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL014.xsd','./msxsdtest/complexType',valid),
  STResList495 = [STRes494|STResList494],
  ?line ITRes233 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL014.xml','./msxsdtest/complexType',valid,S494),
  ITResList234 = [ITRes233|ITResList233],


  ?line {STRes495,S495} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL015.xsd','./msxsdtest/complexType',valid),
  STResList496 = [STRes495|STResList495],
  ?line ITRes234 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL015.xml','./msxsdtest/complexType',valid,S495),
  ITResList235 = [ITRes234|ITResList234],


  ?line {STRes496,S496} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL016.xsd','./msxsdtest/complexType',valid),
  STResList497 = [STRes496|STResList496],
  ?line ITRes235 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL016.xml','./msxsdtest/complexType',valid,S496),
  ITResList236 = [ITRes235|ITResList235],


  ?line {STRes497,S497} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL017.xsd','./msxsdtest/complexType',valid),
  STResList498 = [STRes497|STResList497],
  ?line ITRes236 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL017.xml','./msxsdtest/complexType',valid,S497),
  ITResList237 = [ITRes236|ITResList236],


  ?line {STRes498,S498} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL018.xsd','./msxsdtest/complexType',valid),
  STResList499 = [STRes498|STResList498],
  ?line ITRes237 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL018.xml','./msxsdtest/complexType',valid,S498),
  ITResList238 = [ITRes237|ITResList237],


  ?line {STRes499,S499} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL019.xsd','./msxsdtest/complexType',valid),
  STResList500 = [STRes499|STResList499],
  ?line ITRes238 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL019.xml','./msxsdtest/complexType',valid,S499),
  ITResList239 = [ITRes238|ITResList238],


  ?line {STRes500,S500} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL020.xsd','./msxsdtest/complexType',valid),
  STResList501 = [STRes500|STResList500],
  ?line ITRes239 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL020.xml','./msxsdtest/complexType',invalid,S500),
  ITResList240 = [ITRes239|ITResList239],


  ?line {STRes501,S501} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctL021.xsd','./msxsdtest/complexType',valid),
  STResList502 = [STRes501|STResList501],
  ?line ITRes240 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctL021.xml','./msxsdtest/complexType',valid,S501),
  ITResList241 = [ITRes240|ITResList240],


  ?line {STRes502,S502} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/bug67200.xsd','./msxsdtest/complexType',valid),
  STResList503 = [STRes502|STResList502],
  ?line ITRes241 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/bug67200.xml','./msxsdtest/complexType',valid,S502),
  ITResList242 = [ITRes241|ITResList241],


  ?line {STRes503,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctM001.xsd','./msxsdtest/complexType',invalid),
  STResList504 = [STRes503|STResList503],


  ?line {STRes504,S504} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctM002.xsd','./msxsdtest/complexType',valid),
  STResList505 = [STRes504|STResList504],
  ?line ITRes242 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctM002.xml','./msxsdtest/complexType',valid,S504),
  ITResList243 = [ITRes242|ITResList242],


  ?line {STRes505,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctM003.xsd','./msxsdtest/complexType',invalid),
  STResList506 = [STRes505|STResList505],


  ?line {STRes506,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctM004.xsd','./msxsdtest/complexType',invalid),
  STResList507 = [STRes506|STResList506],


  ?line {STRes507,S507} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctN001.xsd','./msxsdtest/complexType',valid),
  STResList508 = [STRes507|STResList507],
  ?line ITRes243 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctN001.xml','./msxsdtest/complexType',valid,S507),
  ITResList244 = [ITRes243|ITResList243],


  ?line {STRes508,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctN002.xsd','./msxsdtest/complexType',invalid),
  STResList509 = [STRes508|STResList508],


  ?line {STRes509,S509} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctN003.xsd','./msxsdtest/complexType',valid),
  STResList510 = [STRes509|STResList509],
  ?line ITRes244 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctN003.xml','./msxsdtest/complexType',valid,S509),
  ITResList245 = [ITRes244|ITResList244],


  ?line {STRes510,S510} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctN004.xsd','./msxsdtest/complexType',valid),
  STResList511 = [STRes510|STResList510],
  ?line ITRes245 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctN004.xml','./msxsdtest/complexType',valid,S510),
  ITResList246 = [ITRes245|ITResList245],


  ?line {STRes511,S511} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctO001.xsd','./msxsdtest/complexType',valid),
  STResList512 = [STRes511|STResList511],
  ?line ITRes246 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctO001.xml','./msxsdtest/complexType',valid,S511),
  ITResList247 = [ITRes246|ITResList246],


  ?line {STRes512,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctO002.xsd','./msxsdtest/complexType',invalid),
  STResList513 = [STRes512|STResList512],


  ?line {STRes513,S513} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctO003.xsd','./msxsdtest/complexType',valid),
  STResList514 = [STRes513|STResList513],
  ?line ITRes247 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctO003.xml','./msxsdtest/complexType',valid,S513),
  ITResList248 = [ITRes247|ITResList247],


  ?line {STRes514,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctO004.xsd','./msxsdtest/complexType',invalid),
  STResList515 = [STRes514|STResList514],


  ?line {STRes515,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctO005.xsd','./msxsdtest/complexType',invalid),
  STResList516 = [STRes515|STResList515],


  ?line {STRes516,S516} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctO006.xsd','./msxsdtest/complexType',valid),
  STResList517 = [STRes516|STResList516],
  ?line ITRes248 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/complexType/ctO006.xml','./msxsdtest/complexType',valid,S516),
  ITResList249 = [ITRes248|ITResList248],


  ?line {STRes517,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/complexType/ctO007.xsd','./msxsdtest/complexType',invalid),
  STResList518 = [STRes517|STResList517],


  xmerl_xsd_lib:compare_test_results(Config,STResList518,ITResList249).

%% 3.3.2 XML Representation of Element Declaration.
%% 3.3.4 Element Declaration Validation Rules.
%% element Validation checking.
%% Regular Expression Validation checking.
%% Bug Regressions Specs section: 3.3.4

elem(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA001.xsd','./msxsdtest/element',invalid),
  STResList1 = [STRes0|STResList0],


  ?line {STRes1,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA002.xsd','./msxsdtest/element',valid),
  STResList2 = [STRes1|STResList1],


  ?line {STRes2,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA003.xsd','./msxsdtest/element',valid),
  STResList3 = [STRes2|STResList2],


  ?line {STRes3,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA004.xsd','./msxsdtest/element',valid),
  STResList4 = [STRes3|STResList3],


  ?line {STRes4,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA005.xsd','./msxsdtest/element',valid),
  STResList5 = [STRes4|STResList4],


  ?line {STRes5,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA006.xsd','./msxsdtest/element',invalid),
  STResList6 = [STRes5|STResList5],


  ?line {STRes6,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA007.xsd','./msxsdtest/element',valid),
  STResList7 = [STRes6|STResList6],


  ?line {STRes7,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA009.xsd','./msxsdtest/element',invalid),
  STResList8 = [STRes7|STResList7],


  ?line {STRes8,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA010.xsd','./msxsdtest/element',invalid),
  STResList9 = [STRes8|STResList8],


  ?line {STRes9,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA011.xsd','./msxsdtest/element',invalid),
  STResList10 = [STRes9|STResList9],


  ?line {STRes10,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA012.xsd','./msxsdtest/element',invalid),
  STResList11 = [STRes10|STResList10],


  ?line {STRes11,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA013.xsd','./msxsdtest/element',invalid),
  STResList12 = [STRes11|STResList11],


  ?line {STRes12,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA014.xsd','./msxsdtest/element',invalid),
  STResList13 = [STRes12|STResList12],


  ?line {STRes13,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA015.xsd','./msxsdtest/element',valid),
  STResList14 = [STRes13|STResList13],


  ?line {STRes14,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA016.xsd','./msxsdtest/element',valid),
  STResList15 = [STRes14|STResList14],


  ?line {STRes15,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemA017.xsd','./msxsdtest/element',valid),
  STResList16 = [STRes15|STResList15],


  ?line {STRes16,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB001.xsd','./msxsdtest/element',valid),
  STResList17 = [STRes16|STResList16],


  ?line {STRes17,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB002.xsd','./msxsdtest/element',valid),
  STResList18 = [STRes17|STResList17],


  ?line {STRes18,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB003.xsd','./msxsdtest/element',invalid),
  STResList19 = [STRes18|STResList18],


  ?line {STRes19,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB004.xsd','./msxsdtest/element',invalid),
  STResList20 = [STRes19|STResList19],


  ?line {STRes20,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB005.xsd','./msxsdtest/element',invalid),
  STResList21 = [STRes20|STResList20],


  ?line {STRes21,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB006.xsd','./msxsdtest/element',invalid),
  STResList22 = [STRes21|STResList21],


  ?line {STRes22,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB007.xsd','./msxsdtest/element',valid),
  STResList23 = [STRes22|STResList22],


  ?line {STRes23,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB008.xsd','./msxsdtest/element',valid),
  STResList24 = [STRes23|STResList23],


  ?line {STRes24,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB009.xsd','./msxsdtest/element',invalid),
  STResList25 = [STRes24|STResList24],


  ?line {STRes25,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemB010.xsd','./msxsdtest/element',invalid),
  STResList26 = [STRes25|STResList25],


  ?line {STRes26,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC001.xsd','./msxsdtest/element',valid),
  STResList27 = [STRes26|STResList26],


  ?line {STRes27,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC002.xsd','./msxsdtest/element',valid),
  STResList28 = [STRes27|STResList27],


  ?line {STRes28,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC003.xsd','./msxsdtest/element',valid),
  STResList29 = [STRes28|STResList28],


  ?line {STRes29,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC004.xsd','./msxsdtest/element',valid),
  STResList30 = [STRes29|STResList29],


  ?line {STRes30,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC005.xsd','./msxsdtest/element',valid),
  STResList31 = [STRes30|STResList30],


  ?line {STRes31,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC006.xsd','./msxsdtest/element',valid),
  STResList32 = [STRes31|STResList31],


  ?line {STRes32,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC007.xsd','./msxsdtest/element',valid),
  STResList33 = [STRes32|STResList32],


  ?line {STRes33,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC008.xsd','./msxsdtest/element',valid),
  STResList34 = [STRes33|STResList33],


  ?line {STRes34,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC009.xsd','./msxsdtest/element',invalid),
  STResList35 = [STRes34|STResList34],


  ?line {STRes35,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC010.xsd','./msxsdtest/element',invalid),
  STResList36 = [STRes35|STResList35],


  ?line {STRes36,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC011.xsd','./msxsdtest/element',invalid),
  STResList37 = [STRes36|STResList36],


  ?line {STRes37,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC012.xsd','./msxsdtest/element',invalid),
  STResList38 = [STRes37|STResList37],


  ?line {STRes38,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC013.xsd','./msxsdtest/element',invalid),
  STResList39 = [STRes38|STResList38],


  ?line {STRes39,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC014.xsd','./msxsdtest/element',invalid),
  STResList40 = [STRes39|STResList39],


  ?line {STRes40,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC015.xsd','./msxsdtest/element',invalid),
  STResList41 = [STRes40|STResList40],


  ?line {STRes41,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC016.xsd','./msxsdtest/element',invalid),
  STResList42 = [STRes41|STResList41],


  ?line {STRes42,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC017.xsd','./msxsdtest/element',invalid),
  STResList43 = [STRes42|STResList42],


  ?line {STRes43,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC018.xsd','./msxsdtest/element',valid),
  STResList44 = [STRes43|STResList43],


  ?line {STRes44,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemC020.xsd','./msxsdtest/element',valid),
  STResList45 = [STRes44|STResList44],


  ?line {STRes45,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemD001.xsd','./msxsdtest/element',valid),
  STResList46 = [STRes45|STResList45],


  ?line {STRes46,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemD002.xsd','./msxsdtest/element',valid),
  STResList47 = [STRes46|STResList46],


  ?line {STRes47,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemD003.xsd','./msxsdtest/element',invalid),
  STResList48 = [STRes47|STResList47],


  ?line {STRes48,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemD004.xsd','./msxsdtest/element',invalid),
  STResList49 = [STRes48|STResList48],


  ?line {STRes49,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemD005.xsd','./msxsdtest/element',invalid),
  STResList50 = [STRes49|STResList49],


  ?line {STRes50,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemD006.xsd','./msxsdtest/element',valid),
  STResList51 = [STRes50|STResList50],


  ?line {STRes51,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemE001.xsd','./msxsdtest/element',valid),
  STResList52 = [STRes51|STResList51],


  ?line {STRes52,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemE002.xsd','./msxsdtest/element',valid),
  STResList53 = [STRes52|STResList52],


  ?line {STRes53,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemE003.xsd','./msxsdtest/element',valid),
  STResList54 = [STRes53|STResList53],


  ?line {STRes54,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemE004.xsd','./msxsdtest/element',valid),
  STResList55 = [STRes54|STResList54],


  ?line {STRes55,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemE005.xsd','./msxsdtest/element',valid),
  STResList56 = [STRes55|STResList55],


  ?line {STRes56,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemE006.xsd','./msxsdtest/element',invalid),
  STResList57 = [STRes56|STResList56],


  ?line {STRes57,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemE007.xsd','./msxsdtest/element',invalid),
  STResList58 = [STRes57|STResList57],


  ?line {STRes58,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemE008.xsd','./msxsdtest/element',invalid),
  STResList59 = [STRes58|STResList58],


  ?line {STRes59,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemE009.xsd','./msxsdtest/element',invalid),
  STResList60 = [STRes59|STResList59],


  ?line {STRes60,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF001.xsd','./msxsdtest/element',valid),
  STResList61 = [STRes60|STResList60],


  ?line {STRes61,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF002.xsd','./msxsdtest/element',valid),
  STResList62 = [STRes61|STResList61],


  ?line {STRes62,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF003.xsd','./msxsdtest/element',valid),
  STResList63 = [STRes62|STResList62],


  ?line {STRes63,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF004.xsd','./msxsdtest/element',invalid),
  STResList64 = [STRes63|STResList63],


  ?line {STRes64,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF005.xsd','./msxsdtest/element',valid),
  STResList65 = [STRes64|STResList64],


  ?line {STRes65,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF006.xsd','./msxsdtest/element',invalid),
  STResList66 = [STRes65|STResList65],


  ?line {STRes66,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF007.xsd','./msxsdtest/element',invalid),
  STResList67 = [STRes66|STResList66],


  ?line {STRes67,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF008.xsd','./msxsdtest/element',invalid),
  STResList68 = [STRes67|STResList67],


  ?line {STRes68,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF009.xsd','./msxsdtest/element',invalid),
  STResList69 = [STRes68|STResList68],


  ?line {STRes69,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF010.xsd','./msxsdtest/element',invalid),
  STResList70 = [STRes69|STResList69],


  ?line {STRes70,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF011.xsd','./msxsdtest/element',invalid),
  STResList71 = [STRes70|STResList70],


  ?line {STRes71,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF012.xsd','./msxsdtest/element',invalid),
  STResList72 = [STRes71|STResList71],


  ?line {STRes72,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF013.xsd','./msxsdtest/element',invalid),
  STResList73 = [STRes72|STResList72],


  ?line {STRes73,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF014.xsd','./msxsdtest/element',invalid),
  STResList74 = [STRes73|STResList73],


  ?line {STRes74,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF015.xsd','./msxsdtest/element',invalid),
  STResList75 = [STRes74|STResList74],


  ?line {STRes75,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF016.xsd','./msxsdtest/element',invalid),
  STResList76 = [STRes75|STResList75],


  ?line {STRes76,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF017.xsd','./msxsdtest/element',invalid),
  STResList77 = [STRes76|STResList76],


  ?line {STRes77,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemF018.xsd','./msxsdtest/element',valid),
  STResList78 = [STRes77|STResList77],


  ?line {STRes78,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemG001.xsd','./msxsdtest/element',valid),
  STResList79 = [STRes78|STResList78],


  ?line {STRes79,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemG002.xsd','./msxsdtest/element',valid),
  STResList80 = [STRes79|STResList79],


  ?line {STRes80,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemG003.xsd','./msxsdtest/element',invalid),
  STResList81 = [STRes80|STResList80],


  ?line {STRes81,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemG004.xsd','./msxsdtest/element',invalid),
  STResList82 = [STRes81|STResList81],


  ?line {STRes82,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemG005.xsd','./msxsdtest/element',valid),
  STResList83 = [STRes82|STResList82],


  ?line {STRes83,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemH001.xsd','./msxsdtest/element',valid),
  STResList84 = [STRes83|STResList83],


  ?line {STRes84,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemH002.xsd','./msxsdtest/element',valid),
  STResList85 = [STRes84|STResList84],


  ?line {STRes85,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemH003.xsd','./msxsdtest/element',invalid),
  STResList86 = [STRes85|STResList85],


  ?line {STRes86,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemH004.xsd','./msxsdtest/element',invalid),
  STResList87 = [STRes86|STResList86],


  ?line {STRes87,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemH005.xsd','./msxsdtest/element',invalid),
  STResList88 = [STRes87|STResList87],


  ?line {STRes88,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemH006.xsd','./msxsdtest/element',invalid),
  STResList89 = [STRes88|STResList88],


  ?line {STRes89,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemI001.xsd','./msxsdtest/element',valid),
  STResList90 = [STRes89|STResList89],


  ?line {STRes90,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemI002.xsd','./msxsdtest/element',valid),
  STResList91 = [STRes90|STResList90],


  ?line {STRes91,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemI003.xsd','./msxsdtest/element',invalid),
  STResList92 = [STRes91|STResList91],


  ?line {STRes92,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemI004.xsd','./msxsdtest/element',invalid),
  STResList93 = [STRes92|STResList92],


  ?line {STRes93,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemI005.xsd','./msxsdtest/element',invalid),
  STResList94 = [STRes93|STResList93],


  ?line {STRes94,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ001.xsd','./msxsdtest/element',valid),
  STResList95 = [STRes94|STResList94],


  ?line {STRes95,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ002.xsd','./msxsdtest/element',valid),
  STResList96 = [STRes95|STResList95],


  ?line {STRes96,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ003.xsd','./msxsdtest/element',valid),
  STResList97 = [STRes96|STResList96],


  ?line {STRes97,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ004.xsd','./msxsdtest/element',valid),
  STResList98 = [STRes97|STResList97],


  ?line {STRes98,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ005.xsd','./msxsdtest/element',valid),
  STResList99 = [STRes98|STResList98],


  ?line {STRes99,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ006.xsd','./msxsdtest/element',invalid),
  STResList100 = [STRes99|STResList99],


  ?line {STRes100,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ007.xsd','./msxsdtest/element',invalid),
  STResList101 = [STRes100|STResList100],


  ?line {STRes101,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ008.xsd','./msxsdtest/element',invalid),
  STResList102 = [STRes101|STResList101],


  ?line {STRes102,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ009.xsd','./msxsdtest/element',valid),
  STResList103 = [STRes102|STResList102],


  ?line {STRes103,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ010.xsd','./msxsdtest/element',valid),
  STResList104 = [STRes103|STResList103],


  ?line {STRes104,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ011.xsd','./msxsdtest/element',valid),
  STResList105 = [STRes104|STResList104],


  ?line {STRes105,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ012.xsd','./msxsdtest/element',invalid),
  STResList106 = [STRes105|STResList105],


  ?line {STRes106,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ013.xsd','./msxsdtest/element',valid),
  STResList107 = [STRes106|STResList106],


  ?line {STRes107,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ014.xsd','./msxsdtest/element',invalid),
  STResList108 = [STRes107|STResList107],


  ?line {STRes108,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ015.xsd','./msxsdtest/element',invalid),
  STResList109 = [STRes108|STResList108],


  ?line {STRes109,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ016.xsd','./msxsdtest/element',invalid),
  STResList110 = [STRes109|STResList109],


  ?line {STRes110,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ017.xsd','./msxsdtest/element',valid),
  STResList111 = [STRes110|STResList110],


  ?line {STRes111,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ018.xsd','./msxsdtest/element',valid),
  STResList112 = [STRes111|STResList111],


  ?line {STRes112,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ019.xsd','./msxsdtest/element',invalid),
  STResList113 = [STRes112|STResList112],


  ?line {STRes113,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ020.xsd','./msxsdtest/element',invalid),
  STResList114 = [STRes113|STResList113],


  ?line {STRes114,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemJ021.xsd','./msxsdtest/element',valid),
  STResList115 = [STRes114|STResList114],


  ?line {STRes115,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemK001.xsd','./msxsdtest/element',valid),
  STResList116 = [STRes115|STResList115],


  ?line {STRes116,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemK002.xsd','./msxsdtest/element',valid),
  STResList117 = [STRes116|STResList116],


  ?line {STRes117,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemK003.xsd','./msxsdtest/element',invalid),
  STResList118 = [STRes117|STResList117],


  ?line {STRes118,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemK004.xsd','./msxsdtest/element',invalid),
  STResList119 = [STRes118|STResList118],


  ?line {STRes119,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemK005.xsd','./msxsdtest/element',invalid),
  STResList120 = [STRes119|STResList119],


  ?line {STRes120,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemK006.xsd','./msxsdtest/element',invalid),
  STResList121 = [STRes120|STResList120],


  ?line {STRes121,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemK007.xsd','./msxsdtest/element',invalid),
  STResList122 = [STRes121|STResList121],


  ?line {STRes122,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemL001.xsd','./msxsdtest/element',valid),
  STResList123 = [STRes122|STResList122],


  ?line {STRes123,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemL002.xsd','./msxsdtest/element',invalid),
  STResList124 = [STRes123|STResList123],


  ?line {STRes124,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemL003.xsd','./msxsdtest/element',invalid),
  STResList125 = [STRes124|STResList124],


  ?line {STRes125,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemL004.xsd','./msxsdtest/element',valid),
  STResList126 = [STRes125|STResList125],


  ?line {STRes126,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemL005.xsd','./msxsdtest/element',valid),
  STResList127 = [STRes126|STResList126],


  ?line {STRes127,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemM001.xsd','./msxsdtest/element',valid),
  STResList128 = [STRes127|STResList127],


  ?line {STRes128,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemM002.xsd','./msxsdtest/element',invalid),
  STResList129 = [STRes128|STResList128],


  ?line {STRes129,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemM003.xsd','./msxsdtest/element',invalid),
  STResList130 = [STRes129|STResList129],


  ?line {STRes130,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemM004.xsd','./msxsdtest/element',valid),
  STResList131 = [STRes130|STResList130],


  ?line {STRes131,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemM005.xsd','./msxsdtest/element',invalid),
  STResList132 = [STRes131|STResList131],


  ?line {STRes132,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemN001.xsd','./msxsdtest/element',valid),
  STResList133 = [STRes132|STResList132],


  ?line {STRes133,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemN002.xsd','./msxsdtest/element',valid),
  STResList134 = [STRes133|STResList133],


  ?line {STRes134,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemN003.xsd','./msxsdtest/element',valid),
  STResList135 = [STRes134|STResList134],


  ?line {STRes135,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemN004.xsd','./msxsdtest/element',valid),
  STResList136 = [STRes135|STResList135],


  ?line {STRes136,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemN005.xsd','./msxsdtest/element',valid),
  STResList137 = [STRes136|STResList136],


  ?line {STRes137,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemN006.xsd','./msxsdtest/element',invalid),
  STResList138 = [STRes137|STResList137],


  ?line {STRes138,S138} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO001.xsd','./msxsdtest/element',valid),
  STResList139 = [STRes138|STResList138],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO001.xml','./msxsdtest/element',invalid,S138),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes139,S139} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO002.xsd','./msxsdtest/element',valid),
  STResList140 = [STRes139|STResList139],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO002.xml','./msxsdtest/element',valid,S139),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes140,S140} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO003.xsd','./msxsdtest/element',valid),
  STResList141 = [STRes140|STResList140],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO003.xml','./msxsdtest/element',valid,S140),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes141,S141} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO004.xsd','./msxsdtest/element',valid),
  STResList142 = [STRes141|STResList141],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO004.xml','./msxsdtest/element',valid,S141),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes142,S142} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO005.xsd','./msxsdtest/element',valid),
  STResList143 = [STRes142|STResList142],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO005.xml','./msxsdtest/element',valid,S142),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes143,S143} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO006.xsd','./msxsdtest/element',valid),
  STResList144 = [STRes143|STResList143],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO006.xml','./msxsdtest/element',valid,S143),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes144,S144} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO007.xsd','./msxsdtest/element',valid),
  STResList145 = [STRes144|STResList144],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO007.xml','./msxsdtest/element',invalid,S144),
  ITResList7 = [ITRes6|ITResList6],


  ?line {STRes145,S145} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO008.xsd','./msxsdtest/element',valid),
  STResList146 = [STRes145|STResList145],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO008.xml','./msxsdtest/element',valid,S145),
  ITResList8 = [ITRes7|ITResList7],


  ?line {STRes146,S146} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO009.xsd','./msxsdtest/element',valid),
  STResList147 = [STRes146|STResList146],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO009.xml','./msxsdtest/element',valid,S146),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes147,S147} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO010.xsd','./msxsdtest/element',valid),
  STResList148 = [STRes147|STResList147],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO010.xml','./msxsdtest/element',invalid,S147),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes148,S148} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO011.xsd','./msxsdtest/element',valid),
  STResList149 = [STRes148|STResList148],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO011.xml','./msxsdtest/element',invalid,S148),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes149,S149} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemO012.xsd','./msxsdtest/element',valid),
  STResList150 = [STRes149|STResList149],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemO012.xml','./msxsdtest/element',valid,S149),
  ITResList12 = [ITRes11|ITResList11],


  ?line {STRes150,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemP001.xsd','./msxsdtest/element',invalid),
  STResList151 = [STRes150|STResList150],


  ?line {STRes151,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemP002.xsd','./msxsdtest/element',invalid),
  STResList152 = [STRes151|STResList151],


  ?line {STRes152,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemP003.xsd','./msxsdtest/element',valid),
  STResList153 = [STRes152|STResList152],


  ?line {STRes153,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemP004.xsd','./msxsdtest/element',valid),
  STResList154 = [STRes153|STResList153],


  ?line {STRes154,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemP005.xsd','./msxsdtest/element',invalid),
  STResList155 = [STRes154|STResList154],


  ?line {STRes155,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemP006.xsd','./msxsdtest/element',invalid),
  STResList156 = [STRes155|STResList155],


  ?line {STRes156,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemP007.xsd','./msxsdtest/element',invalid),
  STResList157 = [STRes156|STResList156],


  ?line {STRes157,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemP008.xsd','./msxsdtest/element',invalid),
  STResList158 = [STRes157|STResList157],


  ?line {STRes158,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemP009.xsd','./msxsdtest/element',invalid),
  STResList159 = [STRes158|STResList158],


  ?line {STRes159,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ001.xsd','./msxsdtest/element',valid),
  STResList160 = [STRes159|STResList159],


  ?line {STRes160,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ002.xsd','./msxsdtest/element',valid),
  STResList161 = [STRes160|STResList160],


  ?line {STRes161,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ003.xsd','./msxsdtest/element',valid),
  STResList162 = [STRes161|STResList161],


  ?line {STRes162,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ004.xsd','./msxsdtest/element',invalid),
  STResList163 = [STRes162|STResList162],


  ?line {STRes163,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ005.xsd','./msxsdtest/element',valid),
  STResList164 = [STRes163|STResList163],


  ?line {STRes164,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ006.xsd','./msxsdtest/element',invalid),
  STResList165 = [STRes164|STResList164],


  ?line {STRes165,S165} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ007.xsd','./msxsdtest/element',valid),
  STResList166 = [STRes165|STResList165],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ007.xml','./msxsdtest/element',invalid,S165),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes166,S166} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ008.xsd','./msxsdtest/element',valid),
  STResList167 = [STRes166|STResList166],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ008.xml','./msxsdtest/element',valid,S166),
  ITResList14 = [ITRes13|ITResList13],


  ?line {STRes167,S167} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ009.xsd','./msxsdtest/element',valid),
  STResList168 = [STRes167|STResList167],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ009.xml','./msxsdtest/element',invalid,S167),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes168,S168} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ010.xsd','./msxsdtest/element',valid),
  STResList169 = [STRes168|STResList168],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ010.xml','./msxsdtest/element',invalid,S168),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes169,S169} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ011.xsd','./msxsdtest/element',valid),
  STResList170 = [STRes169|STResList169],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ011.xml','./msxsdtest/element',valid,S169),
  ITResList17 = [ITRes16|ITResList16],


  ?line {STRes170,S170} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ012.xsd','./msxsdtest/element',valid),
  STResList171 = [STRes170|STResList170],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ012.xml','./msxsdtest/element',invalid,S170),
  ITResList18 = [ITRes17|ITResList17],


  ?line {STRes171,S171} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ013.xsd','./msxsdtest/element',valid),
  STResList172 = [STRes171|STResList171],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ013.xml','./msxsdtest/element',valid,S171),
  ITResList19 = [ITRes18|ITResList18],


  ?line {STRes172,S172} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ014.xsd','./msxsdtest/element',valid),
  STResList173 = [STRes172|STResList172],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ014.xml','./msxsdtest/element',invalid,S172),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes173,S173} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ015.xsd','./msxsdtest/element',valid),
  STResList174 = [STRes173|STResList173],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ015.xml','./msxsdtest/element',valid,S173),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes174,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ016.xsd','./msxsdtest/element',valid),
  STResList175 = [STRes174|STResList174],


  ?line {STRes175,S175} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ017.xsd','./msxsdtest/element',valid),
  STResList176 = [STRes175|STResList175],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ017.xml','./msxsdtest/element',valid,S175),
  ITResList22 = [ITRes21|ITResList21],


  ?line {STRes176,S176} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ018.xsd','./msxsdtest/element',valid),
  STResList177 = [STRes176|STResList176],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ018.xml','./msxsdtest/element',invalid,S176),
  ITResList23 = [ITRes22|ITResList22],


  ?line {STRes177,S177} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ019.xsd','./msxsdtest/element',valid),
  STResList178 = [STRes177|STResList177],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ019.xml','./msxsdtest/element',invalid,S177),
  ITResList24 = [ITRes23|ITResList23],


  ?line {STRes178,S178} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ020.xsd','./msxsdtest/element',valid),
  STResList179 = [STRes178|STResList178],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ020.xml','./msxsdtest/element',valid,S178),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes179,S179} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ021.xsd','./msxsdtest/element',valid),
  STResList180 = [STRes179|STResList179],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ021.xml','./msxsdtest/element',valid,S179),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes180,S180} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemQ022.xsd','./msxsdtest/element',valid),
  STResList181 = [STRes180|STResList180],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemQ022.xml','./msxsdtest/element',valid,S180),
  ITResList27 = [ITRes26|ITResList26],


  ?line {STRes181,S181} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemR001.xsd','./msxsdtest/element',valid),
  STResList182 = [STRes181|STResList181],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemR001.xml','./msxsdtest/element',valid,S181),
  ITResList28 = [ITRes27|ITResList27],


  ?line {STRes182,S182} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemR002.xsd','./msxsdtest/element',valid),
  STResList183 = [STRes182|STResList182],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemR002.xml','./msxsdtest/element',valid,S182),
  ITResList29 = [ITRes28|ITResList28],


  ?line {STRes183,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemR003.xsd','./msxsdtest/element',invalid),
  STResList184 = [STRes183|STResList183],


  ?line {STRes184,S184} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemR004.xsd','./msxsdtest/element',valid),
  STResList185 = [STRes184|STResList184],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemR004.xml','./msxsdtest/element',valid,S184),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes185,S185} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemR005.xsd','./msxsdtest/element',valid),
  STResList186 = [STRes185|STResList185],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemR005.xml','./msxsdtest/element',valid,S185),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes186,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemR006.xsd','./msxsdtest/element',invalid),
  STResList187 = [STRes186|STResList186],


  ?line {STRes187,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemS001.xsd','./msxsdtest/element',invalid),
  STResList188 = [STRes187|STResList187],


  ?line {STRes188,S188} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemS002.xsd','./msxsdtest/element',valid),
  STResList189 = [STRes188|STResList188],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemS002.xml','./msxsdtest/element',valid,S188),
  ITResList32 = [ITRes31|ITResList31],


  ?line {STRes189,S189} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemS003.xsd','./msxsdtest/element',valid),
  STResList190 = [STRes189|STResList189],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemS003.xml','./msxsdtest/element',valid,S189),
  ITResList33 = [ITRes32|ITResList32],


  ?line {STRes190,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemS004.xsd','./msxsdtest/element',invalid),
  STResList191 = [STRes190|STResList190],


  ?line {STRes191,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemS005.xsd','./msxsdtest/element',invalid),
  STResList192 = [STRes191|STResList191],


  ?line {STRes192,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemS006.xsd','./msxsdtest/element',invalid),
  STResList193 = [STRes192|STResList192],


  ?line {STRes193,S193} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemS007.xsd','./msxsdtest/element',valid),
  STResList194 = [STRes193|STResList193],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemS007.xml','./msxsdtest/element',valid,S193),
  ITResList34 = [ITRes33|ITResList33],


  ?line {STRes194,S194} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemS008.xsd','./msxsdtest/element',valid),
  STResList195 = [STRes194|STResList194],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemS008.xml','./msxsdtest/element',valid,S194),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes195,S195} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT001.xsd','./msxsdtest/element',valid),
  STResList196 = [STRes195|STResList195],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT001.xml','./msxsdtest/element',invalid,S195),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes196,S196} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT002.xsd','./msxsdtest/element',valid),
  STResList197 = [STRes196|STResList196],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT002.xml','./msxsdtest/element',valid,S196),
  ITResList37 = [ITRes36|ITResList36],


  ?line {STRes197,S197} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT003.xsd','./msxsdtest/element',valid),
  STResList198 = [STRes197|STResList197],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT003.xml','./msxsdtest/element',valid,S197),
  ITResList38 = [ITRes37|ITResList37],


  ?line {STRes198,S198} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT004.xsd','./msxsdtest/element',valid),
  STResList199 = [STRes198|STResList198],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT004.xml','./msxsdtest/element',invalid,S198),
  ITResList39 = [ITRes38|ITResList38],


  ?line {STRes199,S199} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT005.xsd','./msxsdtest/element',valid),
  STResList200 = [STRes199|STResList199],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT005.xml','./msxsdtest/element',invalid,S199),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes200,S200} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT006.xsd','./msxsdtest/element',valid),
  STResList201 = [STRes200|STResList200],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT006.xml','./msxsdtest/element',invalid,S200),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes201,S201} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT007.xsd','./msxsdtest/element',valid),
  STResList202 = [STRes201|STResList201],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT007.xml','./msxsdtest/element',valid,S201),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes202,S202} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT008.xsd','./msxsdtest/element',valid),
  STResList203 = [STRes202|STResList202],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT008.xml','./msxsdtest/element',valid,S202),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes203,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT009.xsd','./msxsdtest/element',invalid),
  STResList204 = [STRes203|STResList203],


  ?line {STRes204,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT010.xsd','./msxsdtest/element',invalid),
  STResList205 = [STRes204|STResList204],


  ?line {STRes205,S205} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT011.xsd','./msxsdtest/element',valid),
  STResList206 = [STRes205|STResList205],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT011.xml','./msxsdtest/element',invalid,S205),
  ITResList44 = [ITRes43|ITResList43],


  ?line {STRes206,S206} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT012.xsd','./msxsdtest/element',valid),
  STResList207 = [STRes206|STResList206],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT012.xml','./msxsdtest/element',invalid,S206),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes207,S207} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT013.xsd','./msxsdtest/element',valid),
  STResList208 = [STRes207|STResList207],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT013.xml','./msxsdtest/element',invalid,S207),
  ITResList46 = [ITRes45|ITResList45],


  ?line {STRes208,S208} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT014.xsd','./msxsdtest/element',valid),
  STResList209 = [STRes208|STResList208],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT014.xml','./msxsdtest/element',valid,S208),
  ITResList47 = [ITRes46|ITResList46],


  ?line {STRes209,S209} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT015.xsd','./msxsdtest/element',valid),
  STResList210 = [STRes209|STResList209],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT015.xml','./msxsdtest/element',valid,S209),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes210,S210} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT016.xsd','./msxsdtest/element',valid),
  STResList211 = [STRes210|STResList210],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT016.xml','./msxsdtest/element',valid,S210),
  ITResList49 = [ITRes48|ITResList48],


  ?line {STRes211,S211} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT017.xsd','./msxsdtest/element',valid),
  STResList212 = [STRes211|STResList211],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT017.xml','./msxsdtest/element',invalid,S211),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes212,S212} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT018.xsd','./msxsdtest/element',valid),
  STResList213 = [STRes212|STResList212],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT018.xml','./msxsdtest/element',invalid,S212),
  ITResList51 = [ITRes50|ITResList50],


  ?line {STRes213,S213} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT019.xsd','./msxsdtest/element',valid),
  STResList214 = [STRes213|STResList213],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT019.xml','./msxsdtest/element',invalid,S213),
  ITResList52 = [ITRes51|ITResList51],


  ?line {STRes214,S214} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT022.xsd','./msxsdtest/element',valid),
  STResList215 = [STRes214|STResList214],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT022.xml','./msxsdtest/element',valid,S214),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes215,S215} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT024.xsd','./msxsdtest/element',valid),
  STResList216 = [STRes215|STResList215],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT024.xml','./msxsdtest/element',invalid,S215),
  ITResList54 = [ITRes53|ITResList53],


  ?line {STRes216,S216} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT025.xsd','./msxsdtest/element',valid),
  STResList217 = [STRes216|STResList216],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT025.xml','./msxsdtest/element',valid,S216),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes217,S217} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT026.xsd','./msxsdtest/element',valid),
  STResList218 = [STRes217|STResList217],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT026.xml','./msxsdtest/element',valid,S217),
  ITResList56 = [ITRes55|ITResList55],


  ?line {STRes218,S218} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT027.xsd','./msxsdtest/element',valid),
  STResList219 = [STRes218|STResList218],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT027.xml','./msxsdtest/element',valid,S218),
  ITResList57 = [ITRes56|ITResList56],


  ?line {STRes219,S219} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT028.xsd','./msxsdtest/element',valid),
  STResList220 = [STRes219|STResList219],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT028.xml','./msxsdtest/element',valid,S219),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes220,S220} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT029.xsd','./msxsdtest/element',valid),
  STResList221 = [STRes220|STResList220],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT029.xml','./msxsdtest/element',valid,S220),
  ITResList59 = [ITRes58|ITResList58],


  ?line {STRes221,S221} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT030.xsd','./msxsdtest/element',valid),
  STResList222 = [STRes221|STResList221],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT030.xml','./msxsdtest/element',valid,S221),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes222,S222} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT031.xsd','./msxsdtest/element',valid),
  STResList223 = [STRes222|STResList222],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT031.xml','./msxsdtest/element',invalid,S222),
  ITResList61 = [ITRes60|ITResList60],


  ?line {STRes223,S223} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT032.xsd','./msxsdtest/element',valid),
  STResList224 = [STRes223|STResList223],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT032.xml','./msxsdtest/element',valid,S223),
  ITResList62 = [ITRes61|ITResList61],


  ?line {STRes224,S224} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT033.xsd','./msxsdtest/element',valid),
  STResList225 = [STRes224|STResList224],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT033.xml','./msxsdtest/element',invalid,S224),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes225,S225} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT038.xsd','./msxsdtest/element',valid),
  STResList226 = [STRes225|STResList225],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT038.xml','./msxsdtest/element',valid,S225),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes226,S226} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT039.xsd','./msxsdtest/element',valid),
  STResList227 = [STRes226|STResList226],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT039.xml','./msxsdtest/element',invalid,S226),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes227,S227} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT040.xsd','./msxsdtest/element',valid),
  STResList228 = [STRes227|STResList227],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT040.xml','./msxsdtest/element',valid,S227),
  ITResList66 = [ITRes65|ITResList65],


  ?line {STRes228,S228} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT041.xsd','./msxsdtest/element',valid),
  STResList229 = [STRes228|STResList228],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT041.xml','./msxsdtest/element',valid,S228),
  ITResList67 = [ITRes66|ITResList66],


  ?line {STRes229,S229} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT042.xsd','./msxsdtest/element',valid),
  STResList230 = [STRes229|STResList229],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT042.xml','./msxsdtest/element',valid,S229),
  ITResList68 = [ITRes67|ITResList67],


  ?line {STRes230,S230} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT043.xsd','./msxsdtest/element',valid),
  STResList231 = [STRes230|STResList230],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT043.xml','./msxsdtest/element',valid,S230),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes231,S231} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT044.xsd','./msxsdtest/element',valid),
  STResList232 = [STRes231|STResList231],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT044.xml','./msxsdtest/element',valid,S231),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes232,S232} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT045.xsd','./msxsdtest/element',valid),
  STResList233 = [STRes232|STResList232],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT045.xml','./msxsdtest/element',invalid,S232),
  ITResList71 = [ITRes70|ITResList70],


  ?line {STRes233,S233} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT046.xsd','./msxsdtest/element',valid),
  STResList234 = [STRes233|STResList233],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT046.xml','./msxsdtest/element',invalid,S233),
  ITResList72 = [ITRes71|ITResList71],


  ?line {STRes234,S234} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT047.xsd','./msxsdtest/element',valid),
  STResList235 = [STRes234|STResList234],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT047.xml','./msxsdtest/element',invalid,S234),
  ITResList73 = [ITRes72|ITResList72],


  ?line {STRes235,S235} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT048.xsd','./msxsdtest/element',valid),
  STResList236 = [STRes235|STResList235],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT048.xml','./msxsdtest/element',invalid,S235),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes236,S236} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT049.xsd','./msxsdtest/element',valid),
  STResList237 = [STRes236|STResList236],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT049.xml','./msxsdtest/element',invalid,S236),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes237,S237} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT050.xsd','./msxsdtest/element',valid),
  STResList238 = [STRes237|STResList237],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT050.xml','./msxsdtest/element',invalid,S237),
  ITResList76 = [ITRes75|ITResList75],


  ?line {STRes238,S238} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT051.xsd','./msxsdtest/element',valid),
  STResList239 = [STRes238|STResList238],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT051.xml','./msxsdtest/element',invalid,S238),
  ITResList77 = [ITRes76|ITResList76],


  ?line {STRes239,S239} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT052.xsd','./msxsdtest/element',valid),
  STResList240 = [STRes239|STResList239],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT052.xml','./msxsdtest/element',invalid,S239),
  ITResList78 = [ITRes77|ITResList77],


  ?line {STRes240,S240} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT053.xsd','./msxsdtest/element',valid),
  STResList241 = [STRes240|STResList240],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT053.xml','./msxsdtest/element',invalid,S240),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes241,S241} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT054.xsd','./msxsdtest/element',valid),
  STResList242 = [STRes241|STResList241],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT054.xml','./msxsdtest/element',invalid,S241),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes242,S242} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT055.xsd','./msxsdtest/element',valid),
  STResList243 = [STRes242|STResList242],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT055.xml','./msxsdtest/element',invalid,S242),
  ITResList81 = [ITRes80|ITResList80],


  ?line {STRes243,S243} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT056.xsd','./msxsdtest/element',valid),
  STResList244 = [STRes243|STResList243],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT056.xml','./msxsdtest/element',invalid,S243),
  ITResList82 = [ITRes81|ITResList81],


  ?line {STRes244,S244} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT057.xsd','./msxsdtest/element',valid),
  STResList245 = [STRes244|STResList244],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT057.xml','./msxsdtest/element',invalid,S244),
  ITResList83 = [ITRes82|ITResList82],


  ?line {STRes245,S245} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT058.xsd','./msxsdtest/element',valid),
  STResList246 = [STRes245|STResList245],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT058.xml','./msxsdtest/element',valid,S245),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes246,S246} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemT074.xsd','./msxsdtest/element',valid),
  STResList247 = [STRes246|STResList246],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemT074.xml','./msxsdtest/element',invalid,S246),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes247,S247} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU001.xsd','./msxsdtest/element',valid),
  STResList248 = [STRes247|STResList247],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU001.xml','./msxsdtest/element',valid,S247),
  ITResList86 = [ITRes85|ITResList85],


  ?line {STRes248,S248} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU002.xsd','./msxsdtest/element',valid),
  STResList249 = [STRes248|STResList248],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU002.xml','./msxsdtest/element',valid,S248),
  ITResList87 = [ITRes86|ITResList86],


  ?line {STRes249,S249} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU003.xsd','./msxsdtest/element',valid),
  STResList250 = [STRes249|STResList249],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU003.xml','./msxsdtest/element',valid,S249),
  ITResList88 = [ITRes87|ITResList87],


  ?line {STRes250,S250} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU004.xsd','./msxsdtest/element',valid),
  STResList251 = [STRes250|STResList250],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU004.xml','./msxsdtest/element',valid,S250),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes251,S251} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU005.xsd','./msxsdtest/element',valid),
  STResList252 = [STRes251|STResList251],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU005.xml','./msxsdtest/element',valid,S251),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes252,S252} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU006.xsd','./msxsdtest/element',valid),
  STResList253 = [STRes252|STResList252],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU006.xml','./msxsdtest/element',valid,S252),
  ITResList91 = [ITRes90|ITResList90],


  ?line {STRes253,S253} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU007.xsd','./msxsdtest/element',valid),
  STResList254 = [STRes253|STResList253],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU007.xml','./msxsdtest/element',valid,S253),
  ITResList92 = [ITRes91|ITResList91],


  ?line {STRes254,S254} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU008.xsd','./msxsdtest/element',valid),
  STResList255 = [STRes254|STResList254],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU008.xml','./msxsdtest/element',valid,S254),
  ITResList93 = [ITRes92|ITResList92],


  ?line {STRes255,S255} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU009.xsd','./msxsdtest/element',valid),
  STResList256 = [STRes255|STResList255],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU009.xml','./msxsdtest/element',valid,S255),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes256,S256} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU010.xsd','./msxsdtest/element',valid),
  STResList257 = [STRes256|STResList256],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU010.xml','./msxsdtest/element',valid,S256),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes257,S257} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU011.xsd','./msxsdtest/element',valid),
  STResList258 = [STRes257|STResList257],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU011.xml','./msxsdtest/element',valid,S257),
  ITResList96 = [ITRes95|ITResList95],


  ?line {STRes258,S258} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU012.xsd','./msxsdtest/element',valid),
  STResList259 = [STRes258|STResList258],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU012.xml','./msxsdtest/element',valid,S258),
  ITResList97 = [ITRes96|ITResList96],


  ?line {STRes259,S259} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU013.xsd','./msxsdtest/element',valid),
  STResList260 = [STRes259|STResList259],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU013.xml','./msxsdtest/element',valid,S259),
  ITResList98 = [ITRes97|ITResList97],


  ?line {STRes260,S260} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU014.xsd','./msxsdtest/element',valid),
  STResList261 = [STRes260|STResList260],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU014.xml','./msxsdtest/element',valid,S260),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes261,S261} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU015.xsd','./msxsdtest/element',valid),
  STResList262 = [STRes261|STResList261],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU015.xml','./msxsdtest/element',valid,S261),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes262,S262} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU017.xsd','./msxsdtest/element',valid),
  STResList263 = [STRes262|STResList262],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU017.xml','./msxsdtest/element',valid,S262),
  ITResList101 = [ITRes100|ITResList100],


  ?line {STRes263,S263} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU018.xsd','./msxsdtest/element',valid),
  STResList264 = [STRes263|STResList263],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU018.xml','./msxsdtest/element',valid,S263),
  ITResList102 = [ITRes101|ITResList101],


  ?line {STRes264,S264} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU019.xsd','./msxsdtest/element',valid),
  STResList265 = [STRes264|STResList264],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU019.xml','./msxsdtest/element',valid,S264),
  ITResList103 = [ITRes102|ITResList102],


  ?line {STRes265,S265} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU020.xsd','./msxsdtest/element',valid),
  STResList266 = [STRes265|STResList265],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU020.xml','./msxsdtest/element',valid,S265),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes266,S266} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU021.xsd','./msxsdtest/element',valid),
  STResList267 = [STRes266|STResList266],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU021.xml','./msxsdtest/element',valid,S266),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes267,S267} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU022.xsd','./msxsdtest/element',valid),
  STResList268 = [STRes267|STResList267],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU022.xml','./msxsdtest/element',valid,S267),
  ITResList106 = [ITRes105|ITResList105],


  ?line {STRes268,S268} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU023.xsd','./msxsdtest/element',valid),
  STResList269 = [STRes268|STResList268],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU023.xml','./msxsdtest/element',valid,S268),
  ITResList107 = [ITRes106|ITResList106],


  ?line {STRes269,S269} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU024.xsd','./msxsdtest/element',valid),
  STResList270 = [STRes269|STResList269],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU024.xml','./msxsdtest/element',valid,S269),
  ITResList108 = [ITRes107|ITResList107],


  ?line {STRes270,S270} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemU025.xsd','./msxsdtest/element',valid),
  STResList271 = [STRes270|STResList270],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemU025.xml','./msxsdtest/element',invalid,S270),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes271,S271} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemZ001.xsd','./msxsdtest/element',valid),
  STResList272 = [STRes271|STResList271],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemZ001.xml','./msxsdtest/element',invalid,S271),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes272,S272} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemZ002.xsd','./msxsdtest/element',valid),
  STResList273 = [STRes272|STResList272],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemZ002.xml','./msxsdtest/element',valid,S272),
  ITResList111 = [ITRes110|ITResList110],


  ?line {STRes273,S273} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemZ003.xsd','./msxsdtest/element',valid),
  STResList274 = [STRes273|STResList273],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/element/elemZ003.xml','./msxsdtest/element',valid,S273),
  ITResList112 = [ITRes111|ITResList111],


  ?line {STRes274,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemZ004.xsd','./msxsdtest/element',valid),
  STResList275 = [STRes274|STResList274],


  ?line {STRes275,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/element/elemZ005.xsd','./msxsdtest/element',valid),
  STResList276 = [STRes275|STResList275],


  xmerl_xsd_lib:compare_test_results(Config,STResList276,ITResList112).

%% Syntax Checking Model Group Tests.
%% Content Checking Model Group Tests.
model_group(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA001.xsd','./msxsdtest/Group',valid),
  STResList1 = [STRes0|STResList0],


  ?line {STRes1,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA002.xsd','./msxsdtest/Group',valid),
  STResList2 = [STRes1|STResList1],


  ?line {STRes2,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA003.xsd','./msxsdtest/Group',invalid),
  STResList3 = [STRes2|STResList2],


  ?line {STRes3,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA004.xsd','./msxsdtest/Group',invalid),
  STResList4 = [STRes3|STResList3],


  ?line {STRes4,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA005.xsd','./msxsdtest/Group',invalid),
  STResList5 = [STRes4|STResList4],


  ?line {STRes5,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA006.xsd','./msxsdtest/Group',invalid),
  STResList6 = [STRes5|STResList5],


  ?line {STRes6,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA007.xsd','./msxsdtest/Group',invalid),
  STResList7 = [STRes6|STResList6],


  ?line {STRes7,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA008.xsd','./msxsdtest/Group',invalid),
  STResList8 = [STRes7|STResList7],


  ?line {STRes8,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA009.xsd','./msxsdtest/Group',invalid),
  STResList9 = [STRes8|STResList8],


  ?line {STRes9,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA010.xsd','./msxsdtest/Group',invalid),
  STResList10 = [STRes9|STResList9],


  ?line {STRes10,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA011.xsd','./msxsdtest/Group',valid),
  STResList11 = [STRes10|STResList10],


  ?line {STRes11,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupA012.xsd','./msxsdtest/Group',invalid),
  STResList12 = [STRes11|STResList11],


  ?line {STRes12,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB001.xsd','./msxsdtest/Group',invalid),
  STResList13 = [STRes12|STResList12],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB002.xsd','./msxsdtest/Group',valid),
  STResList14 = [STRes13|STResList13],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupB002.xml','./msxsdtest/Group',valid,S13),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB003.xsd','./msxsdtest/Group',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupB003.xml','./msxsdtest/Group',valid,S14),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB004.xsd','./msxsdtest/Group',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupB004.xml','./msxsdtest/Group',valid,S15),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB005.xsd','./msxsdtest/Group',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupB005.xml','./msxsdtest/Group',valid,S16),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB006.xsd','./msxsdtest/Group',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupB006.xml','./msxsdtest/Group',valid,S17),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes18,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB007.xsd','./msxsdtest/Group',invalid),
  STResList19 = [STRes18|STResList18],


  ?line {STRes19,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB008.xsd','./msxsdtest/Group',invalid),
  STResList20 = [STRes19|STResList19],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB009.xsd','./msxsdtest/Group',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupB009.xml','./msxsdtest/Group',valid,S20),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB010.xsd','./msxsdtest/Group',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupB010.xml','./msxsdtest/Group',valid,S21),
  ITResList7 = [ITRes6|ITResList6],


  ?line {STRes22,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB011.xsd','./msxsdtest/Group',invalid),
  STResList23 = [STRes22|STResList22],


  ?line {STRes23,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB012.xsd','./msxsdtest/Group',invalid),
  STResList24 = [STRes23|STResList23],


  ?line {STRes24,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB013.xsd','./msxsdtest/Group',invalid),
  STResList25 = [STRes24|STResList24],


  ?line {STRes25,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB014.xsd','./msxsdtest/Group',invalid),
  STResList26 = [STRes25|STResList25],


  ?line {STRes26,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB015.xsd','./msxsdtest/Group',invalid),
  STResList27 = [STRes26|STResList26],


  ?line {STRes27,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB016.xsd','./msxsdtest/Group',invalid),
  STResList28 = [STRes27|STResList27],


  ?line {STRes28,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupB017.xsd','./msxsdtest/Group',valid),
  STResList29 = [STRes28|STResList28],


  ?line {STRes29,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC001.xsd','./msxsdtest/Group',invalid),
  STResList30 = [STRes29|STResList29],


  ?line {STRes30,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC002.xsd','./msxsdtest/Group',invalid),
  STResList31 = [STRes30|STResList30],


  ?line {STRes31,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC003.xsd','./msxsdtest/Group',invalid),
  STResList32 = [STRes31|STResList31],


  ?line {STRes32,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC004.xsd','./msxsdtest/Group',invalid),
  STResList33 = [STRes32|STResList32],


  ?line {STRes33,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC005.xsd','./msxsdtest/Group',invalid),
  STResList34 = [STRes33|STResList33],


  ?line {STRes34,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC006.xsd','./msxsdtest/Group',invalid),
  STResList35 = [STRes34|STResList34],


  ?line {STRes35,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC007.xsd','./msxsdtest/Group',invalid),
  STResList36 = [STRes35|STResList35],


  ?line {STRes36,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC008.xsd','./msxsdtest/Group',invalid),
  STResList37 = [STRes36|STResList36],


  ?line {STRes37,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC009.xsd','./msxsdtest/Group',invalid),
  STResList38 = [STRes37|STResList37],


  ?line {STRes38,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC010.xsd','./msxsdtest/Group',invalid),
  STResList39 = [STRes38|STResList38],


  ?line {STRes39,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC011.xsd','./msxsdtest/Group',valid),
  STResList40 = [STRes39|STResList39],


  ?line {STRes40,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupC012.xsd','./msxsdtest/Group',invalid),
  STResList41 = [STRes40|STResList40],


  ?line {STRes41,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupD001.xsd','./msxsdtest/Group',invalid),
  STResList42 = [STRes41|STResList41],


  ?line {STRes42,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupD002.xsd','./msxsdtest/Group',invalid),
  STResList43 = [STRes42|STResList42],


  ?line {STRes43,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupD003.xsd','./msxsdtest/Group',invalid),
  STResList44 = [STRes43|STResList43],


  ?line {STRes44,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupD004.xsd','./msxsdtest/Group',invalid),
  STResList45 = [STRes44|STResList44],


  ?line {STRes45,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupE001.xsd','./msxsdtest/Group',valid),
  STResList46 = [STRes45|STResList45],


  ?line {STRes46,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupE002.xsd','./msxsdtest/Group',invalid),
  STResList47 = [STRes46|STResList46],


  ?line {STRes47,S47} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupE003.xsd','./msxsdtest/Group',valid),
  STResList48 = [STRes47|STResList47],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupE003.xml','./msxsdtest/Group',invalid,S47),
  ITResList8 = [ITRes7|ITResList7],


  ?line {STRes48,S48} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupE004.xsd','./msxsdtest/Group',valid),
  STResList49 = [STRes48|STResList48],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupE004.xml','./msxsdtest/Group',valid,S48),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes49,S49} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupE005.xsd','./msxsdtest/Group',valid),
  STResList50 = [STRes49|STResList49],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupE005.xml','./msxsdtest/Group',invalid,S49),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes50,S50} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF001.xsd','./msxsdtest/Group',valid),
  STResList51 = [STRes50|STResList50],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF001.xml','./msxsdtest/Group',valid,S50),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes51,S51} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF002.xsd','./msxsdtest/Group',valid),
  STResList52 = [STRes51|STResList51],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF002.xml','./msxsdtest/Group',valid,S51),
  ITResList12 = [ITRes11|ITResList11],


  ?line {STRes52,S52} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF003.xsd','./msxsdtest/Group',valid),
  STResList53 = [STRes52|STResList52],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF003.xml','./msxsdtest/Group',invalid,S52),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes53,S53} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF004.xsd','./msxsdtest/Group',valid),
  STResList54 = [STRes53|STResList53],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF004.xml','./msxsdtest/Group',valid,S53),
  ITResList14 = [ITRes13|ITResList13],


  ?line {STRes54,S54} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF005.xsd','./msxsdtest/Group',valid),
  STResList55 = [STRes54|STResList54],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF005.xml','./msxsdtest/Group',valid,S54),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes55,S55} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF006.xsd','./msxsdtest/Group',valid),
  STResList56 = [STRes55|STResList55],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF006.xml','./msxsdtest/Group',invalid,S55),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes56,S56} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF007.xsd','./msxsdtest/Group',valid),
  STResList57 = [STRes56|STResList56],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF007.xml','./msxsdtest/Group',valid,S56),
  ITResList17 = [ITRes16|ITResList16],


  ?line {STRes57,S57} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF008.xsd','./msxsdtest/Group',valid),
  STResList58 = [STRes57|STResList57],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF008.xml','./msxsdtest/Group',invalid,S57),
  ITResList18 = [ITRes17|ITResList17],


  ?line {STRes58,S58} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF009.xsd','./msxsdtest/Group',valid),
  STResList59 = [STRes58|STResList58],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF009.xml','./msxsdtest/Group',valid,S58),
  ITResList19 = [ITRes18|ITResList18],


  ?line {STRes59,S59} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF010.xsd','./msxsdtest/Group',valid),
  STResList60 = [STRes59|STResList59],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF010.xml','./msxsdtest/Group',invalid,S59),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes60,S60} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF011.xsd','./msxsdtest/Group',valid),
  STResList61 = [STRes60|STResList60],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF011.xml','./msxsdtest/Group',valid,S60),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes61,S61} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF012.xsd','./msxsdtest/Group',valid),
  STResList62 = [STRes61|STResList61],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF012.xml','./msxsdtest/Group',invalid,S61),
  ITResList22 = [ITRes21|ITResList21],


  ?line {STRes62,S62} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF013.xsd','./msxsdtest/Group',valid),
  STResList63 = [STRes62|STResList62],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF013.xml','./msxsdtest/Group',invalid,S62),
  ITResList23 = [ITRes22|ITResList22],


  ?line {STRes63,S63} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF014.xsd','./msxsdtest/Group',valid),
  STResList64 = [STRes63|STResList63],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF014.xml','./msxsdtest/Group',valid,S63),
  ITResList24 = [ITRes23|ITResList23],


  ?line {STRes64,S64} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF015.xsd','./msxsdtest/Group',valid),
  STResList65 = [STRes64|STResList64],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF015.xml','./msxsdtest/Group',invalid,S64),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes65,S65} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF016.xsd','./msxsdtest/Group',valid),
  STResList66 = [STRes65|STResList65],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF016.xml','./msxsdtest/Group',invalid,S65),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes66,S66} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF017.xsd','./msxsdtest/Group',valid),
  STResList67 = [STRes66|STResList66],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF017.xml','./msxsdtest/Group',valid,S66),
  ITResList27 = [ITRes26|ITResList26],


  ?line {STRes67,S67} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF018.xsd','./msxsdtest/Group',valid),
  STResList68 = [STRes67|STResList67],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF018.xml','./msxsdtest/Group',valid,S67),
  ITResList28 = [ITRes27|ITResList27],


  ?line {STRes68,S68} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF019.xsd','./msxsdtest/Group',valid),
  STResList69 = [STRes68|STResList68],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF019.xml','./msxsdtest/Group',invalid,S68),
  ITResList29 = [ITRes28|ITResList28],


  ?line {STRes69,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF020.xsd','./msxsdtest/Group',invalid),
  STResList70 = [STRes69|STResList69],


  ?line {STRes70,S70} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF021.xsd','./msxsdtest/Group',valid),
  STResList71 = [STRes70|STResList70],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupF021.xml','./msxsdtest/Group',valid,S70),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes71,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF022.xsd','./msxsdtest/Group',invalid),
  STResList72 = [STRes71|STResList71],


  ?line {STRes72,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF023.xsd','./msxsdtest/Group',invalid),
  STResList73 = [STRes72|STResList72],


  ?line {STRes73,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF024.xsd','./msxsdtest/Group',invalid),
  STResList74 = [STRes73|STResList73],


  ?line {STRes74,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupF025.xsd','./msxsdtest/Group',invalid),
  STResList75 = [STRes74|STResList74],


  ?line {STRes75,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupG001.xsd','./msxsdtest/Group',valid),
  STResList76 = [STRes75|STResList75],


  ?line {STRes76,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupG002.xsd','./msxsdtest/Group',invalid),
  STResList77 = [STRes76|STResList76],


  ?line {STRes77,S77} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupG003.xsd','./msxsdtest/Group',valid),
  STResList78 = [STRes77|STResList77],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupG003.xml','./msxsdtest/Group',invalid,S77),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes78,S78} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupG004.xsd','./msxsdtest/Group',valid),
  STResList79 = [STRes78|STResList78],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupG004.xml','./msxsdtest/Group',valid,S78),
  ITResList32 = [ITRes31|ITResList31],


  ?line {STRes79,S79} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupG005.xsd','./msxsdtest/Group',valid),
  STResList80 = [STRes79|STResList79],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupG005.xml','./msxsdtest/Group',invalid,S79),
  ITResList33 = [ITRes32|ITResList32],


  ?line {STRes80,S80} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH001.xsd','./msxsdtest/Group',valid),
  STResList81 = [STRes80|STResList80],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH001.xml','./msxsdtest/Group',valid,S80),
  ITResList34 = [ITRes33|ITResList33],


  ?line {STRes81,S81} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH002.xsd','./msxsdtest/Group',valid),
  STResList82 = [STRes81|STResList81],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH002.xml','./msxsdtest/Group',valid,S81),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes82,S82} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH003.xsd','./msxsdtest/Group',valid),
  STResList83 = [STRes82|STResList82],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH003.xml','./msxsdtest/Group',invalid,S82),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes83,S83} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH004.xsd','./msxsdtest/Group',valid),
  STResList84 = [STRes83|STResList83],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH004.xml','./msxsdtest/Group',valid,S83),
  ITResList37 = [ITRes36|ITResList36],


  ?line {STRes84,S84} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH005.xsd','./msxsdtest/Group',valid),
  STResList85 = [STRes84|STResList84],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH005.xml','./msxsdtest/Group',valid,S84),
  ITResList38 = [ITRes37|ITResList37],


  ?line {STRes85,S85} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH006.xsd','./msxsdtest/Group',valid),
  STResList86 = [STRes85|STResList85],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH006.xml','./msxsdtest/Group',invalid,S85),
  ITResList39 = [ITRes38|ITResList38],


  ?line {STRes86,S86} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH007.xsd','./msxsdtest/Group',valid),
  STResList87 = [STRes86|STResList86],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH007.xml','./msxsdtest/Group',valid,S86),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes87,S87} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH008.xsd','./msxsdtest/Group',valid),
  STResList88 = [STRes87|STResList87],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH008.xml','./msxsdtest/Group',invalid,S87),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes88,S88} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH009.xsd','./msxsdtest/Group',valid),
  STResList89 = [STRes88|STResList88],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH009.xml','./msxsdtest/Group',valid,S88),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes89,S89} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH010.xsd','./msxsdtest/Group',valid),
  STResList90 = [STRes89|STResList89],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH010.xml','./msxsdtest/Group',invalid,S89),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes90,S90} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH011.xsd','./msxsdtest/Group',valid),
  STResList91 = [STRes90|STResList90],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH011.xml','./msxsdtest/Group',valid,S90),
  ITResList44 = [ITRes43|ITResList43],


  ?line {STRes91,S91} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH012.xsd','./msxsdtest/Group',valid),
  STResList92 = [STRes91|STResList91],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH012.xml','./msxsdtest/Group',invalid,S91),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes92,S92} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH013.xsd','./msxsdtest/Group',valid),
  STResList93 = [STRes92|STResList92],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH013.xml','./msxsdtest/Group',invalid,S92),
  ITResList46 = [ITRes45|ITResList45],


  ?line {STRes93,S93} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH014.xsd','./msxsdtest/Group',valid),
  STResList94 = [STRes93|STResList93],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH014.xml','./msxsdtest/Group',valid,S93),
  ITResList47 = [ITRes46|ITResList46],


  ?line {STRes94,S94} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH015.xsd','./msxsdtest/Group',valid),
  STResList95 = [STRes94|STResList94],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH015.xml','./msxsdtest/Group',invalid,S94),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes95,S95} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH016.xsd','./msxsdtest/Group',valid),
  STResList96 = [STRes95|STResList95],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH016.xml','./msxsdtest/Group',invalid,S95),
  ITResList49 = [ITRes48|ITResList48],


  ?line {STRes96,S96} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH017.xsd','./msxsdtest/Group',valid),
  STResList97 = [STRes96|STResList96],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH017.xml','./msxsdtest/Group',valid,S96),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes97,S97} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH018.xsd','./msxsdtest/Group',valid),
  STResList98 = [STRes97|STResList97],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH018.xml','./msxsdtest/Group',valid,S97),
  ITResList51 = [ITRes50|ITResList50],


  ?line {STRes98,S98} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH019.xsd','./msxsdtest/Group',valid),
  STResList99 = [STRes98|STResList98],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH019.xml','./msxsdtest/Group',invalid,S98),
  ITResList52 = [ITRes51|ITResList51],


  ?line {STRes99,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH020.xsd','./msxsdtest/Group',invalid),
  STResList100 = [STRes99|STResList99],


  ?line {STRes100,S100} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH021.xsd','./msxsdtest/Group',valid),
  STResList101 = [STRes100|STResList100],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupH021.xml','./msxsdtest/Group',valid,S100),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes101,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH022.xsd','./msxsdtest/Group',invalid),
  STResList102 = [STRes101|STResList101],


  ?line {STRes102,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH023.xsd','./msxsdtest/Group',invalid),
  STResList103 = [STRes102|STResList102],


  ?line {STRes103,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH024.xsd','./msxsdtest/Group',invalid),
  STResList104 = [STRes103|STResList103],


  ?line {STRes104,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupH025.xsd','./msxsdtest/Group',invalid),
  STResList105 = [STRes104|STResList104],


  ?line {STRes105,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupI001.xsd','./msxsdtest/Group',valid),
  STResList106 = [STRes105|STResList105],


  ?line {STRes106,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupI002.xsd','./msxsdtest/Group',invalid),
  STResList107 = [STRes106|STResList106],


  ?line {STRes107,S107} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupI003.xsd','./msxsdtest/Group',valid),
  STResList108 = [STRes107|STResList107],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupI003.xml','./msxsdtest/Group',invalid,S107),
  ITResList54 = [ITRes53|ITResList53],


  ?line {STRes108,S108} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupI004.xsd','./msxsdtest/Group',valid),
  STResList109 = [STRes108|STResList108],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupI004.xml','./msxsdtest/Group',valid,S108),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes109,S109} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupI005.xsd','./msxsdtest/Group',valid),
  STResList110 = [STRes109|STResList109],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupI005.xml','./msxsdtest/Group',invalid,S109),
  ITResList56 = [ITRes55|ITResList55],


  ?line {STRes110,S110} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ001.xsd','./msxsdtest/Group',valid),
  STResList111 = [STRes110|STResList110],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ001.xml','./msxsdtest/Group',valid,S110),
  ITResList57 = [ITRes56|ITResList56],


  ?line {STRes111,S111} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ002.xsd','./msxsdtest/Group',valid),
  STResList112 = [STRes111|STResList111],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ002.xml','./msxsdtest/Group',valid,S111),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes112,S112} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ003.xsd','./msxsdtest/Group',valid),
  STResList113 = [STRes112|STResList112],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ003.xml','./msxsdtest/Group',invalid,S112),
  ITResList59 = [ITRes58|ITResList58],


  ?line {STRes113,S113} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ004.xsd','./msxsdtest/Group',valid),
  STResList114 = [STRes113|STResList113],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ004.xml','./msxsdtest/Group',valid,S113),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes114,S114} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ005.xsd','./msxsdtest/Group',valid),
  STResList115 = [STRes114|STResList114],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ005.xml','./msxsdtest/Group',valid,S114),
  ITResList61 = [ITRes60|ITResList60],


  ?line {STRes115,S115} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ006.xsd','./msxsdtest/Group',valid),
  STResList116 = [STRes115|STResList115],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ006.xml','./msxsdtest/Group',invalid,S115),
  ITResList62 = [ITRes61|ITResList61],


  ?line {STRes116,S116} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ007.xsd','./msxsdtest/Group',valid),
  STResList117 = [STRes116|STResList116],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ007.xml','./msxsdtest/Group',valid,S116),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes117,S117} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ008.xsd','./msxsdtest/Group',valid),
  STResList118 = [STRes117|STResList117],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ008.xml','./msxsdtest/Group',invalid,S117),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes118,S118} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ009.xsd','./msxsdtest/Group',valid),
  STResList119 = [STRes118|STResList118],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ009.xml','./msxsdtest/Group',valid,S118),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes119,S119} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ010.xsd','./msxsdtest/Group',valid),
  STResList120 = [STRes119|STResList119],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ010.xml','./msxsdtest/Group',invalid,S119),
  ITResList66 = [ITRes65|ITResList65],


  ?line {STRes120,S120} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ011.xsd','./msxsdtest/Group',valid),
  STResList121 = [STRes120|STResList120],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ011.xml','./msxsdtest/Group',valid,S120),
  ITResList67 = [ITRes66|ITResList66],


  ?line {STRes121,S121} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ012.xsd','./msxsdtest/Group',valid),
  STResList122 = [STRes121|STResList121],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ012.xml','./msxsdtest/Group',invalid,S121),
  ITResList68 = [ITRes67|ITResList67],


  ?line {STRes122,S122} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ013.xsd','./msxsdtest/Group',valid),
  STResList123 = [STRes122|STResList122],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ013.xml','./msxsdtest/Group',invalid,S122),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes123,S123} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ014.xsd','./msxsdtest/Group',valid),
  STResList124 = [STRes123|STResList123],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ014.xml','./msxsdtest/Group',valid,S123),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes124,S124} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ015.xsd','./msxsdtest/Group',valid),
  STResList125 = [STRes124|STResList124],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ015.xml','./msxsdtest/Group',invalid,S124),
  ITResList71 = [ITRes70|ITResList70],


  ?line {STRes125,S125} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ016.xsd','./msxsdtest/Group',valid),
  STResList126 = [STRes125|STResList125],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ016.xml','./msxsdtest/Group',invalid,S125),
  ITResList72 = [ITRes71|ITResList71],


  ?line {STRes126,S126} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ017.xsd','./msxsdtest/Group',valid),
  STResList127 = [STRes126|STResList126],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ017.xml','./msxsdtest/Group',valid,S126),
  ITResList73 = [ITRes72|ITResList72],


  ?line {STRes127,S127} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ018.xsd','./msxsdtest/Group',valid),
  STResList128 = [STRes127|STResList127],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ018.xml','./msxsdtest/Group',valid,S127),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes128,S128} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ019.xsd','./msxsdtest/Group',valid),
  STResList129 = [STRes128|STResList128],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ019.xml','./msxsdtest/Group',invalid,S128),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes129,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ020.xsd','./msxsdtest/Group',invalid),
  STResList130 = [STRes129|STResList129],


  ?line {STRes130,S130} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ021.xsd','./msxsdtest/Group',valid),
  STResList131 = [STRes130|STResList130],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupJ021.xml','./msxsdtest/Group',valid,S130),
  ITResList76 = [ITRes75|ITResList75],


  ?line {STRes131,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ022.xsd','./msxsdtest/Group',invalid),
  STResList132 = [STRes131|STResList131],


  ?line {STRes132,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ023.xsd','./msxsdtest/Group',invalid),
  STResList133 = [STRes132|STResList132],


  ?line {STRes133,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ024.xsd','./msxsdtest/Group',invalid),
  STResList134 = [STRes133|STResList133],


  ?line {STRes134,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupJ025.xsd','./msxsdtest/Group',invalid),
  STResList135 = [STRes134|STResList134],


  ?line {STRes135,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupK001.xsd','./msxsdtest/Group',valid),
  STResList136 = [STRes135|STResList135],


  ?line {STRes136,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupK002.xsd','./msxsdtest/Group',invalid),
  STResList137 = [STRes136|STResList136],


  ?line {STRes137,S137} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupK003.xsd','./msxsdtest/Group',valid),
  STResList138 = [STRes137|STResList137],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupK003.xml','./msxsdtest/Group',invalid,S137),
  ITResList77 = [ITRes76|ITResList76],


  ?line {STRes138,S138} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupK004.xsd','./msxsdtest/Group',valid),
  STResList139 = [STRes138|STResList138],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupK004.xml','./msxsdtest/Group',valid,S138),
  ITResList78 = [ITRes77|ITResList77],


  ?line {STRes139,S139} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupK005.xsd','./msxsdtest/Group',valid),
  STResList140 = [STRes139|STResList139],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupK005.xml','./msxsdtest/Group',invalid,S139),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes140,S140} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL001.xsd','./msxsdtest/Group',valid),
  STResList141 = [STRes140|STResList140],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL001.xml','./msxsdtest/Group',valid,S140),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes141,S141} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL002.xsd','./msxsdtest/Group',valid),
  STResList142 = [STRes141|STResList141],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL002.xml','./msxsdtest/Group',valid,S141),
  ITResList81 = [ITRes80|ITResList80],


  ?line {STRes142,S142} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL003.xsd','./msxsdtest/Group',valid),
  STResList143 = [STRes142|STResList142],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL003.xml','./msxsdtest/Group',invalid,S142),
  ITResList82 = [ITRes81|ITResList81],


  ?line {STRes143,S143} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL004.xsd','./msxsdtest/Group',valid),
  STResList144 = [STRes143|STResList143],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL004.xml','./msxsdtest/Group',valid,S143),
  ITResList83 = [ITRes82|ITResList82],


  ?line {STRes144,S144} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL005.xsd','./msxsdtest/Group',valid),
  STResList145 = [STRes144|STResList144],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL005.xml','./msxsdtest/Group',valid,S144),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes145,S145} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL006.xsd','./msxsdtest/Group',valid),
  STResList146 = [STRes145|STResList145],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL006.xml','./msxsdtest/Group',invalid,S145),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes146,S146} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL007.xsd','./msxsdtest/Group',valid),
  STResList147 = [STRes146|STResList146],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL007.xml','./msxsdtest/Group',valid,S146),
  ITResList86 = [ITRes85|ITResList85],


  ?line {STRes147,S147} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL008.xsd','./msxsdtest/Group',valid),
  STResList148 = [STRes147|STResList147],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL008.xml','./msxsdtest/Group',invalid,S147),
  ITResList87 = [ITRes86|ITResList86],


  ?line {STRes148,S148} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL009.xsd','./msxsdtest/Group',valid),
  STResList149 = [STRes148|STResList148],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL009.xml','./msxsdtest/Group',valid,S148),
  ITResList88 = [ITRes87|ITResList87],


  ?line {STRes149,S149} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL010.xsd','./msxsdtest/Group',valid),
  STResList150 = [STRes149|STResList149],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL010.xml','./msxsdtest/Group',invalid,S149),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes150,S150} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL011.xsd','./msxsdtest/Group',valid),
  STResList151 = [STRes150|STResList150],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL011.xml','./msxsdtest/Group',valid,S150),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes151,S151} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL012.xsd','./msxsdtest/Group',valid),
  STResList152 = [STRes151|STResList151],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL012.xml','./msxsdtest/Group',invalid,S151),
  ITResList91 = [ITRes90|ITResList90],


  ?line {STRes152,S152} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL013.xsd','./msxsdtest/Group',valid),
  STResList153 = [STRes152|STResList152],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL013.xml','./msxsdtest/Group',invalid,S152),
  ITResList92 = [ITRes91|ITResList91],


  ?line {STRes153,S153} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL014.xsd','./msxsdtest/Group',valid),
  STResList154 = [STRes153|STResList153],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL014.xml','./msxsdtest/Group',valid,S153),
  ITResList93 = [ITRes92|ITResList92],


  ?line {STRes154,S154} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL015.xsd','./msxsdtest/Group',valid),
  STResList155 = [STRes154|STResList154],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL015.xml','./msxsdtest/Group',invalid,S154),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes155,S155} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL016.xsd','./msxsdtest/Group',valid),
  STResList156 = [STRes155|STResList155],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL016.xml','./msxsdtest/Group',invalid,S155),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes156,S156} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL017.xsd','./msxsdtest/Group',valid),
  STResList157 = [STRes156|STResList156],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL017.xml','./msxsdtest/Group',valid,S156),
  ITResList96 = [ITRes95|ITResList95],


  ?line {STRes157,S157} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL018.xsd','./msxsdtest/Group',valid),
  STResList158 = [STRes157|STResList157],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL018.xml','./msxsdtest/Group',valid,S157),
  ITResList97 = [ITRes96|ITResList96],


  ?line {STRes158,S158} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL019.xsd','./msxsdtest/Group',valid),
  STResList159 = [STRes158|STResList158],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL019.xml','./msxsdtest/Group',invalid,S158),
  ITResList98 = [ITRes97|ITResList97],


  ?line {STRes159,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL020.xsd','./msxsdtest/Group',invalid),
  STResList160 = [STRes159|STResList159],


  ?line {STRes160,S160} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL021.xsd','./msxsdtest/Group',valid),
  STResList161 = [STRes160|STResList160],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupL021.xml','./msxsdtest/Group',valid,S160),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes161,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL022.xsd','./msxsdtest/Group',invalid),
  STResList162 = [STRes161|STResList161],


  ?line {STRes162,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL023.xsd','./msxsdtest/Group',invalid),
  STResList163 = [STRes162|STResList162],


  ?line {STRes163,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL024.xsd','./msxsdtest/Group',invalid),
  STResList164 = [STRes163|STResList163],


  ?line {STRes164,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupL025.xsd','./msxsdtest/Group',invalid),
  STResList165 = [STRes164|STResList164],


  ?line {STRes165,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupM001.xsd','./msxsdtest/Group',valid),
  STResList166 = [STRes165|STResList165],


  ?line {STRes166,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupM002.xsd','./msxsdtest/Group',invalid),
  STResList167 = [STRes166|STResList166],


  ?line {STRes167,S167} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupM003.xsd','./msxsdtest/Group',valid),
  STResList168 = [STRes167|STResList167],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupM003.xml','./msxsdtest/Group',invalid,S167),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes168,S168} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupM004.xsd','./msxsdtest/Group',valid),
  STResList169 = [STRes168|STResList168],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupM004.xml','./msxsdtest/Group',valid,S168),
  ITResList101 = [ITRes100|ITResList100],


  ?line {STRes169,S169} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupM005.xsd','./msxsdtest/Group',valid),
  STResList170 = [STRes169|STResList169],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupM005.xml','./msxsdtest/Group',invalid,S169),
  ITResList102 = [ITRes101|ITResList101],


  ?line {STRes170,S170} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN001.xsd','./msxsdtest/Group',valid),
  STResList171 = [STRes170|STResList170],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN001.xml','./msxsdtest/Group',valid,S170),
  ITResList103 = [ITRes102|ITResList102],


  ?line {STRes171,S171} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN002.xsd','./msxsdtest/Group',valid),
  STResList172 = [STRes171|STResList171],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN002.xml','./msxsdtest/Group',valid,S171),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes172,S172} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN003.xsd','./msxsdtest/Group',valid),
  STResList173 = [STRes172|STResList172],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN003.xml','./msxsdtest/Group',invalid,S172),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes173,S173} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN004.xsd','./msxsdtest/Group',valid),
  STResList174 = [STRes173|STResList173],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN004.xml','./msxsdtest/Group',valid,S173),
  ITResList106 = [ITRes105|ITResList105],


  ?line {STRes174,S174} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN005.xsd','./msxsdtest/Group',valid),
  STResList175 = [STRes174|STResList174],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN005.xml','./msxsdtest/Group',valid,S174),
  ITResList107 = [ITRes106|ITResList106],


  ?line {STRes175,S175} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN006.xsd','./msxsdtest/Group',valid),
  STResList176 = [STRes175|STResList175],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN006.xml','./msxsdtest/Group',invalid,S175),
  ITResList108 = [ITRes107|ITResList107],


  ?line {STRes176,S176} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN007.xsd','./msxsdtest/Group',valid),
  STResList177 = [STRes176|STResList176],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN007.xml','./msxsdtest/Group',valid,S176),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes177,S177} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN008.xsd','./msxsdtest/Group',valid),
  STResList178 = [STRes177|STResList177],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN008.xml','./msxsdtest/Group',invalid,S177),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes178,S178} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN009.xsd','./msxsdtest/Group',valid),
  STResList179 = [STRes178|STResList178],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN009.xml','./msxsdtest/Group',valid,S178),
  ITResList111 = [ITRes110|ITResList110],


  ?line {STRes179,S179} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN010.xsd','./msxsdtest/Group',valid),
  STResList180 = [STRes179|STResList179],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN010.xml','./msxsdtest/Group',invalid,S179),
  ITResList112 = [ITRes111|ITResList111],


  ?line {STRes180,S180} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN011.xsd','./msxsdtest/Group',valid),
  STResList181 = [STRes180|STResList180],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN011.xml','./msxsdtest/Group',valid,S180),
  ITResList113 = [ITRes112|ITResList112],


  ?line {STRes181,S181} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN012.xsd','./msxsdtest/Group',valid),
  STResList182 = [STRes181|STResList181],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN012.xml','./msxsdtest/Group',invalid,S181),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes182,S182} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN013.xsd','./msxsdtest/Group',valid),
  STResList183 = [STRes182|STResList182],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN013.xml','./msxsdtest/Group',invalid,S182),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes183,S183} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN014.xsd','./msxsdtest/Group',valid),
  STResList184 = [STRes183|STResList183],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN014.xml','./msxsdtest/Group',valid,S183),
  ITResList116 = [ITRes115|ITResList115],


  ?line {STRes184,S184} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN015.xsd','./msxsdtest/Group',valid),
  STResList185 = [STRes184|STResList184],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN015.xml','./msxsdtest/Group',invalid,S184),
  ITResList117 = [ITRes116|ITResList116],


  ?line {STRes185,S185} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN016.xsd','./msxsdtest/Group',valid),
  STResList186 = [STRes185|STResList185],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN016.xml','./msxsdtest/Group',invalid,S185),
  ITResList118 = [ITRes117|ITResList117],


  ?line {STRes186,S186} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN017.xsd','./msxsdtest/Group',valid),
  STResList187 = [STRes186|STResList186],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN017.xml','./msxsdtest/Group',valid,S186),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes187,S187} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN018.xsd','./msxsdtest/Group',valid),
  STResList188 = [STRes187|STResList187],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN018.xml','./msxsdtest/Group',valid,S187),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes188,S188} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN019.xsd','./msxsdtest/Group',valid),
  STResList189 = [STRes188|STResList188],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN019.xml','./msxsdtest/Group',invalid,S188),
  ITResList121 = [ITRes120|ITResList120],


  ?line {STRes189,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN020.xsd','./msxsdtest/Group',invalid),
  STResList190 = [STRes189|STResList189],


  ?line {STRes190,S190} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN021.xsd','./msxsdtest/Group',valid),
  STResList191 = [STRes190|STResList190],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupN021.xml','./msxsdtest/Group',valid,S190),
  ITResList122 = [ITRes121|ITResList121],


  ?line {STRes191,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN022.xsd','./msxsdtest/Group',invalid),
  STResList192 = [STRes191|STResList191],


  ?line {STRes192,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN023.xsd','./msxsdtest/Group',invalid),
  STResList193 = [STRes192|STResList192],


  ?line {STRes193,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN024.xsd','./msxsdtest/Group',invalid),
  STResList194 = [STRes193|STResList193],


  ?line {STRes194,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupN025.xsd','./msxsdtest/Group',invalid),
  STResList195 = [STRes194|STResList194],


  ?line {STRes195,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO001.xsd','./msxsdtest/Group',valid),
  STResList196 = [STRes195|STResList195],


  ?line {STRes196,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO002.xsd','./msxsdtest/Group',invalid),
  STResList197 = [STRes196|STResList196],


  ?line {STRes197,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO003.xsd','./msxsdtest/Group',invalid),
  STResList198 = [STRes197|STResList197],


  ?line {STRes198,S198} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO004.xsd','./msxsdtest/Group',valid),
  STResList199 = [STRes198|STResList198],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupO004.xml','./msxsdtest/Group',valid,S198),
  ITResList123 = [ITRes122|ITResList122],


  ?line {STRes199,S199} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO005.xsd','./msxsdtest/Group',valid),
  STResList200 = [STRes199|STResList199],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupO005.xml','./msxsdtest/Group',invalid,S199),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes200,S200} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO006.xsd','./msxsdtest/Group',valid),
  STResList201 = [STRes200|STResList200],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupO006.xml','./msxsdtest/Group',valid,S200),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes201,S201} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO007.xsd','./msxsdtest/Group',valid),
  STResList202 = [STRes201|STResList201],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupO007.xml','./msxsdtest/Group',invalid,S201),
  ITResList126 = [ITRes125|ITResList125],


  ?line {STRes202,S202} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO008.xsd','./msxsdtest/Group',valid),
  STResList203 = [STRes202|STResList202],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupO008.xml','./msxsdtest/Group',valid,S202),
  ITResList127 = [ITRes126|ITResList126],


  ?line {STRes203,S203} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO009.xsd','./msxsdtest/Group',valid),
  STResList204 = [STRes203|STResList203],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/Group/groupO009.xml','./msxsdtest/Group',invalid,S203),
  ITResList128 = [ITRes127|ITResList127],


  ?line {STRes204,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO010.xsd','./msxsdtest/Group',invalid),
  STResList205 = [STRes204|STResList204],


  ?line {STRes205,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO011.xsd','./msxsdtest/Group',invalid),
  STResList206 = [STRes205|STResList205],


  ?line {STRes206,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO012.xsd','./msxsdtest/Group',invalid),
  STResList207 = [STRes206|STResList206],


  ?line {STRes207,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO013.xsd','./msxsdtest/Group',invalid),
  STResList208 = [STRes207|STResList207],


  ?line {STRes208,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO014.xsd','./msxsdtest/Group',valid),
  STResList209 = [STRes208|STResList208],


  ?line {STRes209,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO015.xsd','./msxsdtest/Group',invalid),
  STResList210 = [STRes209|STResList209],


  ?line {STRes210,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO016.xsd','./msxsdtest/Group',invalid),
  STResList211 = [STRes210|STResList210],


  ?line {STRes211,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO017.xsd','./msxsdtest/Group',invalid),
  STResList212 = [STRes211|STResList211],


  ?line {STRes212,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO018.xsd','./msxsdtest/Group',invalid),
  STResList213 = [STRes212|STResList212],


  ?line {STRes213,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO019.xsd','./msxsdtest/Group',invalid),
  STResList214 = [STRes213|STResList213],


  ?line {STRes214,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO020.xsd','./msxsdtest/Group',invalid),
  STResList215 = [STRes214|STResList214],


  ?line {STRes215,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO021.xsd','./msxsdtest/Group',invalid),
  STResList216 = [STRes215|STResList215],


  ?line {STRes216,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO022.xsd','./msxsdtest/Group',invalid),
  STResList217 = [STRes216|STResList216],


  ?line {STRes217,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO023.xsd','./msxsdtest/Group',invalid),
  STResList218 = [STRes217|STResList217],


  ?line {STRes218,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO024.xsd','./msxsdtest/Group',invalid),
  STResList219 = [STRes218|STResList218],


  ?line {STRes219,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO025.xsd','./msxsdtest/Group',invalid),
  STResList220 = [STRes219|STResList219],


  ?line {STRes220,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO026.xsd','./msxsdtest/Group',invalid),
  STResList221 = [STRes220|STResList220],


  ?line {STRes221,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/Group/groupO027.xsd','./msxsdtest/Group',invalid),
  STResList222 = [STRes221|STResList221],


  xmerl_xsd_lib:compare_test_results(Config,STResList222,ITResList128).

%% 3.11.1 The Identity-constraint Definition Schema Component.

idc_(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_string.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S0),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S1),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_token.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S2),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_language.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S3),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S4),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S5),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S6),
  ITResList7 = [ITRes6|ITResList6],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S7),
  ITResList8 = [ITRes7|ITResList7],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S8),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S9),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S10),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S11),
  ITResList12 = [ITRes11|ITResList11],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S12),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S13),
  ITResList14 = [ITRes13|ITResList13],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S14),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S15),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S16),
  ITResList17 = [ITRes16|ITResList16],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S17),
  ITResList18 = [ITRes17|ITResList17],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S18),
  ITResList19 = [ITRes18|ITResList18],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S19),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S20),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S21),
  ITResList22 = [ITRes21|ITResList21],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S22),
  ITResList23 = [ITRes22|ITResList22],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S23),
  ITResList24 = [ITRes23|ITResList23],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S24),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S25),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S26),
  ITResList27 = [ITRes26|ITResList26],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S27),
  ITResList28 = [ITRes27|ITResList27],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S28),
  ITResList29 = [ITRes28|ITResList28],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S29),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S30),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S31),
  ITResList32 = [ITRes31|ITResList31],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_dateTime.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_dateTime.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S32),
  ITResList33 = [ITRes32|ITResList32],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_time.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_time.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S33),
  ITResList34 = [ITRes33|ITResList33],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_date.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_date.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S34),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gYearMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gYearMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S35),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gYear.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gYear.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S36),
  ITResList37 = [ITRes36|ITResList36],


  ?line {STRes37,S37} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gMonthDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList38 = [STRes37|STResList37],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gMonthDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S37),
  ITResList38 = [ITRes37|ITResList37],


  ?line {STRes38,S38} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList39 = [STRes38|STResList38],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S38),
  ITResList39 = [ITRes38|ITResList38],


  ?line {STRes39,S39} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList40 = [STRes39|STResList39],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_string_gMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S39),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes40,S40} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList41 = [STRes40|STResList40],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_string.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S40),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes41,S41} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList42 = [STRes41|STResList41],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S41),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes42,S42} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList43 = [STRes42|STResList42],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_token.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S42),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes43,S43} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList44 = [STRes43|STResList43],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_language.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S43),
  ITResList44 = [ITRes43|ITResList43],


  ?line {STRes44,S44} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList45 = [STRes44|STResList44],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S44),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes45,S45} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList46 = [STRes45|STResList45],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S45),
  ITResList46 = [ITRes45|ITResList45],


  ?line {STRes46,S46} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList47 = [STRes46|STResList46],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S46),
  ITResList47 = [ITRes46|ITResList46],


  ?line {STRes47,S47} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList48 = [STRes47|STResList47],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S47),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes48,S48} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList49 = [STRes48|STResList48],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S48),
  ITResList49 = [ITRes48|ITResList48],


  ?line {STRes49,S49} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList50 = [STRes49|STResList49],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S49),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes50,S50} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList51 = [STRes50|STResList50],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S50),
  ITResList51 = [ITRes50|ITResList50],


  ?line {STRes51,S51} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList52 = [STRes51|STResList51],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S51),
  ITResList52 = [ITRes51|ITResList51],


  ?line {STRes52,S52} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList53 = [STRes52|STResList52],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S52),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes53,S53} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList54 = [STRes53|STResList53],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S53),
  ITResList54 = [ITRes53|ITResList53],


  ?line {STRes54,S54} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList55 = [STRes54|STResList54],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S54),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes55,S55} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList56 = [STRes55|STResList55],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S55),
  ITResList56 = [ITRes55|ITResList55],


  ?line {STRes56,S56} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList57 = [STRes56|STResList56],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S56),
  ITResList57 = [ITRes56|ITResList56],


  ?line {STRes57,S57} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList58 = [STRes57|STResList57],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S57),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes58,S58} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList59 = [STRes58|STResList58],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S58),
  ITResList59 = [ITRes58|ITResList58],


  ?line {STRes59,S59} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList60 = [STRes59|STResList59],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S59),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes60,S60} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList61 = [STRes60|STResList60],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S60),
  ITResList61 = [ITRes60|ITResList60],


  ?line {STRes61,S61} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList62 = [STRes61|STResList61],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S61),
  ITResList62 = [ITRes61|ITResList61],


  ?line {STRes62,S62} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList63 = [STRes62|STResList62],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S62),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes63,S63} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList64 = [STRes63|STResList63],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S63),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes64,S64} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList65 = [STRes64|STResList64],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S64),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes65,S65} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList66 = [STRes65|STResList65],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S65),
  ITResList66 = [ITRes65|ITResList65],


  ?line {STRes66,S66} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList67 = [STRes66|STResList66],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S66),
  ITResList67 = [ITRes66|ITResList66],


  ?line {STRes67,S67} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList68 = [STRes67|STResList67],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S67),
  ITResList68 = [ITRes67|ITResList67],


  ?line {STRes68,S68} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList69 = [STRes68|STResList68],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S68),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes69,S69} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList70 = [STRes69|STResList69],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S69),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes70,S70} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList71 = [STRes70|STResList70],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S70),
  ITResList71 = [ITRes70|ITResList70],


  ?line {STRes71,S71} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList72 = [STRes71|STResList71],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S71),
  ITResList72 = [ITRes71|ITResList71],


  ?line {STRes72,S72} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_dateTime.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList73 = [STRes72|STResList72],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_dateTime.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S72),
  ITResList73 = [ITRes72|ITResList72],


  ?line {STRes73,S73} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_time.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList74 = [STRes73|STResList73],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_time.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S73),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes74,S74} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_date.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList75 = [STRes74|STResList74],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_date.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S74),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes75,S75} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gYearMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList76 = [STRes75|STResList75],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gYearMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S75),
  ITResList76 = [ITRes75|ITResList75],


  ?line {STRes76,S76} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gYear.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList77 = [STRes76|STResList76],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gYear.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S76),
  ITResList77 = [ITRes76|ITResList76],


  ?line {STRes77,S77} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gMonthDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList78 = [STRes77|STResList77],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gMonthDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S77),
  ITResList78 = [ITRes77|ITResList77],


  ?line {STRes78,S78} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList79 = [STRes78|STResList78],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S78),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes79,S79} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList80 = [STRes79|STResList79],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_normalizedString_gMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S79),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes80,S80} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList81 = [STRes80|STResList80],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_string.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S80),
  ITResList81 = [ITRes80|ITResList80],


  ?line {STRes81,S81} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList82 = [STRes81|STResList81],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S81),
  ITResList82 = [ITRes81|ITResList81],


  ?line {STRes82,S82} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList83 = [STRes82|STResList82],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_token.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S82),
  ITResList83 = [ITRes82|ITResList82],


  ?line {STRes83,S83} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList84 = [STRes83|STResList83],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_language.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S83),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes84,S84} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList85 = [STRes84|STResList84],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S84),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes85,S85} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList86 = [STRes85|STResList85],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S85),
  ITResList86 = [ITRes85|ITResList85],


  ?line {STRes86,S86} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList87 = [STRes86|STResList86],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S86),
  ITResList87 = [ITRes86|ITResList86],


  ?line {STRes87,S87} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList88 = [STRes87|STResList87],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S87),
  ITResList88 = [ITRes87|ITResList87],


  ?line {STRes88,S88} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList89 = [STRes88|STResList88],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S88),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes89,S89} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList90 = [STRes89|STResList89],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S89),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes90,S90} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList91 = [STRes90|STResList90],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S90),
  ITResList91 = [ITRes90|ITResList90],


  ?line {STRes91,S91} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList92 = [STRes91|STResList91],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S91),
  ITResList92 = [ITRes91|ITResList91],


  ?line {STRes92,S92} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList93 = [STRes92|STResList92],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S92),
  ITResList93 = [ITRes92|ITResList92],


  ?line {STRes93,S93} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList94 = [STRes93|STResList93],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S93),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes94,S94} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList95 = [STRes94|STResList94],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S94),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes95,S95} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList96 = [STRes95|STResList95],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S95),
  ITResList96 = [ITRes95|ITResList95],


  ?line {STRes96,S96} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList97 = [STRes96|STResList96],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S96),
  ITResList97 = [ITRes96|ITResList96],


  ?line {STRes97,S97} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList98 = [STRes97|STResList97],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S97),
  ITResList98 = [ITRes97|ITResList97],


  ?line {STRes98,S98} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList99 = [STRes98|STResList98],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S98),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes99,S99} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList100 = [STRes99|STResList99],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S99),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes100,S100} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList101 = [STRes100|STResList100],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S100),
  ITResList101 = [ITRes100|ITResList100],


  ?line {STRes101,S101} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList102 = [STRes101|STResList101],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S101),
  ITResList102 = [ITRes101|ITResList101],


  ?line {STRes102,S102} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList103 = [STRes102|STResList102],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S102),
  ITResList103 = [ITRes102|ITResList102],


  ?line {STRes103,S103} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList104 = [STRes103|STResList103],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S103),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes104,S104} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList105 = [STRes104|STResList104],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S104),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes105,S105} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList106 = [STRes105|STResList105],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S105),
  ITResList106 = [ITRes105|ITResList105],


  ?line {STRes106,S106} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList107 = [STRes106|STResList106],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S106),
  ITResList107 = [ITRes106|ITResList106],


  ?line {STRes107,S107} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList108 = [STRes107|STResList107],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S107),
  ITResList108 = [ITRes107|ITResList107],


  ?line {STRes108,S108} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList109 = [STRes108|STResList108],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S108),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes109,S109} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList110 = [STRes109|STResList109],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S109),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes110,S110} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList111 = [STRes110|STResList110],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S110),
  ITResList111 = [ITRes110|ITResList110],


  ?line {STRes111,S111} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList112 = [STRes111|STResList111],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S111),
  ITResList112 = [ITRes111|ITResList111],


  ?line {STRes112,S112} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_dateTime.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList113 = [STRes112|STResList112],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_dateTime.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S112),
  ITResList113 = [ITRes112|ITResList112],


  ?line {STRes113,S113} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_time.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList114 = [STRes113|STResList113],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_time.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S113),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes114,S114} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_date.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList115 = [STRes114|STResList114],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_date.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S114),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes115,S115} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gYearMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList116 = [STRes115|STResList115],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gYearMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S115),
  ITResList116 = [ITRes115|ITResList115],


  ?line {STRes116,S116} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gYear.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList117 = [STRes116|STResList116],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gYear.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S116),
  ITResList117 = [ITRes116|ITResList116],


  ?line {STRes117,S117} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gMonthDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList118 = [STRes117|STResList117],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gMonthDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S117),
  ITResList118 = [ITRes117|ITResList117],


  ?line {STRes118,S118} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList119 = [STRes118|STResList118],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S118),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes119,S119} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList120 = [STRes119|STResList119],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_token_gMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S119),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes120,S120} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList121 = [STRes120|STResList120],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_string.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S120),
  ITResList121 = [ITRes120|ITResList120],


  ?line {STRes121,S121} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList122 = [STRes121|STResList121],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S121),
  ITResList122 = [ITRes121|ITResList121],


  ?line {STRes122,S122} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList123 = [STRes122|STResList122],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_token.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S122),
  ITResList123 = [ITRes122|ITResList122],


  ?line {STRes123,S123} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList124 = [STRes123|STResList123],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_language.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S123),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes124,S124} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList125 = [STRes124|STResList124],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S124),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes125,S125} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList126 = [STRes125|STResList125],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S125),
  ITResList126 = [ITRes125|ITResList125],


  ?line {STRes126,S126} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList127 = [STRes126|STResList126],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S126),
  ITResList127 = [ITRes126|ITResList126],


  ?line {STRes127,S127} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList128 = [STRes127|STResList127],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S127),
  ITResList128 = [ITRes127|ITResList127],


  ?line {STRes128,S128} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_IDREFS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList129 = [STRes128|STResList128],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_IDREFS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S128),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes129,S129} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList130 = [STRes129|STResList129],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S129),
  ITResList130 = [ITRes129|ITResList129],


  ?line {STRes130,S130} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList131 = [STRes130|STResList130],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S130),
  ITResList131 = [ITRes130|ITResList130],


  ?line {STRes131,S131} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList132 = [STRes131|STResList131],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S131),
  ITResList132 = [ITRes131|ITResList131],


  ?line {STRes132,S132} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList133 = [STRes132|STResList132],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S132),
  ITResList133 = [ITRes132|ITResList132],


  ?line {STRes133,S133} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList134 = [STRes133|STResList133],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_language_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S133),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes134,S134} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList135 = [STRes134|STResList134],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_string.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S134),
  ITResList135 = [ITRes134|ITResList134],


  ?line {STRes135,S135} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList136 = [STRes135|STResList135],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S135),
  ITResList136 = [ITRes135|ITResList135],


  ?line {STRes136,S136} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList137 = [STRes136|STResList136],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_token.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S136),
  ITResList137 = [ITRes136|ITResList136],


  ?line {STRes137,S137} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList138 = [STRes137|STResList137],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S137),
  ITResList138 = [ITRes137|ITResList137],


  ?line {STRes138,S138} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList139 = [STRes138|STResList138],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S138),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes139,S139} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList140 = [STRes139|STResList139],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S139),
  ITResList140 = [ITRes139|ITResList139],


  ?line {STRes140,S140} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList141 = [STRes140|STResList140],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S140),
  ITResList141 = [ITRes140|ITResList140],


  ?line {STRes141,S141} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList142 = [STRes141|STResList141],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S141),
  ITResList142 = [ITRes141|ITResList141],


  ?line {STRes142,S142} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList143 = [STRes142|STResList142],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S142),
  ITResList143 = [ITRes142|ITResList142],


  ?line {STRes143,S143} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList144 = [STRes143|STResList143],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S143),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes144,S144} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList145 = [STRes144|STResList144],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S144),
  ITResList145 = [ITRes144|ITResList144],


  ?line {STRes145,S145} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList146 = [STRes145|STResList145],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S145),
  ITResList146 = [ITRes145|ITResList145],


  ?line {STRes146,S146} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList147 = [STRes146|STResList146],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S146),
  ITResList147 = [ITRes146|ITResList146],


  ?line {STRes147,S147} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList148 = [STRes147|STResList147],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S147),
  ITResList148 = [ITRes147|ITResList147],


  ?line {STRes148,S148} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList149 = [STRes148|STResList148],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_Name_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S148),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes149,S149} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList150 = [STRes149|STResList149],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_string.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S149),
  ITResList150 = [ITRes149|ITResList149],


  ?line {STRes150,S150} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList151 = [STRes150|STResList150],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S150),
  ITResList151 = [ITRes150|ITResList150],


  ?line {STRes151,S151} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList152 = [STRes151|STResList151],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_token.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S151),
  ITResList152 = [ITRes151|ITResList151],


  ?line {STRes152,S152} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList153 = [STRes152|STResList152],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S152),
  ITResList153 = [ITRes152|ITResList152],


  ?line {STRes153,S153} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList154 = [STRes153|STResList153],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S153),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes154,S154} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList155 = [STRes154|STResList154],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S154),
  ITResList155 = [ITRes154|ITResList154],


  ?line {STRes155,S155} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList156 = [STRes155|STResList155],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S155),
  ITResList156 = [ITRes155|ITResList155],


  ?line {STRes156,S156} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList157 = [STRes156|STResList156],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S156),
  ITResList157 = [ITRes156|ITResList156],


  ?line {STRes157,S157} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList158 = [STRes157|STResList157],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S157),
  ITResList158 = [ITRes157|ITResList157],


  ?line {STRes158,S158} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList159 = [STRes158|STResList158],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S158),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes159,S159} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList160 = [STRes159|STResList159],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S159),
  ITResList160 = [ITRes159|ITResList159],


  ?line {STRes160,S160} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList161 = [STRes160|STResList160],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S160),
  ITResList161 = [ITRes160|ITResList160],


  ?line {STRes161,S161} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList162 = [STRes161|STResList161],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S161),
  ITResList162 = [ITRes161|ITResList161],


  ?line {STRes162,S162} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList163 = [STRes162|STResList162],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S162),
  ITResList163 = [ITRes162|ITResList162],


  ?line {STRes163,S163} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList164 = [STRes163|STResList163],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NCName_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S163),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes164,S164} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList165 = [STRes164|STResList164],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_string.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S164),
  ITResList165 = [ITRes164|ITResList164],


  ?line {STRes165,S165} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList166 = [STRes165|STResList165],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S165),
  ITResList166 = [ITRes165|ITResList165],


  ?line {STRes166,S166} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList167 = [STRes166|STResList166],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_token.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S166),
  ITResList167 = [ITRes166|ITResList166],


  ?line {STRes167,S167} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList168 = [STRes167|STResList167],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S167),
  ITResList168 = [ITRes167|ITResList167],


  ?line {STRes168,S168} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList169 = [STRes168|STResList168],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S168),
  ITResList169 = [ITRes168|ITResList168],


  ?line {STRes169,S169} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList170 = [STRes169|STResList169],
  ?line ITRes169 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S169),
  ITResList170 = [ITRes169|ITResList169],


  ?line {STRes170,S170} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList171 = [STRes170|STResList170],
  ?line ITRes170 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S170),
  ITResList171 = [ITRes170|ITResList170],


  ?line {STRes171,S171} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList172 = [STRes171|STResList171],
  ?line ITRes171 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S171),
  ITResList172 = [ITRes171|ITResList171],


  ?line {STRes172,S172} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_IDREFS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList173 = [STRes172|STResList172],
  ?line ITRes172 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_IDREFS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S172),
  ITResList173 = [ITRes172|ITResList172],


  ?line {STRes173,S173} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList174 = [STRes173|STResList173],
  ?line ITRes173 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S173),
  ITResList174 = [ITRes173|ITResList173],


  ?line {STRes174,S174} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList175 = [STRes174|STResList174],
  ?line ITRes174 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S174),
  ITResList175 = [ITRes174|ITResList174],


  ?line {STRes175,S175} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList176 = [STRes175|STResList175],
  ?line ITRes175 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S175),
  ITResList176 = [ITRes175|ITResList175],


  ?line {STRes176,S176} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList177 = [STRes176|STResList176],
  ?line ITRes176 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S176),
  ITResList177 = [ITRes176|ITResList176],


  ?line {STRes177,S177} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList178 = [STRes177|STResList177],
  ?line ITRes177 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S177),
  ITResList178 = [ITRes177|ITResList177],


  ?line {STRes178,S178} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList179 = [STRes178|STResList178],
  ?line ITRes178 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S178),
  ITResList179 = [ITRes178|ITResList178],


  ?line {STRes179,S179} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList180 = [STRes179|STResList179],
  ?line ITRes179 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_ID_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S179),
  ITResList180 = [ITRes179|ITResList179],


  ?line {STRes180,S180} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList181 = [STRes180|STResList180],
  ?line ITRes180 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_string.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S180),
  ITResList181 = [ITRes180|ITResList180],


  ?line {STRes181,S181} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList182 = [STRes181|STResList181],
  ?line ITRes181 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S181),
  ITResList182 = [ITRes181|ITResList181],


  ?line {STRes182,S182} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList183 = [STRes182|STResList182],
  ?line ITRes182 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_token.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S182),
  ITResList183 = [ITRes182|ITResList182],


  ?line {STRes183,S183} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList184 = [STRes183|STResList183],
  ?line ITRes183 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S183),
  ITResList184 = [ITRes183|ITResList183],


  ?line {STRes184,S184} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList185 = [STRes184|STResList184],
  ?line ITRes184 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S184),
  ITResList185 = [ITRes184|ITResList184],


  ?line {STRes185,S185} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList186 = [STRes185|STResList185],
  ?line ITRes185 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S185),
  ITResList186 = [ITRes185|ITResList185],


  ?line {STRes186,S186} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList187 = [STRes186|STResList186],
  ?line ITRes186 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S186),
  ITResList187 = [ITRes186|ITResList186],


  ?line {STRes187,S187} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList188 = [STRes187|STResList187],
  ?line ITRes187 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S187),
  ITResList188 = [ITRes187|ITResList187],


  ?line {STRes188,S188} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList189 = [STRes188|STResList188],
  ?line ITRes188 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S188),
  ITResList189 = [ITRes188|ITResList188],


  ?line {STRes189,S189} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList190 = [STRes189|STResList189],
  ?line ITRes189 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S189),
  ITResList190 = [ITRes189|ITResList189],


  ?line {STRes190,S190} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList191 = [STRes190|STResList190],
  ?line ITRes190 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S190),
  ITResList191 = [ITRes190|ITResList190],


  ?line {STRes191,S191} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList192 = [STRes191|STResList191],
  ?line ITRes191 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S191),
  ITResList192 = [ITRes191|ITResList191],


  ?line {STRes192,S192} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList193 = [STRes192|STResList192],
  ?line ITRes192 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S192),
  ITResList193 = [ITRes192|ITResList192],


  ?line {STRes193,S193} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList194 = [STRes193|STResList193],
  ?line ITRes193 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S193),
  ITResList194 = [ITRes193|ITResList193],


  ?line {STRes194,S194} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList195 = [STRes194|STResList194],
  ?line ITRes194 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREF_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S194),
  ITResList195 = [ITRes194|ITResList194],


  ?line {STRes195,S195} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList196 = [STRes195|STResList195],
  ?line ITRes195 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S195),
  ITResList196 = [ITRes195|ITResList195],


  ?line {STRes196,S196} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList197 = [STRes196|STResList196],
  ?line ITRes196 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S196),
  ITResList197 = [ITRes196|ITResList196],


  ?line {STRes197,S197} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList198 = [STRes197|STResList197],
  ?line ITRes197 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S197),
  ITResList198 = [ITRes197|ITResList197],


  ?line {STRes198,S198} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList199 = [STRes198|STResList198],
  ?line ITRes198 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S198),
  ITResList199 = [ITRes198|ITResList198],


  ?line {STRes199,S199} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList200 = [STRes199|STResList199],
  ?line ITRes199 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S199),
  ITResList200 = [ITRes199|ITResList199],


  ?line {STRes200,S200} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList201 = [STRes200|STResList200],
  ?line ITRes200 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S200),
  ITResList201 = [ITRes200|ITResList200],


  ?line {STRes201,S201} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList202 = [STRes201|STResList201],
  ?line ITRes201 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S201),
  ITResList202 = [ITRes201|ITResList201],


  ?line {STRes202,S202} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList203 = [STRes202|STResList202],
  ?line ITRes202 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S202),
  ITResList203 = [ITRes202|ITResList202],


  ?line {STRes203,S203} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList204 = [STRes203|STResList203],
  ?line ITRes203 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_IDREFS_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S203),
  ITResList204 = [ITRes203|ITResList203],


  ?line {STRes204,S204} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList205 = [STRes204|STResList204],
  ?line ITRes204 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_string.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S204),
  ITResList205 = [ITRes204|ITResList204],


  ?line {STRes205,S205} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList206 = [STRes205|STResList205],
  ?line ITRes205 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S205),
  ITResList206 = [ITRes205|ITResList205],


  ?line {STRes206,S206} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList207 = [STRes206|STResList206],
  ?line ITRes206 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_token.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S206),
  ITResList207 = [ITRes206|ITResList206],


  ?line {STRes207,S207} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList208 = [STRes207|STResList207],
  ?line ITRes207 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S207),
  ITResList208 = [ITRes207|ITResList207],


  ?line {STRes208,S208} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList209 = [STRes208|STResList208],
  ?line ITRes208 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S208),
  ITResList209 = [ITRes208|ITResList208],


  ?line {STRes209,S209} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList210 = [STRes209|STResList209],
  ?line ITRes209 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S209),
  ITResList210 = [ITRes209|ITResList209],


  ?line {STRes210,S210} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList211 = [STRes210|STResList210],
  ?line ITRes210 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S210),
  ITResList211 = [ITRes210|ITResList210],


  ?line {STRes211,S211} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList212 = [STRes211|STResList211],
  ?line ITRes211 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S211),
  ITResList212 = [ITRes211|ITResList211],


  ?line {STRes212,S212} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_IDREFS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList213 = [STRes212|STResList212],
  ?line ITRes212 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_IDREFS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S212),
  ITResList213 = [ITRes212|ITResList212],


  ?line {STRes213,S213} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList214 = [STRes213|STResList213],
  ?line ITRes213 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S213),
  ITResList214 = [ITRes213|ITResList213],


  ?line {STRes214,S214} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList215 = [STRes214|STResList214],
  ?line ITRes214 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S214),
  ITResList215 = [ITRes214|ITResList214],


  ?line {STRes215,S215} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList216 = [STRes215|STResList215],
  ?line ITRes215 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S215),
  ITResList216 = [ITRes215|ITResList215],


  ?line {STRes216,S216} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList217 = [STRes216|STResList216],
  ?line ITRes216 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S216),
  ITResList217 = [ITRes216|ITResList216],


  ?line {STRes217,S217} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList218 = [STRes217|STResList217],
  ?line ITRes217 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S217),
  ITResList218 = [ITRes217|ITResList217],


  ?line {STRes218,S218} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList219 = [STRes218|STResList218],
  ?line ITRes218 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S218),
  ITResList219 = [ITRes218|ITResList218],


  ?line {STRes219,S219} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList220 = [STRes219|STResList219],
  ?line ITRes219 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S219),
  ITResList220 = [ITRes219|ITResList219],


  ?line {STRes220,S220} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList221 = [STRes220|STResList220],
  ?line ITRes220 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S220),
  ITResList221 = [ITRes220|ITResList220],


  ?line {STRes221,S221} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList222 = [STRes221|STResList221],
  ?line ITRes221 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S221),
  ITResList222 = [ITRes221|ITResList221],


  ?line {STRes222,S222} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList223 = [STRes222|STResList222],
  ?line ITRes222 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S222),
  ITResList223 = [ITRes222|ITResList222],


  ?line {STRes223,S223} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList224 = [STRes223|STResList223],
  ?line ITRes223 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S223),
  ITResList224 = [ITRes223|ITResList223],


  ?line {STRes224,S224} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList225 = [STRes224|STResList224],
  ?line ITRes224 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S224),
  ITResList225 = [ITRes224|ITResList224],


  ?line {STRes225,S225} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList226 = [STRes225|STResList225],
  ?line ITRes225 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S225),
  ITResList226 = [ITRes225|ITResList225],


  ?line {STRes226,S226} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList227 = [STRes226|STResList226],
  ?line ITRes226 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S226),
  ITResList227 = [ITRes226|ITResList226],


  ?line {STRes227,S227} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList228 = [STRes227|STResList227],
  ?line ITRes227 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S227),
  ITResList228 = [ITRes227|ITResList227],


  ?line {STRes228,S228} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList229 = [STRes228|STResList228],
  ?line ITRes228 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S228),
  ITResList229 = [ITRes228|ITResList228],


  ?line {STRes229,S229} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList230 = [STRes229|STResList229],
  ?line ITRes229 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S229),
  ITResList230 = [ITRes229|ITResList229],


  ?line {STRes230,S230} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList231 = [STRes230|STResList230],
  ?line ITRes230 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S230),
  ITResList231 = [ITRes230|ITResList230],


  ?line {STRes231,S231} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList232 = [STRes231|STResList231],
  ?line ITRes231 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S231),
  ITResList232 = [ITRes231|ITResList231],


  ?line {STRes232,S232} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList233 = [STRes232|STResList232],
  ?line ITRes232 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S232),
  ITResList233 = [ITRes232|ITResList232],


  ?line {STRes233,S233} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList234 = [STRes233|STResList233],
  ?line ITRes233 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S233),
  ITResList234 = [ITRes233|ITResList233],


  ?line {STRes234,S234} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList235 = [STRes234|STResList234],
  ?line ITRes234 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S234),
  ITResList235 = [ITRes234|ITResList234],


  ?line {STRes235,S235} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList236 = [STRes235|STResList235],
  ?line ITRes235 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S235),
  ITResList236 = [ITRes235|ITResList235],


  ?line {STRes236,S236} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList237 = [STRes236|STResList236],
  ?line ITRes236 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S236),
  ITResList237 = [ITRes236|ITResList236],


  ?line {STRes237,S237} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_dateTime.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList238 = [STRes237|STResList237],
  ?line ITRes237 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_dateTime.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S237),
  ITResList238 = [ITRes237|ITResList237],


  ?line {STRes238,S238} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_time.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList239 = [STRes238|STResList238],
  ?line ITRes238 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_time.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S238),
  ITResList239 = [ITRes238|ITResList238],


  ?line {STRes239,S239} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_date.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList240 = [STRes239|STResList239],
  ?line ITRes239 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_date.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S239),
  ITResList240 = [ITRes239|ITResList239],


  ?line {STRes240,S240} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gYearMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList241 = [STRes240|STResList240],
  ?line ITRes240 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gYearMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S240),
  ITResList241 = [ITRes240|ITResList240],


  ?line {STRes241,S241} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gYear.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList242 = [STRes241|STResList241],
  ?line ITRes241 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gYear.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S241),
  ITResList242 = [ITRes241|ITResList241],


  ?line {STRes242,S242} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gMonthDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList243 = [STRes242|STResList242],
  ?line ITRes242 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gMonthDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S242),
  ITResList243 = [ITRes242|ITResList242],


  ?line {STRes243,S243} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList244 = [STRes243|STResList243],
  ?line ITRes243 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S243),
  ITResList244 = [ITRes243|ITResList243],


  ?line {STRes244,S244} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList245 = [STRes244|STResList244],
  ?line ITRes244 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKEN_gMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S244),
  ITResList245 = [ITRes244|ITResList244],


  ?line {STRes245,S245} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList246 = [STRes245|STResList245],
  ?line ITRes245 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S245),
  ITResList246 = [ITRes245|ITResList245],


  ?line {STRes246,S246} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList247 = [STRes246|STResList246],
  ?line ITRes246 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S246),
  ITResList247 = [ITRes246|ITResList246],


  ?line {STRes247,S247} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList248 = [STRes247|STResList247],
  ?line ITRes247 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S247),
  ITResList248 = [ITRes247|ITResList247],


  ?line {STRes248,S248} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList249 = [STRes248|STResList248],
  ?line ITRes248 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S248),
  ITResList249 = [ITRes248|ITResList248],


  ?line {STRes249,S249} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList250 = [STRes249|STResList249],
  ?line ITRes249 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S249),
  ITResList250 = [ITRes249|ITResList249],


  ?line {STRes250,S250} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_IDREFS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList251 = [STRes250|STResList250],
  ?line ITRes250 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_IDREFS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S250),
  ITResList251 = [ITRes250|ITResList250],


  ?line {STRes251,S251} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList252 = [STRes251|STResList251],
  ?line ITRes251 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S251),
  ITResList252 = [ITRes251|ITResList251],


  ?line {STRes252,S252} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList253 = [STRes252|STResList252],
  ?line ITRes252 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S252),
  ITResList253 = [ITRes252|ITResList252],


  ?line {STRes253,S253} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList254 = [STRes253|STResList253],
  ?line ITRes253 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S253),
  ITResList254 = [ITRes253|ITResList253],


  ?line {STRes254,S254} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList255 = [STRes254|STResList254],
  ?line ITRes254 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S254),
  ITResList255 = [ITRes254|ITResList254],


  ?line {STRes255,S255} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList256 = [STRes255|STResList255],
  ?line ITRes255 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S255),
  ITResList256 = [ITRes255|ITResList255],


  ?line {STRes256,S256} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList257 = [STRes256|STResList256],
  ?line ITRes256 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S256),
  ITResList257 = [ITRes256|ITResList256],


  ?line {STRes257,S257} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList258 = [STRes257|STResList257],
  ?line ITRes257 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S257),
  ITResList258 = [ITRes257|ITResList257],


  ?line {STRes258,S258} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList259 = [STRes258|STResList258],
  ?line ITRes258 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S258),
  ITResList259 = [ITRes258|ITResList258],


  ?line {STRes259,S259} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList260 = [STRes259|STResList259],
  ?line ITRes259 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S259),
  ITResList260 = [ITRes259|ITResList259],


  ?line {STRes260,S260} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList261 = [STRes260|STResList260],
  ?line ITRes260 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S260),
  ITResList261 = [ITRes260|ITResList260],


  ?line {STRes261,S261} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList262 = [STRes261|STResList261],
  ?line ITRes261 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S261),
  ITResList262 = [ITRes261|ITResList261],


  ?line {STRes262,S262} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList263 = [STRes262|STResList262],
  ?line ITRes262 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S262),
  ITResList263 = [ITRes262|ITResList262],


  ?line {STRes263,S263} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList264 = [STRes263|STResList263],
  ?line ITRes263 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S263),
  ITResList264 = [ITRes263|ITResList263],


  ?line {STRes264,S264} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList265 = [STRes264|STResList264],
  ?line ITRes264 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S264),
  ITResList265 = [ITRes264|ITResList264],


  ?line {STRes265,S265} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList266 = [STRes265|STResList265],
  ?line ITRes265 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S265),
  ITResList266 = [ITRes265|ITResList265],


  ?line {STRes266,S266} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList267 = [STRes266|STResList266],
  ?line ITRes266 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S266),
  ITResList267 = [ITRes266|ITResList266],


  ?line {STRes267,S267} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList268 = [STRes267|STResList267],
  ?line ITRes267 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S267),
  ITResList268 = [ITRes267|ITResList267],


  ?line {STRes268,S268} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList269 = [STRes268|STResList268],
  ?line ITRes268 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S268),
  ITResList269 = [ITRes268|ITResList268],


  ?line {STRes269,S269} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList270 = [STRes269|STResList269],
  ?line ITRes269 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S269),
  ITResList270 = [ITRes269|ITResList269],


  ?line {STRes270,S270} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList271 = [STRes270|STResList270],
  ?line ITRes270 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S270),
  ITResList271 = [ITRes270|ITResList270],


  ?line {STRes271,S271} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList272 = [STRes271|STResList271],
  ?line ITRes271 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S271),
  ITResList272 = [ITRes271|ITResList271],


  ?line {STRes272,S272} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList273 = [STRes272|STResList272],
  ?line ITRes272 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S272),
  ITResList273 = [ITRes272|ITResList272],


  ?line {STRes273,S273} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList274 = [STRes273|STResList273],
  ?line ITRes273 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S273),
  ITResList274 = [ITRes273|ITResList273],


  ?line {STRes274,S274} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_dateTime.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList275 = [STRes274|STResList274],
  ?line ITRes274 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_dateTime.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S274),
  ITResList275 = [ITRes274|ITResList274],


  ?line {STRes275,S275} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_time.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList276 = [STRes275|STResList275],
  ?line ITRes275 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_time.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S275),
  ITResList276 = [ITRes275|ITResList275],


  ?line {STRes276,S276} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_date.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList277 = [STRes276|STResList276],
  ?line ITRes276 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_date.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S276),
  ITResList277 = [ITRes276|ITResList276],


  ?line {STRes277,S277} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gYearMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList278 = [STRes277|STResList277],
  ?line ITRes277 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gYearMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S277),
  ITResList278 = [ITRes277|ITResList277],


  ?line {STRes278,S278} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gYear.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList279 = [STRes278|STResList278],
  ?line ITRes278 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gYear.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S278),
  ITResList279 = [ITRes278|ITResList278],


  ?line {STRes279,S279} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gMonthDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList280 = [STRes279|STResList279],
  ?line ITRes279 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gMonthDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S279),
  ITResList280 = [ITRes279|ITResList279],


  ?line {STRes280,S280} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList281 = [STRes280|STResList280],
  ?line ITRes280 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S280),
  ITResList281 = [ITRes280|ITResList280],


  ?line {STRes281,S281} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList282 = [STRes281|STResList281],
  ?line ITRes281 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NMTOKENS_gMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S281),
  ITResList282 = [ITRes281|ITResList281],


  ?line {STRes282,S282} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList283 = [STRes282|STResList282],
  ?line ITRes282 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S282),
  ITResList283 = [ITRes282|ITResList282],


  ?line {STRes283,S283} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList284 = [STRes283|STResList283],
  ?line ITRes283 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S283),
  ITResList284 = [ITRes283|ITResList283],


  ?line {STRes284,S284} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList285 = [STRes284|STResList284],
  ?line ITRes284 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S284),
  ITResList285 = [ITRes284|ITResList284],


  ?line {STRes285,S285} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList286 = [STRes285|STResList285],
  ?line ITRes285 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S285),
  ITResList286 = [ITRes285|ITResList285],


  ?line {STRes286,S286} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList287 = [STRes286|STResList286],
  ?line ITRes286 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S286),
  ITResList287 = [ITRes286|ITResList286],


  ?line {STRes287,S287} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList288 = [STRes287|STResList287],
  ?line ITRes287 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S287),
  ITResList288 = [ITRes287|ITResList287],


  ?line {STRes288,S288} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList289 = [STRes288|STResList288],
  ?line ITRes288 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S288),
  ITResList289 = [ITRes288|ITResList288],


  ?line {STRes289,S289} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_IDREFS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList290 = [STRes289|STResList289],
  ?line ITRes289 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_IDREFS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S289),
  ITResList290 = [ITRes289|ITResList289],


  ?line {STRes290,S290} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList291 = [STRes290|STResList290],
  ?line ITRes290 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S290),
  ITResList291 = [ITRes290|ITResList290],


  ?line {STRes291,S291} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList292 = [STRes291|STResList291],
  ?line ITRes291 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S291),
  ITResList292 = [ITRes291|ITResList291],


  ?line {STRes292,S292} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList293 = [STRes292|STResList292],
  ?line ITRes292 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S292),
  ITResList293 = [ITRes292|ITResList292],


  ?line {STRes293,S293} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList294 = [STRes293|STResList293],
  ?line ITRes293 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S293),
  ITResList294 = [ITRes293|ITResList293],


  ?line {STRes294,S294} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList295 = [STRes294|STResList294],
  ?line ITRes294 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S294),
  ITResList295 = [ITRes294|ITResList294],


  ?line {STRes295,S295} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList296 = [STRes295|STResList295],
  ?line ITRes295 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S295),
  ITResList296 = [ITRes295|ITResList295],


  ?line {STRes296,S296} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList297 = [STRes296|STResList296],
  ?line ITRes296 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S296),
  ITResList297 = [ITRes296|ITResList296],


  ?line {STRes297,S297} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList298 = [STRes297|STResList297],
  ?line ITRes297 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S297),
  ITResList298 = [ITRes297|ITResList297],


  ?line {STRes298,S298} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList299 = [STRes298|STResList298],
  ?line ITRes298 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S298),
  ITResList299 = [ITRes298|ITResList298],


  ?line {STRes299,S299} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList300 = [STRes299|STResList299],
  ?line ITRes299 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S299),
  ITResList300 = [ITRes299|ITResList299],


  ?line {STRes300,S300} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList301 = [STRes300|STResList300],
  ?line ITRes300 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S300),
  ITResList301 = [ITRes300|ITResList300],


  ?line {STRes301,S301} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList302 = [STRes301|STResList301],
  ?line ITRes301 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S301),
  ITResList302 = [ITRes301|ITResList301],


  ?line {STRes302,S302} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList303 = [STRes302|STResList302],
  ?line ITRes302 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S302),
  ITResList303 = [ITRes302|ITResList302],


  ?line {STRes303,S303} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList304 = [STRes303|STResList303],
  ?line ITRes303 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S303),
  ITResList304 = [ITRes303|ITResList303],


  ?line {STRes304,S304} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList305 = [STRes304|STResList304],
  ?line ITRes304 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S304),
  ITResList305 = [ITRes304|ITResList304],


  ?line {STRes305,S305} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList306 = [STRes305|STResList305],
  ?line ITRes305 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S305),
  ITResList306 = [ITRes305|ITResList305],


  ?line {STRes306,S306} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList307 = [STRes306|STResList306],
  ?line ITRes306 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S306),
  ITResList307 = [ITRes306|ITResList306],


  ?line {STRes307,S307} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList308 = [STRes307|STResList307],
  ?line ITRes307 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S307),
  ITResList308 = [ITRes307|ITResList307],


  ?line {STRes308,S308} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList309 = [STRes308|STResList308],
  ?line ITRes308 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S308),
  ITResList309 = [ITRes308|ITResList308],


  ?line {STRes309,S309} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList310 = [STRes309|STResList309],
  ?line ITRes309 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S309),
  ITResList310 = [ITRes309|ITResList309],


  ?line {STRes310,S310} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList311 = [STRes310|STResList310],
  ?line ITRes310 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S310),
  ITResList311 = [ITRes310|ITResList310],


  ?line {STRes311,S311} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList312 = [STRes311|STResList311],
  ?line ITRes311 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S311),
  ITResList312 = [ITRes311|ITResList311],


  ?line {STRes312,S312} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList313 = [STRes312|STResList312],
  ?line ITRes312 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_boolean_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S312),
  ITResList313 = [ITRes312|ITResList312],


  ?line {STRes313,S313} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList314 = [STRes313|STResList313],
  ?line ITRes313 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S313),
  ITResList314 = [ITRes313|ITResList313],


  ?line {STRes314,S314} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList315 = [STRes314|STResList314],
  ?line ITRes314 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S314),
  ITResList315 = [ITRes314|ITResList314],


  ?line {STRes315,S315} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList316 = [STRes315|STResList315],
  ?line ITRes315 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S315),
  ITResList316 = [ITRes315|ITResList315],


  ?line {STRes316,S316} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList317 = [STRes316|STResList316],
  ?line ITRes316 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S316),
  ITResList317 = [ITRes316|ITResList316],


  ?line {STRes317,S317} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList318 = [STRes317|STResList317],
  ?line ITRes317 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S317),
  ITResList318 = [ITRes317|ITResList317],


  ?line {STRes318,S318} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList319 = [STRes318|STResList318],
  ?line ITRes318 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S318),
  ITResList319 = [ITRes318|ITResList318],


  ?line {STRes319,S319} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList320 = [STRes319|STResList319],
  ?line ITRes319 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S319),
  ITResList320 = [ITRes319|ITResList319],


  ?line {STRes320,S320} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList321 = [STRes320|STResList320],
  ?line ITRes320 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S320),
  ITResList321 = [ITRes320|ITResList320],


  ?line {STRes321,S321} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList322 = [STRes321|STResList321],
  ?line ITRes321 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S321),
  ITResList322 = [ITRes321|ITResList321],


  ?line {STRes322,S322} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList323 = [STRes322|STResList322],
  ?line ITRes322 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S322),
  ITResList323 = [ITRes322|ITResList322],


  ?line {STRes323,S323} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList324 = [STRes323|STResList323],
  ?line ITRes323 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S323),
  ITResList324 = [ITRes323|ITResList323],


  ?line {STRes324,S324} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList325 = [STRes324|STResList324],
  ?line ITRes324 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S324),
  ITResList325 = [ITRes324|ITResList324],


  ?line {STRes325,S325} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList326 = [STRes325|STResList325],
  ?line ITRes325 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S325),
  ITResList326 = [ITRes325|ITResList325],


  ?line {STRes326,S326} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList327 = [STRes326|STResList326],
  ?line ITRes326 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S326),
  ITResList327 = [ITRes326|ITResList326],


  ?line {STRes327,S327} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList328 = [STRes327|STResList327],
  ?line ITRes327 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S327),
  ITResList328 = [ITRes327|ITResList327],


  ?line {STRes328,S328} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList329 = [STRes328|STResList328],
  ?line ITRes328 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S328),
  ITResList329 = [ITRes328|ITResList328],


  ?line {STRes329,S329} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList330 = [STRes329|STResList329],
  ?line ITRes329 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S329),
  ITResList330 = [ITRes329|ITResList329],


  ?line {STRes330,S330} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList331 = [STRes330|STResList330],
  ?line ITRes330 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S330),
  ITResList331 = [ITRes330|ITResList330],


  ?line {STRes331,S331} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList332 = [STRes331|STResList331],
  ?line ITRes331 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S331),
  ITResList332 = [ITRes331|ITResList331],


  ?line {STRes332,S332} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList333 = [STRes332|STResList332],
  ?line ITRes332 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S332),
  ITResList333 = [ITRes332|ITResList332],


  ?line {STRes333,S333} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList334 = [STRes333|STResList333],
  ?line ITRes333 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S333),
  ITResList334 = [ITRes333|ITResList333],


  ?line {STRes334,S334} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList335 = [STRes334|STResList334],
  ?line ITRes334 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_base64Binary_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S334),
  ITResList335 = [ITRes334|ITResList334],


  ?line {STRes335,S335} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList336 = [STRes335|STResList335],
  ?line ITRes335 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S335),
  ITResList336 = [ITRes335|ITResList335],


  ?line {STRes336,S336} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList337 = [STRes336|STResList336],
  ?line ITRes336 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S336),
  ITResList337 = [ITRes336|ITResList336],


  ?line {STRes337,S337} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList338 = [STRes337|STResList337],
  ?line ITRes337 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S337),
  ITResList338 = [ITRes337|ITResList337],


  ?line {STRes338,S338} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList339 = [STRes338|STResList338],
  ?line ITRes338 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S338),
  ITResList339 = [ITRes338|ITResList338],


  ?line {STRes339,S339} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList340 = [STRes339|STResList339],
  ?line ITRes339 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S339),
  ITResList340 = [ITRes339|ITResList339],


  ?line {STRes340,S340} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList341 = [STRes340|STResList340],
  ?line ITRes340 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S340),
  ITResList341 = [ITRes340|ITResList340],


  ?line {STRes341,S341} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList342 = [STRes341|STResList341],
  ?line ITRes341 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S341),
  ITResList342 = [ITRes341|ITResList341],


  ?line {STRes342,S342} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList343 = [STRes342|STResList342],
  ?line ITRes342 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S342),
  ITResList343 = [ITRes342|ITResList342],


  ?line {STRes343,S343} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList344 = [STRes343|STResList343],
  ?line ITRes343 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S343),
  ITResList344 = [ITRes343|ITResList343],


  ?line {STRes344,S344} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList345 = [STRes344|STResList344],
  ?line ITRes344 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S344),
  ITResList345 = [ITRes344|ITResList344],


  ?line {STRes345,S345} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList346 = [STRes345|STResList345],
  ?line ITRes345 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S345),
  ITResList346 = [ITRes345|ITResList345],


  ?line {STRes346,S346} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList347 = [STRes346|STResList346],
  ?line ITRes346 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S346),
  ITResList347 = [ITRes346|ITResList346],


  ?line {STRes347,S347} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList348 = [STRes347|STResList347],
  ?line ITRes347 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S347),
  ITResList348 = [ITRes347|ITResList347],


  ?line {STRes348,S348} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList349 = [STRes348|STResList348],
  ?line ITRes348 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S348),
  ITResList349 = [ITRes348|ITResList348],


  ?line {STRes349,S349} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList350 = [STRes349|STResList349],
  ?line ITRes349 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S349),
  ITResList350 = [ITRes349|ITResList349],


  ?line {STRes350,S350} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList351 = [STRes350|STResList350],
  ?line ITRes350 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S350),
  ITResList351 = [ITRes350|ITResList350],


  ?line {STRes351,S351} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList352 = [STRes351|STResList351],
  ?line ITRes351 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S351),
  ITResList352 = [ITRes351|ITResList351],


  ?line {STRes352,S352} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList353 = [STRes352|STResList352],
  ?line ITRes352 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S352),
  ITResList353 = [ITRes352|ITResList352],


  ?line {STRes353,S353} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList354 = [STRes353|STResList353],
  ?line ITRes353 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S353),
  ITResList354 = [ITRes353|ITResList353],


  ?line {STRes354,S354} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList355 = [STRes354|STResList354],
  ?line ITRes354 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S354),
  ITResList355 = [ITRes354|ITResList354],


  ?line {STRes355,S355} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList356 = [STRes355|STResList355],
  ?line ITRes355 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S355),
  ITResList356 = [ITRes355|ITResList355],


  ?line {STRes356,S356} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList357 = [STRes356|STResList356],
  ?line ITRes356 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_hexBinary_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S356),
  ITResList357 = [ITRes356|ITResList356],


  ?line {STRes357,S357} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList358 = [STRes357|STResList357],
  ?line ITRes357 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S357),
  ITResList358 = [ITRes357|ITResList357],


  ?line {STRes358,S358} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList359 = [STRes358|STResList358],
  ?line ITRes358 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S358),
  ITResList359 = [ITRes358|ITResList358],


  ?line {STRes359,S359} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList360 = [STRes359|STResList359],
  ?line ITRes359 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S359),
  ITResList360 = [ITRes359|ITResList359],


  ?line {STRes360,S360} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList361 = [STRes360|STResList360],
  ?line ITRes360 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S360),
  ITResList361 = [ITRes360|ITResList360],


  ?line {STRes361,S361} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList362 = [STRes361|STResList361],
  ?line ITRes361 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S361),
  ITResList362 = [ITRes361|ITResList361],


  ?line {STRes362,S362} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList363 = [STRes362|STResList362],
  ?line ITRes362 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S362),
  ITResList363 = [ITRes362|ITResList362],


  ?line {STRes363,S363} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList364 = [STRes363|STResList363],
  ?line ITRes363 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S363),
  ITResList364 = [ITRes363|ITResList363],


  ?line {STRes364,S364} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList365 = [STRes364|STResList364],
  ?line ITRes364 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S364),
  ITResList365 = [ITRes364|ITResList364],


  ?line {STRes365,S365} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList366 = [STRes365|STResList365],
  ?line ITRes365 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_float.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S365),
  ITResList366 = [ITRes365|ITResList365],


  ?line {STRes366,S366} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList367 = [STRes366|STResList366],
  ?line ITRes366 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S366),
  ITResList367 = [ITRes366|ITResList366],


  ?line {STRes367,S367} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList368 = [STRes367|STResList367],
  ?line ITRes367 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S367),
  ITResList368 = [ITRes367|ITResList367],


  ?line {STRes368,S368} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList369 = [STRes368|STResList368],
  ?line ITRes368 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S368),
  ITResList369 = [ITRes368|ITResList368],


  ?line {STRes369,S369} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList370 = [STRes369|STResList369],
  ?line ITRes369 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S369),
  ITResList370 = [ITRes369|ITResList369],


  ?line {STRes370,S370} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList371 = [STRes370|STResList370],
  ?line ITRes370 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S370),
  ITResList371 = [ITRes370|ITResList370],


  ?line {STRes371,S371} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList372 = [STRes371|STResList371],
  ?line ITRes371 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S371),
  ITResList372 = [ITRes371|ITResList371],


  ?line {STRes372,S372} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList373 = [STRes372|STResList372],
  ?line ITRes372 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S372),
  ITResList373 = [ITRes372|ITResList372],


  ?line {STRes373,S373} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList374 = [STRes373|STResList373],
  ?line ITRes373 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S373),
  ITResList374 = [ITRes373|ITResList373],


  ?line {STRes374,S374} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList375 = [STRes374|STResList374],
  ?line ITRes374 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S374),
  ITResList375 = [ITRes374|ITResList374],


  ?line {STRes375,S375} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList376 = [STRes375|STResList375],
  ?line ITRes375 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S375),
  ITResList376 = [ITRes375|ITResList375],


  ?line {STRes376,S376} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList377 = [STRes376|STResList376],
  ?line ITRes376 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S376),
  ITResList377 = [ITRes376|ITResList376],


  ?line {STRes377,S377} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList378 = [STRes377|STResList377],
  ?line ITRes377 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S377),
  ITResList378 = [ITRes377|ITResList377],


  ?line {STRes378,S378} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList379 = [STRes378|STResList378],
  ?line ITRes378 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S378),
  ITResList379 = [ITRes378|ITResList378],


  ?line {STRes379,S379} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList380 = [STRes379|STResList379],
  ?line ITRes379 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S379),
  ITResList380 = [ITRes379|ITResList379],


  ?line {STRes380,S380} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList381 = [STRes380|STResList380],
  ?line ITRes380 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S380),
  ITResList381 = [ITRes380|ITResList380],


  ?line {STRes381,S381} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList382 = [STRes381|STResList381],
  ?line ITRes381 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_float_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S381),
  ITResList382 = [ITRes381|ITResList381],


  ?line {STRes382,S382} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList383 = [STRes382|STResList382],
  ?line ITRes382 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S382),
  ITResList383 = [ITRes382|ITResList382],


  ?line {STRes383,S383} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList384 = [STRes383|STResList383],
  ?line ITRes383 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S383),
  ITResList384 = [ITRes383|ITResList383],


  ?line {STRes384,S384} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList385 = [STRes384|STResList384],
  ?line ITRes384 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S384),
  ITResList385 = [ITRes384|ITResList384],


  ?line {STRes385,S385} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList386 = [STRes385|STResList385],
  ?line ITRes385 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S385),
  ITResList386 = [ITRes385|ITResList385],


  ?line {STRes386,S386} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList387 = [STRes386|STResList386],
  ?line ITRes386 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S386),
  ITResList387 = [ITRes386|ITResList386],


  ?line {STRes387,S387} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList388 = [STRes387|STResList387],
  ?line ITRes387 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S387),
  ITResList388 = [ITRes387|ITResList387],


  ?line {STRes388,S388} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList389 = [STRes388|STResList388],
  ?line ITRes388 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S388),
  ITResList389 = [ITRes388|ITResList388],


  ?line {STRes389,S389} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList390 = [STRes389|STResList389],
  ?line ITRes389 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S389),
  ITResList390 = [ITRes389|ITResList389],


  ?line {STRes390,S390} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList391 = [STRes390|STResList390],
  ?line ITRes390 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S390),
  ITResList391 = [ITRes390|ITResList390],


  ?line {STRes391,S391} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList392 = [STRes391|STResList391],
  ?line ITRes391 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S391),
  ITResList392 = [ITRes391|ITResList391],


  ?line {STRes392,S392} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList393 = [STRes392|STResList392],
  ?line ITRes392 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S392),
  ITResList393 = [ITRes392|ITResList392],


  ?line {STRes393,S393} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList394 = [STRes393|STResList393],
  ?line ITRes393 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S393),
  ITResList394 = [ITRes393|ITResList393],


  ?line {STRes394,S394} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList395 = [STRes394|STResList394],
  ?line ITRes394 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S394),
  ITResList395 = [ITRes394|ITResList394],


  ?line {STRes395,S395} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList396 = [STRes395|STResList395],
  ?line ITRes395 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_long.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S395),
  ITResList396 = [ITRes395|ITResList395],


  ?line {STRes396,S396} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList397 = [STRes396|STResList396],
  ?line ITRes396 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_int.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S396),
  ITResList397 = [ITRes396|ITResList396],


  ?line {STRes397,S397} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList398 = [STRes397|STResList397],
  ?line ITRes397 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_short.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S397),
  ITResList398 = [ITRes397|ITResList397],


  ?line {STRes398,S398} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList399 = [STRes398|STResList398],
  ?line ITRes398 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S398),
  ITResList399 = [ITRes398|ITResList398],


  ?line {STRes399,S399} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList400 = [STRes399|STResList399],
  ?line ITRes399 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S399),
  ITResList400 = [ITRes399|ITResList399],


  ?line {STRes400,S400} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList401 = [STRes400|STResList400],
  ?line ITRes400 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S400),
  ITResList401 = [ITRes400|ITResList400],


  ?line {STRes401,S401} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList402 = [STRes401|STResList401],
  ?line ITRes401 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S401),
  ITResList402 = [ITRes401|ITResList401],


  ?line {STRes402,S402} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList403 = [STRes402|STResList402],
  ?line ITRes402 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S402),
  ITResList403 = [ITRes402|ITResList402],


  ?line {STRes403,S403} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList404 = [STRes403|STResList403],
  ?line ITRes403 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S403),
  ITResList404 = [ITRes403|ITResList403],


  ?line {STRes404,S404} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList405 = [STRes404|STResList404],
  ?line ITRes404 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S404),
  ITResList405 = [ITRes404|ITResList404],


  ?line {STRes405,S405} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList406 = [STRes405|STResList405],
  ?line ITRes405 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S405),
  ITResList406 = [ITRes405|ITResList405],


  ?line {STRes406,S406} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList407 = [STRes406|STResList406],
  ?line ITRes406 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_decimal_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S406),
  ITResList407 = [ITRes406|ITResList406],


  ?line {STRes407,S407} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList408 = [STRes407|STResList407],
  ?line ITRes407 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S407),
  ITResList408 = [ITRes407|ITResList407],


  ?line {STRes408,S408} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList409 = [STRes408|STResList408],
  ?line ITRes408 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S408),
  ITResList409 = [ITRes408|ITResList408],


  ?line {STRes409,S409} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList410 = [STRes409|STResList409],
  ?line ITRes409 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S409),
  ITResList410 = [ITRes409|ITResList409],


  ?line {STRes410,S410} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList411 = [STRes410|STResList410],
  ?line ITRes410 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S410),
  ITResList411 = [ITRes410|ITResList410],


  ?line {STRes411,S411} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList412 = [STRes411|STResList411],
  ?line ITRes411 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S411),
  ITResList412 = [ITRes411|ITResList411],


  ?line {STRes412,S412} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList413 = [STRes412|STResList412],
  ?line ITRes412 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S412),
  ITResList413 = [ITRes412|ITResList412],


  ?line {STRes413,S413} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList414 = [STRes413|STResList413],
  ?line ITRes413 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S413),
  ITResList414 = [ITRes413|ITResList413],


  ?line {STRes414,S414} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList415 = [STRes414|STResList414],
  ?line ITRes414 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S414),
  ITResList415 = [ITRes414|ITResList414],


  ?line {STRes415,S415} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList416 = [STRes415|STResList415],
  ?line ITRes415 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S415),
  ITResList416 = [ITRes415|ITResList415],


  ?line {STRes416,S416} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList417 = [STRes416|STResList416],
  ?line ITRes416 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S416),
  ITResList417 = [ITRes416|ITResList416],


  ?line {STRes417,S417} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList418 = [STRes417|STResList417],
  ?line ITRes417 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S417),
  ITResList418 = [ITRes417|ITResList417],


  ?line {STRes418,S418} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList419 = [STRes418|STResList418],
  ?line ITRes418 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S418),
  ITResList419 = [ITRes418|ITResList418],


  ?line {STRes419,S419} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList420 = [STRes419|STResList419],
  ?line ITRes419 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S419),
  ITResList420 = [ITRes419|ITResList419],


  ?line {STRes420,S420} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList421 = [STRes420|STResList420],
  ?line ITRes420 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_long.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S420),
  ITResList421 = [ITRes420|ITResList420],


  ?line {STRes421,S421} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList422 = [STRes421|STResList421],
  ?line ITRes421 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_int.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S421),
  ITResList422 = [ITRes421|ITResList421],


  ?line {STRes422,S422} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList423 = [STRes422|STResList422],
  ?line ITRes422 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_short.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S422),
  ITResList423 = [ITRes422|ITResList422],


  ?line {STRes423,S423} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList424 = [STRes423|STResList423],
  ?line ITRes423 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S423),
  ITResList424 = [ITRes423|ITResList423],


  ?line {STRes424,S424} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList425 = [STRes424|STResList424],
  ?line ITRes424 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S424),
  ITResList425 = [ITRes424|ITResList424],


  ?line {STRes425,S425} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList426 = [STRes425|STResList425],
  ?line ITRes425 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S425),
  ITResList426 = [ITRes425|ITResList425],


  ?line {STRes426,S426} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList427 = [STRes426|STResList426],
  ?line ITRes426 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S426),
  ITResList427 = [ITRes426|ITResList426],


  ?line {STRes427,S427} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList428 = [STRes427|STResList427],
  ?line ITRes427 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S427),
  ITResList428 = [ITRes427|ITResList427],


  ?line {STRes428,S428} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList429 = [STRes428|STResList428],
  ?line ITRes428 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S428),
  ITResList429 = [ITRes428|ITResList428],


  ?line {STRes429,S429} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList430 = [STRes429|STResList429],
  ?line ITRes429 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S429),
  ITResList430 = [ITRes429|ITResList429],


  ?line {STRes430,S430} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList431 = [STRes430|STResList430],
  ?line ITRes430 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S430),
  ITResList431 = [ITRes430|ITResList430],


  ?line {STRes431,S431} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList432 = [STRes431|STResList431],
  ?line ITRes431 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_integer_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S431),
  ITResList432 = [ITRes431|ITResList431],


  ?line {STRes432,S432} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList433 = [STRes432|STResList432],
  ?line ITRes432 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S432),
  ITResList433 = [ITRes432|ITResList432],


  ?line {STRes433,S433} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList434 = [STRes433|STResList433],
  ?line ITRes433 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S433),
  ITResList434 = [ITRes433|ITResList433],


  ?line {STRes434,S434} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList435 = [STRes434|STResList434],
  ?line ITRes434 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S434),
  ITResList435 = [ITRes434|ITResList434],


  ?line {STRes435,S435} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList436 = [STRes435|STResList435],
  ?line ITRes435 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S435),
  ITResList436 = [ITRes435|ITResList435],


  ?line {STRes436,S436} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList437 = [STRes436|STResList436],
  ?line ITRes436 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S436),
  ITResList437 = [ITRes436|ITResList436],


  ?line {STRes437,S437} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList438 = [STRes437|STResList437],
  ?line ITRes437 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S437),
  ITResList438 = [ITRes437|ITResList437],


  ?line {STRes438,S438} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList439 = [STRes438|STResList438],
  ?line ITRes438 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S438),
  ITResList439 = [ITRes438|ITResList438],


  ?line {STRes439,S439} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList440 = [STRes439|STResList439],
  ?line ITRes439 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S439),
  ITResList440 = [ITRes439|ITResList439],


  ?line {STRes440,S440} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList441 = [STRes440|STResList440],
  ?line ITRes440 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S440),
  ITResList441 = [ITRes440|ITResList440],


  ?line {STRes441,S441} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList442 = [STRes441|STResList441],
  ?line ITRes441 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S441),
  ITResList442 = [ITRes441|ITResList441],


  ?line {STRes442,S442} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList443 = [STRes442|STResList442],
  ?line ITRes442 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S442),
  ITResList443 = [ITRes442|ITResList442],


  ?line {STRes443,S443} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList444 = [STRes443|STResList443],
  ?line ITRes443 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S443),
  ITResList444 = [ITRes443|ITResList443],


  ?line {STRes444,S444} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList445 = [STRes444|STResList444],
  ?line ITRes444 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S444),
  ITResList445 = [ITRes444|ITResList444],


  ?line {STRes445,S445} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList446 = [STRes445|STResList445],
  ?line ITRes445 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S445),
  ITResList446 = [ITRes445|ITResList445],


  ?line {STRes446,S446} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList447 = [STRes446|STResList446],
  ?line ITRes446 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S446),
  ITResList447 = [ITRes446|ITResList446],


  ?line {STRes447,S447} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList448 = [STRes447|STResList447],
  ?line ITRes447 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S447),
  ITResList448 = [ITRes447|ITResList447],


  ?line {STRes448,S448} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList449 = [STRes448|STResList448],
  ?line ITRes448 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonPositiveInteger_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S448),
  ITResList449 = [ITRes448|ITResList448],


  ?line {STRes449,S449} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList450 = [STRes449|STResList449],
  ?line ITRes449 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S449),
  ITResList450 = [ITRes449|ITResList449],


  ?line {STRes450,S450} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList451 = [STRes450|STResList450],
  ?line ITRes450 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S450),
  ITResList451 = [ITRes450|ITResList450],


  ?line {STRes451,S451} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList452 = [STRes451|STResList451],
  ?line ITRes451 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S451),
  ITResList452 = [ITRes451|ITResList451],


  ?line {STRes452,S452} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList453 = [STRes452|STResList452],
  ?line ITRes452 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S452),
  ITResList453 = [ITRes452|ITResList452],


  ?line {STRes453,S453} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList454 = [STRes453|STResList453],
  ?line ITRes453 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S453),
  ITResList454 = [ITRes453|ITResList453],


  ?line {STRes454,S454} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList455 = [STRes454|STResList454],
  ?line ITRes454 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S454),
  ITResList455 = [ITRes454|ITResList454],


  ?line {STRes455,S455} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList456 = [STRes455|STResList455],
  ?line ITRes455 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S455),
  ITResList456 = [ITRes455|ITResList455],


  ?line {STRes456,S456} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList457 = [STRes456|STResList456],
  ?line ITRes456 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S456),
  ITResList457 = [ITRes456|ITResList456],


  ?line {STRes457,S457} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList458 = [STRes457|STResList457],
  ?line ITRes457 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S457),
  ITResList458 = [ITRes457|ITResList457],


  ?line {STRes458,S458} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList459 = [STRes458|STResList458],
  ?line ITRes458 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S458),
  ITResList459 = [ITRes458|ITResList458],


  ?line {STRes459,S459} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList460 = [STRes459|STResList459],
  ?line ITRes459 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S459),
  ITResList460 = [ITRes459|ITResList459],


  ?line {STRes460,S460} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList461 = [STRes460|STResList460],
  ?line ITRes460 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S460),
  ITResList461 = [ITRes460|ITResList460],


  ?line {STRes461,S461} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList462 = [STRes461|STResList461],
  ?line ITRes461 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S461),
  ITResList462 = [ITRes461|ITResList461],


  ?line {STRes462,S462} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList463 = [STRes462|STResList462],
  ?line ITRes462 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S462),
  ITResList463 = [ITRes462|ITResList462],


  ?line {STRes463,S463} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList464 = [STRes463|STResList463],
  ?line ITRes463 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S463),
  ITResList464 = [ITRes463|ITResList463],


  ?line {STRes464,S464} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList465 = [STRes464|STResList464],
  ?line ITRes464 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_negativeInteger_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S464),
  ITResList465 = [ITRes464|ITResList464],


  ?line {STRes465,S465} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList466 = [STRes465|STResList465],
  ?line ITRes465 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S465),
  ITResList466 = [ITRes465|ITResList465],


  ?line {STRes466,S466} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList467 = [STRes466|STResList466],
  ?line ITRes466 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S466),
  ITResList467 = [ITRes466|ITResList466],


  ?line {STRes467,S467} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList468 = [STRes467|STResList467],
  ?line ITRes467 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S467),
  ITResList468 = [ITRes467|ITResList467],


  ?line {STRes468,S468} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList469 = [STRes468|STResList468],
  ?line ITRes468 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S468),
  ITResList469 = [ITRes468|ITResList468],


  ?line {STRes469,S469} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList470 = [STRes469|STResList469],
  ?line ITRes469 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S469),
  ITResList470 = [ITRes469|ITResList469],


  ?line {STRes470,S470} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList471 = [STRes470|STResList470],
  ?line ITRes470 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S470),
  ITResList471 = [ITRes470|ITResList470],


  ?line {STRes471,S471} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList472 = [STRes471|STResList471],
  ?line ITRes471 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S471),
  ITResList472 = [ITRes471|ITResList471],


  ?line {STRes472,S472} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList473 = [STRes472|STResList472],
  ?line ITRes472 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S472),
  ITResList473 = [ITRes472|ITResList472],


  ?line {STRes473,S473} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList474 = [STRes473|STResList473],
  ?line ITRes473 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S473),
  ITResList474 = [ITRes473|ITResList473],


  ?line {STRes474,S474} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList475 = [STRes474|STResList474],
  ?line ITRes474 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S474),
  ITResList475 = [ITRes474|ITResList474],


  ?line {STRes475,S475} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList476 = [STRes475|STResList475],
  ?line ITRes475 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S475),
  ITResList476 = [ITRes475|ITResList475],


  ?line {STRes476,S476} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList477 = [STRes476|STResList476],
  ?line ITRes476 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S476),
  ITResList477 = [ITRes476|ITResList476],


  ?line {STRes477,S477} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList478 = [STRes477|STResList477],
  ?line ITRes477 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S477),
  ITResList478 = [ITRes477|ITResList477],


  ?line {STRes478,S478} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList479 = [STRes478|STResList478],
  ?line ITRes478 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_long.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S478),
  ITResList479 = [ITRes478|ITResList478],


  ?line {STRes479,S479} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList480 = [STRes479|STResList479],
  ?line ITRes479 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_int.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S479),
  ITResList480 = [ITRes479|ITResList479],


  ?line {STRes480,S480} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList481 = [STRes480|STResList480],
  ?line ITRes480 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_short.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S480),
  ITResList481 = [ITRes480|ITResList480],


  ?line {STRes481,S481} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList482 = [STRes481|STResList481],
  ?line ITRes481 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S481),
  ITResList482 = [ITRes481|ITResList481],


  ?line {STRes482,S482} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList483 = [STRes482|STResList482],
  ?line ITRes482 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S482),
  ITResList483 = [ITRes482|ITResList482],


  ?line {STRes483,S483} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList484 = [STRes483|STResList483],
  ?line ITRes483 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S483),
  ITResList484 = [ITRes483|ITResList483],


  ?line {STRes484,S484} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList485 = [STRes484|STResList484],
  ?line ITRes484 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S484),
  ITResList485 = [ITRes484|ITResList484],


  ?line {STRes485,S485} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList486 = [STRes485|STResList485],
  ?line ITRes485 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S485),
  ITResList486 = [ITRes485|ITResList485],


  ?line {STRes486,S486} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList487 = [STRes486|STResList486],
  ?line ITRes486 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S486),
  ITResList487 = [ITRes486|ITResList486],


  ?line {STRes487,S487} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList488 = [STRes487|STResList487],
  ?line ITRes487 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S487),
  ITResList488 = [ITRes487|ITResList487],


  ?line {STRes488,S488} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList489 = [STRes488|STResList488],
  ?line ITRes488 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S488),
  ITResList489 = [ITRes488|ITResList488],


  ?line {STRes489,S489} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList490 = [STRes489|STResList489],
  ?line ITRes489 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_long_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S489),
  ITResList490 = [ITRes489|ITResList489],


  ?line {STRes490,S490} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList491 = [STRes490|STResList490],
  ?line ITRes490 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S490),
  ITResList491 = [ITRes490|ITResList490],


  ?line {STRes491,S491} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList492 = [STRes491|STResList491],
  ?line ITRes491 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S491),
  ITResList492 = [ITRes491|ITResList491],


  ?line {STRes492,S492} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList493 = [STRes492|STResList492],
  ?line ITRes492 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S492),
  ITResList493 = [ITRes492|ITResList492],


  ?line {STRes493,S493} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList494 = [STRes493|STResList493],
  ?line ITRes493 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S493),
  ITResList494 = [ITRes493|ITResList493],


  ?line {STRes494,S494} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList495 = [STRes494|STResList494],
  ?line ITRes494 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S494),
  ITResList495 = [ITRes494|ITResList494],


  ?line {STRes495,S495} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList496 = [STRes495|STResList495],
  ?line ITRes495 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S495),
  ITResList496 = [ITRes495|ITResList495],


  ?line {STRes496,S496} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList497 = [STRes496|STResList496],
  ?line ITRes496 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S496),
  ITResList497 = [ITRes496|ITResList496],


  ?line {STRes497,S497} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList498 = [STRes497|STResList497],
  ?line ITRes497 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S497),
  ITResList498 = [ITRes497|ITResList497],


  ?line {STRes498,S498} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList499 = [STRes498|STResList498],
  ?line ITRes498 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S498),
  ITResList499 = [ITRes498|ITResList498],


  ?line {STRes499,S499} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList500 = [STRes499|STResList499],
  ?line ITRes499 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S499),
  ITResList500 = [ITRes499|ITResList499],


  ?line {STRes500,S500} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList501 = [STRes500|STResList500],
  ?line ITRes500 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S500),
  ITResList501 = [ITRes500|ITResList500],


  ?line {STRes501,S501} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList502 = [STRes501|STResList501],
  ?line ITRes501 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S501),
  ITResList502 = [ITRes501|ITResList501],


  ?line {STRes502,S502} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList503 = [STRes502|STResList502],
  ?line ITRes502 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S502),
  ITResList503 = [ITRes502|ITResList502],


  ?line {STRes503,S503} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList504 = [STRes503|STResList503],
  ?line ITRes503 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_long.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S503),
  ITResList504 = [ITRes503|ITResList503],


  ?line {STRes504,S504} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList505 = [STRes504|STResList504],
  ?line ITRes504 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_int.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S504),
  ITResList505 = [ITRes504|ITResList504],


  ?line {STRes505,S505} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList506 = [STRes505|STResList505],
  ?line ITRes505 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_short.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S505),
  ITResList506 = [ITRes505|ITResList505],


  ?line {STRes506,S506} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList507 = [STRes506|STResList506],
  ?line ITRes506 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S506),
  ITResList507 = [ITRes506|ITResList506],


  ?line {STRes507,S507} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList508 = [STRes507|STResList507],
  ?line ITRes507 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S507),
  ITResList508 = [ITRes507|ITResList507],


  ?line {STRes508,S508} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList509 = [STRes508|STResList508],
  ?line ITRes508 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S508),
  ITResList509 = [ITRes508|ITResList508],


  ?line {STRes509,S509} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList510 = [STRes509|STResList509],
  ?line ITRes509 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S509),
  ITResList510 = [ITRes509|ITResList509],


  ?line {STRes510,S510} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList511 = [STRes510|STResList510],
  ?line ITRes510 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S510),
  ITResList511 = [ITRes510|ITResList510],


  ?line {STRes511,S511} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList512 = [STRes511|STResList511],
  ?line ITRes511 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S511),
  ITResList512 = [ITRes511|ITResList511],


  ?line {STRes512,S512} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList513 = [STRes512|STResList512],
  ?line ITRes512 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S512),
  ITResList513 = [ITRes512|ITResList512],


  ?line {STRes513,S513} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList514 = [STRes513|STResList513],
  ?line ITRes513 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S513),
  ITResList514 = [ITRes513|ITResList513],


  ?line {STRes514,S514} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList515 = [STRes514|STResList514],
  ?line ITRes514 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_int_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S514),
  ITResList515 = [ITRes514|ITResList514],


  ?line {STRes515,S515} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList516 = [STRes515|STResList515],
  ?line ITRes515 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S515),
  ITResList516 = [ITRes515|ITResList515],


  ?line {STRes516,S516} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList517 = [STRes516|STResList516],
  ?line ITRes516 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S516),
  ITResList517 = [ITRes516|ITResList516],


  ?line {STRes517,S517} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList518 = [STRes517|STResList517],
  ?line ITRes517 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S517),
  ITResList518 = [ITRes517|ITResList517],


  ?line {STRes518,S518} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList519 = [STRes518|STResList518],
  ?line ITRes518 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S518),
  ITResList519 = [ITRes518|ITResList518],


  ?line {STRes519,S519} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList520 = [STRes519|STResList519],
  ?line ITRes519 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S519),
  ITResList520 = [ITRes519|ITResList519],


  ?line {STRes520,S520} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList521 = [STRes520|STResList520],
  ?line ITRes520 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S520),
  ITResList521 = [ITRes520|ITResList520],


  ?line {STRes521,S521} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList522 = [STRes521|STResList521],
  ?line ITRes521 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S521),
  ITResList522 = [ITRes521|ITResList521],


  ?line {STRes522,S522} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList523 = [STRes522|STResList522],
  ?line ITRes522 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S522),
  ITResList523 = [ITRes522|ITResList522],


  ?line {STRes523,S523} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList524 = [STRes523|STResList523],
  ?line ITRes523 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S523),
  ITResList524 = [ITRes523|ITResList523],


  ?line {STRes524,S524} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList525 = [STRes524|STResList524],
  ?line ITRes524 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S524),
  ITResList525 = [ITRes524|ITResList524],


  ?line {STRes525,S525} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList526 = [STRes525|STResList525],
  ?line ITRes525 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S525),
  ITResList526 = [ITRes525|ITResList525],


  ?line {STRes526,S526} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList527 = [STRes526|STResList526],
  ?line ITRes526 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S526),
  ITResList527 = [ITRes526|ITResList526],


  ?line {STRes527,S527} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList528 = [STRes527|STResList527],
  ?line ITRes527 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S527),
  ITResList528 = [ITRes527|ITResList527],


  ?line {STRes528,S528} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList529 = [STRes528|STResList528],
  ?line ITRes528 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_long.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S528),
  ITResList529 = [ITRes528|ITResList528],


  ?line {STRes529,S529} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList530 = [STRes529|STResList529],
  ?line ITRes529 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_int.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S529),
  ITResList530 = [ITRes529|ITResList529],


  ?line {STRes530,S530} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList531 = [STRes530|STResList530],
  ?line ITRes530 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_short.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S530),
  ITResList531 = [ITRes530|ITResList530],


  ?line {STRes531,S531} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList532 = [STRes531|STResList531],
  ?line ITRes531 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S531),
  ITResList532 = [ITRes531|ITResList531],


  ?line {STRes532,S532} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList533 = [STRes532|STResList532],
  ?line ITRes532 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S532),
  ITResList533 = [ITRes532|ITResList532],


  ?line {STRes533,S533} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList534 = [STRes533|STResList533],
  ?line ITRes533 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S533),
  ITResList534 = [ITRes533|ITResList533],


  ?line {STRes534,S534} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList535 = [STRes534|STResList534],
  ?line ITRes534 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S534),
  ITResList535 = [ITRes534|ITResList534],


  ?line {STRes535,S535} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList536 = [STRes535|STResList535],
  ?line ITRes535 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S535),
  ITResList536 = [ITRes535|ITResList535],


  ?line {STRes536,S536} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList537 = [STRes536|STResList536],
  ?line ITRes536 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S536),
  ITResList537 = [ITRes536|ITResList536],


  ?line {STRes537,S537} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList538 = [STRes537|STResList537],
  ?line ITRes537 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S537),
  ITResList538 = [ITRes537|ITResList537],


  ?line {STRes538,S538} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList539 = [STRes538|STResList538],
  ?line ITRes538 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S538),
  ITResList539 = [ITRes538|ITResList538],


  ?line {STRes539,S539} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList540 = [STRes539|STResList539],
  ?line ITRes539 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_short_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S539),
  ITResList540 = [ITRes539|ITResList539],


  ?line {STRes540,S540} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList541 = [STRes540|STResList540],
  ?line ITRes540 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S540),
  ITResList541 = [ITRes540|ITResList540],


  ?line {STRes541,S541} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList542 = [STRes541|STResList541],
  ?line ITRes541 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S541),
  ITResList542 = [ITRes541|ITResList541],


  ?line {STRes542,S542} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList543 = [STRes542|STResList542],
  ?line ITRes542 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S542),
  ITResList543 = [ITRes542|ITResList542],


  ?line {STRes543,S543} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList544 = [STRes543|STResList543],
  ?line ITRes543 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S543),
  ITResList544 = [ITRes543|ITResList543],


  ?line {STRes544,S544} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList545 = [STRes544|STResList544],
  ?line ITRes544 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S544),
  ITResList545 = [ITRes544|ITResList544],


  ?line {STRes545,S545} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList546 = [STRes545|STResList545],
  ?line ITRes545 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S545),
  ITResList546 = [ITRes545|ITResList545],


  ?line {STRes546,S546} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList547 = [STRes546|STResList546],
  ?line ITRes546 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S546),
  ITResList547 = [ITRes546|ITResList546],


  ?line {STRes547,S547} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList548 = [STRes547|STResList547],
  ?line ITRes547 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S547),
  ITResList548 = [ITRes547|ITResList547],


  ?line {STRes548,S548} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList549 = [STRes548|STResList548],
  ?line ITRes548 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S548),
  ITResList549 = [ITRes548|ITResList548],


  ?line {STRes549,S549} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList550 = [STRes549|STResList549],
  ?line ITRes549 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S549),
  ITResList550 = [ITRes549|ITResList549],


  ?line {STRes550,S550} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList551 = [STRes550|STResList550],
  ?line ITRes550 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S550),
  ITResList551 = [ITRes550|ITResList550],


  ?line {STRes551,S551} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList552 = [STRes551|STResList551],
  ?line ITRes551 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S551),
  ITResList552 = [ITRes551|ITResList551],


  ?line {STRes552,S552} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList553 = [STRes552|STResList552],
  ?line ITRes552 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S552),
  ITResList553 = [ITRes552|ITResList552],


  ?line {STRes553,S553} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList554 = [STRes553|STResList553],
  ?line ITRes553 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_long.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S553),
  ITResList554 = [ITRes553|ITResList553],


  ?line {STRes554,S554} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList555 = [STRes554|STResList554],
  ?line ITRes554 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_int.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S554),
  ITResList555 = [ITRes554|ITResList554],


  ?line {STRes555,S555} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList556 = [STRes555|STResList555],
  ?line ITRes555 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_short.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S555),
  ITResList556 = [ITRes555|ITResList555],


  ?line {STRes556,S556} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList557 = [STRes556|STResList556],
  ?line ITRes556 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S556),
  ITResList557 = [ITRes556|ITResList556],


  ?line {STRes557,S557} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList558 = [STRes557|STResList557],
  ?line ITRes557 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S557),
  ITResList558 = [ITRes557|ITResList557],


  ?line {STRes558,S558} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList559 = [STRes558|STResList558],
  ?line ITRes558 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S558),
  ITResList559 = [ITRes558|ITResList558],


  ?line {STRes559,S559} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList560 = [STRes559|STResList559],
  ?line ITRes559 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S559),
  ITResList560 = [ITRes559|ITResList559],


  ?line {STRes560,S560} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList561 = [STRes560|STResList560],
  ?line ITRes560 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S560),
  ITResList561 = [ITRes560|ITResList560],


  ?line {STRes561,S561} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList562 = [STRes561|STResList561],
  ?line ITRes561 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S561),
  ITResList562 = [ITRes561|ITResList561],


  ?line {STRes562,S562} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList563 = [STRes562|STResList562],
  ?line ITRes562 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S562),
  ITResList563 = [ITRes562|ITResList562],


  ?line {STRes563,S563} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList564 = [STRes563|STResList563],
  ?line ITRes563 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S563),
  ITResList564 = [ITRes563|ITResList563],


  ?line {STRes564,S564} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList565 = [STRes564|STResList564],
  ?line ITRes564 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_byte_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S564),
  ITResList565 = [ITRes564|ITResList564],


  ?line {STRes565,S565} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList566 = [STRes565|STResList565],
  ?line ITRes565 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S565),
  ITResList566 = [ITRes565|ITResList565],


  ?line {STRes566,S566} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList567 = [STRes566|STResList566],
  ?line ITRes566 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S566),
  ITResList567 = [ITRes566|ITResList566],


  ?line {STRes567,S567} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList568 = [STRes567|STResList567],
  ?line ITRes567 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S567),
  ITResList568 = [ITRes567|ITResList567],


  ?line {STRes568,S568} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList569 = [STRes568|STResList568],
  ?line ITRes568 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S568),
  ITResList569 = [ITRes568|ITResList568],


  ?line {STRes569,S569} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList570 = [STRes569|STResList569],
  ?line ITRes569 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S569),
  ITResList570 = [ITRes569|ITResList569],


  ?line {STRes570,S570} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList571 = [STRes570|STResList570],
  ?line ITRes570 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S570),
  ITResList571 = [ITRes570|ITResList570],


  ?line {STRes571,S571} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList572 = [STRes571|STResList571],
  ?line ITRes571 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S571),
  ITResList572 = [ITRes571|ITResList571],


  ?line {STRes572,S572} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList573 = [STRes572|STResList572],
  ?line ITRes572 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S572),
  ITResList573 = [ITRes572|ITResList572],


  ?line {STRes573,S573} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList574 = [STRes573|STResList573],
  ?line ITRes573 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S573),
  ITResList574 = [ITRes573|ITResList573],


  ?line {STRes574,S574} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList575 = [STRes574|STResList574],
  ?line ITRes574 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S574),
  ITResList575 = [ITRes574|ITResList574],


  ?line {STRes575,S575} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList576 = [STRes575|STResList575],
  ?line ITRes575 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S575),
  ITResList576 = [ITRes575|ITResList575],


  ?line {STRes576,S576} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList577 = [STRes576|STResList576],
  ?line ITRes576 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S576),
  ITResList577 = [ITRes576|ITResList576],


  ?line {STRes577,S577} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList578 = [STRes577|STResList577],
  ?line ITRes577 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S577),
  ITResList578 = [ITRes577|ITResList577],


  ?line {STRes578,S578} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList579 = [STRes578|STResList578],
  ?line ITRes578 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S578),
  ITResList579 = [ITRes578|ITResList578],


  ?line {STRes579,S579} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList580 = [STRes579|STResList579],
  ?line ITRes579 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S579),
  ITResList580 = [ITRes579|ITResList579],


  ?line {STRes580,S580} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList581 = [STRes580|STResList580],
  ?line ITRes580 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S580),
  ITResList581 = [ITRes580|ITResList580],


  ?line {STRes581,S581} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList582 = [STRes581|STResList581],
  ?line ITRes581 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S581),
  ITResList582 = [ITRes581|ITResList581],


  ?line {STRes582,S582} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList583 = [STRes582|STResList582],
  ?line ITRes582 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S582),
  ITResList583 = [ITRes582|ITResList582],


  ?line {STRes583,S583} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList584 = [STRes583|STResList583],
  ?line ITRes583 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S583),
  ITResList584 = [ITRes583|ITResList583],


  ?line {STRes584,S584} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList585 = [STRes584|STResList584],
  ?line ITRes584 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S584),
  ITResList585 = [ITRes584|ITResList584],


  ?line {STRes585,S585} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList586 = [STRes585|STResList585],
  ?line ITRes585 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S585),
  ITResList586 = [ITRes585|ITResList585],


  ?line {STRes586,S586} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList587 = [STRes586|STResList586],
  ?line ITRes586 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S586),
  ITResList587 = [ITRes586|ITResList586],


  ?line {STRes587,S587} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList588 = [STRes587|STResList587],
  ?line ITRes587 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_nonNegativeInteger_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S587),
  ITResList588 = [ITRes587|ITResList587],


  ?line {STRes588,S588} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList589 = [STRes588|STResList588],
  ?line ITRes588 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S588),
  ITResList589 = [ITRes588|ITResList588],


  ?line {STRes589,S589} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList590 = [STRes589|STResList589],
  ?line ITRes589 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S589),
  ITResList590 = [ITRes589|ITResList589],


  ?line {STRes590,S590} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList591 = [STRes590|STResList590],
  ?line ITRes590 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S590),
  ITResList591 = [ITRes590|ITResList590],


  ?line {STRes591,S591} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList592 = [STRes591|STResList591],
  ?line ITRes591 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S591),
  ITResList592 = [ITRes591|ITResList591],


  ?line {STRes592,S592} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList593 = [STRes592|STResList592],
  ?line ITRes592 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S592),
  ITResList593 = [ITRes592|ITResList592],


  ?line {STRes593,S593} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList594 = [STRes593|STResList593],
  ?line ITRes593 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S593),
  ITResList594 = [ITRes593|ITResList593],


  ?line {STRes594,S594} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList595 = [STRes594|STResList594],
  ?line ITRes594 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S594),
  ITResList595 = [ITRes594|ITResList594],


  ?line {STRes595,S595} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList596 = [STRes595|STResList595],
  ?line ITRes595 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S595),
  ITResList596 = [ITRes595|ITResList595],


  ?line {STRes596,S596} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList597 = [STRes596|STResList596],
  ?line ITRes596 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S596),
  ITResList597 = [ITRes596|ITResList596],


  ?line {STRes597,S597} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList598 = [STRes597|STResList597],
  ?line ITRes597 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S597),
  ITResList598 = [ITRes597|ITResList597],


  ?line {STRes598,S598} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList599 = [STRes598|STResList598],
  ?line ITRes598 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S598),
  ITResList599 = [ITRes598|ITResList598],


  ?line {STRes599,S599} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList600 = [STRes599|STResList599],
  ?line ITRes599 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S599),
  ITResList600 = [ITRes599|ITResList599],


  ?line {STRes600,S600} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList601 = [STRes600|STResList600],
  ?line ITRes600 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S600),
  ITResList601 = [ITRes600|ITResList600],


  ?line {STRes601,S601} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList602 = [STRes601|STResList601],
  ?line ITRes601 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S601),
  ITResList602 = [ITRes601|ITResList601],


  ?line {STRes602,S602} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList603 = [STRes602|STResList602],
  ?line ITRes602 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S602),
  ITResList603 = [ITRes602|ITResList602],


  ?line {STRes603,S603} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList604 = [STRes603|STResList603],
  ?line ITRes603 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S603),
  ITResList604 = [ITRes603|ITResList603],


  ?line {STRes604,S604} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList605 = [STRes604|STResList604],
  ?line ITRes604 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S604),
  ITResList605 = [ITRes604|ITResList604],


  ?line {STRes605,S605} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList606 = [STRes605|STResList605],
  ?line ITRes605 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S605),
  ITResList606 = [ITRes605|ITResList605],


  ?line {STRes606,S606} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList607 = [STRes606|STResList606],
  ?line ITRes606 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S606),
  ITResList607 = [ITRes606|ITResList606],


  ?line {STRes607,S607} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList608 = [STRes607|STResList607],
  ?line ITRes607 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S607),
  ITResList608 = [ITRes607|ITResList607],


  ?line {STRes608,S608} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList609 = [STRes608|STResList608],
  ?line ITRes608 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S608),
  ITResList609 = [ITRes608|ITResList608],


  ?line {STRes609,S609} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList610 = [STRes609|STResList609],
  ?line ITRes609 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S609),
  ITResList610 = [ITRes609|ITResList609],


  ?line {STRes610,S610} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList611 = [STRes610|STResList610],
  ?line ITRes610 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_positiveInteger_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S610),
  ITResList611 = [ITRes610|ITResList610],


  ?line {STRes611,S611} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList612 = [STRes611|STResList611],
  ?line ITRes611 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S611),
  ITResList612 = [ITRes611|ITResList611],


  ?line {STRes612,S612} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList613 = [STRes612|STResList612],
  ?line ITRes612 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S612),
  ITResList613 = [ITRes612|ITResList612],


  ?line {STRes613,S613} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList614 = [STRes613|STResList613],
  ?line ITRes613 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S613),
  ITResList614 = [ITRes613|ITResList613],


  ?line {STRes614,S614} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList615 = [STRes614|STResList614],
  ?line ITRes614 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S614),
  ITResList615 = [ITRes614|ITResList614],


  ?line {STRes615,S615} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList616 = [STRes615|STResList615],
  ?line ITRes615 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S615),
  ITResList616 = [ITRes615|ITResList615],


  ?line {STRes616,S616} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList617 = [STRes616|STResList616],
  ?line ITRes616 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S616),
  ITResList617 = [ITRes616|ITResList616],


  ?line {STRes617,S617} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList618 = [STRes617|STResList617],
  ?line ITRes617 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S617),
  ITResList618 = [ITRes617|ITResList617],


  ?line {STRes618,S618} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList619 = [STRes618|STResList618],
  ?line ITRes618 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S618),
  ITResList619 = [ITRes618|ITResList618],


  ?line {STRes619,S619} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList620 = [STRes619|STResList619],
  ?line ITRes619 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S619),
  ITResList620 = [ITRes619|ITResList619],


  ?line {STRes620,S620} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList621 = [STRes620|STResList620],
  ?line ITRes620 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S620),
  ITResList621 = [ITRes620|ITResList620],


  ?line {STRes621,S621} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList622 = [STRes621|STResList621],
  ?line ITRes621 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S621),
  ITResList622 = [ITRes621|ITResList621],


  ?line {STRes622,S622} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList623 = [STRes622|STResList622],
  ?line ITRes622 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S622),
  ITResList623 = [ITRes622|ITResList622],


  ?line {STRes623,S623} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList624 = [STRes623|STResList623],
  ?line ITRes623 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S623),
  ITResList624 = [ITRes623|ITResList623],


  ?line {STRes624,S624} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList625 = [STRes624|STResList624],
  ?line ITRes624 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S624),
  ITResList625 = [ITRes624|ITResList624],


  ?line {STRes625,S625} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList626 = [STRes625|STResList625],
  ?line ITRes625 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S625),
  ITResList626 = [ITRes625|ITResList625],


  ?line {STRes626,S626} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList627 = [STRes626|STResList626],
  ?line ITRes626 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S626),
  ITResList627 = [ITRes626|ITResList626],


  ?line {STRes627,S627} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList628 = [STRes627|STResList627],
  ?line ITRes627 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S627),
  ITResList628 = [ITRes627|ITResList627],


  ?line {STRes628,S628} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList629 = [STRes628|STResList628],
  ?line ITRes628 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S628),
  ITResList629 = [ITRes628|ITResList628],


  ?line {STRes629,S629} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList630 = [STRes629|STResList629],
  ?line ITRes629 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S629),
  ITResList630 = [ITRes629|ITResList629],


  ?line {STRes630,S630} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList631 = [STRes630|STResList630],
  ?line ITRes630 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S630),
  ITResList631 = [ITRes630|ITResList630],


  ?line {STRes631,S631} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList632 = [STRes631|STResList631],
  ?line ITRes631 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S631),
  ITResList632 = [ITRes631|ITResList631],


  ?line {STRes632,S632} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList633 = [STRes632|STResList632],
  ?line ITRes632 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S632),
  ITResList633 = [ITRes632|ITResList632],


  ?line {STRes633,S633} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList634 = [STRes633|STResList633],
  ?line ITRes633 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedLong_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S633),
  ITResList634 = [ITRes633|ITResList633],


  ?line {STRes634,S634} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList635 = [STRes634|STResList634],
  ?line ITRes634 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S634),
  ITResList635 = [ITRes634|ITResList634],


  ?line {STRes635,S635} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList636 = [STRes635|STResList635],
  ?line ITRes635 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S635),
  ITResList636 = [ITRes635|ITResList635],


  ?line {STRes636,S636} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList637 = [STRes636|STResList636],
  ?line ITRes636 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S636),
  ITResList637 = [ITRes636|ITResList636],


  ?line {STRes637,S637} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList638 = [STRes637|STResList637],
  ?line ITRes637 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S637),
  ITResList638 = [ITRes637|ITResList637],


  ?line {STRes638,S638} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList639 = [STRes638|STResList638],
  ?line ITRes638 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S638),
  ITResList639 = [ITRes638|ITResList638],


  ?line {STRes639,S639} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList640 = [STRes639|STResList639],
  ?line ITRes639 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S639),
  ITResList640 = [ITRes639|ITResList639],


  ?line {STRes640,S640} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList641 = [STRes640|STResList640],
  ?line ITRes640 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S640),
  ITResList641 = [ITRes640|ITResList640],


  ?line {STRes641,S641} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList642 = [STRes641|STResList641],
  ?line ITRes641 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S641),
  ITResList642 = [ITRes641|ITResList641],


  ?line {STRes642,S642} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList643 = [STRes642|STResList642],
  ?line ITRes642 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S642),
  ITResList643 = [ITRes642|ITResList642],


  ?line {STRes643,S643} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList644 = [STRes643|STResList643],
  ?line ITRes643 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S643),
  ITResList644 = [ITRes643|ITResList643],


  ?line {STRes644,S644} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList645 = [STRes644|STResList644],
  ?line ITRes644 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S644),
  ITResList645 = [ITRes644|ITResList644],


  ?line {STRes645,S645} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList646 = [STRes645|STResList645],
  ?line ITRes645 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S645),
  ITResList646 = [ITRes645|ITResList645],


  ?line {STRes646,S646} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList647 = [STRes646|STResList646],
  ?line ITRes646 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S646),
  ITResList647 = [ITRes646|ITResList646],


  ?line {STRes647,S647} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList648 = [STRes647|STResList647],
  ?line ITRes647 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S647),
  ITResList648 = [ITRes647|ITResList647],


  ?line {STRes648,S648} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList649 = [STRes648|STResList648],
  ?line ITRes648 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S648),
  ITResList649 = [ITRes648|ITResList648],


  ?line {STRes649,S649} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList650 = [STRes649|STResList649],
  ?line ITRes649 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S649),
  ITResList650 = [ITRes649|ITResList649],


  ?line {STRes650,S650} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList651 = [STRes650|STResList650],
  ?line ITRes650 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S650),
  ITResList651 = [ITRes650|ITResList650],


  ?line {STRes651,S651} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList652 = [STRes651|STResList651],
  ?line ITRes651 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S651),
  ITResList652 = [ITRes651|ITResList651],


  ?line {STRes652,S652} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList653 = [STRes652|STResList652],
  ?line ITRes652 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S652),
  ITResList653 = [ITRes652|ITResList652],


  ?line {STRes653,S653} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList654 = [STRes653|STResList653],
  ?line ITRes653 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S653),
  ITResList654 = [ITRes653|ITResList653],


  ?line {STRes654,S654} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList655 = [STRes654|STResList654],
  ?line ITRes654 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S654),
  ITResList655 = [ITRes654|ITResList654],


  ?line {STRes655,S655} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList656 = [STRes655|STResList655],
  ?line ITRes655 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S655),
  ITResList656 = [ITRes655|ITResList655],


  ?line {STRes656,S656} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList657 = [STRes656|STResList656],
  ?line ITRes656 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedInt_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S656),
  ITResList657 = [ITRes656|ITResList656],


  ?line {STRes657,S657} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList658 = [STRes657|STResList657],
  ?line ITRes657 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S657),
  ITResList658 = [ITRes657|ITResList657],


  ?line {STRes658,S658} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList659 = [STRes658|STResList658],
  ?line ITRes658 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S658),
  ITResList659 = [ITRes658|ITResList658],


  ?line {STRes659,S659} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList660 = [STRes659|STResList659],
  ?line ITRes659 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S659),
  ITResList660 = [ITRes659|ITResList659],


  ?line {STRes660,S660} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList661 = [STRes660|STResList660],
  ?line ITRes660 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S660),
  ITResList661 = [ITRes660|ITResList660],


  ?line {STRes661,S661} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList662 = [STRes661|STResList661],
  ?line ITRes661 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S661),
  ITResList662 = [ITRes661|ITResList661],


  ?line {STRes662,S662} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList663 = [STRes662|STResList662],
  ?line ITRes662 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S662),
  ITResList663 = [ITRes662|ITResList662],


  ?line {STRes663,S663} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList664 = [STRes663|STResList663],
  ?line ITRes663 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S663),
  ITResList664 = [ITRes663|ITResList663],


  ?line {STRes664,S664} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList665 = [STRes664|STResList664],
  ?line ITRes664 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S664),
  ITResList665 = [ITRes664|ITResList664],


  ?line {STRes665,S665} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList666 = [STRes665|STResList665],
  ?line ITRes665 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S665),
  ITResList666 = [ITRes665|ITResList665],


  ?line {STRes666,S666} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList667 = [STRes666|STResList666],
  ?line ITRes666 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S666),
  ITResList667 = [ITRes666|ITResList666],


  ?line {STRes667,S667} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList668 = [STRes667|STResList667],
  ?line ITRes667 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S667),
  ITResList668 = [ITRes667|ITResList667],


  ?line {STRes668,S668} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList669 = [STRes668|STResList668],
  ?line ITRes668 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S668),
  ITResList669 = [ITRes668|ITResList668],


  ?line {STRes669,S669} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList670 = [STRes669|STResList669],
  ?line ITRes669 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S669),
  ITResList670 = [ITRes669|ITResList669],


  ?line {STRes670,S670} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList671 = [STRes670|STResList670],
  ?line ITRes670 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S670),
  ITResList671 = [ITRes670|ITResList670],


  ?line {STRes671,S671} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList672 = [STRes671|STResList671],
  ?line ITRes671 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S671),
  ITResList672 = [ITRes671|ITResList671],


  ?line {STRes672,S672} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList673 = [STRes672|STResList672],
  ?line ITRes672 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S672),
  ITResList673 = [ITRes672|ITResList672],


  ?line {STRes673,S673} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList674 = [STRes673|STResList673],
  ?line ITRes673 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S673),
  ITResList674 = [ITRes673|ITResList673],


  ?line {STRes674,S674} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList675 = [STRes674|STResList674],
  ?line ITRes674 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S674),
  ITResList675 = [ITRes674|ITResList674],


  ?line {STRes675,S675} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList676 = [STRes675|STResList675],
  ?line ITRes675 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S675),
  ITResList676 = [ITRes675|ITResList675],


  ?line {STRes676,S676} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList677 = [STRes676|STResList676],
  ?line ITRes676 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S676),
  ITResList677 = [ITRes676|ITResList676],


  ?line {STRes677,S677} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList678 = [STRes677|STResList677],
  ?line ITRes677 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S677),
  ITResList678 = [ITRes677|ITResList677],


  ?line {STRes678,S678} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList679 = [STRes678|STResList678],
  ?line ITRes678 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S678),
  ITResList679 = [ITRes678|ITResList678],


  ?line {STRes679,S679} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList680 = [STRes679|STResList679],
  ?line ITRes679 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedShort_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S679),
  ITResList680 = [ITRes679|ITResList679],


  ?line {STRes680,S680} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList681 = [STRes680|STResList680],
  ?line ITRes680 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S680),
  ITResList681 = [ITRes680|ITResList680],


  ?line {STRes681,S681} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList682 = [STRes681|STResList681],
  ?line ITRes681 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S681),
  ITResList682 = [ITRes681|ITResList681],


  ?line {STRes682,S682} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList683 = [STRes682|STResList682],
  ?line ITRes682 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S682),
  ITResList683 = [ITRes682|ITResList682],


  ?line {STRes683,S683} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList684 = [STRes683|STResList683],
  ?line ITRes683 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S683),
  ITResList684 = [ITRes683|ITResList683],


  ?line {STRes684,S684} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList685 = [STRes684|STResList684],
  ?line ITRes684 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S684),
  ITResList685 = [ITRes684|ITResList684],


  ?line {STRes685,S685} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList686 = [STRes685|STResList685],
  ?line ITRes685 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S685),
  ITResList686 = [ITRes685|ITResList685],


  ?line {STRes686,S686} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList687 = [STRes686|STResList686],
  ?line ITRes686 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S686),
  ITResList687 = [ITRes686|ITResList686],


  ?line {STRes687,S687} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList688 = [STRes687|STResList687],
  ?line ITRes687 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S687),
  ITResList688 = [ITRes687|ITResList687],


  ?line {STRes688,S688} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList689 = [STRes688|STResList688],
  ?line ITRes688 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S688),
  ITResList689 = [ITRes688|ITResList688],


  ?line {STRes689,S689} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList690 = [STRes689|STResList689],
  ?line ITRes689 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S689),
  ITResList690 = [ITRes689|ITResList689],


  ?line {STRes690,S690} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList691 = [STRes690|STResList690],
  ?line ITRes690 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S690),
  ITResList691 = [ITRes690|ITResList690],


  ?line {STRes691,S691} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList692 = [STRes691|STResList691],
  ?line ITRes691 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S691),
  ITResList692 = [ITRes691|ITResList691],


  ?line {STRes692,S692} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList693 = [STRes692|STResList692],
  ?line ITRes692 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S692),
  ITResList693 = [ITRes692|ITResList692],


  ?line {STRes693,S693} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList694 = [STRes693|STResList693],
  ?line ITRes693 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S693),
  ITResList694 = [ITRes693|ITResList693],


  ?line {STRes694,S694} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList695 = [STRes694|STResList694],
  ?line ITRes694 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S694),
  ITResList695 = [ITRes694|ITResList694],


  ?line {STRes695,S695} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList696 = [STRes695|STResList695],
  ?line ITRes695 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S695),
  ITResList696 = [ITRes695|ITResList695],


  ?line {STRes696,S696} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList697 = [STRes696|STResList696],
  ?line ITRes696 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S696),
  ITResList697 = [ITRes696|ITResList696],


  ?line {STRes697,S697} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList698 = [STRes697|STResList697],
  ?line ITRes697 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S697),
  ITResList698 = [ITRes697|ITResList697],


  ?line {STRes698,S698} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList699 = [STRes698|STResList698],
  ?line ITRes698 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S698),
  ITResList699 = [ITRes698|ITResList698],


  ?line {STRes699,S699} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList700 = [STRes699|STResList699],
  ?line ITRes699 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S699),
  ITResList700 = [ITRes699|ITResList699],


  ?line {STRes700,S700} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList701 = [STRes700|STResList700],
  ?line ITRes700 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S700),
  ITResList701 = [ITRes700|ITResList700],


  ?line {STRes701,S701} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList702 = [STRes701|STResList701],
  ?line ITRes701 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S701),
  ITResList702 = [ITRes701|ITResList701],


  ?line {STRes702,S702} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList703 = [STRes702|STResList702],
  ?line ITRes702 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_unsignedByte_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S702),
  ITResList703 = [ITRes702|ITResList702],


  ?line {STRes703,S703} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList704 = [STRes703|STResList703],
  ?line ITRes703 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S703),
  ITResList704 = [ITRes703|ITResList703],


  ?line {STRes704,S704} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList705 = [STRes704|STResList704],
  ?line ITRes704 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S704),
  ITResList705 = [ITRes704|ITResList704],


  ?line {STRes705,S705} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList706 = [STRes705|STResList705],
  ?line ITRes705 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S705),
  ITResList706 = [ITRes705|ITResList705],


  ?line {STRes706,S706} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList707 = [STRes706|STResList706],
  ?line ITRes706 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S706),
  ITResList707 = [ITRes706|ITResList706],


  ?line {STRes707,S707} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList708 = [STRes707|STResList707],
  ?line ITRes707 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S707),
  ITResList708 = [ITRes707|ITResList707],


  ?line {STRes708,S708} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList709 = [STRes708|STResList708],
  ?line ITRes708 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S708),
  ITResList709 = [ITRes708|ITResList708],


  ?line {STRes709,S709} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList710 = [STRes709|STResList709],
  ?line ITRes709 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S709),
  ITResList710 = [ITRes709|ITResList709],


  ?line {STRes710,S710} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList711 = [STRes710|STResList710],
  ?line ITRes710 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S710),
  ITResList711 = [ITRes710|ITResList710],


  ?line {STRes711,S711} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList712 = [STRes711|STResList711],
  ?line ITRes711 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S711),
  ITResList712 = [ITRes711|ITResList711],


  ?line {STRes712,S712} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList713 = [STRes712|STResList712],
  ?line ITRes712 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S712),
  ITResList713 = [ITRes712|ITResList712],


  ?line {STRes713,S713} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList714 = [STRes713|STResList713],
  ?line ITRes713 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S713),
  ITResList714 = [ITRes713|ITResList713],


  ?line {STRes714,S714} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList715 = [STRes714|STResList714],
  ?line ITRes714 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S714),
  ITResList715 = [ITRes714|ITResList714],


  ?line {STRes715,S715} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList716 = [STRes715|STResList715],
  ?line ITRes715 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S715),
  ITResList716 = [ITRes715|ITResList715],


  ?line {STRes716,S716} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList717 = [STRes716|STResList716],
  ?line ITRes716 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S716),
  ITResList717 = [ITRes716|ITResList716],


  ?line {STRes717,S717} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList718 = [STRes717|STResList717],
  ?line ITRes717 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S717),
  ITResList718 = [ITRes717|ITResList717],


  ?line {STRes718,S718} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList719 = [STRes718|STResList718],
  ?line ITRes718 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S718),
  ITResList719 = [ITRes718|ITResList718],


  ?line {STRes719,S719} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList720 = [STRes719|STResList719],
  ?line ITRes719 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S719),
  ITResList720 = [ITRes719|ITResList719],


  ?line {STRes720,S720} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList721 = [STRes720|STResList720],
  ?line ITRes720 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S720),
  ITResList721 = [ITRes720|ITResList720],


  ?line {STRes721,S721} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList722 = [STRes721|STResList721],
  ?line ITRes721 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S721),
  ITResList722 = [ITRes721|ITResList721],


  ?line {STRes722,S722} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList723 = [STRes722|STResList722],
  ?line ITRes722 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S722),
  ITResList723 = [ITRes722|ITResList722],


  ?line {STRes723,S723} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList724 = [STRes723|STResList723],
  ?line ITRes723 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S723),
  ITResList724 = [ITRes723|ITResList723],


  ?line {STRes724,S724} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList725 = [STRes724|STResList724],
  ?line ITRes724 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S724),
  ITResList725 = [ITRes724|ITResList724],


  ?line {STRes725,S725} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList726 = [STRes725|STResList725],
  ?line ITRes725 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S725),
  ITResList726 = [ITRes725|ITResList725],


  ?line {STRes726,S726} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList727 = [STRes726|STResList726],
  ?line ITRes726 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_double.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S726),
  ITResList727 = [ITRes726|ITResList726],


  ?line {STRes727,S727} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList728 = [STRes727|STResList727],
  ?line ITRes727 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_double_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S727),
  ITResList728 = [ITRes727|ITResList727],


  ?line {STRes728,S728} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList729 = [STRes728|STResList728],
  ?line ITRes728 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S728),
  ITResList729 = [ITRes728|ITResList728],


  ?line {STRes729,S729} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList730 = [STRes729|STResList729],
  ?line ITRes729 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S729),
  ITResList730 = [ITRes729|ITResList729],


  ?line {STRes730,S730} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList731 = [STRes730|STResList730],
  ?line ITRes730 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S730),
  ITResList731 = [ITRes730|ITResList730],


  ?line {STRes731,S731} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList732 = [STRes731|STResList731],
  ?line ITRes731 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S731),
  ITResList732 = [ITRes731|ITResList731],


  ?line {STRes732,S732} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList733 = [STRes732|STResList732],
  ?line ITRes732 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S732),
  ITResList733 = [ITRes732|ITResList732],


  ?line {STRes733,S733} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList734 = [STRes733|STResList733],
  ?line ITRes733 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S733),
  ITResList734 = [ITRes733|ITResList733],


  ?line {STRes734,S734} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList735 = [STRes734|STResList734],
  ?line ITRes734 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S734),
  ITResList735 = [ITRes734|ITResList734],


  ?line {STRes735,S735} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList736 = [STRes735|STResList735],
  ?line ITRes735 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S735),
  ITResList736 = [ITRes735|ITResList735],


  ?line {STRes736,S736} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_IDREFS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList737 = [STRes736|STResList736],
  ?line ITRes736 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_IDREFS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S736),
  ITResList737 = [ITRes736|ITResList736],


  ?line {STRes737,S737} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList738 = [STRes737|STResList737],
  ?line ITRes737 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S737),
  ITResList738 = [ITRes737|ITResList737],


  ?line {STRes738,S738} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList739 = [STRes738|STResList738],
  ?line ITRes738 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S738),
  ITResList739 = [ITRes738|ITResList738],


  ?line {STRes739,S739} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList740 = [STRes739|STResList739],
  ?line ITRes739 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S739),
  ITResList740 = [ITRes739|ITResList739],


  ?line {STRes740,S740} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_base64Binary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList741 = [STRes740|STResList740],
  ?line ITRes740 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_base64Binary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S740),
  ITResList741 = [ITRes740|ITResList740],


  ?line {STRes741,S741} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_hexBinary.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList742 = [STRes741|STResList741],
  ?line ITRes741 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_hexBinary.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S741),
  ITResList742 = [ITRes741|ITResList741],


  ?line {STRes742,S742} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_float.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList743 = [STRes742|STResList742],
  ?line ITRes742 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_float.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S742),
  ITResList743 = [ITRes742|ITResList742],


  ?line {STRes743,S743} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_decimal.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList744 = [STRes743|STResList743],
  ?line ITRes743 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_decimal.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S743),
  ITResList744 = [ITRes743|ITResList743],


  ?line {STRes744,S744} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_integer.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList745 = [STRes744|STResList744],
  ?line ITRes744 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_integer.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S744),
  ITResList745 = [ITRes744|ITResList744],


  ?line {STRes745,S745} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_nonPositiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList746 = [STRes745|STResList745],
  ?line ITRes745 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_nonPositiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S745),
  ITResList746 = [ITRes745|ITResList745],


  ?line {STRes746,S746} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_negativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList747 = [STRes746|STResList746],
  ?line ITRes746 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_negativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S746),
  ITResList747 = [ITRes746|ITResList746],


  ?line {STRes747,S747} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_long.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList748 = [STRes747|STResList747],
  ?line ITRes747 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_long.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S747),
  ITResList748 = [ITRes747|ITResList747],


  ?line {STRes748,S748} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_int.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList749 = [STRes748|STResList748],
  ?line ITRes748 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_int.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S748),
  ITResList749 = [ITRes748|ITResList748],


  ?line {STRes749,S749} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_short.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList750 = [STRes749|STResList749],
  ?line ITRes749 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_short.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S749),
  ITResList750 = [ITRes749|ITResList749],


  ?line {STRes750,S750} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_byte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList751 = [STRes750|STResList750],
  ?line ITRes750 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_byte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S750),
  ITResList751 = [ITRes750|ITResList750],


  ?line {STRes751,S751} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_nonNegativeInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList752 = [STRes751|STResList751],
  ?line ITRes751 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_nonNegativeInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S751),
  ITResList752 = [ITRes751|ITResList751],


  ?line {STRes752,S752} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_positiveInteger.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList753 = [STRes752|STResList752],
  ?line ITRes752 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_positiveInteger.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S752),
  ITResList753 = [ITRes752|ITResList752],


  ?line {STRes753,S753} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_unsignedLong.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList754 = [STRes753|STResList753],
  ?line ITRes753 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_unsignedLong.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S753),
  ITResList754 = [ITRes753|ITResList753],


  ?line {STRes754,S754} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_unsignedInt.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList755 = [STRes754|STResList754],
  ?line ITRes754 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_unsignedInt.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S754),
  ITResList755 = [ITRes754|ITResList754],


  ?line {STRes755,S755} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_unsignedShort.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList756 = [STRes755|STResList755],
  ?line ITRes755 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_unsignedShort.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S755),
  ITResList756 = [ITRes755|ITResList755],


  ?line {STRes756,S756} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_unsignedByte.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList757 = [STRes756|STResList756],
  ?line ITRes756 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_unsignedByte.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S756),
  ITResList757 = [ITRes756|ITResList756],


  ?line {STRes757,S757} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_double.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList758 = [STRes757|STResList757],
  ?line ITRes757 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_double.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S757),
  ITResList758 = [ITRes757|ITResList757],


  ?line {STRes758,S758} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList759 = [STRes758|STResList758],
  ?line ITRes758 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S758),
  ITResList759 = [ITRes758|ITResList758],


  ?line {STRes759,S759} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList760 = [STRes759|STResList759],
  ?line ITRes759 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S759),
  ITResList760 = [ITRes759|ITResList759],


  ?line {STRes760,S760} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList761 = [STRes760|STResList760],
  ?line ITRes760 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S760),
  ITResList761 = [ITRes760|ITResList760],


  ?line {STRes761,S761} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList762 = [STRes761|STResList761],
  ?line ITRes761 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S761),
  ITResList762 = [ITRes761|ITResList761],


  ?line {STRes762,S762} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_dateTime.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList763 = [STRes762|STResList762],
  ?line ITRes762 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_dateTime.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S762),
  ITResList763 = [ITRes762|ITResList762],


  ?line {STRes763,S763} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_time.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList764 = [STRes763|STResList763],
  ?line ITRes763 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_time.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S763),
  ITResList764 = [ITRes763|ITResList763],


  ?line {STRes764,S764} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_date.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList765 = [STRes764|STResList764],
  ?line ITRes764 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_date.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S764),
  ITResList765 = [ITRes764|ITResList764],


  ?line {STRes765,S765} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gYearMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList766 = [STRes765|STResList765],
  ?line ITRes765 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gYearMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S765),
  ITResList766 = [ITRes765|ITResList765],


  ?line {STRes766,S766} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gYear.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList767 = [STRes766|STResList766],
  ?line ITRes766 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gYear.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S766),
  ITResList767 = [ITRes766|ITResList766],


  ?line {STRes767,S767} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gMonthDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList768 = [STRes767|STResList767],
  ?line ITRes767 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gMonthDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S767),
  ITResList768 = [ITRes767|ITResList767],


  ?line {STRes768,S768} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList769 = [STRes768|STResList768],
  ?line ITRes768 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S768),
  ITResList769 = [ITRes768|ITResList768],


  ?line {STRes769,S769} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList770 = [STRes769|STResList769],
  ?line ITRes769 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_anyURI_gMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S769),
  ITResList770 = [ITRes769|ITResList769],


  ?line {STRes770,S770} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList771 = [STRes770|STResList770],
  ?line ITRes770 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S770),
  ITResList771 = [ITRes770|ITResList770],


  ?line {STRes771,S771} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList772 = [STRes771|STResList771],
  ?line ITRes771 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S771),
  ITResList772 = [ITRes771|ITResList771],


  ?line {STRes772,S772} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList773 = [STRes772|STResList772],
  ?line ITRes772 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S772),
  ITResList773 = [ITRes772|ITResList772],


  ?line {STRes773,S773} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList774 = [STRes773|STResList773],
  ?line ITRes773 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S773),
  ITResList774 = [ITRes773|ITResList773],


  ?line {STRes774,S774} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList775 = [STRes774|STResList774],
  ?line ITRes774 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S774),
  ITResList775 = [ITRes774|ITResList774],


  ?line {STRes775,S775} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList776 = [STRes775|STResList775],
  ?line ITRes775 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S775),
  ITResList776 = [ITRes775|ITResList775],


  ?line {STRes776,S776} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList777 = [STRes776|STResList776],
  ?line ITRes776 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S776),
  ITResList777 = [ITRes776|ITResList776],


  ?line {STRes777,S777} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList778 = [STRes777|STResList777],
  ?line ITRes777 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S777),
  ITResList778 = [ITRes777|ITResList777],


  ?line {STRes778,S778} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_IDREFS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList779 = [STRes778|STResList778],
  ?line ITRes778 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_IDREFS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S778),
  ITResList779 = [ITRes778|ITResList778],


  ?line {STRes779,S779} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList780 = [STRes779|STResList779],
  ?line ITRes779 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S779),
  ITResList780 = [ITRes779|ITResList779],


  ?line {STRes780,S780} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList781 = [STRes780|STResList780],
  ?line ITRes780 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S780),
  ITResList781 = [ITRes780|ITResList780],


  ?line {STRes781,S781} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList782 = [STRes781|STResList781],
  ?line ITRes781 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S781),
  ITResList782 = [ITRes781|ITResList781],


  ?line {STRes782,S782} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList783 = [STRes782|STResList782],
  ?line ITRes782 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S782),
  ITResList783 = [ITRes782|ITResList782],


  ?line {STRes783,S783} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList784 = [STRes783|STResList783],
  ?line ITRes783 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S783),
  ITResList784 = [ITRes783|ITResList783],


  ?line {STRes784,S784} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList785 = [STRes784|STResList784],
  ?line ITRes784 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_QName_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S784),
  ITResList785 = [ITRes784|ITResList784],


  ?line {STRes785,S785} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList786 = [STRes785|STResList785],
  ?line ITRes785 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S785),
  ITResList786 = [ITRes785|ITResList785],


  ?line {STRes786,S786} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList787 = [STRes786|STResList786],
  ?line ITRes786 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S786),
  ITResList787 = [ITRes786|ITResList786],


  ?line {STRes787,S787} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList788 = [STRes787|STResList787],
  ?line ITRes787 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S787),
  ITResList788 = [ITRes787|ITResList787],


  ?line {STRes788,S788} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_language.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList789 = [STRes788|STResList788],
  ?line ITRes788 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_language.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S788),
  ITResList789 = [ITRes788|ITResList788],


  ?line {STRes789,S789} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList790 = [STRes789|STResList789],
  ?line ITRes789 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S789),
  ITResList790 = [ITRes789|ITResList789],


  ?line {STRes790,S790} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList791 = [STRes790|STResList790],
  ?line ITRes790 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S790),
  ITResList791 = [ITRes790|ITResList790],


  ?line {STRes791,S791} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList792 = [STRes791|STResList791],
  ?line ITRes791 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S791),
  ITResList792 = [ITRes791|ITResList791],


  ?line {STRes792,S792} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList793 = [STRes792|STResList792],
  ?line ITRes792 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S792),
  ITResList793 = [ITRes792|ITResList792],


  ?line {STRes793,S793} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_IDREFS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList794 = [STRes793|STResList793],
  ?line ITRes793 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_IDREFS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S793),
  ITResList794 = [ITRes793|ITResList793],


  ?line {STRes794,S794} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList795 = [STRes794|STResList794],
  ?line ITRes794 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S794),
  ITResList795 = [ITRes794|ITResList794],


  ?line {STRes795,S795} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList796 = [STRes795|STResList795],
  ?line ITRes795 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S795),
  ITResList796 = [ITRes795|ITResList795],


  ?line {STRes796,S796} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_boolean.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList797 = [STRes796|STResList796],
  ?line ITRes796 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_boolean.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S796),
  ITResList797 = [ITRes796|ITResList796],


  ?line {STRes797,S797} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList798 = [STRes797|STResList797],
  ?line ITRes797 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S797),
  ITResList798 = [ITRes797|ITResList797],


  ?line {STRes798,S798} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList799 = [STRes798|STResList798],
  ?line ITRes798 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S798),
  ITResList799 = [ITRes798|ITResList798],


  ?line {STRes799,S799} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList800 = [STRes799|STResList799],
  ?line ITRes799 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_NOTATION_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S799),
  ITResList800 = [ITRes799|ITResList799],


  ?line {STRes800,S800} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList801 = [STRes800|STResList800],
  ?line ITRes800 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S800),
  ITResList801 = [ITRes800|ITResList800],


  ?line {STRes801,S801} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList802 = [STRes801|STResList801],
  ?line ITRes801 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S801),
  ITResList802 = [ITRes801|ITResList801],


  ?line {STRes802,S802} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList803 = [STRes802|STResList802],
  ?line ITRes802 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S802),
  ITResList803 = [ITRes802|ITResList802],


  ?line {STRes803,S803} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_Name.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList804 = [STRes803|STResList803],
  ?line ITRes803 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_Name.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S803),
  ITResList804 = [ITRes803|ITResList803],


  ?line {STRes804,S804} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_NCName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList805 = [STRes804|STResList804],
  ?line ITRes804 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_NCName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S804),
  ITResList805 = [ITRes804|ITResList804],


  ?line {STRes805,S805} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_ID.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList806 = [STRes805|STResList805],
  ?line ITRes805 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_ID.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S805),
  ITResList806 = [ITRes805|ITResList805],


  ?line {STRes806,S806} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_IDREF.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList807 = [STRes806|STResList806],
  ?line ITRes806 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_IDREF.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S806),
  ITResList807 = [ITRes806|ITResList806],


  ?line {STRes807,S807} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_IDREFS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList808 = [STRes807|STResList807],
  ?line ITRes807 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_IDREFS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S807),
  ITResList808 = [ITRes807|ITResList807],


  ?line {STRes808,S808} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList809 = [STRes808|STResList808],
  ?line ITRes808 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S808),
  ITResList809 = [ITRes808|ITResList808],


  ?line {STRes809,S809} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList810 = [STRes809|STResList809],
  ?line ITRes809 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S809),
  ITResList810 = [ITRes809|ITResList809],


  ?line {STRes810,S810} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList811 = [STRes810|STResList810],
  ?line ITRes810 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S810),
  ITResList811 = [ITRes810|ITResList810],


  ?line {STRes811,S811} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_QName.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList812 = [STRes811|STResList811],
  ?line ITRes811 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_QName.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S811),
  ITResList812 = [ITRes811|ITResList811],


  ?line {STRes812,S812} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_NOTATION.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList813 = [STRes812|STResList812],
  ?line ITRes812 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_NOTATION.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S812),
  ITResList813 = [ITRes812|ITResList812],


  ?line {STRes813,S813} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList814 = [STRes813|STResList813],
  ?line ITRes813 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S813),
  ITResList814 = [ITRes813|ITResList813],


  ?line {STRes814,S814} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_dateTime.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList815 = [STRes814|STResList814],
  ?line ITRes814 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_dateTime.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S814),
  ITResList815 = [ITRes814|ITResList814],


  ?line {STRes815,S815} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_time.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList816 = [STRes815|STResList815],
  ?line ITRes815 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_time.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S815),
  ITResList816 = [ITRes815|ITResList815],


  ?line {STRes816,S816} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_date.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList817 = [STRes816|STResList816],
  ?line ITRes816 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_date.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S816),
  ITResList817 = [ITRes816|ITResList816],


  ?line {STRes817,S817} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gYearMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList818 = [STRes817|STResList817],
  ?line ITRes817 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gYearMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S817),
  ITResList818 = [ITRes817|ITResList817],


  ?line {STRes818,S818} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gYear.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList819 = [STRes818|STResList818],
  ?line ITRes818 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gYear.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S818),
  ITResList819 = [ITRes818|ITResList818],


  ?line {STRes819,S819} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gMonthDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList820 = [STRes819|STResList819],
  ?line ITRes819 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gMonthDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S819),
  ITResList820 = [ITRes819|ITResList819],


  ?line {STRes820,S820} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList821 = [STRes820|STResList820],
  ?line ITRes820 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gDay.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S820),
  ITResList821 = [ITRes820|ITResList820],


  ?line {STRes821,S821} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList822 = [STRes821|STResList821],
  ?line ITRes821 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_duration_gMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S821),
  ITResList822 = [ITRes821|ITResList821],


  ?line {STRes822,S822} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList823 = [STRes822|STResList822],
  ?line ITRes822 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S822),
  ITResList823 = [ITRes822|ITResList822],


  ?line {STRes823,S823} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList824 = [STRes823|STResList823],
  ?line ITRes823 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S823),
  ITResList824 = [ITRes823|ITResList823],


  ?line {STRes824,S824} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList825 = [STRes824|STResList824],
  ?line ITRes824 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S824),
  ITResList825 = [ITRes824|ITResList824],


  ?line {STRes825,S825} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList826 = [STRes825|STResList825],
  ?line ITRes825 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S825),
  ITResList826 = [ITRes825|ITResList825],


  ?line {STRes826,S826} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList827 = [STRes826|STResList826],
  ?line ITRes826 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S826),
  ITResList827 = [ITRes826|ITResList826],


  ?line {STRes827,S827} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList828 = [STRes827|STResList827],
  ?line ITRes827 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S827),
  ITResList828 = [ITRes827|ITResList827],


  ?line {STRes828,S828} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList829 = [STRes828|STResList828],
  ?line ITRes828 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S828),
  ITResList829 = [ITRes828|ITResList828],


  ?line {STRes829,S829} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_dateTime.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList830 = [STRes829|STResList829],
  ?line ITRes829 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_dateTime.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S829),
  ITResList830 = [ITRes829|ITResList829],


  ?line {STRes830,S830} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_date.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList831 = [STRes830|STResList830],
  ?line ITRes830 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_dateTime_date.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S830),
  ITResList831 = [ITRes830|ITResList830],


  ?line {STRes831,S831} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList832 = [STRes831|STResList831],
  ?line ITRes831 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S831),
  ITResList832 = [ITRes831|ITResList831],


  ?line {STRes832,S832} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList833 = [STRes832|STResList832],
  ?line ITRes832 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S832),
  ITResList833 = [ITRes832|ITResList832],


  ?line {STRes833,S833} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList834 = [STRes833|STResList833],
  ?line ITRes833 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S833),
  ITResList834 = [ITRes833|ITResList833],


  ?line {STRes834,S834} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList835 = [STRes834|STResList834],
  ?line ITRes834 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S834),
  ITResList835 = [ITRes834|ITResList834],


  ?line {STRes835,S835} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList836 = [STRes835|STResList835],
  ?line ITRes835 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S835),
  ITResList836 = [ITRes835|ITResList835],


  ?line {STRes836,S836} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList837 = [STRes836|STResList836],
  ?line ITRes836 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S836),
  ITResList837 = [ITRes836|ITResList836],


  ?line {STRes837,S837} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList838 = [STRes837|STResList837],
  ?line ITRes837 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S837),
  ITResList838 = [ITRes837|ITResList837],


  ?line {STRes838,S838} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_time.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList839 = [STRes838|STResList838],
  ?line ITRes838 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_time_time.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S838),
  ITResList839 = [ITRes838|ITResList838],


  ?line {STRes839,S839} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList840 = [STRes839|STResList839],
  ?line ITRes839 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S839),
  ITResList840 = [ITRes839|ITResList839],


  ?line {STRes840,S840} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList841 = [STRes840|STResList840],
  ?line ITRes840 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S840),
  ITResList841 = [ITRes840|ITResList840],


  ?line {STRes841,S841} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList842 = [STRes841|STResList841],
  ?line ITRes841 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S841),
  ITResList842 = [ITRes841|ITResList841],


  ?line {STRes842,S842} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList843 = [STRes842|STResList842],
  ?line ITRes842 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S842),
  ITResList843 = [ITRes842|ITResList842],


  ?line {STRes843,S843} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList844 = [STRes843|STResList843],
  ?line ITRes843 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S843),
  ITResList844 = [ITRes843|ITResList843],


  ?line {STRes844,S844} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList845 = [STRes844|STResList844],
  ?line ITRes844 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S844),
  ITResList845 = [ITRes844|ITResList844],


  ?line {STRes845,S845} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList846 = [STRes845|STResList845],
  ?line ITRes845 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S845),
  ITResList846 = [ITRes845|ITResList845],


  ?line {STRes846,S846} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_dateTime.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList847 = [STRes846|STResList846],
  ?line ITRes846 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_dateTime.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S846),
  ITResList847 = [ITRes846|ITResList846],


  ?line {STRes847,S847} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_date.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList848 = [STRes847|STResList847],
  ?line ITRes847 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_date_date.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S847),
  ITResList848 = [ITRes847|ITResList847],


  ?line {STRes848,S848} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList849 = [STRes848|STResList848],
  ?line ITRes848 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S848),
  ITResList849 = [ITRes848|ITResList848],


  ?line {STRes849,S849} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList850 = [STRes849|STResList849],
  ?line ITRes849 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S849),
  ITResList850 = [ITRes849|ITResList849],


  ?line {STRes850,S850} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList851 = [STRes850|STResList850],
  ?line ITRes850 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S850),
  ITResList851 = [ITRes850|ITResList850],


  ?line {STRes851,S851} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList852 = [STRes851|STResList851],
  ?line ITRes851 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S851),
  ITResList852 = [ITRes851|ITResList851],


  ?line {STRes852,S852} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList853 = [STRes852|STResList852],
  ?line ITRes852 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S852),
  ITResList853 = [ITRes852|ITResList852],


  ?line {STRes853,S853} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList854 = [STRes853|STResList853],
  ?line ITRes853 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S853),
  ITResList854 = [ITRes853|ITResList853],


  ?line {STRes854,S854} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList855 = [STRes854|STResList854],
  ?line ITRes854 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S854),
  ITResList855 = [ITRes854|ITResList854],


  ?line {STRes855,S855} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_gYearMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList856 = [STRes855|STResList855],
  ?line ITRes855 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYearMonth_gYearMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S855),
  ITResList856 = [ITRes855|ITResList855],


  ?line {STRes856,S856} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList857 = [STRes856|STResList856],
  ?line ITRes856 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S856),
  ITResList857 = [ITRes856|ITResList856],


  ?line {STRes857,S857} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList858 = [STRes857|STResList857],
  ?line ITRes857 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S857),
  ITResList858 = [ITRes857|ITResList857],


  ?line {STRes858,S858} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList859 = [STRes858|STResList858],
  ?line ITRes858 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S858),
  ITResList859 = [ITRes858|ITResList858],


  ?line {STRes859,S859} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList860 = [STRes859|STResList859],
  ?line ITRes859 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S859),
  ITResList860 = [ITRes859|ITResList859],


  ?line {STRes860,S860} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList861 = [STRes860|STResList860],
  ?line ITRes860 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S860),
  ITResList861 = [ITRes860|ITResList860],


  ?line {STRes861,S861} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList862 = [STRes861|STResList861],
  ?line ITRes861 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S861),
  ITResList862 = [ITRes861|ITResList861],


  ?line {STRes862,S862} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList863 = [STRes862|STResList862],
  ?line ITRes862 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S862),
  ITResList863 = [ITRes862|ITResList862],


  ?line {STRes863,S863} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_gYear.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList864 = [STRes863|STResList863],
  ?line ITRes863 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gYear_gYear.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S863),
  ITResList864 = [ITRes863|ITResList863],


  ?line {STRes864,S864} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList865 = [STRes864|STResList864],
  ?line ITRes864 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S864),
  ITResList865 = [ITRes864|ITResList864],


  ?line {STRes865,S865} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList866 = [STRes865|STResList865],
  ?line ITRes865 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S865),
  ITResList866 = [ITRes865|ITResList865],


  ?line {STRes866,S866} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList867 = [STRes866|STResList866],
  ?line ITRes866 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S866),
  ITResList867 = [ITRes866|ITResList866],


  ?line {STRes867,S867} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList868 = [STRes867|STResList867],
  ?line ITRes867 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S867),
  ITResList868 = [ITRes867|ITResList867],


  ?line {STRes868,S868} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList869 = [STRes868|STResList868],
  ?line ITRes868 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S868),
  ITResList869 = [ITRes868|ITResList868],


  ?line {STRes869,S869} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList870 = [STRes869|STResList869],
  ?line ITRes869 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S869),
  ITResList870 = [ITRes869|ITResList869],


  ?line {STRes870,S870} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList871 = [STRes870|STResList870],
  ?line ITRes870 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S870),
  ITResList871 = [ITRes870|ITResList870],


  ?line {STRes871,S871} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_gMonthDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList872 = [STRes871|STResList871],
  ?line ITRes871 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonthDay_gMonthDay.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S871),
  ITResList872 = [ITRes871|ITResList871],


  ?line {STRes872,S872} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList873 = [STRes872|STResList872],
  ?line ITRes872 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S872),
  ITResList873 = [ITRes872|ITResList872],


  ?line {STRes873,S873} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList874 = [STRes873|STResList873],
  ?line ITRes873 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S873),
  ITResList874 = [ITRes873|ITResList873],


  ?line {STRes874,S874} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList875 = [STRes874|STResList874],
  ?line ITRes874 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S874),
  ITResList875 = [ITRes874|ITResList874],


  ?line {STRes875,S875} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList876 = [STRes875|STResList875],
  ?line ITRes875 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S875),
  ITResList876 = [ITRes875|ITResList875],


  ?line {STRes876,S876} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList877 = [STRes876|STResList876],
  ?line ITRes876 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S876),
  ITResList877 = [ITRes876|ITResList876],


  ?line {STRes877,S877} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList878 = [STRes877|STResList877],
  ?line ITRes877 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S877),
  ITResList878 = [ITRes877|ITResList877],


  ?line {STRes878,S878} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList879 = [STRes878|STResList878],
  ?line ITRes878 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S878),
  ITResList879 = [ITRes878|ITResList878],


  ?line {STRes879,S879} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_gDay.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList880 = [STRes879|STResList879],
  ?line ITRes879 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gDay_gDay.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S879),
  ITResList880 = [ITRes879|ITResList879],


  ?line {STRes880,S880} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_string.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList881 = [STRes880|STResList880],
  ?line ITRes880 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_string.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S880),
  ITResList881 = [ITRes880|ITResList880],


  ?line {STRes881,S881} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_normalizedString.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList882 = [STRes881|STResList881],
  ?line ITRes881 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_normalizedString.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S881),
  ITResList882 = [ITRes881|ITResList881],


  ?line {STRes882,S882} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_token.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList883 = [STRes882|STResList882],
  ?line ITRes882 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_token.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S882),
  ITResList883 = [ITRes882|ITResList882],


  ?line {STRes883,S883} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_NMTOKEN.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList884 = [STRes883|STResList883],
  ?line ITRes883 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_NMTOKEN.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S883),
  ITResList884 = [ITRes883|ITResList883],


  ?line {STRes884,S884} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_NMTOKENS.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList885 = [STRes884|STResList884],
  ?line ITRes884 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_NMTOKENS.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S884),
  ITResList885 = [ITRes884|ITResList884],


  ?line {STRes885,S885} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_anyURI.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList886 = [STRes885|STResList885],
  ?line ITRes885 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_anyURI.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S885),
  ITResList886 = [ITRes885|ITResList885],


  ?line {STRes886,S886} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_duration.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList887 = [STRes886|STResList886],
  ?line ITRes886 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_duration.xml','./msxsdtest/identityConstraint/idc_datatypes',invalid,S886),
  ITResList887 = [ITRes886|ITResList886],


  ?line {STRes887,S887} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_gMonth.xsd','./msxsdtest/identityConstraint/idc_datatypes',valid),
  STResList888 = [STRes887|STResList887],
  ?line ITRes887 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idc_datatypes/idc_gMonth_gMonth.xml','./msxsdtest/identityConstraint/idc_datatypes',valid,S887),
  ITResList888 = [ITRes887|ITResList887],


  xmerl_xsd_lib:compare_test_results(Config,STResList888,ITResList888).

%% Identity-constraint Definition Schema Component.
%% Identity-constraint Validation Rules.
%% Selector identity-constraint xpath bnf.
%% Field identity-constraint xpath bnf.
%% XPath validation.
%% Bug Regressions

id(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA001.xsd','./msxsdtest/identityConstraint',valid),
  STResList1 = [STRes0|STResList0],


  ?line {STRes1,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA002.xsd','./msxsdtest/identityConstraint',invalid),
  STResList2 = [STRes1|STResList1],


  ?line {STRes2,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA003.xsd','./msxsdtest/identityConstraint',invalid),
  STResList3 = [STRes2|STResList2],


  ?line {STRes3,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA004.xsd','./msxsdtest/identityConstraint',invalid),
  STResList4 = [STRes3|STResList3],


  ?line {STRes4,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA005.xsd','./msxsdtest/identityConstraint',invalid),
  STResList5 = [STRes4|STResList4],


  ?line {STRes5,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA006.xsd','./msxsdtest/identityConstraint',invalid),
  STResList6 = [STRes5|STResList5],


  ?line {STRes6,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA007.xsd','./msxsdtest/identityConstraint',invalid),
  STResList7 = [STRes6|STResList6],


  ?line {STRes7,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA008.xsd','./msxsdtest/identityConstraint',valid),
  STResList8 = [STRes7|STResList7],


  ?line {STRes8,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA009.xsd','./msxsdtest/identityConstraint',valid),
  STResList9 = [STRes8|STResList8],


  ?line {STRes9,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA010.xsd','./msxsdtest/identityConstraint',valid),
  STResList10 = [STRes9|STResList9],


  ?line {STRes10,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA011.xsd','./msxsdtest/identityConstraint',valid),
  STResList11 = [STRes10|STResList10],


  ?line {STRes11,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA012.xsd','./msxsdtest/identityConstraint',valid),
  STResList12 = [STRes11|STResList11],


  ?line {STRes12,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA013.xsd','./msxsdtest/identityConstraint',valid),
  STResList13 = [STRes12|STResList12],


  ?line {STRes13,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA014.xsd','./msxsdtest/identityConstraint',valid),
  STResList14 = [STRes13|STResList13],


  ?line {STRes14,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA015.xsd','./msxsdtest/identityConstraint',valid),
  STResList15 = [STRes14|STResList14],


  ?line {STRes15,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA016.xsd','./msxsdtest/identityConstraint',invalid),
  STResList16 = [STRes15|STResList15],


  ?line {STRes16,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA017.xsd','./msxsdtest/identityConstraint',valid),
  STResList17 = [STRes16|STResList16],


  ?line {STRes17,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA018.xsd','./msxsdtest/identityConstraint',invalid),
  STResList18 = [STRes17|STResList17],


  ?line {STRes18,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA019.xsd','./msxsdtest/identityConstraint',invalid),
  STResList19 = [STRes18|STResList18],


  ?line {STRes19,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA020.xsd','./msxsdtest/identityConstraint',invalid),
  STResList20 = [STRes19|STResList19],


  ?line {STRes20,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA021.xsd','./msxsdtest/identityConstraint',invalid),
  STResList21 = [STRes20|STResList20],


  ?line {STRes21,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA022.xsd','./msxsdtest/identityConstraint',valid),
  STResList22 = [STRes21|STResList21],


  ?line {STRes22,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA023.xsd','./msxsdtest/identityConstraint',invalid),
  STResList23 = [STRes22|STResList22],


  ?line {STRes23,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA024.xsd','./msxsdtest/identityConstraint',invalid),
  STResList24 = [STRes23|STResList23],


  ?line {STRes24,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA025.xsd','./msxsdtest/identityConstraint',invalid),
  STResList25 = [STRes24|STResList24],


  ?line {STRes25,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA026.xsd','./msxsdtest/identityConstraint',invalid),
  STResList26 = [STRes25|STResList25],


  ?line {STRes26,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA027.xsd','./msxsdtest/identityConstraint',invalid),
  STResList27 = [STRes26|STResList26],


  ?line {STRes27,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA028.xsd','./msxsdtest/identityConstraint',invalid),
  STResList28 = [STRes27|STResList27],


  ?line {STRes28,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA029.xsd','./msxsdtest/identityConstraint',invalid),
  STResList29 = [STRes28|STResList28],


  ?line {STRes29,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA030.xsd','./msxsdtest/identityConstraint',invalid),
  STResList30 = [STRes29|STResList29],


  ?line {STRes30,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA031.xsd','./msxsdtest/identityConstraint',invalid),
  STResList31 = [STRes30|STResList30],


  ?line {STRes31,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA032.xsd','./msxsdtest/identityConstraint',invalid),
  STResList32 = [STRes31|STResList31],


  ?line {STRes32,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA033.xsd','./msxsdtest/identityConstraint',valid),
  STResList33 = [STRes32|STResList32],


  ?line {STRes33,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA034.xsd','./msxsdtest/identityConstraint',valid),
  STResList34 = [STRes33|STResList33],


  ?line {STRes34,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA035.xsd','./msxsdtest/identityConstraint',invalid),
  STResList35 = [STRes34|STResList34],


  ?line {STRes35,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA036.xsd','./msxsdtest/identityConstraint',valid),
  STResList36 = [STRes35|STResList35],


  ?line {STRes36,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA037.xsd','./msxsdtest/identityConstraint',invalid),
  STResList37 = [STRes36|STResList36],


  ?line {STRes37,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA038.xsd','./msxsdtest/identityConstraint',invalid),
  STResList38 = [STRes37|STResList37],


  ?line {STRes38,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA039.xsd','./msxsdtest/identityConstraint',invalid),
  STResList39 = [STRes38|STResList38],


  ?line {STRes39,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA040.xsd','./msxsdtest/identityConstraint',valid),
  STResList40 = [STRes39|STResList39],


  ?line {STRes40,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA041.xsd','./msxsdtest/identityConstraint',valid),
  STResList41 = [STRes40|STResList40],


  ?line {STRes41,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA042.xsd','./msxsdtest/identityConstraint',invalid),
  STResList42 = [STRes41|STResList41],


  ?line {STRes42,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA043.xsd','./msxsdtest/identityConstraint',invalid),
  STResList43 = [STRes42|STResList42],


  ?line {STRes43,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA044.xsd','./msxsdtest/identityConstraint',invalid),
  STResList44 = [STRes43|STResList43],


  ?line {STRes44,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA045.xsd','./msxsdtest/identityConstraint',valid),
  STResList45 = [STRes44|STResList44],


  ?line {STRes45,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA046.xsd','./msxsdtest/identityConstraint',invalid),
  STResList46 = [STRes45|STResList45],


  ?line {STRes46,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA047.xsd','./msxsdtest/identityConstraint',invalid),
  STResList47 = [STRes46|STResList46],


  ?line {STRes47,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA048.xsd','./msxsdtest/identityConstraint',invalid),
  STResList48 = [STRes47|STResList47],


  ?line {STRes48,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA049.xsd','./msxsdtest/identityConstraint',invalid),
  STResList49 = [STRes48|STResList48],


  ?line {STRes49,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA050.xsd','./msxsdtest/identityConstraint',invalid),
  STResList50 = [STRes49|STResList49],


  ?line {STRes50,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA051.xsd','./msxsdtest/identityConstraint',invalid),
  STResList51 = [STRes50|STResList50],


  ?line {STRes51,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA052.xsd','./msxsdtest/identityConstraint',invalid),
  STResList52 = [STRes51|STResList51],


  ?line {STRes52,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA053.xsd','./msxsdtest/identityConstraint',invalid),
  STResList53 = [STRes52|STResList52],


  ?line {STRes53,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA054.xsd','./msxsdtest/identityConstraint',invalid),
  STResList54 = [STRes53|STResList53],


  ?line {STRes54,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA055.xsd','./msxsdtest/identityConstraint',invalid),
  STResList55 = [STRes54|STResList54],


  ?line {STRes55,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA056.xsd','./msxsdtest/identityConstraint',invalid),
  STResList56 = [STRes55|STResList55],


  ?line {STRes56,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA057.xsd','./msxsdtest/identityConstraint',invalid),
  STResList57 = [STRes56|STResList56],


  ?line {STRes57,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA058.xsd','./msxsdtest/identityConstraint',invalid),
  STResList58 = [STRes57|STResList57],


  ?line {STRes58,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA059.xsd','./msxsdtest/identityConstraint',invalid),
  STResList59 = [STRes58|STResList58],


  ?line {STRes59,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idA060.xsd','./msxsdtest/identityConstraint',invalid),
  STResList60 = [STRes59|STResList59],


  ?line {STRes60,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB001.xsd','./msxsdtest/identityConstraint',valid),
  STResList61 = [STRes60|STResList60],


  ?line {STRes61,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB002.xsd','./msxsdtest/identityConstraint',invalid),
  STResList62 = [STRes61|STResList61],


  ?line {STRes62,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB003.xsd','./msxsdtest/identityConstraint',invalid),
  STResList63 = [STRes62|STResList62],


  ?line {STRes63,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB004.xsd','./msxsdtest/identityConstraint',invalid),
  STResList64 = [STRes63|STResList63],


  ?line {STRes64,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB005.xsd','./msxsdtest/identityConstraint',invalid),
  STResList65 = [STRes64|STResList64],


  ?line {STRes65,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB006.xsd','./msxsdtest/identityConstraint',invalid),
  STResList66 = [STRes65|STResList65],


  ?line {STRes66,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB007.xsd','./msxsdtest/identityConstraint',invalid),
  STResList67 = [STRes66|STResList66],


  ?line {STRes67,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB008.xsd','./msxsdtest/identityConstraint',valid),
  STResList68 = [STRes67|STResList67],


  ?line {STRes68,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB009.xsd','./msxsdtest/identityConstraint',valid),
  STResList69 = [STRes68|STResList68],


  ?line {STRes69,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB010.xsd','./msxsdtest/identityConstraint',valid),
  STResList70 = [STRes69|STResList69],


  ?line {STRes70,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB011.xsd','./msxsdtest/identityConstraint',valid),
  STResList71 = [STRes70|STResList70],


  ?line {STRes71,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB012.xsd','./msxsdtest/identityConstraint',valid),
  STResList72 = [STRes71|STResList71],


  ?line {STRes72,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB013.xsd','./msxsdtest/identityConstraint',valid),
  STResList73 = [STRes72|STResList72],


  ?line {STRes73,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB014.xsd','./msxsdtest/identityConstraint',valid),
  STResList74 = [STRes73|STResList73],


  ?line {STRes74,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB015.xsd','./msxsdtest/identityConstraint',valid),
  STResList75 = [STRes74|STResList74],


  ?line {STRes75,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB016.xsd','./msxsdtest/identityConstraint',invalid),
  STResList76 = [STRes75|STResList75],


  ?line {STRes76,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB017.xsd','./msxsdtest/identityConstraint',invalid),
  STResList77 = [STRes76|STResList76],


  ?line {STRes77,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB018.xsd','./msxsdtest/identityConstraint',valid),
  STResList78 = [STRes77|STResList77],


  ?line {STRes78,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB019.xsd','./msxsdtest/identityConstraint',invalid),
  STResList79 = [STRes78|STResList78],


  ?line {STRes79,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB020.xsd','./msxsdtest/identityConstraint',invalid),
  STResList80 = [STRes79|STResList79],


  ?line {STRes80,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB021.xsd','./msxsdtest/identityConstraint',invalid),
  STResList81 = [STRes80|STResList80],


  ?line {STRes81,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB022.xsd','./msxsdtest/identityConstraint',valid),
  STResList82 = [STRes81|STResList81],


  ?line {STRes82,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB023.xsd','./msxsdtest/identityConstraint',invalid),
  STResList83 = [STRes82|STResList82],


  ?line {STRes83,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB024.xsd','./msxsdtest/identityConstraint',invalid),
  STResList84 = [STRes83|STResList83],


  ?line {STRes84,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB025.xsd','./msxsdtest/identityConstraint',invalid),
  STResList85 = [STRes84|STResList84],


  ?line {STRes85,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB026.xsd','./msxsdtest/identityConstraint',invalid),
  STResList86 = [STRes85|STResList85],


  ?line {STRes86,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB027.xsd','./msxsdtest/identityConstraint',invalid),
  STResList87 = [STRes86|STResList86],


  ?line {STRes87,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB028.xsd','./msxsdtest/identityConstraint',invalid),
  STResList88 = [STRes87|STResList87],


  ?line {STRes88,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB029.xsd','./msxsdtest/identityConstraint',invalid),
  STResList89 = [STRes88|STResList88],


  ?line {STRes89,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB030.xsd','./msxsdtest/identityConstraint',invalid),
  STResList90 = [STRes89|STResList89],


  ?line {STRes90,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB031.xsd','./msxsdtest/identityConstraint',invalid),
  STResList91 = [STRes90|STResList90],


  ?line {STRes91,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB032.xsd','./msxsdtest/identityConstraint',invalid),
  STResList92 = [STRes91|STResList91],


  ?line {STRes92,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB033.xsd','./msxsdtest/identityConstraint',valid),
  STResList93 = [STRes92|STResList92],


  ?line {STRes93,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB034.xsd','./msxsdtest/identityConstraint',valid),
  STResList94 = [STRes93|STResList93],


  ?line {STRes94,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB035.xsd','./msxsdtest/identityConstraint',invalid),
  STResList95 = [STRes94|STResList94],


  ?line {STRes95,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB036.xsd','./msxsdtest/identityConstraint',valid),
  STResList96 = [STRes95|STResList95],


  ?line {STRes96,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB037.xsd','./msxsdtest/identityConstraint',invalid),
  STResList97 = [STRes96|STResList96],


  ?line {STRes97,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB038.xsd','./msxsdtest/identityConstraint',invalid),
  STResList98 = [STRes97|STResList97],


  ?line {STRes98,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB039.xsd','./msxsdtest/identityConstraint',invalid),
  STResList99 = [STRes98|STResList98],


  ?line {STRes99,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB040.xsd','./msxsdtest/identityConstraint',valid),
  STResList100 = [STRes99|STResList99],


  ?line {STRes100,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB041.xsd','./msxsdtest/identityConstraint',valid),
  STResList101 = [STRes100|STResList100],


  ?line {STRes101,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB042.xsd','./msxsdtest/identityConstraint',invalid),
  STResList102 = [STRes101|STResList101],


  ?line {STRes102,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB043.xsd','./msxsdtest/identityConstraint',invalid),
  STResList103 = [STRes102|STResList102],


  ?line {STRes103,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB044.xsd','./msxsdtest/identityConstraint',invalid),
  STResList104 = [STRes103|STResList103],


  ?line {STRes104,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB045.xsd','./msxsdtest/identityConstraint',valid),
  STResList105 = [STRes104|STResList104],


  ?line {STRes105,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB046.xsd','./msxsdtest/identityConstraint',invalid),
  STResList106 = [STRes105|STResList105],


  ?line {STRes106,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB047.xsd','./msxsdtest/identityConstraint',invalid),
  STResList107 = [STRes106|STResList106],


  ?line {STRes107,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB048.xsd','./msxsdtest/identityConstraint',invalid),
  STResList108 = [STRes107|STResList107],


  ?line {STRes108,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB049.xsd','./msxsdtest/identityConstraint',invalid),
  STResList109 = [STRes108|STResList108],


  ?line {STRes109,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB050.xsd','./msxsdtest/identityConstraint',invalid),
  STResList110 = [STRes109|STResList109],


  ?line {STRes110,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB051.xsd','./msxsdtest/identityConstraint',invalid),
  STResList111 = [STRes110|STResList110],


  ?line {STRes111,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB052.xsd','./msxsdtest/identityConstraint',invalid),
  STResList112 = [STRes111|STResList111],


  ?line {STRes112,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB053.xsd','./msxsdtest/identityConstraint',invalid),
  STResList113 = [STRes112|STResList112],


  ?line {STRes113,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB054.xsd','./msxsdtest/identityConstraint',invalid),
  STResList114 = [STRes113|STResList113],


  ?line {STRes114,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB055.xsd','./msxsdtest/identityConstraint',invalid),
  STResList115 = [STRes114|STResList114],


  ?line {STRes115,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB056.xsd','./msxsdtest/identityConstraint',invalid),
  STResList116 = [STRes115|STResList115],


  ?line {STRes116,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB057.xsd','./msxsdtest/identityConstraint',invalid),
  STResList117 = [STRes116|STResList116],


  ?line {STRes117,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB058.xsd','./msxsdtest/identityConstraint',invalid),
  STResList118 = [STRes117|STResList117],


  ?line {STRes118,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB059.xsd','./msxsdtest/identityConstraint',invalid),
  STResList119 = [STRes118|STResList118],


  ?line {STRes119,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idB060.xsd','./msxsdtest/identityConstraint',invalid),
  STResList120 = [STRes119|STResList119],


  ?line {STRes120,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC001.xsd','./msxsdtest/identityConstraint',valid),
  STResList121 = [STRes120|STResList120],


  ?line {STRes121,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC002.xsd','./msxsdtest/identityConstraint',invalid),
  STResList122 = [STRes121|STResList121],


  ?line {STRes122,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC003.xsd','./msxsdtest/identityConstraint',invalid),
  STResList123 = [STRes122|STResList122],


  ?line {STRes123,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC004.xsd','./msxsdtest/identityConstraint',invalid),
  STResList124 = [STRes123|STResList123],


  ?line {STRes124,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC005.xsd','./msxsdtest/identityConstraint',invalid),
  STResList125 = [STRes124|STResList124],


  ?line {STRes125,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC006.xsd','./msxsdtest/identityConstraint',invalid),
  STResList126 = [STRes125|STResList125],


  ?line {STRes126,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC007.xsd','./msxsdtest/identityConstraint',invalid),
  STResList127 = [STRes126|STResList126],


  ?line {STRes127,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC008.xsd','./msxsdtest/identityConstraint',valid),
  STResList128 = [STRes127|STResList127],


  ?line {STRes128,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC009.xsd','./msxsdtest/identityConstraint',valid),
  STResList129 = [STRes128|STResList128],


  ?line {STRes129,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC010.xsd','./msxsdtest/identityConstraint',valid),
  STResList130 = [STRes129|STResList129],


  ?line {STRes130,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC011.xsd','./msxsdtest/identityConstraint',valid),
  STResList131 = [STRes130|STResList130],


  ?line {STRes131,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC012.xsd','./msxsdtest/identityConstraint',valid),
  STResList132 = [STRes131|STResList131],


  ?line {STRes132,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC013.xsd','./msxsdtest/identityConstraint',valid),
  STResList133 = [STRes132|STResList132],


  ?line {STRes133,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC014.xsd','./msxsdtest/identityConstraint',valid),
  STResList134 = [STRes133|STResList133],


  ?line {STRes134,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC015.xsd','./msxsdtest/identityConstraint',valid),
  STResList135 = [STRes134|STResList134],


  ?line {STRes135,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC016.xsd','./msxsdtest/identityConstraint',invalid),
  STResList136 = [STRes135|STResList135],


  ?line {STRes136,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC017.xsd','./msxsdtest/identityConstraint',invalid),
  STResList137 = [STRes136|STResList136],


  ?line {STRes137,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC018.xsd','./msxsdtest/identityConstraint',invalid),
  STResList138 = [STRes137|STResList137],


  ?line {STRes138,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC019.xsd','./msxsdtest/identityConstraint',valid),
  STResList139 = [STRes138|STResList138],


  ?line {STRes139,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC020.xsd','./msxsdtest/identityConstraint',invalid),
  STResList140 = [STRes139|STResList139],


  ?line {STRes140,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC021.xsd','./msxsdtest/identityConstraint',invalid),
  STResList141 = [STRes140|STResList140],


  ?line {STRes141,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC022.xsd','./msxsdtest/identityConstraint',valid),
  STResList142 = [STRes141|STResList141],


  ?line {STRes142,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC023.xsd','./msxsdtest/identityConstraint',invalid),
  STResList143 = [STRes142|STResList142],


  ?line {STRes143,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC024.xsd','./msxsdtest/identityConstraint',invalid),
  STResList144 = [STRes143|STResList143],


  ?line {STRes144,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC025.xsd','./msxsdtest/identityConstraint',invalid),
  STResList145 = [STRes144|STResList144],


  ?line {STRes145,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC026.xsd','./msxsdtest/identityConstraint',invalid),
  STResList146 = [STRes145|STResList145],


  ?line {STRes146,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC027.xsd','./msxsdtest/identityConstraint',invalid),
  STResList147 = [STRes146|STResList146],


  ?line {STRes147,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC028.xsd','./msxsdtest/identityConstraint',invalid),
  STResList148 = [STRes147|STResList147],


  ?line {STRes148,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC029.xsd','./msxsdtest/identityConstraint',invalid),
  STResList149 = [STRes148|STResList148],


  ?line {STRes149,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC030.xsd','./msxsdtest/identityConstraint',invalid),
  STResList150 = [STRes149|STResList149],


  ?line {STRes150,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC031.xsd','./msxsdtest/identityConstraint',invalid),
  STResList151 = [STRes150|STResList150],


  ?line {STRes151,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC032.xsd','./msxsdtest/identityConstraint',invalid),
  STResList152 = [STRes151|STResList151],


  ?line {STRes152,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC033.xsd','./msxsdtest/identityConstraint',valid),
  STResList153 = [STRes152|STResList152],


  ?line {STRes153,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC034.xsd','./msxsdtest/identityConstraint',valid),
  STResList154 = [STRes153|STResList153],


  ?line {STRes154,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC035.xsd','./msxsdtest/identityConstraint',valid),
  STResList155 = [STRes154|STResList154],


  ?line {STRes155,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC036.xsd','./msxsdtest/identityConstraint',valid),
  STResList156 = [STRes155|STResList155],


  ?line {STRes156,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC038.xsd','./msxsdtest/identityConstraint',invalid),
  STResList157 = [STRes156|STResList156],


  ?line {STRes157,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC039.xsd','./msxsdtest/identityConstraint',valid),
  STResList158 = [STRes157|STResList157],


  ?line {STRes158,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC040.xsd','./msxsdtest/identityConstraint',invalid),
  STResList159 = [STRes158|STResList158],


  ?line {STRes159,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC041.xsd','./msxsdtest/identityConstraint',invalid),
  STResList160 = [STRes159|STResList159],


  ?line {STRes160,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC042.xsd','./msxsdtest/identityConstraint',invalid),
  STResList161 = [STRes160|STResList160],


  ?line {STRes161,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC043.xsd','./msxsdtest/identityConstraint',valid),
  STResList162 = [STRes161|STResList161],


  ?line {STRes162,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC044.xsd','./msxsdtest/identityConstraint',valid),
  STResList163 = [STRes162|STResList162],


  ?line {STRes163,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC045.xsd','./msxsdtest/identityConstraint',invalid),
  STResList164 = [STRes163|STResList163],


  ?line {STRes164,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC046.xsd','./msxsdtest/identityConstraint',invalid),
  STResList165 = [STRes164|STResList164],


  ?line {STRes165,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC047.xsd','./msxsdtest/identityConstraint',invalid),
  STResList166 = [STRes165|STResList165],


  ?line {STRes166,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC048.xsd','./msxsdtest/identityConstraint',valid),
  STResList167 = [STRes166|STResList166],


  ?line {STRes167,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC049.xsd','./msxsdtest/identityConstraint',invalid),
  STResList168 = [STRes167|STResList167],


  ?line {STRes168,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC050.xsd','./msxsdtest/identityConstraint',invalid),
  STResList169 = [STRes168|STResList168],


  ?line {STRes169,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC051.xsd','./msxsdtest/identityConstraint',invalid),
  STResList170 = [STRes169|STResList169],


  ?line {STRes170,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC052.xsd','./msxsdtest/identityConstraint',invalid),
  STResList171 = [STRes170|STResList170],


  ?line {STRes171,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC053.xsd','./msxsdtest/identityConstraint',invalid),
  STResList172 = [STRes171|STResList171],


  ?line {STRes172,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC054.xsd','./msxsdtest/identityConstraint',invalid),
  STResList173 = [STRes172|STResList172],


  ?line {STRes173,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC055.xsd','./msxsdtest/identityConstraint',invalid),
  STResList174 = [STRes173|STResList173],


  ?line {STRes174,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC056.xsd','./msxsdtest/identityConstraint',invalid),
  STResList175 = [STRes174|STResList174],


  ?line {STRes175,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC057.xsd','./msxsdtest/identityConstraint',invalid),
  STResList176 = [STRes175|STResList175],


  ?line {STRes176,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC058.xsd','./msxsdtest/identityConstraint',invalid),
  STResList177 = [STRes176|STResList176],


  ?line {STRes177,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC059.xsd','./msxsdtest/identityConstraint',invalid),
  STResList178 = [STRes177|STResList177],


  ?line {STRes178,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC060.xsd','./msxsdtest/identityConstraint',invalid),
  STResList179 = [STRes178|STResList178],


  ?line {STRes179,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC061.xsd','./msxsdtest/identityConstraint',invalid),
  STResList180 = [STRes179|STResList179],


  ?line {STRes180,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC062.xsd','./msxsdtest/identityConstraint',invalid),
  STResList181 = [STRes180|STResList180],


  ?line {STRes181,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idC063.xsd','./msxsdtest/identityConstraint',invalid),
  STResList182 = [STRes181|STResList181],


  ?line {STRes182,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD001.xsd','./msxsdtest/identityConstraint',valid),
  STResList183 = [STRes182|STResList182],


  ?line {STRes183,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD002.xsd','./msxsdtest/identityConstraint',invalid),
  STResList184 = [STRes183|STResList183],


  ?line {STRes184,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD003.xsd','./msxsdtest/identityConstraint',invalid),
  STResList185 = [STRes184|STResList184],


  ?line {STRes185,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD004.xsd','./msxsdtest/identityConstraint',invalid),
  STResList186 = [STRes185|STResList185],


  ?line {STRes186,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD005.xsd','./msxsdtest/identityConstraint',invalid),
  STResList187 = [STRes186|STResList186],


  ?line {STRes187,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD006.xsd','./msxsdtest/identityConstraint',invalid),
  STResList188 = [STRes187|STResList187],


  ?line {STRes188,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD007.xsd','./msxsdtest/identityConstraint',invalid),
  STResList189 = [STRes188|STResList188],


  ?line {STRes189,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD008.xsd','./msxsdtest/identityConstraint',valid),
  STResList190 = [STRes189|STResList189],


  ?line {STRes190,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD009.xsd','./msxsdtest/identityConstraint',valid),
  STResList191 = [STRes190|STResList190],


  ?line {STRes191,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD010.xsd','./msxsdtest/identityConstraint',valid),
  STResList192 = [STRes191|STResList191],


  ?line {STRes192,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD011.xsd','./msxsdtest/identityConstraint',invalid),
  STResList193 = [STRes192|STResList192],


  ?line {STRes193,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD012.xsd','./msxsdtest/identityConstraint',invalid),
  STResList194 = [STRes193|STResList193],


  ?line {STRes194,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD013.xsd','./msxsdtest/identityConstraint',valid),
  STResList195 = [STRes194|STResList194],


  ?line {STRes195,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD014.xsd','./msxsdtest/identityConstraint',invalid),
  STResList196 = [STRes195|STResList195],


  ?line {STRes196,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD015.xsd','./msxsdtest/identityConstraint',valid),
  STResList197 = [STRes196|STResList196],


  ?line {STRes197,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD016.xsd','./msxsdtest/identityConstraint',valid),
  STResList198 = [STRes197|STResList197],


  ?line {STRes198,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD017.xsd','./msxsdtest/identityConstraint',invalid),
  STResList199 = [STRes198|STResList198],


  ?line {STRes199,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD018.xsd','./msxsdtest/identityConstraint',invalid),
  STResList200 = [STRes199|STResList199],


  ?line {STRes200,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD019.xsd','./msxsdtest/identityConstraint',invalid),
  STResList201 = [STRes200|STResList200],


  ?line {STRes201,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD020.xsd','./msxsdtest/identityConstraint',invalid),
  STResList202 = [STRes201|STResList201],


  ?line {STRes202,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD021.xsd','./msxsdtest/identityConstraint',invalid),
  STResList203 = [STRes202|STResList202],


  ?line {STRes203,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD022.xsd','./msxsdtest/identityConstraint',invalid),
  STResList204 = [STRes203|STResList203],


  ?line {STRes204,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD023.xsd','./msxsdtest/identityConstraint',invalid),
  STResList205 = [STRes204|STResList204],


  ?line {STRes205,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD024.xsd','./msxsdtest/identityConstraint',invalid),
  STResList206 = [STRes205|STResList205],


  ?line {STRes206,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD025.xsd','./msxsdtest/identityConstraint',invalid),
  STResList207 = [STRes206|STResList206],


  ?line {STRes207,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD026.xsd','./msxsdtest/identityConstraint',invalid),
  STResList208 = [STRes207|STResList207],


  ?line {STRes208,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD027.xsd','./msxsdtest/identityConstraint',invalid),
  STResList209 = [STRes208|STResList208],


  ?line {STRes209,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD028.xsd','./msxsdtest/identityConstraint',invalid),
  STResList210 = [STRes209|STResList209],


  ?line {STRes210,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD029.xsd','./msxsdtest/identityConstraint',invalid),
  STResList211 = [STRes210|STResList210],


  ?line {STRes211,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD030.xsd','./msxsdtest/identityConstraint',invalid),
  STResList212 = [STRes211|STResList211],


  ?line {STRes212,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD031.xsd','./msxsdtest/identityConstraint',invalid),
  STResList213 = [STRes212|STResList212],


  ?line {STRes213,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD032.xsd','./msxsdtest/identityConstraint',invalid),
  STResList214 = [STRes213|STResList213],


  ?line {STRes214,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idD033.xsd','./msxsdtest/identityConstraint',invalid),
  STResList215 = [STRes214|STResList214],


  ?line {STRes215,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE001.xsd','./msxsdtest/identityConstraint',valid),
  STResList216 = [STRes215|STResList215],


  ?line {STRes216,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE002.xsd','./msxsdtest/identityConstraint',invalid),
  STResList217 = [STRes216|STResList216],


  ?line {STRes217,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE003.xsd','./msxsdtest/identityConstraint',invalid),
  STResList218 = [STRes217|STResList217],


  ?line {STRes218,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE004.xsd','./msxsdtest/identityConstraint',invalid),
  STResList219 = [STRes218|STResList218],


  ?line {STRes219,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE005.xsd','./msxsdtest/identityConstraint',invalid),
  STResList220 = [STRes219|STResList219],


  ?line {STRes220,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE006.xsd','./msxsdtest/identityConstraint',invalid),
  STResList221 = [STRes220|STResList220],


  ?line {STRes221,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE007.xsd','./msxsdtest/identityConstraint',invalid),
  STResList222 = [STRes221|STResList221],


  ?line {STRes222,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE008.xsd','./msxsdtest/identityConstraint',valid),
  STResList223 = [STRes222|STResList222],


  ?line {STRes223,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE009.xsd','./msxsdtest/identityConstraint',valid),
  STResList224 = [STRes223|STResList223],


  ?line {STRes224,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE010.xsd','./msxsdtest/identityConstraint',valid),
  STResList225 = [STRes224|STResList224],


  ?line {STRes225,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE011.xsd','./msxsdtest/identityConstraint',invalid),
  STResList226 = [STRes225|STResList225],


  ?line {STRes226,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE012.xsd','./msxsdtest/identityConstraint',invalid),
  STResList227 = [STRes226|STResList226],


  ?line {STRes227,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE013.xsd','./msxsdtest/identityConstraint',valid),
  STResList228 = [STRes227|STResList227],


  ?line {STRes228,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE014.xsd','./msxsdtest/identityConstraint',invalid),
  STResList229 = [STRes228|STResList228],


  ?line {STRes229,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE015.xsd','./msxsdtest/identityConstraint',valid),
  STResList230 = [STRes229|STResList229],


  ?line {STRes230,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE016.xsd','./msxsdtest/identityConstraint',valid),
  STResList231 = [STRes230|STResList230],


  ?line {STRes231,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE017.xsd','./msxsdtest/identityConstraint',invalid),
  STResList232 = [STRes231|STResList231],


  ?line {STRes232,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE018.xsd','./msxsdtest/identityConstraint',invalid),
  STResList233 = [STRes232|STResList232],


  ?line {STRes233,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE019.xsd','./msxsdtest/identityConstraint',invalid),
  STResList234 = [STRes233|STResList233],


  ?line {STRes234,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE020.xsd','./msxsdtest/identityConstraint',invalid),
  STResList235 = [STRes234|STResList234],


  ?line {STRes235,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE021.xsd','./msxsdtest/identityConstraint',invalid),
  STResList236 = [STRes235|STResList235],


  ?line {STRes236,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE022.xsd','./msxsdtest/identityConstraint',invalid),
  STResList237 = [STRes236|STResList236],


  ?line {STRes237,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE023.xsd','./msxsdtest/identityConstraint',invalid),
  STResList238 = [STRes237|STResList237],


  ?line {STRes238,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE024.xsd','./msxsdtest/identityConstraint',invalid),
  STResList239 = [STRes238|STResList238],


  ?line {STRes239,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE025.xsd','./msxsdtest/identityConstraint',invalid),
  STResList240 = [STRes239|STResList239],


  ?line {STRes240,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE026.xsd','./msxsdtest/identityConstraint',invalid),
  STResList241 = [STRes240|STResList240],


  ?line {STRes241,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE027.xsd','./msxsdtest/identityConstraint',invalid),
  STResList242 = [STRes241|STResList241],


  ?line {STRes242,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE028.xsd','./msxsdtest/identityConstraint',invalid),
  STResList243 = [STRes242|STResList242],


  ?line {STRes243,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE029.xsd','./msxsdtest/identityConstraint',invalid),
  STResList244 = [STRes243|STResList243],


  ?line {STRes244,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE030.xsd','./msxsdtest/identityConstraint',invalid),
  STResList245 = [STRes244|STResList244],


  ?line {STRes245,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE031.xsd','./msxsdtest/identityConstraint',invalid),
  STResList246 = [STRes245|STResList245],


  ?line {STRes246,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE032.xsd','./msxsdtest/identityConstraint',invalid),
  STResList247 = [STRes246|STResList246],


  ?line {STRes247,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idE033.xsd','./msxsdtest/identityConstraint',invalid),
  STResList248 = [STRes247|STResList247],


  ?line {STRes248,S248} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF001.xsd','./msxsdtest/identityConstraint',valid),
  STResList249 = [STRes248|STResList248],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF001.xml','./msxsdtest/identityConstraint',valid,S248),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes249,S249} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF003.xsd','./msxsdtest/identityConstraint',valid),
  STResList250 = [STRes249|STResList249],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF003.xml','./msxsdtest/identityConstraint',valid,S249),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes250,S250} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF004.xsd','./msxsdtest/identityConstraint',valid),
  STResList251 = [STRes250|STResList250],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF004.xml','./msxsdtest/identityConstraint',valid,S250),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes251,S251} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF005.xsd','./msxsdtest/identityConstraint',valid),
  STResList252 = [STRes251|STResList251],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF005.xml','./msxsdtest/identityConstraint',invalid,S251),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes252,S252} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF006.xsd','./msxsdtest/identityConstraint',valid),
  STResList253 = [STRes252|STResList252],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF006.xml','./msxsdtest/identityConstraint',invalid,S252),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes253,S253} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF007.xsd','./msxsdtest/identityConstraint',valid),
  STResList254 = [STRes253|STResList253],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF007.xml','./msxsdtest/identityConstraint',valid,S253),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes254,S254} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF008.xsd','./msxsdtest/identityConstraint',valid),
  STResList255 = [STRes254|STResList254],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF008.xml','./msxsdtest/identityConstraint',invalid,S254),
  ITResList7 = [ITRes6|ITResList6],


  ?line {STRes255,S255} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF009.xsd','./msxsdtest/identityConstraint',valid),
  STResList256 = [STRes255|STResList255],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF009.xml','./msxsdtest/identityConstraint',valid,S255),
  ITResList8 = [ITRes7|ITResList7],


  ?line {STRes256,S256} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF010.xsd','./msxsdtest/identityConstraint',valid),
  STResList257 = [STRes256|STResList256],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF010.xml','./msxsdtest/identityConstraint',invalid,S256),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes257,S257} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF011.xsd','./msxsdtest/identityConstraint',valid),
  STResList258 = [STRes257|STResList257],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF011.xml','./msxsdtest/identityConstraint',valid,S257),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes258,S258} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF012.xsd','./msxsdtest/identityConstraint',valid),
  STResList259 = [STRes258|STResList258],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF012.xml','./msxsdtest/identityConstraint',valid,S258),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes259,S259} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF013.xsd','./msxsdtest/identityConstraint',valid),
  STResList260 = [STRes259|STResList259],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF013.xml','./msxsdtest/identityConstraint',valid,S259),
  ITResList12 = [ITRes11|ITResList11],


  ?line {STRes260,S260} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF014.xsd','./msxsdtest/identityConstraint',valid),
  STResList261 = [STRes260|STResList260],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF014.xml','./msxsdtest/identityConstraint',valid,S260),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes261,S261} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF015.xsd','./msxsdtest/identityConstraint',valid),
  STResList262 = [STRes261|STResList261],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF015.xml','./msxsdtest/identityConstraint',invalid,S261),
  ITResList14 = [ITRes13|ITResList13],


  ?line {STRes262,S262} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF016.xsd','./msxsdtest/identityConstraint',valid),
  STResList263 = [STRes262|STResList262],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF016.xml','./msxsdtest/identityConstraint',invalid,S262),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes263,S263} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF017.xsd','./msxsdtest/identityConstraint',valid),
  STResList264 = [STRes263|STResList263],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF017.xml','./msxsdtest/identityConstraint',invalid,S263),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes264,S264} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF018.xsd','./msxsdtest/identityConstraint',valid),
  STResList265 = [STRes264|STResList264],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF018.xml','./msxsdtest/identityConstraint',invalid,S264),
  ITResList17 = [ITRes16|ITResList16],


  ?line {STRes265,S265} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF019.xsd','./msxsdtest/identityConstraint',valid),
  STResList266 = [STRes265|STResList265],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF019.xml','./msxsdtest/identityConstraint',valid,S265),
  ITResList18 = [ITRes17|ITResList17],


  ?line {STRes266,S266} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF020.xsd','./msxsdtest/identityConstraint',valid),
  STResList267 = [STRes266|STResList266],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF020.xml','./msxsdtest/identityConstraint',valid,S266),
  ITResList19 = [ITRes18|ITResList18],


  ?line {STRes267,S267} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF021.xsd','./msxsdtest/identityConstraint',valid),
  STResList268 = [STRes267|STResList267],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF021.xml','./msxsdtest/identityConstraint',valid,S267),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes268,S268} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF022.xsd','./msxsdtest/identityConstraint',valid),
  STResList269 = [STRes268|STResList268],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF022.xml','./msxsdtest/identityConstraint',valid,S268),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes269,S269} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF023.xsd','./msxsdtest/identityConstraint',valid),
  STResList270 = [STRes269|STResList269],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF023.xml','./msxsdtest/identityConstraint',valid,S269),
  ITResList22 = [ITRes21|ITResList21],


  ?line {STRes270,S270} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF024.xsd','./msxsdtest/identityConstraint',valid),
  STResList271 = [STRes270|STResList270],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF024.xml','./msxsdtest/identityConstraint',valid,S270),
  ITResList23 = [ITRes22|ITResList22],


  ?line {STRes271,S271} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF025.xsd','./msxsdtest/identityConstraint',valid),
  STResList272 = [STRes271|STResList271],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF025.xml','./msxsdtest/identityConstraint',valid,S271),
  ITResList24 = [ITRes23|ITResList23],


  ?line {STRes272,S272} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF026.xsd','./msxsdtest/identityConstraint',valid),
  STResList273 = [STRes272|STResList272],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF026.xml','./msxsdtest/identityConstraint',valid,S272),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes273,S273} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF027.xsd','./msxsdtest/identityConstraint',valid),
  STResList274 = [STRes273|STResList273],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF027.xml','./msxsdtest/identityConstraint',valid,S273),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes274,S274} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF028.xsd','./msxsdtest/identityConstraint',valid),
  STResList275 = [STRes274|STResList274],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF028.xml','./msxsdtest/identityConstraint',valid,S274),
  ITResList27 = [ITRes26|ITResList26],


  ?line {STRes275,S275} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF029.xsd','./msxsdtest/identityConstraint',valid),
  STResList276 = [STRes275|STResList275],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF029.xml','./msxsdtest/identityConstraint',valid,S275),
  ITResList28 = [ITRes27|ITResList27],


  ?line {STRes276,S276} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF030.xsd','./msxsdtest/identityConstraint',valid),
  STResList277 = [STRes276|STResList276],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF030.xml','./msxsdtest/identityConstraint',valid,S276),
  ITResList29 = [ITRes28|ITResList28],


  ?line {STRes277,S277} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF031.xsd','./msxsdtest/identityConstraint',valid),
  STResList278 = [STRes277|STResList277],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF031.xml','./msxsdtest/identityConstraint',valid,S277),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes278,S278} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF032.xsd','./msxsdtest/identityConstraint',valid),
  STResList279 = [STRes278|STResList278],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF032.xml','./msxsdtest/identityConstraint',valid,S278),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes279,S279} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF033.xsd','./msxsdtest/identityConstraint',valid),
  STResList280 = [STRes279|STResList279],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF033.xml','./msxsdtest/identityConstraint',valid,S279),
  ITResList32 = [ITRes31|ITResList31],


  ?line {STRes280,S280} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF034.xsd','./msxsdtest/identityConstraint',valid),
  STResList281 = [STRes280|STResList280],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF034.xml','./msxsdtest/identityConstraint',valid,S280),
  ITResList33 = [ITRes32|ITResList32],


  ?line {STRes281,S281} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF035.xsd','./msxsdtest/identityConstraint',valid),
  STResList282 = [STRes281|STResList281],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF035.xml','./msxsdtest/identityConstraint',valid,S281),
  ITResList34 = [ITRes33|ITResList33],


  ?line {STRes282,S282} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idF036.xsd','./msxsdtest/identityConstraint',valid),
  STResList283 = [STRes282|STResList282],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idF036.xml','./msxsdtest/identityConstraint',valid,S282),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes283,S283} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG001.xsd','./msxsdtest/identityConstraint',valid),
  STResList284 = [STRes283|STResList283],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG001.xml','./msxsdtest/identityConstraint',valid,S283),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes284,S284} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG003.xsd','./msxsdtest/identityConstraint',valid),
  STResList285 = [STRes284|STResList284],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG003.xml','./msxsdtest/identityConstraint',invalid,S284),
  ITResList37 = [ITRes36|ITResList36],


  ?line {STRes285,S285} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG004.xsd','./msxsdtest/identityConstraint',valid),
  STResList286 = [STRes285|STResList285],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG004.xml','./msxsdtest/identityConstraint',valid,S285),
  ITResList38 = [ITRes37|ITResList37],


  ?line {STRes286,S286} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG005.xsd','./msxsdtest/identityConstraint',valid),
  STResList287 = [STRes286|STResList286],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG005.xml','./msxsdtest/identityConstraint',invalid,S286),
  ITResList39 = [ITRes38|ITResList38],


  ?line {STRes287,S287} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG006.xsd','./msxsdtest/identityConstraint',valid),
  STResList288 = [STRes287|STResList287],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG006.xml','./msxsdtest/identityConstraint',invalid,S287),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes288,S288} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG007.xsd','./msxsdtest/identityConstraint',valid),
  STResList289 = [STRes288|STResList288],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG007.xml','./msxsdtest/identityConstraint',valid,S288),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes289,S289} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG008.xsd','./msxsdtest/identityConstraint',valid),
  STResList290 = [STRes289|STResList289],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG008.xml','./msxsdtest/identityConstraint',invalid,S289),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes290,S290} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG009.xsd','./msxsdtest/identityConstraint',valid),
  STResList291 = [STRes290|STResList290],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG009.xml','./msxsdtest/identityConstraint',invalid,S290),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes291,S291} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG010.xsd','./msxsdtest/identityConstraint',valid),
  STResList292 = [STRes291|STResList291],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG010.xml','./msxsdtest/identityConstraint',invalid,S291),
  ITResList44 = [ITRes43|ITResList43],


  ?line {STRes292,S292} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG011.xsd','./msxsdtest/identityConstraint',valid),
  STResList293 = [STRes292|STResList292],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG011.xml','./msxsdtest/identityConstraint',invalid,S292),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes293,S293} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG012.xsd','./msxsdtest/identityConstraint',valid),
  STResList294 = [STRes293|STResList293],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG012.xml','./msxsdtest/identityConstraint',invalid,S293),
  ITResList46 = [ITRes45|ITResList45],


  ?line {STRes294,S294} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG013.xsd','./msxsdtest/identityConstraint',valid),
  STResList295 = [STRes294|STResList294],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG013.xml','./msxsdtest/identityConstraint',valid,S294),
  ITResList47 = [ITRes46|ITResList46],


  ?line {STRes295,S295} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG014.xsd','./msxsdtest/identityConstraint',valid),
  STResList296 = [STRes295|STResList295],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG014.xml','./msxsdtest/identityConstraint',valid,S295),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes296,S296} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG015.xsd','./msxsdtest/identityConstraint',valid),
  STResList297 = [STRes296|STResList296],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG015.xml','./msxsdtest/identityConstraint',valid,S296),
  ITResList49 = [ITRes48|ITResList48],


  ?line {STRes297,S297} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG016.xsd','./msxsdtest/identityConstraint',valid),
  STResList298 = [STRes297|STResList297],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG016.xml','./msxsdtest/identityConstraint',valid,S297),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes298,S298} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG017.xsd','./msxsdtest/identityConstraint',valid),
  STResList299 = [STRes298|STResList298],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG017.xml','./msxsdtest/identityConstraint',valid,S298),
  ITResList51 = [ITRes50|ITResList50],


  ?line {STRes299,S299} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG018.xsd','./msxsdtest/identityConstraint',valid),
  STResList300 = [STRes299|STResList299],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG018.xml','./msxsdtest/identityConstraint',valid,S299),
  ITResList52 = [ITRes51|ITResList51],


  ?line {STRes300,S300} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG019.xsd','./msxsdtest/identityConstraint',valid),
  STResList301 = [STRes300|STResList300],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG019.xml','./msxsdtest/identityConstraint',valid,S300),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes301,S301} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG020.xsd','./msxsdtest/identityConstraint',valid),
  STResList302 = [STRes301|STResList301],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG020.xml','./msxsdtest/identityConstraint',invalid,S301),
  ITResList54 = [ITRes53|ITResList53],


  ?line {STRes302,S302} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG021.xsd','./msxsdtest/identityConstraint',valid),
  STResList303 = [STRes302|STResList302],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG021.xml','./msxsdtest/identityConstraint',valid,S302),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes303,S303} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG022.xsd','./msxsdtest/identityConstraint',valid),
  STResList304 = [STRes303|STResList303],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG022.xml','./msxsdtest/identityConstraint',valid,S303),
  ITResList56 = [ITRes55|ITResList55],


  ?line {STRes304,S304} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG023.xsd','./msxsdtest/identityConstraint',valid),
  STResList305 = [STRes304|STResList304],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG023.xml','./msxsdtest/identityConstraint',valid,S304),
  ITResList57 = [ITRes56|ITResList56],


  ?line {STRes305,S305} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG024.xsd','./msxsdtest/identityConstraint',valid),
  STResList306 = [STRes305|STResList305],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG024.xml','./msxsdtest/identityConstraint',valid,S305),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes306,S306} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG025.xsd','./msxsdtest/identityConstraint',valid),
  STResList307 = [STRes306|STResList306],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG025.xml','./msxsdtest/identityConstraint',invalid,S306),
  ITResList59 = [ITRes58|ITResList58],


  ?line {STRes307,S307} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG026.xsd','./msxsdtest/identityConstraint',valid),
  STResList308 = [STRes307|STResList307],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG026.xml','./msxsdtest/identityConstraint',valid,S307),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes308,S308} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG027.xsd','./msxsdtest/identityConstraint',valid),
  STResList309 = [STRes308|STResList308],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG027.xml','./msxsdtest/identityConstraint',valid,S308),
  ITResList61 = [ITRes60|ITResList60],


  ?line {STRes309,S309} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG028.xsd','./msxsdtest/identityConstraint',valid),
  STResList310 = [STRes309|STResList309],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG028.xml','./msxsdtest/identityConstraint',valid,S309),
  ITResList62 = [ITRes61|ITResList61],


  ?line {STRes310,S310} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG029.xsd','./msxsdtest/identityConstraint',valid),
  STResList311 = [STRes310|STResList310],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG029.xml','./msxsdtest/identityConstraint',valid,S310),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes311,S311} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idG030.xsd','./msxsdtest/identityConstraint',valid),
  STResList312 = [STRes311|STResList311],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idG030.xml','./msxsdtest/identityConstraint',valid,S311),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes312,S312} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH001.xsd','./msxsdtest/identityConstraint',valid),
  STResList313 = [STRes312|STResList312],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH001.xml','./msxsdtest/identityConstraint',valid,S312),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes313,S313} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH003.xsd','./msxsdtest/identityConstraint',valid),
  STResList314 = [STRes313|STResList313],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH003.xml','./msxsdtest/identityConstraint',valid,S313),
  ITResList66 = [ITRes65|ITResList65],


  ?line {STRes314,S314} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH004.xsd','./msxsdtest/identityConstraint',valid),
  STResList315 = [STRes314|STResList314],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH004.xml','./msxsdtest/identityConstraint',valid,S314),
  ITResList67 = [ITRes66|ITResList66],


  ?line {STRes315,S315} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH005.xsd','./msxsdtest/identityConstraint',valid),
  STResList316 = [STRes315|STResList315],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH005.xml','./msxsdtest/identityConstraint',invalid,S315),
  ITResList68 = [ITRes67|ITResList67],


  ?line {STRes316,S316} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH006.xsd','./msxsdtest/identityConstraint',valid),
  STResList317 = [STRes316|STResList316],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH006.xml','./msxsdtest/identityConstraint',invalid,S316),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes317,S317} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH007.xsd','./msxsdtest/identityConstraint',valid),
  STResList318 = [STRes317|STResList317],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH007.xml','./msxsdtest/identityConstraint',valid,S317),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes318,S318} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH008.xsd','./msxsdtest/identityConstraint',valid),
  STResList319 = [STRes318|STResList318],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH008.xml','./msxsdtest/identityConstraint',valid,S318),
  ITResList71 = [ITRes70|ITResList70],


  ?line {STRes319,S319} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH009.xsd','./msxsdtest/identityConstraint',valid),
  STResList320 = [STRes319|STResList319],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH009.xml','./msxsdtest/identityConstraint',valid,S319),
  ITResList72 = [ITRes71|ITResList71],


  ?line {STRes320,S320} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH010.xsd','./msxsdtest/identityConstraint',valid),
  STResList321 = [STRes320|STResList320],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH010.xml','./msxsdtest/identityConstraint',invalid,S320),
  ITResList73 = [ITRes72|ITResList72],


  ?line {STRes321,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH011.xsd','./msxsdtest/identityConstraint',invalid),
  STResList322 = [STRes321|STResList321],


  ?line {STRes322,S322} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH012.xsd','./msxsdtest/identityConstraint',valid),
  STResList323 = [STRes322|STResList322],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH012.xml','./msxsdtest/identityConstraint',invalid,S322),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes323,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH013.xsd','./msxsdtest/identityConstraint',invalid),
  STResList324 = [STRes323|STResList323],


  ?line {STRes324,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH014.xsd','./msxsdtest/identityConstraint',invalid),
  STResList325 = [STRes324|STResList324],


  ?line {STRes325,S325} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH015.xsd','./msxsdtest/identityConstraint',valid),
  STResList326 = [STRes325|STResList325],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH015.xml','./msxsdtest/identityConstraint',valid,S325),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes326,S326} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH016.xsd','./msxsdtest/identityConstraint',valid),
  STResList327 = [STRes326|STResList326],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH016.xml','./msxsdtest/identityConstraint',valid,S326),
  ITResList76 = [ITRes75|ITResList75],


  ?line {STRes327,S327} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH017.xsd','./msxsdtest/identityConstraint',valid),
  STResList328 = [STRes327|STResList327],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH017.xml','./msxsdtest/identityConstraint',valid,S327),
  ITResList77 = [ITRes76|ITResList76],


  ?line {STRes328,S328} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH018.xsd','./msxsdtest/identityConstraint',valid),
  STResList329 = [STRes328|STResList328],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH018.xml','./msxsdtest/identityConstraint',valid,S328),
  ITResList78 = [ITRes77|ITResList77],


  ?line {STRes329,S329} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH019.xsd','./msxsdtest/identityConstraint',valid),
  STResList330 = [STRes329|STResList329],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH019.xml','./msxsdtest/identityConstraint',valid,S329),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes330,S330} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH020.xsd','./msxsdtest/identityConstraint',valid),
  STResList331 = [STRes330|STResList330],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH020.xml','./msxsdtest/identityConstraint',valid,S330),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes331,S331} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH021.xsd','./msxsdtest/identityConstraint',valid),
  STResList332 = [STRes331|STResList331],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH021.xml','./msxsdtest/identityConstraint',valid,S331),
  ITResList81 = [ITRes80|ITResList80],


  ?line {STRes332,S332} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH022.xsd','./msxsdtest/identityConstraint',valid),
  STResList333 = [STRes332|STResList332],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH022.xml','./msxsdtest/identityConstraint',valid,S332),
  ITResList82 = [ITRes81|ITResList81],


  ?line {STRes333,S333} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH023.xsd','./msxsdtest/identityConstraint',valid),
  STResList334 = [STRes333|STResList333],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH023.xml','./msxsdtest/identityConstraint',valid,S333),
  ITResList83 = [ITRes82|ITResList82],


  ?line {STRes334,S334} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH024.xsd','./msxsdtest/identityConstraint',valid),
  STResList335 = [STRes334|STResList334],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH024.xml','./msxsdtest/identityConstraint',valid,S334),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes335,S335} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH025.xsd','./msxsdtest/identityConstraint',valid),
  STResList336 = [STRes335|STResList335],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH025.xml','./msxsdtest/identityConstraint',valid,S335),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes336,S336} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH026.xsd','./msxsdtest/identityConstraint',valid),
  STResList337 = [STRes336|STResList336],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH026.xml','./msxsdtest/identityConstraint',valid,S336),
  ITResList86 = [ITRes85|ITResList85],


  ?line {STRes337,S337} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH027.xsd','./msxsdtest/identityConstraint',valid),
  STResList338 = [STRes337|STResList337],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH027.xml','./msxsdtest/identityConstraint',valid,S337),
  ITResList87 = [ITRes86|ITResList86],


  ?line {STRes338,S338} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH028.xsd','./msxsdtest/identityConstraint',valid),
  STResList339 = [STRes338|STResList338],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH028.xml','./msxsdtest/identityConstraint',valid,S338),
  ITResList88 = [ITRes87|ITResList87],


  ?line {STRes339,S339} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH029.xsd','./msxsdtest/identityConstraint',valid),
  STResList340 = [STRes339|STResList339],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH029.xml','./msxsdtest/identityConstraint',valid,S339),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes340,S340} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH030.xsd','./msxsdtest/identityConstraint',valid),
  STResList341 = [STRes340|STResList340],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH030.xml','./msxsdtest/identityConstraint',valid,S340),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes341,S341} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH031.xsd','./msxsdtest/identityConstraint',valid),
  STResList342 = [STRes341|STResList341],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH031.xml','./msxsdtest/identityConstraint',valid,S341),
  ITResList91 = [ITRes90|ITResList90],


  ?line {STRes342,S342} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH032.xsd','./msxsdtest/identityConstraint',valid),
  STResList343 = [STRes342|STResList342],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH032.xml','./msxsdtest/identityConstraint',valid,S342),
  ITResList92 = [ITRes91|ITResList91],


  ?line {STRes343,S343} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH034.xsd','./msxsdtest/identityConstraint',valid),
  STResList344 = [STRes343|STResList343],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idH034.xml','./msxsdtest/identityConstraint',valid,S343),
  ITResList93 = [ITRes92|ITResList92],


  ?line {STRes344,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idH035.xsd','./msxsdtest/identityConstraint',invalid),
  STResList345 = [STRes344|STResList344],


  ?line {STRes345,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI001.xsd','./msxsdtest/identityConstraint',invalid),
  STResList346 = [STRes345|STResList345],


  ?line {STRes346,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI002.xsd','./msxsdtest/identityConstraint',valid),
  STResList347 = [STRes346|STResList346],


  ?line {STRes347,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI003.xsd','./msxsdtest/identityConstraint',invalid),
  STResList348 = [STRes347|STResList347],


  ?line {STRes348,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI004.xsd','./msxsdtest/identityConstraint',invalid),
  STResList349 = [STRes348|STResList348],


  ?line {STRes349,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI005.xsd','./msxsdtest/identityConstraint',invalid),
  STResList350 = [STRes349|STResList349],


  ?line {STRes350,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI006.xsd','./msxsdtest/identityConstraint',invalid),
  STResList351 = [STRes350|STResList350],


  ?line {STRes351,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI007.xsd','./msxsdtest/identityConstraint',invalid),
  STResList352 = [STRes351|STResList351],


  ?line {STRes352,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI008.xsd','./msxsdtest/identityConstraint',valid),
  STResList353 = [STRes352|STResList352],


  ?line {STRes353,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI009.xsd','./msxsdtest/identityConstraint',valid),
  STResList354 = [STRes353|STResList353],


  ?line {STRes354,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI010.xsd','./msxsdtest/identityConstraint',invalid),
  STResList355 = [STRes354|STResList354],


  ?line {STRes355,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI011.xsd','./msxsdtest/identityConstraint',valid),
  STResList356 = [STRes355|STResList355],


  ?line {STRes356,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI012.xsd','./msxsdtest/identityConstraint',valid),
  STResList357 = [STRes356|STResList356],


  ?line {STRes357,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI013.xsd','./msxsdtest/identityConstraint',valid),
  STResList358 = [STRes357|STResList357],


  ?line {STRes358,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI014.xsd','./msxsdtest/identityConstraint',invalid),
  STResList359 = [STRes358|STResList358],


  ?line {STRes359,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI015.xsd','./msxsdtest/identityConstraint',invalid),
  STResList360 = [STRes359|STResList359],


  ?line {STRes360,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI016.xsd','./msxsdtest/identityConstraint',invalid),
  STResList361 = [STRes360|STResList360],


  ?line {STRes361,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI017.xsd','./msxsdtest/identityConstraint',valid),
  STResList362 = [STRes361|STResList361],


  ?line {STRes362,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI018.xsd','./msxsdtest/identityConstraint',invalid),
  STResList363 = [STRes362|STResList362],


  ?line {STRes363,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI019.xsd','./msxsdtest/identityConstraint',valid),
  STResList364 = [STRes363|STResList363],


  ?line {STRes364,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI020.xsd','./msxsdtest/identityConstraint',valid),
  STResList365 = [STRes364|STResList364],


  ?line {STRes365,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI021.xsd','./msxsdtest/identityConstraint',valid),
  STResList366 = [STRes365|STResList365],


  ?line {STRes366,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI022.xsd','./msxsdtest/identityConstraint',invalid),
  STResList367 = [STRes366|STResList366],


  ?line {STRes367,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI023.xsd','./msxsdtest/identityConstraint',invalid),
  STResList368 = [STRes367|STResList367],


  ?line {STRes368,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI024.xsd','./msxsdtest/identityConstraint',valid),
  STResList369 = [STRes368|STResList368],


  ?line {STRes369,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI025.xsd','./msxsdtest/identityConstraint',valid),
  STResList370 = [STRes369|STResList369],


  ?line {STRes370,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI026.xsd','./msxsdtest/identityConstraint',valid),
  STResList371 = [STRes370|STResList370],


  ?line {STRes371,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI027.xsd','./msxsdtest/identityConstraint',valid),
  STResList372 = [STRes371|STResList371],


  ?line {STRes372,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI028.xsd','./msxsdtest/identityConstraint',invalid),
  STResList373 = [STRes372|STResList372],


  ?line {STRes373,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI029.xsd','./msxsdtest/identityConstraint',valid),
  STResList374 = [STRes373|STResList373],


  ?line {STRes374,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI030.xsd','./msxsdtest/identityConstraint',valid),
  STResList375 = [STRes374|STResList374],


  ?line {STRes375,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI031.xsd','./msxsdtest/identityConstraint',valid),
  STResList376 = [STRes375|STResList375],


  ?line {STRes376,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI032.xsd','./msxsdtest/identityConstraint',valid),
  STResList377 = [STRes376|STResList376],


  ?line {STRes377,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI033.xsd','./msxsdtest/identityConstraint',valid),
  STResList378 = [STRes377|STResList377],


  ?line {STRes378,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI034.xsd','./msxsdtest/identityConstraint',valid),
  STResList379 = [STRes378|STResList378],


  ?line {STRes379,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI035.xsd','./msxsdtest/identityConstraint',valid),
  STResList380 = [STRes379|STResList379],


  ?line {STRes380,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI036.xsd','./msxsdtest/identityConstraint',valid),
  STResList381 = [STRes380|STResList380],


  ?line {STRes381,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI037.xsd','./msxsdtest/identityConstraint',valid),
  STResList382 = [STRes381|STResList381],


  ?line {STRes382,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI038.xsd','./msxsdtest/identityConstraint',invalid),
  STResList383 = [STRes382|STResList382],


  ?line {STRes383,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI039.xsd','./msxsdtest/identityConstraint',valid),
  STResList384 = [STRes383|STResList383],


  ?line {STRes384,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI040.xsd','./msxsdtest/identityConstraint',valid),
  STResList385 = [STRes384|STResList384],


  ?line {STRes385,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI041.xsd','./msxsdtest/identityConstraint',valid),
  STResList386 = [STRes385|STResList385],


  ?line {STRes386,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI042.xsd','./msxsdtest/identityConstraint',valid),
  STResList387 = [STRes386|STResList386],


  ?line {STRes387,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI043.xsd','./msxsdtest/identityConstraint',valid),
  STResList388 = [STRes387|STResList387],


  ?line {STRes388,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI044.xsd','./msxsdtest/identityConstraint',valid),
  STResList389 = [STRes388|STResList388],


  ?line {STRes389,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI045.xsd','./msxsdtest/identityConstraint',valid),
  STResList390 = [STRes389|STResList389],


  ?line {STRes390,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI046.xsd','./msxsdtest/identityConstraint',valid),
  STResList391 = [STRes390|STResList390],


  ?line {STRes391,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI047.xsd','./msxsdtest/identityConstraint',valid),
  STResList392 = [STRes391|STResList391],


  ?line {STRes392,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI048.xsd','./msxsdtest/identityConstraint',valid),
  STResList393 = [STRes392|STResList392],


  ?line {STRes393,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI049.xsd','./msxsdtest/identityConstraint',valid),
  STResList394 = [STRes393|STResList393],


  ?line {STRes394,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI050.xsd','./msxsdtest/identityConstraint',valid),
  STResList395 = [STRes394|STResList394],


  ?line {STRes395,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI051.xsd','./msxsdtest/identityConstraint',valid),
  STResList396 = [STRes395|STResList395],


  ?line {STRes396,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI052.xsd','./msxsdtest/identityConstraint',valid),
  STResList397 = [STRes396|STResList396],


  ?line {STRes397,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI053.xsd','./msxsdtest/identityConstraint',valid),
  STResList398 = [STRes397|STResList397],


  ?line {STRes398,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI054.xsd','./msxsdtest/identityConstraint',valid),
  STResList399 = [STRes398|STResList398],


  ?line {STRes399,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI055.xsd','./msxsdtest/identityConstraint',valid),
  STResList400 = [STRes399|STResList399],


  ?line {STRes400,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI056.xsd','./msxsdtest/identityConstraint',valid),
  STResList401 = [STRes400|STResList400],


  ?line {STRes401,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI057.xsd','./msxsdtest/identityConstraint',valid),
  STResList402 = [STRes401|STResList401],


  ?line {STRes402,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI058.xsd','./msxsdtest/identityConstraint',valid),
  STResList403 = [STRes402|STResList402],


  ?line {STRes403,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI059.xsd','./msxsdtest/identityConstraint',valid),
  STResList404 = [STRes403|STResList403],


  ?line {STRes404,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI060.xsd','./msxsdtest/identityConstraint',valid),
  STResList405 = [STRes404|STResList404],


  ?line {STRes405,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI061.xsd','./msxsdtest/identityConstraint',valid),
  STResList406 = [STRes405|STResList405],


  ?line {STRes406,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI062.xsd','./msxsdtest/identityConstraint',valid),
  STResList407 = [STRes406|STResList406],


  ?line {STRes407,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI063.xsd','./msxsdtest/identityConstraint',valid),
  STResList408 = [STRes407|STResList407],


  ?line {STRes408,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI064.xsd','./msxsdtest/identityConstraint',valid),
  STResList409 = [STRes408|STResList408],


  ?line {STRes409,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI065.xsd','./msxsdtest/identityConstraint',valid),
  STResList410 = [STRes409|STResList409],


  ?line {STRes410,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI066.xsd','./msxsdtest/identityConstraint',valid),
  STResList411 = [STRes410|STResList410],


  ?line {STRes411,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI067.xsd','./msxsdtest/identityConstraint',valid),
  STResList412 = [STRes411|STResList411],


  ?line {STRes412,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI068.xsd','./msxsdtest/identityConstraint',valid),
  STResList413 = [STRes412|STResList412],


  ?line {STRes413,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI069.xsd','./msxsdtest/identityConstraint',valid),
  STResList414 = [STRes413|STResList413],


  ?line {STRes414,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI070.xsd','./msxsdtest/identityConstraint',valid),
  STResList415 = [STRes414|STResList414],


  ?line {STRes415,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI071.xsd','./msxsdtest/identityConstraint',valid),
  STResList416 = [STRes415|STResList415],


  ?line {STRes416,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI072.xsd','./msxsdtest/identityConstraint',valid),
  STResList417 = [STRes416|STResList416],


  ?line {STRes417,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI073.xsd','./msxsdtest/identityConstraint',valid),
  STResList418 = [STRes417|STResList417],


  ?line {STRes418,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI074.xsd','./msxsdtest/identityConstraint',valid),
  STResList419 = [STRes418|STResList418],


  ?line {STRes419,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI075.xsd','./msxsdtest/identityConstraint',valid),
  STResList420 = [STRes419|STResList419],


  ?line {STRes420,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI076.xsd','./msxsdtest/identityConstraint',valid),
  STResList421 = [STRes420|STResList420],


  ?line {STRes421,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI077.xsd','./msxsdtest/identityConstraint',valid),
  STResList422 = [STRes421|STResList421],


  ?line {STRes422,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI078.xsd','./msxsdtest/identityConstraint',valid),
  STResList423 = [STRes422|STResList422],


  ?line {STRes423,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI079.xsd','./msxsdtest/identityConstraint',valid),
  STResList424 = [STRes423|STResList423],


  ?line {STRes424,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI080.xsd','./msxsdtest/identityConstraint',valid),
  STResList425 = [STRes424|STResList424],


  ?line {STRes425,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI081.xsd','./msxsdtest/identityConstraint',valid),
  STResList426 = [STRes425|STResList425],


  ?line {STRes426,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI082.xsd','./msxsdtest/identityConstraint',valid),
  STResList427 = [STRes426|STResList426],


  ?line {STRes427,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI083.xsd','./msxsdtest/identityConstraint',valid),
  STResList428 = [STRes427|STResList427],


  ?line {STRes428,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI084.xsd','./msxsdtest/identityConstraint',valid),
  STResList429 = [STRes428|STResList428],


  ?line {STRes429,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI085.xsd','./msxsdtest/identityConstraint',valid),
  STResList430 = [STRes429|STResList429],


  ?line {STRes430,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI086.xsd','./msxsdtest/identityConstraint',valid),
  STResList431 = [STRes430|STResList430],


  ?line {STRes431,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI087.xsd','./msxsdtest/identityConstraint',valid),
  STResList432 = [STRes431|STResList431],


  ?line {STRes432,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI088.xsd','./msxsdtest/identityConstraint',valid),
  STResList433 = [STRes432|STResList432],


  ?line {STRes433,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI089.xsd','./msxsdtest/identityConstraint',valid),
  STResList434 = [STRes433|STResList433],


  ?line {STRes434,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI090.xsd','./msxsdtest/identityConstraint',valid),
  STResList435 = [STRes434|STResList434],


  ?line {STRes435,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI091.xsd','./msxsdtest/identityConstraint',valid),
  STResList436 = [STRes435|STResList435],


  ?line {STRes436,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI092.xsd','./msxsdtest/identityConstraint',valid),
  STResList437 = [STRes436|STResList436],


  ?line {STRes437,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI093.xsd','./msxsdtest/identityConstraint',valid),
  STResList438 = [STRes437|STResList437],


  ?line {STRes438,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI094.xsd','./msxsdtest/identityConstraint',valid),
  STResList439 = [STRes438|STResList438],


  ?line {STRes439,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI095.xsd','./msxsdtest/identityConstraint',valid),
  STResList440 = [STRes439|STResList439],


  ?line {STRes440,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI096.xsd','./msxsdtest/identityConstraint',valid),
  STResList441 = [STRes440|STResList440],


  ?line {STRes441,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI097.xsd','./msxsdtest/identityConstraint',valid),
  STResList442 = [STRes441|STResList441],


  ?line {STRes442,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI098.xsd','./msxsdtest/identityConstraint',valid),
  STResList443 = [STRes442|STResList442],


  ?line {STRes443,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI099.xsd','./msxsdtest/identityConstraint',valid),
  STResList444 = [STRes443|STResList443],


  ?line {STRes444,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI100.xsd','./msxsdtest/identityConstraint',valid),
  STResList445 = [STRes444|STResList444],


  ?line {STRes445,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI101.xsd','./msxsdtest/identityConstraint',valid),
  STResList446 = [STRes445|STResList445],


  ?line {STRes446,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI102.xsd','./msxsdtest/identityConstraint',valid),
  STResList447 = [STRes446|STResList446],


  ?line {STRes447,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI103.xsd','./msxsdtest/identityConstraint',valid),
  STResList448 = [STRes447|STResList447],


  ?line {STRes448,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI104.xsd','./msxsdtest/identityConstraint',valid),
  STResList449 = [STRes448|STResList448],


  ?line {STRes449,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI105.xsd','./msxsdtest/identityConstraint',valid),
  STResList450 = [STRes449|STResList449],


  ?line {STRes450,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI106.xsd','./msxsdtest/identityConstraint',valid),
  STResList451 = [STRes450|STResList450],


  ?line {STRes451,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI107.xsd','./msxsdtest/identityConstraint',valid),
  STResList452 = [STRes451|STResList451],


  ?line {STRes452,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI108.xsd','./msxsdtest/identityConstraint',valid),
  STResList453 = [STRes452|STResList452],


  ?line {STRes453,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI109.xsd','./msxsdtest/identityConstraint',valid),
  STResList454 = [STRes453|STResList453],


  ?line {STRes454,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI110.xsd','./msxsdtest/identityConstraint',valid),
  STResList455 = [STRes454|STResList454],


  ?line {STRes455,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI111.xsd','./msxsdtest/identityConstraint',valid),
  STResList456 = [STRes455|STResList455],


  ?line {STRes456,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI112.xsd','./msxsdtest/identityConstraint',valid),
  STResList457 = [STRes456|STResList456],


  ?line {STRes457,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI113.xsd','./msxsdtest/identityConstraint',valid),
  STResList458 = [STRes457|STResList457],


  ?line {STRes458,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI114.xsd','./msxsdtest/identityConstraint',valid),
  STResList459 = [STRes458|STResList458],


  ?line {STRes459,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI115.xsd','./msxsdtest/identityConstraint',valid),
  STResList460 = [STRes459|STResList459],


  ?line {STRes460,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI116.xsd','./msxsdtest/identityConstraint',valid),
  STResList461 = [STRes460|STResList460],


  ?line {STRes461,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI117.xsd','./msxsdtest/identityConstraint',valid),
  STResList462 = [STRes461|STResList461],


  ?line {STRes462,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI118.xsd','./msxsdtest/identityConstraint',valid),
  STResList463 = [STRes462|STResList462],


  ?line {STRes463,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI119.xsd','./msxsdtest/identityConstraint',valid),
  STResList464 = [STRes463|STResList463],


  ?line {STRes464,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI120.xsd','./msxsdtest/identityConstraint',valid),
  STResList465 = [STRes464|STResList464],


  ?line {STRes465,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI121.xsd','./msxsdtest/identityConstraint',valid),
  STResList466 = [STRes465|STResList465],


  ?line {STRes466,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI122.xsd','./msxsdtest/identityConstraint',valid),
  STResList467 = [STRes466|STResList466],


  ?line {STRes467,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI123.xsd','./msxsdtest/identityConstraint',valid),
  STResList468 = [STRes467|STResList467],


  ?line {STRes468,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI124.xsd','./msxsdtest/identityConstraint',valid),
  STResList469 = [STRes468|STResList468],


  ?line {STRes469,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI125.xsd','./msxsdtest/identityConstraint',valid),
  STResList470 = [STRes469|STResList469],


  ?line {STRes470,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI126.xsd','./msxsdtest/identityConstraint',valid),
  STResList471 = [STRes470|STResList470],


  ?line {STRes471,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI127.xsd','./msxsdtest/identityConstraint',valid),
  STResList472 = [STRes471|STResList471],


  ?line {STRes472,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI128.xsd','./msxsdtest/identityConstraint',valid),
  STResList473 = [STRes472|STResList472],


  ?line {STRes473,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI129.xsd','./msxsdtest/identityConstraint',valid),
  STResList474 = [STRes473|STResList473],


  ?line {STRes474,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI130.xsd','./msxsdtest/identityConstraint',valid),
  STResList475 = [STRes474|STResList474],


  ?line {STRes475,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI131.xsd','./msxsdtest/identityConstraint',valid),
  STResList476 = [STRes475|STResList475],


  ?line {STRes476,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI132.xsd','./msxsdtest/identityConstraint',valid),
  STResList477 = [STRes476|STResList476],


  ?line {STRes477,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI133.xsd','./msxsdtest/identityConstraint',valid),
  STResList478 = [STRes477|STResList477],


  ?line {STRes478,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI134.xsd','./msxsdtest/identityConstraint',valid),
  STResList479 = [STRes478|STResList478],


  ?line {STRes479,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI135.xsd','./msxsdtest/identityConstraint',valid),
  STResList480 = [STRes479|STResList479],


  ?line {STRes480,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI136.xsd','./msxsdtest/identityConstraint',valid),
  STResList481 = [STRes480|STResList480],


  ?line {STRes481,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI137.xsd','./msxsdtest/identityConstraint',valid),
  STResList482 = [STRes481|STResList481],


  ?line {STRes482,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI138.xsd','./msxsdtest/identityConstraint',valid),
  STResList483 = [STRes482|STResList482],


  ?line {STRes483,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI139.xsd','./msxsdtest/identityConstraint',valid),
  STResList484 = [STRes483|STResList483],


  ?line {STRes484,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI140.xsd','./msxsdtest/identityConstraint',valid),
  STResList485 = [STRes484|STResList484],


  ?line {STRes485,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI141.xsd','./msxsdtest/identityConstraint',valid),
  STResList486 = [STRes485|STResList485],


  ?line {STRes486,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI142.xsd','./msxsdtest/identityConstraint',valid),
  STResList487 = [STRes486|STResList486],


  ?line {STRes487,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI143.xsd','./msxsdtest/identityConstraint',valid),
  STResList488 = [STRes487|STResList487],


  ?line {STRes488,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI144.xsd','./msxsdtest/identityConstraint',valid),
  STResList489 = [STRes488|STResList488],


  ?line {STRes489,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI145.xsd','./msxsdtest/identityConstraint',invalid),
  STResList490 = [STRes489|STResList489],


  ?line {STRes490,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI146.xsd','./msxsdtest/identityConstraint',invalid),
  STResList491 = [STRes490|STResList490],


  ?line {STRes491,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI147.xsd','./msxsdtest/identityConstraint',invalid),
  STResList492 = [STRes491|STResList491],


  ?line {STRes492,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI148.xsd','./msxsdtest/identityConstraint',invalid),
  STResList493 = [STRes492|STResList492],


  ?line {STRes493,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI149.xsd','./msxsdtest/identityConstraint',invalid),
  STResList494 = [STRes493|STResList493],


  ?line {STRes494,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI150.xsd','./msxsdtest/identityConstraint',invalid),
  STResList495 = [STRes494|STResList494],


  ?line {STRes495,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI151.xsd','./msxsdtest/identityConstraint',invalid),
  STResList496 = [STRes495|STResList495],


  ?line {STRes496,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idI152.xsd','./msxsdtest/identityConstraint',invalid),
  STResList497 = [STRes496|STResList496],


  ?line {STRes497,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ001.xsd','./msxsdtest/identityConstraint',invalid),
  STResList498 = [STRes497|STResList497],


  ?line {STRes498,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ002.xsd','./msxsdtest/identityConstraint',invalid),
  STResList499 = [STRes498|STResList498],


  ?line {STRes499,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ003.xsd','./msxsdtest/identityConstraint',invalid),
  STResList500 = [STRes499|STResList499],


  ?line {STRes500,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ004.xsd','./msxsdtest/identityConstraint',valid),
  STResList501 = [STRes500|STResList500],


  ?line {STRes501,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ005.xsd','./msxsdtest/identityConstraint',invalid),
  STResList502 = [STRes501|STResList501],


  ?line {STRes502,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ006.xsd','./msxsdtest/identityConstraint',invalid),
  STResList503 = [STRes502|STResList502],


  ?line {STRes503,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ007.xsd','./msxsdtest/identityConstraint',invalid),
  STResList504 = [STRes503|STResList503],


  ?line {STRes504,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ008.xsd','./msxsdtest/identityConstraint',invalid),
  STResList505 = [STRes504|STResList504],


  ?line {STRes505,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ009.xsd','./msxsdtest/identityConstraint',valid),
  STResList506 = [STRes505|STResList505],


  ?line {STRes506,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ010.xsd','./msxsdtest/identityConstraint',valid),
  STResList507 = [STRes506|STResList506],


  ?line {STRes507,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ011.xsd','./msxsdtest/identityConstraint',invalid),
  STResList508 = [STRes507|STResList507],


  ?line {STRes508,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ012.xsd','./msxsdtest/identityConstraint',valid),
  STResList509 = [STRes508|STResList508],


  ?line {STRes509,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ013.xsd','./msxsdtest/identityConstraint',valid),
  STResList510 = [STRes509|STResList509],


  ?line {STRes510,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ014.xsd','./msxsdtest/identityConstraint',valid),
  STResList511 = [STRes510|STResList510],


  ?line {STRes511,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ015.xsd','./msxsdtest/identityConstraint',invalid),
  STResList512 = [STRes511|STResList511],


  ?line {STRes512,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ016.xsd','./msxsdtest/identityConstraint',invalid),
  STResList513 = [STRes512|STResList512],


  ?line {STRes513,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ017.xsd','./msxsdtest/identityConstraint',invalid),
  STResList514 = [STRes513|STResList513],


  ?line {STRes514,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ018.xsd','./msxsdtest/identityConstraint',valid),
  STResList515 = [STRes514|STResList514],


  ?line {STRes515,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ019.xsd','./msxsdtest/identityConstraint',valid),
  STResList516 = [STRes515|STResList515],


  ?line {STRes516,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ020.xsd','./msxsdtest/identityConstraint',valid),
  STResList517 = [STRes516|STResList516],


  ?line {STRes517,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ021.xsd','./msxsdtest/identityConstraint',valid),
  STResList518 = [STRes517|STResList517],


  ?line {STRes518,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ022.xsd','./msxsdtest/identityConstraint',valid),
  STResList519 = [STRes518|STResList518],


  ?line {STRes519,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ023.xsd','./msxsdtest/identityConstraint',valid),
  STResList520 = [STRes519|STResList519],


  ?line {STRes520,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ024.xsd','./msxsdtest/identityConstraint',valid),
  STResList521 = [STRes520|STResList520],


  ?line {STRes521,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ025.xsd','./msxsdtest/identityConstraint',invalid),
  STResList522 = [STRes521|STResList521],


  ?line {STRes522,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ026.xsd','./msxsdtest/identityConstraint',invalid),
  STResList523 = [STRes522|STResList522],


  ?line {STRes523,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ027.xsd','./msxsdtest/identityConstraint',valid),
  STResList524 = [STRes523|STResList523],


  ?line {STRes524,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ028.xsd','./msxsdtest/identityConstraint',valid),
  STResList525 = [STRes524|STResList524],


  ?line {STRes525,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ029.xsd','./msxsdtest/identityConstraint',valid),
  STResList526 = [STRes525|STResList525],


  ?line {STRes526,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ030.xsd','./msxsdtest/identityConstraint',invalid),
  STResList527 = [STRes526|STResList526],


  ?line {STRes527,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ031.xsd','./msxsdtest/identityConstraint',valid),
  STResList528 = [STRes527|STResList527],


  ?line {STRes528,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ032.xsd','./msxsdtest/identityConstraint',invalid),
  STResList529 = [STRes528|STResList528],


  ?line {STRes529,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ033.xsd','./msxsdtest/identityConstraint',valid),
  STResList530 = [STRes529|STResList529],


  ?line {STRes530,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ034.xsd','./msxsdtest/identityConstraint',valid),
  STResList531 = [STRes530|STResList530],


  ?line {STRes531,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ035.xsd','./msxsdtest/identityConstraint',valid),
  STResList532 = [STRes531|STResList531],


  ?line {STRes532,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ036.xsd','./msxsdtest/identityConstraint',invalid),
  STResList533 = [STRes532|STResList532],


  ?line {STRes533,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ037.xsd','./msxsdtest/identityConstraint',valid),
  STResList534 = [STRes533|STResList533],


  ?line {STRes534,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ038.xsd','./msxsdtest/identityConstraint',valid),
  STResList535 = [STRes534|STResList534],


  ?line {STRes535,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ039.xsd','./msxsdtest/identityConstraint',valid),
  STResList536 = [STRes535|STResList535],


  ?line {STRes536,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ040.xsd','./msxsdtest/identityConstraint',valid),
  STResList537 = [STRes536|STResList536],


  ?line {STRes537,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ041.xsd','./msxsdtest/identityConstraint',valid),
  STResList538 = [STRes537|STResList537],


  ?line {STRes538,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ042.xsd','./msxsdtest/identityConstraint',valid),
  STResList539 = [STRes538|STResList538],


  ?line {STRes539,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ043.xsd','./msxsdtest/identityConstraint',valid),
  STResList540 = [STRes539|STResList539],


  ?line {STRes540,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ044.xsd','./msxsdtest/identityConstraint',valid),
  STResList541 = [STRes540|STResList540],


  ?line {STRes541,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ045.xsd','./msxsdtest/identityConstraint',valid),
  STResList542 = [STRes541|STResList541],


  ?line {STRes542,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ046.xsd','./msxsdtest/identityConstraint',valid),
  STResList543 = [STRes542|STResList542],


  ?line {STRes543,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ047.xsd','./msxsdtest/identityConstraint',valid),
  STResList544 = [STRes543|STResList543],


  ?line {STRes544,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ048.xsd','./msxsdtest/identityConstraint',valid),
  STResList545 = [STRes544|STResList544],


  ?line {STRes545,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ049.xsd','./msxsdtest/identityConstraint',valid),
  STResList546 = [STRes545|STResList545],


  ?line {STRes546,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ050.xsd','./msxsdtest/identityConstraint',valid),
  STResList547 = [STRes546|STResList546],


  ?line {STRes547,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ051.xsd','./msxsdtest/identityConstraint',valid),
  STResList548 = [STRes547|STResList547],


  ?line {STRes548,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ052.xsd','./msxsdtest/identityConstraint',invalid),
  STResList549 = [STRes548|STResList548],


  ?line {STRes549,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ053.xsd','./msxsdtest/identityConstraint',valid),
  STResList550 = [STRes549|STResList549],


  ?line {STRes550,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ054.xsd','./msxsdtest/identityConstraint',valid),
  STResList551 = [STRes550|STResList550],


  ?line {STRes551,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ055.xsd','./msxsdtest/identityConstraint',valid),
  STResList552 = [STRes551|STResList551],


  ?line {STRes552,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ056.xsd','./msxsdtest/identityConstraint',invalid),
  STResList553 = [STRes552|STResList552],


  ?line {STRes553,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ057.xsd','./msxsdtest/identityConstraint',valid),
  STResList554 = [STRes553|STResList553],


  ?line {STRes554,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ058.xsd','./msxsdtest/identityConstraint',valid),
  STResList555 = [STRes554|STResList554],


  ?line {STRes555,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ059.xsd','./msxsdtest/identityConstraint',valid),
  STResList556 = [STRes555|STResList555],


  ?line {STRes556,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ060.xsd','./msxsdtest/identityConstraint',valid),
  STResList557 = [STRes556|STResList556],


  ?line {STRes557,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ061.xsd','./msxsdtest/identityConstraint',valid),
  STResList558 = [STRes557|STResList557],


  ?line {STRes558,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ062.xsd','./msxsdtest/identityConstraint',valid),
  STResList559 = [STRes558|STResList558],


  ?line {STRes559,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ063.xsd','./msxsdtest/identityConstraint',valid),
  STResList560 = [STRes559|STResList559],


  ?line {STRes560,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ064.xsd','./msxsdtest/identityConstraint',valid),
  STResList561 = [STRes560|STResList560],


  ?line {STRes561,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ065.xsd','./msxsdtest/identityConstraint',valid),
  STResList562 = [STRes561|STResList561],


  ?line {STRes562,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ066.xsd','./msxsdtest/identityConstraint',valid),
  STResList563 = [STRes562|STResList562],


  ?line {STRes563,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ067.xsd','./msxsdtest/identityConstraint',valid),
  STResList564 = [STRes563|STResList563],


  ?line {STRes564,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ068.xsd','./msxsdtest/identityConstraint',valid),
  STResList565 = [STRes564|STResList564],


  ?line {STRes565,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ069.xsd','./msxsdtest/identityConstraint',valid),
  STResList566 = [STRes565|STResList565],


  ?line {STRes566,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ070.xsd','./msxsdtest/identityConstraint',valid),
  STResList567 = [STRes566|STResList566],


  ?line {STRes567,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ071.xsd','./msxsdtest/identityConstraint',valid),
  STResList568 = [STRes567|STResList567],


  ?line {STRes568,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ072.xsd','./msxsdtest/identityConstraint',valid),
  STResList569 = [STRes568|STResList568],


  ?line {STRes569,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ073.xsd','./msxsdtest/identityConstraint',valid),
  STResList570 = [STRes569|STResList569],


  ?line {STRes570,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ074.xsd','./msxsdtest/identityConstraint',valid),
  STResList571 = [STRes570|STResList570],


  ?line {STRes571,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ075.xsd','./msxsdtest/identityConstraint',valid),
  STResList572 = [STRes571|STResList571],


  ?line {STRes572,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ076.xsd','./msxsdtest/identityConstraint',valid),
  STResList573 = [STRes572|STResList572],


  ?line {STRes573,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ077.xsd','./msxsdtest/identityConstraint',valid),
  STResList574 = [STRes573|STResList573],


  ?line {STRes574,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ078.xsd','./msxsdtest/identityConstraint',valid),
  STResList575 = [STRes574|STResList574],


  ?line {STRes575,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ079.xsd','./msxsdtest/identityConstraint',valid),
  STResList576 = [STRes575|STResList575],


  ?line {STRes576,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ080.xsd','./msxsdtest/identityConstraint',valid),
  STResList577 = [STRes576|STResList576],


  ?line {STRes577,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ081.xsd','./msxsdtest/identityConstraint',valid),
  STResList578 = [STRes577|STResList577],


  ?line {STRes578,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ082.xsd','./msxsdtest/identityConstraint',valid),
  STResList579 = [STRes578|STResList578],


  ?line {STRes579,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ083.xsd','./msxsdtest/identityConstraint',valid),
  STResList580 = [STRes579|STResList579],


  ?line {STRes580,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ084.xsd','./msxsdtest/identityConstraint',valid),
  STResList581 = [STRes580|STResList580],


  ?line {STRes581,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ085.xsd','./msxsdtest/identityConstraint',valid),
  STResList582 = [STRes581|STResList581],


  ?line {STRes582,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ086.xsd','./msxsdtest/identityConstraint',valid),
  STResList583 = [STRes582|STResList582],


  ?line {STRes583,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ087.xsd','./msxsdtest/identityConstraint',valid),
  STResList584 = [STRes583|STResList583],


  ?line {STRes584,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ088.xsd','./msxsdtest/identityConstraint',valid),
  STResList585 = [STRes584|STResList584],


  ?line {STRes585,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ089.xsd','./msxsdtest/identityConstraint',valid),
  STResList586 = [STRes585|STResList585],


  ?line {STRes586,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ090.xsd','./msxsdtest/identityConstraint',valid),
  STResList587 = [STRes586|STResList586],


  ?line {STRes587,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ091.xsd','./msxsdtest/identityConstraint',valid),
  STResList588 = [STRes587|STResList587],


  ?line {STRes588,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ092.xsd','./msxsdtest/identityConstraint',valid),
  STResList589 = [STRes588|STResList588],


  ?line {STRes589,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ093.xsd','./msxsdtest/identityConstraint',valid),
  STResList590 = [STRes589|STResList589],


  ?line {STRes590,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ094.xsd','./msxsdtest/identityConstraint',valid),
  STResList591 = [STRes590|STResList590],


  ?line {STRes591,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ095.xsd','./msxsdtest/identityConstraint',valid),
  STResList592 = [STRes591|STResList591],


  ?line {STRes592,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ096.xsd','./msxsdtest/identityConstraint',valid),
  STResList593 = [STRes592|STResList592],


  ?line {STRes593,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ097.xsd','./msxsdtest/identityConstraint',valid),
  STResList594 = [STRes593|STResList593],


  ?line {STRes594,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ098.xsd','./msxsdtest/identityConstraint',valid),
  STResList595 = [STRes594|STResList594],


  ?line {STRes595,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ099.xsd','./msxsdtest/identityConstraint',valid),
  STResList596 = [STRes595|STResList595],


  ?line {STRes596,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ100.xsd','./msxsdtest/identityConstraint',valid),
  STResList597 = [STRes596|STResList596],


  ?line {STRes597,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ101.xsd','./msxsdtest/identityConstraint',valid),
  STResList598 = [STRes597|STResList597],


  ?line {STRes598,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ102.xsd','./msxsdtest/identityConstraint',valid),
  STResList599 = [STRes598|STResList598],


  ?line {STRes599,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ103.xsd','./msxsdtest/identityConstraint',valid),
  STResList600 = [STRes599|STResList599],


  ?line {STRes600,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ104.xsd','./msxsdtest/identityConstraint',valid),
  STResList601 = [STRes600|STResList600],


  ?line {STRes601,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ105.xsd','./msxsdtest/identityConstraint',valid),
  STResList602 = [STRes601|STResList601],


  ?line {STRes602,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ106.xsd','./msxsdtest/identityConstraint',valid),
  STResList603 = [STRes602|STResList602],


  ?line {STRes603,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ107.xsd','./msxsdtest/identityConstraint',valid),
  STResList604 = [STRes603|STResList603],


  ?line {STRes604,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ108.xsd','./msxsdtest/identityConstraint',valid),
  STResList605 = [STRes604|STResList604],


  ?line {STRes605,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ109.xsd','./msxsdtest/identityConstraint',valid),
  STResList606 = [STRes605|STResList605],


  ?line {STRes606,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ110.xsd','./msxsdtest/identityConstraint',valid),
  STResList607 = [STRes606|STResList606],


  ?line {STRes607,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ111.xsd','./msxsdtest/identityConstraint',valid),
  STResList608 = [STRes607|STResList607],


  ?line {STRes608,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ112.xsd','./msxsdtest/identityConstraint',valid),
  STResList609 = [STRes608|STResList608],


  ?line {STRes609,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ113.xsd','./msxsdtest/identityConstraint',valid),
  STResList610 = [STRes609|STResList609],


  ?line {STRes610,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ114.xsd','./msxsdtest/identityConstraint',valid),
  STResList611 = [STRes610|STResList610],


  ?line {STRes611,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ115.xsd','./msxsdtest/identityConstraint',valid),
  STResList612 = [STRes611|STResList611],


  ?line {STRes612,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ116.xsd','./msxsdtest/identityConstraint',valid),
  STResList613 = [STRes612|STResList612],


  ?line {STRes613,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ117.xsd','./msxsdtest/identityConstraint',valid),
  STResList614 = [STRes613|STResList613],


  ?line {STRes614,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ118.xsd','./msxsdtest/identityConstraint',valid),
  STResList615 = [STRes614|STResList614],


  ?line {STRes615,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ119.xsd','./msxsdtest/identityConstraint',valid),
  STResList616 = [STRes615|STResList615],


  ?line {STRes616,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ120.xsd','./msxsdtest/identityConstraint',valid),
  STResList617 = [STRes616|STResList616],


  ?line {STRes617,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ121.xsd','./msxsdtest/identityConstraint',valid),
  STResList618 = [STRes617|STResList617],


  ?line {STRes618,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ122.xsd','./msxsdtest/identityConstraint',valid),
  STResList619 = [STRes618|STResList618],


  ?line {STRes619,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ123.xsd','./msxsdtest/identityConstraint',valid),
  STResList620 = [STRes619|STResList619],


  ?line {STRes620,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ124.xsd','./msxsdtest/identityConstraint',valid),
  STResList621 = [STRes620|STResList620],


  ?line {STRes621,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ125.xsd','./msxsdtest/identityConstraint',valid),
  STResList622 = [STRes621|STResList621],


  ?line {STRes622,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ126.xsd','./msxsdtest/identityConstraint',valid),
  STResList623 = [STRes622|STResList622],


  ?line {STRes623,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ127.xsd','./msxsdtest/identityConstraint',valid),
  STResList624 = [STRes623|STResList623],


  ?line {STRes624,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ128.xsd','./msxsdtest/identityConstraint',valid),
  STResList625 = [STRes624|STResList624],


  ?line {STRes625,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ129.xsd','./msxsdtest/identityConstraint',valid),
  STResList626 = [STRes625|STResList625],


  ?line {STRes626,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ130.xsd','./msxsdtest/identityConstraint',valid),
  STResList627 = [STRes626|STResList626],


  ?line {STRes627,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ131.xsd','./msxsdtest/identityConstraint',valid),
  STResList628 = [STRes627|STResList627],


  ?line {STRes628,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ132.xsd','./msxsdtest/identityConstraint',valid),
  STResList629 = [STRes628|STResList628],


  ?line {STRes629,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ133.xsd','./msxsdtest/identityConstraint',valid),
  STResList630 = [STRes629|STResList629],


  ?line {STRes630,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ134.xsd','./msxsdtest/identityConstraint',valid),
  STResList631 = [STRes630|STResList630],


  ?line {STRes631,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ135.xsd','./msxsdtest/identityConstraint',valid),
  STResList632 = [STRes631|STResList631],


  ?line {STRes632,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ136.xsd','./msxsdtest/identityConstraint',valid),
  STResList633 = [STRes632|STResList632],


  ?line {STRes633,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ137.xsd','./msxsdtest/identityConstraint',valid),
  STResList634 = [STRes633|STResList633],


  ?line {STRes634,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ138.xsd','./msxsdtest/identityConstraint',valid),
  STResList635 = [STRes634|STResList634],


  ?line {STRes635,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ139.xsd','./msxsdtest/identityConstraint',valid),
  STResList636 = [STRes635|STResList635],


  ?line {STRes636,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ140.xsd','./msxsdtest/identityConstraint',valid),
  STResList637 = [STRes636|STResList636],


  ?line {STRes637,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ141.xsd','./msxsdtest/identityConstraint',valid),
  STResList638 = [STRes637|STResList637],


  ?line {STRes638,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ142.xsd','./msxsdtest/identityConstraint',valid),
  STResList639 = [STRes638|STResList638],


  ?line {STRes639,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ143.xsd','./msxsdtest/identityConstraint',valid),
  STResList640 = [STRes639|STResList639],


  ?line {STRes640,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ144.xsd','./msxsdtest/identityConstraint',valid),
  STResList641 = [STRes640|STResList640],


  ?line {STRes641,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ145.xsd','./msxsdtest/identityConstraint',valid),
  STResList642 = [STRes641|STResList641],


  ?line {STRes642,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ146.xsd','./msxsdtest/identityConstraint',valid),
  STResList643 = [STRes642|STResList642],


  ?line {STRes643,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ147.xsd','./msxsdtest/identityConstraint',valid),
  STResList644 = [STRes643|STResList643],


  ?line {STRes644,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ148.xsd','./msxsdtest/identityConstraint',valid),
  STResList645 = [STRes644|STResList644],


  ?line {STRes645,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ149.xsd','./msxsdtest/identityConstraint',valid),
  STResList646 = [STRes645|STResList645],


  ?line {STRes646,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ150.xsd','./msxsdtest/identityConstraint',valid),
  STResList647 = [STRes646|STResList646],


  ?line {STRes647,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ151.xsd','./msxsdtest/identityConstraint',valid),
  STResList648 = [STRes647|STResList647],


  ?line {STRes648,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ152.xsd','./msxsdtest/identityConstraint',valid),
  STResList649 = [STRes648|STResList648],


  ?line {STRes649,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ153.xsd','./msxsdtest/identityConstraint',valid),
  STResList650 = [STRes649|STResList649],


  ?line {STRes650,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ154.xsd','./msxsdtest/identityConstraint',valid),
  STResList651 = [STRes650|STResList650],


  ?line {STRes651,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ155.xsd','./msxsdtest/identityConstraint',valid),
  STResList652 = [STRes651|STResList651],


  ?line {STRes652,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ156.xsd','./msxsdtest/identityConstraint',valid),
  STResList653 = [STRes652|STResList652],


  ?line {STRes653,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ157.xsd','./msxsdtest/identityConstraint',valid),
  STResList654 = [STRes653|STResList653],


  ?line {STRes654,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ158.xsd','./msxsdtest/identityConstraint',valid),
  STResList655 = [STRes654|STResList654],


  ?line {STRes655,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ159.xsd','./msxsdtest/identityConstraint',valid),
  STResList656 = [STRes655|STResList655],


  ?line {STRes656,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ160.xsd','./msxsdtest/identityConstraint',valid),
  STResList657 = [STRes656|STResList656],


  ?line {STRes657,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ161.xsd','./msxsdtest/identityConstraint',valid),
  STResList658 = [STRes657|STResList657],


  ?line {STRes658,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ162.xsd','./msxsdtest/identityConstraint',valid),
  STResList659 = [STRes658|STResList658],


  ?line {STRes659,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ163.xsd','./msxsdtest/identityConstraint',valid),
  STResList660 = [STRes659|STResList659],


  ?line {STRes660,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ164.xsd','./msxsdtest/identityConstraint',valid),
  STResList661 = [STRes660|STResList660],


  ?line {STRes661,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ165.xsd','./msxsdtest/identityConstraint',valid),
  STResList662 = [STRes661|STResList661],


  ?line {STRes662,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ166.xsd','./msxsdtest/identityConstraint',valid),
  STResList663 = [STRes662|STResList662],


  ?line {STRes663,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ167.xsd','./msxsdtest/identityConstraint',valid),
  STResList664 = [STRes663|STResList663],


  ?line {STRes664,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ168.xsd','./msxsdtest/identityConstraint',valid),
  STResList665 = [STRes664|STResList664],


  ?line {STRes665,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ169.xsd','./msxsdtest/identityConstraint',valid),
  STResList666 = [STRes665|STResList665],


  ?line {STRes666,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ170.xsd','./msxsdtest/identityConstraint',valid),
  STResList667 = [STRes666|STResList666],


  ?line {STRes667,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ171.xsd','./msxsdtest/identityConstraint',valid),
  STResList668 = [STRes667|STResList667],


  ?line {STRes668,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ172.xsd','./msxsdtest/identityConstraint',valid),
  STResList669 = [STRes668|STResList668],


  ?line {STRes669,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ173.xsd','./msxsdtest/identityConstraint',valid),
  STResList670 = [STRes669|STResList669],


  ?line {STRes670,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ174.xsd','./msxsdtest/identityConstraint',valid),
  STResList671 = [STRes670|STResList670],


  ?line {STRes671,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ175.xsd','./msxsdtest/identityConstraint',valid),
  STResList672 = [STRes671|STResList671],


  ?line {STRes672,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ176.xsd','./msxsdtest/identityConstraint',valid),
  STResList673 = [STRes672|STResList672],


  ?line {STRes673,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ177.xsd','./msxsdtest/identityConstraint',valid),
  STResList674 = [STRes673|STResList673],


  ?line {STRes674,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ178.xsd','./msxsdtest/identityConstraint',valid),
  STResList675 = [STRes674|STResList674],


  ?line {STRes675,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ179.xsd','./msxsdtest/identityConstraint',valid),
  STResList676 = [STRes675|STResList675],


  ?line {STRes676,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ180.xsd','./msxsdtest/identityConstraint',valid),
  STResList677 = [STRes676|STResList676],


  ?line {STRes677,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ181.xsd','./msxsdtest/identityConstraint',valid),
  STResList678 = [STRes677|STResList677],


  ?line {STRes678,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ182.xsd','./msxsdtest/identityConstraint',valid),
  STResList679 = [STRes678|STResList678],


  ?line {STRes679,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ183.xsd','./msxsdtest/identityConstraint',valid),
  STResList680 = [STRes679|STResList679],


  ?line {STRes680,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ184.xsd','./msxsdtest/identityConstraint',valid),
  STResList681 = [STRes680|STResList680],


  ?line {STRes681,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ185.xsd','./msxsdtest/identityConstraint',valid),
  STResList682 = [STRes681|STResList681],


  ?line {STRes682,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ186.xsd','./msxsdtest/identityConstraint',valid),
  STResList683 = [STRes682|STResList682],


  ?line {STRes683,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ187.xsd','./msxsdtest/identityConstraint',valid),
  STResList684 = [STRes683|STResList683],


  ?line {STRes684,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ188.xsd','./msxsdtest/identityConstraint',valid),
  STResList685 = [STRes684|STResList684],


  ?line {STRes685,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ189.xsd','./msxsdtest/identityConstraint',valid),
  STResList686 = [STRes685|STResList685],


  ?line {STRes686,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ190.xsd','./msxsdtest/identityConstraint',valid),
  STResList687 = [STRes686|STResList686],


  ?line {STRes687,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ191.xsd','./msxsdtest/identityConstraint',valid),
  STResList688 = [STRes687|STResList687],


  ?line {STRes688,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ192.xsd','./msxsdtest/identityConstraint',valid),
  STResList689 = [STRes688|STResList688],


  ?line {STRes689,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ193.xsd','./msxsdtest/identityConstraint',valid),
  STResList690 = [STRes689|STResList689],


  ?line {STRes690,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ194.xsd','./msxsdtest/identityConstraint',valid),
  STResList691 = [STRes690|STResList690],


  ?line {STRes691,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ195.xsd','./msxsdtest/identityConstraint',valid),
  STResList692 = [STRes691|STResList691],


  ?line {STRes692,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ196.xsd','./msxsdtest/identityConstraint',valid),
  STResList693 = [STRes692|STResList692],


  ?line {STRes693,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ197.xsd','./msxsdtest/identityConstraint',valid),
  STResList694 = [STRes693|STResList693],


  ?line {STRes694,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ198.xsd','./msxsdtest/identityConstraint',valid),
  STResList695 = [STRes694|STResList694],


  ?line {STRes695,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ199.xsd','./msxsdtest/identityConstraint',valid),
  STResList696 = [STRes695|STResList695],


  ?line {STRes696,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ200.xsd','./msxsdtest/identityConstraint',valid),
  STResList697 = [STRes696|STResList696],


  ?line {STRes697,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ201.xsd','./msxsdtest/identityConstraint',valid),
  STResList698 = [STRes697|STResList697],


  ?line {STRes698,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ202.xsd','./msxsdtest/identityConstraint',valid),
  STResList699 = [STRes698|STResList698],


  ?line {STRes699,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ203.xsd','./msxsdtest/identityConstraint',valid),
  STResList700 = [STRes699|STResList699],


  ?line {STRes700,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ204.xsd','./msxsdtest/identityConstraint',valid),
  STResList701 = [STRes700|STResList700],


  ?line {STRes701,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ205.xsd','./msxsdtest/identityConstraint',invalid),
  STResList702 = [STRes701|STResList701],


  ?line {STRes702,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ206.xsd','./msxsdtest/identityConstraint',invalid),
  STResList703 = [STRes702|STResList702],


  ?line {STRes703,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ207.xsd','./msxsdtest/identityConstraint',invalid),
  STResList704 = [STRes703|STResList703],


  ?line {STRes704,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ208.xsd','./msxsdtest/identityConstraint',invalid),
  STResList705 = [STRes704|STResList704],


  ?line {STRes705,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ209.xsd','./msxsdtest/identityConstraint',invalid),
  STResList706 = [STRes705|STResList705],


  ?line {STRes706,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idJ210.xsd','./msxsdtest/identityConstraint',invalid),
  STResList707 = [STRes706|STResList706],


  ?line {STRes707,S707} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK001.xsd','./msxsdtest/identityConstraint',valid),
  STResList708 = [STRes707|STResList707],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK001.xml','./msxsdtest/identityConstraint',valid,S707),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes708,S708} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK002.xsd','./msxsdtest/identityConstraint',valid),
  STResList709 = [STRes708|STResList708],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK002.xml','./msxsdtest/identityConstraint',valid,S708),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes709,S709} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK003.xsd','./msxsdtest/identityConstraint',valid),
  STResList710 = [STRes709|STResList709],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK003.xml','./msxsdtest/identityConstraint',invalid,S709),
  ITResList96 = [ITRes95|ITResList95],


  ?line {STRes710,S710} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK004.xsd','./msxsdtest/identityConstraint',valid),
  STResList711 = [STRes710|STResList710],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK004.xml','./msxsdtest/identityConstraint',valid,S710),
  ITResList97 = [ITRes96|ITResList96],


  ?line {STRes711,S711} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK005.xsd','./msxsdtest/identityConstraint',valid),
  STResList712 = [STRes711|STResList711],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK005.xml','./msxsdtest/identityConstraint',valid,S711),
  ITResList98 = [ITRes97|ITResList97],


  ?line {STRes712,S712} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK006.xsd','./msxsdtest/identityConstraint',valid),
  STResList713 = [STRes712|STResList712],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK006.xml','./msxsdtest/identityConstraint',valid,S712),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes713,S713} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK007.xsd','./msxsdtest/identityConstraint',valid),
  STResList714 = [STRes713|STResList713],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK007.xml','./msxsdtest/identityConstraint',valid,S713),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes714,S714} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK008.xsd','./msxsdtest/identityConstraint',valid),
  STResList715 = [STRes714|STResList714],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK008.xml','./msxsdtest/identityConstraint',valid,S714),
  ITResList101 = [ITRes100|ITResList100],


  ?line {STRes715,S715} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK009.xsd','./msxsdtest/identityConstraint',valid),
  STResList716 = [STRes715|STResList715],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK009.xml','./msxsdtest/identityConstraint',valid,S715),
  ITResList102 = [ITRes101|ITResList101],


  ?line {STRes716,S716} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK010.xsd','./msxsdtest/identityConstraint',valid),
  STResList717 = [STRes716|STResList716],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK010.xml','./msxsdtest/identityConstraint',valid,S716),
  ITResList103 = [ITRes102|ITResList102],


  ?line {STRes717,S717} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK011.xsd','./msxsdtest/identityConstraint',valid),
  STResList718 = [STRes717|STResList717],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK011.xml','./msxsdtest/identityConstraint',valid,S717),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes718,S718} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK012.xsd','./msxsdtest/identityConstraint',valid),
  STResList719 = [STRes718|STResList718],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK012.xml','./msxsdtest/identityConstraint',invalid,S718),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes719,S719} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK013.xsd','./msxsdtest/identityConstraint',valid),
  STResList720 = [STRes719|STResList719],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK013.xml','./msxsdtest/identityConstraint',valid,S719),
  ITResList106 = [ITRes105|ITResList105],


  ?line {STRes720,S720} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK014.xsd','./msxsdtest/identityConstraint',valid),
  STResList721 = [STRes720|STResList720],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK014.xml','./msxsdtest/identityConstraint',valid,S720),
  ITResList107 = [ITRes106|ITResList106],


  ?line {STRes721,S721} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK015.xsd','./msxsdtest/identityConstraint',valid),
  STResList722 = [STRes721|STResList721],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK015.xml','./msxsdtest/identityConstraint',valid,S721),
  ITResList108 = [ITRes107|ITResList107],


  ?line {STRes722,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK016.xsd','./msxsdtest/identityConstraint',invalid),
  STResList723 = [STRes722|STResList722],


  ?line {STRes723,S723} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idK017.xsd','./msxsdtest/identityConstraint',valid),
  STResList724 = [STRes723|STResList723],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idK017.xml','./msxsdtest/identityConstraint',valid,S723),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes724,S724} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL001.xsd','./msxsdtest/identityConstraint',valid),
  STResList725 = [STRes724|STResList724],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL001.xml','./msxsdtest/identityConstraint',valid,S724),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes725,S725} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL002.xsd','./msxsdtest/identityConstraint',valid),
  STResList726 = [STRes725|STResList725],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL002.xml','./msxsdtest/identityConstraint',invalid,S725),
  ITResList111 = [ITRes110|ITResList110],


  ?line {STRes726,S726} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL003.xsd','./msxsdtest/identityConstraint',valid),
  STResList727 = [STRes726|STResList726],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL003.xml','./msxsdtest/identityConstraint',valid,S726),
  ITResList112 = [ITRes111|ITResList111],


  ?line {STRes727,S727} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL004.xsd','./msxsdtest/identityConstraint',valid),
  STResList728 = [STRes727|STResList727],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL004.xml','./msxsdtest/identityConstraint',valid,S727),
  ITResList113 = [ITRes112|ITResList112],


  ?line {STRes728,S728} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL005.xsd','./msxsdtest/identityConstraint',valid),
  STResList729 = [STRes728|STResList728],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL005.xml','./msxsdtest/identityConstraint',valid,S728),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes729,S729} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL006.xsd','./msxsdtest/identityConstraint',valid),
  STResList730 = [STRes729|STResList729],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL006.xml','./msxsdtest/identityConstraint',invalid,S729),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes730,S730} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL007.xsd','./msxsdtest/identityConstraint',valid),
  STResList731 = [STRes730|STResList730],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL007.xml','./msxsdtest/identityConstraint',invalid,S730),
  ITResList116 = [ITRes115|ITResList115],


  ?line {STRes731,S731} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL008.xsd','./msxsdtest/identityConstraint',valid),
  STResList732 = [STRes731|STResList731],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL008.xml','./msxsdtest/identityConstraint',valid,S731),
  ITResList117 = [ITRes116|ITResList116],


  ?line {STRes732,S732} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL009.xsd','./msxsdtest/identityConstraint',valid),
  STResList733 = [STRes732|STResList732],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL009.xml','./msxsdtest/identityConstraint',valid,S732),
  ITResList118 = [ITRes117|ITResList117],


  ?line {STRes733,S733} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL010.xsd','./msxsdtest/identityConstraint',valid),
  STResList734 = [STRes733|STResList733],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL010.xml','./msxsdtest/identityConstraint',valid,S733),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes734,S734} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL011.xsd','./msxsdtest/identityConstraint',valid),
  STResList735 = [STRes734|STResList734],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL011.xml','./msxsdtest/identityConstraint',invalid,S734),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes735,S735} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL012.xsd','./msxsdtest/identityConstraint',valid),
  STResList736 = [STRes735|STResList735],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL012.xml','./msxsdtest/identityConstraint',invalid,S735),
  ITResList121 = [ITRes120|ITResList120],


  ?line {STRes736,S736} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL013.xsd','./msxsdtest/identityConstraint',valid),
  STResList737 = [STRes736|STResList736],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL013.xml','./msxsdtest/identityConstraint',valid,S736),
  ITResList122 = [ITRes121|ITResList121],


  ?line {STRes737,S737} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL014.xsd','./msxsdtest/identityConstraint',valid),
  STResList738 = [STRes737|STResList737],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL014.xml','./msxsdtest/identityConstraint',valid,S737),
  ITResList123 = [ITRes122|ITResList122],


  ?line {STRes738,S738} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL015.xsd','./msxsdtest/identityConstraint',valid),
  STResList739 = [STRes738|STResList738],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL015.xml','./msxsdtest/identityConstraint',invalid,S738),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes739,S739} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL016.xsd','./msxsdtest/identityConstraint',valid),
  STResList740 = [STRes739|STResList739],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL016.xml','./msxsdtest/identityConstraint',valid,S739),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes740,S740} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL017.xsd','./msxsdtest/identityConstraint',valid),
  STResList741 = [STRes740|STResList740],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL017.xml','./msxsdtest/identityConstraint',valid,S740),
  ITResList126 = [ITRes125|ITResList125],


  ?line {STRes741,S741} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL018.xsd','./msxsdtest/identityConstraint',valid),
  STResList742 = [STRes741|STResList741],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL018.xml','./msxsdtest/identityConstraint',valid,S741),
  ITResList127 = [ITRes126|ITResList126],


  ?line {STRes742,S742} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL019.xsd','./msxsdtest/identityConstraint',valid),
  STResList743 = [STRes742|STResList742],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL019.xml','./msxsdtest/identityConstraint',invalid,S742),
  ITResList128 = [ITRes127|ITResList127],


  ?line {STRes743,S743} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL020.xsd','./msxsdtest/identityConstraint',valid),
  STResList744 = [STRes743|STResList743],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL020.xml','./msxsdtest/identityConstraint',valid,S743),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes744,S744} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL021.xsd','./msxsdtest/identityConstraint',valid),
  STResList745 = [STRes744|STResList744],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL021.xml','./msxsdtest/identityConstraint',valid,S744),
  ITResList130 = [ITRes129|ITResList129],


  ?line {STRes745,S745} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL022.xsd','./msxsdtest/identityConstraint',valid),
  STResList746 = [STRes745|STResList745],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL022.xml','./msxsdtest/identityConstraint',invalid,S745),
  ITResList131 = [ITRes130|ITResList130],


  ?line {STRes746,S746} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL023.xsd','./msxsdtest/identityConstraint',valid),
  STResList747 = [STRes746|STResList746],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL023.xml','./msxsdtest/identityConstraint',valid,S746),
  ITResList132 = [ITRes131|ITResList131],


  ?line {STRes747,S747} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL024.xsd','./msxsdtest/identityConstraint',valid),
  STResList748 = [STRes747|STResList747],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL024.xml','./msxsdtest/identityConstraint',valid,S747),
  ITResList133 = [ITRes132|ITResList132],


  ?line {STRes748,S748} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL025.xsd','./msxsdtest/identityConstraint',valid),
  STResList749 = [STRes748|STResList748],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL025.xml','./msxsdtest/identityConstraint',invalid,S748),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes749,S749} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL026.xsd','./msxsdtest/identityConstraint',valid),
  STResList750 = [STRes749|STResList749],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL026.xml','./msxsdtest/identityConstraint',valid,S749),
  ITResList135 = [ITRes134|ITResList134],


  ?line {STRes750,S750} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL027.xsd','./msxsdtest/identityConstraint',valid),
  STResList751 = [STRes750|STResList750],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL027.xml','./msxsdtest/identityConstraint',invalid,S750),
  ITResList136 = [ITRes135|ITResList135],


  ?line {STRes751,S751} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL028.xsd','./msxsdtest/identityConstraint',valid),
  STResList752 = [STRes751|STResList751],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL028.xml','./msxsdtest/identityConstraint',valid,S751),
  ITResList137 = [ITRes136|ITResList136],


  ?line {STRes752,S752} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL029.xsd','./msxsdtest/identityConstraint',valid),
  STResList753 = [STRes752|STResList752],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL029.xml','./msxsdtest/identityConstraint',valid,S752),
  ITResList138 = [ITRes137|ITResList137],


  ?line {STRes753,S753} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL030.xsd','./msxsdtest/identityConstraint',valid),
  STResList754 = [STRes753|STResList753],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL030.xml','./msxsdtest/identityConstraint',valid,S753),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes754,S754} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL031.xsd','./msxsdtest/identityConstraint',valid),
  STResList755 = [STRes754|STResList754],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL031.xml','./msxsdtest/identityConstraint',invalid,S754),
  ITResList140 = [ITRes139|ITResList139],


  ?line {STRes755,S755} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL032.xsd','./msxsdtest/identityConstraint',valid),
  STResList756 = [STRes755|STResList755],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL032.xml','./msxsdtest/identityConstraint',invalid,S755),
  ITResList141 = [ITRes140|ITResList140],


  ?line {STRes756,S756} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL033.xsd','./msxsdtest/identityConstraint',valid),
  STResList757 = [STRes756|STResList756],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL033.xml','./msxsdtest/identityConstraint',valid,S756),
  ITResList142 = [ITRes141|ITResList141],


  ?line {STRes757,S757} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL034.xsd','./msxsdtest/identityConstraint',valid),
  STResList758 = [STRes757|STResList757],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL034.xml','./msxsdtest/identityConstraint',valid,S757),
  ITResList143 = [ITRes142|ITResList142],


  ?line {STRes758,S758} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL035.xsd','./msxsdtest/identityConstraint',valid),
  STResList759 = [STRes758|STResList758],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL035.xml','./msxsdtest/identityConstraint',valid,S758),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes759,S759} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL036.xsd','./msxsdtest/identityConstraint',valid),
  STResList760 = [STRes759|STResList759],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL036.xml','./msxsdtest/identityConstraint',invalid,S759),
  ITResList145 = [ITRes144|ITResList144],


  ?line {STRes760,S760} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL037.xsd','./msxsdtest/identityConstraint',valid),
  STResList761 = [STRes760|STResList760],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL037.xml','./msxsdtest/identityConstraint',invalid,S760),
  ITResList146 = [ITRes145|ITResList145],


  ?line {STRes761,S761} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL038.xsd','./msxsdtest/identityConstraint',valid),
  STResList762 = [STRes761|STResList761],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL038.xml','./msxsdtest/identityConstraint',valid,S761),
  ITResList147 = [ITRes146|ITResList146],


  ?line {STRes762,S762} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL039.xsd','./msxsdtest/identityConstraint',valid),
  STResList763 = [STRes762|STResList762],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL039.xml','./msxsdtest/identityConstraint',valid,S762),
  ITResList148 = [ITRes147|ITResList147],


  ?line {STRes763,S763} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL040.xsd','./msxsdtest/identityConstraint',valid),
  STResList764 = [STRes763|STResList763],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL040.xml','./msxsdtest/identityConstraint',invalid,S763),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes764,S764} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL041.xsd','./msxsdtest/identityConstraint',valid),
  STResList765 = [STRes764|STResList764],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL041.xml','./msxsdtest/identityConstraint',valid,S764),
  ITResList150 = [ITRes149|ITResList149],


  ?line {STRes765,S765} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL042.xsd','./msxsdtest/identityConstraint',valid),
  STResList766 = [STRes765|STResList765],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL042.xml','./msxsdtest/identityConstraint',valid,S765),
  ITResList151 = [ITRes150|ITResList150],


  ?line {STRes766,S766} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL043.xsd','./msxsdtest/identityConstraint',valid),
  STResList767 = [STRes766|STResList766],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL043.xml','./msxsdtest/identityConstraint',valid,S766),
  ITResList152 = [ITRes151|ITResList151],


  ?line {STRes767,S767} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL044.xsd','./msxsdtest/identityConstraint',valid),
  STResList768 = [STRes767|STResList767],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL044.xml','./msxsdtest/identityConstraint',invalid,S767),
  ITResList153 = [ITRes152|ITResList152],


  ?line {STRes768,S768} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL045.xsd','./msxsdtest/identityConstraint',valid),
  STResList769 = [STRes768|STResList768],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL045.xml','./msxsdtest/identityConstraint',valid,S768),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes769,S769} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL046.xsd','./msxsdtest/identityConstraint',valid),
  STResList770 = [STRes769|STResList769],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL046.xml','./msxsdtest/identityConstraint',valid,S769),
  ITResList155 = [ITRes154|ITResList154],


  ?line {STRes770,S770} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL047.xsd','./msxsdtest/identityConstraint',valid),
  STResList771 = [STRes770|STResList770],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL047.xml','./msxsdtest/identityConstraint',invalid,S770),
  ITResList156 = [ITRes155|ITResList155],


  ?line {STRes771,S771} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL048.xsd','./msxsdtest/identityConstraint',valid),
  STResList772 = [STRes771|STResList771],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL048.xml','./msxsdtest/identityConstraint',valid,S771),
  ITResList157 = [ITRes156|ITResList156],


  ?line {STRes772,S772} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL049.xsd','./msxsdtest/identityConstraint',valid),
  STResList773 = [STRes772|STResList772],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL049.xml','./msxsdtest/identityConstraint',valid,S772),
  ITResList158 = [ITRes157|ITResList157],


  ?line {STRes773,S773} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL050.xsd','./msxsdtest/identityConstraint',valid),
  STResList774 = [STRes773|STResList773],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL050.xml','./msxsdtest/identityConstraint',invalid,S773),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes774,S774} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL051.xsd','./msxsdtest/identityConstraint',valid),
  STResList775 = [STRes774|STResList774],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL051.xml','./msxsdtest/identityConstraint',valid,S774),
  ITResList160 = [ITRes159|ITResList159],


  ?line {STRes775,S775} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL052.xsd','./msxsdtest/identityConstraint',valid),
  STResList776 = [STRes775|STResList775],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL052.xml','./msxsdtest/identityConstraint',invalid,S775),
  ITResList161 = [ITRes160|ITResList160],


  ?line {STRes776,S776} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL053.xsd','./msxsdtest/identityConstraint',valid),
  STResList777 = [STRes776|STResList776],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL053.xml','./msxsdtest/identityConstraint',valid,S776),
  ITResList162 = [ITRes161|ITResList161],


  ?line {STRes777,S777} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL054.xsd','./msxsdtest/identityConstraint',valid),
  STResList778 = [STRes777|STResList777],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL054.xml','./msxsdtest/identityConstraint',valid,S777),
  ITResList163 = [ITRes162|ITResList162],


  ?line {STRes778,S778} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL055.xsd','./msxsdtest/identityConstraint',valid),
  STResList779 = [STRes778|STResList778],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL055.xml','./msxsdtest/identityConstraint',valid,S778),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes779,S779} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL056.xsd','./msxsdtest/identityConstraint',valid),
  STResList780 = [STRes779|STResList779],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL056.xml','./msxsdtest/identityConstraint',invalid,S779),
  ITResList165 = [ITRes164|ITResList164],


  ?line {STRes780,S780} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL057.xsd','./msxsdtest/identityConstraint',valid),
  STResList781 = [STRes780|STResList780],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL057.xml','./msxsdtest/identityConstraint',invalid,S780),
  ITResList166 = [ITRes165|ITResList165],


  ?line {STRes781,S781} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL058.xsd','./msxsdtest/identityConstraint',valid),
  STResList782 = [STRes781|STResList781],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL058.xml','./msxsdtest/identityConstraint',valid,S781),
  ITResList167 = [ITRes166|ITResList166],


  ?line {STRes782,S782} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL059.xsd','./msxsdtest/identityConstraint',valid),
  STResList783 = [STRes782|STResList782],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL059.xml','./msxsdtest/identityConstraint',valid,S782),
  ITResList168 = [ITRes167|ITResList167],


  ?line {STRes783,S783} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL060.xsd','./msxsdtest/identityConstraint',valid),
  STResList784 = [STRes783|STResList783],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL060.xml','./msxsdtest/identityConstraint',valid,S783),
  ITResList169 = [ITRes168|ITResList168],


  ?line {STRes784,S784} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL061.xsd','./msxsdtest/identityConstraint',valid),
  STResList785 = [STRes784|STResList784],
  ?line ITRes169 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL061.xml','./msxsdtest/identityConstraint',invalid,S784),
  ITResList170 = [ITRes169|ITResList169],


  ?line {STRes785,S785} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL062.xsd','./msxsdtest/identityConstraint',valid),
  STResList786 = [STRes785|STResList785],
  ?line ITRes170 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL062.xml','./msxsdtest/identityConstraint',invalid,S785),
  ITResList171 = [ITRes170|ITResList170],


  ?line {STRes786,S786} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL063.xsd','./msxsdtest/identityConstraint',valid),
  STResList787 = [STRes786|STResList786],
  ?line ITRes171 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL063.xml','./msxsdtest/identityConstraint',valid,S786),
  ITResList172 = [ITRes171|ITResList171],


  ?line {STRes787,S787} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL064.xsd','./msxsdtest/identityConstraint',valid),
  STResList788 = [STRes787|STResList787],
  ?line ITRes172 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL064.xml','./msxsdtest/identityConstraint',valid,S787),
  ITResList173 = [ITRes172|ITResList172],


  ?line {STRes788,S788} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL065.xsd','./msxsdtest/identityConstraint',valid),
  STResList789 = [STRes788|STResList788],
  ?line ITRes173 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL065.xml','./msxsdtest/identityConstraint',invalid,S788),
  ITResList174 = [ITRes173|ITResList173],


  ?line {STRes789,S789} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL066.xsd','./msxsdtest/identityConstraint',valid),
  STResList790 = [STRes789|STResList789],
  ?line ITRes174 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL066.xml','./msxsdtest/identityConstraint',valid,S789),
  ITResList175 = [ITRes174|ITResList174],


  ?line {STRes790,S790} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL067.xsd','./msxsdtest/identityConstraint',valid),
  STResList791 = [STRes790|STResList790],
  ?line ITRes175 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL067.xml','./msxsdtest/identityConstraint',valid,S790),
  ITResList176 = [ITRes175|ITResList175],


  ?line {STRes791,S791} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL068.xsd','./msxsdtest/identityConstraint',valid),
  STResList792 = [STRes791|STResList791],
  ?line ITRes176 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL068.xml','./msxsdtest/identityConstraint',valid,S791),
  ITResList177 = [ITRes176|ITResList176],


  ?line {STRes792,S792} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL069.xsd','./msxsdtest/identityConstraint',valid),
  STResList793 = [STRes792|STResList792],
  ?line ITRes177 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL069.xml','./msxsdtest/identityConstraint',invalid,S792),
  ITResList178 = [ITRes177|ITResList177],


  ?line {STRes793,S793} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL070.xsd','./msxsdtest/identityConstraint',valid),
  STResList794 = [STRes793|STResList793],
  ?line ITRes178 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL070.xml','./msxsdtest/identityConstraint',valid,S793),
  ITResList179 = [ITRes178|ITResList178],


  ?line {STRes794,S794} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL071.xsd','./msxsdtest/identityConstraint',valid),
  STResList795 = [STRes794|STResList794],
  ?line ITRes179 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL071.xml','./msxsdtest/identityConstraint',valid,S794),
  ITResList180 = [ITRes179|ITResList179],


  ?line {STRes795,S795} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL072.xsd','./msxsdtest/identityConstraint',valid),
  STResList796 = [STRes795|STResList795],
  ?line ITRes180 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL072.xml','./msxsdtest/identityConstraint',invalid,S795),
  ITResList181 = [ITRes180|ITResList180],


  ?line {STRes796,S796} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL073.xsd','./msxsdtest/identityConstraint',valid),
  STResList797 = [STRes796|STResList796],
  ?line ITRes181 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL073.xml','./msxsdtest/identityConstraint',valid,S796),
  ITResList182 = [ITRes181|ITResList181],


  ?line {STRes797,S797} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL074.xsd','./msxsdtest/identityConstraint',valid),
  STResList798 = [STRes797|STResList797],
  ?line ITRes182 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL074.xml','./msxsdtest/identityConstraint',valid,S797),
  ITResList183 = [ITRes182|ITResList182],


  ?line {STRes798,S798} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL075.xsd','./msxsdtest/identityConstraint',valid),
  STResList799 = [STRes798|STResList798],
  ?line ITRes183 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL075.xml','./msxsdtest/identityConstraint',invalid,S798),
  ITResList184 = [ITRes183|ITResList183],


  ?line {STRes799,S799} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL076.xsd','./msxsdtest/identityConstraint',valid),
  STResList800 = [STRes799|STResList799],
  ?line ITRes184 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL076.xml','./msxsdtest/identityConstraint',valid,S799),
  ITResList185 = [ITRes184|ITResList184],


  ?line {STRes800,S800} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL077.xsd','./msxsdtest/identityConstraint',valid),
  STResList801 = [STRes800|STResList800],
  ?line ITRes185 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL077.xml','./msxsdtest/identityConstraint',valid,S800),
  ITResList186 = [ITRes185|ITResList185],


  ?line {STRes801,S801} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL078.xsd','./msxsdtest/identityConstraint',valid),
  STResList802 = [STRes801|STResList801],
  ?line ITRes186 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL078.xml','./msxsdtest/identityConstraint',valid,S801),
  ITResList187 = [ITRes186|ITResList186],


  ?line {STRes802,S802} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL079.xsd','./msxsdtest/identityConstraint',valid),
  STResList803 = [STRes802|STResList802],
  ?line ITRes187 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL079.xml','./msxsdtest/identityConstraint',invalid,S802),
  ITResList188 = [ITRes187|ITResList187],


  ?line {STRes803,S803} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL080.xsd','./msxsdtest/identityConstraint',valid),
  STResList804 = [STRes803|STResList803],
  ?line ITRes188 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL080.xml','./msxsdtest/identityConstraint',invalid,S803),
  ITResList189 = [ITRes188|ITResList188],


  ?line {STRes804,S804} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL081.xsd','./msxsdtest/identityConstraint',valid),
  STResList805 = [STRes804|STResList804],
  ?line ITRes189 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL081.xml','./msxsdtest/identityConstraint',invalid,S804),
  ITResList190 = [ITRes189|ITResList189],


  ?line {STRes805,S805} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL082.xsd','./msxsdtest/identityConstraint',valid),
  STResList806 = [STRes805|STResList805],
  ?line ITRes190 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL082.xml','./msxsdtest/identityConstraint',valid,S805),
  ITResList191 = [ITRes190|ITResList190],


  ?line {STRes806,S806} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL083.xsd','./msxsdtest/identityConstraint',valid),
  STResList807 = [STRes806|STResList806],
  ?line ITRes191 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL083.xml','./msxsdtest/identityConstraint',invalid,S806),
  ITResList192 = [ITRes191|ITResList191],


  ?line {STRes807,S807} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL084.xsd','./msxsdtest/identityConstraint',valid),
  STResList808 = [STRes807|STResList807],
  ?line ITRes192 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL084.xml','./msxsdtest/identityConstraint',valid,S807),
  ITResList193 = [ITRes192|ITResList192],


  ?line {STRes808,S808} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL085.xsd','./msxsdtest/identityConstraint',valid),
  STResList809 = [STRes808|STResList808],
  ?line ITRes193 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL085.xml','./msxsdtest/identityConstraint',invalid,S808),
  ITResList194 = [ITRes193|ITResList193],


  ?line {STRes809,S809} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL086.xsd','./msxsdtest/identityConstraint',valid),
  STResList810 = [STRes809|STResList809],
  ?line ITRes194 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL086.xml','./msxsdtest/identityConstraint',valid,S809),
  ITResList195 = [ITRes194|ITResList194],


  ?line {STRes810,S810} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL087.xsd','./msxsdtest/identityConstraint',valid),
  STResList811 = [STRes810|STResList810],
  ?line ITRes195 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL087.xml','./msxsdtest/identityConstraint',invalid,S810),
  ITResList196 = [ITRes195|ITResList195],


  ?line {STRes811,S811} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL088.xsd','./msxsdtest/identityConstraint',valid),
  STResList812 = [STRes811|STResList811],
  ?line ITRes196 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL088.xml','./msxsdtest/identityConstraint',valid,S811),
  ITResList197 = [ITRes196|ITResList196],


  ?line {STRes812,S812} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL089.xsd','./msxsdtest/identityConstraint',valid),
  STResList813 = [STRes812|STResList812],
  ?line ITRes197 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL089.xml','./msxsdtest/identityConstraint',invalid,S812),
  ITResList198 = [ITRes197|ITResList197],


  ?line {STRes813,S813} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL090.xsd','./msxsdtest/identityConstraint',valid),
  STResList814 = [STRes813|STResList813],
  ?line ITRes198 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL090.xml','./msxsdtest/identityConstraint',valid,S813),
  ITResList199 = [ITRes198|ITResList198],


  ?line {STRes814,S814} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL091.xsd','./msxsdtest/identityConstraint',valid),
  STResList815 = [STRes814|STResList814],
  ?line ITRes199 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL091.xml','./msxsdtest/identityConstraint',invalid,S814),
  ITResList200 = [ITRes199|ITResList199],


  ?line {STRes815,S815} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL092.xsd','./msxsdtest/identityConstraint',valid),
  STResList816 = [STRes815|STResList815],
  ?line ITRes200 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL092.xml','./msxsdtest/identityConstraint',valid,S815),
  ITResList201 = [ITRes200|ITResList200],


  ?line {STRes816,S816} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL093.xsd','./msxsdtest/identityConstraint',valid),
  STResList817 = [STRes816|STResList816],
  ?line ITRes201 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL093.xml','./msxsdtest/identityConstraint',invalid,S816),
  ITResList202 = [ITRes201|ITResList201],


  ?line {STRes817,S817} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL094.xsd','./msxsdtest/identityConstraint',valid),
  STResList818 = [STRes817|STResList817],
  ?line ITRes202 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL094.xml','./msxsdtest/identityConstraint',valid,S817),
  ITResList203 = [ITRes202|ITResList202],


  ?line {STRes818,S818} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL095.xsd','./msxsdtest/identityConstraint',valid),
  STResList819 = [STRes818|STResList818],
  ?line ITRes203 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL095.xml','./msxsdtest/identityConstraint',invalid,S818),
  ITResList204 = [ITRes203|ITResList203],


  ?line {STRes819,S819} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL096.xsd','./msxsdtest/identityConstraint',valid),
  STResList820 = [STRes819|STResList819],
  ?line ITRes204 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL096.xml','./msxsdtest/identityConstraint',valid,S819),
  ITResList205 = [ITRes204|ITResList204],


  ?line {STRes820,S820} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL097.xsd','./msxsdtest/identityConstraint',valid),
  STResList821 = [STRes820|STResList820],
  ?line ITRes205 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL097.xml','./msxsdtest/identityConstraint',invalid,S820),
  ITResList206 = [ITRes205|ITResList205],


  ?line {STRes821,S821} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL098.xsd','./msxsdtest/identityConstraint',valid),
  STResList822 = [STRes821|STResList821],
  ?line ITRes206 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL098.xml','./msxsdtest/identityConstraint',valid,S821),
  ITResList207 = [ITRes206|ITResList206],


  ?line {STRes822,S822} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL099.xsd','./msxsdtest/identityConstraint',valid),
  STResList823 = [STRes822|STResList822],
  ?line ITRes207 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL099.xml','./msxsdtest/identityConstraint',invalid,S822),
  ITResList208 = [ITRes207|ITResList207],


  ?line {STRes823,S823} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL100.xsd','./msxsdtest/identityConstraint',valid),
  STResList824 = [STRes823|STResList823],
  ?line ITRes208 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL100.xml','./msxsdtest/identityConstraint',valid,S823),
  ITResList209 = [ITRes208|ITResList208],


  ?line {STRes824,S824} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL101.xsd','./msxsdtest/identityConstraint',valid),
  STResList825 = [STRes824|STResList824],
  ?line ITRes209 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL101.xml','./msxsdtest/identityConstraint',invalid,S824),
  ITResList210 = [ITRes209|ITResList209],


  ?line {STRes825,S825} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL102.xsd','./msxsdtest/identityConstraint',valid),
  STResList826 = [STRes825|STResList825],
  ?line ITRes210 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL102.xml','./msxsdtest/identityConstraint',valid,S825),
  ITResList211 = [ITRes210|ITResList210],


  ?line {STRes826,S826} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idL103.xsd','./msxsdtest/identityConstraint',valid),
  STResList827 = [STRes826|STResList826],
  ?line ITRes211 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idL103.xml','./msxsdtest/identityConstraint',invalid,S826),
  ITResList212 = [ITRes211|ITResList211],


  ?line {STRes827,S827} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idZ001.xsd','./msxsdtest/identityConstraint',valid),
  STResList828 = [STRes827|STResList827],
  ?line ITRes212 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idZ001.xml','./msxsdtest/identityConstraint',invalid,S827),
  ITResList213 = [ITRes212|ITResList212],


  ?line {STRes828,S828} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idZ002.xsd','./msxsdtest/identityConstraint',valid),
  STResList829 = [STRes828|STResList828],
  ?line ITRes213 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idZ002.xml','./msxsdtest/identityConstraint',invalid,S828),
  ITResList214 = [ITRes213|ITResList213],




  ?line {STRes829,S829} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/identityConstraint/idZ004.xsd','./msxsdtest/identityConstraint',valid),
  STResList830 = [STRes829|STResList829],
  ?line ITRes214 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/identityConstraint/idZ004.xml','./msxsdtest/identityConstraint',invalid,S829),
  ITResList215 = [ITRes214|ITResList214],


  xmerl_xsd_lib:compare_test_results(Config,STResList830,ITResList215).

%% model groups (ALL).

mgABCD(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA001.xsd','./msxsdtest/ModelGroups',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgA001.xml','./msxsdtest/ModelGroups',valid,S0),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes1,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList2 = [STRes1|STResList1],


  ?line {STRes2,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList3 = [STRes2|STResList2],


  ?line {STRes3,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA004.xsd','./msxsdtest/ModelGroups',invalid),
  STResList4 = [STRes3|STResList3],


  ?line {STRes4,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA005.xsd','./msxsdtest/ModelGroups',invalid),
  STResList5 = [STRes4|STResList4],


  ?line {STRes5,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA006.xsd','./msxsdtest/ModelGroups',invalid),
  STResList6 = [STRes5|STResList5],


  ?line {STRes6,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList7 = [STRes6|STResList6],


  ?line {STRes7,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList8 = [STRes7|STResList7],


  ?line {STRes8,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA009.xsd','./msxsdtest/ModelGroups',invalid),
  STResList9 = [STRes8|STResList8],


  ?line {STRes9,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA010.xsd','./msxsdtest/ModelGroups',invalid),
  STResList10 = [STRes9|STResList9],


  ?line {STRes10,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA011.xsd','./msxsdtest/ModelGroups',invalid),
  STResList11 = [STRes10|STResList10],


  ?line {STRes11,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA012.xsd','./msxsdtest/ModelGroups',invalid),
  STResList12 = [STRes11|STResList11],


  ?line {STRes12,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA013.xsd','./msxsdtest/ModelGroups',invalid),
  STResList13 = [STRes12|STResList12],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA014.xsd','./msxsdtest/ModelGroups',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgA014.xml','./msxsdtest/ModelGroups',valid,S13),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA015.xsd','./msxsdtest/ModelGroups',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgA015.xml','./msxsdtest/ModelGroups',valid,S14),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA016.xsd','./msxsdtest/ModelGroups',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgA016.xml','./msxsdtest/ModelGroups',valid,S15),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA017.xsd','./msxsdtest/ModelGroups',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgA017.xml','./msxsdtest/ModelGroups',valid,S16),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes17,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA018.xsd','./msxsdtest/ModelGroups',invalid),
  STResList18 = [STRes17|STResList17],


  ?line {STRes18,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgA019.xsd','./msxsdtest/ModelGroups',invalid),
  STResList19 = [STRes18|STResList18],


  ?line {STRes19,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa001.xsd','./msxsdtest/ModelGroups',invalid),
  STResList20 = [STRes19|STResList19],


  ?line {STRes20,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList21 = [STRes20|STResList20],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa003.xsd','./msxsdtest/ModelGroups',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgAa003.xml','./msxsdtest/ModelGroups',valid,S21),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes22,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa004.xsd','./msxsdtest/ModelGroups',invalid),
  STResList23 = [STRes22|STResList22],


  ?line {STRes23,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa005.xsd','./msxsdtest/ModelGroups',invalid),
  STResList24 = [STRes23|STResList23],


  ?line {STRes24,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa006.xsd','./msxsdtest/ModelGroups',invalid),
  STResList25 = [STRes24|STResList24],


  ?line {STRes25,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList26 = [STRes25|STResList25],


  ?line {STRes26,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList27 = [STRes26|STResList26],


  ?line {STRes27,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa009.xsd','./msxsdtest/ModelGroups',invalid),
  STResList28 = [STRes27|STResList27],


  ?line {STRes28,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAa010.xsd','./msxsdtest/ModelGroups',invalid),
  STResList29 = [STRes28|STResList28],


  ?line {STRes29,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb001.xsd','./msxsdtest/ModelGroups',invalid),
  STResList30 = [STRes29|STResList29],


  ?line {STRes30,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList31 = [STRes30|STResList30],


  ?line {STRes31,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList32 = [STRes31|STResList31],


  ?line {STRes32,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb004.xsd','./msxsdtest/ModelGroups',invalid),
  STResList33 = [STRes32|STResList32],


  ?line {STRes33,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb005.xsd','./msxsdtest/ModelGroups',invalid),
  STResList34 = [STRes33|STResList33],


  ?line {STRes34,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb006.xsd','./msxsdtest/ModelGroups',invalid),
  STResList35 = [STRes34|STResList34],


  ?line {STRes35,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList36 = [STRes35|STResList35],


  ?line {STRes36,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList37 = [STRes36|STResList36],


  ?line {STRes37,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb009.xsd','./msxsdtest/ModelGroups',invalid),
  STResList38 = [STRes37|STResList37],


  ?line {STRes38,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgAb010.xsd','./msxsdtest/ModelGroups',invalid),
  STResList39 = [STRes38|STResList38],


  ?line {STRes39,S39} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgB001.xsd','./msxsdtest/ModelGroups',valid),
  STResList40 = [STRes39|STResList39],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgB001.xml','./msxsdtest/ModelGroups',valid,S39),
  ITResList7 = [ITRes6|ITResList6],


  ?line {STRes40,S40} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgB002.xsd','./msxsdtest/ModelGroups',valid),
  STResList41 = [STRes40|STResList40],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgB002.xml','./msxsdtest/ModelGroups',valid,S40),
  ITResList8 = [ITRes7|ITResList7],


  ?line {STRes41,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgB003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList42 = [STRes41|STResList41],


  ?line {STRes42,S42} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgB004.xsd','./msxsdtest/ModelGroups',valid),
  STResList43 = [STRes42|STResList42],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgB004.xml','./msxsdtest/ModelGroups',valid,S42),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes43,S43} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgB006.xsd','./msxsdtest/ModelGroups',valid),
  STResList44 = [STRes43|STResList43],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgB006.xml','./msxsdtest/ModelGroups',valid,S43),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes44,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgB007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList45 = [STRes44|STResList44],


  ?line {STRes45,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgB008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList46 = [STRes45|STResList45],


  ?line {STRes46,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgB009.xsd','./msxsdtest/ModelGroups',invalid),
  STResList47 = [STRes46|STResList46],


  ?line {STRes47,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgB010.xsd','./msxsdtest/ModelGroups',invalid),
  STResList48 = [STRes47|STResList47],


  ?line {STRes48,S48} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC001.xsd','./msxsdtest/ModelGroups',valid),
  STResList49 = [STRes48|STResList48],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC001.xml','./msxsdtest/ModelGroups',invalid,S48),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes49,S49} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC002.xsd','./msxsdtest/ModelGroups',valid),
  STResList50 = [STRes49|STResList49],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC002.xml','./msxsdtest/ModelGroups',valid,S49),
  ITResList12 = [ITRes11|ITResList11],


  ?line {STRes50,S50} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC003.xsd','./msxsdtest/ModelGroups',valid),
  STResList51 = [STRes50|STResList50],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC003.xml','./msxsdtest/ModelGroups',invalid,S50),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes51,S51} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC004.xsd','./msxsdtest/ModelGroups',valid),
  STResList52 = [STRes51|STResList51],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC004.xml','./msxsdtest/ModelGroups',valid,S51),
  ITResList14 = [ITRes13|ITResList13],


  ?line {STRes52,S52} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC005.xsd','./msxsdtest/ModelGroups',valid),
  STResList53 = [STRes52|STResList52],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC005.xml','./msxsdtest/ModelGroups',invalid,S52),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes53,S53} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC006.xsd','./msxsdtest/ModelGroups',valid),
  STResList54 = [STRes53|STResList53],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC006.xml','./msxsdtest/ModelGroups',valid,S53),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes54,S54} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC007.xsd','./msxsdtest/ModelGroups',valid),
  STResList55 = [STRes54|STResList54],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC007.xml','./msxsdtest/ModelGroups',invalid,S54),
  ITResList17 = [ITRes16|ITResList16],


  ?line {STRes55,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList56 = [STRes55|STResList55],


  ?line {STRes56,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC009.xsd','./msxsdtest/ModelGroups',invalid),
  STResList57 = [STRes56|STResList56],


  ?line {STRes57,S57} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC010.xsd','./msxsdtest/ModelGroups',valid),
  STResList58 = [STRes57|STResList57],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC010.xml','./msxsdtest/ModelGroups',invalid,S57),
  ITResList18 = [ITRes17|ITResList17],


  ?line {STRes58,S58} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC011.xsd','./msxsdtest/ModelGroups',valid),
  STResList59 = [STRes58|STResList58],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC011.xml','./msxsdtest/ModelGroups',valid,S58),
  ITResList19 = [ITRes18|ITResList18],


  ?line {STRes59,S59} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC012.xsd','./msxsdtest/ModelGroups',valid),
  STResList60 = [STRes59|STResList59],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC012.xml','./msxsdtest/ModelGroups',invalid,S59),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes60,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC013.xsd','./msxsdtest/ModelGroups',invalid),
  STResList61 = [STRes60|STResList60],


  ?line {STRes61,S61} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgC014.xsd','./msxsdtest/ModelGroups',valid),
  STResList62 = [STRes61|STResList61],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgC014.xml','./msxsdtest/ModelGroups',valid,S61),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes62,S62} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgD001.xsd','./msxsdtest/ModelGroups',valid),
  STResList63 = [STRes62|STResList62],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgD001.xml','./msxsdtest/ModelGroups',valid,S62),
  ITResList22 = [ITRes21|ITResList21],


  ?line {STRes63,S63} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgD005.xsd','./msxsdtest/ModelGroups',valid),
  STResList64 = [STRes63|STResList63],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgD005.xml','./msxsdtest/ModelGroups',valid,S63),
  ITResList23 = [ITRes22|ITResList22],


  ?line {STRes64,S64} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgD009.xsd','./msxsdtest/ModelGroups',valid),
  STResList65 = [STRes64|STResList64],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgD009.xml','./msxsdtest/ModelGroups',valid,S64),
  ITResList24 = [ITRes23|ITResList23],


  ?line {STRes65,S65} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgD013.xsd','./msxsdtest/ModelGroups',valid),
  STResList66 = [STRes65|STResList65],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgD013.xml','./msxsdtest/ModelGroups',valid,S65),
  ITResList25 = [ITRes24|ITResList24],


  xmerl_xsd_lib:compare_test_results(Config,STResList66,ITResList25).

%% model groups ( sequence ).

mgEFG(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE001.xsd','./msxsdtest/ModelGroups',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgE001.xml','./msxsdtest/ModelGroups',valid,S0),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes1,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList2 = [STRes1|STResList1],


  ?line {STRes2,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList3 = [STRes2|STResList2],


  ?line {STRes3,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE004.xsd','./msxsdtest/ModelGroups',invalid),
  STResList4 = [STRes3|STResList3],


  ?line {STRes4,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE005.xsd','./msxsdtest/ModelGroups',invalid),
  STResList5 = [STRes4|STResList4],


  ?line {STRes5,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE006.xsd','./msxsdtest/ModelGroups',invalid),
  STResList6 = [STRes5|STResList5],


  ?line {STRes6,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList7 = [STRes6|STResList6],


  ?line {STRes7,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList8 = [STRes7|STResList7],


  ?line {STRes8,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE009.xsd','./msxsdtest/ModelGroups',invalid),
  STResList9 = [STRes8|STResList8],


  ?line {STRes9,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE010.xsd','./msxsdtest/ModelGroups',invalid),
  STResList10 = [STRes9|STResList9],


  ?line {STRes10,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE011.xsd','./msxsdtest/ModelGroups',invalid),
  STResList11 = [STRes10|STResList10],


  ?line {STRes11,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE012.xsd','./msxsdtest/ModelGroups',invalid),
  STResList12 = [STRes11|STResList11],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE013.xsd','./msxsdtest/ModelGroups',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgE013.xml','./msxsdtest/ModelGroups',valid,S12),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE014.xsd','./msxsdtest/ModelGroups',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgE014.xml','./msxsdtest/ModelGroups',valid,S13),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE015.xsd','./msxsdtest/ModelGroups',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgE015.xml','./msxsdtest/ModelGroups',valid,S14),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE016.xsd','./msxsdtest/ModelGroups',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgE016.xml','./msxsdtest/ModelGroups',valid,S15),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE017.xsd','./msxsdtest/ModelGroups',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgE017.xml','./msxsdtest/ModelGroups',valid,S16),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgE018.xsd','./msxsdtest/ModelGroups',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgE018.xml','./msxsdtest/ModelGroups',valid,S17),
  ITResList7 = [ITRes6|ITResList6],


  ?line {STRes18,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEa001.xsd','./msxsdtest/ModelGroups',invalid),
  STResList19 = [STRes18|STResList18],


  ?line {STRes19,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEa002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList20 = [STRes19|STResList19],


  ?line {STRes20,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEa003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList21 = [STRes20|STResList20],


  ?line {STRes21,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEa004.xsd','./msxsdtest/ModelGroups',invalid),
  STResList22 = [STRes21|STResList21],


  ?line {STRes22,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEa005.xsd','./msxsdtest/ModelGroups',invalid),
  STResList23 = [STRes22|STResList22],


  ?line {STRes23,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEa006.xsd','./msxsdtest/ModelGroups',invalid),
  STResList24 = [STRes23|STResList23],


  ?line {STRes24,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEa007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList25 = [STRes24|STResList24],


  ?line {STRes25,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEa008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList26 = [STRes25|STResList25],


  ?line {STRes26,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEb001.xsd','./msxsdtest/ModelGroups',invalid),
  STResList27 = [STRes26|STResList26],


  ?line {STRes27,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEb002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList28 = [STRes27|STResList27],


  ?line {STRes28,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEb003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList29 = [STRes28|STResList28],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEb004.xsd','./msxsdtest/ModelGroups',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgEb004.xml','./msxsdtest/ModelGroups',valid,S29),
  ITResList8 = [ITRes7|ITResList7],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEb005.xsd','./msxsdtest/ModelGroups',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgEb005.xml','./msxsdtest/ModelGroups',valid,S30),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes31,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEb006.xsd','./msxsdtest/ModelGroups',invalid),
  STResList32 = [STRes31|STResList31],


  ?line {STRes32,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEb007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList33 = [STRes32|STResList32],


  ?line {STRes33,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgEb008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList34 = [STRes33|STResList33],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF001.xsd','./msxsdtest/ModelGroups',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF001.xml','./msxsdtest/ModelGroups',valid,S34),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF002.xsd','./msxsdtest/ModelGroups',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF002.xml','./msxsdtest/ModelGroups',valid,S35),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes36,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList37 = [STRes36|STResList36],


  ?line {STRes37,S37} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF004.xsd','./msxsdtest/ModelGroups',valid),
  STResList38 = [STRes37|STResList37],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF004.xml','./msxsdtest/ModelGroups',valid,S37),
  ITResList12 = [ITRes11|ITResList11],


  ?line {STRes38,S38} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF005.xsd','./msxsdtest/ModelGroups',valid),
  STResList39 = [STRes38|STResList38],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF005.xml','./msxsdtest/ModelGroups',valid,S38),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes39,S39} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF006.xsd','./msxsdtest/ModelGroups',valid),
  STResList40 = [STRes39|STResList39],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF006.xml','./msxsdtest/ModelGroups',valid,S39),
  ITResList14 = [ITRes13|ITResList13],


  ?line {STRes40,S40} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF007.xsd','./msxsdtest/ModelGroups',valid),
  STResList41 = [STRes40|STResList40],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF007.xml','./msxsdtest/ModelGroups',valid,S40),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes41,S41} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF008.xsd','./msxsdtest/ModelGroups',valid),
  STResList42 = [STRes41|STResList41],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF008.xml','./msxsdtest/ModelGroups',valid,S41),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes42,S42} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF009.xsd','./msxsdtest/ModelGroups',valid),
  STResList43 = [STRes42|STResList42],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF009.xml','./msxsdtest/ModelGroups',valid,S42),
  ITResList17 = [ITRes16|ITResList16],


  ?line {STRes43,S43} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF010.xsd','./msxsdtest/ModelGroups',valid),
  STResList44 = [STRes43|STResList43],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF010.xml','./msxsdtest/ModelGroups',valid,S43),
  ITResList18 = [ITRes17|ITResList17],


  ?line {STRes44,S44} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF011.xsd','./msxsdtest/ModelGroups',valid),
  STResList45 = [STRes44|STResList44],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF011.xml','./msxsdtest/ModelGroups',valid,S44),
  ITResList19 = [ITRes18|ITResList18],


  ?line {STRes45,S45} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF012.xsd','./msxsdtest/ModelGroups',valid),
  STResList46 = [STRes45|STResList45],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF012.xml','./msxsdtest/ModelGroups',valid,S45),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes46,S46} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF013.xsd','./msxsdtest/ModelGroups',valid),
  STResList47 = [STRes46|STResList46],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF013.xml','./msxsdtest/ModelGroups',valid,S46),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes47,S47} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF014.xsd','./msxsdtest/ModelGroups',valid),
  STResList48 = [STRes47|STResList47],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF014.xml','./msxsdtest/ModelGroups',valid,S47),
  ITResList22 = [ITRes21|ITResList21],


  ?line {STRes48,S48} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF015.xsd','./msxsdtest/ModelGroups',valid),
  STResList49 = [STRes48|STResList48],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF015.xml','./msxsdtest/ModelGroups',valid,S48),
  ITResList23 = [ITRes22|ITResList22],


  ?line {STRes49,S49} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF016.xsd','./msxsdtest/ModelGroups',valid),
  STResList50 = [STRes49|STResList49],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF016.xml','./msxsdtest/ModelGroups',valid,S49),
  ITResList24 = [ITRes23|ITResList23],


  ?line {STRes50,S50} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF017.xsd','./msxsdtest/ModelGroups',valid),
  STResList51 = [STRes50|STResList50],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF017.xml','./msxsdtest/ModelGroups',valid,S50),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes51,S51} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF018.xsd','./msxsdtest/ModelGroups',valid),
  STResList52 = [STRes51|STResList51],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF018.xml','./msxsdtest/ModelGroups',valid,S51),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes52,S52} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF019.xsd','./msxsdtest/ModelGroups',valid),
  STResList53 = [STRes52|STResList52],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgF019.xml','./msxsdtest/ModelGroups',valid,S52),
  ITResList27 = [ITRes26|ITResList26],


  ?line {STRes53,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF020.xsd','./msxsdtest/ModelGroups',invalid),
  STResList54 = [STRes53|STResList53],


  ?line {STRes54,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF021.xsd','./msxsdtest/ModelGroups',invalid),
  STResList55 = [STRes54|STResList54],


  ?line {STRes55,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF022.xsd','./msxsdtest/ModelGroups',invalid),
  STResList56 = [STRes55|STResList55],


  ?line {STRes56,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgF023.xsd','./msxsdtest/ModelGroups',invalid),
  STResList57 = [STRes56|STResList56],


  ?line {STRes57,S57} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG001.xsd','./msxsdtest/ModelGroups',valid),
  STResList58 = [STRes57|STResList57],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG001.xml','./msxsdtest/ModelGroups',valid,S57),
  ITResList28 = [ITRes27|ITResList27],


  ?line {STRes58,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList59 = [STRes58|STResList58],


  ?line {STRes59,S59} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG003.xsd','./msxsdtest/ModelGroups',valid),
  STResList60 = [STRes59|STResList59],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG003.xml','./msxsdtest/ModelGroups',invalid,S59),
  ITResList29 = [ITRes28|ITResList28],


  ?line {STRes60,S60} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG004.xsd','./msxsdtest/ModelGroups',valid),
  STResList61 = [STRes60|STResList60],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG004.xml','./msxsdtest/ModelGroups',valid,S60),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes61,S61} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG005.xsd','./msxsdtest/ModelGroups',valid),
  STResList62 = [STRes61|STResList61],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG005.xml','./msxsdtest/ModelGroups',invalid,S61),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes62,S62} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG006.xsd','./msxsdtest/ModelGroups',valid),
  STResList63 = [STRes62|STResList62],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG006.xml','./msxsdtest/ModelGroups',valid,S62),
  ITResList32 = [ITRes31|ITResList31],


  ?line {STRes63,S63} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG007.xsd','./msxsdtest/ModelGroups',valid),
  STResList64 = [STRes63|STResList63],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG007.xml','./msxsdtest/ModelGroups',valid,S63),
  ITResList33 = [ITRes32|ITResList32],


  ?line {STRes64,S64} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG008.xsd','./msxsdtest/ModelGroups',valid),
  STResList65 = [STRes64|STResList64],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG008.xml','./msxsdtest/ModelGroups',invalid,S64),
  ITResList34 = [ITRes33|ITResList33],


  ?line {STRes65,S65} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG009.xsd','./msxsdtest/ModelGroups',valid),
  STResList66 = [STRes65|STResList65],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG009.xml','./msxsdtest/ModelGroups',valid,S65),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes66,S66} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG010.xsd','./msxsdtest/ModelGroups',valid),
  STResList67 = [STRes66|STResList66],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG010.xml','./msxsdtest/ModelGroups',valid,S66),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes67,S67} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG011.xsd','./msxsdtest/ModelGroups',valid),
  STResList68 = [STRes67|STResList67],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG011.xml','./msxsdtest/ModelGroups',invalid,S67),
  ITResList37 = [ITRes36|ITResList36],


  ?line {STRes68,S68} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG012.xsd','./msxsdtest/ModelGroups',valid),
  STResList69 = [STRes68|STResList68],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG012.xml','./msxsdtest/ModelGroups',valid,S68),
  ITResList38 = [ITRes37|ITResList37],


  ?line {STRes69,S69} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG013.xsd','./msxsdtest/ModelGroups',valid),
  STResList70 = [STRes69|STResList69],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG013.xml','./msxsdtest/ModelGroups',invalid,S69),
  ITResList39 = [ITRes38|ITResList38],


  ?line {STRes70,S70} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG014.xsd','./msxsdtest/ModelGroups',valid),
  STResList71 = [STRes70|STResList70],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG014.xml','./msxsdtest/ModelGroups',valid,S70),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes71,S71} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG015.xsd','./msxsdtest/ModelGroups',valid),
  STResList72 = [STRes71|STResList71],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG015.xml','./msxsdtest/ModelGroups',invalid,S71),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes72,S72} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG016.xsd','./msxsdtest/ModelGroups',valid),
  STResList73 = [STRes72|STResList72],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG016.xml','./msxsdtest/ModelGroups',valid,S72),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes73,S73} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG017.xsd','./msxsdtest/ModelGroups',valid),
  STResList74 = [STRes73|STResList73],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG017.xml','./msxsdtest/ModelGroups',invalid,S73),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes74,S74} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG018.xsd','./msxsdtest/ModelGroups',valid),
  STResList75 = [STRes74|STResList74],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG018.xml','./msxsdtest/ModelGroups',invalid,S74),
  ITResList44 = [ITRes43|ITResList43],


  ?line {STRes75,S75} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG019.xsd','./msxsdtest/ModelGroups',valid),
  STResList76 = [STRes75|STResList75],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG019.xml','./msxsdtest/ModelGroups',valid,S75),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes76,S76} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG020.xsd','./msxsdtest/ModelGroups',valid),
  STResList77 = [STRes76|STResList76],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG020.xml','./msxsdtest/ModelGroups',invalid,S76),
  ITResList46 = [ITRes45|ITResList45],


  ?line {STRes77,S77} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG021.xsd','./msxsdtest/ModelGroups',valid),
  STResList78 = [STRes77|STResList77],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG021.xml','./msxsdtest/ModelGroups',invalid,S77),
  ITResList47 = [ITRes46|ITResList46],


  ?line {STRes78,S78} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG022.xsd','./msxsdtest/ModelGroups',valid),
  STResList79 = [STRes78|STResList78],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG022.xml','./msxsdtest/ModelGroups',valid,S78),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes79,S79} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG023.xsd','./msxsdtest/ModelGroups',valid),
  STResList80 = [STRes79|STResList79],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG023.xml','./msxsdtest/ModelGroups',valid,S79),
  ITResList49 = [ITRes48|ITResList48],


  ?line {STRes80,S80} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG024.xsd','./msxsdtest/ModelGroups',valid),
  STResList81 = [STRes80|STResList80],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG024.xml','./msxsdtest/ModelGroups',invalid,S80),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes81,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG025.xsd','./msxsdtest/ModelGroups',invalid),
  STResList82 = [STRes81|STResList81],


  ?line {STRes82,S82} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG026.xsd','./msxsdtest/ModelGroups',valid),
  STResList83 = [STRes82|STResList82],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgG026.xml','./msxsdtest/ModelGroups',valid,S82),
  ITResList51 = [ITRes50|ITResList50],


  ?line {STRes83,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG027.xsd','./msxsdtest/ModelGroups',invalid),
  STResList84 = [STRes83|STResList83],


  ?line {STRes84,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG028.xsd','./msxsdtest/ModelGroups',invalid),
  STResList85 = [STRes84|STResList84],


  ?line {STRes85,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG029.xsd','./msxsdtest/ModelGroups',invalid),
  STResList86 = [STRes85|STResList85],


  ?line {STRes86,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgG030.xsd','./msxsdtest/ModelGroups',invalid),
  STResList87 = [STRes86|STResList86],


  xmerl_xsd_lib:compare_test_results(Config,STResList87,ITResList51).

%% model groups ( choice ).

mgHIJ(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH001.xsd','./msxsdtest/ModelGroups',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgH001.xml','./msxsdtest/ModelGroups',valid,S0),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes1,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList2 = [STRes1|STResList1],


  ?line {STRes2,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList3 = [STRes2|STResList2],


  ?line {STRes3,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH004.xsd','./msxsdtest/ModelGroups',invalid),
  STResList4 = [STRes3|STResList3],


  ?line {STRes4,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH005.xsd','./msxsdtest/ModelGroups',invalid),
  STResList5 = [STRes4|STResList4],


  ?line {STRes5,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH006.xsd','./msxsdtest/ModelGroups',invalid),
  STResList6 = [STRes5|STResList5],


  ?line {STRes6,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList7 = [STRes6|STResList6],


  ?line {STRes7,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList8 = [STRes7|STResList7],


  ?line {STRes8,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH009.xsd','./msxsdtest/ModelGroups',invalid),
  STResList9 = [STRes8|STResList8],


  ?line {STRes9,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH010.xsd','./msxsdtest/ModelGroups',invalid),
  STResList10 = [STRes9|STResList9],


  ?line {STRes10,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH011.xsd','./msxsdtest/ModelGroups',invalid),
  STResList11 = [STRes10|STResList10],


  ?line {STRes11,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH012.xsd','./msxsdtest/ModelGroups',invalid),
  STResList12 = [STRes11|STResList11],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH013.xsd','./msxsdtest/ModelGroups',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgH013.xml','./msxsdtest/ModelGroups',valid,S12),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH014.xsd','./msxsdtest/ModelGroups',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgH014.xml','./msxsdtest/ModelGroups',valid,S13),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH015.xsd','./msxsdtest/ModelGroups',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgH015.xml','./msxsdtest/ModelGroups',valid,S14),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH016.xsd','./msxsdtest/ModelGroups',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgH016.xml','./msxsdtest/ModelGroups',valid,S15),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH017.xsd','./msxsdtest/ModelGroups',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgH017.xml','./msxsdtest/ModelGroups',valid,S16),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgH018.xsd','./msxsdtest/ModelGroups',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgH018.xml','./msxsdtest/ModelGroups',valid,S17),
  ITResList7 = [ITRes6|ITResList6],


  ?line {STRes18,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHa001.xsd','./msxsdtest/ModelGroups',invalid),
  STResList19 = [STRes18|STResList18],


  ?line {STRes19,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHa002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList20 = [STRes19|STResList19],


  ?line {STRes20,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHa003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList21 = [STRes20|STResList20],


  ?line {STRes21,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHa004.xsd','./msxsdtest/ModelGroups',invalid),
  STResList22 = [STRes21|STResList21],


  ?line {STRes22,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHa005.xsd','./msxsdtest/ModelGroups',invalid),
  STResList23 = [STRes22|STResList22],


  ?line {STRes23,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHa006.xsd','./msxsdtest/ModelGroups',invalid),
  STResList24 = [STRes23|STResList23],


  ?line {STRes24,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHa007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList25 = [STRes24|STResList24],


  ?line {STRes25,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHa008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList26 = [STRes25|STResList25],


  ?line {STRes26,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHb001.xsd','./msxsdtest/ModelGroups',invalid),
  STResList27 = [STRes26|STResList26],


  ?line {STRes27,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHb002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList28 = [STRes27|STResList27],


  ?line {STRes28,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHb003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList29 = [STRes28|STResList28],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHb004.xsd','./msxsdtest/ModelGroups',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgHb004.xml','./msxsdtest/ModelGroups',valid,S29),
  ITResList8 = [ITRes7|ITResList7],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHb005.xsd','./msxsdtest/ModelGroups',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgHb005.xml','./msxsdtest/ModelGroups',valid,S30),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes31,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHb006.xsd','./msxsdtest/ModelGroups',invalid),
  STResList32 = [STRes31|STResList31],


  ?line {STRes32,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHb007.xsd','./msxsdtest/ModelGroups',invalid),
  STResList33 = [STRes32|STResList32],


  ?line {STRes33,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgHb008.xsd','./msxsdtest/ModelGroups',invalid),
  STResList34 = [STRes33|STResList33],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI001.xsd','./msxsdtest/ModelGroups',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI001.xml','./msxsdtest/ModelGroups',valid,S34),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI002.xsd','./msxsdtest/ModelGroups',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI002.xml','./msxsdtest/ModelGroups',valid,S35),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes36,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI003.xsd','./msxsdtest/ModelGroups',invalid),
  STResList37 = [STRes36|STResList36],


  ?line {STRes37,S37} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI004.xsd','./msxsdtest/ModelGroups',valid),
  STResList38 = [STRes37|STResList37],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI004.xml','./msxsdtest/ModelGroups',valid,S37),
  ITResList12 = [ITRes11|ITResList11],


  ?line {STRes38,S38} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI005.xsd','./msxsdtest/ModelGroups',valid),
  STResList39 = [STRes38|STResList38],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI005.xml','./msxsdtest/ModelGroups',valid,S38),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes39,S39} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI006.xsd','./msxsdtest/ModelGroups',valid),
  STResList40 = [STRes39|STResList39],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI006.xml','./msxsdtest/ModelGroups',valid,S39),
  ITResList14 = [ITRes13|ITResList13],


  ?line {STRes40,S40} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI007.xsd','./msxsdtest/ModelGroups',valid),
  STResList41 = [STRes40|STResList40],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI007.xml','./msxsdtest/ModelGroups',valid,S40),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes41,S41} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI008.xsd','./msxsdtest/ModelGroups',valid),
  STResList42 = [STRes41|STResList41],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI008.xml','./msxsdtest/ModelGroups',valid,S41),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes42,S42} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI009.xsd','./msxsdtest/ModelGroups',valid),
  STResList43 = [STRes42|STResList42],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI009.xml','./msxsdtest/ModelGroups',valid,S42),
  ITResList17 = [ITRes16|ITResList16],


  ?line {STRes43,S43} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI010.xsd','./msxsdtest/ModelGroups',valid),
  STResList44 = [STRes43|STResList43],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI010.xml','./msxsdtest/ModelGroups',valid,S43),
  ITResList18 = [ITRes17|ITResList17],


  ?line {STRes44,S44} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI011.xsd','./msxsdtest/ModelGroups',valid),
  STResList45 = [STRes44|STResList44],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI011.xml','./msxsdtest/ModelGroups',valid,S44),
  ITResList19 = [ITRes18|ITResList18],


  ?line {STRes45,S45} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI012.xsd','./msxsdtest/ModelGroups',valid),
  STResList46 = [STRes45|STResList45],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI012.xml','./msxsdtest/ModelGroups',valid,S45),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes46,S46} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI013.xsd','./msxsdtest/ModelGroups',valid),
  STResList47 = [STRes46|STResList46],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI013.xml','./msxsdtest/ModelGroups',valid,S46),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes47,S47} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI014.xsd','./msxsdtest/ModelGroups',valid),
  STResList48 = [STRes47|STResList47],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI014.xml','./msxsdtest/ModelGroups',valid,S47),
  ITResList22 = [ITRes21|ITResList21],


  ?line {STRes48,S48} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI015.xsd','./msxsdtest/ModelGroups',valid),
  STResList49 = [STRes48|STResList48],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI015.xml','./msxsdtest/ModelGroups',valid,S48),
  ITResList23 = [ITRes22|ITResList22],


  ?line {STRes49,S49} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI016.xsd','./msxsdtest/ModelGroups',valid),
  STResList50 = [STRes49|STResList49],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI016.xml','./msxsdtest/ModelGroups',valid,S49),
  ITResList24 = [ITRes23|ITResList23],


  ?line {STRes50,S50} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI017.xsd','./msxsdtest/ModelGroups',valid),
  STResList51 = [STRes50|STResList50],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI017.xml','./msxsdtest/ModelGroups',valid,S50),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes51,S51} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI018.xsd','./msxsdtest/ModelGroups',valid),
  STResList52 = [STRes51|STResList51],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI018.xml','./msxsdtest/ModelGroups',valid,S51),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes52,S52} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI019.xsd','./msxsdtest/ModelGroups',valid),
  STResList53 = [STRes52|STResList52],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgI019.xml','./msxsdtest/ModelGroups',valid,S52),
  ITResList27 = [ITRes26|ITResList26],


  ?line {STRes53,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI020.xsd','./msxsdtest/ModelGroups',invalid),
  STResList54 = [STRes53|STResList53],


  ?line {STRes54,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI021.xsd','./msxsdtest/ModelGroups',invalid),
  STResList55 = [STRes54|STResList54],


  ?line {STRes55,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI022.xsd','./msxsdtest/ModelGroups',invalid),
  STResList56 = [STRes55|STResList55],


  ?line {STRes56,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgI023.xsd','./msxsdtest/ModelGroups',invalid),
  STResList57 = [STRes56|STResList56],


  ?line {STRes57,S57} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgJ001.xsd','./msxsdtest/ModelGroups',valid),
  STResList58 = [STRes57|STResList57],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgJ001.xml','./msxsdtest/ModelGroups',valid,S57),
  ITResList28 = [ITRes27|ITResList27],


  ?line {STRes58,_} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgJ002.xsd','./msxsdtest/ModelGroups',invalid),
  STResList59 = [STRes58|STResList58],


  ?line {STRes59,S59} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgJ003.xsd','./msxsdtest/ModelGroups',valid),
  STResList60 = [STRes59|STResList59],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgJ003.xml','./msxsdtest/ModelGroups',invalid,S59),
  ITResList29 = [ITRes28|ITResList28],


  ?line {STRes60,S60} = xmerl_xsd_lib:schema_test(Config,'./msxsdtest/ModelGroups/mgJ004.xsd','./msxsdtest/ModelGroups',valid),
  STResList61 = [STRes60|STResList60],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./msxsdtest/ModelGroups/mgJ004.xml','./msxsdtest/ModelGroups',valid,S60),
  ITResList30 = [ITRes29|ITResList