/*
 * vars.h: header for vars.c
 *
 * (C) 1990, 1995 Michael Sandroff, Matthew Green and others.
 *
 * $Id: vars.h.proto,v 1.6 1994/01/05 11:09:34 mrgreen Exp $
 */

#ifndef _VARS_H_
#define _VARS_H_

#include "irc_std.h"

/* indexes for the irc_variable array */
enum VAR_TYPES {
	ALWAYS_SPLIT_BIGGEST_VAR,
	AUTO_NEW_NICK_VAR,
	AUTO_RECONNECT_VAR,
	AUTO_REJOIN_VAR,
	AUTO_UNMARK_AWAY_VAR,
	AUTO_WHOWAS_VAR ,
	BEEP_VAR,
	BEEP_MAX_VAR,
	BEEP_ON_MSG_VAR,
	BEEP_WHEN_AWAY_VAR,
	BOLD_VIDEO_VAR,
	CHANNEL_NAME_WIDTH_VAR,
	CLIENTINFO_VAR,
	CLOCK_VAR,
	CLOCK_24HOUR_VAR,
	CLOCK_ALARM_VAR,
	CMDCHARS_VAR,
	COMMAND_MODE_VAR,
	COMMENT_HACK_VAR,
	CONTINUED_LINE_VAR,
	DCC_LONG_PATHNAMES_VAR,
	DCC_SLIDING_WINDOW_VAR,
	DCC_STORE_PATH_VAR,
	DEBUG_VAR,
	DISPLAY_VAR,
	DISPLAY_ANSI_VAR,
	EIGHT_BIT_CHARACTERS_VAR,
	ENCRYPT_PROGRAM_VAR,
	EXEC_PROTECTION_VAR,
	FLOATING_POINT_MATH_VAR,
	FLOOD_AFTER_VAR,
	FLOOD_RATE_VAR,
	FLOOD_USERS_VAR,
	FLOOD_WARNING_VAR,
	FULL_STATUS_LINE_VAR,
	HELP_PAGER_VAR,
	HELP_PATH_VAR,
	HELP_PROMPT_VAR,
#ifdef USE_HELP_BOTS
	HELP_SERVICE_VAR,
#endif
	HELP_WINDOW_VAR,
	HIDE_PRIVATE_CHANNELS_VAR,
	HIGHLIGHT_CHAR_VAR,
	HISTORY_VAR,
	HISTORY_FILE_VAR,
	HOLD_MODE_VAR,
	HOLD_MODE_MAX_VAR,
	INDENT_VAR,
	INPUT_ALIASES_VAR,
	INPUT_PROMPT_VAR,
	INPUT_PROTECTION_VAR,
	INSERT_MODE_VAR,
	INVERSE_VIDEO_VAR,
	LASTLOG_VAR,
	LASTLOG_LEVEL_VAR,
	LOAD_PATH_VAR,
	LOG_VAR,
	LOGFILE_VAR,
	MAIL_VAR,
	MAX_RECURSIONS_VAR,
	MENU_VAR,
	MODE_STRIPPER_VAR,
	NO_CTCP_FLOOD_VAR,
	NOTIFY_HANDLER_VAR,
	NOTIFY_LEVEL_VAR,
	NOTIFY_ON_TERMINATION_VAR,
	NOVICE_VAR,
	NUM_OF_WHOWAS_VAR,
	PAD_CHAR_VAR,
	REALNAME_VAR,
	REVERSE_STATUS_LINE_VAR,
	SCREEN_OPTIONS_VAR,
	SCROLL_VAR,
	SCROLL_LINES_VAR,
	SECURITY_VAR,
	SEND_IGNORE_MSG_VAR,
	SHELL_VAR,
	SHELL_FLAGS_VAR,
	SHELL_LIMIT_VAR,
	SHOW_AWAY_ONCE_VAR,
	SHOW_CHANNEL_NAMES_VAR,
	SHOW_END_OF_MSGS_VAR,
	SHOW_NUMERICS_VAR,
	SHOW_STATUS_ALL_VAR,
	SHOW_WHO_HOPCOUNT_VAR,
	STATUS_AWAY_VAR,
	STATUS_CHANNEL_VAR,
	STATUS_CHANOP_VAR,
	STATUS_CLOCK_VAR,
	STATUS_FORMAT_VAR,
	STATUS_FORMAT1_VAR,
	STATUS_FORMAT2_VAR,
	STATUS_HOLD_VAR,
	STATUS_HOLD_LINES_VAR,
	STATUS_INSERT_VAR,
	STATUS_MAIL_VAR,
	STATUS_MODE_VAR,
	STATUS_NO_REPEAT_VAR,
	STATUS_NOTIFY_VAR,
	STATUS_OPER_VAR,
	STATUS_OVERWRITE_VAR,
	STATUS_QUERY_VAR,
	STATUS_SERVER_VAR,
	STATUS_UMODE_VAR,
	STATUS_USER_VAR,
	STATUS_USER1_VAR,
	STATUS_USER2_VAR,
	STATUS_USER3_VAR,
/* 
 * Oh the labours of adding functionality... new STATUS_USER variables
 * 					-- Jake [WinterHawk] Khuon
 */
	STATUS_USER4_VAR,
	STATUS_USER5_VAR,
	STATUS_USER6_VAR,
	STATUS_USER7_VAR,
	STATUS_USER8_VAR,
	STATUS_USER9_VAR,
	STATUS_VOICE_VAR,
	STATUS_WINDOW_VAR,
	SUPPRESS_SERVER_MOTD_VAR,
	SUPPRESS_FROM_REMOTE_SERVER,
	TAB_VAR,
	TAB_MAX_VAR,
	TRANSLATION_VAR,
	UNDERLINE_VIDEO_VAR,
	USER_INFO_VAR,
#define	USERINFO_VAR USER_INFO_VAR
	VERBOSE_CTCP_VAR,
	WARN_OF_IGNORES_VAR,
	XTERM_OPTIONS_VAR,
	NUMBER_OF_VARIABLES
};

/* var_settings indexes ... also used in display.c for highlights */
#define OFF 0
#define ON 1
#define TOGGLE 2

#define	DEBUG_COMMANDS		0x0001
#define	DEBUG_EXPANSIONS	0x0002
#define DEBUG_FUNCTIONS		0x0004


extern	int	do_boolean _((char *, int *));
extern	void	set_variable _((char *, char *, char *));
extern	int	get_int_var _((enum VAR_TYPES));
extern	char	*get_string_var _((enum VAR_TYPES));
extern	void	set_int_var _((enum VAR_TYPES, unsigned int));
extern	void	set_string_var _((enum VAR_TYPES, char *));
extern	char	*get_string_var _((enum VAR_TYPES));
extern	void	init_variables _((void));
extern	char	*var_settings[];
extern	char	*make_string_var _((char *));
extern	void	set_highlight_char();
extern	int	charset_size _((void));
extern	void	save_variables _((FILE *, int));
extern	void	set_var_value _((int, char *));

extern	int	loading_global;


#endif /* _VARS_H_ */
