/*
 * ================================================================
 * Please view:
 *
 * 	README for program information.
 * 	COPYING for distribution information.
 *
 * 	based on ident2 by Michael Bacarella (defile@nyct.net)
 *
 * ================================================================ 
 */

#include "xtelld.h"
#include <sys/stat.h>

/* ------------------------------------------------------------------
 * get_request	:	a fgets for file descriptors 
 * ------------------------------------------------------------------
 */
short int get_request(int d, char buffer[], unsigned short int len)
{
    unsigned short i;
    char ch;

    memset(buffer, 0, len);
    for (i = 0; i < len; i++) {
	if (read(d, &ch, 1) != 1)
	    return -1;
	else if (ch == '\n')
	    break;
	else if (ch == '\r') {
	    read(d, &ch, 1);	/* it better be \n */
	    break;
	} else
	    buffer[i] = ch;
    }
    buffer[i] = '\0';
    return i;
}

FILE *logFILE(const char *fromluser)
{
    FILE *file;
    char *path;
    struct passwd *passs;
    struct stat s;

    if ((passs = getpwnam(fromluser)) != NULL) {
	path = malloc(strlen(passs->pw_dir) + sizeof(LOGFILE) + 1);
	if (path == NULL)
	    return NULL;
	strcpy(path, passs->pw_dir);
	strcat(path, "/");
	strcat(path, LOGFILE);
        if (stat(path, &s)==0) {
        if (S_ISREG(s.st_mode)) {
	if ((file = fopen(path, "a")) != NULL) {
            free (path);
	    return file;
	}}}
	free(path);
    }
    return NULL;
}


/* ------------------------------------------------------------------
 * killsock:
 *	violently kills a socket
 * ------------------------------------------------------------------
 */
void killsock(int s)
{
    shutdown(s, 2);
    close(s);
}
