/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public class IntersectFeatures {
    private static VectorMaker fac1 = null;
    private static VectorMaker fac2 = null;
    private long[] totals = new long[]{0L, 0L};
    private GeneralVector[] locs = new GeneralVector[2];
    private boolean[] gathered = new boolean[]{false, false};

    public static void main(String[] stringArray) {
        if (stringArray.length < 5 || stringArray.length > 5) {
            System.out.println("Requires 5 parameters :");
            System.out.println("  1: filename1 (flat and gzip files supported)");
            System.out.println("  2: file1 type = (gff|tab)");
            System.out.println("  3: filename2 (flat and gzip files supported)");
            System.out.println("  4: file2 type = (gff|tab)");
            System.out.println("  5: output format = (lite|simple|levy");
            System.exit(1);
        }
        LocationComparator locationComparator = null;
        String string = stringArray[0];
        String string2 = stringArray[2];
        try {
            fac1 = IntersectFeatures.getFactory(stringArray[1]);
            fac2 = IntersectFeatures.getFactory(stringArray[3]);
            locationComparator = IntersectFeatures.getComparator(stringArray[4]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(10);
        }
        IntersectFeatures intersectFeatures = new IntersectFeatures();
        try {
            intersectFeatures.intersectFeatures(locationComparator, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(40);
        }
    }

    public void intersectFeatures(LocationComparator locationComparator, String string, String string2) throws Exception {
        this.totals[0] = 0L;
        this.totals[1] = 0L;
        LocationVector[] locationVectorArray = new LocationVector[]{new LocationVector(), new LocationVector()};
        BufferedReader bufferedReader = this.getFileReader(string);
        BufferedReader bufferedReader2 = this.getFileReader(string2);
        String string3 = bufferedReader.readLine();
        String string4 = bufferedReader2.readLine();
        this.locs[0] = fac1.makeVector(string3);
        this.locs[1] = fac2.makeVector(string4);
        long l = 0L;
        boolean bl = false;
        while (this.locs[0] != null && this.locs[1] != null) {
            int n = this.locs[0].getChromosome().compareTo(this.locs[1].getChromosome());
            if (n != 0) {
                if (n < 0) {
                    this.totals[0] = this.totals[0] + (long)this.locs[0].size();
                    string3 = bufferedReader.readLine();
                    this.locs[0] = fac1.makeVector(string3);
                    this.gathered[0] = false;
                    continue;
                }
                this.totals[1] = this.totals[1] + (long)this.locs[1].size();
                string4 = bufferedReader2.readLine();
                this.locs[1] = fac2.makeVector(string4);
                this.gathered[1] = false;
                continue;
            }
            if (this.locs[0].intersects(this.locs[1])) {
                locationVectorArray[0].clear();
                locationVectorArray[1].clear();
                this.totals[0] = this.totals[0] + (long)this.locs[0].size();
                this.totals[1] = this.totals[1] + (long)this.locs[1].size();
                locationVectorArray[0].addLocation(this.locs[0]);
                locationVectorArray[1].addLocation(this.locs[1]);
                this.gathered[0] = true;
                this.gathered[1] = true;
                boolean bl2 = true;
                boolean bl3 = true;
                int n2 = 0;
                while ((bl2 || bl3 || n2 < 2) && (this.locs[0] != null && locationVectorArray[0].intersects(this.locs[0]) || this.locs[1] != null && locationVectorArray[0].intersects(this.locs[1]) || this.locs[0] != null && locationVectorArray[1].intersects(this.locs[0]) || this.locs[1] != null && locationVectorArray[1].intersects(this.locs[1]))) {
                    n2 = bl2 || bl3 ? 0 : ++n2;
                    int n3 = locationVectorArray[0].size();
                    int n4 = locationVectorArray[1].size();
                    if (this.locs[0] != null && (locationVectorArray[0].intersects(this.locs[0]) || locationVectorArray[1].intersects(this.locs[0]))) {
                        this.gatherGroup(0, this.locs, locationVectorArray, fac1, bufferedReader);
                    }
                    if (this.locs[1] != null && (locationVectorArray[0].intersects(this.locs[1]) || locationVectorArray[1].intersects(this.locs[1]))) {
                        this.gatherGroup(1, this.locs, locationVectorArray, fac2, bufferedReader2);
                    }
                    bl2 = n3 != locationVectorArray[0].size();
                    boolean bl4 = bl3 = n4 != locationVectorArray[1].size();
                }
                locationComparator.compare(locationVectorArray[0], locationVectorArray[1]);
                l += (long)locationComparator.getTotalOverlap();
                continue;
            }
            if (this.locs[0].compareTo(this.locs[1]) < 0) {
                if (!this.gathered[0]) {
                    this.totals[0] = this.totals[0] + (long)this.locs[0].size();
                }
                string3 = bufferedReader.readLine();
                this.locs[0] = fac1.makeVector(string3);
                this.gathered[0] = false;
                continue;
            }
            if (!this.gathered[1]) {
                this.totals[1] = this.totals[1] + (long)this.locs[1].size();
            }
            string4 = bufferedReader2.readLine();
            this.locs[1] = fac2.makeVector(string4);
            this.gathered[1] = false;
        }
        if (this.locs[0] != null) {
            if (!this.gathered[0]) {
                this.totals[0] = this.totals[0] + (long)this.locs[0].size();
            }
            while (this.locs[0] != null) {
                string3 = bufferedReader.readLine();
                this.locs[0] = fac1.makeVector(string3);
                if (this.locs[0] == null) continue;
                this.totals[0] = this.totals[0] + (long)this.locs[0].size();
            }
        }
        if (this.locs[1] != null) {
            if (!this.gathered[1]) {
                this.totals[1] = this.totals[1] + (long)this.locs[1].size();
            }
            while (this.locs[1] != null) {
                string4 = bufferedReader2.readLine();
                this.locs[1] = fac2.makeVector(string4);
                if (this.locs[1] == null) continue;
                this.totals[1] = this.totals[1] + (long)this.locs[1].size();
            }
        }
        System.out.println("Total overlap " + l);
        System.out.println("Total coverage " + this.totals[0] + " for file " + string);
        System.out.println("Total coverage " + this.totals[1] + " for file " + string2);
    }

    private void gatherGroup(int n, GeneralVector[] generalVectorArray, LocationVector[] locationVectorArray, VectorMaker vectorMaker, BufferedReader bufferedReader) {
        int n2 = (n + 1) % 2;
        String string = null;
        if (generalVectorArray[n] == null || this.gathered[n]) {
            try {
                string = bufferedReader.readLine();
                generalVectorArray[n] = vectorMaker.makeVector(string);
                this.gathered[n] = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (generalVectorArray[n] != null) {
            if (locationVectorArray[n2].intersects(generalVectorArray[n])) {
                locationVectorArray[n].addLocation(generalVectorArray[n]);
                int n3 = n;
                this.totals[n3] = this.totals[n3] + (long)generalVectorArray[n].size();
                this.gathered[n] = true;
            } else if (locationVectorArray[n].intersects(generalVectorArray[n])) {
                locationVectorArray[n].addLocation(generalVectorArray[n]);
                int n4 = n;
                this.totals[n4] = this.totals[n4] + (long)generalVectorArray[n].size();
                this.gathered[n] = true;
            }
        }
    }

    private BufferedReader getFileReader(String string) throws IOException {
        BufferedReader bufferedReader = null;
        if (string.endsWith(".gz")) {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(bufferedInputStream);
            bufferedReader = new BufferedReader(new InputStreamReader(gZIPInputStream));
        } else {
            FileInputStream fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        }
        return bufferedReader;
    }

    private static VectorMaker getFactory(String string) throws Exception {
        VectorMaker vectorMaker = null;
        if (string.compareTo("gff") == 0) {
            vectorMaker = new GFFVectorFactory();
        } else if (string.compareTo("tab") == 0) {
            vectorMaker = new TabVectorFactory();
        } else {
            throw new Exception("Unknown VectorFactory specified");
        }
        return vectorMaker;
    }

    private static LocationComparator getComparator(String string) throws Exception {
        LocationComparator locationComparator = null;
        if (string.compareTo("lite") == 0) {
            locationComparator = new LocationComparator();
        } else if (string.compareTo("simple") == 0) {
            locationComparator = new SimpleComparator();
        } else if (string.compareTo("levy") == 0) {
            locationComparator = new LevyComparator();
        } else {
            throw new Exception("Unknown LocationComparator specified");
        }
        return locationComparator;
    }
}

