/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.
This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

#include <stdlib.h>
#include "apriltag.h"

apriltag_family_t *tagStandard52h13_create()
{
  apriltag_family_t *tf = (apriltag_family_t *)calloc(1, sizeof(apriltag_family_t));
   tf->name = strdup("tagStandard52h13");
   tf->h = 13;
   tf->ncodes = 48714;
   tf->codes = (uint64_t *)calloc(48714, sizeof(uint64_t));
   tf->codes[0] = 0x0004064a19651ff1UL;
   tf->codes[1] = 0x0004064a53f425b6UL;
   tf->codes[2] = 0x0004064a8e832b7bUL;
   tf->codes[3] = 0x0004064ac9123140UL;
   tf->codes[4] = 0x0004064b03a13705UL;
   tf->codes[5] = 0x0004064b3e303ccaUL;
   tf->codes[6] = 0x0004064b78bf428fUL;
   tf->codes[7] = 0x0004064bb34e4854UL;
   tf->codes[8] = 0x0004064beddd4e19UL;
   tf->codes[9] = 0x0004064c286c53deUL;
   tf->codes[10] = 0x0004064c62fb59a3UL;
   tf->codes[11] = 0x0004064c9d8a5f68UL;
   tf->codes[12] = 0x0004064d12a86af2UL;
   tf->codes[13] = 0x0004064d4d3770b7UL;
   tf->codes[14] = 0x0004064dc2557c41UL;
   tf->codes[15] = 0x0004064dfce48206UL;
   tf->codes[16] = 0x0004064e377387cbUL;
   tf->codes[17] = 0x0004064e72028d90UL;
   tf->codes[18] = 0x0004064eac919355UL;
   tf->codes[19] = 0x0004064f21af9edfUL;
   tf->codes[20] = 0x0004064fd15cb02eUL;
   tf->codes[21] = 0x000406500bebb5f3UL;
   tf->codes[22] = 0x00040650467abbb8UL;
   tf->codes[23] = 0x00040650bb98c742UL;
   tf->codes[24] = 0x00040650f627cd07UL;
   tf->codes[25] = 0x000406516b45d891UL;
   tf->codes[26] = 0x00040651a5d4de56UL;
   tf->codes[27] = 0x000406521af2e9e0UL;
   tf->codes[28] = 0x000406525581efa5UL;
   tf->codes[29] = 0x00040653052f00f4UL;
   tf->codes[30] = 0x000406533fbe06b9UL;
   tf->codes[31] = 0x000406537a4d0c7eUL;
   tf->codes[32] = 0x00040653ef6b1808UL;
   tf->codes[33] = 0x0004065429fa1dcdUL;
   tf->codes[34] = 0x0004065464892392UL;
   tf->codes[35] = 0x000406549f182957UL;
   tf->codes[36] = 0x00040654d9a72f1cUL;
   tf->codes[37] = 0x00040655143634e1UL;
   tf->codes[38] = 0x000406554ec53aa6UL;
   tf->codes[39] = 0x000406558954406bUL;
   tf->codes[40] = 0x00040655c3e34630UL;
   tf->codes[41] = 0x00040655fe724bf5UL;
   tf->codes[42] = 0x000406567390577fUL;
   tf->codes[43] = 0x00040656ae1f5d44UL;
   tf->codes[44] = 0x00040657233d68ceUL;
   tf->codes[45] = 0x00040657985b7458UL;
   tf->codes[46] = 0x00040657d2ea7a1dUL;
   tf->codes[47] = 0x00040658480885a7UL;
   tf->codes[48] = 0x00040658bd269131UL;
   tf->codes[49] = 0x00040659e1f1ae0aUL;
   tf->codes[50] = 0x0004065a919ebf59UL;
   tf->codes[51] = 0x0004065bb669dc32UL;
   tf->codes[52] = 0x0004065bf0f8e1f7UL;
   tf->codes[53] = 0x0004065cdb34f90bUL;
   tf->codes[54] = 0x0004065d15c3fed0UL;
   tf->codes[55] = 0x0004065d50530495UL;
   tf->codes[56] = 0x0004065e3a8f1ba9UL;
   tf->codes[57] = 0x0004065eea3c2cf8UL;
   tf->codes[58] = 0x0004066049964f96UL;
   tf->codes[59] = 0x000406608425555bUL;
   tf->codes[60] = 0x00040660beb45b20UL;
   tf->codes[61] = 0x0004066133d266aaUL;
   tf->codes[62] = 0x00040661e37f77f9UL;
   tf->codes[63] = 0x000406621e0e7dbeUL;
   tf->codes[64] = 0x00040662932c8948UL;
   tf->codes[65] = 0x00040662cdbb8f0dUL;
   tf->codes[66] = 0x00040663084a94d2UL;
   tf->codes[67] = 0x0004066342d99a97UL;
   tf->codes[68] = 0x000406637d68a05cUL;
   tf->codes[69] = 0x00040663f286abe6UL;
   tf->codes[70] = 0x0004066467a4b770UL;
   tf->codes[71] = 0x00040664a233bd35UL;
   tf->codes[72] = 0x00040664dcc2c2faUL;
   tf->codes[73] = 0x000406651751c8bfUL;
   tf->codes[74] = 0x0004066551e0ce84UL;
   tf->codes[75] = 0x00040666b13af122UL;
   tf->codes[76] = 0x00040666ebc9f6e7UL;
   tf->codes[77] = 0x0004066760e80271UL;
   tf->codes[78] = 0x00040668109513c0UL;
   tf->codes[79] = 0x000406684b241985UL;
   tf->codes[80] = 0x00040668fad12ad4UL;
   tf->codes[81] = 0x000406696fef365eUL;
   tf->codes[82] = 0x00040669aa7e3c23UL;
   tf->codes[83] = 0x00040669e50d41e8UL;
   tf->codes[84] = 0x0004066bb9857010UL;
   tf->codes[85] = 0x0004066bf41475d5UL;
   tf->codes[86] = 0x0004066c6932815fUL;
   tf->codes[87] = 0x0004066ca3c18724UL;
   tf->codes[88] = 0x0004066d536e9873UL;
   tf->codes[89] = 0x0004066dc88ca3fdUL;
   tf->codes[90] = 0x0004066e031ba9c2UL;
   tf->codes[91] = 0x0004066eb2c8bb11UL;
   tf->codes[92] = 0x000406704cb1e374UL;
   tf->codes[93] = 0x00040670c1cfeefeUL;
   tf->codes[94] = 0x00040670fc5ef4c3UL;
   tf->codes[95] = 0x0004067136edfa88UL;
   tf->codes[96] = 0x00040671ac0c0612UL;
   tf->codes[97] = 0x00040673bb1339ffUL;
   tf->codes[98] = 0x000406746ac04b4eUL;
   tf->codes[99] = 0x00040676b4568500UL;
   tf->codes[100] = 0x00040676eee58ac5UL;
   tf->codes[101] = 0x000406776403964fUL;
   tf->codes[102] = 0x00040678fdecbeb2UL;
   tf->codes[103] = 0x0004067b4782f864UL;
   tf->codes[104] = 0x0004067c6c4e153dUL;
   tf->codes[105] = 0x0004067ce16c20c7UL;
   tf->codes[106] = 0x0004067d568a2c51UL;
   tf->codes[107] = 0x0004067eb5e44eefUL;
   tf->codes[108] = 0x0004067f2b025a79UL;
   tf->codes[109] = 0x0004067f6591603eUL;
   tf->codes[110] = 0x000406808a5c7d17UL;
   tf->codes[111] = 0x00040680c4eb82dcUL;
   tf->codes[112] = 0x00040680ff7a88a1UL;
   tf->codes[113] = 0x000406817498942bUL;
   tf->codes[114] = 0x00040681e9b69fb5UL;
   tf->codes[115] = 0x000406825ed4ab3fUL;
   tf->codes[116] = 0x00040682d3f2b6c9UL;
   tf->codes[117] = 0x000406834910c253UL;
   tf->codes[118] = 0x00040683be2ecdddUL;
   tf->codes[119] = 0x000406846ddbdf2cUL;
   tf->codes[120] = 0x00040684a86ae4f1UL;
   tf->codes[121] = 0x00040684e2f9eab6UL;
   tf->codes[122] = 0x000406855817f640UL;
   tf->codes[123] = 0x0004068592a6fc05UL;
   tf->codes[124] = 0x00040685cd3601caUL;
   tf->codes[125] = 0x000406867ce31319UL;
   tf->codes[126] = 0x00040686b77218deUL;
   tf->codes[127] = 0x00040687671f2a2dUL;
   tf->codes[128] = 0x00040687a1ae2ff2UL;
   tf->codes[129] = 0x00040688515b4141UL;
   tf->codes[130] = 0x000406888bea4706UL;
   tf->codes[131] = 0x00040689eb4469a4UL;
   tf->codes[132] = 0x0004068a6062752eUL;
   tf->codes[133] = 0x0004068a9af17af3UL;
   tf->codes[134] = 0x0004068ad58080b8UL;
   tf->codes[135] = 0x0004068b100f867dUL;
   tf->codes[136] = 0x0004068b4a9e8c42UL;
   tf->codes[137] = 0x0004068b852d9207UL;
   tf->codes[138] = 0x0004068c34daa356UL;
   tf->codes[139] = 0x0004068ce487b4a5UL;
   tf->codes[140] = 0x0004068d9434c5f4UL;
   tf->codes[141] = 0x0004068dcec3cbb9UL;
   tf->codes[142] = 0x0004068f68acf41cUL;
   tf->codes[143] = 0x0004069052e90b30UL;
   tf->codes[144] = 0x00040691b2432dceUL;
   tf->codes[145] = 0x00040691ecd23393UL;
   tf->codes[146] = 0x0004069261f03f1dUL;
   tf->codes[147] = 0x000406929c7f44e2UL;
   tf->codes[148] = 0x00040692d70e4aa7UL;
   tf->codes[149] = 0x00040693119d506cUL;
   tf->codes[150] = 0x000406934c2c5631UL;
   tf->codes[151] = 0x0004069386bb5bf6UL;
   tf->codes[152] = 0x00040693c14a61bbUL;
   tf->codes[153] = 0x0004069436686d45UL;
   tf->codes[154] = 0x000406955b338a1eUL;
   tf->codes[155] = 0x0004069595c28fe3UL;
   tf->codes[156] = 0x00040695d05195a8UL;
   tf->codes[157] = 0x000406960ae09b6dUL;
   tf->codes[158] = 0x00040696f51cb281UL;
   tf->codes[159] = 0x000406972fabb846UL;
   tf->codes[160] = 0x0004069819e7cf5aUL;
   tf->codes[161] = 0x000406988f05dae4UL;
   tf->codes[162] = 0x000406993eb2ec33UL;
   tf->codes[163] = 0x00040699b3d0f7bdUL;
   tf->codes[164] = 0x0004069ad89c1496UL;
   tf->codes[165] = 0x0004069b4dba2020UL;
   tf->codes[166] = 0x0004069d22324e48UL;
   tf->codes[167] = 0x0004069dd1df5f97UL;
   tf->codes[168] = 0x0004069f6bc887faUL;
   tf->codes[169] = 0x0004069fa6578dbfUL;
   tf->codes[170] = 0x000406a09093a4d3UL;
   tf->codes[171] = 0x000406a105b1b05dUL;
   tf->codes[172] = 0x000406a2650bd2fbUL;
   tf->codes[173] = 0x000406a2da29de85UL;
   tf->codes[174] = 0x000406a4741306e8UL;
   tf->codes[175] = 0x000406a4aea20cadUL;
   tf->codes[176] = 0x000406a4e9311272UL;
   tf->codes[177] = 0x000406a598de23c1UL;
   tf->codes[178] = 0x000406a60dfc2f4bUL;
   tf->codes[179] = 0x000406a6bda9409aUL;
   tf->codes[180] = 0x000406a7a7e557aeUL;
   tf->codes[181] = 0x000406a7e2745d73UL;
   tf->codes[182] = 0x000406a8579268fdUL;
   tf->codes[183] = 0x000406a97c5d85d6UL;
   tf->codes[184] = 0x000406a9b6ec8b9bUL;
   tf->codes[185] = 0x000406ac75a0d0d7UL;
   tf->codes[186] = 0x000406acb02fd69cUL;
   tf->codes[187] = 0x000406af34551613UL;
   tf->codes[188] = 0x000406afa973219dUL;
   tf->codes[189] = 0x000406b0592032ecUL;
   tf->codes[190] = 0x000406b093af38b1UL;
   tf->codes[191] = 0x000406b0ce3e3e76UL;
   tf->codes[192] = 0x000406b1435c4a00UL;
   tf->codes[193] = 0x000406b17deb4fc5UL;
   tf->codes[194] = 0x000406b2682766d9UL;
   tf->codes[195] = 0x000406b2a2b66c9eUL;
   tf->codes[196] = 0x000406b2dd457263UL;
   tf->codes[197] = 0x000406b3c7818977UL;
   tf->codes[198] = 0x000406b61117c329UL;
   tf->codes[199] = 0x000406b64ba6c8eeUL;
   tf->codes[200] = 0x000406b6c0c4d478UL;
   tf->codes[201] = 0x000406b7e58ff151UL;
   tf->codes[202] = 0x000406b85aadfcdbUL;
   tf->codes[203] = 0x000406b944ea13efUL;
   tf->codes[204] = 0x000406ba2f262b03UL;
   tf->codes[205] = 0x000406baa444368dUL;
   tf->codes[206] = 0x000406bb53f147dcUL;
   tf->codes[207] = 0x000406bcb34b6a7aUL;
   tf->codes[208] = 0x000406be87c398a2UL;
   tf->codes[209] = 0x000406bf3770a9f1UL;
   tf->codes[210] = 0x000406c14677dddeUL;
   tf->codes[211] = 0x000406c1bb95e968UL;
   tf->codes[212] = 0x000406c47a4a2ea4UL;
   tf->codes[213] = 0x000406c5648645b8UL;
   tf->codes[214] = 0x000406c64ec25cccUL;
   tf->codes[215] = 0x000406c8233a8af4UL;
   tf->codes[216] = 0x000406c89858967eUL;
   tf->codes[217] = 0x000406c9f7b2b91cUL;
   tf->codes[218] = 0x000406caa75fca6bUL;
   tf->codes[219] = 0x000406cae1eed030UL;
   tf->codes[220] = 0x000406cb570cdbbaUL;
   tf->codes[221] = 0x000406cbcc2ae744UL;
   tf->codes[222] = 0x000406cda0a3156cUL;
   tf->codes[223] = 0x000406cf751b4394UL;
   tf->codes[224] = 0x000406d1f940830bUL;
   tf->codes[225] = 0x000406d68c6cf66fUL;
   tf->codes[226] = 0x000406d7b1381348UL;
   tf->codes[227] = 0x000406dc446486acUL;
   tf->codes[228] = 0x000406dd692fa385UL;
   tf->codes[229] = 0x000406de8dfac05eUL;
   tf->codes[230] = 0x000406dfed54e2fcUL;
   tf->codes[231] = 0x000406e1873e0b5fUL;
   tf->codes[232] = 0x000406e40b634ad6UL;
   tf->codes[233] = 0x000406e5302e67afUL;
   tf->codes[234] = 0x000406e56abd6d74UL;
   tf->codes[235] = 0x000406e73f359b9cUL;
   tf->codes[236] = 0x000406e94e3ccf89UL;
   tf->codes[237] = 0x000406ea7307ec62UL;
   tf->codes[238] = 0x000406eaad96f227UL;
   tf->codes[239] = 0x000406ec0cf114c5UL;
   tf->codes[240] = 0x000406ef40c3658bUL;
   tf->codes[241] = 0x000406f0658e8264UL;
   tf->codes[242] = 0x000406f1153b93b3UL;
   tf->codes[243] = 0x000406f1c4e8a502UL;
   tf->codes[244] = 0x000406f658151866UL;
   tf->codes[245] = 0x000406f742512f7aUL;
   tf->codes[246] = 0x000406f8dc3a57ddUL;
   tf->codes[247] = 0x000406fa010574b6UL;
   tf->codes[248] = 0x000406fb25d0918fUL;
   tf->codes[249] = 0x000407018d75331bUL;
   tf->codes[250] = 0x00040702eccf55b9UL;
   tf->codes[251] = 0x00040703275e5b7eUL;
   tf->codes[252] = 0x0004070361ed6143UL;
   tf->codes[253] = 0x00040704119a7292UL;
   tf->codes[254] = 0x0004070486b87e1cUL;
   tf->codes[255] = 0x00040704c14783e1UL;
   tf->codes[256] = 0x000407065b30ac44UL;
   tf->codes[257] = 0x00040706d04eb7ceUL;
   tf->codes[258] = 0x00040707ba8acee2UL;
   tf->codes[259] = 0x00040708a4c6e5f6UL;
   tf->codes[260] = 0x0004070919e4f180UL;
   tf->codes[261] = 0x0004070ab3ce19e3UL;
   tf->codes[262] = 0x0004070b9e0a30f7UL;
   tf->codes[263] = 0x0004070de7a06aa9UL;
   tf->codes[264] = 0x0004070e974d7bf8UL;
   tf->codes[265] = 0x0004070f0c6b8782UL;
   tf->codes[266] = 0x000407103136a45bUL;
   tf->codes[267] = 0x00040712b55be3d2UL;
   tf->codes[268] = 0x00040712efeae997UL;
   tf->codes[269] = 0x00040713da2700abUL;
   tf->codes[270] = 0x000407144f450c35UL;
   tf->codes[271] = 0x00040714c46317bfUL;
   tf->codes[272] = 0x00040715ae9f2ed3UL;
   tf->codes[273] = 0x00040715e92e3498UL;
   tf->codes[274] = 0x000407170df95171UL;
   tf->codes[275] = 0x0004071783175cfbUL;
   tf->codes[276] = 0x00040717bda662c0UL;
   tf->codes[277] = 0x00040719578f8b23UL;
   tf->codes[278] = 0x00040719921e90e8UL;
   tf->codes[279] = 0x00040719ccad96adUL;
   tf->codes[280] = 0x0004071a073c9c72UL;
   tf->codes[281] = 0x0004071b6696bf10UL;
   tf->codes[282] = 0x0004071ba125c4d5UL;
   tf->codes[283] = 0x0004071bdbb4ca9aUL;
   tf->codes[284] = 0x0004071c50d2d624UL;
   tf->codes[285] = 0x0004071d007fe773UL;
   tf->codes[286] = 0x0004071d3b0eed38UL;
   tf->codes[287] = 0x0004071d759df2fdUL;
   tf->codes[288] = 0x0004071e5fda0a11UL;
   tf->codes[289] = 0x0004071f4a162125UL;
   tf->codes[290] = 0x0004071ff9c33274UL;
   tf->codes[291] = 0x00040720a97043c3UL;
   tf->codes[292] = 0x00040721591d5512UL;
   tf->codes[293] = 0x0004072193ac5ad7UL;
   tf->codes[294] = 0x00040721ce3b609cUL;
   tf->codes[295] = 0x0004072208ca6661UL;
   tf->codes[296] = 0x0004072243596c26UL;
   tf->codes[297] = 0x00040723682488ffUL;
   tf->codes[298] = 0x00040723dd429489UL;
   tf->codes[299] = 0x000407245260a013UL;
   tf->codes[300] = 0x00040725020db162UL;
   tf->codes[301] = 0x00040725772bbcecUL;
   tf->codes[302] = 0x00040725ec49c876UL;
   tf->codes[303] = 0x0004072626d8ce3bUL;
   tf->codes[304] = 0x000407269bf6d9c5UL;
   tf->codes[305] = 0x00040726d685df8aUL;
   tf->codes[306] = 0x000407274ba3eb14UL;
   tf->codes[307] = 0x00040728e58d1377UL;
   tf->codes[308] = 0x0004072a44e73615UL;
   tf->codes[309] = 0x0004072a7f763bdaUL;
   tf->codes[310] = 0x0004072b2f234d29UL;
   tf->codes[311] = 0x0004072bded05e78UL;
   tf->codes[312] = 0x0004072c195f643dUL;
   tf->codes[313] = 0x0004072c8e7d6fc7UL;
   tf->codes[314] = 0x0004072d78b986dbUL;
   tf->codes[315] = 0x0004072e62f59defUL;
   tf->codes[316] = 0x0004072ed813a979UL;
   tf->codes[317] = 0x00040730e71add66UL;
   tf->codes[318] = 0x0004073196c7eeb5UL;
   tf->codes[319] = 0x00040732f6221153UL;
   tf->codes[320] = 0x00040733e05e2867UL;
   tf->codes[321] = 0x000407341aed2e2cUL;
   tf->codes[322] = 0x00040734557c33f1UL;
   tf->codes[323] = 0x00040735b4d6568fUL;
   tf->codes[324] = 0x0004073629f46219UL;
   tf->codes[325] = 0x000407369f126da3UL;
   tf->codes[326] = 0x000407371430792dUL;
   tf->codes[327] = 0x00040737c3dd8a7cUL;
   tf->codes[328] = 0x0004073c919903a5UL;
   tf->codes[329] = 0x0004073ccc28096aUL;
   tf->codes[330] = 0x0004073ea0a03792UL;
   tf->codes[331] = 0x0004073edb2f3d57UL;
   tf->codes[332] = 0x0004073f15be431cUL;
   tf->codes[333] = 0x0004073f504d48e1UL;
   tf->codes[334] = 0x0004073fc56b546bUL;
   tf->codes[335] = 0x0004074199e38293UL;
   tf->codes[336] = 0x00040741d4728858UL;
   tf->codes[337] = 0x00040742841f99a7UL;
   tf->codes[338] = 0x00040742f93da531UL;
   tf->codes[339] = 0x000407436e5bb0bbUL;
   tf->codes[340] = 0x00040746a22e0181UL;
   tf->codes[341] = 0x00040746dcbd0746UL;
   tf->codes[342] = 0x00040747174c0d0bUL;
   tf->codes[343] = 0x0004074a85ad6396UL;
   tf->codes[344] = 0x0004074ac03c695bUL;
   tf->codes[345] = 0x0004074baa78806fUL;
   tf->codes[346] = 0x0004074c1f968bf9UL;
   tf->codes[347] = 0x0004074df40eba21UL;
   tf->codes[348] = 0x00040753e6955023UL;
   tf->codes[349] = 0x00040754212455e8UL;
   tf->codes[350] = 0x00040759d91be625UL;
   tf->codes[351] = 0x0004075bad94144dUL;
   tf->codes[352] = 0x0004075d820c4275UL;
   tf->codes[353] = 0x0004075dbc9b483aUL;
   tf->codes[354] = 0x000407650e7c00daUL;
   tf->codes[355] = 0x00040765839a0c64UL;
   tf->codes[356] = 0x00040765be291229UL;
   tf->codes[357] = 0x0004076758123a8cUL;
   tf->codes[358] = 0x00040769a1a8743eUL;
   tf->codes[359] = 0x0004076a5155858dUL;
   tf->codes[360] = 0x0004076b3b919ca1UL;
   tf->codes[361] = 0x0004076d4a98d08eUL;
   tf->codes[362] = 0x0004076ee481f8f1UL;
   tf->codes[363] = 0x0004077168a73868UL;
   tf->codes[364] = 0x00040772185449b7UL;
   tf->codes[365] = 0x00040773029060cbUL;
   tf->codes[366] = 0x00040774d7088ef3UL;
   tf->codes[367] = 0x00040775119794b8UL;
   tf->codes[368] = 0x000407796a350257UL;
   tf->codes[369] = 0x0004077a19e213a6UL;
   tf->codes[370] = 0x0004077a8f001f30UL;
   tf->codes[371] = 0x0004077b041e2abaUL;
   tf->codes[372] = 0x0004077c63784d58UL;
   tf->codes[373] = 0x0004077e37f07b80UL;
   tf->codes[374] = 0x0004077f974a9e1eUL;
   tf->codes[375] = 0x00040781e0e0d7d0UL;
   tf->codes[376] = 0x0004078305abf4a9UL;
   tf->codes[377] = 0x000407854f422e5bUL;
   tf->codes[378] = 0x00040785c46039e5UL;
   tf->codes[379] = 0x000407884885795cUL;
   tf->codes[380] = 0x0004079084a24910UL;
   tf->codes[381] = 0x00040792591a7738UL;
   tf->codes[382] = 0x00040792ce3882c2UL;
   tf->codes[383] = 0x00040793b87499d6UL;
   tf->codes[384] = 0x000407942d92a560UL;
   tf->codes[385] = 0x00040794a2b0b0eaUL;
   tf->codes[386] = 0x0004079517cebc74UL;
   tf->codes[387] = 0x000407967728df12UL;
   tf->codes[388] = 0x00040798fb4e1e89UL;
   tf->codes[389] = 0x00040799706c2a13UL;
   tf->codes[390] = 0x0004079a20193b62UL;
   tf->codes[391] = 0x0004079ca43e7ad9UL;
   tf->codes[392] = 0x0004079f62f2c015UL;
   tf->codes[393] = 0x000407a296c510dbUL;
   tf->codes[394] = 0x000407a34672222aUL;
   tf->codes[395] = 0x000407a605266766UL;
   tf->codes[396] = 0x000407a67a4472f0UL;
   tf->codes[397] = 0x000407a764808a04UL;
   tf->codes[398] = 0x000407aa9852dacaUL;
   tf->codes[399] = 0x000407ab828ef1deUL;
   tf->codes[400] = 0x000407abf7acfd68UL;
   tf->codes[401] = 0x000407adcc252b90UL;
   tf->codes[402] = 0x000407aef0f04869UL;
   tf->codes[403] = 0x000407afa09d59b8UL;
   tf->codes[404] = 0x000407b13a86821bUL;
   tf->codes[405] = 0x000407b25f519ef4UL;
   tf->codes[406] = 0x000407b3498db608UL;
   tf->codes[407] = 0x000407b5cdb2f57fUL;
   tf->codes[408] = 0x000407b642d10109UL;
   tf->codes[409] = 0x000407b9ebc15d59UL;
   tf->codes[410] = 0x000407bc6fe69cd0UL;
   tf->codes[411] = 0x000407c05365fee5UL;
   tf->codes[412] = 0x000407c1ed4f2748UL;
   tf->codes[413] = 0x000407c2d78b3e5cUL;
   tf->codes[414] = 0x000407c3121a4421UL;
   tf->codes[415] = 0x000407c55bb07dd3UL;
   tf->codes[416] = 0x000407c76ab7b1c0UL;
   tf->codes[417] = 0x000407c904a0da23UL;
   tf->codes[418] = 0x000407c9b44deb72UL;
   tf->codes[419] = 0x000407ca296bf6fcUL;
   tf->codes[420] = 0x000407cbc3551f5fUL;
   tf->codes[421] = 0x000407cc38732ae9UL;
   tf->codes[422] = 0x000407cfe1638739UL;
   tf->codes[423] = 0x000407d140bda9d7UL;
   tf->codes[424] = 0x000407d38a53e389UL;
   tf->codes[425] = 0x000407d55ecc11b1UL;
   tf->codes[426] = 0x000407d9424b73c6UL;
   tf->codes[427] = 0x000407da2c878adaUL;
   tf->codes[428] = 0x000407dadc349c29UL;
   tf->codes[429] = 0x000407de4a95f2b4UL;
   tf->codes[430] = 0x000407df34d209c8UL;
   tf->codes[431] = 0x000407e2a3336053UL;
   tf->codes[432] = 0x000407e527589fcaUL;
   tf->codes[433] = 0x000407e5d705b119UL;
   tf->codes[434] = 0x000407e770eed97cUL;
   tf->codes[435] = 0x000407e85b2af090UL;
   tf->codes[436] = 0x000407ee132280cdUL;
   tf->codes[437] = 0x000407ee88408c57UL;
   tf->codes[438] = 0x000407eefd5e97e1UL;
   tf->codes[439] = 0x000407efad0ba930UL;
   tf->codes[440] = 0x000407f09747c044UL;
   tf->codes[441] = 0x000407f2a64ef431UL;
   tf->codes[442] = 0x000407f3908b0b45UL;
   tf->codes[443] = 0x000407f440381c94UL;
   tf->codes[444] = 0x000407f52a7433a8UL;
   tf->codes[445] = 0x000407f5da2144f7UL;
   tf->codes[446] = 0x000407f64f3f5081UL;
   tf->codes[447] = 0x000407f7e92878e4UL;
   tf->codes[448] = 0x000407f823b77ea9UL;
   tf->codes[449] = 0x000407fa32beb296UL;
   tf->codes[450] = 0x000407fcf172f7d2UL;
   tf->codes[451] = 0x0004080025454898UL;
   tf->codes[452] = 0x000408009a635422UL;
   tf->codes[453] = 0x00040800d4f259e7UL;
   tf->codes[454] = 0x000408010f815facUL;
   tf->codes[455] = 0x000408014a106571UL;
   tf->codes[456] = 0x00040801849f6b36UL;
   tf->codes[457] = 0x00040801f9bd76c0UL;
   tf->codes[458] = 0x000408026edb824aUL;
   tf->codes[459] = 0x00040802e3f98dd4UL;
   tf->codes[460] = 0x000408031e889399UL;
   tf->codes[461] = 0x000408035917995eUL;
   tf->codes[462] = 0x0004080393a69f23UL;
   tf->codes[463] = 0x00040803ce35a4e8UL;
   tf->codes[464] = 0x0004080408c4aaadUL;
   tf->codes[465] = 0x000408044353b072UL;
   tf->codes[466] = 0x000408047de2b637UL;
   tf->codes[467] = 0x00040805681ecd4bUL;
   tf->codes[468] = 0x00040805a2add310UL;
   tf->codes[469] = 0x00040805dd3cd8d5UL;
   tf->codes[470] = 0x0004080617cbde9aUL;
   tf->codes[471] = 0x00040806c778efe9UL;
   tf->codes[472] = 0x000408070207f5aeUL;
   tf->codes[473] = 0x000408073c96fb73UL;
   tf->codes[474] = 0x0004080777260138UL;
   tf->codes[475] = 0x00040807b1b506fdUL;
   tf->codes[476] = 0x00040807ec440cc2UL;
   tf->codes[477] = 0x00040808d68023d6UL;
   tf->codes[478] = 0x00040809110f299bUL;
   tf->codes[479] = 0x00040809862d3525UL;
   tf->codes[480] = 0x00040809fb4b40afUL;
   tf->codes[481] = 0x0004080a70694c39UL;
   tf->codes[482] = 0x0004080aaaf851feUL;
   tf->codes[483] = 0x0004080ae58757c3UL;
   tf->codes[484] = 0x0004080b5aa5634dUL;
   tf->codes[485] = 0x0004080c0a52749cUL;
   tf->codes[486] = 0x0004080c44e17a61UL;
   tf->codes[487] = 0x0004080cb9ff85ebUL;
   tf->codes[488] = 0x0004080cf48e8bb0UL;
   tf->codes[489] = 0x0004080da43b9cffUL;
   tf->codes[490] = 0x0004080e53e8ae4eUL;
   tf->codes[491] = 0x0004080e8e77b413UL;
   tf->codes[492] = 0x0004080fedd1d6b1UL;
   tf->codes[493] = 0x0004081062efe23bUL;
   tf->codes[494] = 0x00040811c24a04d9UL;
   tf->codes[495] = 0x00040811fcd90a9eUL;
   tf->codes[496] = 0x0004081237681063UL;
   tf->codes[497] = 0x0004081271f71628UL;
   tf->codes[498] = 0x00040812ac861bedUL;
   tf->codes[499] = 0x00040812e71521b2UL;
   tf->codes[500] = 0x00040814bb8d4fdaUL;
   tf->codes[501] = 0x00040814f61c559fUL;
   tf->codes[502] = 0x00040815a5c966eeUL;
   tf->codes[503] = 0x000408165576783dUL;
   tf->codes[504] = 0x0004081690057e02UL;
   tf->codes[505] = 0x00040816ca9483c7UL;
   tf->codes[506] = 0x000408170523898cUL;
   tf->codes[507] = 0x000408177a419516UL;
   tf->codes[508] = 0x000408189f0cb1efUL;
   tf->codes[509] = 0x00040818d99bb7b4UL;
   tf->codes[510] = 0x000408194eb9c33eUL;
   tf->codes[511] = 0x00040819c3d7cec8UL;
   tf->codes[512] = 0x0004081a38f5da52UL;
   tf->codes[513] = 0x0004081a7384e017UL;
   tf->codes[514] = 0x0004081b2331f166UL;
   tf->codes[515] = 0x0004081b5dc0f72bUL;
   tf->codes[516] = 0x0004081b984ffcf0UL;
   tf->codes[517] = 0x0004081bd2df02b5UL;
   tf->codes[518] = 0x0004081c0d6e087aUL;
   tf->codes[519] = 0x0004081d32392553UL;
   tf->codes[520] = 0x0004081da75730ddUL;
   tf->codes[521] = 0x0004081ecc224db6UL;
   tf->codes[522] = 0x0004081f41405940UL;
   tf->codes[523] = 0x0004081f7bcf5f05UL;
   tf->codes[524] = 0x000408218ad692f2UL;
   tf->codes[525] = 0x00040821fff49e7cUL;
   tf->codes[526] = 0x00040822afa1afcbUL;
   tf->codes[527] = 0x00040823d46ccca4UL;
   tf->codes[528] = 0x00040824498ad82eUL;
   tf->codes[529] = 0x0004082533c6ef42UL;
   tf->codes[530] = 0x00040825e3740091UL;
   tf->codes[531] = 0x000408261e030656UL;
   tf->codes[532] = 0x00040826932111e0UL;
   tf->codes[533] = 0x0004082742ce232fUL;
   tf->codes[534] = 0x000408277d5d28f4UL;
   tf->codes[535] = 0x00040827f27b347eUL;
   tf->codes[536] = 0x0004082c10899c58UL;
   tf->codes[537] = 0x0004082c4b18a21dUL;
   tf->codes[538] = 0x0004082cfac5b36cUL;
   tf->codes[539] = 0x0004082e1f90d045UL;
   tf->codes[540] = 0x0004082e5a1fd60aUL;
   tf->codes[541] = 0x0004082e94aedbcfUL;
   tf->codes[542] = 0x0004082f09cce759UL;
   tf->codes[543] = 0x0004082f445bed1eUL;
   tf->codes[544] = 0x0004082f7eeaf2e3UL;
   tf->codes[545] = 0x0004082fb979f8a8UL;
   tf->codes[546] = 0x0004082ff408fe6dUL;
   tf->codes[547] = 0x00040830692709f7UL;
   tf->codes[548] = 0x00040830de451581UL;
   tf->codes[549] = 0x00040831c8812c95UL;
   tf->codes[550] = 0x00040832b2bd43a9UL;
   tf->codes[551] = 0x00040832ed4c496eUL;
   tf->codes[552] = 0x0004083327db4f33UL;
   tf->codes[553] = 0x00040833d7886082UL;
   tf->codes[554] = 0x00040834c1c47796UL;
   tf->codes[555] = 0x00040834fc537d5bUL;
   tf->codes[556] = 0x00040836211e9a34UL;
   tf->codes[557] = 0x00040836d0cbab83UL;
   tf->codes[558] = 0x000408370b5ab148UL;
   tf->codes[559] = 0x000408378078bcd2UL;
   tf->codes[560] = 0x00040837bb07c297UL;
   tf->codes[561] = 0x00040838a543d9abUL;
   tf->codes[562] = 0x0004083954f0eafaUL;
   tf->codes[563] = 0x00040839ca0ef684UL;
   tf->codes[564] = 0x0004083a3f2d020eUL;
   tf->codes[565] = 0x0004083a79bc07d3UL;
   tf->codes[566] = 0x0004083bd9162a71UL;
   tf->codes[567] = 0x0004083c4e3435fbUL;
   tf->codes[568] = 0x0004083d38704d0fUL;
   tf->codes[569] = 0x0004083dad8e5899UL;
   tf->codes[570] = 0x0004083de81d5e5eUL;
   tf->codes[571] = 0x0004083f0ce87b37UL;
   tf->codes[572] = 0x000408406c429dd5UL;
   tf->codes[573] = 0x0004084240bacbfdUL;
   tf->codes[574] = 0x00040842b5d8d787UL;
   tf->codes[575] = 0x00040842f067dd4cUL;
   tf->codes[576] = 0x00040843a014ee9bUL;
   tf->codes[577] = 0x000408448a5105afUL;
   tf->codes[578] = 0x00040845af1c2288UL;
   tf->codes[579] = 0x000408469958399cUL;
   tf->codes[580] = 0x0004084749054aebUL;
   tf->codes[581] = 0x00040847f8b25c3aUL;
   tf->codes[582] = 0x000408486dd067c4UL;
   tf->codes[583] = 0x00040848a85f6d89UL;
   tf->codes[584] = 0x0004084a424895ecUL;
   tf->codes[585] = 0x0004084ab766a176UL;
   tf->codes[586] = 0x0004084ba1a2b88aUL;
   tf->codes[587] = 0x0004084d761ae6b2UL;
   tf->codes[588] = 0x0004084e9ae6038bUL;
   tf->codes[589] = 0x0004084ed5750950UL;
   tf->codes[590] = 0x0004084f10040f15UL;
   tf->codes[591] = 0x0004084fbfb12064UL;
   tf->codes[592] = 0x0004084ffa402629UL;
   tf->codes[593] = 0x00040850a9ed3778UL;
   tf->codes[594] = 0x000408511f0b4302UL;
   tf->codes[595] = 0x000408532e1276efUL;
   tf->codes[596] = 0x00040854184e8e03UL;
   tf->codes[597] = 0x0004085452dd93c8UL;
   tf->codes[598] = 0x00040855ecc6bc2bUL;
   tf->codes[599] = 0x000408595b2812b6UL;
   tf->codes[600] = 0x0004085995b7187bUL;
   tf->codes[601] = 0x0004085a0ad52405UL;
   tf->codes[602] = 0x0004085a7ff32f8fUL;
   tf->codes[603] = 0x0004085aba823554UL;
   tf->codes[604] = 0x0004085d79367a90UL;
   tf->codes[605] = 0x0004085f883dae7dUL;
   tf->codes[606] = 0x0004085ffd5bba07UL;
   tf->codes[607] = 0x0004086037eabfccUL;
   tf->codes[608] = 0x00040860e797d11bUL;
   tf->codes[609] = 0x00040861d1d3e82fUL;
   tf->codes[610] = 0x0004086455f927a6UL;
   tf->codes[611] = 0x0004086505a638f5UL;
   tf->codes[612] = 0x000408657ac4447fUL;
   tf->codes[613] = 0x00040865b5534a44UL;
   tf->codes[614] = 0x000408669f8f6158UL;
   tf->codes[615] = 0x0004086a830ec36dUL;
   tf->codes[616] = 0x0004086b32bbd4bcUL;
   tf->codes[617] = 0x0004086ccca4fd1fUL;
   tf->codes[618] = 0x0004086db6e11433UL;
   tf->codes[619] = 0x0004086e2bff1fbdUL;
   tf->codes[620] = 0x0004086e668e2582UL;
   tf->codes[621] = 0x0004086ea11d2b47UL;
   tf->codes[622] = 0x00040870eab364f9UL;
   tf->codes[623] = 0x00040872849c8d5cUL;
   tf->codes[624] = 0x00040872f9ba98e6UL;
   tf->codes[625] = 0x000408736ed8a470UL;
   tf->codes[626] = 0x00040873e3f6affaUL;
   tf->codes[627] = 0x00040874ce32c70eUL;
   tf->codes[628] = 0x00040876681bef71UL;
   tf->codes[629] = 0x00040876dd39fafbUL;
   tf->codes[630] = 0x00040878ec412ee8UL;
   tf->codes[631] = 0x00040879d67d45fcUL;
   tf->codes[632] = 0x0004087a4b9b5186UL;
   tf->codes[633] = 0x0004087afb4862d5UL;
   tf->codes[634] = 0x0004087b70666e5fUL;
   tf->codes[635] = 0x0004087c20137faeUL;
   tf->codes[636] = 0x0004087ccfc090fdUL;
   tf->codes[637] = 0x0004087df48badd6UL;
   tf->codes[638] = 0x0004087f53e5d074UL;
   tf->codes[639] = 0x000408800392e1c3UL;
   tf->codes[640] = 0x0004088162ed0461UL;
   tf->codes[641] = 0x000408819d7c0a26UL;
   tf->codes[642] = 0x000408824d291b75UL;
   tf->codes[643] = 0x0004088337653289UL;
   tf->codes[644] = 0x00040883ac833e13UL;
   tf->codes[645] = 0x000408845c304f62UL;
   tf->codes[646] = 0x00040884d14e5aecUL;
   tf->codes[647] = 0x000408850bdd60b1UL;
   tf->codes[648] = 0x0004088630a87d8aUL;
   tf->codes[649] = 0x000408879002a028UL;
   tf->codes[650] = 0x00040889647ace50UL;
   tf->codes[651] = 0x00040890b65b86f0UL;
   tf->codes[652] = 0x000408912b79927aUL;
   tf->codes[653] = 0x00040891db26a3c9UL;
   tf->codes[654] = 0x00040893af9ed1f1UL;
   tf->codes[655] = 0x000408950ef8f48fUL;
   tf->codes[656] = 0x000408966e53172dUL;
   tf->codes[657] = 0x00040897cdad39cbUL;
   tf->codes[658] = 0x00040898083c3f90UL;
   tf->codes[659] = 0x000408996796622eUL;
   tf->codes[660] = 0x0004089a1743737dUL;
   tf->codes[661] = 0x0004089b3c0e9056UL;
   tf->codes[662] = 0x0004089bb12c9be0UL;
   tf->codes[663] = 0x0004089d1086be7eUL;
   tf->codes[664] = 0x000408a253604331UL;
   tf->codes[665] = 0x000408a2c87e4ebbUL;
   tf->codes[666] = 0x000408a3030d5480UL;
   tf->codes[667] = 0x000408a427d87159UL;
   tf->codes[668] = 0x000408a5c1c199bcUL;
   tf->codes[669] = 0x000408a6e68cb695UL;
   tf->codes[670] = 0x000408a8bb04e4bdUL;
   tf->codes[671] = 0x000408a8f593ea82UL;
   tf->codes[672] = 0x000408a96ab1f60cUL;
   tf->codes[673] = 0x000408abb4482fbeUL;
   tf->codes[674] = 0x000408ad13a2525cUL;
   tf->codes[675] = 0x000408aee81a8084UL;
   tf->codes[676] = 0x000408b340b7ee23UL;
   tf->codes[677] = 0x000408b5ff6c335fUL;
   tf->codes[678] = 0x000408b639fb3924UL;
   tf->codes[679] = 0x000408b6e9a84a73UL;
   tf->codes[680] = 0x000408ba1d7a9b39UL;
   tf->codes[681] = 0x000408ba5809a0feUL;
   tf->codes[682] = 0x000408bb4245b812UL;
   tf->codes[683] = 0x000408bcdc2ee075UL;
   tf->codes[684] = 0x000408be761808d8UL;
   tf->codes[685] = 0x000408beeb361462UL;
   tf->codes[686] = 0x000408bf60541fecUL;
   tf->codes[687] = 0x000408bf9ae325b1UL;
   tf->codes[688] = 0x000408c0851f3cc5UL;
   tf->codes[689] = 0x000408c2942670b2UL;
   tf->codes[690] = 0x000408c2ceb57677UL;
   tf->codes[691] = 0x000408c309447c3cUL;
   tf->codes[692] = 0x000408c3b8f18d8bUL;
   tf->codes[693] = 0x000408c3f3809350UL;
   tf->codes[694] = 0x000408c8c13c0c79UL;
   tf->codes[695] = 0x000408c9365a1803UL;
   tf->codes[696] = 0x000408c9e6072952UL;
   tf->codes[697] = 0x000408ca5b2534dcUL;
   tf->codes[698] = 0x000408cb7ff051b5UL;
   tf->codes[699] = 0x000408cbf50e5d3fUL;
   tf->codes[700] = 0x000408cc6a2c68c9UL;
   tf->codes[701] = 0x000408ccdf4a7453UL;
   tf->codes[702] = 0x000408cd54687fddUL;
   tf->codes[703] = 0x000408cdc9868b67UL;
   tf->codes[704] = 0x000408ce0415912cUL;
   tf->codes[705] = 0x000408ce3ea496f1UL;
   tf->codes[706] = 0x000408cf636fb3caUL;
   tf->codes[707] = 0x000408d0131cc519UL;
   tf->codes[708] = 0x000408d0fd58dc2dUL;
   tf->codes[709] = 0x000408d3bc0d2169UL;
   tf->codes[710] = 0x000408d4e0d83e42UL;
   tf->codes[711] = 0x000408d555f649ccUL;
   tf->codes[712] = 0x000408d5cb145556UL;
   tf->codes[713] = 0x000408d605a35b1bUL;
   tf->codes[714] = 0x000408d72a6e77f4UL;
   tf->codes[715] = 0x000408d764fd7db9UL;
   tf->codes[716] = 0x000408d79f8c837eUL;
   tf->codes[717] = 0x000408d7da1b8943UL;
   tf->codes[718] = 0x000408d814aa8f08UL;
   tf->codes[719] = 0x000408d889c89a92UL;
   tf->codes[720] = 0x000408d8fee6a61cUL;
   tf->codes[721] = 0x000408d9e922bd30UL;
   tf->codes[722] = 0x000408dad35ed444UL;
   tf->codes[723] = 0x000408db830be593UL;
   tf->codes[724] = 0x000408dbbd9aeb58UL;
   tf->codes[725] = 0x000408e43446c0d1UL;
   tf->codes[726] = 0x000408e46ed5c696UL;
   tf->codes[727] = 0x000408e4e3f3d220UL;
   tf->codes[728] = 0x000408e72d8a0bd2UL;
   tf->codes[729] = 0x000408e8525528abUL;
   tf->codes[730] = 0x000408e8c7733435UL;
   tf->codes[731] = 0x000408e9b1af4b49UL;
   tf->codes[732] = 0x000408ed5a9fa799UL;
   tf->codes[733] = 0x000408edcfbdb323UL;
   tf->codes[734] = 0x000408ee44dbbeadUL;
   tf->codes[735] = 0x000408f053e2f29aUL;
   tf->codes[736] = 0x000408f13e1f09aeUL;
   tf->codes[737] = 0x000408f2285b20c2UL;
   tf->codes[738] = 0x000408f29d792c4cUL;
   tf->codes[739] = 0x000408f3129737d6UL;
   tf->codes[740] = 0x000408f4376254afUL;
   tf->codes[741] = 0x000408f4e70f65feUL;
   tf->codes[742] = 0x000408fa6477f076UL;
   tf->codes[743] = 0x000408fd984a413cUL;
   tf->codes[744] = 0x000408fe82865850UL;
   tf->codes[745] = 0x000408febd155e15UL;
   tf->codes[746] = 0x000408ffa7517529UL;
   tf->codes[747] = 0x000409001c6f80b3UL;
   tf->codes[748] = 0x0004090106ab97c7UL;
   tf->codes[749] = 0x00040901b658a916UL;
   tf->codes[750] = 0x00040901f0e7aedbUL;
   tf->codes[751] = 0x000409022b76b4a0UL;
   tf->codes[752] = 0x00040903c55fdd03UL;
   tf->codes[753] = 0x00040904ea2af9dcUL;
   tf->codes[754] = 0x000409068414223fUL;
   tf->codes[755] = 0x00040906f9322dc9UL;
   tf->codes[756] = 0x00040908588c5067UL;
   tf->codes[757] = 0x00040909b7e67305UL;
   tf->codes[758] = 0x0004090a2d047e8fUL;
   tf->codes[759] = 0x0004090aa2228a19UL;
   tf->codes[760] = 0x0004090c017cacb7UL;
   tf->codes[761] = 0x0004090ec030f1f3UL;
   tf->codes[762] = 0x0004090faa6d0907UL;
   tf->codes[763] = 0x000409114456316aUL;
   tf->codes[764] = 0x00040911f40342b9UL;
   tf->codes[765] = 0x00040912de3f59cdUL;
   tf->codes[766] = 0x0004091478288230UL;
   tf->codes[767] = 0x000409159cf39f09UL;
   tf->codes[768] = 0x0004091736dcc76cUL;
   tf->codes[769] = 0x000409198073011eUL;
   tf->codes[770] = 0x0004091a6aaf1832UL;
   tf->codes[771] = 0x0004091c04984095UL;
   tf->codes[772] = 0x0004091cb44551e4UL;
   tf->codes[773] = 0x0004091d9e8168f8UL;
   tf->codes[774] = 0x0004091fad889ce5UL;
   tf->codes[775] = 0x0004091fe817a2aaUL;
   tf->codes[776] = 0x0004092022a6a86fUL;
   tf->codes[777] = 0x000409214771c548UL;
   tf->codes[778] = 0x000409231be9f370UL;
   tf->codes[779] = 0x00040923cb9704bfUL;
   tf->codes[780] = 0x0004092406260a84UL;
   tf->codes[781] = 0x000409252af1275dUL;
   tf->codes[782] = 0x000409268a4b49fbUL;
   tf->codes[783] = 0x0004092948ff8f37UL;
   tf->codes[784] = 0x00040929be1d9ac1UL;
   tf->codes[785] = 0x00040929f8aca086UL;
   tf->codes[786] = 0x0004092a333ba64bUL;
   tf->codes[787] = 0x0004092aa859b1d5UL;
   tf->codes[788] = 0x0004092b5806c324UL;
   tf->codes[789] = 0x0004092e16bb0860UL;
   tf->codes[790] = 0x0004093060514212UL;
   tf->codes[791] = 0x000409309ae047d7UL;
   tf->codes[792] = 0x00040931851c5eebUL;
   tf->codes[793] = 0x00040932e4768189UL;
   tf->codes[794] = 0x0004093409419e62UL;
   tf->codes[795] = 0x000409352e0cbb3bUL;
   tf->codes[796] = 0x00040935ddb9cc8aUL;
   tf->codes[797] = 0x0004093861df0c01UL;
   tf->codes[798] = 0x00040939fbc83464UL;
   tf->codes[799] = 0x0004093a36573a29UL;
   tf->codes[800] = 0x0004093d2f9a852aUL;
   tf->codes[801] = 0x0004093d6a298aefUL;
   tf->codes[802] = 0x0004093e8ef4a7c8UL;
   tf->codes[803] = 0x00040940d88ae17aUL;
   tf->codes[804] = 0x000409414da8ed04UL;
   tf->codes[805] = 0x00040943973f26b6UL;
   tf->codes[806] = 0x00040945a6465aa3UL;
   tf->codes[807] = 0x00040945e0d56068UL;
   tf->codes[808] = 0x00040947b54d8e90UL;
   tf->codes[809] = 0x00040949fee3c842UL;
   tf->codes[810] = 0x0004094a3972ce07UL;
   tf->codes[811] = 0x0004094aae90d991UL;
   tf->codes[812] = 0x0004094c487a01f4UL;
   tf->codes[813] = 0x0004094cbd980d7eUL;
   tf->codes[814] = 0x0004094d32b61908UL;
   tf->codes[815] = 0x0004094f7c4c52baUL;
   tf->codes[816] = 0x00040950668869ceUL;
   tf->codes[817] = 0x0004095116357b1dUL;
   tf->codes[818] = 0x000409535fcbb4cfUL;
   tf->codes[819] = 0x00040953d4e9c059UL;
   tf->codes[820] = 0x00040954bf25d76dUL;
   tf->codes[821] = 0x000409556ed2e8bcUL;
   tf->codes[822] = 0x00040956ce2d0b5aUL;
   tf->codes[823] = 0x0004095708bc111fUL;
   tf->codes[824] = 0x00040958681633bdUL;
   tf->codes[825] = 0x00040958dd343f47UL;
   tf->codes[826] = 0x00040959c770565bUL;
   tf->codes[827] = 0x0004095ecfbad549UL;
   tf->codes[828] = 0x00040960a4330371UL;
   tf->codes[829] = 0x0004096278ab3199UL;
   tf->codes[830] = 0x00040962edc93d23UL;
   tf->codes[831] = 0x0004096571ee7c9aUL;
   tf->codes[832] = 0x00040965e70c8824UL;
   tf->codes[833] = 0x000409665c2a93aeUL;
   tf->codes[834] = 0x0004096780f5b087UL;
   tf->codes[835] = 0x000409686b31c79bUL;
   tf->codes[836] = 0x00040968a5c0cd60UL;
   tf->codes[837] = 0x0004096cc3cf353aUL;
   tf->codes[838] = 0x0004096de89a5213UL;
   tf->codes[839] = 0x0004097032308bc5UL;
   tf->codes[840] = 0x00040971918aae63UL;
   tf->codes[841] = 0x000409765f46278cUL;
   tf->codes[842] = 0x000409770ef338dbUL;
   tf->codes[843] = 0x0004097784114465UL;
   tf->codes[844] = 0x0004097993187852UL;
   tf->codes[845] = 0x0004097d7697da67UL;
   tf->codes[846] = 0x0004097db126e02cUL;
   tf->codes[847] = 0x0004097e2644ebb6UL;
   tf->codes[848] = 0x0004097ed5f1fd05UL;
   tf->codes[849] = 0x0004097f108102caUL;
   tf->codes[850] = 0x00040980354c1fa3UL;
   tf->codes[851] = 0x00040980e4f930f2UL;
   tf->codes[852] = 0x00040983691e7069UL;
   tf->codes[853] = 0x00040984535a877dUL;
   tf->codes[854] = 0x00040984c8789307UL;
   tf->codes[855] = 0x0004098bdfca45e2UL;
   tf->codes[856] = 0x0004098d79b36e45UL;
   tf->codes[857] = 0x0004098deed179cfUL;
   tf->codes[858] = 0x0004098f139c96a8UL;
   tf->codes[859] = 0x00040990e814c4d0UL;
   tf->codes[860] = 0x00040991d250dbe4UL;
   tf->codes[861] = 0x000409920cdfe1a9UL;
   tf->codes[862] = 0x000409941be71596UL;
   tf->codes[863] = 0x00040995b5d03df9UL;
   tf->codes[864] = 0x00040996657d4f48UL;
   tf->codes[865] = 0x000409978a486c21UL;
   tf->codes[866] = 0x00040998e9a28ebfUL;
   tf->codes[867] = 0x0004099924319484UL;
   tf->codes[868] = 0x000409995ec09a49UL;
   tf->codes[869] = 0x0004099c9292eb0fUL;
   tf->codes[870] = 0x0004099df1ed0dadUL;
   tf->codes[871] = 0x0004099edc2924c1UL;
   tf->codes[872] = 0x0004099f16b82a86UL;
   tf->codes[873] = 0x0004099f8bd63610UL;
   tf->codes[874] = 0x000409a0eb3058aeUL;
   tf->codes[875] = 0x000409a41f02a974UL;
   tf->codes[876] = 0x000409a49420b4feUL;
   tf->codes[877] = 0x000409a5093ec088UL;
   tf->codes[878] = 0x000409a62e09dd61UL;
   tf->codes[879] = 0x000409a6ddb6eeb0UL;
   tf->codes[880] = 0x000409a78d63ffffUL;
   tf->codes[881] = 0x000409a99c6b33ecUL;
   tf->codes[882] = 0x000409a9d6fa39b1UL;
   tf->codes[883] = 0x000409aa11893f76UL;
   tf->codes[884] = 0x000409aafbc5568aUL;
   tf->codes[885] = 0x000409aedf44b89fUL;
   tf->codes[886] = 0x000409b0ee4bec8cUL;
   tf->codes[887] = 0x000409b24da60f2aUL;
   tf->codes[888] = 0x000409b337e2263eUL;
   tf->codes[889] = 0x000409b4221e3d52UL;
   tf->codes[890] = 0x000409b45cad4317UL;
   tf->codes[891] = 0x000409b63125713fUL;
   tf->codes[892] = 0x000409b7907f93ddUL;
   tf->codes[893] = 0x000409b7cb0e99a2UL;
   tf->codes[894] = 0x000409b8402ca52cUL;
   tf->codes[895] = 0x000409b9da15cd8fUL;
   tf->codes[896] = 0x000409bac451e4a3UL;
   tf->codes[897] = 0x000409c1a11491b9UL;
   tf->codes[898] = 0x000409c250c1a308UL;
   tf->codes[899] = 0x000409c3006eb457UL;
   tf->codes[900] = 0x000409c33afdba1cUL;
   tf->codes[901] = 0x000409c3b01bc5a6UL;
   tf->codes[902] = 0x000409c50f75e844UL;
   tf->codes[903] = 0x000409c5bf22f993UL;
   tf->codes[904] = 0x000409c6a95f10a7UL;
   tf->codes[905] = 0x000409cac76d7881UL;
   tf->codes[906] = 0x000409cbec38955aUL;
   tf->codes[907] = 0x000409cc26c79b1fUL;
   tf->codes[908] = 0x000409cee57be05bUL;
   tf->codes[909] = 0x000409cf5a99ebe5UL;
   tf->codes[910] = 0x000409d0f4831448UL;
   tf->codes[911] = 0x000409d169a11fd2UL;
   tf->codes[912] = 0x000409d49d737098UL;
   tf->codes[913] = 0x000409d880f2d2adUL;
   tf->codes[914] = 0x000409d9a5bdef86UL;
   tf->codes[915] = 0x000409dcd990404cUL;
   tf->codes[916] = 0x000409de38ea62eaUL;
   tf->codes[917] = 0x000409df98448588UL;
   tf->codes[918] = 0x000409e29187d089UL;
   tf->codes[919] = 0x000409e306a5dc13UL;
   tf->codes[920] = 0x000409e6ea253e28UL;
   tf->codes[921] = 0x000409e724b443edUL;
   tf->codes[922] = 0x000409e7d461553cUL;
   tf->codes[923] = 0x000409e8840e668bUL;
   tf->codes[924] = 0x000409e8be9d6c50UL;
   tf->codes[925] = 0x000409ea1df78eeeUL;
   tf->codes[926] = 0x000409ea93159a78UL;
   tf->codes[927] = 0x000409eb7d51b18cUL;
   tf->codes[928] = 0x000409ed173ad9efUL;
   tf->codes[929] = 0x000409f04b0d2ab5UL;
   tf->codes[930] = 0x000409f1aa674d53UL;
   tf->codes[931] = 0x000409f25a145ea2UL;
   tf->codes[932] = 0x000409f37edf7b7bUL;
   tf->codes[933] = 0x000409f3f3fd8705UL;
   tf->codes[934] = 0x000409f6ed40d206UL;
   tf->codes[935] = 0x000409f7d77ce91aUL;
   tf->codes[936] = 0x000409f8fc4805f3UL;
   tf->codes[937] = 0x000409f97166117dUL;
   tf->codes[938] = 0x000409f9e6841d07UL;
   tf->codes[939] = 0x000409fad0c0341bUL;
   tf->codes[940] = 0x000409fbf58b50f4UL;
   tf->codes[941] = 0x00040a001399b8ceUL;
   tf->codes[942] = 0x00040a00fdd5cfe2UL;
   tf->codes[943] = 0x00040a013864d5a7UL;
   tf->codes[944] = 0x00040a0556733d81UL;
   tf->codes[945] = 0x00040a05cb91490bUL;
   tf->codes[946] = 0x00040a06f05c65e4UL;
   tf->codes[947] = 0x00040a072aeb6ba9UL;
   tf->codes[948] = 0x00040a088a458e47UL;
   tf->codes[949] = 0x00040a08c4d4940cUL;
   tf->codes[950] = 0x00040a0a242eb6aaUL;
   tf->codes[951] = 0x00040a0b48f9d383UL;
   tf->codes[952] = 0x00040a0bbe17df0dUL;
   tf->codes[953] = 0x00040a0e423d1e84UL;
   tf->codes[954] = 0x00040a0f2c793598UL;
   tf->codes[955] = 0x00040a113b806985UL;
   tf->codes[956] = 0x00040a16093be2aeUL;
   tf->codes[957] = 0x00040a16f377f9c2UL;
   tf->codes[958] = 0x00040a181843169bUL;
   tf->codes[959] = 0x00040a188d612225UL;
   tf->codes[960] = 0x00040a19779d3939UL;
   tf->codes[961] = 0x00040a19ecbb44c3UL;
   tf->codes[962] = 0x00040a1d208d9589UL;
   tf->codes[963] = 0x00040a1fa4b2d500UL;
   tf->codes[964] = 0x00040a20545fe64fUL;
   tf->codes[965] = 0x00040a229df62001UL;
   tf->codes[966] = 0x00040a2388323715UL;
   tf->codes[967] = 0x00040a255caa653dUL;
   tf->codes[968] = 0x00040a2855edb03eUL;
   tf->codes[969] = 0x00040a28cb0bbbc8UL;
   tf->codes[970] = 0x00040a2dd3563ab6UL;
   tf->codes[971] = 0x00040a2e83034c05UL;
   tf->codes[972] = 0x00040a2ef821578fUL;
   tf->codes[973] = 0x00040a2fe25d6ea3UL;
   tf->codes[974] = 0x00040a301cec7468UL;
   tf->codes[975] = 0x00040a30920a7ff2UL;
   tf->codes[976] = 0x00040a3107288b7cUL;
   tf->codes[977] = 0x00040a3141b79141UL;
   tf->codes[978] = 0x00040a322bf3a855UL;
   tf->codes[979] = 0x00040a34006bd67dUL;
   tf->codes[980] = 0x00040a352536f356UL;
   tf->codes[981] = 0x00040a376ecd2d08UL;
   tf->codes[982] = 0x00040a3bc76a9aa7UL;
   tf->codes[983] = 0x00040a3d9be2c8cfUL;
   tf->codes[984] = 0x00040a3efb3ceb6dUL;
   tf->codes[985] = 0x00040a3f35cbf132UL;
   tf->codes[986] = 0x00040a4353da590cUL;
   tf->codes[987] = 0x00040a438e695ed1UL;
   tf->codes[988] = 0x00040a43c8f86496UL;
   tf->codes[989] = 0x00040a4528528734UL;
   tf->codes[990] = 0x00040a482195d235UL;
   tf->codes[991] = 0x00040a485c24d7faUL;
   tf->codes[992] = 0x00040a4aa5bb11acUL;
   tf->codes[993] = 0x00040a4b556822fbUL;
   tf->codes[994] = 0x00040a4d9efe5cadUL;
   tf->codes[995] = 0x00040a4f73768ad5UL;
   tf->codes[996] = 0x00040a4fae05909aUL;
   tf->codes[997] = 0x00040a50d2d0ad73UL;
   tf->codes[998] = 0x00040a539184f2afUL;
   tf->codes[999] = 0x00040a57750454c4UL;
   tf->codes[1000] = 0x00040a59840b88b1UL;
   tf->codes[1001] = 0x00040a5a33b89a00UL;
   tf->codes[1002] = 0x00040a5cb7ddd977UL;
   tf->codes[1003] = 0x00040a5cf26cdf3cUL;
   tf->codes[1004] = 0x00040a5ddca8f650UL;
   tf->codes[1005] = 0x00040a61c0285865UL;
   tf->codes[1006] = 0x00040a62aa646f79UL;
   tf->codes[1007] = 0x00040a63cf2f8c52UL;
   tf->codes[1008] = 0x00040a647edc9da1UL;
   tf->codes[1009] = 0x00040a6b211044f2UL;
   tf->codes[1010] = 0x00040a6cf588731aUL;
   tf->codes[1011] = 0x00040a6da5358469UL;
   tf->codes[1012] = 0x00040a6f3f1eacccUL;
   tf->codes[1013] = 0x00040a70d907d52fUL;
   tf->codes[1014] = 0x00040a71fdd2f208UL;
   tf->codes[1015] = 0x00040a7481f8317fUL;
   tf->codes[1016] = 0x00040a794fb3aaa8UL;
   tf->codes[1017] = 0x00040a7e1d6f23d1UL;
   tf->codes[1018] = 0x00040a7f423a40aaUL;
   tf->codes[1019] = 0x00040a840ff5b9d3UL;
   tf->codes[1020] = 0x00040a85e46de7fbUL;
   tf->codes[1021] = 0x00040a86598bf385UL;
   tf->codes[1022] = 0x00040a8743c80a99UL;
   tf->codes[1023] = 0x00040a8868932772UL;
   tf->codes[1024] = 0x00040a8cfbbf9ad6UL;
   tf->codes[1025] = 0x00040a927928254eUL;
   tf->codes[1026] = 0x00040a92ee4630d8UL;
   tf->codes[1027] = 0x00040a93d88247ecUL;
   tf->codes[1028] = 0x00040a970c5498b2UL;
   tf->codes[1029] = 0x00040a9746e39e77UL;
   tf->codes[1030] = 0x00040a9ab544f502UL;
   tf->codes[1031] = 0x00040a9b2a63008cUL;
   tf->codes[1032] = 0x00040a9bda1011dbUL;
   tf->codes[1033] = 0x00040a9d396a3479UL;
   tf->codes[1034] = 0x00040a9e23a64b8dUL;
   tf->codes[1035] = 0x00040a9f48716866UL;
   tf->codes[1036] = 0x00040a9ff81e79b5UL;
   tf->codes[1037] = 0x00040aa48b4aed19UL;
   tf->codes[1038] = 0x00040aa749ff3255UL;
   tf->codes[1039] = 0x00040aa9ce2471ccUL;
   tf->codes[1040] = 0x00040aaffb3a0d93UL;
   tf->codes[1041] = 0x00040ab244d04745UL;
   tf->codes[1042] = 0x00040ab2b9ee52cfUL;
   tf->codes[1043] = 0x00040ab3a42a69e3UL;
   tf->codes[1044] = 0x00040ab7fcc7d782UL;
   tf->codes[1045] = 0x00040ab92192f45bUL;
   tf->codes[1046] = 0x00040aba465e1134UL;
   tf->codes[1047] = 0x00040ababb7c1cbeUL;
   tf->codes[1048] = 0x00040abcca8350abUL;
   tf->codes[1049] = 0x00040ac3e1d50386UL;
   tf->codes[1050] = 0x00040acb6e44c1ebUL;
   tf->codes[1051] = 0x00040acdf26a0162UL;
   tf->codes[1052] = 0x00040ace2cf90727UL;
   tf->codes[1053] = 0x00040acf51c42400UL;
   tf->codes[1054] = 0x00040ad1263c5228UL;
   tf->codes[1055] = 0x00040ad24b076f01UL;
   tf->codes[1056] = 0x00040ad335438615UL;
   tf->codes[1057] = 0x00040ad6a3a4dca0UL;
   tf->codes[1058] = 0x00040ad78de0f3b4UL;
   tf->codes[1059] = 0x00040ad8b2ac108dUL;
   tf->codes[1060] = 0x00040add45d883f1UL;
   tf->codes[1061] = 0x00040addbaf68f7bUL;
   tf->codes[1062] = 0x00040adea532a68fUL;
   tf->codes[1063] = 0x00040ae0b439da7cUL;
   tf->codes[1064] = 0x00040ae21393fd1aUL;
   tf->codes[1065] = 0x00040ae4229b3107UL;
   tf->codes[1066] = 0x00040ae50cd7481bUL;
   tf->codes[1067] = 0x00040ae7566d81cdUL;
   tf->codes[1068] = 0x00040ae790fc8792UL;
   tf->codes[1069] = 0x00040ae96574b5baUL;
   tf->codes[1070] = 0x00040aea8a3fd293UL;
   tf->codes[1071] = 0x00040aedbe122359UL;
   tf->codes[1072] = 0x00040aeea84e3a6dUL;
   tf->codes[1073] = 0x00040af216af90f8UL;
   tf->codes[1074] = 0x00040af46045caaaUL;
   tf->codes[1075] = 0x00040af6e46b0a21UL;
   tf->codes[1076] = 0x00040af71efa0fe6UL;
   tf->codes[1077] = 0x00040af7598915abUL;
   tf->codes[1078] = 0x00040af87e543284UL;
   tf->codes[1079] = 0x00040afb77977d85UL;
   tf->codes[1080] = 0x00040afc9c629a5eUL;
   tf->codes[1081] = 0x00040afeab69ce4bUL;
   tf->codes[1082] = 0x00040aff95a5e55fUL;
   tf->codes[1083] = 0x00040b01a4ad194cUL;
   tf->codes[1084] = 0x00040b033e9641afUL;
   tf->codes[1085] = 0x00040b05c2bb8126UL;
   tf->codes[1086] = 0x00040b06e7869dffUL;
   tf->codes[1087] = 0x00040b075ca4a989UL;
   tf->codes[1088] = 0x00040b079733af4eUL;
   tf->codes[1089] = 0x00040b07d1c2b513UL;
   tf->codes[1090] = 0x00040b0b059505d9UL;
   tf->codes[1091] = 0x00040b0dc4494b15UL;
   tf->codes[1092] = 0x00040b0e73f65c64UL;
   tf->codes[1093] = 0x00040b0f5e327378UL;
   tf->codes[1094] = 0x00040b10f81b9bdbUL;
   tf->codes[1095] = 0x00040b116d39a765UL;
   tf->codes[1096] = 0x00040b129204c43eUL;
   tf->codes[1097] = 0x00040b12cc93ca03UL;
   tf->codes[1098] = 0x00040b19e3e57cdeUL;
   tf->codes[1099] = 0x00040b1b7dcea541UL;
   tf->codes[1100] = 0x00040b1d17b7cda4UL;
   tf->codes[1101] = 0x00040b1fd66c12e0UL;
   tf->codes[1102] = 0x00040b23f47a7abaUL;
   tf->codes[1103] = 0x00040b27284ccb80UL;
   tf->codes[1104] = 0x00040b2887a6ee1eUL;
   tf->codes[1105] = 0x00040b2971e30532UL;
   tf->codes[1106] = 0x00040b29e70110bcUL;
   tf->codes[1107] = 0x00040b2d1ad36182UL;
   tf->codes[1108] = 0x00040b2e050f7896UL;
   tf->codes[1109] = 0x00040b2e3f9e7e5bUL;
   tf->codes[1110] = 0x00040b32d2caf1bfUL;
   tf->codes[1111] = 0x00040b33f7960e98UL;
   tf->codes[1112] = 0x00040b34e1d225acUL;
   tf->codes[1113] = 0x00040b3556f03136UL;
   tf->codes[1114] = 0x00040b372b685f5eUL;
   tf->codes[1115] = 0x00040b38ffe08d86UL;
   tf->codes[1116] = 0x00040b393a6f934bUL;
   tf->codes[1117] = 0x00040b3f2cf6294dUL;
   tf->codes[1118] = 0x00040b413bfd5d3aUL;
   tf->codes[1119] = 0x00040b422639744eUL;
   tf->codes[1120] = 0x00040b4310758b62UL;
   tf->codes[1121] = 0x00040b4609b8d663UL;
   tf->codes[1122] = 0x00040b4818c00a50UL;
   tf->codes[1123] = 0x00040b48534f1015UL;
   tf->codes[1124] = 0x00040b4a9ce549c7UL;
   tf->codes[1125] = 0x00040b4ad7744f8cUL;
   tf->codes[1126] = 0x00040b4bfc3f6c65UL;
   tf->codes[1127] = 0x00040b4e8064abdcUL;
   tf->codes[1128] = 0x00040b4ebaf3b1a1UL;
   tf->codes[1129] = 0x00040b4f3011bd2bUL;
   tf->codes[1130] = 0x00040b522955082cUL;
   tf->codes[1131] = 0x00040b5263e40df1UL;
   tf->codes[1132] = 0x00040b53c33e308fUL;
   tf->codes[1133] = 0x00040b581bdb9e2eUL;
   tf->codes[1134] = 0x00040b5890f9a9b8UL;
   tf->codes[1135] = 0x00040b5940a6bb07UL;
   tf->codes[1136] = 0x00040b5a6571d7e0UL;
   tf->codes[1137] = 0x00040b5b151ee92fUL;
   tf->codes[1138] = 0x00040b5b4fadeef4UL;
   tf->codes[1139] = 0x00040b5bc4cbfa7eUL;
   tf->codes[1140] = 0x00040b62a18ea794UL;
   tf->codes[1141] = 0x00040b638bcabea8UL;
   tf->codes[1142] = 0x00040b643b77cff7UL;
   tf->codes[1143] = 0x00040b64eb24e146UL;
   tf->codes[1144] = 0x00040b6525b3e70bUL;
   tf->codes[1145] = 0x00040b6943c24ee5UL;
   tf->codes[1146] = 0x00040b6a2dfe65f9UL;
   tf->codes[1147] = 0x00040b6a688d6bbeUL;
   tf->codes[1148] = 0x00040b6e4c0ccdd3UL;
   tf->codes[1149] = 0x00040b6fab66f071UL;
   tf->codes[1150] = 0x00040b72df394137UL;
   tf->codes[1151] = 0x00040b75d87c8c38UL;
   tf->codes[1152] = 0x00040b777265b49bUL;
   tf->codes[1153] = 0x00040b7946dde2c3UL;
   tf->codes[1154] = 0x00040b7b1b5610ebUL;
   tf->codes[1155] = 0x00040b7e89b76776UL;
   tf->codes[1156] = 0x00040b8232a7c3c6UL;
   tf->codes[1157] = 0x00040b86162725dbUL;
   tf->codes[1158] = 0x00040b8cf2e9d2f1UL;
   tf->codes[1159] = 0x00040b8e8cd2fb54UL;
   tf->codes[1160] = 0x00040b9026bc23b7UL;
   tf->codes[1161] = 0x00040b909bda2f41UL;
   tf->codes[1162] = 0x00040b92aae1632eUL;
   tf->codes[1163] = 0x00040b940a3b85ccUL;
   tf->codes[1164] = 0x00040b97789cdc57UL;
   tf->codes[1165] = 0x00040b97b32be21cUL;
   tf->codes[1166] = 0x00040b9862d8f36bUL;
   tf->codes[1167] = 0x00040b994d150a7fUL;
   tf->codes[1168] = 0x00040b9b218d38a7UL;
   tf->codes[1169] = 0x00040b9cbb76610aUL;
   tf->codes[1170] = 0x00040b9eca7d94f7UL;
   tf->codes[1171] = 0x00040ba0d984c8e4UL;
   tf->codes[1172] = 0x00040ba2adfcf70cUL;
   tf->codes[1173] = 0x00040ba3231b0296UL;
   tf->codes[1174] = 0x00040ba482752534UL;
   tf->codes[1175] = 0x00040ba532223683UL;
   tf->codes[1176] = 0x00040ba6cc0b5ee6UL;
   tf->codes[1177] = 0x00040ba950309e5dUL;
   tf->codes[1178] = 0x00040ba9ffddafacUL;
   tf->codes[1179] = 0x00040bae587b1d4bUL;
   tf->codes[1180] = 0x00040baf08282e9aUL;
   tf->codes[1181] = 0x00040bb0a21156fdUL;
   tf->codes[1182] = 0x00040bb5353dca61UL;
   tf->codes[1183] = 0x00040bb74444fe4eUL;
   tf->codes[1184] = 0x00040bb98ddb3800UL;
   tf->codes[1185] = 0x00040bbc871e8301UL;
   tf->codes[1186] = 0x00040bbde678a59fUL;
   tf->codes[1187] = 0x00040bc39e7035dcUL;
   tf->codes[1188] = 0x00040bc44e1d472bUL;
   tf->codes[1189] = 0x00040bc6d24286a2UL;
   tf->codes[1190] = 0x00040bc74760922cUL;
   tf->codes[1191] = 0x00040bc95667c619UL;
   tf->codes[1192] = 0x00040bcaf050ee7cUL;
   tf->codes[1193] = 0x00040bcb2adff441UL;
   tf->codes[1194] = 0x00040bcb9ffdffcbUL;
   tf->codes[1195] = 0x00040bcd39e7282eUL;
   tf->codes[1196] = 0x00040bcfbe0c67a5UL;
   tf->codes[1197] = 0x00040bd0e2d7847eUL;
   tf->codes[1198] = 0x00040bd2f1deb86bUL;
   tf->codes[1199] = 0x00040bd7fa293759UL;
   tf->codes[1200] = 0x00040bdaf36c825aUL;
   tf->codes[1201] = 0x00040bddb220c796UL;
   tf->codes[1202] = 0x00040be0ab641297UL;
   tf->codes[1203] = 0x00040be15b1123e6UL;
   tf->codes[1204] = 0x00040be195a029abUL;
   tf->codes[1205] = 0x00040be1d02f2f70UL;
   tf->codes[1206] = 0x00040be36a1857d3UL;
   tf->codes[1207] = 0x00040be628cc9d0fUL;
   tf->codes[1208] = 0x00040beabbf91073UL;
   tf->codes[1209] = 0x00040beffed29526UL;
   tf->codes[1210] = 0x00040bf5f1592b28UL;
   tf->codes[1211] = 0x00040bffc75f233fUL;
   tf->codes[1212] = 0x00040c0001ee2904UL;
   tf->codes[1213] = 0x00040c0544c7adb7UL;
   tf->codes[1214] = 0x00040c05b9e5b941UL;
   tf->codes[1215] = 0x00040c0a128326e0UL;
   tf->codes[1216] = 0x00040c0ac230382fUL;
   tf->codes[1217] = 0x00040c119ef2e545UL;
   tf->codes[1218] = 0x00040c1338dc0da8UL;
   tf->codes[1219] = 0x00040c1498363046UL;
   tf->codes[1220] = 0x00040c171c5b6fbdUL;
   tf->codes[1221] = 0x00040c1791797b47UL;
   tf->codes[1222] = 0x00040c192b62a3aaUL;
   tf->codes[1223] = 0x00040c1c24a5eeabUL;
   tf->codes[1224] = 0x00040c1ea8cb2e22UL;
   tf->codes[1225] = 0x00040c1ee35a33e7UL;
   tf->codes[1226] = 0x00040c2809b31aafUL;
   tf->codes[1227] = 0x00040c29690d3d4dUL;
   tf->codes[1228] = 0x00040c2b7814713aUL;
   tf->codes[1229] = 0x00040c2cd76e93d8UL;
   tf->codes[1230] = 0x00040c2d4c8c9f62UL;
   tf->codes[1231] = 0x00040c2e7157bc3bUL;
   tf->codes[1232] = 0x00040c30805ef028UL;
   tf->codes[1233] = 0x00040c3379a23b29UL;
   tf->codes[1234] = 0x00040c3722929779UL;
   tf->codes[1235] = 0x00040c3bf04e10a2UL;
   tf->codes[1236] = 0x00040c3c2add1667UL;
   tf->codes[1237] = 0x00040c4133279555UL;
   tf->codes[1238] = 0x00040c41e2d4a6a4UL;
   tf->codes[1239] = 0x00040c4a1ef17658UL;
   tf->codes[1240] = 0x00040c4bf369a480UL;
   tf->codes[1241] = 0x00040c4d1834c159UL;
   tf->codes[1242] = 0x00040c4d52c3c71eUL;
   tf->codes[1243] = 0x00040c50fbb4236eUL;
   tf->codes[1244] = 0x00040c52959d4bd1UL;
   tf->codes[1245] = 0x00040c55c96f9c97UL;
   tf->codes[1246] = 0x00040c5603fea25cUL;
   tf->codes[1247] = 0x00040c5e401b7210UL;
   tf->codes[1248] = 0x00040c5f9f7594aeUL;
   tf->codes[1249] = 0x00040c64e24f1961UL;
   tf->codes[1250] = 0x00040c66071a363aUL;
   tf->codes[1251] = 0x00040c667c3841c4UL;
   tf->codes[1252] = 0x00040c693aec8700UL;
   tf->codes[1253] = 0x00040c6bbf11c677UL;
   tf->codes[1254] = 0x00040c6ce3dce350UL;
   tf->codes[1255] = 0x00040c6d9389f49fUL;
   tf->codes[1256] = 0x00040c6e433705eeUL;
   tf->codes[1257] = 0x00040c6f2d731d02UL;
   tf->codes[1258] = 0x00040c7017af3416UL;
   tf->codes[1259] = 0x00040c71ec27623eUL;
   tf->codes[1260] = 0x00040c74e56aad3fUL;
   tf->codes[1261] = 0x00040c78c8ea0f54UL;
   tf->codes[1262] = 0x00040c7903791519UL;
   tf->codes[1263] = 0x00040c7b12804906UL;
   tf->codes[1264] = 0x00040c7dd1348e42UL;
   tf->codes[1265] = 0x00040c817a24ea92UL;
   tf->codes[1266] = 0x00040c8229d1fbe1UL;
   tf->codes[1267] = 0x00040c8a2b5fc5d0UL;
   tf->codes[1268] = 0x00040c8bc548ee33UL;
   tf->codes[1269] = 0x00040c8caf850547UL;
   tf->codes[1270] = 0x00040c8cea140b0cUL;
   tf->codes[1271] = 0x00040c8d24a310d1UL;
   tf->codes[1272] = 0x00040c8ebe8c3934UL;
   tf->codes[1273] = 0x00040c8fa8c85048UL;
   tf->codes[1274] = 0x00040c917d407e70UL;
   tf->codes[1275] = 0x00040c947683c971UL;
   tf->codes[1276] = 0x00040c9b53467687UL;
   tf->codes[1277] = 0x00040c9ced2f9eeaUL;
   tf->codes[1278] = 0x00040c9d9cdcb039UL;
   tf->codes[1279] = 0x00040ca26a982962UL;
   tf->codes[1280] = 0x00040ca354d44076UL;
   tf->codes[1281] = 0x00040ca6138885b2UL;
   tf->codes[1282] = 0x00040ca688a6913cUL;
   tf->codes[1283] = 0x00040ca6c3359701UL;
   tf->codes[1284] = 0x00040ca772e2a850UL;
   tf->codes[1285] = 0x00040ca7e800b3daUL;
   tf->codes[1286] = 0x00040ca897adc529UL;
   tf->codes[1287] = 0x00040ca8d23ccaeeUL;
   tf->codes[1288] = 0x00040cab90f1102aUL;
   tf->codes[1289] = 0x00040cac409e2179UL;
   tf->codes[1290] = 0x00040cad9ff84417UL;
   tf->codes[1291] = 0x00040cadda8749dcUL;
   tf->codes[1292] = 0x00040caf39e16c7aUL;
   tf->codes[1293] = 0x00040cb2e2d1c8caUL;
   tf->codes[1294] = 0x00040cb31d60ce8fUL;
   tf->codes[1295] = 0x00040cb5a1860e06UL;
   tf->codes[1296] = 0x00040cb7eb1c47b8UL;
   tf->codes[1297] = 0x00040cbaa9d08cf4UL;
   tf->codes[1298] = 0x00040cbbce9ba9cdUL;
   tf->codes[1299] = 0x00040cc445477f46UL;
   tf->codes[1300] = 0x00040cc47fd6850bUL;
   tf->codes[1301] = 0x00040cc52f83965aUL;
   tf->codes[1302] = 0x00040cc6544eb333UL;
   tf->codes[1303] = 0x00040cc703fbc482UL;
   tf->codes[1304] = 0x00040cc89de4ece5UL;
   tf->codes[1305] = 0x00040cccf6825a84UL;
   tf->codes[1306] = 0x00040cce906b82e7UL;
   tf->codes[1307] = 0x00040cd189aecde8UL;
   tf->codes[1308] = 0x00040cd1feccd972UL;
   tf->codes[1309] = 0x00040cd398b601d5UL;
   tf->codes[1310] = 0x00040cd5329f2a38UL;
   tf->codes[1311] = 0x00040cd7b6c469afUL;
   tf->codes[1312] = 0x00040cdaea96ba75UL;
   tf->codes[1313] = 0x00040cdc49f0dd13UL;
   tf->codes[1314] = 0x00040cdd342cf427UL;
   tf->codes[1315] = 0x00040ce18cca61c6UL;
   tf->codes[1316] = 0x00040ce1c759678bUL;
   tf->codes[1317] = 0x00040ce23c777315UL;
   tf->codes[1318] = 0x00040ce2ec248464UL;
   tf->codes[1319] = 0x00040ce326b38a29UL;
   tf->codes[1320] = 0x00040ce5aad8c9a0UL;
   tf->codes[1321] = 0x00040ce70a32ec3eUL;
   tf->codes[1322] = 0x00040ceab323488eUL;
   tf->codes[1323] = 0x00040cedac66938fUL;
   tf->codes[1324] = 0x00040cede6f59954UL;
   tf->codes[1325] = 0x00040cf1ca74fb69UL;
   tf->codes[1326] = 0x00040cf4892940a5UL;
   tf->codes[1327] = 0x00040cf623126908UL;
   tf->codes[1328] = 0x00040cf7bcfb916bUL;
   tf->codes[1329] = 0x00040cf832199cf5UL;
   tf->codes[1330] = 0x00040cfa7bafd6a7UL;
   tf->codes[1331] = 0x00040cfaf0cde231UL;
   tf->codes[1332] = 0x00040cfba07af380UL;
   tf->codes[1333] = 0x00040cfe99be3e81UL;
   tf->codes[1334] = 0x00040d02b7cca65bUL;
   tf->codes[1335] = 0x00040d0451b5cebeUL;
   tf->codes[1336] = 0x00040d05eb9ef721UL;
   tf->codes[1337] = 0x00040d069b4c0870UL;
   tf->codes[1338] = 0x00040d0a7ecb6a85UL;
   tf->codes[1339] = 0x00040d0e27bbc6d5UL;
   tf->codes[1340] = 0x00040d1036c2fac2UL;
   tf->codes[1341] = 0x00040d11d0ac2325UL;
   tf->codes[1342] = 0x00040d13dfb35712UL;
   tf->codes[1343] = 0x00040d15b42b853aUL;
   tf->codes[1344] = 0x00040d171385a7d8UL;
   tf->codes[1345] = 0x00040d1788a3b362UL;
   tf->codes[1346] = 0x00040d18e7fdd600UL;
   tf->codes[1347] = 0x00040d19228cdbc5UL;
   tf->codes[1348] = 0x00040d1b6c231577UL;
   tf->codes[1349] = 0x00040d1c1bd026c6UL;
   tf->codes[1350] = 0x00040d1fff4f88dbUL;
   tf->codes[1351] = 0x00040d219938b13eUL;
   tf->codes[1352] = 0x00040d23a83fe52bUL;
   tf->codes[1353] = 0x00040d2a0fe486b7UL;
   tf->codes[1354] = 0x00040d2a4a738c7cUL;
   tf->codes[1355] = 0x00040d2e6881f456UL;
   tf->codes[1356] = 0x00040d30b2182e08UL;
   tf->codes[1357] = 0x00040d319c54451cUL;
   tf->codes[1358] = 0x00040d32c11f61f5UL;
   tf->codes[1359] = 0x00040d39d87114d0UL;
   tf->codes[1360] = 0x00040d3a13001a95UL;
   tf->codes[1361] = 0x00040d3a4d8f205aUL;
   tf->codes[1362] = 0x00040d3bace942f8UL;
   tf->codes[1363] = 0x00040d3ea62c8df9UL;
   tf->codes[1364] = 0x00040d3ee0bb93beUL;
   tf->codes[1365] = 0x00040d3f55d99f48UL;
   tf->codes[1366] = 0x00040d407aa4bc21UL;
   tf->codes[1367] = 0x00040d42148de484UL;
   tf->codes[1368] = 0x00040d424f1cea49UL;
   tf->codes[1369] = 0x00040d433959015dUL;
   tf->codes[1370] = 0x00040d4841a3804bUL;
   tf->codes[1371] = 0x00040d4c9a40edeaUL;
   tf->codes[1372] = 0x00040d4e342a164dUL;
   tf->codes[1373] = 0x00040d4f1e662d61UL;
   tf->codes[1374] = 0x00040d4f58f53326UL;
   tf->codes[1375] = 0x00040d4fce133eb0UL;
   tf->codes[1376] = 0x00040d5008a24475UL;
   tf->codes[1377] = 0x00040d554b7bc928UL;
   tf->codes[1378] = 0x00040d55c099d4b2UL;
   tf->codes[1379] = 0x00040d575a82fd15UL;
   tf->codes[1380] = 0x00040d592efb2b3dUL;
   tf->codes[1381] = 0x00040d59dea83c8cUL;
   tf->codes[1382] = 0x00040d5cd7eb878dUL;
   tf->codes[1383] = 0x00040d654e975d06UL;
   tf->codes[1384] = 0x00040d675d9e90f3UL;
   tf->codes[1385] = 0x00040d6bf0cb0457UL;
   tf->codes[1386] = 0x00040d6d502526f5UL;
   tf->codes[1387] = 0x00040d758c41f6a9UL;
   tf->codes[1388] = 0x00040d76b10d1382UL;
   tf->codes[1389] = 0x00040d78c014476fUL;
   tf->codes[1390] = 0x00040d7acf1b7b5cUL;
   tf->codes[1391] = 0x00040d7b09aa8121UL;
   tf->codes[1392] = 0x00040d7b443986e6UL;
   tf->codes[1393] = 0x00040d7b7ec88cabUL;
   tf->codes[1394] = 0x00040d7e02edcc22UL;
   tf->codes[1395] = 0x00040d7f6247eec0UL;
   tf->codes[1396] = 0x00040d8087130b99UL;
   tf->codes[1397] = 0x00040d84dfb07938UL;
   tf->codes[1398] = 0x00040d8554ce84c2UL;
   tf->codes[1399] = 0x00040d86eeb7ad25UL;
   tf->codes[1400] = 0x00040d8972dcec9cUL;
   tf->codes[1401] = 0x00040d89e7faf826UL;
   tf->codes[1402] = 0x00040d8ad2370f3aUL;
   tf->codes[1403] = 0x00040d8ef0457714UL;
   tf->codes[1404] = 0x00040d91e988c215UL;
   tf->codes[1405] = 0x00040d92d3c4d929UL;
   tf->codes[1406] = 0x00040d946dae018cUL;
   tf->codes[1407] = 0x00040d96079729efUL;
   tf->codes[1408] = 0x00040d9900da74f0UL;
   tf->codes[1409] = 0x00040d993b697ab5UL;
   tf->codes[1410] = 0x00040d9a9ac39d53UL;
   tf->codes[1411] = 0x00040d9dce95ee19UL;
   tf->codes[1412] = 0x00040d9e0924f3deUL;
   tf->codes[1413] = 0x00040da13cf744a4UL;
   tf->codes[1414] = 0x00040da177864a69UL;
   tf->codes[1415] = 0x00040da29c516742UL;
   tf->codes[1416] = 0x00040da52076a6b9UL;
   tf->codes[1417] = 0x00040da59594b243UL;
   tf->codes[1418] = 0x00040da72f7ddaa6UL;
   tf->codes[1419] = 0x00040da7a49be630UL;
   tf->codes[1420] = 0x00040da8c9670309UL;
   tf->codes[1421] = 0x00040da903f608ceUL;
   tf->codes[1422] = 0x00040da9ee321fe2UL;
   tf->codes[1423] = 0x00040dadd1b181f7UL;
   tf->codes[1424] = 0x00040db34f1a0c6fUL;
   tf->codes[1425] = 0x00040db3fec71dbeUL;
   tf->codes[1426] = 0x00040db598b04621UL;
   tf->codes[1427] = 0x00040dba666bbf4aUL;
   tf->codes[1428] = 0x00040dbe0f5c1b9aUL;
   tf->codes[1429] = 0x00040dbe847a2724UL;
   tf->codes[1430] = 0x00040dc2a2888efeUL;
   tf->codes[1431] = 0x00040dc6c096f6d8UL;
   tf->codes[1432] = 0x00040dc90a2d308aUL;
   tf->codes[1433] = 0x00040dc944bc364fUL;
   tf->codes[1434] = 0x00040dcb19346477UL;
   tf->codes[1435] = 0x00040dcc03707b8bUL;
   tf->codes[1436] = 0x00040dcd283b9864UL;
   tf->codes[1437] = 0x00040dcd62ca9e29UL;
   tf->codes[1438] = 0x00040dd0217ee365UL;
   tf->codes[1439] = 0x00040dd2a5a422dcUL;
   tf->codes[1440] = 0x00040dd404fe457aUL;
   tf->codes[1441] = 0x00040dd738d09640UL;
   tf->codes[1442] = 0x00040dd8d2b9bea3UL;
   tf->codes[1443] = 0x00040de099b882cdUL;
   tf->codes[1444] = 0x00040de9faa06f5aUL;
   tf->codes[1445] = 0x00040deaaa4d80a9UL;
   tf->codes[1446] = 0x00040deb948997bdUL;
   tf->codes[1447] = 0x00040decf3e3ba5bUL;
   tf->codes[1448] = 0x00040df445c472fbUL;
   tf->codes[1449] = 0x00040df61a3ca123UL;
   tf->codes[1450] = 0x00040df9fdbc0338UL;
   tf->codes[1451] = 0x00040dfcbc704874UL;
   tf->codes[1452] = 0x00040dfcf6ff4e39UL;
   tf->codes[1453] = 0x00040dfd6c1d59c3UL;
   tf->codes[1454] = 0x00040dfe565970d7UL;
   tf->codes[1455] = 0x00040dff7b248db0UL;
   tf->codes[1456] = 0x00040e05331c1dedUL;
   tf->codes[1457] = 0x00040e08dc0c7a3dUL;
   tf->codes[1458] = 0x00040e0ab084a865UL;
   tf->codes[1459] = 0x00040e0d34a9e7dcUL;
   tf->codes[1460] = 0x00040e10687c38a2UL;
   tf->codes[1461] = 0x00040e11182949f1UL;
   tf->codes[1462] = 0x00040e12eca17819UL;
   tf->codes[1463] = 0x00040e17453ee5b8UL;
   tf->codes[1464] = 0x00040e198ed51f6aUL;
   tf->codes[1465] = 0x00040e1d7254817fUL;
   tf->codes[1466] = 0x00040e291cd2a7beUL;
   tf->codes[1467] = 0x00040e2d005209d3UL;
   tf->codes[1468] = 0x00040e32089c88c1UL;
   tf->codes[1469] = 0x00040e3626aaf09bUL;
   tf->codes[1470] = 0x00040e391fee3b9cUL;
   tf->codes[1471] = 0x00040e3af46669c4UL;
   tf->codes[1472] = 0x00040e4629c68479UL;
   tf->codes[1473] = 0x00040e492309cf7aUL;
   tf->codes[1474] = 0x00040e4db63642deUL;
   tf->codes[1475] = 0x00040e4f8aae7106UL;
   tf->codes[1476] = 0x00040e583be94c44UL;
   tf->codes[1477] = 0x00040e5c1f68ae59UL;
   tf->codes[1478] = 0x00040e5e2e6fe246UL;
   tf->codes[1479] = 0x00040e5fc8590aa9UL;
   tf->codes[1480] = 0x00040e62c19c55aaUL;
   tf->codes[1481] = 0x00040e65badfa0abUL;
   tf->codes[1482] = 0x00040e6d81de64d5UL;
   tf->codes[1483] = 0x00040e6e318b7624UL;
   tf->codes[1484] = 0x00040e70b5b0b59bUL;
   tf->codes[1485] = 0x00040e71da7bd274UL;
   tf->codes[1486] = 0x00040e76a8374b9dUL;
   tf->codes[1487] = 0x00040e771d555727UL;
   tf->codes[1488] = 0x00040e7ac645b377UL;
   tf->codes[1489] = 0x00040e7b00d4b93cUL;
   tf->codes[1490] = 0x00040e7b75f2c4c6UL;
   tf->codes[1491] = 0x00040e86e5e1e540UL;
   tf->codes[1492] = 0x00040e872070eb05UL;
   tf->codes[1493] = 0x00040e8a54433bcbUL;
   tf->codes[1494] = 0x00040e92caef1144UL;
   tf->codes[1495] = 0x00040e9882e6a181UL;
   tf->codes[1496] = 0x00040e9bb6b8f247UL;
   tf->codes[1497] = 0x00040e9fd4c75a21UL;
   tf->codes[1498] = 0x00040ea3b846bc36UL;
   tf->codes[1499] = 0x00040ea79bc61e4bUL;
   tf->codes[1500] = 0x00040eaa5a7a6387UL;
   tf->codes[1501] = 0x00040eab44b67a9bUL;
   tf->codes[1502] = 0x00040eae036abfd7UL;
   tf->codes[1503] = 0x00040eb0c21f0513UL;
   tf->codes[1504] = 0x00040eb5554b7877UL;
   tf->codes[1505] = 0x00040eb6b4a59b15UL;
   tf->codes[1506] = 0x00040ec1af76b005UL;
   tf->codes[1507] = 0x00040ec6b7c12ef3UL;
   tf->codes[1508] = 0x00040ec8c6c862e0UL;
   tf->codes[1509] = 0x00040ed2d75d60bcUL;
   tf->codes[1510] = 0x00040ed55b82a033UL;
   tf->codes[1511] = 0x00040ed6badcc2d1UL;
   tf->codes[1512] = 0x00040edd2281645dUL;
   tf->codes[1513] = 0x00040edebc6a8cc0UL;
   tf->codes[1514] = 0x00040ee17b1ed1fcUL;
   tf->codes[1515] = 0x00040ee1f03cdd86UL;
   tf->codes[1516] = 0x00040ee5992d39d6UL;
   tf->codes[1517] = 0x00040eebc642d59dUL;
   tf->codes[1518] = 0x00040ef561b9c7efUL;
   tf->codes[1519] = 0x00040efa2f754118UL;
   tf->codes[1520] = 0x00040f02e0b01c56UL;
   tf->codes[1521] = 0x00040f04057b392fUL;
   tf->codes[1522] = 0x00040f0f756a59a9UL;
   tf->codes[1523] = 0x00040f10d4c47c47UL;
   tf->codes[1524] = 0x00040f1358e9bbbeUL;
   tf->codes[1525] = 0x00040f139378c183UL;
   tf->codes[1526] = 0x00040f13ce07c748UL;
   tf->codes[1527] = 0x00040f23d1235b26UL;
   tf->codes[1528] = 0x00040f323a55c6a1UL;
   tf->codes[1529] = 0x00040f332491ddb5UL;
   tf->codes[1530] = 0x00040f3692f33440UL;
   tf->codes[1531] = 0x00040f3aeb90a1dfUL;
   tf->codes[1532] = 0x00040f402e6a2692UL;
   tf->codes[1533] = 0x00040f47804adf32UL;
   tf->codes[1534] = 0x00040f49c9e118e4UL;
   tf->codes[1535] = 0x00040f4c88955e20UL;
   tf->codes[1536] = 0x00040f4de7ef80beUL;
   tf->codes[1537] = 0x00040f5f84f43cffUL;
   tf->codes[1538] = 0x00040f6f12f1c553UL;
   tf->codes[1539] = 0x00040f7121f8f940UL;
   tf->codes[1540] = 0x00040f74905a4fcbUL;
   tf->codes[1541] = 0x00040f769f6183b8UL;
   tf->codes[1542] = 0x00040f77c42ca091UL;
   tf->codes[1543] = 0x00040f78ae68b7a5UL;
   tf->codes[1544] = 0x00040f7b328df71cUL;
   tf->codes[1545] = 0x00040f7d07062544UL;
   tf->codes[1546] = 0x00040f7df1423c58UL;
   tf->codes[1547] = 0x00040f82f98cbb46UL;
   tf->codes[1548] = 0x00040f8db9ceca71UL;
   tf->codes[1549] = 0x00040f9580cd8e9bUL;
   tf->codes[1550] = 0x00040f98b49fdf61UL;
   tf->codes[1551] = 0x00040f9a13fa01ffUL;
   tf->codes[1552] = 0x00040f9a89180d89UL;
   tf->codes[1553] = 0x00040f9c981f4176UL;
   tf->codes[1554] = 0x00040f9d825b588aUL;
   tf->codes[1555] = 0x00040fa45f1e05a0UL;
   tf->codes[1556] = 0x00040fa583e92279UL;
   tf->codes[1557] = 0x00040fa6339633c8UL;
   tf->codes[1558] = 0x00040fa71dd24adcUL;
   tf->codes[1559] = 0x00040fa8b7bb733fUL;
   tf->codes[1560] = 0x00040fa92cd97ec9UL;
   tf->codes[1561] = 0x00040fabb0febe40UL;
   tf->codes[1562] = 0x00040fad4ae7e6a3UL;
   tf->codes[1563] = 0x00040fae6fb3037cUL;
   tf->codes[1564] = 0x00040fb07eba3769UL;
   tf->codes[1565] = 0x00040fb6abcfd330UL;
   tf->codes[1566] = 0x00040fb7d09af009UL;
   tf->codes[1567] = 0x00040fbd137474bcUL;
   tf->codes[1568] = 0x00040fc54f914470UL;
   tf->codes[1569] = 0x00040fc724097298UL;
   tf->codes[1570] = 0x00040fceeb0836c2UL;
   tf->codes[1571] = 0x00040fd1a9bc7bfeUL;
   tf->codes[1572] = 0x00040fd1e44b81c3UL;
   tf->codes[1573] = 0x00040fd3f352b5b0UL;
   tf->codes[1574] = 0x00040fd67777f527UL;
   tf->codes[1575] = 0x00040fd6b206faecUL;
   tf->codes[1576] = 0x00040fd7d6d217c5UL;
   tf->codes[1577] = 0x00040fd9ab4a45edUL;
   tf->codes[1578] = 0x00040fdad01562c6UL;
   tf->codes[1579] = 0x00040fdb45336e50UL;
   tf->codes[1580] = 0x00040fdd543aa23dUL;
   tf->codes[1581] = 0x00040fe012eee779UL;
   tf->codes[1582] = 0x00040fe137ba0452UL;
   tf->codes[1583] = 0x00040fe381503e04UL;
   tf->codes[1584] = 0x00040fe46b8c5518UL;
   tf->codes[1585] = 0x00040fe4e0aa60a2UL;
   tf->codes[1586] = 0x00040fe7d9edaba3UL;
   tf->codes[1587] = 0x00040fe8899abcf2UL;
   tf->codes[1588] = 0x00040feb484f022eUL;
   tf->codes[1589] = 0x00040feca7a924ccUL;
   tf->codes[1590] = 0x00040feef13f5e7eUL;
   tf->codes[1591] = 0x00040ff0c5b78ca6UL;
   tf->codes[1592] = 0x00040ffeb9cbec97UL;
   tf->codes[1593] = 0x00041001788031d3UL;
   tf->codes[1594] = 0x00041002282d4322UL;
   tf->codes[1595] = 0x0004100262bc48e7UL;
   tf->codes[1596] = 0x00041002d7da5471UL;
   tf->codes[1597] = 0x000410034cf85ffbUL;
   tf->codes[1598] = 0x00041003c2166b85UL;
   tf->codes[1599] = 0x0004100471c37cd4UL;
   tf->codes[1600] = 0x00041004ac528299UL;
   tf->codes[1601] = 0x0004100521708e23UL;
   tf->codes[1602] = 0x00041005968e99adUL;
   tf->codes[1603] = 0x00041005d11d9f72UL;
   tf->codes[1604] = 0x0004100680cab0c1UL;
   tf->codes[1605] = 0x00041006bb59b686UL;
   tf->codes[1606] = 0x00041007e024d35fUL;
   tf->codes[1607] = 0x000410081ab3d924UL;
   tf->codes[1608] = 0x000410088fd1e4aeUL;
   tf->codes[1609] = 0x00041008ca60ea73UL;
   tf->codes[1610] = 0x000410093f7ef5fdUL;
   tf->codes[1611] = 0x00041009b49d0187UL;
   tf->codes[1612] = 0x00041009ef2c074cUL;
   tf->codes[1613] = 0x0004100a29bb0d11UL;
   tf->codes[1614] = 0x0004100a644a12d6UL;
   tf->codes[1615] = 0x0004100ad9681e60UL;
   tf->codes[1616] = 0x0004100b4e8629eaUL;
   tf->codes[1617] = 0x0004100c735146c3UL;
   tf->codes[1618] = 0x0004100d981c639cUL;
   tf->codes[1619] = 0x0004100dd2ab6961UL;
   tf->codes[1620] = 0x0004100e82587ab0UL;
   tf->codes[1621] = 0x0004100f6c9491c4UL;
   tf->codes[1622] = 0x00041010915fae9dUL;
   tf->codes[1623] = 0x00041011067dba27UL;
   tf->codes[1624] = 0x00041011f0b9d13bUL;
   tf->codes[1625] = 0x00041012a066e28aUL;
   tf->codes[1626] = 0x000410131584ee14UL;
   tf->codes[1627] = 0x000410138aa2f99eUL;
   tf->codes[1628] = 0x00041013ffc10528UL;
   tf->codes[1629] = 0x0004101474df10b2UL;
   tf->codes[1630] = 0x00041014af6e1677UL;
   tf->codes[1631] = 0x0004101599aa2d8bUL;
   tf->codes[1632] = 0x00041016be754a64UL;
   tf->codes[1633] = 0x000410181dcf6d02UL;
   tf->codes[1634] = 0x000410197d298fa0UL;
   tf->codes[1635] = 0x00041019f2479b2aUL;
   tf->codes[1636] = 0x0004101a6765a6b4UL;
   tf->codes[1637] = 0x0004101aa1f4ac79UL;
   tf->codes[1638] = 0x0004101bc6bfc952UL;
   tf->codes[1639] = 0x0004101c766cdaa1UL;
   tf->codes[1640] = 0x0004101cb0fbe066UL;
   tf->codes[1641] = 0x0004101ceb8ae62bUL;
   tf->codes[1642] = 0x0004101e4ae508c9UL;
   tf->codes[1643] = 0x0004101e85740e8eUL;
   tf->codes[1644] = 0x0004101ec0031453UL;
   tf->codes[1645] = 0x0004101efa921a18UL;
   tf->codes[1646] = 0x0004101fe4ce312cUL;
   tf->codes[1647] = 0x00041021b9465f54UL;
   tf->codes[1648] = 0x00041023532f87b7UL;
   tf->codes[1649] = 0x00041023c84d9341UL;
   tf->codes[1650] = 0x0004102402dc9906UL;
   tf->codes[1651] = 0x0004102527a7b5dfUL;
   tf->codes[1652] = 0x00041025d754c72eUL;
   tf->codes[1653] = 0x0004102945b61db9UL;
   tf->codes[1654] = 0x000410298045237eUL;
   tf->codes[1655] = 0x0004102c3ef968baUL;
   tf->codes[1656] = 0x0004102cb4177444UL;
   tf->codes[1657] = 0x0004102dd8e2911dUL;
   tf->codes[1658] = 0x0004102e4e009ca7UL;
   tf->codes[1659] = 0x000410310cb4e1e3UL;
   tf->codes[1660] = 0x0004103390da215aUL;
   tf->codes[1661] = 0x00041034b5a53e33UL;
   tf->codes[1662] = 0x000410368a1d6c5bUL;
   tf->codes[1663] = 0x00041036ff3b77e5UL;
   tf->codes[1664] = 0x000410377459836fUL;
   tf->codes[1665] = 0x0004103a6d9cce70UL;
   tf->codes[1666] = 0x0004103aa82bd435UL;
   tf->codes[1667] = 0x0004103cf1c20de7UL;
   tf->codes[1668] = 0x0004103d66e01971UL;
   tf->codes[1669] = 0x0004103f00c941d4UL;
   tf->codes[1670] = 0x0004103fb0765323UL;
   tf->codes[1671] = 0x0004104060236472UL;
   tf->codes[1672] = 0x00041041fa0c8cd5UL;
   tf->codes[1673] = 0x000410426f2a985fUL;
   tf->codes[1674] = 0x0004104393f5b538UL;
   tf->codes[1675] = 0x00041045dd8beeeaUL;
   tf->codes[1676] = 0x00041046181af4afUL;
   tf->codes[1677] = 0x0004104652a9fa74UL;
   tf->codes[1678] = 0x000410468d390039UL;
   tf->codes[1679] = 0x000410477775174dUL;
   tf->codes[1680] = 0x00041047ec9322d7UL;
   tf->codes[1681] = 0x00041049115e3fb0UL;
   tf->codes[1682] = 0x00041049867c4b3aUL;
   tf->codes[1683] = 0x0004104b95837f27UL;
   tf->codes[1684] = 0x0004104c7fbf963bUL;
   tf->codes[1685] = 0x0004104d69fbad4fUL;
   tf->codes[1686] = 0x0004104e8ec6ca28UL;
   tf->codes[1687] = 0x0004105112ec099fUL;
   tf->codes[1688] = 0x00041051c2991aeeUL;
   tf->codes[1689] = 0x00041052acd53202UL;
   tf->codes[1690] = 0x00041053d1a04edbUL;
   tf->codes[1691] = 0x000410540c2f54a0UL;
   tf->codes[1692] = 0x00041054bbdc65efUL;
   tf->codes[1693] = 0x00041055a6187d03UL;
   tf->codes[1694] = 0x000410561b36888dUL;
   tf->codes[1695] = 0x000410577a90ab2bUL;
   tf->codes[1696] = 0x000410591479d38eUL;
   tf->codes[1697] = 0x00041059c426e4ddUL;
   tf->codes[1698] = 0x00041059feb5eaa2UL;
   tf->codes[1699] = 0x0004105c484c2454UL;
   tf->codes[1700] = 0x0004105ecc7163cbUL;
   tf->codes[1701] = 0x0004105fb6ad7adfUL;
   tf->codes[1702] = 0x00041063250ed16aUL;
   tf->codes[1703] = 0x00041063d4bbe2b9UL;
   tf->codes[1704] = 0x000410648468f408UL;
   tf->codes[1705] = 0x000410656ea50b1cUL;
   tf->codes[1706] = 0x00041066937027f5UL;
   tf->codes[1707] = 0x00041066cdff2dbaUL;
   tf->codes[1708] = 0x00041067f2ca4a93UL;
   tf->codes[1709] = 0x000410682d595058UL;
   tf->codes[1710] = 0x00041069c74278bbUL;
   tf->codes[1711] = 0x0004106ab17e8fcfUL;
   tf->codes[1712] = 0x0004106b269c9b59UL;
   tf->codes[1713] = 0x0004106c10d8b26dUL;
   tf->codes[1714] = 0x0004106daac1dad0UL;
   tf->codes[1715] = 0x0004107153b23720UL;
   tf->codes[1716] = 0x0004107412667c5cUL;
   tf->codes[1717] = 0x000410744cf58221UL;
   tf->codes[1718] = 0x00041074fca29370UL;
   tf->codes[1719] = 0x000410798fcf06d4UL;
   tf->codes[1720] = 0x0004107aef292972UL;
   tf->codes[1721] = 0x0004107b9ed63ac1UL;
   tf->codes[1722] = 0x0004107bd9654086UL;
   tf->codes[1723] = 0x0004107e981985c2UL;
   tf->codes[1724] = 0x0004107f47c69711UL;
   tf->codes[1725] = 0x00041080a720b9afUL;
   tf->codes[1726] = 0x0004108156cdcafeUL;
   tf->codes[1727] = 0x00041081915cd0c3UL;
   tf->codes[1728] = 0x00041081cbebd688UL;
   tf->codes[1729] = 0x000410827b98e7d7UL;
   tf->codes[1730] = 0x00041082f0b6f361UL;
   tf->codes[1731] = 0x00041083a06404b0UL;
   tf->codes[1732] = 0x00041084501115ffUL;
   tf->codes[1733] = 0x000410865f1849ecUL;
   tf->codes[1734] = 0x00041087be726c8aUL;
   tf->codes[1735] = 0x00041088a8ae839eUL;
   tf->codes[1736] = 0x0004108af244bd50UL;
   tf->codes[1737] = 0x0004108b2cd3c315UL;
   tf->codes[1738] = 0x0004108d014bf13dUL;
   tf->codes[1739] = 0x00041090aa3c4d8dUL;
   tf->codes[1740] = 0x0004109368f092c9UL;
   tf->codes[1741] = 0x00041094189da418UL;
   tf->codes[1742] = 0x000410974c6ff4deUL;
   tf->codes[1743] = 0x0004109b6a7e5cb8UL;
   tf->codes[1744] = 0x0004109d0467851bUL;
   tf->codes[1745] = 0x0004109e9e50ad7eUL;
   tf->codes[1746] = 0x000410a0ad57e16bUL;
   tf->codes[1747] = 0x000410a2f6ee1b1dUL;
   tf->codes[1748] = 0x000410a36c0c26a7UL;
   tf->codes[1749] = 0x000410a3a69b2c6cUL;
   tf->codes[1750] = 0x000410a4cb664945UL;
   tf->codes[1751] = 0x000410a5f031661eUL;
   tf->codes[1752] = 0x000410a6da6d7d32UL;
   tf->codes[1753] = 0x000410a7c4a99446UL;
   tf->codes[1754] = 0x000410a7ff389a0bUL;
   tf->codes[1755] = 0x000410aaf87be50cUL;
   tf->codes[1756] = 0x000410ab330aead1UL;
   tf->codes[1757] = 0x000410ab6d99f096UL;
   tf->codes[1758] = 0x000410adf1bf300dUL;
   tf->codes[1759] = 0x000410afc6375e35UL;
   tf->codes[1760] = 0x000410b20fcd97e7UL;
   tf->codes[1761] = 0x000410b36f27ba85UL;
   tf->codes[1762] = 0x000410b41ed4cbd4UL;
   tf->codes[1763] = 0x000410b5f34cf9fcUL;
   tf->codes[1764] = 0x000410b7181816d5UL;
   tf->codes[1765] = 0x000410b752a71c9aUL;
   tf->codes[1766] = 0x000410b78d36225fUL;
   tf->codes[1767] = 0x000410b9d6cc5c11UL;
   tf->codes[1768] = 0x000410ba4bea679bUL;
   tf->codes[1769] = 0x000410bac1087325UL;
   tf->codes[1770] = 0x000410bafb9778eaUL;
   tf->codes[1771] = 0x000410bc9580a14dUL;
   tf->codes[1772] = 0x000410bd0a9eacd7UL;
   tf->codes[1773] = 0x000410bf5434e689UL;
   tf->codes[1774] = 0x000410c1d85a2600UL;
   tf->codes[1775] = 0x000410c45c7f6577UL;
   tf->codes[1776] = 0x000410c4970e6b3cUL;
   tf->codes[1777] = 0x000410c8056fc1c7UL;
   tf->codes[1778] = 0x000410ca4f05fb79UL;
   tf->codes[1779] = 0x000410cac4240703UL;
   tf->codes[1780] = 0x000410cee2326eddUL;
   tf->codes[1781] = 0x000410cf1cc174a2UL;
   tf->codes[1782] = 0x000410cf57507a67UL;
   tf->codes[1783] = 0x000410cfcc6e85f1UL;
   tf->codes[1784] = 0x000410d0418c917bUL;
   tf->codes[1785] = 0x000410d16657ae54UL;
   tf->codes[1786] = 0x000410d2c5b1d0f2UL;
   tf->codes[1787] = 0x000410d30040d6b7UL;
   tf->codes[1788] = 0x000410d50f480aa4UL;
   tf->codes[1789] = 0x000410d66ea22d42UL;
   tf->codes[1790] = 0x000410d6e3c038ccUL;
   tf->codes[1791] = 0x000410d87da9612fUL;
   tf->codes[1792] = 0x000410d8b83866f4UL;
   tf->codes[1793] = 0x000410d8f2c76cb9UL;
   tf->codes[1794] = 0x000410d967e57843UL;
   tf->codes[1795] = 0x000410da17928992UL;
   tf->codes[1796] = 0x000410db01cea0a6UL;
   tf->codes[1797] = 0x000410dc6128c344UL;
   tf->codes[1798] = 0x000410dcd646ceceUL;
   tf->codes[1799] = 0x000410dee54e02bbUL;
   tf->codes[1800] = 0x000410e12ee43c6dUL;
   tf->codes[1801] = 0x000410e42827876eUL;
   tf->codes[1802] = 0x000410e462b68d33UL;
   tf->codes[1803] = 0x000410e49d4592f8UL;
   tf->codes[1804] = 0x000410e671bdc120UL;
   tf->codes[1805] = 0x000410e96b010c21UL;
   tf->codes[1806] = 0x000410e9e01f17abUL;
   tf->codes[1807] = 0x000410ea1aae1d70UL;
   tf->codes[1808] = 0x000410ed4e806e36UL;
   tf->codes[1809] = 0x000410edc39e79c0UL;
   tf->codes[1810] = 0x000410eee8699699UL;
   tf->codes[1811] = 0x000410efd2a5adadUL;
   tf->codes[1812] = 0x000410f0bce1c4c1UL;
   tf->codes[1813] = 0x000410f256caed24UL;
   tf->codes[1814] = 0x000410f3b6250fc2UL;
   tf->codes[1815] = 0x000410f4daf02c9bUL;
   tf->codes[1816] = 0x000410f5157f3260UL;
   tf->codes[1817] = 0x000410f63a4a4f39UL;
   tf->codes[1818] = 0x000410f883e088ebUL;
   tf->codes[1819] = 0x000410f9e33aab89UL;
   tf->codes[1820] = 0x000410fc2cd0e53bUL;
   tf->codes[1821] = 0x000410fd519c0214UL;
   tf->codes[1822] = 0x000410ff60a33601UL;
   tf->codes[1823] = 0x00041101aa396fb3UL;
   tf->codes[1824] = 0x00041103b940a3a0UL;
   tf->codes[1825] = 0x0004110468edb4efUL;
   tf->codes[1826] = 0x0004110811de113fUL;
   tf->codes[1827] = 0x0004110886fc1cc9UL;
   tf->codes[1828] = 0x0004110936a92e18UL;
   tf->codes[1829] = 0x00041109e6563f67UL;
   tf->codes[1830] = 0x0004110b803f67caUL;
   tf->codes[1831] = 0x0004110bbace6d8fUL;
   tf->codes[1832] = 0x0004110eeea0be55UL;
   tf->codes[1833] = 0x0004110fd8dcd569UL;
   tf->codes[1834] = 0x00041110c318ec7dUL;
   tf->codes[1835] = 0x00041113bc5c377eUL;
   tf->codes[1836] = 0x00041113f6eb3d43UL;
   tf->codes[1837] = 0x00041114317a4308UL;
   tf->codes[1838] = 0x000411167b107cbaUL;
   tf->codes[1839] = 0x000411172abd8e09UL;
   tf->codes[1840] = 0x000411179fdb9993UL;
   tf->codes[1841] = 0x00041117da6a9f58UL;
   tf->codes[1842] = 0x000411188a17b0a7UL;
   tf->codes[1843] = 0x0004111939c4c1f6UL;
   tf->codes[1844] = 0x00041119e971d345UL;
   tf->codes[1845] = 0x0004111d92622f95UL;
   tf->codes[1846] = 0x0004111e07803b1fUL;
   tf->codes[1847] = 0x0004111e7c9e46a9UL;
   tf->codes[1848] = 0x0004112100c38620UL;
   tf->codes[1849] = 0x000411229aacae83UL;
   tf->codes[1850] = 0x00041124a9b3e270UL;
   tf->codes[1851] = 0x000411290251500fUL;
   tf->codes[1852] = 0x0004112a9c3a7872UL;
   tf->codes[1853] = 0x0004112fa484f760UL;
   tf->codes[1854] = 0x00041131ee1b3112UL;
   tf->codes[1855] = 0x000411360c2998ecUL;
   tf->codes[1856] = 0x00041136f665b000UL;
   tf->codes[1857] = 0x000411397a8aef77UL;
   tf->codes[1858] = 0x00041139b519f53cUL;
   tf->codes[1859] = 0x0004113c73ce3a78UL;
   tf->codes[1860] = 0x0004113cae5d403dUL;
   tf->codes[1861] = 0x0004113ce8ec4602UL;
   tf->codes[1862] = 0x0004113d237b4bc7UL;
   tf->codes[1863] = 0x000411414189b3a1UL;
   tf->codes[1864] = 0x000411422bc5cab5UL;
   tf->codes[1865] = 0x00041144003df8ddUL;
   tf->codes[1866] = 0x000411460f452ccaUL;
   tf->codes[1867] = 0x0004114dd643f0f4UL;
   tf->codes[1868] = 0x0004115094f83630UL;
   tf->codes[1869] = 0x000411510a1641baUL;
   tf->codes[1870] = 0x0004115144a5477fUL;
   tf->codes[1871] = 0x00041151f45258ceUL;
   tf->codes[1872] = 0x000411552824a994UL;
   tf->codes[1873] = 0x00041156c20dd1f7UL;
   tf->codes[1874] = 0x00041159bb511cf8UL;
   tf->codes[1875] = 0x00041159f5e022bdUL;
   tf->codes[1876] = 0x0004115a6afe2e47UL;
   tf->codes[1877] = 0x0004115e890c9621UL;
   tf->codes[1878] = 0x0004115efe2aa1abUL;
   tf->codes[1879] = 0x0004115f38b9a770UL;
   tf->codes[1880] = 0x0004115f7348ad35UL;
   tf->codes[1881] = 0x000411631c390985UL;
   tf->codes[1882] = 0x00041164f0b137adUL;
   tf->codes[1883] = 0x00041166157c5486UL;
   tf->codes[1884] = 0x00041166500b5a4bUL;
   tf->codes[1885] = 0x000411673a47715fUL;
   tf->codes[1886] = 0x00041167e9f482aeUL;
   tf->codes[1887] = 0x000411685f128e38UL;
   tf->codes[1888] = 0x00041168d43099c2UL;
   tf->codes[1889] = 0x0004116aa8a8c7eaUL;
   tf->codes[1890] = 0x0004116b92e4defeUL;
   tf->codes[1891] = 0x0004116cf23f019cUL;
   tf->codes[1892] = 0x0004116ec6b72fc4UL;
   tf->codes[1893] = 0x0004116fb0f346d8UL;
   tf->codes[1894] = 0x00041172e4c5979eUL;
   tf->codes[1895] = 0x000411740990b477UL;
   tf->codes[1896] = 0x00041175de08e29fUL;
   tf->codes[1897] = 0x000411789cbd27dbUL;
   tf->codes[1898] = 0x00041178d74c2da0UL;
   tf->codes[1899] = 0x0004117a36a6503eUL;
   tf->codes[1900] = 0x0004117a71355603UL;
   tf->codes[1901] = 0x0004117ddf96ac8eUL;
   tf->codes[1902] = 0x0004117e1a25b253UL;
   tf->codes[1903] = 0x0004117f797fd4f1UL;
   tf->codes[1904] = 0x000411809e4af1caUL;
   tf->codes[1905] = 0x0004118238341a2dUL;
   tf->codes[1906] = 0x00041182ad5225b7UL;
   tf->codes[1907] = 0x00041182e7e12b7cUL;
   tf->codes[1908] = 0x00041184473b4e1aUL;
   tf->codes[1909] = 0x000411861bb37c42UL;
   tf->codes[1910] = 0x00041187b59ca4a5UL;
   tf->codes[1911] = 0x00041188da67c17eUL;
   tf->codes[1912] = 0x0004118a7450e9e1UL;
   tf->codes[1913] = 0x0004118bd3ab0c7fUL;
   tf->codes[1914] = 0x0004118c0e3a1244UL;
   tf->codes[1915] = 0x0004118cbde72393UL;
   tf->codes[1916] = 0x0004118de2b2406cUL;
   tf->codes[1917] = 0x00041193d538d66eUL;
   tf->codes[1918] = 0x00041195a9b10496UL;
   tf->codes[1919] = 0x0004119693ed1baaUL;
   tf->codes[1920] = 0x00041197090b2734UL;
   tf->codes[1921] = 0x000411977e2932beUL;
   tf->codes[1922] = 0x0004119a776c7dbfUL;
   tf->codes[1923] = 0x0004119aec8a8949UL;
   tf->codes[1924] = 0x0004119b27198f0eUL;
   tf->codes[1925] = 0x0004119b9c379a98UL;
   tf->codes[1926] = 0x0004119c4be4abe7UL;
   tf->codes[1927] = 0x0004119d3620c2fbUL;
   tf->codes[1928] = 0x0004119d70afc8c0UL;
   tf->codes[1929] = 0x0004119de5cdd44aUL;
   tf->codes[1930] = 0x0004119e957ae599UL;
   tf->codes[1931] = 0x0004119ed009eb5eUL;
   tf->codes[1932] = 0x0004119f0a98f123UL;
   tf->codes[1933] = 0x0004119fba460272UL;
   tf->codes[1934] = 0x000411a363365ec2UL;
   tf->codes[1935] = 0x000411a3d8546a4cUL;
   tf->codes[1936] = 0x000411a488017b9bUL;
   tf->codes[1937] = 0x000411a621eaa3feUL;
   tf->codes[1938] = 0x000411a70c26bb12UL;
   tf->codes[1939] = 0x000411ac898f458aUL;
   tf->codes[1940] = 0x000411af0db48501UL;
   tf->codes[1941] = 0x000411af48438ac6UL;
   tf->codes[1942] = 0x000411b3a0e0f865UL;
   tf->codes[1943] = 0x000411b53aca20c8UL;
   tf->codes[1944] = 0x000411b65f953da1UL;
   tf->codes[1945] = 0x000411b6d4b3492bUL;
   tf->codes[1946] = 0x000411b9cdf6942cUL;
   tf->codes[1947] = 0x000411ba088599f1UL;
   tf->codes[1948] = 0x000411bd3c57eab7UL;
   tf->codes[1949] = 0x000411be269401cbUL;
   tf->codes[1950] = 0x000411be9bb20d55UL;
   tf->codes[1951] = 0x000411c1cf845e1bUL;
   tf->codes[1952] = 0x000411c3a3fc8c43UL;
   tf->codes[1953] = 0x000411c453a99d92UL;
   tf->codes[1954] = 0x000411c74cece893UL;
   tf->codes[1955] = 0x000411c95bf41c80UL;
   tf->codes[1956] = 0x000411c996832245UL;
   tf->codes[1957] = 0x000411caf5dd44e3UL;
   tf->codes[1958] = 0x000411ce643e9b6eUL;
   tf->codes[1959] = 0x000411d07345cf5bUL;
   tf->codes[1960] = 0x000411d3e1a725e6UL;
   tf->codes[1961] = 0x000411d41c362babUL;
   tf->codes[1962] = 0x000411d665cc655dUL;
   tf->codes[1963] = 0x000411db3387de86UL;
   tf->codes[1964] = 0x000411db6e16e44bUL;
   tf->codes[1965] = 0x000411dd7d1e1838UL;
   tf->codes[1966] = 0x000411ddf23c23c2UL;
   tf->codes[1967] = 0x000411de2ccb2987UL;
   tf->codes[1968] = 0x000411dedc783ad6UL;
   tf->codes[1969] = 0x000411e0b0f068feUL;
   tf->codes[1970] = 0x000411e2fa86a2b0UL;
   tf->codes[1971] = 0x000411e459e0c54eUL;
   tf->codes[1972] = 0x000411e5098dd69dUL;
   tf->codes[1973] = 0x000411e5441cdc62UL;
   tf->codes[1974] = 0x000411e62e58f376UL;
   tf->codes[1975] = 0x000411e6de0604c5UL;
   tf->codes[1976] = 0x000411ea86f66115UL;
   tf->codes[1977] = 0x000411ebabc17deeUL;
   tf->codes[1978] = 0x000411ebe65083b3UL;
   tf->codes[1979] = 0x000411ec20df8978UL;
   tf->codes[1980] = 0x000411ef54b1da3eUL;
   tf->codes[1981] = 0x000411f1292a0866UL;
   tf->codes[1982] = 0x000411f1d8d719b5UL;
   tf->codes[1983] = 0x000411f45cfc592cUL;
   tf->codes[1984] = 0x000411fd48c63a2fUL;
   tf->codes[1985] = 0x0004120166d4a209UL;
   tf->codes[1986] = 0x000412071ecc3246UL;
   tf->codes[1987] = 0x000412087e2654e4UL;
   tf->codes[1988] = 0x0004120a529e830cUL;
   tf->codes[1989] = 0x0004120d1152c848UL;
   tf->codes[1990] = 0x0004120e361de521UL;
   tf->codes[1991] = 0x00041212c94a5885UL;
   tf->codes[1992] = 0x0004121378f769d4UL;
   tf->codes[1993] = 0x00041214633380e8UL;
   tf->codes[1994] = 0x00041216723ab4d5UL;
   tf->codes[1995] = 0x00041219e09c0b60UL;
   tf->codes[1996] = 0x000412237c12fdb2UL;
   tf->codes[1997] = 0x000412263ac742eeUL;
   tf->codes[1998] = 0x000412275f925fc7UL;
   tf->codes[1999] = 0x00041227d4b06b51UL;
   tf->codes[2000] = 0x00041228beec8265UL;
   tf->codes[2001] = 0x0004122a9364b08dUL;
   tf->codes[2002] = 0x0004122e3c550cddUL;
   tf->codes[2003] = 0x00041231359857deUL;
   tf->codes[2004] = 0x000412330a108606UL;
   tf->codes[2005] = 0x00041233b9bd9755UL;
   tf->codes[2006] = 0x00041234de88b42eUL;
   tf->codes[2007] = 0x0004123762adf3a5UL;
   tf->codes[2008] = 0x000412379d3cf96aUL;
   tf->codes[2009] = 0x0004123a216238e1UL;
   tf->codes[2010] = 0x0004123a5bf13ea6UL;
   tf->codes[2011] = 0x0004123a9680446bUL;
   tf->codes[2012] = 0x0004123b462d55baUL;
   tf->codes[2013] = 0x0004123d553489a7UL;
   tf->codes[2014] = 0x0004123f9ecac359UL;
   tf->codes[2015] = 0x00041241e860fd0bUL;
   tf->codes[2016] = 0x00041242980e0e5aUL;
   tf->codes[2017] = 0x000412472b3a81beUL;
   tf->codes[2018] = 0x0004124850059e97UL;
   tf->codes[2019] = 0x0004124b4948e998UL;
   tf->codes[2020] = 0x0004124e428c3499UL;
   tf->codes[2021] = 0x0004124f67575172UL;
   tf->codes[2022] = 0x000412538565b94cUL;
   tf->codes[2023] = 0x00041254aa30d625UL;
   tf->codes[2024] = 0x000412564419fe88UL;
   tf->codes[2025] = 0x000412567ea9044dUL;
   tf->codes[2026] = 0x00041258c83f3dffUL;
   tf->codes[2027] = 0x0004125b4c647d76UL;
   tf->codes[2028] = 0x0004125c36a0948aUL;
   tf->codes[2029] = 0x0004125f6a72e550UL;
   tf->codes[2030] = 0x0004125fdf90f0daUL;
   tf->codes[2031] = 0x00041264ad4c6a03UL;
   tf->codes[2032] = 0x00041264e7db6fc8UL;
   tf->codes[2033] = 0x0004126647359266UL;
   tf->codes[2034] = 0x00041267a68fb504UL;
   tf->codes[2035] = 0x00041268563cc653UL;
   tf->codes[2036] = 0x00041268cb5ad1ddUL;
   tf->codes[2037] = 0x00041269b596e8f1UL;
   tf->codes[2038] = 0x0004126a2ab4f47bUL;
   tf->codes[2039] = 0x0004126bc49e1cdeUL;
   tf->codes[2040] = 0x0004126c39bc2868UL;
   tf->codes[2041] = 0x0004126dd3a550cbUL;
   tf->codes[2042] = 0x00041270cce89bccUL;
   tf->codes[2043] = 0x000412710777a191UL;
   tf->codes[2044] = 0x00041271b724b2e0UL;
   tf->codes[2045] = 0x000412722c42be6aUL;
   tf->codes[2046] = 0x00041274b067fde1UL;
   tf->codes[2047] = 0x00041276bf6f31ceUL;
   tf->codes[2048] = 0x0004127859585a31UL;
   tf->codes[2049] = 0x000412797e23770aUL;
   tf->codes[2050] = 0x00041279b8b27ccfUL;
   tf->codes[2051] = 0x0004127a685f8e1eUL;
   tf->codes[2052] = 0x0004128478f48bfaUL;
   tf->codes[2053] = 0x000412877237d6fbUL;
   tf->codes[2054] = 0x0004128aa60a27c1UL;
   tf->codes[2055] = 0x0004128b1b28334bUL;
   tf->codes[2056] = 0x0004128bcad5449aUL;
   tf->codes[2057] = 0x0004128cb5115baeUL;
   tf->codes[2058] = 0x0004128e146b7e4cUL;
   tf->codes[2059] = 0x0004128e898989d6UL;
   tf->codes[2060] = 0x0004128f73c5a0eaUL;
   tf->codes[2061] = 0x00041291483dcf12UL;
   tf->codes[2062] = 0x00041293cc630e89UL;
   tf->codes[2063] = 0x00041295664c36ecUL;
   tf->codes[2064] = 0x00041295a0db3cb1UL;
   tf->codes[2065] = 0x000412968b1753c5UL;
   tf->codes[2066] = 0x0004129775536ad9UL;
   tf->codes[2067] = 0x00041298d4ad8d77UL;
   tf->codes[2068] = 0x00041299845a9ec6UL;
   tf->codes[2069] = 0x000412a5a3f6d08fUL;
   tf->codes[2070] = 0x000412a94ce72cdfUL;
   tf->codes[2071] = 0x000412ab5bee60ccUL;
   tf->codes[2072] = 0x000412ac0b9b721bUL;
   tf->codes[2073] = 0x000412ad30668ef4UL;
   tf->codes[2074] = 0x000412ada5849a7eUL;
   tf->codes[2075] = 0x000412ae1aa2a608UL;
   tf->codes[2076] = 0x000412afef1ad430UL;
   tf->codes[2077] = 0x000412b3980b3080UL;
   tf->codes[2078] = 0x000412b40d293c0aUL;
   tf->codes[2079] = 0x000412bcbe641748UL;
   tf->codes[2080] = 0x000412c0a1e3795dUL;
   tf->codes[2081] = 0x000412c1c6ae9636UL;
   tf->codes[2082] = 0x000412c32608b8d4UL;
   tf->codes[2083] = 0x000412cab2787739UL;
   tf->codes[2084] = 0x000412cbd7439412UL;
   tf->codes[2085] = 0x000412cc86f0a561UL;
   tf->codes[2086] = 0x000412ccc17fab26UL;
   tf->codes[2087] = 0x000412cf8033f062UL;
   tf->codes[2088] = 0x000412d0df8e1300UL;
   tf->codes[2089] = 0x000412d279773b63UL;
   tf->codes[2090] = 0x000412d39e42583cUL;
   tf->codes[2091] = 0x000412daf02310dcUL;
   tf->codes[2092] = 0x000412db9fd0222bUL;
   tf->codes[2093] = 0x000412dc4f7d337aUL;
   tf->codes[2094] = 0x000412dd74485053UL;
   tf->codes[2095] = 0x000412ded3a272f1UL;
   tf->codes[2096] = 0x000412e24203c97cUL;
   tf->codes[2097] = 0x000412e4167bf7a4UL;
   tf->codes[2098] = 0x000412e6d5303ce0UL;
   tf->codes[2099] = 0x000412e7f9fb59b9UL;
   tf->codes[2100] = 0x000412eaf33ea4baUL;
   tf->codes[2101] = 0x000412f837a5f35cUL;
   tf->codes[2102] = 0x000412fe2a2c895eUL;
   tf->codes[2103] = 0x000412ffc415b1c1UL;
   tf->codes[2104] = 0x000413020dabeb73UL;
   tf->codes[2105] = 0x00041302f7e80287UL;
   tf->codes[2106] = 0x00041306db67649cUL;
   tf->codes[2107] = 0x0004130a8457c0ecUL;
   tf->codes[2108] = 0x0004130ccdedfa9eUL;
   tf->codes[2109] = 0x0004130d7d9b0bedUL;
   tf->codes[2110] = 0x0004130df2b91777UL;
   tf->codes[2111] = 0x0004130e2d481d3cUL;
   tf->codes[2112] = 0x0004130fc731459fUL;
   tf->codes[2113] = 0x0004131210c77f51UL;
   tf->codes[2114] = 0x00041315b9b7dba1UL;
   tf->codes[2115] = 0x000413178e3009c9UL;
   tf->codes[2116] = 0x0004131c5beb82f2UL;
   tf->codes[2117] = 0x0004131df5d4ab55UL;
   tf->codes[2118] = 0x0004131e3063b11aUL;
   tf->codes[2119] = 0x00041325f7627544UL;
   tf->codes[2120] = 0x00041326e19e8c58UL;
   tf->codes[2121] = 0x0004132be9e90b46UL;
   tf->codes[2122] = 0x0004132d83d233a9UL;
   tf->codes[2123] = 0x00041330f2338a34UL;
   tf->codes[2124] = 0x00041331dc6fa148UL;
   tf->codes[2125] = 0x00041333eb76d535UL;
   tf->codes[2126] = 0x000413346094e0bfUL;
   tf->codes[2127] = 0x000413354ad0f7d3UL;
   tf->codes[2128] = 0x000413371f4925fbUL;
   tf->codes[2129] = 0x0004133759d82bc0UL;
   tf->codes[2130] = 0x00041339a36e6572UL;
   tf->codes[2131] = 0x0004133e369ad8d6UL;
   tf->codes[2132] = 0x0004133fd0840139UL;
   tf->codes[2133] = 0x000413412fde23d7UL;
   tf->codes[2134] = 0x00041345fd999d00UL;
   tf->codes[2135] = 0x0004134881bedc77UL;
   tf->codes[2136] = 0x00041349e118ff15UL;
   tf->codes[2137] = 0x0004134b407321b3UL;
   tf->codes[2138] = 0x0004134d4f7a55a0UL;
   tf->codes[2139] = 0x0004134dff2766efUL;
   tf->codes[2140] = 0x00041350834ca666UL;
   tf->codes[2141] = 0x000413537c8ff167UL;
   tf->codes[2142] = 0x00041356eaf147f2UL;
   tf->codes[2143] = 0x0004135d5295e97eUL;
   tf->codes[2144] = 0x0004136136154b93UL;
   tf->codes[2145] = 0x00041362956f6e31UL;
   tf->codes[2146] = 0x0004136603d0c4bcUL;
   tf->codes[2147] = 0x00041367289be195UL;
   tf->codes[2148] = 0x0004136b46aa496fUL;
   tf->codes[2149] = 0x0004136c30e66083UL;
   tf->codes[2150] = 0x0004136eb50b9ffaUL;
   tf->codes[2151] = 0x000413725dfbfc4aUL;
   tf->codes[2152] = 0x0004137591ce4d10UL;
   tf->codes[2153] = 0x00041375cc5d52d5UL;
   tf->codes[2154] = 0x00041376f1286faeUL;
   tf->codes[2155] = 0x0004137766467b38UL;
   tf->codes[2156] = 0x00041379afdcb4eaUL;
   tf->codes[2157] = 0x0004137bf972ee9cUL;
   tf->codes[2158] = 0x0004137d1e3e0b75UL;
   tf->codes[2159] = 0x000413808c9f6200UL;
   tf->codes[2160] = 0x0004138a28165452UL;
   tf->codes[2161] = 0x0004138a62a55a17UL;
   tf->codes[2162] = 0x000413913f68072dUL;
   tf->codes[2163] = 0x00041393c38d46a4UL;
   tf->codes[2164] = 0x00041394e858637dUL;
   tf->codes[2165] = 0x00041395d2947a91UL;
   tf->codes[2166] = 0x00041396f75f976aUL;
   tf->codes[2167] = 0x000413981c2ab443UL;
   tf->codes[2168] = 0x000413997b84d6e1UL;
   tf->codes[2169] = 0x0004139d24753331UL;
   tf->codes[2170] = 0x000413a142839b0bUL;
   tf->codes[2171] = 0x000413a1b7a1a695UL;
   tf->codes[2172] = 0x000413a2a1ddbda9UL;
   tf->codes[2173] = 0x000413ae11ccde23UL;
   tf->codes[2174] = 0x000413afe6450c4bUL;
   tf->codes[2175] = 0x000413b1459f2ee9UL;
   tf->codes[2176] = 0x000413b1babd3a73UL;
   tf->codes[2177] = 0x000413b354a662d6UL;
   tf->codes[2178] = 0x000413b9472cf8d8UL;
   tf->codes[2179] = 0x000413b981bbfe9dUL;
   tf->codes[2180] = 0x000413bbcb52384fUL;
   tf->codes[2181] = 0x000413bd653b60b2UL;
   tf->codes[2182] = 0x000413bf7442949fUL;
   tf->codes[2183] = 0x000413bfaed19a64UL;
   tf->codes[2184] = 0x000413bfe960a029UL;
   tf->codes[2185] = 0x000413c148bac2c7UL;
   tf->codes[2186] = 0x000413c232f6d9dbUL;
   tf->codes[2187] = 0x000413c52c3a24dcUL;
   tf->codes[2188] = 0x000413c8257d6fddUL;
   tf->codes[2189] = 0x000413c90fb986f1UL;
   tf->codes[2190] = 0x000413c984d7927bUL;
   tf->codes[2191] = 0x000413cddd75001aUL;
   tf->codes[2192] = 0x000413cfec7c3407UL;
   tf->codes[2193] = 0x000413d186655c6aUL;
   tf->codes[2194] = 0x000413d7b37af831UL;
   tf->codes[2195] = 0x000413d8289903bbUL;
   tf->codes[2196] = 0x000413dcbbc5771fUL;
   tf->codes[2197] = 0x000413e1fe9efbd2UL;
   tf->codes[2198] = 0x000413e398882435UL;
   tf->codes[2199] = 0x000413e6cc5a74fbUL;
   tf->codes[2200] = 0x000413e98b0eba37UL;
   tf->codes[2201] = 0x000413ee93593925UL;
   tf->codes[2202] = 0x000413ef087744afUL;
   tf->codes[2203] = 0x000413f201ba8fb0UL;
   tf->codes[2204] = 0x000413f23c499575UL;
   tf->codes[2205] = 0x000413f276d89b3aUL;
   tf->codes[2206] = 0x000413f2b167a0ffUL;
   tf->codes[2207] = 0x000413f32685ac89UL;
   tf->codes[2208] = 0x000413f5358ce076UL;
   tf->codes[2209] = 0x000413f61fc8f78aUL;
   tf->codes[2210] = 0x000413fa3dd75f64UL;
   tf->codes[2211] = 0x000413fc124f8d8cUL;
   tf->codes[2212] = 0x000413fcc1fc9edbUL;
   tf->codes[2213] = 0x000413fcfc8ba4a0UL;
   tf->codes[2214] = 0x000413fe9674cd03UL;
   tf->codes[2215] = 0x00041408a709cadfUL;
   tf->codes[2216] = 0x00041408e198d0a4UL;
   tf->codes[2217] = 0x0004140cffa7387eUL;
   tf->codes[2218] = 0x0004140e999060e1UL;
   tf->codes[2219] = 0x00041410e3269a93UL;
   tf->codes[2220] = 0x0004141959d2700cUL;
   tf->codes[2221] = 0x0004141b2e4a9e34UL;
   tf->codes[2222] = 0x0004141c8da4c0d2UL;
   tf->codes[2223] = 0x0004141d77e0d7e6UL;
   tf->codes[2224] = 0x0004141decfee370UL;
   tf->codes[2225] = 0x0004141ed73afa84UL;
   tf->codes[2226] = 0x0004141fc1771198UL;
   tf->codes[2227] = 0x0004142195ef3fc0UL;
   tf->codes[2228] = 0x00041422baba5c99UL;
   tf->codes[2229] = 0x000414253edf9c10UL;
   tf->codes[2230] = 0x0004142ba6843d9cUL;
   tf->codes[2231] = 0x0004142d05de603aUL;
   tf->codes[2232] = 0x0004142d7afc6bc4UL;
   tf->codes[2233] = 0x0004142eda568e62UL;
   tf->codes[2234] = 0x0004142fc492a576UL;
   tf->codes[2235] = 0x0004143af9f2c02bUL;
   tf->codes[2236] = 0x0004144211447306UL;
   tf->codes[2237] = 0x000414424bd378cbUL;
   tf->codes[2238] = 0x00041444cff8b842UL;
   tf->codes[2239] = 0x00041447198ef1f4UL;
   tf->codes[2240] = 0x00041449289625e1UL;
   tf->codes[2241] = 0x0004144fcac9cd32UL;
   tf->codes[2242] = 0x000414519f41fb5aUL;
   tf->codes[2243] = 0x0004145806e69ce6UL;
   tf->codes[2244] = 0x00041458b693ae35UL;
   tf->codes[2245] = 0x00041459a0cfc549UL;
   tf->codes[2246] = 0x0004145bafd6f936UL;
   tf->codes[2247] = 0x0004145d0f311bd4UL;
   tf->codes[2248] = 0x0004145df96d32e8UL;
   tf->codes[2249] = 0x000414633c46b79bUL;
   tf->codes[2250] = 0x00041464d62fdffeUL;
   tf->codes[2251] = 0x00041466358a029cUL;
   tf->codes[2252] = 0x00041466aaa80e26UL;
   tf->codes[2253] = 0x0004146bb2f28d14UL;
   tf->codes[2254] = 0x00041470461f0078UL;
   tf->codes[2255] = 0x00041471a5792316UL;
   tf->codes[2256] = 0x00041471e00828dbUL;
   tf->codes[2257] = 0x00041472ca443fefUL;
   tf->codes[2258] = 0x00041475fe1690b5UL;
   tf->codes[2259] = 0x0004147722e1ad8eUL;
   tf->codes[2260] = 0x000414775d70b353UL;
   tf->codes[2261] = 0x00041478f759dbb6UL;
   tf->codes[2262] = 0x0004147ee9e071b8UL;
   tf->codes[2263] = 0x0004148292d0ce08UL;
   tf->codes[2264] = 0x0004148307eed992UL;
   tf->codes[2265] = 0x00041483f22af0a6UL;
   tf->codes[2266] = 0x0004148516f60d7fUL;
   tf->codes[2267] = 0x000414867650301dUL;
   tf->codes[2268] = 0x000414884ac85e45UL;
   tf->codes[2269] = 0x00041489e4b186a8UL;
   tf->codes[2270] = 0x0004148aceed9dbcUL;
   tf->codes[2271] = 0x0004148d5312dd33UL;
   tf->codes[2272] = 0x0004148dc830e8bdUL;
   tf->codes[2273] = 0x0004149011c7226fUL;
   tf->codes[2274] = 0x0004149220ce565cUL;
   tf->codes[2275] = 0x000414946a64900eUL;
   tf->codes[2276] = 0x00041496044db871UL;
   tf->codes[2277] = 0x000414984de3f223UL;
   tf->codes[2278] = 0x0004149938200937UL;
   tf->codes[2279] = 0x00041499ad3e14c1UL;
   tf->codes[2280] = 0x0004149ca6815fc2UL;
   tf->codes[2281] = 0x000414a5924b40c5UL;
   tf->codes[2282] = 0x000414a607694c4fUL;
   tf->codes[2283] = 0x000414ab4a42d102UL;
   tf->codes[2284] = 0x000414ad1ebaff2aUL;
   tf->codes[2285] = 0x000414b1023a613fUL;
   tf->codes[2286] = 0x000414b3c0eea67bUL;
   tf->codes[2287] = 0x000414b3fb7dac40UL;
   tf->codes[2288] = 0x000414b6ba31f17cUL;
   tf->codes[2289] = 0x000414b8c9392569UL;
   tf->codes[2290] = 0x000414ba9db15391UL;
   tf->codes[2291] = 0x000414bc722981b9UL;
   tf->codes[2292] = 0x000414bd21d69308UL;
   tf->codes[2293] = 0x000414be8130b5a6UL;
   tf->codes[2294] = 0x000414c22a2111f6UL;
   tf->codes[2295] = 0x000414c29f3f1d80UL;
   tf->codes[2296] = 0x000414c4392845e3UL;
   tf->codes[2297] = 0x000414c55df362bcUL;
   tf->codes[2298] = 0x000414c81ca7a7f8UL;
   tf->codes[2299] = 0x000414c9b690d05bUL;
   tf->codes[2300] = 0x000414ca663de1aaUL;
   tf->codes[2301] = 0x000414cc00270a0dUL;
   tf->codes[2302] = 0x000414cd9a103270UL;
   tf->codes[2303] = 0x000414ce844c4984UL;
   tf->codes[2304] = 0x000414d093537d71UL;
   tf->codes[2305] = 0x000414d22d3ca5d4UL;
   tf->codes[2306] = 0x000414d267cbab99UL;
   tf->codes[2307] = 0x000414d31778bce8UL;
   tf->codes[2308] = 0x000414d35207c2adUL;
   tf->codes[2309] = 0x000414d9f43b69feUL;
   tf->codes[2310] = 0x000414dd629cc089UL;
   tf->codes[2311] = 0x000414de4cd8d79dUL;
   tf->codes[2312] = 0x000414df71a3f476UL;
   tf->codes[2313] = 0x000414e1f5c933edUL;
   tf->codes[2314] = 0x000414e3ca416215UL;
   tf->codes[2315] = 0x000414e5299b84b3UL;
   tf->codes[2316] = 0x000414e688f5a751UL;
   tf->codes[2317] = 0x000414e7e84fc9efUL;
   tf->codes[2318] = 0x000414ec40ed378eUL;
   tf->codes[2319] = 0x000414ec7b7c3d53UL;
   tf->codes[2320] = 0x000414efaf4e8e19UL;
   tf->codes[2321] = 0x000414f14937b67cUL;
   tf->codes[2322] = 0x000414f26e02d355UL;
   tf->codes[2323] = 0x000414f392cdf02eUL;
   tf->codes[2324] = 0x000414f910367aa6UL;
   tf->codes[2325] = 0x000414f985548630UL;
   tf->codes[2326] = 0x000414f9bfe38bf5UL;
   tf->codes[2327] = 0x000414fae4aea8ceUL;
   tf->codes[2328] = 0x000414fb945bba1dUL;
   tf->codes[2329] = 0x000414fbceeabfe2UL;
   tf->codes[2330] = 0x00041502e63c72bdUL;
   tf->codes[2331] = 0x0004150320cb7882UL;
   tf->codes[2332] = 0x0004150395e9840cUL;
   tf->codes[2333] = 0x00041506549dc948UL;
   tf->codes[2334] = 0x000415068f2ccf0dUL;
   tf->codes[2335] = 0x00041507b3f7ebe6UL;
   tf->codes[2336] = 0x000415089e3402faUL;
   tf->codes[2337] = 0x00041508d8c308bfUL;
   tf->codes[2338] = 0x0004150b22594271UL;
   tf->codes[2339] = 0x0004150d3160765eUL;
   tf->codes[2340] = 0x0004150d6bef7c23UL;
   tf->codes[2341] = 0x0004150e90ba98fcUL;
   tf->codes[2342] = 0x0004151189fde3fdUL;
   tf->codes[2343] = 0x0004151239aaf54cUL;
   tf->codes[2344] = 0x00041512aec900d6UL;
   tf->codes[2345] = 0x00041512e958069bUL;
   tf->codes[2346] = 0x0004151323e70c60UL;
   tf->codes[2347] = 0x00041516924862ebUL;
   tf->codes[2348] = 0x000415198b8badecUL;
   tf->codes[2349] = 0x0004151de4291b8bUL;
   tf->codes[2350] = 0x000415277fa00dddUL;
   tf->codes[2351] = 0x0004152a3e545319UL;
   tf->codes[2352] = 0x0004153190350bb9UL;
   tf->codes[2353] = 0x0004153205531743UL;
   tf->codes[2354] = 0x000415365df084e2UL;
   tf->codes[2355] = 0x00041536987f8aa7UL;
   tf->codes[2356] = 0x0004153a06e0e132UL;
   tf->codes[2357] = 0x0004153f49ba65e5UL;
   tf->codes[2358] = 0x000415411e32940dUL;
   tf->codes[2359] = 0x00041542086eab21UL;
   tf->codes[2360] = 0x0004154576d001acUL;
   tf->codes[2361] = 0x00041548e5315837UL;
   tf->codes[2362] = 0x0004154d785dcb9bUL;
   tf->codes[2363] = 0x00041550e6bf2226UL;
   tf->codes[2364] = 0x00041552bb37504eUL;
   tf->codes[2365] = 0x00041554ca3e843bUL;
   tf->codes[2366] = 0x000415553f5c8fc5UL;
   tf->codes[2367] = 0x0004155788f2c977UL;
   tf->codes[2368] = 0x0004155a47a70eb3UL;
   tf->codes[2369] = 0x0004155ea0447c52UL;
   tf->codes[2370] = 0x000415662cb43ab7UL;
   tf->codes[2371] = 0x00041567c69d631aUL;
   tf->codes[2372] = 0x0004156b34feb9a5UL;
   tf->codes[2373] = 0x0004156df3b2fee1UL;
   tf->codes[2374] = 0x0004156fc82b2d09UL;
   tf->codes[2375] = 0x00041570ecf649e2UL;
   tf->codes[2376] = 0x00041572c16e780aUL;
   tf->codes[2377] = 0x0004157420c89aa8UL;
   tf->codes[2378] = 0x000415758022bd46UL;
   tf->codes[2379] = 0x000415778f29f133UL;
   tf->codes[2380] = 0x000415799e312520UL;
   tf->codes[2381] = 0x0004157afd8b47beUL;
   tf->codes[2382] = 0x0004157c5ce56a5cUL;
   tf->codes[2383] = 0x00041585f85c5caeUL;
   tf->codes[2384] = 0x0004158792458511UL;
   tf->codes[2385] = 0x0004158ea99737ecUL;
   tf->codes[2386] = 0x0004159008f15a8aUL;
   tf->codes[2387] = 0x00041591a2da82edUL;
   tf->codes[2388] = 0x000415930234a58bUL;
   tf->codes[2389] = 0x00041599a4684cdcUL;
   tf->codes[2390] = 0x0004159b03c26f7aUL;
   tf->codes[2391] = 0x0004159d4d58a92cUL;
   tf->codes[2392] = 0x000415a37a6e44f3UL;
   tf->codes[2393] = 0x000415a84829be1cUL;
   tf->codes[2394] = 0x000415a96cf4daf5UL;
   tf->codes[2395] = 0x000415a9a783e0baUL;
   tf->codes[2396] = 0x000415aacc4efd93UL;
   tf->codes[2397] = 0x000415abf11a1a6cUL;
   tf->codes[2398] = 0x000415b133f39f1fUL;
   tf->codes[2399] = 0x000415b258bebbf8UL;
   tf->codes[2400] = 0x000415b517730134UL;
   tf->codes[2401] = 0x000415b885d457bfUL;
   tf->codes[2402] = 0x000415b8c0635d84UL;
   tf->codes[2403] = 0x000415bacf6a9171UL;
   tf->codes[2404] = 0x000415bc6953b9d4UL;
   tf->codes[2405] = 0x000415bd8e1ed6adUL;
   tf->codes[2406] = 0x000415beb2e9f386UL;
   tf->codes[2407] = 0x000415c30b876125UL;
   tf->codes[2408] = 0x000415c4a5708988UL;
   tf->codes[2409] = 0x000415c58faca09cUL;
   tf->codes[2410] = 0x000415c6ef06c33aUL;
   tf->codes[2411] = 0x000415cd1c1c5f01UL;
   tf->codes[2412] = 0x000415d4336e11dcUL;
   tf->codes[2413] = 0x000415d72cb15cddUL;
   tf->codes[2414] = 0x000415d816ed73f1UL;
   tf->codes[2415] = 0x000415dbfa6cd606UL;
   tf->codes[2416] = 0x000415dd1f37f2dfUL;
   tf->codes[2417] = 0x000415e1ecf36c08UL;
   tf->codes[2418] = 0x000415e29ca07d57UL;
   tf->codes[2419] = 0x000415e3c16b9a30UL;
   tf->codes[2420] = 0x000415e47118ab7fUL;
   tf->codes[2421] = 0x000415e64590d9a7UL;
   tf->codes[2422] = 0x000415e904451ee3UL;
   tf->codes[2423] = 0x000415ee471ea396UL;
   tf->codes[2424] = 0x000415f090b4dd48UL;
   tf->codes[2425] = 0x000415f105d2e8d2UL;
   tf->codes[2426] = 0x000415f17af0f45cUL;
   tf->codes[2427] = 0x000415f2da4b16faUL;
   tf->codes[2428] = 0x000415f5d38e61fbUL;
   tf->codes[2429] = 0x000415f60e1d67c0UL;
   tf->codes[2430] = 0x000415f9f19cc9d5UL;
   tf->codes[2431] = 0x000415fcb0510f11UL;
   tf->codes[2432] = 0x00041601b89b8dffUL;
   tf->codes[2433] = 0x00041603c7a2c1ecUL;
   tf->codes[2434] = 0x000416085acf3550UL;
   tf->codes[2435] = 0x0004160a69d6693dUL;
   tf->codes[2436] = 0x0004161146991653UL;
   tf->codes[2437] = 0x00041613cabe55caUL;
   tf->codes[2438] = 0x0004161689729b06UL;
   tf->codes[2439] = 0x0004161773aeb21aUL;
   tf->codes[2440] = 0x0004161982b5e607UL;
   tf->codes[2441] = 0x0004162358bbde1eUL;
   tf->codes[2442] = 0x00041624f2a50681UL;
   tf->codes[2443] = 0x000416252d340c46UL;
   tf->codes[2444] = 0x0004162985d179e5UL;
   tf->codes[2445] = 0x0004162ae52b9c83UL;
   tf->codes[2446] = 0x0004163480a28ed5UL;
   tf->codes[2447] = 0x0004163988ed0dc3UL;
   tf->codes[2448] = 0x00041639fe0b194dUL;
   tf->codes[2449] = 0x0004163da6fb759dUL;
   tf->codes[2450] = 0x0004163fb602a98aUL;
   tf->codes[2451] = 0x00041645336b3402UL;
   tf->codes[2452] = 0x00041645a8893f8cUL;
   tf->codes[2453] = 0x00041647427267efUL;
   tf->codes[2454] = 0x00041647f21f793eUL;
   tf->codes[2455] = 0x000416482cae7f03UL;
   tf->codes[2456] = 0x0004164b6080cfc9UL;
   tf->codes[2457] = 0x0004164b9b0fd58eUL;
   tf->codes[2458] = 0x0004164e59c41acaUL;
   tf->codes[2459] = 0x000416582fca12e1UL;
   tf->codes[2460] = 0x0004165a04424109UL;
   tf->codes[2461] = 0x0004166832e5a6bfUL;
   tf->codes[2462] = 0x0004166c8b83145eUL;
   tf->codes[2463] = 0x0004166d3b3025adUL;
   tf->codes[2464] = 0x0004167417f2d2c3UL;
   tf->codes[2465] = 0x0004167c8e9ea83cUL;
   tf->codes[2466] = 0x0004167d03bcb3c6UL;
   tf->codes[2467] = 0x00041681d1782cefUL;
   tf->codes[2468] = 0x000416820c0732b4UL;
   tf->codes[2469] = 0x00041682bbb44403UL;
   tf->codes[2470] = 0x00041684559d6c66UL;
   tf->codes[2471] = 0x00041684cabb77f0UL;
   tf->codes[2472] = 0x00041685b4f78f04UL;
   tf->codes[2473] = 0x00041687c3fec2f1UL;
   tf->codes[2474] = 0x0004168d06d847a4UL;
   tf->codes[2475] = 0x0004168d7bf6532eUL;
   tf->codes[2476] = 0x00041697176d4580UL;
   tf->codes[2477] = 0x0004169afaeca795UL;
   tf->codes[2478] = 0x0004169b357bad5aUL;
   tf->codes[2479] = 0x0004169e694dfe20UL;
   tf->codes[2480] = 0x000416a2875c65faUL;
   tf->codes[2481] = 0x000416b50e9d394fUL;
   tf->codes[2482] = 0x000416b9673aa6eeUL;
   tf->codes[2483] = 0x000416bac694c98cUL;
   tf->codes[2484] = 0x000416be6f8525dcUL;
   tf->codes[2485] = 0x000416c07e8c59c9UL;
   tf->codes[2486] = 0x000416c12e396b18UL;
   tf->codes[2487] = 0x000416c3b25eaa8fUL;
   tf->codes[2488] = 0x000416c4277cb619UL;
   tf->codes[2489] = 0x000416c511b8cd2dUL;
   tf->codes[2490] = 0x000416c80afc182eUL;
   tf->codes[2491] = 0x000416c8f5382f42UL;
   tf->codes[2492] = 0x000416cc290a8008UL;
   tf->codes[2493] = 0x000416d3405c32e3UL;
   tf->codes[2494] = 0x000416d7d388a647UL;
   tf->codes[2495] = 0x000416de75bc4d98UL;
   tf->codes[2496] = 0x000416e6774a1787UL;
   tf->codes[2497] = 0x000416ed197dbed8UL;
   tf->codes[2498] = 0x000416ee78d7e176UL;
   tf->codes[2499] = 0x000416f590299451UL;
   tf->codes[2500] = 0x000416f8c3fbe517UL;
   tf->codes[2501] = 0x000416fa235607b5UL;
   tf->codes[2502] = 0x000416fd1c9952b6UL;
   tf->codes[2503] = 0x000416fdcc466405UL;
   tf->codes[2504] = 0x000416ff662f8c68UL;
   tf->codes[2505] = 0x0004170558b6226aUL;
   tf->codes[2506] = 0x0004170a26719b93UL;
   tf->codes[2507] = 0x0004170caa96db0aUL;
   tf->codes[2508] = 0x0004171018f83195UL;
   tf->codes[2509] = 0x0004171178525433UL;
   tf->codes[2510] = 0x00041719b46f23e7UL;
   tf->codes[2511] = 0x0004171e0d0c9186UL;
   tf->codes[2512] = 0x00041724af4038d7UL;
   tf->codes[2513] = 0x00041731f3a78779UL;
   tf->codes[2514] = 0x000417322e368d3eUL;
   tf->codes[2515] = 0x00041732a35498c8UL;
   tf->codes[2516] = 0x00041742a6702ca6UL;
   tf->codes[2517] = 0x0004174e50ee52e5UL;
   tf->codes[2518] = 0x000417514a319de6UL;
   tf->codes[2519] = 0x0004175184c0a3abUL;
   tf->codes[2520] = 0x00041752e41ac649UL;
   tf->codes[2521] = 0x0004175702292e23UL;
   tf->codes[2522] = 0x0004175826f44afcUL;
   tf->codes[2523] = 0x0004175ec927f24dUL;
   tf->codes[2524] = 0x00041764811f828aUL;
   tf->codes[2525] = 0x00041769144bf5eeUL;
   tf->codes[2526] = 0x0004176d6ce9638dUL;
   tf->codes[2527] = 0x00041774f95921f2UL;
   tf->codes[2528] = 0x0004177658b34490UL;
   tf->codes[2529] = 0x000417777d7e6169UL;
   tf->codes[2530] = 0x0004177aebdfb7f4UL;
   tf->codes[2531] = 0x0004177d7004f76bUL;
   tf->codes[2532] = 0x0004177ff42a36e2UL;
   tf->codes[2533] = 0x00041788dff417e5UL;
   tf->codes[2534] = 0x0004178e5d5ca25dUL;
   tf->codes[2535] = 0x00041791912ef323UL;
   tf->codes[2536] = 0x00041792f08915c1UL;
   tf->codes[2537] = 0x0004179992bcbd12UL;
   tf->codes[2538] = 0x000417aed8b1d5a3UL;
   tf->codes[2539] = 0x000417b1d1f520a4UL;
   tf->codes[2540] = 0x000417bf8b7a7ad0UL;
   tf->codes[2541] = 0x000417c493c4f9beUL;
   tf->codes[2542] = 0x000417cf19780324UL;
   tf->codes[2543] = 0x000417cf8e960eaeUL;
   tf->codes[2544] = 0x000417d0edf0314cUL;
   tf->codes[2545] = 0x000417d2c2685f74UL;
   tf->codes[2546] = 0x000417d45c5187d7UL;
   tf->codes[2547] = 0x000417dafe852f28UL;
   tf->codes[2548] = 0x000417dc5ddf51c6UL;
   tf->codes[2549] = 0x000417e0f10bc52aUL;
   tf->codes[2550] = 0x000417e9a246a068UL;
   tf->codes[2551] = 0x000417f8460811a8UL;
   tf->codes[2552] = 0x000417faca2d511fUL;
   tf->codes[2553] = 0x00041801e17f03faUL;
   tf->codes[2554] = 0x000418096deec25fUL;
   tf->codes[2555] = 0x0004181ca4dca703UL;
   tf->codes[2556] = 0x0004182556178241UL;
   tf->codes[2557] = 0x0004182a5e62012fUL;
   tf->codes[2558] = 0x0004182e07525d7fUL;
   tf->codes[2559] = 0x0004183608e0276eUL;
   tf->codes[2560] = 0x00041836b88d38bdUL;
   tf->codes[2561] = 0x00041837683a4a0cUL;
   tf->codes[2562] = 0x00041849b4ec179cUL;
   tf->codes[2563] = 0x00041854752e26c7UL;
   tf->codes[2564] = 0x0004185599f943a0UL;
   tf->codes[2565] = 0x00041856f953663eUL;
   tf->codes[2566] = 0x00041857e38f7d52UL;
   tf->codes[2567] = 0x00041858cdcb9466UL;
   tf->codes[2568] = 0x0004185f357035f2UL;
   tf->codes[2569] = 0x0004186980943993UL;
   tf->codes[2570] = 0x0004187022c7e0e4UL;
   tf->codes[2571] = 0x0004187231cf14d1UL;
   tf->codes[2572] = 0x00041879be3ed336UL;
   tf->codes[2573] = 0x0004187a6debe485UL;
   tf->codes[2574] = 0x00041880d5908611UL;
   tf->codes[2575] = 0x0004188ae62583edUL;
   tf->codes[2576] = 0x0004188f3ec2f18cUL;
   tf->codes[2577] = 0x0004189d6d665742UL;
   tf->codes[2578] = 0x000418b5720fb50fUL;
   tf->codes[2579] = 0x000418c32b950f3bUL;
   tf->codes[2580] = 0x000418c48aef31d9UL;
   tf->codes[2581] = 0x000418c624d85a3cUL;
   tf->codes[2582] = 0x000418cb67b1deefUL;
   tf->codes[2583] = 0x000418cc8c7cfbc8UL;
   tf->codes[2584] = 0x000418ce2666242bUL;
   tf->codes[2585] = 0x000418cf85c046c9UL;
   tf->codes[2586] = 0x000418d1cf56807bUL;
   tf->codes[2587] = 0x000418d71230052eUL;
   tf->codes[2588] = 0x000418da0b73502fUL;
   tf->codes[2589] = 0x000418dd79d4a6baUL;
   tf->codes[2590] = 0x000418eea1bb5771UL;
   tf->codes[2591] = 0x000418f802a343feUL;
   tf->codes[2592] = 0x000418f877c14f88UL;
   tf->codes[2593] = 0x000418f8ecdf5b12UL;
   tf->codes[2594] = 0x000418fbab93a04eUL;
   tf->codes[2595] = 0x000419092a89f4b5UL;
   tf->codes[2596] = 0x000419096518fa7aUL;
   tf->codes[2597] = 0x00041909da370604UL;
   tf->codes[2598] = 0x0004190a89e41753UL;
   tf->codes[2599] = 0x0004190d0e0956caUL;
   tf->codes[2600] = 0x000419121653d5b8UL;
   tf->codes[2601] = 0x00041912c600e707UL;
   tf->codes[2602] = 0x0004191793bc6030UL;
   tf->codes[2603] = 0x00041918f31682ceUL;
   tf->codes[2604] = 0x0004191ee59d18d0UL;
   tf->codes[2605] = 0x000419200a6835a9UL;
   tf->codes[2606] = 0x0004192acaaa44d4UL;
   tf->codes[2607] = 0x0004192bef7561adUL;
   tf->codes[2608] = 0x00041940c04c6eb4UL;
   tf->codes[2609] = 0x0004194f640ddff4UL;
   tf->codes[2610] = 0x0004195138860e1cUL;
   tf->codes[2611] = 0x0004195431c9591dUL;
   tf->codes[2612] = 0x00041957659ba9e3UL;
   tf->codes[2613] = 0x0004195c6de628d1UL;
   tf->codes[2614] = 0x000419638537dbacUL;
   tf->codes[2615] = 0x0004196643ec20e8UL;
   tf->codes[2616] = 0x0004196c3672b6eaUL;
   tf->codes[2617] = 0x00041972638852b1UL;
   tf->codes[2618] = 0x0004197b89e13979UL;
   tf->codes[2619] = 0x0004197ebdb38a3fUL;
   tf->codes[2620] = 0x0004197fa7efa153UL;
   tf->codes[2621] = 0x00041982a132ec54UL;
   tf->codes[2622] = 0x000419897df5996aUL;
   tf->codes[2623] = 0x0004198add4fbc08UL;
   tf->codes[2624] = 0x0004198bc78bd31cUL;
   tf->codes[2625] = 0x0004198c3ca9dea6UL;
   tf->codes[2626] = 0x0004198d26e5f5baUL;
   tf->codes[2627] = 0x0004199403a8a2d0UL;
   tf->codes[2628] = 0x0004199612afd6bdUL;
   tf->codes[2629] = 0x0004199e4ecca671UL;
   tf->codes[2630] = 0x000419a90f0eb59cUL;
   tf->codes[2631] = 0x000419a9bebbc6ebUL;
   tf->codes[2632] = 0x000419a9f94accb0UL;
   tf->codes[2633] = 0x000419addcca2ec5UL;
   tf->codes[2634] = 0x000419af01954b9eUL;
   tf->codes[2635] = 0x000419ba36f56653UL;
   tf->codes[2636] = 0x000419c4bca86fb9UL;
   tf->codes[2637] = 0x000419c94fd4e31dUL;
   tf->codes[2638] = 0x000419cae9be0b80UL;
   tf->codes[2639] = 0x000419cb244d1145UL;
   tf->codes[2640] = 0x000419cd33544532UL;
   tf->codes[2641] = 0x000419d4fa53095cUL;
   tf->codes[2642] = 0x000419d743e9430eUL;
   tf->codes[2643] = 0x000419df45770cfdUL;
   tf->codes[2644] = 0x000419e2b3d86388UL;
   tf->codes[2645] = 0x000419e3d8a38061UL;
   tf->codes[2646] = 0x000419e44dc18bebUL;
   tf->codes[2647] = 0x000419e537fda2ffUL;
   tf->codes[2648] = 0x000419e9909b109eUL;
   tf->codes[2649] = 0x000419ecc46d6164UL;
   tf->codes[2650] = 0x000419ef4892a0dbUL;
   tf->codes[2651] = 0x000419fb2d9fccdfUL;
   tf->codes[2652] = 0x000419fd77360691UL;
   tf->codes[2653] = 0x00041a01202662e1UL;
   tf->codes[2654] = 0x00041a0503a5c4f6UL;
   tf->codes[2655] = 0x00041a0a467f49a9UL;
   tf->codes[2656] = 0x00041a0e9f1cb748UL;
   tf->codes[2657] = 0x00041a0fc3e7d421UL;
   tf->codes[2658] = 0x00041a1750579286UL;
   tf->codes[2659] = 0x00041a1c93311739UL;
   tf->codes[2660] = 0x00041a1d42de2888UL;
   tf->codes[2661] = 0x00041a27c89131eeUL;
   tf->codes[2662] = 0x00041a2a4cb67165UL;
   tf->codes[2663] = 0x00041a2d8088c22bUL;
   tf->codes[2664] = 0x00041a33730f582dUL;
   tf->codes[2665] = 0x00041a3cd3f744baUL;
   tf->codes[2666] = 0x00041a4007c99580UL;
   tf->codes[2667] = 0x00041a43b0b9f1d0UL;
   tf->codes[2668] = 0x00041a4585321ff8UL;
   tf->codes[2669] = 0x00041a4b3d29b035UL;
   tf->codes[2670] = 0x00041a554dbeae11UL;
   tf->codes[2671] = 0x00041a579754e7c3UL;
   tf->codes[2672] = 0x00041a57d1e3ed88UL;
   tf->codes[2673] = 0x00041a584701f912UL;
   tf->codes[2674] = 0x00041a5c9f9f66b1UL;
   tf->codes[2675] = 0x00041a64dbbc3665UL;
   tf->codes[2676] = 0x00041a6b7defddb6UL;
   tf->codes[2677] = 0x00041a6c682bf4caUL;
   tf->codes[2678] = 0x00041a6e773328b7UL;
   tf->codes[2679] = 0x00041a7220238507UL;
   tf->codes[2680] = 0x00041a75c913e157UL;
   tf->codes[2681] = 0x00041a79ac93436cUL;
   tf->codes[2682] = 0x00041a7b0bed660aUL;
   tf->codes[2683] = 0x00041a7eb4ddc25aUL;
   tf->codes[2684] = 0x00041a8ca8f2224bUL;
   tf->codes[2685] = 0x00041a8fa2356d4cUL;
   tf->codes[2686] = 0x00041a9385b4cf61UL;
   tf->codes[2687] = 0x00041a943561e0b0UL;
   tf->codes[2688] = 0x00041a988dff4e4fUL;
   tf->codes[2689] = 0x00041a99b2ca6b28UL;
   tf->codes[2690] = 0x00041a99ed5970edUL;
   tf->codes[2691] = 0x00041a9a27e876b2UL;
   tf->codes[2692] = 0x00041a9d5bbac778UL;
   tf->codes[2693] = 0x00041aace9b84fccUL;
   tf->codes[2694] = 0x00041ab17ce4c330UL;
   tf->codes[2695] = 0x00041ab316cdeb93UL;
   tf->codes[2696] = 0x00041ab4b0b713f6UL;
   tf->codes[2697] = 0x00041ab560642545UL;
   tf->codes[2698] = 0x00041abd61f1ef34UL;
   tf->codes[2699] = 0x00041abe119f0083UL;
   tf->codes[2700] = 0x00041abec14c11d2UL;
   tf->codes[2701] = 0x00041ac10ae24b84UL;
   tf->codes[2702] = 0x00041ac2a4cb73e7UL;
   tf->codes[2703] = 0x00041ac6fd68e186UL;
   tf->codes[2704] = 0x00041ac8975209e9UL;
   tf->codes[2705] = 0x00041ad2e2760d8aUL;
   tf->codes[2706] = 0x00041adcb87c05a1UL;
   tf->codes[2707] = 0x00041ae3cfcdb87cUL;
   tf->codes[2708] = 0x00041ae4ba09cf90UL;
   tf->codes[2709] = 0x00041ae4f498d555UL;
   tf->codes[2710] = 0x00041aeb21ae711cUL;
   tf->codes[2711] = 0x00041aebd15b826bUL;
   tf->codes[2712] = 0x00041aeda5d3b093UL;
   tf->codes[2713] = 0x00041af1fe711e32UL;
   tf->codes[2714] = 0x00041af7f0f7b434UL;
   tf->codes[2715] = 0x00041af95051d6d2UL;
   tf->codes[2716] = 0x00041afa3a8dede6UL;
   tf->codes[2717] = 0x00041afa751cf3abUL;
   tf->codes[2718] = 0x00041affb7f6785eUL;
   tf->codes[2719] = 0x00041b02b139c35fUL;
   tf->codes[2720] = 0x00041b08de4f5f26UL;
   tf->codes[2721] = 0x00041b0a78388789UL;
   tf->codes[2722] = 0x00041b0d36ecccc5UL;
   tf->codes[2723] = 0x00041b1488cd8565UL;
   tf->codes[2724] = 0x00041b15ad98a23eUL;
   tf->codes[2725] = 0x00041b1a40c515a2UL;
   tf->codes[2726] = 0x00041b1af07226f1UL;
   tf->codes[2727] = 0x00041b1c4fcc498fUL;
   tf->codes[2728] = 0x00041b1f839e9a55UL;
   tf->codes[2729] = 0x00041b23dc3c07f4UL;
   tf->codes[2730] = 0x00041b2f86ba2e33UL;
   tf->codes[2731] = 0x00041b336a399048UL;
   tf->codes[2732] = 0x00041b33a4c8960dUL;
   tf->codes[2733] = 0x00041b378847f822UL;
   tf->codes[2734] = 0x00041b38e7a21ac0UL;
   tf->codes[2735] = 0x00041b39974f2c0fUL;
   tf->codes[2736] = 0x00041b3a46fc3d5eUL;
   tf->codes[2737] = 0x00041b3ffef3cd9bUL;
   tf->codes[2738] = 0x00041b41d36bfbc3UL;
   tf->codes[2739] = 0x00041b4283190d12UL;
   tf->codes[2740] = 0x00041b45b6eb5dd8UL;
   tf->codes[2741] = 0x00041b524ba59b2bUL;
   tf->codes[2742] = 0x00041b54cfcadaa2UL;
   tf->codes[2743] = 0x00041b5719611454UL;
   tf->codes[2744] = 0x00041b599d8653cbUL;
   tf->codes[2745] = 0x00041b62fe6e4058UL;
   tf->codes[2746] = 0x00041b6582937fcfUL;
   tf->codes[2747] = 0x00041b696612e1e4UL;
   tf->codes[2748] = 0x00041b6a504ef8f8UL;
   tf->codes[2749] = 0x00041b78b9816473UL;
   tf->codes[2750] = 0x00041b7a18db8711UL;
   tf->codes[2751] = 0x00041b7a536a8cd6UL;
   tf->codes[2752] = 0x00041b8797d1db78UL;
   tf->codes[2753] = 0x00041b88820df28cUL;
   tf->codes[2754] = 0x00041b916dd7d38fUL;
   tf->codes[2755] = 0x00041b91e2f5df19UL;
   tf->codes[2756] = 0x00041b979aed6f56UL;
   tf->codes[2757] = 0x00041b9fd70a3f0aUL;
   tf->codes[2758] = 0x00041ba76379fd6fUL;
   tf->codes[2759] = 0x00041bb641ca7474UL;
   tf->codes[2760] = 0x00041bb81642a29cUL;
   tf->codes[2761] = 0x00041bbd591c274fUL;
   tf->codes[2762] = 0x00041bbef3054fb2UL;
   tf->codes[2763] = 0x00041bc9b3475eddUL;
   tf->codes[2764] = 0x00041bcce719afa3UL;
   tf->codes[2765] = 0x00041bd17a462307UL;
   tf->codes[2766] = 0x00041bd4e8a77992UL;
   tf->codes[2767] = 0x00041bd7e1eac493UL;
   tf->codes[2768] = 0x00041bd97bd3ecf6UL;
   tf->codes[2769] = 0x00041bdb504c1b1eUL;
   tf->codes[2770] = 0x00041bdfa8e988bdUL;
   tf->codes[2771] = 0x00041be560e118faUL;
   tf->codes[2772] = 0x00041be64b1d300eUL;
   tf->codes[2773] = 0x00041bf10b5f3f39UL;
   tf->codes[2774] = 0x00041bf2302a5c12UL;
   tf->codes[2775] = 0x00041bf6fde5d53bUL;
   tf->codes[2776] = 0x00041bf77303e0c5UL;
   tf->codes[2777] = 0x00041c06c6726354UL;
   tf->codes[2778] = 0x00041c07b0ae7a68UL;
   tf->codes[2779] = 0x00041c0ae480cb2eUL;
   tf->codes[2780] = 0x00041c0e18531bf4UL;
   tf->codes[2781] = 0x00041c1270f08993UL;
   tf->codes[2782] = 0x00041c1988423c6eUL;
   tf->codes[2783] = 0x00041c1d6bc19e83UL;
   tf->codes[2784] = 0x00041c1e55fdb597UL;
   tf->codes[2785] = 0x00041c2323b92ec0UL;
   tf->codes[2786] = 0x00041c240df545d4UL;
   tf->codes[2787] = 0x00041c26cca98b10UL;
   tf->codes[2788] = 0x00041c2950ceca87UL;
   tf->codes[2789] = 0x00041c2cbf302112UL;
   tf->codes[2790] = 0x00041c3326d4c29eUL;
   tf->codes[2791] = 0x00041c3f4670f467UL;
   tf->codes[2792] = 0x00041c3fbb8efff1UL;
   tf->codes[2793] = 0x00041c4030ad0b7bUL;
   tf->codes[2794] = 0x00041c406b3c1140UL;
   tf->codes[2795] = 0x00041c4cfff64e93UL;
   tf->codes[2796] = 0x00041c4f841b8e0aUL;
   tf->codes[2797] = 0x00041c5451d70733UL;
   tf->codes[2798] = 0x00041c57108b4c6fUL;
   tf->codes[2799] = 0x00041c5a7eeca2faUL;
   tf->codes[2800] = 0x00041c63dfd48f87UL;
   tf->codes[2801] = 0x00041c6d40bc7c14UL;
   tf->codes[2802] = 0x00041c6e658798edUL;
   tf->codes[2803] = 0x00041c7c599bf8deUL;
   tf->codes[2804] = 0x00041c7df3852141UL;
   tf->codes[2805] = 0x00041c7f18503e1aUL;
   tf->codes[2806] = 0x00041c819c757d91UL;
   tf->codes[2807] = 0x00041c85ba83e56bUL;
   tf->codes[2808] = 0x00041c8cd1d59846UL;
   tf->codes[2809] = 0x00041c924f3e22beUL;
   tf->codes[2810] = 0x00041c93ae98455cUL;
   tf->codes[2811] = 0x00041c987c53be85UL;
   tf->codes[2812] = 0x00041c99a11edb5eUL;
   tf->codes[2813] = 0x00041c9c25441ad5UL;
   tf->codes[2814] = 0x00041c9d0f8031e9UL;
   tf->codes[2815] = 0x00041cafd1500b03UL;
   tf->codes[2816] = 0x00041cb00bdf10c8UL;
   tf->codes[2817] = 0x00041cb2ca935604UL;
   tf->codes[2818] = 0x00041cb4d99a89f1UL;
   tf->codes[2819] = 0x00041cb72330c3a3UL;
   tf->codes[2820] = 0x00041cb8828ae641UL;
   tf->codes[2821] = 0x00041cbe75117c43UL;
   tf->codes[2822] = 0x00041cc517452394UL;
   tf->codes[2823] = 0x00041cc58c632f1eUL;
   tf->codes[2824] = 0x00041cc8c0357fe4UL;
   tf->codes[2825] = 0x00041cceb2bc15e6UL;
   tf->codes[2826] = 0x00041ccf27da2170UL;
   tf->codes[2827] = 0x00041cd6b449dfd5UL;
   tf->codes[2828] = 0x00041cd8c35113c2UL;
   tf->codes[2829] = 0x00041cd9386f1f4cUL;
   tf->codes[2830] = 0x00041cdb820558feUL;
   tf->codes[2831] = 0x00041ce7a1a18ac7UL;
   tf->codes[2832] = 0x00041ced942820c9UL;
   tf->codes[2833] = 0x00041ceef3824367UL;
   tf->codes[2834] = 0x00041cf7df4c246aUL;
   tf->codes[2835] = 0x00041cf979354ccdUL;
   tf->codes[2836] = 0x00041cf9b3c45292UL;
   tf->codes[2837] = 0x00041cfad88f6f6bUL;
   tf->codes[2838] = 0x00041cfb883c80baUL;
   tf->codes[2839] = 0x00041cfc37e99209UL;
   tf->codes[2840] = 0x00041d0523b3730cUL;
   tf->codes[2841] = 0x00041d12681ac1aeUL;
   tf->codes[2842] = 0x00041d147721f59bUL;
   tf->codes[2843] = 0x00041d177065409cUL;
   tf->codes[2844] = 0x00041d1d9d7adc63UL;
   tf->codes[2845] = 0x00041d1fe7111615UL;
   tf->codes[2846] = 0x00041d26c3d3c32bUL;
   tf->codes[2847] = 0x00041d28d2daf718UL;
   tf->codes[2848] = 0x00041d356795346bUL;
   tf->codes[2849] = 0x00041d35dcb33ff5UL;
   tf->codes[2850] = 0x00041d3cf404f2d0UL;
   tf->codes[2851] = 0x00041d3f3d9b2c82UL;
   tf->codes[2852] = 0x00041d47b44701fbUL;
   tf->codes[2853] = 0x00041d4b97c66410UL;
   tf->codes[2854] = 0x00041d4de15c9dc2UL;
   tf->codes[2855] = 0x00041d50da9fe8c3UL;
   tf->codes[2856] = 0x00041d55333d5662UL;
   tf->codes[2857] = 0x00041d5742448a4fUL;
   tf->codes[2858] = 0x00041d58670fa728UL;
   tf->codes[2859] = 0x00041d5e59963d2aUL;
   tf->codes[2860] = 0x00041d60689d7117UL;
   tf->codes[2861] = 0x00041d68df494690UL;
   tf->codes[2862] = 0x00041d6c131b9756UL;
   tf->codes[2863] = 0x00041d6f0c5ee257UL;
   tf->codes[2864] = 0x00041d703129ff30UL;
   tf->codes[2865] = 0x00041d7489c76ccfUL;
   tf->codes[2866] = 0x00041d770decac46UL;
   tf->codes[2867] = 0x00041d836817e3d4UL;
   tf->codes[2868] = 0x00041d86615b2ed5UL;
   tf->codes[2869] = 0x00041d995dba0db4UL;
   tf->codes[2870] = 0x00041d9b32323bdcUL;
   tf->codes[2871] = 0x00041d9db6577b53UL;
   tf->codes[2872] = 0x00041d9f5040a3b6UL;
   tf->codes[2873] = 0x00041da5083833f3UL;
   tf->codes[2874] = 0x00041daa85a0be6bUL;
   tf->codes[2875] = 0x00041dab6fdcd57fUL;
   tf->codes[2876] = 0x00041dabaa6bdb44UL;
   tf->codes[2877] = 0x00041daf18cd31cfUL;
   tf->codes[2878] = 0x00041db2872e885aUL;
   tf->codes[2879] = 0x00041db2fc4c93e4UL;
   tf->codes[2880] = 0x00041dbbe81674e7UL;
   tf->codes[2881] = 0x00041dd28d65b016UL;
   tf->codes[2882] = 0x00041dd636560c66UL;
   tf->codes[2883] = 0x00041de00c5c047dUL;
   tf->codes[2884] = 0x00041de75e3cbd1dUL;
   tf->codes[2885] = 0x00041de9a7d2f6cfUL;
   tf->codes[2886] = 0x00041deca11641d0UL;
   tf->codes[2887] = 0x00041df4a2a40bbfUL;
   tf->codes[2888] = 0x00041df79be756c0UL;
   tf->codes[2889] = 0x00041df935d07f23UL;
   tf->codes[2890] = 0x00041df9705f84e8UL;
   tf->codes[2891] = 0x00041dfe3e1afe11UL;
   tf->codes[2892] = 0x00041e067a37cdc5UL;
   tf->codes[2893] = 0x00041e0dcc188665UL;
   tf->codes[2894] = 0x00041e0e7bc597b4UL;
   tf->codes[2895] = 0x00041e13498110ddUL;
   tf->codes[2896] = 0x00041e1a9b61c97dUL;
   tf->codes[2897] = 0x00041e39f1ebdfeaUL;
   tf->codes[2898] = 0x00041e3bc6640e12UL;
   tf->codes[2899] = 0x00041e3e8518534eUL;
   tf->codes[2900] = 0x00041e3f6f546a62UL;
   tf->codes[2901] = 0x00041e417e5b9e4fUL;
   tf->codes[2902] = 0x00041e4c040ea7b5UL;
   tf->codes[2903] = 0x00041e53cb0d6bdfUL;
   tf->codes[2904] = 0x00041e59f82307a6UL;
   tf->codes[2905] = 0x00041e5a32b20d6bUL;
   tf->codes[2906] = 0x00041e5b577d2a44UL;
   tf->codes[2907] = 0x00041e5d66845e31UL;
   tf->codes[2908] = 0x00041e6408b80582UL;
   tf->codes[2909] = 0x00041e66c76c4abeUL;
   tf->codes[2910] = 0x00041e6a35cda149UL;
   tf->codes[2911] = 0x00041e7062e33d10UL;
   tf->codes[2912] = 0x00041e7aae0740b1UL;
   tf->codes[2913] = 0x00041e8533ba4a17UL;
   tf->codes[2914] = 0x00041e88a21ba0a2UL;
   tf->codes[2915] = 0x00041e8daa661f90UL;
   tf->codes[2916] = 0x00041e95e682ef44UL;
   tf->codes[2917] = 0x00041e9696300093UL;
   tf->codes[2918] = 0x00041e96d0bf0658UL;
   tf->codes[2919] = 0x00041e9a79af62a8UL;
   tf->codes[2920] = 0x00041ea65ebc8eacUL;
   tf->codes[2921] = 0x00041ea91d70d3e8UL;
   tf->codes[2922] = 0x00041ea9cd1de537UL;
   tf->codes[2923] = 0x00041eae604a589bUL;
   tf->codes[2924] = 0x00041eaed5686425UL;
   tf->codes[2925] = 0x00041eaffa3380feUL;
   tf->codes[2926] = 0x00041eb2093ab4ebUL;
   tf->codes[2927] = 0x00041eb2f376cbffUL;
   tf->codes[2928] = 0x00041eb661d8228aUL;
   tf->codes[2929] = 0x00041eb7fbc14aedUL;
   tf->codes[2930] = 0x00041eb9d0397915UL;
   tf->codes[2931] = 0x00041ebb2f939bb3UL;
   tf->codes[2932] = 0x00041ecb32af2f91UL;
   tf->codes[2933] = 0x00041ecf50bd976bUL;
   tf->codes[2934] = 0x00041ed5b86238f7UL;
   tf->codes[2935] = 0x00041edb35cac36fUL;
   tf->codes[2936] = 0x00041edccfb3ebd2UL;
   tf->codes[2937] = 0x00041ede699d1435UL;
   tf->codes[2938] = 0x00041ededebb1fbfUL;
   tf->codes[2939] = 0x00041edfc8f736d3UL;
   tf->codes[2940] = 0x00041ee128515971UL;
   tf->codes[2941] = 0x00041ee19d6f64fbUL;
   tf->codes[2942] = 0x00041ee3ac7698e8UL;
   tf->codes[2943] = 0x00041ee87a321211UL;
   tf->codes[2944] = 0x00041ee8ef501d9bUL;
   tf->codes[2945] = 0x00041eef1c65b962UL;
   tf->codes[2946] = 0x00041ef215a90463UL;
   tf->codes[2947] = 0x00041ef3ea21328bUL;
   tf->codes[2948] = 0x00041efbb11ff6b5UL;
   tf->codes[2949] = 0x00041f06abf10ba5UL;
   tf->codes[2950] = 0x00041f0d4e24b2f6UL;
   tf->codes[2951] = 0x00041f0ee80ddb59UL;
   tf->codes[2952] = 0x00041f121be02c1fUL;
   tf->codes[2953] = 0x00041f180e66c221UL;
   tf->codes[2954] = 0x00041f196dc0e4bfUL;
   tf->codes[2955] = 0x00041f2a208989ecUL;
   tf->codes[2956] = 0x00041f2a95a79576UL;
   tf->codes[2957] = 0x00041f2ca4aec963UL;
   tf->codes[2958] = 0x00041f2f63630e9fUL;
   tf->codes[2959] = 0x00041f34e0cb9917UL;
   tf->codes[2960] = 0x00041f40c5d8c51bUL;
   tf->codes[2961] = 0x00041f446ec9216bUL;
   tf->codes[2962] = 0x00041f47680c6c6cUL;
   tf->codes[2963] = 0x00041f555c20cc5dUL;
   tf->codes[2964] = 0x00041f560bcdddacUL;
   tf->codes[2965] = 0x00041f573098fa85UL;
   tf->codes[2966] = 0x00041f5a9efa5110UL;
   tf->codes[2967] = 0x00041f5bfe5473aeUL;
   tf->codes[2968] = 0x00041f5ce8908ac2UL;
   tf->codes[2969] = 0x00041f5d231f9087UL;
   tf->codes[2970] = 0x00041f5e47eaad60UL;
   tf->codes[2971] = 0x00041f5f3226c474UL;
   tf->codes[2972] = 0x00041f69f268d39fUL;
   tf->codes[2973] = 0x00041f6adca4eab3UL;
   tf->codes[2974] = 0x00041f6b51c2f63dUL;
   tf->codes[2975] = 0x00041f701f7e6f66UL;
   tf->codes[2976] = 0x00041f759ce6f9deUL;
   tf->codes[2977] = 0x00041f7612050568UL;
   tf->codes[2978] = 0x00041f76c1b216b7UL;
   tf->codes[2979] = 0x00041f7980665bf3UL;
   tf->codes[2980] = 0x00041f7fad7bf7baUL;
   tf->codes[2981] = 0x00041f84b5c676a8UL;
   tf->codes[2982] = 0x00041f898381efd1UL;
   tf->codes[2983] = 0x00041f8c07a72f48UL;
   tf->codes[2984] = 0x00041f8e8bcc6ebfUL;
   tf->codes[2985] = 0x00041f8f760885d3UL;
   tf->codes[2986] = 0x00041f94f371104bUL;
   tf->codes[2987] = 0x00041f994c0e7deaUL;
   tf->codes[2988] = 0x00041fae9203967bUL;
   tf->codes[2989] = 0x00041fb3253009dfUL;
   tf->codes[2990] = 0x00041fbc10f9eae2UL;
   tf->codes[2991] = 0x00041fbcc0a6fc31UL;
   tf->codes[2992] = 0x00041fbff4794cf7UL;
   tf->codes[2993] = 0x00041fc487a5c05bUL;
   tf->codes[2994] = 0x00041fc86b252270UL;
   tf->codes[2995] = 0x00041fc8e0432dfaUL;
   tf->codes[2996] = 0x00041fcb64686d71UL;
   tf->codes[2997] = 0x00041fcf0d58c9c1UL;
   tf->codes[2998] = 0x00041fcf47e7cf86UL;
   tf->codes[2999] = 0x00041fd2069c14c2UL;
   tf->codes[3000] = 0x00041fd48ac15439UL;
   tf->codes[3001] = 0x00041fd91dedc79dUL;
   tf->codes[3002] = 0x00041fda0829deb1UL;
   tf->codes[3003] = 0x00041fda42b8e476UL;
   tf->codes[3004] = 0x00041fdd016d29b2UL;
   tf->codes[3005] = 0x00041fdd768b353cUL;
   tf->codes[3006] = 0x00041fe32e82c579UL;
   tf->codes[3007] = 0x00041fe5ed370ab5UL;
   tf->codes[3008] = 0x00041fea45d47854UL;
   tf->codes[3009] = 0x00041fed79a6c91aUL;
   tf->codes[3010] = 0x00041ff1d24436b9UL;
   tf->codes[3011] = 0x00041ff41bda706bUL;
   tf->codes[3012] = 0x00041ffbe2d93495UL;
   tf->codes[3013] = 0x00041ffd42335733UL;
   tf->codes[3014] = 0x00042000b094adbeUL;
   tf->codes[3015] = 0x000420024a7dd621UL;
   tf->codes[3016] = 0x00042002bf9be1abUL;
   tf->codes[3017] = 0x00042002fa2ae770UL;
   tf->codes[3018] = 0x0004200509321b5dUL;
   tf->codes[3019] = 0x0004200927408337UL;
   tf->codes[3020] = 0x0004200961cf88fcUL;
   tf->codes[3021] = 0x00042009d6ed9486UL;
   tf->codes[3022] = 0x0004200d0abfe54cUL;
   tf->codes[3023] = 0x0004200dba6cf69bUL;
   tf->codes[3024] = 0x0004200e2f8b0225UL;
   tf->codes[3025] = 0x0004200e6a1a07eaUL;
   tf->codes[3026] = 0x0004200f19c71939UL;
   tf->codes[3027] = 0x00042013726486d8UL;
   tf->codes[3028] = 0x000420166ba7d1d9UL;
   tf->codes[3029] = 0x00042016e0c5dd63UL;
   tf->codes[3030] = 0x00042018efcd1150UL;
   tf->codes[3031] = 0x000420199f7a229fUL;
   tf->codes[3032] = 0x0004201a89b639b3UL;
   tf->codes[3033] = 0x0004201d486a7eefUL;
   tf->codes[3034] = 0x000420233af114f1UL;
   tf->codes[3035] = 0x000420250f694319UL;
   tf->codes[3036] = 0x0004202549f848deUL;
   tf->codes[3037] = 0x000420266ec365b7UL;
   tf->codes[3038] = 0x000420271e707706UL;
   tf->codes[3039] = 0x00042029a295b67dUL;
   tf->codes[3040] = 0x0004202b3c7edee0UL;
   tf->codes[3041] = 0x0004202bb19cea6aUL;
   tf->codes[3042] = 0x0004202cd6680743UL;
   tf->codes[3043] = 0x0004202dc0a41e57UL;
   tf->codes[3044] = 0x0004202ee56f3b30UL;
   tf->codes[3045] = 0x0004202f1ffe40f5UL;
   tf->codes[3046] = 0x0004203462d7c5a8UL;
   tf->codes[3047] = 0x0004203587a2e281UL;
   tf->codes[3048] = 0x00042035c231e846UL;
   tf->codes[3049] = 0x0004203671def995UL;
   tf->codes[3050] = 0x00042036ac6dff5aUL;
   tf->codes[3051] = 0x000420375c1b10a9UL;
   tf->codes[3052] = 0x0004203796aa166eUL;
   tf->codes[3053] = 0x00042038bb753347UL;
   tf->codes[3054] = 0x000420396b224496UL;
   tf->codes[3055] = 0x0004203b050b6cf9UL;
   tf->codes[3056] = 0x0004203b7a297883UL;
   tf->codes[3057] = 0x0004203bef47840dUL;
   tf->codes[3058] = 0x0004203c29d689d2UL;
   tf->codes[3059] = 0x0004203c64658f97UL;
   tf->codes[3060] = 0x0004203d1412a0e6UL;
   tf->codes[3061] = 0x0004203eadfbc949UL;
   tf->codes[3062] = 0x0004203f2319d4d3UL;
   tf->codes[3063] = 0x000420400d55ebe7UL;
   tf->codes[3064] = 0x0004204047e4f1acUL;
   tf->codes[3065] = 0x00042040f79202fbUL;
   tf->codes[3066] = 0x0004204341283cadUL;
   tf->codes[3067] = 0x00042047d454b011UL;
   tf->codes[3068] = 0x0004204933aed2afUL;
   tf->codes[3069] = 0x0004204bf26317ebUL;
   tf->codes[3070] = 0x0004204c2cf21db0UL;
   tf->codes[3071] = 0x0004204e016a4bd8UL;
   tf->codes[3072] = 0x0004204eeba662ecUL;
   tf->codes[3073] = 0x0004204fd5e27a00UL;
   tf->codes[3074] = 0x00042050c01e9114UL;
   tf->codes[3075] = 0x00042051e4e9adedUL;
   tf->codes[3076] = 0x00042053b961dc15UL;
   tf->codes[3077] = 0x000420542e7fe79fUL;
   tf->codes[3078] = 0x00042054a39df329UL;
   tf->codes[3079] = 0x0004205518bbfeb3UL;
   tf->codes[3080] = 0x00042055c8691002UL;
   tf->codes[3081] = 0x00042056b2a52716UL;
   tf->codes[3082] = 0x0004205762523865UL;
   tf->codes[3083] = 0x0004205811ff49b4UL;
   tf->codes[3084] = 0x0004205ad0b38ef0UL;
   tf->codes[3085] = 0x0004205b8060a03fUL;
   tf->codes[3086] = 0x0004205c6a9cb753UL;
   tf->codes[3087] = 0x0004205d54d8ce67UL;
   tf->codes[3088] = 0x0004205fd8fe0ddeUL;
   tf->codes[3089] = 0x00042062d24158dfUL;
   tf->codes[3090] = 0x000420667b31b52fUL;
   tf->codes[3091] = 0x00042066b5c0baf4UL;
   tf->codes[3092] = 0x00042067656dcc43UL;
   tf->codes[3093] = 0x000420679ffcd208UL;
   tf->codes[3094] = 0x00042067da8bd7cdUL;
   tf->codes[3095] = 0x000420688a38e91cUL;
   tf->codes[3096] = 0x0004206b48ed2e58UL;
   tf->codes[3097] = 0x0004206bf89a3fa7UL;
   tf->codes[3098] = 0x0004206c3329456cUL;
   tf->codes[3099] = 0x0004206ca84750f6UL;
   tf->codes[3100] = 0x0004206e7cbf7f1eUL;
   tf->codes[3101] = 0x0004206eb74e84e3UL;
   tf->codes[3102] = 0x0004206f2c6c906dUL;
   tf->codes[3103] = 0x00042071eb20d5a9UL;
   tf->codes[3104] = 0x000420729acde6f8UL;
   tf->codes[3105] = 0x0004207818367170UL;
   tf->codes[3106] = 0x0004207852c57735UL;
   tf->codes[3107] = 0x000420788d547cfaUL;
   tf->codes[3108] = 0x00042079ecae9f98UL;
   tf->codes[3109] = 0x0004207bc126cdc0UL;
   tf->codes[3110] = 0x0004207c3644d94aUL;
   tf->codes[3111] = 0x0004207e7fdb12fcUL;
   tf->codes[3112] = 0x0004207f2f88244bUL;
   tf->codes[3113] = 0x000420834d968c25UL;
   tf->codes[3114] = 0x00042085d1bbcb9cUL;
   tf->codes[3115] = 0x00042087e0c2ff89UL;
   tf->codes[3116] = 0x000420881b52054eUL;
   tf->codes[3117] = 0x00042088907010d8UL;
   tf->codes[3118] = 0x00042089b53b2db1UL;
   tf->codes[3119] = 0x0004208ada064a8aUL;
   tf->codes[3120] = 0x0004208bfed16763UL;
   tf->codes[3121] = 0x0004208e4867a115UL;
   tf->codes[3122] = 0x0004208f6d32bdeeUL;
   tf->codes[3123] = 0x0004208fe250c978UL;
   tf->codes[3124] = 0x00042090576ed502UL;
   tf->codes[3125] = 0x00042090cc8ce08cUL;
   tf->codes[3126] = 0x00042094757d3cdcUL;
   tf->codes[3127] = 0x000420955fb953f0UL;
   tf->codes[3128] = 0x00042095d4d75f7aUL;
   tf->codes[3129] = 0x000420994338b605UL;
   tf->codes[3130] = 0x0004209b8cceefb7UL;
   tf->codes[3131] = 0x0004209bc75df57cUL;
   tf->codes[3132] = 0x0004209c01ecfb41UL;
   tf->codes[3133] = 0x0004209ec0a1407dUL;
   tf->codes[3134] = 0x0004209f35bf4c07UL;
   tf->codes[3135] = 0x0004209faadd5791UL;
   tf->codes[3136] = 0x000420a22f029708UL;
   tf->codes[3137] = 0x000420a7374d15f6UL;
   tf->codes[3138] = 0x000420aa6b1f66bcUL;
   tf->codes[3139] = 0x000420aae03d7246UL;
   tf->codes[3140] = 0x000420ac3f9794e4UL;
   tf->codes[3141] = 0x000420b182711997UL;
   tf->codes[3142] = 0x000420b2321e2ae6UL;
   tf->codes[3143] = 0x000420b565f07bacUL;
   tf->codes[3144] = 0x000420b6159d8cfbUL;
   tf->codes[3145] = 0x000420b6c54a9e4aUL;
   tf->codes[3146] = 0x000420b90ee0d7fcUL;
   tf->codes[3147] = 0x000420b9be8de94bUL;
   tf->codes[3148] = 0x000420c1106ea1ebUL;
   tf->codes[3149] = 0x000420c1faaab8ffUL;
   tf->codes[3150] = 0x000420c26fc8c489UL;
   tf->codes[3151] = 0x000420c409b1ececUL;
   tf->codes[3152] = 0x000420c5de2a1b14UL;
   tf->codes[3153] = 0x000420c7ed314f01UL;
   tf->codes[3154] = 0x000420c94c8b719fUL;
   tf->codes[3155] = 0x000420cfeebf18f0UL;
   tf->codes[3156] = 0x000420d3229169b6UL;
   tf->codes[3157] = 0x000420d690f2c041UL;
   tf->codes[3158] = 0x000420d70610cbcbUL;
   tf->codes[3159] = 0x000420d7f04ce2dfUL;
   tf->codes[3160] = 0x000420d98a360b42UL;
   tf->codes[3161] = 0x000420dc0e5b4ab9UL;
   tf->codes[3162] = 0x000420df422d9b7fUL;
   tf->codes[3163] = 0x000420e39acb091eUL;
   tf->codes[3164] = 0x000420e44a781a6dUL;
   tf->codes[3165] = 0x000420e5e46142d0UL;
   tf->codes[3166] = 0x000420eb273ac783UL;
   tf->codes[3167] = 0x000420ec1176de97UL;
   tf->codes[3168] = 0x000420ee959c1e0eUL;
   tf->codes[3169] = 0x000420f203fd7499UL;
   tf->codes[3170] = 0x000420f2b3aa85e8UL;
   tf->codes[3171] = 0x000420f2ee398badUL;
   tf->codes[3172] = 0x000420f39de69cfcUL;
   tf->codes[3173] = 0x000420f3d875a2c1UL;
   tf->codes[3174] = 0x000420f5725ecb24UL;
   tf->codes[3175] = 0x000420fa401a444dUL;
   tf->codes[3176] = 0x000420fd395d8f4eUL;
   tf->codes[3177] = 0x0004210191fafcedUL;
   tf->codes[3178] = 0x00042108e3dbb58dUL;
   tf->codes[3179] = 0x000421091e6abb52UL;
   tf->codes[3180] = 0x000421099388c6dcUL;
   tf->codes[3181] = 0x0004210bdd1f008eUL;
   tf->codes[3182] = 0x0004210d770828f1UL;
   tf->codes[3183] = 0x0004210dec26347bUL;
   tf->codes[3184] = 0x0004211035bc6e2dUL;
   tf->codes[3185] = 0x00042113698ebef3UL;
   tf->codes[3186] = 0x00042117879d26cdUL;
   tf->codes[3187] = 0x00042118ac6843a6UL;
   tf->codes[3188] = 0x0004211af5fe7d58UL;
   tf->codes[3189] = 0x0004211f892af0bcUL;
   tf->codes[3190] = 0x0004211ffe48fc46UL;
   tf->codes[3191] = 0x000421236caa52d1UL;
   tf->codes[3192] = 0x00042128ea12dd49UL;
   tf->codes[3193] = 0x0004212a83fc05acUL;
   tf->codes[3194] = 0x0004212ba8c72285UL;
   tf->codes[3195] = 0x0004212edc99734bUL;
   tf->codes[3196] = 0x0004213076829baeUL;
   tf->codes[3197] = 0x00042130b111a173UL;
   tf->codes[3198] = 0x00042133aa54ec74UL;
   tf->codes[3199] = 0x0004213509af0f12UL;
   tf->codes[3200] = 0x0004213afc35a514UL;
   tf->codes[3201] = 0x0004213c961ecd77UL;
   tf->codes[3202] = 0x0004213d805ae48bUL;
   tf->codes[3203] = 0x0004213f1a440ceeUL;
   tf->codes[3204] = 0x0004213fc9f11e3dUL;
   tf->codes[3205] = 0x00042144228e8bdcUL;
   tf->codes[3206] = 0x000421450ccaa2f0UL;
   tf->codes[3207] = 0x000421466c24c58eUL;
   tf->codes[3208] = 0x000421475660dca2UL;
   tf->codes[3209] = 0x00042148060dedf1UL;
   tf->codes[3210] = 0x0004214d0e586cdfUL;
   tf->codes[3211] = 0x0004214ee2d09b07UL;
   tf->codes[3212] = 0x0004214f927dac56UL;
   tf->codes[3213] = 0x000421550fe636ceUL;
   tf->codes[3214] = 0x0004215634b153a7UL;
   tf->codes[3215] = 0x0004215c61c6ef6eUL;
   tf->codes[3216] = 0x0004215c9c55f533UL;
   tf->codes[3217] = 0x0004215cd6e4faf8UL;
   tf->codes[3218] = 0x000421628edc8b35UL;
   tf->codes[3219] = 0x00042163ee36add3UL;
   tf->codes[3220] = 0x00042164d872c4e7UL;
   tf->codes[3221] = 0x00042165fd3de1c0UL;
   tf->codes[3222] = 0x00042166725bed4aUL;
   tf->codes[3223] = 0x00042166aceaf30fUL;
   tf->codes[3224] = 0x000421680c4515adUL;
   tf->codes[3225] = 0x0004216931103286UL;
   tf->codes[3226] = 0x000421696b9f384bUL;
   tf->codes[3227] = 0x0004216b40176673UL;
   tf->codes[3228] = 0x000421700dd2df9cUL;
   tf->codes[3229] = 0x00042173f15241b1UL;
   tf->codes[3230] = 0x00042174db8e58c5UL;
   tf->codes[3231] = 0x0004217550ac644fUL;
   tf->codes[3232] = 0x0004217ca28d1cefUL;
   tf->codes[3233] = 0x0004217d523a2e3eUL;
   tf->codes[3234] = 0x0004217eec2356a1UL;
   tf->codes[3235] = 0x000421830a31be7bUL;
   tf->codes[3236] = 0x00042184dea9eca3UL;
   tf->codes[3237] = 0x000421858e56fdf2UL;
   tf->codes[3238] = 0x00042185c8e603b7UL;
   tf->codes[3239] = 0x0004218678931506UL;
   tf->codes[3240] = 0x00042188fcb8547dUL;
   tf->codes[3241] = 0x0004218937475a42UL;
   tf->codes[3242] = 0x0004218ad13082a5UL;
   tf->codes[3243] = 0x0004218b80dd93f4UL;
   tf->codes[3244] = 0x0004218ce037b692UL;
   tf->codes[3245] = 0x000421904e990d1dUL;
   tf->codes[3246] = 0x00042195cc019795UL;
   tf->codes[3247] = 0x00042197a079c5bdUL;
   tf->codes[3248] = 0x000421981597d147UL;
   tf->codes[3249] = 0x0004219a5f2e0af9UL;
   tf->codes[3250] = 0x0004219d93005bbfUL;
   tf->codes[3251] = 0x0004219e42ad6d0eUL;
   tf->codes[3252] = 0x000421a29b4adaadUL;
   tf->codes[3253] = 0x000421a559ff1fe9UL;
   tf->codes[3254] = 0x000421aa9cd8a49cUL;
   tf->codes[3255] = 0x000421add0aaf562UL;
   tf->codes[3256] = 0x000421ae45c900ecUL;
   tf->codes[3257] = 0x000421b597a9b98cUL;
   tf->codes[3258] = 0x000421bb4fa149c9UL;
   tf->codes[3259] = 0x000421bcaefb6c67UL;
   tf->codes[3260] = 0x000421bf6dafb1a3UL;
   tf->codes[3261] = 0x000421bfa83eb768UL;
   tf->codes[3262] = 0x000421c3512f13b8UL;
   tf->codes[3263] = 0x000421c400dc2507UL;
   tf->codes[3264] = 0x000421c475fa3091UL;
   tf->codes[3265] = 0x000421c4eb183c1bUL;
   tf->codes[3266] = 0x000421c97e44af7fUL;
   tf->codes[3267] = 0x000421caa30fcc58UL;
   tf->codes[3268] = 0x000421cd61c41194UL;
   tf->codes[3269] = 0x000421cf363c3fbcUL;
   tf->codes[3270] = 0x000421d2a49d9647UL;
   tf->codes[3271] = 0x000421d5d86fe70dUL;
   tf->codes[3272] = 0x000421d8d1b3320eUL;
   tf->codes[3273] = 0x000421dae0ba65fbUL;
   tf->codes[3274] = 0x000421db1b496bc0UL;
   tf->codes[3275] = 0x000421dc7aa38e5eUL;
   tf->codes[3276] = 0x000421dcb5329423UL;
   tf->codes[3277] = 0x000421de4f1bbc86UL;
   tf->codes[3278] = 0x000421e098b1f638UL;
   tf->codes[3279] = 0x000421e4b6c05e12UL;
   tf->codes[3280] = 0x000421e77574a34eUL;
   tf->codes[3281] = 0x000421eb58f40563UL;
   tf->codes[3282] = 0x000421eda28a3f15UL;
   tf->codes[3283] = 0x000421ee52375064UL;
   tf->codes[3284] = 0x000421eec7555beeUL;
   tf->codes[3285] = 0x000421f235b6b279UL;
   tf->codes[3286] = 0x000421f39510d517UL;
   tf->codes[3287] = 0x000421f653c51a53UL;
   tf->codes[3288] = 0x000421f68e542018UL;
   tf->codes[3289] = 0x000421f6c8e325ddUL;
   tf->codes[3290] = 0x000421f7b31f3cf1UL;
   tf->codes[3291] = 0x000421f8d7ea59caUL;
   tf->codes[3292] = 0x000421f987976b19UL;
   tf->codes[3293] = 0x000421fb5c0f9941UL;
   tf->codes[3294] = 0x000421fcf5f8c1a4UL;
   tf->codes[3295] = 0x000421fda5a5d2f3UL;
   tf->codes[3296] = 0x000421ff7a1e011bUL;
   tf->codes[3297] = 0x0004220238d24657UL;
   tf->codes[3298] = 0x00042207f0c9d694UL;
   tf->codes[3299] = 0x000422095023f932UL;
   tf->codes[3300] = 0x0004220b5f2b2d1fUL;
   tf->codes[3301] = 0x0004220b99ba32e4UL;
   tf->codes[3302] = 0x0004220cbe854fbdUL;
   tf->codes[3303] = 0x0004220f081b896fUL;
   tf->codes[3304] = 0x0004220f42aa8f34UL;
   tf->codes[3305] = 0x000422132629f149UL;
   tf->codes[3306] = 0x00042217b95664adUL;
   tf->codes[3307] = 0x000422182e747037UL;
   tf->codes[3308] = 0x00042218a3927bc1UL;
   tf->codes[3309] = 0x0004221918b0874bUL;
   tf->codes[3310] = 0x0004221e20fb0639UL;
   tf->codes[3311] = 0x0004222d746988c8UL;
   tf->codes[3312] = 0x00042238a9c9a37dUL;
   tf->codes[3313] = 0x0004224070c867a7UL;
   tf->codes[3314] = 0x0004224195938480UL;
   tf->codes[3315] = 0x000422427fcf9b94UL;
   tf->codes[3316] = 0x00042242ba5ea159UL;
   tf->codes[3317] = 0x00042245b3a1ec5aUL;
   tf->codes[3318] = 0x00042248e7743d20UL;
   tf->codes[3319] = 0x0004224fc436ea36UL;
   tf->codes[3320] = 0x00042253a7b64c4bUL;
   tf->codes[3321] = 0x00042255419f74aeUL;
   tf->codes[3322] = 0x00042255b6bd8038UL;
   tf->codes[3323] = 0x00042256db889d11UL;
   tf->codes[3324] = 0x000422580053b9eaUL;
   tf->codes[3325] = 0x0004225c1e6221c4UL;
   tf->codes[3326] = 0x00042266dea430efUL;
   tf->codes[3327] = 0x0004226962c97066UL;
   tf->codes[3328] = 0x0004226ac2239304UL;
   tf->codes[3329] = 0x0004226afcb298c9UL;
   tf->codes[3330] = 0x0004227004fd17b7UL;
   tf->codes[3331] = 0x0004227498298b1bUL;
   tf->codes[3332] = 0x0004227547d69c6aUL;
   tf->codes[3333] = 0x00042275bcf4a7f4UL;
   tf->codes[3334] = 0x00042275f783adb9UL;
   tf->codes[3335] = 0x00042276e1bfc4cdUL;
   tf->codes[3336] = 0x000422784119e76bUL;
   tf->codes[3337] = 0x0004227965e50444UL;
   tf->codes[3338] = 0x0004227b74ec3831UL;
   tf->codes[3339] = 0x0004227dbe8271e3UL;
   tf->codes[3340] = 0x0004227e6e2f8332UL;
   tf->codes[3341] = 0x000422854af23048UL;
   tf->codes[3342] = 0x00042285fa9f4197UL;
   tf->codes[3343] = 0x000422871f6a5e70UL;
   tf->codes[3344] = 0x00042287948869faUL;
   tf->codes[3345] = 0x0004228a8dcbb4fbUL;
   tf->codes[3346] = 0x0004228c27b4dd5eUL;
   tf->codes[3347] = 0x0004228c6243e323UL;
   tf->codes[3348] = 0x0004228eabda1cd5UL;
   tf->codes[3349] = 0x0004228ee669229aUL;
   tf->codes[3350] = 0x0004228f20f8285fUL;
   tf->codes[3351] = 0x00042290f5705687UL;
   tf->codes[3352] = 0x000422954e0dc426UL;
   tf->codes[3353] = 0x00042298bc6f1ab1UL;
   tf->codes[3354] = 0x0004229c9fee7cc6UL;
   tf->codes[3355] = 0x000422a5c647638eUL;
   tf->codes[3356] = 0x000422a6b0837aa2UL;
   tf->codes[3357] = 0x000422a8fa19b454UL;
   tf->codes[3358] = 0x000422ae02643342UL;
   tf->codes[3359] = 0x000422ae77823eccUL;
   tf->codes[3360] = 0x000422af61be55e0UL;
   tf->codes[3361] = 0x000422b30aaeb230UL;
   tf->codes[3362] = 0x000422b37fccbdbaUL;
   tf->codes[3363] = 0x000422b3ba5bc37fUL;
   tf->codes[3364] = 0x000422ba971e7095UL;
   tf->codes[3365] = 0x000422bf9f68ef83UL;
   tf->codes[3366] = 0x000422bfd9f7f548UL;
   tf->codes[3367] = 0x000422c382e85198UL;
   tf->codes[3368] = 0x000422c90050dc10UL;
   tf->codes[3369] = 0x000422cfa2848361UL;
   tf->codes[3370] = 0x000422d4aacf024fUL;
   tf->codes[3371] = 0x000422d51fed0dd9UL;
   tf->codes[3372] = 0x000422d72ef441c6UL;
   tf->codes[3373] = 0x000422d9036c6feeUL;
   tf->codes[3374] = 0x000422da28378cc7UL;
   tf->codes[3375] = 0x000422da62c6928cUL;
   tf->codes[3376] = 0x000422da9d559851UL;
   tf->codes[3377] = 0x000422dcac5ccc3eUL;
   tf->codes[3378] = 0x000422de4645f4a1UL;
   tf->codes[3379] = 0x000422dfa5a0173fUL;
   tf->codes[3380] = 0x000422e76c9edb69UL;
   tf->codes[3381] = 0x000422e9068803ccUL;
   tf->codes[3382] = 0x000422ec3a5a5492UL;
   tf->codes[3383] = 0x000422eebe7f9409UL;
   tf->codes[3384] = 0x000422f38c3b0d32UL;
   tf->codes[3385] = 0x000422f4eb952fd0UL;
   tf->codes[3386] = 0x000422f610604ca9UL;
   tf->codes[3387] = 0x00042302a51a89fcUL;
   tf->codes[3388] = 0x000423059e5dd4fdUL;
   tf->codes[3389] = 0x00042305d8ecdac2UL;
   tf->codes[3390] = 0x000423064e0ae64cUL;
   tf->codes[3391] = 0x00042306fdb7f79bUL;
   tf->codes[3392] = 0x0004230dda7aa4b1UL;
   tf->codes[3393] = 0x0004230e4f98b03bUL;
   tf->codes[3394] = 0x000423102410de63UL;
   tf->codes[3395] = 0x0004231616977465UL;
   tf->codes[3396] = 0x00042317b0809cc8UL;
   tf->codes[3397] = 0x000423189abcb3dcUL;
   tf->codes[3398] = 0x00042318d54bb9a1UL;
   tf->codes[3399] = 0x0004231ae452ed8eUL;
   tf->codes[3400] = 0x00042323d01cce91UL;
   tf->codes[3401] = 0x00042324f4e7eb6aUL;
   tf->codes[3402] = 0x00042326c9601992UL;
   tf->codes[3403] = 0x0004232a725075e2UL;
   tf->codes[3404] = 0x0004232b971b92bbUL;
   tf->codes[3405] = 0x0004232d6b93c0e3UL;
   tf->codes[3406] = 0x0004232e55cfd7f7UL;
   tf->codes[3407] = 0x0004232ecaede381UL;
   tf->codes[3408] = 0x0004232fb529fa95UL;
   tf->codes[3409] = 0x000423353292850dUL;
   tf->codes[3410] = 0x00042335e23f965cUL;
   tf->codes[3411] = 0x00042336575da1e6UL;
   tf->codes[3412] = 0x0004233691eca7abUL;
   tf->codes[3413] = 0x000423418cbdbc9bUL;
   tf->codes[3414] = 0x00042344fb1f1326UL;
   tf->codes[3415] = 0x000423461fea2fffUL;
   tf->codes[3416] = 0x0004234953bc80c5UL;
   tf->codes[3417] = 0x000423511abb44efUL;
   tf->codes[3418] = 0x00042351554a4ab4UL;
   tf->codes[3419] = 0x000423527a15678dUL;
   tf->codes[3420] = 0x0004235329c278dcUL;
   tf->codes[3421] = 0x000423539ee08466UL;
   tf->codes[3422] = 0x000423565d94c9a2UL;
   tf->codes[3423] = 0x00042358a72b0354UL;
   tf->codes[3424] = 0x0004235d3a5776b8UL;
   tf->codes[3425] = 0x0004235daf758242UL;
   tf->codes[3426] = 0x00042362f24f06f5UL;
   tf->codes[3427] = 0x000423691f64a2bcUL;
   tf->codes[3428] = 0x0004236b68fadc6eUL;
   tf->codes[3429] = 0x0004236cc854ff0cUL;
   tf->codes[3430] = 0x000423748f53c336UL;
   tf->codes[3431] = 0x00042377137902adUL;
   tf->codes[3432] = 0x0004237a81da5938UL;
   tf->codes[3433] = 0x0004237ba6a57611UL;
   tf->codes[3434] = 0x0004237be1347bd6UL;
   tf->codes[3435] = 0x0004237c1bc3819bUL;
   tf->codes[3436] = 0x0004237e6559bb4dUL;
   tf->codes[3437] = 0x00042382bdf728ecUL;
   tf->codes[3438] = 0x00042385b73a73edUL;
   tf->codes[3439] = 0x0004238666e7853cUL;
   tf->codes[3440] = 0x00042388b07dbeeeUL;
   tf->codes[3441] = 0x0004238edd935ab5UL;
   tf->codes[3442] = 0x0004238f52b1663fUL;
   tf->codes[3443] = 0x0004238fc7cf71c9UL;
   tf->codes[3444] = 0x00042394d019f0b7UL;
   tf->codes[3445] = 0x0004239719b02a69UL;
   tf->codes[3446] = 0x000423983e7b4742UL;
   tf->codes[3447] = 0x000423996346641bUL;
   tf->codes[3448] = 0x0004239d0c36c06bUL;
   tf->codes[3449] = 0x000423a3ae6a67bcUL;
   tf->codes[3450] = 0x000423a71ccbbe47UL;
   tf->codes[3451] = 0x000423a9db800383UL;
   tf->codes[3452] = 0x000423abaff831abUL;
   tf->codes[3453] = 0x000423ad84705fd3UL;
   tf->codes[3454] = 0x000423b0b842b099UL;
   tf->codes[3455] = 0x000423b376f6f5d5UL;
   tf->codes[3456] = 0x000423b585fe29c2UL;
   tf->codes[3457] = 0x000423b7cf946374UL;
   tf->codes[3458] = 0x000423b9a40c919cUL;
   tf->codes[3459] = 0x000423bac8d7ae75UL;
   tf->codes[3460] = 0x000423bb7884bfc4UL;
   tf->codes[3461] = 0x000423bd4cfcedecUL;
   tf->codes[3462] = 0x000423bdfca9ff3bUL;
   tf->codes[3463] = 0x000423c28fd6729fUL;
   tf->codes[3464] = 0x000423c3b4a18f78UL;
   tf->codes[3465] = 0x000423c4d96cac51UL;
   tf->codes[3466] = 0x000423c513fbb216UL;
   tf->codes[3467] = 0x000423c6ade4da79UL;
   tf->codes[3468] = 0x000423cc65dc6ab6UL;
   tf->codes[3469] = 0x000423cd15897c05UL;
   tf->codes[3470] = 0x000423d13397e3dfUL;
   tf->codes[3471] = 0x000423d2cd810c42UL;
   tf->codes[3472] = 0x000423e38049b16fUL;
   tf->codes[3473] = 0x000423eb0cb96fd4UL;
   tf->codes[3474] = 0x000423ec31848cadUL;
   tf->codes[3475] = 0x000423ece1319dfcUL;
   tf->codes[3476] = 0x000423f25e9a2874UL;
   tf->codes[3477] = 0x000423f38365454dUL;
   tf->codes[3478] = 0x000423f3bdf44b12UL;
   tf->codes[3479] = 0x000423f7a173ad27UL;
   tf->codes[3480] = 0x000423f81691b8b1UL;
   tf->codes[3481] = 0x000423fd1edc379fUL;
   tf->codes[3482] = 0x000423fe09184eb3UL;
   tf->codes[3483] = 0x000424017779a53eUL;
   tf->codes[3484] = 0x0004240903e963a3UL;
   tf->codes[3485] = 0x000424093e786968UL;
   tf->codes[3486] = 0x00042409b39674f2UL;
   tf->codes[3487] = 0x0004240a28b4807cUL;
   tf->codes[3488] = 0x0004240b4d7f9d55UL;
   tf->codes[3489] = 0x0004240cacd9bff3UL;
   tf->codes[3490] = 0x0004240fe0ac10b9UL;
   tf->codes[3491] = 0x00042413c42b72ceUL;
   tf->codes[3492] = 0x00042414ae6789e2UL;
   tf->codes[3493] = 0x000424160dc1ac80UL;
   tf->codes[3494] = 0x00042416f7fdc394UL;
   tf->codes[3495] = 0x00042417328cc959UL;
   tf->codes[3496] = 0x00042417e239daa8UL;
   tf->codes[3497] = 0x000424185757e632UL;
   tf->codes[3498] = 0x0004241a665f1a1fUL;
   tf->codes[3499] = 0x0004241c75664e0cUL;
   tf->codes[3500] = 0x0004241dd4c070aaUL;
   tf->codes[3501] = 0x000424238cb800e7UL;
   tf->codes[3502] = 0x00042427703762fcUL;
   tf->codes[3503] = 0x0004242b53b6c511UL;
   tf->codes[3504] = 0x0004242b8e45cad6UL;
   tf->codes[3505] = 0x0004242fac5432b0UL;
   tf->codes[3506] = 0x0004243021723e3aUL;
   tf->codes[3507] = 0x00042432e0268376UL;
   tf->codes[3508] = 0x0004243b1c43532aUL;
   tf->codes[3509] = 0x0004243c7b9d75c8UL;
   tf->codes[3510] = 0x0004243cb62c7b8dUL;
   tf->codes[3511] = 0x00042440d43ae367UL;
   tf->codes[3512] = 0x00042441be76fa7bUL;
   tf->codes[3513] = 0x0004244651a36ddfUL;
   tf->codes[3514] = 0x00042448d5c8ad56UL;
   tf->codes[3515] = 0x000424509cc77180UL;
   tf->codes[3516] = 0x000424568f4e0782UL;
   tf->codes[3517] = 0x0004245988915283UL;
   tf->codes[3518] = 0x0004245ae7eb7521UL;
   tf->codes[3519] = 0x0004245c81d49d84UL;
   tf->codes[3520] = 0x0004245d6c10b498UL;
   tf->codes[3521] = 0x0004245e1bbdc5e7UL;
   tf->codes[3522] = 0x00042463d3b55624UL;
   tf->codes[3523] = 0x00042464bdf16d38UL;
   tf->codes[3524] = 0x00042469511de09cUL;
   tf->codes[3525] = 0x000424698bace661UL;
   tf->codes[3526] = 0x0004246a3b59f7b0UL;
   tf->codes[3527] = 0x0004246b25960ec4UL;
   tf->codes[3528] = 0x0004246ece866b14UL;
   tf->codes[3529] = 0x00042471c7c9b615UL;
   tf->codes[3530] = 0x00042472ec94d2eeUL;
   tf->codes[3531] = 0x000424732723d8b3UL;
   tf->codes[3532] = 0x000424777fc14652UL;
   tf->codes[3533] = 0x0004247869fd5d66UL;
   tf->codes[3534] = 0x000424795439747aUL;
   tf->codes[3535] = 0x0004247f814f1041UL;
   tf->codes[3536] = 0x000424832a3f6c91UL;
   tf->codes[3537] = 0x00042483d9ec7de0UL;
   tf->codes[3538] = 0x000424865e11bd57UL;
   tf->codes[3539] = 0x0004248a41911f6cUL;
   tf->codes[3540] = 0x0004248cc5b65ee3UL;
   tf->codes[3541] = 0x000424911e53cc82UL;
   tf->codes[3542] = 0x0004249710da6284UL;
   tf->codes[3543] = 0x0004249ba406d5e8UL;
   tf->codes[3544] = 0x0004249d0360f886UL;
   tf->codes[3545] = 0x0004249ded9d0f9aUL;
   tf->codes[3546] = 0x0004249ed7d926aeUL;
   tf->codes[3547] = 0x000424a33076944dUL;
   tf->codes[3548] = 0x000424aa82574cedUL;
   tf->codes[3549] = 0x000424ab32045e3cUL;
   tf->codes[3550] = 0x000424ac1c407550UL;
   tf->codes[3551] = 0x000424accbed869fUL;
   tf->codes[3552] = 0x000424ad067c8c64UL;
   tf->codes[3553] = 0x000424ae65d6af02UL;
   tf->codes[3554] = 0x000424aedaf4ba8cUL;
   tf->codes[3555] = 0x000424b3e33f397aUL;
   tf->codes[3556] = 0x000424b41dce3f3fUL;
   tf->codes[3557] = 0x000424b751a09005UL;
   tf->codes[3558] = 0x000424b7c6be9b8fUL;
   tf->codes[3559] = 0x000424b83bdca719UL;
   tf->codes[3560] = 0x000424b8eb89b868UL;
   tf->codes[3561] = 0x000424bb351ff21aUL;
   tf->codes[3562] = 0x000424bbe4cd0369UL;
   tf->codes[3563] = 0x000424be68f242e0UL;
   tf->codes[3564] = 0x000424c1d753996bUL;
   tf->codes[3565] = 0x000424c211e29f30UL;
   tf->codes[3566] = 0x000424c420e9d31dUL;
   tf->codes[3567] = 0x000424c5f5620145UL;
   tf->codes[3568] = 0x000424c7c9da2f6dUL;
   tf->codes[3569] = 0x000424ca4dff6ee4UL;
   tf->codes[3570] = 0x000424ca888e74a9UL;
   tf->codes[3571] = 0x000424cbe7e89747UL;
   tf->codes[3572] = 0x000424cea69cdc83UL;
   tf->codes[3573] = 0x000424d0f0331635UL;
   tf->codes[3574] = 0x000424d12ac21bfaUL;
   tf->codes[3575] = 0x000424d19fe02784UL;
   tf->codes[3576] = 0x000424d3745855acUL;
   tf->codes[3577] = 0x000424d5835f8999UL;
   tf->codes[3578] = 0x000424d66d9ba0adUL;
   tf->codes[3579] = 0x000424da8baa0887UL;
   tf->codes[3580] = 0x000424db75e61f9bUL;
   tf->codes[3581] = 0x000424dbb0752560UL;
   tf->codes[3582] = 0x000424e1686cb59dUL;
   tf->codes[3583] = 0x000424e42720fad9UL;
   tf->codes[3584] = 0x000424e6ab463a50UL;
   tf->codes[3585] = 0x000424e6e5d54015UL;
   tf->codes[3586] = 0x000424e92f6b79c7UL;
   tf->codes[3587] = 0x000424f0f66a3df1UL;
   tf->codes[3588] = 0x000424f42a3c8eb7UL;
   tf->codes[3589] = 0x000424f932870da5UL;
   tf->codes[3590] = 0x000424f96d16136aUL;
   tf->codes[3591] = 0x000424fca0e86430UL;
   tf->codes[3592] = 0x000424fcdb7769f5UL;
   tf->codes[3593] = 0x000424fd16066fbaUL;
   tf->codes[3594] = 0x000424fdc5b38109UL;
   tf->codes[3595] = 0x000425008467c645UL;
   tf->codes[3596] = 0x00042502936efa32UL;
   tf->codes[3597] = 0x00042506ec0c67d1UL;
   tf->codes[3598] = 0x0004250810d784aaUL;
   tf->codes[3599] = 0x0004250a1fdeb897UL;
   tf->codes[3600] = 0x0004250b44a9d570UL;
   tf->codes[3601] = 0x0004250b7f38db35UL;
   tf->codes[3602] = 0x0004250d8e400f22UL;
   tf->codes[3603] = 0x000425104cf4545eUL;
   tf->codes[3604] = 0x00042512968a8e10UL;
   tf->codes[3605] = 0x0004251380c6a524UL;
   tf->codes[3606] = 0x00042513bb55aae9UL;
   tf->codes[3607] = 0x0004251764460739UL;
   tf->codes[3608] = 0x0004251a981857ffUL;
   tf->codes[3609] = 0x0004251f65d3d128UL;
   tf->codes[3610] = 0x0004252642967e3eUL;
   tf->codes[3611] = 0x00042527a1f0a0dcUL;
   tf->codes[3612] = 0x0004252bfa8e0e7bUL;
   tf->codes[3613] = 0x0004252d947736deUL;
   tf->codes[3614] = 0x00042534abc8e9b9UL;
   tf->codes[3615] = 0x00042537df9b3a7fUL;
   tf->codes[3616] = 0x000425381a2a4044UL;
   tf->codes[3617] = 0x00042539eea26e6cUL;
   tf->codes[3618] = 0x0004253bc31a9c94UL;
   tf->codes[3619] = 0x00042544aee47d97UL;
   tf->codes[3620] = 0x000425505962a3d6UL;
   tf->codes[3621] = 0x000425526869d7c3UL;
   tf->codes[3622] = 0x000425543ce205ebUL;
   tf->codes[3623] = 0x000425564be939d8UL;
   tf->codes[3624] = 0x0004255b8ec2be8bUL;
   tf->codes[3625] = 0x0004255ec2950f51UL;
   tf->codes[3626] = 0x000425631b327cf0UL;
   tf->codes[3627] = 0x0004256773cfea8fUL;
   tf->codes[3628] = 0x00042569484818b7UL;
   tf->codes[3629] = 0x0004256e8b219d6aUL;
   tf->codes[3630] = 0x00042572a9300544UL;
   tf->codes[3631] = 0x0004257910d4a6d0UL;
   tf->codes[3632] = 0x0004257c44a6f796UL;
   tf->codes[3633] = 0x00042589fe2c51c2UL;
   tf->codes[3634] = 0x00042592e9f632c5UL;
   tf->codes[3635] = 0x00042595a8aa7801UL;
   tf->codes[3636] = 0x0004259b9b310e03UL;
   tf->codes[3637] = 0x0004259fb93f75ddUL;
   tf->codes[3638] = 0x000425a1c846a9caUL;
   tf->codes[3639] = 0x000425ac4df9b330UL;
   tf->codes[3640] = 0x000425adad53d5ceUL;
   tf->codes[3641] = 0x000425afbc5b09bbUL;
   tf->codes[3642] = 0x000425aff6ea0f80UL;
   tf->codes[3643] = 0x000425b623ffab47UL;
   tf->codes[3644] = 0x000425b7bde8d3aaUL;
   tf->codes[3645] = 0x000425b86d95e4f9UL;
   tf->codes[3646] = 0x000425b8a824eabeUL;
   tf->codes[3647] = 0x000425b957d1fc0dUL;
   tf->codes[3648] = 0x000425bcc6335298UL;
   tf->codes[3649] = 0x000425c06f23aee8UL;
   tf->codes[3650] = 0x000425c11ed0c037UL;
   tf->codes[3651] = 0x000425c193eecbc1UL;
   tf->codes[3652] = 0x000425c6d6c85074UL;
   tf->codes[3653] = 0x000425c8ab407e9cUL;
   tf->codes[3654] = 0x000425cb69f4c3d8UL;
   tf->codes[3655] = 0x000425cdb38afd8aUL;
   tf->codes[3656] = 0x000425ce9dc7149eUL;
   tf->codes[3657] = 0x000425d037b03d01UL;
   tf->codes[3658] = 0x000425d2f664823dUL;
   tf->codes[3659] = 0x000425d5056bb62aUL;
   tf->codes[3660] = 0x000425d5b518c779UL;
   tf->codes[3661] = 0x000425d664c5d8c8UL;
   tf->codes[3662] = 0x000425d7c41ffb66UL;
   tf->codes[3663] = 0x000425da82d440a2UL;
   tf->codes[3664] = 0x000425dabd634667UL;
   tf->codes[3665] = 0x000425e493693e7eUL;
   tf->codes[3666] = 0x000425e543164fcdUL;
   tf->codes[3667] = 0x000425e5b8345b57UL;
   tf->codes[3668] = 0x000425e801ca9509UL;
   tf->codes[3669] = 0x000425eb359ce5cfUL;
   tf->codes[3670] = 0x000425ec1fd8fce3UL;
   tf->codes[3671] = 0x000425ef8e3a536eUL;
   tf->codes[3672] = 0x000425f3ac48bb48UL;
   tf->codes[3673] = 0x000425f964404b85UL;
   tf->codes[3674] = 0x000425fc22f490c1UL;
   tf->codes[3675] = 0x000425fd0d30a7d5UL;
   tf->codes[3676] = 0x000425fdbcddb924UL;
   tf->codes[3677] = 0x00042603e9f354ebUL;
   tf->codes[3678] = 0x00042605494d7789UL;
   tf->codes[3679] = 0x00042606a8a79a27UL;
   tf->codes[3680] = 0x00042614d74affddUL;
   tf->codes[3681] = 0x0004261b04609ba4UL;
   tf->codes[3682] = 0x0004261cd8d8c9ccUL;
   tf->codes[3683] = 0x000426258a13a50aUL;
   tf->codes[3684] = 0x00042627991ad8f7UL;
   tf->codes[3685] = 0x00042638867283e9UL;
   tf->codes[3686] = 0x0004263ad008bd9bUL;
   tf->codes[3687] = 0x0004264814700c3dUL;
   tf->codes[3688] = 0x00042648feac2351UL;
   tf->codes[3689] = 0x00042650508cdbf1UL;
   tf->codes[3690] = 0x000426530f41212dUL;
   tf->codes[3691] = 0x00042663877ac095UL;
   tf->codes[3692] = 0x00042667306b1ce5UL;
   tf->codes[3693] = 0x0004266dd29ec436UL;
   tf->codes[3694] = 0x0004267bc6b32427UL;
   tf->codes[3695] = 0x0004267d9b2b524fUL;
   tf->codes[3696] = 0x0004267faa32863cUL;
   tf->codes[3697] = 0x00042681b939ba29UL;
   tf->codes[3698] = 0x00042682a375d13dUL;
   tf->codes[3699] = 0x00042684b27d052aUL;
   tf->codes[3700] = 0x000426859cb91c3eUL;
   tf->codes[3701] = 0x0004268820de5bb5UL;
   tf->codes[3702] = 0x0004268f72bf1455UL;
   tf->codes[3703] = 0x00042690978a312eUL;
   tf->codes[3704] = 0x00042694407a8d7eUL;
   tf->codes[3705] = 0x0004269b1d3d3a94UL;
   tf->codes[3706] = 0x0004269cf1b568bcUL;
   tf->codes[3707] = 0x000426a6180e4f84UL;
   tf->codes[3708] = 0x000426b446b1b53aUL;
   tf->codes[3709] = 0x000426b61b29e362UL;
   tf->codes[3710] = 0x000426ba39384b3cUL;
   tf->codes[3711] = 0x000426bc483f7f29UL;
   tf->codes[3712] = 0x000426bc82ce84eeUL;
   tf->codes[3713] = 0x000426bda799a1c7UL;
   tf->codes[3714] = 0x000426be1cb7ad51UL;
   tf->codes[3715] = 0x000426c0a0dcecc8UL;
   tf->codes[3716] = 0x000426c3d4af3d8eUL;
   tf->codes[3717] = 0x000426c82d4cab2dUL;
   tf->codes[3718] = 0x000426ca76e2e4dfUL;
   tf->codes[3719] = 0x000426cb268ff62eUL;
   tf->codes[3720] = 0x000426d02eda751cUL;
   tf->codes[3721] = 0x000426d18e3497baUL;
   tf->codes[3722] = 0x000426d65bf010e3UL;
   tf->codes[3723] = 0x000426d7f5d93946UL;
   tf->codes[3724] = 0x000426d91aa4561fUL;
   tf->codes[3725] = 0x000426dcc394b26fUL;
   tf->codes[3726] = 0x000426e65f0ba4c1UL;
   tf->codes[3727] = 0x000426f8369f66c7UL;
   tf->codes[3728] = 0x000426f8e64c7816UL;
   tf->codes[3729] = 0x000426fbdf8fc317UL;
   tf->codes[3730] = 0x000426fd3ee9e5b5UL;
   tf->codes[3731] = 0x00042704563b9890UL;
   tf->codes[3732] = 0x00042705b595bb2eUL;
   tf->codes[3733] = 0x000427103b48c494UL;
   tf->codes[3734] = 0x00042718b1f49a0dUL;
   tf->codes[3735] = 0x00042725813ddd25UL;
   tf->codes[3736] = 0x00042738f2bac78eUL;
   tf->codes[3737] = 0x0004273bb16f0ccaUL;
   tf->codes[3738] = 0x0004273e35944c41UL;
   tf->codes[3739] = 0x0004273fcf7d74a4UL;
   tf->codes[3740] = 0x000427451256f957UL;
   tf->codes[3741] = 0x00042746ac4021baUL;
   tf->codes[3742] = 0x000427480b9a4458UL;
   tf->codes[3743] = 0x0004275bb7a63486UL;
   tf->codes[3744] = 0x0004275f609690d6UL;
   tf->codes[3745] = 0x0004276ca4fddf78UL;
   tf->codes[3746] = 0x0004276e04580216UL;
   tf->codes[3747] = 0x000427729784757aUL;
   tf->codes[3748] = 0x0004277ca8197356UL;
   tf->codes[3749] = 0x0004277e077395f4UL;
   tf->codes[3750] = 0x0004278f2f5a46abUL;
   tf->codes[3751] = 0x0004279387f7b44aUL;
   tf->codes[3752] = 0x00042796813aff4bUL;
   tf->codes[3753] = 0x00042796f6590ad5UL;
   tf->codes[3754] = 0x00042797a6061c24UL;
   tf->codes[3755] = 0x0004279a2a2b5b9bUL;
   tf->codes[3756] = 0x000427ad268a3a7aUL;
   tf->codes[3757] = 0x000427b528180469UL;
   tf->codes[3758] = 0x000427b6c2012cccUL;
   tf->codes[3759] = 0x000427b90b97667eUL;
   tf->codes[3760] = 0x000427bec38ef6bbUL;
   tf->codes[3761] = 0x000427bfe85a1394UL;
   tf->codes[3762] = 0x000427ce16fd794aUL;
   tf->codes[3763] = 0x000427cfb0e6a1adUL;
   tf->codes[3764] = 0x000427db95f3cdb1UL;
   tf->codes[3765] = 0x000427e063af46daUL;
   tf->codes[3766] = 0x000427e3d2109d65UL;
   tf->codes[3767] = 0x000427e5316ac003UL;
   tf->codes[3768] = 0x000427e74071f3f0UL;
   tf->codes[3769] = 0x000427fc86670c81UL;
   tf->codes[3770] = 0x00042805e74ef90eUL;
   tf->codes[3771] = 0x0004280f0da7dfd6UL;
   tf->codes[3772] = 0x0004281191cd1f4dUL;
   tf->codes[3773] = 0x00042812b6983c26UL;
   tf->codes[3774] = 0x00042813a0d4533aUL;
   tf->codes[3775] = 0x000428178453b54fUL;
   tf->codes[3776] = 0x0004282194e8b32bUL;
   tf->codes[3777] = 0x000428248e2bfe2cUL;
   tf->codes[3778] = 0x0004282996767d1aUL;
   tf->codes[3779] = 0x00042837156cd181UL;
   tf->codes[3780] = 0x000428407654be0eUL;
   tf->codes[3781] = 0x0004286300b12541UL;
   tf->codes[3782] = 0x00042869a2e4cc92UL;
   tf->codes[3783] = 0x0004286bec7b0644UL;
   tf->codes[3784] = 0x0004286f204d570aUL;
   tf->codes[3785] = 0x000428700a896e1eUL;
   tf->codes[3786] = 0x000428721990a20bUL;
   tf->codes[3787] = 0x00042875fd100420UL;
   tf->codes[3788] = 0x0004287b055a830eUL;
   tf->codes[3789] = 0x0004288306e84cfdUL;
   tf->codes[3790] = 0x00042891701ab878UL;
   tf->codes[3791] = 0x00042892cf74db16UL;
   tf->codes[3792] = 0x00042899e6c68df1UL;
   tf->codes[3793] = 0x0004289bbb3ebc19UL;
   tf->codes[3794] = 0x0004289e3f63fb90UL;
   tf->codes[3795] = 0x0004289f29a012a4UL;
   tf->codes[3796] = 0x000428a347ae7a7eUL;
   tf->codes[3797] = 0x000428ae07f089a9UL;
   tf->codes[3798] = 0x000428b1eb6febbeUL;
   tf->codes[3799] = 0x000428bd5b5f0c38UL;
   tf->codes[3800] = 0x000428bfa4f545eaUL;
   tf->codes[3801] = 0x000428c1b3fc79d7UL;
   tf->codes[3802] = 0x000428c2291a8561UL;
   tf->codes[3803] = 0x000428c263a98b26UL;
   tf->codes[3804] = 0x000428c29e3890ebUL;
   tf->codes[3805] = 0x000428c34de5a23aUL;
   tf->codes[3806] = 0x000428d141fa022bUL;
   tf->codes[3807] = 0x000428d38b903bddUL;
   tf->codes[3808] = 0x000428e22f51ad1dUL;
   tf->codes[3809] = 0x000428e64d6014f7UL;
   tf->codes[3810] = 0x000428eb55aa93e5UL;
   tf->codes[3811] = 0x000428f357385dd4UL;
   tf->codes[3812] = 0x000428f73ab7bfe9UL;
   tf->codes[3813] = 0x000428f949bef3d6UL;
   tf->codes[3814] = 0x00042904b9ae1450UL;
   tf->codes[3815] = 0x00042908629e70a0UL;
   tf->codes[3816] = 0x0004291273336e7cUL;
   tf->codes[3817] = 0x0004291322e07fcbUL;
   tf->codes[3818] = 0x00042913d28d911aUL;
   tf->codes[3819] = 0x00042914823aa269UL;
   tf->codes[3820] = 0x00042915e194c507UL;
   tf->codes[3821] = 0x000429198a852157UL;
   tf->codes[3822] = 0x0004291da8938931UL;
   tf->codes[3823] = 0x0004291f427cb194UL;
   tf->codes[3824] = 0x00042923d5a924f8UL;
   tf->codes[3825] = 0x000429295311af70UL;
   tf->codes[3826] = 0x0004292bd736eee7UL;
   tf->codes[3827] = 0x000429453b3a6f52UL;
   tf->codes[3828] = 0x0004294ffb7c7e7dUL;
   tf->codes[3829] = 0x00042952f4bfc97eUL;
   tf->codes[3830] = 0x00042953a46cdacdUL;
   tf->codes[3831] = 0x00042955b3740ebaUL;
   tf->codes[3832] = 0x0004295a812f87e3UL;
   tf->codes[3833] = 0x0004296282bd51d2UL;
   tf->codes[3834] = 0x0004296506e29149UL;
   tf->codes[3835] = 0x0004296a844b1bc1UL;
   tf->codes[3836] = 0x0004296d08705b38UL;
   tf->codes[3837] = 0x00042975448d2aecUL;
   tf->codes[3838] = 0x00042976a3e74d8aUL;
   tf->codes[3839] = 0x0004297803417028UL;
   tf->codes[3840] = 0x000429799d2a988bUL;
   tf->codes[3841] = 0x0004297afc84bb29UL;
   tf->codes[3842] = 0x000429819eb8627aUL;
   tf->codes[3843] = 0x0004298288f4798eUL;
   tf->codes[3844] = 0x000429866c73dba3UL;
   tf->codes[3845] = 0x0004298a4ff33db8UL;
   tf->codes[3846] = 0x0004299968d2ba82UL;
   tf->codes[3847] = 0x0004299e368e33abUL;
   tf->codes[3848] = 0x0004299fd0775c0eUL;
   tf->codes[3849] = 0x000429a80c942bc2UL;
   tf->codes[3850] = 0x000429acda4fa4ebUL;
   tf->codes[3851] = 0x000429af23e5de9dUL;
   tf->codes[3852] = 0x000429b884cdcb2aUL;
   tf->codes[3853] = 0x000429bb43821066UL;
   tf->codes[3854] = 0x000429c37f9ee01aUL;
   tf->codes[3855] = 0x000429c7288f3c6aUL;
   tf->codes[3856] = 0x000429d591c1a7e5UL;
   tf->codes[3857] = 0x000429d76639d60dUL;
   tf->codes[3858] = 0x000429d9ea5f1584UL;
   tf->codes[3859] = 0x000429deb81a8eadUL;
   tf->codes[3860] = 0x000429e51fbf3039UL;
   tf->codes[3861] = 0x000429ebc1f2d78aUL;
   tf->codes[3862] = 0x000429ec719fe8d9UL;
   tf->codes[3863] = 0x000429f29eb584a0UL;
   tf->codes[3864] = 0x000429f6bcc3ec7aUL;
   tf->codes[3865] = 0x000429f9b607377bUL;
   tf->codes[3866] = 0x000429ffe31cd342UL;
   tf->codes[3867] = 0x00042a03c69c3557UL;
   tf->codes[3868] = 0x00042a04b0d84c6bUL;
   tf->codes[3869] = 0x00042a059b14637fUL;
   tf->codes[3870] = 0x00042a105b5672aaUL;
   tf->codes[3871] = 0x00042a1faec4f539UL;
   tf->codes[3872] = 0x00042a24b70f7427UL;
   tf->codes[3873] = 0x00042a2e52866679UL;
   tf->codes[3874] = 0x00042a3de083eecdUL;
   tf->codes[3875] = 0x00042a40d9c739ceUL;
   tf->codes[3876] = 0x00042a453264a76dUL;
   tf->codes[3877] = 0x00042a4691beca0bUL;
   tf->codes[3878] = 0x00042a49c5911ad1UL;
   tf->codes[3879] = 0x00042a4cbed465d2UL;
   tf->codes[3880] = 0x00042a4ff2a6b698UL;
   tf->codes[3881] = 0x00042a511771d371UL;
   tf->codes[3882] = 0x00042a54c0622fc1UL;
   tf->codes[3883] = 0x00042a55700f4110UL;
   tf->codes[3884] = 0x00042a5918ff9d60UL;
   tf->codes[3885] = 0x00042a706dfbe9deUL;
   tf->codes[3886] = 0x00042a75b0d56e91UL;
   tf->codes[3887] = 0x00042a791f36c51cUL;
   tf->codes[3888] = 0x00042a79cee3d66bUL;
   tf->codes[3889] = 0x00042a7a7e90e7baUL;
   tf->codes[3890] = 0x00042a7db2633880UL;
   tf->codes[3891] = 0x00042a8195e29a95UL;
   tf->codes[3892] = 0x00042a86639e13beUL;
   tf->codes[3893] = 0x00042a8fc486004bUL;
   tf->codes[3894] = 0x00042a8fff150610UL;
   tf->codes[3895] = 0x00042a9be4223214UL;
   tf->codes[3896] = 0x00042a9c59403d9eUL;
   tf->codes[3897] = 0x00042a9f17f482daUL;
   tf->codes[3898] = 0x00042aa7c92f5e18UL;
   tf->codes[3899] = 0x00042aac5c5bd17cUL;
   tf->codes[3900] = 0x00042aba5070316dUL;
   tf->codes[3901] = 0x00042abf9349b620UL;
   tf->codes[3902] = 0x00042ac75a487a4aUL;
   tf->codes[3903] = 0x00042ac87f139723UL;
   tf->codes[3904] = 0x00042ac92ec0a872UL;
   tf->codes[3905] = 0x00042ad7d28219b2UL;
   tf->codes[3906] = 0x00042ade74b5c103UL;
   tf->codes[3907] = 0x00042ae8102cb355UL;
   tf->codes[3908] = 0x00042aea59c2ed07UL;
   tf->codes[3909] = 0x00042aeca35926b9UL;
   tf->codes[3910] = 0x00042af6b3ee2495UL;
   tf->codes[3911] = 0x00042af972a269d1UL;
   tf->codes[3912] = 0x00042afa224f7b20UL;
   tf->codes[3913] = 0x00042afd5621cbe6UL;
   tf->codes[3914] = 0x00042afd90b0d1abUL;
   tf->codes[3915] = 0x00042afe05cedd35UL;
   tf->codes[3916] = 0x00042afe7aece8bfUL;
   tf->codes[3917] = 0x00042b0223dd450fUL;
   tf->codes[3918] = 0x00042b03bdc66d72UL;
   tf->codes[3919] = 0x00042b0850f2e0d6UL;
   tf->codes[3920] = 0x00042b0a9a891a88UL;
   tf->codes[3921] = 0x00042b113cbcc1d9UL;
   tf->codes[3922] = 0x00042b16ba254c51UL;
   tf->codes[3923] = 0x00042b1d5c58f3a2UL;
   tf->codes[3924] = 0x00042b2682b1da6aUL;
   tf->codes[3925] = 0x00042b276cedf17eUL;
   tf->codes[3926] = 0x00042b29b6842b30UL;
   tf->codes[3927] = 0x00042b2c7538706cUL;
   tf->codes[3928] = 0x00042b2dd492930aUL;
   tf->codes[3929] = 0x00042b32dcdd11f8UL;
   tf->codes[3930] = 0x00042b343c373496UL;
   tf->codes[3931] = 0x00042b3526734baaUL;
   tf->codes[3932] = 0x00042b35d6205cf9UL;
   tf->codes[3933] = 0x00042b4404c3c2afUL;
   tf->codes[3934] = 0x00042b50245ff478UL;
   tf->codes[3935] = 0x00042b54426e5c52UL;
   tf->codes[3936] = 0x00042b552caa7366UL;
   tf->codes[3937] = 0x00042b5825edbe67UL;
   tf->codes[3938] = 0x00042b5b1f310968UL;
   tf->codes[3939] = 0x00042b665491241dUL;
   tf->codes[3940] = 0x00042b6f405b0520UL;
   tf->codes[3941] = 0x00042b72399e5021UL;
   tf->codes[3942] = 0x00042b818d0cd2b0UL;
   tf->codes[3943] = 0x00042b86cfe65763UL;
   tf->codes[3944] = 0x00042b94144da605UL;
   tf->codes[3945] = 0x00042b969872e57cUL;
   tf->codes[3946] = 0x00042b98e2091f2eUL;
   tf->codes[3947] = 0x00042b99cc453642UL;
   tf->codes[3948] = 0x00042b9a7bf24791UL;
   tf->codes[3949] = 0x00042b9c15db6ff4UL;
   tf->codes[3950] = 0x00042ba6d61d7f1fUL;
   tf->codes[3951] = 0x00042ba710ac84e4UL;
   tf->codes[3952] = 0x00042bb037056bacUL;
   tf->codes[3953] = 0x00042bb20b7d99d4UL;
   tf->codes[3954] = 0x00042bb3a566c237UL;
   tf->codes[3955] = 0x00042bb74e571e87UL;
   tf->codes[3956] = 0x00042bbabcb87512UL;
   tf->codes[3957] = 0x00042bc2be463f01UL;
   tf->codes[3958] = 0x00042bcc59bd3153UL;
   tf->codes[3959] = 0x00042bcdb91753f1UL;
   tf->codes[3960] = 0x00042bd78f1d4c08UL;
   tf->codes[3961] = 0x00042bd8ee776ea6UL;
   tf->codes[3962] = 0x00042bdd4714dc45UL;
   tf->codes[3963] = 0x00042bde6bdff91eUL;
   tf->codes[3964] = 0x00042be1da414fa9UL;
   tf->codes[3965] = 0x00042be80756eb70UL;
   tf->codes[3966] = 0x00042bec9a835ed4UL;
   tf->codes[3967] = 0x00042befce55af9aUL;
   tf->codes[3968] = 0x00042bf5c0dc459cUL;
   tf->codes[3969] = 0x00042bf80a727f4eUL;
   tf->codes[3970] = 0x00042bf8f4ae9662UL;
   tf->codes[3971] = 0x00042bfbedf1e163UL;
   tf->codes[3972] = 0x00042bff21c43229UL;
   tf->codes[3973] = 0x00042c063915e504UL;
   tf->codes[3974] = 0x00042c100f1bdd1bUL;
   tf->codes[3975] = 0x00042c163c3178e2UL;
   tf->codes[3976] = 0x00042c1d53832bbdUL;
   tf->codes[3977] = 0x00042c1f27fb59e5UL;
   tf->codes[3978] = 0x00042c26b46b184aUL;
   tf->codes[3979] = 0x00042c27d9363523UL;
   tf->codes[3980] = 0x00042c2a5d5b749aUL;
   tf->codes[3981] = 0x00042c2bbcb59738UL;
   tf->codes[3982] = 0x00042c2eb5f8e239UL;
   tf->codes[3983] = 0x00042c2f65a5f388UL;
   tf->codes[3984] = 0x00042c325ee93e89UL;
   tf->codes[3985] = 0x00042c330e964fd8UL;
   tf->codes[3986] = 0x00042c351d9d83c5UL;
   tf->codes[3987] = 0x00042c35582c898aUL;
   tf->codes[3988] = 0x00042c367cf7a663UL;
   tf->codes[3989] = 0x00042c36b786ac28UL;
   tf->codes[3990] = 0x00042c3ad5951402UL;
   tf->codes[3991] = 0x00042c3e096764c8UL;
   tf->codes[3992] = 0x00042c464584347cUL;
   tf->codes[3993] = 0x00042c4c7299d043UL;
   tf->codes[3994] = 0x00042c50cb373de2UL;
   tf->codes[3995] = 0x00042c51b57354f6UL;
   tf->codes[3996] = 0x00042c5adbcc3bbeUL;
   tf->codes[3997] = 0x00042c5f3469a95dUL;
   tf->codes[3998] = 0x00042c62dd5a05adUL;
   tf->codes[3999] = 0x00042c685ac29025UL;
   tf->codes[4000] = 0x00042c6cb35ffdc4UL;
   tf->codes[4001] = 0x00042c6d9d9c14d8UL;
   tf->codes[4002] = 0x00042c7aa7745db5UL;
   tf->codes[4003] = 0x00042c7da0b7a8b6UL;
   tf->codes[4004] = 0x00042c8099faf3b7UL;
   tf->codes[4005] = 0x00042c80d489f97cUL;
   tf->codes[4006] = 0x00042c8dde624259UL;
   tf->codes[4007] = 0x00042c8f032d5f32UL;
   tf->codes[4008] = 0x00042c914cc398e4UL;
   tf->codes[4009] = 0x00042c92ac1dbb82UL;
   tf->codes[4010] = 0x00042c9988e06898UL;
   tf->codes[4011] = 0x00042c99c36f6e5dUL;
   tf->codes[4012] = 0x00042c9d31d0c4e8UL;
   tf->codes[4013] = 0x00042c9de17dd637UL;
   tf->codes[4014] = 0x00042cb6d0634b18UL;
   tf->codes[4015] = 0x00042cb98f179054UL;
   tf->codes[4016] = 0x00042cc240526b92UL;
   tf->codes[4017] = 0x00042cc832d90194UL;
   tf->codes[4018] = 0x00042cc8a7f70d1eUL;
   tf->codes[4019] = 0x00042ccfbf48bff9UL;
   tf->codes[4020] = 0x00042cdffcf3599cUL;
   tf->codes[4021] = 0x00042ce8e8bd3a9fUL;
   tf->codes[4022] = 0x00042cf6a24294cbUL;
   tf->codes[4023] = 0x00042cfa85c1f6e0UL;
   tf->codes[4024] = 0x00042cfc5a3a2508UL;
   tf->codes[4025] = 0x00042cfdf4234d6bUL;
   tf->codes[4026] = 0x00042d07ca294582UL;
   tf->codes[4027] = 0x00042d12c4fa5a72UL;
   tf->codes[4028] = 0x00042d150e909424UL;
   tf->codes[4029] = 0x00042d16335bb0fdUL;
   tf->codes[4030] = 0x00042d1c60714cc4UL;
   tf->codes[4031] = 0x00042d1e6f7880b1UL;
   tf->codes[4032] = 0x00042d21a34ad177UL;
   tf->codes[4033] = 0x00042d25c1593951UL;
   tf->codes[4034] = 0x00042d25fbe83f16UL;
   tf->codes[4035] = 0x00042d275b4261b4UL;
   tf->codes[4036] = 0x00042d2bee6ed518UL;
   tf->codes[4037] = 0x00042d32cb31822eUL;
   tf->codes[4038] = 0x00042d3accbf4c1dUL;
   tf->codes[4039] = 0x00042d3b41dd57a7UL;
   tf->codes[4040] = 0x00042d3ca1377a45UL;
   tf->codes[4041] = 0x00042d42ce4d160cUL;
   tf->codes[4042] = 0x00042d4308dc1bd1UL;
   tf->codes[4043] = 0x00042d4f6307535fUL;
   tf->codes[4044] = 0x00042d4f9d965924UL;
   tf->codes[4045] = 0x00042d504d436a73UL;
   tf->codes[4046] = 0x00042d50c26175fdUL;
   tf->codes[4047] = 0x00042d53bba4c0feUL;
   tf->codes[4048] = 0x00042d53f633c6c3UL;
   tf->codes[4049] = 0x00042d579f242313UL;
   tf->codes[4050] = 0x00042d5a98676e14UL;
   tf->codes[4051] = 0x00042d5bf7c190b2UL;
   tf->codes[4052] = 0x00042d60505efe51UL;
   tf->codes[4053] = 0x00042d613a9b1565UL;
   tf->codes[4054] = 0x00042d63f94f5aa1UL;
   tf->codes[4055] = 0x00042d6608568e8eUL;
   tf->codes[4056] = 0x00042d667d749a18UL;
   tf->codes[4057] = 0x00042d68175dc27bUL;
   tf->codes[4058] = 0x00042d6d94c64cf3UL;
   tf->codes[4059] = 0x00042d6eb99169ccUL;
   tf->codes[4060] = 0x00042d717845af08UL;
   tf->codes[4061] = 0x00042d755bc5111dUL;
   tf->codes[4062] = 0x00042d7680902df6UL;
   tf->codes[4063] = 0x00042d7c3887be33UL;
   tf->codes[4064] = 0x00042d810643375cUL;
   tf->codes[4065] = 0x00042d89f20d185fUL;
   tf->codes[4066] = 0x00042d8bc6854687UL;
   tf->codes[4067] = 0x00042d8cb0c15d9bUL;
   tf->codes[4068] = 0x00042d931865ff27UL;
   tf->codes[4069] = 0x00042d9352f504ecUL;
   tf->codes[4070] = 0x00042d9402a2163bUL;
   tf->codes[4071] = 0x00042d9b5482cedbUL;
   tf->codes[4072] = 0x00042da3561098caUL;
   tf->codes[4073] = 0x00042db26ef01594UL;
   tf->codes[4074] = 0x00042db568336095UL;
   tf->codes[4075] = 0x00042dc4bba1e324UL;
   tf->codes[4076] = 0x00042dc7b4e52e25UL;
   tf->codes[4077] = 0x00042dc9895d5c4dUL;
   tf->codes[4078] = 0x00042dd8a23cd917UL;
   tf->codes[4079] = 0x00042ddc85bc3b2cUL;
   tf->codes[4080] = 0x00042ddcc04b40f1UL;
   tf->codes[4081] = 0x00042ddcfada46b6UL;
   tf->codes[4082] = 0x00042de2b2d1d6f3UL;
   tf->codes[4083] = 0x00042dee22c0f76dUL;
   tf->codes[4084] = 0x00042deed26e08bcUL;
   tf->codes[4085] = 0x00042deff7392595UL;
   tf->codes[4086] = 0x00042df3659a7c20UL;
   tf->codes[4087] = 0x00042dfffa54b973UL;
   tf->codes[4088] = 0x00042e03ddd41b88UL;
   tf->codes[4089] = 0x00042e06d7176689UL;
   tf->codes[4090] = 0x00042e08ab8f94b1UL;
   tf->codes[4091] = 0x00042e18741c22caUL;
   tf->codes[4092] = 0x00042e19d3764568UL;
   tf->codes[4093] = 0x00042e1a832356b7UL;
   tf->codes[4094] = 0x00042e1abdb25c7cUL;
   tf->codes[4095] = 0x00042e1b6d5f6dcbUL;
   tf->codes[4096] = 0x00042e1edbc0c456UL;
   tf->codes[4097] = 0x00042e23a97c3d7fUL;
   tf->codes[4098] = 0x00042e2afb5cf61fUL;
   tf->codes[4099] = 0x00042e39d9ad6d24UL;
   tf->codes[4100] = 0x00042e3fcc340326UL;
   tf->codes[4101] = 0x00042e42c5774e27UL;
   tf->codes[4102] = 0x00042e4f1fa285b5UL;
   tf->codes[4103] = 0x00042e512ea9b9a2UL;
   tf->codes[4104] = 0x00042e5427ed04a3UL;
   tf->codes[4105] = 0x00042e5c297ace92UL;
   tf->codes[4106] = 0x00042e5f97dc251dUL;
   tf->codes[4107] = 0x00042e679969ef0cUL;
   tf->codes[4108] = 0x00042e742e242c5fUL;
   tf->codes[4109] = 0x00042e7ad057d3b0UL;
   tf->codes[4110] = 0x00042e7c2fb1f64eUL;
   tf->codes[4111] = 0x00042e7e79483000UL;
   tf->codes[4112] = 0x00042e80884f63edUL;
   tf->codes[4113] = 0x00042e8b0e026d53UL;
   tf->codes[4114] = 0x00042e8c32cd8a2cUL;
   tf->codes[4115] = 0x00042e967df18dcdUL;
   tf->codes[4116] = 0x00042e9b111e0131UL;
   tf->codes[4117] = 0x00042e9e7f7f57bcUL;
   tf->codes[4118] = 0x00042ea76b4938bfUL;
   tf->codes[4119] = 0x00042eb6f946c113UL;
   tf->codes[4120] = 0x00042eb9084df500UL;
   tf->codes[4121] = 0x00042ec736f15ab6UL;
   tf->codes[4122] = 0x00042ec8d0da8319UL;
   tf->codes[4123] = 0x00042ed10cf752cdUL;
   tf->codes[4124] = 0x00042ed61541d1bbUL;
   tf->codes[4125] = 0x00042ede8beda734UL;
   tf->codes[4126] = 0x00042ee5ddce5fd4UL;
   tf->codes[4127] = 0x00042ee6185d6599UL;
   tf->codes[4128] = 0x00042eecba910ceaUL;
   tf->codes[4129] = 0x00042eeddf5c29c3UL;
   tf->codes[4130] = 0x00042f0cfb573a6bUL;
   tf->codes[4131] = 0x00042f14c255fe95UL;
   tf->codes[4132] = 0x00042f1c4ec5bcfaUL;
   tf->codes[4133] = 0x00042f26d478c660UL;
   tf->codes[4134] = 0x00042f2ba2343f89UL;
   tf->codes[4135] = 0x00042f2c51e150d8UL;
   tf->codes[4136] = 0x00042f34536f1ac7UL;
   tf->codes[4137] = 0x00042f353dab31dbUL;
   tf->codes[4138] = 0x00042f3f88cf357cUL;
   tf->codes[4139] = 0x00042f4be2fa6d0aUL;
   tf->codes[4140] = 0x00042f4db7729b32UL;
   tf->codes[4141] = 0x00042f4f16ccbdd0UL;
   tf->codes[4142] = 0x00042f51d581030cUL;
   tf->codes[4143] = 0x00042f5459a64283UL;
   tf->codes[4144] = 0x00042f5668ad7670UL;
   tf->codes[4145] = 0x00042f62fd67b3c3UL;
   tf->codes[4146] = 0x00042f6805b232b1UL;
   tf->codes[4147] = 0x00042f68b55f4400UL;
   tf->codes[4148] = 0x00042f68efee49c5UL;
   tf->codes[4149] = 0x00042f6b7413893cUL;
   tf->codes[4150] = 0x00042f6dbda9c2eeUL;
   tf->codes[4151] = 0x00042f6df838c8b3UL;
   tf->codes[4152] = 0x00042f6fccb0f6dbUL;
   tf->codes[4153] = 0x00042f7f5aae7f2fUL;
   tf->codes[4154] = 0x00042f8587c41af6UL;
   tf->codes[4155] = 0x00042f9acdb93387UL;
   tf->codes[4156] = 0x00042f9e018b844dUL;
   tf->codes[4157] = 0x00042fad1a6b0117UL;
   tf->codes[4158] = 0x00042fad8f890ca1UL;
   tf->codes[4159] = 0x00042fb3f72dae2dUL;
   tf->codes[4160] = 0x00042fb51bf8cb06UL;
   tf->codes[4161] = 0x00042fb8153c1607UL;
   tf->codes[4162] = 0x00042fbad3f05b43UL;
   tf->codes[4163] = 0x00042fbc334a7de1UL;
   tf->codes[4164] = 0x00042fbd58159abaUL;
   tf->codes[4165] = 0x00042fbd92a4a07fUL;
   tf->codes[4166] = 0x00042fc2606019a8UL;
   tf->codes[4167] = 0x00042fcd5b312e98UL;
   tf->codes[4168] = 0x00042fce0ade3fe7UL;
   tf->codes[4169] = 0x00042fce7ffc4b71UL;
   tf->codes[4170] = 0x00042fd31328bed5UL;
   tf->codes[4171] = 0x00042fd4e7a0ecfdUL;
   tf->codes[4172] = 0x00042fe17c5b2a50UL;
   tf->codes[4173] = 0x00042fe1f17935daUL;
   tf->codes[4174] = 0x00042fecec4a4acaUL;
   tf->codes[4175] = 0x00042fed61685654UL;
   tf->codes[4176] = 0x00042ff2ded0e0ccUL;
   tf->codes[4177] = 0x00042ff478ba092fUL;
   tf->codes[4178] = 0x00042ff4edd814b9UL;
   tf->codes[4179] = 0x00042ff7376e4e6bUL;
   tf->codes[4180] = 0x00042ff896c87109UL;
   tf->codes[4181] = 0x00042ff90be67c93UL;
   tf->codes[4182] = 0x0004300d679f7e10UL;
   tf->codes[4183] = 0x000430102653c34cUL;
   tf->codes[4184] = 0x0004301e1a68233dUL;
   tf->codes[4185] = 0x00043030a1a8f692UL;
   tf->codes[4186] = 0x000430356f646fbbUL;
   tf->codes[4187] = 0x00043035a9f37580UL;
   tf->codes[4188] = 0x00043036942f8c94UL;
   tf->codes[4189] = 0x000430439e07d571UL;
   tf->codes[4190] = 0x000430448843ec85UL;
   tf->codes[4191] = 0x0004304e5e49e49cUL;
   tf->codes[4192] = 0x0004305450d07a9eUL;
   tf->codes[4193] = 0x0004305993a9ff51UL;
   tf->codes[4194] = 0x00043062f491ebdeUL;
   tf->codes[4195] = 0x000430653e282590UL;
   tf->codes[4196] = 0x0004306b6b3dc157UL;
   tf->codes[4197] = 0x0004306be05bcce1UL;
   tf->codes[4198] = 0x0004306d3fb5ef7fUL;
   tf->codes[4199] = 0x0004306def6300ceUL;
   tf->codes[4200] = 0x0004306fc3db2ef6UL;
   tf->codes[4201] = 0x000430762b7fd082UL;
   tf->codes[4202] = 0x0004307d42d1835dUL;
   tf->codes[4203] = 0x00043086a3b96feaUL;
   tf->codes[4204] = 0x0004308f54f44b28UL;
   tf->codes[4205] = 0x00043098062f2666UL;
   tf->codes[4206] = 0x0004309baf1f82b6UL;
   tf->codes[4207] = 0x000430b8bc135f71UL;
   tf->codes[4208] = 0x000430c307376312UL;
   tf->codes[4209] = 0x000430c8f9bdf914UL;
   tf->codes[4210] = 0x000430d8c24a872dUL;
   tf->codes[4211] = 0x000430dc30abddb8UL;
   tf->codes[4212] = 0x000430e9afa2321fUL;
   tf->codes[4213] = 0x000430f609cd69adUL;
   tf->codes[4214] = 0x000430f9ed4ccbc2UL;
   tf->codes[4215] = 0x000430fb1217e89bUL;
   tf->codes[4216] = 0x000430ff6ab5563aUL;
   tf->codes[4217] = 0x00043108cb9d42c7UL;
   tf->codes[4218] = 0x0004310e0e76c77aUL;
   tf->codes[4219] = 0x00043113c66e57b7UL;
   tf->codes[4220] = 0x0004311a68a1ff08UL;
   tf->codes[4221] = 0x0004311ec13f6ca7UL;
   tf->codes[4222] = 0x0004312d9f8fe3acUL;
   tf->codes[4223] = 0x0004313232bc5710UL;
   tf->codes[4224] = 0x00043133578773e9UL;
   tf->codes[4225] = 0x00043134f1709c4cUL;
   tf->codes[4226] = 0x00043135dbacb360UL;
   tf->codes[4227] = 0x00043138d4effe61UL;
   tf->codes[4228] = 0x000431414b9bd3daUL;
   tf->codes[4229] = 0x0004314444df1edbUL;
   tf->codes[4230] = 0x0004314a71f4baa2UL;
   tf->codes[4231] = 0x0004314cf619fa19UL;
   tf->codes[4232] = 0x00043154f7a7c408UL;
   tf->codes[4233] = 0x0004315e588fb095UL;
   tf->codes[4234] = 0x0004316744599198UL;
   tf->codes[4235] = 0x00043168a3b3b436UL;
   tf->codes[4236] = 0x0004316c8733164bUL;
   tf->codes[4237] = 0x0004316ed0c94ffdUL;
   tf->codes[4238] = 0x00043179567c5963UL;
   tf->codes[4239] = 0x0004317c4fbfa464UL;
   tf->codes[4240] = 0x0004317d748ac13dUL;
   tf->codes[4241] = 0x0004317de9a8ccc7UL;
   tf->codes[4242] = 0x0004317f0e73e9a0UL;
   tf->codes[4243] = 0x000431806dce0c3eUL;
   tf->codes[4244] = 0x0004318500fa7fa2UL;
   tf->codes[4245] = 0x00043187851fbf19UL;
   tf->codes[4246] = 0x00043190ab78a5e1UL;
   tf->codes[4247] = 0x0004319504161380UL;
   tf->codes[4248] = 0x000431953ea51945UL;
   tf->codes[4249] = 0x000431a62bfcc437UL;
   tf->codes[4250] = 0x000431af17c6a53aUL;
   tf->codes[4251] = 0x000431b2fb46074fUL;
   tf->codes[4252] = 0x000431b80390863dUL;
   tf->codes[4253] = 0x000431b8b33d978cUL;
   tf->codes[4254] = 0x000431bafcd3d13eUL;
   tf->codes[4255] = 0x000431c2c3d29568UL;
   tf->codes[4256] = 0x000431d1679406a8UL;
   tf->codes[4257] = 0x000431d3769b3a95UL;
   tf->codes[4258] = 0x000431d5108462f8UL;
   tf->codes[4259] = 0x000431d794a9a26fUL;
   tf->codes[4260] = 0x000431da8deced70UL;
   tf->codes[4261] = 0x000431dac87bf335UL;
   tf->codes[4262] = 0x000431db78290484UL;
   tf->codes[4263] = 0x000431e588be0260UL;
   tf->codes[4264] = 0x000431eacb978713UL;
   tf->codes[4265] = 0x000431f7d56fcff0UL;
   tf->codes[4266] = 0x000431f9e47703ddUL;
   tf->codes[4267] = 0x00043200fbc8b6b8UL;
   tf->codes[4268] = 0x00043203ba7cfbf4UL;
   tf->codes[4269] = 0x0004320519d71e92UL;
   tf->codes[4270] = 0x0004321a253d315eUL;
   tf->codes[4271] = 0x000432301adf5b3eUL;
   tf->codes[4272] = 0x00043233c3cfb78eUL;
   tf->codes[4273] = 0x0004323aa09264a4UL;
   tf->codes[4274] = 0x0004323caf999891UL;
   tf->codes[4275] = 0x0004323e0ef3bb2fUL;
   tf->codes[4276] = 0x0004323e8411c6b9UL;
   tf->codes[4277] = 0x0004323f6e4dddcdUL;
   tf->codes[4278] = 0x00043243173e3a1dUL;
   tf->codes[4279] = 0x000432438c5c45a7UL;
   tf->codes[4280] = 0x00043246c02e966dUL;
   tf->codes[4281] = 0x000432497ee2dba9UL;
   tf->codes[4282] = 0x00043249b971e16eUL;
   tf->codes[4283] = 0x0004324b8dea0f96UL;
   tf->codes[4284] = 0x0004324d62623dbeUL;
   tf->codes[4285] = 0x0004324f36da6be6UL;
   tf->codes[4286] = 0x00043259bc8d754cUL;
   tf->codes[4287] = 0x0004325d2aeecbd7UL;
   tf->codes[4288] = 0x00043267b0a1d53dUL;
   tf->codes[4289] = 0x0004326b94213752UL;
   tf->codes[4290] = 0x0004326da3286b3fUL;
   tf->codes[4291] = 0x00043273d03e0706UL;
   tf->codes[4292] = 0x00043276c9815207UL;
   tf->codes[4293] = 0x00043281fee16cbcUL;
   tf->codes[4294] = 0x0004328b9a585f0eUL;
   tf->codes[4295] = 0x0004328cf9b281acUL;
   tf->codes[4296] = 0x0004329a78a8d613UL;
   tf->codes[4297] = 0x000432a1ca898eb3UL;
   tf->codes[4298] = 0x000432aba08f86caUL;
   tf->codes[4299] = 0x000432b193161cccUL;
   tf->codes[4300] = 0x000432b626429030UL;
   tf->codes[4301] = 0x000432b9cf32ec80UL;
   tf->codes[4302] = 0x000432bc8de731bcUL;
   tf->codes[4303] = 0x000432bd3d94430bUL;
   tf->codes[4304] = 0x000432bf4c9b76f8UL;
   tf->codes[4305] = 0x000432c0716693d1UL;
   tf->codes[4306] = 0x000432c41a56f021UL;
   tf->codes[4307] = 0x000432c663ed29d3UL;
   tf->codes[4308] = 0x000432cbe155b44bUL;
   tf->codes[4309] = 0x000432cd0620d124UL;
   tf->codes[4310] = 0x000432d15ebe3ec3UL;
   tf->codes[4311] = 0x000432d99adb0e77UL;
   tf->codes[4312] = 0x000432e3e5ff1218UL;
   tf->codes[4313] = 0x000432e57fe83a7bUL;
   tf->codes[4314] = 0x000432e78eef6e68UL;
   tf->codes[4315] = 0x000432ec5caae791UL;
   tf->codes[4316] = 0x000432ec9739ed56UL;
   tf->codes[4317] = 0x000432eee0d02708UL;
   tf->codes[4318] = 0x000432f07ab94f6bUL;
   tf->codes[4319] = 0x000432f24f317d93UL;
   tf->codes[4320] = 0x000432f9dba13bf8UL;
   tf->codes[4321] = 0x000432fd4a029283UL;
   tf->codes[4322] = 0x0004330377182e4aUL;
   tf->codes[4323] = 0x00043305c0ae67fcUL;
   tf->codes[4324] = 0x00043306aaea7f10UL;
   tf->codes[4325] = 0x0004330c28530988UL;
   tf->codes[4326] = 0x0004330c62e20f4dUL;
   tf->codes[4327] = 0x0004330e71e9433aUL;
   tf->codes[4328] = 0x000433128ff7ab14UL;
   tf->codes[4329] = 0x0004331acc147ac8UL;
   tf->codes[4330] = 0x0004331b41328652UL;
   tf->codes[4331] = 0x0004331bf0df97a1UL;
   tf->codes[4332] = 0x0004331f24b1e867UL;
   tf->codes[4333] = 0x0004332308314a7cUL;
   tf->codes[4334] = 0x0004332d53554e1dUL;
   tf->codes[4335] = 0x0004333554e3180cUL;
   tf->codes[4336] = 0x0004333763ea4bf9UL;
   tf->codes[4337] = 0x0004333b81f8b3d3UL;
   tf->codes[4338] = 0x0004333ce152d671UL;
   tf->codes[4339] = 0x0004333d1be1dc36UL;
   tf->codes[4340] = 0x0004334433338f11UL;
   tf->codes[4341] = 0x00043351779addb3UL;
   tf->codes[4342] = 0x0004335f6baf3da4UL;
   tf->codes[4343] = 0x000433622a6382e0UL;
   tf->codes[4344] = 0x000433634f2e9fb9UL;
   tf->codes[4345] = 0x0004336389bda57eUL;
   tf->codes[4346] = 0x0004337317bb2dd2UL;
   tf->codes[4347] = 0x0004337dd7fd3cfdUL;
   tf->codes[4348] = 0x0004337e87aa4e4cUL;
   tf->codes[4349] = 0x00043380219376afUL;
   tf->codes[4350] = 0x0004338b1c648b9fUL;
   tf->codes[4351] = 0x0004338b56f39164UL;
   tf->codes[4352] = 0x0004339024af0a8dUL;
   tf->codes[4353] = 0x000433910eeb21a1UL;
   tf->codes[4354] = 0x000433931df2558eUL;
   tf->codes[4355] = 0x000433991078eb90UL;
   tf->codes[4356] = 0x0004339b949e2b07UL;
   tf->codes[4357] = 0x000433abd248c4aaUL;
   tf->codes[4358] = 0x000433ae90fd09e6UL;
   tf->codes[4359] = 0x000433aff0572c84UL;
   tf->codes[4360] = 0x000433b74237e524UL;
   tf->codes[4361] = 0x000433c919cba72aUL;
   tf->codes[4362] = 0x000433cb6361e0dcUL;
   tf->codes[4363] = 0x000433cc882cfdb5UL;
   tf->codes[4364] = 0x000433cff68e5440UL;
   tf->codes[4365] = 0x000433d44f2bc1dfUL;
   tf->codes[4366] = 0x000433df0f6dd10aUL;
   tf->codes[4367] = 0x000433eb69990898UL;
   tf->codes[4368] = 0x000433ed3e1136c0UL;
   tf->codes[4369] = 0x0004340124ac2cb3UL;
   tf->codes[4370] = 0x000434036e426665UL;
   tf->codes[4371] = 0x00043405082b8ec8UL;
   tf->codes[4372] = 0x000434078c50ce3fUL;
   tf->codes[4373] = 0x0004340ea3a2811aUL;
   tf->codes[4374] = 0x000434124c92dd6aUL;
   tf->codes[4375] = 0x0004342a513c3b37UL;
   tf->codes[4376] = 0x00043435fbba6176UL;
   tf->codes[4377] = 0x00043439df39c38bUL;
   tf->codes[4378] = 0x0004343ac975da9fUL;
   tf->codes[4379] = 0x0004343dfd482b65UL;
   tf->codes[4380] = 0x0004343f5ca24e03UL;
   tf->codes[4381] = 0x00043441a63887b5UL;
   tf->codes[4382] = 0x00043445fed5f554UL;
   tf->codes[4383] = 0x0004344d8b45b3b9UL;
   tf->codes[4384] = 0x0004344e0063bf43UL;
   tf->codes[4385] = 0x00043453b85b4f80UL;
   tf->codes[4386] = 0x000434563c808ef7UL;
   tf->codes[4387] = 0x0004345c2f0724f9UL;
   tf->codes[4388] = 0x0004345cdeb43648UL;
   tf->codes[4389] = 0x0004345e3e0e58e6UL;
   tf->codes[4390] = 0x00043465ca7e174bUL;
   tf->codes[4391] = 0x000434684ea356c2UL;
   tf->codes[4392] = 0x0004346bf793b312UL;
   tf->codes[4393] = 0x0004346e069ae6ffUL;
   tf->codes[4394] = 0x0004346e7bb8f289UL;
   tf->codes[4395] = 0x0004347174fc3d8aUL;
   tf->codes[4396] = 0x000434788c4df065UL;
   tf->codes[4397] = 0x0004347a9b552452UL;
   tf->codes[4398] = 0x00043482d771f406UL;
   tf->codes[4399] = 0x0004348596263942UL;
   tf->codes[4400] = 0x0004348854da7e7eUL;
   tf->codes[4401] = 0x0004348bfdcadaceUL;
   tf->codes[4402] = 0x0004348c72e8e658UL;
   tf->codes[4403] = 0x00043496f89befbeUL;
   tf->codes[4404] = 0x0004349d9acf970fUL;
   tf->codes[4405] = 0x000434a3c7e532d6UL;
   tf->codes[4406] = 0x000434a8d02fb1c4UL;
   tf->codes[4407] = 0x000434af72635915UL;
   tf->codes[4408] = 0x000434b6c44411b5UL;
   tf->codes[4409] = 0x000434bddb95c490UL;
   tf->codes[4410] = 0x000434c05fbb0407UL;
   tf->codes[4411] = 0x000434c7770cb6e2UL;
   tf->codes[4412] = 0x000434c910f5df45UL;
   tf->codes[4413] = 0x000434c94b84e50aUL;
   tf->codes[4414] = 0x000434ce53cf63f8UL;
   tf->codes[4415] = 0x000434d028479220UL;
   tf->codes[4416] = 0x000434e324a670ffUL;
   tf->codes[4417] = 0x000434ebd5e14c3dUL;
   tf->codes[4418] = 0x000434f2ed32ff18UL;
   tf->codes[4419] = 0x00043506d3cdf50bUL;
   tf->codes[4420] = 0x00043508e2d528f8UL;
   tf->codes[4421] = 0x0004350ba1896e34UL;
   tf->codes[4422] = 0x000435136888325eUL;
   tf->codes[4423] = 0x000435241b50d78bUL;
   tf->codes[4424] = 0x0004352b32a28a66UL;
   tf->codes[4425] = 0x000435399bd4f5e1UL;
   tf->codes[4426] = 0x000435400379976dUL;
   tf->codes[4427] = 0x00043542879ed6e4UL;
   tf->codes[4428] = 0x0004354371daedf8UL;
   tf->codes[4429] = 0x00043547555a500dUL;
   tf->codes[4430] = 0x0004354ac3bba698UL;
   tf->codes[4431] = 0x0004355842b1faffUL;
   tf->codes[4432] = 0x0004355f5a03addaUL;
   tf->codes[4433] = 0x00043566abe4667aUL;
   tf->codes[4434] = 0x00043567d0af8353UL;
   tf->codes[4435] = 0x000435716c2675a5UL;
   tf->codes[4436] = 0x00043571a6b57b6aUL;
   tf->codes[4437] = 0x0004357290f1927eUL;
   tf->codes[4438] = 0x00043573409ea3cdUL;
   tf->codes[4439] = 0x00043573f04bb51cUL;
   tf->codes[4440] = 0x00043575c4c3e344UL;
   tf->codes[4441] = 0x00043577241e05e2UL;
   tf->codes[4442] = 0x00043579332539cfUL;
   tf->codes[4443] = 0x00043579e2d24b1eUL;
   tf->codes[4444] = 0x00043581a9d10f48UL;
   tf->codes[4445] = 0x000435837e493d70UL;
   tf->codes[4446] = 0x000435858d50715dUL;
   tf->codes[4447] = 0x00043586ecaa93fbUL;
   tf->codes[4448] = 0x00043590fd3f91d7UL;
   tf->codes[4449] = 0x000435943111e29dUL;
   tf->codes[4450] = 0x0004359d91f9cf2aUL;
   tf->codes[4451] = 0x000435a4342d767bUL;
   tf->codes[4452] = 0x000435a64334aa68UL;
   tf->codes[4453] = 0x000435ac704a462fUL;
   tf->codes[4454] = 0x000435b262d0dc31UL;
   tf->codes[4455] = 0x000435be0d4f0270UL;
   tf->codes[4456] = 0x000435c1f0ce6485UL;
   tf->codes[4457] = 0x000435c2a07b75d4UL;
   tf->codes[4458] = 0x000435c9b7cd28afUL;
   tf->codes[4459] = 0x000435cc76816debUL;
   tf->codes[4460] = 0x000435d6c1a5718cUL;
   tf->codes[4461] = 0x000435d736c37d16UL;
   tf->codes[4462] = 0x000435dd63d918ddUL;
   tf->codes[4463] = 0x000435eb927c7e93UL;
   tf->codes[4464] = 0x000435f2a9ce316eUL;
   tf->codes[4465] = 0x000435f2e45d3733UL;
   tf->codes[4466] = 0x000435f3940a4882UL;
   tf->codes[4467] = 0x000435f3ce994e47UL;
   tf->codes[4468] = 0x000435fb95981271UL;
   tf->codes[4469] = 0x000435fc0ab61dfbUL;
   tf->codes[4470] = 0x000435fcf4f2350fUL;
   tf->codes[4471] = 0x000435fda49f465eUL;
   tf->codes[4472] = 0x000436014d8fa2aeUL;
   tf->codes[4473] = 0x0004360864e15589UL;
   tf->codes[4474] = 0x0004360fb6c20e29UL;
   tf->codes[4475] = 0x00043614f99b92dcUL;
   tf->codes[4476] = 0x0004361867fce967UL;
   tf->codes[4477] = 0x0004361bd65e3ff2UL;
   tf->codes[4478] = 0x0004361de56573dfUL;
   tf->codes[4479] = 0x00043624c22820f5UL;
   tf->codes[4480] = 0x0004362571d53244UL;
   tf->codes[4481] = 0x00043626d12f54e2UL;
   tf->codes[4482] = 0x0004362a3f90ab6dUL;
   tf->codes[4483] = 0x0004362cfe44f0a9UL;
   tf->codes[4484] = 0x000436391de12272UL;
   tf->codes[4485] = 0x00043639cd8e33c1UL;
   tf->codes[4486] = 0x0004363af259509aUL;
   tf->codes[4487] = 0x00043651228a803fUL;
   tf->codes[4488] = 0x000436574fa01c06UL;
   tf->codes[4489] = 0x0004365c1d5b952fUL;
   tf->codes[4490] = 0x00043663e45a5959UL;
   tf->codes[4491] = 0x0004366509257632UL;
   tf->codes[4492] = 0x0004366f8ed87f98UL;
   tf->codes[4493] = 0x0004367003f68b22UL;
   tf->codes[4494] = 0x000436716350adc0UL;
   tf->codes[4495] = 0x00043674d1b2044bUL;
   tf->codes[4496] = 0x0004367a89a99488UL;
   tf->codes[4497] = 0x0004368e35b584b6UL;
   tf->codes[4498] = 0x0004369a1ac2b0baUL;
   tf->codes[4499] = 0x0004369b7a1cd358UL;
   tf->codes[4500] = 0x000436a55022cb6fUL;
   tf->codes[4501] = 0x000436a7d4480ae6UL;
   tf->codes[4502] = 0x000436a9e34f3ed3UL;
   tf->codes[4503] = 0x000436ae767bb237UL;
   tf->codes[4504] = 0x000436b4de2053c3UL;
   tf->codes[4505] = 0x000436b9e66ad2b1UL;
   tf->codes[4506] = 0x000436c1ad6996dbUL;
   tf->codes[4507] = 0x000436c34752bf3eUL;
   tf->codes[4508] = 0x000436c4318ed652UL;
   tf->codes[4509] = 0x000436c8150e3867UL;
   tf->codes[4510] = 0x000436c9aef760caUL;
   tf->codes[4511] = 0x000436d9eca1fa6dUL;
   tf->codes[4512] = 0x000436dc70c739e4UL;
   tf->codes[4513] = 0x000436ddd0215c82UL;
   tf->codes[4514] = 0x000436ec73e2cdc2UL;
   tf->codes[4515] = 0x000436f4afff9d76UL;
   tf->codes[4516] = 0x0004370144b9dac9UL;
   tf->codes[4517] = 0x0004370353c10eb6UL;
   tf->codes[4518] = 0x00043710d2b7631dUL;
   tf->codes[4519] = 0x0004371356dca294UL;
   tf->codes[4520] = 0x00043714f0c5caf7UL;
   tf->codes[4521] = 0x0004371949633896UL;
   tf->codes[4522] = 0x0004371a339f4faaUL;
   tf->codes[4523] = 0x0004371b92f97248UL;
   tf->codes[4524] = 0x0004371c7d35895cUL;
   tf->codes[4525] = 0x0004371feb96dfe7UL;
   tf->codes[4526] = 0x000437268dca8738UL;
   tf->codes[4527] = 0x0004372b20f6fa9cUL;
   tf->codes[4528] = 0x000437356c1afe3dUL;
   tf->codes[4529] = 0x0004373c48ddab53UL;
   tf->codes[4530] = 0x000437411699247cUL;
   tf->codes[4531] = 0x000437439abe63f3UL;
   tf->codes[4532] = 0x000437465972a92fUL;
   tf->codes[4533] = 0x00043747b8cccbcdUL;
   tf->codes[4534] = 0x00043750df25b295UL;
   tf->codes[4535] = 0x0004375412f8035bUL;
   tf->codes[4536] = 0x00043755e7703183UL;
   tf->codes[4537] = 0x0004375621ff3748UL;
   tf->codes[4538] = 0x000437591b428249UL;
   tf->codes[4539] = 0x000437678474edc4UL;
   tf->codes[4540] = 0x0004376a089a2d3bUL;
   tf->codes[4541] = 0x0004376af2d6444fUL;
   tf->codes[4542] = 0x0004376cc74e7277UL;
   tf->codes[4543] = 0x0004376e26a89515UL;
   tf->codes[4544] = 0x0004376f8602b7b3UL;
   tf->codes[4545] = 0x00043774c8dc3c66UL;
   tf->codes[4546] = 0x00043775eda7593fUL;
   tf->codes[4547] = 0x000437769d546a8eUL;
   tf->codes[4548] = 0x0004377a4644c6deUL;
   tf->codes[4549] = 0x0004377b3080ddf2UL;
   tf->codes[4550] = 0x0004377be02def41UL;
   tf->codes[4551] = 0x0004377e9ee2347dUL;
   tf->codes[4552] = 0x00043785b633e758UL;
   tf->codes[4553] = 0x00043787501d0fbbUL;
   tf->codes[4554] = 0x00043791d5d01921UL;
   tf->codes[4555] = 0x000437936fb94184UL;
   tf->codes[4556] = 0x0004379718a99dd4UL;
   tf->codes[4557] = 0x00043797c856af23UL;
   tf->codes[4558] = 0x0004379a4c7bee9aUL;
   tf->codes[4559] = 0x0004379babd61138UL;
   tf->codes[4560] = 0x0004379d45bf399bUL;
   tf->codes[4561] = 0x0004379edfa861feUL;
   tf->codes[4562] = 0x000437a756543777UL;
   tf->codes[4563] = 0x000437aac4b58e02UL;
   tf->codes[4564] = 0x000437abaef1a516UL;
   tf->codes[4565] = 0x000437b12c5a2f8eUL;
   tf->codes[4566] = 0x000437b634a4ae7cUL;
   tf->codes[4567] = 0x000437bc61ba4a43UL;
   tf->codes[4568] = 0x000437bdfba372a6UL;
   tf->codes[4569] = 0x000437c4d8661fbcUL;
   tf->codes[4570] = 0x000437c6e76d53a9UL;
   tf->codes[4571] = 0x000437c8f6748796UL;
   tf->codes[4572] = 0x000437ca1b3fa46fUL;
   tf->codes[4573] = 0x000437cd89a0fafaUL;
   tf->codes[4574] = 0x000437dc2d626c3aUL;
   tf->codes[4575] = 0x000437df6134bd00UL;
   tf->codes[4576] = 0x000437e21fe9023cUL;
   tf->codes[4577] = 0x000437e4697f3beeUL;
   tf->codes[4578] = 0x000437e9e6e7c666UL;
   tf->codes[4579] = 0x000437ebf5eefa53UL;
   tf->codes[4580] = 0x000437f9af74547fUL;
   tf->codes[4581] = 0x000437fca8b79f80UL;
   tf->codes[4582] = 0x000437fd5864b0cfUL;
   tf->codes[4583] = 0x000437feb7bed36dUL;
   tf->codes[4584] = 0x000438093d71dcd3UL;
   tf->codes[4585] = 0x00043812d8e8cf25UL;
   tf->codes[4586] = 0x00043813c324e639UL;
   tf->codes[4587] = 0x000438181bc253d8UL;
   tf->codes[4588] = 0x00043830d018c2f4UL;
   tf->codes[4589] = 0x000438359dd43c1dUL;
   tf->codes[4590] = 0x000438405e164b48UL;
   tf->codes[4591] = 0x00043840d33456d2UL;
   tf->codes[4592] = 0x00043844b6b3b8e7UL;
   tf->codes[4593] = 0x00043853cf9335b1UL;
   tf->codes[4594] = 0x0004385da5992dc8UL;
   tf->codes[4595] = 0x00043862e872b27bUL;
   tf->codes[4596] = 0x0004386706811a55UL;
   tf->codes[4597] = 0x0004386915884e42UL;
   tf->codes[4598] = 0x0004386ff24afb58UL;
   tf->codes[4599] = 0x0004387485776ebcUL;
   tf->codes[4600] = 0x00043874fa957a46UL;
   tf->codes[4601] = 0x0004387918a3e220UL;
   tf->codes[4602] = 0x0004387b623a1bd2UL;
   tf->codes[4603] = 0x0004387b9cc92197UL;
   tf->codes[4604] = 0x0004387c4c7632e6UL;
   tf->codes[4605] = 0x00043885384013e9UL;
   tf->codes[4606] = 0x000438870cb84211UL;
   tf->codes[4607] = 0x0004388b9fe4b575UL;
   tf->codes[4608] = 0x0004388e2409f4ecUL;
   tf->codes[4609] = 0x0004388fbdf31d4fUL;
   tf->codes[4610] = 0x00043891ccfa513cUL;
   tf->codes[4611] = 0x0004389993f91566UL;
   tf->codes[4612] = 0x0004389a7e352c7aUL;
   tf->codes[4613] = 0x0004389af3533804UL;
   tf->codes[4614] = 0x0004389f867fab68UL;
   tf->codes[4615] = 0x000438a20aa4eadfUL;
   tf->codes[4616] = 0x000438ab30fdd1a7UL;
   tf->codes[4617] = 0x000438b4cc74c3f9UL;
   tf->codes[4618] = 0x000438b57c21d548UL;
   tf->codes[4619] = 0x000438ba846c5436UL;
   tf->codes[4620] = 0x000438c001d4deaeUL;
   tf->codes[4621] = 0x000438c076f2ea38UL;
   tf->codes[4622] = 0x000438c19bbe0711UL;
   tf->codes[4623] = 0x000438c370363539UL;
   tf->codes[4624] = 0x000438c50a1f5d9cUL;
   tf->codes[4625] = 0x000438ca1269dc8aUL;
   tf->codes[4626] = 0x000438cdbb5a38daUL;
   tf->codes[4627] = 0x000438d338c2c352UL;
   tf->codes[4628] = 0x000438dcd439b5a4UL;
   tf->codes[4629] = 0x000438dee340e991UL;
   tf->codes[4630] = 0x000438e0f2481d7eUL;
   tf->codes[4631] = 0x000438e4261a6e44UL;
   tf->codes[4632] = 0x000438e759ecbf0aUL;
   tf->codes[4633] = 0x000438e7947bc4cfUL;
   tf->codes[4634] = 0x000438ef20eb8334UL;
   tf->codes[4635] = 0x000438f7979758adUL;
   tf->codes[4636] = 0x000438fb4087b4fdUL;
   tf->codes[4637] = 0x000438fc2ac3cc11UL;
   tf->codes[4638] = 0x000438fcda70dd60UL;
   tf->codes[4639] = 0x000438fe39cafffeUL;
   tf->codes[4640] = 0x0004390fd6cfbc3fUL;
   tf->codes[4641] = 0x000439104bedc7c9UL;
   tf->codes[4642] = 0x0004391170b8e4a2UL;
   tf->codes[4643] = 0x0004391ce0a8051cUL;
   tf->codes[4644] = 0x0004391d9055166bUL;
   tf->codes[4645] = 0x0004391dcae41c30UL;
   tf->codes[4646] = 0x00043932d64a2efcUL;
   tf->codes[4647] = 0x000439388e41bf39UL;
   tf->codes[4648] = 0x0004393e46394f76UL;
   tf->codes[4649] = 0x0004394a65d5813fUL;
   tf->codes[4650] = 0x0004394caf6bbaf1UL;
   tf->codes[4651] = 0x000439522cd44569UL;
   tf->codes[4652] = 0x00043958cf07ecbaUL;
   tf->codes[4653] = 0x0004395ced165494UL;
   tf->codes[4654] = 0x00043967ad5863bfUL;
   tf->codes[4655] = 0x0004396dda6dff86UL;
   tf->codes[4656] = 0x0004396ec4aa169aUL;
   tf->codes[4657] = 0x00043971f87c6760UL;
   tf->codes[4658] = 0x0004398619a66318UL;
   tf->codes[4659] = 0x0004398a7243d0b7UL;
   tf->codes[4660] = 0x0004398b21f0e206UL;
   tf->codes[4661] = 0x0004398fefac5b2fUL;
   tf->codes[4662] = 0x00043990d9e87243UL;
   tf->codes[4663] = 0x0004399e936dcc6fUL;
   tf->codes[4664] = 0x000439a7b9c6b337UL;
   tf->codes[4665] = 0x000439ae216b54c3UL;
   tf->codes[4666] = 0x000439b3d962e500UL;
   tf->codes[4667] = 0x000439b622f91eb2UL;
   tf->codes[4668] = 0x000439b782534150UL;
   tf->codes[4669] = 0x000439ba067880c7UL;
   tf->codes[4670] = 0x000439bdaf68dd17UL;
   tf->codes[4671] = 0x000439c158593967UL;
   tf->codes[4672] = 0x000439c4c6ba8ff2UL;
   tf->codes[4673] = 0x000439c959e70356UL;
   tf->codes[4674] = 0x000439d0abc7bbf6UL;
   tf->codes[4675] = 0x000439d41a291281UL;
   tf->codes[4676] = 0x000439d5eea140a9UL;
   tf->codes[4677] = 0x000439d838377a5bUL;
   tf->codes[4678] = 0x000439db317ac55cUL;
   tf->codes[4679] = 0x000439dd4081f949UL;
   tf->codes[4680] = 0x000439dd7b10ff0eUL;
   tf->codes[4681] = 0x000439e5420fc338UL;
   tf->codes[4682] = 0x000439ed439d8d27UL;
   tf->codes[4683] = 0x000439f0776fddedUL;
   tf->codes[4684] = 0x000439ff904f5ab7UL;
   tf->codes[4685] = 0x000439ffcade607cUL;
   tf->codes[4686] = 0x00043a02feb0b142UL;
   tf->codes[4687] = 0x00043a0806fb3030UL;
   tf->codes[4688] = 0x00043a08418a35f5UL;
   tf->codes[4689] = 0x00043a092bc64d09UL;
   tf->codes[4690] = 0x00043a09665552ceUL;
   tf->codes[4691] = 0x00043a0d49d4b4e3UL;
   tf->codes[4692] = 0x00043a107da705a9UL;
   tf->codes[4693] = 0x00043a1376ea50aaUL;
   tf->codes[4694] = 0x00043a16359e95e6UL;
   tf->codes[4695] = 0x00043a17cf87be49UL;
   tf->codes[4696] = 0x00043a1a53acfdc0UL;
   tf->codes[4697] = 0x00043a1bed962623UL;
   tf->codes[4698] = 0x00043a1c62b431adUL;
   tf->codes[4699] = 0x00043a1eac4a6b5fUL;
   tf->codes[4700] = 0x00043a25fe2b23ffUL;
   tf->codes[4701] = 0x00043a2673492f89UL;
   tf->codes[4702] = 0x00043a2722f640d8UL;
   tf->codes[4703] = 0x00043a300ec021dbUL;
   tf->codes[4704] = 0x00043a3b7eaf4255UL;
   tf->codes[4705] = 0x00043a484df8856dUL;
   tf->codes[4706] = 0x00043a4f2abb3283UL;
   tf->codes[4707] = 0x00043a530e3a9498UL;
   tf->codes[4708] = 0x00043a56420ce55eUL;
   tf->codes[4709] = 0x00043a59eafd41aeUL;
   tf->codes[4710] = 0x00043a68542fad29UL;
   tf->codes[4711] = 0x00043a6a28a7db51UL;
   tf->codes[4712] = 0x00043a6d970931dcUL;
   tf->codes[4713] = 0x00043a7055bd7718UL;
   tf->codes[4714] = 0x00043a76f7f11e69UL;
   tf->codes[4715] = 0x00043a7906f85256UL;
   tf->codes[4716] = 0x00043a794187581bUL;
   tf->codes[4717] = 0x00043a8401c96746UL;
   tf->codes[4718] = 0x00043a8610d09b33UL;
   tf->codes[4719] = 0x00043a86c07dac82UL;
   tf->codes[4720] = 0x00043a890a13e634UL;
   tf->codes[4721] = 0x00043a8e877c70acUL;
   tf->codes[4722] = 0x00043aa392e28378UL;
   tf->codes[4723] = 0x00043aa98569197aUL;
   tf->codes[4724] = 0x00043aaf77efaf7cUL;
   tf->codes[4725] = 0x00043ab1fc14eef3UL;
   tf->codes[4726] = 0x00043ab7b40c7f30UL;
   tf->codes[4727] = 0x00043ab7ee9b84f5UL;
   tf->codes[4728] = 0x00043ab863b9907fUL;
   tf->codes[4729] = 0x00043ab8d8d79c09UL;
   tf->codes[4730] = 0x00043ab9c313b31dUL;
   tf->codes[4731] = 0x00043ac35e8aa56fUL;
   tf->codes[4732] = 0x00043aca00be4cc0UL;
   tf->codes[4733] = 0x00043aca3b4d5285UL;
   tf->codes[4734] = 0x00043acaeafa63d4UL;
   tf->codes[4735] = 0x00043ad3d6c444d7UL;
   tf->codes[4736] = 0x00043ad7ba43a6ecUL;
   tf->codes[4737] = 0x00043ad8a47fbe00UL;
   tf->codes[4738] = 0x00043ad9199dc98aUL;
   tf->codes[4739] = 0x00043adb6334033cUL;
   tf->codes[4740] = 0x00043adf0c245f8cUL;
   tf->codes[4741] = 0x00043ae27a85b617UL;
   tf->codes[4742] = 0x00043ae364c1cd2bUL;
   tf->codes[4743] = 0x00043aeaf1318b90UL;
   tf->codes[4744] = 0x00043af243124430UL;
   tf->codes[4745] = 0x00043afa44a00e1fUL;
   tf->codes[4746] = 0x00043afd3de35920UL;
   tf->codes[4747] = 0x00043b06643c3fe8UL;
   tf->codes[4748] = 0x00043b069ecb45adUL;
   tf->codes[4749] = 0x00043b06d95a4b72UL;
   tf->codes[4750] = 0x00043b0b31f7b911UL;
   tf->codes[4751] = 0x00043b0c56c2d5eaUL;
   tf->codes[4752] = 0x00043b11247e4f13UL;
   tf->codes[4753] = 0x00043b1249496becUL;
   tf->codes[4754] = 0x00043b1492dfa59eUL;
   tf->codes[4755] = 0x00043b1d098b7b17UL;
   tf->codes[4756] = 0x00043b2afd9fdb08UL;
   tf->codes[4757] = 0x00043b2e31722bceUL;
   tf->codes[4758] = 0x00043b3df9feb9e7UL;
   tf->codes[4759] = 0x00043b3f5958dc85UL;
   tf->codes[4760] = 0x00043b45fb8c83d6UL;
   tf->codes[4761] = 0x00043b4b03d702c4UL;
   tf->codes[4762] = 0x00043b4c9dc02b27UL;
   tf->codes[4763] = 0x00043b4e7238594fUL;
   tf->codes[4764] = 0x00043b642d4b7d6aUL;
   tf->codes[4765] = 0x00043b6601c3ab92UL;
   tf->codes[4766] = 0x00043b6a5a611931UL;
   tf->codes[4767] = 0x00043b72967de8e5UL;
   tf->codes[4768] = 0x00043b7b0d29be5eUL;
   tf->codes[4769] = 0x00043b7bbcd6cfadUL;
   tf->codes[4770] = 0x00043b843382a526UL;
   tf->codes[4771] = 0x00043b8607fad34eUL;
   tf->codes[4772] = 0x00043b8d946a91b3UL;
   tf->codes[4773] = 0x00043b8e7ea6a8c7UL;
   tf->codes[4774] = 0x00043b95d0876167UL;
   tf->codes[4775] = 0x00043b972fe18405UL;
   tf->codes[4776] = 0x00043b9d97862591UL;
   tf->codes[4777] = 0x00043bb22dce2cd3UL;
   tf->codes[4778] = 0x00043bb43cd560c0UL;
   tf->codes[4779] = 0x00043bb73618abc1UL;
   tf->codes[4780] = 0x00043bbcee103bfeUL;
   tf->codes[4781] = 0x00043bbf72357b75UL;
   tf->codes[4782] = 0x00043bc1f65abaecUL;
   tf->codes[4783] = 0x00043bc85dff5c78UL;
   tf->codes[4784] = 0x00043bcaa795962aUL;
   tf->codes[4785] = 0x00043bcf75510f53UL;
   tf->codes[4786] = 0x00043bd65213bc69UL;
   tf->codes[4787] = 0x00043bd985e60d2fUL;
   tf->codes[4788] = 0x00043bdbcf7c46e1UL;
   tf->codes[4789] = 0x00043bdc0a0b4ca6UL;
   tf->codes[4790] = 0x00043bdf786ca331UL;
   tf->codes[4791] = 0x00043be9fe1fac97UL;
   tf->codes[4792] = 0x00043bed6c810322UL;
   tf->codes[4793] = 0x00043bf40eb4aa73UL;
   tf->codes[4794] = 0x00043bf4be61bbc2UL;
   tf->codes[4795] = 0x00043bf8a1e11dd7UL;
   tf->codes[4796] = 0x00043c00a36ee7c6UL;
   tf->codes[4797] = 0x00043c0c4ded0e05UL;
   tf->codes[4798] = 0x00043c0cc30b198fUL;
   tf->codes[4799] = 0x00043c111ba8872eUL;
   tf->codes[4800] = 0x00043c1cc626ad6dUL;
   tf->codes[4801] = 0x00043c2aba3b0d5eUL;
   tf->codes[4802] = 0x00043c2d78ef529aUL;
   tf->codes[4803] = 0x00043c2fc2858c4cUL;
   tf->codes[4804] = 0x00043c3246aacbc3UL;
   tf->codes[4805] = 0x00043c32f657dd12UL;
   tf->codes[4806] = 0x00043c341b22f9ebUL;
   tf->codes[4807] = 0x00043c3abd56a13cUL;
   tf->codes[4808] = 0x00043c3b3274acc6UL;
   tf->codes[4809] = 0x00043c3ea0d60351UL;
   tf->codes[4810] = 0x00043c41d4a85417UL;
   tf->codes[4811] = 0x00043c48b16b012dUL;
   tf->codes[4812] = 0x00043c5162a5dc6bUL;
   tf->codes[4813] = 0x00043c52fc8f04ceUL;
   tf->codes[4814] = 0x00043c566af05b59UL;
   tf->codes[4815] = 0x00043c5a13e0b7a9UL;
   tf->codes[4816] = 0x00043c642475b585UL;
   tf->codes[4817] = 0x00043c66337ce972UL;
   tf->codes[4818] = 0x00043c6a8c1a5711UL;
   tf->codes[4819] = 0x00043c6b0138629bUL;
   tf->codes[4820] = 0x00043c707ea0ed13UL;
   tf->codes[4821] = 0x00043c7427914963UL;
   tf->codes[4822] = 0x00043c79df88d9a0UL;
   tf->codes[4823] = 0x00043c7a1a17df65UL;
   tf->codes[4824] = 0x00043c7e3826473fUL;
   tf->codes[4825] = 0x00043c81e116a38fUL;
   tf->codes[4826] = 0x00043c82cb52baa3UL;
   tf->codes[4827] = 0x00043c8acce08492UL;
   tf->codes[4828] = 0x00043c8b41fe901cUL;
   tf->codes[4829] = 0x00043c8b7c8d95e1UL;
   tf->codes[4830] = 0x00043c95c7b19982UL;
   tf->codes[4831] = 0x00043c97d6b8cd6fUL;
   tf->codes[4832] = 0x00043ca51b201c11UL;
   tf->codes[4833] = 0x00043cb1754b539fUL;
   tf->codes[4834] = 0x00043cb558cab5b4UL;
   tf->codes[4835] = 0x00043cd22b2f8caaUL;
   tf->codes[4836] = 0x00043cd2dadc9df9UL;
   tf->codes[4837] = 0x00043cdd9b1ead24UL;
   tf->codes[4838] = 0x00043cdfe4b4e6d6UL;
   tf->codes[4839] = 0x00043ce5278e6b89UL;
   tf->codes[4840] = 0x00043ceefd9463a0UL;
   tf->codes[4841] = 0x00043cf6c49327caUL;
   tf->codes[4842] = 0x00043cf739b13354UL;
   tf->codes[4843] = 0x00043cf7aecf3edeUL;
   tf->codes[4844] = 0x00043d02e42f5993UL;
   tf->codes[4845] = 0x00043d068d1fb5e3UL;
   tf->codes[4846] = 0x00043d089c26e9d0UL;
   tf->codes[4847] = 0x00043d0d2f535d34UL;
   tf->codes[4848] = 0x00043d15a5ff32adUL;
   tf->codes[4849] = 0x00043d161b1d3e37UL;
   tf->codes[4850] = 0x00043d1ae8d8b760UL;
   tf->codes[4851] = 0x00043d274303eeeeUL;
   tf->codes[4852] = 0x00043d27f2b1003dUL;
   tf->codes[4853] = 0x00043d2a76d63fb4UL;
   tf->codes[4854] = 0x00043d2b26835103UL;
   tf->codes[4855] = 0x00043d2b9ba15c8dUL;
   tf->codes[4856] = 0x00043d2daaa8907aUL;
   tf->codes[4857] = 0x00043d34876b3d90UL;
   tf->codes[4858] = 0x00043d395526b6b9UL;
   tf->codes[4859] = 0x00043d3f823c5280UL;
   tf->codes[4860] = 0x00043d3fbccb5845UL;
   tf->codes[4861] = 0x00043d45e9e0f40cUL;
   tf->codes[4862] = 0x00043d47493b16aaUL;
   tf->codes[4863] = 0x00043d4af22b72faUL;
   tf->codes[4864] = 0x00043d5a4599f589UL;
   tf->codes[4865] = 0x00043d6281b6c53dUL;
   tf->codes[4866] = 0x00043d6ea152f706UL;
   tf->codes[4867] = 0x00043d719a964207UL;
   tf->codes[4868] = 0x00043d72f9f064a5UL;
   tf->codes[4869] = 0x00043d79d6b311bbUL;
   tf->codes[4870] = 0x00043d80b375bed1UL;
   tf->codes[4871] = 0x00043d8d82bf01e9UL;
   tf->codes[4872] = 0x00043d9a52084501UL;
   tf->codes[4873] = 0x00043d9b76d361daUL;
   tf->codes[4874] = 0x00043d9bebf16d64UL;
   tf->codes[4875] = 0x00043da4629d42ddUL;
   tf->codes[4876] = 0x00043da5c1f7657bUL;
   tf->codes[4877] = 0x00043daf5d6e57cdUL;
   tf->codes[4878] = 0x00043db340edb9e2UL;
   tf->codes[4879] = 0x00043dbb07ec7e0cUL;
   tf->codes[4880] = 0x00043dbe3bbeced2UL;
   tf->codes[4881] = 0x00043dc1aa20255dUL;
   tf->codes[4882] = 0x00043dcc2fd32ec3UL;
   tf->codes[4883] = 0x00043dcd549e4b9cUL;
   tf->codes[4884] = 0x00043dd172acb376UL;
   tf->codes[4885] = 0x00043dd79fc24f3dUL;
   tf->codes[4886] = 0x00043dd814e05ac7UL;
   tf->codes[4887] = 0x00043dd84f6f608cUL;
   tf->codes[4888] = 0x00043ddd9248e53fUL;
   tf->codes[4889] = 0x00043de3bf5e8106UL;
   tf->codes[4890] = 0x00043de5ce65b4f3UL;
   tf->codes[4891] = 0x00043de6f330d1ccUL;
   tf->codes[4892] = 0x00043def69dca745UL;
   tf->codes[4893] = 0x00043dfc73b4f022UL;
   tf->codes[4894] = 0x00043dfe482d1e4aUL;
   tf->codes[4895] = 0x00043e0c01b27876UL;
   tf->codes[4896] = 0x00043e12de75258cUL;
   tf->codes[4897] = 0x00043e1403404265UL;
   tf->codes[4898] = 0x00043e15d7b8708dUL;
   tf->codes[4899] = 0x00043e2b1dad891eUL;
   tf->codes[4900] = 0x00043e2d2cb4bd0bUL;
   tf->codes[4901] = 0x00043e352e4286faUL;
   tf->codes[4902] = 0x00043e37ecf6cc36UL;
   tf->codes[4903] = 0x00043e44f6cf1513UL;
   tf->codes[4904] = 0x00043e46562937b1UL;
   tf->codes[4905] = 0x00043e4c48afcdb3UL;
   tf->codes[4906] = 0x00043e4c833ed378UL;
   tf->codes[4907] = 0x00043e4f076412efUL;
   tf->codes[4908] = 0x00043e58684bff7cUL;
   tf->codes[4909] = 0x00043e5a023527dfUL;
   tf->codes[4910] = 0x00043e665c605f6dUL;
   tf->codes[4911] = 0x00043e7032665784UL;
   tf->codes[4912] = 0x00043e70a784630eUL;
   tf->codes[4913] = 0x00043e7206de85acUL;
   tf->codes[4914] = 0x00043e73a0c7ae0fUL;
   tf->codes[4915] = 0x00043e745074bf5eUL;
   tf->codes[4916] = 0x00043e7d76cda626UL;
   tf->codes[4917] = 0x00043e83de7247b2UL;
   tf->codes[4918] = 0x00043e85033d648bUL;
   tf->codes[4919] = 0x00043e899669d7efUL;
   tf->codes[4920] = 0x00043e8e9eb456ddUL;
   tf->codes[4921] = 0x00043e93e18ddb90UL;
   tf->codes[4922] = 0x00043e941c1ce155UL;
   tf->codes[4923] = 0x00043e9540e7fe2eUL;
   tf->codes[4924] = 0x00043e957b7703f3UL;
   tf->codes[4925] = 0x00043ea334fc5e1fUL;
   tf->codes[4926] = 0x00043eafc9b69b72UL;
   tf->codes[4927] = 0x00043eb45ce30ed6UL;
   tf->codes[4928] = 0x00043ec1dbd9633dUL;
   tf->codes[4929] = 0x00043ec3eae0972aUL;
   tf->codes[4930] = 0x00043ec92dba1bddUL;
   tf->codes[4931] = 0x00043edc9f370646UL;
   tf->codes[4932] = 0x00043edf987a5147UL;
   tf->codes[4933] = 0x00043ee1e2108af9UL;
   tf->codes[4934] = 0x00043ee4db53d5faUL;
   tf->codes[4935] = 0x00043eeca2529a24UL;
   tf->codes[4936] = 0x00043eef2677d99bUL;
   tf->codes[4937] = 0x00043ef5538d7562UL;
   tf->codes[4938] = 0x00043efc30502278UL;
   tf->codes[4939] = 0x00043f05cbc714caUL;
   tf->codes[4940] = 0x00043f06f09231a3UL;
   tf->codes[4941] = 0x00043f0b0ea0997dUL;
   tf->codes[4942] = 0x00043f13bfdb74bbUL;
   tf->codes[4943] = 0x00043f260c8d424bUL;
   tf->codes[4944] = 0x00043f2856237bfdUL;
   tf->codes[4945] = 0x00043f3908ec212aUL;
   tf->codes[4946] = 0x00043f3cb1dc7d7aUL;
   tf->codes[4947] = 0x00043f45631758b8UL;
   tf->codes[4948] = 0x00043f4b559deebaUL;
   tf->codes[4949] = 0x00043f50235967e3UL;
   tf->codes[4950] = 0x00043f5182b38a81UL;
   tf->codes[4951] = 0x00043f5824e731d2UL;
   tf->codes[4952] = 0x00043f5da24fbc4aUL;
   tf->codes[4953] = 0x00043f66538a9788UL;
   tf->codes[4954] = 0x00043f668e199d4dUL;
   tf->codes[4955] = 0x00043f677855b461UL;
   tf->codes[4956] = 0x00043f6c80a0334fUL;
   tf->codes[4957] = 0x00043f7397f1e62aUL;
   tf->codes[4958] = 0x00043f7ecd5200dfUL;
   tf->codes[4959] = 0x00043f7f42700c69UL;
   tf->codes[4960] = 0x00043f81c6954be0UL;
   tf->codes[4961] = 0x00043f923eceeb48UL;
   tf->codes[4962] = 0x00043f96d1fb5eacUL;
   tf->codes[4963] = 0x00043f991b91985eUL;
   tf->codes[4964] = 0x00043faa7e074edaUL;
   tf->codes[4965] = 0x00043faba2d26bb3UL;
   tf->codes[4966] = 0x00043fb0ab1ceaa1UL;
   tf->codes[4967] = 0x00043fb0e5abf066UL;
   tf->codes[4968] = 0x00043fb787df97b7UL;
   tf->codes[4969] = 0x00043fc491b7e094UL;
   tf->codes[4970] = 0x00043fc83aa83ce4UL;
   tf->codes[4971] = 0x00043fcbe3989934UL;
   tf->codes[4972] = 0x00043fd8ed70e211UL;
   tf->codes[4973] = 0x00043fda875a0a74UL;
   tf->codes[4974] = 0x00043fe422d0fcc6UL;
   tf->codes[4975] = 0x00043fe7cbc15916UL;
   tf->codes[4976] = 0x00043fe8f08c75efUL;
   tf->codes[4977] = 0x00043fec997cd23fUL;
   tf->codes[4978] = 0x00043ff71f2fdba5UL;
   tf->codes[4979] = 0x00043ffac82037f5UL;
   tf->codes[4980] = 0x00044002c9ae01e4UL;
   tf->codes[4981] = 0x00044003043d07a9UL;
   tf->codes[4982] = 0x00044003b3ea18f8UL;
   tf->codes[4983] = 0x00044005c2f14ce5UL;
   tf->codes[4984] = 0x0004400a90acc60eUL;
   tf->codes[4985] = 0x0004400b4059d75dUL;
   tf->codes[4986] = 0x000440137c76a711UL;
   tf->codes[4987] = 0x0004401675b9f212UL;
   tf->codes[4988] = 0x0004401a1eaa4e62UL;
   tf->codes[4989] = 0x0004401b43756b3bUL;
   tf->codes[4990] = 0x0004401c2db1824fUL;
   tf->codes[4991] = 0x00044024a45d57c8UL;
   tf->codes[4992] = 0x00044029aca7d6b6UL;
   tf->codes[4993] = 0x0004402a21c5e240UL;
   tf->codes[4994] = 0x0004402eef815b69UL;
   tf->codes[4995] = 0x000440329871b7b9UL;
   tf->codes[4996] = 0x00044033bd3cd492UL;
   tf->codes[4997] = 0x00044033f7cbda57UL;
   tf->codes[4998] = 0x00044034a778eba6UL;
   tf->codes[4999] = 0x000440367bf119ceUL;
   tf->codes[5000] = 0x000440372b9e2b1dUL;
   tf->codes[5001] = 0x00044037662d30e2UL;
   tf->codes[5002] = 0x0004403a24e1761eUL;
   tf->codes[5003] = 0x0004403ce395bb5aUL;
   tf->codes[5004] = 0x0004403d58b3c6e4UL;
   tf->codes[5005] = 0x0004404260fe45d2UL;
   tf->codes[5006] = 0x00044044357673faUL;
   tf->codes[5007] = 0x0004404bc1e6325fUL;
   tf->codes[5008] = 0x0004404d965e6087UL;
   tf->codes[5009] = 0x0004404e809a779bUL;
   tf->codes[5010] = 0x0004404f6ad68eafUL;
   tf->codes[5011] = 0x00044050ca30b14dUL;
   tf->codes[5012] = 0x0004405104bfb712UL;
   tf->codes[5013] = 0x000440534e55f0c4UL;
   tf->codes[5014] = 0x00044054389207d8UL;
   tf->codes[5015] = 0x0004405473210d9dUL;
   tf->codes[5016] = 0x0004405647993bc5UL;
   tf->codes[5017] = 0x00044058cbbe7b3cUL;
   tf->codes[5018] = 0x00044059064d8101UL;
   tf->codes[5019] = 0x00044059b5fa9250UL;
   tf->codes[5020] = 0x00044059f0899815UL;
   tf->codes[5021] = 0x0004405a2b189ddaUL;
   tf->codes[5022] = 0x0004406267356d8eUL;
   tf->codes[5023] = 0x000440643bad9bb6UL;
   tf->codes[5024] = 0x00044064763ca17bUL;
   tf->codes[5025] = 0x00044064b0cba740UL;
   tf->codes[5026] = 0x00044066fa61e0f2UL;
   tf->codes[5027] = 0x0004406734f0e6b7UL;
   tf->codes[5028] = 0x0004406a68c3377dUL;
   tf->codes[5029] = 0x0004406cece876f4UL;
   tf->codes[5030] = 0x0004406ec160a51cUL;
   tf->codes[5031] = 0x0004406fe62bc1f5UL;
   tf->codes[5032] = 0x000440738f1c1e45UL;
   tf->codes[5033] = 0x00044073c9ab240aUL;
   tf->codes[5034] = 0x00044074043a29cfUL;
   tf->codes[5035] = 0x00044079f6c0bfd1UL;
   tf->codes[5036] = 0x0004407b561ae26fUL;
   tf->codes[5037] = 0x0004407c4056f983UL;
   tf->codes[5038] = 0x0004407e14cf27abUL;
   tf->codes[5039] = 0x0004407e4f5e2d70UL;
   tf->codes[5040] = 0x000440868b7afd24UL;
   tf->codes[5041] = 0x0004408d2daea475UL;
   tf->codes[5042] = 0x0004408d683daa3aUL;
   tf->codes[5043] = 0x0004408da2ccafffUL;
   tf->codes[5044] = 0x0004408ddd5bb5c4UL;
   tf->codes[5045] = 0x00044093cfe24bc6UL;
   tf->codes[5046] = 0x00044098287fb965UL;
   tf->codes[5047] = 0x0004409ae733fea1UL;
   tf->codes[5048] = 0x0004409de07749a2UL;
   tf->codes[5049] = 0x0004409f7a607205UL;
   tf->codes[5050] = 0x000440a2ae32c2cbUL;
   tf->codes[5051] = 0x000440ab99fca3ceUL;
   tf->codes[5052] = 0x000440b0a24722bcUL;
   tf->codes[5053] = 0x000440ba032f0f49UL;
   tf->codes[5054] = 0x000440ba784d1ad3UL;
   tf->codes[5055] = 0x000440bbd7a73d71UL;
   tf->codes[5056] = 0x000440bc12364336UL;
   tf->codes[5057] = 0x000440bfbb269f86UL;
   tf->codes[5058] = 0x000440c2b469ea87UL;
   tf->codes[5059] = 0x000440c747965debUL;
   tf->codes[5060] = 0x000440c9cbbb9d62UL;
   tf->codes[5061] = 0x000440ca7b68aeb1UL;
   tf->codes[5062] = 0x000440cc1551d714UL;
   tf->codes[5063] = 0x000440d0a87e4a78UL;
   tf->codes[5064] = 0x000440d0e30d503dUL;
   tf->codes[5065] = 0x000440d1582b5bc7UL;
   tf->codes[5066] = 0x000440d192ba618cUL;
   tf->codes[5067] = 0x000440d27cf678a0UL;
   tf->codes[5068] = 0x000440d2b7857e65UL;
   tf->codes[5069] = 0x000440d66075dab5UL;
   tf->codes[5070] = 0x000440da09663705UL;
   tf->codes[5071] = 0x000440dbddde652dUL;
   tf->codes[5072] = 0x000440ded721b02eUL;
   tf->codes[5073] = 0x000440e0ab99de56UL;
   tf->codes[5074] = 0x000440e20af400f4UL;
   tf->codes[5075] = 0x000440e36a4e2392UL;
   tf->codes[5076] = 0x000440e87298a280UL;
   tf->codes[5077] = 0x000440ea0c81cae3UL;
   tf->codes[5078] = 0x000440eb6bdbed81UL;
   tf->codes[5079] = 0x000440efc4795b20UL;
   tf->codes[5080] = 0x000440f1d3808f0dUL;
   tf->codes[5081] = 0x000440f332dab1abUL;
   tf->codes[5082] = 0x000440f57c70eb5dUL;
   tf->codes[5083] = 0x000440f95ff04d72UL;
   tf->codes[5084] = 0x000440fa4a2c6486UL;
   tf->codes[5085] = 0x000440fb6ef7815fUL;
   tf->codes[5086] = 0x000440fd08e0a9c2UL;
   tf->codes[5087] = 0x00044101617e1761UL;
   tf->codes[5088] = 0x000441028649343aUL;
   tf->codes[5089] = 0x00044102fb673fc4UL;
   tf->codes[5090] = 0x000441062f39908aUL;
   tf->codes[5091] = 0x00044106a4579c14UL;
   tf->codes[5092] = 0x0004410cd16d37dbUL;
   tf->codes[5093] = 0x0004410f90217d17UL;
   tf->codes[5094] = 0x0004410fcab082dcUL;
   tf->codes[5095] = 0x00044113ae2fe4f1UL;
   tf->codes[5096] = 0x00044115bd3718deUL;
   tf->codes[5097] = 0x00044116e20235b7UL;
   tf->codes[5098] = 0x000441171c913b7cUL;
   tf->codes[5099] = 0x00044118415c5855UL;
   tf->codes[5100] = 0x000441192b986f69UL;
   tf->codes[5101] = 0x0004411c24dbba6aUL;
   tf->codes[5102] = 0x0004411dbec4e2cdUL;
   tf->codes[5103] = 0x0004411f1e1f056bUL;
   tf->codes[5104] = 0x0004411f933d10f5UL;
   tf->codes[5105] = 0x00044123ebda7e94UL;
   tf->codes[5106] = 0x000441271faccf5aUL;
   tf->codes[5107] = 0x0004412b3dbb3734UL;
   tf->codes[5108] = 0x0004412bb2d942beUL;
   tf->codes[5109] = 0x00044133b4670cadUL;
   tf->codes[5110] = 0x00044140f8ce5b4fUL;
   tf->codes[5111] = 0x000441476072fcdbUL;
   tf->codes[5112] = 0x0004414a1f274217UL;
   tf->codes[5113] = 0x0004414ca34c818eUL;
   tf->codes[5114] = 0x0004414e02a6a42cUL;
   tf->codes[5115] = 0x000441513678f4f2UL;
   tf->codes[5116] = 0x000441563ec373e0UL;
   tf->codes[5117] = 0x0004415a5cd1dbbaUL;
   tf->codes[5118] = 0x0004415ad1efe744UL;
   tf->codes[5119] = 0x0004416014c96bf7UL;
   tf->codes[5120] = 0x0004416223d09fe4UL;
   tf->codes[5121] = 0x000441630e0cb6f8UL;
   tf->codes[5122] = 0x000441659231f66fUL;
   tf->codes[5123] = 0x00044169b0405e49UL;
   tf->codes[5124] = 0x0004416a9a7c755dUL;
   tf->codes[5125] = 0x0004416b84b88c71UL;
   tf->codes[5126] = 0x0004416c6ef4a385UL;
   tf->codes[5127] = 0x0004416d1ea1b4d4UL;
   tf->codes[5128] = 0x0004416dce4ec623UL;
   tf->codes[5129] = 0x0004416eb88add37UL;
   tf->codes[5130] = 0x000441705274059aUL;
   tf->codes[5131] = 0x000441713cb01caeUL;
   tf->codes[5132] = 0x0004417470826d74UL;
   tf->codes[5133] = 0x00044175202f7ec3UL;
   tf->codes[5134] = 0x0004417769c5b875UL;
   tf->codes[5135] = 0x0004417ef63576daUL;
   tf->codes[5136] = 0x00044183c3f0f003UL;
   tf->codes[5137] = 0x0004418598691e2bUL;
   tf->codes[5138] = 0x000441897be88040UL;
   tf->codes[5139] = 0x0004418bc57eb9f2UL;
   tf->codes[5140] = 0x0004418ef9510ab8UL;
   tf->codes[5141] = 0x000441938c7d7e1cUL;
   tf->codes[5142] = 0x00044194b1489af5UL;
   tf->codes[5143] = 0x00044199b99319e3UL;
   tf->codes[5144] = 0x0004419b18ed3c81UL;
   tf->codes[5145] = 0x000441a4b4642ed3UL;
   tf->codes[5146] = 0x000441a613be5171UL;
   tf->codes[5147] = 0x000441a77318740fUL;
   tf->codes[5148] = 0x000441a822c5855eUL;
   tf->codes[5149] = 0x000441ac7b62f2fdUL;
   tf->codes[5150] = 0x000441b26de988ffUL;
   tf->codes[5151] = 0x000441b9bfca419fUL;
   tf->codes[5152] = 0x000441bb94426fc7UL;
   tf->codes[5153] = 0x000441bc7e7e86dbUL;
   tf->codes[5154] = 0x000441be1867af3eUL;
   tf->codes[5155] = 0x000441bf02a3c652UL;
   tf->codes[5156] = 0x000441bf77c1d1dcUL;
   tf->codes[5157] = 0x000441bfecdfdd66UL;
   tf->codes[5158] = 0x000441c4ba9b568fUL;
   tf->codes[5159] = 0x000441c704319041UL;
   tf->codes[5160] = 0x000441c7b3dea190UL;
   tf->codes[5161] = 0x000441c8638bb2dfUL;
   tf->codes[5162] = 0x000441cf7add65baUL;
   tf->codes[5163] = 0x000441d1c4739f6cUL;
   tf->codes[5164] = 0x000441d23991aaf6UL;
   tf->codes[5165] = 0x000441d35e5cc7cfUL;
   tf->codes[5166] = 0x000441d398ebcd94UL;
   tf->codes[5167] = 0x000441d5e2820746UL;
   tf->codes[5168] = 0x000441d77c6b2fa9UL;
   tf->codes[5169] = 0x000441dda980cb70UL;
   tf->codes[5170] = 0x000441df08daee0eUL;
   tf->codes[5171] = 0x000441e326e955e8UL;
   tf->codes[5172] = 0x000441e77f86c387UL;
   tf->codes[5173] = 0x000441eb28771fd7UL;
   tf->codes[5174] = 0x000441ec87d14275UL;
   tf->codes[5175] = 0x000441ecfcef4dffUL;
   tf->codes[5176] = 0x000441efbba3933bUL;
   tf->codes[5177] = 0x000441f2ef75e401UL;
   tf->codes[5178] = 0x000441f5ae2a293dUL;
   tf->codes[5179] = 0x000441f91c8b7fc8UL;
   tf->codes[5180] = 0x000441fc15cecac9UL;
   tf->codes[5181] = 0x00044202085560cbUL;
   tf->codes[5182] = 0x0004420ab9903c09UL;
   tf->codes[5183] = 0x0004420ba3cc531dUL;
   tf->codes[5184] = 0x0004420bde5b58e2UL;
   tf->codes[5185] = 0x0004420ed79ea3e3UL;
   tf->codes[5186] = 0x00044212f5ad0bbdUL;
   tf->codes[5187] = 0x00044213dfe922d1UL;
   tf->codes[5188] = 0x00044215eef056beUL;
   tf->codes[5189] = 0x00044216d92c6dd2UL;
   tf->codes[5190] = 0x000442174e4a795cUL;
   tf->codes[5191] = 0x00044217c36884e6UL;
   tf->codes[5192] = 0x0004421922c2a784UL;
   tf->codes[5193] = 0x0004421a478dc45dUL;
   tf->codes[5194] = 0x000442233357a560UL;
   tf->codes[5195] = 0x00044227c68418c4UL;
   tf->codes[5196] = 0x0004422eddd5cb9fUL;
   tf->codes[5197] = 0x00044233ab9144c8UL;
   tf->codes[5198] = 0x0004423928f9cf40UL;
   tf->codes[5199] = 0x0004423ea66259b8UL;
   tf->codes[5200] = 0x0004423f909e70ccUL;
   tf->codes[5201] = 0x000442412a87992fUL;
   tf->codes[5202] = 0x00044241da34aa7eUL;
   tf->codes[5203] = 0x00044243741dd2e1UL;
   tf->codes[5204] = 0x00044245bdb40c93UL;
   tf->codes[5205] = 0x000442466d611de2UL;
   tf->codes[5206] = 0x0004424df9d0dc47UL;
   tf->codes[5207] = 0x00044254d693895dUL;
   tf->codes[5208] = 0x0004425bb3563673UL;
   tf->codes[5209] = 0x00044261e06bd23aUL;
   tf->codes[5210] = 0x000442621afad7ffUL;
   tf->codes[5211] = 0x000442637a54fa9dUL;
   tf->codes[5212] = 0x00044268f7bd8515UL;
   tf->codes[5213] = 0x0004426bb671ca51UL;
   tf->codes[5214] = 0x0004426c2b8fd5dbUL;
   tf->codes[5215] = 0x00044272cdc37d2cUL;
   tf->codes[5216] = 0x000442751759b6deUL;
   tf->codes[5217] = 0x0004427a5a333b91UL;
   tf->codes[5218] = 0x0004427a94c24156UL;
   tf->codes[5219] = 0x0004427bb98d5e2fUL;
   tf->codes[5220] = 0x00044282d0df110aUL;
   tf->codes[5221] = 0x0004428345fd1c94UL;
   tf->codes[5222] = 0x00044284303933a8UL;
   tf->codes[5223] = 0x000442851a754abcUL;
   tf->codes[5224] = 0x0004428604b161d0UL;
   tf->codes[5225] = 0x000442863f406795UL;
   tf->codes[5226] = 0x00044287297c7ea9UL;
   tf->codes[5227] = 0x000442884e479b82UL;
   tf->codes[5228] = 0x0004428b0cfbe0beUL;
   tf->codes[5229] = 0x0004428d56921a70UL;
   tf->codes[5230] = 0x000442930e89aaadUL;
   tf->codes[5231] = 0x0004429a25db5d88UL;
   tf->codes[5232] = 0x000442a645778f51UL;
   tf->codes[5233] = 0x000442a76a42ac2aUL;
   tf->codes[5234] = 0x000442aa9e14fcf0UL;
   tf->codes[5235] = 0x000442b97c6573f5UL;
   tf->codes[5236] = 0x000442bb50dda21dUL;
   tf->codes[5237] = 0x000442bd2555d045UL;
   tf->codes[5238] = 0x000442be84aff2e3UL;
   tf->codes[5239] = 0x000442c9f49f135dUL;
   tf->codes[5240] = 0x000442cdd81e7572UL;
   tf->codes[5241] = 0x000442d021b4af24UL;
   tf->codes[5242] = 0x000442d05c43b4e9UL;
   tf->codes[5243] = 0x000442d096d2baaeUL;
   tf->codes[5244] = 0x000442d6895950b0UL;
   tf->codes[5245] = 0x000442d7e8b3734eUL;
   tf->codes[5246] = 0x000442d89860849dUL;
   tf->codes[5247] = 0x000442d9829c9bb1UL;
   tf->codes[5248] = 0x000442dc06c1db28UL;
   tf->codes[5249] = 0x000442dfea413d3dUL;
   tf->codes[5250] = 0x000442e3cdc09f52UL;
   tf->codes[5251] = 0x000442e7ebcf072cUL;
   tf->codes[5252] = 0x000442e8265e0cf1UL;
   tf->codes[5253] = 0x000442ea6ff446a3UL;
   tf->codes[5254] = 0x000442ec446c74cbUL;
   tf->codes[5255] = 0x000442ecf419861aUL;
   tf->codes[5256] = 0x000442f11227edf4UL;
   tf->codes[5257] = 0x000442f14cb6f3b9UL;
   tf->codes[5258] = 0x000442f236f30acdUL;
   tf->codes[5259] = 0x000442ff7b5a596fUL;
   tf->codes[5260] = 0x000443044915d298UL;
   tf->codes[5261] = 0x000443056de0ef71UL;
   tf->codes[5262] = 0x00044305a86ff536UL;
   tf->codes[5263] = 0x0004430707ca17d4UL;
   tf->codes[5264] = 0x0004430cfa50add6UL;
   tf->codes[5265] = 0x0004430e59aad074UL;
   tf->codes[5266] = 0x000443102e22fe9cUL;
   tf->codes[5267] = 0x0004431b28f4138cUL;
   tf->codes[5268] = 0x0004431c13302aa0UL;
   tf->codes[5269] = 0x0004431c884e362aUL;
   tf->codes[5270] = 0x0004431cc2dd3befUL;
   tf->codes[5271] = 0x0004431fbc2086f0UL;
   tf->codes[5272] = 0x0004432414bdf48fUL;
   tf->codes[5273] = 0x0004432539891168UL;
   tf->codes[5274] = 0x0004432ff9cb2093UL;
   tf->codes[5275] = 0x0004433502159f81UL;
   tf->codes[5276] = 0x0004433d78c174faUL;
   tf->codes[5277] = 0x00044343e0661686UL;
   tf->codes[5278] = 0x000443441af51c4bUL;
   tf->codes[5279] = 0x00044344caa22d9aUL;
   tf->codes[5280] = 0x00044348ae218fafUL;
   tf->codes[5281] = 0x0004434a8299bdd7UL;
   tf->codes[5282] = 0x0004434b3246cf26UL;
   tf->codes[5283] = 0x0004434ccc2ff789UL;
   tf->codes[5284] = 0x00044354cdbdc178UL;
   tf->codes[5285] = 0x0004435876ae1dc8UL;
   tf->codes[5286] = 0x00044363e69d3e42UL;
   tf->codes[5287] = 0x00044365f5a4722fUL;
   tf->codes[5288] = 0x0004436879c9b1a6UL;
   tf->codes[5289] = 0x000443728a5eaf82UL;
   tf->codes[5290] = 0x000443766dde1197UL;
   tf->codes[5291] = 0x000443771d8b22e6UL;
   tf->codes[5292] = 0x0004437ac67b7f36UL;
   tf->codes[5293] = 0x0004437b76289085UL;
   tf->codes[5294] = 0x0004437bb0b7964aUL;
   tf->codes[5295] = 0x0004437d4aa0beadUL;
   tf->codes[5296] = 0x0004437f59a7f29aUL;
   tf->codes[5297] = 0x00044383b2456039UL;
   tf->codes[5298] = 0x0004438427636bc3UL;
   tf->codes[5299] = 0x0004438670f9a575UL;
   tf->codes[5300] = 0x0004438b042618d9UL;
   tf->codes[5301] = 0x0004438d132d4cc6UL;
   tf->codes[5302] = 0x0004439514bb16b5UL;
   tf->codes[5303] = 0x0004439ca12ad51aUL;
   tf->codes[5304] = 0x0004439eb0320907UL;
   tf->codes[5305] = 0x000443a60212c1a7UL;
   tf->codes[5306] = 0x000443afd818b9beUL;
   tf->codes[5307] = 0x000443b1ac90e7e6UL;
   tf->codes[5308] = 0x000443b8895394fcUL;
   tf->codes[5309] = 0x000443ba5dcbc324UL;
   tf->codes[5310] = 0x000443be414b2539UL;
   tf->codes[5311] = 0x000443bf2b873c4dUL;
   tf->codes[5312] = 0x000443c224ca874eUL;
   tf->codes[5313] = 0x000443c433d1bb3bUL;
   tf->codes[5314] = 0x000443c8c6fe2e9fUL;
   tf->codes[5315] = 0x000443cdcf48ad8dUL;
   tf->codes[5316] = 0x000443d08dfcf2c9UL;
   tf->codes[5317] = 0x000443d3fc5e4954UL;
   tf->codes[5318] = 0x000443d6bb128e90UL;
   tf->codes[5319] = 0x000443d7dfddab69UL;
   tf->codes[5320] = 0x000443dbfdec1343UL;
   tf->codes[5321] = 0x000443e5d3f20b5aUL;
   tf->codes[5322] = 0x000443e60e81111fUL;
   tf->codes[5323] = 0x000443e6be2e226eUL;
   tf->codes[5324] = 0x000443e9b7716d6fUL;
   tf->codes[5325] = 0x000443ed25d2c3faUL;
   tf->codes[5326] = 0x000443f094341a85UL;
   tf->codes[5327] = 0x000443fbc994353aUL;
   tf->codes[5328] = 0x00044409f8379af0UL;
   tf->codes[5329] = 0x0004440b5791bd8eUL;
   tf->codes[5330] = 0x0004440da127f740UL;
   tf->codes[5331] = 0x00044410254d36b7UL;
   tf->codes[5332] = 0x000444114a185390UL;
   tf->codes[5333] = 0x00044411f9c564dfUL;
   tf->codes[5334] = 0x00044412e4017bf3UL;
   tf->codes[5335] = 0x00044414435b9e91UL;
   tf->codes[5336] = 0x000444165262d27eUL;
   tf->codes[5337] = 0x0004441cf49679cfUL;
   tf->codes[5338] = 0x00044421fce0f8bdUL;
   tf->codes[5339] = 0x000444298950b722UL;
   tf->codes[5340] = 0x0004442d32411372UL;
   tf->codes[5341] = 0x000444323a8b9260UL;
   tf->codes[5342] = 0x0004443b9b737eedUL;
   tf->codes[5343] = 0x0004443f7ef2e102UL;
   tf->codes[5344] = 0x0004444536ea713fUL;
   tf->codes[5345] = 0x00044446964493ddUL;
   tf->codes[5346] = 0x00044448dfdacd8fUL;
   tf->codes[5347] = 0x0004444b9e8f12cbUL;
   tf->codes[5348] = 0x0004444fbc9d7aa5UL;
   tf->codes[5349] = 0x00044450a6d991b9UL;
   tf->codes[5350] = 0x000444515686a308UL;
   tf->codes[5351] = 0x0004445a4250840bUL;
   tf->codes[5352] = 0x0004445a7cdf89d0UL;
   tf->codes[5353] = 0x0004445d7622d4d1UL;
   tf->codes[5354] = 0x000444627e6d53bfUL;
   tf->codes[5355] = 0x000444671199c723UL;
   tf->codes[5356] = 0x0004446b2fa82efdUL;
   tf->codes[5357] = 0x0004446f88459c9cUL;
   tf->codes[5358] = 0x000444769f974f77UL;
   tf->codes[5359] = 0x00044477c4626c50UL;
   tf->codes[5360] = 0x0004447a8316b18cUL;
   tf->codes[5361] = 0x0004447b32c3c2dbUL;
   tf->codes[5362] = 0x00044488772b117dUL;
   tf->codes[5363] = 0x0004448a111439e0UL;
   tf->codes[5364] = 0x0004448d0a5784e1UL;
   tf->codes[5365] = 0x000444903e29d5a7UL;
   tf->codes[5366] = 0x0004449078b8db6cUL;
   tf->codes[5367] = 0x0004449287c00f59UL;
   tf->codes[5368] = 0x00044499d9a0c7f9UL;
   tf->codes[5369] = 0x0004449e323e3598UL;
   tf->codes[5370] = 0x000444ab76a5843aUL;
   tf->codes[5371] = 0x000444b4d78d70c7UL;
   tf->codes[5372] = 0x000444bb04a30c8eUL;
   tf->codes[5373] = 0x000444be38755d54UL;
   tf->codes[5374] = 0x000444bead9368deUL;
   tf->codes[5375] = 0x000444cdc672e5a8UL;
   tf->codes[5376] = 0x000444ce3b90f132UL;
   tf->codes[5377] = 0x000444d16f6341f8UL;
   tf->codes[5378] = 0x000444d3b8f97baaUL;
   tf->codes[5379] = 0x000444d7275ad235UL;
   tf->codes[5380] = 0x000444d936620622UL;
   tf->codes[5381] = 0x000444da209e1d36UL;
   tf->codes[5382] = 0x000444e30c67fe39UL;
   tf->codes[5383] = 0x000444e79f94719dUL;
   tf->codes[5384] = 0x000444e7da237762UL;
   tf->codes[5385] = 0x000444e8c45f8e76UL;
   tf->codes[5386] = 0x000444f1b0296f79UL;
   tf->codes[5387] = 0x000444f51e8ac604UL;
   tf->codes[5388] = 0x000444f76820ffb6UL;
   tf->codes[5389] = 0x000444f7dd3f0b40UL;
   tf->codes[5390] = 0x00044503129f25f5UL;
   tf->codes[5391] = 0x000445090525bbf7UL;
   tf->codes[5392] = 0x0004450bc3da0133UL;
   tf->codes[5393] = 0x00044513fff6d0e7UL;
   tf->codes[5394] = 0x000445143a85d6acUL;
   tf->codes[5395] = 0x0004451908414fd5UL;
   tf->codes[5396] = 0x00044519f27d66e9UL;
   tf->codes[5397] = 0x00044529807aef3dUL;
   tf->codes[5398] = 0x0004452fe81f90c9UL;
   tf->codes[5399] = 0x0004453d6715e530UL;
   tf->codes[5400] = 0x00044542e47e6fa8UL;
   tf->codes[5401] = 0x0004454aab7d33d2UL;
   tf->codes[5402] = 0x000445556bbf42fdUL;
   tf->codes[5403] = 0x00044555e0dd4e87UL;
   tf->codes[5404] = 0x0004455a7409c1ebUL;
   tf->codes[5405] = 0x0004455b23b6d33aUL;
   tf->codes[5406] = 0x0004456ab1b45b8eUL;
   tf->codes[5407] = 0x0004456aec436153UL;
   tf->codes[5408] = 0x0004456f0a51c92dUL;
   tf->codes[5409] = 0x0004457328603107UL;
   tf->codes[5410] = 0x00044579ca93d858UL;
   tf->codes[5411] = 0x0004457c4eb917cfUL;
   tf->codes[5412] = 0x0004457f47fc62d0UL;
   tf->codes[5413] = 0x000445848ad5e783UL;
   tf->codes[5414] = 0x0004458cc6f2b737UL;
   tf->codes[5415] = 0x0004459d049d50daUL;
   tf->codes[5416] = 0x0004459e29686db3UL;
   tf->codes[5417] = 0x000445b41f0a9793UL;
   tf->codes[5418] = 0x000445b99c73220bUL;
   tf->codes[5419] = 0x000445be6a2e9b34UL;
   tf->codes[5420] = 0x000445c422262b71UL;
   tf->codes[5421] = 0x000445c50c624285UL;
   tf->codes[5422] = 0x000445c6e0da70adUL;
   tf->codes[5423] = 0x000445c8efe1a49aUL;
   tf->codes[5424] = 0x000445ca4f3bc738UL;
   tf->codes[5425] = 0x000445cd830e17feUL;
   tf->codes[5426] = 0x000445cf92154bebUL;
   tf->codes[5427] = 0x000445d4d4eed09eUL;
   tf->codes[5428] = 0x000445d6a966fec6UL;
   tf->codes[5429] = 0x000445d808c12164UL;
   tf->codes[5430] = 0x000445d9dd394f8cUL;
   tf->codes[5431] = 0x000445da52575b16UL;
   tf->codes[5432] = 0x000445dc9bed94c8UL;
   tf->codes[5433] = 0x000445dd8629abdcUL;
   tf->codes[5434] = 0x000445ddfb47b766UL;
   tf->codes[5435] = 0x000445e49d7b5eb7UL;
   tf->codes[5436] = 0x000445f1e1e2ad59UL;
   tf->codes[5437] = 0x000445f42b78e70bUL;
   tf->codes[5438] = 0x000445f515b4fe1fUL;
   tf->codes[5439] = 0x000445facdac8e5cUL;
   tf->codes[5440] = 0x00044604a3b28673UL;
   tf->codes[5441] = 0x0004460518d091fdUL;
   tf->codes[5442] = 0x0004460d54ed61b1UL;
   tf->codes[5443] = 0x0004460e3f2978c5UL;
   tf->codes[5444] = 0x00044615cb99372aUL;
   tf->codes[5445] = 0x00044616f0645403UL;
   tf->codes[5446] = 0x0004461c6dccde7bUL;
   tf->codes[5447] = 0x0004461d9297fb54UL;
   tf->codes[5448] = 0x0004464d9beab6eeUL;
   tf->codes[5449] = 0x000446505a9efc2aUL;
   tf->codes[5450] = 0x000446594668dd2dUL;
   tf->codes[5451] = 0x0004465b5570111aUL;
   tf->codes[5452] = 0x0004465e4eb35c1bUL;
   tf->codes[5453] = 0x00044673cf377a71UL;
   tf->codes[5454] = 0x0004467ae6892d4cUL;
   tf->codes[5455] = 0x00044694851bb37cUL;
   tf->codes[5456] = 0x000446982e0c0fccUL;
   tf->codes[5457] = 0x00044699184826e0UL;
   tf->codes[5458] = 0x0004469c4c1a77a6UL;
   tf->codes[5459] = 0x000446a7817a925bUL;
   tf->codes[5460] = 0x000446ab9f88fa35UL;
   tf->codes[5461] = 0x000446b3a116c424UL;
   tf->codes[5462] = 0x000446b784962639UL;
   tf->codes[5463] = 0x000446b7f9b431c3UL;
   tf->codes[5464] = 0x000446bcc76faaecUL;
   tf->codes[5465] = 0x000446c1952b2415UL;
   tf->codes[5466] = 0x000446c9d147f3c9UL;
   tf->codes[5467] = 0x000446cfc3ce89cbUL;
   tf->codes[5468] = 0x000446d6a09136e1UL;
   tf->codes[5469] = 0x000446d78acd4df5UL;
   tf->codes[5470] = 0x000446da49819331UL;
   tf->codes[5471] = 0x000446e45a16910dUL;
   tf->codes[5472] = 0x000446ef1a58a038UL;
   tf->codes[5473] = 0x000446f0eed0ce60UL;
   tf->codes[5474] = 0x000446f4d2503075UL;
   tf->codes[5475] = 0x000446f8b5cf928aUL;
   tf->codes[5476] = 0x000446fb39f4d201UL;
   tf->codes[5477] = 0x0004470425beb304UL;
   tf->codes[5478] = 0x0004470a8d635490UL;
   tf->codes[5479] = 0x0004471c2a6810d1UL;
   tf->codes[5480] = 0x0004471c9f861c5bUL;
   tf->codes[5481] = 0x00044726b01b1a37UL;
   tf->codes[5482] = 0x0004472dc76ccd12UL;
   tf->codes[5483] = 0x0004472e7719de61UL;
   tf->codes[5484] = 0x00044733f48268d9UL;
   tf->codes[5485] = 0x00044739375bed8cUL;
   tf->codes[5486] = 0x00044744a74b0e06UL;
   tf->codes[5487] = 0x0004474a5f429e43UL;
   tf->codes[5488] = 0x0004474c6e49d230UL;
   tf->codes[5489] = 0x0004475101764594UL;
   tf->codes[5490] = 0x000447572e8be15bUL;
   tf->codes[5491] = 0x00044759b2b120d2UL;
   tf->codes[5492] = 0x000447660cdc5860UL;
   tf->codes[5493] = 0x0004476d5ebd1100UL;
   tf->codes[5494] = 0x0004477267078feeUL;
   tf->codes[5495] = 0x00044778598e25f0UL;
   tf->codes[5496] = 0x0004477cecba9954UL;
   tf->codes[5497] = 0x00044781ba76127dUL;
   tf->codes[5498] = 0x000447843e9b51f4UL;
   tf->codes[5499] = 0x0004478fe9197833UL;
   tf->codes[5500] = 0x000447905e3783bdUL;
   tf->codes[5501] = 0x00044793577acebeUL;
   tf->codes[5502] = 0x000447ac0bd13ddaUL;
   tf->codes[5503] = 0x000447b56cb92a67UL;
   tf->codes[5504] = 0x000447bfb7dd2e08UL;
   tf->codes[5505] = 0x000447bff26c33cdUL;
   tf->codes[5506] = 0x000447c3d5eb95e2UL;
   tf->codes[5507] = 0x000447c56fd4be45UL;
   tf->codes[5508] = 0x000447c5e4f2c9cfUL;
   tf->codes[5509] = 0x000447c7f3f9fdbcUL;
   tf->codes[5510] = 0x000447c8de3614d0UL;
   tf->codes[5511] = 0x000447cc87267120UL;
   tf->codes[5512] = 0x000447d44e25354aUL;
   tf->codes[5513] = 0x000447de994938ebUL;
   tf->codes[5514] = 0x000447e66047fd15UL;
   tf->codes[5515] = 0x000447effbbeef67UL;
   tf->codes[5516] = 0x000447f2ba7334a3UL;
   tf->codes[5517] = 0x000447f419cd5741UL;
   tf->codes[5518] = 0x000447fba63d15a6UL;
   tf->codes[5519] = 0x000447fdb5444993UL;
   tf->codes[5520] = 0x0004483eabeeb01fUL;
   tf->codes[5521] = 0x0004483f962ac733UL;
   tf->codes[5522] = 0x000448400b48d2bdUL;
   tf->codes[5523] = 0x0004484d4fb0215fUL;
   tf->codes[5524] = 0x0004484e39ec3873UL;
   tf->codes[5525] = 0x000448580ff2308aUL;
   tf->codes[5526] = 0x0004485bf371929fUL;
   tf->codes[5527] = 0x000448772bed4132UL;
   tf->codes[5528] = 0x0004487850b85e0bUL;
   tf->codes[5529] = 0x000448905561bbd8UL;
   tf->codes[5530] = 0x00044894e88e2f3cUL;
   tf->codes[5531] = 0x0004489b5032d0c8UL;
   tf->codes[5532] = 0x0004489b8ac1d68dUL;
   tf->codes[5533] = 0x000448ac02fb75f5UL;
   tf->codes[5534] = 0x000448b9bc80d021UL;
   tf->codes[5535] = 0x000448e3d34cf5b9UL;
   tf->codes[5536] = 0x000448e40ddbfb7eUL;
   tf->codes[5537] = 0x000448e56d361e1cUL;
   tf->codes[5538] = 0x000448e5a7c523e1UL;
   tf->codes[5539] = 0x000448e98b4485f6UL;
   tf->codes[5540] = 0x000448ee1e70f95aUL;
   tf->codes[5541] = 0x000448ee938f04e4UL;
   tf->codes[5542] = 0x000448f2b19d6cbeUL;
   tf->codes[5543] = 0x000448f486159ae6UL;
   tf->codes[5544] = 0x00044905adfc4b9dUL;
   tf->codes[5545] = 0x000449091c5da228UL;
   tf->codes[5546] = 0x0004490956eca7edUL;
   tf->codes[5547] = 0x0004490c502ff2eeUL;
   tf->codes[5548] = 0x0004491a09b54d1aUL;
   tf->codes[5549] = 0x0004491f871dd792UL;
   tf->codes[5550] = 0x00044934cd12f023UL;
   tf->codes[5551] = 0x00044936a18b1e4bUL;
   tf->codes[5552] = 0x0004493800e540e9UL;
   tf->codes[5553] = 0x0004493c5982ae88UL;
   tf->codes[5554] = 0x0004493e2dfadcb0UL;
   tf->codes[5555] = 0x0004494d46da597aUL;
   tf->codes[5556] = 0x0004494ee0c381ddUL;
   tf->codes[5557] = 0x000449512a59bb8fUL;
   tf->codes[5558] = 0x000449533960ef7cUL;
   tf->codes[5559] = 0x00044954239d0690UL;
   tf->codes[5560] = 0x000449566d334042UL;
   tf->codes[5561] = 0x00044957576f5756UL;
   tf->codes[5562] = 0x00044958f1587fb9UL;
   tf->codes[5563] = 0x0004495a16239c92UL;
   tf->codes[5564] = 0x0004495d0f66e793UL;
   tf->codes[5565] = 0x0004496217b16681UL;
   tf->codes[5566] = 0x00044963ec2994a9UL;
   tf->codes[5567] = 0x0004496f96a7bae8UL;
   tf->codes[5568] = 0x000449721accfa5fUL;
   tf->codes[5569] = 0x0004498551badf03UL;
   tf->codes[5570] = 0x0004498760c212f0UL;
   tf->codes[5571] = 0x00044995c9f47e6bUL;
   tf->codes[5572] = 0x0004499ca6b72b81UL;
   tf->codes[5573] = 0x000449ab4a789cc1UL;
   tf->codes[5574] = 0x000449b3fbb377ffUL;
   tf->codes[5575] = 0x000449bfa6319e3eUL;
   tf->codes[5576] = 0x000449c01b4fa9c8UL;
   tf->codes[5577] = 0x000449c1efc7d7f0UL;
   tf->codes[5578] = 0x000449c4ae7c1d2cUL;
   tf->codes[5579] = 0x000449c907198acbUL;
   tf->codes[5580] = 0x000449cd2527f2a5UL;
   tf->codes[5581] = 0x000449d4b197b10aUL;
   tf->codes[5582] = 0x000449e85da3a138UL;
   tf->codes[5583] = 0x000449fc09af9166UL;
   tf->codes[5584] = 0x00044a1239e0c10bUL;
   tf->codes[5585] = 0x00044a12e98dd25aUL;
   tf->codes[5586] = 0x00044a135eabdde4UL;
   tf->codes[5587] = 0x00044a140e58ef33UL;
   tf->codes[5588] = 0x00044a1e1eeded0fUL;
   tf->codes[5589] = 0x00044a286a11f0b0UL;
   tf->codes[5590] = 0x00044a34149016efUL;
   tf->codes[5591] = 0x00044a495a852f80UL;
   tf->codes[5592] = 0x00044a649300de13UL;
   tf->codes[5593] = 0x00044a71d7682cb5UL;
   tf->codes[5594] = 0x00044a72c1a443c9UL;
   tf->codes[5595] = 0x00044a7420fe6667UL;
   tf->codes[5596] = 0x00044a7b38501942UL;
   tf->codes[5597] = 0x00044a7d0cc8476aUL;
   tf->codes[5598] = 0x00044a80f047a97fUL;
   tf->codes[5599] = 0x00044a84d3c70b94UL;
   tf->codes[5600] = 0x00044a8548e5171eUL;
   tf->codes[5601] = 0x00044a8beb18be6fUL;
   tf->codes[5602] = 0x00044a8c6036c9f9UL;
   tf->codes[5603] = 0x00044a9252bd5ffbUL;
   tf->codes[5604] = 0x00044a9f2206a313UL;
   tf->codes[5605] = 0x00044ab1e3d67c2dUL;
   tf->codes[5606] = 0x00044ab517a8ccf3UL;
   tf->codes[5607] = 0x00044ab7613f06a5UL;
   tf->codes[5608] = 0x00044abb7f4d6e7fUL;
   tf->codes[5609] = 0x00044abd53c59ca7UL;
   tf->codes[5610] = 0x00044abd8e54a26cUL;
   tf->codes[5611] = 0x00044ac3f5f943f8UL;
   tf->codes[5612] = 0x00044acd9170364aUL;
   tf->codes[5613] = 0x00044ad46e32e360UL;
   tf->codes[5614] = 0x00044ae1ed2937c7UL;
   tf->codes[5615] = 0x00044aea63d50d40UL;
   tf->codes[5616] = 0x00044aec72dc412dUL;
   tf->codes[5617] = 0x00044aed97a75e06UL;
   tf->codes[5618] = 0x00044af6be0044ceUL;
   tf->codes[5619] = 0x00044b02dd9c7697UL;
   tf->codes[5620] = 0x00044b03182b7c5cUL;
   tf->codes[5621] = 0x00044b043cf69935UL;
   tf->codes[5622] = 0x00044b0fe774bf74UL;
   tf->codes[5623] = 0x00044b16c4376c8aUL;
   tf->codes[5624] = 0x00044b1c0710f13dUL;
   tf->codes[5625] = 0x00044b205fae5edcUL;
   tf->codes[5626] = 0x00044b36555088bcUL;
   tf->codes[5627] = 0x00044b37b4aaab5aUL;
   tf->codes[5628] = 0x00044b3b982a0d6fUL;
   tf->codes[5629] = 0x00044b3fb6387549UL;
   tf->codes[5630] = 0x00044b3ff0c77b0eUL;
   tf->codes[5631] = 0x00044b4692fb225fUL;
   tf->codes[5632] = 0x00044b5620f8aab3UL;
   tf->codes[5633] = 0x00044b5a04780cc8UL;
   tf->codes[5634] = 0x00044b5b9e61352bUL;
   tf->codes[5635] = 0x00044b686daa7843UL;
   tf->codes[5636] = 0x00044b6ba17cc909UL;
   tf->codes[5637] = 0x00044b7ffd35ca86UL;
   tf->codes[5638] = 0x00044b895e1db713UL;
   tf->codes[5639] = 0x00044b8d7c2c1eedUL;
   tf->codes[5640] = 0x00044b8f8b3352daUL;
   tf->codes[5641] = 0x00044b8fc5c2589fUL;
   tf->codes[5642] = 0x00044b920f589251UL;
   tf->codes[5643] = 0x00044b9f53bfe0f3UL;
   tf->codes[5644] = 0x00044bb1a071ae83UL;
   tf->codes[5645] = 0x00044bb6a8bc2d71UL;
   tf->codes[5646] = 0x00044bb842a555d4UL;
   tf->codes[5647] = 0x00044bc044331fc3UL;
   tf->codes[5648] = 0x00044bc8badef53cUL;
   tf->codes[5649] = 0x00044bc92ffd00c6UL;
   tf->codes[5650] = 0x00044bdc2c5bdfa5UL;
   tf->codes[5651] = 0x00044beca4957f0dUL;
   tf->codes[5652] = 0x00044bee03efa1abUL;
   tf->codes[5653] = 0x00044beeee2bb8bfUL;
   tf->codes[5654] = 0x00044bf0c2a3e6e7UL;
   tf->codes[5655] = 0x00044bf3bbe731e8UL;
   tf->codes[5656] = 0x00044bfc32930761UL;
   tf->codes[5657] = 0x00044c060898ff78UL;
   tf->codes[5658] = 0x00044c0bc0908fb5UL;
   tf->codes[5659] = 0x00044c0dcf97c3a2UL;
   tf->codes[5660] = 0x00044c0e0a26c967UL;
   tf->codes[5661] = 0x00044c13fcad5f69UL;
   tf->codes[5662] = 0x00044c2f6fb813c1UL;
   tf->codes[5663] = 0x00044c3268fb5ec2UL;
   tf->codes[5664] = 0x00044c47e97f7d18UL;
   tf->codes[5665] = 0x00044c4ddc06131aUL;
   tf->codes[5666] = 0x00044c514a6769a5UL;
   tf->codes[5667] = 0x00044c54f357c5f5UL;
   tf->codes[5668] = 0x00044c5a36314aa8UL;
   tf->codes[5669] = 0x00044c5a70c0506dUL;
   tf->codes[5670] = 0x00044c5cf4e58fe4UL;
   tf->codes[5671] = 0x00044c5e19b0acbdUL;
   tf->codes[5672] = 0x00044c67efb6a4d4UL;
   tf->codes[5673] = 0x00044c68d9f2bbe8UL;
   tf->codes[5674] = 0x00044c6aae6aea10UL;
   tf->codes[5675] = 0x00044c6da7ae3511UL;
   tf->codes[5676] = 0x00044c7066627a4dUL;
   tf->codes[5677] = 0x00044c7693781614UL;
   tf->codes[5678] = 0x00044c7cfb1cb7a0UL;
   tf->codes[5679] = 0x00044c8c4e8b3a2fUL;
   tf->codes[5680] = 0x00044c90e1b7ad93UL;
   tf->codes[5681] = 0x00044c9b676ab6f9UL;
   tf->codes[5682] = 0x00044c9cc6c4d997UL;
   tf->codes[5683] = 0x00044ca9960e1cafUL;
   tf->codes[5684] = 0x00044cac8f5167b0UL;
   tf->codes[5685] = 0x00044caf1376a727UL;
   tf->codes[5686] = 0x00044cb0e7eed54fUL;
   tf->codes[5687] = 0x00044cba48d6c1dcUL;
   tf->codes[5688] = 0x00044cbd078b0718UL;
   tf->codes[5689] = 0x00044cc5b8c5e256UL;
   tf->codes[5690] = 0x00044cc6dd90ff2fUL;
   tf->codes[5691] = 0x00044cc83ceb21cdUL;
   tf->codes[5692] = 0x00044cd630ff81beUL;
   tf->codes[5693] = 0x00044cdb73d90671UL;
   tf->codes[5694] = 0x00044ce549defe88UL;
   tf->codes[5695] = 0x00044cf00a210db3UL;
   tf->codes[5696] = 0x00044cf28e464d2aUL;
   tf->codes[5697] = 0x00044cfdfe356da4UL;
   tf->codes[5698] = 0x00044d0b7d2bc20bUL;
   tf->codes[5699] = 0x00044d2ca82e06a0UL;
   tf->codes[5700] = 0x00044d2e7ca634c8UL;
   tf->codes[5701] = 0x00044d33fa0ebf40UL;
   tf->codes[5702] = 0x00044d37a2ff1b90UL;
   tf->codes[5703] = 0x00044d3bc10d836aUL;
   tf->codes[5704] = 0x00044d490574d20cUL;
   tf->codes[5705] = 0x00044d4cae652e5cUL;
   tf->codes[5706] = 0x00044d4d238339e6UL;
   tf->codes[5707] = 0x00044d4dd3304b35UL;
   tf->codes[5708] = 0x00044d5091e49071UL;
   tf->codes[5709] = 0x00044d56befa2c38UL;
   tf->codes[5710] = 0x00044d5e4b69ea9dUL;
   tf->codes[5711] = 0x00044d5ec087f627UL;
   tf->codes[5712] = 0x00044d5faac40d3bUL;
   tf->codes[5713] = 0x00044d6c3f7e4a8eUL;
   tf->codes[5714] = 0x00044d6e4e857e7bUL;
   tf->codes[5715] = 0x00044d73cbee08f3UL;
   tf->codes[5716] = 0x00044d911370eb73UL;
   tf->codes[5717] = 0x00044d9fb7325cb3UL;
   tf->codes[5718] = 0x00044da659660404UL;
   tf->codes[5719] = 0x00044dacfb99ab55UL;
   tf->codes[5720] = 0x00044dad3628b11aUL;
   tf->codes[5721] = 0x00044db328af471cUL;
   tf->codes[5722] = 0x00044dc958e076c1UL;
   tf->codes[5723] = 0x00044dce269befeaUL;
   tf->codes[5724] = 0x00044dced6490139UL;
   tf->codes[5725] = 0x00044dd194fd4675UL;
   tf->codes[5726] = 0x00044dd20a1b51ffUL;
   tf->codes[5727] = 0x00044dd244aa57c4UL;
   tf->codes[5728] = 0x00044dd48e409176UL;
   tf->codes[5729] = 0x00044dd95bfc0a9fUL;
   tf->codes[5730] = 0x00044ddc8fce5b65UL;
   tf->codes[5731] = 0x00044ddd7a0a7279UL;
   tf->codes[5732] = 0x00044ddffe2fb1f0UL;
   tf->codes[5733] = 0x00044de5f0b647f2UL;
   tf->codes[5734] = 0x00044defc6bc4009UL;
   tf->codes[5735] = 0x00044dfb36ab6083UL;
   tf->codes[5736] = 0x00044dfd45b29470UL;
   tf->codes[5737] = 0x00044e03e7e63bc1UL;
   tf->codes[5738] = 0x00044e0a8a19e312UL;
   tf->codes[5739] = 0x00044e0ac4a8e8d7UL;
   tf->codes[5740] = 0x00044e0b7455fa26UL;
   tf->codes[5741] = 0x00044e0f92646200UL;
   tf->codes[5742] = 0x00044e0fccf367c5UL;
   tf->codes[5743] = 0x00044e1007826d8aUL;
   tf->codes[5744] = 0x00044e166f270f16UL;
   tf->codes[5745] = 0x00044e1bec8f998eUL;
   tf->codes[5746] = 0x00044e23ee1d637dUL;
   tf->codes[5747] = 0x00044e300db99546UL;
   tf->codes[5748] = 0x00044e34db750e6fUL;
   tf->codes[5749] = 0x00044e396ea181d3UL;
   tf->codes[5750] = 0x00044e3acdfba471UL;
   tf->codes[5751] = 0x00044e3e3c5cfafcUL;
   tf->codes[5752] = 0x00044e3f9bb71d9aUL;
   tf->codes[5753] = 0x00044e43f4548b39UL;
   tf->codes[5754] = 0x00044e4553aeadd7UL;
   tf->codes[5755] = 0x00044e4d553c77c6UL;
   tf->codes[5756] = 0x00044e5a99a3c668UL;
   tf->codes[5757] = 0x00044e60170c50e0UL;
   tf->codes[5758] = 0x00044e6559e5d593UL;
   tf->codes[5759] = 0x00044e6b4c6c6b95UL;
   tf->codes[5760] = 0x00044e6b86fb715aUL;
   tf->codes[5761] = 0x00044e6dd091ab0cUL;
   tf->codes[5762] = 0x00044e7ada69f3e9UL;
   tf->codes[5763] = 0x00044e81077f8fb0UL;
   tf->codes[5764] = 0x00044e81b72ca0ffUL;
   tf->codes[5765] = 0x00044e881ed1428bUL;
   tf->codes[5766] = 0x00044e8fab4100f0UL;
   tf->codes[5767] = 0x00044e99f6650491UL;
   tf->codes[5768] = 0x00044e9dd9e466a6UL;
   tf->codes[5769] = 0x00044e9f393e8944UL;
   tf->codes[5770] = 0x00044eb4b9c2a79aUL;
   tf->codes[5771] = 0x00044ebc80c16bc4UL;
   tf->codes[5772] = 0x00044ec3d2a22464UL;
   tf->codes[5773] = 0x00044ec4bcde3b78UL;
   tf->codes[5774] = 0x00044ec61c385e16UL;
   tf->codes[5775] = 0x00044ecc83dcffa2UL;
   tf->codes[5776] = 0x00044ed1519878cbUL;
   tf->codes[5777] = 0x00044ed77eae1492UL;
   tf->codes[5778] = 0x00044ed918973cf5UL;
   tf->codes[5779] = 0x00044eda3d6259ceUL;
   tf->codes[5780] = 0x00044ede5b70c1a8UL;
   tf->codes[5781] = 0x00044ee18f43126eUL;
   tf->codes[5782] = 0x00044ef53b4f029cUL;
   tf->codes[5783] = 0x00044ef834924d9dUL;
   tf->codes[5784] = 0x00044ef8a9b05927UL;
   tf->codes[5785] = 0x00044efd024dc6c6UL;
   tf->codes[5786] = 0x00044efed6c5f4eeUL;
   tf->codes[5787] = 0x00044f08723ce740UL;
   tf->codes[5788] = 0x00044f08e75af2caUL;
   tf->codes[5789] = 0x00044f0c1b2d4390UL;
   tf->codes[5790] = 0x00044f1db831ffd1UL;
   tf->codes[5791] = 0x00044f1f178c226fUL;
   tf->codes[5792] = 0x00044f24cf83b2acUL;
   tf->codes[5793] = 0x00044f2753a8f223UL;
   tf->codes[5794] = 0x00044f299d3f2bd5UL;
   tf->codes[5795] = 0x00044f2b71b759fdUL;
   tf->codes[5796] = 0x00044f3129aeea3aUL;
   tf->codes[5797] = 0x00044f3756c48601UL;
   tf->codes[5798] = 0x00044f392b3cb429UL;
   tf->codes[5799] = 0x00044f3a8a96d6c7UL;
   tf->codes[5800] = 0x00044f3f58524ff0UL;
   tf->codes[5801] = 0x00044f48441c30f3UL;
   tf->codes[5802] = 0x00044f4eabc0d27fUL;
   tf->codes[5803] = 0x00044f5045a9fae2UL;
   tf->codes[5804] = 0x00044f55c312855aUL;
   tf->codes[5805] = 0x00044f58bc55d05bUL;
   tf->codes[5806] = 0x00044f5c9fd53270UL;
   tf->codes[5807] = 0x00044f630779d3fcUL;
   tf->codes[5808] = 0x00044f6600bd1efdUL;
   tf->codes[5809] = 0x00044f6b4396a3b0UL;
   tf->codes[5810] = 0x00044f6e7768f476UL;
   tf->codes[5811] = 0x00044f6f9c34114fUL;
   tf->codes[5812] = 0x00044f758ebaa751UL;
   tf->codes[5813] = 0x00044f89003791baUL;
   tf->codes[5814] = 0x00044f8b0f3ec5a7UL;
   tf->codes[5815] = 0x00044f8bbeebd6f6UL;
   tf->codes[5816] = 0x00044f8d1e45f994UL;
   tf->codes[5817] = 0x00044f93c079a0e5UL;
   tf->codes[5818] = 0x00044f9ef5d9bb9aUL;
   tf->codes[5819] = 0x00044fa4e860519cUL;
   tf->codes[5820] = 0x00044fb0cd6d7da0UL;
   tf->codes[5821] = 0x00044fb6fa831967UL;
   tf->codes[5822] = 0x00044fbc02cd9855UL;
   tf->codes[5823] = 0x00044fbefc10e356UL;
   tf->codes[5824] = 0x00044fc981c3ecbcUL;
   tf->codes[5825] = 0x00044fca6c0003d0UL;
   tf->codes[5826] = 0x00044fd7b0675272UL;
   tf->codes[5827] = 0x00044fd89aa36986UL;
   tf->codes[5828] = 0x00044fdc7e22cb9bUL;
   tf->codes[5829] = 0x00044fe35ae578b1UL;
   tf->codes[5830] = 0x00044fe4f4cea114UL;
   tf->codes[5831] = 0x00044fea72372b8cUL;
   tf->codes[5832] = 0x00044ff02a2ebbc9UL;
   tf->codes[5833] = 0x00044ff482cc2968UL;
   tf->codes[5834] = 0x00044ff8664b8b7dUL;
   tf->codes[5835] = 0x00044ffb24ffd0b9UL;
   tf->codes[5836] = 0x000450098e323c34UL;
   tf->codes[5837] = 0x0004500d37229884UL;
   tf->codes[5838] = 0x0004501279fc1d37UL;
   tf->codes[5839] = 0x00045017bcd5a1eaUL;
   tf->codes[5840] = 0x0004501e99984f00UL;
   tf->codes[5841] = 0x0004501f0eb65a8aUL;
   tf->codes[5842] = 0x0004502710442479UL;
   tf->codes[5843] = 0x000450286f9e4717UL;
   tf->codes[5844] = 0x0004502b2e528c53UL;
   tf->codes[5845] = 0x00045035b40595b9UL;
   tf->codes[5846] = 0x00045047167b4c35UL;
   tf->codes[5847] = 0x0004504d4390e7fcUL;
   tf->codes[5848] = 0x0004504e2dccff10UL;
   tf->codes[5849] = 0x0004505002452d38UL;
   tf->codes[5850] = 0x000450503cd432fdUL;
   tf->codes[5851] = 0x0004505370a683c3UL;
   tf->codes[5852] = 0x0004505803d2f727UL;
   tf->codes[5853] = 0x000450775a5d0d94UL;
   tf->codes[5854] = 0x0004507e371fbaaaUL;
   tf->codes[5855] = 0x00045083b4884522UL;
   tf->codes[5856] = 0x0004508429a650acUL;
   tf->codes[5857] = 0x0004508931f0cf9aUL;
   tf->codes[5858] = 0x000450a51a198f7cUL;
   tf->codes[5859] = 0x000450af9fcc98e2UL;
   tf->codes[5860] = 0x000450b25e80de1eUL;
   tf->codes[5861] = 0x000450b975d290f9UL;
   tf->codes[5862] = 0x000450be08ff045dUL;
   tf->codes[5863] = 0x000450c55adfbcfdUL;
   tf->codes[5864] = 0x000450c903d0194dUL;
   tf->codes[5865] = 0x000450c9b37d2a9cUL;
   tf->codes[5866] = 0x000450c9ee0c3061UL;
   tf->codes[5867] = 0x000450d29f470b9fUL;
   tf->codes[5868] = 0x000450d8573e9bdcUL;
   tf->codes[5869] = 0x000450dd24fa1505UL;
   tf->codes[5870] = 0x000450dfa91f547cUL;
   tf->codes[5871] = 0x000450e685e20192UL;
   tf->codes[5872] = 0x000450ec3dd991cfUL;
   tf->codes[5873] = 0x000450f05be7f9a9UL;
   tf->codes[5874] = 0x000450f8d293cf22UL;
   tf->codes[5875] = 0x000450fb56b90e99UL;
   tf->codes[5876] = 0x000450fb9148145eUL;
   tf->codes[5877] = 0x000450fe8a8b5f5fUL;
   tf->codes[5878] = 0x0004510aaa279128UL;
   tf->codes[5879] = 0x0004510f77e30a51UL;
   tf->codes[5880] = 0x00045113d08077f0UL;
   tf->codes[5881] = 0x00045118d8caf6deUL;
   tf->codes[5882] = 0x0004511ae7d22acbUL;
   tf->codes[5883] = 0x0004511c472c4d69UL;
   tf->codes[5884] = 0x000451209fc9bb08UL;
   tf->codes[5885] = 0x0004512d3483f85bUL;
   tf->codes[5886] = 0x0004512da9a203e5UL;
   tf->codes[5887] = 0x00045130dd7454abUL;
   tf->codes[5888] = 0x00045132023f7184UL;
   tf->codes[5889] = 0x0004513aee095287UL;
   tf->codes[5890] = 0x0004513c12d46f60UL;
   tf->codes[5891] = 0x0004513c4d637525UL;
   tf->codes[5892] = 0x0004513f0c17ba61UL;
   tf->codes[5893] = 0x000451427a7910ecUL;
   tf->codes[5894] = 0x00045143d9d3338aUL;
   tf->codes[5895] = 0x00045148a78eacb3UL;
   tf->codes[5896] = 0x0004514d002c1a52UL;
   tf->codes[5897] = 0x000451532d41b619UL;
   tf->codes[5898] = 0x00045156d6321269UL;
   tf->codes[5899] = 0x00045158358c3507UL;
   tf->codes[5900] = 0x0004515f124ee21dUL;
   tf->codes[5901] = 0x000451641a99610bUL;
   tf->codes[5902] = 0x00045167fe18c320UL;
   tf->codes[5903] = 0x00045168adc5d46fUL;
   tf->codes[5904] = 0x0004516df09f5922UL;
   tf->codes[5905] = 0x00045171d41ebb37UL;
   tf->codes[5906] = 0x00045175b79e1d4cUL;
   tf->codes[5907] = 0x000451783bc35cc3UL;
   tf->codes[5908] = 0x0004517abfe89c3aUL;
   tf->codes[5909] = 0x0004518420d088c7UL;
   tf->codes[5910] = 0x00045191da55e2f3UL;
   tf->codes[5911] = 0x000451966d825657UL;
   tf->codes[5912] = 0x0004519e34811a81UL;
   tf->codes[5913] = 0x000451a6360ee470UL;
   tf->codes[5914] = 0x000451a6e5bbf5bfUL;
   tf->codes[5915] = 0x000451a80a871298UL;
   tf->codes[5916] = 0x000451adc27ea2d5UL;
   tf->codes[5917] = 0x000451b42a234461UL;
   tf->codes[5918] = 0x000451b6ae4883d8UL;
   tf->codes[5919] = 0x000451c049bf762aUL;
   tf->codes[5920] = 0x000451ce0344d056UL;
   tf->codes[5921] = 0x000451cf9d2df8b9UL;
   tf->codes[5922] = 0x000451d938a4eb0bUL;
   tf->codes[5923] = 0x000451dad28e136eUL;
   tf->codes[5924] = 0x000451db823b24bdUL;
   tf->codes[5925] = 0x000451f386e4828aUL;
   tf->codes[5926] = 0x000451f72fd4dedaUL;
   tf->codes[5927] = 0x000451f81a10f5eeUL;
   tf->codes[5928] = 0x000451fef6d3a304UL;
   tf->codes[5929] = 0x000451ffa680b453UL;
   tf->codes[5930] = 0x0004520941f7a6a5UL;
   tf->codes[5931] = 0x00045217ab2a1220UL;
   tf->codes[5932] = 0x000452190a8434beUL;
   tf->codes[5933] = 0x0004521adefc62e6UL;
   tf->codes[5934] = 0x00045229482ece61UL;
   tf->codes[5935] = 0x0004522b1ca6fc89UL;
   tf->codes[5936] = 0x000452310f2d928bUL;
   tf->codes[5937] = 0x00045232e3a5c0b3UL;
   tf->codes[5938] = 0x00045235a25a05efUL;
   tf->codes[5939] = 0x000452389b9d50f0UL;
   tf->codes[5940] = 0x0004523bcf6fa1b6UL;
   tf->codes[5941] = 0x0004523cf43abe8fUL;
   tf->codes[5942] = 0x0004523f0341f27cUL;
   tf->codes[5943] = 0x00045243966e65e0UL;
   tf->codes[5944] = 0x00045244f5c8887eUL;
   tf->codes[5945] = 0x0004524704cfbc6bUL;
   tf->codes[5946] = 0x0004524779edc7f5UL;
   tf->codes[5947] = 0x000452518a82c5d1UL;
   tf->codes[5948] = 0x000452561daf3935UL;
   tf->codes[5949] = 0x0004526327878212UL;
   tf->codes[5950] = 0x00045268df7f124fUL;
   tf->codes[5951] = 0x0004526fbc41bf65UL;
   tf->codes[5952] = 0x00045270a67dd679UL;
   tf->codes[5953] = 0x0004527365321bb5UL;
   tf->codes[5954] = 0x0004527ab712d455UL;
   tf->codes[5955] = 0x00045282b8a09e44UL;
   tf->codes[5956] = 0x00045283dd6bbb1dUL;
   tf->codes[5957] = 0x0004528d3e53a7aaUL;
   tf->codes[5958] = 0x0004528e631ec483UL;
   tf->codes[5959] = 0x0004528f12cbd5d2UL;
   tf->codes[5960] = 0x0004529196f11549UL;
   tf->codes[5961] = 0x000452969f3b9437UL;
   tf->codes[5962] = 0x000452aa10b87ea0UL;
   tf->codes[5963] = 0x000452ac94ddbe17UL;
   tf->codes[5964] = 0x000452aede73f7c9UL;
   tf->codes[5965] = 0x000452c374bbff0bUL;
   tf->codes[5966] = 0x000452c807e8726fUL;
   tf->codes[5967] = 0x000452ceaa1c19c0UL;
   tf->codes[5968] = 0x000452d302b9875fUL;
   tf->codes[5969] = 0x000452da8f2945c4UL;
   tf->codes[5970] = 0x000452dc9e3079b1UL;
   tf->codes[5971] = 0x000452fb0a7e790aUL;
   tf->codes[5972] = 0x00045308fe92d8fbUL;
   tf->codes[5973] = 0x0004531349b6dc9cUL;
   tf->codes[5974] = 0x0004531852015b8aUL;
   tf->codes[5975] = 0x0004531e4487f18cUL;
   tf->codes[5976] = 0x0004532b4e603a69UL;
   tf->codes[5977] = 0x0004532e47a3856aUL;
   tf->codes[5978] = 0x0004533265b1ed44UL;
   tf->codes[5979] = 0x0004534e134ba761UL;
   tf->codes[5980] = 0x000453531b96264fUL;
   tf->codes[5981] = 0x000453590e1cbc51UL;
   tf->codes[5982] = 0x0004535a6d76deefUL;
   tf->codes[5983] = 0x0004535c07600752UL;
   tf->codes[5984] = 0x000453623475a319UL;
   tf->codes[5985] = 0x00045362a993aea3UL;
   tf->codes[5986] = 0x000453689c1a44a5UL;
   tf->codes[5987] = 0x0004537ae8cc1235UL;
   tf->codes[5988] = 0x0004537f41697fd4UL;
   tf->codes[5989] = 0x000453818affb986UL;
   tf->codes[5990] = 0x00045390a3df3650UL;
   tf->codes[5991] = 0x00045392033958eeUL;
   tf->codes[5992] = 0x00045398304ef4b5UL;
   tf->codes[5993] = 0x0004539b29923fb6UL;
   tf->codes[5994] = 0x0004539bd93f5105UL;
   tf->codes[5995] = 0x000453a783bd7744UL;
   tf->codes[5996] = 0x000453b32e3b9d83UL;
   tf->codes[5997] = 0x000453babaab5be8UL;
   tf->codes[5998] = 0x000453bdb3eea6e9UL;
   tf->codes[5999] = 0x000453c69fb887ecUL;
   tf->codes[6000] = 0x000453d284c5b3f0UL;
   tf->codes[6001] = 0x000453e87a67ddd0UL;
   tf->codes[6002] = 0x000453ed0d945134UL;
   tf->codes[6003] = 0x000453ee6cee73d2UL;
   tf->codes[6004] = 0x000453eee20c7f5cUL;
   tf->codes[6005] = 0x000453fbb155c274UL;
   tf->codes[6006] = 0x000453fc9b91d988UL;
   tf->codes[6007] = 0x000454067197d19fUL;
   tf->codes[6008] = 0x00045408460fffc7UL;
   tf->codes[6009] = 0x0004540fd27fbe2cUL;
   tf->codes[6010] = 0x000454121c15f7deUL;
   tf->codes[6011] = 0x0004541256a4fda3UL;
   tf->codes[6012] = 0x000454142b1d2bcbUL;
   tf->codes[6013] = 0x0004541674b3657dUL;
   tf->codes[6014] = 0x00045419e314bc08UL;
   tf->codes[6015] = 0x0004541eb0d03531UL;
   tf->codes[6016] = 0x00045427d7291bf9UL;
   tf->codes[6017] = 0x0004542e043eb7c0UL;
   tf->codes[6018] = 0x00045439399ed275UL;
   tf->codes[6019] = 0x00045439aebcddffUL;
   tf->codes[6020] = 0x0004543e7c785728UL;
   tf->codes[6021] = 0x0004543f66b46e3cUL;
   tf->codes[6022] = 0x0004545521c79257UL;
   tf->codes[6023] = 0x00045455d174a3a6UL;
   tf->codes[6024] = 0x00045457a5ecd1ceUL;
   tf->codes[6025] = 0x0004545e82af7ee4UL;
   tf->codes[6026] = 0x0004546a2d2da523UL;
   tf->codes[6027] = 0x00045472694a74d7UL;
   tf->codes[6028] = 0x00045477e6b2ff4fUL;
   tf->codes[6029] = 0x0004547aa567448bUL;
   tf->codes[6030] = 0x0004547f3893b7efUL;
   tf->codes[6031] = 0x0004547fadb1c379UL;
   tf->codes[6032] = 0x00045484b5fc4267UL;
   tf->codes[6033] = 0x0004548cb78a0c56UL;
   tf->codes[6034] = 0x0004548e16e42ef4UL;
   tf->codes[6035] = 0x0004548ec6914043UL;
   tf->codes[6036] = 0x000454a77ae7af5fUL;
   tf->codes[6037] = 0x000454bbd6a0b0dcUL;
   tf->codes[6038] = 0x000454caef802da6UL;
   tf->codes[6039] = 0x000454d5afc23cd1UL;
   tf->codes[6040] = 0x000454dab80cbbbfUL;
   tf->codes[6041] = 0x000454e6d7a8ed88UL;
   tf->codes[6042] = 0x000454ea0b7b3e4eUL;
   tf->codes[6043] = 0x000454f5064c533eUL;
   tf->codes[6044] = 0x000454fb3361ef05UL;
   tf->codes[6045] = 0x000454fd426922f2UL;
   tf->codes[6046] = 0x00045502fa60b32fUL;
   tf->codes[6047] = 0x00045509620554bbUL;
   tf->codes[6048] = 0x00045513e7b85e21UL;
   tf->codes[6049] = 0x000455333e42748eUL;
   tf->codes[6050] = 0x0004553378d17a53UL;
   tf->codes[6051] = 0x0004553acab232f3UL;
   tf->codes[6052] = 0x0004553b054138b8UL;
   tf->codes[6053] = 0x000455458af4421eUL;
   tf->codes[6054] = 0x0004554884378d1fUL;
   tf->codes[6055] = 0x00045550fae36298UL;
   tf->codes[6056] = 0x0004555309ea9685UL;
   tf->codes[6057] = 0x0004555812351573UL;
   tf->codes[6058] = 0x00045560fdfef676UL;
   tf->codes[6059] = 0x000455646c604d01UL;
   tf->codes[6060] = 0x00045568c4fdbaa0UL;
   tf->codes[6061] = 0x0004556a9975e8c8UL;
   tf->codes[6062] = 0x0004556b4922fa17UL;
   tf->codes[6063] = 0x00045572d592b87cUL;
   tf->codes[6064] = 0x0004557643f40f07UL;
   tf->codes[6065] = 0x00045583885b5da9UL;
   tf->codes[6066] = 0x000455860c809d20UL;
   tf->codes[6067] = 0x0004558b89e92798UL;
   tf->codes[6068] = 0x000455909233a686UL;
   tf->codes[6069] = 0x0004559684ba3c88UL;
   tf->codes[6070] = 0x00045598ce50763aUL;
   tf->codes[6071] = 0x000455a6fcf3dbf0UL;
   tf->codes[6072] = 0x000455a9bba8212cUL;
   tf->codes[6073] = 0x000455ad9f278341UL;
   tf->codes[6074] = 0x000455bc42e8f481UL;
   tf->codes[6075] = 0x000455c3cf58b2e6UL;
   tf->codes[6076] = 0x000455c7b2d814fbUL;
   tf->codes[6077] = 0x000455d865a0ba28UL;
   tf->codes[6078] = 0x000455db2454ff64UL;
   tf->codes[6079] = 0x000455f18f1534ceUL;
   tf->codes[6080] = 0x000455fe23cf7221UL;
   tf->codes[6081] = 0x000455ffbdb89a84UL;
   tf->codes[6082] = 0x00045600e283b75dUL;
   tf->codes[6083] = 0x000456027c6cdfc0UL;
   tf->codes[6084] = 0x00045603dbc7025eUL;
   tf->codes[6085] = 0x00045604c6031972UL;
   tf->codes[6086] = 0x0004560e26eb05ffUL;
   tf->codes[6087] = 0x0004561578cbbe9fUL;
   tf->codes[6088] = 0x0004561ba5e15a66UL;
   tf->codes[6089] = 0x0004561db4e88e53UL;
   tf->codes[6090] = 0x0004562282a4077cUL;
   tf->codes[6091] = 0x0004562edccf3f0aUL;
   tf->codes[6092] = 0x000456341fa8c3bdUL;
   tf->codes[6093] = 0x0004563b71897c5dUL;
   tf->codes[6094] = 0x00045641d92e1de9UL;
   tf->codes[6095] = 0x0004564d83ac4428UL;
   tf->codes[6096] = 0x0004565425dfeb79UL;
   tf->codes[6097] = 0x00045655101c028dUL;
   tf->codes[6098] = 0x000456571f23367aUL;
   tf->codes[6099] = 0x0004565843ee5353UL;
   tf->codes[6100] = 0x0004565a52f58740UL;
   tf->codes[6101] = 0x000456625483512fUL;
   tf->codes[6102] = 0x0004566bb56b3dbcUL;
   tf->codes[6103] = 0x00045672922dead2UL;
   tf->codes[6104] = 0x00045673b6f907abUL;
   tf->codes[6105] = 0x0004567dc78e0587UL;
   tf->codes[6106] = 0x00045686ede6ec4fUL;
   tf->codes[6107] = 0x00045688fcee203cUL;
   tf->codes[6108] = 0x0004569382a129a2UL;
   tf->codes[6109] = 0x00045693f7bf352cUL;
   tf->codes[6110] = 0x0004569a24d4d0f3UL;
   tf->codes[6111] = 0x0004569e7d723e92UL;
   tf->codes[6112] = 0x000456a609e1fcf7UL;
   tf->codes[6113] = 0x000456a7a3cb255aUL;
   tf->codes[6114] = 0x000456ace6a4aa0dUL;
   tf->codes[6115] = 0x000456afa558ef49UL;
   tf->codes[6116] = 0x000456b3c3675723UL;
   tf->codes[6117] = 0x000456b7e175befdUL;
   tf->codes[6118] = 0x000456c525dd0d9fUL;
   tf->codes[6119] = 0x000456d1ba974af2UL;
   tf->codes[6120] = 0x000456d1f52650b7UL;
   tf->codes[6121] = 0x000456d8d1e8fdcdUL;
   tf->codes[6122] = 0x000456db560e3d44UL;
   tf->codes[6123] = 0x000456dd2a866b6cUL;
   tf->codes[6124] = 0x000456dec46f93cfUL;
   tf->codes[6125] = 0x000456e1bdb2ded0UL;
   tf->codes[6126] = 0x000456e4b6f629d1UL;
   tf->codes[6127] = 0x000456e89a758be6UL;
   tf->codes[6128] = 0x000456e9f9cfae84UL;
   tf->codes[6129] = 0x000456eb93b8d6e7UL;
   tf->codes[6130] = 0x000456ee8cfc21e8UL;
   tf->codes[6131] = 0x000456f3cfd5a69bUL;
   tf->codes[6132] = 0x00045701895b00c7UL;
   tf->codes[6133] = 0x00045701fe790c51UL;
   tf->codes[6134] = 0x000457077be196c9UL;
   tf->codes[6135] = 0x0004570b5f60f8deUL;
   tf->codes[6136] = 0x00045713d60cce57UL;
   tf->codes[6137] = 0x0004571a3db16fe3UL;
   tf->codes[6138] = 0x00045728a6e3db5eUL;
   tf->codes[6139] = 0x0004572af07a1510UL;
   tf->codes[6140] = 0x0004572ff8c493feUL;
   tf->codes[6141] = 0x0004573785345263UL;
   tf->codes[6142] = 0x0004573c1860c5c7UL;
   tf->codes[6143] = 0x0004576ac2595ec3UL;
   tf->codes[6144] = 0x0004578dc1d3d180UL;
   tf->codes[6145] = 0x0004579dc4ef655eUL;
   tf->codes[6146] = 0x0004579ee9ba8237UL;
   tf->codes[6147] = 0x000457b728f2e5c9UL;
   tf->codes[6148] = 0x000457bad1e34219UL;
   tf->codes[6149] = 0x000457be05b592dfUL;
   tf->codes[6150] = 0x000457c04f4bcc91UL;
   tf->codes[6151] = 0x000457c3488f1792UL;
   tf->codes[6152] = 0x000457c90086a7cfUL;
   tf->codes[6153] = 0x000457ce08d126bdUL;
   tf->codes[6154] = 0x000457d7a448190fUL;
   tf->codes[6155] = 0x000457db4d38755fUL;
   tf->codes[6156] = 0x000457e6bd2795d9UL;
   tf->codes[6157] = 0x000457e97bdbdb15UL;
   tf->codes[6158] = 0x000457ebc57214c7UL;
   tf->codes[6159] = 0x000457ed5f5b3d2aUL;
   tf->codes[6160] = 0x000457f4ebcafb8fUL;
   tf->codes[6161] = 0x000457fade519191UL;
   tf->codes[6162] = 0x000457fb536f9d1bUL;
   tf->codes[6163] = 0x000457fe8741ede1UL;
   tf->codes[6164] = 0x0004580897d6ebbdUL;
   tf->codes[6165] = 0x0004580aa6de1faaUL;
   tf->codes[6166] = 0x0004580ae16d256fUL;
   tf->codes[6167] = 0x0004580b1bfc2b34UL;
   tf->codes[6168] = 0x0004580b568b30f9UL;
   tf->codes[6169] = 0x0004580bcba93c83UL;
   tf->codes[6170] = 0x00045814f202234bUL;
   tf->codes[6171] = 0x00045817eb456e4cUL;
   tf->codes[6172] = 0x0004581a34dba7feUL;
   tf->codes[6173] = 0x00045827b3d1fc65UL;
   tf->codes[6174] = 0x0004582d313a86ddUL;
   tf->codes[6175] = 0x00045834bdaa4542UL;
   tf->codes[6176] = 0x0004583c4a1a03a7UL;
   tf->codes[6177] = 0x0004583f08ce48e3UL;
   tf->codes[6178] = 0x00045840a2b77146UL;
   tf->codes[6179] = 0x0004584117d57cd0UL;
   tf->codes[6180] = 0x00045848a4453b35UL;
   tf->codes[6181] = 0x0004584c87c49d4aUL;
   tf->codes[6182] = 0x0004584d7200b45eUL;
   tf->codes[6183] = 0x00045851ca9e21fdUL;
   tf->codes[6184] = 0x0004585a06baf1b1UL;
   tf->codes[6185] = 0x0004585f84237c29UL;
   tf->codes[6186] = 0x00045863dcc0e9c8UL;
   tf->codes[6187] = 0x0004586451def552UL;
   tf->codes[6188] = 0x000458774e3dd431UL;
   tf->codes[6189] = 0x00045877c35bdfbbUL;
   tf->codes[6190] = 0x0004588afa49c45fUL;
   tf->codes[6191] = 0x0004589719e5f628UL;
   tf->codes[6192] = 0x000458a6e2728441UL;
   tf->codes[6193] = 0x000458abb02dfd6aUL;
   tf->codes[6194] = 0x000458b58633f581UL;
   tf->codes[6195] = 0x000458b92f2451d1UL;
   tf->codes[6196] = 0x000458bdc250c535UL;
   tf->codes[6197] = 0x000458be71fdd684UL;
   tf->codes[6198] = 0x000458c429f566c1UL;
   tf->codes[6199] = 0x000458c9e1ecf6feUL;
   tf->codes[6200] = 0x000458cbf0f42aebUL;
   tf->codes[6201] = 0x000458cdc56c5913UL;
   tf->codes[6202] = 0x000458d21e09c6b2UL;
   tf->codes[6203] = 0x000458d5c6fa2302UL;
   tf->codes[6204] = 0x000458d6b1363a16UL;
   tf->codes[6205] = 0x000458d760e34b65UL;
   tf->codes[6206] = 0x000458d8facc73c8UL;
   tf->codes[6207] = 0x000458e345f07769UL;
   tf->codes[6208] = 0x000458eb477e4158UL;
   tf->codes[6209] = 0x000458ee06328694UL;
   tf->codes[6210] = 0x000458f6424f5648UL;
   tf->codes[6211] = 0x0004590311989960UL;
   tf->codes[6212] = 0x0004590fe0e1dc78UL;
   tf->codes[6213] = 0x00045914740e4fdcUL;
   tf->codes[6214] = 0x00045914ae9d55a1UL;
   tf->codes[6215] = 0x00045919073ac340UL;
   tf->codes[6216] = 0x00045919b6e7d48fUL;
   tf->codes[6217] = 0x00045926863117a7UL;
   tf->codes[6218] = 0x00045926fb4f2331UL;
   tf->codes[6219] = 0x00045930d1551b48UL;
   tf->codes[6220] = 0x000459347a457798UL;
   tf->codes[6221] = 0x000459439324f462UL;
   tf->codes[6222] = 0x00045946c6f74528UL;
   tf->codes[6223] = 0x0004594cb97ddb2aUL;
   tf->codes[6224] = 0x00045957eeddf5dfUL;
   tf->codes[6225] = 0x0004595b22b046a5UL;
   tf->codes[6226] = 0x0004595ff06bbfceUL;
   tf->codes[6227] = 0x00045962af20050aUL;
   tf->codes[6228] = 0x0004597152e1764aUL;
   tf->codes[6229] = 0x0004597b63767426UL;
   tf->codes[6230] = 0x0004597cc2d096c4UL;
   tf->codes[6231] = 0x0004597e222ab962UL;
   tf->codes[6232] = 0x0004598698d68edbUL;
   tf->codes[6233] = 0x0004598c8b5d24ddUL;
   tf->codes[6234] = 0x0004598e9a6458caUL;
   tf->codes[6235] = 0x000459a57a4299beUL;
   tf->codes[6236] = 0x000459b4cdb11c4dUL;
   tf->codes[6237] = 0x000459ba108aa100UL;
   tf->codes[6238] = 0x000459bac037b24fUL;
   tf->codes[6239] = 0x000459c58079c17aUL;
   tf->codes[6240] = 0x000459c754f1efa2UL;
   tf->codes[6241] = 0x000459d6a8607231UL;
   tf->codes[6242] = 0x000459d87cd8a059UL;
   tf->codes[6243] = 0x000459db00fddfd0UL;
   tf->codes[6244] = 0x000459eb041973aeUL;
   tf->codes[6245] = 0x000459efd1d4ecd7UL;
   tf->codes[6246] = 0x000459f2cb1837d8UL;
   tf->codes[6247] = 0x000459f514ae718aUL;
   tf->codes[6248] = 0x000459fcdbad35b4UL;
   tf->codes[6249] = 0x00045a0d8e75dae1UL;
   tf->codes[6250] = 0x00045a0eb340f7baUL;
   tf->codes[6251] = 0x00045a17647bd2f8UL;
   tf->codes[6252] = 0x00045a3262687bc6UL;
   tf->codes[6253] = 0x00045a3436e0a9eeUL;
   tf->codes[6254] = 0x00045a40567cdbb7UL;
   tf->codes[6255] = 0x00045a434fc026b8UL;
   tf->codes[6256] = 0x00045a46be217d43UL;
   tf->codes[6257] = 0x00045a57e6082dfaUL;
   tf->codes[6258] = 0x00045a5b19da7ec0UL;
   tf->codes[6259] = 0x00045a6355f74e74UL;
   tf->codes[6260] = 0x00045a685e41cd62UL;
   tf->codes[6261] = 0x00045a6b1cf6129eUL;
   tf->codes[6262] = 0x00045a6c41c12f77UL;
   tf->codes[6263] = 0x00045a78d67b6ccaUL;
   tf->codes[6264] = 0x00045a7aaaf39af2UL;
   tf->codes[6265] = 0x00045a7bcfbeb7cbUL;
   tf->codes[6266] = 0x00045a809d7a30f4UL;
   tf->codes[6267] = 0x00045a8530a6a458UL;
   tf->codes[6268] = 0x00045a8ecc1d96aaUL;
   tf->codes[6269] = 0x00045a98679488fcUL;
   tf->codes[6270] = 0x00045aafbc90d57aUL;
   tf->codes[6271] = 0x00045ab4ff6a5a2dUL;
   tf->codes[6272] = 0x00045ab7be1e9f69UL;
   tf->codes[6273] = 0x00045ab8e2e9bc42UL;
   tf->codes[6274] = 0x00045aba07b4d91bUL;
   tf->codes[6275] = 0x00045abdeb343b30UL;
   tf->codes[6276] = 0x00045abe25c340f5UL;
   tf->codes[6277] = 0x00045ac3689cc5a8UL;
   tf->codes[6278] = 0x00045ac3ddbad132UL;
   tf->codes[6279] = 0x00045ac870e74496UL;
   tf->codes[6280] = 0x00045ac9d0416734UL;
   tf->codes[6281] = 0x00045adabd991226UL;
   tf->codes[6282] = 0x00045ae24a08d08bUL;
   tf->codes[6283] = 0x00045ae28497d650UL;
   tf->codes[6284] = 0x00045ae6dd3543efUL;
   tf->codes[6285] = 0x00045aedf486f6caUL;
   tf->codes[6286] = 0x00045aee2f15fc8fUL;
   tf->codes[6287] = 0x00045aeedec30ddeUL;
   tf->codes[6288] = 0x00045afc5db96245UL;
   tf->codes[6289] = 0x00045afe6cc09632UL;
   tf->codes[6290] = 0x00045b128dea91eaUL;
   tf->codes[6291] = 0x00045b1d88bba6daUL;
   tf->codes[6292] = 0x00045b1fd251e08cUL;
   tf->codes[6293] = 0x00045b2dc666407dUL;
   tf->codes[6294] = 0x00045b2eeb315d56UL;
   tf->codes[6295] = 0x00045b2f25c0631bUL;
   tf->codes[6296] = 0x00045b47da16d237UL;
   tf->codes[6297] = 0x00045b4bf8253a11UL;
   tf->codes[6298] = 0x00045b4c32b43fd6UL;
   tf->codes[6299] = 0x00045b4ce2615125UL;
   tf->codes[6300] = 0x00045b51b01cca4eUL;
   tf->codes[6301] = 0x00045b59b1aa943dUL;
   tf->codes[6302] = 0x00045b664664d190UL;
   tf->codes[6303] = 0x00045b693fa81c91UL;
   tf->codes[6304] = 0x00045b7ec02c3ae7UL;
   tf->codes[6305] = 0x00045b7faa6851fbUL;
   tf->codes[6306] = 0x00045b87e68521afUL;
   tf->codes[6307] = 0x00045b8d295ea662UL;
   tf->codes[6308] = 0x00045b9bcd2017a2UL;
   tf->codes[6309] = 0x00045b9cb75c2eb6UL;
   tf->codes[6310] = 0x00045bb4f6949248UL;
   tf->codes[6311] = 0x00045bbf41b895e9UL;
   tf->codes[6312] = 0x00045bcfb9f23551UL;
   tf->codes[6313] = 0x00045bd23e1774c8UL;
   tf->codes[6314] = 0x00045bd362e291a1UL;
   tf->codes[6315] = 0x00045bd98ff82d68UL;
   tf->codes[6316] = 0x00045bda3fa53eb7UL;
   tf->codes[6317] = 0x00045be8e366aff7UL;
   tf->codes[6318] = 0x00045beba21af533UL;
   tf->codes[6319] = 0x00045bf9d0be5ae9UL;
   tf->codes[6320] = 0x00045bfaf58977c2UL;
   tf->codes[6321] = 0x00045bfc1a54949bUL;
   tf->codes[6322] = 0x00045bfc54e39a60UL;
   tf->codes[6323] = 0x00045c07c4d2badaUL;
   tf->codes[6324] = 0x00045c0839f0c664UL;
   tf->codes[6325] = 0x00045c120ff6be7bUL;
   tf->codes[6326] = 0x00045c1927487156UL;
   tf->codes[6327] = 0x00045c33eaa6145fUL;
   tf->codes[6328] = 0x00045c36343c4e11UL;
   tf->codes[6329] = 0x00045c3cd66ff562UL;
   tf->codes[6330] = 0x00045c43b332a278UL;
   tf->codes[6331] = 0x00045c53f0dd3c1bUL;
   tf->codes[6332] = 0x00045c5550375eb9UL;
   tf->codes[6333] = 0x00045c55c5556a43UL;
   tf->codes[6334] = 0x00045c74a6c17526UL;
   tf->codes[6335] = 0x00045c75566e8675UL;
   tf->codes[6336] = 0x00045c7fdc218fdbUL;
   tf->codes[6337] = 0x00045c80c65da6efUL;
   tf->codes[6338] = 0x00045c8768914e40UL;
   tf->codes[6339] = 0x00045c8b4c10b055UL;
   tf->codes[6340] = 0x00045c8bfbbdc1a4UL;
   tf->codes[6341] = 0x00045c8c364cc769UL;
   tf->codes[6342] = 0x00045c934d9e7a44UL;
   tf->codes[6343] = 0x00045c94acf89ce2UL;
   tf->codes[6344] = 0x00045c9940251046UL;
   tf->codes[6345] = 0x00045c9a2a61275aUL;
   tf->codes[6346] = 0x00045ca734397037UL;
   tf->codes[6347] = 0x00045cac3c83ef25UL;
   tf->codes[6348] = 0x00045cb38e64a7c5UL;
   tf->codes[6349] = 0x00045cb478a0bed9UL;
   tf->codes[6350] = 0x00045cc05dadeaddUL;
   tf->codes[6351] = 0x00045cc6503480dfUL;
   tf->codes[6352] = 0x00045cc90ee8c61bUL;
   tf->codes[6353] = 0x00045ccbcd9d0b57UL;
   tf->codes[6354] = 0x00045cd44448e0d0UL;
   tf->codes[6355] = 0x00045cdf3f19f5c0UL;
   tf->codes[6356] = 0x00045ce6566ba89bUL;
   tf->codes[6357] = 0x00045ce86572dc88UL;
   tf->codes[6358] = 0x00045cf56f4b2565UL;
   tf->codes[6359] = 0x00045cff0ac217b7UL;
   tf->codes[6360] = 0x00045d05e784c4cdUL;
   tf->codes[6361] = 0x00045d0b9f7c550aUL;
   tf->codes[6362] = 0x00045d0f486cb15aUL;
   tf->codes[6363] = 0x00045d132bec136fUL;
   tf->codes[6364] = 0x00045d35f0d78067UL;
   tf->codes[6365] = 0x00045d395f38d6f2UL;
   tf->codes[6366] = 0x00045d424b02b7f5UL;
   tf->codes[6367] = 0x00045d462e821a0aUL;
   tf->codes[6368] = 0x00045d592ae0f8e9UL;
   tf->codes[6369] = 0x00045d628bc8e576UL;
   tf->codes[6370] = 0x00045d69688b928cUL;
   tf->codes[6371] = 0x00045d69dda99e16UL;
   tf->codes[6372] = 0x00045d6a8d56af65UL;
   tf->codes[6373] = 0x00045d780c4d03ccUL;
   tf->codes[6374] = 0x00045d79e0c531f4UL;
   tf->codes[6375] = 0x00045d7dfed399ceUL;
   tf->codes[6376] = 0x00045d83b6cb2a0bUL;
   tf->codes[6377] = 0x00045d84db9646e4UL;
   tf->codes[6378] = 0x00045d8bb858f3faUL;
   tf->codes[6379] = 0x00045d9553cfe64cUL;
   tf->codes[6380] = 0x00045d97d7f525c3UL;
   tf->codes[6381] = 0x00045d9971de4e26UL;
   tf->codes[6382] = 0x00045d9c6b219927UL;
   tf->codes[6383] = 0x00045d9f6464e428UL;
   tf->codes[6384] = 0x00045dad58794419UL;
   tf->codes[6385] = 0x00045dae42b55b2dUL;
   tf->codes[6386] = 0x00045db34affda1bUL;
   tf->codes[6387] = 0x00045db4e4e9027eUL;
   tf->codes[6388] = 0x00045dc7a6b8db98UL;
   tf->codes[6389] = 0x00045dd64a7a4cd8UL;
   tf->codes[6390] = 0x00045de319c38ff0UL;
   tf->codes[6391] = 0x00045de59de8cf67UL;
   tf->codes[6392] = 0x00045df73aed8ba8UL;
   tf->codes[6393] = 0x00045dfb938af947UL;
   tf->codes[6394] = 0x00045dfc7dc7105bUL;
   tf->codes[6395] = 0x00045e056990f15eUL;
   tf->codes[6396] = 0x00045e0f7a25ef3aUL;
   tf->codes[6397] = 0x00045e1273693a3bUL;
   tf->codes[6398] = 0x00045e156cac853cUL;
   tf->codes[6399] = 0x00045e1d6e3a4f2bUL;
   tf->codes[6400] = 0x00045e1de3585ab5UL;
   tf->codes[6401] = 0x00045e2cfc37d77fUL;
   tf->codes[6402] = 0x00045e2f805d16f6UL;
   tf->codes[6403] = 0x00045e2ff57b2280UL;
   tf->codes[6404] = 0x00045e32eebe6d81UL;
   tf->codes[6405] = 0x00045e3bda884e84UL;
   tf->codes[6406] = 0x00045e3daf007cacUL;
   tf->codes[6407] = 0x00045e55b3a9da79UL;
   tf->codes[6408] = 0x00045e5c1b4e7c05UL;
   tf->codes[6409] = 0x00045e6507185d08UL;
   tf->codes[6410] = 0x00045e6a49f1e1bbUL;
   tf->codes[6411] = 0x00045e6a8480e780UL;
   tf->codes[6412] = 0x00045e7335bbc2beUL;
   tf->codes[6413] = 0x00045e74cfa4eb21UL;
   tf->codes[6414] = 0x00045e845da27375UL;
   tf->codes[6415] = 0x00045ea7228de06dUL;
   tf->codes[6416] = 0x00045eb3422a1236UL;
   tf->codes[6417] = 0x00045eb3b7481dc0UL;
   tf->codes[6418] = 0x00045ec58edbdfc6UL;
   tf->codes[6419] = 0x00045ec603f9eb50UL;
   tf->codes[6420] = 0x00045ed173e90bcaUL;
   tf->codes[6421] = 0x00045ed4a7bb5c90UL;
   tf->codes[6422] = 0x00045ed88b3abea5UL;
   tf->codes[6423] = 0x00045ed9ea94e143UL;
   tf->codes[6424] = 0x00045edb0f5ffe1cUL;
   tf->codes[6425] = 0x00045edd1e673209UL;
   tf->codes[6426] = 0x00045ee435b8e4e4UL;
   tf->codes[6427] = 0x00045ef5d2bda125UL;
   tf->codes[6428] = 0x00045ef9068ff1ebUL;
   tf->codes[6429] = 0x00045efd5f2d5f8aUL;
   tf->codes[6430] = 0x00045f04767f1265UL;
   tf->codes[6431] = 0x00045f09443a8b8eUL;
   tf->codes[6432] = 0x00045f2c43b4fe4bUL;
   tf->codes[6433] = 0x00045f32ab599fd7UL;
   tf->codes[6434] = 0x00045f3e55d7c616UL;
   tf->codes[6435] = 0x00045f50a28993a6UL;
   tf->codes[6436] = 0x00045f5c1278b420UL;
   tf->codes[6437] = 0x00045f5de6f0e248UL;
   tf->codes[6438] = 0x00045f639ee87285UL;
   tf->codes[6439] = 0x00045f6747d8ced5UL;
   tf->codes[6440] = 0x00045f69cbfe0e4cUL;
   tf->codes[6441] = 0x00045f7e6246158eUL;
   tf->codes[6442] = 0x00045f8ba6ad6430UL;
   tf->codes[6443] = 0x00045f8e9ff0af31UL;
   tf->codes[6444] = 0x00045f92bdff170bUL;
   tf->codes[6445] = 0x00045f9457e83f6eUL;
   tf->codes[6446] = 0x00045fa49592d911UL;
   tf->codes[6447] = 0x00045fb1d9fa27b3UL;
   tf->codes[6448] = 0x00045fb5f8088f8dUL;
   tf->codes[6449] = 0x00045fbc251e2b54UL;
   tf->codes[6450] = 0x00045fc376fee3f4UL;
   tf->codes[6451] = 0x00045fc5c0951da6UL;
   tf->codes[6452] = 0x00045fc6e5603a7fUL;
   tf->codes[6453] = 0x00045fe3b7c51175UL;
   tf->codes[6454] = 0x00045fe4dc902e4eUL;
   tf->codes[6455] = 0x00045fe7d5d3794fUL;
   tf->codes[6456] = 0x00045fed18acfe02UL;
   tf->codes[6457] = 0x00045ff30b339404UL;
   tf->codes[6458] = 0x00045ff8137e12f2UL;
   tf->codes[6459] = 0x00045ffd1bc891e0UL;
   tf->codes[6460] = 0x00046001aef50544UL;
   tf->codes[6461] = 0x000460046da94a80UL;
   tf->codes[6462] = 0x00046004a8385045UL;
   tf->codes[6463] = 0x0004600a25a0dabdUL;
   tf->codes[6464] = 0x0004600d59732b83UL;
   tf->codes[6465] = 0x0004601052b67684UL;
   tf->codes[6466] = 0x00046025d33a94daUL;
   tf->codes[6467] = 0x000460359bc722f3UL;
   tf->codes[6468] = 0x0004603a69829c1cUL;
   tf->codes[6469] = 0x0004603bc8dcbebaUL;
   tf->codes[6470] = 0x0004604947d31321UL;
   tf->codes[6471] = 0x00046056c6c96788UL;
   tf->codes[6472] = 0x00046059c00cb289UL;
   tf->codes[6473] = 0x000460639612aaa0UL;
   tf->codes[6474] = 0x00046066c9e4fb66UL;
   tf->codes[6475] = 0x0004606863ce23c9UL;
   tf->codes[6476] = 0x0004606cf6fa972dUL;
   tf->codes[6477] = 0x0004606e1bc5b406UL;
   tf->codes[6478] = 0x0004607bd54b0e32UL;
   tf->codes[6479] = 0x0004607e93ff536eUL;
   tf->codes[6480] = 0x00046092400b439cUL;
   tf->codes[6481] = 0x0004609d3adc588cUL;
   tf->codes[6482] = 0x000460b0ac5942f5UL;
   tf->codes[6483] = 0x000460b504f6b094UL;
   tf->codes[6484] = 0x000460c20ecef971UL;
   tf->codes[6485] = 0x000460c3339a164aUL;
   tf->codes[6486] = 0x000460c5b7bf55c1UL;
   tf->codes[6487] = 0x000460ca105cc360UL;
   tf->codes[6488] = 0x000460d804712351UL;
   tf->codes[6489] = 0x000460e2c4b3327cUL;
   tf->codes[6490] = 0x000460e548d871f3UL;
   tf->codes[6491] = 0x000460f7958a3f83UL;
   tf->codes[6492] = 0x000460fc6345b8acUL;
   tf->codes[6493] = 0x00046109e23c0d13UL;
   tf->codes[6494] = 0x0004610dc5bb6f28UL;
   tf->codes[6495] = 0x00046119aac89b2cUL;
   tf->codes[6496] = 0x0004611bb9cfcf19UL;
   tf->codes[6497] = 0x0004611c697ce068UL;
   tf->codes[6498] = 0x0004613b8577f110UL;
   tf->codes[6499] = 0x0004613e442c364cUL;
   tf->codes[6500] = 0x0004613e7ebb3c11UL;
   tf->codes[6501] = 0x00046146f567118aUL;
   tf->codes[6502] = 0x00046149046e4577UL;
   tf->codes[6503] = 0x00046149eeaa5c8bUL;
   tf->codes[6504] = 0x0004614bfdb19078UL;
   tf->codes[6505] = 0x00046151408b152bUL;
   tf->codes[6506] = 0x0004615648d59419UL;
   tf->codes[6507] = 0x00046161f353ba58UL;
   tf->codes[6508] = 0x0004616611622232UL;
   tf->codes[6509] = 0x0004616c3e77bdf9UL;
   tf->codes[6510] = 0x00046173cae77c5eUL;
   tf->codes[6511] = 0x000461752a419efcUL;
   tf->codes[6512] = 0x00046185a27b3e64UL;
   tf->codes[6513] = 0x000461909d4c5354UL;
   tf->codes[6514] = 0x00046197ef2d0bf4UL;
   tf->codes[6515] = 0x000461994e872e92UL;
   tf->codes[6516] = 0x0004619d6c95966cUL;
   tf->codes[6517] = 0x0004619f067ebecfUL;
   tf->codes[6518] = 0x000461b277fba938UL;
   tf->codes[6519] = 0x000461bc13729b8aUL;
   tf->codes[6520] = 0x000461c205f9318cUL;
   tf->codes[6521] = 0x000461cab7340ccaUL;
   tf->codes[6522] = 0x000461e330fb7621UL;
   tf->codes[6523] = 0x000461e4905598bfUL;
   tf->codes[6524] = 0x000461f2bef8fe75UL;
   tf->codes[6525] = 0x000461f62d5a5500UL;
   tf->codes[6526] = 0x000461f7522571d9UL;
   tf->codes[6527] = 0x0004620ac3a25c42UL;
   tf->codes[6528] = 0x00046211daf40f1dUL;
   tf->codes[6529] = 0x000462150ec65fe3UL;
   tf->codes[6530] = 0x00046218f245c1f8UL;
   tf->codes[6531] = 0x0004621ac6bdf020UL;
   tf->codes[6532] = 0x0004621b014cf5e5UL;
   tf->codes[6533] = 0x0004621cd5c5240dUL;
   tf->codes[6534] = 0x000462249cc3e837UL;
   tf->codes[6535] = 0x0004622586ffff4bUL;
   tf->codes[6536] = 0x0004622796073338UL;
   tf->codes[6537] = 0x0004622d136fbdb0UL;
   tf->codes[6538] = 0x0004622dc31cceffUL;
   tf->codes[6539] = 0x000462300cb308b1UL;
   tf->codes[6540] = 0x00046233b5a36501UL;
   tf->codes[6541] = 0x0004623a92661217UL;
   tf->codes[6542] = 0x000462458d372707UL;
   tf->codes[6543] = 0x0004624677733e1bUL;
   tf->codes[6544] = 0x0004624ca488d9e2UL;
   tf->codes[6545] = 0x00046259e8f02884UL;
   tf->codes[6546] = 0x0004627b4e8172deUL;
   tf->codes[6547] = 0x0004627e47c4bddfUL;
   tf->codes[6548] = 0x0004627ef771cf2eUL;
   tf->codes[6549] = 0x00046291099496f9UL;
   tf->codes[6550] = 0x00046296fc1b2cfbUL;
   tf->codes[6551] = 0x000462990b2260e8UL;
   tf->codes[6552] = 0x0004629efda8f6eaUL;
   tf->codes[6553] = 0x000462a90e3df4c6UL;
   tf->codes[6554] = 0x000462ae8ba67f3eUL;
   tf->codes[6555] = 0x000462b5a2f83219UL;
   tf->codes[6556] = 0x000462b9115988a4UL;
   tf->codes[6557] = 0x000462bc452bd96aUL;
   tf->codes[6558] = 0x000462c9feb13396UL;
   tf->codes[6559] = 0x000462cae8ed4aaaUL;
   tf->codes[6560] = 0x000462cbd32961beUL;
   tf->codes[6561] = 0x000462d5e3be5f9aUL;
   tf->codes[6562] = 0x000462de5a6a3513UL;
   tf->codes[6563] = 0x000462e362b4b401UL;
   tf->codes[6564] = 0x000462e780c31bdbUL;
   tf->codes[6565] = 0x000462eb64427df0UL;
   tf->codes[6566] = 0x000462eff76ef154UL;
   tf->codes[6567] = 0x000462f3daee5369UL;
   tf->codes[6568] = 0x000462faf2400644UL;
   tf->codes[6569] = 0x000462fb2ccf0c09UL;
   tf->codes[6570] = 0x000462fe60a15ccfUL;
   tf->codes[6571] = 0x000463095b7271bfUL;
   tf->codes[6572] = 0x0004630b6a79a5acUL;
   tf->codes[6573] = 0x0004630bdf97b136UL;
   tf->codes[6574] = 0x0004630d7980d999UL;
   tf->codes[6575] = 0x0004630db40fdf5eUL;
   tf->codes[6576] = 0x00046317c4a4dd3aUL;
   tf->codes[6577] = 0x00046318e96ffa13UL;
   tf->codes[6578] = 0x0004631a0e3b16ecUL;
   tf->codes[6579] = 0x0004631a48ca1cb1UL;
   tf->codes[6580] = 0x0004632668664e7aUL;
   tf->codes[6581] = 0x0004632fc94e3b07UL;
   tf->codes[6582] = 0x0004633288028043UL;
   tf->codes[6583] = 0x00046338efa721cfUL;
   tf->codes[6584] = 0x0004633cd32683e4UL;
   tf->codes[6585] = 0x000463580ba23277UL;
   tf->codes[6586] = 0x0004635dc399c2b4UL;
   tf->codes[6587] = 0x00046365157a7b54UL;
   tf->codes[6588] = 0x00046367999fbacbUL;
   tf->codes[6589] = 0x0004636f9b2d84baUL;
   tf->codes[6590] = 0x00046373441de10aUL;
   tf->codes[6591] = 0x00046389744f10afUL;
   tf->codes[6592] = 0x00046391eafae628UL;
   tf->codes[6593] = 0x000463929aa7f777UL;
   tf->codes[6594] = 0x00046394e43e3129UL;
   tf->codes[6595] = 0x00046397686370a0UL;
   tf->codes[6596] = 0x0004639bfb8fe404UL;
   tf->codes[6597] = 0x0004639e7fb5237bUL;
   tf->codes[6598] = 0x000463b4ea7558e5UL;
   tf->codes[6599] = 0x000463bd9bb03423UL;
   tf->codes[6600] = 0x000463c896814913UL;
   tf->codes[6601] = 0x000463cb8fc49414UL;
   tf->codes[6602] = 0x000463d615779d7aUL;
   tf->codes[6603] = 0x000463e3cefcf7a6UL;
   tf->codes[6604] = 0x000463e8d7477694UL;
   tf->codes[6605] = 0x000463eae64eaa81UL;
   tf->codes[6606] = 0x000463ebd08ac195UL;
   tf->codes[6607] = 0x000463ee8f3f06d1UL;
   tf->codes[6608] = 0x000463fecce9a074UL;
   tf->codes[6609] = 0x0004640693e8649eUL;
   tf->codes[6610] = 0x0004640b9c32e38cUL;
   tf->codes[6611] = 0x0004640f0a943a17UL;
   tf->codes[6612] = 0x00046411c9487f53UL;
   tf->codes[6613] = 0x0004641328a2a1f1UL;
   tf->codes[6614] = 0x000464265f908695UL;
   tf->codes[6615] = 0x0004642af2bcf9f9UL;
   tf->codes[6616] = 0x0004642bdcf9110dUL;
   tf->codes[6617] = 0x0004642c52171c97UL;
   tf->codes[6618] = 0x0004642ffb0778e7UL;
   tf->codes[6619] = 0x0004643d3f6ec789UL;
   tf->codes[6620] = 0x00046445f0a9a2c7UL;
   tf->codes[6621] = 0x000464562e543c6aUL;
   tf->codes[6622] = 0x0004645d45a5ef45UL;
   tf->codes[6623] = 0x0004646d835088e8UL;
   tf->codes[6624] = 0x000464704204ce24UL;
   tf->codes[6625] = 0x00046470f1b1df73UL;
   tf->codes[6626] = 0x00046477ce748c89UL;
   tf->codes[6627] = 0x00046486acc5038eUL;
   tf->codes[6628] = 0x00046494664a5dbaUL;
   tf->codes[6629] = 0x000464988458c594UL;
   tf->codes[6630] = 0x0004649b087e050bUL;
   tf->codes[6631] = 0x0004649bb82b165aUL;
   tf->codes[6632] = 0x000464a5c8c01436UL;
   tf->codes[6633] = 0x000464c17659ce53UL;
   tf->codes[6634] = 0x000464c26095e567UL;
   tf->codes[6635] = 0x000464ca9cb2b51bUL;
   tf->codes[6636] = 0x000464d52265be81UL;
   tf->codes[6637] = 0x000464d5d212cfd0UL;
   tf->codes[6638] = 0x000464dc74467721UL;
   tf->codes[6639] = 0x000464e7e435979bUL;
   tf->codes[6640] = 0x000464e9438fba39UL;
   tf->codes[6641] = 0x000464ecec801689UL;
   tf->codes[6642] = 0x000464f17fac89edUL;
   tf->codes[6643] = 0x00046505db658b6aUL;
   tf->codes[6644] = 0x00046517b2f94d70UL;
   tf->codes[6645] = 0x0004651c80b4c699UL;
   tf->codes[6646] = 0x00046535e4b84704UL;
   tf->codes[6647] = 0x0004653a3d55b4a3UL;
   tf->codes[6648] = 0x0004653dabb70b2eUL;
   tf->codes[6649] = 0x00046543d8cca6f5UL;
   tf->codes[6650] = 0x00046545e7d3dae2UL;
   tf->codes[6651] = 0x000465465cf1e66cUL;
   tf->codes[6652] = 0x0004654b2aad5f95UL;
   tf->codes[6653] = 0x00046550e2a4efd2UL;
   tf->codes[6654] = 0x000465569a9c800fUL;
   tf->codes[6655] = 0x000465570fba8b99UL;
   tf->codes[6656] = 0x0004655b2dc8f373UL;
   tf->codes[6657] = 0x0004656a46a8703dUL;
   tf->codes[6658] = 0x0004658b71aab4d2UL;
   tf->codes[6659] = 0x0004659213de5c23UL;
   tf->codes[6660] = 0x00046592fe1a7337UL;
   tf->codes[6661] = 0x00046596e199d54cUL;
   tf->codes[6662] = 0x000465992b300efeUL;
   tf->codes[6663] = 0x0004659c5f025fc4UL;
   tf->codes[6664] = 0x000465ac621df3a2UL;
   tf->codes[6665] = 0x000465bc9fc88d45UL;
   tf->codes[6666] = 0x000465d5c93d07ebUL;
   tf->codes[6667] = 0x000465d76326304eUL;
   tf->codes[6668] = 0x000465e25df7453eUL;
   tf->codes[6669] = 0x000465e4a78d7ef0UL;
   tf->codes[6670] = 0x000465f644923b31UL;
   tf->codes[6671] = 0x000465f7de7b6394UL;
   tf->codes[6672] = 0x000465fa62a0a30bUL;
   tf->codes[6673] = 0x000465febb3e10aaUL;
   tf->codes[6674] = 0x0004660d5eff81eaUL;
   tf->codes[6675] = 0x0004661b5313e1dbUL;
   tf->codes[6676] = 0x0004662772b013a4UL;
   tf->codes[6677] = 0x0004663566c47395UL;
   tf->codes[6678] = 0x00046635a153795aUL;
   tf->codes[6679] = 0x0004663b1ebc03d2UL;
   tf->codes[6680] = 0x0004663c08f81ae6UL;
   tf->codes[6681] = 0x0004663c7e162670UL;
   tf->codes[6682] = 0x00046641c0efab23UL;
   tf->codes[6683] = 0x000466440a85e4d5UL;
   tf->codes[6684] = 0x00046647ee0546eaUL;
   tf->codes[6685] = 0x0004664f3fe5ff8aUL;
   tf->codes[6686] = 0x0004665cf96b59b6UL;
   tf->codes[6687] = 0x00046666cf7151cdUL;
   tf->codes[6688] = 0x0004666b280ebf6cUL;
   tf->codes[6689] = 0x0004666dac33fee3UL;
   tf->codes[6690] = 0x00046671ca4266bdUL;
   tf->codes[6691] = 0x000466765d6eda21UL;
   tf->codes[6692] = 0x00046685eb6c6275UL;
   tf->codes[6693] = 0x0004668785558ad8UL;
   tf->codes[6694] = 0x0004669a0c965e2dUL;
   tf->codes[6695] = 0x0004669abc436f7cUL;
   tf->codes[6696] = 0x000466a62c328ff6UL;
   tf->codes[6697] = 0x000466a750fdaccfUL;
   tf->codes[6698] = 0x000466aabf5f035aUL;
   tf->codes[6699] = 0x000466b16192aaabUL;
   tf->codes[6700] = 0x000466cf58c29e7aUL;
   tf->codes[6701] = 0x000466d794df6e2eUL;
   tf->codes[6702] = 0x000466e28fb0831eUL;
   tf->codes[6703] = 0x000466e2ca3f88e3UL;
   tf->codes[6704] = 0x000466e931e42a6fUL;
   tf->codes[6705] = 0x000466fa1f3bd561UL;
   tf->codes[6706] = 0x000466fe02bb3776UL;
   tf->codes[6707] = 0x0004670604490165UL;
   tf->codes[6708] = 0x00046707d8c12f8dUL;
   tf->codes[6709] = 0x0004670c315e9d2cUL;
   tf->codes[6710] = 0x0004670d90b8bfcaUL;
   tf->codes[6711] = 0x0004672fa5f71b73UL;
   tf->codes[6712] = 0x0004673c00225301UL;
   tf->codes[6713] = 0x0004674352030ba1UL;
   tf->codes[6714] = 0x000467443c3f22b5UL;
   tf->codes[6715] = 0x00046750966a5a43UL;
   tf->codes[6716] = 0x00046752305382a6UL;
   tf->codes[6717] = 0x0004675ae18e5de4UL;
   tf->codes[6718] = 0x0004675c40e88082UL;
   tf->codes[6719] = 0x00046761be510afaUL;
   tf->codes[6720] = 0x0004676407e744acUL;
   tf->codes[6721] = 0x0004676776489b37UL;
   tf->codes[6722] = 0x0004676c7e931a25UL;
   tf->codes[6723] = 0x0004676f77d66526UL;
   tf->codes[6724] = 0x00046771fbfba49dUL;
   tf->codes[6725] = 0x00046775a4ec00edUL;
   tf->codes[6726] = 0x0004677779642f15UL;
   tf->codes[6727] = 0x000467789e2f4beeUL;
   tf->codes[6728] = 0x0004677c81aeae03UL;
   tf->codes[6729] = 0x0004677e90b5e1f0UL;
   tf->codes[6730] = 0x0004678a00a5026aUL;
   tf->codes[6731] = 0x000467a2ef8a774bUL;
   tf->codes[6732] = 0x000467ad753d80b1UL;
   tf->codes[6733] = 0x000467b242f8f9daUL;
   tf->codes[6734] = 0x000467b994d9b27aUL;
   tf->codes[6735] = 0x000467bb2ec2daddUL;
   tf->codes[6736] = 0x000467bba3e0e667UL;
   tf->codes[6737] = 0x000467cea03fc546UL;
   tf->codes[6738] = 0x000467d3e31949f9UL;
   tf->codes[6739] = 0x000467dafa6afcd4UL;
   tf->codes[6740] = 0x000467e6a4e92313UL;
   tf->codes[6741] = 0x000467e78f253a27UL;
   tf->codes[6742] = 0x000467e87961513bUL;
   tf->codes[6743] = 0x000467e99e2c6e14UL;
   tf->codes[6744] = 0x000467ef5623fe51UL;
   tf->codes[6745] = 0x000467f66d75b12cUL;
   tf->codes[6746] = 0x000467f6e293bcb6UL;
   tf->codes[6747] = 0x000467fd0fa9587dUL;
   tf->codes[6748] = 0x00046812559e710eUL;
   tf->codes[6749] = 0x000468158970c1d4UL;
   tf->codes[6750] = 0x000468196cf023e9UL;
   tf->codes[6751] = 0x0004681a91bb40c2UL;
   tf->codes[6752] = 0x0004681d15e08039UL;
   tf->codes[6753] = 0x0004681f24e7b426UL;
   tf->codes[6754] = 0x00046825c71b5b77UL;
   tf->codes[6755] = 0x0004683ef08fd61dUL;
   tf->codes[6756] = 0x000468408a78fe80UL;
   tf->codes[6757] = 0x0004684592c37d6eUL;
   tf->codes[6758] = 0x00046849eb60eb0dUL;
   tf->codes[6759] = 0x0004684f68c97585UL;
   tf->codes[6760] = 0x000468534c48d79aUL;
   tf->codes[6761] = 0x000468560afd1cd6UL;
   tf->codes[6762] = 0x000468593ecf6d9cUL;
   tf->codes[6763] = 0x0004685e81a8f24fUL;
   tf->codes[6764] = 0x00046867e290dedcUL;
   tf->codes[6765] = 0x0004686c009f46b6UL;
   tf->codes[6766] = 0x0004686ceadb5dcaUL;
   tf->codes[6767] = 0x0004686e84c4862dUL;
   tf->codes[6768] = 0x00046870ce5abfdfUL;
   tf->codes[6769] = 0x0004687aa460b7f6UL;
   tf->codes[6770] = 0x000468885de61222UL;
   tf->codes[6771] = 0x000468952d2f553aUL;
   tf->codes[6772] = 0x0004689cb99f139fUL;
   tf->codes[6773] = 0x000468ac822ba1b8UL;
   tf->codes[6774] = 0x000468b692c09f94UL;
   tf->codes[6775] = 0x000468ba3bb0fbe4UL;
   tf->codes[6776] = 0x000468bf43fb7ad2UL;
   tf->codes[6777] = 0x000468c068c697abUL;
   tf->codes[6778] = 0x000468ca3ecc8fc2UL;
   tf->codes[6779] = 0x000468d5e94ab601UL;
   tf->codes[6780] = 0x000468df0fa39cc9UL;
   tf->codes[6781] = 0x000468df4a32a28eUL;
   tf->codes[6782] = 0x000468e8ab1a8f1bUL;
   tf->codes[6783] = 0x000468e920389aa5UL;
   tf->codes[6784] = 0x000468eb69ced457UL;
   tf->codes[6785] = 0x000468ed03b7fcbaUL;
   tf->codes[6786] = 0x000468f072195345UL;
   tf->codes[6787] = 0x000468f0e7375ecfUL;
   tf->codes[6788] = 0x000468faf7cc5cabUL;
   tf->codes[6789] = 0x0004690493434efdUL;
   tf->codes[6790] = 0x000469099b8dcdebUL;
   tf->codes[6791] = 0x000469178fa22ddcUL;
   tf->codes[6792] = 0x00046925be459392UL;
   tf->codes[6793] = 0x00046927582ebbf5UL;
   tf->codes[6794] = 0x0004692d854457bcUL;
   tf->codes[6795] = 0x0004692dfa626346UL;
   tf->codes[6796] = 0x00046938baa47271UL;
   tf->codes[6797] = 0x0004693a548d9ad4UL;
   tf->codes[6798] = 0x000469437ae6819cUL;
   tf->codes[6799] = 0x0004694bf1925715UL;
   tf->codes[6800] = 0x0004694f9a82b365UL;
   tf->codes[6801] = 0x000469504a2fc4b4UL;
   tf->codes[6802] = 0x00046956b1d46640UL;
   tf->codes[6803] = 0x00046958fb6a9ff2UL;
   tf->codes[6804] = 0x0004695935f9a5b7UL;
   tf->codes[6805] = 0x000469788c83bc24UL;
   tf->codes[6806] = 0x0004697e09ec469cUL;
   tf->codes[6807] = 0x00046985213df977UL;
   tf->codes[6808] = 0x000469855bccff3cUL;
   tf->codes[6809] = 0x0004698cadadb7dcUL;
   tf->codes[6810] = 0x00046992dac353a3UL;
   tf->codes[6811] = 0x0004699c763a45f5UL;
   tf->codes[6812] = 0x000469ac3ec6d40eUL;
   tf->codes[6813] = 0x000469b1bc2f5e86UL;
   tf->codes[6814] = 0x000469bd66ad84c5UL;
   tf->codes[6815] = 0x000469c3ce522651UL;
   tf->codes[6816] = 0x000469ccba1c0754UL;
   tf->codes[6817] = 0x000469d5e074ee1cUL;
   tf->codes[6818] = 0x000469dcf7c6a0f7UL;
   tf->codes[6819] = 0x000469df415cdaa9UL;
   tf->codes[6820] = 0x000469e61e1f87bfUL;
   tf->codes[6821] = 0x000469e867b5c171UL;
   tf->codes[6822] = 0x000469ec10a61dc1UL;
   tf->codes[6823] = 0x000469ef44786e87UL;
   tf->codes[6824] = 0x000469fb6414a050UL;
   tf->codes[6825] = 0x00046a006c5f1f3eUL;
   tf->codes[6826] = 0x00046a1627724359UL;
   tf->codes[6827] = 0x00046a17fbea7181UL;
   tf->codes[6828] = 0x00046a1c8f16e4e5UL;
   tf->codes[6829] = 0x00046a23e0f79d85UL;
   tf->codes[6830] = 0x00046a257ae0c5e8UL;
   tf->codes[6831] = 0x00046a36683870daUL;
   tf->codes[6832] = 0x00046a39d699c765UL;
   tf->codes[6833] = 0x00046a42fcf2ae2dUL;
   tf->codes[6834] = 0x00046a51db432532UL;
   tf->codes[6835] = 0x00046a550f1575f8UL;
   tf->codes[6836] = 0x00046a5967b2e397UL;
   tf->codes[6837] = 0x00046a5cd6143a22UL;
   tf->codes[6838] = 0x00046a61de5eb910UL;
   tf->codes[6839] = 0x00046a68bb216626UL;
   tf->codes[6840] = 0x00046a6dfdfaead9UL;
   tf->codes[6841] = 0x00046a75ff88b4c8UL;
   tf->codes[6842] = 0x00046a772453d1a1UL;
   tf->codes[6843] = 0x00046a7bf20f4acaUL;
   tf->codes[6844] = 0x00046a829442f21bUL;
   tf->codes[6845] = 0x00046a8811ab7c93UL;
   tf->codes[6846] = 0x00046a9d922f9ae9UL;
   tf->codes[6847] = 0x00046aa2255c0e4dUL;
   tf->codes[6848] = 0x00046aa6f3178776UL;
   tf->codes[6849] = 0x00046ac01c8c021cUL;
   tf->codes[6850] = 0x00046acb175d170cUL;
   tf->codes[6851] = 0x00046ad109e3ad0eUL;
   tf->codes[6852] = 0x00046ad35379e6c0UL;
   tf->codes[6853] = 0x00046ad562811aadUL;
   tf->codes[6854] = 0x00046ad6122e2bfcUL;
   tf->codes[6855] = 0x00046ad8d0e27138UL;
   tf->codes[6856] = 0x00046adcb461d34dUL;
   tf->codes[6857] = 0x00046ae73a14dcb3UL;
   tf->codes[6858] = 0x00046aecf20c6cf0UL;
   tf->codes[6859] = 0x00046aeec6849b18UL;
   tf->codes[6860] = 0x00046b048197bf33UL;
   tf->codes[6861] = 0x00046b0914c43297UL;
   tf->codes[6862] = 0x00046b094f53385cUL;
   tf->codes[6863] = 0x00046b0989e23e21UL;
   tf->codes[6864] = 0x00046b0c4896835dUL;
   tf->codes[6865] = 0x00046b0cf84394acUL;
   tf->codes[6866] = 0x00046b1534606460UL;
   tf->codes[6867] = 0x00046b186832b526UL;
   tf->codes[6868] = 0x00046b270bf42666UL;
   tf->codes[6869] = 0x00046b29901965ddUL;
   tf->codes[6870] = 0x00046b30e1fa1e7dUL;
   tf->codes[6871] = 0x00046b348aea7acdUL;
   tf->codes[6872] = 0x00046b35ea449d6bUL;
   tf->codes[6873] = 0x00046b3f109d8433UL;
   tf->codes[6874] = 0x00046b3f85bb8fbdUL;
   tf->codes[6875] = 0x00046b4996508d99UL;
   tf->codes[6876] = 0x00046b4cca22de5fUL;
   tf->codes[6877] = 0x00046b52821a6e9cUL;
   tf->codes[6878] = 0x00046b61606ae5a1UL;
   tf->codes[6879] = 0x00046b636f72198eUL;
   tf->codes[6880] = 0x00046b6a11a5c0dfUL;
   tf->codes[6881] = 0x00046b6bab8ee942UL;
   tf->codes[6882] = 0x00046b6d0ae90be0UL;
   tf->codes[6883] = 0x00046b6ea4d23443UL;
   tf->codes[6884] = 0x00046b6edf613a08UL;
   tf->codes[6885] = 0x00046b750c76d5cfUL;
   tf->codes[6886] = 0x00046b7840492695UL;
   tf->codes[6887] = 0x00046b7dbdb1b10dUL;
   tf->codes[6888] = 0x00046b812c130798UL;
   tf->codes[6889] = 0x00046b8ee59861c4UL;
   tf->codes[6890] = 0x00046b97d16242c7UL;
   tf->codes[6891] = 0x00046b9bb4e1a4dcUL;
   tf->codes[6892] = 0x00046bad51e6611dUL;
   tf->codes[6893] = 0x00046bb603213c5bUL;
   tf->codes[6894] = 0x00046bb8c1d58197UL;
   tf->codes[6895] = 0x00046bbd8f90fac0UL;
   tf->codes[6896] = 0x00046bbeb45c1799UL;
   tf->codes[6897] = 0x00046bc0fdf2514bUL;
   tf->codes[6898] = 0x00046bc640cbd5feUL;
   tf->codes[6899] = 0x00046bc9749e26c4UL;
   tf->codes[6900] = 0x00046be7313f14ceUL;
   tf->codes[6901] = 0x00046bf2dbbd3b0dUL;
   tf->codes[6902] = 0x00046c0353f6da75UL;
   tf->codes[6903] = 0x00046c0403a3ebc4UL;
   tf->codes[6904] = 0x00046c0ae06698daUL;
   tf->codes[6905] = 0x00046c0c7a4fc13dUL;
   tf->codes[6906] = 0x00046c0d9f1ade16UL;
   tf->codes[6907] = 0x00046c1406bf7fa2UL;
   tf->codes[6908] = 0x00046c19beb70fdfUL;
   tf->codes[6909] = 0x00046c1c42dc4f56UL;
   tf->codes[6910] = 0x00046c1cf28960a5UL;
   tf->codes[6911] = 0x00046c29fc61a982UL;
   tf->codes[6912] = 0x00046c3740c8f824UL;
   tf->codes[6913] = 0x00046c40a1b0e4b1UL;
   tf->codes[6914] = 0x00046c477e7391c7UL;
   tf->codes[6915] = 0x00046c4ab245e28dUL;
   tf->codes[6916] = 0x00046c4f0ae3502cUL;
   tf->codes[6917] = 0x00046c4f457255f1UL;
   tf->codes[6918] = 0x00046c665fdf9caaUL;
   tf->codes[6919] = 0x00046c7921af75c4UL;
   tf->codes[6920] = 0x00046c7fc3e31d15UL;
   tf->codes[6921] = 0x00046c820d7956c7UL;
   tf->codes[6922] = 0x00046c83a7627f2aUL;
   tf->codes[6923] = 0x00046c84cc2d9c03UL;
   tf->codes[6924] = 0x00046c8e67a48e55UL;
   tf->codes[6925] = 0x00046c9afc5ecba8UL;
   tf->codes[6926] = 0x00046c9e6ac02233UL;
   tf->codes[6927] = 0x00046ca6e16bf7acUL;
   tf->codes[6928] = 0x00046cae334cb04cUL;
   tf->codes[6929] = 0x00046cb0f200f588UL;
   tf->codes[6930] = 0x00046cb8f38ebf77UL;
   tf->codes[6931] = 0x00046cbc61f01602UL;
   tf->codes[6932] = 0x00046cc16a3a94f0UL;
   tf->codes[6933] = 0x00046ccacb22817dUL;
   tf->codes[6934] = 0x00046cd550d58ae3UL;
   tf->codes[6935] = 0x00046ce9377080d6UL;
   tf->codes[6936] = 0x00046cea21ac97eaUL;
   tf->codes[6937] = 0x00046cea96caa374UL;
   tf->codes[6938] = 0x00046cec30b3cbd7UL;
   tf->codes[6939] = 0x00046cef29f716d8UL;
   tf->codes[6940] = 0x00046cf382948477UL;
   tf->codes[6941] = 0x00046cf3bd238a3cUL;
   tf->codes[6942] = 0x00046cf5570cb29fUL;
   tf->codes[6943] = 0x00046cf67bd7cf78UL;
   tf->codes[6944] = 0x00046cfad4753d17UL;
   tf->codes[6945] = 0x00046d097836ae57UL;
   tf->codes[6946] = 0x00046d0ce69804e2UL;
   tf->codes[6947] = 0x00046d160cf0ebaaUL;
   tf->codes[6948] = 0x00046d1caf2492fbUL;
   tf->codes[6949] = 0x00046d1d24429e85UL;
   tf->codes[6950] = 0x00046d2d61ed3828UL;
   tf->codes[6951] = 0x00046d2fe612779fUL;
   tf->codes[6952] = 0x00046d38222f4753UL;
   tf->codes[6953] = 0x00046d3cefeac07cUL;
   tf->codes[6954] = 0x00046d468b61b2ceUL;
   tf->codes[6955] = 0x00046d47b02ccfa7UL;
   tf->codes[6956] = 0x00046d59fcde9d37UL;
   tf->codes[6957] = 0x00046d5bd156cb5fUL;
   tf->codes[6958] = 0x00046d698adc258bUL;
   tf->codes[6959] = 0x00046d6b5f5453b3UL;
   tf->codes[6960] = 0x00046d6f42d3b5c8UL;
   tf->codes[6961] = 0x00046d7b27e0e1ccUL;
   tf->codes[6962] = 0x00046d8ed3ecd1faUL;
   tf->codes[6963] = 0x00046d8f8399e349UL;
   tf->codes[6964] = 0x00046d969aeb9624UL;
   tf->codes[6965] = 0x00046d9c1854209cUL;
   tf->codes[6966] = 0x00046da070f18e3bUL;
   tf->codes[6967] = 0x00046db332c16755UL;
   tf->codes[6968] = 0x00046db78b5ed4f4UL;
   tf->codes[6969] = 0x00046dd005263e4bUL;
   tf->codes[6970] = 0x00046dd2fe69894cUL;
   tf->codes[6971] = 0x00046dd50d70bd39UL;
   tf->codes[6972] = 0x00046dd6323bda12UL;
   tf->codes[6973] = 0x00046ddc24c27014UL;
   tf->codes[6974] = 0x00046ddea8e7af8bUL;
   tf->codes[6975] = 0x00046de5c0396266UL;
   tf->codes[6976] = 0x00046de66fe673b5UL;
   tf->codes[6977] = 0x00046dee71743da4UL;
   tf->codes[6978] = 0x00046df49e89d96bUL;
   tf->codes[6979] = 0x00046e037cda5070UL;
   tf->codes[6980] = 0x00046e0516c378d3UL;
   tf->codes[6981] = 0x00046e0eb23a6b25UL;
   tf->codes[6982] = 0x00046e1295b9cd3aUL;
   tf->codes[6983] = 0x00046e137ff5e44eUL;
   tf->codes[6984] = 0x00046e1b0c65a2b3UL;
   tf->codes[6985] = 0x00046e1fda211bdcUL;
   tf->codes[6986] = 0x00046e238311782cUL;
   tf->codes[6987] = 0x00046e2eb87192e1UL;
   tf->codes[6988] = 0x00046e3853e88533UL;
   tf->codes[6989] = 0x00046e3fa5c93dd3UL;
   tf->codes[6990] = 0x00046e4a660b4cfeUL;
   tf->codes[6991] = 0x00046e561089733dUL;
   tf->codes[6992] = 0x00046e5894aeb2b4UL;
   tf->codes[6993] = 0x00046e5e12173d2cUL;
   tf->codes[6994] = 0x00046e61f5969f41UL;
   tf->codes[6995] = 0x00046e631a61bc1aUL;
   tf->codes[6996] = 0x00046e71f8b2331fUL;
   tf->codes[6997] = 0x00046e72a85f446eUL;
   tf->codes[6998] = 0x00046e73cd2a6147UL;
   tf->codes[6999] = 0x00046e7e8d6c7072UL;
   tf->codes[7000] = 0x00046e832098e3d6UL;
   tf->codes[7001] = 0x00046e8bd1d3bf14UL;
   tf->codes[7002] = 0x00046eb5e89fe4acUL;
   tf->codes[7003] = 0x00046eb6232eea71UL;
   tf->codes[7004] = 0x00046ebb66086f24UL;
   tf->codes[7005] = 0x00046ebe24bcb460UL;
   tf->codes[7006] = 0x00046ebfbea5dcc3UL;
   tf->codes[7007] = 0x00046ec7c033a6b2UL;
   tf->codes[7008] = 0x00046ecbde420e8cUL;
   tf->codes[7009] = 0x00046ecc8def1fdbUL;
   tf->codes[7010] = 0x00046ed20b57aa53UL;
   tf->codes[7011] = 0x00046ed7c34f3a90UL;
   tf->codes[7012] = 0x00046edd0628bf43UL;
   tf->codes[7013] = 0x00046eeafa3d1f34UL;
   tf->codes[7014] = 0x00046eeb34cc24f9UL;
   tf->codes[7015] = 0x00046ef24c1dd7d4UL;
   tf->codes[7016] = 0x00046ef50ad21d10UL;
   tf->codes[7017] = 0x00046ef62f9d39e9UL;
   tf->codes[7018] = 0x00046f03e9229415UL;
   tf->codes[7019] = 0x00046f128ce40555UL;
   tf->codes[7020] = 0x00046f1b3e1ee093UL;
   tf->codes[7021] = 0x00046f45ca0911b5UL;
   tf->codes[7022] = 0x00046f5ce476586eUL;
   tf->codes[7023] = 0x00046f6ad88ab85fUL;
   tf->codes[7024] = 0x00046f6f6bb72bc3UL;
   tf->codes[7025] = 0x00046f717abe5fb0UL;
   tf->codes[7026] = 0x00046f743972a4ecUL;
   tf->codes[7027] = 0x00046f789210128bUL;
   tf->codes[7028] = 0x00046f87aaef8f55UL;
   tf->codes[7029] = 0x00046f8d285819cdUL;
   tf->codes[7030] = 0x00046f91bb848d31UL;
   tf->codes[7031] = 0x00046f943fa9cca8UL;
   tf->codes[7032] = 0x00046f9b56fb7f83UL;
   tf->codes[7033] = 0x00046f9ec55cd60eUL;
   tf->codes[7034] = 0x00046f9faf98ed22UL;
   tf->codes[7035] = 0x00046fafb2b48100UL;
   tf->codes[7036] = 0x00046fba72f6902bUL;
   tf->codes[7037] = 0x00046fbd6c39db2cUL;
   tf->codes[7038] = 0x00046fbda6c8e0f1UL;
   tf->codes[7039] = 0x00046fbf40b20954UL;
   tf->codes[7040] = 0x00046fc35ec0712eUL;
   tf->codes[7041] = 0x00046fc40e6d827dUL;
   tf->codes[7042] = 0x00046fc7b75ddecdUL;
   tf->codes[7043] = 0x00046fc8dc28fba6UL;
   tf->codes[7044] = 0x00046fdb9df8d4c0UL;
   tf->codes[7045] = 0x00046feff9b1d63dUL;
   tf->codes[7046] = 0x00046ff6d6748353UL;
   tf->codes[7047] = 0x00046ff8705dabb6UL;
   tf->codes[7048] = 0x0004701db96e5825UL;
   tf->codes[7049] = 0x00047029295d789fUL;
   tf->codes[7050] = 0x0004702be811bddbUL;
   tf->codes[7051] = 0x0004702c22a0c3a0UL;
   tf->codes[7052] = 0x00047040f377d0a7UL;
   tf->codes[7053] = 0x000470449c682cf7UL;
   tf->codes[7054] = 0x000470463651555aUL;
   tf->codes[7055] = 0x0004704cd884fcabUL;
   tf->codes[7056] = 0x000470516bb1700fUL;
   tf->codes[7057] = 0x00047056ae8af4c2UL;
   tf->codes[7058] = 0x0004705a1cec4b4dUL;
   tf->codes[7059] = 0x0004705acc995c9cUL;
   tf->codes[7060] = 0x0004705bb6d573b0UL;
   tf->codes[7061] = 0x0004705eeaa7c476UL;
   tf->codes[7062] = 0x0004706ca42d1ea2UL;
   tf->codes[7063] = 0x000470746b2be2ccUL;
   tf->codes[7064] = 0x000470758ff6ffa5UL;
   tf->codes[7065] = 0x00047078893a4aa6UL;
   tf->codes[7066] = 0x0004707a23237309UL;
   tf->codes[7067] = 0x0004707ca748b280UL;
   tf->codes[7068] = 0x00047082d45e4e47UL;
   tf->codes[7069] = 0x000470867d4eaa97UL;
   tf->codes[7070] = 0x0004709c72f0d477UL;
   tf->codes[7071] = 0x000470af34c0ad91UL;
   tf->codes[7072] = 0x000470b0941ad02fUL;
   tf->codes[7073] = 0x000470b38d5e1b30UL;
   tf->codes[7074] = 0x000470b9ba73b6f7UL;
   tf->codes[7075] = 0x000470c52a62d771UL;
   tf->codes[7076] = 0x000470c6fedb0599UL;
   tf->codes[7077] = 0x000470cc7c439011UL;
   tf->codes[7078] = 0x000470dae575fb8cUL;
   tf->codes[7079] = 0x000470dec8f55da1UL;
   tf->codes[7080] = 0x000470df78a26ef0UL;
   tf->codes[7081] = 0x000470eecc10f17fUL;
   tf->codes[7082] = 0x000470f40eea7632UL;
   tf->codes[7083] = 0x000470f82cf8de0cUL;
   tf->codes[7084] = 0x0004710118c2bf0fUL;
   tf->codes[7085] = 0x0004710536d126e9UL;
   tf->codes[7086] = 0x0004711031a23bd9UL;
   tf->codes[7087] = 0x0004711b2c7350c9UL;
   tf->codes[7088] = 0x000471415fc0144cUL;
   tf->codes[7089] = 0x000471419a4f1a11UL;
   tf->codes[7090] = 0x00047143a9564dfeUL;
   tf->codes[7091] = 0x00047143e3e553c3UL;
   tf->codes[7092] = 0x0004716a51c11d0bUL;
   tf->codes[7093] = 0x00047172c86cf284UL;
   tf->codes[7094] = 0x00047173b2a90998UL;
   tf->codes[7095] = 0x0004717a1a4dab24UL;
   tf->codes[7096] = 0x0004717b3f18c7fdUL;
   tf->codes[7097] = 0x000471916f49f7a2UL;
   tf->codes[7098] = 0x00047193f36f3719UL;
   tf->codes[7099] = 0x000471a4e0c6e20bUL;
   tf->codes[7100] = 0x000471b4e3e275e9UL;
   tf->codes[7101] = 0x000471b85243cc74UL;
   tf->codes[7102] = 0x000471bad6690bebUL;
   tf->codes[7103] = 0x000471c3c232eceeUL;
   tf->codes[7104] = 0x000471cce88bd3b6UL;
   tf->codes[7105] = 0x000471cf32220d68UL;
   tf->codes[7106] = 0x000471d3c54e80ccUL;
   tf->codes[7107] = 0x000471dfaa5bacd0UL;
   tf->codes[7108] = 0x000471e562533d0dUL;
   tf->codes[7109] = 0x000471ee88ac23d5UL;
   tf->codes[7110] = 0x000471f26c2b85eaUL;
   tf->codes[7111] = 0x000471f6ff57f94eUL;
   tf->codes[7112] = 0x000471ffb092d48cUL;
   tf->codes[7113] = 0x0004720b2081f506UL;
   tf->codes[7114] = 0x0004720cba6b1d69UL;
   tf->codes[7115] = 0x0004720f3e905ce0UL;
   tf->codes[7116] = 0x000472109dea7f7eUL;
   tf->codes[7117] = 0x000472194f255abcUL;
   tf->codes[7118] = 0x00047219fed26c0bUL;
   tf->codes[7119] = 0x0004721a396171d0UL;
   tf->codes[7120] = 0x0004721de251ce20UL;
   tf->codes[7121] = 0x00047226ce1baf23UL;
   tf->codes[7122] = 0x0004722ff47495ebUL;
   tf->codes[7123] = 0x000472341282fdc5UL;
   tf->codes[7124] = 0x00047236218a31b2UL;
   tf->codes[7125] = 0x0004723d736aea52UL;
   tf->codes[7126] = 0x0004724206975db6UL;
   tf->codes[7127] = 0x0004724699c3d11aUL;
   tf->codes[7128] = 0x0004724deba489baUL;
   tf->codes[7129] = 0x0004724f106fa693UL;
   tf->codes[7130] = 0x000472532e7e0e6dUL;
   tf->codes[7131] = 0x0004725a0b40bb83UL;
   tf->codes[7132] = 0x0004725fc3384bc0UL;
   tf->codes[7133] = 0x0004726281ec90fcUL;
   tf->codes[7134] = 0x00047268747326feUL;
   tf->codes[7135] = 0x0004727b70d205ddUL;
   tf->codes[7136] = 0x00047283aceed591UL;
   tf->codes[7137] = 0x00047294252874f9UL;
   tf->codes[7138] = 0x00047296e3dcba35UL;
   tf->codes[7139] = 0x0004729b01eb220fUL;
   tf->codes[7140] = 0x0004729b3c7a27d4UL;
   tf->codes[7141] = 0x0004729bec273923UL;
   tf->codes[7142] = 0x0004729c26b63ee8UL;
   tf->codes[7143] = 0x000472b4db0cae04UL;
   tf->codes[7144] = 0x000472b5c548c518UL;
   tf->codes[7145] = 0x000472b933aa1ba3UL;
   tf->codes[7146] = 0x000472bc2ced66a4UL;
   tf->codes[7147] = 0x000472c5c86458f6UL;
   tf->codes[7148] = 0x000472c6b2a0700aUL;
   tf->codes[7149] = 0x000472cb0b3ddda9UL;
   tf->codes[7150] = 0x000472cc6a980047UL;
   tf->codes[7151] = 0x000472d590f0e70fUL;
   tf->codes[7152] = 0x000472d7da8720c1UL;
   tf->codes[7153] = 0x000472dd927eb0feUL;
   tf->codes[7154] = 0x000472df66f6df26UL;
   tf->codes[7155] = 0x000472e2603a2a27UL;
   tf->codes[7156] = 0x000472e46f415e14UL;
   tf->codes[7157] = 0x000472e6b8d797c6UL;
   tf->codes[7158] = 0x000472e7dda2b49fUL;
   tf->codes[7159] = 0x000472eb869310efUL;
   tf->codes[7160] = 0x000472eeba6561b5UL;
   tf->codes[7161] = 0x000472ef6a127304UL;
   tf->codes[7162] = 0x000472f0c96c95a2UL;
   tf->codes[7163] = 0x000472f81b4d4e42UL;
   tf->codes[7164] = 0x000472fa2a54822fUL;
   tf->codes[7165] = 0x000472fe0dd3e444UL;
   tf->codes[7166] = 0x000473017c353acfUL;
   tf->codes[7167] = 0x00047304757885d0UL;
   tf->codes[7168] = 0x0004731ae038bb3aUL;
   tf->codes[7169] = 0x00047327af81fe52UL;
   tf->codes[7170] = 0x0004734063d86d6eUL;
   tf->codes[7171] = 0x000473414e148482UL;
   tf->codes[7172] = 0x00047345e140f7e6UL;
   tf->codes[7173] = 0x000473644d8ef73fUL;
   tf->codes[7174] = 0x00047371cc854ba6UL;
   tf->codes[7175] = 0x000473770f5ed059UL;
   tf->codes[7176] = 0x00047386283e4d23UL;
   tf->codes[7177] = 0x0004739d42ab93dcUL;
   tf->codes[7178] = 0x000473a41f6e40f2UL;
   tf->codes[7179] = 0x000473acd0a91c30UL;
   tf->codes[7180] = 0x000473b54754f1a9UL;
   tf->codes[7181] = 0x000473c634ac9c9bUL;
   tf->codes[7182] = 0x000473c80924cac3UL;
   tf->codes[7183] = 0x000473cbb2152713UL;
   tf->codes[7184] = 0x000473cbeca42cd8UL;
   tf->codes[7185] = 0x000473e4a0fa9bf4UL;
   tf->codes[7186] = 0x000473e4db89a1b9UL;
   tf->codes[7187] = 0x000473e96eb6151dUL;
   tf->codes[7188] = 0x000473f6788e5dfaUL;
   tf->codes[7189] = 0x000473fdca6f169aUL;
   tf->codes[7190] = 0x00047402230c8439UL;
   tf->codes[7191] = 0x0004740ce34e9364UL;
   tf->codes[7192] = 0x0004741818aeae19UL;
   tf->codes[7193] = 0x0004743684fcad72UL;
   tf->codes[7194] = 0x0004743c77834374UL;
   tf->codes[7195] = 0x00047448971f753dUL;
   tf->codes[7196] = 0x0004744d9f69f42bUL;
   tf->codes[7197] = 0x00047475e1bdeb9bUL;
   tf->codes[7198] = 0x000474777ba713feUL;
   tf->codes[7199] = 0x00047479c53d4db0UL;
   tf->codes[7200] = 0x0004747c0ed38762UL;
   tf->codes[7201] = 0x0004747d6e2daa00UL;
   tf->codes[7202] = 0x0004748b9cd10fb6UL;
   tf->codes[7203] = 0x000474923f04b707UL;
   tf->codes[7204] = 0x00047497bc6d417fUL;
   tf->codes[7205] = 0x00047498e1385e58UL;
   tf->codes[7206] = 0x0004749bda7ba959UL;
   tf->codes[7207] = 0x000474adb20f6b5fUL;
   tf->codes[7208] = 0x000474b1958ecd74UL;
   tf->codes[7209] = 0x000474c20dc86cdcUL;
   tf->codes[7210] = 0x000474c8756d0e68UL;
   tf->codes[7211] = 0x000474d5b9d45d0aUL;
   tf->codes[7212] = 0x000474d7c8db90f7UL;
   tf->codes[7213] = 0x000474da878fd633UL;
   tf->codes[7214] = 0x000474e58260eb23UL;
   tf->codes[7215] = 0x000474e5bceff0e8UL;
   tf->codes[7216] = 0x000474e6e1bb0dc1UL;
   tf->codes[7217] = 0x000474f460b16228UL;
   tf->codes[7218] = 0x000474fb02e50979UL;
   tf->codes[7219] = 0x000474ff20f37153UL;
   tf->codes[7220] = 0x000474ffd0a082a2UL;
   tf->codes[7221] = 0x000475016a89ab05UL;
   tf->codes[7222] = 0x0004750e7461f3e2UL;
   tf->codes[7223] = 0x0004750f5e9e0af6UL;
   tf->codes[7224] = 0x000475100e4b1c45UL;
   tf->codes[7225] = 0x0004751292705bbcUL;
   tf->codes[7226] = 0x00047513078e6746UL;
   tf->codes[7227] = 0x00047514a1778fa9UL;
   tf->codes[7228] = 0x0004751516959b33UL;
   tf->codes[7229] = 0x0004751c687653d3UL;
   tf->codes[7230] = 0x00047527d865744dUL;
   tf->codes[7231] = 0x00047535cc79d43eUL;
   tf->codes[7232] = 0x00047539aff93653UL;
   tf->codes[7233] = 0x0004753ce3cb8719UL;
   tf->codes[7234] = 0x0004754e46413d95UL;
   tf->codes[7235] = 0x0004754f307d54a9UL;
   tf->codes[7236] = 0x00047559b6305e0fUL;
   tf->codes[7237] = 0x0004755bffc697c1UL;
   tf->codes[7238] = 0x0004755dd43ec5e9UL;
   tf->codes[7239] = 0x000475759e591df1UL;
   tf->codes[7240] = 0x000475894a650e1fUL;
   tf->codes[7241] = 0x0004758a34a12533UL;
   tf->codes[7242] = 0x000475be96914e6cUL;
   tf->codes[7243] = 0x000475c204f2a4f7UL;
   tf->codes[7244] = 0x000475c413f9d8e4UL;
   tf->codes[7245] = 0x000475cfbe77ff23UL;
   tf->codes[7246] = 0x000475d959eef175UL;
   tf->codes[7247] = 0x000475de27aa6a9eUL;
   tf->codes[7248] = 0x000475ea81d5a22cUL;
   tf->codes[7249] = 0x000475ed05fae1a3UL;
   tf->codes[7250] = 0x000476045af72e21UL;
   tf->codes[7251] = 0x0004761005755460UL;
   tf->codes[7252] = 0x00047618f13f3563UL;
   tf->codes[7253] = 0x0004761a160a523cUL;
   tf->codes[7254] = 0x0004761c9a2f91b3UL;
   tf->codes[7255] = 0x0004761e6ea7bfdbUL;
   tf->codes[7256] = 0x0004762585f972b6UL;
   tf->codes[7257] = 0x000476416e223298UL;
   tf->codes[7258] = 0x00047647d5c6d424UL;
   tf->codes[7259] = 0x000476488573e573UL;
   tf->codes[7260] = 0x000476530b26eed9UL;
   tf->codes[7261] = 0x0004765d90d9f83fUL;
   tf->codes[7262] = 0x000476743629336eUL;
   tf->codes[7263] = 0x000476829f5b9ee9UL;
   tf->codes[7264] = 0x00047684ae62d2d6UL;
   tf->codes[7265] = 0x00047687e235239cUL;
   tf->codes[7266] = 0x0004768adb786e9dUL;
   tf->codes[7267] = 0x000476985a6ec304UL;
   tf->codes[7268] = 0x0004769b8e4113caUL;
   tf->codes[7269] = 0x000476a529b8061cUL;
   tf->codes[7270] = 0x000476b233904ef9UL;
   tf->codes[7271] = 0x000476b392ea7197UL;
   tf->codes[7272] = 0x000476c61a2b44ecUL;
   tf->codes[7273] = 0x000476c654ba4ab1UL;
   tf->codes[7274] = 0x000476cf7b133179UL;
   tf->codes[7275] = 0x000476d18a1a6566UL;
   tf->codes[7276] = 0x000476d239c776b5UL;
   tf->codes[7277] = 0x000476d35e92938eUL;
   tf->codes[7278] = 0x000476d69264e454UL;
   tf->codes[7279] = 0x000476df7e2ec557UL;
   tf->codes[7280] = 0x000476dfb8bdcb1cUL;
   tf->codes[7281] = 0x000476fe5f9ad03aUL;
   tf->codes[7282] = 0x00047704c73f71c6UL;
   tf->codes[7283] = 0x00047707c082bcc7UL;
   tf->codes[7284] = 0x0004770bde9124a1UL;
   tf->codes[7285] = 0x0004770db30952c9UL;
   tf->codes[7286] = 0x0004773127a1d110UL;
   tf->codes[7287] = 0x000477316230d6d5UL;
   tf->codes[7288] = 0x0004773420e51c11UL;
   tf->codes[7289] = 0x0004773cd21ff74fUL;
   tf->codes[7290] = 0x0004773f90d43c8bUL;
   tf->codes[7291] = 0x000477424f8881c7UL;
   tf->codes[7292] = 0x000477528d331b6aUL;
   tf->codes[7293] = 0x0004775a5431df94UL;
   tf->codes[7294] = 0x0004775bee1b07f7UL;
   tf->codes[7295] = 0x0004776f5f97f260UL;
   tf->codes[7296] = 0x00047779702cf03cUL;
   tf->codes[7297] = 0x0004777ca3ff4102UL;
   tf->codes[7298] = 0x0004778938b97e55UL;
   tf->codes[7299] = 0x0004778bbcdebdccUL;
   tf->codes[7300] = 0x0004778c6c8bcf1bUL;
   tf->codes[7301] = 0x00047794338a9345UL;
   tf->codes[7302] = 0x00047799766417f8UL;
   tf->codes[7303] = 0x0004779d1f547448UL;
   tf->codes[7304] = 0x0004779fa379b3bfUL;
   tf->codes[7305] = 0x000477b1b59c7b8aUL;
   tf->codes[7306] = 0x000477c85aebb6b9UL;
   tf->codes[7307] = 0x000477d89896505cUL;
   tf->codes[7308] = 0x000477e358d85f87UL;
   tf->codes[7309] = 0x000477e47da37c60UL;
   tf->codes[7310] = 0x000477e4f2c187eaUL;
   tf->codes[7311] = 0x000477e6c739b612UL;
   tf->codes[7312] = 0x000477eb5a662976UL;
   tf->codes[7313] = 0x000477f704e44fb5UL;
   tf->codes[7314] = 0x000477f7ef2066c9UL;
   tf->codes[7315] = 0x000478002b3d367dUL;
   tf->codes[7316] = 0x0004781c4df4fc24UL;
   tf->codes[7317] = 0x0004782ba1637eb3UL;
   tf->codes[7318] = 0x0004782e6017c3efUL;
   tf->codes[7319] = 0x0004783661a58ddeUL;
   tf->codes[7320] = 0x0004783d3e683af4UL;
   tf->codes[7321] = 0x0004784a82cf8996UL;
   tf->codes[7322] = 0x000478520f3f47fbUL;
   tf->codes[7323] = 0x00047854cdf38d37UL;
   tf->codes[7324] = 0x00047855b82fa44bUL;
   tf->codes[7325] = 0x000478650b9e26daUL;
   tf->codes[7326] = 0x00047871a058642dUL;
   tf->codes[7327] = 0x00047893f025c59bUL;
   tf->codes[7328] = 0x000478949fd2d6eaUL;
   tf->codes[7329] = 0x00047895c49df3c3UL;
   tf->codes[7330] = 0x00047896e969109cUL;
   tf->codes[7331] = 0x00047898bde13ec4UL;
   tf->codes[7332] = 0x0004789c66d19b14UL;
   tf->codes[7333] = 0x0004789e00bac377UL;
   tf->codes[7334] = 0x000478a3b8b253b4UL;
   tf->codes[7335] = 0x000478abba401da3UL;
   tf->codes[7336] = 0x000478af9dbf7fb8UL;
   tf->codes[7337] = 0x000478b221e4bf2fUL;
   tf->codes[7338] = 0x000478b7d9dc4f6cUL;
   tf->codes[7339] = 0x000478b973c577cfUL;
   tf->codes[7340] = 0x000478bce226ce5aUL;
   tf->codes[7341] = 0x000478bd1cb5d41fUL;
   tf->codes[7342] = 0x000478bdcc62e56eUL;
   tf->codes[7343] = 0x000478cc359550e9UL;
   tf->codes[7344] = 0x000478dbfe21df02UL;
   tf->codes[7345] = 0x000478def7652a03UL;
   tf->codes[7346] = 0x000478e8cd6b221aUL;
   tf->codes[7347] = 0x000478f3531e2b80UL;
   tf->codes[7348] = 0x000478f7abbb991fUL;
   tf->codes[7349] = 0x000478f85b68aa6eUL;
   tf->codes[7350] = 0x000478fdd8d134e6UL;
   tf->codes[7351] = 0x00047904b593e1fcUL;
   tf->codes[7352] = 0x0004791c7fae3a04UL;
   tf->codes[7353] = 0x000479277a7f4ef4UL;
   tf->codes[7354] = 0x00047931c5a35295UL;
   tf->codes[7355] = 0x00047934845797d1UL;
   tf->codes[7356] = 0x0004793cc0746785UL;
   tf->codes[7357] = 0x000479465beb59d7UL;
   tf->codes[7358] = 0x0004794f47b53adaUL;
   tf->codes[7359] = 0x0004795365c3a2b4UL;
   tf->codes[7360] = 0x00047955af59dc66UL;
   tf->codes[7361] = 0x0004795ab7a45b54UL;
   tf->codes[7362] = 0x000479606f9beb91UL;
   tf->codes[7363] = 0x000479669cb18758UL;
   tf->codes[7364] = 0x00047967c17ca431UL;
   tf->codes[7365] = 0x0004796fc30a6e20UL;
   tf->codes[7366] = 0x00047970e7d58af9UL;
   tf->codes[7367] = 0x000479715cf39683UL;
   tf->codes[7368] = 0x00047972472fad97UL;
   tf->codes[7369] = 0x00047977c498380fUL;
   tf->codes[7370] = 0x0004797a834c7d4bUL;
   tf->codes[7371] = 0x0004797c1d35a5aeUL;
   tf->codes[7372] = 0x0004797e2c3cd99bUL;
   tf->codes[7373] = 0x0004798c956f4516UL;
   tf->codes[7374] = 0x0004798e2f586d79UL;
   tf->codes[7375] = 0x0004799a1465997dUL;
   tf->codes[7376] = 0x0004799afea1b091UL;
   tf->codes[7377] = 0x0004799c5dfbd32fUL;
   tf->codes[7378] = 0x000479ab01bd446fUL;
   tf->codes[7379] = 0x000479b9a57eb5afUL;
   tf->codes[7380] = 0x000479bc6432faebUL;
   tf->codes[7381] = 0x000479bc9ec200b0UL;
   tf->codes[7382] = 0x000479ca58475adcUL;
   tf->codes[7383] = 0x000479e5563403aaUL;
   tf->codes[7384] = 0x000479eb83499f71UL;
   tf->codes[7385] = 0x000479ee076edee8UL;
   tf->codes[7386] = 0x000479feba378415UL;
   tf->codes[7387] = 0x00047a0437a00e8dUL;
   tf->codes[7388] = 0x00047a08903d7c2cUL;
   tf->codes[7389] = 0x00047a0cae4be406UL;
   tf->codes[7390] = 0x00047a1d2685836eUL;
   tf->codes[7391] = 0x00047a2cb4830bc2UL;
   tf->codes[7392] = 0x00047a31f75c9075UL;
   tf->codes[7393] = 0x00047a35dadbf28aUL;
   tf->codes[7394] = 0x00047a36156af84fUL;
   tf->codes[7395] = 0x00047a37e9e32677UL;
   tf->codes[7396] = 0x00047a3c07f18e51UL;
   tf->codes[7397] = 0x00047a3c7d0f99dbUL;
   tf->codes[7398] = 0x00047a3da1dab6b4UL;
   tf->codes[7399] = 0x00047a3ddc69bc79UL;
   tf->codes[7400] = 0x00047a468da497b7UL;
   tf->codes[7401] = 0x00047a4986e7e2b8UL;
   tf->codes[7402] = 0x00047a4b95ef16a5UL;
   tf->codes[7403] = 0x00047a5b23ec9ef9UL;
   tf->codes[7404] = 0x00047a639a987472UL;
   tf->codes[7405] = 0x00047a702f52b1c5UL;
   tf->codes[7406] = 0x00047a75379d30b3UL;
   tf->codes[7407] = 0x00047a7e5df6177bUL;
   tf->codes[7408] = 0x00047a8c520a776cUL;
   tf->codes[7409] = 0x00047a948e274720UL;
   tf->codes[7410] = 0x00047aa95efe5427UL;
   tf->codes[7411] = 0x00047ab03bc1013dUL;
   tf->codes[7412] = 0x00047ab285573aefUL;
   tf->codes[7413] = 0x00047acc5e78c6e4UL;
   tf->codes[7414] = 0x00047ad84385f2e8UL;
   tf->codes[7415] = 0x00047adbb1e74973UL;
   tf->codes[7416] = 0x00047ae2c938fc4eUL;
   tf->codes[7417] = 0x00047aed145cffefUL;
   tf->codes[7418] = 0x00047af75f810390UL;
   tf->codes[7419] = 0x00047afd8c969f57UL;
   tf->codes[7420] = 0x00047b167b7c1438UL;
   tf->codes[7421] = 0x00047b17dad636d6UL;
   tf->codes[7422] = 0x00047b1b83c69326UL;
   tf->codes[7423] = 0x00047b2f2fd28354UL;
   tf->codes[7424] = 0x00047b3a9fc1a3ceUL;
   tf->codes[7425] = 0x00047b4141f54b1fUL;
   tf->codes[7426] = 0x00047b4475c79be5UL;
   tf->codes[7427] = 0x00047b4a2dbf2c22UL;
   tf->codes[7428] = 0x00047b4a684e31e7UL;
   tf->codes[7429] = 0x00047b4b17fb4336UL;
   tf->codes[7430] = 0x00047b585c6291d8UL;
   tf->codes[7431] = 0x00047b5e89782d9fUL;
   tf->codes[7432] = 0x00047b68d49c3140UL;
   tf->codes[7433] = 0x00047b690f2b3705UL;
   tf->codes[7434] = 0x00047b7394de406bUL;
   tf->codes[7435] = 0x00047b76c8b09131UL;
   tf->codes[7436] = 0x00047b794cd5d0a8UL;
   tf->codes[7437] = 0x00047b7f3f5c66aaUL;
   tf->codes[7438] = 0x00047b9067431761UL;
   tf->codes[7439] = 0x00047b9659c9ad63UL;
   tf->codes[7440] = 0x00047b9ff5409fb5UL;
   tf->codes[7441] = 0x00047bac89fadd08UL;
   tf->codes[7442] = 0x00047bbe26ff9949UL;
   tf->codes[7443] = 0x00047bc19560efd4UL;
   tf->codes[7444] = 0x00047bc9d17dbf88UL;
   tf->codes[7445] = 0x00047bca0c0cc54dUL;
   tf->codes[7446] = 0x00047bcd3fdf1613UL;
   tf->codes[7447] = 0x00047bd3a783b79fUL;
   tf->codes[7448] = 0x00047bd62ba8f716UL;
   tf->codes[7449] = 0x00047be6695390b9UL;
   tf->codes[7450] = 0x00047bf19eb3ab6eUL;
   tf->codes[7451] = 0x00047bf9dad07b22UL;
   tf->codes[7452] = 0x00047c13b3f20717UL;
   tf->codes[7453] = 0x00047c14d8bd23f0UL;
   tf->codes[7454] = 0x00047c154ddb2f7aUL;
   tf->codes[7455] = 0x00047c196be99754UL;
   tf->codes[7456] = 0x00047c2dc7a298d1UL;
   tf->codes[7457] = 0x00047c3554125736UL;
   tf->codes[7458] = 0x00047c4d58bbb503UL;
   tf->codes[7459] = 0x00047c5176ca1cddUL;
   tf->codes[7460] = 0x00047c5b12410f2fUL;
   tf->codes[7461] = 0x00047c5cac2a3792UL;
   tf->codes[7462] = 0x00047c5ce6b93d57UL;
   tf->codes[7463] = 0x00047c60551a93e2UL;
   tf->codes[7464] = 0x00047c69b602806fUL;
   tf->codes[7465] = 0x00047c6caf45cb70UL;
   tf->codes[7466] = 0x00047c7ec168933bUL;
   tf->codes[7467] = 0x00047c81f53ae401UL;
   tf->codes[7468] = 0x00047c864dd851a0UL;
   tf->codes[7469] = 0x00047c8822507fc8UL;
   tf->codes[7470] = 0x00047c8bcb40dc18UL;
   tf->codes[7471] = 0x00047c8dda481005UL;
   tf->codes[7472] = 0x00047c8e14d715caUL;
   tf->codes[7473] = 0x00047c9f022ec0bcUL;
   tf->codes[7474] = 0x00047c9fb1dbd20bUL;
   tf->codes[7475] = 0x00047cb1fe8d9f9bUL;
   tf->codes[7476] = 0x00047cb9506e583bUL;
   tf->codes[7477] = 0x00047ccde6b65f7dUL;
   tf->codes[7478] = 0x00047cce5bd46b07UL;
   tf->codes[7479] = 0x00047cd11a88b043UL;
   tf->codes[7480] = 0x00047cd488ea06ceUL;
   tf->codes[7481] = 0x00047cd831da631eUL;
   tf->codes[7482] = 0x00047ce74ab9dfe8UL;
   tf->codes[7483] = 0x00047cea7e8c30aeUL;
   tf->codes[7484] = 0x00047cedeced8739UL;
   tf->codes[7485] = 0x00047ceed7299e4dUL;
   tf->codes[7486] = 0x00047cfb3154d5dbUL;
   tf->codes[7487] = 0x00047cfccb3dfe3eUL;
   tf->codes[7488] = 0x00047d1d0c042bbfUL;
   tf->codes[7489] = 0x00047d333c355b64UL;
   tf->codes[7490] = 0x00047d3dc1e864caUL;
   tf->codes[7491] = 0x00047d449eab11e0UL;
   tf->codes[7492] = 0x00047d48bcb979baUL;
   tf->codes[7493] = 0x00047d4c65a9d60aUL;
   tf->codes[7494] = 0x00047d5acedc4185UL;
   tf->codes[7495] = 0x00047d5b096b474aUL;
   tf->codes[7496] = 0x00047d5f2779af24UL;
   tf->codes[7497] = 0x00047d65c9ad5675UL;
   tf->codes[7498] = 0x00047d6a9768cf9eUL;
   tf->codes[7499] = 0x00047d6eb5773778UL;
   tf->codes[7500] = 0x00047d704f605fdbUL;
   tf->codes[7501] = 0x00047d79009b3b19UL;
   tf->codes[7502] = 0x00047d7d93c7ae7dUL;
   tf->codes[7503] = 0x00047d872f3ea0cfUL;
   tf->codes[7504] = 0x00047dad628b6452UL;
   tf->codes[7505] = 0x00047dae4cc77b66UL;
   tf->codes[7506] = 0x00047db85d5c7942UL;
   tf->codes[7507] = 0x00047dc233627159UL;
   tf->codes[7508] = 0x00047dc2a8807ce3UL;
   tf->codes[7509] = 0x00047dc44269a546UL;
   tf->codes[7510] = 0x00047dc8d59618aaUL;
   tf->codes[7511] = 0x00047dc94ab42434UL;
   tf->codes[7512] = 0x00047de8dbcd4066UL;
   tf->codes[7513] = 0x00047df20226272eUL;
   tf->codes[7514] = 0x00047df3d69e5556UL;
   tf->codes[7515] = 0x00047df4112d5b1bUL;
   tf->codes[7516] = 0x00047df4864b66a5UL;
   tf->codes[7517] = 0x00047e07bd394b49UL;
   tf->codes[7518] = 0x00047e0e24ddecd5UL;
   tf->codes[7519] = 0x00047e25eef844ddUL;
   tf->codes[7520] = 0x00047e3199766b1cUL;
   tf->codes[7521] = 0x00047e31d40570e1UL;
   tf->codes[7522] = 0x00047e362ca2de80UL;
   tf->codes[7523] = 0x00047e416202f935UL;
   tf->codes[7524] = 0x00047e462fbe725eUL;
   tf->codes[7525] = 0x00047e48b3e3b1d5UL;
   tf->codes[7526] = 0x00047e592c1d513dUL;
   tf->codes[7527] = 0x00047e5c9a7ea7c8UL;
   tf->codes[7528] = 0x00047e63b1d05aa3UL;
   tf->codes[7529] = 0x00047e6dfcf45e44UL;
   tf->codes[7530] = 0x00047e70bba8a380UL;
   tf->codes[7531] = 0x00047e7d15d3db0eUL;
   tf->codes[7532] = 0x00047e7e752dfdacUL;
   tf->codes[7533] = 0x00047e8810a4effeUL;
   tf->codes[7534] = 0x00047e884b33f5c3UL;
   tf->codes[7535] = 0x00047e8d8e0d7a76UL;
   tf->codes[7536] = 0x00047e8e7849918aUL;
   tf->codes[7537] = 0x00047e91ac1be250UL;
   tf->codes[7538] = 0x00047e929657f964UL;
   tf->codes[7539] = 0x00047e99ada9ac3fUL;
   tf->codes[7540] = 0x00047eac34ea7f94UL;
   tf->codes[7541] = 0x00047ebbfd770dadUL;
   tf->codes[7542] = 0x00047ecf3464f251UL;
   tf->codes[7543] = 0x00047ed093bf14efUL;
   tf->codes[7544] = 0x00047ed735f2bc40UL;
   tf->codes[7545] = 0x00047eddd8266391UL;
   tf->codes[7546] = 0x00047edefcf1806aUL;
   tf->codes[7547] = 0x00047eed2b94e620UL;
   tf->codes[7548] = 0x00047f040b732714UL;
   tf->codes[7549] = 0x00047f18dc4a341bUL;
   tf->codes[7550] = 0x00047f1916d939e0UL;
   tf->codes[7551] = 0x00047f1ab0c26243UL;
   tf->codes[7552] = 0x00047f1d6f76a77fUL;
   tf->codes[7553] = 0x00047f4b69c22f2cUL;
   tf->codes[7554] = 0x00047f59986594e2UL;
   tf->codes[7555] = 0x00047f5db673fcbcUL;
   tf->codes[7556] = 0x00047f68ebd41771UL;
   tf->codes[7557] = 0x00047f6f18e9b338UL;
   tf->codes[7558] = 0x00047f77ca248e76UL;
   tf->codes[7559] = 0x00047f8967294ab7UL;
   tf->codes[7560] = 0x00047f8f943ee67eUL;
   tf->codes[7561] = 0x00047f8fcecdec43UL;
   tf->codes[7562] = 0x00047f94d7186b31UL;
   tf->codes[7563] = 0x00047fb468318763UL;
   tf->codes[7564] = 0x00047fb81121e3b3UL;
   tf->codes[7565] = 0x00047fb935ed008cUL;
   tf->codes[7566] = 0x00047fbe03a879b5UL;
   tf->codes[7567] = 0x00047fbeede490c9UL;
   tf->codes[7568] = 0x00047fc430be157cUL;
   tf->codes[7569] = 0x00047fd60851d782UL;
   tf->codes[7570] = 0x00047fda60ef4521UL;
   tf->codes[7571] = 0x00047fe1b2cffdc1UL;
   tf->codes[7572] = 0x00047fe4e6a24e87UL;
   tf->codes[7573] = 0x00047ff0912074c6UL;
   tf->codes[7574] = 0x00048002a3433c91UL;
   tf->codes[7575] = 0x00048007366faff5UL;
   tf->codes[7576] = 0x000480090ae7de1dUL;
   tf->codes[7577] = 0x000480098005e9a7UL;
   tf->codes[7578] = 0x0004800b547e17cfUL;
   tf->codes[7579] = 0x0004800f728c7fa9UL;
   tf->codes[7580] = 0x00048012a65ed06fUL;
   tf->codes[7581] = 0x0004801cf182d410UL;
   tf->codes[7582] = 0x0004802d69bc7378UL;
   tf->codes[7583] = 0x0004802f3e34a1a0UL;
   tf->codes[7584] = 0x00048039c3e7ab06UL;
   tf->codes[7585] = 0x0004803c0d7de4b8UL;
   tf->codes[7586] = 0x0004803d6cd80756UL;
   tf->codes[7587] = 0x0004803e91a3242fUL;
   tf->codes[7588] = 0x00048040db395de1UL;
   tf->codes[7589] = 0x000480461e12e294UL;
   tf->codes[7590] = 0x00048048a238220bUL;
   tf->codes[7591] = 0x0004804daa82a0f9UL;
   tf->codes[7592] = 0x000480515372fd49UL;
   tf->codes[7593] = 0x0004805536f25f5eUL;
   tf->codes[7594] = 0x0004805e97da4bebUL;
   tf->codes[7595] = 0x0004805ed26951b0UL;
   tf->codes[7596] = 0x000480606c527a13UL;
   tf->codes[7597] = 0x00048068e2fe4f8cUL;
   tf->codes[7598] = 0x00048069cd3a66a0UL;
   tf->codes[7599] = 0x0004806a07c96c65UL;
   tf->codes[7600] = 0x0004806e9af5dfc9UL;
   tf->codes[7601] = 0x0004807b2fb01d1cUL;
   tf->codes[7602] = 0x0004807f132f7f31UL;
   tf->codes[7603] = 0x0004807fc2dc9080UL;
   tf->codes[7604] = 0x00048088aea67183UL;
   tf->codes[7605] = 0x0004808af83cab35UL;
   tf->codes[7606] = 0x0004808d7c61eaacUL;
   tf->codes[7607] = 0x0004808edbbc0d4aUL;
   tf->codes[7608] = 0x00048092bf3b6f5fUL;
   tf->codes[7609] = 0x00048094ce42a34cUL;
   tf->codes[7610] = 0x00048099d68d223aUL;
   tf->codes[7611] = 0x0004809a4bab2dc4UL;
   tf->codes[7612] = 0x0004809e69b9959eUL;
   tf->codes[7613] = 0x0004809ea4489b63UL;
   tf->codes[7614] = 0x0004809f1966a6edUL;
   tf->codes[7615] = 0x000480a5bb9a4e3eUL;
   tf->codes[7616] = 0x000480a6e0656b17UL;
   tf->codes[7617] = 0x000480ac233eefcaUL;
   tf->codes[7618] = 0x000480b87d6a2758UL;
   tf->codes[7619] = 0x000480b9a2354431UL;
   tf->codes[7620] = 0x000480bcd60794f7UL;
   tf->codes[7621] = 0x000480bdfad2b1d0UL;
   tf->codes[7622] = 0x000480c3031d30beUL;
   tf->codes[7623] = 0x000480c3783b3c48UL;
   tf->codes[7624] = 0x000480cfd26673d6UL;
   tf->codes[7625] = 0x000480d3b5e5d5ebUL;
   tf->codes[7626] = 0x000480d63a0b1562UL;
   tf->codes[7627] = 0x000480d883a14f14UL;
   tf->codes[7628] = 0x000480d9334e6063UL;
   tf->codes[7629] = 0x000480e4a33d80ddUL;
   tf->codes[7630] = 0x000480e60297a37bUL;
   tf->codes[7631] = 0x000480e761f1c619UL;
   tf->codes[7632] = 0x000480e886bce2f2UL;
   tf->codes[7633] = 0x000480e93669f441UL;
   tf->codes[7634] = 0x000480ee3eb4732fUL;
   tf->codes[7635] = 0x000480eeb3d27eb9UL;
   tf->codes[7636] = 0x000480f25cc2db09UL;
   tf->codes[7637] = 0x000480fa23c19f33UL;
   tf->codes[7638] = 0x000480fe07410148UL;
   tf->codes[7639] = 0x000480ff669b23e6UL;
   tf->codes[7640] = 0x0004810dcfcd8f61UL;
   tf->codes[7641] = 0x0004810fa445bd89UL;
   tf->codes[7642] = 0x00048116467964daUL;
   tf->codes[7643] = 0x000481197a4bb5a0UL;
   tf->codes[7644] = 0x0004811f324345ddUL;
   tf->codes[7645] = 0x0004811f6cd24ba2UL;
   tf->codes[7646] = 0x0004812d9b75b158UL;
   tf->codes[7647] = 0x0004813bca19170eUL;
   tf->codes[7648] = 0x00048145a01f0f25UL;
   tf->codes[7649] = 0x00048145daae14eaUL;
   tf->codes[7650] = 0x0004814ec677f5edUL;
   tf->codes[7651] = 0x000481514a9d3564UL;
   tf->codes[7652] = 0x0004815359a46951UL;
   tf->codes[7653] = 0x000481570294c5a1UL;
   tf->codes[7654] = 0x000481627283e61bUL;
   tf->codes[7655] = 0x000481640c6d0e7eUL;
   tf->codes[7656] = 0x0004816cf836ef81UL;
   tf->codes[7657] = 0x0004817d70708ee9UL;
   tf->codes[7658] = 0x0004817e5aaca5fdUL;
   tf->codes[7659] = 0x0004818746768700UL;
   tf->codes[7660] = 0x00048189ca9bc677UL;
   tf->codes[7661] = 0x0004818aef66e350UL;
   tf->codes[7662] = 0x00048191570b84dcUL;
   tf->codes[7663] = 0x000481927bd6a1b5UL;
   tf->codes[7664] = 0x00048192b665a77aUL;
   tf->codes[7665] = 0x0004819624c6fe05UL;
   tf->codes[7666] = 0x000481a53da67acfUL;
   tf->codes[7667] = 0x000481a95bb4e2a9UL;
   tf->codes[7668] = 0x000481ac8f87336fUL;
   tf->codes[7669] = 0x000481acca163934UL;
   tf->codes[7670] = 0x000481b7ff7653e9UL;
   tf->codes[7671] = 0x000481bb3348a4afUL;
   tf->codes[7672] = 0x000481c8eccdfedbUL;
   tf->codes[7673] = 0x000481cf19e39aa2UL;
   tf->codes[7674] = 0x000481d4d1db2adfUL;
   tf->codes[7675] = 0x000481d6a6535907UL;
   tf->codes[7676] = 0x000481e584a3d00cUL;
   tf->codes[7677] = 0x000481e808c90f83UL;
   tf->codes[7678] = 0x000481ee706db10fUL;
   tf->codes[7679] = 0x000481eeaafcb6d4UL;
   tf->codes[7680] = 0x000481f8f620ba75UL;
   tf->codes[7681] = 0x000481f96b3ec5ffUL;
   tf->codes[7682] = 0x000481fa1aebd74eUL;
   tf->codes[7683] = 0x000481fd894d2dd9UL;
   tf->codes[7684] = 0x0004820cdcbbb068UL;
   tf->codes[7685] = 0x000482121f95351bUL;
   tf->codes[7686] = 0x0004821d54f54fd0UL;
   tf->codes[7687] = 0x0004821d8f845595UL;
   tf->codes[7688] = 0x0004822a5ecd98adUL;
   tf->codes[7689] = 0x0004822f6718179bUL;
   tf->codes[7690] = 0x0004823434d390c4UL;
   tf->codes[7691] = 0x000482346f629689UL;
   tf->codes[7692] = 0x0004823a61e92c8bUL;
   tf->codes[7693] = 0x000482476bc17568UL;
   tf->codes[7694] = 0x000482481b6e86b7UL;
   tf->codes[7695] = 0x0004824a2a75baa4UL;
   tf->codes[7696] = 0x0004825350cea16cUL;
   tf->codes[7697] = 0x00048255d4f3e0e3UL;
   tf->codes[7698] = 0x00048256f9befdbcUL;
   tf->codes[7699] = 0x0004825e862ebc21UL;
   tf->codes[7700] = 0x000482690be1c587UL;
   tf->codes[7701] = 0x0004826980ffd111UL;
   tf->codes[7702] = 0x0004826ae059f3afUL;
   tf->codes[7703] = 0x00048270985183ecUL;
   tf->codes[7704] = 0x000482726cc9b214UL;
   tf->codes[7705] = 0x00048277afa336c7UL;
   tf->codes[7706] = 0x0004827aa8e681c8UL;
   tf->codes[7707] = 0x0004827b1e048d52UL;
   tf->codes[7708] = 0x0004827f3c12f52cUL;
   tf->codes[7709] = 0x000482940cea0233UL;
   tf->codes[7710] = 0x000482994fc386e6UL;
   tf->codes[7711] = 0x0004829f07bb1723UL;
   tf->codes[7712] = 0x000482a82e13fdebUL;
   tf->codes[7713] = 0x000482ae209a93edUL;
   tf->codes[7714] = 0x000482ae95b89f77UL;
   tf->codes[7715] = 0x000482b2b3c70751UL;
   tf->codes[7716] = 0x000482c2073589e0UL;
   tf->codes[7717] = 0x000482c4163cbdcdUL;
   tf->codes[7718] = 0x000482cbdd3b81f7UL;
   tf->codes[7719] = 0x000482cd3c95a495UL;
   tf->codes[7720] = 0x000482ced67eccf8UL;
   tf->codes[7721] = 0x000482d6285f8598UL;
   tf->codes[7722] = 0x000482e78ad53c14UL;
   tf->codes[7723] = 0x000482f96268fe1aUL;
   tf->codes[7724] = 0x000482fa4ca5152eUL;
   tf->codes[7725] = 0x000482fcd0ca54a5UL;
   tf->codes[7726] = 0x000483087b487ae4UL;
   tf->codes[7727] = 0x0004830c2438d734UL;
   tf->codes[7728] = 0x0004831a184d3725UL;
   tf->codes[7729] = 0x0004831b77a759c3UL;
   tf->codes[7730] = 0x000483249e00408bUL;
   tf->codes[7731] = 0x0004832c2a6ffef0UL;
   tf->codes[7732] = 0x0004832ee924442cUL;
   tf->codes[7733] = 0x000483300def6105UL;
   tf->codes[7734] = 0x00048334668ccea4UL;
   tf->codes[7735] = 0x00048343f48a56f8UL;
   tf->codes[7736] = 0x000483442f195cbdUL;
   tf->codes[7737] = 0x00048344dec66e0cUL;
   tf->codes[7738] = 0x0004835ce36fcbd9UL;
   tf->codes[7739] = 0x00048369782a092cUL;
   tf->codes[7740] = 0x0004836ad7842bcaUL;
   tf->codes[7741] = 0x0004836cabfc59f2UL;
   tf->codes[7742] = 0x0004836ce68b5fb7UL;
   tf->codes[7743] = 0x000483708f7bbc07UL;
   tf->codes[7744] = 0x0004837313a0fb7eUL;
   tf->codes[7745] = 0x0004837647734c44UL;
   tf->codes[7746] = 0x0004838b52d95f10UL;
   tf->codes[7747] = 0x0004838b8d6864d5UL;
   tf->codes[7748] = 0x0004838d27518d38UL;
   tf->codes[7749] = 0x0004838fe605d274UL;
   tf->codes[7750] = 0x000483938ef62ec4UL;
   tf->codes[7751] = 0x000483aa6ed46fb8UL;
   tf->codes[7752] = 0x000483ac434c9de0UL;
   tf->codes[7753] = 0x000483af0200e31cUL;
   tf->codes[7754] = 0x000483b35a9e50bbUL;
   tf->codes[7755] = 0x000483bf3fab7cbfUL;
   tf->codes[7756] = 0x000483d709c5d4c7UL;
   tf->codes[7757] = 0x000483d98deb143eUL;
   tf->codes[7758] = 0x000483ded0c498f1UL;
   tf->codes[7759] = 0x000483df45e2a47bUL;
   tf->codes[7760] = 0x000483f11d766681UL;
   tf->codes[7761] = 0x000483f834c8195cUL;
   tf->codes[7762] = 0x0004840195b005e9UL;
   tf->codes[7763] = 0x0004840788369bebUL;
   tf->codes[7764] = 0x00048409d1ccd59dUL;
   tf->codes[7765] = 0x000484195fca5df1UL;
   tf->codes[7766] = 0x0004841a0f776f40UL;
   tf->codes[7767] = 0x0004841e6814dcdfUL;
   tf->codes[7768] = 0x00048422862344b9UL;
   tf->codes[7769] = 0x0004842753debde2UL;
   tf->codes[7770] = 0x0004842ea5bf7682UL;
   tf->codes[7771] = 0x0004842f1add820cUL;
   tf->codes[7772] = 0x00048430ef55b034UL;
   tf->codes[7773] = 0x0004843f93172174UL;
   tf->codes[7774] = 0x000484487ee10277UL;
   tf->codes[7775] = 0x0004844dc1ba872aUL;
   tf->codes[7776] = 0x0004844dfc498cefUL;
   tf->codes[7777] = 0x0004845b0621d5ccUL;
   tf->codes[7778] = 0x000484655145d96dUL;
   tf->codes[7779] = 0x0004846c2e088683UL;
   tf->codes[7780] = 0x0004846eecbccbbfUL;
   tf->codes[7781] = 0x000484758ef07310UL;
   tf->codes[7782] = 0x00048487dba240a0UL;
   tf->codes[7783] = 0x00048489006d5d79UL;
   tf->codes[7784] = 0x0004848b0f749166UL;
   tf->codes[7785] = 0x000484913c8a2d2dUL;
   tf->codes[7786] = 0x00048494705c7df3UL;
   tf->codes[7787] = 0x00048494aaeb83b8UL;
   tf->codes[7788] = 0x000484960a45a656UL;
   tf->codes[7789] = 0x0004849bc23d3693UL;
   tf->codes[7790] = 0x0004849d5c265ef6UL;
   tf->codes[7791] = 0x0004849ebb808194UL;
   tf->codes[7792] = 0x000484a4e8961d5bUL;
   tf->codes[7793] = 0x000484a856f773e6UL;
   tf->codes[7794] = 0x000484b22cfd6bfdUL;
   tf->codes[7795] = 0x000484bcb2b07563UL;
   tf->codes[7796] = 0x000484bf7164ba9fUL;
   tf->codes[7797] = 0x000484bfe682c629UL;
   tf->codes[7798] = 0x000484c1806bee8cUL;
   tf->codes[7799] = 0x000484c64e2767b5UL;
   tf->codes[7800] = 0x000484cb5671e6a3UL;
   tf->codes[7801] = 0x000484d26dc3997eUL;
   tf->codes[7802] = 0x000484e40ac855bfUL;
   tf->codes[7803] = 0x000484e91312d4adUL;
   tf->codes[7804] = 0x000484eae78b02d5UL;
   tf->codes[7805] = 0x000484f3d354e3d8UL;
   tf->codes[7806] = 0x000484f40de3e99dUL;
   tf->codes[7807] = 0x000484f5e25c17c5UL;
   tf->codes[7808] = 0x000484f61ceb1d8aUL;
   tf->codes[7809] = 0x000484f6cc982ed9UL;
   tf->codes[7810] = 0x000484ffb8620fdcUL;
   tf->codes[7811] = 0x0004850a3e151942UL;
   tf->codes[7812] = 0x0004850c128d476aUL;
   tf->codes[7813] = 0x00048510309baf44UL;
   tf->codes[7814] = 0x0004851538e62e32UL;
   tf->codes[7815] = 0x00048517827c67e4UL;
   tf->codes[7816] = 0x000485186cb87ef8UL;
   tf->codes[7817] = 0x0004851fbe993798UL;
   tf->codes[7818] = 0x0004852c8de27ab0UL;
   tf->codes[7819] = 0x0004852f1207ba27UL;
   tf->codes[7820] = 0x0004853b31a3ebf0UL;
   tf->codes[7821] = 0x00048540af0c7668UL;
   tf->codes[7822] = 0x0004854716b117f4UL;
   tf->codes[7823] = 0x000485478bcf237eUL;
   tf->codes[7824] = 0x00048548760b3a92UL;
   tf->codes[7825] = 0x0004854b6f4e8593UL;
   tf->codes[7826] = 0x0004855928d3dfbfUL;
   tf->codes[7827] = 0x00048560efd2a3e9UL;
   tf->codes[7828] = 0x0004856c2532be9eUL;
   tf->codes[7829] = 0x000485767056c23fUL;
   tf->codes[7830] = 0x000485780a3feaa2UL;
   tf->codes[7831] = 0x000485896cb5a11eUL;
   tf->codes[7832] = 0x000485942cf7b049UL;
   tf->codes[7833] = 0x00048599e4ef4086UL;
   tf->codes[7834] = 0x0004859d8ddf9cd6UL;
   tf->codes[7835] = 0x000485a6b438839eUL;
   tf->codes[7836] = 0x000485ac31a10e16UL;
   tf->codes[7837] = 0x000485ad566c2aefUL;
   tf->codes[7838] = 0x000485b59288faa3UL;
   tf->codes[7839] = 0x000485bbbf9e966aUL;
   tf->codes[7840] = 0x000485c1ecb43231UL;
   tf->codes[7841] = 0x000485c3117f4f0aUL;
   tf->codes[7842] = 0x000485c4e5f77d32UL;
   tf->codes[7843] = 0x000485c819c9cdf8UL;
   tf->codes[7844] = 0x000485c9ee41fc20UL;
   tf->codes[7845] = 0x000485cbc2ba2a48UL;
   tf->codes[7846] = 0x000485d055e69dacUL;
   tf->codes[7847] = 0x000485d389b8ee72UL;
   tf->codes[7848] = 0x000485d682fc3973UL;
   tf->codes[7849] = 0x000485dbc5d5be26UL;
   tf->codes[7850] = 0x000485e59bdbb63dUL;
   tf->codes[7851] = 0x000485e68617cd51UL;
   tf->codes[7852] = 0x000485e735c4dea0UL;
   tf->codes[7853] = 0x000485efac70b419UL;
   tf->codes[7854] = 0x000485ffaf8c47f7UL;
   tf->codes[7855] = 0x000486052cf4d26fUL;
   tf->codes[7856] = 0x0004860b5a0a6e36UL;
   tf->codes[7857] = 0x0004860c09b77f85UL;
   tf->codes[7858] = 0x000486111201fe73UL;
   tf->codes[7859] = 0x0004861a385ae53bUL;
   tf->codes[7860] = 0x0004861f40a56429UL;
   tf->codes[7861] = 0x00048633d6ed6b6bUL;
   tf->codes[7862] = 0x000486406ba7a8beUL;
   tf->codes[7863] = 0x0004866b6cafe56aUL;
   tf->codes[7864] = 0x000486703a6b5e93UL;
   tf->codes[7865] = 0x000486750826d7bcUL;
   tf->codes[7866] = 0x0004867a107156aaUL;
   tf->codes[7867] = 0x000486824c8e265eUL;
   tf->codes[7868] = 0x000486950e5dff78UL;
   tf->codes[7869] = 0x00048699a18a72dcUL;
   tf->codes[7870] = 0x0004869ea9d4f1caUL;
   tf->codes[7871] = 0x000486a586979ee0UL;
   tf->codes[7872] = 0x000486af972c9cbcUL;
   tf->codes[7873] = 0x000486c3f2e59e39UL;
   tf->codes[7874] = 0x000486c935bf22ecUL;
   tf->codes[7875] = 0x000486ca1ffb3a00UL;
   tf->codes[7876] = 0x000486d171dbf2a0UL;
   tf->codes[7877] = 0x000486d67a26718eUL;
   tf->codes[7878] = 0x000486dc321e01cbUL;
   tf->codes[7879] = 0x000486e299c2a357UL;
   tf->codes[7880] = 0x000486eb858c845aUL;
   tf->codes[7881] = 0x000486ee7ecfcf5bUL;
   tf->codes[7882] = 0x000486f311fc42bfUL;
   tf->codes[7883] = 0x000486f6f57ba4d4UL;
   tf->codes[7884] = 0x000486fa63dcfb5fUL;
   tf->codes[7885] = 0x000486fa9e6c0124UL;
   tf->codes[7886] = 0x000486ff31987488UL;
   tf->codes[7887] = 0x00048709079e6c9fUL;
   tf->codes[7888] = 0x0004870ebf95fcdcUL;
   tf->codes[7889] = 0x000487252a563246UL;
   tf->codes[7890] = 0x0004872ec5cd2498UL;
   tf->codes[7891] = 0x000487310f635e4aUL;
   tf->codes[7892] = 0x000487352d71c624UL;
   tf->codes[7893] = 0x0004873826b51125UL;
   tf->codes[7894] = 0x0004873cb9e18489UL;
   tf->codes[7895] = 0x00048742ac681a8bUL;
   tf->codes[7896] = 0x00048745308d5a02UL;
   tf->codes[7897] = 0x000487461ac97116UL;
   tf->codes[7898] = 0x00048747ef419f3eUL;
   tf->codes[7899] = 0x0004874cbcfd1867UL;
   tf->codes[7900] = 0x00048752ea12b42eUL;
   tf->codes[7901] = 0x0004875e9490da6dUL;
   tf->codes[7902] = 0x0004876f0cca79d5UL;
   tf->codes[7903] = 0x00048778e2d071ecUL;
   tf->codes[7904] = 0x00048785b219b504UL;
   tf->codes[7905] = 0x0004879923969f6dUL;
   tf->codes[7906] = 0x0004879d41a50747UL;
   tf->codes[7907] = 0x000487a3342b9d49UL;
   tf->codes[7908] = 0x000487b2127c144eUL;
   tf->codes[7909] = 0x000487b3ac653cb1UL;
   tf->codes[7910] = 0x000487b9d97ad878UL;
   tf->codes[7911] = 0x000487ba8927e9c7UL;
   tf->codes[7912] = 0x000487c25026adf1UL;
   tf->codes[7913] = 0x000487d28dd14794UL;
   tf->codes[7914] = 0x000487d49cd87b81UL;
   tf->codes[7915] = 0x000487d587149295UL;
   tf->codes[7916] = 0x000487d5c1a3985aUL;
   tf->codes[7917] = 0x000487d720fdbaf8UL;
   tf->codes[7918] = 0x000487db3f0c22d2UL;
   tf->codes[7919] = 0x000487dcd8f54b35UL;
   tf->codes[7920] = 0x000487dead6d795dUL;
   tf->codes[7921] = 0x000487ec66f2d389UL;
   tf->codes[7922] = 0x000487ed169fe4d8UL;
   tf->codes[7923] = 0x000487f1e45b5e01UL;
   tf->codes[7924] = 0x000487f9e5e927f0UL;
   tf->codes[7925] = 0x000487fa5b07337aUL;
   tf->codes[7926] = 0x000487fa9596393fUL;
   tf->codes[7927] = 0x0004880ad340d2e2UL;
   tf->codes[7928] = 0x0004882b4e960628UL;
   tf->codes[7929] = 0x0004885b9277c787UL;
   tf->codes[7930] = 0x0004885e169d06feUL;
   tf->codes[7931] = 0x000488626f3a749dUL;
   tf->codes[7932] = 0x00048864b8d0ae4fUL;
   tf->codes[7933] = 0x0004886cba5e783eUL;
   tf->codes[7934] = 0x0004888de560bcd3UL;
   tf->codes[7935] = 0x000488941276589aUL;
   tf->codes[7936] = 0x000488afc01012b7UL;
   tf->codes[7937] = 0x000488b6d761c592UL;
   tf->codes[7938] = 0x000488bc8f5955cfUL;
   tf->codes[7939] = 0x000488df19b5bd02UL;
   tf->codes[7940] = 0x000488dfc962ce51UL;
   tf->codes[7941] = 0x000488ec98ac1169UL;
   tf->codes[7942] = 0x000488edf8063407UL;
   tf->codes[7943] = 0x000488f50f57e6e2UL;
   tf->codes[7944] = 0x00048913f0c3f1c5UL;
   tf->codes[7945] = 0x00048916af783701UL;
   tf->codes[7946] = 0x0004891883f06529UL;
   tf->codes[7947] = 0x000489263d75bf55UL;
   tf->codes[7948] = 0x0004893f2c5b3436UL;
   tf->codes[7949] = 0x0004894643ace711UL;
   tf->codes[7950] = 0x00048946f359f860UL;
   tf->codes[7951] = 0x00048954acdf528cUL;
   tf->codes[7952] = 0x000489576b9397c8UL;
   tf->codes[7953] = 0x000489581b40a917UL;
   tf->codes[7954] = 0x00048965d4c60343UL;
   tf->codes[7955] = 0x0004898c0812c6c6UL;
   tf->codes[7956] = 0x00048995de18beddUL;
   tf->codes[7957] = 0x000489965336ca67UL;
   tf->codes[7958] = 0x00048998623dfe54UL;
   tf->codes[7959] = 0x0004899e1a358e91UL;
   tf->codes[7960] = 0x000489bb61b87111UL;
   tf->codes[7961] = 0x000489bc86838deaUL;
   tf->codes[7962] = 0x000489c5e76b7a77UL;
   tf->codes[7963] = 0x000489ce23884a2bUL;
   tf->codes[7964] = 0x000489d5756902cbUL;
   tf->codes[7965] = 0x000489d7f98e4242UL;
   tf->codes[7966] = 0x000489dba27e9e92UL;
   tf->codes[7967] = 0x000489df10dff51dUL;
   tf->codes[7968] = 0x000489e62831a7f8UL;
   tf->codes[7969] = 0x000489eb307c26e6UL;
   tf->codes[7970] = 0x000489ec554743bfUL;
   tf->codes[7971] = 0x000489eed96c8336UL;
   tf->codes[7972] = 0x000489f6dafa4d25UL;
   tf->codes[7973] = 0x000489fa83eaa975UL;
   tf->codes[7974] = 0x00048a0f54c1b67cUL;
   tf->codes[7975] = 0x00048a124e05017dUL;
   tf->codes[7976] = 0x00048a1e6da13346UL;
   tf->codes[7977] = 0x00048a2c27268d72UL;
   tf->codes[7978] = 0x00048a31a48f17eaUL;
   tf->codes[7979] = 0x00048a38f66fd08aUL;
   tf->codes[7980] = 0x00048a3b05770477UL;
   tf->codes[7981] = 0x00048a3b7a951001UL;
   tf->codes[7982] = 0x00048a3fd3327da0UL;
   tf->codes[7983] = 0x00048a521fe44b30UL;
   tf->codes[7984] = 0x00048a530a206244UL;
   tf->codes[7985] = 0x00048a59ac540995UL;
   tf->codes[7986] = 0x00048a5a5c011ae4UL;
   tf->codes[7987] = 0x00048a5bbb5b3d82UL;
   tf->codes[7988] = 0x00048a5dca62716fUL;
   tf->codes[7989] = 0x00048a5e3f807cf9UL;
   tf->codes[7990] = 0x00048a66b62c5272UL;
   tf->codes[7991] = 0x00048a6fdc85393aUL;
   tf->codes[7992] = 0x00048a71766e619dUL;
   tf->codes[7993] = 0x00048a7c713f768dUL;
   tf->codes[7994] = 0x00048a829e551254UL;
   tf->codes[7995] = 0x00048a834e0223a3UL;
   tf->codes[7996] = 0x00048a8ada71e208UL;
   tf->codes[7997] = 0x00048a91b7348f1eUL;
   tf->codes[7998] = 0x00048aac0574269dUL;
   tf->codes[7999] = 0x00048ab6c5b635c8UL;
   tf->codes[8000] = 0x00048ab85f9f5e2bUL;
   tf->codes[8001] = 0x00048accf5e7656dUL;
   tf->codes[8002] = 0x00048ad0d966c782UL;
   tf->codes[8003] = 0x00048ad4825723d2UL;
   tf->codes[8004] = 0x00048ad9ffbfae4aUL;
   tf->codes[8005] = 0x00048ada3a4eb40fUL;
   tf->codes[8006] = 0x00048ae659eae5d8UL;
   tf->codes[8007] = 0x00048aeb9cc46a8bUL;
   tf->codes[8008] = 0x00048aff0e4154f4UL;
   tf->codes[8009] = 0x00048b032c4fbcceUL;
   tf->codes[8010] = 0x00048b0f867af45cUL;
   tf->codes[8011] = 0x00048b1d057148c3UL;
   tf->codes[8012] = 0x00048b362ee5c369UL;
   tf->codes[8013] = 0x00048b4498182ee4UL;
   tf->codes[8014] = 0x00048b466c905d0cUL;
   tf->codes[8015] = 0x00048b46a71f62d1UL;
   tf->codes[8016] = 0x00048b5ee657c663UL;
   tf->codes[8017] = 0x00048b5fd093dd77UL;
   tf->codes[8018] = 0x00048b68f6ecc43fUL;
   tf->codes[8019] = 0x00048b6bf0300f40UL;
   tf->codes[8020] = 0x00048b6d8a1937a3UL;
   tf->codes[8021] = 0x00048b6ee9735a41UL;
   tf->codes[8022] = 0x00048b7884ea4c93UL;
   tf->codes[8023] = 0x00048b7ace808645UL;
   tf->codes[8024] = 0x00048b7dc7c3d146UL;
   tf->codes[8025] = 0x00048b7f271df3e4UL;
   tf->codes[8026] = 0x00048b8220613ee5UL;
   tf->codes[8027] = 0x00048b8e056e6ae9UL;
   tf->codes[8028] = 0x00048b9173cfc174UL;
   tf->codes[8029] = 0x00048b951cc01dc4UL;
   tf->codes[8030] = 0x00048b99afec9128UL;
   tf->codes[8031] = 0x00048bb2d9610bceUL;
   tf->codes[8032] = 0x00048bbb157ddb82UL;
   tf->codes[8033] = 0x00048bbc3a48f85bUL;
   tf->codes[8034] = 0x00048bbd99a31af9UL;
   tf->codes[8035] = 0x00048bc3519aab36UL;
   tf->codes[8036] = 0x00048bc5d5bfeaadUL;
   tf->codes[8037] = 0x00048bc7aa3818d5UL;
   tf->codes[8038] = 0x00048bcb53287525UL;
   tf->codes[8039] = 0x00048bd09601f9d8UL;
   tf->codes[8040] = 0x00048bd1f55c1c76UL;
   tf->codes[8041] = 0x00048bd31a27394fUL;
   tf->codes[8042] = 0x00048bf061aa1bcfUL;
   tf->codes[8043] = 0x00048bf569f49abdUL;
   tf->codes[8044] = 0x00048bf778fbceaaUL;
   tf->codes[8045] = 0x00048bf7b38ad46fUL;
   tf->codes[8046] = 0x00048c032379f4e9UL;
   tf->codes[8047] = 0x00048c1ab305472cUL;
   tf->codes[8048] = 0x00048c2daf64260bUL;
   tf->codes[8049] = 0x00048c2de9f32bd0UL;
   tf->codes[8050] = 0x00048c3db27fb9e9UL;
   tf->codes[8051] = 0x00048c4a81c8fd01UL;
   tf->codes[8052] = 0x00048c4d407d423dUL;
   tf->codes[8053] = 0x00048c624be35509UL;
   tf->codes[8054] = 0x00048c750db32e23UL;
   tf->codes[8055] = 0x00048c787c1484aeUL;
   tf->codes[8056] = 0x00048c8d125c8bf0UL;
   tf->codes[8057] = 0x00048c975d808f91UL;
   tf->codes[8058] = 0x00048cadc840c4fbUL;
   tf->codes[8059] = 0x00048caeb27cdc0fUL;
   tf->codes[8060] = 0x00048cb46a746c4cUL;
   tf->codes[8061] = 0x00048cc08a109e15UL;
   tf->codes[8062] = 0x00048ce523743935UL;
   tf->codes[8063] = 0x00048ceef97a314cUL;
   tf->codes[8064] = 0x00048cf01e454e25UL;
   tf->codes[8065] = 0x00048cf894f1239eUL;
   tf->codes[8066] = 0x00048d02306815f0UL;
   tf->codes[8067] = 0x00048d0738b294deUL;
   tf->codes[8068] = 0x00048d0c7b8c1991UL;
   tf->codes[8069] = 0x00048d0d65c830a5UL;
   tf->codes[8070] = 0x00048d11be659e44UL;
   tf->codes[8071] = 0x00048d17765d2e81UL;
   tf->codes[8072] = 0x00048d194ad55ca9UL;
   tf->codes[8073] = 0x00048d3866d06d51UL;
   tf->codes[8074] = 0x00048d3ab066a703UL;
   tf->codes[8075] = 0x00048d41529a4e54UL;
   tf->codes[8076] = 0x00048d4869ec012fUL;
   tf->codes[8077] = 0x00048d523ff1f946UL;
   tf->codes[8078] = 0x00048d55e8e25596UL;
   tf->codes[8079] = 0x00048d565e006120UL;
   tf->codes[8080] = 0x00048d5991d2b1e6UL;
   tf->codes[8081] = 0x00048d6a0a0c514eUL;
   tf->codes[8082] = 0x00048d6f4ce5d601UL;
   tf->codes[8083] = 0x00048d7b31f30205UL;
   tf->codes[8084] = 0x00048d7c1c2f1919UL;
   tf->codes[8085] = 0x00048d88b0e9566cUL;
   tf->codes[8086] = 0x00048d8f8dac0382UL;
   tf->codes[8087] = 0x00048d9d47315daeUL;
   tf->codes[8088] = 0x00048db75ae1ef68UL;
   tf->codes[8089] = 0x00048dc80daa9495UL;
   tf->codes[8090] = 0x00048dcca0d707f9UL;
   tf->codes[8091] = 0x00048de1e6cc208aUL;
   tf->codes[8092] = 0x00048dee40f75818UL;
   tf->codes[8093] = 0x00048df4e32aff69UL;
   tf->codes[8094] = 0x00048e04e6469347UL;
   tf->codes[8095] = 0x00048e0fa688a272UL;
   tf->codes[8096] = 0x00048e134f78fec2UL;
   tf->codes[8097] = 0x00048e16834b4f88UL;
   tf->codes[8098] = 0x00048e1a2c3babd8UL;
   tf->codes[8099] = 0x00048e1c75d1e58aUL;
   tf->codes[8100] = 0x00048e2ec283b31aUL;
   tf->codes[8101] = 0x00048e34ef994ee1UL;
   tf->codes[8102] = 0x00048e431e3cb497UL;
   tf->codes[8103] = 0x00048e468c9e0b22UL;
   tf->codes[8104] = 0x00048e5c82403502UL;
   tf->codes[8105] = 0x00048e5ecbd66eb4UL;
   tf->codes[8106] = 0x00048e6e9462fccdUL;
   tf->codes[8107] = 0x00048e7b63ac3fe5UL;
   tf->codes[8108] = 0x00048e7de7d17f5cUL;
   tf->codes[8109] = 0x00048e911ebf6400UL;
   tf->codes[8110] = 0x00048e927e19869eUL;
   tf->codes[8111] = 0x00048e969c27ee78UL;
   tf->codes[8112] = 0x00048eaaf7e0eff5UL;
   tf->codes[8113] = 0x00048eab326ff5baUL;
   tf->codes[8114] = 0x00048eaccc591e1dUL;
   tf->codes[8115] = 0x00048ead7c062f6cUL;
   tf->codes[8116] = 0x00048eb28450ae5aUL;
   tf->codes[8117] = 0x00048eb6dcee1bf9UL;
   tf->codes[8118] = 0x00048eb876d7445cUL;
   tf->codes[8119] = 0x00048ebac06d7e0eUL;
   tf->codes[8120] = 0x00048ebc94e5ac36UL;
   tf->codes[8121] = 0x00048ebea3ece023UL;
   tf->codes[8122] = 0x00048eccd29045d9UL;
   tf->codes[8123] = 0x00048ecd47ae5163UL;
   tf->codes[8124] = 0x00048ed00662969fUL;
   tf->codes[8125] = 0x00048ed2ffa5e1a0UL;
   tf->codes[8126] = 0x00048ed8f22c77a2UL;
   tf->codes[8127] = 0x00048ed92cbb7d67UL;
   tf->codes[8128] = 0x00048edb7651b719UL;
   tf->codes[8129] = 0x00048edfceef24b8UL;
   tf->codes[8130] = 0x00048eed1356735aUL;
   tf->codes[8131] = 0x00048ef3b58a1aabUL;
   tf->codes[8132] = 0x00048ef6743e5fe7UL;
   tf->codes[8133] = 0x00048efaccdbcd86UL;
   tf->codes[8134] = 0x00048f046852bfd8UL;
   tf->codes[8135] = 0x00048f0cdefe9551UL;
   tf->codes[8136] = 0x00048f179f40a47cUL;
   tf->codes[8137] = 0x00048f1a2365e3f3UL;
   tf->codes[8138] = 0x00048f1b82c00691UL;
   tf->codes[8139] = 0x00048f3f6c769062UL;
   tf->codes[8140] = 0x00048f42dad7e6edUL;
   tf->codes[8141] = 0x00048f585b5c0543UL;
   tf->codes[8142] = 0x00048f58d07a10cdUL;
   tf->codes[8143] = 0x00048f5a2fd4336bUL;
   tf->codes[8144] = 0x00048f6b9249e9e7UL;
   tf->codes[8145] = 0x00048f6ddbe02399UL;
   tf->codes[8146] = 0x00048f77ec752175UL;
   tf->codes[8147] = 0x00048f79865e49d8UL;
   tf->codes[8148] = 0x00048f7f78e4dfdaUL;
   tf->codes[8149] = 0x00048f84bbbe648dUL;
   tf->codes[8150] = 0x00048f94844af2a6UL;
   tf->codes[8151] = 0x00048f97f2ac4931UL;
   tf->codes[8152] = 0x00048fa9ca400b37UL;
   tf->codes[8153] = 0x00048fb3a046034eUL;
   tf->codes[8154] = 0x00048fcdee859acdUL;
   tf->codes[8155] = 0x00048fcf4ddfbd6bUL;
   tf->codes[8156] = 0x00048fd3a67d2b0aUL;
   tf->codes[8157] = 0x00048fd5f01364bcUL;
   tf->codes[8158] = 0x00048fd923e5b582UL;
   tf->codes[8159] = 0x00048fdc57b80648UL;
   tf->codes[8160] = 0x00048fe1d52090c0UL;
   tf->codes[8161] = 0x00048fe5b89ff2d5UL;
   tf->codes[8162] = 0x00048ff421d25e50UL;
   tf->codes[8163] = 0x00048ffbe8d1227aUL;
   tf->codes[8164] = 0x00048fff1ca37340UL;
   tf->codes[8165] = 0x000490049a0bfdb8UL;
   tf->codes[8166] = 0x0004901462988bd1UL;
   tf->codes[8167] = 0x00049026e9d95f26UL;
   tf->codes[8168] = 0x000490337e939c79UL;
   tf->codes[8169] = 0x0004903fd8bed407UL;
   tf->codes[8170] = 0x0004907aa2539eccUL;
   tf->codes[8171] = 0x0004907faa9e1dbaUL;
   tf->codes[8172] = 0x000490868760cad0UL;
   tf->codes[8173] = 0x00049087ac2be7a9UL;
   tf->codes[8174] = 0x0004909022d7bd22UL;
   tf->codes[8175] = 0x00049093913913adUL;
   tf->codes[8176] = 0x00049093cbc81972UL;
   tf->codes[8177] = 0x00049094b6043086UL;
   tf->codes[8178] = 0x0004909c4273eeebUL;
   tf->codes[8179] = 0x000490a9c16a4352UL;
   tf->codes[8180] = 0x000490ab5b536bb5UL;
   tf->codes[8181] = 0x000490ad6a5a9fa2UL;
   tf->codes[8182] = 0x000490ca023070d3UL;
   tf->codes[8183] = 0x000490d9559ef362UL;
   tf->codes[8184] = 0x000490dd73ad5b3cUL;
   tf->codes[8185] = 0x000490e24168d465UL;
   tf->codes[8186] = 0x000490edebe6faa4UL;
   tf->codes[8187] = 0x000490f5ed74c493UL;
   tf->codes[8188] = 0x00049107155b754aUL;
   tf->codes[8189] = 0x00049126315685f2UL;
   tf->codes[8190] = 0x00049126a674917cUL;
   tf->codes[8191] = 0x0004912be94e162fUL;
   tf->codes[8192] = 0x0004912ee2916130UL;
   tf->codes[8193] = 0x0004913f955a065dUL;
   tf->codes[8194] = 0x00049143edf773fcUL;
   tf->codes[8195] = 0x0004915d176beea2UL;
   tf->codes[8196] = 0x0004915d8c89fa2cUL;
   tf->codes[8197] = 0x0004915e01a805b6UL;
   tf->codes[8198] = 0x0004916a5bd33d44UL;
   tf->codes[8199] = 0x0004917222d2016eUL;
   tf->codes[8200] = 0x00049173822c240cUL;
   tf->codes[8201] = 0x0004917b83b9edfbUL;
   tf->codes[8202] = 0x0004917e426e3337UL;
   tf->codes[8203] = 0x0004918853033113UL;
   tf->codes[8204] = 0x00049193c2f2518dUL;
   tf->codes[8205] = 0x0004919681a696c9UL;
   tf->codes[8206] = 0x000491b3540b6dbfUL;
   tf->codes[8207] = 0x000491b7aca8db5eUL;
   tf->codes[8208] = 0x000491ba6b5d209aUL;
   tf->codes[8209] = 0x000491bcb4f35a4cUL;
   tf->codes[8210] = 0x000491be144d7ceaUL;
   tf->codes[8211] = 0x000491ccf29df3efUL;
   tf->codes[8212] = 0x000491cd67bbff79UL;
   tf->codes[8213] = 0x000491cda24b053eUL;
   tf->codes[8214] = 0x000491ce51f8168dUL;
   tf->codes[8215] = 0x000491d0d61d5604UL;
   tf->codes[8216] = 0x000491d1c0596d18UL;
   tf->codes[8217] = 0x000491d3cf60a105UL;
   tf->codes[8218] = 0x000491dc809b7c43UL;
   tf->codes[8219] = 0x000491e7f08a9cbdUL;
   tf->codes[8220] = 0x000491eff21866acUL;
   tf->codes[8221] = 0x000491f44ab5d44bUL;
   tf->codes[8222] = 0x0004920622499651UL;
   tf->codes[8223] = 0x000492065cd89c16UL;
   tf->codes[8224] = 0x000492191ea87530UL;
   tf->codes[8225] = 0x0004923db80c1050UL;
   tf->codes[8226] = 0x0004924210a97defUL;
   tf->codes[8227] = 0x0004924e3045afb8UL;
   tf->codes[8228] = 0x0004924edff2c107UL;
   tf->codes[8229] = 0x0004924f1a81c6ccUL;
   tf->codes[8230] = 0x000492503f4ce3a5UL;
   tf->codes[8231] = 0x0004925213c511cdUL;
   tf->codes[8232] = 0x000492524e541792UL;
   tf->codes[8233] = 0x00049258064ba7cfUL;
   tf->codes[8234] = 0x0004925840daad94UL;
   tf->codes[8235] = 0x0004925a1552dbbcUL;
   tf->codes[8236] = 0x00049275fd7b9b9eUL;
   tf->codes[8237] = 0x0004927d4f5c543eUL;
   tf->codes[8238] = 0x000492830753e47bUL;
   tf->codes[8239] = 0x0004928b08e1ae6aUL;
   tf->codes[8240] = 0x0004928e3cb3ff30UL;
   tf->codes[8241] = 0x0004928eec61107fUL;
   tf->codes[8242] = 0x0004929dcab18784UL;
   tf->codes[8243] = 0x000492a7a0b77f9bUL;
   tf->codes[8244] = 0x000492b594cbdf8cUL;
   tf->codes[8245] = 0x000492be4606bacaUL;
   tf->codes[8246] = 0x000492c229861cdfUL;
   tf->codes[8247] = 0x000492c597e7736aUL;
   tf->codes[8248] = 0x000492cbff8c14f6UL;
   tf->codes[8249] = 0x000492ccaf392645UL;
   tf->codes[8250] = 0x000492d4eb55f5f9UL;
   tf->codes[8251] = 0x000492dcece3bfe8UL;
   tf->codes[8252] = 0x000492dd2772c5adUL;
   tf->codes[8253] = 0x000492ee89e87c29UL;
   tf->codes[8254] = 0x000492f098efb016UL;
   tf->codes[8255] = 0x000492f10e0dbba0UL;
   tf->codes[8256] = 0x000492f68b764618UL;
   tf->codes[8257] = 0x00049309fcf33081UL;
   tf->codes[8258] = 0x0004930fb4eac0beUL;
   tf->codes[8259] = 0x00049314f7c44571UL;
   tf->codes[8260] = 0x00049343672dd8a8UL;
   tf->codes[8261] = 0x0004934c1868b3e6UL;
   tf->codes[8262] = 0x0004935036771bc0UL;
   tf->codes[8263] = 0x00049352ba9c5b37UL;
   tf->codes[8264] = 0x00049356d8aac311UL;
   tf->codes[8265] = 0x0004936af9d4bec9UL;
   tf->codes[8266] = 0x0004936e2da70f8fUL;
   tf->codes[8267] = 0x0004937161796055UL;
   tf->codes[8268] = 0x0004937335f18e7dUL;
   tf->codes[8269] = 0x0004937544f8c26aUL;
   tf->codes[8270] = 0x0004937753fff657UL;
   tf->codes[8271] = 0x0004937df6339da8UL;
   tf->codes[8272] = 0x00049383e8ba33aaUL;
   tf->codes[8273] = 0x0004938c99f50ee8UL;
   tf->codes[8274] = 0x000493966ffb06ffUL;
   tf->codes[8275] = 0x0004939b784585edUL;
   tf->codes[8276] = 0x0004939e7188d0eeUL;
   tf->codes[8277] = 0x000493a5c369898eUL;
   tf->codes[8278] = 0x000493a6e834a667UL;
   tf->codes[8279] = 0x000493b4dc490658UL;
   tf->codes[8280] = 0x000493b725df400aUL;
   tf->codes[8281] = 0x000493b84aaa5ce3UL;
   tf->codes[8282] = 0x000493bacecf9c5aUL;
   tf->codes[8283] = 0x000493bd1865d60cUL;
   tf->codes[8284] = 0x000493be3d30f2e5UL;
   tf->codes[8285] = 0x000493bf61fc0fbeUL;
   tf->codes[8286] = 0x000493c1e6214f35UL;
   tf->codes[8287] = 0x000493cb81984187UL;
   tf->codes[8288] = 0x000493ce404c86c3UL;
   tf->codes[8289] = 0x000493d383260b76UL;
   tf->codes[8290] = 0x000493db4a24cfa0UL;
   tf->codes[8291] = 0x000493e3112393caUL;
   tf->codes[8292] = 0x000493fd5f632b49UL;
   tf->codes[8293] = 0x0004940560f0f538UL;
   tf->codes[8294] = 0x0004940735692360UL;
   tf->codes[8295] = 0x0004940b18e88575UL;
   tf->codes[8296] = 0x0004940c03249c89UL;
   tf->codes[8297] = 0x00049414eeee7d8cUL;
   tf->codes[8298] = 0x00049434800799beUL;
   tf->codes[8299] = 0x0004943a728e2fc0UL;
   tf->codes[8300] = 0x000494482c1389ecUL;
   tf->codes[8301] = 0x0004944cf9cf0315UL;
   tf->codes[8302] = 0x00049469cc33da0bUL;
   tf->codes[8303] = 0x0004946a06c2dfd0UL;
   tf->codes[8304] = 0x00049470e3858ce6UL;
   tf->codes[8305] = 0x00049475b141060fUL;
   tf->codes[8306] = 0x0004947e627be14dUL;
   tf->codes[8307] = 0x0004948a82181316UL;
   tf->codes[8308] = 0x0004948e2b086f66UL;
   tf->codes[8309] = 0x000494b5bdaf5587UL;
   tf->codes[8310] = 0x000494bdf9cc253bUL;
   tf->codes[8311] = 0x000494be6eea30c5UL;
   tf->codes[8312] = 0x000494c5fb59ef2aUL;
   tf->codes[8313] = 0x000494c92f2c3ff0UL;
   tf->codes[8314] = 0x000494d0f62b041aUL;
   tf->codes[8315] = 0x000494e676af2270UL;
   tf->codes[8316] = 0x000494eacf4c900fUL;
   tf->codes[8317] = 0x0004950642574467UL;
   tf->codes[8318] = 0x000495176a3df51eUL;
   tf->codes[8319] = 0x000495193eb62346UL;
   tf->codes[8320] = 0x0004951fa65ac4d2UL;
   tf->codes[8321] = 0x000495289224a5d5UL;
   tf->codes[8322] = 0x0004953dd819be66UL;
   tf->codes[8323] = 0x0004953e4d37c9f0UL;
   tf->codes[8324] = 0x00049541467b14f1UL;
   tf->codes[8325] = 0x000495431af34319UL;
   tf->codes[8326] = 0x00049544ef6b7141UL;
   tf->codes[8327] = 0x0004954bcc2e1e57UL;
   tf->codes[8328] = 0x00049552e37fd132UL;
   tf->codes[8329] = 0x00049556175221f8UL;
   tf->codes[8330] = 0x00049557b13b4a5bUL;
   tf->codes[8331] = 0x0004956c4783519dUL;
   tf->codes[8332] = 0x00049571ff7ae1daUL;
   tf->codes[8333] = 0x0004957916cc94b5UL;
   tf->codes[8334] = 0x0004957ecec424f2UL;
   tf->codes[8335] = 0x00049582029675b8UL;
   tf->codes[8336] = 0x0004958a3eb3456cUL;
   tf->codes[8337] = 0x0004958ab3d150f6UL;
   tf->codes[8338] = 0x00049598e274b6acUL;
   tf->codes[8339] = 0x000495bea0a36ea5UL;
   tf->codes[8340] = 0x000495bffffd9143UL;
   tf->codes[8341] = 0x000495c4cdb90a6cUL;
   tf->codes[8342] = 0x000495c8ebc77246UL;
   tf->codes[8343] = 0x000495eb3b94d3b4UL;
   tf->codes[8344] = 0x000495eee4853004UL;
   tf->codes[8345] = 0x000495f377b1a368UL;
   tf->codes[8346] = 0x000495f9df5644f4UL;
   tf->codes[8347] = 0x0004960c66971849UL;
   tf->codes[8348] = 0x0004960cdbb523d3UL;
   tf->codes[8349] = 0x00049615c77f04d6UL;
   tf->codes[8350] = 0x0004961d8e7dc900UL;
   tf->codes[8351] = 0x0004961e039bd48aUL;
   tf->codes[8352] = 0x0004962bf7b0347bUL;
   tf->codes[8353] = 0x00049632d472e191UL;
   tf->codes[8354] = 0x000496393c17831dUL;
   tf->codes[8355] = 0x0004964b88c950adUL;
   tf->codes[8356] = 0x000496597cddb09eUL;
   tf->codes[8357] = 0x0004967d2c0534aaUL;
   tf->codes[8358] = 0x0004968c44e4b174UL;
   tf->codes[8359] = 0x000496b1c88463a8UL;
   tf->codes[8360] = 0x000496b7807bf3e5UL;
   tf->codes[8361] = 0x000496b7f599ff6fUL;
   tf->codes[8362] = 0x000496bcc3557898UL;
   tf->codes[8363] = 0x000496dfc2cfeb55UL;
   tf->codes[8364] = 0x000496e2bc133656UL;
   tf->codes[8365] = 0x000496f2849fc46fUL;
   tf->codes[8366] = 0x000496f5435409abUL;
   tf->codes[8367] = 0x000496f926d36bc0UL;
   tf->codes[8368] = 0x000496fafb4b99e8UL;
   tf->codes[8369] = 0x000496fbaaf8ab37UL;
   tf->codes[8370] = 0x0004970f9193a12aUL;
   tf->codes[8371] = 0x000497104140b279UL;
   tf->codes[8372] = 0x00049710b65ebe03UL;
   tf->codes[8373] = 0x00049710f0edc3c8UL;
   tf->codes[8374] = 0x00049711db29dadcUL;
   tf->codes[8375] = 0x0004972c9e877de5UL;
   tf->codes[8376] = 0x0004973e3b8c3a26UL;
   tf->codes[8377] = 0x000497479c7426b3UL;
   tf->codes[8378] = 0x0004974970ec54dbUL;
   tf->codes[8379] = 0x0004974a2099662aUL;
   tf->codes[8380] = 0x00049750c2cd0d7bUL;
   tf->codes[8381] = 0x0004975605a6922eUL;
   tf->codes[8382] = 0x0004975d57874aceUL;
   tf->codes[8383] = 0x0004975e41c361e2UL;
   tf->codes[8384] = 0x0004976643512bd1UL;
   tf->codes[8385] = 0x00049769b1b2825cUL;
   tf->codes[8386] = 0x0004976f69aa1299UL;
   tf->codes[8387] = 0x0004977103933afcUL;
   tf->codes[8388] = 0x0004977471f49187UL;
   tf->codes[8389] = 0x0004977ad9993313UL;
   tf->codes[8390] = 0x0004978e108717b7UL;
   tf->codes[8391] = 0x0004978efac32ecbUL;
   tf->codes[8392] = 0x00049797e68d0fceUL;
   tf->codes[8393] = 0x000497a5a01269faUL;
   tf->codes[8394] = 0x000497b6c7f91ab1UL;
   tf->codes[8395] = 0x000497cda7d75ba5UL;
   tf->codes[8396] = 0x000497d3253fe61dUL;
   tf->codes[8397] = 0x000497eaef5a3e25UL;
   tf->codes[8398] = 0x000497ecfe617212UL;
   tf->codes[8399] = 0x000497f32b770dd9UL;
   tf->codes[8400] = 0x000497f415b324edUL;
   tf->codes[8401] = 0x000497f450422ab2UL;
   tf->codes[8402] = 0x000497fcc6ee002bUL;
   tf->codes[8403] = 0x0004980f4e2ed380UL;
   tf->codes[8404] = 0x00049810386aea94UL;
   tf->codes[8405] = 0x0004981ea19d560fUL;
   tf->codes[8406] = 0x00049823a9e7d4fdUL;
   tf->codes[8407] = 0x0004983c5e3e4419UL;
   tf->codes[8408] = 0x00049847939e5eceUL;
   tf->codes[8409] = 0x0004984dc0b3fa95UL;
   tf->codes[8410] = 0x000498528e6f73beUL;
   tf->codes[8411] = 0x000498551294b335UL;
   tf->codes[8412] = 0x00049863b6562475UL;
   tf->codes[8413] = 0x000498742e8fc3ddUL;
   tf->codes[8414] = 0x00049879abf84e55UL;
   tf->codes[8415] = 0x0004987d54e8aaa5UL;
   tf->codes[8416] = 0x0004987eeed1d308UL;
   tf->codes[8417] = 0x00049886f05f9cf7UL;
   tf->codes[8418] = 0x0004988bbe1b1620UL;
   tf->codes[8419] = 0x0004989225bfb7acUL;
   tf->codes[8420] = 0x0004989643ce1f86UL;
   tf->codes[8421] = 0x000498b01cefab7bUL;
   tf->codes[8422] = 0x000498b26685e52dUL;
   tf->codes[8423] = 0x000498bb524fc630UL;
   tf->codes[8424] = 0x000498be4b931131UL;
   tf->codes[8425] = 0x000498c687afe0e5UL;
   tf->codes[8426] = 0x000498d02326d337UL;
   tf->codes[8427] = 0x000498d356f923fdUL;
   tf->codes[8428] = 0x000498da6e4ad6d8UL;
   tf->codes[8429] = 0x000498e394a3bda0UL;
   tf->codes[8430] = 0x000498e5de39f752UL;
   tf->codes[8431] = 0x000498f14e2917ccUL;
   tf->codes[8432] = 0x000498f531a879e1UL;
   tf->codes[8433] = 0x000498f77b3eb393UL;
   tf->codes[8434] = 0x000498f9c4d4ed45UL;
   tf->codes[8435] = 0x00049907f37852fbUL;
   tf->codes[8436] = 0x00049908a325644aUL;
   tf->codes[8437] = 0x0004990b9c68af4bUL;
   tf->codes[8438] = 0x0004990dab6fe338UL;
   tf->codes[8439] = 0x00049912792b5c61UL;
   tf->codes[8440] = 0x00049915726ea762UL;
   tf->codes[8441] = 0x000499170c57cfc5UL;
   tf->codes[8442] = 0x0004991b2a66379fUL;
   tf->codes[8443] = 0x0004993abb7f53d1UL;
   tf->codes[8444] = 0x0004993db4c29ed2UL;
   tf->codes[8445] = 0x0004994715aa8b5fUL;
   tf->codes[8446] = 0x0004994924b1bf4cUL;
   tf->codes[8447] = 0x00049949d45ed09bUL;
   tf->codes[8448] = 0x0004994fc6e5669dUL;
   tf->codes[8449] = 0x00049952c028b19eUL;
   tf->codes[8450] = 0x00049958782041dbUL;
   tf->codes[8451] = 0x0004995dbaf9c68eUL;
   tf->codes[8452] = 0x00049960eecc1754UL;
   tf->codes[8453] = 0x0004996d48f74ee2UL;
   tf->codes[8454] = 0x0004996d838654a7UL;
   tf->codes[8455] = 0x0004997634c12fe5UL;
   tf->codes[8456] = 0x0004999a1e77b9b6UL;
   tf->codes[8457] = 0x000499b3827b3a21UL;
   tf->codes[8458] = 0x000499b815a7ad85UL;
   tf->codes[8459] = 0x000499b93a72ca5eUL;
   tf->codes[8460] = 0x000499c8c87052b2UL;
   tf->codes[8461] = 0x000499d34e235c18UL;
   tf->codes[8462] = 0x000499d681f5acdeUL;
   tf->codes[8463] = 0x000499efab6a2784UL;
   tf->codes[8464] = 0x000499f319cb7e0fUL;
   tf->codes[8465] = 0x000499f56361b7c1UL;
   tf->codes[8466] = 0x000499fb55e84dc3UL;
   tf->codes[8467] = 0x00049a0d2d7c0fc9UL;
   tf->codes[8468] = 0x00049a17edbe1ef4UL;
   tf->codes[8469] = 0x00049a1b96ae7b44UL;
   tf->codes[8470] = 0x00049a235dad3f6eUL;
   tf->codes[8471] = 0x00049a27069d9bbeUL;
   tf->codes[8472] = 0x00049a2fb7d876fcUL;
   tf->codes[8473] = 0x00049a365a0c1e4dUL;
   tf->codes[8474] = 0x00049a377ed73b26UL;
   tf->codes[8475] = 0x00049a3b62569d3bUL;
   tf->codes[8476] = 0x00049a3d715dd128UL;
   tf->codes[8477] = 0x00049a474763c93fUL;
   tf->codes[8478] = 0x00049a4d74796506UL;
   tf->codes[8479] = 0x00049a4f838098f3UL;
   tf->codes[8480] = 0x00049a4ff89ea47dUL;
   tf->codes[8481] = 0x00049a66635ed9e7UL;
   tf->codes[8482] = 0x00049a7c1e71fe02UL;
   tf->codes[8483] = 0x00049a903f9bf9baUL;
   tf->codes[8484] = 0x00049a984129c3a9UL;
   tf->codes[8485] = 0x00049a9cd456370dUL;
   tf->codes[8486] = 0x00049aa844455787UL;
   tf->codes[8487] = 0x00049ab672e8bd3dUL;
   tf->codes[8488] = 0x00049abc2ae04d7aUL;
   tf->codes[8489] = 0x00049abe39e78167UL;
   tf->codes[8490] = 0x00049ac1a848d7f2UL;
   tf->codes[8491] = 0x00049ac29284ef06UL;
   tf->codes[8492] = 0x00049ad170d5660bUL;
   tf->codes[8493] = 0x00049ad4df36bc96UL;
   tf->codes[8494] = 0x00049ad6ee3df083UL;
   tf->codes[8495] = 0x00049ad9e7813b84UL;
   tf->codes[8496] = 0x00049add55e2920fUL;
   tf->codes[8497] = 0x00049ae81624a13aUL;
   tf->codes[8498] = 0x00049af017b26b29UL;
   tf->codes[8499] = 0x00049af853cf3addUL;
   tf->codes[8500] = 0x00049afbfcbf972dUL;
   tf->codes[8501] = 0x00049b00555d04ccUL;
   tf->codes[8502] = 0x00049b09b644f159UL;
   tf->codes[8503] = 0x00049b0e0ee25ef8UL;
   tf->codes[8504] = 0x00049b101de992e5UL;
   tf->codes[8505] = 0x00049b1e871bfe60UL;
   tf->codes[8506] = 0x00049b3616a750a3UL;
   tf->codes[8507] = 0x00049b37eb1f7ecbUL;
   tf->codes[8508] = 0x00049b3b5980d556UL;
   tf->codes[8509] = 0x00049b41fbb47ca7UL;
   tf->codes[8510] = 0x00049b468ee0f00bUL;
   tf->codes[8511] = 0x00049b4fefc8dc98UL;
   tf->codes[8512] = 0x00049b5189b204fbUL;
   tf->codes[8513] = 0x00049b5448664a37UL;
   tf->codes[8514] = 0x00049b5d34302b3aUL;
   tf->codes[8515] = 0x00049b6a3e087417UL;
   tf->codes[8516] = 0x00049b6c879eadc9UL;
   tf->codes[8517] = 0x00049b6ed134e77bUL;
   tf->codes[8518] = 0x00049b77826fc2b9UL;
   tf->codes[8519] = 0x00049b7d3a6752f6UL;
   tf->codes[8520] = 0x00049b85eba22e34UL;
   tf->codes[8521] = 0x00049b874afc50d2UL;
   tf->codes[8522] = 0x00049b8af3ecad22UL;
   tf->codes[8523] = 0x00049b920b3e5ffdUL;
   tf->codes[8524] = 0x00049b941a4593eaUL;
   tf->codes[8525] = 0x00049b95b42ebc4dUL;
   tf->codes[8526] = 0x00049ba75133788eUL;
   tf->codes[8527] = 0x00049bb719c006a7UL;
   tf->codes[8528] = 0x00049bbd0c469ca9UL;
   tf->codes[8529] = 0x00049bbea62fc50cUL;
   tf->codes[8530] = 0x00049bc289af2721UL;
   tf->codes[8531] = 0x00049bc2fecd32abUL;
   tf->codes[8532] = 0x00049bc7cc88abd4UL;
   tf->codes[8533] = 0x00049bd92efe6250UL;
   tf->codes[8534] = 0x00049bdc9d5fb8dbUL;
   tf->codes[8535] = 0x00049bf3f25c0559UL;
   tf->codes[8536] = 0x00049bf96fc48fd1UL;
   tf->codes[8537] = 0x00049c051a42b610UL;
   tf->codes[8538] = 0x00049c063f0dd2e9UL;
   tf->codes[8539] = 0x00049c1d597b19a2UL;
   tf->codes[8540] = 0x00049c293e8845a6UL;
   tf->codes[8541] = 0x00049c2bfd3c8ae2UL;
   tf->codes[8542] = 0x00049c37a7bab121UL;
   tf->codes[8543] = 0x00049c4108a29daeUL;
   tf->codes[8544] = 0x00049c435238d760UL;
   tf->codes[8545] = 0x00049c4b8e55a714UL;
   tf->codes[8546] = 0x00049c4bc8e4acd9UL;
   tf->codes[8547] = 0x00049c4c7891be28UL;
   tf->codes[8548] = 0x00049c6233a4e243UL;
   tf->codes[8549] = 0x00049c69faa3a66dUL;
   tf->codes[8550] = 0x00049c6e8dd019d1UL;
   tf->codes[8551] = 0x00049c756a92c6e7UL;
   tf->codes[8552] = 0x00049c7da6af969bUL;
   tf->codes[8553] = 0x00049c811510ed26UL;
   tf->codes[8554] = 0x00049c85e2cc664fUL;
   tf->codes[8555] = 0x00049c8866f1a5c6UL;
   tf->codes[8556] = 0x00049c8fb8d25e66UL;
   tf->codes[8557] = 0x00049c96d0241141UL;
   tf->codes[8558] = 0x00049ca4fec776f7UL;
   tf->codes[8559] = 0x00049cb45235f986UL;
   tf->codes[8560] = 0x00049cb48cc4ff4bUL;
   tf->codes[8561] = 0x00049cc504fe9eb3UL;
   tf->codes[8562] = 0x00049cc74e94d865UL;
   tf->codes[8563] = 0x00049ccb6ca3403fUL;
   tf->codes[8564] = 0x00049cd24965ed55UL;
   tf->codes[8565] = 0x00049cdc1f6be56cUL;
   tf->codes[8566] = 0x00049ceb72da67fbUL;
   tf->codes[8567] = 0x00049cec2287794aUL;
   tf->codes[8568] = 0x00049cef1bcac44bUL;
   tf->codes[8569] = 0x00049cf424154339UL;
   tf->codes[8570] = 0x00049cf966eec7ecUL;
   tf->codes[8571] = 0x00049cfb75f5fbd9UL;
   tf->codes[8572] = 0x00049cfc603212edUL;
   tf->codes[8573] = 0x00049d0cd86bb255UL;
   tf->codes[8574] = 0x00049d0e7254dab8UL;
   tf->codes[8575] = 0x00049d116b9825b9UL;
   tf->codes[8576] = 0x00049d15c4359358UL;
   tf->codes[8577] = 0x00049d1673e2a4a7UL;
   tf->codes[8578] = 0x00049d1b7c2d2395UL;
   tf->codes[8579] = 0x00049d29aad0894bUL;
   tf->codes[8580] = 0x00049d3d916b7f3eUL;
   tf->codes[8581] = 0x00049d43be811b05UL;
   tf->codes[8582] = 0x00049d4b1061d3a5UL;
   tf->codes[8583] = 0x00049d5ce7f595abUL;
   tf->codes[8584] = 0x00049d5e0cc0b284UL;
   tf->codes[8585] = 0x00049d694220cd39UL;
   tf->codes[8586] = 0x00049d6d9abe3ad8UL;
   tf->codes[8587] = 0x00049d74b20fedb3UL;
   tf->codes[8588] = 0x00049d805c8e13f2UL;
   tf->codes[8589] = 0x00049d8355d15ef3UL;
   tf->codes[8590] = 0x00049d859f6798a5UL;
   tf->codes[8591] = 0x00049d8aa7b21793UL;
   tf->codes[8592] = 0x00049d8bcc7d346cUL;
   tf->codes[8593] = 0x00049d90251aa20bUL;
   tf->codes[8594] = 0x00049d9701dd4f21UL;
   tf->codes[8595] = 0x00049dae1c4a95daUL;
   tf->codes[8596] = 0x00049dbf7ec04c56UL;
   tf->codes[8597] = 0x00049dc3623fae6bUL;
   tf->codes[8598] = 0x00049dc6d0a104f6UL;
   tf->codes[8599] = 0x00049dc954c6446dUL;
   tf->codes[8600] = 0x00049dc9c9e44ff7UL;
   tf->codes[8601] = 0x00049dccfdb6a0bdUL;
   tf->codes[8602] = 0x00049dcf0cbdd4aaUL;
   tf->codes[8603] = 0x00049ddb2c5a0673UL;
   tf->codes[8604] = 0x00049dfba7af39b9UL;
   tf->codes[8605] = 0x00049dff16109044UL;
   tf->codes[8606] = 0x00049e05f2d33d5aUL;
   tf->codes[8607] = 0x00049e0d7f42fbbfUL;
   tf->codes[8608] = 0x00049e0fc8d93571UL;
   tf->codes[8609] = 0x00049e11d7e0695eUL;
   tf->codes[8610] = 0x00049e12878d7aadUL;
   tf->codes[8611] = 0x00049e17ca66ff60UL;
   tf->codes[8612] = 0x00049e3720f115cdUL;
   tf->codes[8613] = 0x00049e38bada3e30UL;
   tf->codes[8614] = 0x00049e3c9e59a045UL;
   tf->codes[8615] = 0x00049e400cbaf6d0UL;
   tf->codes[8616] = 0x00049e4b078c0bc0UL;
   tf->codes[8617] = 0x00049e4bb7391d0fUL;
   tf->codes[8618] = 0x00049e563cec2675UL;
   tf->codes[8619] = 0x00049e667a96c018UL;
   tf->codes[8620] = 0x00049e6fa0efa6e0UL;
   tf->codes[8621] = 0x00049e7b85fcd2e4UL;
   tf->codes[8622] = 0x00049e7bfb1ade6eUL;
   tf->codes[8623] = 0x00049e7d5a75010cUL;
   tf->codes[8624] = 0x00049e943a534200UL;
   tf->codes[8625] = 0x00049e9733968d01UL;
   tf->codes[8626] = 0x00049eb9f881f9f9UL;
   tf->codes[8627] = 0x00049eba6da00583UL;
   tf->codes[8628] = 0x00049ebb926b225cUL;
   tf->codes[8629] = 0x00049ec2349ec9adUL;
   tf->codes[8630] = 0x00049ec47e35035fUL;
   tf->codes[8631] = 0x00049ec7b2075425UL;
   tf->codes[8632] = 0x00049ecb5af7b075UL;
   tf->codes[8633] = 0x00049eccf4e0d8d8UL;
   tf->codes[8634] = 0x00049ede57568f54UL;
   tf->codes[8635] = 0x00049ee9c745afceUL;
   tf->codes[8636] = 0x00049eed35a70659UL;
   tf->codes[8637] = 0x00049eef44ae3a46UL;
   tf->codes[8638] = 0x00049eefb9cc45d0UL;
   tf->codes[8639] = 0x00049ef0a4085ce4UL;
   tf->codes[8640] = 0x00049ef3d7daadaaUL;
   tf->codes[8641] = 0x00049ef5e6e1e197UL;
   tf->codes[8642] = 0x00049ef62170e75cUL;
   tf->codes[8643] = 0x00049f0699aa86c4UL;
   tf->codes[8644] = 0x00049f0db0fc399fUL;
   tf->codes[8645] = 0x00049f11947b9bb4UL;
   tf->codes[8646] = 0x00049f17870231b6UL;
   tf->codes[8647] = 0x00049f1920eb5a19UL;
   tf->codes[8648] = 0x00049f1abad4827cUL;
   tf->codes[8649] = 0x00049f1b2ff28e06UL;
   tf->codes[8650] = 0x00049f1d3ef9c1f3UL;
   tf->codes[8651] = 0x00049f3493f60e71UL;
   tf->codes[8652] = 0x00049f5d85f71730UL;
   tf->codes[8653] = 0x00049f65fca2eca9UL;
   tf->codes[8654] = 0x00049f66e6df03bdUL;
   tf->codes[8655] = 0x00049f74daf363aeUL;
   tf->codes[8656] = 0x00049f7dc6bd44b1UL;
   tf->codes[8657] = 0x00049f8886ff53dcUL;
   tf->codes[8658] = 0x00049f984f8be1f5UL;
   tf->codes[8659] = 0x00049f9b835e32bbUL;
   tf->codes[8660] = 0x00049fae0a9f0610UL;
   tf->codes[8661] = 0x00049fb76b86f29dUL;
   tf->codes[8662] = 0x00049fbf3285b6c7UL;
   tf->codes[8663] = 0x00049fc858de9d8fUL;
   tf->codes[8664] = 0x00049fcaa274d741UL;
   tf->codes[8665] = 0x00049fd64cf2fd80UL;
   tf->codes[8666] = 0x00049fe774d9ae37UL;
   tf->codes[8667] = 0x00049ff26faac327UL;
   tf->codes[8668] = 0x0004a0014dfb3a2cUL;
   tf->codes[8669] = 0x0004a00c0e3d4957UL;
   tf->codes[8670] = 0x0004a00f07809458UL;
   tf->codes[8671] = 0x0004a01066dab6f6UL;
   tf->codes[8672] = 0x0004a0115116ce0aUL;
   tf->codes[8673] = 0x0004a01484e91ed0UL;
   tf->codes[8674] = 0x0004a017f34a755bUL;
   tf->codes[8675] = 0x0004a03a0888d104UL;
   tf->codes[8676] = 0x0004a046282502cdUL;
   tf->codes[8677] = 0x0004a053a71b5734UL;
   tf->codes[8678] = 0x0004a057157cadbfUL;
   tf->codes[8679] = 0x0004a05874d6d05dUL;
   tf->codes[8680] = 0x0004a06a86f99828UL;
   tf->codes[8681] = 0x0004a06cd08fd1daUL;
   tf->codes[8682] = 0x0004a077cb60e6caUL;
   tf->codes[8683] = 0x0004a07c23fe5469UL;
   tf->codes[8684] = 0x0004a082c631fbbaUL;
   tf->codes[8685] = 0x0004a08c9c37f3d1UL;
   tf->codes[8686] = 0x0004a09721eafd37UL;
   tf->codes[8687] = 0x0004a09930f23124UL;
   tf->codes[8688] = 0x0004a09cd9e28d74UL;
   tf->codes[8689] = 0x0004a0acdcfe2152UL;
   tf->codes[8690] = 0x0004a0ad8cab32a1UL;
   tf->codes[8691] = 0x0004a0c29811456dUL;
   tf->codes[8692] = 0x0004a0d4e4c312fdUL;
   tf->codes[8693] = 0x0004a0d853246988UL;
   tf->codes[8694] = 0x0004a0de45aaff8aUL;
   tf->codes[8695] = 0x0004a0e4ad4fa116UL;
   tf->codes[8696] = 0x0004a0e681c7cf3eUL;
   tf->codes[8697] = 0x0004a0fa6862c531UL;
   tf->codes[8698] = 0x0004a10269f08f20UL;
   tf->codes[8699] = 0x0004a116c5a9909dUL;
   tf->codes[8700] = 0x0004a117afe5a7b1UL;
   tf->codes[8701] = 0x0004a11ae3b7f877UL;
   tf->codes[8702] = 0x0004a11c7da120daUL;
   tf->codes[8703] = 0x0004a14ff55532ffUL;
   tf->codes[8704] = 0x0004a1506a733e89UL;
   tf->codes[8705] = 0x0004a1511a204fd8UL;
   tf->codes[8706] = 0x0004a156226acec6UL;
   tf->codes[8707] = 0x0004a1620777facaUL;
   tf->codes[8708] = 0x0004a16b2dd0e192UL;
   tf->codes[8709] = 0x0004a17af65d6fabUL;
   tf->codes[8710] = 0x0004a18c1e442062UL;
   tf->codes[8711] = 0x0004a18c93622becUL;
   tf->codes[8712] = 0x0004a19076e18e01UL;
   tf->codes[8713] = 0x0004a193aab3dec7UL;
   tf->codes[8714] = 0x0004a19e6af5edf2UL;
   tf->codes[8715] = 0x0004a1a840fbe609UL;
   tf->codes[8716] = 0x0004a1ae6e1181d0UL;
   tf->codes[8717] = 0x0004a1bac83cb95eUL;
   tf->codes[8718] = 0x0004a1c254ac77c3UL;
   tf->codes[8719] = 0x0004a1ca563a41b2UL;
   tf->codes[8720] = 0x0004a1ce39b9a3c7UL;
   tf->codes[8721] = 0x0004a1e812db2fbcUL;
   tf->codes[8722] = 0x0004a1e887f93b46UL;
   tf->codes[8723] = 0x0004a1f606ef8fadUL;
   tf->codes[8724] = 0x0004a1fa5f8cfd4cUL;
   tf->codes[8725] = 0x0004a2055a5e123cUL;
   tf->codes[8726] = 0x0004a2093ddd7451UL;
   tf->codes[8727] = 0x0004a20a62a8912aUL;
   tf->codes[8728] = 0x0004a20b8773ae03UL;
   tf->codes[8729] = 0x0004a214adcc94cbUL;
   tf->codes[8730] = 0x0004a215d297b1a4UL;
   tf->codes[8731] = 0x0004a21731f1d442UL;
   tf->codes[8732] = 0x0004a219f0a6197eUL;
   tf->codes[8733] = 0x0004a21b8a8f41e1UL;
   tf->codes[8734] = 0x0004a21d5f077009UL;
   tf->codes[8735] = 0x0004a2385cf418d7UL;
   tf->codes[8736] = 0x0004a2439254338cUL;
   tf->codes[8737] = 0x0004a24d2dcb25deUL;
   tf->codes[8738] = 0x0004a24e18073cf2UL;
   tf->codes[8739] = 0x0004a252e5c2b61bUL;
   tf->codes[8740] = 0x0004a257b37e2f44UL;
   tf->codes[8741] = 0x0004a25f7a7cf36eUL;
   tf->codes[8742] = 0x0004a264f7e57de6UL;
   tf->codes[8743] = 0x0004a284c38d9fddUL;
   tf->codes[8744] = 0x0004a285e858bcb6UL;
   tf->codes[8745] = 0x0004a287f75ff0a3UL;
   tf->codes[8746] = 0x0004a29416fc226cUL;
   tf->codes[8747] = 0x0004a297103f6d6dUL;
   tf->codes[8748] = 0x0004a29f4c5c3d21UL;
   tf->codes[8749] = 0x0004a2afc495dc89UL;
   tf->codes[8750] = 0x0004a2b0aed1f39dUL;
   tf->codes[8751] = 0x0004a2b78b94a0b3UL;
   tf->codes[8752] = 0x0004a2c2c0f4bb68UL;
   tf->codes[8753] = 0x0004a2c4cffbef55UL;
   tf->codes[8754] = 0x0004a2d24ef243bcUL;
   tf->codes[8755] = 0x0004a2d8b696e548UL;
   tf->codes[8756] = 0x0004a2da15f107e6UL;
   tf->codes[8757] = 0x0004a2f304d67cc7UL;
   tf->codes[8758] = 0x0004a2f5fe19c7c8UL;
   tf->codes[8759] = 0x0004a2f6e855dedcUL;
   tf->codes[8760] = 0x0004a2fd8a89862dUL;
   tf->codes[8761] = 0x0004a309aa25b7f6UL;
   tf->codes[8762] = 0x0004a31888762efbUL;
   tf->codes[8763] = 0x0004a33d21d9ca1bUL;
   tf->codes[8764] = 0x0004a351f2b0d722UL;
   tf->codes[8765] = 0x0004a3638fb59363UL;
   tf->codes[8766] = 0x0004a36738a5efb3UL;
   tf->codes[8767] = 0x0004a3726e060a68UL;
   tf->codes[8768] = 0x0004a377eb6e94e0UL;
   tf->codes[8769] = 0x0004a3794ac8b77eUL;
   tf->codes[8770] = 0x0004a37d68d71f58UL;
   tf->codes[8771] = 0x0004a3873edd176fUL;
   tf->codes[8772] = 0x0004a3889e373a0dUL;
   tf->codes[8773] = 0x0004a391c49020d5UL;
   tf->codes[8774] = 0x0004a39d6f0e4714UL;
   tf->codes[8775] = 0x0004a3a7f4c1507aUL;
   tf->codes[8776] = 0x0004a3ab9db1accaUL;
   tf->codes[8777] = 0x0004a3c69b9e5598UL;
   tf->codes[8778] = 0x0004a3c74b4b66e7UL;
   tf->codes[8779] = 0x0004a3c95a529ad4UL;
   tf->codes[8780] = 0x0004a3c9cf70a65eUL;
   tf->codes[8781] = 0x0004a3d121515efeUL;
   tf->codes[8782] = 0x0004a3ddb60b9c51UL;
   tf->codes[8783] = 0x0004a3eabfe3e52eUL;
   tf->codes[8784] = 0x0004a40d0fb1469cUL;
   tf->codes[8785] = 0x0004a41043839762UL;
   tf->codes[8786] = 0x0004a4112dbfae76UL;
   tf->codes[8787] = 0x0004a411a2ddba00UL;
   tf->codes[8788] = 0x0004a414d6b00ac6UL;
   tf->codes[8789] = 0x0004a41b78e3b217UL;
   tf->codes[8790] = 0x0004a42e3ab38b31UL;
   tf->codes[8791] = 0x0004a43552053e0cUL;
   tf->codes[8792] = 0x0004a445ca3edd74UL;
   tf->codes[8793] = 0x0004a44fdad3db50UL;
   tf->codes[8794] = 0x0004a45a25f7def1UL;
   tf->codes[8795] = 0x0004a4734f6c5997UL;
   tf->codes[8796] = 0x0004a47389fb5f5cUL;
   tf->codes[8797] = 0x0004a47bc6182f10UL;
   tf->codes[8798] = 0x0004a49390328718UL;
   tf->codes[8799] = 0x0004a49564aab540UL;
   tf->codes[8800] = 0x0004a4990d9b1190UL;
   tf->codes[8801] = 0x0004a49fafceb8e1UL;
   tf->codes[8802] = 0x0004a4bb22d96d39UL;
   tf->codes[8803] = 0x0004a4be913ac3c4UL;
   tf->codes[8804] = 0x0004a4c483c159c6UL;
   tf->codes[8805] = 0x0004a4c56dfd70daUL;
   tf->codes[8806] = 0x0004a4d32782cb06UL;
   tf->codes[8807] = 0x0004a4d5aba80a7dUL;
   tf->codes[8808] = 0x0004a4da3ed47de1UL;
   tf->codes[8809] = 0x0004a4dff6cc0e1eUL;
   tf->codes[8810] = 0x0004a4e992430070UL;
   tf->codes[8811] = 0x0004a4f27e0ce173UL;
   tf->codes[8812] = 0x0004a4f7c0e66626UL;
   tf->codes[8813] = 0x0004a4fa0a7c9fd8UL;
   tf->codes[8814] = 0x0004a4fe631a0d77UL;
   tf->codes[8815] = 0x0004a505b4fac617UL;
   tf->codes[8816] = 0x0004a509235c1ca2UL;
   tf->codes[8817] = 0x0004a50f5071b869UL;
   tf->codes[8818] = 0x0004a5141e2d3192UL;
   tf->codes[8819] = 0x0004a51afaefdea8UL;
   tf->codes[8820] = 0x0004a5333a28423aUL;
   tf->codes[8821] = 0x0004a538b790ccb2UL;
   tf->codes[8822] = 0x0004a53c25f2233dUL;
   tf->codes[8823] = 0x0004a53f945379c8UL;
   tf->codes[8824] = 0x0004a541dde9b37aUL;
   tf->codes[8825] = 0x0004a54c9e2bc2a5UL;
   tf->codes[8826] = 0x0004a54f976f0da6UL;
   tf->codes[8827] = 0x0004a55305d06431UL;
   tf->codes[8828] = 0x0004a554da489259UL;
   tf->codes[8829] = 0x0004a55514d7981eUL;
   tf->codes[8830] = 0x0004a5567431babcUL;
   tf->codes[8831] = 0x0004a559e2931147UL;
   tf->codes[8832] = 0x0004a55d8b836d97UL;
   tf->codes[8833] = 0x0004a56a955bb674UL;
   tf->codes[8834] = 0x0004a56b7f97cd88UL;
   tf->codes[8835] = 0x0004a571721e638aUL;
   tf->codes[8836] = 0x0004a57c326072b5UL;
   tf->codes[8837] = 0x0004a57d91ba9553UL;
   tf->codes[8838] = 0x0004a581ea5802f2UL;
   tf->codes[8839] = 0x0004a588176d9eb9UL;
   tf->codes[8840] = 0x0004a58b10b0e9baUL;
   tf->codes[8841] = 0x0004a590c8a879f7UL;
   tf->codes[8842] = 0x0004a591b2e4910bUL;
   tf->codes[8843] = 0x0004a594e6b6e1d1UL;
   tf->codes[8844] = 0x0004a596f5be15beUL;
   tf->codes[8845] = 0x0004a59e479ece5eUL;
   tf->codes[8846] = 0x0004a59f6c69eb37UL;
   tf->codes[8847] = 0x0004a5afe4a38a9fUL;
   tf->codes[8848] = 0x0004a5bd6399df06UL;
   tf->codes[8849] = 0x0004a5c23155582fUL;
   tf->codes[8850] = 0x0004a5c90e180545UL;
   tf->codes[8851] = 0x0004a5cc7c795bd0UL;
   tf->codes[8852] = 0x0004a5d09a87c3aaUL;
   tf->codes[8853] = 0x0004a5d2a98ef797UL;
   tf->codes[8854] = 0x0004a5d31ead0321UL;
   tf->codes[8855] = 0x0004a5d7774a70c0UL;
   tf->codes[8856] = 0x0004a5d98651a4adUL;
   tf->codes[8857] = 0x0004a5dc0a76e424UL;
   tf->codes[8858] = 0x0004a5dddeef124cUL;
   tf->codes[8859] = 0x0004a5de540d1dd6UL;
   tf->codes[8860] = 0x0004a5e56b5ed0b1UL;
   tf->codes[8861] = 0x0004a5f1506bfcb5UL;
   tf->codes[8862] = 0x0004a5f6cdd4872dUL;
   tf->codes[8863] = 0x0004a5f742f292b7UL;
   tf->codes[8864] = 0x0004a60c88e7ab48UL;
   tf->codes[8865] = 0x0004a61d3bb05075UL;
   tf->codes[8866] = 0x0004a61e25ec6789UL;
   tf->codes[8867] = 0x0004a6274c454e51UL;
   tf->codes[8868] = 0x0004a62d043cde8eUL;
   tf->codes[8869] = 0x0004a6420fa2f15aUL;
   tf->codes[8870] = 0x0004a64508e63c5bUL;
   tf->codes[8871] = 0x0004a64ea45d2eadUL;
   tf->codes[8872] = 0x0004a65be8c47d4fUL;
   tf->codes[8873] = 0x0004a6628af824a0UL;
   tf->codes[8874] = 0x0004a66bebe0112dUL;
   tf->codes[8875] = 0x0004a66fcf5f7342UL;
   tf->codes[8876] = 0x0004a673b2ded557UL;
   tf->codes[8877] = 0x0004a6775bcf31a7UL;
   tf->codes[8878] = 0x0004a67ee83ef00cUL;
   tf->codes[8879] = 0x0004a689a880ff37UL;
   tf->codes[8880] = 0x0004a68c67354473UL;
   tf->codes[8881] = 0x0004a68f25e989afUL;
   tf->codes[8882] = 0x0004a6904ab4a688UL;
   tf->codes[8883] = 0x0004a69677ca424fUL;
   tf->codes[8884] = 0x0004a69a5b49a464UL;
   tf->codes[8885] = 0x0004a6b559364d32UL;
   tf->codes[8886] = 0x0004a6c103b47371UL;
   tf->codes[8887] = 0x0004a6c387d9b2e8UL;
   tf->codes[8888] = 0x0004a6c4aca4cfc1UL;
   tf->codes[8889] = 0x0004a6c55c51e110UL;
   tf->codes[8890] = 0x0004a6c6bbac03aeUL;
   tf->codes[8891] = 0x0004a6d091b1fbc5UL;
   tf->codes[8892] = 0x0004a6d6843891c7UL;
   tf->codes[8893] = 0x0004a6d81e21ba2aUL;
   tf->codes[8894] = 0x0004a6ee4e52e9cfUL;
   tf->codes[8895] = 0x0004a6eec370f559UL;
   tf->codes[8896] = 0x0004a6ef388f00e3UL;
   tf->codes[8897] = 0x0004a6f7e9c9dc21UL;
   tf->codes[8898] = 0x0004a70025e6abd5UL;
   tf->codes[8899] = 0x0004a708d7218713UL;
   tf->codes[8900] = 0x0004a71272987965UL;
   tf->codes[8901] = 0x0004a71da7f8941aUL;
   tf->codes[8902] = 0x0004a72693c2751dUL;
   tf->codes[8903] = 0x0004a739902153fcUL;
   tf->codes[8904] = 0x0004a73ab4ec70d5UL;
   tf->codes[8905] = 0x0004a74699f99cd9UL;
   tf->codes[8906] = 0x0004a74958ade215UL;
   tf->codes[8907] = 0x0004a7724aaeead4UL;
   tf->codes[8908] = 0x0004a77b3678cbd7UL;
   tf->codes[8909] = 0x0004a78805c20eefUL;
   tf->codes[8910] = 0x0004a79a5273dc7fUL;
   tf->codes[8911] = 0x0004a79c617b106cUL;
   tf->codes[8912] = 0x0004a7ad1443b599UL;
   tf->codes[8913] = 0x0004a7adc3f0c6e8UL;
   tf->codes[8914] = 0x0004a7d34790791cUL;
   tf->codes[8915] = 0x0004a7d93a170f1eUL;
   tf->codes[8916] = 0x0004a7eef52a3339UL;
   tf->codes[8917] = 0x0004a81c7a57af5cUL;
   tf->codes[8918] = 0x0004a8268aecad38UL;
   tf->codes[8919] = 0x0004a838d79e7ac8UL;
   tf->codes[8920] = 0x0004a83cf5ace2a2UL;
   tf->codes[8921] = 0x0004a83feef02da3UL;
   tf->codes[8922] = 0x0004a8414e4a5041UL;
   tf->codes[8923] = 0x0004a842e83378a4UL;
   tf->codes[8924] = 0x0004a845e176c3a5UL;
   tf->codes[8925] = 0x0004a854bfc73aaaUL;
   tf->codes[8926] = 0x0004a858a3469cbfUL;
   tf->codes[8927] = 0x0004a858ddd5a284UL;
   tf->codes[8928] = 0x0004a85cc1550499UL;
   tf->codes[8929] = 0x0004a877bf41ad67UL;
   tf->codes[8930] = 0x0004a87ba2c10f7cUL;
   tf->codes[8931] = 0x0004a8853e3801ceUL;
   tf->codes[8932] = 0x0004a887fcec470aUL;
   tf->codes[8933] = 0x0004a88d7a54d182UL;
   tf->codes[8934] = 0x0004a897505ac999UL;
   tf->codes[8935] = 0x0004a89af94b25e9UL;
   tf->codes[8936] = 0x0004a8b8f07b19b8UL;
   tf->codes[8937] = 0x0004a8baff824da5UL;
   tf->codes[8938] = 0x0004a8dc2a84923aUL;
   tf->codes[8939] = 0x0004a8e550dd7902UL;
   tf->codes[8940] = 0x0004a8e79a73b2b4UL;
   tf->codes[8941] = 0x0004a8eb43640f04UL;
   tf->codes[8942] = 0x0004a8f9ac967a7fUL;
   tf->codes[8943] = 0x0004a8fad1619758UL;
   tf->codes[8944] = 0x0004a9131099faeaUL;
   tf->codes[8945] = 0x0004a93f70fc5a34UL;
   tf->codes[8946] = 0x0004a947728a2423UL;
   tf->codes[8947] = 0x0004a953ccb55bb1UL;
   tf->codes[8948] = 0x0004a95a6ee90302UL;
   tf->codes[8949] = 0x0004a95ae4070e8cUL;
   tf->codes[8950] = 0x0004a95e17d95f52UL;
   tf->codes[8951] = 0x0004a977f0faeb47UL;
   tf->codes[8952] = 0x0004a978db37025bUL;
   tf->codes[8953] = 0x0004a987f4167f25UL;
   tf->codes[8954] = 0x0004a988de529639UL;
   tf->codes[8955] = 0x0004a98ab2cac461UL;
   tf->codes[8956] = 0x0004a98f45f737c5UL;
   tf->codes[8957] = 0x0004a99782140779UL;
   tf->codes[8958] = 0x0004a9b95cc35d5dUL;
   tf->codes[8959] = 0x0004a9ba0c706eacUL;
   tf->codes[8960] = 0x0004a9bbe0e89cd4UL;
   tf->codes[8961] = 0x0004a9c45794724dUL;
   tf->codes[8962] = 0x0004a9c62c0ca075UL;
   tf->codes[8963] = 0x0004a9cc1e933677UL;
   tf->codes[8964] = 0x0004a9d07730a416UL;
   tf->codes[8965] = 0x0004a9d0ec4eafa0UL;
   tf->codes[8966] = 0x0004a9dac254a7b7UL;
   tf->codes[8967] = 0x0004a9db3772b341UL;
   tf->codes[8968] = 0x0004a9dc5c3dd01aUL;
   tf->codes[8969] = 0x0004a9e164884f08UL;
   tf->codes[8970] = 0x0004a9f92ea2a710UL;
   tf->codes[8971] = 0x0004a9ff5bb842d7UL;
   tf->codes[8972] = 0x0004aa0dff79b417UL;
   tf->codes[8973] = 0x0004aa1725d29adfUL;
   tf->codes[8974] = 0x0004aa1f276064ceUL;
   tf->codes[8975] = 0x0004aa29e7a273f9UL;
   tf->codes[8976] = 0x0004aa36b6ebb711UL;
   tf->codes[8977] = 0x0004aa447071113dUL;
   tf->codes[8978] = 0x0004aa57e1edfba6UL;
   tf->codes[8979] = 0x0004aa5e0f03976dUL;
   tf->codes[8980] = 0x0004aa6f71794de9UL;
   tf->codes[8981] = 0x0004aa7738781213UL;
   tf->codes[8982] = 0x0004aa79f72c574fUL;
   tf->codes[8983] = 0x0004aa7cf06fa250UL;
   tf->codes[8984] = 0x0004aa873b93a5f1UL;
   tf->codes[8985] = 0x0004aa8d68a941b8UL;
   tf->codes[8986] = 0x0004aa91fbd5b51cUL;
   tf->codes[8987] = 0x0004aa96547322bbUL;
   tf->codes[8988] = 0x0004aa99fd637f0bUL;
   tf->codes[8989] = 0x0004aaa7073bc7e8UL;
   tf->codes[8990] = 0x0004aaad345163afUL;
   tf->codes[8991] = 0x0004aab2b1b9ee27UL;
   tf->codes[8992] = 0x0004aabdac8b0317UL;
   tf->codes[8993] = 0x0004aac030b0428eUL;
   tf->codes[8994] = 0x0004aacab6634bf4UL;
   tf->codes[8995] = 0x0004aacba09f6308UL;
   tf->codes[8996] = 0x0004aad3a22d2cf7UL;
   tf->codes[8997] = 0x0004aad3dcbc32bcUL;
   tf->codes[8998] = 0x0004aad4c6f849d0UL;
   tf->codes[8999] = 0x0004aaee658ad000UL;
   tf->codes[9000] = 0x0004aafba9f21ea2UL;
   tf->codes[9001] = 0x0004aafd43db4705UL;
   tf->codes[9002] = 0x0004ab078eff4aa6UL;
   tf->codes[9003] = 0x0004ab09d8958458UL;
   tf->codes[9004] = 0x0004ab0fcb1c1a5aUL;
   tf->codes[9005] = 0x0004ab1423b987f9UL;
   tf->codes[9006] = 0x0004ab1a16401dfbUL;
   tf->codes[9007] = 0x0004ab1ee3fb9724UL;
   tf->codes[9008] = 0x0004ab2eac88253dUL;
   tf->codes[9009] = 0x0004ab32ca968d17UL;
   tf->codes[9010] = 0x0004ab337a439e66UL;
   tf->codes[9011] = 0x0004ab3f99dfd02fUL;
   tf->codes[9012] = 0x0004ab47d5fc9fe3UL;
   tf->codes[9013] = 0x0004ab6383965a00UL;
   tf->codes[9014] = 0x0004ab64a86176d9UL;
   tf->codes[9015] = 0x0004ab708d6ea2ddUL;
   tf->codes[9016] = 0x0004ab74365eff2dUL;
   tf->codes[9017] = 0x0004ab764566331aUL;
   tf->codes[9018] = 0x0004ab77df4f5b7dUL;
   tf->codes[9019] = 0x0004ab7d5cb7e5f5UL;
   tf->codes[9020] = 0x0004ab8f6edaadc0UL;
   tf->codes[9021] = 0x0004abaae1e56218UL;
   tf->codes[9022] = 0x0004abb1498a03a4UL;
   tf->codes[9023] = 0x0004abb1f93714f3UL;
   tf->codes[9024] = 0x0004abbf782d695aUL;
   tf->codes[9025] = 0x0004abc027da7aa9UL;
   tf->codes[9026] = 0x0004abc35baccb6fUL;
   tf->codes[9027] = 0x0004abc6ca0e21faUL;
   tf->codes[9028] = 0x0004abd14fc12b60UL;
   tf->codes[9029] = 0x0004abd18a503125UL;
   tf->codes[9030] = 0x0004abd239fd4274UL;
   tf->codes[9031] = 0x0004abdb25c72377UL;
   tf->codes[9032] = 0x0004abde94287a02UL;
   tf->codes[9033] = 0x0004abef46f11f2fUL;
   tf->codes[9034] = 0x0004abf4fee8af6cUL;
   tf->codes[9035] = 0x0004abfe5fd09bf9UL;
   tf->codes[9036] = 0x0004ac074b9a7cfcUL;
   tf->codes[9037] = 0x0004ac0bdec6f060UL;
   tf->codes[9038] = 0x0004ac1196be809dUL;
   tf->codes[9039] = 0x0004ac153faedcedUL;
   tf->codes[9040] = 0x0004ac15ef5bee3cUL;
   tf->codes[9041] = 0x0004ac18ae103378UL;
   tf->codes[9042] = 0x0004ac328731bf6dUL;
   tf->codes[9043] = 0x0004ac32fc4fcaf7UL;
   tf->codes[9044] = 0x0004ac3ac34e8f21UL;
   tf->codes[9045] = 0x0004ac40062813d4UL;
   tf->codes[9046] = 0x0004ac40b5d52523UL;
   tf->codes[9047] = 0x0004ac45be1fa411UL;
   tf->codes[9048] = 0x0004ac5dc2c901deUL;
   tf->codes[9049] = 0x0004ac69e26533a7UL;
   tf->codes[9050] = 0x0004ac6a57833f31UL;
   tf->codes[9051] = 0x0004ac73434d2034UL;
   tf->codes[9052] = 0x0004ac74a2a742d2UL;
   tf->codes[9053] = 0x0004ac7552545421UL;
   tf->codes[9054] = 0x0004ac8ce1dfa664UL;
   tf->codes[9055] = 0x0004ac8d918cb7b3UL;
   tf->codes[9056] = 0x0004acb97cd10b73UL;
   tf->codes[9057] = 0x0004acbefa3995ebUL;
   tf->codes[9058] = 0x0004acc9455d998cUL;
   tf->codes[9059] = 0x0004acca6a28b665UL;
   tf->codes[9060] = 0x0004acdaa7d35008UL;
   tf->codes[9061] = 0x0004acde50c3ac58UL;
   tf->codes[9062] = 0x0004acee8e6e45fbUL;
   tf->codes[9063] = 0x0004acfaae0a77c4UL;
   tf->codes[9064] = 0x0004acff06a7e563UL;
   tf->codes[9065] = 0x0004ad18a53a6b93UL;
   tf->codes[9066] = 0x0004ad1954e77ce2UL;
   tf->codes[9067] = 0x0004ad1b63eeb0cfUL;
   tf->codes[9068] = 0x0004ad3d3e9e06b3UL;
   tf->codes[9069] = 0x0004ad4ccc9b8f07UL;
   tf->codes[9070] = 0x0004ad541e7c47a7UL;
   tf->codes[9071] = 0x0004ad54939a5331UL;
   tf->codes[9072] = 0x0004ad6496b5e70fUL;
   tf->codes[9073] = 0x0004ad6df79dd39cUL;
   tf->codes[9074] = 0x0004ad70f0e11e9dUL;
   tf->codes[9075] = 0x0004ad74d46080b2UL;
   tf->codes[9076] = 0x0004ad792cfdee51UL;
   tf->codes[9077] = 0x0004ad79678cf416UL;
   tf->codes[9078] = 0x0004ad8dfdd4fb58UL;
   tf->codes[9079] = 0x0004ad97994bedaaUL;
   tf->codes[9080] = 0x0004ad9d8bd283acUL;
   tf->codes[9081] = 0x0004ad9e00f08f36UL;
   tf->codes[9082] = 0x0004ad9fd568bd5eUL;
   tf->codes[9083] = 0x0004adb3f692b916UL;
   tf->codes[9084] = 0x0004adb64028f2c8UL;
   tf->codes[9085] = 0x0004adc0162eeadfUL;
   tf->codes[9086] = 0x0004adc25fc52491UL;
   tf->codes[9087] = 0x0004adeaa2191c01UL;
   tf->codes[9088] = 0x0004adfb54e1c12eUL;
   tf->codes[9089] = 0x0004adfc048ed27dUL;
   tf->codes[9090] = 0x0004adffad7f2ecdUL;
   tf->codes[9091] = 0x0004ae01bc8662baUL;
   tf->codes[9092] = 0x0004ae0b1d6e4f47UL;
   tf->codes[9093] = 0x0004ae36ce239d42UL;
   tf->codes[9094] = 0x0004ae3e5a935ba7UL;
   tf->codes[9095] = 0x0004ae4e983df54aUL;
   tf->codes[9096] = 0x0004ae5e60ca8363UL;
   tf->codes[9097] = 0x0004ae648de01f2aUL;
   tf->codes[9098] = 0x0004ae68e67d8cc9UL;
   tf->codes[9099] = 0x0004ae6db43905f2UL;
   tf->codes[9100] = 0x0004ae7c57fa7732UL;
   tf->codes[9101] = 0x0004ae7edc1fb6a9UL;
   tf->codes[9102] = 0x0004ae8961d2c00fUL;
   tf->codes[9103] = 0x0004ae8d7fe127e9UL;
   tf->codes[9104] = 0x0004ae924d9ca112UL;
   tf->codes[9105] = 0x0004ae95816ef1d8UL;
   tf->codes[9106] = 0x0004ae9f9203efb4UL;
   tf->codes[9107] = 0x0004aeb9a5b4816eUL;
   tf->codes[9108] = 0x0004aec84975f2aeUL;
   tf->codes[9109] = 0x0004aee30cd395b7UL;
   tf->codes[9110] = 0x0004aef5cea36ed1UL;
   tf->codes[9111] = 0x0004aef8c7e6b9d2UL;
   tf->codes[9112] = 0x0004aefcab661be7UL;
   tf->codes[9113] = 0x0004af0fe254008bUL;
   tf->codes[9114] = 0x0004af14758073efUL;
   tf->codes[9115] = 0x0004af2e4ea1ffe4UL;
   tf->codes[9116] = 0x0004af34b646a170UL;
   tf->codes[9117] = 0x0004af37ea18f236UL;
   tf->codes[9118] = 0x0004af486252919eUL;
   tf->codes[9119] = 0x0004af5272e78f7aUL;
   tf->codes[9120] = 0x0004af52ad76953fUL;
   tf->codes[9121] = 0x0004af561bd7ebcaUL;
   tf->codes[9122] = 0x0004af58656e257cUL;
   tf->codes[9123] = 0x0004af5bd3cf7c07UL;
   tf->codes[9124] = 0x0004af623b741d93UL;
   tf->codes[9125] = 0x0004af6e5b104f5cUL;
   tf->codes[9126] = 0x0004af77bbf83be9UL;
   tf->codes[9127] = 0x0004af77f68741aeUL;
   tf->codes[9128] = 0x0004afa665f0d4e5UL;
   tf->codes[9129] = 0x0004afaf8c49bbadUL;
   tf->codes[9130] = 0x0004afbbe674f33bUL;
   tf->codes[9131] = 0x0004afbedfb83e3cUL;
   tf->codes[9132] = 0x0004afd0f1db0607UL;
   tf->codes[9133] = 0x0004afdb027003e3UL;
   tf->codes[9134] = 0x0004afe0ba679420UL;
   tf->codes[9135] = 0x0004b013bcfd9abbUL;
   tf->codes[9136] = 0x0004b017db0c0295UL;
   tf->codes[9137] = 0x0004b03104807d3bUL;
   tf->codes[9138] = 0x0004b04b52c014baUL;
   tf->codes[9139] = 0x0004b04d273842e2UL;
   tf->codes[9140] = 0x0004b05563551296UL;
   tf->codes[9141] = 0x0004b06b9386423bUL;
   tf->codes[9142] = 0x0004b0747f50233eUL;
   tf->codes[9143] = 0x0004b07653c85166UL;
   tf->codes[9144] = 0x0004b0768e57572bUL;
   tf->codes[9145] = 0x0004b07e1ac71590UL;
   tf->codes[9146] = 0x0004b08c0edb7581UL;
   tf->codes[9147] = 0x0004b095aa5267d3UL;
   tf->codes[9148] = 0x0004b09f45c95a25UL;
   tf->codes[9149] = 0x0004b0b157ec21f0UL;
   tf->codes[9150] = 0x0004b0b9ce97f769UL;
   tf->codes[9151] = 0x0004b0bc52bd36e0UL;
   tf->codes[9152] = 0x0004b0bed6e27657UL;
   tf->codes[9153] = 0x0004b0bf11717c1cUL;
   tf->codes[9154] = 0x0004b0cabbefa25bUL;
   tf->codes[9155] = 0x0004b0d83ae5f6c2UL;
   tf->codes[9156] = 0x0004b0da0f5e24eaUL;
   tf->codes[9157] = 0x0004b0e8edae9befUL;
   tf->codes[9158] = 0x0004b0e9283da1b4UL;
   tf->codes[9159] = 0x0004b0fd83f6a331UL;
   tf->codes[9160] = 0x0004b102c6d027e4UL;
   tf->codes[9161] = 0x0004b10510666196UL;
   tf->codes[9162] = 0x0004b10b02ecf798UL;
   tf->codes[9163] = 0x0004b1121a3eaa73UL;
   tf->codes[9164] = 0x0004b1280fe0d453UL;
   tf->codes[9165] = 0x0004b146b6bdd971UL;
   tf->codes[9166] = 0x0004b1529bcb0575UL;
   tf->codes[9167] = 0x0004b15644bb61c5UL;
   tf->codes[9168] = 0x0004b156f4687314UL;
   tf->codes[9169] = 0x0004b16b8ab07a56UL;
   tf->codes[9170] = 0x0004b171b7c6161dUL;
   tf->codes[9171] = 0x0004b17351af3e80UL;
   tf->codes[9172] = 0x0004b17909a6cebdUL;
   tf->codes[9173] = 0x0004b17c3d791f83UL;
   tf->codes[9174] = 0x0004b19825a1df65UL;
   tf->codes[9175] = 0x0004b199bf8b07c8UL;
   tf->codes[9176] = 0x0004b19cb8ce52c9UL;
   tf->codes[9177] = 0x0004b1af400f261eUL;
   tf->codes[9178] = 0x0004b1cf46464ddaUL;
   tf->codes[9179] = 0x0004b1d39ee3bb79UL;
   tf->codes[9180] = 0x0004b1dc158f90f2UL;
   tf->codes[9181] = 0x0004b1e4171d5ae1UL;
   tf->codes[9182] = 0x0004b1f454c7f484UL;
   tf->codes[9183] = 0x0004b20f52b49d52UL;
   tf->codes[9184] = 0x0004b20fc7d2a8dcUL;
   tf->codes[9185] = 0x0004b210ec9dc5b5UL;
   tf->codes[9186] = 0x0004b228b6b81dbdUL;
   tf->codes[9187] = 0x0004b22cd4c68597UL;
   tf->codes[9188] = 0x0004b240bb617b8aUL;
   tf->codes[9189] = 0x0004b24429c2d215UL;
   tf->codes[9190] = 0x0004b246e8771751UL;
   tf->codes[9191] = 0x0004b25e02e45e0aUL;
   tf->codes[9192] = 0x0004b26ce134d50fUL;
   tf->codes[9193] = 0x0004b29314819892UL;
   tf->codes[9194] = 0x0004b29fe3cadbaaUL;
   tf->codes[9195] = 0x0004b2ad62c13011UL;
   tf->codes[9196] = 0x0004b2aefcaa5874UL;
   tf->codes[9197] = 0x0004b2afac5769c3UL;
   tf->codes[9198] = 0x0004b2b43f83dd27UL;
   tf->codes[9199] = 0x0004b2b9f77b6d64UL;
   tf->codes[9200] = 0x0004b2c05f200ef0UL;
   tf->codes[9201] = 0x0004b2c10ecd203fUL;
   tf->codes[9202] = 0x0004b2c5a1f993a3UL;
   tf->codes[9203] = 0x0004b2c8261ed31aUL;
   tf->codes[9204] = 0x0004b2d111e8b41dUL;
   tf->codes[9205] = 0x0004b2e0da754236UL;
   tf->codes[9206] = 0x0004b2e1c4b1594aUL;
   tf->codes[9207] = 0x0004b2ea75ec3488UL;
   tf->codes[9208] = 0x0004b2f361b6158bUL;
   tf->codes[9209] = 0x0004b2f486813264UL;
   tf->codes[9210] = 0x0004b2fd724b1367UL;
   tf->codes[9211] = 0x0004b2ffbbe14d19UL;
   tf->codes[9212] = 0x0004b307bd6f1708UL;
   tf->codes[9213] = 0x0004b30a4194567fUL;
   tf->codes[9214] = 0x0004b32a47cb7e3bUL;
   tf->codes[9215] = 0x0004b344d09a1b7fUL;
   tf->codes[9216] = 0x0004b3450b292144UL;
   tf->codes[9217] = 0x0004b3471a305531UL;
   tf->codes[9218] = 0x0004b347c9dd6680UL;
   tf->codes[9219] = 0x0004b34a8891abbcUL;
   tf->codes[9220] = 0x0004b35339cc86faUL;
   tf->codes[9221] = 0x0004b35548d3bae7UL;
   tf->codes[9222] = 0x0004b358421705e8UL;
   tf->codes[9223] = 0x0004b35a8bad3f9aUL;
   tf->codes[9224] = 0x0004b378bd6c392eUL;
   tf->codes[9225] = 0x0004b396ef2b32c2UL;
   tf->codes[9226] = 0x0004b39bf775b1b0UL;
   tf->codes[9227] = 0x0004b39c3204b775UL;
   tf->codes[9228] = 0x0004b3ca2c503f22UL;
   tf->codes[9229] = 0x0004b3d43ce53cfeUL;
   tf->codes[9230] = 0x0004b3d6fb99823aUL;
   tf->codes[9231] = 0x0004b3eae234782dUL;
   tf->codes[9232] = 0x0004b3ec06ff9506UL;
   tf->codes[9233] = 0x0004b3f4f2c97609UL;
   tf->codes[9234] = 0x0004b3f89bb9d259UL;
   tf->codes[9235] = 0x0004b403968ae749UL;
   tf->codes[9236] = 0x0004b410daf235ebUL;
   tf->codes[9237] = 0x0004b412af6a6413UL;
   tf->codes[9238] = 0x0004b438e2b72796UL;
   tf->codes[9239] = 0x0004b43c1689785cUL;
   tf->codes[9240] = 0x0004b4403497e036UL;
   tf->codes[9241] = 0x0004b4515c7e90edUL;
   tf->codes[9242] = 0x0004b4520c2ba23cUL;
   tf->codes[9243] = 0x0004b4553ffdf302UL;
   tf->codes[9244] = 0x0004b459d32a6666UL;
   tf->codes[9245] = 0x0004b464936c7591UL;
   tf->codes[9246] = 0x0004b468ec09e330UL;
   tf->codes[9247] = 0x0004b46afb11171dUL;
   tf->codes[9248] = 0x0004b46c5a6b39bbUL;
   tf->codes[9249] = 0x0004b46d0a184b0aUL;
   tf->codes[9250] = 0x0004b47964438298UL;
   tf->codes[9251] = 0x0004b47b38bbb0c0UL;
   tf->codes[9252] = 0x0004b499df98b5deUL;
   tf->codes[9253] = 0x0004b49fd21f4be0UL;
   tf->codes[9254] = 0x0004b4af9aabd9f9UL;
   tf->codes[9255] = 0x0004b4b602507b85UL;
   tf->codes[9256] = 0x0004b4b84be6b537UL;
   tf->codes[9257] = 0x0004b4b970b1d210UL;
   tf->codes[9258] = 0x0004b4beee1a5c88UL;
   tf->codes[9259] = 0x0004b4bf28a9624dUL;
   tf->codes[9260] = 0x0004b4c30c28c462UL;
   tf->codes[9261] = 0x0004b4c9e8eb7178UL;
   tf->codes[9262] = 0x0004b4cb48459416UL;
   tf->codes[9263] = 0x0004b4ceb6a6eaa1UL;
   tf->codes[9264] = 0x0004b4d3f9806f54UL;
   tf->codes[9265] = 0x0004b4dd94f761a6UL;
   tf->codes[9266] = 0x0004b4ebc39ac75cUL;
   tf->codes[9267] = 0x0004b51c7c9a9445UL;
   tf->codes[9268] = 0x0004b51e1683bca8UL;
   tf->codes[9269] = 0x0004b5289c36c60eUL;
   tf->codes[9270] = 0x0004b52e199f5086UL;
   tf->codes[9271] = 0x0004b5418b1c3aefUL;
   tf->codes[9272] = 0x0004b547b831d6b6UL;
   tf->codes[9273] = 0x0004b548dcfcf38fUL;
   tf->codes[9274] = 0x0004b54cc07c55a4UL;
   tf->codes[9275] = 0x0004b54daab86cb8UL;
   tf->codes[9276] = 0x0004b554c20a1f93UL;
   tf->codes[9277] = 0x0004b55571b730e2UL;
   tf->codes[9278] = 0x0004b55de863065bUL;
   tf->codes[9279] = 0x0004b5686e160fc1UL;
   tf->codes[9280] = 0x0004b57f13654af0UL;
   tf->codes[9281] = 0x0004b5895e894e91UL;
   tf->codes[9282] = 0x0004b59961a4e26fUL;
   tf->codes[9283] = 0x0004b5b6e3b6cab4UL;
   tf->codes[9284] = 0x0004b5b71e45d079UL;
   tf->codes[9285] = 0x0004b5d3b61ba1aaUL;
   tf->codes[9286] = 0x0004b5d9a8a237acUL;
   tf->codes[9287] = 0x0004b5db428b600fUL;
   tf->codes[9288] = 0x0004b5deb0ecb69aUL;
   tf->codes[9289] = 0x0004b5deeb7bbc5fUL;
   tf->codes[9290] = 0x0004b5ecdf901c50UL;
   tf->codes[9291] = 0x0004b5f2d216b252UL;
   tf->codes[9292] = 0x0004b5f43170d4f0UL;
   tf->codes[9293] = 0x0004b5f939bb53deUL;
   tf->codes[9294] = 0x0004b5fd57c9bbb8UL;
   tf->codes[9295] = 0x0004b5fe7c94d891UL;
   tf->codes[9296] = 0x0004b607dd7cc51eUL;
   tf->codes[9297] = 0x0004b61b4ef9af87UL;
   tf->codes[9298] = 0x0004b64f765ad2fbUL;
   tf->codes[9299] = 0x0004b64feb78de85UL;
   tf->codes[9300] = 0x0004b66063b27dedUL;
   tf->codes[9301] = 0x0004b662382aac15UL;
   tf->codes[9302] = 0x0004b665a68c02a0UL;
   tf->codes[9303] = 0x0004b66690c819b4UL;
   tf->codes[9304] = 0x0004b66e1d37d819UL;
   tf->codes[9305] = 0x0004b672eaf35142UL;
   tf->codes[9306] = 0x0004b67c866a4394UL;
   tf->codes[9307] = 0x0004b67e20536bf7UL;
   tf->codes[9308] = 0x0004b68746ac52bfUL;
   tf->codes[9309] = 0x0004b68bd9d8c623UL;
   tf->codes[9310] = 0x0004b694c5a2a726UL;
   tf->codes[9311] = 0x0004b69ab8293d28UL;
   tf->codes[9312] = 0x0004b6ac1a9ef3a4UL;
   tf->codes[9313] = 0x0004b6adb4881c07UL;
   tf->codes[9314] = 0x0004b6ae9ec4331bUL;
   tf->codes[9315] = 0x0004b6b2bcd29af5UL;
   tf->codes[9316] = 0x0004b6b78a8e141eUL;
   tf->codes[9317] = 0x0004b6c877e5bf10UL;
   tf->codes[9318] = 0x0004b6d33827ce3bUL;
   tf->codes[9319] = 0x0004b6d5bc4d0db2UL;
   tf->codes[9320] = 0x0004b6dc5e80b503UL;
   tf->codes[9321] = 0x0004b6eb02422643UL;
   tf->codes[9322] = 0x0004b6fc64b7dcbfUL;
   tf->codes[9323] = 0x0004b6ff5dfb27c0UL;
   tf->codes[9324] = 0x0004b701327355e8UL;
   tf->codes[9325] = 0x0004b70ca2627662UL;
   tf->codes[9326] = 0x0004b716b2f7743eUL;
   tf->codes[9327] = 0x0004b718125196dcUL;
   tf->codes[9328] = 0x0004b71f64324f7cUL;
   tf->codes[9329] = 0x0004b732d5af39e5UL;
   tf->codes[9330] = 0x0004b736f3bda1bfUL;
   tf->codes[9331] = 0x0004b73c71262c37UL;
   tf->codes[9332] = 0x0004b75266c85617UL;
   tf->codes[9333] = 0x0004b75684d6bdf1UL;
   tf->codes[9334] = 0x0004b7576f12d505UL;
   tf->codes[9335] = 0x0004b76d2a25f920UL;
   tf->codes[9336] = 0x0004b77f76d7c6b0UL;
   tf->codes[9337] = 0x0004b787b2f49664UL;
   tf->codes[9338] = 0x0004b794823dd97cUL;
   tf->codes[9339] = 0x0004b797066318f3UL;
   tf->codes[9340] = 0x0004b7977b81247dUL;
   tf->codes[9341] = 0x0004b79c83cba36bUL;
   tf->codes[9342] = 0x0004b7a77e9cb85bUL;
   tf->codes[9343] = 0x0004b7aed07d70fbUL;
   tf->codes[9344] = 0x0004b7b18f31b637UL;
   tf->codes[9345] = 0x0004b7c1ccdc4fdaUL;
   tf->codes[9346] = 0x0004b7d628955157UL;
   tf->codes[9347] = 0x0004b7da8132bef6UL;
   tf->codes[9348] = 0x0004b7dccac8f8a8UL;
   tf->codes[9349] = 0x0004b7ded9d02c95UL;
   tf->codes[9350] = 0x0004b7df145f325aUL;
   tf->codes[9351] = 0x0004b7e41ca9b148UL;
   tf->codes[9352] = 0x0004b7e491c7bcd2UL;
   tf->codes[9353] = 0x0004b7f2c06b2288UL;
   tf->codes[9354] = 0x0004b7f83dd3ad00UL;
   tf->codes[9355] = 0x0004b7f9280fc414UL;
   tf->codes[9356] = 0x0004b7fc96711a9fUL;
   tf->codes[9357] = 0x0004b81425fc6ce2UL;
   tf->codes[9358] = 0x0004b81b77dd2582UL;
   tf->codes[9359] = 0x0004b83c2dc15e8dUL;
   tf->codes[9360] = 0x0004b83eb1e69e04UL;
   tf->codes[9361] = 0x0004b840c0edd1f1UL;
   tf->codes[9362] = 0x0004b850fe986b94UL;
   tf->codes[9363] = 0x0004b854a788c7e4UL;
   tf->codes[9364] = 0x0004b85e0870b471UL;
   tf->codes[9365] = 0x0004b870ca408d8bUL;
   tf->codes[9366] = 0x0004b87682381dc8UL;
   tf->codes[9367] = 0x0004b8bae743dadfUL;
   tf->codes[9368] = 0x0004b8c4f7d8d8bbUL;
   tf->codes[9369] = 0x0004b8df4618703aUL;
   tf->codes[9370] = 0x0004b8e65d6a2315UL;
   tf->codes[9371] = 0x0004b8ee5ef7ed04UL;
   tf->codes[9372] = 0x0004b8f78550d3ccUL;
   tf->codes[9373] = 0x0004b8ff4c4f97f6UL;
   tf->codes[9374] = 0x0004b90ba67acf84UL;
   tf->codes[9375] = 0x0004b90f14dc260fUL;
   tf->codes[9376] = 0x0004b90f4f6b2bd4UL;
   tf->codes[9377] = 0x0004b90f89fa3199UL;
   tf->codes[9378] = 0x0004b910aec54e72UL;
   tf->codes[9379] = 0x0004b9136d7993aeUL;
   tf->codes[9380] = 0x0004b92b7222f17bUL;
   tf->codes[9381] = 0x0004b92e6b663c7cUL;
   tf->codes[9382] = 0x0004b93a15e462bbUL;
   tf->codes[9383] = 0x0004b93bea5c90e3UL;
   tf->codes[9384] = 0x0004b93f58bde76eUL;
   tf->codes[9385] = 0x0004b9425201326fUL;
   tf->codes[9386] = 0x0004b94d4cd2475fUL;
   tf->codes[9387] = 0x0004b95513d10b89UL;
   tf->codes[9388] = 0x0004b956e84939b1UL;
   tf->codes[9389] = 0x0004b95847a35c4fUL;
   tf->codes[9390] = 0x0004b96bb92046b8UL;
   tf->codes[9391] = 0x0004b9742fcc1c31UL;
   tf->codes[9392] = 0x0004b977639e6cf7UL;
   tf->codes[9393] = 0x0004b98bbf576e74UL;
   tf->codes[9394] = 0x0004b994709249b2UL;
   tf->codes[9395] = 0x0004b99d96eb307aUL;
   tf->codes[9396] = 0x0004b99f6b635ea2UL;
   tf->codes[9397] = 0x0004b9b351fe5495UL;
   tf->codes[9398] = 0x0004b9bced7546e7UL;
   tf->codes[9399] = 0x0004b9c7adb75612UL;
   tf->codes[9400] = 0x0004b9c7e8465bd7UL;
   tf->codes[9401] = 0x0004b9db94524c05UL;
   tf->codes[9402] = 0x0004b9e2aba3fee0UL;
   tf->codes[9403] = 0x0004b9e5a4e749e1UL;
   tf->codes[9404] = 0x0004b9ed6be60e0bUL;
   tf->codes[9405] = 0x0004ba0d378e3002UL;
   tf->codes[9406] = 0x0004ba18325f44f2UL;
   tf->codes[9407] = 0x0004ba191c9b5c06UL;
   tf->codes[9408] = 0x0004ba1f843ffd92UL;
   tf->codes[9409] = 0x0004ba3d0651e5d7UL;
   tf->codes[9410] = 0x0004ba607aea641eUL;
   tf->codes[9411] = 0x0004ba6c25688a5dUL;
   tf->codes[9412] = 0x0004ba6f1eabd55eUL;
   tf->codes[9413] = 0x0004ba792f40d33aUL;
   tf->codes[9414] = 0x0004ba79deede489UL;
   tf->codes[9415] = 0x0004ba86e8c62d66UL;
   tf->codes[9416] = 0x0004ba8acc458f7bUL;
   tf->codes[9417] = 0x0004ba8cdb4cc368UL;
   tf->codes[9418] = 0x0004ba91e3974256UL;
   tf->codes[9419] = 0x0004ba93b80f707eUL;
   tf->codes[9420] = 0x0004ba993577faf6UL;
   tf->codes[9421] = 0x0004ba9e78517fa9UL;
   tf->codes[9422] = 0x0004baa973229499UL;
   tf->codes[9423] = 0x0004baad9130fc73UL;
   tf->codes[9424] = 0x0004baafdac73625UL;
   tf->codes[9425] = 0x0004bab592bec662UL;
   tf->codes[9426] = 0x0004babef3a6b2efUL;
   tf->codes[9427] = 0x0004babfa353c43eUL;
   tf->codes[9428] = 0x0004bac645876b8fUL;
   tf->codes[9429] = 0x0004bac9043bb0cbUL;
   tf->codes[9430] = 0x0004bae5d6a087c1UL;
   tf->codes[9431] = 0x0004baeb197a0c74UL;
   tf->codes[9432] = 0x0004baecedf23a9cUL;
   tf->codes[9433] = 0x0004baf64eda2729UL;
   tf->codes[9434] = 0x0004bafc4160bd2bUL;
   tf->codes[9435] = 0x0004bb061766b542UL;
   tf->codes[9436] = 0x0004bb0dde65796cUL;
   tf->codes[9437] = 0x0004bb1a731fb6bfUL;
   tf->codes[9438] = 0x0004bb4f84bcf147UL;
   tf->codes[9439] = 0x0004bb532dad4d97UL;
   tf->codes[9440] = 0x0004bb592033e399UL;
   tf->codes[9441] = 0x0004bb5dedef5cc2UL;
   tf->codes[9442] = 0x0004bb615c50b34dUL;
   tf->codes[9443] = 0x0004bb6330c8e175UL;
   tf->codes[9444] = 0x0004bb653fd01562UL;
   tf->codes[9445] = 0x0004bb6e6628fc2aUL;
   tf->codes[9446] = 0x0004bb70afbf35dcUL;
   tf->codes[9447] = 0x0004bb778c81e2f2UL;
   tf->codes[9448] = 0x0004bb83ac1e14bbUL;
   tf->codes[9449] = 0x0004bb9eaa0abd89UL;
   tf->codes[9450] = 0x0004bbaf22445cf1UL;
   tf->codes[9451] = 0x0004bbb589e8fe7dUL;
   tf->codes[9452] = 0x0004bbbeb041e545UL;
   tf->codes[9453] = 0x0004bbc97083f470UL;
   tf->codes[9454] = 0x0004bbcd8e925c4aUL;
   tf->codes[9455] = 0x0004bbce3e3f6d99UL;
   tf->codes[9456] = 0x0004bbd9e8bd93d8UL;
   tf->codes[9457] = 0x0004bbe2d48774dbUL;
   tf->codes[9458] = 0x0004bbf0c89bd4ccUL;
   tf->codes[9459] = 0x0004bbf5d0e653baUL;
   tf->codes[9460] = 0x0004bc017b6479f9UL;
   tf->codes[9461] = 0x0004bc09f2104f72UL;
   tf->codes[9462] = 0x0004bc14b2525e9dUL;
   tf->codes[9463] = 0x0004bc1aa4d8f49fUL;
   tf->codes[9464] = 0x0004bc34b8898659UL;
   tf->codes[9465] = 0x0004bc373caec5d0UL;
   tf->codes[9466] = 0x0004bc3fede9a10eUL;
   tf->codes[9467] = 0x0004bc4989609360UL;
   tf->codes[9468] = 0x0004bc7d3ba3ab4aUL;
   tf->codes[9469] = 0x0004bc8786c7aeebUL;
   tf->codes[9470] = 0x0004bc93a663e0b4UL;
   tf->codes[9471] = 0x0004bca8773aedbbUL;
   tf->codes[9472] = 0x0004bcb5468430d3UL;
   tf->codes[9473] = 0x0004bcc842e30fb2UL;
   tf->codes[9474] = 0x0004bcd33db424a2UL;
   tf->codes[9475] = 0x0004bcdd13ba1cb9UL;
   tf->codes[9476] = 0x0004bce4dab8e0e3UL;
   tf->codes[9477] = 0x0004bce7d3fc2be4UL;
   tf->codes[9478] = 0x0004bcea1d926596UL;
   tf->codes[9479] = 0x0004bcf6029f919aUL;
   tf->codes[9480] = 0x0004bcfca4d338ebUL;
   tf->codes[9481] = 0x0004bd004dc3953bUL;
   tf->codes[9482] = 0x0004bd0605bb2578UL;
   tf->codes[9483] = 0x0004bd06b56836c7UL;
   tf->codes[9484] = 0x0004bd072a864251UL;
   tf->codes[9485] = 0x0004bd125fe65d06UL;
   tf->codes[9486] = 0x0004bd13bf407fa4UL;
   tf->codes[9487] = 0x0004bd1b4bb03e09UL;
   tf->codes[9488] = 0x0004bd229d90f6a9UL;
   tf->codes[9489] = 0x0004bd33c577a760UL;
   tf->codes[9490] = 0x0004bd37e3860f3aUL;
   tf->codes[9491] = 0x0004bd3b17586000UL;
   tf->codes[9492] = 0x0004bd5022be72ccUL;
   tf->codes[9493] = 0x0004bd52a6e3b243UL;
   tf->codes[9494] = 0x0004bd5fb0bbfb20UL;
   tf->codes[9495] = 0x0004bd7c8320d216UL;
   tf->codes[9496] = 0x0004bd89526a152eUL;
   tf->codes[9497] = 0x0004bd902f2cc244UL;
   tf->codes[9498] = 0x0004bd9e5dd027faUL;
   tf->codes[9499] = 0x0004bda9933042afUL;
   tf->codes[9500] = 0x0004bdb06ff2efc5UL;
   tf->codes[9501] = 0x0004bdb7fc62ae2aUL;
   tf->codes[9502] = 0x0004bdc24786b1cbUL;
   tf->codes[9503] = 0x0004bdc5063af707UL;
   tf->codes[9504] = 0x0004bdd7c80ad021UL;
   tf->codes[9505] = 0x0004bddf8f09944bUL;
   tf->codes[9506] = 0x0004bde004279fd5UL;
   tf->codes[9507] = 0x0004bde16381c273UL;
   tf->codes[9508] = 0x0004bde45cc50d74UL;
   tf->codes[9509] = 0x0004bdefccb42deeUL;
   tf->codes[9510] = 0x0004bdf0b6f04502UL;
   tf->codes[9511] = 0x0004be0378c01e1cUL;
   tf->codes[9512] = 0x0004be0ee8af3e96UL;
   tf->codes[9513] = 0x0004be10829866f9UL;
   tf->codes[9514] = 0x0004be1b42da7624UL;
   tf->codes[9515] = 0x0004be1d51e1aa11UL;
   tf->codes[9516] = 0x0004be34e16cfc54UL;
   tf->codes[9517] = 0x0004be41eb454531UL;
   tf->codes[9518] = 0x0004be4643e2b2d0UL;
   tf->codes[9519] = 0x0004be47ddcbdb33UL;
   tf->codes[9520] = 0x0004be490296f80cUL;
   tf->codes[9521] = 0x0004be4bc14b3d48UL;
   tf->codes[9522] = 0x0004be4d20a55fe6UL;
   tf->codes[9523] = 0x0004be4e45707cbfUL;
   tf->codes[9524] = 0x0004be5ada2aba12UL;
   tf->codes[9525] = 0x0004be5bc466d126UL;
   tf->codes[9526] = 0x0004be659a6cc93dUL;
   tf->codes[9527] = 0x0004be7e14343294UL;
   tf->codes[9528] = 0x0004be95de4e8a9cUL;
   tf->codes[9529] = 0x0004beada868e2a4UL;
   tf->codes[9530] = 0x0004beb151593ef4UL;
   tf->codes[9531] = 0x0004beb868aaf1cfUL;
   tf->codes[9532] = 0x0004bec06a38bbbeUL;
   tf->codes[9533] = 0x0004bed8e4002515UL;
   tf->codes[9534] = 0x0004bee7fcdfa1dfUL;
   tf->codes[9535] = 0x0004bf0927e1e674UL;
   tf->codes[9536] = 0x0004bf3a1b70b922UL;
   tf->codes[9537] = 0x0004bf3c2a77ed0fUL;
   tf->codes[9538] = 0x0004bf3f98d9439aUL;
   tf->codes[9539] = 0x0004bf46759bf0b0UL;
   tf->codes[9540] = 0x0004bf479a670d89UL;
   tf->codes[9541] = 0x0004bf4ca2b18c77UL;
   tf->codes[9542] = 0x0004bf558e7b6d7aUL;
   tf->codes[9543] = 0x0004bf655707fb93UL;
   tf->codes[9544] = 0x0004bf6d5895c582UL;
   tf->codes[9545] = 0x0004bf73fac96cd3UL;
   tf->codes[9546] = 0x0004bf95d578c2b7UL;
   tf->codes[9547] = 0x0004bf96bfb4d9cbUL;
   tf->codes[9548] = 0x0004bfae4f402c0eUL;
   tf->codes[9549] = 0x0004bfb89a642fafUL;
   tf->codes[9550] = 0x0004bfcaac86f77aUL;
   tf->codes[9551] = 0x0004bfce1ae84e05UL;
   tf->codes[9552] = 0x0004bfcfb4d17668UL;
   tf->codes[9553] = 0x0004bfd56cc906a5UL;
   tf->codes[9554] = 0x0004bfe65a20b197UL;
   tf->codes[9555] = 0x0004c0053b8cbc7aUL;
   tf->codes[9556] = 0x0004c009ceb92fdeUL;
   tf->codes[9557] = 0x0004c00b2e13527cUL;
   tf->codes[9558] = 0x0004c00ba3315e06UL;
   tf->codes[9559] = 0x0004c014546c3944UL;
   tf->codes[9560] = 0x0004c018727aa11eUL;
   tf->codes[9561] = 0x0004c033aaf64fb1UL;
   tf->codes[9562] = 0x0004c04806af512eUL;
   tf->codes[9563] = 0x0004c04ac563966aUL;
   tf->codes[9564] = 0x0004c05042cc20e2UL;
   tf->codes[9565] = 0x0004c0528c625a94UL;
   tf->codes[9566] = 0x0004c0575a1dd3bdUL;
   tf->codes[9567] = 0x0004c065c3503f38UL;
   tf->codes[9568] = 0x0004c0675d39679bUL;
   tf->codes[9569] = 0x0004c06bb5d6d53aUL;
   tf->codes[9570] = 0x0004c06e748b1a76UL;
   tf->codes[9571] = 0x0004c0842f9e3e91UL;
   tf->codes[9572] = 0x0004c08519da55a5UL;
   tf->codes[9573] = 0x0004c093bd9bc6e5UL;
   tf->codes[9574] = 0x0004c098c5e645d3UL;
   tf->codes[9575] = 0x0004c09a9a5e73fbUL;
   tf->codes[9576] = 0x0004c09f6819ed24UL;
   tf->codes[9577] = 0x0004c0ab12981363UL;
   tf->codes[9578] = 0x0004c0ca2e93240bUL;
   tf->codes[9579] = 0x0004c0cd27d66f0cUL;
   tf->codes[9580] = 0x0004c0eda32ba252UL;
   tf->codes[9581] = 0x0004c0f0d6fdf318UL;
   tf->codes[9582] = 0x0004c10c4a08a770UL;
   tf->codes[9583] = 0x0004c10d6ed3c449UL;
   tf->codes[9584] = 0x0004c12ab656a6c9UL;
   tf->codes[9585] = 0x0004c134c6eba4a5UL;
   tf->codes[9586] = 0x0004c1391f891244UL;
   tf->codes[9587] = 0x0004c14872f794d3UL;
   tf->codes[9588] = 0x0004c14a0ce0bd36UL;
   tf->codes[9589] = 0x0004c14c1be7f123UL;
   tf->codes[9590] = 0x0004c14d7b4213c1UL;
   tf->codes[9591] = 0x0004c15507b1d226UL;
   tf->codes[9592] = 0x0004c155f1ede93aUL;
   tf->codes[9593] = 0x0004c1578bd7119dUL;
   tf->codes[9594] = 0x0004c15df37bb329UL;
   tf->codes[9595] = 0x0004c160b22ff865UL;
   tf->codes[9596] = 0x0004c1624c1920c8UL;
   tf->codes[9597] = 0x0004c165455c6bc9UL;
   tf->codes[9598] = 0x0004c16e6bb55291UL;
   tf->codes[9599] = 0x0004c17966866781UL;
   tf->codes[9600] = 0x0004c17d8494cf5bUL;
   tf->codes[9601] = 0x0004c1833c8c5f98UL;
   tf->codes[9602] = 0x0004c192ca89e7ecUL;
   tf->codes[9603] = 0x0004c1972327558bUL;
   tf->codes[9604] = 0x0004c1b8fdd6ab6fUL;
   tf->codes[9605] = 0x0004c1bfa00a52c0UL;
   tf->codes[9606] = 0x0004c1cb4a8878ffUL;
   tf->codes[9607] = 0x0004c1cce471a162UL;
   tf->codes[9608] = 0x0004c1d67fe893b4UL;
   tf->codes[9609] = 0x0004c1d76a24aac8UL;
   tf->codes[9610] = 0x0004c1ddd1c94c54UL;
   tf->codes[9611] = 0x0004c1efe3ec141fUL;
   tf->codes[9612] = 0x0004c1f09399256eUL;
   tf->codes[9613] = 0x0004c1f7aaead849UL;
   tf->codes[9614] = 0x0004c1f82008e3d3UL;
   tf->codes[9615] = 0x0004c1fb8e6a3a5eUL;
   tf->codes[9616] = 0x0004c1ffe707a7fdUL;
   tf->codes[9617] = 0x0004c208232477b1UL;
   tf->codes[9618] = 0x0004c233994abfe7UL;
   tf->codes[9619] = 0x0004c23448f7d136UL;
   tf->codes[9620] = 0x0004c24ed1c66e7aUL;
   tf->codes[9621] = 0x0004c26a0a421d0dUL;
   tf->codes[9622] = 0x0004c273e0481524UL;
   tf->codes[9623] = 0x0004c27d7bbf0776UL;
   tf->codes[9624] = 0x0004c2841df2aec7UL;
   tf->codes[9625] = 0x0004c286a217ee3eUL;
   tf->codes[9626] = 0x0004c28fc870d506UL;
   tf->codes[9627] = 0x0004c2b5fbbd9889UL;
   tf->codes[9628] = 0x0004c2c7d3515a8fUL;
   tf->codes[9629] = 0x0004c2d8c0a90581UL;
   tf->codes[9630] = 0x0004c2eca743fb74UL;
   tf->codes[9631] = 0x0004c2ee7bbc299cUL;
   tf->codes[9632] = 0x0004c2efa0874675UL;
   tf->codes[9633] = 0x0004c2f642baedc6UL;
   tf->codes[9634] = 0x0004c2fe4448b7b5UL;
   tf->codes[9635] = 0x0004c3138a3dd046UL;
   tf->codes[9636] = 0x0004c32fe7849bb2UL;
   tf->codes[9637] = 0x0004c337ae835fdcUL;
   tf->codes[9638] = 0x0004c33a32a89f53UL;
   tf->codes[9639] = 0x0004c344433d9d2fUL;
   tf->codes[9640] = 0x0004c3468cd3d6e1UL;
   tf->codes[9641] = 0x0004c34cb9e972a8UL;
   tf->codes[9642] = 0x0004c35396ac1fbeUL;
   tf->codes[9643] = 0x0004c35b5daae3e8UL;
   tf->codes[9644] = 0x0004c35d32231210UL;
   tf->codes[9645] = 0x0004c37ed243622fUL;
   tf->codes[9646] = 0x0004c38190f7a76bUL;
   tf->codes[9647] = 0x0004c38240a4b8baUL;
   tf->codes[9648] = 0x0004c39a7fdd1c4cUL;
   tf->codes[9649] = 0x0004c3b0757f462cUL;
   tf->codes[9650] = 0x0004c3b5433abf55UL;
   tf->codes[9651] = 0x0004c3b926ba216aUL;
   tf->codes[9652] = 0x0004c3c12847eb59UL;
   tf->codes[9653] = 0x0004c3c546565333UL;
   tf->codes[9654] = 0x0004c3c8b4b7a9beUL;
   tf->codes[9655] = 0x0004c3cd827322e7UL;
   tf->codes[9656] = 0x0004c3d00698625eUL;
   tf->codes[9657] = 0x0004c3d58400ecd6UL;
   tf->codes[9658] = 0x0004c3d6e35b0f74UL;
   tf->codes[9659] = 0x0004c3d967804eebUL;
   tf->codes[9660] = 0x0004c3deaa59d39eUL;
   tf->codes[9661] = 0x0004c3ea54d7f9ddUL;
   tf->codes[9662] = 0x0004c3edc3395068UL;
   tf->codes[9663] = 0x0004c3f674742ba6UL;
   tf->codes[9664] = 0x0004c3f80e5d5409UL;
   tf->codes[9665] = 0x0004c40b0abc32e8UL;
   tf->codes[9666] = 0x0004c40d8ee1725fUL;
   tf->codes[9667] = 0x0004c40eb3ac8f38UL;
   tf->codes[9668] = 0x0004c40f28ca9ac2UL;
   tf->codes[9669] = 0x0004c4146ba41f75UL;
   tf->codes[9670] = 0x0004c41555e03689UL;
   tf->codes[9671] = 0x0004c437e03c9dbcUL;
   tf->codes[9672] = 0x0004c43bfe4b0596UL;
   tf->codes[9673] = 0x0004c449b7d05fc2UL;
   tf->codes[9674] = 0x0004c44faa56f5c4UL;
   tf->codes[9675] = 0x0004c4501f75014eUL;
   tf->codes[9676] = 0x0004c465da882569UL;
   tf->codes[9677] = 0x0004c4685ead64e0UL;
   tf->codes[9678] = 0x0004c468d3cb706aUL;
   tf->codes[9679] = 0x0004c4709aca3494UL;
   tf->codes[9680] = 0x0004c484bbf4304cUL;
   tf->codes[9681] = 0x0004c486cafb6439UL;
   tf->codes[9682] = 0x0004c48d32a005c5UL;
   tf->codes[9683] = 0x0004c48e1cdc1cd9UL;
   tf->codes[9684] = 0x0004c494bf0fc42aUL;
   tf->codes[9685] = 0x0004c4b91de45985UL;
   tf->codes[9686] = 0x0004c4ba7d3e7c23UL;
   tf->codes[9687] = 0x0004c4df8bc022cdUL;
   tf->codes[9688] = 0x0004c4f21300f622UL;
   tf->codes[9689] = 0x0004c4f99f70b487UL;
   tf->codes[9690] = 0x0004c4fb3959dceaUL;
   tf->codes[9691] = 0x0004c505f99bec15UL;
   tf->codes[9692] = 0x0004c5092d6e3cdbUL;
   tf->codes[9693] = 0x0004c50ac757653eUL;
   tf->codes[9694] = 0x0004c51b3f9104a6UL;
   tf->codes[9695] = 0x0004c51bb4af1030UL;
   tf->codes[9696] = 0x0004c51c29cd1bbaUL;
   tf->codes[9697] = 0x0004c52cdc95c0e7UL;
   tf->codes[9698] = 0x0004c53f63d6943cUL;
   tf->codes[9699] = 0x0004c549aefa97ddUL;
   tf->codes[9700] = 0x0004c550169f3969UL;
   tf->codes[9701] = 0x0004c5526035731bUL;
   tf->codes[9702] = 0x0004c5555978be1cUL;
   tf->codes[9703] = 0x0004c55a9c5242cfUL;
   tf->codes[9704] = 0x0004c563fd3a2f5cUL;
   tf->codes[9705] = 0x0004c56437c93521UL;
   tf->codes[9706] = 0x0004c564e7764670UL;
   tf->codes[9707] = 0x0004c56d98b121aeUL;
   tf->codes[9708] = 0x0004c56ef80b444cUL;
   tf->codes[9709] = 0x0004c57649ebfcecUL;
   tf->codes[9710] = 0x0004c579b84d5377UL;
   tf->codes[9711] = 0x0004c5873743a7deUL;
   tf->codes[9712] = 0x0004c58cb4ac3256UL;
   tf->codes[9713] = 0x0004c5926ca3c293UL;
   tf->codes[9714] = 0x0004c596502324a8UL;
   tf->codes[9715] = 0x0004c5973a5f3bbcUL;
   tf->codes[9716] = 0x0004c5a618afb2c1UL;
   tf->codes[9717] = 0x0004c5ac8054544dUL;
   tf->codes[9718] = 0x0004c5af79979f4eUL;
   tf->codes[9719] = 0x0004c5c9182a257eUL;
   tf->codes[9720] = 0x0004c5c98d483108UL;
   tf->codes[9721] = 0x0004c5cc116d707fUL;
   tf->codes[9722] = 0x0004c5eed658dd77UL;
   tf->codes[9723] = 0x0004c5f27f4939c7UL;
   tf->codes[9724] = 0x0004c5f3dea35c65UL;
   tf->codes[9725] = 0x0004c5f4c8df7379UL;
   tf->codes[9726] = 0x0004c5fe645665cbUL;
   tf->codes[9727] = 0x0004c60a496391cfUL;
   tf->codes[9728] = 0x0004c60a83f29794UL;
   tf->codes[9729] = 0x0004c61459f88fabUL;
   tf->codes[9730] = 0x0004c6162e70bdd3UL;
   tf->codes[9731] = 0x0004c61a4c7f25adUL;
   tf->codes[9732] = 0x0004c62ea838272aUL;
   tf->codes[9733] = 0x0004c639687a3655UL;
   tf->codes[9734] = 0x0004c63c9c4c871bUL;
   tf->codes[9735] = 0x0004c63eab53bb08UL;
   tf->codes[9736] = 0x0004c644d86956cfUL;
   tf->codes[9737] = 0x0004c64dfec23d97UL;
   tf->codes[9738] = 0x0004c652575fab36UL;
   tf->codes[9739] = 0x0004c65bf2d69d88UL;
   tf->codes[9740] = 0x0004c65f26a8ee4eUL;
   tf->codes[9741] = 0x0004c669ac5bf7b4UL;
   tf->codes[9742] = 0x0004c66b0bb61a52UL;
   tf->codes[9743] = 0x0004c66bbb632ba1UL;
   tf->codes[9744] = 0x0004c674e1bc1269UL;
   tf->codes[9745] = 0x0004c67606872f42UL;
   tf->codes[9746] = 0x0004c6788aac6eb9UL;
   tf->codes[9747] = 0x0004c67c339ccb09UL;
   tf->codes[9748] = 0x0004c67d92f6eda7UL;
   tf->codes[9749] = 0x0004c687a38beb83UL;
   tf->codes[9750] = 0x0004c6aa6877587bUL;
   tf->codes[9751] = 0x0004c6c7affa3afbUL;
   tf->codes[9752] = 0x0004c6c825184685UL;
   tf->codes[9753] = 0x0004c6ce522de24cUL;
   tf->codes[9754] = 0x0004c6df3f858d3eUL;
   tf->codes[9755] = 0x0004c6e09edfafdcUL;
   tf->codes[9756] = 0x0004c6eb2492b942UL;
   tf->codes[9757] = 0x0004c6f117194f44UL;
   tf->codes[9758] = 0x0004c6f326208331UL;
   tf->codes[9759] = 0x0004c6f6cf10df81UL;
   tf->codes[9760] = 0x0004c6fb27ae4d20UL;
   tf->codes[9761] = 0x0004c7153b5ededaUL;
   tf->codes[9762] = 0x0004c73abefe910eUL;
   tf->codes[9763] = 0x0004c741d65043e9UL;
   tf->codes[9764] = 0x0004c7483df4e575UL;
   tf->codes[9765] = 0x0004c75f1dd32669UL;
   tf->codes[9766] = 0x0004c76cd7588095UL;
   tf->codes[9767] = 0x0004c7728f5010d2UL;
   tf->codes[9768] = 0x0004c7749e5744bfUL;
   tf->codes[9769] = 0x0004c78b43a67feeUL;
   tf->codes[9770] = 0x0004c79fd9ee8730UL;
   tf->codes[9771] = 0x0004c7bb4cf93b88UL;
   tf->codes[9772] = 0x0004c7e9bc62cebfUL;
   tf->codes[9773] = 0x0004c7e9f6f1d484UL;
   tf->codes[9774] = 0x0004c7ee8a1e47e8UL;
   tf->codes[9775] = 0x0004c7f1836192e9UL;
   tf->codes[9776] = 0x0004c808633fd3ddUL;
   tf->codes[9777] = 0x0004c80b971224a3UL;
   tf->codes[9778] = 0x0004c811feb6c62fUL;
   tf->codes[9779] = 0x0004c814f7fa1130UL;
   tf->codes[9780] = 0x0004c82a036023fcUL;
   tf->codes[9781] = 0x0004c82ed11b9d25UL;
   tf->codes[9782] = 0x0004c82ff5e6b9feUL;
   tf->codes[9783] = 0x0004c8448c2ec140UL;
   tf->codes[9784] = 0x0004c84e6234b957UL;
   tf->codes[9785] = 0x0004c84f86ffd630UL;
   tf->codes[9786] = 0x0004c85be12b0dbeUL;
   tf->codes[9787] = 0x0004c85e65504d35UL;
   tf->codes[9788] = 0x0004c861d3b1a3c0UL;
   tf->codes[9789] = 0x0004c87420637150UL;
   tf->codes[9790] = 0x0004c875f4db9f78UL;
   tf->codes[9791] = 0x0004c88ac5b2ac7fUL;
   tf->codes[9792] = 0x0004c8912d574e0bUL;
   tf->codes[9793] = 0x0004c8be77f5c469UL;
   tf->codes[9794] = 0x0004c8c380404357UL;
   tf->codes[9795] = 0x0004c8e2d6ca59c4UL;
   tf->codes[9796] = 0x0004c8fd5f98f708UL;
   tf->codes[9797] = 0x0004c8fd9a27fccdUL;
   tf->codes[9798] = 0x0004c92e1898c3f1UL;
   tf->codes[9799] = 0x0004c93f407f74a8UL;
   tf->codes[9800] = 0x0004c945e2b31bf9UL;
   tf->codes[9801] = 0x0004c94a75df8f5dUL;
   tf->codes[9802] = 0x0004c956957bc126UL;
   tf->codes[9803] = 0x0004c958a482f513UL;
   tf->codes[9804] = 0x0004c95fbbd4a7eeUL;
   tf->codes[9805] = 0x0004c961904cd616UL;
   tf->codes[9806] = 0x0004c968e22d8eb6UL;
   tf->codes[9807] = 0x0004c9836afc2bfaUL;
   tf->codes[9808] = 0x0004c986643f76fbUL;
   tf->codes[9809] = 0x0004c988add5b0adUL;
   tf->codes[9810] = 0x0004c98922f3bc37UL;
   tf->codes[9811] = 0x0004c991d42e9775UL;
   tf->codes[9812] = 0x0004c999260f5015UL;
   tf->codes[9813] = 0x0004c99afa877e3dUL;
   tf->codes[9814] = 0x0004c9a9d8d7f542UL;
   tf->codes[9815] = 0x0004c9afcb5e8b44UL;
   tf->codes[9816] = 0x0004c9b7ccec5533UL;
   tf->codes[9817] = 0x0004c9d4d9e031eeUL;
   tf->codes[9818] = 0x0004c9d723766ba0UL;
   tf->codes[9819] = 0x0004c9e2cdf491dfUL;
   tf->codes[9820] = 0x0004c9e3b830a8f3UL;
   tf->codes[9821] = 0x0004c9edc8c5a6cfUL;
   tf->codes[9822] = 0x0004c9f13726fd5aUL;
   tf->codes[9823] = 0x0004c9f6b48f87d2UL;
   tf->codes[9824] = 0x0004ca0ad5b9838aUL;
   tf->codes[9825] = 0x0004ca134c655903UL;
   tf->codes[9826] = 0x0004ca1dd2186269UL;
   tf->codes[9827] = 0x0004ca26bde2436cUL;
   tf->codes[9828] = 0x0004ca2e84e10796UL;
   tf->codes[9829] = 0x0004ca3c03d75bfdUL;
   tf->codes[9830] = 0x0004ca3cb3846d4cUL;
   tf->codes[9831] = 0x0004ca447a833176UL;
   tf->codes[9832] = 0x0004ca4823738dc6UL;
   tf->codes[9833] = 0x0004ca4ddb6b1e03UL;
   tf->codes[9834] = 0x0004ca547d9ec554UL;
   tf->codes[9835] = 0x0004ca70a0568afbUL;
   tf->codes[9836] = 0x0004ca723a3fb35eUL;
   tf->codes[9837] = 0x0004ca72af5dbee8UL;
   tf->codes[9838] = 0x0004ca74be64f2d5UL;
   tf->codes[9839] = 0x0004ca78dc735aafUL;
   tf->codes[9840] = 0x0004ca7de4bdd99dUL;
   tf->codes[9841] = 0x0004ca7fb93607c5UL;
   tf->codes[9842] = 0x0004ca8362266415UL;
   tf->codes[9843] = 0x0004ca87f552d779UL;
   tf->codes[9844] = 0x0004ca8c4df04518UL;
   tf->codes[9845] = 0x0004ca8f47339019UL;
   tf->codes[9846] = 0x0004ca9deaf50159UL;
   tf->codes[9847] = 0x0004caaf87f9bd9aUL;
   tf->codes[9848] = 0x0004cac5b82aed3fUL;
   tf->codes[9849] = 0x0004cac78ca31b67UL;
   tf->codes[9850] = 0x0004cac8b16e3840UL;
   tf->codes[9851] = 0x0004cad3e6ce52f5UL;
   tf->codes[9852] = 0x0004cad7ca4db50aUL;
   tf->codes[9853] = 0x0004cad83f6bc094UL;
   tf->codes[9854] = 0x0004cae165c4a75cUL;
   tf->codes[9855] = 0x0004cae5f8f11ac0UL;
   tf->codes[9856] = 0x0004caf49cb28c00UL;
   tf->codes[9857] = 0x0004cafe72b88417UL;
   tf->codes[9858] = 0x0004cb0c2c3dde43UL;
   tf->codes[9859] = 0x0004cb10bf6a51a7UL;
   tf->codes[9860] = 0x0004cb18c0f81b96UL;
   tf->codes[9861] = 0x0004cb1e78efabd3UL;
   tf->codes[9862] = 0x0004cb2e7c0b3fb1UL;
   tf->codes[9863] = 0x0004cb2eb69a4576UL;
   tf->codes[9864] = 0x0004cb36087afe16UL;
   tf->codes[9865] = 0x0004cb36f2b7152aUL;
   tf->codes[9866] = 0x0004cb37dcf32c3eUL;
   tf->codes[9867] = 0x0004cb388ca03d8dUL;
   tf->codes[9868] = 0x0004cb413ddb18cbUL;
   tf->codes[9869] = 0x0004cb4904d9dcf5UL;
   tf->codes[9870] = 0x0004cb49ef15f409UL;
   tf->codes[9871] = 0x0004cb4dd295561eUL;
   tf->codes[9872] = 0x0004cb510667a6e4UL;
   tf->codes[9873] = 0x0004cb58cd666b0eUL;
   tf->codes[9874] = 0x0004cb5adc6d9efbUL;
   tf->codes[9875] = 0x0004cb5f6f9a125fUL;
   tf->codes[9876] = 0x0004cb68d081feecUL;
   tf->codes[9877] = 0x0004cb7405e219a1UL;
   tf->codes[9878] = 0x0004cb7823f0817bUL;
   tf->codes[9879] = 0x0004cb7f00b32e91UL;
   tf->codes[9880] = 0x0004cb85a2e6d5e2UL;
   tf->codes[9881] = 0x0004cb8b5ade661fUL;
   tf->codes[9882] = 0x0004cb9b9888ffc2UL;
   tf->codes[9883] = 0x0004cbba3f6604e0UL;
   tf->codes[9884] = 0x0004cbc91db67be5UL;
   tf->codes[9885] = 0x0004cbd786e8e760UL;
   tf->codes[9886] = 0x0004cbdf1358a5c5UL;
   tf->codes[9887] = 0x0004cc0fcc5872aeUL;
   tf->codes[9888] = 0x0004cc145f84e612UL;
   tf->codes[9889] = 0x0004cc1758c83113UL;
   tf->codes[9890] = 0x0004cc1a177c764fUL;
   tf->codes[9891] = 0x0004cc1bebf4a477UL;
   tf->codes[9892] = 0x0004cc37d41d6459UL;
   tf->codes[9893] = 0x0004cc3c6749d7bdUL;
   tf->codes[9894] = 0x0004cc3f608d22beUL;
   tf->codes[9895] = 0x0004cc576536808bUL;
   tf->codes[9896] = 0x0004cc693cca4291UL;
   tf->codes[9897] = 0x0004cc6e7fa3c744UL;
   tf->codes[9898] = 0x0004cc70198cefa7UL;
   tf->codes[9899] = 0x0004cc74acb9630bUL;
   tf->codes[9900] = 0x0004cc822bafb772UL;
   tf->codes[9901] = 0x0004cc8a67cc8726UL;
   tf->codes[9902] = 0x0004cc8dd62dddb1UL;
   tf->codes[9903] = 0x0004cc922ecb4b50UL;
   tf->codes[9904] = 0x0004cc92695a5115UL;
   tf->codes[9905] = 0x0004cc92a3e956daUL;
   tf->codes[9906] = 0x0004cc990b8df866UL;
   tf->codes[9907] = 0x0004cc9d9eba6bcaUL;
   tf->codes[9908] = 0x0004cc9f38a3942dUL;
   tf->codes[9909] = 0x0004ccafb0dd3395UL;
   tf->codes[9910] = 0x0004ccb3945c95aaUL;
   tf->codes[9911] = 0x0004ccb89ca71498UL;
   tf->codes[9912] = 0x0004ccb9c1723171UL;
   tf->codes[9913] = 0x0004ccc2381e06eaUL;
   tf->codes[9914] = 0x0004ccc5e10e633aUL;
   tf->codes[9915] = 0x0004ccc9c48dc54fUL;
   tf->codes[9916] = 0x0004ccd39a93bd66UL;
   tf->codes[9917] = 0x0004ccd5347ce5c9UL;
   tf->codes[9918] = 0x0004cce278e4346bUL;
   tf->codes[9919] = 0x0004cce621d490bbUL;
   tf->codes[9920] = 0x0004cd015a503f4eUL;
   tf->codes[9921] = 0x0004cd078765db15UL;
   tf->codes[9922] = 0x0004cd0c8fb05a03UL;
   tf->codes[9923] = 0x0004cd195ef99d1bUL;
   tf->codes[9924] = 0x0004cd68bed66f22UL;
   tf->codes[9925] = 0x0004cd6d5202e286UL;
   tf->codes[9926] = 0x0004cd73b9a78412UL;
   tf->codes[9927] = 0x0004cd755390ac75UL;
   tf->codes[9928] = 0x0004cd7b0b883cb2UL;
   tf->codes[9929] = 0x0004cd846c70293fUL;
   tf->codes[9930] = 0x0004cd89af49adf2UL;
   tf->codes[9931] = 0x0004cd8ce31bfeb8UL;
   tf->codes[9932] = 0x0004cd9559c7d431UL;
   tf->codes[9933] = 0x0004cd9977d63c0bUL;
   tf->codes[9934] = 0x0004cd9b86dd6ff8UL;
   tf->codes[9935] = 0x0004cdb266bbb0ecUL;
   tf->codes[9936] = 0x0004cdb7e4243b64UL;
   tf->codes[9937] = 0x0004cdc77221c3b8UL;
   tf->codes[9938] = 0x0004cdc896ece091UL;
   tf->codes[9939] = 0x0004cdc94699f1e0UL;
   tf->codes[9940] = 0x0004cdeb9667534eUL;
   tf->codes[9941] = 0x0004ce03d59fb6e0UL;
   tf->codes[9942] = 0x0004ce0744010d6bUL;
   tf->codes[9943] = 0x0004ce4506d92331UL;
   tf->codes[9944] = 0x0004ce5509f4b70fUL;
   tf->codes[9945] = 0x0004ce583dc707d5UL;
   tf->codes[9946] = 0x0004ce5a4cce3bc2UL;
   tf->codes[9947] = 0x0004ce5f1a89b4ebUL;
   tf->codes[9948] = 0x0004ce645d63399eUL;
   tf->codes[9949] = 0x0004ce6ee3164304UL;
   tf->codes[9950] = 0x0004ce7f20c0dca7UL;
   tf->codes[9951] = 0x0004ce89a673e60dUL;
   tf->codes[9952] = 0x0004cea58e9ca5efUL;
   tf->codes[9953] = 0x0004cec8538812e7UL;
   tf->codes[9954] = 0x0004cec8c8a61e71UL;
   tf->codes[9955] = 0x0004ced13f51f3eaUL;
   tf->codes[9956] = 0x0004ced5d27e674eUL;
   tf->codes[9957] = 0x0004ced6f7498427UL;
   tf->codes[9958] = 0x0004cee40121cd04UL;
   tf->codes[9959] = 0x0004cee734f41dcaUL;
   tf->codes[9960] = 0x0004cef4043d60e2UL;
   tf->codes[9961] = 0x0004cef4ee7977f6UL;
   tf->codes[9962] = 0x0004cef7380fb1a8UL;
   tf->codes[9963] = 0x0004cefa6be2026eUL;
   tf->codes[9964] = 0x0004cf068b7e3437UL;
   tf->codes[9965] = 0x0004cf10d6a237d8UL;
   tf->codes[9966] = 0x0004cf11c0de4eecUL;
   tf->codes[9967] = 0x0004cf16540ac250UL;
   tf->codes[9968] = 0x0004cf173e46d964UL;
   tf->codes[9969] = 0x0004cf1912bf078cUL;
   tf->codes[9970] = 0x0004cf2ecdd22ba7UL;
   tf->codes[9971] = 0x0004cf3201a47c6dUL;
   tf->codes[9972] = 0x0004cf361fb2e447UL;
   tf->codes[9973] = 0x0004cf41ca310a86UL;
   tf->codes[9974] = 0x0004cf42eefc275fUL;
   tf->codes[9975] = 0x0004cf4b65a7fcd8UL;
   tf->codes[9976] = 0x0004cf4c4fe413ecUL;
   tf->codes[9977] = 0x0004cf4cff91253bUL;
   tf->codes[9978] = 0x0004cf51582e92daUL;
   tf->codes[9979] = 0x0004cf57fa623a2bUL;
   tf->codes[9980] = 0x0004cf5f86d1f890UL;
   tf->codes[9981] = 0x0004cf6af6c1190aUL;
   tf->codes[9982] = 0x0004cf7123d6b4d1UL;
   tf->codes[9983] = 0x0004cf720e12cbe5UL;
   tf->codes[9984] = 0x0004cf7457a90597UL;
   tf->codes[9985] = 0x0004cf762c2133bfUL;
   tf->codes[9986] = 0x0004cf76dbce450eUL;
   tf->codes[9987] = 0x0004cf892880129eUL;
   tf->codes[9988] = 0x0004cfb304bd3271UL;
   tf->codes[9989] = 0x0004cfbb064afc60UL;
   tf->codes[9990] = 0x0004cfbd4fe13612UL;
   tf->codes[9991] = 0x0004cfc083b386d8UL;
   tf->codes[9992] = 0x0004cfc2cd49c08aUL;
   tf->codes[9993] = 0x0004cfc63bab1715UL;
   tf->codes[9994] = 0x0004cfd0fbed2640UL;
   tf->codes[9995] = 0x0004cfd1e6293d54UL;
   tf->codes[9996] = 0x0004cfd30af45a2dUL;
   tf->codes[9997] = 0x0004cfdfda3d9d45UL;
   tf->codes[9998] = 0x0004cfe9b043955cUL;
   tf->codes[9999] = 0x0004cfef2dac1fd4UL;
   tf->codes[10000] = 0x0004cffad82a4613UL;
   tf->codes[10001] = 0x0004d007e2028ef0UL;
   tf->codes[10002] = 0x0004d00b8af2eb40UL;
   tf->codes[10003] = 0x0004d014ebdad7cdUL;
   tf->codes[10004] = 0x0004d037b0c644c5UL;
   tf->codes[10005] = 0x0004d03e186ae651UL;
   tf->codes[10006] = 0x0004d04027721a3eUL;
   tf->codes[10007] = 0x0004d0470434c754UL;
   tf->codes[10008] = 0x0004d048d8acf57cUL;
   tf->codes[10009] = 0x0004d04c819d51ccUL;
   tf->codes[10010] = 0x0004d058a1398395UL;
   tf->codes[10011] = 0x0004d05f7dfc30abUL;
   tf->codes[10012] = 0x0004d0648646af99UL;
   tf->codes[10013] = 0x0004d06cc2637f4dUL;
   tf->codes[10014] = 0x0004d07ed4864718UL;
   tf->codes[10015] = 0x0004d08f874eec45UL;
   tf->codes[10016] = 0x0004d09fff888badUL;
   tf->codes[10017] = 0x0004d0a9d58e83c4UL;
   tf->codes[10018] = 0x0004d0b7c9a2e3b5UL;
   tf->codes[10019] = 0x0004d0cbeaccdf6dUL;
   tf->codes[10020] = 0x0004d0ce6ef21ee4UL;
   tf->codes[10021] = 0x0004d0d008db4747UL;
   tf->codes[10022] = 0x0004d0d07df952d1UL;
   tf->codes[10023] = 0x0004d0d4d696c070UL;
   tf->codes[10024] = 0x0004d0db03ac5c37UL;
   tf->codes[10025] = 0x0004d0e130c1f7feUL;
   tf->codes[10026] = 0x0004d0f58c7af97bUL;
   tf->codes[10027] = 0x0004d0f7266421deUL;
   tf->codes[10028] = 0x0004d0f9aa896155UL;
   tf->codes[10029] = 0x0004d0fa1fa76cdfUL;
   tf->codes[10030] = 0x0004d118c68471fdUL;
   tf->codes[10031] = 0x0004d11a606d9a60UL;
   tf->codes[10032] = 0x0004d12b13363f8dUL;
   tf->codes[10033] = 0x0004d13c008dea7fUL;
   tf->codes[10034] = 0x0004d13ebf422fbbUL;
   tf->codes[10035] = 0x0004d144ec57cb82UL;
   tf->codes[10036] = 0x0004d1526b4e1fe9UL;
   tf->codes[10037] = 0x0004d1589863bbb0UL;
   tf->codes[10038] = 0x0004d15c06c5123bUL;
   tf->codes[10039] = 0x0004d16442e1e1efUL;
   tf->codes[10040] = 0x0004d1673c252cf0UL;
   tf->codes[10041] = 0x0004d16b94c29a8fUL;
   tf->codes[10042] = 0x0004d175dfe69e30UL;
   tf->codes[10043] = 0x0004d17aada21759UL;
   tf->codes[10044] = 0x0004d189c6819423UL;
   tf->codes[10045] = 0x0004d18b25dbb6c1UL;
   tf->codes[10046] = 0x0004d19118624cc3UL;
   tf->codes[10047] = 0x0004d1944c349d89UL;
   tf->codes[10048] = 0x0004d1adb0381df4UL;
   tf->codes[10049] = 0x0004d1b3682fae31UL;
   tf->codes[10050] = 0x0004d1d03a948527UL;
   tf->codes[10051] = 0x0004d1d0afb290b1UL;
   tf->codes[10052] = 0x0004d1d124d09c3bUL;
   tf->codes[10053] = 0x0004d1d542df0415UL;
   tf->codes[10054] = 0x0004d1d78c753dc7UL;
   tf->codes[10055] = 0x0004d1db35659a17UL;
   tf->codes[10056] = 0x0004d1dd446cce04UL;
   tf->codes[10057] = 0x0004d1e99e980592UL;
   tf->codes[10058] = 0x0004d1ea88d41ca6UL;
   tf->codes[10059] = 0x0004d1ef568f95cfUL;
   tf->codes[10060] = 0x0004d1f16596c9bcUL;
   tf->codes[10061] = 0x0004d1f5be34375bUL;
   tf->codes[10062] = 0x0004d1f87ce87c97UL;
   tf->codes[10063] = 0x0004d1f9672493abUL;
   tf->codes[10064] = 0x0004d20bee656700UL;
   tf->codes[10065] = 0x0004d210f6afe5eeUL;
   tf->codes[10066] = 0x0004d21accb5de05UL;
   tf->codes[10067] = 0x0004d21eeac445dfUL;
   tf->codes[10068] = 0x0004d21f5fe25169UL;
   tf->codes[10069] = 0x0004d228fb5943bbUL;
   tf->codes[10070] = 0x0004d2346b486435UL;
   tf->codes[10071] = 0x0004d2410002a188UL;
   tf->codes[10072] = 0x0004d24d1f9ed351UL;
   tf->codes[10073] = 0x0004d251783c40f0UL;
   tf->codes[10074] = 0x0004d25c730d55e0UL;
   tf->codes[10075] = 0x0004d2655ed736e3UL;
   tf->codes[10076] = 0x0004d274ecd4bf37UL;
   tf->codes[10077] = 0x0004d28ddbba3418UL;
   tf->codes[10078] = 0x0004d29e8e82d945UL;
   tf->codes[10079] = 0x0004d2c5717cae17UL;
   tf->codes[10080] = 0x0004d2c5e69ab9a1UL;
   tf->codes[10081] = 0x0004d2c7bb12e7c9UL;
   tf->codes[10082] = 0x0004d2ccc35d66b7UL;
   tf->codes[10083] = 0x0004d2ce97d594dfUL;
   tf->codes[10084] = 0x0004d2e1943473beUL;
   tf->codes[10085] = 0x0004d2e53d24d00eUL;
   tf->codes[10086] = 0x0004d2ed3eb299fdUL;
   tf->codes[10087] = 0x0004d2f5b55e6f76UL;
   tf->codes[10088] = 0x0004d305b87a0354UL;
   tf->codes[10089] = 0x0004d30dba07cd43UL;
   tf->codes[10090] = 0x0004d31287c3466cUL;
   tf->codes[10091] = 0x0004d31e6cd07270UL;
   tf->codes[10092] = 0x0004d32a8c6ca439UL;
   tf->codes[10093] = 0x0004d32e6fec064eUL;
   tf->codes[10094] = 0x0004d335c1ccbeeeUL;
   tf->codes[10095] = 0x0004d33bb45354f0UL;
   tf->codes[10096] = 0x0004d340bc9dd3deUL;
   tf->codes[10097] = 0x0004d3425686fc41UL;
   tf->codes[10098] = 0x0004d344a01d35f3UL;
   tf->codes[10099] = 0x0004d353f38bb882UL;
   tf->codes[10100] = 0x0004d35a95bf5fd3UL;
   tf->codes[10101] = 0x0004d35eb3cdc7adUL;
   tf->codes[10102] = 0x0004d37bc0c1a468UL;
   tf->codes[10103] = 0x0004d3922b81d9d2UL;
   tf->codes[10104] = 0x0004d395d4723622UL;
   tf->codes[10105] = 0x0004d3a90b601ac6UL;
   tf->codes[10106] = 0x0004d3ac04a365c7UL;
   tf->codes[10107] = 0x0004d3be51553357UL;
   tf->codes[10108] = 0x0004d3caab806ae5UL;
   tf->codes[10109] = 0x0004d3e56ede0deeUL;
   tf->codes[10110] = 0x0004d3ecc0bec68eUL;
   tf->codes[10111] = 0x0004d3f696c4bea5UL;
   tf->codes[10112] = 0x0004d415b2bfcf4dUL;
   tf->codes[10113] = 0x0004d415ed4ed512UL;
   tf->codes[10114] = 0x0004d41e296ba4c6UL;
   tf->codes[10115] = 0x0004d41f88c5c764UL;
   tf->codes[10116] = 0x0004d42be2f0fef2UL;
   tf->codes[10117] = 0x0004d43c5b2a9e5aUL;
   tf->codes[10118] = 0x0004d43f19dee396UL;
   tf->codes[10119] = 0x0004d44213222e97UL;
   tf->codes[10120] = 0x0004d456e3f93b9eUL;
   tf->codes[10121] = 0x0004d45ac7789db3UL;
   tf->codes[10122] = 0x0004d46462ef9005UL;
   tf->codes[10123] = 0x0004d46ee8a2996bUL;
   tf->codes[10124] = 0x0004d47047fcbc09UL;
   tf->codes[10125] = 0x0004d476afa15d95UL;
   tf->codes[10126] = 0x0004d47c6798edd2UL;
   tf->codes[10127] = 0x0004d4ad2098babbUL;
   tf->codes[10128] = 0x0004d4add045cc0aUL;
   tf->codes[10129] = 0x0004d4af2f9feea8UL;
   tf->codes[10130] = 0x0004d4b5222684aaUL;
   tf->codes[10131] = 0x0004d4b9b552f80eUL;
   tf->codes[10132] = 0x0004d4c40076fbafUL;
   tf->codes[10133] = 0x0004d4c4eab312c3UL;
   tf->codes[10134] = 0x0004d4c60f7e2f9cUL;
   tf->codes[10135] = 0x0004d4db90024df2UL;
   tf->codes[10136] = 0x0004d4dc3faf5f41UL;
   tf->codes[10137] = 0x0004d4e35701121cUL;
   tf->codes[10138] = 0x0004d4e7ea2d8580UL;
   tf->codes[10139] = 0x0004d4ecf278046eUL;
   tf->codes[10140] = 0x0004d4eddcb41b82UL;
   tf->codes[10141] = 0x0004d4f2e4fe9a70UL;
   tf->codes[10142] = 0x0004d4f6535ff0fbUL;
   tf->codes[10143] = 0x0004d4f9c1c14786UL;
   tf->codes[10144] = 0x0004d4fe1a5eb525UL;
   tf->codes[10145] = 0x0004d50ff1f2772bUL;
   tf->codes[10146] = 0x0004d512b0a6bc67UL;
   tf->codes[10147] = 0x0004d51e5b24e2a6UL;
   tf->codes[10148] = 0x0004d54af61647b5UL;
   tf->codes[10149] = 0x0004d54d3fac8167UL;
   tf->codes[10150] = 0x0004d5519849ef06UL;
   tf->codes[10151] = 0x0004d55a0ef5c47fUL;
   tf->codes[10152] = 0x0004d55ccdaa09bbUL;
   tf->codes[10153] = 0x0004d5636fddb10cUL;
   tf->codes[10154] = 0x0004d563e4fbbc96UL;
   tf->codes[10155] = 0x0004d59637e4b1e2UL;
   tf->codes[10156] = 0x0004d5a75fcb6299UL;
   tf->codes[10157] = 0x0004d5c4a74e4519UL;
   tf->codes[10158] = 0x0004d5c9ea27c9ccUL;
   tf->codes[10159] = 0x0004d5d4aa69d8f7UL;
   tf->codes[10160] = 0x0004d5d5cf34f5d0UL;
   tf->codes[10161] = 0x0004d5d67ee2071fUL;
   tf->codes[10162] = 0x0004d5d6b9710ce4UL;
   tf->codes[10163] = 0x0004d5dbc1bb8bd2UL;
   tf->codes[10164] = 0x0004d5fdd6f9e77bUL;
   tf->codes[10165] = 0x0004d6090c5a0230UL;
   tf->codes[10166] = 0x0004d611f823e333UL;
   tf->codes[10167] = 0x0004d61c4347e6d4UL;
   tf->codes[10168] = 0x0004d637f0e1a0f1UL;
   tf->codes[10169] = 0x0004d6382b70a6b6UL;
   tf->codes[10170] = 0x0004d63cbe9d1a1aUL;
   tf->codes[10171] = 0x0004d6439b5fc730UL;
   tf->codes[10172] = 0x0004d646cf3217f6UL;
   tf->codes[10173] = 0x0004d64f806cf334UL;
   tf->codes[10174] = 0x0004d65488b77222UL;
   tf->codes[10175] = 0x0004d65b2aeb1973UL;
   tf->codes[10176] = 0x0004d65d39f24d60UL;
   tf->codes[10177] = 0x0004d6670ff84577UL;
   tf->codes[10178] = 0x0004d668a9e16ddaUL;
   tf->codes[10179] = 0x0004d66cc7efd5b4UL;
   tf->codes[10180] = 0x0004d67195ab4eddUL;
   tf->codes[10181] = 0x0004d6727fe765f1UL;
   tf->codes[10182] = 0x0004d6732f947740UL;
   tf->codes[10183] = 0x0004d675ee48bc7cUL;
   tf->codes[10184] = 0x0004d6774da2df1aUL;
   tf->codes[10185] = 0x0004d67defd6866bUL;
   tf->codes[10186] = 0x0004d68875898fd1UL;
   tf->codes[10187] = 0x0004d695f47fe438UL;
   tf->codes[10188] = 0x0004d69ac23b5d61UL;
   tf->codes[10189] = 0x0004d6a338e732daUL;
   tf->codes[10190] = 0x0004d6a6322a7ddbUL;
   tf->codes[10191] = 0x0004d6ad497c30b6UL;
   tf->codes[10192] = 0x0004d6c588b49448UL;
   tf->codes[10193] = 0x0004d6cc2ae83b99UL;
   tf->codes[10194] = 0x0004d6d048f6a373UL;
   tf->codes[10195] = 0x0004d6d37cc8f439UL;
   tf->codes[10196] = 0x0004d6da941aa714UL;
   tf->codes[10197] = 0x0004d700c7676a97UL;
   tf->codes[10198] = 0x0004d713fe554f3bUL;
   tf->codes[10199] = 0x0004d72f36d0fdceUL;
   tf->codes[10200] = 0x0004d73cb5c75235UL;
   tf->codes[10201] = 0x0004d74d2e00f19dUL;
   tf->codes[10202] = 0x0004d7786998340eUL;
   tf->codes[10203] = 0x0004d78538e17726UL;
   tf->codes[10204] = 0x0004d7878277b0d8UL;
   tf->codes[10205] = 0x0004d78a7bbafbd9UL;
   tf->codes[10206] = 0x0004d78f0ee76f3dUL;
   tf->codes[10207] = 0x0004d7adb5c4745bUL;
   tf->codes[10208] = 0x0004d7b800e877fcUL;
   tf->codes[10209] = 0x0004d7c9635e2e78UL;
   tf->codes[10210] = 0x0004d7d5486b5a7cUL;
   tf->codes[10211] = 0x0004d7d96679c256UL;
   tf->codes[10212] = 0x0004d7dbb00ffc08UL;
   tf->codes[10213] = 0x0004d7e301f0b4a8UL;
   tf->codes[10214] = 0x0004d7f16b232023UL;
   tf->codes[10215] = 0x0004d7f1e0412badUL;
   tf->codes[10216] = 0x0004d7f3ef485f9aUL;
   tf->codes[10217] = 0x0004d7f514137c73UL;
   tf->codes[10218] = 0x0004d7fc2b652f4eUL;
   tf->codes[10219] = 0x0004d80d8ddae5caUL;
   tf->codes[10220] = 0x0004d818138def30UL;
   tf->codes[10221] = 0x0004d81d90f679a8UL;
   tf->codes[10222] = 0x0004d81e06148532UL;
   tf->codes[10223] = 0x0004d81e7b3290bcUL;
   tf->codes[10224] = 0x0004d827a18b7784UL;
   tf->codes[10225] = 0x0004d8338698a388UL;
   tf->codes[10226] = 0x0004d8388ee32276UL;
   tf->codes[10227] = 0x0004d83dd1bca729UL;
   tf->codes[10228] = 0x0004d84264e91a8dUL;
   tf->codes[10229] = 0x0004d84648687ca2UL;
   tf->codes[10230] = 0x0004d8497c3acd68UL;
   tf->codes[10231] = 0x0004d84e0f6740ccUL;
   tf->codes[10232] = 0x0004d8768c4a3e01UL;
   tf->codes[10233] = 0x0004d87c4441ce3eUL;
   tf->codes[10234] = 0x0004d884baeda3b7UL;
   tf->codes[10235] = 0x0004d89448eb2c0bUL;
   tf->codes[10236] = 0x0004d89c0fe9f035UL;
   tf->codes[10237] = 0x0004d8cc53cbb194UL;
   tf->codes[10238] = 0x0004d8dd7bb2624bUL;
   tf->codes[10239] = 0x0004d8dedb0c84e9UL;
   tf->codes[10240] = 0x0004d8df502a9073UL;
   tf->codes[10241] = 0x0004d8e6a20b4913UL;
   tf->codes[10242] = 0x0004d8ea4afba563UL;
   tf->codes[10243] = 0x0004d9045eac371dUL;
   tf->codes[10244] = 0x0004d908079c936dUL;
   tf->codes[10245] = 0x0004d90b00dfde6eUL;
   tf->codes[10246] = 0x0004d9112df57a35UL;
   tf->codes[10247] = 0x0004d92882f1c6b3UL;
   tf->codes[10248] = 0x0004d9334333d5deUL;
   tf->codes[10249] = 0x0004d9379bd1437dUL;
   tf->codes[10250] = 0x0004d940c22a2a45UL;
   tf->codes[10251] = 0x0004d94a9830225cUL;
   tf->codes[10252] = 0x0004d94d1c5561d3UL;
   tf->codes[10253] = 0x0004d94e069178e7UL;
   tf->codes[10254] = 0x0004d95851b57c88UL;
   tf->codes[10255] = 0x0004d96ad8f64fddUL;
   tf->codes[10256] = 0x0004d96e4757a668UL;
   tf->codes[10257] = 0x0004d971409af169UL;
   tf->codes[10258] = 0x0004d9729ff51407UL;
   tf->codes[10259] = 0x0004d98bc9698eadUL;
   tf->codes[10260] = 0x0004d99da0fd50b3UL;
   tf->codes[10261] = 0x0004d9b8645af3bcUL;
   tf->codes[10262] = 0x0004d9bd6ca572aaUL;
   tf->codes[10263] = 0x0004d9cf09aa2eebUL;
   tf->codes[10264] = 0x0004d9d44c83b39eUL;
   tf->codes[10265] = 0x0004d9d4fc30c4edUL;
   tf->codes[10266] = 0x0004d9e5746a6455UL;
   tf->codes[10267] = 0x0004d9e65ea67b69UL;
   tf->codes[10268] = 0x0004d9eb2c61f492UL;
   tf->codes[10269] = 0x0004d9ecc64b1cf5UL;
   tf->codes[10270] = 0x0004d9f7116f2096UL;
   tf->codes[10271] = 0x0004da0998aff3ebUL;
   tf->codes[10272] = 0x0004da119a3dbddaUL;
   tf->codes[10273] = 0x0004da1db9d9efa3UL;
   tf->codes[10274] = 0x0004da2e32138f0bUL;
   tf->codes[10275] = 0x0004da312b56da0cUL;
   tf->codes[10276] = 0x0004da45870fdb89UL;
   tf->codes[10277] = 0x0004da4796170f76UL;
   tf->codes[10278] = 0x0004da6084fc8457UL;
   tf->codes[10279] = 0x0004da60bf8b8a1cUL;
   tf->codes[10280] = 0x0004da6b0aaf8dbdUL;
   tf->codes[10281] = 0x0004da760580a2adUL;
   tf->codes[10282] = 0x0004da7ef14a83b0UL;
   tf->codes[10283] = 0x0004da7fdb869ac4UL;
   tf->codes[10284] = 0x0004da801615a089UL;
   tf->codes[10285] = 0x0004da82d4c9e5c5UL;
   tf->codes[10286] = 0x0004da8caacfdddcUL;
   tf->codes[10287] = 0x0004da8ce55ee3a1UL;
   tf->codes[10288] = 0x0004da9dd2b68e93UL;
   tf->codes[10289] = 0x0004daab171ddd35UL;
   tf->codes[10290] = 0x0004dab17ec27ec1UL;
   tf->codes[10291] = 0x0004dac31bc73b02UL;
   tf->codes[10292] = 0x0004dad4f35afd08UL;
   tf->codes[10293] = 0x0004dafaec18bac6UL;
   tf->codes[10294] = 0x0004dafdaacd0002UL;
   tf->codes[10295] = 0x0004db039d539604UL;
   tf->codes[10296] = 0x0004db11cbf6fbbaUL;
   tf->codes[10297] = 0x0004db2711ec144bUL;
   tf->codes[10298] = 0x0004db2f1379de3aUL;
   tf->codes[10299] = 0x0004db2f4e08e3ffUL;
   tf->codes[10300] = 0x0004db3281db34c5UL;
   tf->codes[10301] = 0x0004db387461cac7UL;
   tf->codes[10302] = 0x0004db3c57e12cdcUL;
   tf->codes[10303] = 0x0004db420fd8bd19UL;
   tf->codes[10304] = 0x0004db4a11668708UL;
   tf->codes[10305] = 0x0004db4b3631a3e1UL;
   tf->codes[10306] = 0x0004db58057ae6f9UL;
   tf->codes[10307] = 0x0004db5afebe31faUL;
   tf->codes[10308] = 0x0004db5fcc79ab23UL;
   tf->codes[10309] = 0x0004db6793786f4dUL;
   tf->codes[10310] = 0x0004db67ce077512UL;
   tf->codes[10311] = 0x0004db6d10e0f9c5UL;
   tf->codes[10312] = 0x0004db6dfb1d10d9UL;
   tf->codes[10313] = 0x0004db6eaaca2228UL;
   tf->codes[10314] = 0x0004db7b04f559b6UL;
   tf->codes[10315] = 0x0004db8c676b1032UL;
   tf->codes[10316] = 0x0004db8cdc891bbcUL;
   tf->codes[10317] = 0x0004db8dc6c532d0UL;
   tf->codes[10318] = 0x0004dba88a22d5d9UL;
   tf->codes[10319] = 0x0004dbc1ee265644UL;
   tf->codes[10320] = 0x0004dbc8cae9035aUL;
   tf->codes[10321] = 0x0004dbcc73d95faaUL;
   tf->codes[10322] = 0x0004dbd94322a2c2UL;
   tf->codes[10323] = 0x0004dbe22eec83c5UL;
   tf->codes[10324] = 0x0004dbe9463e36a0UL;
   tf->codes[10325] = 0x0004dbf2320817a3UL;
   tf->codes[10326] = 0x0004dbff3be06080UL;
   tf->codes[10327] = 0x0004dc11c32133d5UL;
   tf->codes[10328] = 0x0004dc174089be4dUL;
   tf->codes[10329] = 0x0004dc2b2724b440UL;
   tf->codes[10330] = 0x0004dc550361d413UL;
   tf->codes[10331] = 0x0004dc59968e4777UL;
   tf->codes[10332] = 0x0004dc5af5e86a15UL;
   tf->codes[10333] = 0x0004dc62bce72e3fUL;
   tf->codes[10334] = 0x0004dc72c002c21dUL;
   tf->codes[10335] = 0x0004dc82137144acUL;
   tf->codes[10336] = 0x0004dc987e317a16UL;
   tf->codes[10337] = 0x0004dcb6aff073aaUL;
   tf->codes[10338] = 0x0004dccb80c780b1UL;
   tf->codes[10339] = 0x0004dcd1734e16b3UL;
   tf->codes[10340] = 0x0004dcd1e86c223dUL;
   tf->codes[10341] = 0x0004dcd93a4cdaddUL;
   tf->codes[10342] = 0x0004dcdb49540ecaUL;
   tf->codes[10343] = 0x0004dcdeb7b56555UL;
   tf->codes[10344] = 0x0004dce1014b9f07UL;
   tf->codes[10345] = 0x0004dcf60cb1b1d3UL;
   tf->codes[10346] = 0x0004dcfe835d874cUL;
   tf->codes[10347] = 0x0004dd0560203462UL;
   tf->codes[10348] = 0x0004dd1478ffb12cUL;
   tf->codes[10349] = 0x0004dd2cf2c71a83UL;
   tf->codes[10350] = 0x0004dd3e8fcbd6c4UL;
   tf->codes[10351] = 0x0004dd47b624bd8cUL;
   tf->codes[10352] = 0x0004dd4ae9f70e52UL;
   tf->codes[10353] = 0x0004dd4c83e036b5UL;
   tf->codes[10354] = 0x0004dd6ff878b4fcUL;
   tf->codes[10355] = 0x0004dd80ab415a29UL;
   tf->codes[10356] = 0x0004dd9a8462e61eUL;
   tf->codes[10357] = 0x0004dd9f178f5982UL;
   tf->codes[10358] = 0x0004ddac2167a25fUL;
   tf->codes[10359] = 0x0004ddb07a050ffeUL;
   tf->codes[10360] = 0x0004ddcbb280be91UL;
   tf->codes[10361] = 0x0004ddcf5b711ae1UL;
   tf->codes[10362] = 0x0004ddd0f55a4344UL;
   tf->codes[10363] = 0x0004ddd21a25601dUL;
   tf->codes[10364] = 0x0004dddeaedf9d70UL;
   tf->codes[10365] = 0x0004dddf5e8caebfUL;
   tf->codes[10366] = 0x0004dde8bf749b4cUL;
   tf->codes[10367] = 0x0004ddf58ebdde64UL;
   tf->codes[10368] = 0x0004ddf84d7223a0UL;
   tf->codes[10369] = 0x0004ddfa21ea51c8UL;
   tf->codes[10370] = 0x0004ddfbf6627ff0UL;
   tf->codes[10371] = 0x0004ddfdcadaae18UL;
   tf->codes[10372] = 0x0004de07a0e0a62fUL;
   tf->codes[10373] = 0x0004de0ce3ba2ae2UL;
   tf->codes[10374] = 0x0004de1ad7ce8ad3UL;
   tf->codes[10375] = 0x0004de438f408dcdUL;
   tf->codes[10376] = 0x0004de5860179ad4UL;
   tf->codes[10377] = 0x0004de64ba42d262UL;
   tf->codes[10378] = 0x0004de69c28d5150UL;
   tf->codes[10379] = 0x0004de7c0f3f1ee0UL;
   tf->codes[10380] = 0x0004de8fbb4b0f0eUL;
   tf->codes[10381] = 0x0004de8ff5da14d3UL;
   tf->codes[10382] = 0x0004de9538b39986UL;
   tf->codes[10383] = 0x0004de95add1a510UL;
   tf->codes[10384] = 0x0004deaf86f33105UL;
   tf->codes[10385] = 0x0004deb9d21734a6UL;
   tf->codes[10386] = 0x0004debaf6e2517fUL;
   tf->codes[10387] = 0x0004dec507774f5bUL;
   tf->codes[10388] = 0x0004dec666d171f9UL;
   tf->codes[10389] = 0x0004dec7c62b9497UL;
   tf->codes[10390] = 0x0004decf529b52fcUL;
   tf->codes[10391] = 0x0004ded3e5c7c660UL;
   tf->codes[10392] = 0x0004deda12dd6227UL;
   tf->codes[10393] = 0x0004dedc21e49614UL;
   tf->codes[10394] = 0x0004dedee098db50UL;
   tf->codes[10395] = 0x0004defa53a38fa8UL;
   tf->codes[10396] = 0x0004defcd7c8cf1fUL;
   tf->codes[10397] = 0x0004df16eb7960d9UL;
   tf->codes[10398] = 0x0004df2fda5ed5baUL;
   tf->codes[10399] = 0x0004df3c348a0d48UL;
   tf->codes[10400] = 0x0004df41776391fbUL;
   tf->codes[10401] = 0x0004df49b38061afUL;
   tf->codes[10402] = 0x0004df5473c270daUL;
   tf->codes[10403] = 0x0004df738fbd8182UL;
   tf->codes[10404] = 0x0004df7cf0a56e0fUL;
   tf->codes[10405] = 0x0004df7ddae18523UL;
   tf->codes[10406] = 0x0004df7e4fff90adUL;
   tf->codes[10407] = 0x0004df8567514388UL;
   tf->codes[10408] = 0x0004df8860948e89UL;
   tf->codes[10409] = 0x0004df909cb15e3dUL;
   tf->codes[10410] = 0x0004df90d7406402UL;
   tf->codes[10411] = 0x0004df93d083af03UL;
   tf->codes[10412] = 0x0004df95a4fbdd2bUL;
   tf->codes[10413] = 0x0004dfacbf6923e4UL;
   tf->codes[10414] = 0x0004dfb919945b72UL;
   tf->codes[10415] = 0x0004dfd69ba643b7UL;
   tf->codes[10416] = 0x0004dfe8e8581147UL;
   tf->codes[10417] = 0x0004dff0e9e5db36UL;
   tf->codes[10418] = 0x0004dff19992ec85UL;
   tf->codes[10419] = 0x0004dff4584731c1UL;
   tf->codes[10420] = 0x0004dff7c6a8884cUL;
   tf->codes[10421] = 0x0004e00963ad448dUL;
   tf->codes[10422] = 0x0004e00fcb51e619UL;
   tf->codes[10423] = 0x0004e0128a062b55UL;
   tf->codes[10424] = 0x0004e02eacbdf0fcUL;
   tf->codes[10425] = 0x0004e04bf440d37cUL;
   tf->codes[10426] = 0x0004e07f3165dfdcUL;
   tf->codes[10427] = 0x0004e082da563c2cUL;
   tf->codes[10428] = 0x0004e083c4925340UL;
   tf->codes[10429] = 0x0004e0afea65acc5UL;
   tf->codes[10430] = 0x0004e0b6c72859dbUL;
   tf->codes[10431] = 0x0004e0b910be938dUL;
   tf->codes[10432] = 0x0004e0bc4490e453UL;
   tf->codes[10433] = 0x0004e0c5305ac556UL;
   tf->codes[10434] = 0x0004e0ccbcca83bbUL;
   tf->codes[10435] = 0x0004e0cd6c77950aUL;
   tf->codes[10436] = 0x0004e0e70b0a1b3aUL;
   tf->codes[10437] = 0x0004e0f2406a35efUL;
   tf->codes[10438] = 0x0004e0f7f861c62cUL;
   tf->codes[10439] = 0x0004e0fd00ac451aUL;
   tf->codes[10440] = 0x0004e100e42ba72fUL;
   tf->codes[10441] = 0x0004e10417fdf7f5UL;
   tf->codes[10442] = 0x0004e108709b6594UL;
   tf->codes[10443] = 0x0004e10d78e5e482UL;
   tf->codes[10444] = 0x0004e11330dd74bfUL;
   tf->codes[10445] = 0x0004e115ef91b9fbUL;
   tf->codes[10446] = 0x0004e127c7257c01UL;
   tf->codes[10447] = 0x0004e12d448e0679UL;
   tf->codes[10448] = 0x0004e1521880a75eUL;
   tf->codes[10449] = 0x0004e15a8f2c7cd7UL;
   tf->codes[10450] = 0x0004e175c7a82b6aUL;
   tf->codes[10451] = 0x0004e17bf4bdc731UL;
   tf->codes[10452] = 0x0004e18973b41b98UL;
   tf->codes[10453] = 0x0004e18b0d9d43fbUL;
   tf->codes[10454] = 0x0004e191ea5ff111UL;
   tf->codes[10455] = 0x0004e1925f7dfc9bUL;
   tf->codes[10456] = 0x0004e1b1f09718cdUL;
   tf->codes[10457] = 0x0004e1b94277d16dUL;
   tf->codes[10458] = 0x0004e1c64c501a4aUL;
   tf->codes[10459] = 0x0004e1d405d57476UL;
   tf->codes[10460] = 0x0004e1da32eb103dUL;
   tf->codes[10461] = 0x0004e1e1f9e9d467UL;
   tf->codes[10462] = 0x0004e1ea7095a9e0UL;
   tf->codes[10463] = 0x0004e1ec0a7ed243UL;
   tf->codes[10464] = 0x0004e1ef3e512309UL;
   tf->codes[10465] = 0x0004e1f7054fe733UL;
   tf->codes[10466] = 0x0004e1f914571b20UL;
   tf->codes[10467] = 0x0004e1fa73b13dbeUL;
   tf->codes[10468] = 0x0004e2106953679eUL;
   tf->codes[10469] = 0x0004e2148761cf78UL;
   tf->codes[10470] = 0x0004e2165bd9fda0UL;
   tf->codes[10471] = 0x0004e21780a51a79UL;
   tf->codes[10472] = 0x0004e234c827fcf9UL;
   tf->codes[10473] = 0x0004e23786dc4235UL;
   tf->codes[10474] = 0x0004e23b2fcc9e85UL;
   tf->codes[10475] = 0x0004e23d3ed3d272UL;
   tf->codes[10476] = 0x0004e23fc2f911e9UL;
   tf->codes[10477] = 0x0004e24122533487UL;
   tf->codes[10478] = 0x0004e248aec2f2ecUL;
   tf->codes[10479] = 0x0004e25284c8eb03UL;
   tf->codes[10480] = 0x0004e25c5acee31aUL;
   tf->codes[10481] = 0x0004e26c235b7133UL;
   tf->codes[10482] = 0x0004e2771e2c8623UL;
   tf->codes[10483] = 0x0004e27e357e38feUL;
   tf->codes[10484] = 0x0004e29256a834b6UL;
   tf->codes[10485] = 0x0004e295ff989106UL;
   tf->codes[10486] = 0x0004e2a9368675aaUL;
   tf->codes[10487] = 0x0004e2b25cdf5c72UL;
   tf->codes[10488] = 0x0004e2bb48a93d75UL;
   tf->codes[10489] = 0x0004e2bc6d745a4eUL;
   tf->codes[10490] = 0x0004e2cbc0e2dcddUL;
   tf->codes[10491] = 0x0004e2cd955b0b05UL;
   tf->codes[10492] = 0x0004e2d1b36972dfUL;
   tf->codes[10493] = 0x0004e2dfe20cd895UL;
   tf->codes[10494] = 0x0004e2e76e7c96faUL;
   tf->codes[10495] = 0x0004e2fd641ec0daUL;
   tf->codes[10496] = 0x0004e2ff3896ef02UL;
   tf->codes[10497] = 0x0004e3005d620bdbUL;
   tf->codes[10498] = 0x0004e30983baf2a3UL;
   tf->codes[10499] = 0x0004e30ae3151541UL;
   tf->codes[10500] = 0x0004e30b1da41b06UL;
   tf->codes[10501] = 0x0004e31702b1470aUL;
   tf->codes[10502] = 0x0004e343d831b1deUL;
   tf->codes[10503] = 0x0004e34ab4f45ef4UL;
   tf->codes[10504] = 0x0004e353662f3a32UL;
   tf->codes[10505] = 0x0004e35f4b3c6636UL;
   tf->codes[10506] = 0x0004e362447fb137UL;
   tf->codes[10507] = 0x0004e3648e15eae9UL;
   tf->codes[10508] = 0x0004e374cbc0848cUL;
   tf->codes[10509] = 0x0004e381d598cd69UL;
   tf->codes[10510] = 0x0004e38c95dadc94UL;
   tf->codes[10511] = 0x0004e3966be0d4abUL;
   tf->codes[10512] = 0x0004e3971b8de5faUL;
   tf->codes[10513] = 0x0004e3c21c9622a6UL;
   tf->codes[10514] = 0x0004e3c37bf04544UL;
   tf->codes[10515] = 0x0004e3c724e0a194UL;
   tf->codes[10516] = 0x0004e3c9e394e6d0UL;
   tf->codes[10517] = 0x0004e3cacdd0fde4UL;
   tf->codes[10518] = 0x0004e3cb7d7e0f33UL;
   tf->codes[10519] = 0x0004e3d010aa8297UL;
   tf->codes[10520] = 0x0004e3da965d8bfdUL;
   tf->codes[10521] = 0x0004e3db0b7b9787UL;
   tf->codes[10522] = 0x0004e3df9ea80aebUL;
   tf->codes[10523] = 0x0004e3e8ff8ff778UL;
   tf->codes[10524] = 0x0004e3f72e335d2eUL;
   tf->codes[10525] = 0x0004e3ffa4df32a7UL;
   tf->codes[10526] = 0x0004e40b89ec5eabUL;
   tf->codes[10527] = 0x0004e40ef84db536UL;
   tf->codes[10528] = 0x0004e410ccc5e35eUL;
   tf->codes[10529] = 0x0004e438d48ad509UL;
   tf->codes[10530] = 0x0004e43a6e73fd6cUL;
   tf->codes[10531] = 0x0004e4447f08fb48UL;
   tf->codes[10532] = 0x0004e451fdff4fafUL;
   tf->codes[10533] = 0x0004e4570649ce9dUL;
   tf->codes[10534] = 0x0004e458dac1fcc5UL;
   tf->codes[10535] = 0x0004e45c0e944d8bUL;
   tf->codes[10536] = 0x0004e47ed37fba83UL;
   tf->codes[10537] = 0x0004e487f9d8a14bUL;
   tf->codes[10538] = 0x0004e488e414b85fUL;
   tf->codes[10539] = 0x0004e48a08dfd538UL;
   tf->codes[10540] = 0x0004e4932f38bc00UL;
   tf->codes[10541] = 0x0004e49e2a09d0f0UL;
   tf->codes[10542] = 0x0004e4a78af1bd7dUL;
   tf->codes[10543] = 0x0004e4b12668afcfUL;
   tf->codes[10544] = 0x0004e4bafc6ea7e6UL;
   tf->codes[10545] = 0x0004e4bd0b75dbd3UL;
   tf->codes[10546] = 0x0004e4c7cbb7eafeUL;
   tf->codes[10547] = 0x0004e4d9dddab2c9UL;
   tf->codes[10548] = 0x0004e4da52f8be53UL;
   tf->codes[10549] = 0x0004e4ebeffd7a94UL;
   tf->codes[10550] = 0x0004e4f3f18b4483UL;
   tf->codes[10551] = 0x0004e4f5c60372abUL;
   tf->codes[10552] = 0x0004e4f884b7b7e7UL;
   tf->codes[10553] = 0x0004e50887d34bc5UL;
   tf->codes[10554] = 0x0004e51bbec13069UL;
   tf->codes[10555] = 0x0004e51d1e1b5307UL;
   tf->codes[10556] = 0x0004e54476333363UL;
   tf->codes[10557] = 0x0004e54b8d84e63eUL;
   tf->codes[10558] = 0x0004e5526a479354UL;
   tf->codes[10559] = 0x0004e55aa6646308UL;
   tf->codes[10560] = 0x0004e56ae40efcabUL;
   tf->codes[10561] = 0x0004e57912b26261UL;
   tf->codes[10562] = 0x0004e5886620e4f0UL;
   tf->codes[10563] = 0x0004e58bd4823b7bUL;
   tf->codes[10564] = 0x0004e5944b2e10f4UL;
   tf->codes[10565] = 0x0004e59ab2d2b280UL;
   tf->codes[10566] = 0x0004e5cccb2ca207UL;
   tf->codes[10567] = 0x0004e5d0aeac041cUL;
   tf->codes[10568] = 0x0004e5d666a39459UL;
   tf->codes[10569] = 0x0004e5d8008cbcbcUL;
   tf->codes[10570] = 0x0004e5df17de6f97UL;
   tf->codes[10571] = 0x0004e5dfc78b80e6UL;
   tf->codes[10572] = 0x0004e5e2c0cecbe7UL;
   tf->codes[10573] = 0x0004e5e8b35561e9UL;
   tf->codes[10574] = 0x0004e5ec96d4c3feUL;
   tf->codes[10575] = 0x0004e5f12a013762UL;
   tf->codes[10576] = 0x0004e60376b304f2UL;
   tf->codes[10577] = 0x0004e60d874802ceUL;
   tf->codes[10578] = 0x0004e61eaf2eb385UL;
   tf->codes[10579] = 0x0004e61f5edbc4d4UL;
   tf->codes[10580] = 0x0004e62e77bb419eUL;
   tf->codes[10581] = 0x0004e642d374431bUL;
   tf->codes[10582] = 0x0004e644e27b7708UL;
   tf->codes[10583] = 0x0004e64a9a730745UL;
   tf->codes[10584] = 0x0004e65226e2c5aaUL;
   tf->codes[10585] = 0x0004e654ab080521UL;
   tf->codes[10586] = 0x0004e65f6b4a144cUL;
   tf->codes[10587] = 0x0004e65fe0681fd6UL;
   tf->codes[10588] = 0x0004e66e499a8b51UL;
   tf->codes[10589] = 0x0004e6805bbd531cUL;
   tf->codes[10590] = 0x0004e68822bc1746UL;
   tf->codes[10591] = 0x0004e68e4fd1b30dUL;
   tf->codes[10592] = 0x0004e68f749ccfe6UL;
   tf->codes[10593] = 0x0004e69bcec80774UL;
   tf->codes[10594] = 0x0004e6b70743b607UL;
   tf->codes[10595] = 0x0004e6c15267b9a8UL;
   tf->codes[10596] = 0x0004e6c20214caf7UL;
   tf->codes[10597] = 0x0004e6cf467c1999UL;
   tf->codes[10598] = 0x0004e6d8e1f30bebUL;
   tf->codes[10599] = 0x0004e6d9cc2f22ffUL;
   tf->codes[10600] = 0x0004e6dbdb3656ecUL;
   tf->codes[10601] = 0x0004e6dc15c55cb1UL;
   tf->codes[10602] = 0x0004e6dcc5726e00UL;
   tf->codes[10603] = 0x0004e6eb2ea4d97bUL;
   tf->codes[10604] = 0x0004e6fa47845645UL;
   tf->codes[10605] = 0x0004e70925d4cd4aUL;
   tf->codes[10606] = 0x0004e70d43e33524UL;
   tf->codes[10607] = 0x0004e7150ae1f94eUL;
   tf->codes[10608] = 0x0004e730b87bb36bUL;
   tf->codes[10609] = 0x0004e7333ca0f2e2UL;
   tf->codes[10610] = 0x0004e77dcec24bc0UL;
   tf->codes[10611] = 0x0004e77f68ab7423UL;
   tf->codes[10612] = 0x0004e78e0c6ce563UL;
   tf->codes[10613] = 0x0004e7929f9958c7UL;
   tf->codes[10614] = 0x0004e7a9f495a545UL;
   tf->codes[10615] = 0x0004e7afac8d3582UL;
   tf->codes[10616] = 0x0004e7b31aee8c0dUL;
   tf->codes[10617] = 0x0004e7bc06b86d10UL;
   tf->codes[10618] = 0x0004e7c701898200UL;
   tf->codes[10619] = 0x0004e7c9c03dc73cUL;
   tf->codes[10620] = 0x0004e7d68f870a54UL;
   tf->codes[10621] = 0x0004e7d7eee12cf2UL;
   tf->codes[10622] = 0x0004e7e274943658UL;
   tf->codes[10623] = 0x0004e7ede48356d2UL;
   tf->codes[10624] = 0x0004e7ef43dd7970UL;
   tf->codes[10625] = 0x0004e7f2b23ecffbUL;
   tf->codes[10626] = 0x0004e8153c9b372eUL;
   tf->codes[10627] = 0x0004e81835de822fUL;
   tf->codes[10628] = 0x0004e82b323d610eUL;
   tf->codes[10629] = 0x0004e84fcba0fc2eUL;
   tf->codes[10630] = 0x0004e861ddc3c3f9UL;
   tf->codes[10631] = 0x0004e87255fd6361UL;
   tf->codes[10632] = 0x0004e88726d47068UL;
   tf->codes[10633] = 0x0004e89d1c769a48UL;
   tf->codes[10634] = 0x0004e89e06b2b15cUL;
   tf->codes[10635] = 0x0004e8bdd25ad353UL;
   tf->codes[10636] = 0x0004e8c6f8b3ba1bUL;
   tf->codes[10637] = 0x0004e8c7e2efd12fUL;
   tf->codes[10638] = 0x0004e8cebfb27e45UL;
   tf->codes[10639] = 0x0004e8d477aa0e82UL;
   tf->codes[10640] = 0x0004e8e3cb189111UL;
   tf->codes[10641] = 0x0004e8e6c45bdc12UL;
   tf->codes[10642] = 0x0004e8e90df215c4UL;
   tf->codes[10643] = 0x0004e8fd2f1c117cUL;
   tf->codes[10644] = 0x0004e901fcd78aa5UL;
   tf->codes[10645] = 0x0004e91449895835UL;
   tf->codes[10646] = 0x0004e937f8b0dc41UL;
   tf->codes[10647] = 0x0004e93c514e49e0UL;
   tf->codes[10648] = 0x0004e9406f5cb1baUL;
   tf->codes[10649] = 0x0004e943a32f0280UL;
   tf->codes[10650] = 0x0004e94b2f9ec0e5UL;
   tf->codes[10651] = 0x0004e952bc0e7f4aUL;
   tf->codes[10652] = 0x0004e95f1639b6d8UL;
   tf->codes[10653] = 0x0004e975bb88f207UL;
   tf->codes[10654] = 0x0004e97e3234c780UL;
   tf->codes[10655] = 0x0004e983ea2c57bdUL;
   tf->codes[10656] = 0x0004e9b602864744UL;
   tf->codes[10657] = 0x0004e9bca4b9ee95UL;
   tf->codes[10658] = 0x0004e9c0c2c8566fUL;
   tf->codes[10659] = 0x0004e9c67abfe6acUL;
   tf->codes[10660] = 0x0004e9cc6d467caeUL;
   tf->codes[10661] = 0x0004e9ce41beaad6UL;
   tf->codes[10662] = 0x0004e9d608bd6f00UL;
   tf->codes[10663] = 0x0004e9e93fab53a4UL;
   tf->codes[10664] = 0x0004e9f8cda8dbf8UL;
   tf->codes[10665] = 0x0004ea01b972bcfbUL;
   tf->codes[10666] = 0x0004ea164fbac43dUL;
   tf->codes[10667] = 0x0004ea60e1dc1d1bUL;
   tf->codes[10668] = 0x0004ea727ee0d95cUL;
   tf->codes[10669] = 0x0004ea72f3fee4e6UL;
   tf->codes[10670] = 0x0004ea7996328c37UL;
   tf->codes[10671] = 0x0004ea9b3652dc56UL;
   tf->codes[10672] = 0x0004eaa8efd83682UL;
   tf->codes[10673] = 0x0004eac796b53ba0UL;
   tf->codes[10674] = 0x0004eac80bd3472aUL;
   tf->codes[10675] = 0x0004eade0175710aUL;
   tf->codes[10676] = 0x0004eaf4a6c4ac39UL;
   tf->codes[10677] = 0x0004eafca8527628UL;
   tf->codes[10678] = 0x0004eb1a64f36432UL;
   tf->codes[10679] = 0x0004eb3f38e60517UL;
   tf->codes[10680] = 0x0004eb431c65672cUL;
   tf->codes[10681] = 0x0004eb49be990e7dUL;
   tf->codes[10682] = 0x0004eb4aa8d52591UL;
   tf->codes[10683] = 0x0004eb5060ccb5ceUL;
   tf->codes[10684] = 0x0004eb5d3015f8e6UL;
   tf->codes[10685] = 0x0004eb677b39fc87UL;
   tf->codes[10686] = 0x0004eb70a192e34fUL;
   tf->codes[10687] = 0x0004eb7bd6f2fe04UL;
   tf->codes[10688] = 0x0004eb8955e9526bUL;
   tf->codes[10689] = 0x0004eb9ba29b1ffbUL;
   tf->codes[10690] = 0x0004ebad7a2ee201UL;
   tf->codes[10691] = 0x0004ebb6db16ce8eUL;
   tf->codes[10692] = 0x0004ebcd0b47fe33UL;
   tf->codes[10693] = 0x0004ebe54a8061c5UL;
   tf->codes[10694] = 0x0004ebe5bf9e6d4fUL;
   tf->codes[10695] = 0x0004ebfc9f7cae43UL;
   tf->codes[10696] = 0x0004ebfdfed6d0e1UL;
   tf->codes[10697] = 0x0004ec06eaa0b1e4UL;
   tf->codes[10698] = 0x0004ec0dc7635efaUL;
   tf->codes[10699] = 0x0004ec1d1ad1e189UL;
   tf->codes[10700] = 0x0004ec29ea1b24a1UL;
   tf->codes[10701] = 0x0004ec38c86b9ba6UL;
   tf->codes[10702] = 0x0004ec4ce995975eUL;
   tf->codes[10703] = 0x0004ec522c6f1c11UL;
   tf->codes[10704] = 0x0004ec58cea2c362UL;
   tf->codes[10705] = 0x0004ec5a688bebc5UL;
   tf->codes[10706] = 0x0004ec5d9c5e3c8bUL;
   tf->codes[10707] = 0x0004ec5efbb85f29UL;
   tf->codes[10708] = 0x0004ec5fe5f4763dUL;
   tf->codes[10709] = 0x0004ec6737d52eddUL;
   tf->codes[10710] = 0x0004ec6ec444ed42UL;
   tf->codes[10711] = 0x0004ec6fae810456UL;
   tf->codes[10712] = 0x0004ec7098bd1b6aUL;
   tf->codes[10713] = 0x0004ec7cb8594d33UL;
   tf->codes[10714] = 0x0004ec93d2c693ecUL;
   tf->codes[10715] = 0x0004ec9a74fa3b3dUL;
   tf->codes[10716] = 0x0004ec9de35b91c8UL;
   tf->codes[10717] = 0x0004ecacfc3b0e92UL;
   tf->codes[10718] = 0x0004ecaf80604e09UL;
   tf->codes[10719] = 0x0004eccc52c524ffUL;
   tf->codes[10720] = 0x0004ecd036448714UL;
   tf->codes[10721] = 0x0004ecd8e77f6252UL;
   tf->codes[10722] = 0x0004ecdd7aabd5b6UL;
   tf->codes[10723] = 0x0004ecee2d747ae3UL;
   tf->codes[10724] = 0x0004ecf41ffb10e5UL;
   tf->codes[10725] = 0x0004ecfe30900ec1UL;
   tf->codes[10726] = 0x0004ed0affd951d9UL;
   tf->codes[10727] = 0x0004ed1a5347d468UL;
   tf->codes[10728] = 0x0004ed2e39e2ca5bUL;
   tf->codes[10729] = 0x0004ed2fd3cbf2beUL;
   tf->codes[10730] = 0x0004ed3cdda43b9bUL;
   tf->codes[10731] = 0x0004ed3eecab6f88UL;
   tf->codes[10732] = 0x0004ed4a972995c7UL;
   tf->codes[10733] = 0x0004ed588b3df5b8UL;
   tf->codes[10734] = 0x0004ed5b49f23af4UL;
   tf->codes[10735] = 0x0004ed6a2842b1f9UL;
   tf->codes[10736] = 0x0004ed82677b158bUL;
   tf->codes[10737] = 0x0004ed85d5dc6c16UL;
   tf->codes[10738] = 0x0004ed86c018832aUL;
   tf->codes[10739] = 0x0004ed8d27bd24b6UL;
   tf->codes[10740] = 0x0004ed8efc3552deUL;
   tf->codes[10741] = 0x0004ed938f61c642UL;
   tf->codes[10742] = 0x0004ed94b42ce31bUL;
   tf->codes[10743] = 0x0004edbb5c97b228UL;
   tf->codes[10744] = 0x0004edbcbbf1d4c6UL;
   tf->codes[10745] = 0x0004edc40dd28d66UL;
   tf->codes[10746] = 0x0004edc8666ffb05UL;
   tf->codes[10747] = 0x0004edcc0f605755UL;
   tf->codes[10748] = 0x0004edcde3d8857dUL;
   tf->codes[10749] = 0x0004edd39bd015baUL;
   tf->codes[10750] = 0x0004edde5c1224e5UL;
   tf->codes[10751] = 0x0004edf86fc2b69fUL;
   tf->codes[10752] = 0x0004edfe9cd85266UL;
   tf->codes[10753] = 0x0004ee0db5b7cf30UL;
   tf->codes[10754] = 0x0004ee0fc4bf031dUL;
   tf->codes[10755] = 0x0004ee1800dbd2d1UL;
   tf->codes[10756] = 0x0004ee1be45b34e6UL;
   tf->codes[10757] = 0x0004ee371cd6e379UL;
   tf->codes[10758] = 0x0004ee39a0fc22f0UL;
   tf->codes[10759] = 0x0004ee3ee3d5a7a3UL;
   tf->codes[10760] = 0x0004ee4301e40f7dUL;
   tf->codes[10761] = 0x0004ee537a1daee5UL;
   tf->codes[10762] = 0x0004ee596ca444e7UL;
   tf->codes[10763] = 0x0004ee65c6cf7c75UL;
   tf->codes[10764] = 0x0004ee69aa4ede8aUL;
   tf->codes[10765] = 0x0004ee6f9cd5748cUL;
   tf->codes[10766] = 0x0004ee7345c5d0dcUL;
   tf->codes[10767] = 0x0004ee743001e7f0UL;
   tf->codes[10768] = 0x0004ee7f656202a5UL;
   tf->codes[10769] = 0x0004eea2d9fa80ecUL;
   tf->codes[10770] = 0x0004eeaadb884adbUL;
   tf->codes[10771] = 0x0004eebc788d071cUL;
   tf->codes[10772] = 0x0004eebfe6ee5da7UL;
   tf->codes[10773] = 0x0004eee1c19db38bUL;
   tf->codes[10774] = 0x0004eee3d0a4e778UL;
   tf->codes[10775] = 0x0004eee56a8e0fdbUL;
   tf->codes[10776] = 0x0004eee70477383eUL;
   tf->codes[10777] = 0x0004eee7799543c8UL;
   tf->codes[10778] = 0x0004eef2e9846442UL;
   tf->codes[10779] = 0x0004ef077fcc6b84UL;
   tf->codes[10780] = 0x0004ef0b634bcd99UL;
   tf->codes[10781] = 0x0004ef0b9ddad35eUL;
   tf->codes[10782] = 0x0004ef12400e7aafUL;
   tf->codes[10783] = 0x0004ef12efbb8bfeUL;
   tf->codes[10784] = 0x0004ef132a4a91c3UL;
   tf->codes[10785] = 0x0004ef1f0f57bdc7UL;
   tf->codes[10786] = 0x0004ef2c53bf0c69UL;
   tf->codes[10787] = 0x0004ef415f251f35UL;
   tf->codes[10788] = 0x0004ef6424108c2dUL;
   tf->codes[10789] = 0x0004ef69dc081c6aUL;
   tf->codes[10790] = 0x0004ef6dfa168444UL;
   tf->codes[10791] = 0x0004ef7252b3f1e3UL;
   tf->codes[10792] = 0x0004ef7670c259bdUL;
   tf->codes[10793] = 0x0004ef79a494aa83UL;
   tf->codes[10794] = 0x0004ef7cd866fb49UL;
   tf->codes[10795] = 0x0004ef8f9a36d463UL;
   tf->codes[10796] = 0x0004ef92ce092529UL;
   tf->codes[10797] = 0x0004ef9cde9e2305UL;
   tf->codes[10798] = 0x0004efb1ea0435d1UL;
   tf->codes[10799] = 0x0004efb30ecf52aaUL;
   tf->codes[10800] = 0x0004efb608129dabUL;
   tf->codes[10801] = 0x0004efc904717c8aUL;
   tf->codes[10802] = 0x0004efcef6f8128cUL;
   tf->codes[10803] = 0x0004efd17b1d5203UL;
   tf->codes[10804] = 0x0004eff355cca7e7UL;
   tf->codes[10805] = 0x0004eff5d9f1e75eUL;
   tf->codes[10806] = 0x0004eff90dc43824UL;
   tf->codes[10807] = 0x0004effae23c664cUL;
   tf->codes[10808] = 0x0004effe160eb712UL;
   tf->codes[10809] = 0x0004f009fb1be316UL;
   tf->codes[10810] = 0x0004f00b5a7605b4UL;
   tf->codes[10811] = 0x0004f01a7355827eUL;
   tf->codes[10812] = 0x0004f01bd2afa51cUL;
   tf->codes[10813] = 0x0004f03e227d068aUL;
   tf->codes[10814] = 0x0004f043da7496c7UL;
   tf->codes[10815] = 0x0004f044c4b0addbUL;
   tf->codes[10816] = 0x0004f0592069af58UL;
   tf->codes[10817] = 0x0004f075f2ce864eUL;
   tf->codes[10818] = 0x0004f07c1fe42215UL;
   tf->codes[10819] = 0x0004f09b766e3882UL;
   tf->codes[10820] = 0x0004f09bb0fd3e47UL;
   tf->codes[10821] = 0x0004f0b80e4409b3UL;
   tf->codes[10822] = 0x0004f0bbf1c36bc8UL;
   tf->codes[10823] = 0x0004f0c6b2057af3UL;
   tf->codes[10824] = 0x0004f0cf9dcf5bf6UL;
   tf->codes[10825] = 0x0004f0d1acd68fe3UL;
   tf->codes[10826] = 0x0004f0da2382655cUL;
   tf->codes[10827] = 0x0004f0e2d4bd409aUL;
   tf->codes[10828] = 0x0004f0eb85f81bd8UL;
   tf->codes[10829] = 0x0004f0ebfb162762UL;
   tf->codes[10830] = 0x0004f0fd981ae3a3UL;
   tf->codes[10831] = 0x0004f1038aa179a5UL;
   tf->codes[10832] = 0x0004f104e9fb9c43UL;
   tf->codes[10833] = 0x0004f10a2cd520f6UL;
   tf->codes[10834] = 0x0004f10b8c2f4394UL;
   tf->codes[10835] = 0x0004f111f3d3e520UL;
   tf->codes[10836] = 0x0004f118d0969236UL;
   tf->codes[10837] = 0x0004f11bc9d9dd37UL;
   tf->codes[10838] = 0x0004f12f00c7c1dbUL;
   tf->codes[10839] = 0x0004f150a0e811faUL;
   tf->codes[10840] = 0x0004f1548467740fUL;
   tf->codes[10841] = 0x0004f1556ea38b23UL;
   tf->codes[10842] = 0x0004f15cc08443c3UL;
   tf->codes[10843] = 0x0004f166968a3bdaUL;
   tf->codes[10844] = 0x0004f16a04eb9265UL;
   tf->codes[10845] = 0x0004f16fbce322a2UL;
   tf->codes[10846] = 0x0004f18577f646bdUL;
   tf->codes[10847] = 0x0004f18af55ed135UL;
   tf->codes[10848] = 0x0004f1bc5e0baf6dUL;
   tf->codes[10849] = 0x0004f1bd82d6cc46UL;
   tf->codes[10850] = 0x0004f1cc26983d86UL;
   tf->codes[10851] = 0x0004f1d846346f4fUL;
   tf->codes[10852] = 0x0004f1ffd8db5570UL;
   tf->codes[10853] = 0x0004f2051bb4da23UL;
   tf->codes[10854] = 0x0004f20b48ca75eaUL;
   tf->codes[10855] = 0x0004f20fa167e389UL;
   tf->codes[10856] = 0x0004f22bfeaeaef5UL;
   tf->codes[10857] = 0x0004f23cec0659e7UL;
   tf->codes[10858] = 0x0004f24144a3c786UL;
   tf->codes[10859] = 0x0004f24562b22f60UL;
   tf->codes[10860] = 0x0004f24d29b0f38aUL;
   tf->codes[10861] = 0x0004f25391559516UL;
   tf->codes[10862] = 0x0004f27272c19ff9UL;
   tf->codes[10863] = 0x0004f273d21bc297UL;
   tf->codes[10864] = 0x0004f277407d1922UL;
   tf->codes[10865] = 0x0004f286ce7aa176UL;
   tf->codes[10866] = 0x0004f28e205b5a16UL;
   tf->codes[10867] = 0x0004f291542daadcUL;
   tf->codes[10868] = 0x0004f29bd9e0b442UL;
   tf->codes[10869] = 0x0004f2b11fd5ccd3UL;
   tf->codes[10870] = 0x0004f2bffe2643d8UL;
   tf->codes[10871] = 0x0004f2cf1705c0a2UL;
   tf->codes[10872] = 0x0004f2d1260cf48fUL;
   tf->codes[10873] = 0x0004f2d2bff61cf2UL;
   tf->codes[10874] = 0x0004f2d4cefd50dfUL;
   tf->codes[10875] = 0x0004f2d5098c56a4UL;
   tf->codes[10876] = 0x0004f2d9279abe7eUL;
   tf->codes[10877] = 0x0004f2e71baf1e6fUL;
   tf->codes[10878] = 0x0004f2f1a16227d5UL;
   tf->codes[10879] = 0x0004f31934090df6UL;
   tf->codes[10880] = 0x0004f32eef1c3211UL;
   tf->codes[10881] = 0x0004f336b61af63bUL;
   tf->codes[10882] = 0x0004f345cefa7305UL;
   tf->codes[10883] = 0x0004f346098978caUL;
   tf->codes[10884] = 0x0004f349b279d51aUL;
   tf->codes[10885] = 0x0004f34d95f9372fUL;
   tf->codes[10886] = 0x0004f35e8350e221UL;
   tf->codes[10887] = 0x0004f393cf7d226eUL;
   tf->codes[10888] = 0x0004f39de012204aUL;
   tf->codes[10889] = 0x0004f3bf0b1464dfUL;
   tf->codes[10890] = 0x0004f3cb653f9c6dUL;
   tf->codes[10891] = 0x0004f3cd39b7ca95UL;
   tf->codes[10892] = 0x0004f3d3dbeb71e6UL;
   tf->codes[10893] = 0x0004f3df4bda9260UL;
   tf->codes[10894] = 0x0004f3f95f8b241aUL;
   tf->codes[10895] = 0x0004f3fabee546b8UL;
   tf->codes[10896] = 0x0004f3ff5211ba1cUL;
   tf->codes[10897] = 0x0004f4062ed46732UL;
   tf->codes[10898] = 0x0004f40a4ce2cf0cUL;
   tf->codes[10899] = 0x0004f42c9cb0307aUL;
   tf->codes[10900] = 0x0004f43acb539630UL;
   tf->codes[10901] = 0x0004f44675d1bc6fUL;
   tf->codes[10902] = 0x0004f4625dfa7c51UL;
   tf->codes[10903] = 0x0004f46815f20c8eUL;
   tf->codes[10904] = 0x0004f47a62a3da1eUL;
   tf->codes[10905] = 0x0004f48940f45123UL;
   tf->codes[10906] = 0x0004f49859d3cdedUL;
   tf->codes[10907] = 0x0004f4ad9fc8e67eUL;
   tf->codes[10908] = 0x0004f4b4b71a9959UL;
   tf->codes[10909] = 0x0004f4b4f1a99f1eUL;
   tf->codes[10910] = 0x0004f4c4ba362d37UL;
   tf->codes[10911] = 0x0004f4d35df79e77UL;
   tf->codes[10912] = 0x0004f4d915ef2eb4UL;
   tf->codes[10913] = 0x0004f4db9a146e2bUL;
   tf->codes[10914] = 0x0004f4e276d71b41UL;
   tf->codes[10915] = 0x0004f50e621b6f01UL;
   tf->codes[10916] = 0x0004f5141a12ff3eUL;
   tf->codes[10917] = 0x0004f5283b3cfaf6UL;
   tf->codes[10918] = 0x0004f52cce696e5aUL;
   tf->codes[10919] = 0x0004f53c21d7f0e9UL;
   tf->codes[10920] = 0x0004f53f1b1b3beaUL;
   tf->codes[10921] = 0x0004f543e8d6b513UL;
   tf->codes[10922] = 0x0004f56673331c46UL;
   tf->codes[10923] = 0x0004f573427c5f5eUL;
   tf->codes[10924] = 0x0004f57d53115d3aUL;
   tf->codes[10925] = 0x0004f58e7af80df1UL;
   tf->codes[10926] = 0x0004f59dce669080UL;
   tf->codes[10927] = 0x0004f5a88ea89fabUL;
   tf->codes[10928] = 0x0004f6040e21a37bUL;
   tf->codes[10929] = 0x0004f608dbdd1ca4UL;
   tf->codes[10930] = 0x0004f609c61933b8UL;
   tf->codes[10931] = 0x0004f614865b42e3UL;
   tf->codes[10932] = 0x0004f633a256538bUL;
   tf->codes[10933] = 0x0004f63ab9a80666UL;
   tf->codes[10934] = 0x0004f63bde73233fUL;
   tf->codes[10935] = 0x0004f6448fadfe7dUL;
   tf->codes[10936] = 0x0004f64713d33df4UL;
   tf->codes[10937] = 0x0004f65f187c9bc1UL;
   tf->codes[10938] = 0x0004f66f90b63b29UL;
   tf->codes[10939] = 0x0004f67841f11667UL;
   tf->codes[10940] = 0x0004f689def5d2a8UL;
   tf->codes[10941] = 0x0004f69a1ca06c4bUL;
   tf->codes[10942] = 0x0004f69bb68994aeUL;
   tf->codes[10943] = 0x0004f6a2934c41c4UL;
   tf->codes[10944] = 0x0004f6be40e5fbe1UL;
   tf->codes[10945] = 0x0004f6c64273c5d0UL;
   tf->codes[10946] = 0x0004f6d01879bde7UL;
   tf->codes[10947] = 0x0004f6d4aba6314bUL;
   tf->codes[10948] = 0x0004f6f8cfebc0e1UL;
   tf->codes[10949] = 0x0004f70e8afee4fcUL;
   tf->codes[10950] = 0x0004f71776c8c5ffUL;
   tf->codes[10951] = 0x0004f731155b4c2fUL;
   tf->codes[10952] = 0x0004f731ff976343UL;
   tf->codes[10953] = 0x0004f736cd52dc6cUL;
   tf->codes[10954] = 0x0004f740dde7da48UL;
   tf->codes[10955] = 0x0004f74277d102abUL;
   tf->codes[10956] = 0x0004f7532a99a7d8UL;
   tf->codes[10957] = 0x0004f75698fafe63UL;
   tf->codes[10958] = 0x0004f75f0fa6d3dcUL;
   tf->codes[10959] = 0x0004f767c0e1af1aUL;
   tf->codes[10960] = 0x0004f78a85cd1c12UL;
   tf->codes[10961] = 0x0004f798eeff878dUL;
   tf->codes[10962] = 0x0004f7bf224c4b10UL;
   tf->codes[10963] = 0x0004f7cf5ff6e4b3UL;
   tf->codes[10964] = 0x0004f7d084c2018cUL;
   tf->codes[10965] = 0x0004f7d0bf510751UL;
   tf->codes[10966] = 0x0004f7d84bc0c5b6UL;
   tf->codes[10967] = 0x0004f7e1378aa6b9UL;
   tf->codes[10968] = 0x0004f7e973a7766dUL;
   tf->codes[10969] = 0x0004f7ec325bbba9UL;
   tf->codes[10970] = 0x0004f80d22cefa79UL;
   tf->codes[10971] = 0x0004f81b5172602fUL;
   tf->codes[10972] = 0x0004f843ce555d64UL;
   tf->codes[10973] = 0x0004f84826f2cb03UL;
   tf->codes[10974] = 0x0004f84cf4ae442cUL;
   tf->codes[10975] = 0x0004f8702eb7bcaeUL;
   tf->codes[10976] = 0x0004f873d7a818feUL;
   tf->codes[10977] = 0x0004f89194490708UL;
   tf->codes[10978] = 0x0004f89368c13530UL;
   tf->codes[10979] = 0x0004f8a7c47a36adUL;
   tf->codes[10980] = 0x0004f8bd0a6f4f3eUL;
   tf->codes[10981] = 0x0004f8c630c83606UL;
   tf->codes[10982] = 0x0004f8c87a5e6fb8UL;
   tf->codes[10983] = 0x0004f8cbe8bfc643UL;
   tf->codes[10984] = 0x0004f8e796598060UL;
   tf->codes[10985] = 0x0004f8ea8f9ccb61UL;
   tf->codes[10986] = 0x0004f8ed4e51109dUL;
   tf->codes[10987] = 0x0004f9084c3db96bUL;
   tf->codes[10988] = 0x0004f908c15bc4f5UL;
   tf->codes[10989] = 0x0004f912d1f0c2d1UL;
   tf->codes[10990] = 0x0004f9164052195cUL;
   tf->codes[10991] = 0x0004f9301973a551UL;
   tf->codes[10992] = 0x0004f9590b74ae10UL;
   tf->codes[10993] = 0x0004f95b1a7be1fdUL;
   tf->codes[10994] = 0x0004f977b251b32eUL;
   tf->codes[10995] = 0x0004f979c158e71bUL;
   tf->codes[10996] = 0x0004f97aab94fe2fUL;
   tf->codes[10997] = 0x0004f989c4747af9UL;
   tf->codes[10998] = 0x0004f990dbc62dd4UL;
   tf->codes[10999] = 0x0004f99917e2fd88UL;
   tf->codes[11000] = 0x0004f9aed2f621a3UL;
   tf->codes[11001] = 0x0004f9b32b938f42UL;
   tf->codes[11002] = 0x0004f9b699f4e5cdUL;
   tf->codes[11003] = 0x0004f9c95bc4bee7UL;
   tf->codes[11004] = 0x0004f9d874a43bb1UL;
   tf->codes[11005] = 0x0004f9f128faaacdUL;
   tf->codes[11006] = 0x0004fa0bec584dd6UL;
   tf->codes[11007] = 0x0004fa1bb4e4dbefUL;
   tf->codes[11008] = 0x0004fa1dc3ec0fdcUL;
   tf->codes[11009] = 0x0004fa4297deb0c1UL;
   tf->codes[11010] = 0x0004fa4e425cd700UL;
   tf->codes[11011] = 0x0004fa4e7cebdcc5UL;
   tf->codes[11012] = 0x0004fa4eb77ae28aUL;
   tf->codes[11013] = 0x0004fa5768b5bdc8UL;
   tf->codes[11014] = 0x0004fa655cca1db9UL;
   tf->codes[11015] = 0x0004fa6bc46ebf45UL;
   tf->codes[11016] = 0x0004fa6fe27d271fUL;
   tf->codes[11017] = 0x0004fa91829d773eUL;
   tf->codes[11018] = 0x0004fa9c42df8669UL;
   tf->codes[11019] = 0x0004fab740cc2f37UL;
   tf->codes[11020] = 0x0004fabda870d0c3UL;
   tf->codes[11021] = 0x0004fabe581de212UL;
   tf->codes[11022] = 0x0004fad20429d240UL;
   tf->codes[11023] = 0x0004faef4bacb4c0UL;
   tf->codes[11024] = 0x0004faf27f7f0586UL;
   tf->codes[11025] = 0x0004fb033247aab3UL;
   tf->codes[11026] = 0x0004fb145a2e5b6aUL;
   tf->codes[11027] = 0x0004fb28b5e75ce7UL;
   tf->codes[11028] = 0x0004fb2b749ba223UL;
   tf->codes[11029] = 0x0004fb2d0e84ca86UL;
   tf->codes[11030] = 0x0004fb349af488ebUL;
   tf->codes[11031] = 0x0004fb412faec63eUL;
   tf->codes[11032] = 0x0004fb50f83b5457UL;
   tf->codes[11033] = 0x0004fb572550f01eUL;
   tf->codes[11034] = 0x0004fb5e3ca2a2f9UL;
   tf->codes[11035] = 0x0004fb71e8ae9327UL;
   tf->codes[11036] = 0x0004fb7bf9439103UL;
   tf->codes[11037] = 0x0004fb855a2b7d90UL;
   tf->codes[11038] = 0x0004fb87de50bd07UL;
   tf->codes[11039] = 0x0004fb91eee5bae3UL;
   tf->codes[11040] = 0x0004fb9313b0d7bcUL;
   tf->codes[11041] = 0x0004fb9682122e47UL;
   tf->codes[11042] = 0x0004fbb59e0d3eefUL;
   tf->codes[11043] = 0x0004fbbe89d71ff2UL;
   tf->codes[11044] = 0x0004fbc47c5db5f4UL;
   tf->codes[11045] = 0x0004fbcd682796f7UL;
   tf->codes[11046] = 0x0004fbd68e807dbfUL;
   tf->codes[11047] = 0x0004fbd82869a622UL;
   tf->codes[11048] = 0x0004fbde557f41e9UL;
   tf->codes[11049] = 0x0004fbde900e47aeUL;
   tf->codes[11050] = 0x0004fbdeca9d4d73UL;
   tf->codes[11051] = 0x0004fbf709d5b105UL;
   tf->codes[11052] = 0x0004fbf918dce4f2UL;
   tf->codes[11053] = 0x0004fc0747804aa8UL;
   tf->codes[11054] = 0x0004fc16605fc772UL;
   tf->codes[11055] = 0x0004fc18e48506e9UL;
   tf->codes[11056] = 0x0004fc1c8d756339UL;
   tf->codes[11057] = 0x0004fc416168041eUL;
   tf->codes[11058] = 0x0004fc4544e76633UL;
   tf->codes[11059] = 0x0004fc47195f945bUL;
   tf->codes[11060] = 0x0004fc483e2ab134UL;
   tf->codes[11061] = 0x0004fc4c96c81ed3UL;
   tf->codes[11062] = 0x0004fc59661161ebUL;
   tf->codes[11063] = 0x0004fc69a3bbfb8eUL;
   tf->codes[11064] = 0x0004fc6d4cac57deUL;
   tf->codes[11065] = 0x0004fc6f96429190UL;
   tf->codes[11066] = 0x0004fc92209ef8c3UL;
   tf->codes[11067] = 0x0004fc979e07833bUL;
   tf->codes[11068] = 0x0004fc9e05ac24c7UL;
   tf->codes[11069] = 0x0004fcb9b345dee4UL;
   tf->codes[11070] = 0x0004fcc13fb59d49UL;
   tf->codes[11071] = 0x0004fcc598530ae8UL;
   tf->codes[11072] = 0x0004fcc7323c334bUL;
   tf->codes[11073] = 0x0004fcd01e06144eUL;
   tf->codes[11074] = 0x0004fcf89ae91183UL;
   tf->codes[11075] = 0x0004fd07b3c88e4dUL;
   tf->codes[11076] = 0x0004fd3030ab8b82UL;
   tf->codes[11077] = 0x0004fd344eb9f35cUL;
   tf->codes[11078] = 0x0004fd4ffc53ad79UL;
   tf->codes[11079] = 0x0004fd5788c36bdeUL;
   tf->codes[11080] = 0x0004fd6a4a9344f8UL;
   tf->codes[11081] = 0x0004fd79d890cd4cUL;
   tf->codes[11082] = 0x0004fd8d849cbd7aUL;
   tf->codes[11083] = 0x0004fd9b78b11d6bUL;
   tf->codes[11084] = 0x0004fd9dc247571dUL;
   tf->codes[11085] = 0x0004fda5c3d5210cUL;
   tf->codes[11086] = 0x0004fda8f7a771d2UL;
   tf->codes[11087] = 0x0004fdb3f27886c2UL;
   tf->codes[11088] = 0x0004fdb7264ad788UL;
   tf->codes[11089] = 0x0004fdcdcb9a12b7UL;
   tf->codes[11090] = 0x0004fdd93b893331UL;
   tf->codes[11091] = 0x0004fdd9761838f6UL;
   tf->codes[11092] = 0x0004fde76a2c98e7UL;
   tf->codes[11093] = 0x0004fdfceab0b73dUL;
   tf->codes[11094] = 0x0004fe185dbb6b95UL;
   tf->codes[11095] = 0x0004fe1effef12e6UL;
   tf->codes[11096] = 0x0004fe28d5f50afdUL;
   tf->codes[11097] = 0x0004fe353020428bUL;
   tf->codes[11098] = 0x0004fe3b97c4e417UL;
   tf->codes[11099] = 0x0004fe3cf71f06b5UL;
   tf->codes[11100] = 0x0004fe4a3b865557UL;
   tf->codes[11101] = 0x0004fe58a4b8c0d2UL;
   tf->codes[11102] = 0x0004fe5bd88b1198UL;
   tf->codes[11103] = 0x0004fe5e5cb0510fUL;
   tf->codes[11104] = 0x0004fe653972fe25UL;
   tf->codes[11105] = 0x0004fe670deb2c4dUL;
   tf->codes[11106] = 0x0004fe72b869528cUL;
   tf->codes[11107] = 0x0004fe7452527aefUL;
   tf->codes[11108] = 0x0004fe903a7b3ad1UL;
   tf->codes[11109] = 0x0004fe9284117483UL;
   tf->codes[11110] = 0x0004fe945889a2abUL;
   tf->codes[11111] = 0x0004fed514a50372UL;
   tf->codes[11112] = 0x0004feea5a9a1c03UL;
   tf->codes[11113] = 0x0004feffdb1e3a59UL;
   tf->codes[11114] = 0x0004ff013a785cf7UL;
   tf->codes[11115] = 0x0004ff0d94a39485UL;
   tf->codes[11116] = 0x0004ff0fde39ce37UL;
   tf->codes[11117] = 0x0004ff15d0c06439UL;
   tf->codes[11118] = 0x0004ff190492b4ffUL;
   tf->codes[11119] = 0x0004ff1e0cdd33edUL;
   tf->codes[11120] = 0x0004ff4898c7650fUL;
   tf->codes[11121] = 0x0004ff4ddba0e9c2UL;
   tf->codes[11122] = 0x0004ff5617bdb976UL;
   tf->codes[11123] = 0x0004ff5c0a444f78UL;
   tf->codes[11124] = 0x0004ff9cc65fb03fUL;
   tf->codes[11125] = 0x0004ffb41b5bfcbdUL;
   tf->codes[11126] = 0x0004ffb9d3538cfaUL;
   tf->codes[11127] = 0x0004ffdc983ef9f2UL;
   tf->codes[11128] = 0x0004ffed1078995aUL;
   tf->codes[11129] = 0x0005001294184b8eUL;
   tf->codes[11130] = 0x000500172744bef2UL;
   tf->codes[11131] = 0x0005001a208809f3UL;
   tf->codes[11132] = 0x00050031b0135c36UL;
   tf->codes[11133] = 0x0005003c35c6659cUL;
   tf->codes[11134] = 0x0005004387a71e3cUL;
   tf->codes[11135] = 0x0005005d2639a46cUL;
   tf->codes[11136] = 0x000500685b99bf21UL;
   tf->codes[11137] = 0x000500785eb552ffUL;
   tf->codes[11138] = 0x0005007da18ed7b2UL;
   tf->codes[11139] = 0x0005007e8bcaeec6UL;
   tf->codes[11140] = 0x0005008cba6e547cUL;
   tf->codes[11141] = 0x0005009655e546ceUL;
   tf->codes[11142] = 0x0005009d32a7f3e4UL;
   tf->codes[11143] = 0x000500d3a39f510aUL;
   tf->codes[11144] = 0x000500d5b2a684f7UL;
   tf->codes[11145] = 0x000500dabaf103e5UL;
   tf->codes[11146] = 0x000500e24760c24aUL;
   tf->codes[11147] = 0x000500f03b75223bUL;
   tf->codes[11148] = 0x000500fb70d53cf0UL;
   tf->codes[11149] = 0x000500fd454d6b18UL;
   tf->codes[11150] = 0x000500fd7fdc70ddUL;
   tf->codes[11151] = 0x000500fdba6b76a2UL;
   tf->codes[11152] = 0x00050101d879de7cUL;
   tf->codes[11153] = 0x000501071b53632fUL;
   tf->codes[11154] = 0x0005010afed2c544UL;
   tf->codes[11155] = 0x0005010b73f0d0ceUL;
   tf->codes[11156] = 0x00050110b6ca5581UL;
   tf->codes[11157] = 0x00050111db95725aUL;
   tf->codes[11158] = 0x0005011250b37de4UL;
   tf->codes[11159] = 0x00050120b9e5e95fUL;
   tf->codes[11160] = 0x0005013674f90d7aUL;
   tf->codes[11161] = 0x0005013c677fa37cUL;
   tf->codes[11162] = 0x0005014309b34acdUL;
   tf->codes[11163] = 0x0005014eb431710cUL;
   tf->codes[11164] = 0x000501513856b083UL;
   tf->codes[11165] = 0x0005015381ecea35UL;
   tf->codes[11166] = 0x00050158ff5574adUL;
   tf->codes[11167] = 0x0005015b837ab424UL;
   tf->codes[11168] = 0x0005016225ae5b75UL;
   tf->codes[11169] = 0x0005016d207f7065UL;
   tf->codes[11170] = 0x0005017646d8572dUL;
   tf->codes[11171] = 0x000501acb7cfb453UL;
   tf->codes[11172] = 0x000501b1c01a3341UL;
   tf->codes[11173] = 0x000501b4b95d7e42UL;
   tf->codes[11174] = 0x000501bb96202b58UL;
   tf->codes[11175] = 0x000501c14e17bb95UL;
   tf->codes[11176] = 0x000501ce1d60feadUL;
   tf->codes[11177] = 0x000501d23b6f6687UL;
   tf->codes[11178] = 0x000501dfba65baeeUL;
   tf->codes[11179] = 0x000501dff4f4c0b3UL;
   tf->codes[11180] = 0x000501e36356173eUL;
   tf->codes[11181] = 0x000501eb9f72e6f2UL;
   tf->codes[11182] = 0x000501ef0dd43d7dUL;
   tf->codes[11183] = 0x000501f0a7bd65e0UL;
   tf->codes[11184] = 0x000501f5005ad37fUL;
   tf->codes[11185] = 0x0005020d3f933711UL;
   tf->codes[11186] = 0x00050213a737d89dUL;
   tf->codes[11187] = 0x0005022d0b3b5908UL;
   tf->codes[11188] = 0x000502399ff5965bUL;
   tf->codes[11189] = 0x0005023df89303faUL;
   tf->codes[11190] = 0x000502446037a586UL;
   tf->codes[11191] = 0x0005024ee5eaaeecUL;
   tf->codes[11192] = 0x000502516a0fee63UL;
   tf->codes[11193] = 0x0005025303f916c6UL;
   tf->codes[11194] = 0x00050279ac63e5d3UL;
   tf->codes[11195] = 0x0005028a5f2c8b00UL;
   tf->codes[11196] = 0x0005028c33a4b928UL;
   tf->codes[11197] = 0x000502931067663eUL;
   tf->codes[11198] = 0x000502967ec8bcc9UL;
   tf->codes[11199] = 0x0005029ce66d5e55UL;
   tf->codes[11200] = 0x000502be868dae74UL;
   tf->codes[11201] = 0x000502cae0b8e602UL;
   tf->codes[11202] = 0x000502d4b6bede19UL;
   tf->codes[11203] = 0x000502e0d65b0fe2UL;
   tf->codes[11204] = 0x000502f14e94af4aUL;
   tf->codes[11205] = 0x000502f1c3b2bad4UL;
   tf->codes[11206] = 0x000502f7b63950d6UL;
   tf->codes[11207] = 0x000502faaf7c9bd7UL;
   tf->codes[11208] = 0x000502fb249aa761UL;
   tf->codes[11209] = 0x000502fde34eec9dUL;
   tf->codes[11210] = 0x00050301c6ce4eb2UL;
   tf->codes[11211] = 0x00050312eeb4ff69UL;
   tf->codes[11212] = 0x000503144e0f2207UL;
   tf->codes[11213] = 0x000503195659a0f5UL;
   tf->codes[11214] = 0x0005032e61bfb3c1UL;
   tf->codes[11215] = 0x000503320ab01011UL;
   tf->codes[11216] = 0x00050333df283e39UL;
   tf->codes[11217] = 0x000503487570457bUL;
   tf->codes[11218] = 0x000503583dfcd394UL;
   tf->codes[11219] = 0x0005035d80d65847UL;
   tf->codes[11220] = 0x0005036d4962e660UL;
   tf->codes[11221] = 0x0005036f1ddb1488UL;
   tf->codes[11222] = 0x00050372c6cb70d8UL;
   tf->codes[11223] = 0x000503ce0bb56ee3UL;
   tf->codes[11224] = 0x000503daa06fac36UL;
   tf->codes[11225] = 0x000503dd5f23f172UL;
   tf->codes[11226] = 0x000503dfa8ba2b24UL;
   tf->codes[11227] = 0x000503ec78036e3cUL;
   tf->codes[11228] = 0x000503ecb2927401UL;
   tf->codes[11229] = 0x000503ed9cce8b15UL;
   tf->codes[11230] = 0x000503eec199a7eeUL;
   tf->codes[11231] = 0x000503f563cd4f3fUL;
   tf->codes[11232] = 0x000503fc0600f690UL;
   tf->codes[11233] = 0x000504114bf60f21UL;
   tf->codes[11234] = 0x00050412e5df3784UL;
   tf->codes[11235] = 0x0005041a724ef5e9UL;
   tf->codes[11236] = 0x0005042c49e2b7efUL;
   tf->codes[11237] = 0x00050432b187597bUL;
   tf->codes[11238] = 0x0005043d373a62e1UL;
   tf->codes[11239] = 0x0005043dac586e6bUL;
   tf->codes[11240] = 0x0005044747cf60bdUL;
   tf->codes[11241] = 0x0005044a7ba1b183UL;
   tf->codes[11242] = 0x0005045208116fe8UL;
   tf->codes[11243] = 0x0005045d78009062UL;
   tf->codes[11244] = 0x00050471d3b991dfUL;
   tf->codes[11245] = 0x000504757ca9ee2fUL;
   tf->codes[11246] = 0x0005047f52afe646UL;
   tf->codes[11247] = 0x00050495f7ff2175UL;
   tf->codes[11248] = 0x0005049a8b2b94d9UL;
   tf->codes[11249] = 0x0005049d846edfdaUL;
   tf->codes[11250] = 0x000504ab3df43a06UL;
   tf->codes[11251] = 0x000504ad4cfb6df3UL;
   tf->codes[11252] = 0x000504b5c3a7436cUL;
   tf->codes[11253] = 0x000504bf5f1e35beUL;
   tf->codes[11254] = 0x000504c63be0e2d4UL;
   tf->codes[11255] = 0x000504c6b0feee5eUL;
   tf->codes[11256] = 0x000504d63efc76b2UL;
   tf->codes[11257] = 0x000504da9799e451UL;
   tf->codes[11258] = 0x000504dd564e298dUL;
   tf->codes[11259] = 0x000504dd90dd2f52UL;
   tf->codes[11260] = 0x000504e975ea5b56UL;
   tf->codes[11261] = 0x000504ee7e34da44UL;
   tf->codes[11262] = 0x0005050caff3d3d8UL;
   tf->codes[11263] = 0x0005050d5fa0e527UL;
   tf->codes[11264] = 0x0005051e12698a54UL;
   tf->codes[11265] = 0x0005052d2b49071eUL;
   tf->codes[11266] = 0x0005052ddaf6186dUL;
   tf->codes[11267] = 0x00050540d754f74cUL;
   tf->codes[11268] = 0x0005054cbc622350UL;
   tf->codes[11269] = 0x0005054ecb69573dUL;
   tf->codes[11270] = 0x00050552e977bf17UL;
   tf->codes[11271] = 0x000505695437f481UL;
   tf->codes[11272] = 0x0005056a03e505d0UL;
   tf->codes[11273] = 0x0005056b28b022a9UL;
   tf->codes[11274] = 0x0005056bd85d33f8UL;
   tf->codes[11275] = 0x0005056d37b75696UL;
   tf->codes[11276] = 0x0005057364ccf25dUL;
   tf->codes[11277] = 0x0005057f49da1e61UL;
   tf->codes[11278] = 0x0005059838bf9342UL;
   tf->codes[11279] = 0x0005059f8aa04be2UL;
   tf->codes[11280] = 0x000505b336ac3c10UL;
   tf->codes[11281] = 0x000505c0408484edUL;
   tf->codes[11282] = 0x000505d28d36527dUL;
   tf->codes[11283] = 0x000505ebb6aacd23UL;
   tf->codes[11284] = 0x000505f601ced0c4UL;
   tf->codes[11285] = 0x000505fa5a6c3e63UL;
   tf->codes[11286] = 0x00050604a5904204UL;
   tf->codes[11287] = 0x000506058fcc5918UL;
   tf->codes[11288] = 0x00050609734bbb2dUL;
   tf->codes[11289] = 0x00050609e869c6b7UL;
   tf->codes[11290] = 0x000506151dc9e16cUL;
   tf->codes[11291] = 0x0005062c72c62deaUL;
   tf->codes[11292] = 0x0005063a66da8ddbUL;
   tf->codes[11293] = 0x000506490a9bff1bUL;
   tf->codes[11294] = 0x0005066b94f8664eUL;
   tf->codes[11295] = 0x0005068f441fea5aUL;
   tf->codes[11296] = 0x000506a86d946500UL;
   tf->codes[11297] = 0x000506ad00c0d864UL;
   tf->codes[11298] = 0x000506d15f956dbfUL;
   tf->codes[11299] = 0x000506dd0a1393feUL;
   tf->codes[11300] = 0x000506ebadd5053eUL;
   tf->codes[11301] = 0x000506f8428f4291UL;
   tf->codes[11302] = 0x0005071e00bdfa8aUL;
   tf->codes[11303] = 0x00050741755678d1UL;
   tf->codes[11304] = 0x0005074901c63736UL;
   tf->codes[11305] = 0x0005078c7c95dd39UL;
   tf->codes[11306] = 0x0005078d2c42ee88UL;
   tf->codes[11307] = 0x0005078e8b9d1126UL;
   tf->codes[11308] = 0x00050794f341b2b2UL;
   tf->codes[11309] = 0x000507994bdf2051UL;
   tf->codes[11310] = 0x000507ba76e164e6UL;
   tf->codes[11311] = 0x000507cf47b871edUL;
   tf->codes[11312] = 0x000507d41573eb16UL;
   tf->codes[11313] = 0x000507d70eb73617UL;
   tf->codes[11314] = 0x000507e5b278a757UL;
   tf->codes[11315] = 0x000507f714ee5dd3UL;
   tf->codes[11316] = 0x000507fa48c0ae99UL;
   tf->codes[11317] = 0x000507fb32fcc5adUL;
   tf->codes[11318] = 0x000507fbe2a9d6fcUL;
   tf->codes[11319] = 0x000507fe66cf1673UL;
   tf->codes[11320] = 0x00050808b1f31a14UL;
   tf->codes[11321] = 0x00050829a26658e4UL;
   tf->codes[11322] = 0x000508458a8f18c6UL;
   tf->codes[11323] = 0x00050849a89d80a0UL;
   tf->codes[11324] = 0x0005085d54a970ceUL;
   tf->codes[11325] = 0x0005086d57c504acUL;
   tf->codes[11326] = 0x000508730fbc94e9UL;
   tf->codes[11327] = 0x0005088437a345a0UL;
   tf->codes[11328] = 0x0005088bc4130405UL;
   tf->codes[11329] = 0x0005089315f3bca5UL;
   tf->codes[11330] = 0x000508955f89f657UL;
   tf->codes[11331] = 0x0005089858cd4158UL;
   tf->codes[11332] = 0x000508b9f8ed9177UL;
   tf->codes[11333] = 0x000508c1103f4452UL;
   tf->codes[11334] = 0x000508d272b4faceUL;
   tf->codes[11335] = 0x000508d35cf111e2UL;
   tf->codes[11336] = 0x000508df41fe3de6UL;
   tf->codes[11337] = 0x000508e0dbe76649UL;
   tf->codes[11338] = 0x000508f1c93f113bUL;
   tf->codes[11339] = 0x000508f830e3b2c7UL;
   tf->codes[11340] = 0x00050908e3ac57f4UL;
   tf->codes[11341] = 0x000509091e3b5db9UL;
   tf->codes[11342] = 0x0005092ccd62e1c5UL;
   tf->codes[11343] = 0x0005094805de9058UL;
   tf->codes[11344] = 0x000509696b6fdab2UL;
   tf->codes[11345] = 0x0005096c2a241feeUL;
   tf->codes[11346] = 0x000509bbc48ff7baUL;
   tf->codes[11347] = 0x000509be0e26316cUL;
   tf->codes[11348] = 0x000509c0ccda76a8UL;
   tf->codes[11349] = 0x000509c9b8a457abUL;
   tf->codes[11350] = 0x000509d7e747bd61UL;
   tf->codes[11351] = 0x000509f185da4391UL;
   tf->codes[11352] = 0x00050a0aaf4ebe37UL;
   tf->codes[11353] = 0x00050a15aa1fd327UL;
   tf->codes[11354] = 0x00050a1b27885d9fUL;
   tf->codes[11355] = 0x00050a4ccac4419cUL;
   tf->codes[11356] = 0x00050a4d7a7152ebUL;
   tf->codes[11357] = 0x00050a4f897886d8UL;
   tf->codes[11358] = 0x00050a51987fbac5UL;
   tf->codes[11359] = 0x00050a562bac2e29UL;
   tf->codes[11360] = 0x00050a583ab36216UL;
   tf->codes[11361] = 0x00050a5be3a3be66UL;
   tf->codes[11362] = 0x00050a6285d765b7UL;
   tf->codes[11363] = 0x00050a6df5c68631UL;
   tf->codes[11364] = 0x00050a7dbe53144aUL;
   tf->codes[11365] = 0x00050a7e33711fd4UL;
   tf->codes[11366] = 0x00050a83764aa487UL;
   tf->codes[11367] = 0x00050a95134f60c8UL;
   tf->codes[11368] = 0x00050a9b7af40254UL;
   tf->codes[11369] = 0x00050ace086bfd65UL;
   tf->codes[11370] = 0x00050af1427575e7UL;
   tf->codes[11371] = 0x00050b0095e3f876UL;
   tf->codes[11372] = 0x00050b105e70868fUL;
   tf->codes[11373] = 0x00050b139242d755UL;
   tf->codes[11374] = 0x00050b1d6848cf6cUL;
   tf->codes[11375] = 0x00050b2b5c5d2f5dUL;
   tf->codes[11376] = 0x00050b2d30d55d85UL;
   tf->codes[11377] = 0x00050b35e21038c3UL;
   tf->codes[11378] = 0x00050b4de6b99690UL;
   tf->codes[11379] = 0x00050b54c37c43a6UL;
   tf->codes[11380] = 0x00050b57bcbf8ea7UL;
   tf->codes[11381] = 0x00050b703686f7feUL;
   tf->codes[11382] = 0x00050b732fca42ffUL;
   tf->codes[11383] = 0x00050b748f24659dUL;
   tf->codes[11384] = 0x00050b7ccb413551UL;
   tf->codes[11385] = 0x00050b84923ff97bUL;
   tf->codes[11386] = 0x00050b85f19a1c19UL;
   tf->codes[11387] = 0x00050b8db898e043UL;
   tf->codes[11388] = 0x00050b93e5ae7c0aUL;
   tf->codes[11389] = 0x00050b957f97a46dUL;
   tf->codes[11390] = 0x00050ba9a0c1a025UL;
   tf->codes[11391] = 0x00050bbbb2e467f0UL;
   tf->codes[11392] = 0x00050bc21a89097cUL;
   tf->codes[11393] = 0x00050bcd155a1e6cUL;
   tf->codes[11394] = 0x00050bd25833a31fUL;
   tf->codes[11395] = 0x00050bd6b0d110beUL;
   tf->codes[11396] = 0x00050bd7d59c2d97UL;
   tf->codes[11397] = 0x00050bde77cfd4e8UL;
   tf->codes[11398] = 0x00050bdf277ce637UL;
   tf->codes[11399] = 0x00050bee405c6301UL;
   tf->codes[11400] = 0x00050bffa2d2197dUL;
   tf->codes[11401] = 0x00050c093e490bcfUL;
   tf->codes[11402] = 0x00050c16482154acUL;
   tf->codes[11403] = 0x00050c2c78528451UL;
   tf->codes[11404] = 0x00050c309660ec2bUL;
   tf->codes[11405] = 0x00050c3613c976a3UL;
   tf->codes[11406] = 0x00050c3822d0aa90UL;
   tf->codes[11407] = 0x00050c4ec81fe5bfUL;
   tf->codes[11408] = 0x00050c53d06a64adUL;
   tf->codes[11409] = 0x00050c54baa67bc1UL;
   tf->codes[11410] = 0x00050c6b9a84bcb5UL;
   tf->codes[11411] = 0x00050c76cfe4d76aUL;
   tf->codes[11412] = 0x00050c865de25fbeUL;
   tf->codes[11413] = 0x00050c8a4161c1d3UL;
   tf->codes[11414] = 0x00050cb15eea9c6aUL;
   tf->codes[11415] = 0x00050cb492bced30UL;
   tf->codes[11416] = 0x00050cc6a4dfb4fbUL;
   tf->codes[11417] = 0x00050cc99e22fffcUL;
   tf->codes[11418] = 0x00050ccafd7d229aUL;
   tf->codes[11419] = 0x00050ccd81a26211UL;
   tf->codes[11420] = 0x00050cd632dd3d4fUL;
   tf->codes[11421] = 0x00050cd757a85a28UL;
   tf->codes[11422] = 0x00050cd966af8e15UL;
   tf->codes[11423] = 0x00050ce9dee92d7dUL;
   tf->codes[11424] = 0x00050cef5c51b7f5UL;
   tf->codes[11425] = 0x00050cf1a5e7f1a7UL;
   tf->codes[11426] = 0x00050cfacc40d86fUL;
   tf->codes[11427] = 0x00050d03f299bf37UL;
   tf->codes[11428] = 0x00050d09357343eaUL;
   tf->codes[11429] = 0x00050d0cde63a03aUL;
   tf->codes[11430] = 0x00050d0dc89fb74eUL;
   tf->codes[11431] = 0x00050d326203526eUL;
   tf->codes[11432] = 0x00050d49b6ff9eecUL;
   tf->codes[11433] = 0x00050d5efcf4b77dUL;
   tf->codes[11434] = 0x00050d7cb995a587UL;
   tf->codes[11435] = 0x00050d7e8e0dd3afUL;
   tf->codes[11436] = 0x00050d840b765e27UL;
   tf->codes[11437] = 0x00050d8e9129678dUL;
   tf->codes[11438] = 0x00050d8fb5f48466UL;
   tf->codes[11439] = 0x00050d9a76369391UL;
   tf->codes[11440] = 0x00050d9cfa5bd308UL;
   tf->codes[11441] = 0x00050d9eced40130UL;
   tf->codes[11442] = 0x00050dae224283bfUL;
   tf->codes[11443] = 0x00050db190a3da4aUL;
   tf->codes[11444] = 0x00050dc45273b364UL;
   tf->codes[11445] = 0x00050dc50220c4b3UL;
   tf->codes[11446] = 0x00050dd5ef786fa5UL;
   tf->codes[11447] = 0x00050de6dcd01a97UL;
   tf->codes[11448] = 0x00050df78f98bfc4UL;
   tf->codes[11449] = 0x00050dfafdfa164fUL;
   tf->codes[11450] = 0x00050e050e8f142bUL;
   tf->codes[11451] = 0x00050e09a1bb878fUL;
   tf->codes[11452] = 0x00050e16ab93d06cUL;
   tf->codes[11453] = 0x00050e16e622d631UL;
   tf->codes[11454] = 0x00050e3a5abb5478UL;
   tf->codes[11455] = 0x00050e41e72b12ddUL;
   tf->codes[11456] = 0x00050e4c6cde1c43UL;
   tf->codes[11457] = 0x00050e551e18f781UL;
   tf->codes[11458] = 0x00050e559337030bUL;
   tf->codes[11459] = 0x00050e5b4b2e9348UL;
   tf->codes[11460] = 0x00050e66f5acb987UL;
   tf->codes[11461] = 0x00050e69eef00488UL;
   tf->codes[11462] = 0x00050e6a9e9d15d7UL;
   tf->codes[11463] = 0x00050e709123abd9UL;
   tf->codes[11464] = 0x00050e8561fab8e0UL;
   tf->codes[11465] = 0x00050e8aa4d43d93UL;
   tf->codes[11466] = 0x00050e931b80130cUL;
   tf->codes[11467] = 0x00050e95da345848UL;
   tf->codes[11468] = 0x00050e97398e7ae6UL;
   tf->codes[11469] = 0x00050eb5a5dc7a3fUL;
   tf->codes[11470] = 0x00050eb73fc5a2a2UL;
   tf->codes[11471] = 0x00050ebae8b5fef2UL;
   tf->codes[11472] = 0x00050ec35f61d46bUL;
   tf->codes[11473] = 0x00050ec4f94afcceUL;
   tf->codes[11474] = 0x00050ef41861a154UL;
   tf->codes[11475] = 0x00050efe9e14aabaUL;
   tf->codes[11476] = 0x00050f283fc2c4c8UL;
   tf->codes[11477] = 0x00050f428e025c47UL;
   tf->codes[11478] = 0x00050f580e867a9dUL;
   tf->codes[11479] = 0x00050f6677b8e618UL;
   tf->codes[11480] = 0x00050f6b45745f41UL;
   tf->codes[11481] = 0x00050f7e0744385bUL;
   tf->codes[11482] = 0x00050f808b6977d2UL;
   tf->codes[11483] = 0x00050f8902154d4bUL;
   tf->codes[11484] = 0x00050f94e722794fUL;
   tf->codes[11485] = 0x00050f9e480a65dcUL;
   tf->codes[11486] = 0x00050fba303325beUL;
   tf->codes[11487] = 0x00050fca334eb99cUL;
   tf->codes[11488] = 0x00050fcddc3f15ecUL;
   tf->codes[11489] = 0x00050fd234dc838bUL;
   tf->codes[11490] = 0x00050fdfee61ddb7UL;
   tf->codes[11491] = 0x00050ff98cf463e7UL;
   tf->codes[11492] = 0x00050ffa77307afbUL;
   tf->codes[11493] = 0x00050fff44ebf424UL;
   tf->codes[11494] = 0x0005100c4ec43d01UL;
   tf->codes[11495] = 0x000510545cc05668UL;
   tf->codes[11496] = 0x0005105546fc6d7cUL;
   tf->codes[11497] = 0x0005107c29f6424eUL;
   tf->codes[11498] = 0x0005108e76a80fdeUL;
   tf->codes[11499] = 0x000510925a2771f3UL;
   tf->codes[11500] = 0x000510a97494b8acUL;
   tf->codes[11501] = 0x000510c13eaf10b4UL;
   tf->codes[11502] = 0x000510c9b55ae62dUL;
   tf->codes[11503] = 0x000510e4edd694c0UL;
   tf->codes[11504] = 0x000510ec7a465325UL;
   tf->codes[11505] = 0x000510f4b66322d9UL;
   tf->codes[11506] = 0x000511014b1d602cUL;
   tf->codes[11507] = 0x00051104f40dbc7cUL;
   tf->codes[11508] = 0x00051118658aa6e5UL;
   tf->codes[11509] = 0x0005112bd707914eUL;
   tf->codes[11510] = 0x00051137f6a3c317UL;
   tf->codes[11511] = 0x0005113aefe70e18UL;
   tf->codes[11512] = 0x0005114032c092cbUL;
   tf->codes[11513] = 0x000511470f833fe1UL;
   tf->codes[11514] = 0x0005114cc77ad01eUL;
   tf->codes[11515] = 0x0005115120183dbdUL;
   tf->codes[11516] = 0x0005116a0efdb29eUL;
   tf->codes[11517] = 0x00051176de46f5b6UL;
   tf->codes[11518] = 0x0005117a1219467cUL;
   tf->codes[11519] = 0x0005117afc555d90UL;
   tf->codes[11520] = 0x0005118b39fff733UL;
   tf->codes[11521] = 0x0005118ea8614dbeUL;
   tf->codes[11522] = 0x000511b1e26ac640UL;
   tf->codes[11523] = 0x000511c4dec9a51fUL;
   tf->codes[11524] = 0x000511d88ad5954dUL;
   tf->codes[11525] = 0x000511e3fac4b5c7UL;
   tf->codes[11526] = 0x000511f9f066dfa7UL;
   tf->codes[11527] = 0x0005120efbccf273UL;
   tf->codes[11528] = 0x0005120f70eafdfdUL;
   tf->codes[11529] = 0x0005122c7ddedab8UL;
   tf->codes[11530] = 0x0005124c84160274UL;
   tf->codes[11531] = 0x0005125485a3cc63UL;
   tf->codes[11532] = 0x0005125e9638ca3fUL;
   tf->codes[11533] = 0x0005126363f44368UL;
   tf->codes[11534] = 0x0005127500f8ffa9UL;
   tf->codes[11535] = 0x0005127710003396UL;
   tf->codes[11536] = 0x0005127f118dfd85UL;
   tf->codes[11537] = 0x0005127f4c1d034aUL;
   tf->codes[11538] = 0x00051283df4976aeUL;
   tf->codes[11539] = 0x0005129123b0c550UL;
   tf->codes[11540] = 0x000512abac7f6294UL;
   tf->codes[11541] = 0x000512b2c3d1156fUL;
   tf->codes[11542] = 0x000512b71c6e830eUL;
   tf->codes[11543] = 0x000512c96920509eUL;
   tf->codes[11544] = 0x000512dcda9d3b07UL;
   tf->codes[11545] = 0x000512de7486636aUL;
   tf->codes[11546] = 0x000512e725c13ea8UL;
   tf->codes[11547] = 0x000512f220925398UL;
   tf->codes[11548] = 0x000512f728dcd286UL;
   tf->codes[11549] = 0x0005130e08bb137aUL;
   tf->codes[11550] = 0x00051311ec3a758fUL;
   tf->codes[11551] = 0x0005131978aa33f4UL;
   tf->codes[11552] = 0x0005131e4665ad1dUL;
   tf->codes[11553] = 0x0005132adb1fea70UL;
   tf->codes[11554] = 0x00051336859e10afUL;
   tf->codes[11555] = 0x00051344eed07c2aUL;
   tf->codes[11556] = 0x0005134cf05e4619UL;
   tf->codes[11557] = 0x00051354f1ec1008UL;
   tf->codes[11558] = 0x000513689df80036UL;
   tf->codes[11559] = 0x0005138bd80178b8UL;
   tf->codes[11560] = 0x000513aba3a99aafUL;
   tf->codes[11561] = 0x000513b788b6c6b3UL;
   tf->codes[11562] = 0x000513d4208c97e4UL;
   tf->codes[11563] = 0x000513d57fe6ba82UL;
   tf->codes[11564] = 0x000513d6a4b1d75bUL;
   tf->codes[11565] = 0x000513de6bb09b85UL;
   tf->codes[11566] = 0x000513dee0cea70fUL;
   tf->codes[11567] = 0x000513e498c6374cUL;
   tf->codes[11568] = 0x000513f54b8edc79UL;
   tf->codes[11569] = 0x000514137d4dd60dUL;
   tf->codes[11570] = 0x000514501b5acefaUL;
   tf->codes[11571] = 0x0005145055e9d4bfUL;
   tf->codes[11572] = 0x000514617dd08576UL;
   tf->codes[11573] = 0x00051465d66df315UL;
   tf->codes[11574] = 0x00051469f47c5aefUL;
   tf->codes[11575] = 0x0005146e87a8ce53UL;
   tf->codes[11576] = 0x0005146ec237d418UL;
   tf->codes[11577] = 0x000514785daec66aUL;
   tf->codes[11578] = 0x000514956aa2a325UL;
   tf->codes[11579] = 0x00051496c9fcc5c3UL;
   tf->codes[11580] = 0x000514973f1ad14dUL;
   tf->codes[11581] = 0x0005149f06199577UL;
   tf->codes[11582] = 0x000514b86a1d15e2UL;
   tf->codes[11583] = 0x000514c573f55ebfUL;
   tf->codes[11584] = 0x000514c70dde8722UL;
   tf->codes[11585] = 0x000514c782fc92acUL;
   tf->codes[11586] = 0x000514f0ea1ba6f5UL;
   tf->codes[11587] = 0x0005150f1bdaa089UL;
   tf->codes[11588] = 0x0005152eacf3bcbbUL;
   tf->codes[11589] = 0x0005153514985e47UL;
   tf->codes[11590] = 0x0005153c2bea1122UL;
   tf->codes[11591] = 0x0005153eb00f5099UL;
   tf->codes[11592] = 0x00051544dd24ec60UL;
   tf->codes[11593] = 0x0005154e789bdeb2UL;
   tf->codes[11594] = 0x0005156224a7cee0UL;
   tf->codes[11595] = 0x00051565587a1fa6UL;
   tf->codes[11596] = 0x0005156b858fbb6dUL;
   tf->codes[11597] = 0x0005156e7ed3066eUL;
   tf->codes[11598] = 0x000515708dda3a5bUL;
   tf->codes[11599] = 0x00051577300de1acUL;
   tf->codes[11600] = 0x0005158648ed5e76UL;
   tf->codes[11601] = 0x0005158dd55d1cdbUL;
   tf->codes[11602] = 0x0005158f34b73f79UL;
   tf->codes[11603] = 0x00051590cea067dcUL;
   tf->codes[11604] = 0x0005159a2f885469UL;
   tf->codes[11605] = 0x0005159b8ee27707UL;
   tf->codes[11606] = 0x000515abcc8d10aaUL;
   tf->codes[11607] = 0x000515b408a9e05eUL;
   tf->codes[11608] = 0x000515b4b856f1adUL;
   tf->codes[11609] = 0x000515bf037af54eUL;
   tf->codes[11610] = 0x000515c2e6fa5763UL;
   tf->codes[11611] = 0x000515e5e674ca20UL;
   tf->codes[11612] = 0x000515f783798661UL;
   tf->codes[11613] = 0x000515fa079ec5d8UL;
   tf->codes[11614] = 0x0005161df1554fa9UL;
   tf->codes[11615] = 0x0005162f53cb0625UL;
   tf->codes[11616] = 0x00051632127f4b61UL;
   tf->codes[11617] = 0x000516366b1cb900UL;
   tf->codes[11618] = 0x000516378fe7d5d9UL;
   tf->codes[11619] = 0x0005165d88a59397UL;
   tf->codes[11620] = 0x0005166d16a31bebUL;
   tf->codes[11621] = 0x0005167dc96bc118UL;
   tf->codes[11622] = 0x0005168e07165abbUL;
   tf->codes[11623] = 0x0005169608a424aaUL;
   tf->codes[11624] = 0x000516988cc96421UL;
   tf->codes[11625] = 0x000516b43a631e3eUL;
   tf->codes[11626] = 0x000516c68714ebceUL;
   tf->codes[11627] = 0x000516cceeb98d5aUL;
   tf->codes[11628] = 0x000516cdd8f5a46eUL;
   tf->codes[11629] = 0x000516d10cc7f534UL;
   tf->codes[11630] = 0x000516d7aefb9c85UL;
   tf->codes[11631] = 0x000516de16a03e11UL;
   tf->codes[11632] = 0x000516e35979c2c4UL;
   tf->codes[11633] = 0x000516f61b499bdeUL;
   tf->codes[11634] = 0x000516f82a50cfcbUL;
   tf->codes[11635] = 0x000517018b38bc58UL;
   tf->codes[11636] = 0x0005170c4b7acb83UL;
   tf->codes[11637] = 0x000517127890674aUL;
   tf->codes[11638] = 0x0005171de87f87c4UL;
   tf->codes[11639] = 0x000517332e74a055UL;
   tf->codes[11640] = 0x0005173fc32edda8UL;
   tf->codes[11641] = 0x00051753a9c9d39bUL;
   tf->codes[11642] = 0x00051757c7d83b75UL;
   tf->codes[11643] = 0x0005176fcc819942UL;
   tf->codes[11644] = 0x000517745fae0ca6UL;
   tf->codes[11645] = 0x00051775f9973509UL;
   tf->codes[11646] = 0x0005177a5234a2a8UL;
   tf->codes[11647] = 0x0005177bb18ec546UL;
   tf->codes[11648] = 0x000517bb0e50036fUL;
   tf->codes[11649] = 0x000517bd57e63d21UL;
   tf->codes[11650] = 0x000517c3bf8adeadUL;
   tf->codes[11651] = 0x000517c60921185fUL;
   tf->codes[11652] = 0x000517cc3636b426UL;
   tf->codes[11653] = 0x000517d054451c00UL;
   tf->codes[11654] = 0x000517d1b39f3e9eUL;
   tf->codes[11655] = 0x000517d855d2e5efUL;
   tf->codes[11656] = 0x000517e31614f51aUL;
   tf->codes[11657] = 0x000517e7e3d06e43UL;
   tf->codes[11658] = 0x0005180cf25214edUL;
   tf->codes[11659] = 0x000518126fba9f65UL;
   tf->codes[11660] = 0x0005181827b22fa2UL;
   tf->codes[11661] = 0x000518189cd03b2cUL;
   tf->codes[11662] = 0x00051836ce8f34c0UL;
   tf->codes[11663] = 0x0005185d3c6afe08UL;
   tf->codes[11664] = 0x000518657887cdbcUL;
   tf->codes[11665] = 0x000518674cfffbe4UL;
   tf->codes[11666] = 0x0005187282601699UL;
   tf->codes[11667] = 0x00051872f77e2223UL;
   tf->codes[11668] = 0x0005187abe7ce64dUL;
   tf->codes[11669] = 0x0005187d7d312b89UL;
   tf->codes[11670] = 0x0005188c5b81a28eUL;
   tf->codes[11671] = 0x00051894979e7242UL;
   tf->codes[11672] = 0x000518b79718e4ffUL;
   tf->codes[11673] = 0x000518c6ea87678eUL;
   tf->codes[11674] = 0x000518d21fe78243UL;
   tf->codes[11675] = 0x000518d63df5ea1dUL;
   tf->codes[11676] = 0x000518d762c106f6UL;
   tf->codes[11677] = 0x000518eb0eccf724UL;
   tf->codes[11678] = 0x000518f2d5cbbb4eUL;
   tf->codes[11679] = 0x000518f3fa96d827UL;
   tf->codes[11680] = 0x000518f559f0fac5UL;
   tf->codes[11681] = 0x0005190054c20fb5UL;
   tf->codes[11682] = 0x000519034e055ab6UL;
   tf->codes[11683] = 0x0005193c0892f18eUL;
   tf->codes[11684] = 0x00051951c3a615a9UL;
   tf->codes[11685] = 0x0005195e92ef58c1UL;
   tf->codes[11686] = 0x000519791bbdf605UL;
   tf->codes[11687] = 0x0005197c4f9046cbUL;
   tf->codes[11688] = 0x000519824216dccdUL;
   tf->codes[11689] = 0x0005198b2de0bdd0UL;
   tf->codes[11690] = 0x000519b8787f342eUL;
   tf->codes[11691] = 0x000519bdbb58b8e1UL;
   tf->codes[11692] = 0x000519d71f5c394cUL;
   tf->codes[11693] = 0x000519dc6235bdffUL;
   tf->codes[11694] = 0x000519e49e528db3UL;
   tf->codes[11695] = 0x000519e72277cd2aUL;
   tf->codes[11696] = 0x000519edff3a7a40UL;
   tf->codes[11697] = 0x000519f84a5e7de1UL;
   tf->codes[11698] = 0x00051a125e0f0f9bUL;
   tf->codes[11699] = 0x00051a185095a59dUL;
   tf->codes[11700] = 0x00051a213c5f86a0UL;
   tf->codes[11701] = 0x00051a29ed9a61deUL;
   tf->codes[11702] = 0x00051a2e80c6d542UL;
   tf->codes[11703] = 0x00051a5354b97627UL;
   tf->codes[11704] = 0x00051a6984eaa5ccUL;
   tf->codes[11705] = 0x00051a6bce80df7eUL;
   tf->codes[11706] = 0x00051a7e55c1b2d3UL;
   tf->codes[11707] = 0x00051a7f056ec422UL;
   tf->codes[11708] = 0x00051a8e58dd46b1UL;
   tf->codes[11709] = 0x00051a944b63dcb3UL;
   tf->codes[11710] = 0x00051a95e54d0516UL;
   tf->codes[11711] = 0x00051a9744a727b4UL;
   tf->codes[11712] = 0x00051a9c4cf1a6a2UL;
   tf->codes[11713] = 0x00051a9cfc9eb7f1UL;
   tf->codes[11714] = 0x00051abb2e5db185UL;
   tf->codes[11715] = 0x00051ac454b6984dUL;
   tf->codes[11716] = 0x00051ac48f459e12UL;
   tf->codes[11717] = 0x00051ac69e4cd1ffUL;
   tf->codes[11718] = 0x00051ad20e3bf279UL;
   tf->codes[11719] = 0x00051b0301cac527UL;
   tf->codes[11720] = 0x00051b100ba30e04UL;
   tf->codes[11721] = 0x00051b128fc84d7bUL;
   tf->codes[11722] = 0x00051b133f755ecaUL;
   tf->codes[11723] = 0x00051b1464407ba3UL;
   tf->codes[11724] = 0x00051b16add6b555UL;
   tf->codes[11725] = 0x00051b1931fbf4ccUL;
   tf->codes[11726] = 0x00051b3763baee60UL;
   tf->codes[11727] = 0x00051b381367ffafUL;
   tf->codes[11728] = 0x00051b3e7b0ca13bUL;
   tf->codes[11729] = 0x00051b4557cf4e51UL;
   tf->codes[11730] = 0x00051b4766d6823eUL;
   tf->codes[11731] = 0x00051b5052a06341UL;
   tf->codes[11732] = 0x00051b5227189169UL;
   tf->codes[11733] = 0x00051b555aeae22fUL;
   tf->codes[11734] = 0x00051b5caccb9acfUL;
   tf->codes[11735] = 0x00051b7efc98fc3dUL;
   tf->codes[11736] = 0x00051b847a0186b5UL;
   tf->codes[11737] = 0x00051bbb2587e9a0UL;
   tf->codes[11738] = 0x00051bcf46b1e558UL;
   tf->codes[11739] = 0x00051bd698929df8UL;
   tf->codes[11740] = 0x00051bda06f3f483UL;
   tf->codes[11741] = 0x00051bebde87b689UL;
   tf->codes[11742] = 0x00051bedb2ffe4b1UL;
   tf->codes[11743] = 0x00051bf1967f46c6UL;
   tf->codes[11744] = 0x00051bf20b9d5250UL;
   tf->codes[11745] = 0x00051bfa47ba2204UL;
   tf->codes[11746] = 0x00051c08765d87baUL;
   tf->codes[11747] = 0x00051c119cb66e82UL;
   tf->codes[11748] = 0x00051c124c637fd1UL;
   tf->codes[11749] = 0x00051c12c1818b5bUL;
   tf->codes[11750] = 0x00051c15bac4d65cUL;
   tf->codes[11751] = 0x00051c16df8ff335UL;
   tf->codes[11752] = 0x00051c1b72bc6699UL;
   tf->codes[11753] = 0x00051c2d84df2e64UL;
   tf->codes[11754] = 0x00051c475e00ba59UL;
   tf->codes[11755] = 0x00051c50f977acabUL;
   tf->codes[11756] = 0x00051c613722464eUL;
   tf->codes[11757] = 0x00051c66ef19d68bUL;
   tf->codes[11758] = 0x00051c6a980a32dbUL;
   tf->codes[11759] = 0x00051c7349450e19UL;
   tf->codes[11760] = 0x00051c7607f95355UL;
   tf->codes[11761] = 0x00051c76f2356a69UL;
   tf->codes[11762] = 0x00051c8595f6dba9UL;
   tf->codes[11763] = 0x00051c86bac1f882UL;
   tf->codes[11764] = 0x00051c994202cbd7UL;
   tf->codes[11765] = 0x00051cc149c7bd82UL;
   tf->codes[11766] = 0x00051cc7b16c5f0eUL;
   tf->codes[11767] = 0x00051cc89ba87622UL;
   tf->codes[11768] = 0x00051cc94b558771UL;
   tf->codes[11769] = 0x00051cd1fc9062afUL;
   tf->codes[11770] = 0x00051cdaadcb3dedUL;
   tf->codes[11771] = 0x00051ced6f9b1707UL;
   tf->codes[11772] = 0x00051cfa0455545aUL;
   tf->codes[11773] = 0x00051d0414ea5236UL;
   tf->codes[11774] = 0x00051d0a41ffedfdUL;
   tf->codes[11775] = 0x00051d1870a353b3UL;
   tf->codes[11776] = 0x00051d1a0a8c7c16UL;
   tf->codes[11777] = 0x00051d1bdf04aa3eUL;
   tf->codes[11778] = 0x00051d5165bff050UL;
   tf->codes[11779] = 0x00051d63b271bde0UL;
   tf->codes[11780] = 0x00051d663696fd57UL;
   tf->codes[11781] = 0x00051d79e2a2ed85UL;
   tf->codes[11782] = 0x00051d7eb05e66aeUL;
   tf->codes[11783] = 0x00051d8e78eaf4c7UL;
   tf->codes[11784] = 0x00051d9764b4d5caUL;
   tf->codes[11785] = 0x00051db08e295070UL;
   tf->codes[11786] = 0x00051db262a17e98UL;
   tf->codes[11787] = 0x00051dcdd5ac32f0UL;
   tf->codes[11788] = 0x00051dd895ee421bUL;
   tf->codes[11789] = 0x00051ddbc9c092e1UL;
   tf->codes[11790] = 0x00051de948b6e748UL;
   tf->codes[11791] = 0x00051deb57be1b35UL;
   tf->codes[11792] = 0x00051dec41fa3249UL;
   tf->codes[11793] = 0x00051def00ae7785UL;
   tf->codes[11794] = 0x00051dfcf4c2d776UL;
   tf->codes[11795] = 0x00051e014d604515UL;
   tf->codes[11796] = 0x00051e08d9d0037aUL;
   tf->codes[11797] = 0x00051e1ecf722d5aUL;
   tf->codes[11798] = 0x00051e2d38a498d5UL;
   tf->codes[11799] = 0x00051e3031e7e3d6UL;
   tf->codes[11800] = 0x00051e495b5c5e7cUL;
   tf->codes[11801] = 0x00051e520c9739baUL;
   tf->codes[11802] = 0x00051e58743bdb46UL;
   tf->codes[11803] = 0x00051e5d41f7546fUL;
   tf->codes[11804] = 0x00051e7546a0b23cUL;
   tf->codes[11805] = 0x00051e766b6bcf15UL;
   tf->codes[11806] = 0x00051e771b18e064UL;
   tf->codes[11807] = 0x00051e85f9695769UL;
   tf->codes[11808] = 0x00051e91a3e77da8UL;
   tf->codes[11809] = 0x00051e98f5c83648UL;
   tf->codes[11810] = 0x00051eb7621635a1UL;
   tf->codes[11811] = 0x00051ec2225844ccUL;
   tf->codes[11812] = 0x00051ec2d205561bUL;
   tf->codes[11813] = 0x00051ec9aec80331UL;
   tf->codes[11814] = 0x00051ecb48b12b94UL;
   tf->codes[11815] = 0x00051ecb83403159UL;
   tf->codes[11816] = 0x00051ece7c837c5aUL;
   tf->codes[11817] = 0x00051ed7a2dc6322UL;
   tf->codes[11818] = 0x00051ee890340e14UL;
   tf->codes[11819] = 0x00051eefe214c6b4UL;
   tf->codes[11820] = 0x00051efec0653db9UL;
   tf->codes[11821] = 0x00051f0a6ae363f8UL;
   tf->codes[11822] = 0x00051f0ec380d197UL;
   tf->codes[11823] = 0x00051f1f764976c4UL;
   tf->codes[11824] = 0x00051f394f6b02b9UL;
   tf->codes[11825] = 0x00051f50def654fcUL;
   tf->codes[11826] = 0x00051f518ea3664bUL;
   tf->codes[11827] = 0x00051f6ed62648cbUL;
   tf->codes[11828] = 0x00051f70aa9e76f3UL;
   tf->codes[11829] = 0x00051f769d250cf5UL;
   tf->codes[11830] = 0x00051f8665b19b0eUL;
   tf->codes[11831] = 0x00051f9001288d60UL;
   tf->codes[11832] = 0x00051f957e9117d8UL;
   tf->codes[11833] = 0x00051f9c20c4bf29UL;
   tf->codes[11834] = 0x00051fc303be93fbUL;
   tf->codes[11835] = 0x00051fd16cf0ff76UL;
   tf->codes[11836] = 0x00051fd80f24a6c7UL;
   tf->codes[11837] = 0x00051fe6b2e61807UL;
   tf->codes[11838] = 0x00051fe8fc7c51b9UL;
   tf->codes[11839] = 0x00051ff8155bce83UL;
   tf->codes[11840] = 0x00051ff88a79da0dUL;
   tf->codes[11841] = 0x0005200a277e964eUL;
   tf->codes[11842] = 0x000520185621fc04UL;
   tf->codes[11843] = 0x0005204615de7decUL;
   tf->codes[11844] = 0x0005204cb812253dUL;
   tf->codes[11845] = 0x0005205a71977f69UL;
   tf->codes[11846] = 0x0005205f04c3f2cdUL;
   tf->codes[11847] = 0x00052074fa661cadUL;
   tf->codes[11848] = 0x0005209a7e05cee1UL;
   tf->codes[11849] = 0x000520ab30ce740eUL;
   tf->codes[11850] = 0x000520aed9bed05eUL;
   tf->codes[11851] = 0x000520b8ea53ce3aUL;
   tf->codes[11852] = 0x000520be67bc58b2UL;
   tf->codes[11853] = 0x000520c87851568eUL;
   tf->codes[11854] = 0x000520cf1a84fddfUL;
   tf->codes[11855] = 0x000520da4fe51894UL;
   tf->codes[11856] = 0x000520df582f9782UL;
   tf->codes[11857] = 0x000520ec9c96e624UL;
   tf->codes[11858] = 0x000520f75cd8f54fUL;
   tf->codes[11859] = 0x0005210e0228307eUL;
   tf->codes[11860] = 0x0005211678d405f7UL;
   tf->codes[11861] = 0x00052119e7355c82UL;
   tf->codes[11862] = 0x0005213e4609f1ddUL;
   tf->codes[11863] = 0x0005214adac42f30UL;
   tf->codes[11864] = 0x00052157aa0d7248UL;
   tf->codes[11865] = 0x0005215b186ec8d3UL;
   tf->codes[11866] = 0x00052177b0449a04UL;
   tf->codes[11867] = 0x00052189fcf66794UL;
   tf->codes[11868] = 0x000521902a0c035bUL;
   tf->codes[11869] = 0x0005219114481a6fUL;
   tf->codes[11870] = 0x000521b2eef77053UL;
   tf->codes[11871] = 0x000521bc8a6e62a5UL;
   tf->codes[11872] = 0x000521dc5616849cUL;
   tf->codes[11873] = 0x000521e457a44e8bUL;
   tf->codes[11874] = 0x000521f9d8286ce1UL;
   tf->codes[11875] = 0x0005220214453c95UL;
   tf->codes[11876] = 0x000522092b96ef70UL;
   tf->codes[11877] = 0x0005220c5f694036UL;
   tf->codes[11878] = 0x0005220dbec362d4UL;
   tf->codes[11879] = 0x0005220ea8ff79e8UL;
   tf->codes[11880] = 0x0005222b06464554UL;
   tf->codes[11881] = 0x000522396f78b0cfUL;
   tf->codes[11882] = 0x0005226ce72cc2f4UL;
   tf->codes[11883] = 0x000522810856beacUL;
   tf->codes[11884] = 0x00052284019a09adUL;
   tf->codes[11885] = 0x0005228ade5cb6c3UL;
   tf->codes[11886] = 0x0005229688dadd02UL;
   tf->codes[11887] = 0x000522977316f416UL;
   tf->codes[11888] = 0x000522b111a97a46UL;
   tf->codes[11889] = 0x000522b68f1204beUL;
   tf->codes[11890] = 0x000522c09fa7029aUL;
   tf->codes[11891] = 0x000522eb2b9133bcUL;
   tf->codes[11892] = 0x000522f5b1443d22UL;
   tf->codes[11893] = 0x000522f7fada76d4UL;
   tf->codes[11894] = 0x000522fd3db3fb87UL;
   tf->codes[11895] = 0x00052315b77b64deUL;
   tf->codes[11896] = 0x0005232c5ccaa00dUL;
   tf->codes[11897] = 0x000523392c13e325UL;
   tf->codes[11898] = 0x0005233c25572e26UL;
   tf->codes[11899] = 0x0005233d84b150c4UL;
   tf->codes[11900] = 0x0005233dbf405689UL;
   tf->codes[11901] = 0x000523596cda10a6UL;
   tf->codes[11902] = 0x0005236b446dd2acUL;
   tf->codes[11903] = 0x00052370fc6562e9UL;
   tf->codes[11904] = 0x00052389eb4ad7caUL;
   tf->codes[11905] = 0x000523929c85b308UL;
   tf->codes[11906] = 0x000523be12abfb3eUL;
   tf->codes[11907] = 0x000523d18428e5a7UL;
   tf->codes[11908] = 0x000523d3cdbf1f59UL;
   tf->codes[11909] = 0x000523e4bb16ca4bUL;
   tf->codes[11910] = 0x000523e913b437eaUL;
   tf->codes[11911] = 0x000523e9fdf04efeUL;
   tf->codes[11912] = 0x000523eaad9d604dUL;
   tf->codes[11913] = 0x00052408a4cd541cUL;
   tf->codes[11914] = 0x0005240fbc1f06f7UL;
   tf->codes[11915] = 0x00052410e0ea23d0UL;
   tf->codes[11916] = 0x0005242dedde008bUL;
   tf->codes[11917] = 0x0005243df0f99469UL;
   tf->codes[11918] = 0x0005244b3560e30bUL;
   tf->codes[11919] = 0x0005244d446816f8UL;
   tf->codes[11920] = 0x0005244fc88d566fUL;
   tf->codes[11921] = 0x00052476e6163106UL;
   tf->codes[11922] = 0x000524780ae14ddfUL;
   tf->codes[11923] = 0x00052478ba8e5f2eUL;
   tf->codes[11924] = 0x0005248256055180UL;
   tf->codes[11925] = 0x000524958cf33624UL;
   tf->codes[11926] = 0x000524b433d03b42UL;
   tf->codes[11927] = 0x000524bad603e293UL;
   tf->codes[11928] = 0x000524d9f1fef33bUL;
   tf->codes[11929] = 0x000524e31857da03UL;
   tf->codes[11930] = 0x000524e6119b2504UL;
   tf->codes[11931] = 0x000524f0d1dd342fUL;
   tf->codes[11932] = 0x00052508d68691fcUL;
   tf->codes[11933] = 0x0005250bcfc9dcfdUL;
   tf->codes[11934] = 0x0005250d69b30560UL;
   tf->codes[11935] = 0x0005254031ba0636UL;
   tf->codes[11936] = 0x000525444fc86e10UL;
   tf->codes[11937] = 0x0005254e25ce6627UL;
   tf->codes[11938] = 0x0005256db6e78259UL;
   tf->codes[11939] = 0x0005256e669493a8UL;
   tf->codes[11940] = 0x0005257e2f2121c1UL;
   tf->codes[11941] = 0x00052590f0f0fadbUL;
   tf->codes[11942] = 0x000525933a87348dUL;
   tf->codes[11943] = 0x00052598b7efbf05UL;
   tf->codes[11944] = 0x000525ceb3c910a1UL;
   tf->codes[11945] = 0x000525dd921987a6UL;
   tf->codes[11946] = 0x000525f13e2577d4UL;
   tf->codes[11947] = 0x000525f9ef605312UL;
   tf->codes[11948] = 0x0005260faa73772dUL;
   tf->codes[11949] = 0x000526140310e4ccUL;
   tf->codes[11950] = 0x0005263911928b76UL;
   tf->codes[11951] = 0x0005263d6a2ff915UL;
   tf->codes[11952] = 0x0005264446f2a62bUL;
   tf->codes[11953] = 0x0005264989cc2adeUL;
   tf->codes[11954] = 0x0005264c4880701aUL;
   tf->codes[11955] = 0x000526535fd222f5UL;
   tf->codes[11956] = 0x00052657b86f9094UL;
   tf->codes[11957] = 0x0005265e5aa337e5UL;
   tf->codes[11958] = 0x00052665e712f64aUL;
   tf->codes[11959] = 0x0005266d7382b4afUL;
   tf->codes[11960] = 0x0005267d3c0f42c8UL;
   tf->codes[11961] = 0x0005269b6dce3c5cUL;
   tf->codes[11962] = 0x0005269e6711875dUL;
   tf->codes[11963] = 0x000526b0b3c354edUL;
   tf->codes[11964] = 0x000526b5f69cd9a0UL;
   tf->codes[11965] = 0x000526b87ac21917UL;
   tf->codes[11966] = 0x000526bd830c9805UL;
   tf->codes[11967] = 0x000526d462ead8f9UL;
   tf->codes[11968] = 0x000526d5fcd4015cUL;
   tf->codes[11969] = 0x000526d9e0536371UL;
   tf->codes[11970] = 0x000526df984af3aeUL;
   tf->codes[11971] = 0x000526e3413b4ffeUL;
   tf->codes[11972] = 0x000526e3b6595b88UL;
   tf->codes[11973] = 0x000526e8bea3da76UL;
   tf->codes[11974] = 0x000526eb083a1428UL;
   tf->codes[11975] = 0x000526ef9b66878cUL;
   tf->codes[11976] = 0x000527172e0d6dadUL;
   tf->codes[11977] = 0x00052719b232ad24UL;
   tf->codes[11978] = 0x0005271d209403afUL;
   tf->codes[11979] = 0x00052736f9b58fa4UL;
   tf->codes[11980] = 0x0005275182842ce8UL;
   tf->codes[11981] = 0x0005275899d5dfc3UL;
   tf->codes[11982] = 0x0005276026459e28UL;
   tf->codes[11983] = 0x00052777b5d0f06bUL;
   tf->codes[11984] = 0x000527802c7cc5e4UL;
   tf->codes[11985] = 0x00052785a9e5505cUL;
   tf->codes[11986] = 0x00052792ee4c9efeUL;
   tf->codes[11987] = 0x0005279328dba4c3UL;
   tf->codes[11988] = 0x00052794c2c4cd26UL;
   tf->codes[11989] = 0x000527bf4eaefe48UL;
   tf->codes[11990] = 0x000527c3322e605dUL;
   tf->codes[11991] = 0x000527d494a416d9UL;
   tf->codes[11992] = 0x000527e5476cbc06UL;
   tf->codes[11993] = 0x000527f2c663106dUL;
   tf->codes[11994] = 0x000527f54a884fe4UL;
   tf->codes[11995] = 0x000527f71f007e0cUL;
   tf->codes[11996] = 0x000527f843cb9ae5UL;
   tf->codes[11997] = 0x000527f96896b7beUL;
   tf->codes[11998] = 0x000527feab703c71UL;
   tf->codes[11999] = 0x0005281ca2a03040UL;
   tf->codes[12000] = 0x00052836b650c1faUL;
   tf->codes[12001] = 0x0005283a24b21885UL;
   tf->codes[12002] = 0x0005284b1209c377UL;
   tf->codes[12003] = 0x0005285c39f0742eUL;
   tf->codes[12004] = 0x0005285c747f79f3UL;
   tf->codes[12005] = 0x0005286107abed57UL;
   tf->codes[12006] = 0x000528676f508ee3UL;
   tf->codes[12007] = 0x00052868ceaab181UL;
   tf->codes[12008] = 0x0005286b8d5ef6bdUL;
   tf->codes[12009] = 0x0005286cb22a1396UL;
   tf->codes[12010] = 0x0005286d9c662aaaUL;
   tf->codes[12011] = 0x00052878d1c6455fUL;
   tf->codes[12012] = 0x0005287ae0cd794cUL;
   tf->codes[12013] = 0x0005287f73f9ecb0UL;
   tf->codes[12014] = 0x0005287fae88f275UL;
   tf->codes[12015] = 0x00052898d7fd6d1bUL;
   tf->codes[12016] = 0x000528b709bc66afUL;
   tf->codes[12017] = 0x000528ca061b458eUL;
   tf->codes[12018] = 0x000528ca7b395118UL;
   tf->codes[12019] = 0x000528cb2ae66267UL;
   tf->codes[12020] = 0x000528cc4fb17f40UL;
   tf->codes[12021] = 0x000528cd39ed9654UL;
   tf->codes[12022] = 0x000528d11d6cf869UL;
   tf->codes[12023] = 0x000528dcc7eb1ea8UL;
   tf->codes[12024] = 0x000528e3a4adcbbeUL;
   tf->codes[12025] = 0x000528ff524785dbUL;
   tf->codes[12026] = 0x00052909d7fa8f41UL;
   tf->codes[12027] = 0x0005290b71e3b7a4UL;
   tf->codes[12028] = 0x0005290bac72bd69UL;
   tf->codes[12029] = 0x0005291547e9afbbUL;
   tf->codes[12030] = 0x0005293463e4c063UL;
   tf->codes[12031] = 0x000529396c2f3f51UL;
   tf->codes[12032] = 0x00052939a6be4516UL;
   tf->codes[12033] = 0x0005294d52ca3544UL;
   tf->codes[12034] = 0x0005294e02774693UL;
   tf->codes[12035] = 0x0005294f2742636cUL;
   tf->codes[12036] = 0x0005295e0592da71UL;
   tf->codes[12037] = 0x0005295f64ecfd0fUL;
   tf->codes[12038] = 0x0005296173f430fcUL;
   tf->codes[12039] = 0x000529681627d84dUL;
   tf->codes[12040] = 0x00052971b19eca9fUL;
   tf->codes[12041] = 0x00052971ec2dd064UL;
   tf->codes[12042] = 0x000529734b87f302UL;
   tf->codes[12043] = 0x00052973c0a5fe8cUL;
   tf->codes[12044] = 0x000529897bb922a7UL;
   tf->codes[12045] = 0x0005299560c64eabUL;
   tf->codes[12046] = 0x000529976fcd8298UL;
   tf->codes[12047] = 0x000529a3c9f8ba26UL;
   tf->codes[12048] = 0x000529bcb8de2f07UL;
   tf->codes[12049] = 0x000529be183851a5UL;
   tf->codes[12050] = 0x000529c5a4a8100aUL;
   tf->codes[12051] = 0x000529cbd1bdabd1UL;
   tf->codes[12052] = 0x000529dbd4d93fafUL;
   tf->codes[12053] = 0x000529edac6d01b5UL;
   tf->codes[12054] = 0x000529ede6fc077aUL;
   tf->codes[12055] = 0x000529ee218b0d3fUL;
   tf->codes[12056] = 0x000529f4fe4dba55UL;
   tf->codes[12057] = 0x000529fbdb10676bUL;
   tf->codes[12058] = 0x00052a0ba39cf584UL;
   tf->codes[12059] = 0x00052a1a475e66c4UL;
   tf->codes[12060] = 0x00052a34d02d0408UL;
   tf->codes[12061] = 0x00052a53770a0926UL;
   tf->codes[12062] = 0x00052a649ef0b9ddUL;
   tf->codes[12063] = 0x00052a64d97fbfa2UL;
   tf->codes[12064] = 0x00052a6638d9e240UL;
   tf->codes[12065] = 0x00052a6b7bb366f3UL;
   tf->codes[12066] = 0x00052a7cde291d6fUL;
   tf->codes[12067] = 0x00052a81e6739c5dUL;
   tf->codes[12068] = 0x00052a846a98dbd4UL;
   tf->codes[12069] = 0x00052ab4395c91a9UL;
   tf->codes[12070] = 0x00052ab473eb976eUL;
   tf->codes[12071] = 0x00052ac058f8c372UL;
   tf->codes[12072] = 0x00052ac267fff75fUL;
   tf->codes[12073] = 0x00052ad738d70466UL;
   tf->codes[12074] = 0x00052af14c879620UL;
   tf->codes[12075] = 0x00052b1c4d8fd2ccUL;
   tf->codes[12076] = 0x00052b3ffcb756d8UL;
   tf->codes[12077] = 0x00052b5f8dd0730aUL;
   tf->codes[12078] = 0x00052b73aefa6ec2UL;
   tf->codes[12079] = 0x00052b9ca0fb7781UL;
   tf->codes[12080] = 0x00052baeedad4511UL;
   tf->codes[12081] = 0x00052bc9eb99eddfUL;
   tf->codes[12082] = 0x00052bd93f08706eUL;
   tf->codes[12083] = 0x00052bdbfdbcb5aaUL;
   tf->codes[12084] = 0x00052bec75f65512UL;
   tf->codes[12085] = 0x00052bfaa499bac8UL;
   tf->codes[12086] = 0x00052c061488db42UL;
   tf->codes[12087] = 0x00052c0c070f7144UL;
   tf->codes[12088] = 0x00052c0da0f899a7UL;
   tf->codes[12089] = 0x00052c2cf782b014UL;
   tf->codes[12090] = 0x00052c2f0689e401UL;
   tf->codes[12091] = 0x00052c4411eff6cdUL;
   tf->codes[12092] = 0x00052c532acf7397UL;
   tf->codes[12093] = 0x00052c60a9c5c7feUL;
   tf->codes[12094] = 0x00052c771485fd68UL;
   tf->codes[12095] = 0x00052c7e6666b608UL;
   tf->codes[12096] = 0x00052c93373dc30fUL;
   tf->codes[12097] = 0x00052c949697e5adUL;
   tf->codes[12098] = 0x00052c9580d3fcc1UL;
   tf->codes[12099] = 0x00052c95bb630286UL;
   tf->codes[12100] = 0x00052c96e02e1f5fUL;
   tf->codes[12101] = 0x00052c9b38cb8cfeUL;
   tf->codes[12102] = 0x00052c9c9825af9cUL;
   tf->codes[12103] = 0x00052caac6c91552UL;
   tf->codes[12104] = 0x00052cba54c69da6UL;
   tf->codes[12105] = 0x00052cccdc0770fbUL;
   tf->codes[12106] = 0x00052d05969507d3UL;
   tf->codes[12107] = 0x00052d09b4a36fadUL;
   tf->codes[12108] = 0x00052d185864e0edUL;
   tf->codes[12109] = 0x00052d1adc8a2064UL;
   tf->codes[12110] = 0x00052d3405fe9b0aUL;
   tf->codes[12111] = 0x00052d3cf1c87c0dUL;
   tf->codes[12112] = 0x00052d4ae5dcdbfeUL;
   tf->codes[12113] = 0x00052d540c35c2c6UL;
   tf->codes[12114] = 0x00052d57efb524dbUL;
   tf->codes[12115] = 0x00052d640f5156a4UL;
   tf->codes[12116] = 0x00052d65341c737dUL;
   tf->codes[12117] = 0x00052d7621741e6fUL;
   tf->codes[12118] = 0x00052d7b29be9d5dUL;
   tf->codes[12119] = 0x00052d7dade3dcd4UL;
   tf->codes[12120] = 0x00052d96d758577aUL;
   tf->codes[12121] = 0x00052da69fe4e593UL;
   tf->codes[12122] = 0x00052db41edb39faUL;
   tf->codes[12123] = 0x00052dbc206903e9UL;
   tf->codes[12124] = 0x00052dbdf4e13211UL;
   tf->codes[12125] = 0x00052dc45c85d39dUL;
   tf->codes[12126] = 0x00052dc790582463UL;
   tf->codes[12127] = 0x00052dd45fa1677bUL;
   tf->codes[12128] = 0x00052dd5846c8454UL;
   tf->codes[12129] = 0x00052ddf1fe376a6UL;
   tf->codes[12130] = 0x00052dea1ab48b96UL;
   tf->codes[12131] = 0x00052dedc3a4e7e6UL;
   tf->codes[12132] = 0x00052df5ffc1b79aUL;
   tf->codes[12133] = 0x00052dfc2cd75361UL;
   tf->codes[12134] = 0x00052dff261a9e62UL;
   tf->codes[12135] = 0x00052e0f63c53805UL;
   tf->codes[12136] = 0x00052e313e748de9UL;
   tf->codes[12137] = 0x00052e42665b3ea0UL;
   tf->codes[12138] = 0x00052e468469a67aUL;
   tf->codes[12139] = 0x00052e4b179619deUL;
   tf->codes[12140] = 0x00052e4b8cb42568UL;
   tf->codes[12141] = 0x00052e5b8fcfb946UL;
   tf->codes[12142] = 0x00052e5e4e83fe82UL;
   tf->codes[12143] = 0x00052e76189e568aUL;
   tf->codes[12144] = 0x00052e7ddf9d1ab4UL;
   tf->codes[12145] = 0x00052e7f0468378dUL;
   tf->codes[12146] = 0x00052e8e9265bfe1UL;
   tf->codes[12147] = 0x00052e8f0783cb6bUL;
   tf->codes[12148] = 0x00052e9066ddee09UL;
   tf->codes[12149] = 0x00052e9534996732UL;
   tf->codes[12150] = 0x00052e9a3ce3e620UL;
   tf->codes[12151] = 0x00052ec8372f6dcdUL;
   tf->codes[12152] = 0x00052ed122f94ed0UL;
   tf->codes[12153] = 0x00052edba8ac5836UL;
   tf->codes[12154] = 0x00052ee5099444c3UL;
   tf->codes[12155] = 0x00052ee802d78fc4UL;
   tf->codes[12156] = 0x00052ee96231b262UL;
   tf->codes[12157] = 0x00052ef0b4126b02UL;
   tf->codes[12158] = 0x00052efcd3ae9ccbUL;
   tf->codes[12159] = 0x00052f033b533e57UL;
   tf->codes[12160] = 0x00052f146339ef0eUL;
   tf->codes[12161] = 0x00052f175c7d3a0fUL;
   tf->codes[12162] = 0x00052f1acade909aUL;
   tf->codes[12163] = 0x00052f1b7a8ba1e9UL;
   tf->codes[12164] = 0x00052f2d17905e2aUL;
   tf->codes[12165] = 0x00052f49af662f5bUL;
   tf->codes[12166] = 0x00052f59b281c339UL;
   tf->codes[12167] = 0x00052f5bc188f726UL;
   tf->codes[12168] = 0x00052f5c36a702b0UL;
   tf->codes[12169] = 0x00052f6890d23a3eUL;
   tf->codes[12170] = 0x00052f6d23feada2UL;
   tf->codes[12171] = 0x00052f7aa2f50209UL;
   tf->codes[12172] = 0x00052f7cec8b3bbbUL;
   tf->codes[12173] = 0x00052f7e11565894UL;
   tf->codes[12174] = 0x00052f9c43155228UL;
   tf->codes[12175] = 0x00052fb70672f531UL;
   tf->codes[12176] = 0x00052fcde6513625UL;
   tf->codes[12177] = 0x00052fd2ee9bb513UL;
   tf->codes[12178] = 0x00052fd70caa1cedUL;
   tf->codes[12179] = 0x00052fee271763a6UL;
   tf->codes[12180] = 0x0005300c936562ffUL;
   tf->codes[12181] = 0x0005300f178aa276UL;
   tf->codes[12182] = 0x0005301c5bf1f118UL;
   tf->codes[12183] = 0x0005303251941af8UL;
   tf->codes[12184] = 0x000530433eebc5eaUL;
   tf->codes[12185] = 0x00053045c3110561UL;
   tf->codes[12186] = 0x0005304acb5b844fUL;
   tf->codes[12187] = 0x0005305048c40ec7UL;
   tf->codes[12188] = 0x0005305600bb9f04UL;
   tf->codes[12189] = 0x0005305d529c57a4UL;
   tf->codes[12190] = 0x0005306678f53e6cUL;
   tf->codes[12191] = 0x00053067d84f610aUL;
   tf->codes[12192] = 0x0005306b46b0b795UL;
   tf->codes[12193] = 0x0005306e0564fcd1UL;
   tf->codes[12194] = 0x000530867f2c6628UL;
   tf->codes[12195] = 0x0005308ef5d83ba1UL;
   tf->codes[12196] = 0x000530c023f61414UL;
   tf->codes[12197] = 0x000530d02711a7f2UL;
   tf->codes[12198] = 0x000530df3ff124bcUL;
   tf->codes[12199] = 0x000530f0a266db38UL;
   tf->codes[12200] = 0x000530f3268c1aafUL;
   tf->codes[12201] = 0x000530f98e30bc3bUL;
   tf->codes[12202] = 0x000530fff5d55dc7UL;
   tf->codes[12203] = 0x0005310de9e9bdb8UL;
   tf->codes[12204] = 0x0005313e685a84dcUL;
   tf->codes[12205] = 0x000531433615fe05UL;
   tf->codes[12206] = 0x000531457fac37b7UL;
   tf->codes[12207] = 0x0005314ac285bc6aUL;
   tf->codes[12208] = 0x000531554838c5d0UL;
   tf->codes[12209] = 0x00053158b69a1c5bUL;
   tf->codes[12210] = 0x0005315c5f8a78abUL;
   tf->codes[12211] = 0x0005316eac3c463bUL;
   tf->codes[12212] = 0x00053171306185b2UL;
   tf->codes[12213] = 0x0005317d156eb1b6UL;
   tf->codes[12214] = 0x000531842cc06491UL;
   tf->codes[12215] = 0x0005318a59d60058UL;
   tf->codes[12216] = 0x00053191abb6b8f8UL;
   tf->codes[12217] = 0x000531979e3d4efaUL;
   tf->codes[12218] = 0x000531aad52b339eUL;
   tf->codes[12219] = 0x000531b05293be16UL;
   tf->codes[12220] = 0x000531bce74dfb69UL;
   tf->codes[12221] = 0x000531bef6552f56UL;
   tf->codes[12222] = 0x000531d267d219bfUL;
   tf->codes[12223] = 0x000531d5d633704aUL;
   tf->codes[12224] = 0x000531d8cf76bb4bUL;
   tf->codes[12225] = 0x000531ef3a36f0b5UL;
   tf->codes[12226] = 0x000531f616f99dcbUL;
   tf->codes[12227] = 0x000531f6c6a6af1aUL;
   tf->codes[12228] = 0x00053215e2a1bfc2UL;
   tf->codes[12229] = 0x000532306b705d06UL;
   tf->codes[12230] = 0x000532453c476a0dUL;
   tf->codes[12231] = 0x0005324c53991ce8UL;
   tf->codes[12232] = 0x0005324d786439c1UL;
   tf->codes[12233] = 0x000532595d7165c5UL;
   tf->codes[12234] = 0x00053260e9e1242aUL;
   tf->codes[12235] = 0x000532615eff2fb4UL;
   tf->codes[12236] = 0x000532687650e28fUL;
   tf->codes[12237] = 0x00053273e6400309UL;
   tf->codes[12238] = 0x0005327afd91b5e4UL;
   tf->codes[12239] = 0x0005327fcb4d2f0dUL;
   tf->codes[12240] = 0x000532bdc8b44a98UL;
   tf->codes[12241] = 0x000532c0fc869b5eUL;
   tf->codes[12242] = 0x000532c25be0bdfcUL;
   tf->codes[12243] = 0x000532d9764e04b5UL;
   tf->codes[12244] = 0x000532e22788dff3UL;
   tf->codes[12245] = 0x000532e81a0f75f5UL;
   tf->codes[12246] = 0x000532ebc2ffd245UL;
   tf->codes[12247] = 0x000532f60e23d5e6UL;
   tf->codes[12248] = 0x000532fa2c323dc0UL;
   tf->codes[12249] = 0x0005330b8ea7f43cUL;
   tf->codes[12250] = 0x00053310d18178efUL;
   tf->codes[12251] = 0x000533182362318fUL;
   tf->codes[12252] = 0x00053336ca3f36adUL;
   tf->codes[12253] = 0x0005333aadbe98c2UL;
   tf->codes[12254] = 0x000533440ea6854fUL;
   tf->codes[12255] = 0x00053344be53969eUL;
   tf->codes[12256] = 0x00053346583cbf01UL;
   tf->codes[12257] = 0x0005334f09779a3fUL;
   tf->codes[12258] = 0x000533565b5852dfUL;
   tf->codes[12259] = 0x0005336240657ee3UL;
   tf->codes[12260] = 0x0005336489fbb895UL;
   tf->codes[12261] = 0x00053375023557fdUL;
   tf->codes[12262] = 0x0005337e288e3ec5UL;
   tf->codes[12263] = 0x00053388e8d04df0UL;
   tf->codes[12264] = 0x0005338c91c0aa40UL;
   tf->codes[12265] = 0x0005339667c6a257UL;
   tf->codes[12266] = 0x0005339a10b6fea7UL;
   tf->codes[12267] = 0x0005339b70112145UL;
   tf->codes[12268] = 0x0005339e69546c46UL;
   tf->codes[12269] = 0x000533ad47a4e34bUL;
   tf->codes[12270] = 0x000533b583c1b2ffUL;
   tf->codes[12271] = 0x000533c2187bf052UL;
   tf->codes[12272] = 0x000533c720c66f40UL;
   tf->codes[12273] = 0x000533db07616533UL;
   tf->codes[12274] = 0x000533ea5acfe7c2UL;
   tf->codes[12275] = 0x000533ebf4b91025UL;
   tf->codes[12276] = 0x000533f296ecb776UL;
   tf->codes[12277] = 0x000533f4e082f128UL;
   tf->codes[12278] = 0x0005340bc061321cUL;
   tf->codes[12279] = 0x00053410c8abb10aUL;
   tf->codes[12280] = 0x00053412d7b2e4f7UL;
   tf->codes[12281] = 0x0005342adc5c42c4UL;
   tf->codes[12282] = 0x0005343686da6903UL;
   tf->codes[12283] = 0x00053449f857536cUL;
   tf->codes[12284] = 0x000534509a8afabdUL;
   tf->codes[12285] = 0x0005345393ce45beUL;
   tf->codes[12286] = 0x000534598654dbc0UL;
   tf->codes[12287] = 0x0005345fb36a7787UL;
   tf->codes[12288] = 0x00053462721ebcc3UL;
   tf->codes[12289] = 0x0005346cf7d1c629UL;
   tf->codes[12290] = 0x00053475e39ba72cUL;
   tf->codes[12291] = 0x000534769348b87bUL;
   tf->codes[12292] = 0x0005347a76c81a90UL;
   tf->codes[12293] = 0x0005348b9eaecb47UL;
   tf->codes[12294] = 0x000534ac54930452UL;
   tf->codes[12295] = 0x000534bbe2908ca6UL;
   tf->codes[12296] = 0x000534bccccca3baUL;
   tf->codes[12297] = 0x000534c6a2d29bd1UL;
   tf->codes[12298] = 0x000534de325dee14UL;
   tf->codes[12299] = 0x000534dee20aff63UL;
   tf->codes[12300] = 0x000534f04480b5dfUL;
   tf->codes[12301] = 0x0005350b7cfc6472UL;
   tf->codes[12302] = 0x0005351f9e26602aUL;
   tf->codes[12303] = 0x00053537dd5ec3bcUL;
   tf->codes[12304] = 0x0005353bfb6d2b96UL;
   tf->codes[12305] = 0x0005353c708b3720UL;
   tf->codes[12306] = 0x000535408e999efaUL;
   tf->codes[12307] = 0x000535493fd47a38UL;
   tf->codes[12308] = 0x0005354a649f9711UL;
   tf->codes[12309] = 0x0005354bc3f9b9afUL;
   tf->codes[12310] = 0x0005354c73a6cafeUL;
   tf->codes[12311] = 0x000535576e77dfeeUL;
   tf->codes[12312] = 0x0005356ceefbfe44UL;
   tf->codes[12313] = 0x000535790e98300dUL;
   tf->codes[12314] = 0x00053584f3a55c11UL;
   tf->codes[12315] = 0x00053593d1f5d316UL;
   tf->codes[12316] = 0x0005359705c823dcUL;
   tf->codes[12317] = 0x0005359e9237e241UL;
   tf->codes[12318] = 0x000535a8dd5be5e2UL;
   tf->codes[12319] = 0x000535bb9f2bbefcUL;
   tf->codes[12320] = 0x000535c415d79475UL;
   tf->codes[12321] = 0x000535cab80b3bc6UL;
   tf->codes[12322] = 0x000535d11fafdd52UL;
   tf->codes[12323] = 0x000535d9d0eab890UL;
   tf->codes[12324] = 0x000535e15d5a76f5UL;
   tf->codes[12325] = 0x000535ec582b8be5UL;
   tf->codes[12326] = 0x000536066bdc1d9fUL;
   tf->codes[12327] = 0x0005360e6d69e78eUL;
   tf->codes[12328] = 0x0005362bef7bcfd3UL;
   tf->codes[12329] = 0x0005363b085b4c9dUL;
   tf->codes[12330] = 0x0005363b7d795827UL;
   tf->codes[12331] = 0x0005363cdcd37ac5UL;
   tf->codes[12332] = 0x000536442eb43365UL;
   tf->codes[12333] = 0x000536538222b5f4UL;
   tf->codes[12334] = 0x0005365eb782d0a9UL;
   tf->codes[12335] = 0x0005366f6a4b75d6UL;
   tf->codes[12336] = 0x000536734dcad7ebUL;
   tf->codes[12337] = 0x0005367d23d0d002UL;
   tf->codes[12338] = 0x0005369e4ed31497UL;
   tf->codes[12339] = 0x000536d4fa597782UL;
   tf->codes[12340] = 0x000536d56f77830cUL;
   tf->codes[12341] = 0x000536ecc473cf8aUL;
   tf->codes[12342] = 0x000536ee98ebfdb2UL;
   tf->codes[12343] = 0x00053700707fbfb8UL;
   tf->codes[12344] = 0x00053718afb8234aUL;
   tf->codes[12345] = 0x000537275379948aUL;
   tf->codes[12346] = 0x00053746aa03aaf7UL;
   tf->codes[12347] = 0x00053751df63c5acUL;
   tf->codes[12348] = 0x00053776b3566691UL;
   tf->codes[12349] = 0x0005378b499e6dd3UL;
   tf->codes[12350] = 0x0005378ce3879636UL;
   tf->codes[12351] = 0x0005378fa23bdb72UL;
   tf->codes[12352] = 0x0005378fdccae137UL;
   tf->codes[12353] = 0x000537910195fe10UL;
   tf->codes[12354] = 0x000537934b2c37c2UL;
   tf->codes[12355] = 0x000537b68535b044UL;
   tf->codes[12356] = 0x000537b8943ce431UL;
   tf->codes[12357] = 0x000537ca6bd0a637UL;
   tf->codes[12358] = 0x000537e320271553UL;
   tf->codes[12359] = 0x000537ecbb9e07a5UL;
   tf->codes[12360] = 0x000537f0d9ac6f7fUL;
   tf->codes[12361] = 0x000538098e02de9bUL;
   tf->codes[12362] = 0x0005380cfc643526UL;
   tf->codes[12363] = 0x0005381a40cb83c8UL;
   tf->codes[12364] = 0x0005381ab5e98f52UL;
   tf->codes[12365] = 0x0005383837fb7797UL;
   tf->codes[12366] = 0x0005383ba65cce22UL;
   tf->codes[12367] = 0x0005385bac93f5deUL;
   tf->codes[12368] = 0x0005385d467d1e41UL;
   tf->codes[12369] = 0x0005386a5055671eUL;
   tf->codes[12370] = 0x00053887d2674f63UL;
   tf->codes[12371] = 0x00053888bca36677UL;
   tf->codes[12372] = 0x0005389e3d2784cdUL;
   tf->codes[12373] = 0x000538ad9096075cUL;
   tf->codes[12374] = 0x000538c5953f6529UL;
   tf->codes[12375] = 0x000538d7e1f132b9UL;
   tf->codes[12376] = 0x000538dd5f59bd31UL;
   tf->codes[12377] = 0x000538ecb2c83fc0UL;
   tf->codes[12378] = 0x0005390f3d24a6f3UL;
   tf->codes[12379] = 0x00053914ba8d316bUL;
   tf->codes[12380] = 0x00053919c2d7b059UL;
   tf->codes[12381] = 0x00053949cc2a6bf3UL;
   tf->codes[12382] = 0x0005394c504fab6aUL;
   tf->codes[12383] = 0x000539519329301dUL;
   tf->codes[12384] = 0x000539569b73af0bUL;
   tf->codes[12385] = 0x0005395785afc61fUL;
   tf->codes[12386] = 0x0005397abfb93ea1UL;
   tf->codes[12387] = 0x0005397e68a99af1UL;
   tf->codes[12388] = 0x000539857ffb4dccUL;
   tf->codes[12389] = 0x00053997921e1597UL;
   tf->codes[12390] = 0x0005399ac5f0665dUL;
   tf->codes[12391] = 0x0005399d0f86a00fUL;
   tf->codes[12392] = 0x000539b5142ffddcUL;
   tf->codes[12393] = 0x000539bb06b693deUL;
   tf->codes[12394] = 0x000539bbb663a52dUL;
   tf->codes[12395] = 0x000539c1a8ea3b2fUL;
   tf->codes[12396] = 0x000539d0121ca6aaUL;
   tf->codes[12397] = 0x000539d84e39765eUL;
   tf->codes[12398] = 0x000539e8c67315c6UL;
   tf->codes[12399] = 0x000539ee7e6aa603UL;
   tf->codes[12400] = 0x000539f67ff86ff2UL;
   tf->codes[12401] = 0x00053a10ce380771UL;
   tf->codes[12402] = 0x00053a1b53eb10d7UL;
   tf->codes[12403] = 0x00053a2aa7599366UL;
   tf->codes[12404] = 0x00053a3ec8838f1eUL;
   tf->codes[12405] = 0x00053a435bb00282UL;
   tf->codes[12406] = 0x00053a440b5d13d1UL;
   tf->codes[12407] = 0x00053a59c67037ecUL;
   tf->codes[12408] = 0x00053a618d6efc16UL;
   tf->codes[12409] = 0x00053a887068d0e8UL;
   tf->codes[12410] = 0x00053a92bb8cd489UL;
   tf->codes[12411] = 0x00053a95b4d01f8aUL;
   tf->codes[12412] = 0x00053a9b6cc7afc7UL;
   tf->codes[12413] = 0x00053a9d7bcee3b4UL;
   tf->codes[12414] = 0x00053aab6fe343a5UL;
   tf->codes[12415] = 0x00053ab336e207cfUL;
   tf->codes[12416] = 0x00053ab78f7f756eUL;
   tf->codes[12417] = 0x00053abfcb9c4522UL;
   tf->codes[12418] = 0x00053ac2c4df9023UL;
   tf->codes[12419] = 0x00053ac92c8431afUL;
   tf->codes[12420] = 0x00053accd5748dffUL;
   tf->codes[12421] = 0x00053ad511915db3UL;
   tf->codes[12422] = 0x00053ada546ae266UL;
   tf->codes[12423] = 0x00053ae67407142fUL;
   tf->codes[12424] = 0x00053af5c77596beUL;
   tf->codes[12425] = 0x00053b2e477427d1UL;
   tf->codes[12426] = 0x00053b2fa6ce4a6fUL;
   tf->codes[12427] = 0x00053b4895b3bf50UL;
   tf->codes[12428] = 0x00053b552a6dfca3UL;
   tf->codes[12429] = 0x00053b5b92129e2fUL;
   tf->codes[12430] = 0x00053b71c243cdd4UL;
   tf->codes[12431] = 0x00053b7271f0df23UL;
   tf->codes[12432] = 0x00053b7d6cc1f413UL;
   tf->codes[12433] = 0x00053b8066053f14UL;
   tf->codes[12434] = 0x00053b8e1f8a9940UL;
   tf->codes[12435] = 0x00053b8ff402c768UL;
   tf->codes[12436] = 0x00053bc122209fdbUL;
   tf->codes[12437] = 0x00053bce2bf8e8b8UL;
   tf->codes[12438] = 0x00053bdf8e6e9f34UL;
   tf->codes[12439] = 0x00053bf66e4ce028UL;
   tf->codes[12440] = 0x00053bf9a21f30eeUL;
   tf->codes[12441] = 0x00053bfdfabc9e8dUL;
   tf->codes[12442] = 0x00053c0303071d7bUL;
   tf->codes[12443] = 0x00053c13b5cfc2a8UL;
   tf->codes[12444] = 0x00053c1eb0a0d798UL;
   tf->codes[12445] = 0x00053c37da15523eUL;
   tf->codes[12446] = 0x00053c413afd3ecbUL;
   tf->codes[12447] = 0x00053c430f756cf3UL;
   tf->codes[12448] = 0x00053c59051796d3UL;
   tf->codes[12449] = 0x00053c593fa69c98UL;
   tf->codes[12450] = 0x00053c61f0e177d6UL;
   tf->codes[12451] = 0x00053c638acaa039UL;
   tf->codes[12452] = 0x00053c72a3aa1d03UL;
   tf->codes[12453] = 0x00053c7a6aa8e12dUL;
   tf->codes[12454] = 0x00053c8983885df7UL;
   tf->codes[12455] = 0x00053c8c423ca333UL;
   tf->codes[12456] = 0x00053c9ae5fe1473UL;
   tf->codes[12457] = 0x00053cb4f9aea62dUL;
   tf->codes[12458] = 0x00053cb9524c13ccUL;
   tf->codes[12459] = 0x00053ccff79b4efbUL;
   tf->codes[12460] = 0x00053ce78726a13eUL;
   tf->codes[12461] = 0x00053cf62ae8127eUL;
   tf->codes[12462] = 0x00053d0b364e254aUL;
   tf->codes[12463] = 0x00053d0dba7364c1UL;
   tf->codes[12464] = 0x00053d16a63d45c4UL;
   tf->codes[12465] = 0x00053d3bef4df233UL;
   tf->codes[12466] = 0x00053d3e737331aaUL;
   tf->codes[12467] = 0x00053d71eb2743cfUL;
   tf->codes[12468] = 0x00053d7a27441383UL;
   tf->codes[12469] = 0x00053d7eba7086e7UL;
   tf->codes[12470] = 0x00053d881b587374UL;
   tf->codes[12471] = 0x00053d943af4a53dUL;
   tf->codes[12472] = 0x00053dae14163132UL;
   tf->codes[12473] = 0x00053db4412bccf9UL;
   tf->codes[12474] = 0x00053dbae35f744aUL;
   tf->codes[12475] = 0x00053dd272eac68dUL;
   tf->codes[12476] = 0x00053dd6cb88342cUL;
   tf->codes[12477] = 0x00053dedab667520UL;
   tf->codes[12478] = 0x00053df1c974dcfaUL;
   tf->codes[12479] = 0x00053dfbda09dad6UL;
   tf->codes[12480] = 0x00053e0cc76185c8UL;
   tf->codes[12481] = 0x00053e0d3c7f9152UL;
   tf->codes[12482] = 0x00053e1f14135358UL;
   tf->codes[12483] = 0x00053e4790f6508dUL;
   tf->codes[12484] = 0x00053e492adf78f0UL;
   tf->codes[12485] = 0x00053e6e73f0255fUL;
   tf->codes[12486] = 0x00053e7f26b8ca8cUL;
   tf->codes[12487] = 0x00053e8469924f3fUL;
   tf->codes[12488] = 0x00053e8ce03e24b8UL;
   tf->codes[12489] = 0x00053ebfa845258eUL;
   tf->codes[12490] = 0x00053ed26a14fea8UL;
   tf->codes[12491] = 0x00053ed7acee835bUL;
   tf->codes[12492] = 0x00053edc401af6bfUL;
   tf->codes[12493] = 0x00053eea6ebe5c75UL;
   tf->codes[12494] = 0x00053ef31ff937b3UL;
   tf->codes[12495] = 0x00053ef8d7f0c7f0UL;
   tf->codes[12496] = 0x00053ef9879dd93fUL;
   tf->codes[12497] = 0x00053f08db0c5bceUL;
   tf->codes[12498] = 0x00053f0da8c7d4f7UL;
   tf->codes[12499] = 0x00053f1117292b82UL;
   tf->codes[12500] = 0x00053f4abbf2d96eUL;
   tf->codes[12501] = 0x00053f58ea963f24UL;
   tf->codes[12502] = 0x00053f86aa52c10cUL;
   tf->codes[12503] = 0x00053f9b060bc289UL;
   tf->codes[12504] = 0x00053f9bf047d99dUL;
   tf->codes[12505] = 0x00053fb170cbf7f3UL;
   tf->codes[12506] = 0x00053fc089ab74bdUL;
   tf->codes[12507] = 0x00053fc13958860cUL;
   tf->codes[12508] = 0x00053fc3485fb9f9UL;
   tf->codes[12509] = 0x00053fdcac633a64UL;
   tf->codes[12510] = 0x00053feadb06a01aUL;
   tf->codes[12511] = 0x00053feb8ab3b169UL;
   tf->codes[12512] = 0x00053febffd1bcf3UL;
   tf->codes[12513] = 0x00053ff5262aa3bbUL;
   tf->codes[12514] = 0x00053ff97ec8115aUL;
   tf->codes[12515] = 0x0005400c0608e4afUL;
   tf->codes[12516] = 0x0005400fe98846c4UL;
   tf->codes[12517] = 0x0005401700d9f99fUL;
   tf->codes[12518] = 0x0005401f7785cf18UL;
   tf->codes[12519] = 0x000540309f6c7fcfUL;
   tf->codes[12520] = 0x000540382bdc3e34UL;
   tf->codes[12521] = 0x0005404c87953fb1UL;
   tf->codes[12522] = 0x0005408cce9294eeUL;
   tf->codes[12523] = 0x00054090b211f703UL;
   tf->codes[12524] = 0x00054095f4eb7bb6UL;
   tf->codes[12525] = 0x000540b75a7cc610UL;
   tf->codes[12526] = 0x000540b7cf9ad19aUL;
   tf->codes[12527] = 0x000540eb0cbfddfaUL;
   tf->codes[12528] = 0x000540f3f889befdUL;
   tf->codes[12529] = 0x000540f43318c4c2UL;
   tf->codes[12530] = 0x000540f4e2c5d611UL;
   tf->codes[12531] = 0x000540f72c5c0fc3UL;
   tf->codes[12532] = 0x0005410a6349f467UL;
   tf->codes[12533] = 0x0005411e0f55e495UL;
   tf->codes[12534] = 0x0005411f6eb00733UL;
   tf->codes[12535] = 0x000541290a26f985UL;
   tf->codes[12536] = 0x0005412efcad8f87UL;
   tf->codes[12537] = 0x0005413f3a58292aUL;
   tf->codes[12538] = 0x0005414dde199a6aUL;
   tf->codes[12539] = 0x0005414f02e4b743UL;
   tf->codes[12540] = 0x00054176206d91daUL;
   tf->codes[12541] = 0x00054188a7ae652fUL;
   tf->codes[12542] = 0x0005419710e0d0aaUL;
   tf->codes[12543] = 0x000541974b6fd66fUL;
   tf->codes[12544] = 0x000541aaf77bc69dUL;
   tf->codes[12545] = 0x000541bb35266040UL;
   tf->codes[12546] = 0x000541be68f8b106UL;
   tf->codes[12547] = 0x000541ca8894e2cfUL;
   tf->codes[12548] = 0x000541ccd22b1c81UL;
   tf->codes[12549] = 0x000541d24f93a6f9UL;
   tf->codes[12550] = 0x000541d4d3b8e670UL;
   tf->codes[12551] = 0x000541d5bdf4fd84UL;
   tf->codes[12552] = 0x000541e7d017c54fUL;
   tf->codes[12553] = 0x000542063c65c4a8UL;
   tf->codes[12554] = 0x00054210126bbcbfUL;
   tf->codes[12555] = 0x00054210fca7d3d3UL;
   tf->codes[12556] = 0x00054216b49f6410UL;
   tf->codes[12557] = 0x00054236bad68bccUL;
   tf->codes[12558] = 0x0005423ce7ec2793UL;
   tf->codes[12559] = 0x0005424c00cba45dUL;
   tf->codes[12560] = 0x00054266feb84d2bUL;
   tf->codes[12561] = 0x0005427c0a1e5ff7UL;
   tf->codes[12562] = 0x0005427d69788295UL;
   tf->codes[12563] = 0x0005428c47c8f99aUL;
   tf->codes[12564] = 0x0005428fb62a5025UL;
   tf->codes[12565] = 0x0005429bd5c681eeUL;
   tf->codes[12566] = 0x0005429c105587b3UL;
   tf->codes[12567] = 0x000542a745b5a268UL;
   tf->codes[12568] = 0x000542ae22784f7eUL;
   tf->codes[12569] = 0x000542ba07857b82UL;
   tf->codes[12570] = 0x000542bb66df9e20UL;
   tf->codes[12571] = 0x000542c870b7e6fdUL;
   tf->codes[12572] = 0x000542ce9dcd82c4UL;
   tf->codes[12573] = 0x000542d7feb56f51UL;
   tf->codes[12574] = 0x000542de665a10ddUL;
   tf->codes[12575] = 0x000542e0ea7f5054UL;
   tf->codes[12576] = 0x000542e9d6493157UL;
   tf->codes[12577] = 0x000542ed7f398da7UL;
   tf->codes[12578] = 0x000542ef53b1bbcfUL;
   tf->codes[12579] = 0x00054308b7b53c3aUL;
   tf->codes[12580] = 0x0005430bb0f8873bUL;
   tf->codes[12581] = 0x0005434012e8b074UL;
   tf->codes[12582] = 0x000543546ea1b1f1UL;
   tf->codes[12583] = 0x0005437ceb84af26UL;
   tf->codes[12584] = 0x00054385d74e9029UL;
   tf->codes[12585] = 0x0005439097909f54UL;
   tf->codes[12586] = 0x000543947b100169UL;
   tf->codes[12587] = 0x000543985e8f637eUL;
   tf->codes[12588] = 0x000543b4f66534afUL;
   tf->codes[12589] = 0x000543b6cadd62d7UL;
   tf->codes[12590] = 0x000543c02bc54f64UL;
   tf->codes[12591] = 0x000543c48462bd03UL;
   tf->codes[12592] = 0x000543ca76e95305UL;
   tf->codes[12593] = 0x000543d0de8df491UL;
   tf->codes[12594] = 0x000543d65bf67f09UL;
   tf->codes[12595] = 0x000543ddadd737a9UL;
   tf->codes[12596] = 0x000543ee609fdcd6UL;
   tf->codes[12597] = 0x0005440f8ba2216bUL;
   tf->codes[12598] = 0x000544120fc760e2UL;
   tf->codes[12599] = 0x00054413e43f8f0aUL;
   tf->codes[12600] = 0x000544141ece94cfUL;
   tf->codes[12601] = 0x000544407f30f419UL;
   tf->codes[12602] = 0x0005444c643e201dUL;
   tf->codes[12603] = 0x0005445bb7aca2acUL;
   tf->codes[12604] = 0x00054478c4a07f67UL;
   tf->codes[12605] = 0x000544990566ace8UL;
   tf->codes[12606] = 0x000544bbca5219e0UL;
   tf->codes[12607] = 0x000544c0980d9309UL;
   tf->codes[12608] = 0x000544c4b61bfae3UL;
   tf->codes[12609] = 0x000544e481c41cdaUL;
   tf->codes[12610] = 0x000544e61bad453dUL;
   tf->codes[12611] = 0x000544ecf86ff253UL;
   tf->codes[12612] = 0x00054510e2267c24UL;
   tf->codes[12613] = 0x00054515ea70fb12UL;
   tf->codes[12614] = 0x00054536dae439e2UL;
   tf->codes[12615] = 0x00054537ffaf56bbUL;
   tf->codes[12616] = 0x0005453d07f9d5a9UL;
   tf->codes[12617] = 0x0005454f1a1c9d74UL;
   tf->codes[12618] = 0x000545545cf62227UL;
   tf->codes[12619] = 0x0005455581c13f00UL;
   tf->codes[12620] = 0x00054566e436f57cUL;
   tf->codes[12621] = 0x0005456ee5c4bf6bUL;
   tf->codes[12622] = 0x0005456f9571d0baUL;
   tf->codes[12623] = 0x000545880f393a11UL;
   tf->codes[12624] = 0x0005458acded7f4dUL;
   tf->codes[12625] = 0x0005458dc730ca4eUL;
   tf->codes[12626] = 0x0005459a5beb07a1UL;
   tf->codes[12627] = 0x0005459e04db63f1UL;
   tf->codes[12628] = 0x0005459f29a680caUL;
   tf->codes[12629] = 0x000545abf8efc3e2UL;
   tf->codes[12630] = 0x000545c29e3eff11UL;
   tf->codes[12631] = 0x000545c6bc4d66ebUL;
   tf->codes[12632] = 0x000545ce48bd2550UL;
   tf->codes[12633] = 0x000545d17c8f7616UL;
   tf->codes[12634] = 0x000545d4b061c6dcUL;
   tf->codes[12635] = 0x000545de8667bef3UL;
   tf->codes[12636] = 0x000545e612d77d58UL;
   tf->codes[12637] = 0x000545e9bbc7d9a8UL;
   tf->codes[12638] = 0x000545ee898352d1UL;
   tf->codes[12639] = 0x000545f56645ffe7UL;
   tf->codes[12640] = 0x000545f5a0d505acUL;
   tf->codes[12641] = 0x000545fa6e907ed5UL;
   tf->codes[12642] = 0x000545fcf2b5be4cUL;
   tf->codes[12643] = 0x00054601c0713775UL;
   tf->codes[12644] = 0x000546068e2cb09eUL;
   tf->codes[12645] = 0x0005460f79f691a1UL;
   tf->codes[12646] = 0x0005463c4f76fc75UL;
   tf->codes[12647] = 0x0005464157c17b63UL;
   tf->codes[12648] = 0x000546453b40dd78UL;
   tf->codes[12649] = 0x0005464ab8a967f0UL;
   tf->codes[12650] = 0x00054658379fbc57UL;
   tf->codes[12651] = 0x0005466491caf3e5UL;
   tf->codes[12652] = 0x00054673aaaa70afUL;
   tf->codes[12653] = 0x00054690428041e0UL;
   tf->codes[12654] = 0x0005469759d1f4bbUL;
   tf->codes[12655] = 0x000546b4dbe3dd00UL;
   tf->codes[12656] = 0x000546c25ada3167UL;
   tf->codes[12657] = 0x000546ce7a766330UL;
   tf->codes[12658] = 0x000546d0c40c9ce2UL;
   tf->codes[12659] = 0x000546d766404433UL;
   tf->codes[12660] = 0x000546e29ba05ee8UL;
   tf->codes[12661] = 0x000546ed5be26e13UL;
   tf->codes[12662] = 0x00054708ceed226bUL;
   tf->codes[12663] = 0x0005470f3691c3f7UL;
   tf->codes[12664] = 0x00054712a4f31a82UL;
   tf->codes[12665] = 0x0005471a6bf1deacUL;
   tf->codes[12666] = 0x0005472d6850bd8bUL;
   tf->codes[12667] = 0x0005473de08a5cf3UL;
   tf->codes[12668] = 0x00054750a25a360dUL;
   tf->codes[12669] = 0x00054766d28b65b2UL;
   tf->codes[12670] = 0x00054767bcc77cc6UL;
   tf->codes[12671] = 0x0005476c4ff3f02aUL;
   tf->codes[12672] = 0x0005476f0ea83566UL;
   tf->codes[12673] = 0x00054773dc63ae8fUL;
   tf->codes[12674] = 0x0005477a7e9755e0UL;
   tf->codes[12675] = 0x0005478f14df5d22UL;
   tf->codes[12676] = 0x00054790e9578b4aUL;
   tf->codes[12677] = 0x00054792bdcfb972UL;
   tf->codes[12678] = 0x000547978b8b329bUL;
   tf->codes[12679] = 0x000547bf1e3218bcUL;
   tf->codes[12680] = 0x000547bf93502446UL;
   tf->codes[12681] = 0x000547c6aaa1d721UL;
   tf->codes[12682] = 0x000547cb785d504aUL;
   tf->codes[12683] = 0x000547cf214dac9aUL;
   tf->codes[12684] = 0x000547d379eb1a39UL;
   tf->codes[12685] = 0x000547df5ef8463dUL;
   tf->codes[12686] = 0x000547eeecf5ce91UL;
   tf->codes[12687] = 0x00054810c7a52475UL;
   tf->codes[12688] = 0x00054811775235c4UL;
   tf->codes[12689] = 0x00054813c0e86f76UL;
   tf->codes[12690] = 0x00054844ef0647e9UL;
   tf->codes[12691] = 0x000548485d679e74UL;
   tf->codes[12692] = 0x0005487448abf234UL;
   tf->codes[12693] = 0x000548798b8576e7UL;
   tf->codes[12694] = 0x000548870a7bcb4eUL;
   tf->codes[12695] = 0x0005489030d4b216UL;
   tf->codes[12696] = 0x000548aed7b1b734UL;
   tf->codes[12697] = 0x000548b0ac29e55cUL;
   tf->codes[12698] = 0x000548c5b78ff828UL;
   tf->codes[12699] = 0x000548cf8d95f03fUL;
   tf->codes[12700] = 0x000548eb00a0a497UL;
   tf->codes[12701] = 0x000548f33cbd744bUL;
   tf->codes[12702] = 0x000548f63600bf4cUL;
   tf->codes[12703] = 0x000548fa8e9e2cebUL;
   tf->codes[12704] = 0x000549121e297f2eUL;
   tf->codes[12705] = 0x0005492a22d2dcfbUL;
   tf->codes[12706] = 0x00054932997eb274UL;
   tf->codes[12707] = 0x00054933be49cf4dUL;
   tf->codes[12708] = 0x00054946458aa2a2UL;
   tf->codes[12709] = 0x000549476a55bf7bUL;
   tf->codes[12710] = 0x0005494d224d4fb8UL;
   tf->codes[12711] = 0x0005495b50f0b56eUL;
   tf->codes[12712] = 0x00054962a2d16e0eUL;
   tf->codes[12713] = 0x0005497c7bf2fa03UL;
   tf->codes[12714] = 0x0005497da0be16dcUL;
   tf->codes[12715] = 0x000549839344acdeUL;
   tf->codes[12716] = 0x000549c748a358a6UL;
   tf->codes[12717] = 0x000549ca07579de2UL;
   tf->codes[12718] = 0x000549ce256605bcUL;
   tf->codes[12719] = 0x000549f1d48d89c8UL;
   tf->codes[12720] = 0x000549f667b9fd2cUL;
   tf->codes[12721] = 0x000549f9d61b53b7UL;
   tf->codes[12722] = 0x000549fa85c86506UL;
   tf->codes[12723] = 0x00054a07ca2fb3a8UL;
   tf->codes[12724] = 0x00054a0f569f720dUL;
   tf->codes[12725] = 0x00054a19dc527b73UL;
   tf->codes[12726] = 0x00054a1c25e8b525UL;
   tf->codes[12727] = 0x00054a375e6463b8UL;
   tf->codes[12728] = 0x00054a3b41e3c5cdUL;
   tf->codes[12729] = 0x00054a3d8b79ff7fUL;
   tf->codes[12730] = 0x00054a77dff0bebaUL;
   tf->codes[12731] = 0x00054a831550d96fUL;
   tf->codes[12732] = 0x00054a9980110ed9UL;
   tf->codes[12733] = 0x00054ac2378311d3UL;
   tf->codes[12734] = 0x00054ac396dd3471UL;
   tf->codes[12735] = 0x00054ac82a09a7d5UL;
   tf->codes[12736] = 0x00054ac9fe81d5fdUL;
   tf->codes[12737] = 0x00054ad23a9ea5b1UL;
   tf->codes[12738] = 0x00054ad7f29635eeUL;
   tf->codes[12739] = 0x00054afdeb53f3acUL;
   tf->codes[12740] = 0x00054b2a11274d31UL;
   tf->codes[12741] = 0x00054b2edee2c65aUL;
   tf->codes[12742] = 0x00054b56e6a7b805UL;
   tf->codes[12743] = 0x00054b63f08000e2UL;
   tf->codes[12744] = 0x00054b6f9afe2721UL;
   tf->codes[12745] = 0x00054b7294417222UL;
   tf->codes[12746] = 0x00054b78c1570de9UL;
   tf->codes[12747] = 0x00054b94e40ed390UL;
   tf->codes[12748] = 0x00054bc2de5a5b3dUL;
   tf->codes[12749] = 0x00054bc527f094efUL;
   tf->codes[12750] = 0x00054bd64fd745a6UL;
   tf->codes[12751] = 0x00054beddf6297e9UL;
   tf->codes[12752] = 0x00054bf56bd2564eUL;
   tf->codes[12753] = 0x00054bfe579c3751UL;
   tf->codes[12754] = 0x00054bff7c67542aUL;
   tf->codes[12755] = 0x00054c1fbd2d81abUL;
   tf->codes[12756] = 0x00054c3e9e998c8eUL;
   tf->codes[12757] = 0x00054c407311bab6UL;
   tf->codes[12758] = 0x00054c436c5505b7UL;
   tf->codes[12759] = 0x00054c56ddd1f020UL;
   tf->codes[12760] = 0x00054c6b398af19dUL;
   tf->codes[12761] = 0x00054c7166a08d64UL;
   tf->codes[12762] = 0x00054c7b3ca6857bUL;
   tf->codes[12763] = 0x00054c8930bae56cUL;
   tf->codes[12764] = 0x00054c8acaa40dcfUL;
   tf->codes[12765] = 0x00054c996e657f0fUL;
   tf->codes[12766] = 0x00054ccf6a3ed0abUL;
   tf->codes[12767] = 0x00054cd9eff1da11UL;
   tf->codes[12768] = 0x00054d123561655fUL;
   tf->codes[12769] = 0x00054d35e488e96bUL;
   tf->codes[12770] = 0x00054d37f3901d58UL;
   tf->codes[12771] = 0x00054d4d74143baeUL;
   tf->codes[12772] = 0x00054d4ed36e5e4cUL;
   tf->codes[12773] = 0x00054d520740af12UL;
   tf->codes[12774] = 0x00054d586ee5509eUL;
   tf->codes[12775] = 0x00054d591e9261edUL;
   tf->codes[12776] = 0x00054d5e26dce0dbUL;
   tf->codes[12777] = 0x00054d6af62623f3UL;
   tf->codes[12778] = 0x00054d7ea2321421UL;
   tf->codes[12779] = 0x00054d9b3a07e552UL;
   tf->codes[12780] = 0x00054daee613d580UL;
   tf->codes[12781] = 0x00054db8f6a8d35cUL;
   tf->codes[12782] = 0x00054dd678babba1UL;
   tf->codes[12783] = 0x00054dd8c250f553UL;
   tf->codes[12784] = 0x00054ddb467634caUL;
   tf->codes[12785] = 0x00054ddf64849ca4UL;
   tf->codes[12786] = 0x00054df2265475beUL;
   tf->codes[12787] = 0x00054e13c674c5ddUL;
   tf->codes[12788] = 0x00054e2aa65306d1UL;
   tf->codes[12789] = 0x00054e3a34508f25UL;
   tf->codes[12790] = 0x00054e49c24e1779UL;
   tf->codes[12791] = 0x00054e4da5cd798eUL;
   tf->codes[12792] = 0x00054e78a6d5b63aUL;
   tf->codes[12793] = 0x00054e7de9af3aedUL;
   tf->codes[12794] = 0x00054eb2fb4c7575UL;
   tf->codes[12795] = 0x00054ebdbb8e84a0UL;
   tf->codes[12796] = 0x00054ec3ae151aa2UL;
   tf->codes[12797] = 0x00054ed5108ad11eUL;
   tf->codes[12798] = 0x00054ed87eec27a9UL;
   tf->codes[12799] = 0x00054ef9e47d7203UL;
   tf->codes[12800] = 0x00054efc68a2b17aUL;
   tf->codes[12801] = 0x00054f0dcb1867f6UL;
   tf->codes[12802] = 0x00054f125e44db5aUL;
   tf->codes[12803] = 0x00054f35984e53dcUL;
   tf->codes[12804] = 0x00054f41b7ea85a5UL;
   tf->codes[12805] = 0x00054f49445a440aUL;
   tf->codes[12806] = 0x00054f5a6c40f4c1UL;
   tf->codes[12807] = 0x00054f5c40b922e9UL;
   tf->codes[12808] = 0x00054f756a2d9d8fUL;
   tf->codes[12809] = 0x00054f7a37e916b8UL;
   tf->codes[12810] = 0x00054f88668c7c6eUL;
   tf->codes[12811] = 0x00054f8950c89382UL;
   tf->codes[12812] = 0x00054f8ece311dfaUL;
   tf->codes[12813] = 0x00054f9152565d71UL;
   tf->codes[12814] = 0x00054f97b9fafefdUL;
   tf->codes[12815] = 0x00054fedf69a7e1aUL;
   tf->codes[12816] = 0x00054ff2fee4fd08UL;
   tf->codes[12817] = 0x00054ff5830a3c7fUL;
   tf->codes[12818] = 0x00055005c0b4d622UL;
   tf->codes[12819] = 0x0005501a918be329UL;
   tf->codes[12820] = 0x000550216e4e903fUL;
   tf->codes[12821] = 0x0005502f6262f030UL;
   tf->codes[12822] = 0x00055043838cebe8UL;
   tf->codes[12823] = 0x0005504816b95f4cUL;
   tf->codes[12824] = 0x0005505e46ea8ef1UL;
   tf->codes[12825] = 0x0005506adba4cc44UL;
   tf->codes[12826] = 0x0005506c3afeeee2UL;
   tf->codes[12827] = 0x0005506e4a0622cfUL;
   tf->codes[12828] = 0x0005506ef9b3341eUL;
   tf->codes[12829] = 0x0005507b194f65e7UL;
   tf->codes[12830] = 0x000550926e4bb265UL;
   tf->codes[12831] = 0x0005509651cb147aUL;
   tf->codes[12832] = 0x0005509776963153UL;
   tf->codes[12833] = 0x0005509e5358de69UL;
   tf->codes[12834] = 0x000550b7f1eb6499UL;
   tf->codes[12835] = 0x000550bda9e2f4d6UL;
   tf->codes[12836] = 0x000550d2402afc18UL;
   tf->codes[12837] = 0x000550ddb01a1c92UL;
   tf->codes[12838] = 0x000550ded4e5396bUL;
   tf->codes[12839] = 0x000550e4524dc3e3UL;
   tf->codes[12840] = 0x000550ee2853bbfaUL;
   tf->codes[12841] = 0x000550faf79cff12UL;
   tf->codes[12842] = 0x00055116dfc5bef4UL;
   tf->codes[12843] = 0x0005511d81f96645UL;
   tf->codes[12844] = 0x0005512f941c2e10UL;
   tf->codes[12845] = 0x00055140f691e48cUL;
   tf->codes[12846] = 0x00055151e3e98f7eUL;
   tf->codes[12847] = 0x00055152ce25a692UL;
   tf->codes[12848] = 0x0005515d8e67b5bdUL;
   tf->codes[12849] = 0x0005515f62dfe3e5UL;
   tf->codes[12850] = 0x00055169ae03e786UL;
   tf->codes[12851] = 0x0005517224afbcffUL;
   tf->codes[12852] = 0x0005517433b6f0ecUL;
   tf->codes[12853] = 0x000551893f1d03b8UL;
   tf->codes[12854] = 0x0005518d229c65cdUL;
   tf->codes[12855] = 0x0005519a2c74aeaaUL;
   tf->codes[12856] = 0x0005519b8bced148UL;
   tf->codes[12857] = 0x000551a6fbbdf1c2UL;
   tf->codes[12858] = 0x000551b18170fb28UL;
   tf->codes[12859] = 0x000551b59f7f6302UL;
   tf->codes[12860] = 0x000551c10f6e837cUL;
   tf->codes[12861] = 0x000551cb5a92871dUL;
   tf->codes[12862] = 0x000551d0d7fb1195UL;
   tf->codes[12863] = 0x000551d7ef4cc470UL;
   tf->codes[12864] = 0x000551e742bb46ffUL;
   tf->codes[12865] = 0x000551f412048a17UL;
   tf->codes[12866] = 0x00055219d0334210UL;
   tf->codes[12867] = 0x0005523fc8f0ffceUL;
   tf->codes[12868] = 0x00055245bb7795d0UL;
   tf->codes[12869] = 0x000552466b24a71fUL;
   tf->codes[12870] = 0x0005526218be613cUL;
   tf->codes[12871] = 0x00055264d772a678UL;
   tf->codes[12872] = 0x00055268806302c8UL;
   tf->codes[12873] = 0x0005527639e85cf4UL;
   tf->codes[12874] = 0x00055281e4668333UL;
   tf->codes[12875] = 0x00055295cb017926UL;
   tf->codes[12876] = 0x000552b6bb74b7f6UL;
   tf->codes[12877] = 0x000552b93f99f76dUL;
   tf->codes[12878] = 0x000552bd9837650cUL;
   tf->codes[12879] = 0x000552c22b63d870UL;
   tf->codes[12880] = 0x000552cb172db973UL;
   tf->codes[12881] = 0x000552e948ecb307UL;
   tf->codes[12882] = 0x000552f1fa278e45UL;
   tf->codes[12883] = 0x000552fe5452c5d3UL;
   tf->codes[12884] = 0x0005530188251699UL;
   tf->codes[12885] = 0x0005534502f4bc9cUL;
   tf->codes[12886] = 0x0005534c54d5753cUL;
   tf->codes[12887] = 0x0005535197aef9efUL;
   tf->codes[12888] = 0x00055351d23dffb4UL;
   tf->codes[12889] = 0x0005535839e2a140UL;
   tf->codes[12890] = 0x0005535f16a54e56UL;
   tf->codes[12891] = 0x0005535fc6525fa5UL;
   tf->codes[12892] = 0x0005536752c21e0aUL;
   tf->codes[12893] = 0x0005536d0ab9ae47UL;
   tf->codes[12894] = 0x0005537e6d2f64c3UL;
   tf->codes[12895] = 0x000553845fb5fac5UL;
   tf->codes[12896] = 0x00055393b3247d54UL;
   tf->codes[12897] = 0x000553949d609468UL;
   tf->codes[12898] = 0x00055395127e9ff2UL;
   tf->codes[12899] = 0x0005539e73668c7fUL;
   tf->codes[12900] = 0x000553ad51b70384UL;
   tf->codes[12901] = 0x000553c5cb7e6cdbUL;
   tf->codes[12902] = 0x000553f6bf0d3f89UL;
   tf->codes[12903] = 0x000553fa2d6e9614UL;
   tf->codes[12904] = 0x0005540d9eeb807dUL;
   tf->codes[12905] = 0x00055410982ecb7eUL;
   tf->codes[12906] = 0x00055432e7fc2cecUL;
   tf->codes[12907] = 0x0005544dab59cff5UL;
   tf->codes[12908] = 0x0005546ed65c148aUL;
   tf->codes[12909] = 0x000554715a815401UL;
   tf->codes[12910] = 0x00055471cf9f5f8bUL;
   tf->codes[12911] = 0x0005549f54ccdbaeUL;
   tf->codes[12912] = 0x000554a0eeb60411UL;
   tf->codes[12913] = 0x000554ccd9fa57d1UL;
   tf->codes[12914] = 0x000554cf98ae9d0dUL;
   tf->codes[12915] = 0x000554de3c700e4dUL;
   tf->codes[12916] = 0x000554df26ac2561UL;
   tf->codes[12917] = 0x000554e6788cde01UL;
   tf->codes[12918] = 0x000554e9e6ee348cUL;
   tf->codes[12919] = 0x000554ff677252e2UL;
   tf->codes[12920] = 0x00055516475093d6UL;
   tf->codes[12921] = 0x00055517a6aab674UL;
   tf->codes[12922] = 0x0005551caef53562UL;
   tf->codes[12923] = 0x000555377252d86bUL;
   tf->codes[12924] = 0x00055555a411d1ffUL;
   tf->codes[12925] = 0x0005555b217a5c77UL;
   tf->codes[12926] = 0x0005555eca6ab8c7UL;
   tf->codes[12927] = 0x0005556ecd864ca5UL;
   tf->codes[12928] = 0x000555744aeed71dUL;
   tf->codes[12929] = 0x0005557c11ed9b47UL;
   tf->codes[12930] = 0x00055594c6440a63UL;
   tf->codes[12931] = 0x000555bfc74c470fUL;
   tf->codes[12932] = 0x000555d0b4a3f201UL;
   tf->codes[12933] = 0x000555df58656341UL;
   tf->codes[12934] = 0x000555dfcd836ecbUL;
   tf->codes[12935] = 0x000555ea18a7726cUL;
   tf->codes[12936] = 0x000555eee662eb95UL;
   tf->codes[12937] = 0x000555fb408e2323UL;
   tf->codes[12938] = 0x000555fd8a245cd5UL;
   tf->codes[12939] = 0x000555feaeef79aeUL;
   tf->codes[12940] = 0x00055605c6412c89UL;
   tf->codes[12941] = 0x000556080fd7663bUL;
   tf->codes[12942] = 0x00055610fba1473eUL;
   tf->codes[12943] = 0x000556146a029dc9UL;
   tf->codes[12944] = 0x00055642644e2576UL;
   tf->codes[12945] = 0x0005564647cd878bUL;
   tf->codes[12946] = 0x0005565dd758d9ceUL;
   tf->codes[12947] = 0x00055663c9df6fd0UL;
   tf->codes[12948] = 0x0005567f3cea2428UL;
   tf->codes[12949] = 0x000556c91f5e6bb7UL;
   tf->codes[12950] = 0x000556f0b20551d8UL;
   tf->codes[12951] = 0x000556f2867d8000UL;
   tf->codes[12952] = 0x000556f8b3931bc7UL;
   tf->codes[12953] = 0x000556f928b12751UL;
   tf->codes[12954] = 0x000557171fe11b20UL;
   tf->codes[12955] = 0x0005572cdaf43f3bUL;
   tf->codes[12956] = 0x0005573bf3d3bc05UL;
   tf->codes[12957] = 0x0005573e77f8fb7cUL;
   tf->codes[12958] = 0x0005574296076356UL;
   tf->codes[12959] = 0x0005574b81d14459UL;
   tf->codes[12960] = 0x0005575ef34e2ec2UL;
   tf->codes[12961] = 0x0005576819a7158aUL;
   tf->codes[12962] = 0x00055776484a7b40UL;
   tf->codes[12963] = 0x00055777e233a3a3UL;
   tf->codes[12964] = 0x00055781431b9030UL;
   tf->codes[12965] = 0x00055781f2c8a17fUL;
   tf->codes[12966] = 0x0005579cb6264488UL;
   tf->codes[12967] = 0x000557a7eb865f3dUL;
   tf->codes[12968] = 0x000557bfb5a0b745UL;
   tf->codes[12969] = 0x000557c0da6bd41eUL;
   tf->codes[12970] = 0x000557ca75e2c670UL;
   tf->codes[12971] = 0x000557cab071cc35UL;
   tf->codes[12972] = 0x000557cc84e9fa5dUL;
   tf->codes[12973] = 0x000557da03e04ec4UL;
   tf->codes[12974] = 0x000557e4feb163b4UL;
   tf->codes[12975] = 0x000557e5ae5e7503UL;
   tf->codes[12976] = 0x000557ef0f466190UL;
   tf->codes[12977] = 0x000557efbef372dfUL;
   tf->codes[12978] = 0x000557f9cf8870bbUL;
   tf->codes[12979] = 0x000558069ed1b3d3UL;
   tf->codes[12980] = 0x0005581d4420ef02UL;
   tf->codes[12981] = 0x0005582a88883da4UL;
   tf->codes[12982] = 0x0005582f1bb4b108UL;
   tf->codes[12983] = 0x00055832ff34131dUL;
   tf->codes[12984] = 0x000558407e2a6784UL;
   tf->codes[12985] = 0x0005584218138fe7UL;
   tf->codes[12986] = 0x0005584b78fb7c74UL;
   tf->codes[12987] = 0x0005585c2bc421a1UL;
   tf->codes[12988] = 0x0005585e3acb558eUL;
   tf->codes[12989] = 0x0005586c2edfb57fUL;
   tf->codes[12990] = 0x00055878c399f2d2UL;
   tf->codes[12991] = 0x0005588642904739UL;
   tf->codes[12992] = 0x000558ac3b4e04f7UL;
   tf->codes[12993] = 0x000558ad258a1c0bUL;
   tf->codes[12994] = 0x000558bf37ace3d6UL;
   tf->codes[12995] = 0x000558caa79c0450UL;
   tf->codes[12996] = 0x000558d68ca93054UL;
   tf->codes[12997] = 0x000558e2e6d467e2UL;
   tf->codes[12998] = 0x000558e9c39714f8UL;
   tf->codes[12999] = 0x000558e9fe261abdUL;
   tf->codes[13000] = 0x000558eae86231d1UL;
   tf->codes[13001] = 0x000558eecbe193e6UL;
   tf->codes[13002] = 0x000558f6cd6f5dd5UL;
   tf->codes[13003] = 0x000558f7f23a7aaeUL;
   tf->codes[13004] = 0x0005590d382f933fUL;
   tf->codes[13005] = 0x0005594508811303UL;
   tf->codes[13006] = 0x000559478ca6527aUL;
   tf->codes[13007] = 0x00055948b1716f53UL;
   tf->codes[13008] = 0x000559503de12db8UL;
   tf->codes[13009] = 0x0005595a4e762b94UL;
   tf->codes[13010] = 0x0005596583d64649UL;
   tf->codes[13011] = 0x000559742797b789UL;
   tf->codes[13012] = 0x000559780b17199eUL;
   tf->codes[13013] = 0x0005597bee967bb3UL;
   tf->codes[13014] = 0x000559a6ef9eb85fUL;
   tf->codes[13015] = 0x000559a81469d538UL;
   tf->codes[13016] = 0x000559ad91d25fb0UL;
   tf->codes[13017] = 0x000559bfde842d40UL;
   tf->codes[13018] = 0x000559e5d741eafeUL;
   tf->codes[13019] = 0x000559f405e550b4UL;
   tf->codes[13020] = 0x00055a09fb877a94UL;
   tf->codes[13021] = 0x00055a14f6588f84UL;
   tf->codes[13022] = 0x00055a15a605a0d3UL;
   tf->codes[13023] = 0x00055a1b236e2b4bUL;
   tf->codes[13024] = 0x00055a1b988c36d5UL;
   tf->codes[13025] = 0x00055a3cc38e7b6aUL;
   tf->codes[13026] = 0x00055a4ffa7c600eUL;
   tf->codes[13027] = 0x00055a5711ce12e9UL;
   tf->codes[13028] = 0x00055a595b644c9bUL;
   tf->codes[13029] = 0x00055a695e7fe079UL;
   tf->codes[13030] = 0x00055a7e69e5f345UL;
   tf->codes[13031] = 0x00055a8d82c5700fUL;
   tf->codes[13032] = 0x00055a91a0d3d7e9UL;
   tf->codes[13033] = 0x00055a9cd633f29eUL;
   tf->codes[13034] = 0x00055ab1a70affa5UL;
   tf->codes[13035] = 0x00055ab80eafa131UL;
   tf->codes[13036] = 0x00055abe3bc53cf8UL;
   tf->codes[13037] = 0x00055ac259d3a4d2UL;
   tf->codes[13038] = 0x00055aceee8de225UL;
   tf->codes[13039] = 0x00055adb0e2a13eeUL;
   tf->codes[13040] = 0x00055aee7fa6fe57UL;
   tf->codes[13041] = 0x00055afc73bb5e48UL;
   tf->codes[13042] = 0x00055afe48338c70UL;
   tf->codes[13043] = 0x00055affa78daf0eUL;
   tf->codes[13044] = 0x00055b0d9ba20effUL;
   tf->codes[13045] = 0x00055b31fa76a45aUL;
   tf->codes[13046] = 0x00055b35a36700aaUL;
   tf->codes[13047] = 0x00055b43225d5511UL;
   tf->codes[13048] = 0x00055b54f9f11717UL;
   tf->codes[13049] = 0x00055b59c7ac9040UL;
   tf->codes[13050] = 0x00055b5b9c24be68UL;
   tf->codes[13051] = 0x00055b5dab2bf255UL;
   tf->codes[13052] = 0x00055b69cac8241eUL;
   tf->codes[13053] = 0x00055b6aef9340f7UL;
   tf->codes[13054] = 0x00055b8a461d5764UL;
   tf->codes[13055] = 0x00055b8e9ebac503UL;
   tf->codes[13056] = 0x00055bbac48e1e88UL;
   tf->codes[13057] = 0x00055bdd4eea85bbUL;
   tf->codes[13058] = 0x00055bef267e47c1UL;
   tf->codes[13059] = 0x00055bef9b9c534bUL;
   tf->codes[13060] = 0x00055bf170148173UL;
   tf->codes[13061] = 0x00055c05cbcd82f0UL;
   tf->codes[13062] = 0x00055c10c69e97e0UL;
   tf->codes[13063] = 0x00055c15945a1109UL;
   tf->codes[13064] = 0x00055c3266bee7ffUL;
   tf->codes[13065] = 0x00055c32dbdcf389UL;
   tf->codes[13066] = 0x00055c359a9138c5UL;
   tf->codes[13067] = 0x00055c39b89fa09fUL;
   tf->codes[13068] = 0x00055c3e4bcc1403UL;
   tf->codes[13069] = 0x00055c417f9e64c9UL;
   tf->codes[13070] = 0x00055c44b370b58fUL;
   tf->codes[13071] = 0x00055c5ddce53035UL;
   tf->codes[13072] = 0x00055c5f3c3f52d3UL;
   tf->codes[13073] = 0x00055c969772c70dUL;
   tf->codes[13074] = 0x00055c98a679fafaUL;
   tf->codes[13075] = 0x00055ca157b4d638UL;
   tf->codes[13076] = 0x00055cad3cc2023cUL;
   tf->codes[13077] = 0x00055cbdb4fba1a4UL;
   tf->codes[13078] = 0x00055cc282b71acdUL;
   tf->codes[13079] = 0x00055ccf52005de5UL;
   tf->codes[13080] = 0x00055ce004c90312UL;
   tf->codes[13081] = 0x00055ce1642325b0UL;
   tf->codes[13082] = 0x00055ce213d036ffUL;
   tf->codes[13083] = 0x00055ce8f092e415UL;
   tf->codes[13084] = 0x00055cf46082048fUL;
   tf->codes[13085] = 0x00055d1516663d9aUL;
   tf->codes[13086] = 0x00055d37db51aa92UL;
   tf->codes[13087] = 0x00055d3c6e7e1df6UL;
   tf->codes[13088] = 0x00055d4609f51048UL;
   tf->codes[13089] = 0x00055d488e1a4fbfUL;
   tf->codes[13090] = 0x00055d5ef8da8529UL;
   tf->codes[13091] = 0x00055d6ceceee51aUL;
   tf->codes[13092] = 0x00055d78d1fc111eUL;
   tf->codes[13093] = 0x00055d873b2e7c99UL;
   tf->codes[13094] = 0x00055d89bf53bc10UL;
   tf->codes[13095] = 0x00055d89f9e2c1d5UL;
   tf->codes[13096] = 0x00055d914bc37a75UL;
   tf->codes[13097] = 0x00055d973e4a1077UL;
   tf->codes[13098] = 0x00055d9b21c9728cUL;
   tf->codes[13099] = 0x00055dd7fa65713eUL;
   tf->codes[13100] = 0x00055de2f536862eUL;
   tf->codes[13101] = 0x00055def4f61bdbcUL;
   tf->codes[13102] = 0x00055df123d9ebe4UL;
   tf->codes[13103] = 0x00055dfd7e052372UL;
   tf->codes[13104] = 0x00055e0ee07ad9eeUL;
   tf->codes[13105] = 0x00055e12fe8941c8UL;
   tf->codes[13106] = 0x00055e558f1cd0b7UL;
   tf->codes[13107] = 0x00055e576394fedfUL;
   tf->codes[13108] = 0x00055e5d1b8c8f1cUL;
   tf->codes[13109] = 0x00055e6014cfda1dUL;
   tf->codes[13110] = 0x00055e6a2564d7f9UL;
   tf->codes[13111] = 0x00055e6c346c0be6UL;
   tf->codes[13112] = 0x00055e760a7203fdUL;
   tf->codes[13113] = 0x00055e78197937eaUL;
   tf->codes[13114] = 0x00055e7903b54efeUL;
   tf->codes[13115] = 0x00055e7a28806bd7UL;
   tf->codes[13116] = 0x00055e7a9d9e7761UL;
   tf->codes[13117] = 0x00055e8e0f1b61caUL;
   tf->codes[13118] = 0x00055ec395d6a7dcUL;
   tf->codes[13119] = 0x00055ec9885d3ddeUL;
   tf->codes[13120] = 0x00055ecc4711831aUL;
   tf->codes[13121] = 0x00055ecde0faab7dUL;
   tf->codes[13122] = 0x00055ed9c607d781UL;
   tf->codes[13123] = 0x00055edb9a8005a9UL;
   tf->codes[13124] = 0x00055ef8a773e264UL;
   tf->codes[13125] = 0x00055f136ad1856dUL;
   tf->codes[13126] = 0x00055f5bb35ca499UL;
   tf->codes[13127] = 0x00055f6e3a9d77eeUL;
   tf->codes[13128] = 0x00055f71e38dd43eUL;
   tf->codes[13129] = 0x00055f7a1faaa3f2UL;
   tf->codes[13130] = 0x00055f93f8cc2fe7UL;
   tf->codes[13131] = 0x00055f997634ba5fUL;
   tf->codes[13132] = 0x00055f9fa34a5626UL;
   tf->codes[13133] = 0x00055fce4d42ef22UL;
   tf->codes[13134] = 0x00055fd7e8b9e174UL;
   tf->codes[13135] = 0x00055fda6cdf20ebUL;
   tf->codes[13136] = 0x00055feb94c5d1a2UL;
   tf->codes[13137] = 0x00055fef3db62df2UL;
   tf->codes[13138] = 0x00055ff779d2fda6UL;
   tf->codes[13139] = 0x00056003996f2f6fUL;
   tf->codes[13140] = 0x00056052842df5ecUL;
   tf->codes[13141] = 0x000560666ac8ebdfUL;
   tf->codes[13142] = 0x00056074244e460bUL;
   tf->codes[13143] = 0x00056075be376e6eUL;
   tf->codes[13144] = 0x000560842769d9e9UL;
   tf->codes[13145] = 0x0005608a19f06febUL;
   tf->codes[13146] = 0x0005608a547f75b0UL;
   tf->codes[13147] = 0x00056095fefd9befUL;
   tf->codes[13148] = 0x000560b25c44675bUL;
   tf->codes[13149] = 0x000560c0c576d2d6UL;
   tf->codes[13150] = 0x000560c46e672f26UL;
   tf->codes[13151] = 0x000560c558a3463aUL;
   tf->codes[13152] = 0x000560ccaa83fedaUL;
   tf->codes[13153] = 0x000560cf2ea93e51UL;
   tf->codes[13154] = 0x000560d018e55565UL;
   tf->codes[13155] = 0x000560d5d0dce5a2UL;
   tf->codes[13156] = 0x000560dd5d4ca407UL;
   tf->codes[13157] = 0x000560eb16d1fe33UL;
   tf->codes[13158] = 0x00056103560a61c5UL;
   tf->codes[13159] = 0x000561059fa09b77UL;
   tf->codes[13160] = 0x0005610823c5daeeUL;
   tf->codes[13161] = 0x000561168cf84669UL;
   tf->codes[13162] = 0x0005611d69baf37fUL;
   tf->codes[13163] = 0x0005611dded8ff09UL;
   tf->codes[13164] = 0x00056130db37dde8UL;
   tf->codes[13165] = 0x000561356e64514cUL;
   tf->codes[13166] = 0x00056146212cf679UL;
   tf->codes[13167] = 0x00056155749b7908UL;
   tf->codes[13168] = 0x000561632e20d334UL;
   tf->codes[13169] = 0x0005616fc2db1087UL;
   tf->codes[13170] = 0x00056178aea4f18aUL;
   tf->codes[13171] = 0x000561795e5202d9UL;
   tf->codes[13172] = 0x0005617be2774250UL;
   tf->codes[13173] = 0x000561966b45df94UL;
   tf->codes[13174] = 0x000561a633d26dadUL;
   tf->codes[13175] = 0x000561b75bb91e64UL;
   tf->codes[13176] = 0x000561c2cba83edeUL;
   tf->codes[13177] = 0x000561cc671f3130UL;
   tf->codes[13178] = 0x000561d16f69b01eUL;
   tf->codes[13179] = 0x000561d8fbd96e83UL;
   tf->codes[13180] = 0x000561dd8f05e1e7UL;
   tf->codes[13181] = 0x000561deee600485UL;
   tf->codes[13182] = 0x000561dfd89c1b99UL;
   tf->codes[13183] = 0x000561f175a0d7daUL;
   tf->codes[13184] = 0x000561fad688c467UL;
   tf->codes[13185] = 0x000561fbc0c4db7bUL;
   tf->codes[13186] = 0x0005621733cf8fd3UL;
   tf->codes[13187] = 0x000562377495bd54UL;
   tf->codes[13188] = 0x0005623b92a4252eUL;
   tf->codes[13189] = 0x0005623c7ce03c42UL;
   tf->codes[13190] = 0x00056247b24056f7UL;
   tf->codes[13191] = 0x000562489c7c6e0bUL;
   tf->codes[13192] = 0x000562589f9801e9UL;
   tf->codes[13193] = 0x0005625e578f9226UL;
   tf->codes[13194] = 0x000562695260a716UL;
   tf->codes[13195] = 0x0005626aec49cf79UL;
   tf->codes[13196] = 0x00056275ac8bdea4UL;
   tf->codes[13197] = 0x0005629b6aba969dUL;
   tf->codes[13198] = 0x000562ad424e58a3UL;
   tf->codes[13199] = 0x000562c3e79d93d2UL;
   tf->codes[13200] = 0x000562c66bc2d349UL;
   tf->codes[13201] = 0x000562ee38f8bf2fUL;
   tf->codes[13202] = 0x000562f933c9d41fUL;
   tf->codes[13203] = 0x00056318c4e2f051UL;
   tf->codes[13204] = 0x0005633a9f924635UL;
   tf->codes[13205] = 0x0005633cae997a22UL;
   tf->codes[13206] = 0x000563401cfad0adUL;
   tf->codes[13207] = 0x0005634faaf85901UL;
   tf->codes[13208] = 0x0005635efe66db90UL;
   tf->codes[13209] = 0x000563735a1fdd0dUL;
   tf->codes[13210] = 0x0005637c45e9be10UL;
   tf->codes[13211] = 0x0005638322ac6b26UL;
   tf->codes[13212] = 0x000563b83449a5aeUL;
   tf->codes[13213] = 0x000563ba08c1d3d6UL;
   tf->codes[13214] = 0x000563c578b0f450UL;
   tf->codes[13215] = 0x000563d1d2dc2bdeUL;
   tf->codes[13216] = 0x000563d7fff1c7a5UL;
   tf->codes[13217] = 0x000563ed8075e5fbUL;
   tf->codes[13218] = 0x000563f58203afeaUL;
   tf->codes[13219] = 0x000563f631b0c139UL;
   tf->codes[13220] = 0x00056413b3c2a97eUL;
   tf->codes[13221] = 0x0005641b403267e3UL;
   tf->codes[13222] = 0x00056440c3d21a17UL;
   tf->codes[13223] = 0x00056440fe611fdcUL;
   tf->codes[13224] = 0x000564697b441d11UL;
   tf->codes[13225] = 0x0005648a6bb75be1UL;
   tf->codes[13226] = 0x00056496c5e2936fUL;
   tf->codes[13227] = 0x000564985fcbbbd2UL;
   tf->codes[13228] = 0x0005649b939e0c98UL;
   tf->codes[13229] = 0x000564af7a39028bUL;
   tf->codes[13230] = 0x000564ba3a7b11b6UL;
   tf->codes[13231] = 0x000564be58897990UL;
   tf->codes[13232] = 0x000564c65a17437fUL;
   tf->codes[13233] = 0x000564f788351bf2UL;
   tf->codes[13234] = 0x000564ff89c2e5e1UL;
   tf->codes[13235] = 0x0005650a4a04f50cUL;
   tf->codes[13236] = 0x0005651753dd3de9UL;
   tf->codes[13237] = 0x0005651878a85ac2UL;
   tf->codes[13238] = 0x0005653cd77cf01dUL;
   tf->codes[13239] = 0x000565449e7bb447UL;
   tf->codes[13240] = 0x0005655dc7f02eedUL;
   tf->codes[13241] = 0x00056561ab6f9102UL;
   tf->codes[13242] = 0x0005656ad1c877caUL;
   tf->codes[13243] = 0x000565751cec7b6bUL;
   tf->codes[13244] = 0x0005658a9d7099c1UL;
   tf->codes[13245] = 0x0005658e80effbd6UL;
   tf->codes[13246] = 0x0005659229e05826UL;
   tf->codes[13247] = 0x000565934eab74ffUL;
   tf->codes[13248] = 0x0005659cea226751UL;
   tf->codes[13249] = 0x000565cdddb139ffUL;
   tf->codes[13250] = 0x000565d7ee4637dbUL;
   tf->codes[13251] = 0x000565fb9d6dbbe7UL;
   tf->codes[13252] = 0x00056613678813efUL;
   tf->codes[13253] = 0x0005661c18c2ef2dUL;
   tf->codes[13254] = 0x0005661c8de0fab7UL;
   tf->codes[13255] = 0x0005661e27ca231aUL;
   tf->codes[13256] = 0x00056628e80c3245UL;
   tf->codes[13257] = 0x0005665423a374b6UL;
   tf->codes[13258] = 0x0005665582fd9754UL;
   tf->codes[13259] = 0x000566592bedf3a4UL;
   tf->codes[13260] = 0x0005665dbf1a6708UL;
   tf->codes[13261] = 0x0005665f93929530UL;
   tf->codes[13262] = 0x000566938064b2dfUL;
   tf->codes[13263] = 0x000566951a4ddb42UL;
   tf->codes[13264] = 0x0005669763e414f4UL;
   tf->codes[13265] = 0x0005669b0cd47144UL;
   tf->codes[13266] = 0x0005669b81f27cceUL;
   tf->codes[13267] = 0x000566bcacf4c163UL;
   tf->codes[13268] = 0x000566e56466c45dUL;
   tf->codes[13269] = 0x000566f73bfa8663UL;
   tf->codes[13270] = 0x00056713994151cfUL;
   tf->codes[13271] = 0x000567365e2cbec7UL;
   tf->codes[13272] = 0x0005674208aae506UL;
   tf->codes[13273] = 0x0005675c56ea7c85UL;
   tf->codes[13274] = 0x000567692633bf9dUL;
   tf->codes[13275] = 0x0005677879a2422cUL;
   tf->codes[13276] = 0x0005678b00e31581UL;
   tf->codes[13277] = 0x0005679d4d94e311UL;
   tf->codes[13278] = 0x000567bb44c4d6e0UL;
   tf->codes[13279] = 0x000567c729d202e4UL;
   tf->codes[13280] = 0x000567e053467d8aUL;
   tf->codes[13281] = 0x0005680cee37e299UL;
   tf->codes[13282] = 0x0005681440189b39UL;
   tf->codes[13283] = 0x000568440edc510eUL;
   tf->codes[13284] = 0x0005685b9e67a351UL;
   tf->codes[13285] = 0x0005685ed239f417UL;
   tf->codes[13286] = 0x0005686bdc123cf4UL;
   tf->codes[13287] = 0x000568850586b79aUL;
   tf->codes[13288] = 0x00056888ae7713eaUL;
   tf->codes[13289] = 0x0005688be24964b0UL;
   tf->codes[13290] = 0x000568936eb92315UL;
   tf->codes[13291] = 0x0005689f8e5554deUL;
   tf->codes[13292] = 0x000568d72417ceddUL;
   tf->codes[13293] = 0x000568f1ace66c21UL;
   tf->codes[13294] = 0x000568f4a629b722UL;
   tf->codes[13295] = 0x000569108e527704UL;
   tf->codes[13296] = 0x0005692b17211448UL;
   tf->codes[13297] = 0x00056958273084e1UL;
   tf->codes[13298] = 0x0005695b5b02d5a7UL;
   tf->codes[13299] = 0x0005696c82e9865eUL;
   tf->codes[13300] = 0x0005696da7b4a337UL;
   tf->codes[13301] = 0x0005697b9bc90328UL;
   tf->codes[13302] = 0x0005699a08170281UL;
   tf->codes[13303] = 0x000569c3a9c51c8fUL;
   tf->codes[13304] = 0x000569df1ccfd0e7UL;
   tf->codes[13305] = 0x000569f3036ac6daUL;
   tf->codes[13306] = 0x00056a0674e7b143UL;
   tf->codes[13307] = 0x00056a0883eee530UL;
   tf->codes[13308] = 0x00056a0f9b40980bUL;
   tf->codes[13309] = 0x00056a17d75d67bfUL;
   tf->codes[13310] = 0x00056a26b5addec4UL;
   tf->codes[13311] = 0x00056a3384f721dcUL;
   tf->codes[13312] = 0x00056a4521fbde1dUL;
   tf->codes[13313] = 0x00056a4646c6faf6UL;
   tf->codes[13314] = 0x00056a46bbe50680UL;
   tf->codes[13315] = 0x00056a4a64d562d0UL;
   tf->codes[13316] = 0x00056a4c73dc96bdUL;
   tf->codes[13317] = 0x00056a51b6b61b70UL;
   tf->codes[13318] = 0x00056a543adb5ae7UL;
   tf->codes[13319] = 0x00056a559a357d85UL;
   tf->codes[13320] = 0x00056a601fe886ebUL;
   tf->codes[13321] = 0x00056a7356d66b8fUL;
   tf->codes[13322] = 0x00056a752b4e99b7UL;
   tf->codes[13323] = 0x00056a7b1dd52fb9UL;
   tf->codes[13324] = 0x00056a80d5ccbff6UL;
   tf->codes[13325] = 0x00056a98da761dc3UL;
   tf->codes[13326] = 0x00056aaed01847a3UL;
   tf->codes[13327] = 0x00056ab9cae95c93UL;
   tf->codes[13328] = 0x00056abf4851e70bUL;
   tf->codes[13329] = 0x00056ac24195320cUL;
   tf->codes[13330] = 0x00056aca4322fbfbUL;
   tf->codes[13331] = 0x00056acd76f54cc1UL;
   tf->codes[13332] = 0x00056ad7c2195062UL;
   tf->codes[13333] = 0x00056ade9edbfd78UL;
   tf->codes[13334] = 0x00056aded96b033dUL;
   tf->codes[13335] = 0x00056af1d5c9e21cUL;
   tf->codes[13336] = 0x00056b0372ce9e5dUL;
   tf->codes[13337] = 0x00056b0ac4af56fdUL;
   tf->codes[13338] = 0x00056b1cd6d21ec8UL;
   tf->codes[13339] = 0x00056b442ee9ff24UL;
   tf->codes[13340] = 0x00056b44de971073UL;
   tf->codes[13341] = 0x00056b46ed9e4460UL;
   tf->codes[13342] = 0x00056b4887876cc3UL;
   tf->codes[13343] = 0x00056b4a5bff9aebUL;
   tf->codes[13344] = 0x00056b5f2cd6a7f2UL;
   tf->codes[13345] = 0x00056b917fbf9d3eUL;
   tf->codes[13346] = 0x00056b9528aff98eUL;
   tf->codes[13347] = 0x00056b9aa6188406UL;
   tf->codes[13348] = 0x00056bd0a1f1d5a2UL;
   tf->codes[13349] = 0x00056bec8a1a9584UL;
   tf->codes[13350] = 0x00056befbdece64aUL;
   tf->codes[13351] = 0x00056bf207831ffcUL;
   tf->codes[13352] = 0x00056bf48ba85f73UL;
   tf->codes[13353] = 0x00056c0712e932c8UL;
   tf->codes[13354] = 0x00056c0ed9e7f6f2UL;
   tf->codes[13355] = 0x00056c18ea7cf4ceUL;
   tf->codes[13356] = 0x00056c195f9b0058UL;
   tf->codes[13357] = 0x00056c1fc73fa1e4UL;
   tf->codes[13358] = 0x00056c43eb85317aUL;
   tf->codes[13359] = 0x00056c4809939954UL;
   tf->codes[13360] = 0x00056c521a289730UL;
   tf->codes[13361] = 0x00056c533ef3b409UL;
   tf->codes[13362] = 0x00056c6ca2f73474UL;
   tf->codes[13363] = 0x00056c6e3ce05cd7UL;
   tf->codes[13364] = 0x00056c7728aa3ddaUL;
   tf->codes[13365] = 0x00056c967f345447UL;
   tf->codes[13366] = 0x00056ca522f5c587UL;
   tf->codes[13367] = 0x00056ca76c8bff39UL;
   tf->codes[13368] = 0x00056cb0cd73ebc6UL;
   tf->codes[13369] = 0x00056cb6856b7c03UL;
   tf->codes[13370] = 0x00056cbaa379e3ddUL;
   tf->codes[13371] = 0x00056cbe11db3a68UL;
   tf->codes[13372] = 0x00056cc688870fe1UL;
   tf->codes[13373] = 0x00056cc8978e43ceUL;
   tf->codes[13374] = 0x00056cd0991c0dbdUL;
   tf->codes[13375] = 0x00056cd148c91f0cUL;
   tf->codes[13376] = 0x00056cd4077d6448UL;
   tf->codes[13377] = 0x00056cd4f1b97b5cUL;
   tf->codes[13378] = 0x00056ce8d854714fUL;
   tf->codes[13379] = 0x00056cf6cc68d140UL;
   tf->codes[13380] = 0x00056cfcbeef6742UL;
   tf->codes[13381] = 0x00056cffb832b243UL;
   tf->codes[13382] = 0x00056d10306c51abUL;
   tf->codes[13383] = 0x00056d10e01962faUL;
   tf->codes[13384] = 0x00056d2b68e8003eUL;
   tf->codes[13385] = 0x00056d44925c7ae4UL;
   tf->codes[13386] = 0x00056d457c9891f8UL;
   tf->codes[13387] = 0x00056d4800bdd16fUL;
   tf->codes[13388] = 0x00056d4875dbdcf9UL;
   tf->codes[13389] = 0x00056d4afa011c70UL;
   tf->codes[13390] = 0x00056d550a961a4cUL;
   tf->codes[13391] = 0x00056d59d8519375UL;
   tf->codes[13392] = 0x00056d649893a2a0UL;
   tf->codes[13393] = 0x00056d6cd4b07254UL;
   tf->codes[13394] = 0x00056d7a53a6c6bbUL;
   tf->codes[13395] = 0x00056d7bed8fef1eUL;
   tf->codes[13396] = 0x00056d7cd7cc0632UL;
   tf->codes[13397] = 0x00056d88824a2c71UL;
   tf->codes[13398] = 0x00056d9d53213978UL;
   tf->codes[13399] = 0x00056da79e453d19UL;
   tf->codes[13400] = 0x00056db1aeda3af5UL;
   tf->codes[13401] = 0x00056dc93e658d38UL;
   tf->codes[13402] = 0x00056de1f2bbfc54UL;
   tf->codes[13403] = 0x00056deced8d1144UL;
   tf->codes[13404] = 0x00056e135b68da8cUL;
   tf->codes[13405] = 0x00056e14f55202efUL;
   tf->codes[13406] = 0x00056e1863b3597aUL;
   tf->codes[13407] = 0x00056e1bd214b005UL;
   tf->codes[13408] = 0x00056e31c7b6d9e5UL;
   tf->codes[13409] = 0x00056e37f4cc75acUL;
   tf->codes[13410] = 0x00056e41cad26dc3UL;
   tf->codes[13411] = 0x00056e46236fdb62UL;
   tf->codes[13412] = 0x00056e48e224209eUL;
   tf->codes[13413] = 0x00056e4f8457c7efUL;
   tf->codes[13414] = 0x00056e6280b6a6ceUL;
   tf->codes[13415] = 0x00056e712478180eUL;
   tf->codes[13416] = 0x00056eac9db9f422UL;
   tf->codes[13417] = 0x00056ec1e3af0cb3UL;
   tf->codes[13418] = 0x00056ec9358fc553UL;
   tf->codes[13419] = 0x00056ecc69621619UL;
   tf->codes[13420] = 0x00056eceb2f84fcbUL;
   tf->codes[13421] = 0x00056ed764332b09UL;
   tf->codes[13422] = 0x00056eddcbd7cc95UL;
   tf->codes[13423] = 0x00056f0ef9f5a508UL;
   tf->codes[13424] = 0x00056f3358ca3a63UL;
   tf->codes[13425] = 0x00056f3a358ce779UL;
   tf->codes[13426] = 0x00056f439674d406UL;
   tf->codes[13427] = 0x00056f5c4acb4322UL;
   tf->codes[13428] = 0x00056f639cabfbc2UL;
   tf->codes[13429] = 0x00056f691a14863aUL;
   tf->codes[13430] = 0x00056f6c8875dcc5UL;
   tf->codes[13431] = 0x00056fb1d7bdb0f0UL;
   tf->codes[13432] = 0x00056fbbe852aeccUL;
   tf->codes[13433] = 0x00056fcdbfe670d2UL;
   tf->codes[13434] = 0x00056fd302bff585UL;
   tf->codes[13435] = 0x00056ff3b8a42e90UL;
   tf->codes[13436] = 0x00056ff517fe512eUL;
   tf->codes[13437] = 0x00056ff6775873ccUL;
   tf->codes[13438] = 0x00056ff8c0eead7eUL;
   tf->codes[13439] = 0x00056fffd8406059UL;
   tf->codes[13440] = 0x000570063fe501e5UL;
   tf->codes[13441] = 0x00057013bedb564cUL;
   tf->codes[13442] = 0x0005703dd5a77be4UL;
   tf->codes[13443] = 0x000570401f3db596UL;
   tf->codes[13444] = 0x00057049bab4a7e8UL;
   tf->codes[13445] = 0x0005704fe7ca43afUL;
   tf->codes[13446] = 0x0005705390ba9fffUL;
   tf->codes[13447] = 0x000570610fb0f466UL;
   tf->codes[13448] = 0x0005707a73b474d1UL;
   tf->codes[13449] = 0x0005707b5df08be5UL;
   tf->codes[13450] = 0x0005707b987f91aaUL;
   tf->codes[13451] = 0x0005707c0d9d9d34UL;
   tf->codes[13452] = 0x00057094c1f40c50UL;
   tf->codes[13453] = 0x000570c0e7c765d5UL;
   tf->codes[13454] = 0x000570c197747724UL;
   tf->codes[13455] = 0x000571033dcbeeffUL;
   tf->codes[13456] = 0x0005710d13d1e716UL;
   tf->codes[13457] = 0x0005710d88eff2a0UL;
   tf->codes[13458] = 0x0005715178dda42dUL;
   tf->codes[13459] = 0x00057157a5f33ff4UL;
   tf->codes[13460] = 0x0005719d2fca19e4UL;
   tf->codes[13461] = 0x0005719d6a591fa9UL;
   tf->codes[13462] = 0x000571b2eadd3dffUL;
   tf->codes[13463] = 0x000571e99663a0eaUL;
   tf->codes[13464] = 0x000571ef13cc2b62UL;
   tf->codes[13465] = 0x00057204cedf4f7dUL;
   tf->codes[13466] = 0x00057208b25eb192UL;
   tf->codes[13467] = 0x0005723a559a958fUL;
   tf->codes[13468] = 0x0005723f23560eb8UL;
   tf->codes[13469] = 0x00057248becd010aUL;
   tf->codes[13470] = 0x0005724a1e2723a8UL;
   tf->codes[13471] = 0x0005727bfbf20d6aUL;
   tf->codes[13472] = 0x0005727ebaa652a6UL;
   tf->codes[13473] = 0x000572959a84939aUL;
   tf->codes[13474] = 0x000572abcab5c33fUL;
   tf->codes[13475] = 0x000572b85f700092UL;
   tf->codes[13476] = 0x000572c09b8cd046UL;
   tf->codes[13477] = 0x000572c110aadbd0UL;
   tf->codes[13478] = 0x000572cae6b0d3e7UL;
   tf->codes[13479] = 0x000572cfb46c4d10UL;
   tf->codes[13480] = 0x000572dbd4087ed9UL;
   tf->codes[13481] = 0x000572e02ca5ec78UL;
   tf->codes[13482] = 0x000572e2eb5a31b4UL;
   tf->codes[13483] = 0x000572e77e86a518UL;
   tf->codes[13484] = 0x000572f3d8b1dca6UL;
   tf->codes[13485] = 0x000572f6d1f527a7UL;
   tf->codes[13486] = 0x0005733494cd3d6dUL;
   tf->codes[13487] = 0x00057352c68c3701UL;
   tf->codes[13488] = 0x0005736fd38013bcUL;
   tf->codes[13489] = 0x0005737257a55333UL;
   tf->codes[13490] = 0x000573763b24b548UL;
   tf->codes[13491] = 0x0005737fd69ba79aUL;
   tf->codes[13492] = 0x00057383ba1b09afUL;
   tf->codes[13493] = 0x000573c6101f92d9UL;
   tf->codes[13494] = 0x000573c7aa08bb3cUL;
   tf->codes[13495] = 0x000573cfab96852bUL;
   tf->codes[13496] = 0x000573d2a4d9d02cUL;
   tf->codes[13497] = 0x000573f912b59974UL;
   tf->codes[13498] = 0x000573fd30c4014eUL;
   tf->codes[13499] = 0x000574074158ff2aUL;
   tf->codes[13500] = 0x000574118c7d02cbUL;
   tf->codes[13501] = 0x0005741360f530f3UL;
   tf->codes[13502] = 0x0005741a7846e3ceUL;
   tf->codes[13503] = 0x0005743501158112UL;
   tf->codes[13504] = 0x00057453e2818bf5UL;
   tf->codes[13505] = 0x0005745af9d33ed0UL;
   tf->codes[13506] = 0x0005745c93bc6733UL;
   tf->codes[13507] = 0x000574650a683cacUL;
   tf->codes[13508] = 0x0005748b0325fa6aUL;
   tf->codes[13509] = 0x000574bca661de67UL;
   tf->codes[13510] = 0x000574cdce488f1eUL;
   tf->codes[13511] = 0x000574cf2da2b1bcUL;
   tf->codes[13512] = 0x000574cfa2c0bd46UL;
   tf->codes[13513] = 0x000574d6f4a175e6UL;
   tf->codes[13514] = 0x000574f38c774717UL;
   tf->codes[13515] = 0x000574fc03231c90UL;
   tf->codes[13516] = 0x0005750c40cdb633UL;
   tf->codes[13517] = 0x000575377c64f8a4UL;
   tf->codes[13518] = 0x00057542ec54191eUL;
   tf->codes[13519] = 0x00057544fb5b4d0bUL;
   tf->codes[13520] = 0x00057545e597641fUL;
   tf->codes[13521] = 0x000575527a51a172UL;
   tf->codes[13522] = 0x0005755dea40c1ecUL;
   tf->codes[13523] = 0x0005756d3daf447bUL;
   tf->codes[13524] = 0x0005757036f28f7cUL;
   tf->codes[13525] = 0x00057571964cb21aUL;
   tf->codes[13526] = 0x0005757f8a61120bUL;
   tf->codes[13527] = 0x0005758f52eda024UL;
   tf->codes[13528] = 0x0005759077b8bcfdUL;
   tf->codes[13529] = 0x000575c9324653d5UL;
   tf->codes[13530] = 0x000575cc6618a49bUL;
   tf->codes[13531] = 0x000575ce751fd888UL;
   tf->codes[13532] = 0x000575d0beb6123aUL;
   tf->codes[13533] = 0x000575dfd7958f04UL;
   tf->codes[13534] = 0x000575e43032fca3UL;
   tf->codes[13535] = 0x000575f224475c94UL;
   tf->codes[13536] = 0x000575f383a17f32UL;
   tf->codes[13537] = 0x00057603119f0786UL;
   tf->codes[13538] = 0x00057609b3d2aed7UL;
   tf->codes[13539] = 0x0005760a9e0ec5ebUL;
   tf->codes[13540] = 0x0005760dd1e116b1UL;
   tf->codes[13541] = 0x0005760ef6ac338aUL;
   tf->codes[13542] = 0x0005761389d8a6eeUL;
   tf->codes[13543] = 0x00057615d36ee0a0UL;
   tf->codes[13544] = 0x0005761ceac0937bUL;
   tf->codes[13545] = 0x0005762c03a01045UL;
   tf->codes[13546] = 0x0005762e12a74432UL;
   tf->codes[13547] = 0x00057652717bd98dUL;
   tf->codes[13548] = 0x00057656ca19472cUL;
   tf->codes[13549] = 0x00057670a33ad321UL;
   tf->codes[13550] = 0x00057677ba8c85fcUL;
   tf->codes[13551] = 0x0005767ed1de38d7UL;
   tf->codes[13552] = 0x0005768deabdb5a1UL;
   tf->codes[13553] = 0x000576987070bf07UL;
   tf->codes[13554] = 0x000576afc56d0b85UL;
   tf->codes[13555] = 0x000576bafacd263aUL;
   tf->codes[13556] = 0x000576be2e9f7700UL;
   tf->codes[13557] = 0x000576d2c4e77e42UL;
   tf->codes[13558] = 0x000576de34d69ebcUL;
   tf->codes[13559] = 0x000576edfd632cd5UL;
   tf->codes[13560] = 0x000576f37acbb74dUL;
   tf->codes[13561] = 0x00057718c3dc63bcUL;
   tf->codes[13562] = 0x0005771d5708d720UL;
   tf->codes[13563] = 0x00057733873a06c5UL;
   tf->codes[13564] = 0x0005773854f57feeUL;
   tf->codes[13565] = 0x000577460e7ada1aUL;
   tf->codes[13566] = 0x00057754028f3a0bUL;
   tf->codes[13567] = 0x000577786163cf66UL;
   tf->codes[13568] = 0x0005777cba013d05UL;
   tf->codes[13569] = 0x0005779b9b6d47e8UL;
   tf->codes[13570] = 0x000577bb2c86641aUL;
   tf->codes[13571] = 0x000577bd00fe9242UL;
   tf->codes[13572] = 0x000577c27e671cbaUL;
   tf->codes[13573] = 0x000577f790045742UL;
   tf->codes[13574] = 0x000577f9647c856aUL;
   tf->codes[13575] = 0x00057801db285ae3UL;
   tf->codes[13576] = 0x00057809a2271f0dUL;
   tf->codes[13577] = 0x0005780c264c5e84UL;
   tf->codes[13578] = 0x0005781aca0dcfc4UL;
   tf->codes[13579] = 0x0005782e3b8aba2dUL;
   tf->codes[13580] = 0x000578425cb4b5e5UL;
   tf->codes[13581] = 0x000578472a702f0eUL;
   tf->codes[13582] = 0x0005784d1cf6c510UL;
   tf->codes[13583] = 0x00057851eab23e39UL;
   tf->codes[13584] = 0x0005786f6cc4267eUL;
   tf->codes[13585] = 0x00057874ea2cb0f6UL;
   tf->codes[13586] = 0x0005787aa2244133UL;
   tf->codes[13587] = 0x0005787b17424cbdUL;
   tf->codes[13588] = 0x0005787e108597beUL;
   tf->codes[13589] = 0x0005789a6dcc632aUL;
   tf->codes[13590] = 0x0005789b58087a3eUL;
   tf->codes[13591] = 0x000578b4bc0bfaa9UL;
   tf->codes[13592] = 0x000578ccfb445e3bUL;
   tf->codes[13593] = 0x000578d18e70d19fUL;
   tf->codes[13594] = 0x0005790331acb59cUL;
   tf->codes[13595] = 0x000579062af0009dUL;
   tf->codes[13596] = 0x0005790abe1c7401UL;
   tf->codes[13597] = 0x0005790c1d76969fUL;
   tf->codes[13598] = 0x000579107614043eUL;
   tf->codes[13599] = 0x0005792ac4539bbdUL;
   tf->codes[13600] = 0x00057932c5e165acUL;
   tf->codes[13601] = 0x0005793968150cfdUL;
   tf->codes[13602] = 0x00057940b9f5c59dUL;
   tf->codes[13603] = 0x00057952cc188d68UL;
   tf->codes[13604] = 0x0005795306a7932dUL;
   tf->codes[13605] = 0x00057956af97ef7dUL;
   tf->codes[13606] = 0x00057963b970385aUL;
   tf->codes[13607] = 0x000579751be5eed6UL;
   tf->codes[13608] = 0x0005797640b10bafUL;
   tf->codes[13609] = 0x000579872e08b6a1UL;
   tf->codes[13610] = 0x0005799228d9cb91UL;
   tf->codes[13611] = 0x000579b2debe049cUL;
   tf->codes[13612] = 0x000579b85c268f14UL;
   tf->codes[13613] = 0x000579d47ede54bbUL;
   tf->codes[13614] = 0x000579d7b2b0a581UL;
   tf->codes[13615] = 0x00057a1450bd9e6eUL;
   tf->codes[13616] = 0x00057a1d3c877f71UL;
   tf->codes[13617] = 0x00057a4d45da3b0bUL;
   tf->codes[13618] = 0x00057a4e3016521fUL;
   tf->codes[13619] = 0x00057a5e3331e5fdUL;
   tf->codes[13620] = 0x00057a68f373f528UL;
   tf->codes[13621] = 0x00057a76acf94f54UL;
   tf->codes[13622] = 0x00057a8ca29b7934UL;
   tf->codes[13623] = 0x00057a98fcc6b0c2UL;
   tf->codes[13624] = 0x00057a9c6b28074dUL;
   tf->codes[13625] = 0x00057aafdca4f1b6UL;
   tf->codes[13626] = 0x00057ab7de32bba5UL;
   tf->codes[13627] = 0x00057abe806662f6UL;
   tf->codes[13628] = 0x00057acbc4cdb198UL;
   tf->codes[13629] = 0x00057ad76f4bd7d7UL;
   tf->codes[13630] = 0x00057ada2e001d13UL;
   tf->codes[13631] = 0x00057ae9bbfda567UL;
   tf->codes[13632] = 0x00057af70064f409UL;
   tf->codes[13633] = 0x00057af89a4e1c6cUL;
   tf->codes[13634] = 0x00057afae3e4561eUL;
   tf->codes[13635] = 0x00057b07b32d9936UL;
   tf->codes[13636] = 0x00057b1aea1b7ddaUL;
   tf->codes[13637] = 0x00057b218c4f252bUL;
   tf->codes[13638] = 0x00057b35385b1559UL;
   tf->codes[13639] = 0x00057b52ba6cfd9eUL;
   tf->codes[13640] = 0x00057b6ea295bd80UL;
   tf->codes[13641] = 0x00057b94d5e28103UL;
   tf->codes[13642] = 0x00057bc3ba6a1fc4UL;
   tf->codes[13643] = 0x00057bc97261b001UL;
   tf->codes[13644] = 0x00057bee80e356abUL;
   tf->codes[13645] = 0x00057befe03d7949UL;
   tf->codes[13646] = 0x00057c01b7d13b4fUL;
   tf->codes[13647] = 0x00057c1b5663c17fUL;
   tf->codes[13648] = 0x00057c35a4a358feUL;
   tf->codes[13649] = 0x00057c3c46d7004fUL;
   tf->codes[13650] = 0x00057c606b1c8fe5UL;
   tf->codes[13651] = 0x00057c68a7395f99UL;
   tf->codes[13652] = 0x00057c7a09af1615UL;
   tf->codes[13653] = 0x00057c94927db359UL;
   tf->codes[13654] = 0x00057c9abf934f20UL;
   tf->codes[13655] = 0x00057cb24f1ea163UL;
   tf->codes[13656] = 0x00057cd2ca73d4a9UL;
   tf->codes[13657] = 0x00057cd847dc5f21UL;
   tf->codes[13658] = 0x00057cd96ca77bfaUL;
   tf->codes[13659] = 0x00057cddffd3ef5eUL;
   tf->codes[13660] = 0x00057cf4dfb23052UL;
   tf->codes[13661] = 0x00057cf6eeb9643fUL;
   tf->codes[13662] = 0x00057cf9384f9df1UL;
   tf->codes[13663] = 0x00057d0816a014f6UL;
   tf->codes[13664] = 0x00057d6480552fdaUL;
   tf->codes[13665] = 0x00057d6a384cc017UL;
   tf->codes[13666] = 0x00057d756dacdaccUL;
   tf->codes[13667] = 0x00057d7c84fe8da7UL;
   tf->codes[13668] = 0x00057d911b4694e9UL;
   tf->codes[13669] = 0x00057d92efbec311UL;
   tf->codes[13670] = 0x00057d9e5fade38bUL;
   tf->codes[13671] = 0x00057dbea074110cUL;
   tf->codes[13672] = 0x00057dc7c6ccf7d4UL;
   tf->codes[13673] = 0x00057dea8bb864ccUL;
   tf->codes[13674] = 0x00057df2c7d53480UL;
   tf->codes[13675] = 0x00057e142d667edaUL;
   tf->codes[13676] = 0x00057e481a389c89UL;
   tf->codes[13677] = 0x00057e547463d417UL;
   tf->codes[13678] = 0x00057e5857e3362cUL;
   tf->codes[13679] = 0x00057e6d28ba4333UL;
   tf->codes[13680] = 0x00057e8b5a793cc7UL;
   tf->codes[13681] = 0x00057e8c44b553dbUL;
   tf->codes[13682] = 0x00057e8d2ef16aefUL;
   tf->codes[13683] = 0x00057e92e6e8fb2cUL;
   tf->codes[13684] = 0x00057ec9926f5e17UL;
   tf->codes[13685] = 0x00057ee71481465cUL;
   tf->codes[13686] = 0x00057eed0707dc5eUL;
   tf->codes[13687] = 0x00057efdf45f8750UL;
   tf->codes[13688] = 0x00057f0546403ff0UL;
   tf->codes[13689] = 0x00057f078fd679a2UL;
   tf->codes[13690] = 0x00057f2fd22a7112UL;
   tf->codes[13691] = 0x00057f36aeed1e28UL;
   tf->codes[13692] = 0x00057f41a9be3318UL;
   tf->codes[13693] = 0x00057f4552ae8f68UL;
   tf->codes[13694] = 0x00057f467779ac41UL;
   tf->codes[13695] = 0x00057f5346c2ef59UL;
   tf->codes[13696] = 0x00057f5605773495UL;
   tf->codes[13697] = 0x00057f7fe1b45468UL;
   tf->codes[13698] = 0x00057f8b8c327aa7UL;
   tf->codes[13699] = 0x00057f8c3bdf8bf6UL;
   tf->codes[13700] = 0x00057f9059edf3d0UL;
   tf->codes[13701] = 0x00057fa68a1f2375UL;
   tf->codes[13702] = 0x00057fbc0aa341cbUL;
   tf->codes[13703] = 0x00057fbf3e759291UL;
   tf->codes[13704] = 0x00057fc112edc0b9UL;
   tf->codes[13705] = 0x00057fc4f66d22ceUL;
   tf->codes[13706] = 0x00057fce91e41520UL;
   tf->codes[13707] = 0x00057fd200456babUL;
   tf->codes[13708] = 0x00057ff2b629a4b6UL;
   tf->codes[13709] = 0x00057ffdeb89bf6bUL;
   tf->codes[13710] = 0x0005800159eb15f6UL;
   tf->codes[13711] = 0x0005800c8f4b30abUL;
   tf->codes[13712] = 0x0005800cc9da3670UL;
   tf->codes[13713] = 0x0005801d7ca2db9dUL;
   tf->codes[13714] = 0x0005801f511b09c5UL;
   tf->codes[13715] = 0x0005802df4dc7b05UL;
   tf->codes[13716] = 0x00058031633dd190UL;
   tf->codes[13717] = 0x0005803212eae2dfUL;
   tf->codes[13718] = 0x00058035f66a44f4UL;
   tf->codes[13719] = 0x0005803b73d2cf6cUL;
   tf->codes[13720] = 0x000580466ea3e45cUL;
   tf->codes[13721] = 0x00058051de9304d6UL;
   tf->codes[13722] = 0x00058055fca16cb0UL;
   tf->codes[13723] = 0x0005805e38be3c64UL;
   tf->codes[13724] = 0x0005805e734d4229UL;
   tf->codes[13725] = 0x0005807344244f30UL;
   tf->codes[13726] = 0x00058075189c7d58UL;
   tf->codes[13727] = 0x00058079abc8f0bcUL;
   tf->codes[13728] = 0x0005807ad0940d95UL;
   tf->codes[13729] = 0x00058083f6ecf45dUL;
   tf->codes[13730] = 0x0005808e7c9ffdc3UL;
   tf->codes[13731] = 0x0005809902530729UL;
   tf->codes[13732] = 0x0005809b115a3b16UL;
   tf->codes[13733] = 0x000580d18251983cUL;
   tf->codes[13734] = 0x000580da6e1b793fUL;
   tf->codes[13735] = 0x000580de8c29e119UL;
   tf->codes[13736] = 0x000580ec0b203580UL;
   tf->codes[13737] = 0x000580f14df9ba33UL;
   tf->codes[13738] = 0x000580f56c08220dUL;
   tf->codes[13739] = 0x000580f690d33ee6UL;
   tf->codes[13740] = 0x000581091814123bUL;
   tf->codes[13741] = 0x000581102f65c516UL;
   tf->codes[13742] = 0x0005811203ddf33eUL;
   tf->codes[13743] = 0x00058118a6119a8fUL;
   tf->codes[13744] = 0x0005811955beabdeUL;
   tf->codes[13745] = 0x0005811de8eb1f42UL;
   tf->codes[13746] = 0x0005812fc07ee148UL;
   tf->codes[13747] = 0x0005813453ab54acUL;
   tf->codes[13748] = 0x00058137fc9bb0fcUL;
   tf->codes[13749] = 0x0005813a0ba2e4e9UL;
   tf->codes[13750] = 0x000581415d839d89UL;
   tf->codes[13751] = 0x000581462b3f16b2UL;
   tf->codes[13752] = 0x0005815f54b39158UL;
   tf->codes[13753] = 0x000581600460a2a7UL;
   tf->codes[13754] = 0x0005817300bf8186UL;
   tf->codes[13755] = 0x00058176a9afddd6UL;
   tf->codes[13756] = 0x0005817dfb909676UL;
   tf->codes[13757] = 0x00058198beee397fUL;
   tf->codes[13758] = 0x0005819c67de95cfUL;
   tf->codes[13759] = 0x000581a8c209cd5dUL;
   tf->codes[13760] = 0x000581bef23afd02UL;
   tf->codes[13761] = 0x000581c2609c538dUL;
   tf->codes[13762] = 0x000581c3bff6762bUL;
   tf->codes[13763] = 0x000581c3fa857bf0UL;
   tf->codes[13764] = 0x000581c6098cafddUL;
   tf->codes[13765] = 0x000581c977ee0668UL;
   tf->codes[13766] = 0x000581ca622a1d7cUL;
   tf->codes[13767] = 0x000581cd20de62b8UL;
   tf->codes[13768] = 0x000581d438301593UL;
   tf->codes[13769] = 0x000581def87224beUL;
   tf->codes[13770] = 0x000581f59dc15fedUL;
   tf->codes[13771] = 0x000581f85c75a529UL;
   tf->codes[13772] = 0x00058233d5b7813dUL;
   tf->codes[13773] = 0x0005824f0e332fd0UL;
   tf->codes[13774] = 0x0005824ff86f46e4UL;
   tf->codes[13775] = 0x0005825242058096UL;
   tf->codes[13776] = 0x00058255eaf5dce6UL;
   tf->codes[13777] = 0x000582574a4fff84UL;
   tf->codes[13778] = 0x00058257f9fd10d3UL;
   tf->codes[13779] = 0x000582641999429cUL;
   tf->codes[13780] = 0x00058271988f9703UL;
   tf->codes[13781] = 0x00058276a0da15f1UL;
   tf->codes[13782] = 0x00058279d4ac66b7UL;
   tf->codes[13783] = 0x0005828d80b856e5UL;
   tf->codes[13784] = 0x00058296a7113dadUL;
   tf->codes[13785] = 0x0005829df8f1f64dUL;
   tf->codes[13786] = 0x000582c675d4f382UL;
   tf->codes[13787] = 0x000582c79aa0105bUL;
   tf->codes[13788] = 0x000582c884dc276fUL;
   tf->codes[13789] = 0x000582ceb1f1c336UL;
   tf->codes[13790] = 0x000582d30a8f30d5UL;
   tf->codes[13791] = 0x000583159b22bfc4UL;
   tf->codes[13792] = 0x0005831c02c76150UL;
   tf->codes[13793] = 0x0005831e86eca0c7UL;
   tf->codes[13794] = 0x0005832772b681caUL;
   tf->codes[13795] = 0x00058337b0611b6dUL;
   tf->codes[13796] = 0x00058345a4757b5eUL;
   tf->codes[13797] = 0x0005835c0f35b0c8UL;
   tf->codes[13798] = 0x000583674495cb7dUL;
   tf->codes[13799] = 0x000583698e2c052fUL;
   tf->codes[13800] = 0x0005836a034a10b9UL;
   tf->codes[13801] = 0x000583811db75772UL;
   tf->codes[13802] = 0x00058384c6a7b3c2UL;
   tf->codes[13803] = 0x0005838af3bd4f89UL;
   tf->codes[13804] = 0x000583a666c803e1UL;
   tf->codes[13805] = 0x000583c582c31489UL;
   tf->codes[13806] = 0x000583d6701abf7bUL;
   tf->codes[13807] = 0x000583edffa611beUL;
   tf->codes[13808] = 0x000583f1a8966e0eUL;
   tf->codes[13809] = 0x00058406b3fc80daUL;
   tf->codes[13810] = 0x000584130e27b868UL;
   tf->codes[13811] = 0x0005841fa2e1f5bbUL;
   tf->codes[13812] = 0x000584381ca95f12UL;
   tf->codes[13813] = 0x000584452681a7efUL;
   tf->codes[13814] = 0x00058446c06ad052UL;
   tf->codes[13815] = 0x00058446faf9d617UL;
   tf->codes[13816] = 0x00058457adc27b44UL;
   tf->codes[13817] = 0x00058461f8e67ee5UL;
   tf->codes[13818] = 0x000584773edb9776UL;
   tf->codes[13819] = 0x0005849a78e50ff8UL;
   tf->codes[13820] = 0x0005849cfd0a4f6fUL;
   tf->codes[13821] = 0x000584b417779628UL;
   tf->codes[13822] = 0x000584d0e9dc6d1eUL;
   tf->codes[13823] = 0x000584d5b797e647UL;
   tf->codes[13824] = 0x000584d8b0db3148UL;
   tf->codes[13825] = 0x000584dbaa1e7c49UL;
   tf->codes[13826] = 0x000584dccee99922UL;
   tf->codes[13827] = 0x000584ed81b23e4fUL;
   tf->codes[13828] = 0x000584edbc414414UL;
   tf->codes[13829] = 0x000584ef90b9723cUL;
   tf->codes[13830] = 0x000584fc9a91bb19UL;
   tf->codes[13831] = 0x00058519a78597d4UL;
   tf->codes[13832] = 0x0005851a91c1aee8UL;
   tf->codes[13833] = 0x0005851eea5f1c87UL;
   tf->codes[13834] = 0x0005853380a723c9UL;
   tf->codes[13835] = 0x00058545583ae5cfUL;
   tf->codes[13836] = 0x00058554368b5cd4UL;
   tf->codes[13837] = 0x0005856ef9e8ffddUL;
   tf->codes[13838] = 0x0005858614564696UL;
   tf->codes[13839] = 0x0005859358bd9538UL;
   tf->codes[13840] = 0x000585e0e4223917UL;
   tf->codes[13841] = 0x000585fb3261d096UL;
   tf->codes[13842] = 0x0005860f8e1ad213UL;
   tf->codes[13843] = 0x0005860fc8a9d7d8UL;
   tf->codes[13844] = 0x0005863f5cde87e8UL;
   tf->codes[13845] = 0x00058655c79ebd52UL;
   tf->codes[13846] = 0x0005866ca77cfe46UL;
   tf->codes[13847] = 0x000586729a039448UL;
   tf->codes[13848] = 0x0005867e09f2b4c2UL;
   tf->codes[13849] = 0x0005867eb99fc611UL;
   tf->codes[13850] = 0x0005868dd27f42dbUL;
   tf->codes[13851] = 0x000586b14717c122UL;
   tf->codes[13852] = 0x000586c5a2d0c29fUL;
   tf->codes[13853] = 0x000586d0d830dd54UL;
   tf->codes[13854] = 0x000586d1c26cf468UL;
   tf->codes[13855] = 0x000586d396e52290UL;
   tf->codes[13856] = 0x000586ecfae8a2fbUL;
   tf->codes[13857] = 0x000586f83048bdb0UL;
   tf->codes[13858] = 0x0005870fbfd40ff3UL;
   tf->codes[13859] = 0x0005870ffa6315b8UL;
   tf->codes[13860] = 0x00058728aeb984d4UL;
   tf->codes[13861] = 0x00058732bf4e82b0UL;
   tf->codes[13862] = 0x0005875633e700f7UL;
   tf->codes[13863] = 0x00058756e3941246UL;
   tf->codes[13864] = 0x000587633dbf49d4UL;
   tf->codes[13865] = 0x00058770bcb59e3bUL;
   tf->codes[13866] = 0x000587775ee9458cUL;
   tf->codes[13867] = 0x0005877b07d9a1dcUL;
   tf->codes[13868] = 0x0005879814cd7e97UL;
   tf->codes[13869] = 0x0005879b489fcf5dUL;
   tf->codes[13870] = 0x000587c858af3ff6UL;
   tf->codes[13871] = 0x000587c8933e45bbUL;
   tf->codes[13872] = 0x0005881fba19dbecUL;
   tf->codes[13873] = 0x0005882dae2e3bddUL;
   tf->codes[13874] = 0x000588345061e32eUL;
   tf->codes[13875] = 0x0005883833e14543UL;
   tf->codes[13876] = 0x0005884418ee7147UL;
   tf->codes[13877] = 0x0005884627f5a534UL;
   tf->codes[13878] = 0x0005885a0e909b27UL;
   tf->codes[13879] = 0x00058860b0c44278UL;
   tf->codes[13880] = 0x00058875819b4f7fUL;
   tf->codes[13881] = 0x0005887790a2836cUL;
   tf->codes[13882] = 0x0005889587d2773bUL;
   tf->codes[13883] = 0x00058895c2617d00UL;
   tf->codes[13884] = 0x000588b1aa8a3ce2UL;
   tf->codes[13885] = 0x000588b42eaf7c59UL;
   tf->codes[13886] = 0x000588bdca266eabUL;
   tf->codes[13887] = 0x000588c556962d10UL;
   tf->codes[13888] = 0x000588d0c6854d8aUL;
   tf->codes[13889] = 0x000588d72e29ef16UL;
   tf->codes[13890] = 0x000588ed5e5b1ebbUL;
   tf->codes[13891] = 0x0005891bcdc4b1f2UL;
   tf->codes[13892] = 0x0005891e51e9f169UL;
   tf->codes[13893] = 0x00058940a1b752d7UL;
   tf->codes[13894] = 0x00058945aa01d1c5UL;
   tf->codes[13895] = 0x0005895ab567e491UL;
   tf->codes[13896] = 0x000589648b6ddca8UL;
   tf->codes[13897] = 0x0005897996d3ef74UL;
   tf->codes[13898] = 0x0005898f17580dcaUL;
   tf->codes[13899] = 0x0005899e6ac69059UL;
   tf->codes[13900] = 0x000589b51015cb88UL;
   tf->codes[13901] = 0x000589b843e81c4eUL;
   tf->codes[13902] = 0x000589bbecd8789eUL;
   tf->codes[13903] = 0x000589c3b3d73cc8UL;
   tf->codes[13904] = 0x000589e135e9250dUL;
   tf->codes[13905] = 0x000589e4a44a7b98UL;
   tf->codes[13906] = 0x000589fbbeb7c251UL;
   tf->codes[13907] = 0x00058a2943e53e74UL;
   tf->codes[13908] = 0x00058a2d61f3a64eUL;
   tf->codes[13909] = 0x00058a32df5c30c6UL;
   tf->codes[13910] = 0x00058a39bc1edddcUL;
   tf->codes[13911] = 0x00058a41831da206UL;
   tf->codes[13912] = 0x00058a49bf3a71baUL;
   tf->codes[13913] = 0x00058a49f9c9777fUL;
   tf->codes[13914] = 0x00058a51fb57416eUL;
   tf->codes[13915] = 0x00058a718c705da0UL;
   tf->codes[13916] = 0x00058a723c1d6eefUL;
   tf->codes[13917] = 0x00058a7f0b66b207UL;
   tf->codes[13918] = 0x00058a948bead05dUL;
   tf->codes[13919] = 0x00058a96d5810a0fUL;
   tf->codes[13920] = 0x00058ab99a6c7707UL;
   tf->codes[13921] = 0x00058abea2b6f5f5UL;
   tf->codes[13922] = 0x00058ac544ea9d46UL;
   tf->codes[13923] = 0x00058aca12a6166fUL;
   tf->codes[13924] = 0x00058ae7cf470479UL;
   tf->codes[13925] = 0x00058aecd7918367UL;
   tf->codes[13926] = 0x00058aedc1cd9a7bUL;
   tf->codes[13927] = 0x00058af08081dfb7UL;
   tf->codes[13928] = 0x00058b0bf38c940fUL;
   tf->codes[13929] = 0x00058b1220a22fd6UL;
   tf->codes[13930] = 0x00058b16042191ebUL;
   tf->codes[13931] = 0x00058b39b34915f7UL;
   tf->codes[13932] = 0x00058b4b8adcd7fdUL;
   tf->codes[13933] = 0x00058b605bb3e504UL;
   tf->codes[13934] = 0x00058b6b5684f9f4UL;
   tf->codes[13935] = 0x00058b6f3a045c09UL;
   tf->codes[13936] = 0x00058b7407bfd532UL;
   tf->codes[13937] = 0x00058b7a34d570f9UL;
   tf->codes[13938] = 0x00058b7a6f6476beUL;
   tf->codes[13939] = 0x00058b7c43dca4e6UL;
   tf->codes[13940] = 0x00058b7e1854d30eUL;
   tf->codes[13941] = 0x00058b93d367f729UL;
   tf->codes[13942] = 0x00058baff61fbcd0UL;
   tf->codes[13943] = 0x00058bb7828f7b35UL;
   tf->codes[13944] = 0x00058bbaf0f0d1c0UL;
   tf->codes[13945] = 0x00058bbe24c32286UL;
   tf->codes[13946] = 0x00058bbe99e12e10UL;
   tf->codes[13947] = 0x00058bc033ca5673UL;
   tf->codes[13948] = 0x00058bc0a8e861fdUL;
   tf->codes[13949] = 0x00058bc994b24300UL;
   tf->codes[13950] = 0x00058bd454f4522bUL;
   tf->codes[13951] = 0x00058bdf4fc5671bUL;
   tf->codes[13952] = 0x00058be2be26bda6UL;
   tf->codes[13953] = 0x00058c0214b0d413UL;
   tf->codes[13954] = 0x00058c0a50cda3c7UL;
   tf->codes[13955] = 0x00058c0f1e891cf0UL;
   tf->codes[13956] = 0x00058c13b1b59054UL;
   tf->codes[13957] = 0x00058c19a43c2656UL;
   tf->codes[13958] = 0x00058c300efc5bc0UL;
   tf->codes[13959] = 0x00058c32cdb0a0fcUL;
   tf->codes[13960] = 0x00058c42d0cc34daUL;
   tf->codes[13961] = 0x00058c46eeda9cb4UL;
   tf->codes[13962] = 0x00058c4ad259fec9UL;
   tf->codes[13963] = 0x00058c4f2af76c68UL;
   tf->codes[13964] = 0x00058c5607ba197eUL;
   tf->codes[13965] = 0x00058c5e7e65eef7UL;
   tf->codes[13966] = 0x00058c86c0b9e667UL;
   tf->codes[13967] = 0x00058c9096bfde7eUL;
   tf->codes[13968] = 0x00058c990d6bb3f7UL;
   tf->codes[13969] = 0x00058c9a6cc5d695UL;
   tf->codes[13970] = 0x00058cb35bab4b76UL;
   tf->codes[13971] = 0x00058cb6ca0ca201UL;
   tf->codes[13972] = 0x00058cbf062971b5UL;
   tf->codes[13973] = 0x00058cc239fbc27bUL;
   tf->codes[13974] = 0x00058cc40e73f0a3UL;
   tf->codes[13975] = 0x00058ccab0a797f4UL;
   tf->codes[13976] = 0x00058ce32a6f014bUL;
   tf->codes[13977] = 0x00058ce4c45829aeUL;
   tf->codes[13978] = 0x00058cefbf293e9eUL;
   tf->codes[13979] = 0x00058ceff9b84463UL;
   tf->codes[13980] = 0x00058cf193a16cc6UL;
   tf->codes[13981] = 0x00058cf6d67af179UL;
   tf->codes[13982] = 0x00058cf95aa030f0UL;
   tf->codes[13983] = 0x00058cfd03908d40UL;
   tf->codes[13984] = 0x00058d1ea3b0dd5fUL;
   tf->codes[13985] = 0x00058d3cd56fd6f3UL;
   tf->codes[13986] = 0x00058d480acff1a8UL;
   tf->codes[13987] = 0x00058d48f50c08bcUL;
   tf->codes[13988] = 0x00058d4f973fb00dUL;
   tf->codes[13989] = 0x00058d5eeaae329cUL;
   tf->codes[13990] = 0x00058d6c2f15813eUL;
   tf->codes[13991] = 0x00058d71ac7e0bb6UL;
   tf->codes[13992] = 0x00058d7296ba22caUL;
   tf->codes[13993] = 0x00058d751adf6241UL;
   tf->codes[13994] = 0x00058d78c3cfbe91UL;
   tf->codes[13995] = 0x00058d7fdb21716cUL;
   tf->codes[13996] = 0x00058d8e09c4d722UL;
   tf->codes[13997] = 0x00058d8f2e8ff3fbUL;
   tf->codes[13998] = 0x00058d9979b3f79cUL;
   tf->codes[13999] = 0x00058dc2a6440620UL;
   tf->codes[14000] = 0x00058dd826c82476UL;
   tf->codes[14001] = 0x00058ddc0a47868bUL;
   tf->codes[14002] = 0x00058df2ea25c77fUL;
   tf->codes[14003] = 0x00058df8dcac5d81UL;
   tf->codes[14004] = 0x00058e08dfc7f15fUL;
   tf->codes[14005] = 0x00058e16d3dc5150UL;
   tf->codes[14006] = 0x00058e4c5a979762UL;
   tf->codes[14007] = 0x00058e5f56f67641UL;
   tf->codes[14008] = 0x00058eaf2bf153d2UL;
   tf->codes[14009] = 0x00058ec1038515d8UL;
   tf->codes[14010] = 0x00058ec9b4bff116UL;
   tf->codes[14011] = 0x00058ed55f3e1755UL;
   tf->codes[14012] = 0x00058ee22e875a6dUL;
   tf->codes[14013] = 0x00058ef0d248cbadUL;
   tf->codes[14014] = 0x00058ef98383a6ebUL;
   tf->codes[14015] = 0x00058efcb755f7b1UL;
   tf->codes[14016] = 0x00058eff3b7b3728UL;
   tf->codes[14017] = 0x00058f15e0ca7257UL;
   tf->codes[14018] = 0x00058f2ecfafe738UL;
   tf->codes[14019] = 0x00058f4e2639fda5UL;
   tf->codes[14020] = 0x00058f699944b1fdUL;
   tf->codes[14021] = 0x00058f6b332dda60UL;
   tf->codes[14022] = 0x00058f77183b0664UL;
   tf->codes[14023] = 0x00058f8f1ce46431UL;
   tf->codes[14024] = 0x00058f963436170cUL;
   tf->codes[14025] = 0x00058fbdc6dcfd2dUL;
   tf->codes[14026] = 0x00058fcf63e1b96eUL;
   tf->codes[14027] = 0x00058fd4a6bb3e21UL;
   tf->codes[14028] = 0x00058fe902743f9eUL;
   tf->codes[14029] = 0x000590022be8ba44UL;
   tf->codes[14030] = 0x0005900649f7221eUL;
   tf->codes[14031] = 0x00059006848627e3UL;
   tf->codes[14032] = 0x0005900e10f5e648UL;
   tf->codes[14033] = 0x0005903ddfb99c1dUL;
   tf->codes[14034] = 0x000590544a79d187UL;
   tf->codes[14035] = 0x0005905dab61be14UL;
   tf->codes[14036] = 0x0005906fbd8485dfUL;
   tf->codes[14037] = 0x0005907f861113f8UL;
   tf->codes[14038] = 0x0005908244c55934UL;
   tf->codes[14039] = 0x0005908ba5ad45c1UL;
   tf->codes[14040] = 0x000590c843ba3eaeUL;
   tf->codes[14041] = 0x000590d9a62ff52aUL;
   tf->codes[14042] = 0x000590de73eb6e53UL;
   tf->codes[14043] = 0x000590e75fb54f56UL;
   tf->codes[14044] = 0x000590f7d7eeeebeUL;
   tf->codes[14045] = 0x000590f9ac671ce6UL;
   tf->codes[14046] = 0x000590fc6b1b6222UL;
   tf->codes[14047] = 0x000590fca5aa67e7UL;
   tf->codes[14048] = 0x0005911902f13353UL;
   tf->codes[14049] = 0x0005911bfc347e54UL;
   tf->codes[14050] = 0x00059136fa212722UL;
   tf->codes[14051] = 0x0005913c3cfaabd5UL;
   tf->codes[14052] = 0x000591482207d7d9UL;
   tf->codes[14053] = 0x000591490c43eeedUL;
   tf->codes[14054] = 0x0005914b1b4b22daUL;
   tf->codes[14055] = 0x0005914e4f1d73a0UL;
   tf->codes[14056] = 0x00059169c22827f8UL;
   tf->codes[14057] = 0x0005916b96a05620UL;
   tf->codes[14058] = 0x00059172e8810ec0UL;
   tf->codes[14059] = 0x0005917656e2654bUL;
   tf->codes[14060] = 0x0005917865e99938UL;
   tf->codes[14061] = 0x00059186cf1c04b3UL;
   tf->codes[14062] = 0x0005919ed3c56280UL;
   tf->codes[14063] = 0x000591ba46d016d8UL;
   tf->codes[14064] = 0x000591bbe0b93f3bUL;
   tf->codes[14065] = 0x000591c541a12bc8UL;
   tf->codes[14066] = 0x000591c99a3e9967UL;
   tf->codes[14067] = 0x000591c9d4cd9f2cUL;
   tf->codes[14068] = 0x000591cc1e63d8deUL;
   tf->codes[14069] = 0x000591e8068c98c0UL;
   tf->codes[14070] = 0x000591ed49661d73UL;
   tf->codes[14071] = 0x000592100e518a6bUL;
   tf->codes[14072] = 0x00059232238fe614UL;
   tf->codes[14073] = 0x0005924c374077ceUL;
   tf->codes[14074] = 0x00059251b4a90246UL;
   tf->codes[14075] = 0x0005926d6242bc63UL;
   tf->codes[14076] = 0x000592844220fd57UL;
   tf->codes[14077] = 0x0005928d2deade5aUL;
   tf->codes[14078] = 0x00059293d01e85abUL;
   tf->codes[14079] = 0x0005929e906094d6UL;
   tf->codes[14080] = 0x000592cc8aac1c83UL;
   tf->codes[14081] = 0x000592d7c00c3738UL;
   tf->codes[14082] = 0x000592dc8dc7b061UL;
   tf->codes[14083] = 0x000592f78bb4592fUL;
   tf->codes[14084] = 0x0005930286856e1fUL;
   tf->codes[14085] = 0x000593321aba1e2fUL;
   tf->codes[14086] = 0x000593442cdce5faUL;
   tf->codes[14087] = 0x0005934a94818786UL;
   tf->codes[14088] = 0x000593767fc5db46UL;
   tf->codes[14089] = 0x0005938c3ad8ff61UL;
   tf->codes[14090] = 0x000593cf408a99daUL;
   tf->codes[14091] = 0x000593d02ac6b0eeUL;
   tf->codes[14092] = 0x000593d7421863c9UL;
   tf->codes[14093] = 0x000593dcfa0ff406UL;
   tf->codes[14094] = 0x000593f7f7fc9cd4UL;
   tf->codes[14095] = 0x000593fbdb7bfee9UL;
   tf->codes[14096] = 0x000594041798ce9dUL;
   tf->codes[14097] = 0x00059410e6e211b5UL;
   tf->codes[14098] = 0x0005941e65d8661cUL;
   tf->codes[14099] = 0x0005941f50147d30UL;
   tf->codes[14100] = 0x00059438eea70360UL;
   tf->codes[14101] = 0x0005943df6f1824eUL;
   tf->codes[14102] = 0x0005943fcb69b076UL;
   tf->codes[14103] = 0x00059449dbfeae52UL;
   tf->codes[14104] = 0x00059453b204a669UL;
   tf->codes[14105] = 0x0005948430756d8dUL;
   tf->codes[14106] = 0x000594cfe761e344UL;
   tf->codes[14107] = 0x000594ecb9c6ba3aUL;
   tf->codes[14108] = 0x000594f7ef26d4efUL;
   tf->codes[14109] = 0x0005951cc31975d4UL;
   tf->codes[14110] = 0x000595327e2c99efUL;
   tf->codes[14111] = 0x0005954e2bc6540cUL;
   tf->codes[14112] = 0x0005956fcbe6a42bUL;
   tf->codes[14113] = 0x0005957c9b2fe743UL;
   tf->codes[14114] = 0x000595900cacd1acUL;
   tf->codes[14115] = 0x000595ce44a2f2fcUL;
   tf->codes[14116] = 0x000595d60ba1b726UL;
   tf->codes[14117] = 0x000595e8585384b6UL;
   tf->codes[14118] = 0x000595eebff82642UL;
   tf->codes[14119] = 0x000595f771330180UL;
   tf->codes[14120] = 0x000596068a127e4aUL;
   tf->codes[14121] = 0x00059612e43db5d8UL;
   tf->codes[14122] = 0x0005961d2f61b979UL;
   tf->codes[14123] = 0x0005961fee15feb5UL;
   tf->codes[14124] = 0x0005963115fcaf6cUL;
   tf->codes[14125] = 0x00059636cdf43fa9UL;
   tf->codes[14126] = 0x000596377da150f8UL;
   tf->codes[14127] = 0x0005965365ca10daUL;
   tf->codes[14128] = 0x000596641892b607UL;
   tf->codes[14129] = 0x0005967072bded95UL;
   tf->codes[14130] = 0x00059675407966beUL;
   tf->codes[14131] = 0x000596945c747766UL;
   tf->codes[14132] = 0x0005969a146c07a3UL;
   tf->codes[14133] = 0x000596d468e2c6deUL;
   tf->codes[14134] = 0x000596eeb7225e5dUL;
   tf->codes[14135] = 0x0005970a2a2d12b5UL;
   tf->codes[14136] = 0x0005972efe1fb39aUL;
   tf->codes[14137] = 0x0005972fadccc4e9UL;
   tf->codes[14138] = 0x0005975322654330UL;
   tf->codes[14139] = 0x0005975a39b6f60bUL;
   tf->codes[14140] = 0x00059776d18cc73cUL;
   tf->codes[14141] = 0x00059793a3f19e32UL;
   tf->codes[14142] = 0x000597995be92e6fUL;
   tf->codes[14143] = 0x0005979d3f689084UL;
   tf->codes[14144] = 0x0005979f4e6fc471UL;
   tf->codes[14145] = 0x000597c2c30842b8UL;
   tf->codes[14146] = 0x000597c4978070e0UL;
   tf->codes[14147] = 0x000597ca4f78011dUL;
   tf->codes[14148] = 0x000597d49a9c04beUL;
   tf->codes[14149] = 0x000597e5c282b575UL;
   tf->codes[14150] = 0x000597e9a602178aUL;
   tf->codes[14151] = 0x000597fbf2b3e51aUL;
   tf->codes[14152] = 0x000597fd8c9d0d7dUL;
   tf->codes[14153] = 0x00059807d7c1111eUL;
   tf->codes[14154] = 0x00059812d292260eUL;
   tf->codes[14155] = 0x0005984475ce0a0bUL;
   tf->codes[14156] = 0x000598517fa652e8UL;
   tf->codes[14157] = 0x0005985478e99de9UL;
   tf->codes[14158] = 0x0005986441762c02UL;
   tf->codes[14159] = 0x0005986bcde5ea67UL;
   tf->codes[14160] = 0x000598770346051cUL;
   tf->codes[14161] = 0x00059879124d3909UL;
   tf->codes[14162] = 0x000598794cdc3eceUL;
   tf->codes[14163] = 0x00059890a1d88b4cUL;
   tf->codes[14164] = 0x0005989aecfc8eedUL;
   tf->codes[14165] = 0x000598c95c662224UL;
   tf->codes[14166] = 0x000598ce2a219b4dUL;
   tf->codes[14167] = 0x000598df8c9751c9UL;
   tf->codes[14168] = 0x000598e509ffdc41UL;
   tf->codes[14169] = 0x000598ea4cd960f4UL;
   tf->codes[14170] = 0x000598fa4ff4f4d2UL;
   tf->codes[14171] = 0x000599012cb7a1e8UL;
   tf->codes[14172] = 0x000599087e985a88UL;
   tf->codes[14173] = 0x000599363e54dc70UL;
   tf->codes[14174] = 0x00059949afd1c6d9UL;
   tf->codes[14175] = 0x0005995ad7b87790UL;
   tf->codes[14176] = 0x000599743bbbf7fbUL;
   tf->codes[14177] = 0x00059974764afdc0UL;
   tf->codes[14178] = 0x0005997a2e428dfdUL;
   tf->codes[14179] = 0x0005997c02babc25UL;
   tf->codes[14180] = 0x000599822fd057ecUL;
   tf->codes[14181] = 0x0005998b90b84479UL;
   tf->codes[14182] = 0x0005998ec48a953fUL;
   tf->codes[14183] = 0x0005998f7437a68eUL;
   tf->codes[14184] = 0x000599b657317b60UL;
   tf->codes[14185] = 0x000599d11a8f1e69UL;
   tf->codes[14186] = 0x000599eb2e3fb023UL;
   tf->codes[14187] = 0x000599f8e7c50a4fUL;
   tf->codes[14188] = 0x000599fa81ae32b2UL;
   tf->codes[14189] = 0x000599fd7af17db3UL;
   tf->codes[14190] = 0x00059a1f1b11cdd2UL;
   tf->codes[14191] = 0x00059a321770acb1UL;
   tf->codes[14192] = 0x00059a34d624f1edUL;
   tf->codes[14193] = 0x00059a3794d93729UL;
   tf->codes[14194] = 0x00059a3c6294b052UL;
   tf->codes[14195] = 0x00059a3ee6b9efc9UL;
   tf->codes[14196] = 0x00059a45fe0ba2a4UL;
   tf->codes[14197] = 0x00059a521da7d46dUL;
   tf->codes[14198] = 0x00059a6136875137UL;
   tf->codes[14199] = 0x00059a7223defc29UL;
   tf->codes[14200] = 0x00059a7a5ffbcbddUL;
   tf->codes[14201] = 0x00059a997bf6dc85UL;
   tf->codes[14202] = 0x00059ac02461ab92UL;
   tf->codes[14203] = 0x00059ad2e63184acUL;
   tf->codes[14204] = 0x00059adda67393d7UL;
   tf->codes[14205] = 0x00059aecf9e21666UL;
   tf->codes[14206] = 0x00059afa3e496508UL;
   tf->codes[14207] = 0x00059b0a06d5f321UL;
   tf->codes[14208] = 0x00059b33a8840d2fUL;
   tf->codes[14209] = 0x00059b48ee7925c0UL;
   tf->codes[14210] = 0x00059b66708b0e05UL;
   tf->codes[14211] = 0x00059b7eea52775cUL;
   tf->codes[14212] = 0x00059b96b46ccf64UL;
   tf->codes[14213] = 0x00059b9eb5fa9953UL;
   tf->codes[14214] = 0x00059bce0fa0439eUL;
   tf->codes[14215] = 0x00059bd093c58315UL;
   tf->codes[14216] = 0x00059bf442ed0721UL;
   tf->codes[14217] = 0x00059bf860fb6efbUL;
   tf->codes[14218] = 0x00059bfe538204fdUL;
   tf->codes[14219] = 0x00059bff032f164cUL;
   tf->codes[14220] = 0x00059c16582b62caUL;
   tf->codes[14221] = 0x00059c198bfdb390UL;
   tf->codes[14222] = 0x00059c1e9448327eUL;
   tf->codes[14223] = 0x00059c1f43f543cdUL;
   tf->codes[14224] = 0x00059c8b3ba7e705UL;
   tf->codes[14225] = 0x00059c9dc2e8ba5aUL;
   tf->codes[14226] = 0x00059cab41df0ec1UL;
   tf->codes[14227] = 0x00059caf9a7c7c60UL;
   tf->codes[14228] = 0x00059cd1ea49ddceUL;
   tf->codes[14229] = 0x00059cf140d3f43bUL;
   tf->codes[14230] = 0x00059d038d85c1cbUL;
   tf->codes[14231] = 0x00059d0820b2352fUL;
   tf->codes[14232] = 0x00059d08d05f467eUL;
   tf->codes[14233] = 0x00059d17aeafbd83UL;
   tf->codes[14234] = 0x00059d2cba15d04fUL;
   tf->codes[14235] = 0x00059d40a0b0c642UL;
   tf->codes[14236] = 0x00059d4bd610e0f7UL;
   tf->codes[14237] = 0x00059d5362809f5cUL;
   tf->codes[14238] = 0x00059d557187d349UL;
   tf->codes[14239] = 0x00059d570b70fbacUL;
   tf->codes[14240] = 0x00059d7159b0932bUL;
   tf->codes[14241] = 0x00059d8a0e070247UL;
   tf->codes[14242] = 0x00059d98021b6238UL;
   tf->codes[14243] = 0x00059d9edede0f4eUL;
   tf->codes[14244] = 0x00059dc427eebbbdUL;
   tf->codes[14245] = 0x00059dc8bb1b2f21UL;
   tf->codes[14246] = 0x00059dd340ce3887UL;
   tf->codes[14247] = 0x00059deb45779654UL;
   tf->codes[14248] = 0x00059df013330f7dUL;
   tf->codes[14249] = 0x00059df1728d321bUL;
   tf->codes[14250] = 0x00059dffdbbf9d96UL;
   tf->codes[14251] = 0x00059e0817dc6d4aUL;
   tf->codes[14252] = 0x00059e0f69bd25eaUL;
   tf->codes[14253] = 0x00059e12d81e7c75UL;
   tf->codes[14254] = 0x00059e134d3c87ffUL;
   tf->codes[14255] = 0x00059e37ac111d5aUL;
   tf->codes[14256] = 0x00059e46ff7f9fe9UL;
   tf->codes[14257] = 0x00059e4a3351f0afUL;
   tf->codes[14258] = 0x00059e52a9fdc628UL;
   tf->codes[14259] = 0x00059e552e23059fUL;
   tf->codes[14260] = 0x00059e589c845c2aUL;
   tf->codes[14261] = 0x00059e594c316d79UL;
   tf->codes[14262] = 0x00059e665609b656UL;
   tf->codes[14263] = 0x00059e6d32cc636cUL;
   tf->codes[14264] = 0x00059e8ff7b7d064UL;
   tf->codes[14265] = 0x00059e98e381b167UL;
   tf->codes[14266] = 0x00059e9d76ae24cbUL;
   tf->codes[14267] = 0x00059eb3a6df5470UL;
   tf->codes[14268] = 0x00059ec076289788UL;
   tf->codes[14269] = 0x00059ed92a7f06a4UL;
   tf->codes[14270] = 0x00059ede32c98592UL;
   tf->codes[14271] = 0x00059ee28b66f331UL;
   tf->codes[14272] = 0x00059ee9a2b8a60cUL;
   tf->codes[14273] = 0x00059ef044ec4d5dUL;
   tf->codes[14274] = 0x00059ef1ded575c0UL;
   tf->codes[14275] = 0x00059f00f7b4f28aUL;
   tf->codes[14276] = 0x00059f05ffff7178UL;
   tf->codes[14277] = 0x00059f0bb7f701b5UL;
   tf->codes[14278] = 0x00059f0d17512453UL;
   tf->codes[14279] = 0x00059f0dc6fe35a2UL;
   tf->codes[14280] = 0x00059f297497efbfUL;
   tf->codes[14281] = 0x00059f5350d50f92UL;
   tf->codes[14282] = 0x00059f555fdc437fUL;
   tf->codes[14283] = 0x00059f6771ff0b4aUL;
   tf->codes[14284] = 0x00059f752b846576UL;
   tf->codes[14285] = 0x00059f7e8c6c5203UL;
   tf->codes[14286] = 0x00059f9cf8ba515cUL;
   tf->codes[14287] = 0x00059fc8a96f9f57UL;
   tf->codes[14288] = 0x00059fd19539805aUL;
   tf->codes[14289] = 0x00059ff0ebc396c7UL;
   tf->codes[14290] = 0x0005a0075683cc31UL;
   tf->codes[14291] = 0x0005a01c275ad938UL;
   tf->codes[14292] = 0x0005a01e70f112eaUL;
   tf->codes[14293] = 0x0005a01f95bc2fc3UL;
   tf->codes[14294] = 0x0005a03ace37de56UL;
   tf->codes[14295] = 0x0005a03fd6825d44UL;
   tf->codes[14296] = 0x0005a04f29f0dfd3UL;
   tf->codes[14297] = 0x0005a05138f813c0UL;
   tf->codes[14298] = 0x0005a054a7596a4bUL;
   tf->codes[14299] = 0x0005a05c6e582e75UL;
   tf->codes[14300] = 0x0005a09a3130443bUL;
   tf->codes[14301] = 0x0005a0b5a43af893UL;
   tf->codes[14302] = 0x0005a0bd30aab6f8UL;
   tf->codes[14303] = 0x0005a0c7413fb4d4UL;
   tf->codes[14304] = 0x0005a0c77bceba99UL;
   tf->codes[14305] = 0x0005a0cde3735c25UL;
   tf->codes[14306] = 0x0005a0cf42cd7ec3UL;
   tf->codes[14307] = 0x0005a0fb68a0d848UL;
   tf->codes[14308] = 0x0005a0fba32fde0dUL;
   tf->codes[14309] = 0x0005a105ee53e1aeUL;
   tf->codes[14310] = 0x0005a1120df01377UL;
   tf->codes[14311] = 0x0005a1178b589defUL;
   tf->codes[14312] = 0x0005a132894546bdUL;
   tf->codes[14313] = 0x0005a134d2db806fUL;
   tf->codes[14314] = 0x0005a1363235a30dUL;
   tf->codes[14315] = 0x0005a13a8ad310acUL;
   tf->codes[14316] = 0x0005a13dbea56172UL;
   tf->codes[14317] = 0x0005a13e6e5272c1UL;
   tf->codes[14318] = 0x0005a140b7e8ac73UL;
   tf->codes[14319] = 0x0005a151dfcf5d2aUL;
   tf->codes[14320] = 0x0005a166eb356ff6UL;
   tf->codes[14321] = 0x0005a18dce2f44c8UL;
   tf->codes[14322] = 0x0005a18e7ddc5617UL;
   tf->codes[14323] = 0x0005a1b3173ff137UL;
   tf->codes[14324] = 0x0005a1cb567854c9UL;
   tf->codes[14325] = 0x0005a1d1f8abfc1aUL;
   tf->codes[14326] = 0x0005a1f448795d88UL;
   tf->codes[14327] = 0x0005a1faeaad04d9UL;
   tf->codes[14328] = 0x0005a2023c8dbd79UL;
   tf->codes[14329] = 0x0005a2044b94f166UL;
   tf->codes[14330] = 0x0005a215ae0aa7e2UL;
   tf->codes[14331] = 0x0005a216d2d5c4bbUL;
   tf->codes[14332] = 0x0005a2315ba461ffUL;
   tf->codes[14333] = 0x0005a231963367c4UL;
   tf->codes[14334] = 0x0005a243e2e53554UL;
   tf->codes[14335] = 0x0005a25754621fbdUL;
   tf->codes[14336] = 0x0005a25c5cac9eabUL;
   tf->codes[14337] = 0x0005a26214a42ee8UL;
   tf->codes[14338] = 0x0005a27bedc5baddUL;
   tf->codes[14339] = 0x0005a29b09c0cb85UL;
   tf->codes[14340] = 0x0005a29b444fd14aUL;
   tf->codes[14341] = 0x0005a2b2d3db238dUL;
   tf->codes[14342] = 0x0005a2db50be20c2UL;
   tf->codes[14343] = 0x0005a2f7e893f1f3UL;
   tf->codes[14344] = 0x0005a3073c027482UL;
   tf->codes[14345] = 0x0005a30b1f81d697UL;
   tf->codes[14346] = 0x0005a310625b5b4aUL;
   tf->codes[14347] = 0x0005a3156aa5da38UL;
   tf->codes[14348] = 0x0005a317b43c13eaUL;
   tf->codes[14349] = 0x0005a363e046952bUL;
   tf->codes[14350] = 0x0005a37124ade3cdUL;
   tf->codes[14351] = 0x0005a37960cab381UL;
   tf->codes[14352] = 0x0005a388b4393610UL;
   tf->codes[14353] = 0x0005a388eec83bd5UL;
   tf->codes[14354] = 0x0005a39d4a813d52UL;
   tf->codes[14355] = 0x0005a3b673f5b7f8UL;
   tf->codes[14356] = 0x0005a3b7d34fda96UL;
   tf->codes[14357] = 0x0005a3c0848ab5d4UL;
   tf->codes[14358] = 0x0005a3ca5a90adebUL;
   tf->codes[14359] = 0x0005a3cb44ccc4ffUL;
   tf->codes[14360] = 0x0005a3d6ef4aeb3eUL;
   tf->codes[14361] = 0x0005a3dc6cb375b6UL;
   tf->codes[14362] = 0x0005a3dd917e928fUL;
   tf->codes[14363] = 0x0005a3ffa6bcee38UL;
   tf->codes[14364] = 0x0005a40648f09589UL;
   tf->codes[14365] = 0x0005a40b8bca1a3cUL;
   tf->codes[14366] = 0x0005a40c00e825c6UL;
   tf->codes[14367] = 0x0005a40e0fef59b3UL;
   tf->codes[14368] = 0x0005a4147793fb3fUL;
   tf->codes[14369] = 0x0005a44187a36bd8UL;
   tf->codes[14370] = 0x0005a4577d4595b8UL;
   tf->codes[14371] = 0x0005a4582cf2a707UL;
   tf->codes[14372] = 0x0005a45951bdc3e0UL;
   tf->codes[14373] = 0x0005a460a39e7c80UL;
   tf->codes[14374] = 0x0005a463d770cd46UL;
   tf->codes[14375] = 0x0005a48452c6008cUL;
   tf->codes[14376] = 0x0005a491220f43a4UL;
   tf->codes[14377] = 0x0005a4abe56ce6adUL;
   tf->codes[14378] = 0x0005a4b0b3285fd6UL;
   tf->codes[14379] = 0x0005a4b78feb0cecUL;
   tf->codes[14380] = 0x0005a4c28abc21dcUL;
   tf->codes[14381] = 0x0005a4c9a20dd4b7UL;
   tf->codes[14382] = 0x0005a4c9dc9cda7cUL;
   tf->codes[14383] = 0x0005a4cac6d8f190UL;
   tf->codes[14384] = 0x0005a4ce6fc94de0UL;
   tf->codes[14385] = 0x0005a4d6e6752359UL;
   tf->codes[14386] = 0x0005a4ec2c6a3beaUL;
   tf->codes[14387] = 0x0005a4ee7600759cUL;
   tf->codes[14388] = 0x0005a51643366182UL;
   tf->codes[14389] = 0x0005a51fa41e4e0fUL;
   tf->codes[14390] = 0x0005a54527be0043UL;
   tf->codes[14391] = 0x0005a547e672457fUL;
   tf->codes[14392] = 0x0005a54f72e203e4UL;
   tf->codes[14393] = 0x0005a567026d5627UL;
   tf->codes[14394] = 0x0005a56c0ab7d515UL;
   tf->codes[14395] = 0x0005a571c2af6552UL;
   tf->codes[14396] = 0x0005a57f41a5b9b9UL;
   tf->codes[14397] = 0x0005a5fdfb28360bUL;
   tf->codes[14398] = 0x0005a5feaad5475aUL;
   tf->codes[14399] = 0x0005a611a7342639UL;
   tf->codes[14400] = 0x0005a6121c5231c3UL;
   tf->codes[14401] = 0x0005a61a92fe073cUL;
   tf->codes[14402] = 0x0005a61acd8d0d01UL;
   tf->codes[14403] = 0x0005a6379ff1e3f7UL;
   tf->codes[14404] = 0x0005a648c7d894aeUL;
   tf->codes[14405] = 0x0005a65d5e209bf0UL;
   tf->codes[14406] = 0x0005a67e1404d4fbUL;
   tf->codes[14407] = 0x0005a686c53fb039UL;
   tf->codes[14408] = 0x0005a68a6e300c89UL;
   tf->codes[14409] = 0x0005a6989cd3723fUL;
   tf->codes[14410] = 0x0005a6b61ee55a84UL;
   tf->codes[14411] = 0x0005a6bab211cde8UL;
   tf->codes[14412] = 0x0005a6d70f589954UL;
   tf->codes[14413] = 0x0005a6df86046ecdUL;
   tf->codes[14414] = 0x0005a6f999b50087UL;
   tf->codes[14415] = 0x0005a7119e5e5e54UL;
   tf->codes[14416] = 0x0005a727ce8f8df9UL;
   tf->codes[14417] = 0x0005a744a0f464efUL;
   tf->codes[14418] = 0x0005a7463add8d52UL;
   tf->codes[14419] = 0x0005a760fe3b305bUL;
   tf->codes[14420] = 0x0005a766f0c1c65dUL;
   tf->codes[14421] = 0x0005a76a5f231ce8UL;
   tf->codes[14422] = 0x0005a76eb7c08a87UL;
   tf->codes[14423] = 0x0005a7751f652c13UL;
   tf->codes[14424] = 0x0005a776f3dd5a3bUL;
   tf->codes[14425] = 0x0005a78ada78502eUL;
   tf->codes[14426] = 0x0005a79316951fe2UL;
   tf->codes[14427] = 0x0005a79bc7cffb20UL;
   tf->codes[14428] = 0x0005a79fab4f5d35UL;
   tf->codes[14429] = 0x0005a7b02388fc9dUL;
   tf->codes[14430] = 0x0005a7b52bd37b8bUL;
   tf->codes[14431] = 0x0005a7b73adaaf78UL;
   tf->codes[14432] = 0x0005a7bf76f77f2cUL;
   tf->codes[14433] = 0x0005a7ca71c8941cUL;
   tf->codes[14434] = 0x0005a7cda59ae4e2UL;
   tf->codes[14435] = 0x0005a7d69164c5e5UL;
   tf->codes[14436] = 0x0005a7dcbe7a61acUL;
   tf->codes[14437] = 0x0005a7de1dd4844aUL;
   tf->codes[14438] = 0x0005a7ef0b2c2f3cUL;
   tf->codes[14439] = 0x0005a7fa05fd442cUL;
   tf->codes[14440] = 0x0005a8048bb04d92UL;
   tf->codes[14441] = 0x0005a81e9f60df4cUL;
   tf->codes[14442] = 0x0005a83b71c5b642UL;
   tf->codes[14443] = 0x0005a853766f140fUL;
   tf->codes[14444] = 0x0005a853eb8d1f99UL;
   tf->codes[14445] = 0x0005a8716d9f07deUL;
   tf->codes[14446] = 0x0005a875168f642eUL;
   tf->codes[14447] = 0x0005a8763b5a8107UL;
   tf->codes[14448] = 0x0005a8822067ad0bUL;
   tf->codes[14449] = 0x0005a8bb8aa25532UL;
   tf->codes[14450] = 0x0005a8c1f246f6beUL;
   tf->codes[14451] = 0x0005a8c859eb984aUL;
   tf->codes[14452] = 0x0005a8d61370f276UL;
   tf->codes[14453] = 0x0005a8eec7c76192UL;
   tf->codes[14454] = 0x0005a8f061b089f5UL;
   tf->codes[14455] = 0x0005a8fa37b6820cUL;
   tf->codes[14456] = 0x0005a90691e1b99aUL;
   tf->codes[14457] = 0x0005a91c1265d7f0UL;
   tf->codes[14458] = 0x0005a9369b347534UL;
   tf->codes[14459] = 0x0005a940abc97310UL;
   tf->codes[14460] = 0x0005a9457984ec39UL;
   tf->codes[14461] = 0x0005a94c1bb8938aUL;
   tf->codes[14462] = 0x0005a94f14fbde8bUL;
   tf->codes[14463] = 0x0005a952bdec3adbUL;
   tf->codes[14464] = 0x0005a956dbfaa2b5UL;
   tf->codes[14465] = 0x0005a9599aaee7f1UL;
   tf->codes[14466] = 0x0005a95b34981054UL;
   tf->codes[14467] = 0x0005a95df34c5590UL;
   tf->codes[14468] = 0x0005a9699dca7bcfUL;
   tf->codes[14469] = 0x0005a97214765148UL;
   tf->codes[14470] = 0x0005a9771cc0d036UL;
   tf->codes[14471] = 0x0005a982c73ef675UL;
   tf->codes[14472] = 0x0005a986702f52c5UL;
   tf->codes[14473] = 0x0005a991307161f0UL;
   tf->codes[14474] = 0x0005a9b9ad545f25UL;
   tf->codes[14475] = 0x0005a9c08a170c3bUL;
   tf->codes[14476] = 0x0005a9c9eafef8c8UL;
   tf->codes[14477] = 0x0005aa11f8fb122fUL;
   tf->codes[14478] = 0x0005aa16c6b68b58UL;
   tf->codes[14479] = 0x0005aa34bde67f27UL;
   tf->codes[14480] = 0x0005aa35a822963bUL;
   tf->codes[14481] = 0x0005aa3866d6db77UL;
   tf->codes[14482] = 0x0005aa565e06cf46UL;
   tf->codes[14483] = 0x0005aa6785ed7ffdUL;
   tf->codes[14484] = 0x0005aa86dc77966aUL;
   tf->codes[14485] = 0x0005aa8afa85fe44UL;
   tf->codes[14486] = 0x0005aac3056683cdUL;
   tf->codes[14487] = 0x0005aaece1a3a3a0UL;
   tf->codes[14488] = 0x0005aaf4a8a267caUL;
   tf->codes[14489] = 0x0005aaf81703be55UL;
   tf->codes[14490] = 0x0005aaffde02827fUL;
   tf->codes[14491] = 0x0005ab03c181e494UL;
   tf->codes[14492] = 0x0005ab129fd25b99UL;
   tf->codes[14493] = 0x0005ab46c7337f0dUL;
   tf->codes[14494] = 0x0005ab59c3925decUL;
   tf->codes[14495] = 0x0005ab732795de57UL;
   tf->codes[14496] = 0x0005ab88a819fcadUL;
   tf->codes[14497] = 0x0005ab950245343bUL;
   tf->codes[14498] = 0x0005abb5087c5bf7UL;
   tf->codes[14499] = 0x0005abc162a79385UL;
   tf->codes[14500] = 0x0005abc45beade86UL;
   tf->codes[14501] = 0x0005abcd47b4bf89UL;
   tf->codes[14502] = 0x0005abd0066904c5UL;
   tf->codes[14503] = 0x0005abdac6ab13f0UL;
   tf->codes[14504] = 0x0005abf256366633UL;
   tf->codes[14505] = 0x0005ac03438e1125UL;
   tf->codes[14506] = 0x0005ac1137a27116UL;
   tf->codes[14507] = 0x0005ac3b88fd9c73UL;
   tf->codes[14508] = 0x0005ac438a8b6662UL;
   tf->codes[14509] = 0x0005ac4b16fb24c7UL;
   tf->codes[14510] = 0x0005ac4f6f989266UL;
   tf->codes[14511] = 0x0005ac55d73d33f2UL;
   tf->codes[14512] = 0x0005ac59babc9607UL;
   tf->codes[14513] = 0x0005ac60977f431dUL;
   tf->codes[14514] = 0x0005ac6614e7cd95UL;
   tf->codes[14515] = 0x0005ac77ec7b8f9bUL;
   tf->codes[14516] = 0x0005ac9fb9b17b81UL;
   tf->codes[14517] = 0x0005acb27b81549bUL;
   tf->codes[14518] = 0x0005acbdeb707515UL;
   tf->codes[14519] = 0x0005acc11f42c5dbUL;
   tf->codes[14520] = 0x0005accf88753156UL;
   tf->codes[14521] = 0x0005acd247297692UL;
   tf->codes[14522] = 0x0005acf3722bbb27UL;
   tf->codes[14523] = 0x0005ad10f43da36cUL;
   tf->codes[14524] = 0x0005ad3d1a10fcf1UL;
   tf->codes[14525] = 0x0005ad3f63a736a3UL;
   tf->codes[14526] = 0x0005ad44a680bb56UL;
   tf->codes[14527] = 0x0005ad6387ecc639UL;
   tf->codes[14528] = 0x0005ad6a2a206d8aUL;
   tf->codes[14529] = 0x0005ad6ce8d4b2c6UL;
   tf->codes[14530] = 0x0005ad6d5df2be50UL;
   tf->codes[14531] = 0x0005ad7106e31aa0UL;
   tf->codes[14532] = 0x0005ad7a67cb072dUL;
   tf->codes[14533] = 0x0005ad7b52071e41UL;
   tf->codes[14534] = 0x0005ad8e88f502e5UL;
   tf->codes[14535] = 0x0005adf8e6be7dbaUL;
   tf->codes[14536] = 0x0005adfd3f5beb59UL;
   tf->codes[14537] = 0x0005adff88f2250bUL;
   tf->codes[14538] = 0x0005ae0a0ea52e71UL;
   tf->codes[14539] = 0x0005ae1b368bdf28UL;
   tf->codes[14540] = 0x0005ae3425715409UL;
   tf->codes[14541] = 0x0005ae3d4bca3ad1UL;
   tf->codes[14542] = 0x0005ae5933f2fab3UL;
   tf->codes[14543] = 0x0005ae6e04ca07baUL;
   tf->codes[14544] = 0x0005ae7088ef4731UL;
   tf->codes[14545] = 0x0005ae7431dfa381UL;
   tf->codes[14546] = 0x0005ae9ce951a67bUL;
   tf->codes[14547] = 0x0005aeb9f6458336UL;
   tf->codes[14548] = 0x0005aec73aacd1d8UL;
   tf->codes[14549] = 0x0005aec9bed2114fUL;
   tf->codes[14550] = 0x0005aed1c05fdb3eUL;
   tf->codes[14551] = 0x0005aedfb4743b2fUL;
   tf->codes[14552] = 0x0005aef325f12598UL;
   tf->codes[14553] = 0x0005aef743ff8d72UL;
   tf->codes[14554] = 0x0005aefbd72c00d6UL;
   tf->codes[14555] = 0x0005af02b3eeadecUL;
   tf->codes[14556] = 0x0005af053813ed63UL;
   tf->codes[14557] = 0x0005af1366b75319UL;
   tf->codes[14558] = 0x0005af169a89a3dfUL;
   tf->codes[14559] = 0x0005af3f51fba6d9UL;
   tf->codes[14560] = 0x0005af4494d52b8cUL;
   tf->codes[14561] = 0x0005af5a8a77556cUL;
   tf->codes[14562] = 0x0005af633bb230aaUL;
   tf->codes[14563] = 0x0005af94a45f0ee2UL;
   tf->codes[14564] = 0x0005afb01769c33aUL;
   tf->codes[14565] = 0x0005afdc3d3d1cbfUL;
   tf->codes[14566] = 0x0005b00863107644UL;
   tf->codes[14567] = 0x0005b01c843a71fcUL;
   tf->codes[14568] = 0x0005b03697eb03b6UL;
   tf->codes[14569] = 0x0005b03e5ee9c7e0UL;
   tf->codes[14570] = 0x0005b04c52fe27d1UL;
   tf->codes[14571] = 0x0005b078b360871bUL;
   tf->codes[14572] = 0x0005b07a87d8b543UL;
   tf->codes[14573] = 0x0005b0a5c36ff7b4UL;
   tf->codes[14574] = 0x0005b0c30af2da34UL;
   tf->codes[14575] = 0x0005b0c5548913e6UL;
   tf->codes[14576] = 0x0005b0c9e7b5874aUL;
   tf->codes[14577] = 0x0005b0ecaca0f442UL;
   tf->codes[14578] = 0x0005b0f4e8bdc3f6UL;
   tf->codes[14579] = 0x0005b1126acfac3bUL;
   tf->codes[14580] = 0x0005b1309c8ea5cfUL;
   tf->codes[14581] = 0x0005b132e624df81UL;
   tf->codes[14582] = 0x0005b135a4d924bdUL;
   tf->codes[14583] = 0x0005b14189e650c1UL;
   tf->codes[14584] = 0x0005b15e5c4b27b7UL;
   tf->codes[14585] = 0x0005b1644ed1bdb9UL;
   tf->codes[14586] = 0x0005b165739cda92UL;
   tf->codes[14587] = 0x0005b165e8bae61cUL;
   tf->codes[14588] = 0x0005b16bdb417c1eUL;
   tf->codes[14589] = 0x0005b1748c7c575cUL;
   tf->codes[14590] = 0x0005b18788db363bUL;
   tf->codes[14591] = 0x0005b1b8b6f90eaeUL;
   tf->codes[14592] = 0x0005b1bd4a258212UL;
   tf->codes[14593] = 0x0005b1c1a2c2efb1UL;
   tf->codes[14594] = 0x0005b1df99f2e380UL;
   tf->codes[14595] = 0x0005b1e16e6b11a8UL;
   tf->codes[14596] = 0x0005b206f20ac3dcUL;
   tf->codes[14597] = 0x0005b2193ebc916cUL;
   tf->codes[14598] = 0x0005b21a9e16b40aUL;
   tf->codes[14599] = 0x0005b249829e52cbUL;
   tf->codes[14600] = 0x0005b24da0acbaa5UL;
   tf->codes[14601] = 0x0005b2589b7dcf95UL;
   tf->codes[14602] = 0x0005b25a6ff5fdbdUL;
   tf->codes[14603] = 0x0005b27da9ff763fUL;
   tf->codes[14604] = 0x0005b28e223915a7UL;
   tf->codes[14605] = 0x0005b2b20bef9f78UL;
   tf->codes[14606] = 0x0005b2b3e067cda0UL;
   tf->codes[14607] = 0x0005b2b8ae2346c9UL;
   tf->codes[14608] = 0x0005b2c960ebebf6UL;
   tf->codes[14609] = 0x0005b2d0783d9ed1UL;
   tf->codes[14610] = 0x0005b2da13b49123UL;
   tf->codes[14611] = 0x0005b2f88002907cUL;
   tf->codes[14612] = 0x0005b3167732844bUL;
   tf->codes[14613] = 0x0005b31d8e843726UL;
   tf->codes[14614] = 0x0005b33433d37255UL;
   tf->codes[14615] = 0x0005b3408dfea9e3UL;
   tf->codes[14616] = 0x0005b34b88cfbed3UL;
   tf->codes[14617] = 0x0005b3709751657dUL;
   tf->codes[14618] = 0x0005b3731b76a4f4UL;
   tf->codes[14619] = 0x0005b399fe7079c6UL;
   tf->codes[14620] = 0x0005b39a738e8550UL;
   tf->codes[14621] = 0x0005b39f06baf8b4UL;
   tf->codes[14622] = 0x0005b3aecf4786cdUL;
   tf->codes[14623] = 0x0005b3dbdf56f766UL;
   tf->codes[14624] = 0x0005b3de28ed3118UL;
   tf->codes[14625] = 0x0005b417cdb6df04UL;
   tf->codes[14626] = 0x0005b418b7f2f618UL;
   tf->codes[14627] = 0x0005b450c2d37ba1UL;
   tf->codes[14628] = 0x0005b47596c61c86UL;
   tf->codes[14629] = 0x0005b486841dc778UL;
   tf->codes[14630] = 0x0005b49efde530cfUL;
   tf->codes[14631] = 0x0005b4c655fd112bUL;
   tf->codes[14632] = 0x0005b4e571f821d3UL;
   tf->codes[14633] = 0x0005b4edae14f187UL;
   tf->codes[14634] = 0x0005b4f3660c81c4UL;
   tf->codes[14635] = 0x0005b4f624c0c700UL;
   tf->codes[14636] = 0x0005b4fffac6bf17UL;
   tf->codes[14637] = 0x0005b5095baeaba4UL;
   tf->codes[14638] = 0x0005b50bdfd3eb1bUL;
   tf->codes[14639] = 0x0005b50c54f1f6a5UL;
   tf->codes[14640] = 0x0005b5141bf0bacfUL;
   tf->codes[14641] = 0x0005b51540bbd7a8UL;
   tf->codes[14642] = 0x0005b52b70ed074dUL;
   tf->codes[14643] = 0x0005b5387ac5502aUL;
   tf->codes[14644] = 0x0005b55637663e34UL;
   tf->codes[14645] = 0x0005b55b7a3fc2e7UL;
   tf->codes[14646] = 0x0005b55eae1213adUL;
   tf->codes[14647] = 0x0005b57085a5d5b3UL;
   tf->codes[14648] = 0x0005b57d54ef18cbUL;
   tf->codes[14649] = 0x0005b57d8f7e1e90UL;
   tf->codes[14650] = 0x0005b5834775aecdUL;
   tf->codes[14651] = 0x0005b589e9a9561eUL;
   tf->codes[14652] = 0x0005b5befb4690a6UL;
   tf->codes[14653] = 0x0005b5bfaaf3a1f5UL;
   tf->codes[14654] = 0x0005b5caa5c4b6e5UL;
   tf->codes[14655] = 0x0005b5d26cc37b0fUL;
   tf->codes[14656] = 0x0005b5dd67948fffUL;
   tf->codes[14657] = 0x0005b5e52e935429UL;
   tf->codes[14658] = 0x0005b5ee8f7b40b6UL;
   tf->codes[14659] = 0x0005b5f6567a04e0UL;
   tf->codes[14660] = 0x0005b619cb128327UL;
   tf->codes[14661] = 0x0005b61e98cdfc50UL;
   tf->codes[14662] = 0x0005b63e64761e47UL;
   tf->codes[14663] = 0x0005b65c5ba61216UL;
   tf->codes[14664] = 0x0005b65f54e95d17UL;
   tf->codes[14665] = 0x0005b66cd3dfb17eUL;
   tf->codes[14666] = 0x0005b673b0a25e94UL;
   tf->codes[14667] = 0x0005b675fa389846UL;
   tf->codes[14668] = 0x0005b6766f56a3d0UL;
   tf->codes[14669] = 0x0005b67c9c6c3f97UL;
   tf->codes[14670] = 0x0005b6bbbe9e77fbUL;
   tf->codes[14671] = 0x0005b6e7a9e2cbbbUL;
   tf->codes[14672] = 0x0005b6f737e0540fUL;
   tf->codes[14673] = 0x0005b7152f1047deUL;
   tf->codes[14674] = 0x0005b725a749e746UL;
   tf->codes[14675] = 0x0005b753a1956ef3UL;
   tf->codes[14676] = 0x0005b755760d9d1bUL;
   tf->codes[14677] = 0x0005b7566049b42fUL;
   tf->codes[14678] = 0x0005b768726c7bfaUL;
   tf->codes[14679] = 0x0005b76922198d49UL;
   tf->codes[14680] = 0x0005b772f81f8560UL;
   tf->codes[14681] = 0x0005b778006a044eUL;
   tf->codes[14682] = 0x0005b7c3f1e57fcaUL;
   tf->codes[14683] = 0x0005b7c80ff3e7a4UL;
   tf->codes[14684] = 0x0005b7cd183e6692UL;
   tf->codes[14685] = 0x0005b7ec6ec87cffUL;
   tf->codes[14686] = 0x0005b8047371daccUL;
   tf->codes[14687] = 0x0005b8356700ad7aUL;
   tf->codes[14688] = 0x0005b85aeaa05faeUL;
   tf->codes[14689] = 0x0005b877827630dfUL;
   tf->codes[14690] = 0x0005b8895a09f2e5UL;
   tf->codes[14691] = 0x0005b890e679b14aUL;
   tf->codes[14692] = 0x0005b894c9f9135fUL;
   tf->codes[14693] = 0x0005b89ccb86dd4eUL;
   tf->codes[14694] = 0x0005b89df051fa27UL;
   tf->codes[14695] = 0x0005b8b83e9191a6UL;
   tf->codes[14696] = 0x0005b8c841ad2584UL;
   tf->codes[14697] = 0x0005b8ca8b435f36UL;
   tf->codes[14698] = 0x0005b8cf938dde24UL;
   tf->codes[14699] = 0x0005b8dbb32a0fedUL;
   tf->codes[14700] = 0x0005b8f1e35b3f92UL;
   tf->codes[14701] = 0x0005b919760225b3UL;
   tf->codes[14702] = 0x0005b91ca9d47679UL;
   tf->codes[14703] = 0x0005b931058d77f6UL;
   tf->codes[14704] = 0x0005b954ef4401c7UL;
   tf->codes[14705] = 0x0005b96ae4e62ba7UL;
   tf->codes[14706] = 0x0005b97a3854ae36UL;
   tf->codes[14707] = 0x0005b9835ead94feUL;
   tf->codes[14708] = 0x0005b9986a13a7caUL;
   tf->codes[14709] = 0x0005b9adea97c620UL;
   tf->codes[14710] = 0x0005b9b2433533bfUL;
   tf->codes[14711] = 0x0005b9c7c3b95215UL;
   tf->codes[14712] = 0x0005b9cabcfc9d16UL;
   tf->codes[14713] = 0x0005b9de2e79877fUL;
   tf->codes[14714] = 0x0005b9e3abe211f7UL;
   tf->codes[14715] = 0x0005b9ecd23af8bfUL;
   tf->codes[14716] = 0x0005b9f0b5ba5ad4UL;
   tf->codes[14717] = 0x0005b9f9dc13419cUL;
   tf->codes[14718] = 0x0005ba04d6e4568cUL;
   tf->codes[14719] = 0x0005ba325c11d2afUL;
   tf->codes[14720] = 0x0005ba5645c85c80UL;
   tf->codes[14721] = 0x0005ba59799aad46UL;
   tf->codes[14722] = 0x0005ba638a2fab22UL;
   tf->codes[14723] = 0x0005babb60b852a2UL;
   tf->codes[14724] = 0x0005baced2353d0bUL;
   tf->codes[14725] = 0x0005badc8bba9737UL;
   tf->codes[14726] = 0x0005badf0fdfd6aeUL;
   tf->codes[14727] = 0x0005baefc2a87bdbUL;
   tf->codes[14728] = 0x0005bafabd7990cbUL;
   tf->codes[14729] = 0x0005bb1ea7301a9cUL;
   tf->codes[14730] = 0x0005bb3720f783f3UL;
   tf->codes[14731] = 0x0005bb3e72d83c93UL;
   tf->codes[14732] = 0x0005bb4674660682UL;
   tf->codes[14733] = 0x0005bb500fdcf8d4UL;
   tf->codes[14734] = 0x0005bb5a9590023aUL;
   tf->codes[14735] = 0x0005bb6dcc7de6deUL;
   tf->codes[14736] = 0x0005bb738475771bUL;
   tf->codes[14737] = 0x0005bb74e3cf99b9UL;
   tf->codes[14738] = 0x0005bb84e6eb2d97UL;
   tf->codes[14739] = 0x0005bba611ed722cUL;
   tf->codes[14740] = 0x0005bbb40601d21dUL;
   tf->codes[14741] = 0x0005bbd7057c44daUL;
   tf->codes[14742] = 0x0005bbd82a4761b3UL;
   tf->codes[14743] = 0x0005bbda73dd9b65UL;
   tf->codes[14744] = 0x0005bbe066643167UL;
   tf->codes[14745] = 0x0005bbe4f990a4cbUL;
   tf->codes[14746] = 0x0005bbe7f2d3efccUL;
   tf->codes[14747] = 0x0005bc08a8b828d7UL;
   tf->codes[14748] = 0x0005bc2df1c8d546UL;
   tf->codes[14749] = 0x0005bc40ee27b425UL;
   tf->codes[14750] = 0x0005bc528b2c7066UL;
   tf->codes[14751] = 0x0005bc55846fbb67UL;
   tf->codes[14752] = 0x0005bc57ce05f519UL;
   tf->codes[14753] = 0x0005bc69307bab95UL;
   tf->codes[14754] = 0x0005bc75ffc4eeadUL;
   tf->codes[14755] = 0x0005bc8468f75a28UL;
   tf->codes[14756] = 0x0005bc9138409d40UL;
   tf->codes[14757] = 0x0005bc92227cb454UL;
   tf->codes[14758] = 0x0005bc9381d6d6f2UL;
   tf->codes[14759] = 0x0005bc99aeec72b9UL;
   tf->codes[14760] = 0x0005bcb9efb2a03aUL;
   tf->codes[14761] = 0x0005bcc89374117aUL;
   tf->codes[14762] = 0x0005bccc76f3738fUL;
   tf->codes[14763] = 0x0005bccd26a084deUL;
   tf->codes[14764] = 0x0005bcd17f3df27dUL;
   tf->codes[14765] = 0x0005bcd43df237b9UL;
   tf->codes[14766] = 0x0005bcda6b07d380UL;
   tf->codes[14767] = 0x0005bce18259865bUL;
   tf->codes[14768] = 0x0005bce26c959d6fUL;
   tf->codes[14769] = 0x0005bce73a511698UL;
   tf->codes[14770] = 0x0005bcf110570eafUL;
   tf->codes[14771] = 0x0005bcfb20ec0c8bUL;
   tf->codes[14772] = 0x0005bd10dbff30a6UL;
   tf->codes[14773] = 0x0005bd19c7c911a9UL;
   tf->codes[14774] = 0x0005bd1ed0139097UL;
   tf->codes[14775] = 0x0005bd34c5b5ba77UL;
   tf->codes[14776] = 0x0005bd5122fc85e3UL;
   tf->codes[14777] = 0x0005bd5be33e950eUL;
   tf->codes[14778] = 0x0005bd80f1c03bb8UL;
   tf->codes[14779] = 0x0005bd89a2fb16f6UL;
   tf->codes[14780] = 0x0005bd9bb51ddec1UL;
   tf->codes[14781] = 0x0005bdc5915afe94UL;
   tf->codes[14782] = 0x0005bddd96045c61UL;
   tf->codes[14783] = 0x0005be07acd081f9UL;
   tf->codes[14784] = 0x0005be1e8caec2edUL;
   tf->codes[14785] = 0x0005be3e5856e4e4UL;
   tf->codes[14786] = 0x0005be527980e09cUL;
   tf->codes[14787] = 0x0005be5b9fd9c764UL;
   tf->codes[14788] = 0x0005be63dbf69718UL;
   tf->codes[14789] = 0x0005be6784e6f368UL;
   tf->codes[14790] = 0x0005be67fa04fef2UL;
   tf->codes[14791] = 0x0005be6db1fc8f2fUL;
   tf->codes[14792] = 0x0005be8df2c2bcb0UL;
   tf->codes[14793] = 0x0005be9a125eee79UL;
   tf->codes[14794] = 0x0005be9a4cedf43eUL;
   tf->codes[14795] = 0x0005beeca60e1146UL;
   tf->codes[14796] = 0x0005bf16824b3119UL;
   tf->codes[14797] = 0x0005bf1fa8a417e1UL;
   tf->codes[14798] = 0x0005bf3c7b08eed7UL;
   tf->codes[14799] = 0x0005bf440778ad3cUL;
   tf->codes[14800] = 0x0005bf490fc32c2aUL;
   tf->codes[14801] = 0x0005bf509c32ea8fUL;
   tf->codes[14802] = 0x0005bf62ae55b25aUL;
   tf->codes[14803] = 0x0005bf7485e97460UL;
   tf->codes[14804] = 0x0005bf777f2cbf61UL;
   tf->codes[14805] = 0x0005bf8b2b38af8fUL;
   tf->codes[14806] = 0x0005bf95eb7abebaUL;
   tf->codes[14807] = 0x0005bfa7fd9d8685UL;
   tf->codes[14808] = 0x0005bfaba68de2d5UL;
   tf->codes[14809] = 0x0005bfbe2dceb62aUL;
   tf->codes[14810] = 0x0005bfc19c300cb5UL;
   tf->codes[14811] = 0x0005bfcb723604ccUL;
   tf->codes[14812] = 0x0005bfdac5a4875bUL;
   tf->codes[14813] = 0x0005bfed4ce55ab0UL;
   tf->codes[14814] = 0x0005bff722eb52c7UL;
   tf->codes[14815] = 0x0005bffbf0a6cbf0UL;
   tf->codes[14816] = 0x0005bffd8a8ff453UL;
   tf->codes[14817] = 0x0005c010fc0cdebcUL;
   tf->codes[14818] = 0x0005c019e7d6bfbfUL;
   tf->codes[14819] = 0x0005c044ae4ff6a6UL;
   tf->codes[14820] = 0x0005c04cea6cc65aUL;
   tf->codes[14821] = 0x0005c05dd7c4714cUL;
   tf->codes[14822] = 0x0005c07024763edcUL;
   tf->codes[14823] = 0x0005c07bcef4651bUL;
   tf->codes[14824] = 0x0005c08654a76e81UL;
   tf->codes[14825] = 0x0005c091ff2594c0UL;
   tf->codes[14826] = 0x0005c097077013aeUL;
   tf->codes[14827] = 0x0005c0ae21dd5a67UL;
   tf->codes[14828] = 0x0005c0af46a87740UL;
   tf->codes[14829] = 0x0005c0be5f87f40aUL;
   tf->codes[14830] = 0x0005c0c501bb9b5bUL;
   tf->codes[14831] = 0x0005c0ce62a387e8UL;
   tf->codes[14832] = 0x0005c0fd0c9c20e4UL;
   tf->codes[14833] = 0x0005c10214e69fd2UL;
   tf->codes[14834] = 0x0005c14ce196fe75UL;
   tf->codes[14835] = 0x0005c14e7b8026d8UL;
   tf->codes[14836] = 0x0005c167df83a743UL;
   tf->codes[14837] = 0x0005c1734f72c7bdUL;
   tf->codes[14838] = 0x0005c17f6f0ef986UL;
   tf->codes[14839] = 0x0005c18facb99329UL;
   tf->codes[14840] = 0x0005c18fe74898eeUL;
   tf->codes[14841] = 0x0005c1b4bb3b39d3UL;
   tf->codes[14842] = 0x0005c1b9fe14be86UL;
   tf->codes[14843] = 0x0005c1ce1f3eba3eUL;
   tf->codes[14844] = 0x0005c1d5e63d7e68UL;
   tf->codes[14845] = 0x0005c1da044be642UL;
   tf->codes[14846] = 0x0005c1daee87fd56UL;
   tf->codes[14847] = 0x0005c1dc13531a2fUL;
   tf->codes[14848] = 0x0005c1ec50fdb3d2UL;
   tf->codes[14849] = 0x0005c1f11eb92cfbUL;
   tf->codes[14850] = 0x0005c1f53cc794d5UL;
   tf->codes[14851] = 0x0005c20998809652UL;
   tf->codes[14852] = 0x0005c2141e339fb8UL;
   tf->codes[14853] = 0x0005c21a4b493b7fUL;
   tf->codes[14854] = 0x0005c24795e7b1ddUL;
   tf->codes[14855] = 0x0005c253b583e3a6UL;
   tf->codes[14856] = 0x0005c258833f5ccfUL;
   tf->codes[14857] = 0x0005c25c2c2fb91fUL;
   tf->codes[14858] = 0x0005c26552889fe7UL;
   tf->codes[14859] = 0x0005c26e3e5280eaUL;
   tf->codes[14860] = 0x0005c26eedff9239UL;
   tf->codes[14861] = 0x0005c27a987db878UL;
   tf->codes[14862] = 0x0005c27b0d9bc402UL;
   tf->codes[14863] = 0x0005c2829a0b8267UL;
   tf->codes[14864] = 0x0005c2c8d38f6da6UL;
   tf->codes[14865] = 0x0005c2e2acb0f99bUL;
   tf->codes[14866] = 0x0005c2e5a5f4449cUL;
   tf->codes[14867] = 0x0005c2f3d497aa52UL;
   tf->codes[14868] = 0x0005c2f56e80d2b5UL;
   tf->codes[14869] = 0x0005c2f867c41db6UL;
   tf->codes[14870] = 0x0005c2fff433dc1bUL;
   tf->codes[14871] = 0x0005c30ed2845320UL;
   tf->codes[14872] = 0x0005c31fbfdbfe12UL;
   tf->codes[14873] = 0x0005c33db70bf1e1UL;
   tf->codes[14874] = 0x0005c3420fa95f80UL;
   tf->codes[14875] = 0x0005c3457e0ab60bUL;
   tf->codes[14876] = 0x0005c3779664a592UL;
   tf->codes[14877] = 0x0005c3942e3a76c3UL;
   tf->codes[14878] = 0x0005c39ad06e1e14UL;
   tf->codes[14879] = 0x0005c39c2fc840b2UL;
   tf->codes[14880] = 0x0005c3b4e41eafceUL;
   tf->codes[14881] = 0x0005c3bb8652571fUL;
   tf->codes[14882] = 0x0005c3bdcfe890d1UL;
   tf->codes[14883] = 0x0005c3ca9f31d3e9UL;
   tf->codes[14884] = 0x0005c41aaebbb73fUL;
   tf->codes[14885] = 0x0005c42b9c136231UL;
   tf->codes[14886] = 0x0005c43278d60f47UL;
   tf->codes[14887] = 0x0005c43bd9bdfbd4UL;
   tf->codes[14888] = 0x0005c4783d3beefcUL;
   tf->codes[14889] = 0x0005c47d45866deaUL;
   tf->codes[14890] = 0x0005c48422491b00UL;
   tf->codes[14891] = 0x0005c496e418f41aUL;
   tf->codes[14892] = 0x0005c49ac798562fUL;
   tf->codes[14893] = 0x0005c49bb1d46d43UL;
   tf->codes[14894] = 0x0005c49fcfe2d51dUL;
   tf->codes[14895] = 0x0005c4cf9ea68af2UL;
   tf->codes[14896] = 0x0005c4d0c371a7cbUL;
   tf->codes[14897] = 0x0005c4d0fe00ad90UL;
   tf->codes[14898] = 0x0005c4dbf8d1c280UL;
   tf->codes[14899] = 0x0005c4dc6defce0aUL;
   tf->codes[14900] = 0x0005c4df2ca41346UL;
   tf->codes[14901] = 0x0005c512a458256bUL;
   tf->codes[14902] = 0x0005c515d82a7631UL;
   tf->codes[14903] = 0x0005c54531d0207cUL;
   tf->codes[14904] = 0x0005c5539b028bf7UL;
   tf->codes[14905] = 0x0005c5686bd998feUL;
   tf->codes[14906] = 0x0005c574c604d08cUL;
   tf->codes[14907] = 0x0005c58712b69e1cUL;
   tf->codes[14908] = 0x0005c587fcf2b530UL;
   tf->codes[14909] = 0x0005c59b6e6f9f99UL;
   tf->codes[14910] = 0x0005c59ba8fea55eUL;
   tf->codes[14911] = 0x0005c59d42e7cdc1UL;
   tf->codes[14912] = 0x0005c59fc70d0d38UL;
   tf->codes[14913] = 0x0005c5b33889f7a1UL;
   tf->codes[14914] = 0x0005c5c79442f91eUL;
   tf->codes[14915] = 0x0005c5d1df66fcbfUL;
   tf->codes[14916] = 0x0005c5d3b3df2ae7UL;
   tf->codes[14917] = 0x0005c5ff2a05731dUL;
   tf->codes[14918] = 0x0005c63fe620d3e4UL;
   tf->codes[14919] = 0x0005c64772909249UL;
   tf->codes[14920] = 0x0005c648223da398UL;
   tf->codes[14921] = 0x0005c64a6bd3dd4aUL;
   tf->codes[14922] = 0x0005c675a76b1fbbUL;
   tf->codes[14923] = 0x0005c6be9fa35036UL;
   tf->codes[14924] = 0x0005c6bf89df674aUL;
   tf->codes[14925] = 0x0005c6c57c65fd4cUL;
   tf->codes[14926] = 0x0005c6dc96d34405UL;
   tf->codes[14927] = 0x0005c704297a2a26UL;
   tf->codes[14928] = 0x0005c71292ac95a1UL;
   tf->codes[14929] = 0x0005c73298e3bd5dUL;
   tf->codes[14930] = 0x0005c732d372c322UL;
   tf->codes[14931] = 0x0005c73432cce5c0UL;
   tf->codes[14932] = 0x0005c76b53715435UL;
   tf->codes[14933] = 0x0005c795df5b8557UL;
   tf->codes[14934] = 0x0005c79ecb25665aUL;
   tf->codes[14935] = 0x0005c7ada975dd5fUL;
   tf->codes[14936] = 0x0005c7c36489017aUL;
   tf->codes[14937] = 0x0005c7c39f18073fUL;
   tf->codes[14938] = 0x0005c7e504a95199UL;
   tf->codes[14939] = 0x0005c7e8ad99ade9UL;
   tf->codes[14940] = 0x0005c806a4c9a1b8UL;
   tf->codes[14941] = 0x0005c81f93af1699UL;
   tf->codes[14942] = 0x0005c83f24c832cbUL;
   tf->codes[14943] = 0x0005c846018adfe1UL;
   tf->codes[14944] = 0x0005c848109213ceUL;
   tf->codes[14945] = 0x0005c84c2ea07ba8UL;
   tf->codes[14946] = 0x0005c86e7e6ddd16UL;
   tf->codes[14947] = 0x0005c87fe0e39392UL;
   tf->codes[14948] = 0x0005c89a69b230d6UL;
   tf->codes[14949] = 0x0005c8a5d9a15150UL;
   tf->codes[14950] = 0x0005c8e536628f79UL;
   tf->codes[14951] = 0x0005c8e6209ea68dUL;
   tf->codes[14952] = 0x0005c8e86a34e03fUL;
   tf->codes[14953] = 0x0005c9169f0f6db1UL;
   tf->codes[14954] = 0x0005c918e8a5a763UL;
   tf->codes[14955] = 0x0005c929d5fd5255UL;
   tf->codes[14956] = 0x0005c9445ecbef99UL;
   tf->codes[14957] = 0x0005c95a19df13b4UL;
   tf->codes[14958] = 0x0005c967d3646de0UL;
   tf->codes[14959] = 0x0005c97eedd1b499UL;
   tf->codes[14960] = 0x0005c98ce1e6148aUL;
   tf->codes[14961] = 0x0005c9946e55d2efUL;
   tf->codes[14962] = 0x0005c9f4bb8a4fe8UL;
   tf->codes[14963] = 0x0005c9f77a3e9524UL;
   tf->codes[14964] = 0x0005c9fbd2dc02c3UL;
   tf->codes[14965] = 0x0005ca1153602119UL;
   tf->codes[14966] = 0x0005ca183022ce2fUL;
   tf->codes[14967] = 0x0005ca4c1cf4ebdeUL;
   tf->codes[14968] = 0x0005ca5a86275759UL;
   tf->codes[14969] = 0x0005ca671ae194acUL;
   tf->codes[14970] = 0x0005ca68b4cabd0fUL;
   tf->codes[14971] = 0x0005ca7e6fdde12aUL;
   tf->codes[14972] = 0x0005ca846264772cUL;
   tf->codes[14973] = 0x0005ca875ba7c22dUL;
   tf->codes[14974] = 0x0005ca99333b8433UL;
   tf->codes[14975] = 0x0005caba5e3dc8c8UL;
   tf->codes[14976] = 0x0005cabbf826f12bUL;
   tf->codes[14977] = 0x0005cac1b01e8168UL;
   tf->codes[14978] = 0x0005cac817c322f4UL;
   tf->codes[14979] = 0x0005cae76e4d3961UL;
   tf->codes[14980] = 0x0005cb0739f55b58UL;
   tf->codes[14981] = 0x0005cb0fb0a130d1UL;
   tf->codes[14982] = 0x0005cb18274d064aUL;
   tf->codes[14983] = 0x0005cb1b2090514bUL;
   tf->codes[14984] = 0x0005cb4e5db55dabUL;
   tf->codes[14985] = 0x0005cb75b5cd3e07UL;
   tf->codes[14986] = 0x0005cbd727ccd7d9UL;
   tf->codes[14987] = 0x0005cbffdf3edad3UL;
   tf->codes[14988] = 0x0005cc1f7057f705UL;
   tf->codes[14989] = 0x0005cc2478a275f3UL;
   tf->codes[14990] = 0x0005cc3da216f099UL;
   tf->codes[14991] = 0x0005cc6534bdd6baUL;
   tf->codes[14992] = 0x0005cc73d87f47faUL;
   tf->codes[14993] = 0x0005cc869a4f2114UL;
   tf->codes[14994] = 0x0005ccb7c86cf987UL;
   tf->codes[14995] = 0x0005ccc3e8092b50UL;
   tf->codes[14996] = 0x0005ccd3eb24bf2eUL;
   tf->codes[14997] = 0x0005ccd425b3c4f3UL;
   tf->codes[14998] = 0x0005cd11adfcd4f4UL;
   tf->codes[14999] = 0x0005cd3647607014UL;
   tf->codes[15000] = 0x0005cd3ef89b4b52UL;
   tf->codes[15001] = 0x0005cd443b74d005UL;
   tf->codes[15002] = 0x0005cd5688269d95UL;
   tf->codes[15003] = 0x0005cd5c401e2dd2UL;
   tf->codes[15004] = 0x0005cd8a3a69b57fUL;
   tf->codes[15005] = 0x0005cd9ab2a354e7UL;
   tf->codes[15006] = 0x0005cda7f70aa389UL;
   tf->codes[15007] = 0x0005cdd0ae7ca683UL;
   tf->codes[15008] = 0x0005cde3704c7f9dUL;
   tf->codes[15009] = 0x0005cde6a41ed063UL;
   tf->codes[15010] = 0x0005cded465277b4UL;
   tf->codes[15011] = 0x0005cdf7cc05811aUL;
   tf->codes[15012] = 0x0005cdf8069486dfUL;
   tf->codes[15013] = 0x0005ce121a451899UL;
   tf->codes[15014] = 0x0005ce133f103572UL;
   tf->codes[15015] = 0x0005ce3d906b60cfUL;
   tf->codes[15016] = 0x0005ce434862f10cUL;
   tf->codes[15017] = 0x0005ce4975788cd3UL;
   tf->codes[15018] = 0x0005ce5310ef7f25UL;
   tf->codes[15019] = 0x0005ce63c3b82452UL;
   tf->codes[15020] = 0x0005ce6dd44d222eUL;
   tf->codes[15021] = 0x0005ce71081f72f4UL;
   tf->codes[15022] = 0x0005ce7d27bba4bdUL;
   tf->codes[15023] = 0x0005ce8bcb7d15fdUL;
   tf->codes[15024] = 0x0005ce9feca711b5UL;
   tf->codes[15025] = 0x0005cedf83f755a3UL;
   tf->codes[15026] = 0x0005cee3a205bd7dUL;
   tf->codes[15027] = 0x0005ceec18b192f6UL;
   tf->codes[15028] = 0x0005cf3510e9c371UL;
   tf->codes[15029] = 0x0005cf3bedac7087UL;
   tf->codes[15030] = 0x0005cf46adee7fb2UL;
   tf->codes[15031] = 0x0005cf4e74ed43dcUL;
   tf->codes[15032] = 0x0005cf5c2e729e08UL;
   tf->codes[15033] = 0x0005cf89b3a01a2bUL;
   tf->codes[15034] = 0x0005cf93148806b8UL;
   tf->codes[15035] = 0x0005cf9682e95d43UL;
   tf->codes[15036] = 0x0005cf9ef99532bcUL;
   tf->codes[15037] = 0x0005cfb4ef375c9cUL;
   tf->codes[15038] = 0x0005cfd0624210f4UL;
   tf->codes[15039] = 0x0005cfe77caf57adUL;
   tf->codes[15040] = 0x0005cfe8a17a7486UL;
   tf->codes[15041] = 0x0005cff8df250e29UL;
   tf->codes[15042] = 0x0005cffdace08752UL;
   tf->codes[15043] = 0x0005d01501dcd3d0UL;
   tf->codes[15044] = 0x0005d030ea0593b2UL;
   tf->codes[15045] = 0x0005d038eb935da1UL;
   tf->codes[15046] = 0x0005d05b75efc4d4UL;
   tf->codes[15047] = 0x0005d0675afcf0d8UL;
   tf->codes[15048] = 0x0005d07046c6d1dbUL;
   tf->codes[15049] = 0x0005d0737a9922a1UL;
   tf->codes[15050] = 0x0005d09813fcbdc1UL;
   tf->codes[15051] = 0x0005d0984e8bc386UL;
   tf->codes[15052] = 0x0005d09a2303f1aeUL;
   tf->codes[15053] = 0x0005d0c81d4f795bUL;
   tf->codes[15054] = 0x0005d0d4025ca55fUL;
   tf->codes[15055] = 0x0005d0d5d6d4d387UL;
   tf->codes[15056] = 0x0005d0d8958918c3UL;
   tf->codes[15057] = 0x0005d0dadf1f5275UL;
   tf->codes[15058] = 0x0005d0e2e0ad1c64UL;
   tf->codes[15059] = 0x0005d119c6c28514UL;
   tf->codes[15060] = 0x0005d1411eda6570UL;
   tf->codes[15061] = 0x0005d16d7f3cc4baUL;
   tf->codes[15062] = 0x0005d174968e7795UL;
   tf->codes[15063] = 0x0005d1850ec816fdUL;
   tf->codes[15064] = 0x0005d19ee7e9a2f2UL;
   tf->codes[15065] = 0x0005d1e3fca27158UL;
   tf->codes[15066] = 0x0005d1eb13f42433UL;
   tf->codes[15067] = 0x0005d1f0cbebb470UL;
   tf->codes[15068] = 0x0005d219835db76aUL;
   tf->codes[15069] = 0x0005d22a36265c97UL;
   tf->codes[15070] = 0x0005d23bd32b18d8UL;
   tf->codes[15071] = 0x0005d24c85f3be05UL;
   tf->codes[15072] = 0x0005d25328276556UL;
   tf->codes[15073] = 0x0005d2570ba6c76bUL;
   tf->codes[15074] = 0x0005d257bb53d8baUL;
   tf->codes[15075] = 0x0005d27996032e9eUL;
   tf->codes[15076] = 0x0005d27a803f45b2UL;
   tf->codes[15077] = 0x0005d28e2c4b35e0UL;
   tf->codes[15078] = 0x0005d2bd85f0e02bUL;
   tf->codes[15079] = 0x0005d2c37877762dUL;
   tf->codes[15080] = 0x0005d2e79cbd05c3UL;
   tf->codes[15081] = 0x0005d2eeb40eb89eUL;
   tf->codes[15082] = 0x0005d31d9896575fUL;
   tf->codes[15083] = 0x0005d3373728dd8fUL;
   tf->codes[15084] = 0x0005d339f5dd22cbUL;
   tf->codes[15085] = 0x0005d34983daab1fUL;
   tf->codes[15086] = 0x0005d350260e5270UL;
   tf->codes[15087] = 0x0005d385723a92bdUL;
   tf->codes[15088] = 0x0005d3b5b61c541cUL;
   tf->codes[15089] = 0x0005d3cbabbe7dfcUL;
   tf->codes[15090] = 0x0005d3cedf90cec2UL;
   tf->codes[15091] = 0x0005d3e375d8d604UL;
   tf->codes[15092] = 0x0005d3e54a51042cUL;
   tf->codes[15093] = 0x0005d3e6348d1b40UL;
   tf->codes[15094] = 0x0005d3f254294d09UL;
   tf->codes[15095] = 0x0005d3f4633080f6UL;
   tf->codes[15096] = 0x0005d3fd898967beUL;
   tf->codes[15097] = 0x0005d40a1e43a511UL;
   tf->codes[15098] = 0x0005d43977e94f5cUL;
   tf->codes[15099] = 0x0005d43e0b15c2c0UL;
   tf->codes[15100] = 0x0005d451f1b0b8b3UL;
   tf->codes[15101] = 0x0005d47824fd7c36UL;
   tf->codes[15102] = 0x0005d49e92d9457eUL;
   tf->codes[15103] = 0x0005d4a9188c4ee4UL;
   tf->codes[15104] = 0x0005d4bb2aaf16afUL;
   tf->codes[15105] = 0x0005d4c500b50ec6UL;
   tf->codes[15106] = 0x0005d542204e62b5UL;
   tf->codes[15107] = 0x0005d54eef97a5cdUL;
   tf->codes[15108] = 0x0005d5534835136cUL;
   tf->codes[15109] = 0x0005d55d58ca1148UL;
   tf->codes[15110] = 0x0005d576823e8beeUL;
   tf->codes[15111] = 0x0005d576bccd91b3UL;
   tf->codes[15112] = 0x0005d583c6a5da90UL;
   tf->codes[15113] = 0x0005d5931a145d1fUL;
   tf->codes[15114] = 0x0005d5be55ab9f90UL;
   tf->codes[15115] = 0x0005d5f9945e75dfUL;
   tf->codes[15116] = 0x0005d5fa097c8169UL;
   tf->codes[15117] = 0x0005d5fd77ddd7f4UL;
   tf->codes[15118] = 0x0005d618eae88c4cUL;
   tf->codes[15119] = 0x0005d61a4a42aeeaUL;
   tf->codes[15120] = 0x0005d632c40a1841UL;
   tf->codes[15121] = 0x0005d644267fcebdUL;
   tf->codes[15122] = 0x0005d65304d045c2UL;
   tf->codes[15123] = 0x0005d675549da730UL;
   tf->codes[15124] = 0x0005d6988ea71fb2UL;
   tf->codes[15125] = 0x0005d6aadb58ed42UL;
   tf->codes[15126] = 0x0005d6ab5076f8ccUL;
   tf->codes[15127] = 0x0005d6c3ca3e6223UL;
   tf->codes[15128] = 0x0005d6caa7010f39UL;
   tf->codes[15129] = 0x0005d6e9c2fc1fe1UL;
   tf->codes[15130] = 0x0005d6f09fbeccf7UL;
   tf->codes[15131] = 0x0005d6f657b65d34UL;
   tf->codes[15132] = 0x0005d6faeae2d098UL;
   tf->codes[15133] = 0x0005d7144ee65103UL;
   tf->codes[15134] = 0x0005d71ab68af28fUL;
   tf->codes[15135] = 0x0005d74458390c9dUL;
   tf->codes[15136] = 0x0005d75077d53e66UL;
   tf->codes[15137] = 0x0005d76a8b85d020UL;
   tf->codes[15138] = 0x0005d774d6a9d3c1UL;
   tf->codes[15139] = 0x0005d77969d64725UL;
   tf->codes[15140] = 0x0005d7896cf1db03UL;
   tf->codes[15141] = 0x0005d78c2ba6203fUL;
   tf->codes[15142] = 0x0005d79258bbbc06UL;
   tf->codes[15143] = 0x0005d79b44859d09UL;
   tf->codes[15144] = 0x0005d79f629404e3UL;
   tf->codes[15145] = 0x0005d7c2277f71dbUL;
   tf->codes[15146] = 0x0005d7db1664e6bcUL;
   tf->codes[15147] = 0x0005d7ff3aaa7652UL;
   tf->codes[15148] = 0x0005d801becfb5c9UL;
   tf->codes[15149] = 0x0005d80776c74606UL;
   tf->codes[15150] = 0x0005d813966377cfUL;
   tf->codes[15151] = 0x0005d847bdc49b43UL;
   tf->codes[15152] = 0x0005d85193ca935aUL;
   tf->codes[15153] = 0x0005d86664a1a061UL;
   tf->codes[15154] = 0x0005d86f15dc7b9fUL;
   tf->codes[15155] = 0x0005d889641c131eUL;
   tf->codes[15156] = 0x0005d88afe053b81UL;
   tf->codes[15157] = 0x0005d8c04a317bceUL;
   tf->codes[15158] = 0x0005d8ee447d037bUL;
   tf->codes[15159] = 0x0005d8f6460acd6aUL;
   tf->codes[15160] = 0x0005d8f73046e47eUL;
   tf->codes[15161] = 0x0005d8fe82279d1eUL;
   tf->codes[15162] = 0x0005d911f3a48787UL;
   tf->codes[15163] = 0x0005d917ab9c17c4UL;
   tf->codes[15164] = 0x0005d918d067349dUL;
   tf->codes[15165] = 0x0005d9290e11ce40UL;
   tf->codes[15166] = 0x0005d94de2046f25UL;
   tf->codes[15167] = 0x0005d95115d6bfebUL;
   tf->codes[15168] = 0x0005d9523aa1dcc4UL;
   tf->codes[15169] = 0x0005d95742ec5bb2UL;
   tf->codes[15170] = 0x0005d97031d1d093UL;
   tf->codes[15171] = 0x0005d97d76391f35UL;
   tf->codes[15172] = 0x0005d97db0c824faUL;
   tf->codes[15173] = 0x0005d97f4ab14d5dUL;
   tf->codes[15174] = 0x0005d9811f297b85UL;
   tf->codes[15175] = 0x0005d9c25062e7d6UL;
   tf->codes[15176] = 0x0005d9c71e1e60ffUL;
   tf->codes[15177] = 0x0005d9d4d7a3bb2bUL;
   tf->codes[15178] = 0x0005d9dc64137990UL;
   tf->codes[15179] = 0x0005d9fc6a4aa14cUL;
   tf->codes[15180] = 0x0005da03f6ba5fb1UL;
   tf->codes[15181] = 0x0005da3a67b1bcd7UL;
   tf->codes[15182] = 0x0005da3e10a21927UL;
   tf->codes[15183] = 0x0005da6025e074d0UL;
   tf->codes[15184] = 0x0005da61bfc99d33UL;
   tf->codes[15185] = 0x0005da70638b0e73UL;
   tf->codes[15186] = 0x0005da81c600c4efUL;
   tf->codes[15187] = 0x0005da84bf440ff0UL;
   tf->codes[15188] = 0x0005da8b26e8b17cUL;
   tf->codes[15189] = 0x0005da98a5df05e3UL;
   tf->codes[15190] = 0x0005daae9b812fc3UL;
   tf->codes[15191] = 0x0005dab8718727daUL;
   tf->codes[15192] = 0x0005dace2c9a4bf5UL;
   tf->codes[15193] = 0x0005dad5f399101fUL;
   tf->codes[15194] = 0x0005dadc5b3db1abUL;
   tf->codes[15195] = 0x0005daee6d607976UL;
   tf->codes[15196] = 0x0005daf2c5fde715UL;
   tf->codes[15197] = 0x0005db0044f43b7cUL;
   tf->codes[15198] = 0x0005db075c45ee57UL;
   tf->codes[15199] = 0x0005db429af8c4a6UL;
   tf->codes[15200] = 0x0005db6c3ca6deb4UL;
   tf->codes[15201] = 0x0005db70cfd35218UL;
   tf->codes[15202] = 0x0005db7562ffc57cUL;
   tf->codes[15203] = 0x0005db9110997f99UL;
   tf->codes[15204] = 0x0005db9da553bcecUL;
   tf->codes[15205] = 0x0005dbbab24799a7UL;
   tf->codes[15206] = 0x0005dbc62236ba21UL;
   tf->codes[15207] = 0x0005dbd032cbb7fdUL;
   tf->codes[15208] = 0x0005dbd15796d4d6UL;
   tf->codes[15209] = 0x0005dbd19225da9bUL;
   tf->codes[15210] = 0x0005dbeed9a8bd1bUL;
   tf->codes[15211] = 0x0005dbfd084c22d1UL;
   tf->codes[15212] = 0x0005dc0b717e8e4cUL;
   tf->codes[15213] = 0x0005dc3b40424421UL;
   tf->codes[15214] = 0x0005dc53f498b33dUL;
   tf->codes[15215] = 0x0005dc5f9f16d97cUL;
   tf->codes[15216] = 0x0005dc64a761586aUL;
   tf->codes[15217] = 0x0005dc77a3c03749UL;
   tf->codes[15218] = 0x0005dc79031a59e7UL;
   tf->codes[15219] = 0x0005dc7fdfdd06fdUL;
   tf->codes[15220] = 0x0005dc92671dda52UL;
   tf->codes[15221] = 0x0005dc9943e08768UL;
   tf->codes[15222] = 0x0005dcbc08cbf460UL;
   tf->codes[15223] = 0x0005dcbe52622e12UL;
   tf->codes[15224] = 0x0005dcbf020f3f61UL;
   tf->codes[15225] = 0x0005dcc235e19027UL;
   tf->codes[15226] = 0x0005dcc5a442e6b2UL;
   tf->codes[15227] = 0x0005dcccf6239f52UL;
   tf->codes[15228] = 0x0005dcd14ec10cf1UL;
   tf->codes[15229] = 0x0005dce8de4c5f34UL;
   tf->codes[15230] = 0x0005dce9536a6abeUL;
   tf->codes[15231] = 0x0005dcf18f873a72UL;
   tf->codes[15232] = 0x0005dcf95685fe9cUL;
   tf->codes[15233] = 0x0005dcfdaf236c3bUL;
   tf->codes[15234] = 0x0005dd00e2f5bd01UL;
   tf->codes[15235] = 0x0005dd0e9c7b172dUL;
   tf->codes[15236] = 0x0005dd3afcdd7677UL;
   tf->codes[15237] = 0x0005dd3c21a89350UL;
   tf->codes[15238] = 0x0005dd42c3dc3aa1UL;
   tf->codes[15239] = 0x0005dd50f27fa057UL;
   tf->codes[15240] = 0x0005dd6b06303211UL;
   tf->codes[15241] = 0x0005dd6bb5dd4360UL;
   tf->codes[15242] = 0x0005dd713345cdd8UL;
   tf->codes[15243] = 0x0005dd7467181e9eUL;
   tf->codes[15244] = 0x0005dd7e028f10f0UL;
   tf->codes[15245] = 0x0005dd967c567a47UL;
   tf->codes[15246] = 0x0005dd997599c548UL;
   tf->codes[15247] = 0x0005dd99eab7d0d2UL;
   tf->codes[15248] = 0x0005ddb55dc2852aUL;
   tf->codes[15249] = 0x0005ddb5d2e090b4UL;
   tf->codes[15250] = 0x0005ddccb2bed1a8UL;
   tf->codes[15251] = 0x0005ddd26ab661e5UL;
   tf->codes[15252] = 0x0005ddd354f278f9UL;
   tf->codes[15253] = 0x0005ddf2365e83dcUL;
   tf->codes[15254] = 0x0005ddf70419fd05UL;
   tf->codes[15255] = 0x0005ddfb222864dfUL;
   tf->codes[15256] = 0x0005de35ebbd2fa4UL;
   tf->codes[15257] = 0x0005de40e68e4494UL;
   tf->codes[15258] = 0x0005de4edaa2a485UL;
   tf->codes[15259] = 0x0005de512438de37UL;
   tf->codes[15260] = 0x0005de54929a34c2UL;
   tf->codes[15261] = 0x0005de6f55f7d7cbUL;
   tf->codes[15262] = 0x0005de75f82b7f1cUL;
   tf->codes[15263] = 0x0005de8670651e84UL;
   tf->codes[15264] = 0x0005deb63f28d459UL;
   tf->codes[15265] = 0x0005debad25547bdUL;
   tf->codes[15266] = 0x0005dece43d23226UL;
   tf->codes[15267] = 0x0005dee81cf3be1bUL;
   tf->codes[15268] = 0x0005def108bd9f1eUL;
   tf->codes[15269] = 0x0005def735d33ae5UL;
   tf->codes[15270] = 0x0005defa2f1685e6UL;
   tf->codes[15271] = 0x0005df110ef4c6daUL;
   tf->codes[15272] = 0x0005df58a7d2d4b7UL;
   tf->codes[15273] = 0x0005df58e261da7cUL;
   tf->codes[15274] = 0x0005df8c5a15eca1UL;
   tf->codes[15275] = 0x0005df9e31a9aea7UL;
   tf->codes[15276] = 0x0005dfc1e0d132b3UL;
   tf->codes[15277] = 0x0005dfd8c0af73a7UL;
   tf->codes[15278] = 0x0005dfeef0e0a34cUL;
   tf->codes[15279] = 0x0005dff642c15becUL;
   tf->codes[15280] = 0x0005dffd5a130ec7UL;
   tf->codes[15281] = 0x0005e0093f203acbUL;
   tf->codes[15282] = 0x0005e0197ccad46eUL;
   tf->codes[15283] = 0x0005e02d9df4d026UL;
   tf->codes[15284] = 0x0005e0426ecbdd2dUL;
   tf->codes[15285] = 0x0005e043ce25ffcbUL;
   tf->codes[15286] = 0x0005e04910ff847eUL;
   tf->codes[15287] = 0x0005e04ddebafda7UL;
   tf->codes[15288] = 0x0005e066cda07288UL;
   tf->codes[15289] = 0x0005e085e99b8330UL;
   tf->codes[15290] = 0x0005e0bfc8f436e1UL;
   tf->codes[15291] = 0x0005e0cdf7979c97UL;
   tf->codes[15292] = 0x0005e0d0b64be1d3UL;
   tf->codes[15293] = 0x0005e0db768df0feUL;
   tf->codes[15294] = 0x0005e0ebeec79066UL;
   tf->codes[15295] = 0x0005e0f6747a99ccUL;
   tf->codes[15296] = 0x0005e0fcdc1f3b58UL;
   tf->codes[15297] = 0x0005e110130d1ffcUL;
   tf->codes[15298] = 0x0005e14e10743b87UL;
   tf->codes[15299] = 0x0005e15109b78688UL;
   tf->codes[15300] = 0x0005e1517ed59212UL;
   tf->codes[15301] = 0x0005e187401fdde9UL;
   tf->codes[15302] = 0x0005e18e92009689UL;
   tf->codes[15303] = 0x0005e18fb6cbb362UL;
   tf->codes[15304] = 0x0005e19f0a3a35f1UL;
   tf->codes[15305] = 0x0005e1b8a8ccbc21UL;
   tf->codes[15306] = 0x0005e1dea18a79dfUL;
   tf->codes[15307] = 0x0005e1dfc65596b8UL;
   tf->codes[15308] = 0x0005e1e4cea015a6UL;
   tf->codes[15309] = 0x0005e2321f75b3c0UL;
   tf->codes[15310] = 0x0005e246409faf78UL;
   tf->codes[15311] = 0x0005e24a5eae1752UL;
   tf->codes[15312] = 0x0005e253bf9603dfUL;
   tf->codes[15313] = 0x0005e26103fd5281UL;
   tf->codes[15314] = 0x0005e26d98b78fd4UL;
   tf->codes[15315] = 0x0005e28d9eeeb790UL;
   tf->codes[15316] = 0x0005e29feba08520UL;
   tf->codes[15317] = 0x0005e2cb9c55d31bUL;
   tf->codes[15318] = 0x0005e2f48e56dbdaUL;
   tf->codes[15319] = 0x0005e2fed97adf7bUL;
   tf->codes[15320] = 0x0005e2ffc3b6f68fUL;
   tf->codes[15321] = 0x0005e30ea2076d94UL;
   tf->codes[15322] = 0x0005e33fd0254607UL;
   tf->codes[15323] = 0x0005e35291f51f21UL;
   tf->codes[15324] = 0x0005e3542bde4784UL;
   tf->codes[15325] = 0x0005e356b00386fbUL;
   tf->codes[15326] = 0x0005e370c3b418b5UL;
   tf->codes[15327] = 0x0005e38ef5731249UL;
   tf->codes[15328] = 0x0005e3a5603347b3UL;
   tf->codes[15329] = 0x0005e3bb1b466bceUL;
   tf->codes[15330] = 0x0005e3d14b779b73UL;
   tf->codes[15331] = 0x0005e3d73dfe3175UL;
   tf->codes[15332] = 0x0005e3dc4648b063UL;
   tf->codes[15333] = 0x0005e3f918ad8759UL;
   tf->codes[15334] = 0x0005e4195973b4daUL;
   tf->codes[15335] = 0x0005e43c937d2d5cUL;
   tf->codes[15336] = 0x0005e43f17a26cd3UL;
   tf->codes[15337] = 0x0005e4483dfb539bUL;
   tf->codes[15338] = 0x0005e44afcaf98d7UL;
   tf->codes[15339] = 0x0005e4503f891d8aUL;
   tf->codes[15340] = 0x0005e4507a18234fUL;
   tf->codes[15341] = 0x0005e47254c77933UL;
   tf->codes[15342] = 0x0005e47463cead20UL;
   tf->codes[15343] = 0x0005e475c328cfbeUL;
   tf->codes[15344] = 0x0005e479a6a831d3UL;
   tf->codes[15345] = 0x0005e4b1ec17bd21UL;
   tf->codes[15346] = 0x0005e4bd5c06dd9bUL;
   tf->codes[15347] = 0x0005e4d8cf1191f3UL;
   tf->codes[15348] = 0x0005e50ae76b817aUL;
   tf->codes[15349] = 0x0005e511febd3455UL;
   tf->codes[15350] = 0x0005e51398a65cb8UL;
   tf->codes[15351] = 0x0005e519509decf5UL;
   tf->codes[15352] = 0x0005e5298e488698UL;
   tf->codes[15353] = 0x0005e5369820cf75UL;
   tf->codes[15354] = 0x0005e57127269475UL;
   tf->codes[15355] = 0x0005e578b39652daUL;
   tf->codes[15356] = 0x0005e57928b45e64UL;
   tf->codes[15357] = 0x0005e57c9715b4efUL;
   tf->codes[15358] = 0x0005e5b96fb1b3a1UL;
   tf->codes[15359] = 0x0005e5c011e55af2UL;
   tf->codes[15360] = 0x0005e5c25b7b94a4UL;
   tf->codes[15361] = 0x0005e5d46d9e5c6fUL;
   tf->codes[15362] = 0x0005e5e6f4df2fc4UL;
   tf->codes[15363] = 0x0005e5fc00454290UL;
   tf->codes[15364] = 0x0005e609f459a281UL;
   tf->codes[15365] = 0x0005e616fe31eb5eUL;
   tf->codes[15366] = 0x0005e6373ef818dfUL;
   tf->codes[15367] = 0x0005e672b839f4f3UL;
   tf->codes[15368] = 0x0005e67af456c4a7UL;
   tf->codes[15369] = 0x0005e67bde92dbbbUL;
   tf->codes[15370] = 0x0005e67d035df894UL;
   tf->codes[15371] = 0x0005e6b50e3e7e1dUL;
   tf->codes[15372] = 0x0005e6cc633aca9bUL;
   tf->codes[15373] = 0x0005e6dd5092758dUL;
   tf->codes[15374] = 0x0005e6e3f2c61cdeUL;
   tf->codes[15375] = 0x0005e71177f39901UL;
   tf->codes[15376] = 0x0005e732a2f5dd96UL;
   tf->codes[15377] = 0x0005e73c78fbd5adUL;
   tf->codes[15378] = 0x0005e74b1cbd46edUL;
   tf->codes[15379] = 0x0005e7531e4b10dcUL;
   tf->codes[15380] = 0x0005e7795197d45fUL;
   tf->codes[15381] = 0x0005e77a7662f138UL;
   tf->codes[15382] = 0x0005e77c856a2525UL;
   tf->codes[15383] = 0x0005e7a8ab3d7eaaUL;
   tf->codes[15384] = 0x0005e7c19a22f38bUL;
   tf->codes[15385] = 0x0005e7ca4b5dcec9UL;
   tf->codes[15386] = 0x0005e7dbadd38545UL;
   tf->codes[15387] = 0x0005e7f377eddd4dUL;
   tf->codes[15388] = 0x0005e7f880385c3bUL;
   tf->codes[15389] = 0x0005e7fdfda0e6b3UL;
   tf->codes[15390] = 0x0005e7ffd21914dbUL;
   tf->codes[15391] = 0x0005e80a57cc1e41UL;
   tf->codes[15392] = 0x0005e8184be07e32UL;
   tf->codes[15393] = 0x0005e83d1fd31f17UL;
   tf->codes[15394] = 0x0005e83e7f2d41b5UL;
   tf->codes[15395] = 0x0005e85056c103bbUL;
   tf->codes[15396] = 0x0005e86a2fe28fb0UL;
   tf->codes[15397] = 0x0005e86a6a719575UL;
   tf->codes[15398] = 0x0005e86d9e43e63bUL;
   tf->codes[15399] = 0x0005e8785e85f566UL;
   tf->codes[15400] = 0x0005e87a6d8d2953UL;
   tf->codes[15401] = 0x0005e89864bd1d22UL;
   tf->codes[15402] = 0x0005e89ecc61beaeUL;
   tf->codes[15403] = 0x0005e8cb2cc41df8UL;
   tf->codes[15404] = 0x0005e8d27ea4d698UL;
   tf->codes[15405] = 0x0005e8d368e0edacUL;
   tf->codes[15406] = 0x0005e9342b33762fUL;
   tf->codes[15407] = 0x0005e9525cf26fc3UL;
   tf->codes[15408] = 0x0005e95a23f133edUL;
   tf->codes[15409] = 0x0005e96e7faa356aUL;
   tf->codes[15410] = 0x0005e98bc72d17eaUL;
   tf->codes[15411] = 0x0005e98d9ba54612UL;
   tf->codes[15412] = 0x0005e98e10c3519cUL;
   tf->codes[15413] = 0x0005e9940349e79eUL;
   tf->codes[15414] = 0x0005e99c79f5bd17UL;
   tf->codes[15415] = 0x0005e9b5a36a37bdUL;
   tf->codes[15416] = 0x0005e9c89fc9169cUL;
   tf->codes[15417] = 0x0005e9ca744144c4UL;
   tf->codes[15418] = 0x0005e9da023ecd18UL;
   tf->codes[15419] = 0x0005e9f5ea678cfaUL;
   tf->codes[15420] = 0x0005ea136c79753fUL;
   tf->codes[15421] = 0x0005ea16a04bc605UL;
   tf->codes[15422] = 0x0005ea1e2cbb846aUL;
   tf->codes[15423] = 0x0005ea7678623774UL;
   tf->codes[15424] = 0x0005ea9225fbf191UL;
   tf->codes[15425] = 0x0005ea934ac70e6aUL;
   tf->codes[15426] = 0x0005ea94e4b036cdUL;
   tf->codes[15427] = 0x0005eaabff1d7d86UL;
   tf->codes[15428] = 0x0005eabb17fcfa50UL;
   tf->codes[15429] = 0x0005eac687ec1acaUL;
   tf->codes[15430] = 0x0005eacfe8d40757UL;
   tf->codes[15431] = 0x0005eadb58c327d1UL;
   tf->codes[15432] = 0x0005eaf7065ce1eeUL;
   tf->codes[15433] = 0x0005eb3503c3fd79UL;
   tf->codes[15434] = 0x0005eb3d3fe0cd2dUL;
   tf->codes[15435] = 0x0005eb787e93a37cUL;
   tf->codes[15436] = 0x0005eb980facbfaeUL;
   tf->codes[15437] = 0x0005eb9d17f73e9cUL;
   tf->codes[15438] = 0x0005eb9eb1e066ffUL;
   tf->codes[15439] = 0x0005ebb4a78290dfUL;
   tf->codes[15440] = 0x0005ebc34b44021fUL;
   tf->codes[15441] = 0x0005ebc72ec36434UL;
   tf->codes[15442] = 0x0005ebf6c2f81444UL;
   tf->codes[15443] = 0x0005ec66639b13ccUL;
   tf->codes[15444] = 0x0005ec6f4f64f4cfUL;
   tf->codes[15445] = 0x0005ec771663b8f9UL;
   tf->codes[15446] = 0x0005ec819c16c25fUL;
   tf->codes[15447] = 0x0005ec85f4b42ffeUL;
   tf->codes[15448] = 0x0005ec924edf678cUL;
   tf->codes[15449] = 0x0005ecc9aa12dbc6UL;
   tf->codes[15450] = 0x0005ed0906d419efUL;
   tf->codes[15451] = 0x0005ed0d5f71878eUL;
   tf->codes[15452] = 0x0005ed1bc8a3f309UL;
   tf->codes[15453] = 0x0005ed45a4e112dcUL;
   tf->codes[15454] = 0x0005ed4de0fde290UL;
   tf->codes[15455] = 0x0005ed5323d76743UL;
   tf->codes[15456] = 0x0005ed5da98a70a9UL;
   tf->codes[15457] = 0x0005edd9dee7ad84UL;
   tf->codes[15458] = 0x0005edde37851b23UL;
   tf->codes[15459] = 0x0005ede6ae30f09cUL;
   tf->codes[15460] = 0x0005edfd53802bcbUL;
   tf->codes[15461] = 0x0005ee0888e04680UL;
   tf->codes[15462] = 0x0005ee32da3b71ddUL;
   tf->codes[15463] = 0x0005ee3a66ab3042UL;
   tf->codes[15464] = 0x0005ee3fe413babaUL;
   tf->codes[15465] = 0x0005ee69c050da8dUL;
   tf->codes[15466] = 0x0005ee768f9a1da5UL;
   tf->codes[15467] = 0x0005ee8916daf0faUL;
   tf->codes[15468] = 0x0005ee8daa07645eUL;
   tf->codes[15469] = 0x0005ee939c8dfa60UL;
   tf->codes[15470] = 0x0005eeb5021f44baUL;
   tf->codes[15471] = 0x0005eeef569603f5UL;
   tf->codes[15472] = 0x0005ef0f975c3176UL;
   tf->codes[15473] = 0x0005ef31377c8195UL;
   tf->codes[15474] = 0x0005ef44e38871c3UL;
   tf->codes[15475] = 0x0005ef47a23cb6ffUL;
   tf->codes[15476] = 0x0005ef5d22c0d555UL;
   tf->codes[15477] = 0x0005ef65244e9f44UL;
   tf->codes[15478] = 0x0005ef81bc247075UL;
   tf->codes[15479] = 0x0005ef88d3762350UL;
   tf->codes[15480] = 0x0005ef98d691b72eUL;
   tf->codes[15481] = 0x0005ef994bafc2b8UL;
   tf->codes[15482] = 0x0005efb7f28cc7d6UL;
   tf->codes[15483] = 0x0005efcf47891454UL;
   tf->codes[15484] = 0x0005efd27b5b651aUL;
   tf->codes[15485] = 0x0005efd783a5e408UL;
   tf->codes[15486] = 0x0005effba7eb739eUL;
   tf->codes[15487] = 0x0005f0020f90152aUL;
   tf->codes[15488] = 0x0005f034d7971600UL;
   tf->codes[15489] = 0x0005f03880877250UL;
   tf->codes[15490] = 0x0005f063f6adba86UL;
   tf->codes[15491] = 0x0005f069aea54ac3UL;
   tf->codes[15492] = 0x0005f074e4056578UL;
   tf->codes[15493] = 0x0005f078c784c78dUL;
   tf->codes[15494] = 0x0005f0aaa54fb14fUL;
   tf->codes[15495] = 0x0005f0c443e2377fUL;
   tf->codes[15496] = 0x0005f0c9119db0a8UL;
   tf->codes[15497] = 0x0005f0ccba8e0cf8UL;
   tf->codes[15498] = 0x0005f0d5e0e6f3c0UL;
   tf->codes[15499] = 0x0005f0f0a44496c9UL;
   tf->codes[15500] = 0x0005f107beb1dd82UL;
   tf->codes[15501] = 0x0005f115b2c63d73UL;
   tf->codes[15502] = 0x0005f146a6551021UL;
   tf->codes[15503] = 0x0005f14790912735UL;
   tf->codes[15504] = 0x0005f14805af32bfUL;
   tf->codes[15505] = 0x0005f14f921ef124UL;
   tf->codes[15506] = 0x0005f165c25020c9UL;
   tf->codes[15507] = 0x0005f16fd2e51ea5UL;
   tf->codes[15508] = 0x0005f171a75d4ccdUL;
   tf->codes[15509] = 0x0005f17e0188845bUL;
   tf->codes[15510] = 0x0005f18553693cfbUL;
   tf->codes[15511] = 0x0005f18c302bea11UL;
   tf->codes[15512] = 0x0005f18e3f331dfeUL;
   tf->codes[15513] = 0x0005f1960631e228UL;
   tf->codes[15514] = 0x0005f1cb525e2275UL;
   tf->codes[15515] = 0x0005f1db1aeab08eUL;
   tf->codes[15516] = 0x0005f1dd29f1e47bUL;
   tf->codes[15517] = 0x0005f1f9c1c7b5acUL;
   tf->codes[15518] = 0x0005f1fc807bfae8UL;
   tf->codes[15519] = 0x0005f2014e377411UL;
   tf->codes[15520] = 0x0005f207062f044eUL;
   tf->codes[15521] = 0x0005f20ff1f8e551UL;
   tf->codes[15522] = 0x0005f21952e0d1deUL;
   tf->codes[15523] = 0x0005f21cfbd12e2eUL;
   tf->codes[15524] = 0x0005f25247fd6e7bUL;
   tf->codes[15525] = 0x0005f25be37460cdUL;
   tf->codes[15526] = 0x0005f25e6799a044UL;
   tf->codes[15527] = 0x0005f291a4beaca4UL;
   tf->codes[15528] = 0x0005f29b40359ef6UL;
   tf->codes[15529] = 0x0005f2b0c0b9bd4cUL;
   tf->codes[15530] = 0x0005f2b2cfc0f139UL;
   tf->codes[15531] = 0x0005f2c72b79f2b6UL;
   tf->codes[15532] = 0x0005f3090c607056UL;
   tf->codes[15533] = 0x0005f31cb86c6084UL;
   tf->codes[15534] = 0x0005f33238f07edaUL;
   tf->codes[15535] = 0x0005f33c49857cb6UL;
   tf->codes[15536] = 0x0005f342ebb92407UL;
   tf->codes[15537] = 0x0005f355ad88fd21UL;
   tf->codes[15538] = 0x0005f36cc7f643daUL;
   tf->codes[15539] = 0x0005f37d402fe342UL;
   tf->codes[15540] = 0x0005f3b1dcaf1240UL;
   tf->codes[15541] = 0x0005f3bcd7802730UL;
   tf->codes[15542] = 0x0005f3c5fdd90df8UL;
   tf->codes[15543] = 0x0005f3cb40b292abUL;
   tf->codes[15544] = 0x0005f3cfd3df060fUL;
   tf->codes[15545] = 0x0005f3d292934b4bUL;
   tf->codes[15546] = 0x0005f3ec6bb4d740UL;
   tf->codes[15547] = 0x0005f3ee059dffa3UL;
   tf->codes[15548] = 0x0005f40b1291dc5eUL;
   tf->codes[15549] = 0x0005f41906a63c4fUL;
   tf->codes[15550] = 0x0005f458d8858602UL;
   tf->codes[15551] = 0x0005f45b221bbfb4UL;
   tf->codes[15552] = 0x0005f478debcadbeUL;
   tf->codes[15553] = 0x0005f4953c03792aUL;
   tf->codes[15554] = 0x0005f4b0747f27bdUL;
   tf->codes[15555] = 0x0005f4c8040a7a00UL;
   tf->codes[15556] = 0x0005f4d24f2e7da1UL;
   tf->codes[15557] = 0x0005f4d71ce9f6caUL;
   tf->codes[15558] = 0x0005f4f4d98ae4d4UL;
   tf->codes[15559] = 0x0005f4f80d5d359aUL;
   tf->codes[15560] = 0x0005f4fbf0dc97afUL;
   tf->codes[15561] = 0x0005f506768fa115UL;
   tf->codes[15562] = 0x0005f540cb066050UL;
   tf->codes[15563] = 0x0005f543149c9a02UL;
   tf->codes[15564] = 0x0005f55a6998e680UL;
   tf->codes[15565] = 0x0005f56096ae8247UL;
   tf->codes[15566] = 0x0005f59b60434d0cUL;
   tf->codes[15567] = 0x0005f59cfa2c756fUL;
   tf->codes[15568] = 0x0005f59f7e51b4e6UL;
   tf->codes[15569] = 0x0005f5d41ad0e3e4UL;
   tf->codes[15570] = 0x0005f5ddb647d636UL;
   tf->codes[15571] = 0x0005f5dedb12f30fUL;
   tf->codes[15572] = 0x0005f5ec5a094776UL;
   tf->codes[15573] = 0x0005f5f2871ee33dUL;
   tf->codes[15574] = 0x0005f5f9d8ff9bddUL;
   tf->codes[15575] = 0x0005f6019ffe6007UL;
   tf->codes[15576] = 0x0005f60d4a7c8646UL;
   tf->codes[15577] = 0x0005f6100930cb82UL;
   tf->codes[15578] = 0x0005f617d02f8facUL;
   tf->codes[15579] = 0x0005f629a7c351b2UL;
   tf->codes[15580] = 0x0005f64380e4dda7UL;
   tf->codes[15581] = 0x0005f650159f1afaUL;
   tf->codes[15582] = 0x0005f6773327f591UL;
   tf->codes[15583] = 0x0005f68352c4275aUL;
   tf->codes[15584] = 0x0005f6bd6cabe0d0UL;
   tf->codes[15585] = 0x0005f6c7b7cfe471UL;
   tf->codes[15586] = 0x0005f6d3d76c163aUL;
   tf->codes[15587] = 0x0005f6d4fc373313UL;
   tf->codes[15588] = 0x0005f6d9c9f2ac3cUL;
   tf->codes[15589] = 0x0005f6da799fbd8bUL;
   tf->codes[15590] = 0x0005f6db9e6ada64UL;
   tf->codes[15591] = 0x0005f6ff88216435UL;
   tf->codes[15592] = 0x0005f708395c3f73UL;
   tf->codes[15593] = 0x0005f712f99e4e9eUL;
   tf->codes[15594] = 0x0005f7178ccac202UL;
   tf->codes[15595] = 0x0005f71ccfa446b5UL;
   tf->codes[15596] = 0x0005f71d44c2523fUL;
   tf->codes[15597] = 0x0005f72a4e9a9b1cUL;
   tf->codes[15598] = 0x0005f735be89bb96UL;
   tf->codes[15599] = 0x0005f7425343f8e9UL;
   tf->codes[15600] = 0x0005f74636c35afeUL;
   tf->codes[15601] = 0x0005f752565f8cc7UL;
   tf->codes[15602] = 0x0005f75848e622c9UL;
   tf->codes[15603] = 0x0005f770c2ad8c20UL;
   tf->codes[15604] = 0x0005f7885238de63UL;
   tf->codes[15605] = 0x0005f792283ed67aUL;
   tf->codes[15606] = 0x0005f79730895568UL;
   tf->codes[15607] = 0x0005f7b9bae5bc9bUL;
   tf->codes[15608] = 0x0005f7c64f9ff9eeUL;
   tf->codes[15609] = 0x0005f7e4bbedf947UL;
   tf->codes[15610] = 0x0005f7e4f67cff0cUL;
   tf->codes[15611] = 0x0005f806969d4f2bUL;
   tf->codes[15612] = 0x0005f81783f4fa1dUL;
   tf->codes[15613] = 0x0005f818a8c016f6UL;
   tf->codes[15614] = 0x0005f81f4af3be47UL;
   tf->codes[15615] = 0x0005f8471829aa2dUL;
   tf->codes[15616] = 0x0005f85cd33cce48UL;
   tf->codes[15617] = 0x0005f85d82e9df97UL;
   tf->codes[15618] = 0x0005f875c2224329UL;
   tf->codes[15619] = 0x0005f8b3bf895eb4UL;
   tf->codes[15620] = 0x0005f8b51ee38152UL;
   tf->codes[15621] = 0x0005f8ccae6ed395UL;
   tf->codes[15622] = 0x0005f8d091ee35aaUL;
   tf->codes[15623] = 0x0005f8d5d4c7ba5dUL;
   tf->codes[15624] = 0x0005f9089ccebb33UL;
   tf->codes[15625] = 0x0005f90bd0a10bf9UL;
   tf->codes[15626] = 0x0005f91272d4b34aUL;
   tf->codes[15627] = 0x0005f91c8369b126UL;
   tf->codes[15628] = 0x0005f9636c9aadb4UL;
   tf->codes[15629] = 0x0005f969d43f4f40UL;
   tf->codes[15630] = 0x0005f97718a69de2UL;
   tf->codes[15631] = 0x0005f9ae73da121cUL;
   tf->codes[15632] = 0x0005f9b4db7eb3a8UL;
   tf->codes[15633] = 0x0005f9bca27d77d2UL;
   tf->codes[15634] = 0x0005f9db0ecb772bUL;
   tf->codes[15635] = 0x0005f9f60cb81ff9UL;
   tf->codes[15636] = 0x0005fa1c0575ddb7UL;
   tf->codes[15637] = 0x0005fa46cbef149eUL;
   tf->codes[15638] = 0x0005fa4d3393b62aUL;
   tf->codes[15639] = 0x0005fa6781d34da9UL;
   tf->codes[15640] = 0x0005fa7242155cd4UL;
   tf->codes[15641] = 0x0005fa9abef85a09UL;
   tf->codes[15642] = 0x0005fa9c1e527ca7UL;
   tf->codes[15643] = 0x0005fb108cb0f558UL;
   tf->codes[15644] = 0x0005fb31b7b339edUL;
   tf->codes[15645] = 0x0005fb59fa07315dUL;
   tf->codes[15646] = 0x0005fb7064c766c7UL;
   tf->codes[15647] = 0x0005fb761cbef704UL;
   tf->codes[15648] = 0x0005fb9747c13b99UL;
   tf->codes[15649] = 0x0005fbaf11db93a1UL;
   tf->codes[15650] = 0x0005fbc36d94951eUL;
   tf->codes[15651] = 0x0005fbc83b500e47UL;
   tf->codes[15652] = 0x0005fbdbe75bfe75UL;
   tf->codes[15653] = 0x0005fbf28cab39a4UL;
   tf->codes[15654] = 0x0005fbf4d6417356UL;
   tf->codes[15655] = 0x0005fbf8b9c0d56bUL;
   tf->codes[15656] = 0x0005fc1b441d3c9eUL;
   tf->codes[15657] = 0x0005fc1c2e5953b2UL;
   tf->codes[15658] = 0x0005fc1c68e85977UL;
   tf->codes[15659] = 0x0005fc429c351cfaUL;
   tf->codes[15660] = 0x0005fc46ba4384d4UL;
   tf->codes[15661] = 0x0005fc5b15fc8651UL;
   tf->codes[15662] = 0x0005fc6a2edc031bUL;
   tf->codes[15663] = 0x0005fc6c78723ccdUL;
   tf->codes[15664] = 0x0005fc87765ee59bUL;
   tf->codes[15665] = 0x0005fc952fe43fc7UL;
   tf->codes[15666] = 0x0005fcad348d9d94UL;
   tf->codes[15667] = 0x0005fcaf4394d181UL;
   tf->codes[15668] = 0x0005fcc623731275UL;
   tf->codes[15669] = 0x0005fcc782cd3513UL;
   tf->codes[15670] = 0x0005fcd6268ea653UL;
   tf->codes[15671] = 0x0005fcd785e8c8f1UL;
   tf->codes[15672] = 0x0005fcd95a60f719UL;
   tf->codes[15673] = 0x0005fd0754ac7ec6UL;
   tf->codes[15674] = 0x0005fd1423f5c1deUL;
   tf->codes[15675] = 0x0005fd1dbf6cb430UL;
   tf->codes[15676] = 0x0005fd530b98f47dUL;
   tf->codes[15677] = 0x0005fd579ec567e1UL;
   tf->codes[15678] = 0x0005fd5e7b8814f7UL;
   tf->codes[15679] = 0x0005fd7854a9a0ecUL;
   tf->codes[15680] = 0x0005fdb776dbd950UL;
   tf->codes[15681] = 0x0005fdf44f77d802UL;
   tf->codes[15682] = 0x0005fe0af4c71331UL;
   tf->codes[15683] = 0x0005fe2db9b28029UL;
   tf->codes[15684] = 0x0005fe3580b14453UL;
   tf->codes[15685] = 0x0005fe3e31ec1f91UL;
   tf->codes[15686] = 0x0005fe4374c5a444UL;
   tf->codes[15687] = 0x0005fe4b76536e33UL;
   tf->codes[15688] = 0x0005fe675e7c2e15UL;
   tf->codes[15689] = 0x0005fe6accdd84a0UL;
   tf->codes[15690] = 0x0005fe79709ef5e0UL;
   tf->codes[15691] = 0x0005fe8430e1050bUL;
   tf->codes[15692] = 0x0005fe8e06e6fd22UL;
   tf->codes[15693] = 0x0005fe9b10bf45ffUL;
   tf->codes[15694] = 0x0005fec59ca97721UL;
   tf->codes[15695] = 0x0005fec686e58e35UL;
   tf->codes[15696] = 0x0005fed90e26618aUL;
   tf->codes[15697] = 0x0005fedcf1a5c39fUL;
   tf->codes[15698] = 0x0005feec7fa34bf3UL;
   tf->codes[15699] = 0x0005feefb3759cb9UL;
   tf->codes[15700] = 0x0005fefc482fda0cUL;
   tf->codes[15701] = 0x0005ff29583f4aa5UL;
   tf->codes[15702] = 0x0005ff4714e038afUL;
   tf->codes[15703] = 0x0005ff6bae43d3cfUL;
   tf->codes[15704] = 0x0005ff82c8b11a88UL;
   tf->codes[15705] = 0x0005ffbe0763f0d7UL;
   tf->codes[15706] = 0x0005ffdd235f017fUL;
   tf->codes[15707] = 0x0005ffe4ea5dc5a9UL;
   tf->codes[15708] = 0x00060040def4d503UL;
   tf->codes[15709] = 0x0006004de8cd1de0UL;
   tf->codes[15710] = 0x00060059cdda49e4UL;
   tf->codes[15711] = 0x0006006d04c82e88UL;
   tf->codes[15712] = 0x000600899c9dffb9UL;
   tf->codes[15713] = 0x00060095bc3a3182UL;
   tf->codes[15714] = 0x000600a8f3281626UL;
   tf->codes[15715] = 0x000600b7d1788d2bUL;
   tf->codes[15716] = 0x000600bd4ee117a3UL;
   tf->codes[15717] = 0x000600bf5de84b90UL;
   tf->codes[15718] = 0x000600c849b22c93UL;
   tf->codes[15719] = 0x000600d37f124748UL;
   tf->codes[15720] = 0x000600dd1a89399aUL;
   tf->codes[15721] = 0x000600fbfbf5447dUL;
   tf->codes[15722] = 0x000600ffa4e5a0cdUL;
   tf->codes[15723] = 0x0006010681a84de3UL;
   tf->codes[15724] = 0x0006011141ea5d0eUL;
   tf->codes[15725] = 0x0006012e4ede39c9UL;
   tf->codes[15726] = 0x0006014cf5bb3ee7UL;
   tf->codes[15727] = 0x0006014ddff755fbUL;
   tf->codes[15728] = 0x0006015f07de06b2UL;
   tf->codes[15729] = 0x0006015ff21a1dc6UL;
   tf->codes[15730] = 0x00060165e4a0b3c8UL;
   tf->codes[15731] = 0x0006017af006c694UL;
   tf->codes[15732] = 0x0006017e5e681d1fUL;
   tf->codes[15733] = 0x00060185ead7db84UL;
   tf->codes[15734] = 0x000601cb3a1fafafUL;
   tf->codes[15735] = 0x000601cb74aeb574UL;
   tf->codes[15736] = 0x000601cc5eeacc88UL;
   tf->codes[15737] = 0x000601d0f2173fecUL;
   tf->codes[15738] = 0x000601d87e86fe51UL;
   tf->codes[15739] = 0x000601e9a66daf08UL;
   tf->codes[15740] = 0x0006020a96e0edd8UL;
   tf->codes[15741] = 0x0006021ef299ef55UL;
   tf->codes[15742] = 0x0006023e0e94fffdUL;
   tf->codes[15743] = 0x0006024fab99bc3eUL;
   tf->codes[15744] = 0x00060269bf4a4df8UL;
   tf->codes[15745] = 0x0006026a6ef75f47UL;
   tf->codes[15746] = 0x0006026bce5181e5UL;
   tf->codes[15747] = 0x00060274ba1b62e8UL;
   tf->codes[15748] = 0x0006027cbba92cd7UL;
   tf->codes[15749] = 0x000602b91f271fffUL;
   tf->codes[15750] = 0x000602ba7e81429dUL;
   tf->codes[15751] = 0x000602be27719eedUL;
   tf->codes[15752] = 0x000602c6d8ac7a2bUL;
   tf->codes[15753] = 0x000602e803aebec0UL;
   tf->codes[15754] = 0x0006030167b23f2bUL;
   tf->codes[15755] = 0x000603084474ec41UL;
   tf->codes[15756] = 0x00060315fdfa466dUL;
   tf->codes[15757] = 0x000603196c5b9cf8UL;
   tf->codes[15758] = 0x0006033e7add43a2UL;
   tf->codes[15759] = 0x0006034766a724a5UL;
   tf->codes[15760] = 0x0006036cea46d6d9UL;
   tf->codes[15761] = 0x0006036fa8fb1c15UL;
   tf->codes[15762] = 0x000603743c278f79UL;
   tf->codes[15763] = 0x0006038404b41d92UL;
   tf->codes[15764] = 0x00060391f8c87d83UL;
   tf->codes[15765] = 0x000603bb9a769791UL;
   tf->codes[15766] = 0x000603c117df2209UL;
   tf->codes[15767] = 0x000603cf468287bfUL;
   tf->codes[15768] = 0x000603df0f0f15d8UL;
   tf->codes[15769] = 0x000603fedab737cfUL;
   tf->codes[15770] = 0x000603ffff8254a8UL;
   tf->codes[15771] = 0x00060409606a4135UL;
   tf->codes[15772] = 0x0006041ee0ee5f8bUL;
   tf->codes[15773] = 0x0006046345fa1ca2UL;
   tf->codes[15774] = 0x00060479b0ba520cUL;
   tf->codes[15775] = 0x00060484e61a6cc1UL;
   tf->codes[15776] = 0x00060497a7ea45dbUL;
   tf->codes[15777] = 0x000604d35bbb27b4UL;
   tf->codes[15778] = 0x000604fcc2da3bfdUL;
   tf->codes[15779] = 0x000605336e609ee8UL;
   tf->codes[15780] = 0x00060535f285de5fUL;
   tf->codes[15781] = 0x0006054d0cf32518UL;
   tf->codes[15782] = 0x000605c7e2f63f55UL;
   tf->codes[15783] = 0x000605d352e55fcfUL;
   tf->codes[15784] = 0x000605daa4c6186fUL;
   tf->codes[15785] = 0x000605dc3eaf40d2UL;
   tf->codes[15786] = 0x000605f31e8d81c6UL;
   tf->codes[15787] = 0x000605f89bf60c3eUL;
   tf->codes[15788] = 0x000605fb5aaa517aUL;
   tf->codes[15789] = 0x000605fbcfc85d04UL;
   tf->codes[15790] = 0x0006060cf7af0dbbUL;
   tf->codes[15791] = 0x00060618a22d33faUL;
   tf->codes[15792] = 0x0006065a0df5a610UL;
   tf->codes[15793] = 0x0006065fc5ed364dUL;
   tf->codes[15794] = 0x000606678cebfa77UL;
   tf->codes[15795] = 0x0006069b3f2f1261UL;
   tf->codes[15796] = 0x000606af9ae813deUL;
   tf->codes[15797] = 0x000606c9ae98a598UL;
   tf->codes[15798] = 0x000606d817cb1113UL;
   tf->codes[15799] = 0x000606dd5aa495c6UL;
   tf->codes[15800] = 0x000606e4ac854e66UL;
   tf->codes[15801] = 0x00060740dbab6385UL;
   tf->codes[15802] = 0x000607453448d124UL;
   tf->codes[15803] = 0x00060745e3f5e273UL;
   tf->codes[15804] = 0x00060770e4fe1f1fUL;
   tf->codes[15805] = 0x000607e0c030246cUL;
   tf->codes[15806] = 0x000607f381fffd86UL;
   tf->codes[15807] = 0x0006086c0e6cde11UL;
   tf->codes[15808] = 0x0006088a7abadd6aUL;
   tf->codes[15809] = 0x0006089450c0d581UL;
   tf->codes[15810] = 0x000608ca4c9a271dUL;
   tf->codes[15811] = 0x000608d24e27f10cUL;
   tf->codes[15812] = 0x000608f28eee1e8dUL;
   tf->codes[15813] = 0x000609042bf2daceUL;
   tf->codes[15814] = 0x0006093a27cc2c6aUL;
   tf->codes[15815] = 0x0006095b8d5d76c4UL;
   tf->codes[15816] = 0x0006095cecb79962UL;
   tf->codes[15817] = 0x0006096aa63cf38eUL;
   tf->codes[15818] = 0x0006097c4341afcfUL;
   tf->codes[15819] = 0x000609835a9362aaUL;
   tf->codes[15820] = 0x000609b2eec812baUL;
   tf->codes[15821] = 0x000609bc4fafff47UL;
   tf->codes[15822] = 0x000609f753d3cfd1UL;
   tf->codes[15823] = 0x000609f8789eecaaUL;
   tf->codes[15824] = 0x00060a0ee35f2214UL;
   tf->codes[15825] = 0x00060a149b56b251UL;
   tf->codes[15826] = 0x00060a1b78195f67UL;
   tf->codes[15827] = 0x00060a425b133439UL;
   tf->codes[15828] = 0x00060a48c2b7d5c5UL;
   tf->codes[15829] = 0x00060a655a8da6f6UL;
   tf->codes[15830] = 0x00060ad4c0a1a0b9UL;
   tf->codes[15831] = 0x00060ad5aaddb7cdUL;
   tf->codes[15832] = 0x00060ada037b256cUL;
   tf->codes[15833] = 0x00060ae99178adc0UL;
   tf->codes[15834] = 0x00060b0454d650c9UL;
   tf->codes[15835] = 0x00060b4008a732a2UL;
   tf->codes[15836] = 0x00060b533f951746UL;
   tf->codes[15837] = 0x00060b6b443e7513UL;
   tf->codes[15838] = 0x00060b7888a5c3b5UL;
   tf->codes[15839] = 0x00060b82d3c9c756UL;
   tf->codes[15840] = 0x00060b9470ce8397UL;
   tf->codes[15841] = 0x00060b976a11ce98UL;
   tf->codes[15842] = 0x00060b9fe0bda411UL;
   tf->codes[15843] = 0x00060bbf3747ba7eUL;
   tf->codes[15844] = 0x00060bd2a8c4a4e7UL;
   tf->codes[15845] = 0x00060bd52ce9e45eUL;
   tf->codes[15846] = 0x00060c0cfd3b6422UL;
   tf->codes[15847] = 0x00060c1e5fb11a9eUL;
   tf->codes[15848] = 0x00060c3e2b593c95UL;
   tf->codes[15849] = 0x00060c462ce70684UL;
   tf->codes[15850] = 0x00060c4f18b0e787UL;
   tf->codes[15851] = 0x00060c59d8f2f6b2UL;
   tf->codes[15852] = 0x00060c7e725691d2UL;
   tf->codes[15853] = 0x00060c83efbf1c4aUL;
   tf->codes[15854] = 0x00060c9f62c9d0a2UL;
   tf->codes[15855] = 0x00060cc81a3bd39cUL;
   tf->codes[15856] = 0x00060cd524141c79UL;
   tf->codes[15857] = 0x00060d156b1171b6UL;
   tf->codes[15858] = 0x00060d470e4d55b3UL;
   tf->codes[15859] = 0x00060d4d75f1f73fUL;
   tf->codes[15860] = 0x00060d5b6a065730UL;
   tf->codes[15861] = 0x00060d7a4b726213UL;
   tf->codes[15862] = 0x00060d88b4a4cd8eUL;
   tf->codes[15863] = 0x00060d8b735912caUL;
   tf->codes[15864] = 0x00060d907ba391b8UL;
   tf->codes[15865] = 0x00060d91dafdb456UL;
   tf->codes[15866] = 0x00060d95495f0ae1UL;
   tf->codes[15867] = 0x00060d98b7c0616cUL;
   tf->codes[15868] = 0x00060dc00fd841c8UL;
   tf->codes[15869] = 0x00060dd5caeb65e3UL;
   tf->codes[15870] = 0x00060e14b28e9882UL;
   tf->codes[15871] = 0x00060e4e5758466eUL;
   tf->codes[15872] = 0x00060e51509b916fUL;
   tf->codes[15873] = 0x00060e698fd3f501UL;
   tf->codes[15874] = 0x00060e9a0e44bc25UL;
   tf->codes[15875] = 0x00060ebfcc73741eUL;
   tf->codes[15876] = 0x00060ec9a2796c35UL;
   tf->codes[15877] = 0x00060ee8be747cddUL;
   tf->codes[15878] = 0x00060f0fdbfd5774UL;
   tf->codes[15879] = 0x00060f134a5eadffUL;
   tf->codes[15880] = 0x00060f490ba8f9d6UL;
   tf->codes[15881] = 0x00060f5774db6551UL;
   tf->codes[15882] = 0x00060f5c4296de7aUL;
   tf->codes[15883] = 0x00060f7656477034UL;
   tf->codes[15884] = 0x00060ff166d99036UL;
   tf->codes[15885] = 0x00060ff7ce7e31c2UL;
   tf->codes[15886] = 0x0006101082d4a0deUL;
   tf->codes[15887] = 0x000610451f53cfdcUL;
   tf->codes[15888] = 0x0006105681c98658UL;
   tf->codes[15889] = 0x000610789707e201UL;
   tf->codes[15890] = 0x0006108b58d7bb1bUL;
   tf->codes[15891] = 0x000610909bb13fceUL;
   tf->codes[15892] = 0x000610cdaedc4445UL;
   tf->codes[15893] = 0x000611479aa3476eUL;
   tf->codes[15894] = 0x0006115603d5b2e9UL;
   tf->codes[15895] = 0x0006115b46af379cUL;
   tf->codes[15896] = 0x0006115d1b2765c4UL;
   tf->codes[15897] = 0x000611cde0958225UL;
   tf->codes[15898] = 0x000611e70a09fccbUL;
   tf->codes[15899] = 0x000611ed71ae9e57UL;
   tf->codes[15900] = 0x000611f782439c33UL;
   tf->codes[15901] = 0x000612141a196d64UL;
   tf->codes[15902] = 0x00061216d8cdb2a0UL;
   tf->codes[15903] = 0x0006123b72314dc0UL;
   tf->codes[15904] = 0x0006124c9a17fe77UL;
   tf->codes[15905] = 0x0006126588fd7358UL;
   tf->codes[15906] = 0x0006127a59d4805fUL;
   tf->codes[15907] = 0x0006128e7afe7c17UL;
   tf->codes[15908] = 0x0006129592502ef2UL;
   tf->codes[15909] = 0x00061298c6227fb8UL;
   tf->codes[15910] = 0x000612bdd4a42662UL;
   tf->codes[15911] = 0x000612c52684df02UL;
   tf->codes[15912] = 0x000612c9449346dcUL;
   tf->codes[15913] = 0x000612ed2e49d0adUL;
   tf->codes[15914] = 0x000612f35b5f6c74UL;
   tf->codes[15915] = 0x000612f8d8c7f6ecUL;
   tf->codes[15916] = 0x000613415be21bddUL;
   tf->codes[15917] = 0x0006134788f7b7a4UL;
   tf->codes[15918] = 0x0006134edad87044UL;
   tf->codes[15919] = 0x0006135492d00081UL;
   tf->codes[15920] = 0x0006135baa21b35cUL;
   tf->codes[15921] = 0x0006135be4b0b921UL;
   tf->codes[15922] = 0x00061363abaf7d4bUL;
   tf->codes[15923] = 0x0006136495eb945fUL;
   tf->codes[15924] = 0x00061366df81ce11UL;
   tf->codes[15925] = 0x0006138a198b4693UL;
   tf->codes[15926] = 0x0006139bb69002d4UL;
   tf->codes[15927] = 0x000613c13a2fb508UL;
   tf->codes[15928] = 0x000613c7a1d45694UL;
   tf->codes[15929] = 0x000613ca9b17a195UL;
   tf->codes[15930] = 0x000613e474392d8aUL;
   tf->codes[15931] = 0x000613f40236b5deUL;
   tf->codes[15932] = 0x000613f7360906a4UL;
   tf->codes[15933] = 0x00061401469e0480UL;
   tf->codes[15934] = 0x00061414086ddd9aUL;
   tf->codes[15935] = 0x0006141c7f19b313UL;
   tf->codes[15936] = 0x00061445aba9c197UL;
   tf->codes[15937] = 0x0006146a0a7e56f2UL;
   tf->codes[15938] = 0x00061486dce32de8UL;
   tf->codes[15939] = 0x0006148ac0628ffdUL;
   tf->codes[15940] = 0x000614916296374eUL;
   tf->codes[15941] = 0x00061491d7b442d8UL;
   tf->codes[15942] = 0x000614c54f6854fdUL;
   tf->codes[15943] = 0x000614d084c86fb2UL;
   tf->codes[15944] = 0x000614e7d9c4bc30UL;
   tf->codes[15945] = 0x000614f7dce0500eUL;
   tf->codes[15946] = 0x00061514af452704UL;
   tf->codes[15947] = 0x000615176df96c40UL;
   tf->codes[15948] = 0x0006153390b131e7UL;
   tf->codes[15949] = 0x0006155396e859a3UL;
   tf->codes[15950] = 0x00061559c3fdf56aUL;
   tf->codes[15951] = 0x00061573d7ae8724UL;
   tf->codes[15952] = 0x0006157c13cb56d8UL;
   tf->codes[15953] = 0x00061597fbf416baUL;
   tf->codes[15954] = 0x000615a247181a5bUL;
   tf->codes[15955] = 0x000615eb79df509bUL;
   tf->codes[15956] = 0x000615ef97edb875UL;
   tf->codes[15957] = 0x0006165b1a825023UL;
   tf->codes[15958] = 0x0006167568c1e7a2UL;
   tf->codes[15959] = 0x00061677ece72719UL;
   tf->codes[15960] = 0x0006169fba1d12ffUL;
   tf->codes[15961] = 0x000616c95bcb2d0dUL;
   tf->codes[15962] = 0x000616cc8f9d7dd3UL;
   tf->codes[15963] = 0x00061713b35d8026UL;
   tf->codes[15964] = 0x0006171dc3f27e02UL;
   tf->codes[15965] = 0x0006173762850432UL;
   tf->codes[15966] = 0x000617388750210bUL;
   tf->codes[15967] = 0x0006173dca29a5beUL;
   tf->codes[15968] = 0x0006176e0e0b671dUL;
   tf->codes[15969] = 0x000617797dfa8797UL;
   tf->codes[15970] = 0x0006177c773dd298UL;
   tf->codes[15971] = 0x0006178c7a596676UL;
   tf->codes[15972] = 0x0006179b1e1ad7b6UL;
   tf->codes[15973] = 0x000617ced05defa0UL;
   tf->codes[15974] = 0x000617cf0aecf565UL;
   tf->codes[15975] = 0x000617d488557fddUL;
   tf->codes[15976] = 0x000617d8a663e7b7UL;
   tf->codes[15977] = 0x000618575fe66409UL;
   tf->codes[15978] = 0x00061858bf4086a7UL;
   tf->codes[15979] = 0x00061861707b61e5UL;
   tf->codes[15980] = 0x0006186d55888de9UL;
   tf->codes[15981] = 0x00061874324b3affUL;
   tf->codes[15982] = 0x000618772b8e8600UL;
   tf->codes[15983] = 0x0006187a99efdc8bUL;
   tf->codes[15984] = 0x0006187e7d6f3ea0UL;
   tf->codes[15985] = 0x0006188176b289a1UL;
   tf->codes[15986] = 0x0006189c749f326fUL;
   tf->codes[15987] = 0x000618c1bdafdedeUL;
   tf->codes[15988] = 0x000618d828701448UL;
   tf->codes[15989] = 0x000618e2739417e9UL;
   tf->codes[15990] = 0x000618e61c847439UL;
   tf->codes[15991] = 0x000618eaafb0e79dUL;
   tf->codes[15992] = 0x000618f7f418363fUL;
   tf->codes[15993] = 0x000618fed0dae355UL;
   tf->codes[15994] = 0x000619044e436dcdUL;
   tf->codes[15995] = 0x0006191834de63c0UL;
   tf->codes[15996] = 0x0006191b2e21aec1UL;
   tf->codes[15997] = 0x0006194ee064c6abUL;
   tf->codes[15998] = 0x0006195b0000f874UL;
   tf->codes[15999] = 0x0006196844684716UL;
   tf->codes[16000] = 0x0006197588cf95b8UL;
   tf->codes[16001] = 0x0006198f27621be8UL;
   tf->codes[16002] = 0x00061993457083c2UL;
   tf->codes[16003] = 0x000619c55dca7349UL;
   tf->codes[16004] = 0x000619d1f284b09cUL;
   tf->codes[16005] = 0x000619d81f9a4c63UL;
   tf->codes[16006] = 0x000619fb1f14bf20UL;
   tf->codes[16007] = 0x00061a1b9a69f266UL;
   tf->codes[16008] = 0x00061a96aafc1268UL;
   tf->codes[16009] = 0x00061ab30842ddd4UL;
   tf->codes[16010] = 0x00061abbb97db912UL;
   tf->codes[16011] = 0x00061ac04caa2c76UL;
   tf->codes[16012] = 0x00061ac30b5e71b2UL;
   tf->codes[16013] = 0x00061acb0cec3ba1UL;
   tf->codes[16014] = 0x00061aec37ee8036UL;
   tf->codes[16015] = 0x00061afe84a04dc6UL;
   tf->codes[16016] = 0x00061b1738f6bce2UL;
   tf->codes[16017] = 0x00061b32ac01713aUL;
   tf->codes[16018] = 0x00061b373f2de49eUL;
   tf->codes[16019] = 0x00061b70e3f7928aUL;
   tf->codes[16020] = 0x00061b7417c9e350UL;
   tf->codes[16021] = 0x00061b8330a9601aUL;
   tf->codes[16022] = 0x00061b88e8a0f057UL;
   tf->codes[16023] = 0x00061b9be4ffcf36UL;
   tf->codes[16024] = 0x00061b9d7ee8f799UL;
   tf->codes[16025] = 0x00061bbfceb65907UL;
   tf->codes[16026] = 0x00061bc043d46491UL;
   tf->codes[16027] = 0x00061bc1a32e872fUL;
   tf->codes[16028] = 0x00061bc2184c92b9UL;
   tf->codes[16029] = 0x00061bc795b51d31UL;
   tf->codes[16030] = 0x00061bde3b045860UL;
   tf->codes[16031] = 0x00061be21e83ba75UL;
   tf->codes[16032] = 0x00061bf012981a66UL;
   tf->codes[16033] = 0x00061c1bc34d6861UL;
   tf->codes[16034] = 0x00061c505fcc975fUL;
   tf->codes[16035] = 0x00061c6480f69317UL;
   tf->codes[16036] = 0x00061c7e94a724d1UL;
   tf->codes[16037] = 0x00061c8aeed25c5fUL;
   tf->codes[16038] = 0x00061c9bdc2a0751UL;
   tf->codes[16039] = 0x00061cc2bf23dc23UL;
   tf->codes[16040] = 0x00061cdd82817f2cUL;
   tf->codes[16041] = 0x00061cedfabb1e94UL;
   tf->codes[16042] = 0x00061cf845df2235UL;
   tf->codes[16043] = 0x00061d0306213160UL;
   tf->codes[16044] = 0x00061d0dc663408bUL;
   tf->codes[16045] = 0x00061d54af943d19UL;
   tf->codes[16046] = 0x00061d74061e5386UL;
   tf->codes[16047] = 0x00061d785ebbc125UL;
   tf->codes[16048] = 0x00061d7a6dc2f512UL;
   tf->codes[16049] = 0x00061d92acfb58a4UL;
   tf->codes[16050] = 0x00061d9cf81f5c45UL;
   tf->codes[16051] = 0x00061db8e0481c27UL;
   tf->codes[16052] = 0x00061dcbdca6fb06UL;
   tf->codes[16053] = 0x00061dce9b5b4042UL;
   tf->codes[16054] = 0x00061dd627cafea7UL;
   tf->codes[16055] = 0x00061dd7c1b4270aUL;
   tf->codes[16056] = 0x00061ddcc9fea5f8UL;
   tf->codes[16057] = 0x00061de15d2b195cUL;
   tf->codes[16058] = 0x00061de1d24924e6UL;
   tf->codes[16059] = 0x00061df334bedb62UL;
   tf->codes[16060] = 0x00061dfbab6ab0dbUL;
   tf->codes[16061] = 0x00061e166ec853e4UL;
   tf->codes[16062] = 0x00061e2b3f9f60ebUL;
   tf->codes[16063] = 0x00061e380ee8a403UL;
   tf->codes[16064] = 0x00061e3a587eddb5UL;
   tf->codes[16065] = 0x00061e4936cf54baUL;
   tf->codes[16066] = 0x00061e4b80658e6cUL;
   tf->codes[16067] = 0x00061e5ce2db44e8UL;
   tf->codes[16068] = 0x00061e6f2f8d1278UL;
   tf->codes[16069] = 0x00061e72635f633eUL;
   tf->codes[16070] = 0x00061e76f68bd6a2UL;
   tf->codes[16071] = 0x00061e7b149a3e7cUL;
   tf->codes[16072] = 0x00061e9d9ef6a5afUL;
   tf->codes[16073] = 0x00061eda027498d7UL;
   tf->codes[16074] = 0x00061ef7bf1586e1UL;
   tf->codes[16075] = 0x00061f0e29d5bc4bUL;
   tf->codes[16076] = 0x00061f3a4fa915d0UL;
   tf->codes[16077] = 0x00061f525452739dUL;
   tf->codes[16078] = 0x00061fa73197d01cUL;
   tf->codes[16079] = 0x00061fc1f4f57325UL;
   tf->codes[16080] = 0x00061fd9f99ed0f2UL;
   tf->codes[16081] = 0x00061fe1fb2c9ae1UL;
   tf->codes[16082] = 0x00061fecbb6eaa0cUL;
   tf->codes[16083] = 0x00061fecf5fdafd1UL;
   tf->codes[16084] = 0x00061ffa74f40438UL;
   tf->codes[16085] = 0x00062005aa541eedUL;
   tf->codes[16086] = 0x0006201a409c262fUL;
   tf->codes[16087] = 0x000620441cd94602UL;
   tf->codes[16088] = 0x0006205335b8c2ccUL;
   tf->codes[16089] = 0x00062076aa514113UL;
   tf->codes[16090] = 0x000620792e76808aUL;
   tf->codes[16091] = 0x000620c29bccbc8fUL;
   tf->codes[16092] = 0x000620c4aad3f07cUL;
   tf->codes[16093] = 0x000620ccac61ba6bUL;
   tf->codes[16094] = 0x000620efabdc2d28UL;
   tf->codes[16095] = 0x000620f4eeb5b1dbUL;
   tf->codes[16096] = 0x000620fa6c1e3c53UL;
   tf->codes[16097] = 0x00062113d021bcbeUL;
   tf->codes[16098] = 0x0006213c1275b42eUL;
   tf->codes[16099] = 0x0006213e5c0bede0UL;
   tf->codes[16100] = 0x0006213e969af3a5UL;
   tf->codes[16101] = 0x0006214d74eb6aaaUL;
   tf->codes[16102] = 0x0006214dea097634UL;
   tf->codes[16103] = 0x0006215ab952b94cUL;
   tf->codes[16104] = 0x0006216872d81378UL;
   tf->codes[16105] = 0x0006217b34a7ec92UL;
   tf->codes[16106] = 0x0006219632949560UL;
   tf->codes[16107] = 0x00062196e241a6afUL;
   tf->codes[16108] = 0x000621c3b7c21183UL;
   tf->codes[16109] = 0x000621df9fead165UL;
   tf->codes[16110] = 0x000622394aeba70dUL;
   tf->codes[16111] = 0x0006225448d84fdbUL;
   tf->codes[16112] = 0x000622774852c298UL;
   tf->codes[16113] = 0x00062278a7ace536UL;
   tf->codes[16114] = 0x0006228626a3399dUL;
   tf->codes[16115] = 0x000622957a11bc2cUL;
   tf->codes[16116] = 0x0006229998202406UL;
   tf->codes[16117] = 0x000622fe3df20e9eUL;
   tf->codes[16118] = 0x0006230c32066e8fUL;
   tf->codes[16119] = 0x00062314a8b24408UL;
   tf->codes[16120] = 0x0006231d1f5e1981UL;
   tf->codes[16121] = 0x00062341b8c1b4a1UL;
   tf->codes[16122] = 0x000623485af55bf2UL;
   tf->codes[16123] = 0x0006234dd85de66aUL;
   tf->codes[16124] = 0x00062352a6195f93UL;
   tf->codes[16125] = 0x0006238e94794731UL;
   tf->codes[16126] = 0x0006239202da9dbcUL;
   tf->codes[16127] = 0x0006239a79867335UL;
   tf->codes[16128] = 0x000623a7bdedc1d7UL;
   tf->codes[16129] = 0x000623bb2f6aac40UL;
   tf->codes[16130] = 0x000623c20c2d5956UL;
   tf->codes[16131] = 0x000623d9d647b15eUL;
   tf->codes[16132] = 0x000623dd44a907e9UL;
   tf->codes[16133] = 0x000624413acde132UL;
   tf->codes[16134] = 0x0006245bc39c7e76UL;
   tf->codes[16135] = 0x0006247402d4e208UL;
   tf->codes[16136] = 0x0006247611dc15f5UL;
   tf->codes[16137] = 0x0006247cee9ec30bUL;
   tf->codes[16138] = 0x00062488d3abef0fUL;
   tf->codes[16139] = 0x000624c53729e237UL;
   tf->codes[16140] = 0x000624c8a58b38c2UL;
   tf->codes[16141] = 0x000624cf824de5d8UL;
   tf->codes[16142] = 0x000624e6622c26ccUL;
   tf->codes[16143] = 0x000624e9d08d7d57UL;
   tf->codes[16144] = 0x000624fb330333d3UL;
   tf->codes[16145] = 0x000624fc57ce50acUL;
   tf->codes[16146] = 0x0006250a8671b662UL;
   tf->codes[16147] = 0x0006251fcc66cef3UL;
   tf->codes[16148] = 0x000625363727045dUL;
   tf->codes[16149] = 0x00062539306a4f5eUL;
   tf->codes[16150] = 0x00062549a8a3eec6UL;
   tf->codes[16151] = 0x000625521f4fc43fUL;
   tf->codes[16152] = 0x0006255cdf91d36aUL;
   tf->codes[16153] = 0x000625651baea31eUL;
   tf->codes[16154] = 0x00062569aedb1682UL;
   tf->codes[16155] = 0x000625847238b98bUL;
   tf->codes[16156] = 0x00062588cad6272aUL;
   tf->codes[16157] = 0x00062592db6b2506UL;
   tf->codes[16158] = 0x00062594003641dfUL;
   tf->codes[16159] = 0x000625bf3bcd8450UL;
   tf->codes[16160] = 0x000625e3601313e6UL;
   tf->codes[16161] = 0x000625eb9c2fe39aUL;
   tf->codes[16162] = 0x000625ef7faf45afUL;
   tf->codes[16163] = 0x000625fa3ff154daUL;
   tf->codes[16164] = 0x0006262d42875b75UL;
   tf->codes[16165] = 0x0006265bec7ff471UL;
   tf->codes[16166] = 0x0006267724fba304UL;
   tf->codes[16167] = 0x000626967b85b971UL;
   tf->codes[16168] = 0x000626d9bbc659afUL;
   tf->codes[16169] = 0x000626d9f6555f74UL;
   tf->codes[16170] = 0x000627102cbdb6d5UL;
   tf->codes[16171] = 0x00062716cef15e26UL;
   tf->codes[16172] = 0x00062719188797d8UL;
   tf->codes[16173] = 0x00062735b05d6909UL;
   tf->codes[16174] = 0x000627415adb8f48UL;
   tf->codes[16175] = 0x0006274d3fe8bb4cUL;
   tf->codes[16176] = 0x0006275123681d61UL;
   tf->codes[16177] = 0x0006275715eeb363UL;
   tf->codes[16178] = 0x0006276fca45227fUL;
   tf->codes[16179] = 0x00062779dada205bUL;
   tf->codes[16180] = 0x0006277a8a8731aaUL;
   tf->codes[16181] = 0x00062789ddf5b439UL;
   tf->codes[16182] = 0x000627916a65729eUL;
   tf->codes[16183] = 0x00062798f6d53103UL;
   tf->codes[16184] = 0x000627c46cfb7939UL;
   tf->codes[16185] = 0x000627eadad74281UL;
   tf->codes[16186] = 0x000627f97e98b3c1UL;
   tf->codes[16187] = 0x000627f9f3b6bf4bUL;
   tf->codes[16188] = 0x000627ffabae4f88UL;
   tf->codes[16189] = 0x00062807e7cb1f3cUL;
   tf->codes[16190] = 0x0006280c7af792a0UL;
   tf->codes[16191] = 0x000628189a93c469UL;
   tf->codes[16192] = 0x00062845aaa33502UL;
   tf->codes[16193] = 0x0006284ab2edb3f0UL;
   tf->codes[16194] = 0x0006284cc1f4e7ddUL;
   tf->codes[16195] = 0x0006285697fadff4UL;
   tf->codes[16196] = 0x000628578236f708UL;
   tf->codes[16197] = 0x0006286834ff9c35UL;
   tf->codes[16198] = 0x000628736a5fb6eaUL;
   tf->codes[16199] = 0x0006288a0faef219UL;
   tf->codes[16200] = 0x00062890b1e2996aUL;
   tf->codes[16201] = 0x00062896def83531UL;
   tf->codes[16202] = 0x0006289d469cd6bdUL;
   tf->codes[16203] = 0x000628b376ce0662UL;
   tf->codes[16204] = 0x000628b3ebec11ecUL;
   tf->codes[16205] = 0x000628b844897f8bUL;
   tf->codes[16206] = 0x000628bbb2ead616UL;
   tf->codes[16207] = 0x000628d934fcbe5bUL;
   tf->codes[16208] = 0x000628d96f8bc420UL;
   tf->codes[16209] = 0x000628f1aec427b2UL;
   tf->codes[16210] = 0x000628f348ad5015UL;
   tf->codes[16211] = 0x000628fc34773118UL;
   tf->codes[16212] = 0x000628feb89c708fUL;
   tf->codes[16213] = 0x0006291a2ba724e7UL;
   tf->codes[16214] = 0x0006295d3158bf60UL;
   tf->codes[16215] = 0x00062967075eb777UL;
   tf->codes[16216] = 0x0006296de421648dUL;
   tf->codes[16217] = 0x0006297cc271db92UL;
   tf->codes[16218] = 0x000629b62cac83b9UL;
   tf->codes[16219] = 0x00062a06ebe3785eUL;
   tf->codes[16220] = 0x00062a0e3dc430feUL;
   tf->codes[16221] = 0x00062a10123c5f26UL;
   tf->codes[16222] = 0x00062a2dcedd4d30UL;
   tf->codes[16223] = 0x00062a3ef6c3fde7UL;
   tf->codes[16224] = 0x00062a455e689f73UL;
   tf->codes[16225] = 0x00062a7aaa94dfc0UL;
   tf->codes[16226] = 0x00062a7d2eba1f37UL;
   tf->codes[16227] = 0x00062a94f8d4773fUL;
   tf->codes[16228] = 0x00062abba13f464cUL;
   tf->codes[16229] = 0x00062acdb3620e17UL;
   tf->codes[16230] = 0x00062ace9d9e252bUL;
   tf->codes[16231] = 0x00062acfc2694204UL;
   tf->codes[16232] = 0x00062ad45595b568UL;
   tf->codes[16233] = 0x00062adbe20573cdUL;
   tf->codes[16234] = 0x00062af58097f9fdUL;
   tf->codes[16235] = 0x00062b0792bac1c8UL;
   tf->codes[16236] = 0x00062b0d4ab25205UL;
   tf->codes[16237] = 0x00062b1252fcd0f3UL;
   tf->codes[16238] = 0x00062b1ac9a8a66cUL;
   tf->codes[16239] = 0x00062b3f9d9b4751UL;
   tf->codes[16240] = 0x00062b59019ec7bcUL;
   tf->codes[16241] = 0x00062b5a9b87f01fUL;
   tf->codes[16242] = 0x00062b5bfae212bdUL;
   tf->codes[16243] = 0x00062b6a64147e38UL;
   tf->codes[16244] = 0x00062b6bfdfda69bUL;
   tf->codes[16245] = 0x00062b7ebfcd7fb5UL;
   tf->codes[16246] = 0x00062b8cee70e56bUL;
   tf->codes[16247] = 0x00062b92e0f77b6dUL;
   tf->codes[16248] = 0x00062b93561586f7UL;
   tf->codes[16249] = 0x00062b97aeb2f496UL;
   tf->codes[16250] = 0x00062bf6d71c54b6UL;
   tf->codes[16251] = 0x00062bf920b28e68UL;
   tf->codes[16252] = 0x00062bfdb3df01ccUL;
   tf->codes[16253] = 0x00062c0abdb74aa9UL;
   tf->codes[16254] = 0x00062c40447290bbUL;
   tf->codes[16255] = 0x00062c4f97e1134aUL;
   tf->codes[16256] = 0x00062c563a14ba9bUL;
   tf->codes[16257] = 0x00062c7d922c9af7UL;
   tf->codes[16258] = 0x00062c89021bbb71UL;
   tf->codes[16259] = 0x00062cbbca22bc47UL;
   tf->codes[16260] = 0x00062cc0d26d3b35UL;
   tf->codes[16261] = 0x00062cc6ff82d6fcUL;
   tf->codes[16262] = 0x00062cf40f924795UL;
   tf->codes[16263] = 0x00062cf9526bcc48UL;
   tf->codes[16264] = 0x00062d1450587516UL;
   tf->codes[16265] = 0x00062d1ba2392db6UL;
   tf->codes[16266] = 0x00062d29212f821dUL;
   tf->codes[16267] = 0x00062d3abe343e5eUL;
   tf->codes[16268] = 0x00062d43e48d2526UL;
   tf->codes[16269] = 0x00062d462e235ed8UL;
   tf->codes[16270] = 0x00062d478d7d8176UL;
   tf->codes[16271] = 0x00062d499c84b563UL;
   tf->codes[16272] = 0x00062d57560a0f8fUL;
   tf->codes[16273] = 0x00062d58404626a3UL;
   tf->codes[16274] = 0x00062d5a14be54cbUL;
   tf->codes[16275] = 0x00062d94de531f90UL;
   tf->codes[16276] = 0x00062dc228f195eeUL;
   tf->codes[16277] = 0x00062dd05794fba4UL;
   tf->codes[16278] = 0x00062dd4008557f4UL;
   tf->codes[16279] = 0x00062ddfe59283f8UL;
   tf->codes[16280] = 0x00062e339e0cc39eUL;
   tf->codes[16281] = 0x00062e3746fd1feeUL;
   tf->codes[16282] = 0x00062e4f86358380UL;
   tf->codes[16283] = 0x00062e60e8ab39fcUL;
   tf->codes[16284] = 0x00062e6248055c9aUL;
   tf->codes[16285] = 0x00062e7927e39d8eUL;
   tf->codes[16286] = 0x00062e871bf7fd7fUL;
   tf->codes[16287] = 0x00062e892aff316cUL;
   tf->codes[16288] = 0x00062e93b0b23ad2UL;
   tf->codes[16289] = 0x00062e98b8fcb9c0UL;
   tf->codes[16290] = 0x00062ec135dfb6f5UL;
   tf->codes[16291] = 0x00062ecdca99f448UL;
   tf->codes[16292] = 0x00062ecf64831cabUL;
   tf->codes[16293] = 0x00062ed1738a5098UL;
   tf->codes[16294] = 0x00062ed4a75ca15eUL;
   tf->codes[16295] = 0x00062efa658b5957UL;
   tf->codes[16296] = 0x00062f0fab8071e8UL;
   tf->codes[16297] = 0x00062f105b2d8337UL;
   tf->codes[16298] = 0x00062f190c685e75UL;
   tf->codes[16299] = 0x00062f3ae717b459UL;
   tf->codes[16300] = 0x00062f45323bb7faUL;
   tf->codes[16301] = 0x00062f4cbeab765fUL;
   tf->codes[16302] = 0x00062f4d6e5887aeUL;
   tf->codes[16303] = 0x00062f5ab2bfd650UL;
   tf->codes[16304] = 0x00062f5de6922716UL;
   tf->codes[16305] = 0x00062f5fbb0a553eUL;
   tf->codes[16306] = 0x00062f6c4fc49291UL;
   tf->codes[16307] = 0x00062f703343f4a6UL;
   tf->codes[16308] = 0x00062f9abf2e25c8UL;
   tf->codes[16309] = 0x00062fbf1e02bb23UL;
   tf->codes[16310] = 0x00062fd588c2f08dUL;
   tf->codes[16311] = 0x00062fe96f5de680UL;
   tf->codes[16312] = 0x00062fff2a710a9bUL;
   tf->codes[16313] = 0x00063004e2689ad8UL;
   tf->codes[16314] = 0x0006301e0bdd157eUL;
   tf->codes[16315] = 0x0006302b15b55e5bUL;
   tf->codes[16316] = 0x0006303b18d0f239UL;
   tf->codes[16317] = 0x000630490ce5522aUL;
   tf->codes[16318] = 0x00063051f8af332dUL;
   tf->codes[16319] = 0x000630689dfe6e5cUL;
   tf->codes[16320] = 0x0006307e93a0983cUL;
   tf->codes[16321] = 0x00063086201056a1UL;
   tf->codes[16322] = 0x00063094fe60cda6UL;
   tf->codes[16323] = 0x000630965dbaf044UL;
   tf->codes[16324] = 0x000630d99dfb9082UL;
   tf->codes[16325] = 0x0006311760d3a648UL;
   tf->codes[16326] = 0x0006311e3d96535eUL;
   tf->codes[16327] = 0x0006314c37e1db0bUL;
   tf->codes[16328] = 0x0006315a668540c1UL;
   tf->codes[16329] = 0x0006315c3afd6ee9UL;
   tf->codes[16330] = 0x0006317529e2e3caUL;
   tf->codes[16331] = 0x0006317738ea17b7UL;
   tf->codes[16332] = 0x00063184f26f71e3UL;
   tf->codes[16333] = 0x00063191fc47bac0UL;
   tf->codes[16334] = 0x000631994e287360UL;
   tf->codes[16335] = 0x000631c06bb14df7UL;
   tf->codes[16336] = 0x000631c4c44ebb96UL;
   tf->codes[16337] = 0x000631cd3afa910fUL;
   tf->codes[16338] = 0x000631d27dd415c2UL;
   tf->codes[16339] = 0x000631fc5a113595UL;
   tf->codes[16340] = 0x00063203e680f3faUL;
   tf->codes[16341] = 0x00063210f0593cd7UL;
   tf->codes[16342] = 0x0006324eb331529dUL;
   tf->codes[16343] = 0x0006326d5a0e57bbUL;
   tf->codes[16344] = 0x0006327c72edd485UL;
   tf->codes[16345] = 0x00063281b5c75938UL;
   tf->codes[16346] = 0x00063282da927611UL;
   tf->codes[16347] = 0x0006329e130e24a4UL;
   tf->codes[16348] = 0x0006329f37d9417dUL;
   tf->codes[16349] = 0x000632c187a6a2ebUL;
   tf->codes[16350] = 0x000632d324ab5f2cUL;
   tf->codes[16351] = 0x000632d56e4198deUL;
   tf->codes[16352] = 0x000632f190f95e85UL;
   tf->codes[16353] = 0x0006334633afb53fUL;
   tf->codes[16354] = 0x00063349dca0118fUL;
   tf->codes[16355] = 0x000633528ddaeccdUL;
   tf->codes[16356] = 0x00063356abe954a7UL;
   tf->codes[16357] = 0x000633675eb1f9d4UL;
   tf->codes[16358] = 0x000633680e5f0b23UL;
   tf->codes[16359] = 0x0006336848ee10e8UL;
   tf->codes[16360] = 0x0006337d545423b4UL;
   tf->codes[16361] = 0x000633e5688764d7UL;
   tf->codes[16362] = 0x000633f40c48d617UL;
   tf->codes[16363] = 0x0006343502f33ca3UL;
   tf->codes[16364] = 0x0006343836c58d69UL;
   tf->codes[16365] = 0x0006345d7fd639d8UL;
   tf->codes[16366] = 0x0006346f91f901a3UL;
   tf->codes[16367] = 0x0006346fcc880768UL;
   tf->codes[16368] = 0x00063490826c4073UL;
   tf->codes[16369] = 0x00063490bcfb4638UL;
   tf->codes[16370] = 0x000634b88a31321eUL;
   tf->codes[16371] = 0x000634c46f3e5e22UL;
   tf->codes[16372] = 0x000634e141a33518UL;
   tf->codes[16373] = 0x000634e9f2de1056UL;
   tf->codes[16374] = 0x000634edd65d726bUL;
   tf->codes[16375] = 0x0006351359fd249fUL;
   tf->codes[16376] = 0x000635186247a38dUL;
   tf->codes[16377] = 0x000635302c61fb95UL;
   tf->codes[16378] = 0x0006353694069d21UL;
   tf->codes[16379] = 0x00063545e7751fb0UL;
   tf->codes[16380] = 0x0006354e5e20f529UL;
   tf->codes[16381] = 0x00063555ea90b38eUL;
   tf->codes[16382] = 0x0006357df255a539UL;
   tf->codes[16383] = 0x000635bdfec3f4b1UL;
   tf->codes[16384] = 0x000635c082e93428UL;
   tf->codes[16385] = 0x000635cb089c3d8eUL;
   tf->codes[16386] = 0x000636076c1a30b6UL;
   tf->codes[16387] = 0x00063614b0817f58UL;
   tf->codes[16388] = 0x0006361c3cf13dbdUL;
   tf->codes[16389] = 0x00063628d1ab7b10UL;
   tf->codes[16390] = 0x000636406136cd53UL;
   tf->codes[16391] = 0x0006365d339ba449UL;
   tf->codes[16392] = 0x000636727990bcdaUL;
   tf->codes[16393] = 0x00063674c326f68cUL;
   tf->codes[16394] = 0x00063685eb0da743UL;
   tf->codes[16395] = 0x000636c004f560b9UL;
   tf->codes[16396] = 0x000636c547cee56cUL;
   tf->codes[16397] = 0x000636c9a06c530bUL;
   tf->codes[16398] = 0x000636cea8b6d1f9UL;
   tf->codes[16399] = 0x000636ef240c053fUL;
   tf->codes[16400] = 0x000637063e794bf8UL;
   tf->codes[16401] = 0x0006371b49df5ec4UL;
   tf->codes[16402] = 0x0006372a282fd5c9UL;
   tf->codes[16403] = 0x000637360d3d01cdUL;
   tf->codes[16404] = 0x0006374d9cc85410UL;
   tf->codes[16405] = 0x0006374e4c75655fUL;
   tf->codes[16406] = 0x0006377a7248bee4UL;
   tf->codes[16407] = 0x0006377bd1a2e182UL;
   tf->codes[16408] = 0x0006378064cf54e6UL;
   tf->codes[16409] = 0x000637961fe27901UL;
   tf->codes[16410] = 0x00063799c8d2d551UL;
   tf->codes[16411] = 0x000637bbde1130faUL;
   tf->codes[16412] = 0x000637bd02dc4dd3UL;
   tf->codes[16413] = 0x000637be9cc57636UL;
   tf->codes[16414] = 0x000637ddf34f8ca3UL;
   tf->codes[16415] = 0x000637f164cc770cUL;
   tf->codes[16416] = 0x000637f92bcb3b36UL;
   tf->codes[16417] = 0x0006380794fda6b1UL;
   tf->codes[16418] = 0x0006380f5bfc6adbUL;
   tf->codes[16419] = 0x000638379e50624bUL;
   tf->codes[16420] = 0x00063848168a01b3UL;
   tf->codes[16421] = 0x0006384b0fcd4cb4UL;
   tf->codes[16422] = 0x0006384dce8191f0UL;
   tf->codes[16423] = 0x000638534bea1c68UL;
   tf->codes[16424] = 0x00063862d9e7a4bcUL;
   tf->codes[16425] = 0x0006386e49d6c536UL;
   tf->codes[16426] = 0x0006389da37c6f81UL;
   tf->codes[16427] = 0x0006389dde0b7546UL;
   tf->codes[16428] = 0x000638ccc2931407UL;
   tf->codes[16429] = 0x000639387fb6b17aUL;
   tf->codes[16430] = 0x000639442a34d7b9UL;
   tf->codes[16431] = 0x00063950f97e1ad1UL;
   tf->codes[16432] = 0x00063960fc99aeafUL;
   tf->codes[16433] = 0x0006396380beee26UL;
   tf->codes[16434] = 0x00063976b7acd2caUL;
   tf->codes[16435] = 0x00063978c6b406b7UL;
   tf->codes[16436] = 0x000639805323c51cUL;
   tf->codes[16437] = 0x00063990563f58faUL;
   tf->codes[16438] = 0x0006399b8b9f73afUL;
   tf->codes[16439] = 0x0006399ceaf9964dUL;
   tf->codes[16440] = 0x0006399e84e2beb0UL;
   tf->codes[16441] = 0x000639b739392dccUL;
   tf->codes[16442] = 0x000639c567dc9382UL;
   tf->codes[16443] = 0x000639c89baee448UL;
   tf->codes[16444] = 0x000639d14ce9bf86UL;
   tf->codes[16445] = 0x00063a0db067b2aeUL;
   tf->codes[16446] = 0x00063a0ff9fdec60UL;
   tf->codes[16447] = 0x00063a1ba47c129fUL;
   tf->codes[16448] = 0x00063a1d78f440c7UL;
   tf->codes[16449] = 0x00063a3c94ef516fUL;
   tf->codes[16450] = 0x00063a5f1f4bb8a2UL;
   tf->codes[16451] = 0x00063ad402c83cddUL;
   tf->codes[16452] = 0x00063adcb403181bUL;
   tf->codes[16453] = 0x00063ae68a091032UL;
   tf->codes[16454] = 0x00063b04f6570f8bUL;
   tf->codes[16455] = 0x00063b161e3dc042UL;
   tf->codes[16456] = 0x00063b362474e7feUL;
   tf->codes[16457] = 0x00063b3d3bc69ad9UL;
   tf->codes[16458] = 0x00063b3e2602b1edUL;
   tf->codes[16459] = 0x00063b520c9da7e0UL;
   tf->codes[16460] = 0x00063b54cb51ed1cUL;
   tf->codes[16461] = 0x00063b620fb93bbeUL;
   tf->codes[16462] = 0x00063b6be5bf33d5UL;
   tf->codes[16463] = 0x00063bf17c045d3dUL;
   tf->codes[16464] = 0x00063c06c1f975ceUL;
   tf->codes[16465] = 0x00063c09bb3cc0cfUL;
   tf->codes[16466] = 0x00063c1097ff6de5UL;
   tf->codes[16467] = 0x00063c1cb79b9faeUL;
   tf->codes[16468] = 0x00063c439a957480UL;
   tf->codes[16469] = 0x00063c44bf609159UL;
   tf->codes[16470] = 0x00063c46ce67c546UL;
   tf->codes[16471] = 0x00063c48dd6ef933UL;
   tf->codes[16472] = 0x00063c523e56e5c0UL;
   tf->codes[16473] = 0x00063cc6e7446436UL;
   tf->codes[16474] = 0x00063cc9e087af37UL;
   tf->codes[16475] = 0x00063cd1326867d7UL;
   tf->codes[16476] = 0x00063cd37bfea189UL;
   tf->codes[16477] = 0x00063cdb42fd65b3UL;
   tf->codes[16478] = 0x00063cf5cbcc02f7UL;
   tf->codes[16479] = 0x00063cf84ff1426eUL;
   tf->codes[16480] = 0x00063cfb0ea587aaUL;
   tf->codes[16481] = 0x00063cfbf8e19ebeUL;
   tf->codes[16482] = 0x00063d0e80227213UL;
   tf->codes[16483] = 0x00063d1f32eb1740UL;
   tf->codes[16484] = 0x00063d238b8884dfUL;
   tf->codes[16485] = 0x00063d656c6f027fUL;
   tf->codes[16486] = 0x00063d865ce2414fUL;
   tf->codes[16487] = 0x00063d891b96868bUL;
   tf->codes[16488] = 0x00063d8e23e10579UL;
   tf->codes[16489] = 0x00063d970faae67cUL;
   tf->codes[16490] = 0x00063da712c67a5aUL;
   tf->codes[16491] = 0x00063db2f7d3a65eUL;
   tf->codes[16492] = 0x00063dbea251cc9dUL;
   tf->codes[16493] = 0x00063dc9d7b1e752UL;
   tf->codes[16494] = 0x00063dcfca387d54UL;
   tf->codes[16495] = 0x00063dd004c78319UL;
   tf->codes[16496] = 0x00063e101135d291UL;
   tf->codes[16497] = 0x00063e1a5c59d632UL;
   tf->codes[16498] = 0x00063e3310b0454eUL;
   tf->codes[16499] = 0x00063e5734f5d4e4UL;
   tf->codes[16500] = 0x00063e5a2e391fe5UL;
   tf->codes[16501] = 0x00063e6c7aeaed75UL;
   tf->codes[16502] = 0x00063e79bf523c17UL;
   tf->codes[16503] = 0x00063e961c990783UL;
   tf->codes[16504] = 0x00063e9bd49097c0UL;
   tf->codes[16505] = 0x00063ec033652d1bUL;
   tf->codes[16506] = 0x00063ec27cfb66cdUL;
   tf->codes[16507] = 0x00063ee666b1f09eUL;
   tf->codes[16508] = 0x00063f0b3aa49183UL;
   tf->codes[16509] = 0x00063f1b784f2b26UL;
   tf->codes[16510] = 0x00063f35c68ec2a5UL;
   tf->codes[16511] = 0x00063f381024fc57UL;
   tf->codes[16512] = 0x00063f48c2eda184UL;
   tf->codes[16513] = 0x00063f7ebec6f320UL;
   tf->codes[16514] = 0x00063f9c0649d5a0UL;
   tf->codes[16515] = 0x00063f9eff8d20a1UL;
   tf->codes[16516] = 0x00063fb4baa044bcUL;
   tf->codes[16517] = 0x00063fc114cb7c4aUL;
   tf->codes[16518] = 0x00063fdf0bfb7019UL;
   tf->codes[16519] = 0x00063fedafbce159UL;
   tf->codes[16520] = 0x000640120e9176b4UL;
   tf->codes[16521] = 0x0006401492b6b62bUL;
   tf->codes[16522] = 0x00064028b3e0b1e3UL;
   tf->codes[16523] = 0x0006403498eddde7UL;
   tf->codes[16524] = 0x000640433caf4f27UL;
   tf->codes[16525] = 0x000640521affc62cUL;
   tf->codes[16526] = 0x00064052caacd77bUL;
   tf->codes[16527] = 0x0006408d9441a240UL;
   tf->codes[16528] = 0x000640b6c0d1b0c4UL;
   tf->codes[16529] = 0x000640d408549344UL;
   tf->codes[16530] = 0x000640fde491b317UL;
   tf->codes[16531] = 0x0006410b6388077eUL;
   tf->codes[16532] = 0x0006413b6cdac318UL;
   tf->codes[16533] = 0x0006414ac04945a7UL;
   tf->codes[16534] = 0x0006414d09df7f59UL;
   tf->codes[16535] = 0x00064152c1d70f96UL;
   tf->codes[16536] = 0x0006416a16d35c14UL;
   tf->codes[16537] = 0x000641937df2705dUL;
   tf->codes[16538] = 0x000641979c00d837UL;
   tf->codes[16539] = 0x000641f31b79dc07UL;
   tf->codes[16540] = 0x000641f47ad3fea5UL;
   tf->codes[16541] = 0x000641fa32cb8ee2UL;
   tf->codes[16542] = 0x000641fd669ddfa8UL;
   tf->codes[16543] = 0x00064205a2baaf5cUL;
   tf->codes[16544] = 0x0006421062fcbe87UL;
   tf->codes[16545] = 0x0006427717d5dd0cUL;
   tf->codes[16546] = 0x000642ad4e3e346dUL;
   tf->codes[16547] = 0x000642c0fa4a249bUL;
   tf->codes[16548] = 0x000642eb4ba54ff8UL;
   tf->codes[16549] = 0x000642f4ac8d3c85UL;
   tf->codes[16550] = 0x000642f6f6237637UL;
   tf->codes[16551] = 0x00064302661296b1UL;
   tf->codes[16552] = 0x00064316121e86dfUL;
   tf->codes[16553] = 0x0006431a6abbf47eUL;
   tf->codes[16554] = 0x0006435c863177e3UL;
   tf->codes[16555] = 0x0006435cc0c07da8UL;
   tf->codes[16556] = 0x0006435e5aa9a60bUL;
   tf->codes[16557] = 0x000643727bd3a1c3UL;
   tf->codes[16558] = 0x000643db7a42f9faUL;
   tf->codes[16559] = 0x000643df985161d4UL;
   tf->codes[16560] = 0x000643e4660cdafdUL;
   tf->codes[16561] = 0x000643e6ea321a74UL;
   tf->codes[16562] = 0x0006440bbe24bb59UL;
   tf->codes[16563] = 0x00064433163c9bb5UL;
   tf->codes[16564] = 0x000644359a61db2cUL;
   tf->codes[16565] = 0x0006445f3c0ff53aUL;
   tf->codes[16566] = 0x000644869427d596UL;
   tf->codes[16567] = 0x0006449746f07ac3UL;
   tf->codes[16568] = 0x0006449c89c9ff76UL;
   tf->codes[16569] = 0x000644c506acfcabUL;
   tf->codes[16570] = 0x000644c75043365dUL;
   tf->codes[16571] = 0x000644cccdabc0d5UL;
   tf->codes[16572] = 0x000644d2fac15c9cUL;
   tf->codes[16573] = 0x000644f300f88458UL;
   tf->codes[16574] = 0x000644f66f59dae3UL;
   tf->codes[16575] = 0x000644f9ddbb316eUL;
   tf->codes[16576] = 0x000645151636e001UL;
   tf->codes[16577] = 0x00064518f9b64216UL;
   tf->codes[16578] = 0x00064534e1df01f8UL;
   tf->codes[16579] = 0x0006453606aa1ed1UL;
   tf->codes[16580] = 0x000645422646509aUL;
   tf->codes[16581] = 0x00064542d5f361e9UL;
   tf->codes[16582] = 0x0006455472f81e2aUL;
   tf->codes[16583] = 0x0006455bc4d8d6caUL;
   tf->codes[16584] = 0x0006457c059f044bUL;
   tf->codes[16585] = 0x0006458bce2b9264UL;
   tf->codes[16586] = 0x000645cdaf121004UL;
   tf->codes[16587] = 0x000645d192917219UL;
   tf->codes[16588] = 0x000645d7fa3613a5UL;
   tf->codes[16589] = 0x000645fdf2f3d163UL;
   tf->codes[16590] = 0x000645ffc76bff8bUL;
   tf->codes[16591] = 0x0006463b40addb9fUL;
   tf->codes[16592] = 0x0006465086a2f430UL;
   tf->codes[16593] = 0x00064659e78ae0bdUL;
   tf->codes[16594] = 0x0006467644d1ac29UL;
   tf->codes[16595] = 0x0006467ef60c8767UL;
   tf->codes[16596] = 0x0006467f309b8d2cUL;
   tf->codes[16597] = 0x0006469142be54f7UL;
   tf->codes[16598] = 0x0006469ec1b4a95eUL;
   tf->codes[16599] = 0x000646c14c111091UL;
   tf->codes[16600] = 0x000646c270dc2d6aUL;
   tf->codes[16601] = 0x000646c2ab6b332fUL;
   tf->codes[16602] = 0x000646d2ae86c70dUL;
   tf->codes[16603] = 0x000646f2b4bdeec9UL;
   tf->codes[16604] = 0x000647032cf78e31UL;
   tf->codes[16605] = 0x0006470f4c93bffaUL;
   tf->codes[16606] = 0x000647115b9af3e7UL;
   tf->codes[16607] = 0x000647141a4f3923UL;
   tf->codes[16608] = 0x00064757cfade4ebUL;
   tf->codes[16609] = 0x000647b473f20594UL;
   tf->codes[16610] = 0x000647be49f7fdabUL;
   tf->codes[16611] = 0x0006480f7e4cfddaUL;
   tf->codes[16612] = 0x0006481a04000740UL;
   tf->codes[16613] = 0x00064852be8d9e18UL;
   tf->codes[16614] = 0x0006488f220b9140UL;
   tf->codes[16615] = 0x00064891e0bfd67cUL;
   tf->codes[16616] = 0x00064892906ce7cbUL;
   tf->codes[16617] = 0x000648d2624c317eUL;
   tf->codes[16618] = 0x000648dad8f806f7UL;
   tf->codes[16619] = 0x000648f143b83c61UL;
   tf->codes[16620] = 0x000648f26883593aUL;
   tf->codes[16621] = 0x000648fa6a112329UL;
   tf->codes[16622] = 0x0006490cb6c2f0b9UL;
   tf->codes[16623] = 0x0006490e161d1357UL;
   tf->codes[16624] = 0x0006491701e6f45aUL;
   tf->codes[16625] = 0x0006493c10689b04UL;
   tf->codes[16626] = 0x000649712205d58cUL;
   tf->codes[16627] = 0x0006497ccc83fbcbUL;
   tf->codes[16628] = 0x00064993e6f14284UL;
   tf->codes[16629] = 0x000649e764dc7c65UL;
   tf->codes[16630] = 0x000649fd1fefa080UL;
   tf->codes[16631] = 0x00064a1892fa54d8UL;
   tf->codes[16632] = 0x00064a1bc6cca59eUL;
   tf->codes[16633] = 0x00064a43ce919749UL;
   tf->codes[16634] = 0x00064a5e5760348dUL;
   tf->codes[16635] = 0x00064a6867f53269UL;
   tf->codes[16636] = 0x00064a702ef3f693UL;
   tf->codes[16637] = 0x00064a9a45c01c2bUL;
   tf->codes[16638] = 0x00064ac4971b4788UL;
   tf->codes[16639] = 0x00064acf91ec5c78UL;
   tf->codes[16640] = 0x00064ad8432737b6UL;
   tf->codes[16641] = 0x00064aec29c22da9UL;
   tf->codes[16642] = 0x00064b09e6631bb3UL;
   tf->codes[16643] = 0x00064b1172d2da18UL;
   tf->codes[16644] = 0x00064b18c4b392b8UL;
   tf->codes[16645] = 0x00064b4ec08ce454UL;
   tf->codes[16646] = 0x00064b72e4d273eaUL;
   tf->codes[16647] = 0x00064b91c63e7ecdUL;
   tf->codes[16648] = 0x00064b944a63be44UL;
   tf->codes[16649] = 0x00064bb2b6b1bd9dUL;
   tf->codes[16650] = 0x00064bb4c5b8f18aUL;
   tf->codes[16651] = 0x00064bb6d4c02577UL;
   tf->codes[16652] = 0x00064bc4c8d48568UL;
   tf->codes[16653] = 0x00064bcd7a0f60a6UL;
   tf->codes[16654] = 0x00064be78dbff260UL;
   tf->codes[16655] = 0x00064bec960a714eUL;
   tf->codes[16656] = 0x00064bf8b5a6a317UL;
   tf->codes[16657] = 0x00064c3f9ed79fa5UL;
   tf->codes[16658] = 0x00064c493a4e91f7UL;
   tf->codes[16659] = 0x00064c54aa3db271UL;
   tf->codes[16660] = 0x00064c62d8e11827UL;
   tf->codes[16661] = 0x00064c7107847dddUL;
   tf->codes[16662] = 0x00064ccde657a44bUL;
   tf->codes[16663] = 0x00064cce5b75afd5UL;
   tf->codes[16664] = 0x00064cd39e4f3488UL;
   tf->codes[16665] = 0x00064ce86f26418fUL;
   tf->codes[16666] = 0x00064d08003f5dc1UL;
   tf->codes[16667] = 0x00064d0f8caf1c26UL;
   tf->codes[16668] = 0x00064d1d0ba5708dUL;
   tf->codes[16669] = 0x00064d337665a5f7UL;
   tf->codes[16670] = 0x00064d36e4c6fc82UL;
   tf->codes[16671] = 0x00064d3bb28275abUL;
   tf->codes[16672] = 0x00064d46e7e29060UL;
   tf->codes[16673] = 0x00064d4722719625UL;
   tf->codes[16674] = 0x00064d47978fa1afUL;
   tf->codes[16675] = 0x00064d7014729ee4UL;
   tf->codes[16676] = 0x00064d7b0f43b3d4UL;
   tf->codes[16677] = 0x00064d947347343fUL;
   tf->codes[16678] = 0x00064d96f76c73b6UL;
   tf->codes[16679] = 0x00064d9731fb797bUL;
   tf->codes[16680] = 0x00064dbfe96d7c75UL;
   tf->codes[16681] = 0x00064e1b68e68045UL;
   tf->codes[16682] = 0x00064e44d005948eUL;
   tf->codes[16683] = 0x00064e46a47dc2b6UL;
   tf->codes[16684] = 0x00064e4a87fd24cbUL;
   tf->codes[16685] = 0x00064e4b37aa361aUL;
   tf->codes[16686] = 0x00064e4e6b7c86e0UL;
   tf->codes[16687] = 0x00064e52c419f47fUL;
   tf->codes[16688] = 0x00064e56e2285c59UL;
   tf->codes[16689] = 0x00064e68b9bc1e5fUL;
   tf->codes[16690] = 0x00064e7638b272c6UL;
   tf->codes[16691] = 0x00064e91369f1b94UL;
   tf->codes[16692] = 0x00064e930b1749bcUL;
   tf->codes[16693] = 0x00064ec906f09b58UL;
   tf->codes[16694] = 0x00064ecc0033e659UL;
   tf->codes[16695] = 0x00064edfe6cedc4cUL;
   tf->codes[16696] = 0x00064eea31f2dfedUL;
   tf->codes[16697] = 0x00064ef183d3988dUL;
   tf->codes[16698] = 0x00064efb94689669UL;
   tf->codes[16699] = 0x00064efdddfed01bUL;
   tf->codes[16700] = 0x00064f0f40748697UL;
   tf->codes[16701] = 0x00064f3c15f4f16bUL;
   tf->codes[16702] = 0x00064f441782bb5aUL;
   tf->codes[16703] = 0x00064f5b6c7f07d8UL;
   tf->codes[16704] = 0x00064f90f33a4deaUL;
   tf->codes[16705] = 0x00064f9252947088UL;
   tf->codes[16706] = 0x00064f98ba391214UL;
   tf->codes[16707] = 0x00064fdc6f97bddcUL;
   tf->codes[16708] = 0x00064ff76d8466aaUL;
   tf->codes[16709] = 0x00065007709ffa88UL;
   tf->codes[16710] = 0x00065041ffa5bf88UL;
   tf->codes[16711] = 0x000650423a34c54dUL;
   tf->codes[16712] = 0x00065047f22c558aUL;
   tf->codes[16713] = 0x0006504a3bc28f3cUL;
   tf->codes[16714] = 0x0006504c103abd64UL;
   tf->codes[16715] = 0x00065053621b7604UL;
   tf->codes[16716] = 0x0006505b9e3845b8UL;
   tf->codes[16717] = 0x0006506bdbe2df5bUL;
   tf->codes[16718] = 0x0006507aba335660UL;
   tf->codes[16719] = 0x00065085ef937115UL;
   tf->codes[16720] = 0x000651155bde9294UL;
   tf->codes[16721] = 0x0006511f31e48aabUL;
   tf->codes[16722] = 0x0006514e8b8a34f6UL;
   tf->codes[16723] = 0x000651510faf746dUL;
   tf->codes[16724] = 0x00065167b4feaf9cUL;
   tf->codes[16725] = 0x0006516cf7d8344fUL;
   tf->codes[16726] = 0x0006516da785459eUL;
   tf->codes[16727] = 0x00065172afcfc48cUL;
   tf->codes[16728] = 0x0006518f82349b82UL;
   tf->codes[16729] = 0x000651906c70b296UL;
   tf->codes[16730] = 0x00065194ff9d25faUL;
   tf->codes[16731] = 0x00065195e9d93d0eUL;
   tf->codes[16732] = 0x000651bbe296faccUL;
   tf->codes[16733] = 0x000651bf50f85157UL;
   tf->codes[16734] = 0x000651d287e635fbUL;
   tf->codes[16735] = 0x000651e0b6899bb1UL;
   tf->codes[16736] = 0x000651e8086a5451UL;
   tf->codes[16737] = 0x000651f5fc7eb442UL;
   tf->codes[16738] = 0x000652030656fd1fUL;
   tf->codes[16739] = 0x00065204a0402582UL;
   tf->codes[16740] = 0x0006525091bba0feUL;
   tf->codes[16741] = 0x00065259f2a38d8bUL;
   tf->codes[16742] = 0x00065271822edfceUL;
   tf->codes[16743] = 0x0006528f795ed39dUL;
   tf->codes[16744] = 0x000652977aec9d8cUL;
   tf->codes[16745] = 0x0006529f075c5bf1UL;
   tf->codes[16746] = 0x000652b2edf751e4UL;
   tf->codes[16747] = 0x000652bb2a142198UL;
   tf->codes[16748] = 0x000652d209f2628cUL;
   tf->codes[16749] = 0x000652d418f99679UL;
   tf->codes[16750] = 0x000652f5f3a8ec5dUL;
   tf->codes[16751] = 0x000652fdbaa7b087UL;
   tf->codes[16752] = 0x00065344de67b2daUL;
   tf->codes[16753] = 0x00065356b5fb74e0UL;
   tf->codes[16754] = 0x000653864a3024f0UL;
   tf->codes[16755] = 0x0006539fae33a55bUL;
   tf->codes[16756] = 0x000653bb965c653dUL;
   tf->codes[16757] = 0x000653d868c13c33UL;
   tf->codes[16758] = 0x000653ecc47a3db0UL;
   tf->codes[16759] = 0x000653f9ce52868dUL;
   tf->codes[16760] = 0x0006540af6393744UL;
   tf->codes[16761] = 0x0006540c90225fa7UL;
   tf->codes[16762] = 0x0006541a0f18b40eUL;
   tf->codes[16763] = 0x00065454d8ad7ed3UL;
   tf->codes[16764] = 0x000654567296a736UL;
   tf->codes[16765] = 0x00065459a668f7fcUL;
   tf->codes[16766] = 0x0006545acb3414d5UL;
   tf->codes[16767] = 0x0006545b7ae12624UL;
   tf->codes[16768] = 0x0006545d89e85a11UL;
   tf->codes[16769] = 0x00065461a7f6c1ebUL;
   tf->codes[16770] = 0x000654b894435257UL;
   tf->codes[16771] = 0x000654c4b3df8420UL;
   tf->codes[16772] = 0x000654d4b6fb17feUL;
   tf->codes[16773] = 0x000654ef7a58bb07UL;
   tf->codes[16774] = 0x000654f8db40a794UL;
   tf->codes[16775] = 0x0006550c4cbd91fdUL;
   tf->codes[16776] = 0x0006551ed3fe6552UL;
   tf->codes[16777] = 0x0006554db8860413UL;
   tf->codes[16778] = 0x0006555c96d67b18UL;
   tf->codes[16779] = 0x000655671c89847eUL;
   tf->codes[16780] = 0x0006557008536581UL;
   tf->codes[16781] = 0x00065582ca233e9bUL;
   tf->codes[16782] = 0x0006558304b24460UL;
   tf->codes[16783] = 0x00065588821aced8UL;
   tf->codes[16784] = 0x000655958bf317b5UL;
   tf->codes[16785] = 0x000655996f7279caUL;
   tf->codes[16786] = 0x0006559a943d96a3UL;
   tf->codes[16787] = 0x0006559eb24bfe7dUL;
   tf->codes[16788] = 0x000655bd1e99fdd6UL;
   tf->codes[16789] = 0x000655d34ecb2d7bUL;
   tf->codes[16790] = 0x000655d4e8b455deUL;
   tf->codes[16791] = 0x0006560407cafa64UL;
   tf->codes[16792] = 0x0006560d68b2e6f1UL;
   tf->codes[16793] = 0x0006561111a34341UL;
   tf->codes[16794] = 0x000656189e1301a6UL;
   tf->codes[16795] = 0x0006564c8ae51f55UL;
   tf->codes[16796] = 0x00065650a8f3872fUL;
   tf->codes[16797] = 0x0006565c5371ad6eUL;
   tf->codes[16798] = 0x0006566d063a529bUL;
   tf->codes[16799] = 0x0006567ea33f0edcUL;
   tf->codes[16800] = 0x0006568928f21842UL;
   tf->codes[16801] = 0x0006569757957df8UL;
   tf->codes[16802] = 0x000656c00f0780f2UL;
   tf->codes[16803] = 0x000656fc7285741aUL;
   tf->codes[16804] = 0x000657055e4f551dUL;
   tf->codes[16805] = 0x0006570a6699d40bUL;
   tf->codes[16806] = 0x00065718cfcc3f86UL;
   tf->codes[16807] = 0x0006571b8e8084c2UL;
   tf->codes[16808] = 0x000657439645766dUL;
   tf->codes[16809] = 0x0006574988cc0c6fUL;
   tf->codes[16810] = 0x0006575f7e6e364fUL;
   tf->codes[16811] = 0x00065772403e0f69UL;
   tf->codes[16812] = 0x00065775ae9f65f4UL;
   tf->codes[16813] = 0x000657869bf710e6UL;
   tf->codes[16814] = 0x00065793a5cf59c3UL;
   tf->codes[16815] = 0x000657bfcba2b348UL;
   tf->codes[16816] = 0x000657c8b76c944bUL;
   tf->codes[16817] = 0x000657e3403b318fUL;
   tf->codes[16818] = 0x00065806ef62b59bUL;
   tf->codes[16819] = 0x000658097387f512UL;
   tf->codes[16820] = 0x000658151e061b51UL;
   tf->codes[16821] = 0x000658459c76e275UL;
   tf->codes[16822] = 0x000658609a638b43UL;
   tf->codes[16823] = 0x0006586f78b40248UL;
   tf->codes[16824] = 0x0006588e1f910766UL;
   tf->codes[16825] = 0x0006589118d45267UL;
   tf->codes[16826] = 0x00065892782e7505UL;
   tf->codes[16827] = 0x000658939cf991deUL;
   tf->codes[16828] = 0x000658ca487ff4c9UL;
   tf->codes[16829] = 0x000658e929ebffacUL;
   tf->codes[16830] = 0x000658f6e37159d8UL;
   tf->codes[16831] = 0x0006590845e71054UL;
   tf->codes[16832] = 0x0006591340b82544UL;
   tf->codes[16833] = 0x0006594593a11a90UL;
   tf->codes[16834] = 0x00065955219ea2e4UL;
   tf->codes[16835] = 0x000659761211e1b4UL;
   tf->codes[16836] = 0x00065979f59143c9UL;
   tf->codes[16837] = 0x0006598cb7611ce3UL;
   tf->codes[16838] = 0x000659952e0cf25cUL;
   tf->codes[16839] = 0x000659c571eeb3bbUL;
   tf->codes[16840] = 0x000659c7bb84ed6dUL;
   tf->codes[16841] = 0x000659d32b740de7UL;
   tf->codes[16842] = 0x000659de264522d7UL;
   tf->codes[16843] = 0x000659e4535abe9eUL;
   tf->codes[16844] = 0x000659faf8a9f9cdUL;
   tf->codes[16845] = 0x00065a08ecbe59beUL;
   tf->codes[16846] = 0x00065a18059dd688UL;
   tf->codes[16847] = 0x00065a2634413c3eUL;
   tf->codes[16848] = 0x00065a496e4ab4c0UL;
   tf->codes[16849] = 0x00065a4bb7e0ee72UL;
   tf->codes[16850] = 0x00065a4bf26ff437UL;
   tf->codes[16851] = 0x00065a58c1b9374fUL;
   tf->codes[16852] = 0x00065a5c6aa9939fUL;
   tf->codes[16853] = 0x00065a5e0492bc02UL;
   tf->codes[16854] = 0x00065a5eb43fcd51UL;
   tf->codes[16855] = 0x00065a70c662951cUL;
   tf->codes[16856] = 0x00065a7852d25381UL;
   tf->codes[16857] = 0x00065a9943459251UL;
   tf->codes[16858] = 0x00065acc0b4c9327UL;
   tf->codes[16859] = 0x00065ad82ae8c4f0UL;
   tf->codes[16860] = 0x00065aec86a1c66dUL;
   tf->codes[16861] = 0x00065aef7fe5116eUL;
   tf->codes[16862] = 0x00065b1c8ff48207UL;
   tf->codes[16863] = 0x00065b50b755a57bUL;
   tf->codes[16864] = 0x00065b58b8e36f6aUL;
   tf->codes[16865] = 0x00065b6befd1540eUL;
   tf->codes[16866] = 0x00065b9ad458f2cfUL;
   tf->codes[16867] = 0x00065bb313915661UL;
   tf->codes[16868] = 0x00065bbbff5b3764UL;
   tf->codes[16869] = 0x00065bc1f1e1cd66UL;
   tf->codes[16870] = 0x00065bd404049531UL;
   tf->codes[16871] = 0x00065bd528cfb20aUL;
   tf->codes[16872] = 0x00065beb938fe774UL;
   tf->codes[16873] = 0x00065bf7edbb1f02UL;
   tf->codes[16874] = 0x00065bf912863bdbUL;
   tf->codes[16875] = 0x00065bffb4b9e32cUL;
   tf->codes[16876] = 0x00065c0a74fbf257UL;
   tf->codes[16877] = 0x00065c52486905f9UL;
   tf->codes[16878] = 0x00065c63704fb6b0UL;
   tf->codes[16879] = 0x00065c9881ecf138UL;
   tf->codes[16880] = 0x00065cb63e8ddf42UL;
   tf->codes[16881] = 0x00065cd3c09fc787UL;
   tf->codes[16882] = 0x00065cfcb2a0d046UL;
   tf->codes[16883] = 0x00065d0d2ada6faeUL;
   tf->codes[16884] = 0x00065d118377dd4dUL;
   tf->codes[16885] = 0x00065d12e2d1ffebUL;
   tf->codes[16886] = 0x00065d1b940cdb29UL;
   tf->codes[16887] = 0x00065d4b62d090feUL;
   tf->codes[16888] = 0x00065d5747ddbd02UL;
   tf->codes[16889] = 0x00065d5d3a645304UL;
   tf->codes[16890] = 0x00065dc0f5fa2688UL;
   tf->codes[16891] = 0x00065dcf5f2c9203UL;
   tf->codes[16892] = 0x00065de1abde5f93UL;
   tf->codes[16893] = 0x00065df6422666d5UL;
   tf->codes[16894] = 0x00065e117aa21568UL;
   tf->codes[16895] = 0x00065e3b56df353bUL;
   tf->codes[16896] = 0x00065e51871064e0UL;
   tf->codes[16897] = 0x00065e64f88d4f49UL;
   tf->codes[16898] = 0x00065e88a7b4d355UL;
   tf->codes[16899] = 0x00065e90e3d1a309UL;
   tf->codes[16900] = 0x00065e9e62c7f770UL;
   tf->codes[16901] = 0x00065ebe68ff1f2cUL;
   tf->codes[16902] = 0x00065ed3aef437bdUL;
   tf->codes[16903] = 0x00065ef42a496b03UL;
   tf->codes[16904] = 0x00065efa1cd00105UL;
   tf->codes[16905] = 0x00065efc66663ab7UL;
   tf->codes[16906] = 0x00065f034328e7cdUL;
   tf->codes[16907] = 0x00065f130bb575e6UL;
   tf->codes[16908] = 0x00065f17d970ef0fUL;
   tf->codes[16909] = 0x00065f18c3ad0623UL;
   tf->codes[16910] = 0x00065f34e664cbcaUL;
   tf->codes[16911] = 0x00065f605c8b1400UL;
   tf->codes[16912] = 0x00065f7b5a77bcceUL;
   tf->codes[16913] = 0x00065fe8b18482a4UL;
   tf->codes[16914] = 0x0006602dc63d510aUL;
   tf->codes[16915] = 0x0006605e7f3d1df3UL;
   tf->codes[16916] = 0x0006607e4ae53feaUL;
   tf->codes[16917] = 0x0006608ec31edf52UL;
   tf->codes[16918] = 0x0006609ae2bb111bUL;
   tf->codes[16919] = 0x000660d39d48a7f3UL;
   tf->codes[16920] = 0x000660ec8c2e1cd4UL;
   tf->codes[16921] = 0x00066101d2233565UL;
   tf->codes[16922] = 0x0006611b70b5bb95UL;
   tf->codes[16923] = 0x00066173bc5c6e9fUL;
   tf->codes[16924] = 0x0006617b0e3d273fUL;
   tf->codes[16925] = 0x0006619d98998e72UL;
   tf->codes[16926] = 0x000661c4f0b16eceUL;
   tf->codes[16927] = 0x000661cf3bd5726fUL;
   tf->codes[16928] = 0x000661d4441ff15dUL;
   tf->codes[16929] = 0x000661dae65398aeUL;
   tf->codes[16930] = 0x000661f18ba2d3ddUL;
   tf->codes[16931] = 0x00066217beef9760UL;
   tf->codes[16932] = 0x0006622e9ecdd854UL;
   tf->codes[16933] = 0x00066257563fdb4eUL;
   tf->codes[16934] = 0x0006625ac4a131d9UL;
   tf->codes[16935] = 0x000662707fb455f4UL;
   tf->codes[16936] = 0x00066276acc9f1bbUL;
   tf->codes[16937] = 0x0006629b0b9e8716UL;
   tf->codes[16938] = 0x000662c9f02625d7UL;
   tf->codes[16939] = 0x000662d7a9ab8003UL;
   tf->codes[16940] = 0x000662e02057557cUL;
   tf->codes[16941] = 0x000662e43e65bd56UL;
   tf->codes[16942] = 0x000662ec3ff38745UL;
   tf->codes[16943] = 0x00066333d8d19522UL;
   tf->codes[16944] = 0x000663486f199c64UL;
   tf->codes[16945] = 0x0006635070a76653UL;
   tf->codes[16946] = 0x0006636332773f6dUL;
   tf->codes[16947] = 0x000663b1e2a70025UL;
   tf->codes[16948] = 0x000663c7289c18b6UL;
   tf->codes[16949] = 0x000663c972325268UL;
   tf->codes[16950] = 0x000663d432746193UL;
   tf->codes[16951] = 0x000663d7db64bde3UL;
   tf->codes[16952] = 0x000663def2b670beUL;
   tf->codes[16953] = 0x000664131a179432UL;
   tf->codes[16954] = 0x0006641d9fca9d98UL;
   tf->codes[16955] = 0x0006643e903ddc68UL;
   tf->codes[16956] = 0x0006644398885b56UL;
   tf->codes[16957] = 0x0006646956b7134fUL;
   tf->codes[16958] = 0x00066475b0e24addUL;
   tf->codes[16959] = 0x00066478aa2595deUL;
   tf->codes[16960] = 0x00066488e7d02f81UL;
   tf->codes[16961] = 0x0006648c5631860cUL;
   tf->codes[16962] = 0x00066494924e55c0UL;
   tf->codes[16963] = 0x000664b9a0cffc6aUL;
   tf->codes[16964] = 0x000664c3ebf4000bUL;
   tf->codes[16965] = 0x000664c4268305d0UL;
   tf->codes[16966] = 0x000664c75a555696UL;
   tf->codes[16967] = 0x000664cd876af25dUL;
   tf->codes[16968] = 0x0006651978e66dd9UL;
   tf->codes[16969] = 0x0006652f33f991f4UL;
   tf->codes[16970] = 0x000665335207f9ceUL;
   tf->codes[16971] = 0x00066537aaa5676dUL;
   tf->codes[16972] = 0x0006654822df06d5UL;
   tf->codes[16973] = 0x0006654947aa23aeUL;
   tf->codes[16974] = 0x00066549bcc82f38UL;
   tf->codes[16975] = 0x000665591036b1c7UL;
   tf->codes[16976] = 0x0006655da363252bUL;
   tf->codes[16977] = 0x000665714f6f1559UL;
   tf->codes[16978] = 0x0006658d3797d53bUL;
   tf->codes[16979] = 0x00066597482cd317UL;
   tf->codes[16980] = 0x000665a835847e09UL;
   tf->codes[16981] = 0x000665c1d4170439UL;
   tf->codes[16982] = 0x000665c6dc618327UL;
   tf->codes[16983] = 0x000665d8044833deUL;
   tf->codes[16984] = 0x000665e87c81d346UL;
   tf->codes[16985] = 0x000665eb00a712bdUL;
   tf->codes[16986] = 0x0006664177d5979fUL;
   tf->codes[16987] = 0x00066643fbfad716UL;
   tf->codes[16988] = 0x0006665732e8bbbaUL;
   tf->codes[16989] = 0x0006669ae8476782UL;
   tf->codes[16990] = 0x000666bc4dd8b1dcUL;
   tf->codes[16991] = 0x000666c489f58190UL;
   tf->codes[16992] = 0x000666c65e6dafb8UL;
   tf->codes[16993] = 0x000666ed06d87ec5UL;
   tf->codes[16994] = 0x000666fbaa99f005UL;
   tf->codes[16995] = 0x00066745c79d3d59UL;
   tf->codes[16996] = 0x000667572a12f3d5UL;
   tf->codes[16997] = 0x000667776ad92156UL;
   tf->codes[16998] = 0x0006677904c249b9UL;
   tf->codes[16999] = 0x000667c09da05796UL;
   tf->codes[17000] = 0x000667c6cab5f35dUL;
   tf->codes[17001] = 0x000667ee22cdd3b9UL;
   tf->codes[17002] = 0x000667f0a6f31330UL;
   tf->codes[17003] = 0x0006681af84e3e8dUL;
   tf->codes[17004] = 0x0006681c923766f0UL;
   tf->codes[17005] = 0x00066850f4279029UL;
   tf->codes[17006] = 0x0006685427f9e0efUL;
   tf->codes[17007] = 0x0006685c2987aadeUL;
   tf->codes[17008] = 0x0006686b07d821e3UL;
   tf->codes[17009] = 0x0006687b8011c14bUL;
   tf->codes[17010] = 0x000668884f5b0463UL;
   tf->codes[17011] = 0x000668a4e730d594UL;
   tf->codes[17012] = 0x000668c9809470b4UL;
   tf->codes[17013] = 0x000668d73a19cae0UL;
   tf->codes[17014] = 0x000668efee7039fcUL;
   tf->codes[17015] = 0x000668f705c1ecd7UL;
   tf->codes[17016] = 0x000668fb23d054b1UL;
   tf->codes[17017] = 0x0006690a3cafd17bUL;
   tf->codes[17018] = 0x0006694af8cb3242UL;
   tf->codes[17019] = 0x0006695125e0ce09UL;
   tf->codes[17020] = 0x0006695752f669d0UL;
   tf->codes[17021] = 0x0006695afbe6c620UL;
   tf->codes[17022] = 0x0006698c2a049e93UL;
   tf->codes[17023] = 0x000669921c8b3495UL;
   tf->codes[17024] = 0x0006699f26637d72UL;
   tf->codes[17025] = 0x000669ce0aeb1c33UL;
   tf->codes[17026] = 0x000669d7e0f1144aUL;
   tf->codes[17027] = 0x000669dcaeac8d73UL;
   tf->codes[17028] = 0x000669fae06b8707UL;
   tf->codes[17029] = 0x00066a06505aa781UL;
   tf->codes[17030] = 0x00066a070007b8d0UL;
   tf->codes[17031] = 0x00066a19122a809bUL;
   tf->codes[17032] = 0x00066a1c808bd726UL;
   tf->codes[17033] = 0x00066a29ff822b8dUL;
   tf->codes[17034] = 0x00066a2a74a03717UL;
   tf->codes[17035] = 0x00066a465cc8f6f9UL;
   tf->codes[17036] = 0x00066a54164e5125UL;
   tf->codes[17037] = 0x00066a7b6e663181UL;
   tf->codes[17038] = 0x00066a7ba8f53746UL;
   tf->codes[17039] = 0x00066abeaea6d1bfUL;
   tf->codes[17040] = 0x00066ac6b0349baeUL;
   tf->codes[17041] = 0x00066ac84a1dc411UL;
   tf->codes[17042] = 0x00066adeef6cff40UL;
   tf->codes[17043] = 0x00066b17e4899bddUL;
   tf->codes[17044] = 0x00066b1c77b60f41UL;
   tf->codes[17045] = 0x00066b577bd9dfcbUL;
   tf->codes[17046] = 0x00066b723f3782d4UL;
   tf->codes[17047] = 0x00066b77f72f1311UL;
   tf->codes[17048] = 0x00066b7c8a5b8675UL;
   tf->codes[17049] = 0x00066b869af08451UL;
   tf->codes[17050] = 0x00066bcb3a8b472dUL;
   tf->codes[17051] = 0x00066bd510913f44UL;
   tf->codes[17052] = 0x00066bd6aa7a67a7UL;
   tf->codes[17053] = 0x00066c0937f262b8UL;
   tf->codes[17054] = 0x00066c09e79f7407UL;
   tf->codes[17055] = 0x00066c35d2e3c7c7UL;
   tf->codes[17056] = 0x00066c4aa3bad4ceUL;
   tf->codes[17057] = 0x00066c5613a9f548UL;
   tf->codes[17058] = 0x00066c564e38fb0dUL;
   tf->codes[17059] = 0x00066c7b5cbaa1b7UL;
   tf->codes[17060] = 0x00066c8532c099ceUL;
   tf->codes[17061] = 0x00066c8b5fd63595UL;
   tf->codes[17062] = 0x00066cb15893f353UL;
   tf->codes[17063] = 0x00066cc5eedbfa95UL;
   tf->codes[17064] = 0x00066cd1d3e92699UL;
   tf->codes[17065] = 0x00066d13b4cfa439UL;
   tf->codes[17066] = 0x00066d17984f064eUL;
   tf->codes[17067] = 0x00066d1847fc179dUL;
   tf->codes[17068] = 0x00066d1e3a82ad9fUL;
   tf->codes[17069] = 0x00066d3ad2587ed0UL;
   tf->codes[17070] = 0x00066d49b0a8f5d5UL;
   tf->codes[17071] = 0x00066d567ff238edUL;
   tf->codes[17072] = 0x00066d6105a54253UL;
   tf->codes[17073] = 0x00066d9c7ee71e67UL;
   tf->codes[17074] = 0x00066dbaeb351dc0UL;
   tf->codes[17075] = 0x00066dc70ad14f89UL;
   tf->codes[17076] = 0x00066dd698ced7ddUL;
   tf->codes[17077] = 0x00066dd957831d19UL;
   tf->codes[17078] = 0x00066dfa47f65be9UL;
   tf->codes[17079] = 0x00066dfb6cc178c2UL;
   tf->codes[17080] = 0x00066dfdf0e6b839UL;
   tf->codes[17081] = 0x00066e0667928db2UL;
   tf->codes[17082] = 0x00066e16301f1bcbUL;
   tf->codes[17083] = 0x00066e2d0ffd5cbfUL;
   tf->codes[17084] = 0x00066e437abd9229UL;
   tf->codes[17085] = 0x00066e4c6687732cUL;
   tf->codes[17086] = 0x00066e5b0a48e46cUL;
   tf->codes[17087] = 0x00066e5b7f66eff6UL;
   tf->codes[17088] = 0x00066e5bb9f5f5bbUL;
   tf->codes[17089] = 0x00066e5f62e6520bUL;
   tf->codes[17090] = 0x00066e6c6cbe9ae8UL;
   tf->codes[17091] = 0x00066e77678fafd8UL;
   tf->codes[17092] = 0x00066e7b859e17b2UL;
   tf->codes[17093] = 0x00066e7c6fda2ec6UL;
   tf->codes[17094] = 0x00066e8a9e7d947cUL;
   tf->codes[17095] = 0x00066e8d22a2d3f3UL;
   tf->codes[17096] = 0x00066ee742c1b525UL;
   tf->codes[17097] = 0x00066ef39cececb3UL;
   tf->codes[17098] = 0x00066ef6d0bf3d79UL;
   tf->codes[17099] = 0x00066ef91a55772bUL;
   tf->codes[17100] = 0x00066f378cda9e40UL;
   tf->codes[17101] = 0x00066f3a861de941UL;
   tf->codes[17102] = 0x00066f471ad82694UL;
   tf->codes[17103] = 0x00066f79e2df276aUL;
   tf->codes[17104] = 0x00066f91726a79adUL;
   tf->codes[17105] = 0x00066fc2a0885220UL;
   tf->codes[17106] = 0x00066fc524ad9197UL;
   tf->codes[17107] = 0x00066fcf6fd19538UL;
   tf->codes[17108] = 0x00066ff94c0eb50bUL;
   tf->codes[17109] = 0x0006700e5774c7d7UL;
   tf->codes[17110] = 0x000670365f39b982UL;
   tf->codes[17111] = 0x00067055f052d5b4UL;
   tf->codes[17112] = 0x0006707f9200efc2UL;
   tf->codes[17113] = 0x000670c60613e0c6UL;
   tf->codes[17114] = 0x000670cce2d68ddcUL;
   tf->codes[17115] = 0x000670d643be7a69UL;
   tf->codes[17116] = 0x000670dd959f3309UL;
   tf->codes[17117] = 0x000670ecae7eafd3UL;
   tf->codes[17118] = 0x0006713fb74bde2aUL;
   tf->codes[17119] = 0x0006714200e217dcUL;
   tf->codes[17120] = 0x0006719dbaea2171UL;
   tf->codes[17121] = 0x000671b5fa228503UL;
   tf->codes[17122] = 0x000671cb40179d94UL;
   tf->codes[17123] = 0x000671fef25ab57eUL;
   tf->codes[17124] = 0x000671ff2ce9bb43UL;
   tf->codes[17125] = 0x00067219f0475e4cUL;
   tf->codes[17126] = 0x0006721d5ea8b4d7UL;
   tf->codes[17127] = 0x00067238d1b3692fUL;
   tf->codes[17128] = 0x00067239f67e8608UL;
   tf->codes[17129] = 0x0006725444be1d87UL;
   tf->codes[17130] = 0x00067265e1c2d9c8UL;
   tf->codes[17131] = 0x000672870cc51e5dUL;
   tf->codes[17132] = 0x00067292b743449cUL;
   tf->codes[17133] = 0x000672aa46ce96dfUL;
   tf->codes[17134] = 0x000672d756de0778UL;
   tf->codes[17135] = 0x000672dd0ed597b5UL;
   tf->codes[17136] = 0x000672f463d1e433UL;
   tf->codes[17137] = 0x000672f8bc6f51d2UL;
   tf->codes[17138] = 0x0006731937c48518UL;
   tf->codes[17139] = 0x00067344e879d313UL;
   tf->codes[17140] = 0x000673468262fb76UL;
   tf->codes[17141] = 0x00067368d2305ce4UL;
   tf->codes[17142] = 0x0006736981dd6e33UL;
   tf->codes[17143] = 0x00067372a83654fbUL;
   tf->codes[17144] = 0x000673b413fec711UL;
   tf->codes[17145] = 0x000673c0a8b90464UL;
   tf->codes[17146] = 0x000673c2f24f3e16UL;
   tf->codes[17147] = 0x000673ecce8c5de9UL;
   tf->codes[17148] = 0x000673fea6201fefUL;
   tf->codes[17149] = 0x0006745fa301ae37UL;
   tf->codes[17150] = 0x0006747264d18751UL;
   tf->codes[17151] = 0x00067474e8f6c6c8UL;
   tf->codes[17152] = 0x000674755e14d252UL;
   tf->codes[17153] = 0x0006749529bcf449UL;
   tf->codes[17154] = 0x000674bfb5a7256bUL;
   tf->codes[17155] = 0x000674c1ff3d5f1dUL;
   tf->codes[17156] = 0x000674c866e200a9UL;
   tf->codes[17157] = 0x000674cb9ab4516fUL;
   tf->codes[17158] = 0x000674d70aa371e9UL;
   tf->codes[17159] = 0x000674f6d64b93e0UL;
   tf->codes[17160] = 0x000675015bfe9d46UL;
   tf->codes[17161] = 0x0006753ee447ad47UL;
   tf->codes[17162] = 0x000675500c2e5dfeUL;
   tf->codes[17163] = 0x0006755eafefcf3eUL;
   tf->codes[17164] = 0x000675658cb27c54UL;
   tf->codes[17165] = 0x0006756e035e51cdUL;
   tf->codes[17166] = 0x0006756e3ded5792UL;
   tf->codes[17167] = 0x00067570c2129709UL;
   tf->codes[17168] = 0x00067578fe2f66bdUL;
   tf->codes[17169] = 0x000675f18a9c4748UL;
   tf->codes[17170] = 0x0006760cfda6fba0UL;
   tf->codes[17171] = 0x00067652fc9be11aUL;
   tf->codes[17172] = 0x00067663af648647UL;
   tf->codes[17173] = 0x000676712e5adaaeUL;
   tf->codes[17174] = 0x00067687d3aa15ddUL;
   tf->codes[17175] = 0x000676cfe1a62f44UL;
   tf->codes[17176] = 0x000676d683d9d695UL;
   tf->codes[17177] = 0x000676f3563ead8bUL;
   tf->codes[17178] = 0x000676fc42088e8eUL;
   tf->codes[17179] = 0x0006774ed5b7b15bUL;
   tf->codes[17180] = 0x000677574c6386d4UL;
   tf->codes[17181] = 0x00067762bc52a74eUL;
   tf->codes[17182] = 0x0006778128a0a6a7UL;
   tf->codes[17183] = 0x0006778c5e00c15cUL;
   tf->codes[17184] = 0x0006778d0dadd2abUL;
   tf->codes[17185] = 0x000677925087575eUL;
   tf->codes[17186] = 0x0006779c268d4f75UL;
   tf->codes[17187] = 0x000677b8f8f2266bUL;
   tf->codes[17188] = 0x000677c79cb397abUL;
   tf->codes[17189] = 0x000677cca4fe1699UL;
   tf->codes[17190] = 0x000677d0887d78aeUL;
   tf->codes[17191] = 0x000677e30fbe4c03UL;
   tf->codes[17192] = 0x000677fa64ba9881UL;
   tf->codes[17193] = 0x0006781b552dd751UL;
   tf->codes[17194] = 0x0006782b1dba656aUL;
   tf->codes[17195] = 0x00067849ff26704dUL;
   tf->codes[17196] = 0x0006785bd6ba3253UL;
   tf->codes[17197] = 0x000678636329f0b8UL;
   tf->codes[17198] = 0x0006786de8dcfa1eUL;
   tf->codes[17199] = 0x00067878e3ae0f0eUL;
   tf->codes[17200] = 0x0006787ffaffc1e9UL;
   tf->codes[17201] = 0x0006788871ab9762UL;
   tf->codes[17202] = 0x000678a6a36a90f6UL;
   tf->codes[17203] = 0x000678be32f5e339UL;
   tf->codes[17204] = 0x000678c28b9350d8UL;
   tf->codes[17205] = 0x000678cb775d31dbUL;
   tf->codes[17206] = 0x0006790ce325a3f1UL;
   tf->codes[17207] = 0x00067911eb7022dfUL;
   tf->codes[17208] = 0x0006791d20d03d94UL;
   tf->codes[17209] = 0x0006791d5b5f4359UL;
   tf->codes[17210] = 0x0006795c7d917bbdUL;
   tf->codes[17211] = 0x0006798868d5cf7dUL;
   tf->codes[17212] = 0x0006798a02bef7e0UL;
   tf->codes[17213] = 0x000679aa7e142b26UL;
   tf->codes[17214] = 0x000679ad3cc87062UL;
   tf->codes[17215] = 0x000679d210bb1147UL;
   tf->codes[17216] = 0x00067a075ce75194UL;
   tf->codes[17217] = 0x00067a142c3094acUL;
   tf->codes[17218] = 0x00067a1ace643bfdUL;
   tf->codes[17219] = 0x00067a3e42fcba44UL;
   tf->codes[17220] = 0x00067a408c92f3f6UL;
   tf->codes[17221] = 0x00067a5597f906c2UL;
   tf->codes[17222] = 0x00067a5ebe51ed8aUL;
   tf->codes[17223] = 0x00067a6f368b8cf2UL;
   tf->codes[17224] = 0x00067a7822556df5UL;
   tf->codes[17225] = 0x00067a9ecac03d02UL;
   tf->codes[17226] = 0x00067ae8ad348491UL;
   tf->codes[17227] = 0x00067b0803be9afeUL;
   tf->codes[17228] = 0x00067b112a1781c6UL;
   tf->codes[17229] = 0x00067b14235accc7UL;
   tf->codes[17230] = 0x00067b328fa8cc20UL;
   tf->codes[17231] = 0x00067b38bcbe67e7UL;
   tf->codes[17232] = 0x00067b434271714dUL;
   tf->codes[17233] = 0x00067b4a1f341e63UL;
   tf->codes[17234] = 0x00067b5295dff3dcUL;
   tf->codes[17235] = 0x00067b52d06ef9a1UL;
   tf->codes[17236] = 0x00067b5a224fb241UL;
   tf->codes[17237] = 0x00067b74360043fbUL;
   tf->codes[17238] = 0x00067b7b87e0fc9bUL;
   tf->codes[17239] = 0x00067b801b0d6fffUL;
   tf->codes[17240] = 0x00067b9476c6717cUL;
   tf->codes[17241] = 0x00067b994481eaa5UL;
   tf->codes[17242] = 0x00067b9fe6b591f6UL;
   tf->codes[17243] = 0x00067bcb5cdbda2cUL;
   tf->codes[17244] = 0x00067bd950f03a1dUL;
   tf->codes[17245] = 0x00067bfd3aa6c3eeUL;
   tf->codes[17246] = 0x00067bffbecc0365UL;
   tf->codes[17247] = 0x00067c141a8504e2UL;
   tf->codes[17248] = 0x00067c153f5021bbUL;
   tf->codes[17249] = 0x00067c169eaa4459UL;
   tf->codes[17250] = 0x00067c1f8a74255cUL;
   tf->codes[17251] = 0x00067c4a50ed5c43UL;
   tf->codes[17252] = 0x00067c758c849eb4UL;
   tf->codes[17253] = 0x00067c77266dc717UL;
   tf->codes[17254] = 0x00067c7e0330742dUL;
   tf->codes[17255] = 0x00067c9a60773f99UL;
   tf->codes[17256] = 0x00067c9bbfd16237UL;
   tf->codes[17257] = 0x00067ccaa45900f8UL;
   tf->codes[17258] = 0x00067cdfafbf13c4UL;
   tf->codes[17259] = 0x00067d09516d2dd2UL;
   tf->codes[17260] = 0x00067d27489d21a1UL;
   tf->codes[17261] = 0x00067d3193c12542UL;
   tf->codes[17262] = 0x00067d4edb4407c2UL;
   tf->codes[17263] = 0x00067d5667b3c627UL;
   tf->codes[17264] = 0x00067d5c94c961eeUL;
   tf->codes[17265] = 0x00067d6fcbb74692UL;
   tf->codes[17266] = 0x00067d7040d5521cUL;
   tf->codes[17267] = 0x00067d9290a2b38aUL;
   tf->codes[17268] = 0x00067d9a57a177b4UL;
   tf->codes[17269] = 0x00067db9ae2b8e21UL;
   tf->codes[17270] = 0x00067dcbc04e55ecUL;
   tf->codes[17271] = 0x00067dd646015f52UL;
   tf->codes[17272] = 0x00067dfdd8a84573UL;
   tf->codes[17273] = 0x00067e498f94bb2aUL;
   tf->codes[17274] = 0x00067e52f07ca7b7UL;
   tf->codes[17275] = 0x00067e5af20a71a6UL;
   tf->codes[17276] = 0x00067e6f885278e8UL;
   tf->codes[17277] = 0x00067e79d3767c89UL;
   tf->codes[17278] = 0x00067efce596667aUL;
   tf->codes[17279] = 0x00067f16beb7f26fUL;
   tf->codes[17280] = 0x00067f54f6ae13bfUL;
   tf->codes[17281] = 0x00067f7cc3e3ffa5UL;
   tf->codes[17282] = 0x00067f83db35b280UL;
   tf->codes[17283] = 0x00067f9deee6443aUL;
   tf->codes[17284] = 0x00068055d81462eeUL;
   tf->codes[17285] = 0x00068074f40f7396UL;
   tf->codes[17286] = 0x000680cf4ebd5a8dUL;
   tf->codes[17287] = 0x000680d1d2e29a04UL;
   tf->codes[17288] = 0x000680dbe37797e0UL;
   tf->codes[17289] = 0x000680e2108d33a7UL;
   tf->codes[17290] = 0x000680e9d78bf7d1UL;
   tf->codes[17291] = 0x000680f004a19398UL;
   tf->codes[17292] = 0x000680f3ad91efe8UL;
   tf->codes[17293] = 0x00068144e1e6f017UL;
   tf->codes[17294] = 0x0006814fa228ff42UL;
   tf->codes[17295] = 0x0006816263f8d85cUL;
   tf->codes[17296] = 0x00068169b5d990fcUL;
   tf->codes[17297] = 0x00068177e47cf6b2UL;
   tf->codes[17298] = 0x0006819e8ce7c5bfUL;
   tf->codes[17299] = 0x000681c5e4ffa61bUL;
   tf->codes[17300] = 0x000681d11a5fc0d0UL;
   tf->codes[17301] = 0x000681dd39fbf299UL;
   tf->codes[17302] = 0x000681de5ec70f72UL;
   tf->codes[17303] = 0x000681e2b7647d11UL;
   tf->codes[17304] = 0x000681f2ba8010efUL;
   tf->codes[17305] = 0x000682228943c6c4UL;
   tf->codes[17306] = 0x00068261ab75ff28UL;
   tf->codes[17307] = 0x000682759210f51bUL;
   tf->codes[17308] = 0x0006827816363492UL;
   tf->codes[17309] = 0x000682cfecbedc12UL;
   tf->codes[17310] = 0x000682d5df457214UL;
   tf->codes[17311] = 0x00068301556bba4aUL;
   tf->codes[17312] = 0x0006830a06a69588UL;
   tf->codes[17313] = 0x0006831c18c95d53UL;
   tf->codes[17314] = 0x00068343365237eaUL;
   tf->codes[17315] = 0x000683592bf461caUL;
   tf->codes[17316] = 0x00068360f2f325f4UL;
   tf->codes[17317] = 0x00068371309dbf97UL;
   tf->codes[17318] = 0x000683749eff1622UL;
   tf->codes[17319] = 0x0006837847ef7272UL;
   tf->codes[17320] = 0x0006838eb2afa7dcUL;
   tf->codes[17321] = 0x0006839136d4e753UL;
   tf->codes[17322] = 0x000683be46e457ecUL;
   tf->codes[17323] = 0x000683d38cd9707dUL;
   tf->codes[17324] = 0x000683d43c8681ccUL;
   tf->codes[17325] = 0x000683fec870b2eeUL;
   tf->codes[17326] = 0x000684009ce8e116UL;
   tf->codes[17327] = 0x00068412e99aaea6UL;
   tf->codes[17328] = 0x0006843e5fc0f6dcUL;
   tf->codes[17329] = 0x00068442434058f1UL;
   tf->codes[17330] = 0x0006844a0a3f1d1bUL;
   tf->codes[17331] = 0x0006844af47b342fUL;
   tf->codes[17332] = 0x0006844ed7fa9644UL;
   tf->codes[17333] = 0x000684557a2e3d95UL;
   tf->codes[17334] = 0x0006845ccc0ef635UL;
   tf->codes[17335] = 0x00068464587eb49aUL;
   tf->codes[17336] = 0x000684837479c542UL;
   tf->codes[17337] = 0x00068484d3d3e7e0UL;
   tf->codes[17338] = 0x00068493b2245ee5UL;
   tf->codes[17339] = 0x000684f17b339c67UL;
   tf->codes[17340] = 0x00068500cea21ef6UL;
   tf->codes[17341] = 0x00068506fbb7babdUL;
   tf->codes[17342] = 0x00068539fe4dc158UL;
   tf->codes[17343] = 0x0006854b60c377d4UL;
   tf->codes[17344] = 0x0006858455e01471UL;
   tf->codes[17345] = 0x000685d42adaf202UL;
   tf->codes[17346] = 0x000685d58a3514a0UL;
   tf->codes[17347] = 0x000685deeb1d012dUL;
   tf->codes[17348] = 0x0006860a26b4439eUL;
   tf->codes[17349] = 0x0006861cadf516f3UL;
   tf->codes[17350] = 0x000686368716a2e8UL;
   tf->codes[17351] = 0x000686398059ede9UL;
   tf->codes[17352] = 0x0006863a6a9604fdUL;
   tf->codes[17353] = 0x0006863e4e156712UL;
   tf->codes[17354] = 0x0006866c4860eebfUL;
   tf->codes[17355] = 0x000686795239379cUL;
   tf->codes[17356] = 0x0006869bdc959ecfUL;
   tf->codes[17357] = 0x000686c961c31af2UL;
   tf->codes[17358] = 0x000686d0b3a3d392UL;
   tf->codes[17359] = 0x000686ed4b79a4c3UL;
   tf->codes[17360] = 0x000686f6e6f09715UL;
   tf->codes[17361] = 0x00068715533e966eUL;
   tf->codes[17362] = 0x0006874d23901632UL;
   tf->codes[17363] = 0x0006874e485b330bUL;
   tf->codes[17364] = 0x000687560f59f735UL;
   tf->codes[17365] = 0x0006875dd658bb5fUL;
   tf->codes[17366] = 0x00068765d7e6854eUL;
   tf->codes[17367] = 0x0006876e14035502UL;
   tf->codes[17368] = 0x00068771bcf3b152UL;
   tf->codes[17369] = 0x0006878394877358UL;
   tf->codes[17370] = 0x00068797f04074d5UL;
   tf->codes[17371] = 0x0006879aaef4ba11UL;
   tf->codes[17372] = 0x000687da4644fdffUL;
   tf->codes[17373] = 0x000687ec5867c5caUL;
   tf->codes[17374] = 0x000687fdbadd7c46UL;
   tf->codes[17375] = 0x00068800b420c747UL;
   tf->codes[17376] = 0x00068807cb727a22UL;
   tf->codes[17377] = 0x0006881968773663UL;
   tf->codes[17378] = 0x0006881f206ec6a0UL;
   tf->codes[17379] = 0x000688379a362ff7UL;
   tf->codes[17380] = 0x000688634aeb7df2UL;
   tf->codes[17381] = 0x0006888bc7ce7b27UL;
   tf->codes[17382] = 0x000688910aa7ffdaUL;
   tf->codes[17383] = 0x00068899f671e0ddUL;
   tf->codes[17384] = 0x000688ce1dd30451UL;
   tf->codes[17385] = 0x000688d2b0ff77b5UL;
   tf->codes[17386] = 0x000688d82e68022dUL;
   tf->codes[17387] = 0x000688de960ca3b9UL;
   tf->codes[17388] = 0x000688e6d229736dUL;
   tf->codes[17389] = 0x000688f66026fbc1UL;
   tf->codes[17390] = 0x0006891c58e4b97fUL;
   tf->codes[17391] = 0x0006894c62377519UL;
   tf->codes[17392] = 0x0006896600c9fb49UL;
   tf->codes[17393] = 0x000689680fd12f36UL;
   tf->codes[17394] = 0x0006898f67e90f92UL;
   tf->codes[17395] = 0x000689960a1cb6e3UL;
   tf->codes[17396] = 0x0006899853b2f095UL;
   tf->codes[17397] = 0x0006899d968c7548UL;
   tf->codes[17398] = 0x000689c9bc5fcecdUL;
   tf->codes[17399] = 0x000689d6c63817aaUL;
   tf->codes[17400] = 0x000689d984ec5ce6UL;
   tf->codes[17401] = 0x00068a0f80c5ae82UL;
   tf->codes[17402] = 0x00068a1413f221e6UL;
   tf->codes[17403] = 0x00068a186c8f8f85UL;
   tf->codes[17404] = 0x00068a18a71e954aUL;
   tf->codes[17405] = 0x00068a4b6f259620UL;
   tf->codes[17406] = 0x00068a51d6ca37acUL;
   tf->codes[17407] = 0x00068a5cd19b4c9cUL;
   tf->codes[17408] = 0x00068a5f904f91d8UL;
   tf->codes[17409] = 0x00068a8304e8101fUL;
   tf->codes[17410] = 0x00068a93f23fbb11UL;
   tf->codes[17411] = 0x00068ab38358d743UL;
   tf->codes[17412] = 0x00068ad8574b7828UL;
   tf->codes[17413] = 0x00068adcafe8e5c7UL;
   tf->codes[17414] = 0x00068ae64b5fd819UL;
   tf->codes[17415] = 0x00068ae8cf851790UL;
   tf->codes[17416] = 0x00068b0dde06be3aUL;
   tf->codes[17417] = 0x00068b189e48cd65UL;
   tf->codes[17418] = 0x00068b18d8d7d32aUL;
   tf->codes[17419] = 0x00068b1e1bb157ddUL;
   tf->codes[17420] = 0x00068b3ed19590e8UL;
   tf->codes[17421] = 0x00068b46d3235ad7UL;
   tf->codes[17422] = 0x00068b4782d06c26UL;
   tf->codes[17423] = 0x00068b5d3de39041UL;
   tf->codes[17424] = 0x00068b8ea6906e79UL;
   tf->codes[17425] = 0x00068b90b597a266UL;
   tf->codes[17426] = 0x00068b9f93e8196bUL;
   tf->codes[17427] = 0x00068bc58ca5d729UL;
   tf->codes[17428] = 0x00068bd97340cd1cUL;
   tf->codes[17429] = 0x00068c3567d7dc76UL;
   tf->codes[17430] = 0x00068c4fb61773f5UL;
   tf->codes[17431] = 0x00068c5cbfefbcd2UL;
   tf->codes[17432] = 0x00068c5ecef6f0bfUL;
   tf->codes[17433] = 0x00068c682fdedd4cUL;
   tf->codes[17434] = 0x00068c724073db28UL;
   tf->codes[17435] = 0x00068c82b8ad7a90UL;
   tf->codes[17436] = 0x00068c9edb654037UL;
   tf->codes[17437] = 0x00068cc758483d6cUL;
   tf->codes[17438] = 0x00068cd462208649UL;
   tf->codes[17439] = 0x00068d04a60247a8UL;
   tf->codes[17440] = 0x00068d0b82c4f4beUL;
   tf->codes[17441] = 0x00068d3d9b1ee445UL;
   tf->codes[17442] = 0x00068d56c4935eebUL;
   tf->codes[17443] = 0x00068d609a995702UL;
   tf->codes[17444] = 0x00068d62e42f90b4UL;
   tf->codes[17445] = 0x00068d694bd43240UL;
   tf->codes[17446] = 0x00068d79fe9cd76dUL;
   tf->codes[17447] = 0x00068d8b9ba193aeUL;
   tf->codes[17448] = 0x00068d90de7b1861UL;
   tf->codes[17449] = 0x00068d93d7be6362UL;
   tf->codes[17450] = 0x00068dd19a967928UL;
   tf->codes[17451] = 0x00068de0ee04fbb7UL;
   tf->codes[17452] = 0x00068df66e891a0dUL;
   tf->codes[17453] = 0x00068e12cbcfe579UL;
   tf->codes[17454] = 0x00068e4a9c21653dUL;
   tf->codes[17455] = 0x00068e4b113f70c7UL;
   tf->codes[17456] = 0x00068e5d5df13e57UL;
   tf->codes[17457] = 0x00068e67e3a447bdUL;
   tf->codes[17458] = 0x00068e8c07e9d753UL;
   tf->codes[17459] = 0x00068e9da4ee9394UL;
   tf->codes[17460] = 0x00068e9e549ba4e3UL;
   tf->codes[17461] = 0x00068eb82dbd30d8UL;
   tf->codes[17462] = 0x00068ec0a4690651UL;
   tf->codes[17463] = 0x00068ee53dcca171UL;
   tf->codes[17464] = 0x00068ef456ac1e3bUL;
   tf->codes[17465] = 0x00068ef6dad15db2UL;
   tf->codes[17466] = 0x00068ef95ef69d29UL;
   tf->codes[17467] = 0x00068f1b7434f8d2UL;
   tf->codes[17468] = 0x00068f48f96274f5UL;
   tf->codes[17469] = 0x00068f5b46144285UL;
   tf->codes[17470] = 0x00068f8a2a9be146UL;
   tf->codes[17471] = 0x00068f959a8b01c0UL;
   tf->codes[17472] = 0x00068f9bc7a09d87UL;
   tf->codes[17473] = 0x00068fc110b149f6UL;
   tf->codes[17474] = 0x00068fdc83bbfe4eUL;
   tf->codes[17475] = 0x00068fe44abac278UL;
   tf->codes[17476] = 0x00068ffa7aebf21dUL;
   tf->codes[17477] = 0x0006900a7e0785fbUL;
   tf->codes[17478] = 0x0006904c245efdd6UL;
   tf->codes[17479] = 0x0006905a18735dc7UL;
   tf->codes[17480] = 0x000690d64dd09aa2UL;
   tf->codes[17481] = 0x000690dc7ae63669UL;
   tf->codes[17482] = 0x000690f987da1324UL;
   tf->codes[17483] = 0x0006912af086f15cUL;
   tf->codes[17484] = 0x0006913e2774d600UL;
   tf->codes[17485] = 0x000691771c91729dUL;
   tf->codes[17486] = 0x0006917c24dbf18bUL;
   tf->codes[17487] = 0x000691821762878dUL;
   tf->codes[17488] = 0x000691a00e927b5cUL;
   tf->codes[17489] = 0x000691f0cdc97001UL;
   tf->codes[17490] = 0x00069206c36b99e1UL;
   tf->codes[17491] = 0x0006923f08db252fUL;
   tf->codes[17492] = 0x0006924f0bf6b90dUL;
   tf->codes[17493] = 0x0006925b6621f09bUL;
   tf->codes[17494] = 0x0006926fc1daf218UL;
   tf->codes[17495] = 0x0006927036f8fda2UL;
   tf->codes[17496] = 0x0006927504b476cbUL;
   tf->codes[17497] = 0x00069285b77d1bf8UL;
   tf->codes[17498] = 0x00069296a4d4c6eaUL;
   tf->codes[17499] = 0x00069298b3dbfad7UL;
   tf->codes[17500] = 0x000692ac9a76f0caUL;
   tf->codes[17501] = 0x000692c0f62ff247UL;
   tf->codes[17502] = 0x000692ceea445238UL;
   tf->codes[17503] = 0x000692e5ca22932cUL;
   tf->codes[17504] = 0x000692fbbfc4bd0cUL;
   tf->codes[17505] = 0x000692ff2e261397UL;
   tf->codes[17506] = 0x0006930c728d6239UL;
   tf->codes[17507] = 0x0006931f6eec4118UL;
   tf->codes[17508] = 0x00069341842a9cc1UL;
   tf->codes[17509] = 0x00069346c7042174UL;
   tf->codes[17510] = 0x0006939ed81bceb9UL;
   tf->codes[17511] = 0x000693d792a96591UL;
   tf->codes[17512] = 0x0006940a5ab06667UL;
   tf->codes[17513] = 0x0006943fa6dca6b4UL;
   tf->codes[17514] = 0x0006944adc3cc169UL;
   tf->codes[17515] = 0x0006945686bae7a8UL;
   tf->codes[17516] = 0x0006946fb02f624eUL;
   tf->codes[17517] = 0x000694768cf20f64UL;
   tf->codes[17518] = 0x00069479fb5365efUL;
   tf->codes[17519] = 0x000694c1cec07991UL;
   tf->codes[17520] = 0x000694c2f38b966aUL;
   tf->codes[17521] = 0x000694ed0a57bc02UL;
   tf->codes[17522] = 0x000694f50be585f1UL;
   tf->codes[17523] = 0x000694f5bb929740UL;
   tf->codes[17524] = 0x000694f87a46dc7cUL;
   tf->codes[17525] = 0x000694fafe6c1bf3UL;
   tf->codes[17526] = 0x00069519302b1587UL;
   tf->codes[17527] = 0x000695593c9964ffUL;
   tf->codes[17528] = 0x00069574ea331f1cUL;
   tf->codes[17529] = 0x000695918208f04dUL;
   tf->codes[17530] = 0x00069594b5db4113UL;
   tf->codes[17531] = 0x000695968a536f3bUL;
   tf->codes[17532] = 0x0006959f00ff44b4UL;
   tf->codes[17533] = 0x000695c066908f0eUL;
   tf->codes[17534] = 0x000695c0dbae9a98UL;
   tf->codes[17535] = 0x000695d830aae716UL;
   tf->codes[17536] = 0x000695e2f0ecf641UL;
   tf->codes[17537] = 0x000695f9d0cb3735UL;
   tf->codes[17538] = 0x0006961afbcd7bcaUL;
   tf->codes[17539] = 0x00069629da1df2cfUL;
   tf->codes[17540] = 0x00069651e1e2e47aUL;
   tf->codes[17541] = 0x0006965f264a331cUL;
   tf->codes[17542] = 0x0006967ef1f25513UL;
   tf->codes[17543] = 0x000696c4b65834c8UL;
   tf->codes[17544] = 0x000696c4f0e73a8dUL;
   tf->codes[17545] = 0x000696d026475542UL;
   tf->codes[17546] = 0x000696e7b5d2a785UL;
   tf->codes[17547] = 0x000696f27614b6b0UL;
   tf->codes[17548] = 0x0006970cfee353f4UL;
   tf->codes[17549] = 0x0006970e23ae70cdUL;
   tf->codes[17550] = 0x00069749d77f52a6UL;
   tf->codes[17551] = 0x0006976d4c17d0edUL;
   tf->codes[17552] = 0x0006977cda155941UL;
   tf->codes[17553] = 0x0006977f98c99e7dUL;
   tf->codes[17554] = 0x00069785c5df3a44UL;
   tf->codes[17555] = 0x0006979a96b6474bUL;
   tf->codes[17556] = 0x000697be0b4ec592UL;
   tf->codes[17557] = 0x000697bebafbd6e1UL;
   tf->codes[17558] = 0x000697d4eb2d0686UL;
   tf->codes[17559] = 0x0006980eca85ba37UL;
   tf->codes[17560] = 0x0006983c4fb3365aUL;
   tf->codes[17561] = 0x0006984ffbbf2688UL;
   tf->codes[17562] = 0x000698933bffc6c6UL;
   tf->codes[17563] = 0x000698c170da5438UL;
   tf->codes[17564] = 0x000698c728d1e475UL;
   tf->codes[17565] = 0x000698ff6e416fc3UL;
   tf->codes[17566] = 0x000699081f7c4b01UL;
   tf->codes[17567] = 0x0006991404897705UL;
   tf->codes[17568] = 0x0006991eff5a8bf5UL;
   tf->codes[17569] = 0x0006992ae467b7f9UL;
   tf->codes[17570] = 0x0006992c7e50e05cUL;
   tf->codes[17571] = 0x0006993f7aafbf3bUL;
   tf->codes[17572] = 0x000699440ddc329fUL;
   tf->codes[17573] = 0x00069958deb33fa6UL;
   tf->codes[17574] = 0x0006996b65f412fbUL;
   tf->codes[17575] = 0x000699720827ba4cUL;
   tf->codes[17576] = 0x00069975768910d7UL;
   tf->codes[17577] = 0x00069990af04bf6aUL;
   tf->codes[17578] = 0x0006999f52c630aaUL;
   tf->codes[17579] = 0x000699ab37d35caeUL;
   tf->codes[17580] = 0x000699d2555c3745UL;
   tf->codes[17581] = 0x000699e63bf72d38UL;
   tf->codes[17582] = 0x000699fad23f347aUL;
   tf->codes[17583] = 0x00069a008a36c4b7UL;
   tf->codes[17584] = 0x00069a5a6fc6a024UL;
   tf->codes[17585] = 0x00069a5f02f31388UL;
   tf->codes[17586] = 0x00069a6236c5644eUL;
   tf->codes[17587] = 0x00069a82eca99d59UL;
   tf->codes[17588] = 0x00069a8919bf3920UL;
   tf->codes[17589] = 0x00069a8cc2af9570UL;
   tf->codes[17590] = 0x00069ad127bb5287UL;
   tf->codes[17591] = 0x00069adf565eb83dUL;
   tf->codes[17592] = 0x00069aef940951e0UL;
   tf->codes[17593] = 0x00069b05fec9874aUL;
   tf->codes[17594] = 0x00069b1b44be9fdbUL;
   tf->codes[17595] = 0x00069b3b4af5c797UL;
   tf->codes[17596] = 0x00069b44abddb424UL;
   tf->codes[17597] = 0x00069b455b8ac573UL;
   tf->codes[17598] = 0x00069b517b26f73cUL;
   tf->codes[17599] = 0x00069b62687ea22eUL;
   tf->codes[17600] = 0x00069b70d1b10da9UL;
   tf->codes[17601] = 0x00069b8fb31d188cUL;
   tf->codes[17602] = 0x00069b9704fdd12cUL;
   tf->codes[17603] = 0x00069b99c3b21668UL;
   tf->codes[17604] = 0x00069b9c82665ba4UL;
   tf->codes[17605] = 0x00069bbaeeb45afdUL;
   tf->codes[17606] = 0x00069bc11bc9f6c4UL;
   tf->codes[17607] = 0x00069c74373c9c4fUL;
   tf->codes[17608] = 0x00069c759696beedUL;
   tf->codes[17609] = 0x00069c7bfe3b6079UL;
   tf->codes[17610] = 0x00069ce362c1904dUL;
   tf->codes[17611] = 0x00069cede87499b3UL;
   tf->codes[17612] = 0x00069cf2b63012dcUL;
   tf->codes[17613] = 0x00069d011f627e57UL;
   tf->codes[17614] = 0x00069d1247492f0eUL;
   tf->codes[17615] = 0x00069d1d421a43feUL;
   tf->codes[17616] = 0x00069d512eec61adUL;
   tf->codes[17617] = 0x00069d7677fd0e1cUL;
   tf->codes[17618] = 0x00069d913b5ab125UL;
   tf->codes[17619] = 0x00069d9593f81ec4UL;
   tf->codes[17620] = 0x00069db8ce019746UL;
   tf->codes[17621] = 0x00069dc05a7155abUL;
   tf->codes[17622] = 0x00069dc2de969522UL;
   tf->codes[17623] = 0x00069dc7e6e11410UL;
   tf->codes[17624] = 0x00069ddd67653266UL;
   tf->codes[17625] = 0x00069ddda1f4382bUL;
   tf->codes[17626] = 0x00069de47eb6e541UL;
   tf->codes[17627] = 0x00069e0275e6d910UL;
   tf->codes[17628] = 0x00069e1990541fc9UL;
   tf->codes[17629] = 0x00069e38373124e7UL;
   tf->codes[17630] = 0x00069e43320239d7UL;
   tf->codes[17631] = 0x00069e6d48ce5f6fUL;
   tf->codes[17632] = 0x00069e70f1bebbbfUL;
   tf->codes[17633] = 0x00069ec977f4748eUL;
   tf->codes[17634] = 0x00069ecebacdf941UL;
   tf->codes[17635] = 0x00069ed3c318782fUL;
   tf->codes[17636] = 0x00069ee6bf77570eUL;
   tf->codes[17637] = 0x00069f0ae3bce6a4UL;
   tf->codes[17638] = 0x00069f1394f7c1e2UL;
   tf->codes[17639] = 0x00069f356fa717c6UL;
   tf->codes[17640] = 0x00069f35aa361d8bUL;
   tf->codes[17641] = 0x00069f3bd74bb952UL;
   tf->codes[17642] = 0x00069f46226fbcf3UL;
   tf->codes[17643] = 0x00069f5993eca75cUL;
   tf->codes[17644] = 0x00069f6ba60f6f27UL;
   tf->codes[17645] = 0x00069f8ac20a7fcfUL;
   tf->codes[17646] = 0x00069f94d29f7dabUL;
   tf->codes[17647] = 0x00069f9affb51972UL;
   tf->codes[17648] = 0x00069f9cd42d479aUL;
   tf->codes[17649] = 0x00069fe93ac6cea0UL;
   tf->codes[17650] = 0x00069ffa9d3c851cUL;
   tf->codes[17651] = 0x0006a0164ad63f39UL;
   tf->codes[17652] = 0x0006a0c03feffdfcUL;
   tf->codes[17653] = 0x0006a0c4d31c7160UL;
   tf->codes[17654] = 0x0006a0cb00320d27UL;
   tf->codes[17655] = 0x0006a105c9c6d7ecUL;
   tf->codes[17656] = 0x0006a106ee91f4c5UL;
   tf->codes[17657] = 0x0006a14b8e2cb7a1UL;
   tf->codes[17658] = 0x0006a14e1251f718UL;
   tf->codes[17659] = 0x0006a15e8a8b9680UL;
   tf->codes[17660] = 0x0006a16f77e34172UL;
   tf->codes[17661] = 0x0006a1afbee096afUL;
   tf->codes[17662] = 0x0006a1cd0663792fUL;
   tf->codes[17663] = 0x0006a1dfc8335249UL;
   tf->codes[17664] = 0x0006a1ecd20b9b26UL;
   tf->codes[17665] = 0x0006a1f423ec53c6UL;
   tf->codes[17666] = 0x0006a1f757bea48cUL;
   tf->codes[17667] = 0x0006a21a57391749UL;
   tf->codes[17668] = 0x0006a2508da16eaaUL;
   tf->codes[17669] = 0x0006a2543691cafaUL;
   tf->codes[17670] = 0x0006a2697c86e38bUL;
   tf->codes[17671] = 0x0006a274ec760405UL;
   tf->codes[17672] = 0x0006a27cee03cdf4UL;
   tf->codes[17673] = 0x0006a287ae45dd1fUL;
   tf->codes[17674] = 0x0006a28c7c015648UL;
   tf->codes[17675] = 0x0006a291f969e0c0UL;
   tf->codes[17676] = 0x0006a294f2ad2bc1UL;
   tf->codes[17677] = 0x0006a2ba3bbdd830UL;
   tf->codes[17678] = 0x0006a2c2b269ada9UL;
   tf->codes[17679] = 0x0006a2c98f2c5abfUL;
   tf->codes[17680] = 0x0006a2e7c0eb5453UL;
   tf->codes[17681] = 0x0006a2e95ad47cb6UL;
   tf->codes[17682] = 0x0006a2ef87ea187dUL;
   tf->codes[17683] = 0x0006a2f3e087861cUL;
   tf->codes[17684] = 0x0006a31afe1060b3UL;
   tf->codes[17685] = 0x0006a33f2255f049UL;
   tf->codes[17686] = 0x0006a345c489979aUL;
   tf->codes[17687] = 0x0006a34723e3ba38UL;
   tf->codes[17688] = 0x0006a358c0e87679UL;
   tf->codes[17689] = 0x0006a376086b58f9UL;
   tf->codes[17690] = 0x0006a3893f593d9dUL;
   tf->codes[17691] = 0x0006a38bfe0d82d9UL;
   tf->codes[17692] = 0x0006a3e0a0c3d993UL;
   tf->codes[17693] = 0x0006a3ff822fe476UL;
   tf->codes[17694] = 0x0006a412f3accedfUL;
   tf->codes[17695] = 0x0006a41c5494bb6cUL;
   tf->codes[17696] = 0x0006a435437a304dUL;
   tf->codes[17697] = 0x0006a489aba18142UL;
   tf->codes[17698] = 0x0006a48fd8b71d09UL;
   tf->codes[17699] = 0x0006a49ad38831f9UL;
   tf->codes[17700] = 0x0006a4c05727e42dUL;
   tf->codes[17701] = 0x0006a4d9bb2b6498UL;
   tf->codes[17702] = 0x0006a4dadff68171UL;
   tf->codes[17703] = 0x0006a4e2a6f5459bUL;
   tf->codes[17704] = 0x0006a4f1bfd4c265UL;
   tf->codes[17705] = 0x0006a4f3cedbf652UL;
   tf->codes[17706] = 0x0006a4f4f3a7132bUL;
   tf->codes[17707] = 0x0006a50b98f64e5aUL;
   tf->codes[17708] = 0x0006a51bd6a0e7fdUL;
   tf->codes[17709] = 0x0006a527f63d19c6UL;
   tf->codes[17710] = 0x0006a58d4bbc15adUL;
   tf->codes[17711] = 0x0006a5b812354c94UL;
   tf->codes[17712] = 0x0006a5f22c1d060aUL;
   tf->codes[17713] = 0x0006a5f316591d1eUL;
   tf->codes[17714] = 0x0006a617ea4bbe03UL;
   tf->codes[17715] = 0x0006a61b1e1e0ec9UL;
   tf->codes[17716] = 0x0006a6370646ceabUL;
   tf->codes[17717] = 0x0006a65204337779UL;
   tf->codes[17718] = 0x0006a65aeffd587cUL;
   tf->codes[17719] = 0x0006a69c9654d057UL;
   tf->codes[17720] = 0x0006a6c1a4d67701UL;
   tf->codes[17721] = 0x0006a6c96bd53b2bUL;
   tf->codes[17722] = 0x0006a6ca5611523fUL;
   tf->codes[17723] = 0x0006a6ece06db972UL;
   tf->codes[17724] = 0x0006a70c36f7cfdfUL;
   tf->codes[17725] = 0x0006a716bcaad945UL;
   tf->codes[17726] = 0x0006a7181c04fbe3UL;
   tf->codes[17727] = 0x0006a71940d018bcUL;
   tf->codes[17728] = 0x0006a742e27e32caUL;
   tf->codes[17729] = 0x0006a74775aaa62eUL;
   tf->codes[17730] = 0x0006a74a6eedf12fUL;
   tf->codes[17731] = 0x0006a74c43661f57UL;
   tf->codes[17732] = 0x0006a76b99f035c4UL;
   tf->codes[17733] = 0x0006a78622bed308UL;
   tf->codes[17734] = 0x0006a78de9bd9732UL;
   tf->codes[17735] = 0x0006a7be682e5e56UL;
   tf->codes[17736] = 0x0006a7c1d68fb4e1UL;
   tf->codes[17737] = 0x0006a7c335e9d77fUL;
   tf->codes[17738] = 0x0006a7d2143a4e84UL;
   tf->codes[17739] = 0x0006a7da8ae623fdUL;
   tf->codes[17740] = 0x0006a7e6aa8255c6UL;
   tf->codes[17741] = 0x0006a843fe7387beUL;
   tf->codes[17742] = 0x0006a8473245d884UL;
   tf->codes[17743] = 0x0006a85560e93e3aUL;
   tf->codes[17744] = 0x0006a86d65929c07UL;
   tf->codes[17745] = 0x0006a8768beb82cfUL;
   tf->codes[17746] = 0x0006a87da33d35aaUL;
   tf->codes[17747] = 0x0006a88b9751959bUL;
   tf->codes[17748] = 0x0006a8d245f38c64UL;
   tf->codes[17749] = 0x0006a8e3e2f848a5UL;
   tf->codes[17750] = 0x0006a8fb72839ae8UL;
   tf->codes[17751] = 0x0006a900efec2560UL;
   tf->codes[17752] = 0x0006a9396feab673UL;
   tf->codes[17753] = 0x0006a9425bb49776UL;
   tf->codes[17754] = 0x0006a96819e34f6fUL;
   tf->codes[17755] = 0x0006a97f6edf9bedUL;
   tf->codes[17756] = 0x0006a98e87bf18b7UL;
   tf->codes[17757] = 0x0006a98fe7193b55UL;
   tf->codes[17758] = 0x0006a9d98efe7d1fUL;
   tf->codes[17759] = 0x0006a9dbd894b6d1UL;
   tf->codes[17760] = 0x0006a9de222af083UL;
   tf->codes[17761] = 0x0006a9ded1d801d2UL;
   tf->codes[17762] = 0x0006a9e4feed9d99UL;
   tf->codes[17763] = 0x0006a9f1ce36e0b1UL;
   tf->codes[17764] = 0x0006aa01d152748fUL;
   tf->codes[17765] = 0x0006aa3c6058398fUL;
   tf->codes[17766] = 0x0006aa3fceb9901aUL;
   tf->codes[17767] = 0x0006aa960b590f37UL;
   tf->codes[17768] = 0x0006aa9f6c40fbc4UL;
   tf->codes[17769] = 0x0006aab4ecc51a1aUL;
   tf->codes[17770] = 0x0006aac10c614be3UL;
   tf->codes[17771] = 0x0006aaccb6df7222UL;
   tf->codes[17772] = 0x0006aadfb33e5101UL;
   tf->codes[17773] = 0x0006aae9fe6254a2UL;
   tf->codes[17774] = 0x0006aaeb232d717bUL;
   tf->codes[17775] = 0x0006aafcc0322dbcUL;
   tf->codes[17776] = 0x0006ab09ca0a7699UL;
   tf->codes[17777] = 0x0006ab48771ea373UL;
   tf->codes[17778] = 0x0006ab6f1f897280UL;
   tf->codes[17779] = 0x0006ab746262f733UL;
   tf->codes[17780] = 0x0006ab7beed2b598UL;
   tf->codes[17781] = 0x0006ab83b5d179c2UL;
   tf->codes[17782] = 0x0006abba9be6e272UL;
   tf->codes[17783] = 0x0006abcbc3cd9329UL;
   tf->codes[17784] = 0x0006abea301b9282UL;
   tf->codes[17785] = 0x0006abf0d24f39d3UL;
   tf->codes[17786] = 0x0006abf440b0905eUL;
   tf->codes[17787] = 0x0006abfc07af5488UL;
   tf->codes[17788] = 0x0006ac1063685605UL;
   tf->codes[17789] = 0x0006ac2b9be40498UL;
   tf->codes[17790] = 0x0006ac3e9842e377UL;
   tf->codes[17791] = 0x0006ac4b678c268fUL;
   tf->codes[17792] = 0x0006ac54c874131cUL;
   tf->codes[17793] = 0x0006ac5627ce35baUL;
   tf->codes[17794] = 0x0006ac7000efc1afUL;
   tf->codes[17795] = 0x0006ac7334c21275UL;
   tf->codes[17796] = 0x0006ac845ca8c32cUL;
   tf->codes[17797] = 0x0006ac892a643c55UL;
   tf->codes[17798] = 0x0006ac8f1cead257UL;
   tf->codes[17799] = 0x0006acd30cd883e4UL;
   tf->codes[17800] = 0x0006ace8c7eba7ffUL;
   tf->codes[17801] = 0x0006ad16c2372facUL;
   tf->codes[17802] = 0x0006ad1aa5b691c1UL;
   tf->codes[17803] = 0x0006ad3a715eb3b8UL;
   tf->codes[17804] = 0x0006ad414e2160ceUL;
   tf->codes[17805] = 0x0006ad42385d77e2UL;
   tf->codes[17806] = 0x0006ad54fa2d50fcUL;
   tf->codes[17807] = 0x0006ad5ff4fe65ecUL;
   tf->codes[17808] = 0x0006ad657266f064UL;
   tf->codes[17809] = 0x0006ad68a639412aUL;
   tf->codes[17810] = 0x0006ad753af37e7dUL;
   tf->codes[17811] = 0x0006ad7749fab26aUL;
   tf->codes[17812] = 0x0006ad8ffe512186UL;
   tf->codes[17813] = 0x0006ad91d2c94faeUL;
   tf->codes[17814] = 0x0006ad95f0d7b788UL;
   tf->codes[17815] = 0x0006ad9ba8cf47c5UL;
   tf->codes[17816] = 0x0006adac5b97ecf2UL;
   tf->codes[17817] = 0x0006adb806161331UL;
   tf->codes[17818] = 0x0006adc5fa2a7322UL;
   tf->codes[17819] = 0x0006add30402bbffUL;
   tf->codes[17820] = 0x0006ade79a4ac341UL;
   tf->codes[17821] = 0x0006adef26ba81a6UL;
   tf->codes[17822] = 0x0006adf30a39e3bbUL;
   tf->codes[17823] = 0x0006adfca5b0d60dUL;
   tf->codes[17824] = 0x0006ae44b3acef74UL;
   tf->codes[17825] = 0x0006ae4b1b519100UL;
   tf->codes[17826] = 0x0006ae57005ebd04UL;
   tf->codes[17827] = 0x0006ae5c433841b7UL;
   tf->codes[17828] = 0x0006ae640a3705e1UL;
   tf->codes[17829] = 0x0006ae761c59cdacUL;
   tf->codes[17830] = 0x0006ae8918b8ac8bUL;
   tf->codes[17831] = 0x0006ae97bc7a1dcbUL;
   tf->codes[17832] = 0x0006ae98a6b634dfUL;
   tf->codes[17833] = 0x0006aea27cbc2cf6UL;
   tf->codes[17834] = 0x0006aea5b08e7dbcUL;
   tf->codes[17835] = 0x0006aeb48edef4c1UL;
   tf->codes[17836] = 0x0006aec8b008f079UL;
   tf->codes[17837] = 0x0006aecea28f867bUL;
   tf->codes[17838] = 0x0006aee66ca9de83UL;
   tf->codes[17839] = 0x0006aeeee355b3fcUL;
   tf->codes[17840] = 0x0006af0f5eaae742UL;
   tf->codes[17841] = 0x0006af14dc1371baUL;
   tf->codes[17842] = 0x0006af3dce147a79UL;
   tf->codes[17843] = 0x0006af4e464e19e1UL;
   tf->codes[17844] = 0x0006af681f6fa5d6UL;
   tf->codes[17845] = 0x0006af8a6f3d0744UL;
   tf->codes[17846] = 0x0006afb3d65c1b8dUL;
   tf->codes[17847] = 0x0006afc0a5a55ea5UL;
   tf->codes[17848] = 0x0006afc39ee8a9a6UL;
   tf->codes[17849] = 0x0006afc7bcf71180UL;
   tf->codes[17850] = 0x0006aff96032f57dUL;
   tf->codes[17851] = 0x0006b04308183747UL;
   tf->codes[17852] = 0x0006b05ad2328f4fUL;
   tf->codes[17853] = 0x0006b05bbc6ea663UL;
   tf->codes[17854] = 0x0006b06d1ee45cdfUL;
   tf->codes[17855] = 0x0006b07470c5157fUL;
   tf->codes[17856] = 0x0006b07fe0b435f9UL;
   tf->codes[17857] = 0x0006b088cc7e16fcUL;
   tf->codes[17858] = 0x0006b09526a94e8aUL;
   tf->codes[17859] = 0x0006b0b26e2c310aUL;
   tf->codes[17860] = 0x0006b0b442a45f32UL;
   tf->codes[17861] = 0x0006b0cc474dbcffUL;
   tf->codes[17862] = 0x0006b0dece8e9054UL;
   tf->codes[17863] = 0x0006b13f56521312UL;
   tf->codes[17864] = 0x0006b145bdf6b49eUL;
   tf->codes[17865] = 0x0006b153025e0340UL;
   tf->codes[17866] = 0x0006b17293771f72UL;
   tf->codes[17867] = 0x0006b18e0681d3caUL;
   tf->codes[17868] = 0x0006b1f2e6e2c427UL;
   tf->codes[17869] = 0x0006b24330fbad42UL;
   tf->codes[17870] = 0x0006b250ea81076eUL;
   tf->codes[17871] = 0x0006b25ac086ff85UL;
   tf->codes[17872] = 0x0006b25d44ac3efcUL;
   tf->codes[17873] = 0x0006b29b42135a87UL;
   tf->codes[17874] = 0x0006b2c976ede7f9UL;
   tf->codes[17875] = 0x0006b2ca9bb904d2UL;
   tf->codes[17876] = 0x0006b2da644592ebUL;
   tf->codes[17877] = 0x0006b2e265d35cdaUL;
   tf->codes[17878] = 0x0006b2f3c8491356UL;
   tf->codes[17879] = 0x0006b3465bf83623UL;
   tf->codes[17880] = 0x0006b356d431d58bUL;
   tf->codes[17881] = 0x0006b36b2fead708UL;
   tf->codes[17882] = 0x0006b37d420d9ed3UL;
   tf->codes[17883] = 0x0006b37f8ba3d885UL;
   tf->codes[17884] = 0x0006b3866866859bUL;
   tf->codes[17885] = 0x0006b39c9897b540UL;
   tf->codes[17886] = 0x0006b3ae359c7181UL;
   tf->codes[17887] = 0x0006b3be38b8055fUL;
   tf->codes[17888] = 0x0006b3cca1ea70daUL;
   tf->codes[17889] = 0x0006b3f1eafb1d49UL;
   tf->codes[17890] = 0x0006b40a9f518c65UL;
   tf->codes[17891] = 0x0006b40c73c9ba8dUL;
   tf->codes[17892] = 0x0006b40f327dffc9UL;
   tf->codes[17893] = 0x0006b437af60fcfeUL;
   tf->codes[17894] = 0x0006b4452e575165UL;
   tf->codes[17895] = 0x0006b45c83539de3UL;
   tf->codes[17896] = 0x0006b469180ddb36UL;
   tf->codes[17897] = 0x0006b46f7fb27cc2UL;
   tf->codes[17898] = 0x0006b47b2a30a301UL;
   tf->codes[17899] = 0x0006b48206f35017UL;
   tf->codes[17900] = 0x0006b4b9d744cfdbUL;
   tf->codes[17901] = 0x0006b4df5ae4820fUL;
   tf->codes[17902] = 0x0006b4e7d1905788UL;
   tf->codes[17903] = 0x0006b50e3f6c20d0UL;
   tf->codes[17904] = 0x0006b51bf8f17afcUL;
   tf->codes[17905] = 0x0006b53caed5b407UL;
   tf->codes[17906] = 0x0006b53fe2a804cdUL;
   tf->codes[17907] = 0x0006b541b72032f5UL;
   tf->codes[17908] = 0x0006b54ec0f87bd2UL;
   tf->codes[17909] = 0x0006b54f3616875cUL;
   tf->codes[17910] = 0x0006b55c3feed039UL;
   tf->codes[17911] = 0x0006b5656647b701UL;
   tf->codes[17912] = 0x0006b575a3f250a4UL;
   tf->codes[17913] = 0x0006b578d7c4a16aUL;
   tf->codes[17914] = 0x0006b58531efd8f8UL;
   tf->codes[17915] = 0x0006b5af48bbfe90UL;
   tf->codes[17916] = 0x0006b5ba438d1380UL;
   tf->codes[17917] = 0x0006b5cccacde6d5UL;
   tf->codes[17918] = 0x0006b5dc935a74eeUL;
   tf->codes[17919] = 0x0006b6133ee0d7d9UL;
   tf->codes[17920] = 0x0006b6175cef3fb3UL;
   tf->codes[17921] = 0x0006b64fdcedd0c6UL;
   tf->codes[17922] = 0x0006b650520bdc50UL;
   tf->codes[17923] = 0x0006b66caf52a7bcUL;
   tf->codes[17924] = 0x0006b68b90beb29fUL;
   tf->codes[17925] = 0x0006b6baafd55725UL;
   tf->codes[17926] = 0x0006b6baea645ceaUL;
   tf->codes[17927] = 0x0006b6cb629dfc52UL;
   tf->codes[17928] = 0x0006b6dba04895f5UL;
   tf->codes[17929] = 0x0006b6e7fa73cd83UL;
   tf->codes[17930] = 0x0006b6ec1882355dUL;
   tf->codes[17931] = 0x0006b6fa81b4a0d8UL;
   tf->codes[17932] = 0x0006b6fb6bf0b7ecUL;
   tf->codes[17933] = 0x0006b74bf098a6ccUL;
   tf->codes[17934] = 0x0006b758bfe1e9e4UL;
   tf->codes[17935] = 0x0006b75e02bb6e97UL;
   tf->codes[17936] = 0x0006b76972aa8f11UL;
   tf->codes[17937] = 0x0006b7955deee2d1UL;
   tf->codes[17938] = 0x0006b79d9a0bb285UL;
   tf->codes[17939] = 0x0006b7b9bcc3782cUL;
   tf->codes[17940] = 0x0006b7cf77d69c47UL;
   tf->codes[17941] = 0x0006b808a7823ea9UL;
   tf->codes[17942] = 0x0006b81c8e1d349cUL;
   tf->codes[17943] = 0x0006b84b3815cd98UL;
   tf->codes[17944] = 0x0006b85423dfae9bUL;
   tf->codes[17945] = 0x0006b854d38cbfeaUL;
   tf->codes[17946] = 0x0006b855f857dcc3UL;
   tf->codes[17947] = 0x0006b856e293f3d7UL;
   tf->codes[17948] = 0x0006b86426fb4279UL;
   tf->codes[17949] = 0x0006b873ef87d092UL;
   tf->codes[17950] = 0x0006b88c2ec03424UL;
   tf->codes[17951] = 0x0006b89dcbc4f065UL;
   tf->codes[17952] = 0x0006b8b29c9bfd6cUL;
   tf->codes[17953] = 0x0006b8e3902ad01aUL;
   tf->codes[17954] = 0x0006b8ec7bf4b11dUL;
   tf->codes[17955] = 0x0006b918673904ddUL;
   tf->codes[17956] = 0x0006b95b325b9991UL;
   tf->codes[17957] = 0x0006b96c1fb34483UL;
   tf->codes[17958] = 0x0006b98967362703UL;
   tf->codes[17959] = 0x0006b98a51723e17UL;
   tf->codes[17960] = 0x0006b98c60797204UL;
   tf->codes[17961] = 0x0006b98dfa629a67UL;
   tf->codes[17962] = 0x0006b9c6b4f0313fUL;
   tf->codes[17963] = 0x0006b9d2d48c6308UL;
   tf->codes[17964] = 0x0006b9da60fc216dUL;
   tf->codes[17965] = 0x0006b9f683b3e714UL;
   tf->codes[17966] = 0x0006b9faa1c24eeeUL;
   tf->codes[17967] = 0x0006b9fd9b0599efUL;
   tf->codes[17968] = 0x0006ba12e0fab280UL;
   tf->codes[17969] = 0x0006ba1e8b78d8bfUL;
   tf->codes[17970] = 0x0006ba36cab13c51UL;
   tf->codes[17971] = 0x0006ba373fcf47dbUL;
   tf->codes[17972] = 0x0006ba45e390b91bUL;
   tf->codes[17973] = 0x0006ba62b5f59011UL;
   tf->codes[17974] = 0x0006ba75ece374b5UL;
   tf->codes[17975] = 0x0006bacc9ea0ff5cUL;
   tf->codes[17976] = 0x0006bad5c4f9e624UL;
   tf->codes[17977] = 0x0006bb2c3c286b06UL;
   tf->codes[17978] = 0x0006bb35d79f5d58UL;
   tf->codes[17979] = 0x0006bb547e7c6276UL;
   tf->codes[17980] = 0x0006bb5b95ce1551UL;
   tf->codes[17981] = 0x0006bb82ede5f5adUL;
   tf->codes[17982] = 0x0006bb9a42e2422bUL;
   tf->codes[17983] = 0x0006bbdc5e57c590UL;
   tf->codes[17984] = 0x0006bbf0ba10c70dUL;
   tf->codes[17985] = 0x0006bbf796d37423UL;
   tf->codes[17986] = 0x0006bc0f9b7cd1f0UL;
   tf->codes[17987] = 0x0006bc8653718453UL;
   tf->codes[17988] = 0x0006bc977b58350aUL;
   tf->codes[17989] = 0x0006bcca08d0301bUL;
   tf->codes[17990] = 0x0006bd0cd3f2c4cfUL;
   tf->codes[17991] = 0x0006bd17cec3d9bfUL;
   tf->codes[17992] = 0x0006bd3f26dbba1bUL;
   tf->codes[17993] = 0x0006bd4c30b402f8UL;
   tf->codes[17994] = 0x0006bdb40a583e56UL;
   tf->codes[17995] = 0x0006bdb52f235b2fUL;
   tf->codes[17996] = 0x0006bdd0dcbd154cUL;
   tf->codes[17997] = 0x0006bdda7834079eUL;
   tf->codes[17998] = 0x0006bdee243ff7ccUL;
   tf->codes[17999] = 0x0006bdf834d4f5a8UL;
   tf->codes[18000] = 0x0006bdffc144b40dUL;
   tf->codes[18001] = 0x0006be16dbb1fac6UL;
   tf->codes[18002] = 0x0006be8766911162UL;
   tf->codes[18003] = 0x0006be9a2860ea7cUL;
   tf->codes[18004] = 0x0006be9d5c333b42UL;
   tf->codes[18005] = 0x0006bec38f7ffec5UL;
   tf->codes[18006] = 0x0006bec3ca0f048aUL;
   tf->codes[18007] = 0x0006bed407b99e2dUL;
   tf->codes[18008] = 0x0006bedc43d66de1UL;
   tf->codes[18009] = 0x0006bef1fee991fcUL;
   tf->codes[18010] = 0x0006bef7b6e12239UL;
   tf->codes[18011] = 0x0006bef98b595061UL;
   tf->codes[18012] = 0x0006bf445809af04UL;
   tf->codes[18013] = 0x0006bf50b234e692UL;
   tf->codes[18014] = 0x0006bf624f39a2d3UL;
   tf->codes[18015] = 0x0006bf73ec3e5f14UL;
   tf->codes[18016] = 0x0006bf89a751832fUL;
   tf->codes[18017] = 0x0006bf8b7bc9b157UL;
   tf->codes[18018] = 0x0006bfbb0ffe6167UL;
   tf->codes[18019] = 0x0006bfc4e604597eUL;
   tf->codes[18020] = 0x0006bfcd973f34bcUL;
   tf->codes[18021] = 0x0006bfd314a7bf34UL;
   tf->codes[18022] = 0x0006bfdfe3f1024cUL;
   tf->codes[18023] = 0x0006bfe108bc1f25UL;
   tf->codes[18024] = 0x0006bfecb33a4564UL;
   tf->codes[18025] = 0x0006bfecedc94b29UL;
   tf->codes[18026] = 0x0006c01ecb9434ebUL;
   tf->codes[18027] = 0x0006c04623ac1547UL;
   tf->codes[18028] = 0x0006c05243484710UL;
   tf->codes[18029] = 0x0006c05d3e195c00UL;
   tf->codes[18030] = 0x0006c0e7a219fe91UL;
   tf->codes[18031] = 0x0006c0f4abf2476eUL;
   tf->codes[18032] = 0x0006c11cee463edeUL;
   tf->codes[18033] = 0x0006c197fed85ee0UL;
   tf->codes[18034] = 0x0006c19e2bedfaa7UL;
   tf->codes[18035] = 0x0006c1cf5a0bd31aUL;
   tf->codes[18036] = 0x0006c1d28dde23e0UL;
   tf->codes[18037] = 0x0006c1f9ab66fe77UL;
   tf->codes[18038] = 0x0006c20ce254e31bUL;
   tf->codes[18039] = 0x0006c24e88ac5af6UL;
   tf->codes[18040] = 0x0006c25c7cc0bae7UL;
   tf->codes[18041] = 0x0006c2794f2591ddUL;
   tf->codes[18042] = 0x0006c2986b20a285UL;
   tf->codes[18043] = 0x0006c299555cb999UL;
   tf->codes[18044] = 0x0006c29e98363e4cUL;
   tf->codes[18045] = 0x0006c2dc207f4e4dUL;
   tf->codes[18046] = 0x0006c3030379231fUL;
   tf->codes[18047] = 0x0006c32518b77ec8UL;
   tf->codes[18048] = 0x0006c344a9d09afaUL;
   tf->codes[18049] = 0x0006c34a27392572UL;
   tf->codes[18050] = 0x0006c34fdf30b5afUL;
   tf->codes[18051] = 0x0006c391faa63914UL;
   tf->codes[18052] = 0x0006c3fedc94f360UL;
   tf->codes[18053] = 0x0006c4057ec89ab1UL;
   tf->codes[18054] = 0x0006c40e6a927bb4UL;
   tf->codes[18055] = 0x0006c41497a8177bUL;
   tf->codes[18056] = 0x0006c418409873cbUL;
   tf->codes[18057] = 0x0006c4558e527e07UL;
   tf->codes[18058] = 0x0006c45a969cfcf5UL;
   tf->codes[18059] = 0x0006c45e04fe5380UL;
   tf->codes[18060] = 0x0006c45f9ee77be3UL;
   tf->codes[18061] = 0x0006c4638266ddf8UL;
   tf->codes[18062] = 0x0006c47ce66a5e63UL;
   tf->codes[18063] = 0x0006c48e836f1aa4UL;
   tf->codes[18064] = 0x0006c4960fded909UL;
   tf->codes[18065] = 0x0006c49e868aae82UL;
   tf->codes[18066] = 0x0006c4ceca6c6fe1UL;
   tf->codes[18067] = 0x0006c4da3a5b905bUL;
   tf->codes[18068] = 0x0006c4e02ce2265dUL;
   tf->codes[18069] = 0x0006c50784fa06b9UL;
   tf->codes[18070] = 0x0006c541d970c5f4UL;
   tf->codes[18071] = 0x0006c55426229384UL;
   tf->codes[18072] = 0x0006c5554aedb05dUL;
   tf->codes[18073] = 0x0006c555fa9ac1acUL;
   tf->codes[18074] = 0x0006c561dfa7edb0UL;
   tf->codes[18075] = 0x0006c565fdb6558aUL;
   tf->codes[18076] = 0x0006c56cda7902a0UL;
   tf->codes[18077] = 0x0006c5796f333ff3UL;
   tf->codes[18078] = 0x0006c57ca30590b9UL;
   tf->codes[18079] = 0x0006c59f67f0fdb1UL;
   tf->codes[18080] = 0x0006c5b9b6309530UL;
   tf->codes[18081] = 0x0006c5c97ebd2349UL;
   tf->codes[18082] = 0x0006c605328e0522UL;
   tf->codes[18083] = 0x0006c60e1e57e625UL;
   tf->codes[18084] = 0x0006c6177f3fd2b2UL;
   tf->codes[18085] = 0x0006c618de99f550UL;
   tf->codes[18086] = 0x0006c61c126c4616UL;
   tf->codes[18087] = 0x0006c6536d9fba50UL;
   tf->codes[18088] = 0x0006c6678ec9b608UL;
   tf->codes[18089] = 0x0006c6c7dbfe3301UL;
   tf->codes[18090] = 0x0006c714b7b5c591UL;
   tf->codes[18091] = 0x0006c750e0a4b2f4UL;
   tf->codes[18092] = 0x0006c77ea06134dcUL;
   tf->codes[18093] = 0x0006c7999e4dddaaUL;
   tf->codes[18094] = 0x0006c79f90d473acUL;
   tf->codes[18095] = 0x0006c7bd12e65bf1UL;
   tf->codes[18096] = 0x0006c7c6e8ec5408UL;
   tf->codes[18097] = 0x0006c7f72cce1567UL;
   tf->codes[18098] = 0x0006c7fa26116068UL;
   tf->codes[18099] = 0x0006c80645ad9231UL;
   tf->codes[18100] = 0x0006c84826940fd1UL;
   tf->codes[18101] = 0x0006c84aaab94f48UL;
   tf->codes[18102] = 0x0006c86daa33c205UL;
   tf->codes[18103] = 0x0006c87745aab457UL;
   tf->codes[18104] = 0x0006c8cc22f010d6UL;
   tf->codes[18105] = 0x0006c8cd824a3374UL;
   tf->codes[18106] = 0x0006c8e96a72f356UL;
   tf->codes[18107] = 0x0006c906ec84db9bUL;
   tf->codes[18108] = 0x0006c90bf4cf5a89UL;
   tf->codes[18109] = 0x0006c91ad31fd18eUL;
   tf->codes[18110] = 0x0006c91d57451105UL;
   tf->codes[18111] = 0x0006c94d6097cc9fUL;
   tf->codes[18112] = 0x0006c959f55209f2UL;
   tf->codes[18113] = 0x0006c97e54269f4dUL;
   tf->codes[18114] = 0x0006c98272350727UL;
   tf->codes[18115] = 0x0006c98c82ca0503UL;
   tf->codes[18116] = 0x0006c9956e93e606UL;
   tf->codes[18117] = 0x0006c9cc8f38547bUL;
   tf->codes[18118] = 0x0006c9d490c61e6aUL;
   tf->codes[18119] = 0x0006c9d714eb5de1UL;
   tf->codes[18120] = 0x0006c9dba817d145UL;
   tf->codes[18121] = 0x0006c9de66cc1681UL;
   tf->codes[18122] = 0x0006c9eb36155999UL;
   tf->codes[18123] = 0x0006c9f078eede4cUL;
   tf->codes[18124] = 0x0006ca03754dbd2bUL;
   tf->codes[18125] = 0x0006ca04d4a7dfc9UL;
   tf->codes[18126] = 0x0006ca237b84e4e7UL;
   tf->codes[18127] = 0x0006ca4c32f6e7e1UL;
   tf->codes[18128] = 0x0006ca97e9e35d98UL;
   tf->codes[18129] = 0x0006cabda8121591UL;
   tf->codes[18130] = 0x0006cacff4c3e321UL;
   tf->codes[18131] = 0x0006cad3289633e7UL;
   tf->codes[18132] = 0x0006cadbd9d10f25UL;
   tf->codes[18133] = 0x0006cade98855461UL;
   tf->codes[18134] = 0x0006cb4cd9ce314bUL;
   tf->codes[18135] = 0x0006cb521ca7b5feUL;
   tf->codes[18136] = 0x0006cb6b80ab3669UL;
   tf->codes[18137] = 0x0006cb901a0ed189UL;
   tf->codes[18138] = 0x0006cb9e48b2373fUL;
   tf->codes[18139] = 0x0006cbc824ef5712UL;
   tf->codes[18140] = 0x0006cbdd6ae46fa3UL;
   tf->codes[18141] = 0x0006cbfa02ba40d4UL;
   tf->codes[18142] = 0x0006cbfdabaa9d24UL;
   tf->codes[18143] = 0x0006cc14c617e3ddUL;
   tf->codes[18144] = 0x0006cc153b35ef67UL;
   tf->codes[18145] = 0x0006cc45f435bc50UL;
   tf->codes[18146] = 0x0006cc5e336e1fe2UL;
   tf->codes[18147] = 0x0006cc6dfbfaadfbUL;
   tf->codes[18148] = 0x0006cc6e3689b3c0UL;
   tf->codes[18149] = 0x0006cc733ed432aeUL;
   tf->codes[18150] = 0x0006cc7a5625e589UL;
   tf->codes[18151] = 0x0006cc88f9e756c9UL;
   tf->codes[18152] = 0x0006cc9a96ec130aUL;
   tf->codes[18153] = 0x0006ccc81c198f2dUL;
   tf->codes[18154] = 0x0006ccccaf460291UL;
   tf->codes[18155] = 0x0006cce6134982fcUL;
   tf->codes[18156] = 0x0006ccf357b0d19eUL;
   tf->codes[18157] = 0x0006cd1cbecfe5e7UL;
   tf->codes[18158] = 0x0006cd2f809fbf01UL;
   tf->codes[18159] = 0x0006cd3c1559fc54UL;
   tf->codes[18160] = 0x0006cd4416e7c643UL;
   tf->codes[18161] = 0x0006cd75f4b2b005UL;
   tf->codes[18162] = 0x0006cd7a12c117dfUL;
   tf->codes[18163] = 0x0006cd7f9029a257UL;
   tf->codes[18164] = 0x0006cdc6b3e9a4aaUL;
   tf->codes[18165] = 0x0006cdd9b0488389UL;
   tf->codes[18166] = 0x0006cddb0fa2a627UL;
   tf->codes[18167] = 0x0006cdf7a7787758UL;
   tf->codes[18168] = 0x0006cdfcea51fc0bUL;
   tf->codes[18169] = 0x0006ce1f3a1f5d79UL;
   tf->codes[18170] = 0x0006ce58a45a05a0UL;
   tf->codes[18171] = 0x0006ce5de7338a53UL;
   tf->codes[18172] = 0x0006ce5ed16fa167UL;
   tf->codes[18173] = 0x0006ce8c1c0e17c5UL;
   tf->codes[18174] = 0x0006ce92be41bf16UL;
   tf->codes[18175] = 0x0006cebd4a2bf038UL;
   tf->codes[18176] = 0x0006cebf1ea41e60UL;
   tf->codes[18177] = 0x0006cec969c82201UL;
   tf->codes[18178] = 0x0006ceceaca1a6b4UL;
   tf->codes[18179] = 0x0006cef9731add9bUL;
   tf->codes[18180] = 0x0006cf025ee4be9eUL;
   tf->codes[18181] = 0x0006cf1819f7e2b9UL;
   tf->codes[18182] = 0x0006cf55a240f2baUL;
   tf->codes[18183] = 0x0006cf6da6ea5087UL;
   tf->codes[18184] = 0x0006cfdac3681098UL;
   tf->codes[18185] = 0x0006cfdd821c55d4UL;
   tf->codes[18186] = 0x0006cffe728f94a4UL;
   tf->codes[18187] = 0x0006d0075e5975a7UL;
   tf->codes[18188] = 0x0006d00e3b1c22bdUL;
   tf->codes[18189] = 0x0006d047dfe5d0a9UL;
   tf->codes[18190] = 0x0006d04e478a7235UL;
   tf->codes[18191] = 0x0006d04ef7378384UL;
   tf->codes[18192] = 0x0006d0601f1e343bUL;
   tf->codes[18193] = 0x0006d071f6b1f641UL;
   tf->codes[18194] = 0x0006d072a65f0790UL;
   tf->codes[18195] = 0x0006d07ec5fb3959UL;
   tf->codes[18196] = 0x0006d0c0a6e1b6f9UL;
   tf->codes[18197] = 0x0006d0d27e7578ffUL;
   tf->codes[18198] = 0x0006d1071af4a7fdUL;
   tf->codes[18199] = 0x0006d14d5478933cUL;
   tf->codes[18200] = 0x0006d1755c3d84e7UL;
   tf->codes[18201] = 0x0006d1dab1bc80ceUL;
   tf->codes[18202] = 0x0006d1ee985776c1UL;
   tf->codes[18203] = 0x0006d1fa0846973bUL;
   tf->codes[18204] = 0x0006d2183a0590cfUL;
   tf->codes[18205] = 0x0006d243b02bd905UL;
   tf->codes[18206] = 0x0006d24b3c9b976aUL;
   tf->codes[18207] = 0x0006d270108e384fUL;
   tf->codes[18208] = 0x0006d2725a247201UL;
   tf->codes[18209] = 0x0006d279e6943066UL;
   tf->codes[18210] = 0x0006d2de51d71539UL;
   tf->codes[18211] = 0x0006d2e1c0386bc4UL;
   tf->codes[18212] = 0x0006d2e912192464UL;
   tf->codes[18213] = 0x0006d2f322ae2240UL;
   tf->codes[18214] = 0x0006d31537ec7de9UL;
   tf->codes[18215] = 0x0006d31955fae5c3UL;
   tf->codes[18216] = 0x0006d3383766f0a6UL;
   tf->codes[18217] = 0x0006d35c963b8601UL;
   tf->codes[18218] = 0x0006d36d0e752569UL;
   tf->codes[18219] = 0x0006d36dbe2236b8UL;
   tf->codes[18220] = 0x0006d389a64af69aUL;
   tf->codes[18221] = 0x0006d394dbab114fUL;
   tf->codes[18222] = 0x0006d3c72e94069bUL;
   tf->codes[18223] = 0x0006d3cbfc4f7fc4UL;
   tf->codes[18224] = 0x0006d3d08f7bf328UL;
   tf->codes[18225] = 0x0006d3e8942550f5UL;
   tf->codes[18226] = 0x0006d4039211f9c3UL;
   tf->codes[18227] = 0x0006d4907a37dbcbUL;
   tf->codes[18228] = 0x0006d49f588852d0UL;
   tf->codes[18229] = 0x0006d4bc657c2f8bUL;
   tf->codes[18230] = 0x0006d4cb43cca690UL;
   tf->codes[18231] = 0x0006d4d9acff120bUL;
   tf->codes[18232] = 0x0006d4dce0d162d1UL;
   tf->codes[18233] = 0x0006d4e5920c3e0fUL;
   tf->codes[18234] = 0x0006d5001adadb53UL;
   tf->codes[18235] = 0x0006d53407acf902UL;
   tf->codes[18236] = 0x0006d54828d6f4baUL;
   tf->codes[18237] = 0x0006d56dac76a6eeUL;
   tf->codes[18238] = 0x0006d58a444c781fUL;
   tf->codes[18239] = 0x0006d58c18c4a647UL;
   tf->codes[18240] = 0x0006d591962d30bfUL;
   tf->codes[18241] = 0x0006d59fc4d09675UL;
   tf->codes[18242] = 0x0006d5bdf68f9009UL;
   tf->codes[18243] = 0x0006d5d252489186UL;
   tf->codes[18244] = 0x0006d6108a3eb2d6UL;
   tf->codes[18245] = 0x0006d65cb6493417UL;
   tf->codes[18246] = 0x0006d666c6de31f3UL;
   tf->codes[18247] = 0x0006d68f43c12f28UL;
   tf->codes[18248] = 0x0006d69152c86315UL;
   tf->codes[18249] = 0x0006d6ba0a3a660fUL;
   tf->codes[18250] = 0x0006d6cb322116c6UL;
   tf->codes[18251] = 0x0006d6dccf25d307UL;
   tf->codes[18252] = 0x0006d74642b336c8UL;
   tf->codes[18253] = 0x0006d74b4afdb5b6UL;
   tf->codes[18254] = 0x0006d7647472305cUL;
   tf->codes[18255] = 0x0006d76b8bc3e337UL;
   tf->codes[18256] = 0x0006d777ab601500UL;
   tf->codes[18257] = 0x0006d7cf4759b6bbUL;
   tf->codes[18258] = 0x0006d7d2409d01bcUL;
   tf->codes[18259] = 0x0006d7e69c560339UL;
   tf->codes[18260] = 0x0006d7f6da009cdcUL;
   tf->codes[18261] = 0x0006d80d44c0d246UL;
   tf->codes[18262] = 0x0006d8150bbf9670UL;
   tf->codes[18263] = 0x0006d83218b3732bUL;
   tf->codes[18264] = 0x0006d841a6b0fb7fUL;
   tf->codes[18265] = 0x0006d87c35b6c07fUL;
   tf->codes[18266] = 0x0006d87e44bdf46cUL;
   tf->codes[18267] = 0x0006d89efaa22d77UL;
   tf->codes[18268] = 0x0006d8c443b2d9e6UL;
   tf->codes[18269] = 0x0006d8db98af2664UL;
   tf->codes[18270] = 0x0006d8dc485c37b3UL;
   tf->codes[18271] = 0x0006d8e5342618b6UL;
   tf->codes[18272] = 0x0006d8f23dfe6193UL;
   tf->codes[18273] = 0x0006d8f9ca6e1ff8UL;
   tf->codes[18274] = 0x0006d910e4db66b1UL;
   tf->codes[18275] = 0x0006d91a80525903UL;
   tf->codes[18276] = 0x0006d91c1a3b8166UL;
   tf->codes[18277] = 0x0006d93bab549d98UL;
   tf->codes[18278] = 0x0006d94212f93f24UL;
   tf->codes[18279] = 0x0006d953ea8d012aUL;
   tf->codes[18280] = 0x0006d96fd2b5c10cUL;
   tf->codes[18281] = 0x0006d98259f69461UL;
   tf->codes[18282] = 0x0006d9984f98be41UL;
   tf->codes[18283] = 0x0006d9c9b8459c79UL;
   tf->codes[18284] = 0x0006d9dd9ee0926cUL;
   tf->codes[18285] = 0x0006da14fa1406a6UL;
   tf->codes[18286] = 0x0006da1d3630d65aUL;
   tf->codes[18287] = 0x0006da3ffb1c4352UL;
   tf->codes[18288] = 0x0006da4453b9b0f1UL;
   tf->codes[18289] = 0x0006da4a464046f3UL;
   tf->codes[18290] = 0x0006da5038c6dcf5UL;
   tf->codes[18291] = 0x0006da9c9f6063fbUL;
   tf->codes[18292] = 0x0006da9e73d89223UL;
   tf->codes[18293] = 0x0006dab7282f013fUL;
   tf->codes[18294] = 0x0006dadfdfa10439UL;
   tf->codes[18295] = 0x0006dae597989476UL;
   tf->codes[18296] = 0x0006dae81bbdd3edUL;
   tf->codes[18297] = 0x0006daee48d36fb4UL;
   tf->codes[18298] = 0x0006daf4b0781140UL;
   tf->codes[18299] = 0x0006daf7e44a6206UL;
   tf->codes[18300] = 0x0006db64c6391c52UL;
   tf->codes[18301] = 0x0006db6d7773f790UL;
   tf->codes[18302] = 0x0006db7c9053745aUL;
   tf->codes[18303] = 0x0006db82f7f815e6UL;
   tf->codes[18304] = 0x0006db8a8467d44bUL;
   tf->codes[18305] = 0x0006dbdeec8f2540UL;
   tf->codes[18306] = 0x0006dc06b9c51126UL;
   tf->codes[18307] = 0x0006dc49fa05b164UL;
   tf->codes[18308] = 0x0006dc57ee1a1155UL;
   tf->codes[18309] = 0x0006dc6482d44ea8UL;
   tf->codes[18310] = 0x0006dc68a0e2b682UL;
   tf->codes[18311] = 0x0006dc8fbe6b9119UL;
   tf->codes[18312] = 0x0006dcd6a79c8da7UL;
   tf->codes[18313] = 0x0006dcdc5f941de4UL;
   tf->codes[18314] = 0x0006dcf080be199cUL;
   tf->codes[18315] = 0x0006dd0d1893eacdUL;
   tf->codes[18316] = 0x0006dd0eb27d1330UL;
   tf->codes[18317] = 0x0006dd52a26ac4bdUL;
   tf->codes[18318] = 0x0006dd710eb8c416UL;
   tf->codes[18319] = 0x0006dd7dde02072eUL;
   tf->codes[18320] = 0x0006dd877978f980UL;
   tf->codes[18321] = 0x0006dd9de4392eeaUL;
   tf->codes[18322] = 0x0006ddbdea7056a6UL;
   tf->codes[18323] = 0x0006ddc48ca3fdf7UL;
   tf->codes[18324] = 0x0006ddcc53a2c221UL;
   tf->codes[18325] = 0x0006ddf4d085bf56UL;
   tf->codes[18326] = 0x0006de15fb8803ebUL;
   tf->codes[18327] = 0x0006de1d4d68bc8bUL;
   tf->codes[18328] = 0x0006de358ca1201dUL;
   tf->codes[18329] = 0x0006de41371f465cUL;
   tf->codes[18330] = 0x0006de70cb53f66cUL;
   tf->codes[18331] = 0x0006de74744452bcUL;
   tf->codes[18332] = 0x0006de7fa9a46d71UL;
   tf->codes[18333] = 0x0006dec8a1dc9decUL;
   tf->codes[18334] = 0x0006df1a10c0a3e0UL;
   tf->codes[18335] = 0x0006df47d07d25c8UL;
   tf->codes[18336] = 0x0006df580e27bf6bUL;
   tf->codes[18337] = 0x0006df69ab2c7bacUL;
   tf->codes[18338] = 0x0006df7c6cfc54c6UL;
   tf->codes[18339] = 0x0006df934cda95baUL;
   tf->codes[18340] = 0x0006df9b4e685fa9UL;
   tf->codes[18341] = 0x0006dfea39272626UL;
   tf->codes[18342] = 0x0006dffe1fc21c19UL;
   tf->codes[18343] = 0x0006e008305719f5UL;
   tf->codes[18344] = 0x0006e01992ccd071UL;
   tf->codes[18345] = 0x0006e044ce6412e2UL;
   tf->codes[18346] = 0x0006e055bbbbbdd4UL;
   tf->codes[18347] = 0x0006e084dad2625aUL;
   tf->codes[18348] = 0x0006e09b80219d89UL;
   tf->codes[18349] = 0x0006e09d1a0ac5ecUL;
   tf->codes[18350] = 0x0006e0a3f6cd7302UL;
   tf->codes[18351] = 0x0006e0c6f647e5bfUL;
   tf->codes[18352] = 0x0006e0ce0d99989aUL;
   tf->codes[18353] = 0x0006e0e56295e518UL;
   tf->codes[18354] = 0x0006e0fd673f42e5UL;
   tf->codes[18355] = 0x0006e10cbaadc574UL;
   tf->codes[18356] = 0x0006e11272a555b1UL;
   tf->codes[18357] = 0x0006e171607fb00cUL;
   tf->codes[18358] = 0x0006e17dbaaae79aUL;
   tf->codes[18359] = 0x0006e183e7c08361UL;
   tf->codes[18360] = 0x0006e1875621d9ecUL;
   tf->codes[18361] = 0x0006e199a2d3a77cUL;
   tf->codes[18362] = 0x0006e1c010af70c4UL;
   tf->codes[18363] = 0x0006e1d46c687241UL;
   tf->codes[18364] = 0x0006e1fdd387868aUL;
   tf->codes[18365] = 0x0006e2017c77e2daUL;
   tf->codes[18366] = 0x0006e2373dc22eb1UL;
   tf->codes[18367] = 0x0006e270e28bdc9dUL;
   tf->codes[18368] = 0x0006e28b6b5a79e1UL;
   tf->codes[18369] = 0x0006e29b33e707faUL;
   tf->codes[18370] = 0x0006e2c16733cb7dUL;
   tf->codes[18371] = 0x0006e2da1b8a3a99UL;
   tf->codes[18372] = 0x0006e2fbf639907dUL;
   tf->codes[18373] = 0x0006e31ad7a59b60UL;
   tf->codes[18374] = 0x0006e3326730eda3UL;
   tf->codes[18375] = 0x0006e3438f179e5aUL;
   tf->codes[18376] = 0x0006e34897621d48UL;
   tf->codes[18377] = 0x0006e34c7ae17f5dUL;
   tf->codes[18378] = 0x0006e359f9d7d3c4UL;
   tf->codes[18379] = 0x0006e37482a67108UL;
   tf->codes[18380] = 0x0006e37706cbb07fUL;
   tf->codes[18381] = 0x0006e38e5bc7fcfdUL;
   tf->codes[18382] = 0x0006e3cabf45f025UL;
   tf->codes[18383] = 0x0006e3d8b35a5016UL;
   tf->codes[18384] = 0x0006e3e214423ca3UL;
   tf->codes[18385] = 0x0006e41c2e29f619UL;
   tf->codes[18386] = 0x0006e438c5ffc74aUL;
   tf->codes[18387] = 0x0006e45e0f1073b9UL;
   tf->codes[18388] = 0x0006e46fac152ffaUL;
   tf->codes[18389] = 0x0006e498d8a53e7eUL;
   tf->codes[18390] = 0x0006e4c3648f6fa0UL;
   tf->codes[18391] = 0x0006e53cdb38673fUL;
   tf->codes[18392] = 0x0006e542932ff77cUL;
   tf->codes[18393] = 0x0006e547d6097c2fUL;
   tf->codes[18394] = 0x0006e54ca3c4f558UL;
   tf->codes[18395] = 0x0006e598cfcf7699UL;
   tf->codes[18396] = 0x0006e5bf783a45a6UL;
   tf->codes[18397] = 0x0006e5c68f8bf881UL;
   tf->codes[18398] = 0x0006e5d1c4ec1336UL;
   tf->codes[18399] = 0x0006e5d82c90b4c2UL;
   tf->codes[18400] = 0x0006e5decec45c13UL;
   tf->codes[18401] = 0x0006e5f0e0e723deUL;
   tf->codes[18402] = 0x0006e5fd008355a7UL;
   tf->codes[18403] = 0x0006e61196cb5ce9UL;
   tf->codes[18404] = 0x0006e61f8adfbcdaUL;
   tf->codes[18405] = 0x0006e64e34d855d6UL;
   tf->codes[18406] = 0x0006e66accae2707UL;
   tf->codes[18407] = 0x0006e67468251959UL;
   tf->codes[18408] = 0x0006e67eedd822bfUL;
   tf->codes[18409] = 0x0006e68c323f7161UL;
   tf->codes[18410] = 0x0006e6cd9e07e377UL;
   tf->codes[18411] = 0x0006e6cf7280119fUL;
   tf->codes[18412] = 0x0006e702afa51dffUL;
   tf->codes[18413] = 0x0006e72cc6714397UL;
   tf->codes[18414] = 0x0006e74037ee2e00UL;
   tf->codes[18415] = 0x0006e78a54f17b54UL;
   tf->codes[18416] = 0x0006e7921bf03f7eUL;
   tf->codes[18417] = 0x0006e7958a519609UL;
   tf->codes[18418] = 0x0006e7c0c5e8d87aUL;
   tf->codes[18419] = 0x0006e7c593a451a3UL;
   tf->codes[18420] = 0x0006e7e3fff250fcUL;
   tf->codes[18421] = 0x0006e7e60ef984e9UL;
   tf->codes[18422] = 0x0006e7eb8c620f61UL;
   tf->codes[18423] = 0x0006e809f8b00ebaUL;
   tf->codes[18424] = 0x0006e80b9299371dUL;
   tf->codes[18425] = 0x0006e84487b5d3baUL;
   tf->codes[18426] = 0x0006e8486b3535cfUL;
   tf->codes[18427] = 0x0006e84b9f078695UL;
   tf->codes[18428] = 0x0006e8f67e5d5c6cUL;
   tf->codes[18429] = 0x0006e9117c4a053aUL;
   tf->codes[18430] = 0x0006e937ea25ce82UL;
   tf->codes[18431] = 0x0006e940d5efaf85UL;
   tf->codes[18432] = 0x0006e944f3fe175fUL;
   tf->codes[18433] = 0x0006e9677e5a7e92UL;
   tf->codes[18434] = 0x0006e996d80028ddUL;
   tf->codes[18435] = 0x0006e9b66919450fUL;
   tf->codes[18436] = 0x0006e9bb7163c3fdUL;
   tf->codes[18437] = 0x0006e9c50cdab64fUL;
   tf->codes[18438] = 0x0006e9ccd3d97a79UL;
   tf->codes[18439] = 0x0006e9fb43430db0UL;
   tf->codes[18440] = 0x0006ea0d1ad6cfb6UL;
   tf->codes[18441] = 0x0006ea4057fbdc16UL;
   tf->codes[18442] = 0x0006ea543e96d209UL;
   tf->codes[18443] = 0x0006ea559df0f4a7UL;
   tf->codes[18444] = 0x0006ea7aac729b51UL;
   tf->codes[18445] = 0x0006ea7e1ad3f1dcUL;
   tf->codes[18446] = 0x0006ea7f7a2e147aUL;
   tf->codes[18447] = 0x0006eaf07a2b36a0UL;
   tf->codes[18448] = 0x0006eaf8069af505UL;
   tf->codes[18449] = 0x0006eb0bb2a6e533UL;
   tf->codes[18450] = 0x0006eb24a18c5a14UL;
   tf->codes[18451] = 0x0006eb57deb16674UL;
   tf->codes[18452] = 0x0006eb5b87a1c2c4UL;
   tf->codes[18453] = 0x0006eb5f6b2124d9UL;
   tf->codes[18454] = 0x0006eb7351bc1accUL;
   tf->codes[18455] = 0x0006eb77e4e88e30UL;
   tf->codes[18456] = 0x0006eb9566fa7675UL;
   tf->codes[18457] = 0x0006eb989accc73bUL;
   tf->codes[18458] = 0x0006eb9c43bd238bUL;
   tf->codes[18459] = 0x0006ebc98e5b99e9UL;
   tf->codes[18460] = 0x0006ebd0e03c5289UL;
   tf->codes[18461] = 0x0006ebdd74f68fdcUL;
   tf->codes[18462] = 0x0006ebed02f41830UL;
   tf->codes[18463] = 0x0006ebf48f63d695UL;
   tf->codes[18464] = 0x0006ec4ca07b83daUL;
   tf->codes[18465] = 0x0006ec67d8f7326dUL;
   tf->codes[18466] = 0x0006ec6ad23a7d6eUL;
   tf->codes[18467] = 0x0006eccc7ec91d05UL;
   tf->codes[18468] = 0x0006ecd1fc31a77dUL;
   tf->codes[18469] = 0x0006ece866f1dce7UL;
   tf->codes[18470] = 0x0006ecf7ba605f76UL;
   tf->codes[18471] = 0x0006ecfd7257efb3UL;
   tf->codes[18472] = 0x0006ed027aa26ea1UL;
   tf->codes[18473] = 0x0006ed053956b3ddUL;
   tf->codes[18474] = 0x0006ed1af469d7f8UL;
   tf->codes[18475] = 0x0006ed36a2039215UL;
   tf->codes[18476] = 0x0006ed47c9ea42ccUL;
   tf->codes[18477] = 0x0006ed737a9f90c7UL;
   tf->codes[18478] = 0x0006ed858cc25892UL;
   tf->codes[18479] = 0x0006ed9c321193c1UL;
   tf->codes[18480] = 0x0006edcb8bb73e0cUL;
   tf->codes[18481] = 0x0006ededdb849f7aUL;
   tf->codes[18482] = 0x0006edf2e3cf1e68UL;
   tf->codes[18483] = 0x0006ee1483ef6e87UL;
   tf->codes[18484] = 0x0006ee3957e20f6cUL;
   tf->codes[18485] = 0x0006ee5b32916550UL;
   tf->codes[18486] = 0x0006ee678cbc9cdeUL;
   tf->codes[18487] = 0x0006ee76307e0e1eUL;
   tf->codes[18488] = 0x0006ee7a4e8c75f8UL;
   tf->codes[18489] = 0x0006ee9a1a3497efUL;
   tf->codes[18490] = 0x0006ee9dc324f43fUL;
   tf->codes[18491] = 0x0006eec79f621412UL;
   tf->codes[18492] = 0x0006eed7a27da7f0UL;
   tf->codes[18493] = 0x0006eee2d7ddc2a5UL;
   tf->codes[18494] = 0x0006eeea29be7b45UL;
   tf->codes[18495] = 0x0006eef35017620dUL;
   tf->codes[18496] = 0x0006ef164f91d4caUL;
   tf->codes[18497] = 0x0006ef1c7ca77091UL;
   tf->codes[18498] = 0x0006ef4ab181fe03UL;
   tf->codes[18499] = 0x0006ef53282dd37cUL;
   tf->codes[18500] = 0x0006ef5c13f7b47fUL;
   tf->codes[18501] = 0x0006ef6bdc844298UL;
   tf->codes[18502] = 0x0006ef74c84e239bUL;
   tf->codes[18503] = 0x0006ef769cc651c3UL;
   tf->codes[18504] = 0x0006ef7920eb913aUL;
   tf->codes[18505] = 0x0006ef7d3ef9f914UL;
   tf->codes[18506] = 0x0006efc07f3a9952UL;
   tf->codes[18507] = 0x0006efd4daf39acfUL;
   tf->codes[18508] = 0x0006f00ce5d42058UL;
   tf->codes[18509] = 0x0006f01d5e0dbfc0UL;
   tf->codes[18510] = 0x0006f044b625a01cUL;
   tf->codes[18511] = 0x0006f04aa8ac361eUL;
   tf->codes[18512] = 0x0006f088a61351a9UL;
   tf->codes[18513] = 0x0006f0aed960152cUL;
   tf->codes[18514] = 0x0006f0c24adcff95UL;
   tf->codes[18515] = 0x0006f0d2c3169efdUL;
   tf->codes[18516] = 0x0006f0f8f6636280UL;
   tf->codes[18517] = 0x0006f0ff5e08040cUL;
   tf->codes[18518] = 0x0006f104665282faUL;
   tf->codes[18519] = 0x0006f11f9ece318dUL;
   tf->codes[18520] = 0x0006f12ca8a67a6aUL;
   tf->codes[18521] = 0x0006f1610a96a3a3UL;
   tf->codes[18522] = 0x0006f1773ac7d348UL;
   tf->codes[18523] = 0x0006f1aed08a4d47UL;
   tf->codes[18524] = 0x0006f1bc14f19be9UL;
   tf->codes[18525] = 0x0006f1c0e2ad1512UL;
   tf->codes[18526] = 0x0006f1c784e0bc63UL;
   tf->codes[18527] = 0x0006f1cf866e8652UL;
   tf->codes[18528] = 0x0006f1e3e22787cfUL;
   tf->codes[18529] = 0x0006f2087b8b22efUL;
   tf->codes[18530] = 0x0006f219a371d3a6UL;
   tf->codes[18531] = 0x0006f21c2797131dUL;
   tf->codes[18532] = 0x0006f2425ae3d6a0UL;
   tf->codes[18533] = 0x0006f24b0c1eb1deUL;
   tf->codes[18534] = 0x0006f25850860080UL;
   tf->codes[18535] = 0x0006f26cac3f01fdUL;
   tf->codes[18536] = 0x0006f26f6af34739UL;
   tf->codes[18537] = 0x0006f2776c811128UL;
   tf->codes[18538] = 0x0006f278cbdb33c6UL;
   tf->codes[18539] = 0x0006f27fe32ce6a1UL;
   tf->codes[18540] = 0x0006f29c7b02b7d2UL;
   tf->codes[18541] = 0x0006f2c064b941a3UL;
   tf->codes[18542] = 0x0006f2ce935ca759UL;
   tf->codes[18543] = 0x0006f33d49c38fcdUL;
   tf->codes[18544] = 0x0006f3400877d509UL;
   tf->codes[18545] = 0x0006f34585e05f81UL;
   tf->codes[18546] = 0x0006f3492ed0bbd1UL;
   tf->codes[18547] = 0x0006f364dc6a75eeUL;
   tf->codes[18548] = 0x0006f36c2e4b2e8eUL;
   tf->codes[18549] = 0x0006f3704c599668UL;
   tf->codes[18550] = 0x0006f383bdd680d1UL;
   tf->codes[18551] = 0x0006f38d594d7323UL;
   tf->codes[18552] = 0x0006f3c947ad5ac1UL;
   tf->codes[18553] = 0x0006f3d1be59303aUL;
   tf->codes[18554] = 0x0006f3eb225cb0a5UL;
   tf->codes[18555] = 0x0006f3eb977abc2fUL;
   tf->codes[18556] = 0x0006f3ecbc45d908UL;
   tf->codes[18557] = 0x0006f475113f47acUL;
   tf->codes[18558] = 0x0006f476360a6485UL;
   tf->codes[18559] = 0x0006f47c2890fa87UL;
   tf->codes[18560] = 0x0006f4c9796698a1UL;
   tf->codes[18561] = 0x0006f507ebebbfb6UL;
   tf->codes[18562] = 0x0006f51f0659066fUL;
   tf->codes[18563] = 0x0006f55ed8385022UL;
   tf->codes[18564] = 0x0006f58ac37ca3e2UL;
   tf->codes[18565] = 0x0006f5c5c7a0746cUL;
   tf->codes[18566] = 0x0006f5d84ee147c1UL;
   tf->codes[18567] = 0x0006f5e6f2a2b901UL;
   tf->codes[18568] = 0x0006f606f8d9e0bdUL;
   tf->codes[18569] = 0x0006f60e102b9398UL;
   tf->codes[18570] = 0x0006f61477d03524UL;
   tf->codes[18571] = 0x0006f654843e849cUL;
   tf->codes[18572] = 0x0006f68159beef70UL;
   tf->codes[18573] = 0x0006f6ac955631e1UL;
   tf->codes[18574] = 0x0006f6d2c8a2f564UL;
   tf->codes[18575] = 0x0006f6d3785006b3UL;
   tf->codes[18576] = 0x0006f6d80b7c7a17UL;
   tf->codes[18577] = 0x0006f6e0bcb75555UL;
   tf->codes[18578] = 0x0006f6fa5b49db85UL;
   tf->codes[18579] = 0x0006f7193cb5e668UL;
   tf->codes[18580] = 0x0006f71bc0db25dfUL;
   tf->codes[18581] = 0x0006f7405a3ec0ffUL;
   tf->codes[18582] = 0x0006f7422eb6ef27UL;
   tf->codes[18583] = 0x0006f74687545cc6UL;
   tf->codes[18584] = 0x0006f74c79daf2c8UL;
   tf->codes[18585] = 0x0006f7564fe0eadfUL;
   tf->codes[18586] = 0x0006f76cbaa12049UL;
   tf->codes[18587] = 0x0006f7babb23cfb2UL;
   tf->codes[18588] = 0x0006f7ca0e925241UL;
   tf->codes[18589] = 0x0006f7d210201c30UL;
   tf->codes[18590] = 0x0006f7d494455ba7UL;
   tf->codes[18591] = 0x0006f7ed0e0cc4feUL;
   tf->codes[18592] = 0x0006f7eee284f326UL;
   tf->codes[18593] = 0x0006f7f45fed7d9eUL;
   tf->codes[18594] = 0x0006f7f584b89a77UL;
   tf->codes[18595] = 0x0006f7fe35f375b5UL;
   tf->codes[18596] = 0x0006f81a58ab3b5cUL;
   tf->codes[18597] = 0x0006f81b42e75270UL;
   tf->codes[18598] = 0x0006f81bf29463bfUL;
   tf->codes[18599] = 0x0006f8434aac441bUL;
   tf->codes[18600] = 0x0006f858cb306271UL;
   tf->codes[18601] = 0x0006f891fadc04d3UL;
   tf->codes[18602] = 0x0006f8986280a65fUL;
   tf->codes[18603] = 0x0006f89eca2547ebUL;
   tf->codes[18604] = 0x0006f8c15481af1eUL;
   tf->codes[18605] = 0x0006f8eed9af2b41UL;
   tf->codes[18606] = 0x0006f943b6f487c0UL;
   tf->codes[18607] = 0x0006f9472555de4bUL;
   tf->codes[18608] = 0x0006f9484a20fb24UL;
   tf->codes[18609] = 0x0006f95b467fda03UL;
   tf->codes[18610] = 0x0006f9701756e70aUL;
   tf->codes[18611] = 0x0006f9c14babe739UL;
   tf->codes[18612] = 0x0006f9f697d82786UL;
   tf->codes[18613] = 0x0006f9f9cbaa784cUL;
   tf->codes[18614] = 0x0006fa7b7e703f9fUL;
   tf->codes[18615] = 0x0006fac9f410fa92UL;
   tf->codes[18616] = 0x0006facade4d11a6UL;
   tf->codes[18617] = 0x0006fad773074ef9UL;
   tf->codes[18618] = 0x0006fad9f72c8e70UL;
   tf->codes[18619] = 0x0006faf73eaf70f0UL;
   tf->codes[18620] = 0x0006fafc46f9efdeUL;
   tf->codes[18621] = 0x0006fb1d71fc3473UL;
   tf->codes[18622] = 0x0006fb4a820ba50cUL;
   tf->codes[18623] = 0x0006fb5074923b0eUL;
   tf->codes[18624] = 0x0006fb666a3464eeUL;
   tf->codes[18625] = 0x0006fbe64881fe19UL;
   tf->codes[18626] = 0x0006fbed5fd3b0f4UL;
   tf->codes[18627] = 0x0006fc2ae81cc0f5UL;
   tf->codes[18628] = 0x0006fc3a00fc3dbfUL;
   tf->codes[18629] = 0x0006fc4d37ea2263UL;
   tf->codes[18630] = 0x0006fc627ddf3af4UL;
   tf->codes[18631] = 0x0006fc678629b9e2UL;
   tf->codes[18632] = 0x0006fc8a10862115UL;
   tf->codes[18633] = 0x0006fcd1e3f334b7UL;
   tf->codes[18634] = 0x0006fcd293a04606UL;
   tf->codes[18635] = 0x0006fcd58ce39107UL;
   tf->codes[18636] = 0x0006fd405fcb1766UL;
   tf->codes[18637] = 0x0006fd47ec3ad5cbUL;
   tf->codes[18638] = 0x0006fd4b200d2691UL;
   tf->codes[18639] = 0x0006fd4f78aa9430UL;
   tf->codes[18640] = 0x0006fd5f06a81c84UL;
   tf->codes[18641] = 0x0006fd8833382b08UL;
   tf->codes[18642] = 0x0006fdbd44d56590UL;
   tf->codes[18643] = 0x0006fdc1d801d8f4UL;
   tf->codes[18644] = 0x0006fdcf1c692796UL;
   tf->codes[18645] = 0x0006fdd8f26f1fadUL;
   tf->codes[18646] = 0x0006fdf21be39a53UL;
   tf->codes[18647] = 0x0006fe5b1a52f28aUL;
   tf->codes[18648] = 0x0006fe7861d5d50aUL;
   tf->codes[18649] = 0x0006fe839735efbfUL;
   tf->codes[18650] = 0x0006fe9c10fd5916UL;
   tf->codes[18651] = 0x0006febb67876f83UL;
   tf->codes[18652] = 0x0006febd3bff9dabUL;
   tf->codes[18653] = 0x0006fec502fe61d5UL;
   tf->codes[18654] = 0x0006feca0b48e0c3UL;
   tf->codes[18655] = 0x0006feca45d7e688UL;
   tf->codes[18656] = 0x0006fecabaf5f212UL;
   tf->codes[18657] = 0x0006fef66bab400dUL;
   tf->codes[18658] = 0x0006ff3bbaf31438UL;
   tf->codes[18659] = 0x0006ff44a6bcf53bUL;
   tf->codes[18660] = 0x0006ff48c4cb5d15UL;
   tf->codes[18661] = 0x0006ff4ca84abf2aUL;
   tf->codes[18662] = 0x0006ff4f66ff0466UL;
   tf->codes[18663] = 0x0006ff567e50b741UL;
   tf->codes[18664] = 0x0006ff63130af494UL;
   tf->codes[18665] = 0x0006ff6dd34d03bfUL;
   tf->codes[18666] = 0x0006ffc116a937dbUL;
   tf->codes[18667] = 0x0006ffc39ace7752UL;
   tf->codes[18668] = 0x0006ffd02f88b4a5UL;
   tf->codes[18669] = 0x0006ffdaefcac3d0UL;
   tf->codes[18670] = 0x0006fffabb72e5c7UL;
   tf->codes[18671] = 0x000700546673bb6fUL;
   tf->codes[18672] = 0x0007005ace185cfbUL;
   tf->codes[18673] = 0x00070061704c044cUL;
   tf->codes[18674] = 0x00070094e8001671UL;
   tf->codes[18675] = 0x000700deca745e00UL;
   tf->codes[18676] = 0x000700e3d2bedceeUL;
   tf->codes[18677] = 0x000700e77baf393eUL;
   tf->codes[18678] = 0x000701106db041fdUL;
   tf->codes[18679] = 0x000701153b6bbb26UL;
   tf->codes[18680] = 0x000701445a825facUL;
   tf->codes[18681] = 0x000701450a2f70fbUL;
   tf->codes[18682] = 0x000701480372bbfcUL;
   tf->codes[18683] = 0x0007016dfc3079baUL;
   tf->codes[18684] = 0x00070175c32f3de4UL;
   tf->codes[18685] = 0x0007018c2def734eUL;
   tf->codes[18686] = 0x0007019bf67c0167UL;
   tf->codes[18687] = 0x000701f94a6d335fUL;
   tf->codes[18688] = 0x000701ffb211d4ebUL;
   tf->codes[18689] = 0x000702406e2d35b2UL;
   tf->codes[18690] = 0x0007024a7ec2338eUL;
   tf->codes[18691] = 0x00070267c645160eUL;
   tf->codes[18692] = 0x000702757fca703aUL;
   tf->codes[18693] = 0x00070281d9f5a7c8UL;
   tf->codes[18694] = 0x00070289db8371b7UL;
   tf->codes[18695] = 0x0007028e6eafe51bUL;
   tf->codes[18696] = 0x000702980a26d76dUL;
   tf->codes[18697] = 0x0007029f969695d2UL;
   tf->codes[18698] = 0x000702c6b41f7069UL;
   tf->codes[18699] = 0x000702d25e9d96a8UL;
   tf->codes[18700] = 0x000702de43aac2acUL;
   tf->codes[18701] = 0x000702f81ccc4ea1UL;
   tf->codes[18702] = 0x000702fe0f52e4a3UL;
   tf->codes[18703] = 0x0007030526a4977eUL;
   tf->codes[18704] = 0x000703097f42051dUL;
   tf->codes[18705] = 0x0007034d34a0b0e5UL;
   tf->codes[18706] = 0x00070352777a3598UL;
   tf->codes[18707] = 0x000703632a42dac5UL;
   tf->codes[18708] = 0x0007036a7c239365UL;
   tf->codes[18709] = 0x00070398b0fe20d7UL;
   tf->codes[18710] = 0x000703cdc29b5b5fUL;
   tf->codes[18711] = 0x000703d29056d488UL;
   tf->codes[18712] = 0x000703e810daf2deUL;
   tf->codes[18713] = 0x000703ffa0664521UL;
   tf->codes[18714] = 0x000704689ed59d58UL;
   tf->codes[18715] = 0x0007047cfa8e9ed5UL;
   tf->codes[18716] = 0x00070485abc97a13UL;
   tf->codes[18717] = 0x0007048e97935b16UL;
   tf->codes[18718] = 0x000704939fddda04UL;
   tf->codes[18719] = 0x000704dd47c31bceUL;
   tf->codes[18720] = 0x000704e8429430beUL;
   tf->codes[18721] = 0x000704ef59e5e399UL;
   tf->codes[18722] = 0x000704f4d74e6e11UL;
   tf->codes[18723] = 0x000705497a04c4cbUL;
   tf->codes[18724] = 0x00070555d42ffc59UL;
   tf->codes[18725] = 0x00070565d74b9037UL;
   tf->codes[18726] = 0x00070567abc3be5fUL;
   tf->codes[18727] = 0x000705785e8c638cUL;
   tf->codes[18728] = 0x000705847e289555UL;
   tf->codes[18729] = 0x0007059e1cbb1b85UL;
   tf->codes[18730] = 0x000705b7f5dca77aUL;
   tf->codes[18731] = 0x000705d1946f2daaUL;
   tf->codes[18732] = 0x000705d8abc0e085UL;
   tf->codes[18733] = 0x00070611a0dd7d22UL;
   tf->codes[18734] = 0x00070613ea73b6d4UL;
   tf->codes[18735] = 0x00070641e4bf3e81UL;
   tf->codes[18736] = 0x0007065e7c950fb2UL;
   tf->codes[18737] = 0x0007066f2f5db4dfUL;
   tf->codes[18738] = 0x00070674e755451cUL;
   tf->codes[18739] = 0x00070678cad4a731UL;
   tf->codes[18740] = 0x000706c32266fa4aUL;
   tf->codes[18741] = 0x000706ce92561ac4UL;
   tf->codes[18742] = 0x000706d0dbec5476UL;
   tf->codes[18743] = 0x000706d5e436d364UL;
   tf->codes[18744] = 0x000706da02453b3eUL;
   tf->codes[18745] = 0x000706daec815252UL;
   tf->codes[18746] = 0x000706f6d4aa1234UL;
   tf->codes[18747] = 0x0007073ac497c3c1UL;
   tf->codes[18748] = 0x0007073fcce242afUL;
   tf->codes[18749] = 0x0007075dfea13c43UL;
   tf->codes[18750] = 0x000707db58c995f7UL;
   tf->codes[18751] = 0x00070802b0e17653UL;
   tf->codes[18752] = 0x000708039b1d8d67UL;
   tf->codes[18753] = 0x0007081d743f195cUL;
   tf->codes[18754] = 0x0007083e9f415df1UL;
   tf->codes[18755] = 0x0007084edcebf794UL;
   tf->codes[18756] = 0x0007085076d51ff7UL;
   tf->codes[18757] = 0x000708792e4722f1UL;
   tf->codes[18758] = 0x000708d0ca40c4acUL;
   tf->codes[18759] = 0x000708eefbffbe40UL;
   tf->codes[18760] = 0x000708fc40670ce2UL;
   tf->codes[18761] = 0x0007091a72260676UL;
   tf->codes[18762] = 0x00070931177541a5UL;
   tf->codes[18763] = 0x0007093f4618a75bUL;
   tf->codes[18764] = 0x00070942ef0903abUL;
   tf->codes[18765] = 0x000709883e50d7d6UL;
   tf->codes[18766] = 0x0007098fcac0963bUL;
   tf->codes[18767] = 0x000709907a6da78aUL;
   tf->codes[18768] = 0x000709924ee5d5b2UL;
   tf->codes[18769] = 0x000709c4dc5dd0c3UL;
   tf->codes[18770] = 0x000709c63bb7f361UL;
   tf->codes[18771] = 0x000709ed93cfd3bdUL;
   tf->codes[18772] = 0x000709f55ace97e7UL;
   tf->codes[18773] = 0x000709f7def3d75eUL;
   tf->codes[18774] = 0x00070a0e0f250703UL;
   tf->codes[18775] = 0x00070a335835b372UL;
   tf->codes[18776] = 0x00070a3a34f86088UL;
   tf->codes[18777] = 0x00070a56ccce31b9UL;
   tf->codes[18778] = 0x00070a61c79f46a9UL;
   tf->codes[18779] = 0x00070a732a14fd25UL;
   tf->codes[18780] = 0x00070a78325f7c13UL;
   tf->codes[18781] = 0x00070a7ba0c0d29eUL;
   tf->codes[18782] = 0x00070a8033ed4602UL;
   tf->codes[18783] = 0x00070ab62fc6979eUL;
   tf->codes[18784] = 0x00070abd81a7503eUL;
   tf->codes[18785] = 0x00070ac12a97ac8eUL;
   tf->codes[18786] = 0x00070ac2c480d4f1UL;
   tf->codes[18787] = 0x00070b38ccc87605UL;
   tf->codes[18788] = 0x00070b4f7217b134UL;
   tf->codes[18789] = 0x00070b53cab51ed3UL;
   tf->codes[18790] = 0x00070b87426930f8UL;
   tf->codes[18791] = 0x00070b89517064e5UL;
   tf->codes[18792] = 0x00070bbc54066b80UL;
   tf->codes[18793] = 0x00070be71a7fa267UL;
   tf->codes[18794] = 0x00070c00f3a12e5cUL;
   tf->codes[18795] = 0x00070c03b2557398UL;
   tf->codes[18796] = 0x00070c1514cb2a14UL;
   tf->codes[18797] = 0x00070c1a9233b48cUL;
   tf->codes[18798] = 0x00070c2fd828cd1dUL;
   tf->codes[18799] = 0x00070c42d487abfcUL;
   tf->codes[18800] = 0x00070c4558aceb73UL;
   tf->codes[18801] = 0x00070c7f7294a4e9UL;
   tf->codes[18802] = 0x00070c8d2c19ff15UL;
   tf->codes[18803] = 0x00070cd4ff8712b7UL;
   tf->codes[18804] = 0x00070cd6d3ff40dfUL;
   tf->codes[18805] = 0x00070d0ededfc668UL;
   tf->codes[18806] = 0x00070d713b1b774eUL;
   tf->codes[18807] = 0x00070d7768311315UL;
   tf->codes[18808] = 0x00070d8c739725e1UL;
   tf->codes[18809] = 0x00070db4b5eb1d51UL;
   tf->codes[18810] = 0x00070dc9fbe035e2UL;
   tf->codes[18811] = 0x00070dca366f3ba7UL;
   tf->codes[18812] = 0x00070dd237fd0596UL;
   tf->codes[18813] = 0x00070dd40c7533beUL;
   tf->codes[18814] = 0x00070df5ac9583ddUL;
   tf->codes[18815] = 0x00070e195bbd07e9UL;
   tf->codes[18816] = 0x00070e1f4e439debUL;
   tf->codes[18817] = 0x00070e4c98e21449UL;
   tf->codes[18818] = 0x00070e7cdcc3d5a8UL;
   tf->codes[18819] = 0x00070e8d1a6e6f4bUL;
   tf->codes[18820] = 0x00070e9088cfc5d6UL;
   tf->codes[18821] = 0x00070ed6c253b115UL;
   tf->codes[18822] = 0x00070ed896cbdf3dUL;
   tf->codes[18823] = 0x00070ee566152255UL;
   tf->codes[18824] = 0x00070f48e71bf014UL;
   tf->codes[18825] = 0x00070f51d2e5d117UL;
   tf->codes[18826] = 0x00070f79daaac2c2UL;
   tf->codes[18827] = 0x00070fcef27f2506UL;
   tf->codes[18828] = 0x00070fdd5bb19081UL;
   tf->codes[18829] = 0x00070fdd96409646UL;
   tf->codes[18830] = 0x00070feb4fc5f072UL;
   tf->codes[18831] = 0x00070feebe2746fdUL;
   tf->codes[18832] = 0x00071011f830bf7fUL;
   tf->codes[18833] = 0x00071017007b3e6dUL;
   tf->codes[18834] = 0x0007101b93a7b1d1UL;
   tf->codes[18835] = 0x00071035a758438bUL;
   tf->codes[18836] = 0x0007104276a186a3UL;
   tf->codes[18837] = 0x0007104ab2be5657UL;
   tf->codes[18838] = 0x0007105ed3e8520fUL;
   tf->codes[18839] = 0x0007107c1b6b348fUL;
   tf->codes[18840] = 0x0007107ffeea96a4UL;
   tf->codes[18841] = 0x00071083a7daf2f4UL;
   tf->codes[18842] = 0x0007108e681d021fUL;
   tf->codes[18843] = 0x000710ad0efa073dUL;
   tf->codes[18844] = 0x000710d3f1f3dc0fUL;
   tf->codes[18845] = 0x000710fa5fcfa557UL;
   tf->codes[18846] = 0x0007111aa095d2d8UL;
   tf->codes[18847] = 0x0007111ebea43ab2UL;
   tf->codes[18848] = 0x00071137386ba409UL;
   tf->codes[18849] = 0x00071142a85ac483UL;
   tf->codes[18850] = 0x0007115e90838465UL;
   tf->codes[18851] = 0x000711995a184f2aUL;
   tf->codes[18852] = 0x000711c719d4d112UL;
   tf->codes[18853] = 0x000711cc5cae55c5UL;
   tf->codes[18854] = 0x000711cea6448f77UL;
   tf->codes[18855] = 0x00071206017803b1UL;
   tf->codes[18856] = 0x00071213806e5818UL;
   tf->codes[18857] = 0x00071219e812f9a4UL;
   tf->codes[18858] = 0x00071237a4b3e7aeUL;
   tf->codes[18859] = 0x000712455e3941daUL;
   tf->codes[18860] = 0x00071248920b92a0UL;
   tf->codes[18861] = 0x00071275678bfd74UL;
   tf->codes[18862] = 0x0007127d2e8ac19eUL;
   tf->codes[18863] = 0x0007127e8de4e43cUL;
   tf->codes[18864] = 0x0007128445dc7479UL;
   tf->codes[18865] = 0x000712870490b9b5UL;
   tf->codes[18866] = 0x000712ae2219944cUL;
   tf->codes[18867] = 0x000712ba7c44cbdaUL;
   tf->codes[18868] = 0x000712bd3af91116UL;
   tf->codes[18869] = 0x000712c920063d1aUL;
   tf->codes[18870] = 0x0007133a5a926505UL;
   tf->codes[18871] = 0x0007134d1c623e1fUL;
   tf->codes[18872] = 0x00071385d6efd4f7UL;
   tf->codes[18873] = 0x0007139982fbc525UL;
   tf->codes[18874] = 0x000713c2ea1ad96eUL;
   tf->codes[18875] = 0x000713c7f265585cUL;
   tf->codes[18876] = 0x000713f41838b1e1UL;
   tf->codes[18877] = 0x0007141801ef3bb2UL;
   tf->codes[18878] = 0x0007141d0a39baa0UL;
   tf->codes[18879] = 0x000714396780860cUL;
   tf->codes[18880] = 0x00071444d76fa686UL;
   tf->codes[18881] = 0x0007149bfe4b3cb7UL;
   tf->codes[18882] = 0x0007149cadf84e06UL;
   tf->codes[18883] = 0x000714d234b39418UL;
   tf->codes[18884] = 0x000714f743353ac2UL;
   tf->codes[18885] = 0x000714fcc09dc53aUL;
   tf->codes[18886] = 0x00071516d44e56f4UL;
   tf->codes[18887] = 0x0007154075fc7102UL;
   tf->codes[18888] = 0x0007155a89ad02bcUL;
   tf->codes[18889] = 0x000715b5ce9700c7UL;
   tf->codes[18890] = 0x000715ba27346e66UL;
   tf->codes[18891] = 0x000715c3881c5af3UL;
   tf->codes[18892] = 0x000715c76b9bbd08UL;
   tf->codes[18893] = 0x000715fa33a2bddeUL;
   tf->codes[18894] = 0x000716370c3ebc90UL;
   tf->codes[18895] = 0x000716515a7e540fUL;
   tf->codes[18896] = 0x0007166999b6b7a1UL;
   tf->codes[18897] = 0x000716819e60156eUL;
   tf->codes[18898] = 0x00071685475071beUL;
   tf->codes[18899] = 0x000716880604b6faUL;
   tf->codes[18900] = 0x0007168cd3c03023UL;
   tf->codes[18901] = 0x000716bca283e5f8UL;
   tf->codes[18902] = 0x000716c812730672UL;
   tf->codes[18903] = 0x000716c8879111fcUL;
   tf->codes[18904] = 0x000716d7a0708ec6UL;
   tf->codes[18905] = 0x000716d8ffcab164UL;
   tf->codes[18906] = 0x0007173c4642795eUL;
   tf->codes[18907] = 0x0007174273581525UL;
   tf->codes[18908] = 0x0007174de347359fUL;
   tf->codes[18909] = 0x000717523be4a33eUL;
   tf->codes[18910] = 0x0007176363cb53f5UL;
   tf->codes[18911] = 0x000717741693f922UL;
   tf->codes[18912] = 0x000717769ab93899UL;
   tf->codes[18913] = 0x0007177cc7ced460UL;
   tf->codes[18914] = 0x0007179be3c9e508UL;
   tf->codes[18915] = 0x0007179c58e7f092UL;
   tf->codes[18916] = 0x000717b37355374bUL;
   tf->codes[18917] = 0x000717c12cda9177UL;
   tf->codes[18918] = 0x000717c7947f3303UL;
   tf->codes[18919] = 0x000717d4d8e681a5UL;
   tf->codes[18920] = 0x000717dd4f92571eUL;
   tf->codes[18921] = 0x0007181bfca683f8UL;
   tf->codes[18922] = 0x000718338c31d63bUL;
   tf->codes[18923] = 0x0007184b90db3408UL;
   tf->codes[18924] = 0x000718632066864bUL;
   tf->codes[18925] = 0x00071871feb6fd50UL;
   tf->codes[18926] = 0x0007187a7562d2c9UL;
   tf->codes[18927] = 0x000718818cb485a4UL;
   tf->codes[18928] = 0x000718877f3b1ba6UL;
   tf->codes[18929] = 0x0007188e968cce81UL;
   tf->codes[18930] = 0x0007188ff5e6f11fUL;
   tf->codes[18931] = 0x0007189fbe737f38UL;
   tf->codes[18932] = 0x000718e791e092daUL;
   tf->codes[18933] = 0x000718e96658c102UL;
   tf->codes[18934] = 0x000718f87f383dccUL;
   tf->codes[18935] = 0x00071906addba382UL;
   tf->codes[18936] = 0x0007194052a5516eUL;
   tf->codes[18937] = 0x0007196ec20ee4a5UL;
   tf->codes[18938] = 0x0007197fe9f5955cUL;
   tf->codes[18939] = 0x00071991c1895762UL;
   tf->codes[18940] = 0x000719c782d3a339UL;
   tf->codes[18941] = 0x000719dab9c187ddUL;
   tf->codes[18942] = 0x000719e1968434f3UL;
   tf->codes[18943] = 0x000719f9260f8736UL;
   tf->codes[18944] = 0x00071a119fd6f08dUL;
   tf->codes[18945] = 0x00071a3fd4b17dffUL;
   tf->codes[18946] = 0x00071a41e3b8b1ecUL;
   tf->codes[18947] = 0x00071a4a5a648765UL;
   tf->codes[18948] = 0x00071a834f812402UL;
   tf->codes[18949] = 0x00071ae695f8ebfcUL;
   tf->codes[18950] = 0x00071aebd8d270afUL;
   tf->codes[18951] = 0x00071aecc30e87c3UL;
   tf->codes[18952] = 0x00071aff0fc05553UL;
   tf->codes[18953] = 0x00071b057764f6dfUL;
   tf->codes[18954] = 0x00071b7293e2b6f0UL;
   tf->codes[18955] = 0x00071b7e03d1d76aUL;
   tf->codes[18956] = 0x00071b9ef445163aUL;
   tf->codes[18957] = 0x00071bd440715687UL;
   tf->codes[18958] = 0x00071be2e432c7c7UL;
   tf->codes[18959] = 0x00071beb5ade9d40UL;
   tf->codes[18960] = 0x00071beda474d6f2UL;
   tf->codes[18961] = 0x00071bf35c6c672fUL;
   tf->codes[18962] = 0x00071c0f44952711UL;
   tf->codes[18963] = 0x00071c1e22e59e16UL;
   tf->codes[18964] = 0x00071c43a685504aUL;
   tf->codes[18965] = 0x00071c4f167470c4UL;
   tf->codes[18966] = 0x00071c51257ba4b1UL;
   tf->codes[18967] = 0x00071c71db5fddbcUL;
   tf->codes[18968] = 0x00071c73002afa95UL;
   tf->codes[18969] = 0x00071c98493ba704UL;
   tf->codes[18970] = 0x00071caf9e37f382UL;
   tf->codes[18971] = 0x00071ccbc0efb929UL;
   tf->codes[18972] = 0x00071ce22bafee93UL;
   tf->codes[18973] = 0x00071ceefaf931abUL;
   tf->codes[18974] = 0x00071d0c427c142bUL;
   tf->codes[18975] = 0x00071d1568d4faf3UL;
   tf->codes[18976] = 0x00071d8afbfe907dUL;
   tf->codes[18977] = 0x00071d9ee2998670UL;
   tf->codes[18978] = 0x00071dc0f7d7e219UL;
   tf->codes[18979] = 0x00071dd010b75ee3UL;
   tf->codes[18980] = 0x00071dd294dc9e5aUL;
   tf->codes[18981] = 0x00071dea2467f09dUL;
   tf->codes[18982] = 0x00071dffdf7b14b8UL;
   tf->codes[18983] = 0x00071e0681aebc09UL;
   tf->codes[18984] = 0x00071e409b96757fUL;
   tf->codes[18985] = 0x00071e57b603bc38UL;
   tf->codes[18986] = 0x00071e739e2c7c1aUL;
   tf->codes[18987] = 0x00071e8a7e0abd0eUL;
   tf->codes[18988] = 0x00071e932f45984cUL;
   tf->codes[18989] = 0x00071e9d3fda9628UL;
   tf->codes[18990] = 0x00071f0812c21c87UL;
   tf->codes[18991] = 0x00071f43c692fe60UL;
   tf->codes[18992] = 0x00071f4a68c6a5b1UL;
   tf->codes[18993] = 0x00071fbe620712d8UL;
   tf->codes[18994] = 0x00071fcc561b72c9UL;
   tf->codes[18995] = 0x00071fd800999908UL;
   tf->codes[18996] = 0x00071fdf17eb4be3UL;
   tf->codes[18997] = 0x00071fed468eb199UL;
   tf->codes[18998] = 0x00071ff5481c7b88UL;
   tf->codes[18999] = 0x000720175d5ad731UL;
   tf->codes[19000] = 0x0007203eb572b78dUL;
   tf->codes[19001] = 0x00072042d3811f67UL;
   tf->codes[19002] = 0x00072056ba1c155aUL;
   tf->codes[19003] = 0x00072057dee73233UL;
   tf->codes[19004] = 0x0007205ad82a7d34UL;
   tf->codes[19005] = 0x0007207fe6ac23deUL;
   tf->codes[19006] = 0x00072083ca2b85f3UL;
   tf->codes[19007] = 0x000720894794106bUL;
   tf->codes[19008] = 0x0007209825e48770UL;
   tf->codes[19009] = 0x000720e660f63c9eUL;
   tf->codes[19010] = 0x00072102491efc80UL;
   tf->codes[19011] = 0x00072105f20f58d0UL;
   tf->codes[19012] = 0x0007211928fd3d74UL;
   tf->codes[19013] = 0x0007214882a2e7bfUL;
   tf->codes[19014] = 0x0007214acc392171UL;
   tf->codes[19015] = 0x00072150bebfb773UL;
   tf->codes[19016] = 0x0007215d5379f4c6UL;
   tf->codes[19017] = 0x00072160122e3a02UL;
   tf->codes[19018] = 0x0007217558235293UL;
   tf->codes[19019] = 0x0007218fe0f1efd7UL;
   tf->codes[19020] = 0x000721960e078b9eUL;
   tf->codes[19021] = 0x000721d4808cb2b3UL;
   tf->codes[19022] = 0x000722070e04adc4UL;
   tf->codes[19023] = 0x0007221af49fa3b7UL;
   tf->codes[19024] = 0x0007223f18e5334dUL;
   tf->codes[19025] = 0x00072254d3f85768UL;
   tf->codes[19026] = 0x0007225ac67eed6aUL;
   tf->codes[19027] = 0x0007225f943a6693UL;
   tf->codes[19028] = 0x0007228552691e8cUL;
   tf->codes[19029] = 0x0007229973931a44UL;
   tf->codes[19030] = 0x000722c5d3f5798eUL;
   tf->codes[19031] = 0x000722d90ae35e32UL;
   tf->codes[19032] = 0x000722ee164970feUL;
   tf->codes[19033] = 0x000723386ddbc417UL;
   tf->codes[19034] = 0x0007234db3d0dca8UL;
   tf->codes[19035] = 0x0007234e9e0cf3bcUL;
   tf->codes[19036] = 0x000723557acfa0d2UL;
   tf->codes[19037] = 0x0007237c98587b69UL;
   tf->codes[19038] = 0x0007238cd603150cUL;
   tf->codes[19039] = 0x000723beee5d0493UL;
   tf->codes[19040] = 0x000723c5cb1fb1a9UL;
   tf->codes[19041] = 0x000723cad36a3097UL;
   tf->codes[19042] = 0x000723da26d8b326UL;
   tf->codes[19043] = 0x000723f2a0a01c7dUL;
   tf->codes[19044] = 0x000724035368c1aaUL;
   tf->codes[19045] = 0x0007240945ef57acUL;
   tf->codes[19046] = 0x000724147b4f7261UL;
   tf->codes[19047] = 0x00072437efe7f0a8UL;
   tf->codes[19048] = 0x00072445344f3f4aUL;
   tf->codes[19049] = 0x0007244b9bf3e0d6UL;
   tf->codes[19050] = 0x0007245ed2e1c57aUL;
   tf->codes[19051] = 0x00072483a6d4665fUL;
   tf->codes[19052] = 0x00072488af1ee54dUL;
   tf->codes[19053] = 0x0007248a0e7907ebUL;
   tf->codes[19054] = 0x0007249d0ad7e6caUL;
   tf->codes[19055] = 0x000724db083f0255UL;
   tf->codes[19056] = 0x000724ddc6f34791UL;
   tf->codes[19057] = 0x000724ead0cb906eUL;
   tf->codes[19058] = 0x000724f72af6c7fcUL;
   tf->codes[19059] = 0x0007250c365cdac8UL;
   tf->codes[19060] = 0x0007251dd3619709UL;
   tf->codes[19061] = 0x0007251e487fa293UL;
   tf->codes[19062] = 0x000725465044943eUL;
   tf->codes[19063] = 0x00072555a3b316cdUL;
   tf->codes[19064] = 0x0007255827d85644UL;
   tf->codes[19065] = 0x00072562e81a656fUL;
   tf->codes[19066] = 0x0007258f0dedbef4UL;
   tf->codes[19067] = 0x000725c160d6b440UL;
   tf->codes[19068] = 0x000725c78dec5007UL;
   tf->codes[19069] = 0x000725d288bd64f7UL;
   tf->codes[19070] = 0x000725d9a00f17d2UL;
   tf->codes[19071] = 0x000725e8b8ee949cUL;
   tf->codes[19072] = 0x000725f6e791fa52UL;
   tf->codes[19073] = 0x000725f846ec1cf0UL;
   tf->codes[19074] = 0x000726037c4c37a5UL;
   tf->codes[19075] = 0x00072618fcd055fbUL;
   tf->codes[19076] = 0x0007261b0bd789e8UL;
   tf->codes[19077] = 0x0007261c30a2a6c1UL;
   tf->codes[19078] = 0x0007264940b2175aUL;
   tf->codes[19079] = 0x0007264e0e6d9083UL;
   tf->codes[19080] = 0x000726c7bfa58de7UL;
   tf->codes[19081] = 0x000726d32f94ae61UL;
   tf->codes[19082] = 0x000726fa87ac8ebdUL;
   tf->codes[19083] = 0x000726fac23b9482UL;
   tf->codes[19084] = 0x00072731e2e002f7UL;
   tf->codes[19085] = 0x0007275f680d7f1aUL;
   tf->codes[19086] = 0x0007276d5c21df0bUL;
   tf->codes[19087] = 0x00072774e8919d70UL;
   tf->codes[19088] = 0x0007279a6c314fa4UL;
   tf->codes[19089] = 0x000727bae78682eaUL;
   tf->codes[19090] = 0x000727c98b47f42aUL;
   tf->codes[19091] = 0x000727caeaa216c8UL;
   tf->codes[19092] = 0x000727ea069d2770UL;
   tf->codes[19093] = 0x00072816dc1d9244UL;
   tf->codes[19094] = 0x000728500bc934a6UL;
   tf->codes[19095] = 0x00072856736dd632UL;
   tf->codes[19096] = 0x0007285932221b6eUL;
   tf->codes[19097] = 0x00072864a2113be8UL;
   tf->codes[19098] = 0x0007286a1f79c660UL;
   tf->codes[19099] = 0x00072879e8065479UL;
   tf->codes[19100] = 0x000728bdd7f40606UL;
   tf->codes[19101] = 0x0007293246527eb7UL;
   tf->codes[19102] = 0x0007294ede284fe8UL;
   tf->codes[19103] = 0x0007297670cf3609UL;
   tf->codes[19104] = 0x000729979bd17a9eUL;
   tf->codes[19105] = 0x0007299d8e5810a0UL;
   tf->codes[19106] = 0x000729c3fc33d9e8UL;
   tf->codes[19107] = 0x000729d8927be12aUL;
   tf->codes[19108] = 0x000729dc3b6c3d7aUL;
   tf->codes[19109] = 0x00072a1b982d7ba3UL;
   tf->codes[19110] = 0x00072a1e1c52bb1aUL;
   tf->codes[19111] = 0x00072a4957e9fd8bUL;
   tf->codes[19112] = 0x00072a4d3b695fa0UL;
   tf->codes[19113] = 0x00072a92ffcf3f55UL;
   tf->codes[19114] = 0x00072aaf228704fcUL;
   tf->codes[19115] = 0x00072ad25c907d7eUL;
   tf->codes[19116] = 0x00072ae3bf0633faUL;
   tf->codes[19117] = 0x00072af2d7e5b0c4UL;
   tf->codes[19118] = 0x00072b13c858ef94UL;
   tf->codes[19119] = 0x00072b4028bb4edeUL;
   tf->codes[19120] = 0x00072b418815717cUL;
   tf->codes[19121] = 0x00072b55e3ce72f9UL;
   tf->codes[19122] = 0x00072b5aec18f1e7UL;
   tf->codes[19123] = 0x00072b61c8db9efdUL;
   tf->codes[19124] = 0x00072b706c9d103dUL;
   tf->codes[19125] = 0x00072b9be2c35873UL;
   tf->codes[19126] = 0x00072bd9e02a73feUL;
   tf->codes[19127] = 0x00072be9a8b70217UL;
   tf->codes[19128] = 0x00072bf58dc42e1bUL;
   tf->codes[19129] = 0x00072bff63ca2632UL;
   tf->codes[19130] = 0x00072c0590dfc1f9UL;
   tf->codes[19131] = 0x00072c0939d01e49UL;
   tf->codes[19132] = 0x00072c0a5e9b3b22UL;
   tf->codes[19133] = 0x00072c3ec08b645bUL;
   tf->codes[19134] = 0x00072c53cbf17727UL;
   tf->codes[19135] = 0x00072c7b5e985d48UL;
   tf->codes[19136] = 0x00072c8659697238UL;
   tf->codes[19137] = 0x00072c8aec95e59cUL;
   tf->codes[19138] = 0x00072c8e20683662UL;
   tf->codes[19139] = 0x00072c923e769e3cUL;
   tf->codes[19140] = 0x00072cb53df110f9UL;
   tf->codes[19141] = 0x00072cbe29baf1fcUL;
   tf->codes[19142] = 0x00072cc5b62ab061UL;
   tf->codes[19143] = 0x00072cde6a811f7dUL;
   tf->codes[19144] = 0x00072d3bbe725175UL;
   tf->codes[19145] = 0x00072d4902d9a017UL;
   tf->codes[19146] = 0x00072d50c9d86441UL;
   tf->codes[19147] = 0x00072d8c431a4055UL;
   tf->codes[19148] = 0x00072d8da27462f3UL;
   tf->codes[19149] = 0x00072dafb7b2be9cUL;
   tf->codes[19150] = 0x00072dcf48cbdaceUL;
   tf->codes[19151] = 0x00072dd74a59a4bdUL;
   tf->codes[19152] = 0x00072e18f0b11c98UL;
   tf->codes[19153] = 0x00072e1b3a47564aUL;
   tf->codes[19154] = 0x00072e1baf6561d4UL;
   tf->codes[19155] = 0x00072e4466d764ceUL;
   tf->codes[19156] = 0x00072e46eafca445UL;
   tf->codes[19157] = 0x00072e4f61a879beUL;
   tf->codes[19158] = 0x00072e6014711eebUL;
   tf->codes[19159] = 0x00072f3d0c20e449UL;
   tf->codes[19160] = 0x00072f407a823ad4UL;
   tf->codes[19161] = 0x00072fcfac3e568eUL;
   tf->codes[19162] = 0x00072fe7eb76ba20UL;
   tf->codes[19163] = 0x0007301486681f2fUL;
   tf->codes[19164] = 0x0007303994e9c5d9UL;
   tf->codes[19165] = 0x00073040e6ca7e79UL;
   tf->codes[19166] = 0x00073052f8ed4644UL;
   tf->codes[19167] = 0x000730be7b81ddf2UL;
   tf->codes[19168] = 0x000730cc6f963de3UL;
   tf->codes[19169] = 0x000730ccaa2543a8UL;
   tf->codes[19170] = 0x000730d311c9e534UL;
   tf->codes[19171] = 0x000730e0cb4f3f60UL;
   tf->codes[19172] = 0x000730f1f335f017UL;
   tf->codes[19173] = 0x000730f4023d2404UL;
   tf->codes[19174] = 0x0007310982c1425aUL;
   tf->codes[19175] = 0x000731578343f1c3UL;
   tf->codes[19176] = 0x00073165b1e75779UL;
   tf->codes[19177] = 0x0007316c541afecaUL;
   tf->codes[19178] = 0x00073178ae463658UL;
   tf->codes[19179] = 0x000731871778a1d3UL;
   tf->codes[19180] = 0x0007318ccf703210UL;
   tf->codes[19181] = 0x0007319879ee584fUL;
   tf->codes[19182] = 0x000731bb3ed9c547UL;
   tf->codes[19183] = 0x000731bcd8c2edaaUL;
   tf->codes[19184] = 0x000731c5ff1bd472UL;
   tf->codes[19185] = 0x000731cb7c845eeaUL;
   tf->codes[19186] = 0x000731cd166d874dUL;
   tf->codes[19187] = 0x000731db7f9ff2c8UL;
   tf->codes[19188] = 0x000731e9e8d25e43UL;
   tf->codes[19189] = 0x00073248d6acb89eUL;
   tf->codes[19190] = 0x0007325bd30b977dUL;
   tf->codes[19191] = 0x000732744cd300d4UL;
   tf->codes[19192] = 0x00073297c16b7f1bUL;
   tf->codes[19193] = 0x000732b8774fb826UL;
   tf->codes[19194] = 0x000732bbe5b10eb1UL;
   tf->codes[19195] = 0x000732c24d55b03dUL;
   tf->codes[19196] = 0x000732c630d51252UL;
   tf->codes[19197] = 0x000732c7cabe3ab5UL;
   tf->codes[19198] = 0x000732c8b4fa51c9UL;
   tf->codes[19199] = 0x000732e512411d35UL;
   tf->codes[19200] = 0x000732ec6421d5d5UL;
   tf->codes[19201] = 0x000732edc37bf873UL;
   tf->codes[19202] = 0x000733167aedfb6dUL;
   tf->codes[19203] = 0x0007331f66b7dc70UL;
   tf->codes[19204] = 0x0007335896637ed2UL;
   tf->codes[19205] = 0x00073359bb2e9babUL;
   tf->codes[19206] = 0x0007336e16e79d28UL;
   tf->codes[19207] = 0x00073383224daff4UL;
   tf->codes[19208] = 0x0007339bd6a41f10UL;
   tf->codes[19209] = 0x000733d5f08bd886UL;
   tf->codes[19210] = 0x000733dbe3126e88UL;
   tf->codes[19211] = 0x000733f92a955108UL;
   tf->codes[19212] = 0x000734100a7391fcUL;
   tf->codes[19213] = 0x0007341512be10eaUL;
   tf->codes[19214] = 0x000734404e55535bUL;
   tf->codes[19215] = 0x0007345d95d835dbUL;
   tf->codes[19216] = 0x0007348ec3f60e4eUL;
   tf->codes[19217] = 0x0007348fae322562UL;
   tf->codes[19218] = 0x000734caece4fbb1UL;
   tf->codes[19219] = 0x000734ccfbec2f9eUL;
   tf->codes[19220] = 0x000734d39e1fd6efUL;
   tf->codes[19221] = 0x000734d572980517UL;
   tf->codes[19222] = 0x000734d7bc2e3ec9UL;
   tf->codes[19223] = 0x000734d95617672cUL;
   tf->codes[19224] = 0x000734ea436f121eUL;
   tf->codes[19225] = 0x000734fed9b71960UL;
   tf->codes[19226] = 0x0007350a0f173415UL;
   tf->codes[19227] = 0x0007353bece21dd7UL;
   tf->codes[19228] = 0x000735558b74a407UL;
   tf->codes[19229] = 0x0007355e02207980UL;
   tf->codes[19230] = 0x0007356dcaad0799UL;
   tf->codes[19231] = 0x0007357bbec1678aUL;
   tf->codes[19232] = 0x00073599b5f15b59UL;
   tf->codes[19233] = 0x000735c3579f7567UL;
   tf->codes[19234] = 0x000735ccb88761f4UL;
   tf->codes[19235] = 0x000735d1c0d1e0e2UL;
   tf->codes[19236] = 0x000735f067aee600UL;
   tf->codes[19237] = 0x000735fb627ffaf0UL;
   tf->codes[19238] = 0x000736171019b50dUL;
   tf->codes[19239] = 0x00073648ede49ecfUL;
   tf->codes[19240] = 0x000736587be22723UL;
   tf->codes[19241] = 0x0007368a59ad10e5UL;
   tf->codes[19242] = 0x00073691366fbdfbUL;
   tf->codes[19243] = 0x0007369eb5661262UL;
   tf->codes[19244] = 0x000736ae7df2a07bUL;
   tf->codes[19245] = 0x000737406e630171UL;
   tf->codes[19246] = 0x0007374af4160ad7UL;
   tf->codes[19247] = 0x0007375245f6c377UL;
   tf->codes[19248] = 0x000737666720bf2fUL;
   tf->codes[19249] = 0x0007376ea33d8ee3UL;
   tf->codes[19250] = 0x00073791dd470765UL;
   tf->codes[19251] = 0x0007379d87c52da4UL;
   tf->codes[19252] = 0x000737ea637cc034UL;
   tf->codes[19253] = 0x00073806863485dbUL;
   tf->codes[19254] = 0x000738147a48e5ccUL;
   tf->codes[19255] = 0x00073817738c30cdUL;
   tf->codes[19256] = 0x0007386623bbf185UL;
   tf->codes[19257] = 0x000738711e8d0675UL;
   tf->codes[19258] = 0x0007388e2b80e330UL;
   tf->codes[19259] = 0x000738c80ad996e1UL;
   tf->codes[19260] = 0x000738de3b0ac686UL;
   tf->codes[19261] = 0x000738dfd4f3eee9UL;
   tf->codes[19262] = 0x000738e6ec45a1c4UL;
   tf->codes[19263] = 0x000738fbf7abb490UL;
   tf->codes[19264] = 0x000738ff2b7e0556UL;
   tf->codes[19265] = 0x000739060840b26cUL;
   tf->codes[19266] = 0x00073910c882c197UL;
   tf->codes[19267] = 0x0007394f0078e2e7UL;
   tf->codes[19268] = 0x0007399db0a8a39fUL;
   tf->codes[19269] = 0x000739d630a734b2UL;
   tf->codes[19270] = 0x000739d8ef5b79eeUL;
   tf->codes[19271] = 0x000739f04457c66cUL;
   tf->codes[19272] = 0x00073a1d8ef63ccaUL;
   tf->codes[19273] = 0x00073a23f69ade56UL;
   tf->codes[19274] = 0x00073a48ca8d7f3bUL;
   tf->codes[19275] = 0x00073a6fe81659d2UL;
   tf->codes[19276] = 0x00073a7c7cd09725UL;
   tf->codes[19277] = 0x00073a9b23ad9c43UL;
   tf->codes[19278] = 0x00073ab98ffb9b9cUL;
   tf->codes[19279] = 0x00073ad1cf33ff2eUL;
   tf->codes[19280] = 0x00073afb70e2193cUL;
   tf->codes[19281] = 0x00073b1eaaeb91beUL;
   tf->codes[19282] = 0x00073b40107cdc18UL;
   tf->codes[19283] = 0x00073b56f05b1d0cUL;
   tf->codes[19284] = 0x00073b99f60cb785UL;
   tf->codes[19285] = 0x00073bbe1a52471bUL;
   tf->codes[19286] = 0x00073bd7f373d310UL;
   tf->codes[19287] = 0x00073bf53af6b590UL;
   tf->codes[19288] = 0x00073bfa4341347eUL;
   tf->codes[19289] = 0x00073c97a3a0b5eeUL;
   tf->codes[19290] = 0x00073c98534dc73dUL;
   tf->codes[19291] = 0x00073c9cabeb34dcUL;
   tf->codes[19292] = 0x00073ccaa636bc89UL;
   tf->codes[19293] = 0x00073ccd9f7a078aUL;
   tf->codes[19294] = 0x00073cdfec2bd51aUL;
   tf->codes[19295] = 0x00073ce82848a4ceUL;
   tf->codes[19296] = 0x00073cf32319b9beUL;
   tf->codes[19297] = 0x00073d1a40a29455UL;
   tf->codes[19298] = 0x00073d56a420877dUL;
   tf->codes[19299] = 0x00073d5c96a71d7fUL;
   tf->codes[19300] = 0x00073d71dc9c3610UL;
   tf->codes[19301] = 0x00073d7d871a5c4fUL;
   tf->codes[19302] = 0x00073d8f993d241aUL;
   tf->codes[19303] = 0x00073d99a9d221f6UL;
   tf->codes[19304] = 0x00073d99e46127bbUL;
   tf->codes[19305] = 0x00073dbbf99f8364UL;
   tf->codes[19306] = 0x00073dc3fb2d4d53UL;
   tf->codes[19307] = 0x00073dc72eff9e19UL;
   tf->codes[19308] = 0x00073dc8c8e8c67cUL;
   tf->codes[19309] = 0x00073dd3c3b9db6cUL;
   tf->codes[19310] = 0x00073dfd9ff6fb3fUL;
   tf->codes[19311] = 0x00073e0da3128f1dUL;
   tf->codes[19312] = 0x00073e61961bd488UL;
   tf->codes[19313] = 0x00073e6fff4e4003UL;
   tf->codes[19314] = 0x00073e77169ff2deUL;
   tf->codes[19315] = 0x00073e8fcaf661faUL;
   tf->codes[19316] = 0x00073ec3f257856eUL;
   tf->codes[19317] = 0x00073ecb7ec743d3UL;
   tf->codes[19318] = 0x00073ed972dba3c4UL;
   tf->codes[19319] = 0x00073edb4753d1ecUL;
   tf->codes[19320] = 0x00073f12a2874626UL;
   tf->codes[19321] = 0x00073f4f0605394eUL;
   tf->codes[19322] = 0x00073f8367f56287UL;
   tf->codes[19323] = 0x00073f9838cc6f8eUL;
   tf->codes[19324] = 0x00073fbd81dd1bfdUL;
   tf->codes[19325] = 0x00073fe5c431136dUL;
   tf->codes[19326] = 0x00073fe673de24bcUL;
   tf->codes[19327] = 0x000740113a575ba3UL;
   tf->codes[19328] = 0x0007403e84f5d201UL;
   tf->codes[19329] = 0x0007405773db46e2UL;
   tf->codes[19330] = 0x0007405fea871c5bUL;
   tf->codes[19331] = 0x0007407271c7efb0UL;
   tf->codes[19332] = 0x000740856e26ce8fUL;
   tf->codes[19333] = 0x000740f0b62c6078UL;
   tf->codes[19334] = 0x0007411883624c5eUL;
   tf->codes[19335] = 0x0007411ca170b438UL;
   tf->codes[19336] = 0x00074146b83cd9d0UL;
   tf->codes[19337] = 0x0007414bfb165e83UL;
   tf->codes[19338] = 0x00074154e6e03f86UL;
   tf->codes[19339] = 0x0007418147429ed0UL;
   tf->codes[19340] = 0x000741835649d2bdUL;
   tf->codes[19341] = 0x0007418ddbfcdc23UL;
   tf->codes[19342] = 0x000741994bebfc9dUL;
   tf->codes[19343] = 0x000741ce22fa3160UL;
   tf->codes[19344] = 0x000741e3de0d557bUL;
   tf->codes[19345] = 0x000741ffc636155dUL;
   tf->codes[19346] = 0x0007420be5d24726UL;
   tf->codes[19347] = 0x0007420d0a9d63ffUL;
   tf->codes[19348] = 0x000742480ec13489UL;
   tf->codes[19349] = 0x0007424dc6b8c4c6UL;
   tf->codes[19350] = 0x00074250104efe78UL;
   tf->codes[19351] = 0x000742542e5d6652UL;
   tf->codes[19352] = 0x0007426bbde8b895UL;
   tf->codes[19353] = 0x00074292a0e28d67UL;
   tf->codes[19354] = 0x000742c5a3789402UL;
   tf->codes[19355] = 0x000742c702d2b6a0UL;
   tf->codes[19356] = 0x000742c8622cd93eUL;
   tf->codes[19357] = 0x000742c986f7f617UL;
   tf->codes[19358] = 0x000742dc8356d4f6UL;
   tf->codes[19359] = 0x000742e39aa887d1UL;
   tf->codes[19360] = 0x000742e6ce7ad897UL;
   tf->codes[19361] = 0x000743132edd37e1UL;
   tf->codes[19362] = 0x0007436befa1f675UL;
   tf->codes[19363] = 0x00074396066e1c0dUL;
   tf->codes[19364] = 0x000744048245febcUL;
   tf->codes[19365] = 0x00074410dc71364aUL;
   tf->codes[19366] = 0x0007441e20d884ecUL;
   tf->codes[19367] = 0x0007443b685b676cUL;
   tf->codes[19368] = 0x0007444e2a2b4086UL;
   tf->codes[19369] = 0x0007444ffea36eaeUL;
   tf->codes[19370] = 0x0007445d087bb78bUL;
   tf->codes[19371] = 0x000744662ed49e53UL;
   tf->codes[19372] = 0x0007446d80b556f3UL;
   tf->codes[19373] = 0x000744716434b908UL;
   tf->codes[19374] = 0x00074491a4fae689UL;
   tf->codes[19375] = 0x00074496382759edUL;
   tf->codes[19376] = 0x0007449797817c8bUL;
   tf->codes[19377] = 0x000744d9b2f6fff0UL;
   tf->codes[19378] = 0x000744faddf94485UL;
   tf->codes[19379] = 0x00074501babbf19bUL;
   tf->codes[19380] = 0x00074519f9f4552dUL;
   tf->codes[19381] = 0x00074541177d2fc4UL;
   tf->codes[19382] = 0x0007457872b0a3feUL;
   tf->codes[19383] = 0x000745ceaf50231bUL;
   tf->codes[19384] = 0x000745d00eaa45b9UL;
   tf->codes[19385] = 0x000745d307ed90baUL;
   tf->codes[19386] = 0x000745d46747b358UL;
   tf->codes[19387] = 0x000745f93b3a543dUL;
   tf->codes[19388] = 0x000745ffa2def5c9UL;
   tf->codes[19389] = 0x0007461adb5aa45cUL;
   tf->codes[19390] = 0x0007461c3ab4c6faUL;
   tf->codes[19391] = 0x0007461c7543ccbfUL;
   tf->codes[19392] = 0x000746405efa5690UL;
   tf->codes[19393] = 0x0007464f77d9d35aUL;
   tf->codes[19394] = 0x0007467d72255b07UL;
   tf->codes[19395] = 0x00074687f7d8646dUL;
   tf->codes[19396] = 0x000746d24f6ab786UL;
   tf->codes[19397] = 0x000746d7ccd341feUL;
   tf->codes[19398] = 0x00074719adb9bf9eUL;
   tf->codes[19399] = 0x0007475c3e4d4e8dUL;
   tf->codes[19400] = 0x00074770d49555cfUL;
   tf->codes[19401] = 0x0007477651fde047UL;
   tf->codes[19402] = 0x0007478b5d63f313UL;
   tf->codes[19403] = 0x000747bc1663bffcUL;
   tf->codes[19404] = 0x000747ce9da49351UL;
   tf->codes[19405] = 0x000747eac05c58f8UL;
   tf->codes[19406] = 0x0007480b76409203UL;
   tf->codes[19407] = 0x0007483e03b88d14UL;
   tf->codes[19408] = 0x00074841378adddaUL;
   tf->codes[19409] = 0x0007487b16e3918bUL;
   tf->codes[19410] = 0x000748b35c531cd9UL;
   tf->codes[19411] = 0x000748bc82ac03a1UL;
   tf->codes[19412] = 0x000748d0de65051eUL;
   tf->codes[19413] = 0x000748d91a81d4d2UL;
   tf->codes[19414] = 0x000748ed763ad64fUL;
   tf->codes[19415] = 0x000748efbfd11001UL;
   tf->codes[19416] = 0x000748f4186e7da0UL;
   tf->codes[19417] = 0x000748f6d722c2dcUL;
   tf->codes[19418] = 0x000748f7fbeddfb5UL;
   tf->codes[19419] = 0x000748fcc9a958deUL;
   tf->codes[19420] = 0x00074917c79601acUL;
   tf->codes[19421] = 0x0007491a112c3b5eUL;
   tf->codes[19422] = 0x000749387d7a3ab7UL;
   tf->codes[19423] = 0x0007493cd617a856UL;
   tf->codes[19424] = 0x00074954dac10623UL;
   tf->codes[19425] = 0x000749558a6e1772UL;
   tf->codes[19426] = 0x00074955c4fd1d37UL;
   tf->codes[19427] = 0x000749905402e237UL;
   tf->codes[19428] = 0x000749ce16daf7fdUL;
   tf->codes[19429] = 0x000749dfb3dfb43eUL;
   tf->codes[19430] = 0x00074a08e06fc2c2UL;
   tf->codes[19431] = 0x00074a5128fae1eeUL;
   tf->codes[19432] = 0x00074a53e7af272aUL;
   tf->codes[19433] = 0x00074a6793bb1758UL;
   tf->codes[19434] = 0x00074a6e707dc46eUL;
   tf->codes[19435] = 0x00074a7d143f35aeUL;
   tf->codes[19436] = 0x00074a837be3d73aUL;
   tf->codes[19437] = 0x00074ad22c1397f2UL;
   tf->codes[19438] = 0x00074ad908d64508UL;
   tf->codes[19439] = 0x00074adcec55a71dUL;
   tf->codes[19440] = 0x00074addd691be31UL;
   tf->codes[19441] = 0x00074b2ab24950c1UL;
   tf->codes[19442] = 0x00074b45eac4ff54UL;
   tf->codes[19443] = 0x00074b4784ae27b7UL;
   tf->codes[19444] = 0x00074b587205d2a9UL;
   tf->codes[19445] = 0x00074b5d7a505197UL;
   tf->codes[19446] = 0x00074bd606bd3222UL;
   tf->codes[19447] = 0x00074be72ea3e2d9UL;
   tf->codes[19448] = 0x00074bfadaafd307UL;
   tf->codes[19449] = 0x00074c056062dc6dUL;
   tf->codes[19450] = 0x00074c5cfc5c7e28UL;
   tf->codes[19451] = 0x00074cc0b7f251acUL;
   tf->codes[19452] = 0x00074cdca01b118eUL;
   tf->codes[19453] = 0x00074cec68a79fa7UL;
   tf->codes[19454] = 0x00074cf170f21e95UL;
   tf->codes[19455] = 0x00074cfbbc162236UL;
   tf->codes[19456] = 0x00074d00c460a124UL;
   tf->codes[19457] = 0x00074d2e0eff1782UL;
   tf->codes[19458] = 0x00074d381f94155eUL;
   tf->codes[19459] = 0x00074d3d9cfc9fd6UL;
   tf->codes[19460] = 0x00074d5aa9f07c91UL;
   tf->codes[19461] = 0x00074d5fb23afb7fUL;
   tf->codes[19462] = 0x00074d9dafa2170aUL;
   tf->codes[19463] = 0x00074dc36dd0cf03UL;
   tf->codes[19464] = 0x00074dce68a1e3f3UL;
   tf->codes[19465] = 0x00074dd161e52ef4UL;
   tf->codes[19466] = 0x00074e2ef06566b1UL;
   tf->codes[19467] = 0x00074e4e46ef7d1eUL;
   tf->codes[19468] = 0x00074e9654eb9685UL;
   tf->codes[19469] = 0x00074e97eed4bee8UL;
   tf->codes[19470] = 0x00074e9e56796074UL;
   tf->codes[19471] = 0x00074edbdec27075UL;
   tf->codes[19472] = 0x00074ee6d9938565UL;
   tf->codes[19473] = 0x00074eec56fc0fddUL;
   tf->codes[19474] = 0x00074f3d8b51100cUL;
   tf->codes[19475] = 0x00074f6caa67b492UL;
   tf->codes[19476] = 0x00074f71b2b23380UL;
   tf->codes[19477] = 0x00074f89b75b914dUL;
   tf->codes[19478] = 0x00074f8a2c799cd7UL;
   tf->codes[19479] = 0x00074f9cee4975f1UL;
   tf->codes[19480] = 0x00074fd0db1b93a0UL;
   tf->codes[19481] = 0x00074fe118c62d43UL;
   tf->codes[19482] = 0x00074fe536d4951dUL;
   tf->codes[19483] = 0x00074fe954e2fcf7UL;
   tf->codes[19484] = 0x00074ff44fb411e7UL;
   tf->codes[19485] = 0x0007502edeb9d6e7UL;
   tf->codes[19486] = 0x00075059dfc21393UL;
   tf->codes[19487] = 0x000750779c63019dUL;
   tf->codes[19488] = 0x0007507b0ac45828UL;
   tf->codes[19489] = 0x000750cc3f195857UL;
   tf->codes[19490] = 0x000750dfb09642c0UL;
   tf->codes[19491] = 0x000750f0d87cf377UL;
   tf->codes[19492] = 0x000751023af2a9f3UL;
   tf->codes[19493] = 0x0007511ab4ba134aUL;
   tf->codes[19494] = 0x0007513d048774b8UL;
   tf->codes[19495] = 0x00075143a6bb1c09UL;
   tf->codes[19496] = 0x0007516ac443f6a0UL;
   tf->codes[19497] = 0x000751c29acc9e20UL;
   tf->codes[19498] = 0x000751c3fa26c0beUL;
   tf->codes[19499] = 0x000751db14940777UL;
   tf->codes[19500] = 0x0007520c42b1dfeaUL;
   tf->codes[19501] = 0x00075213cf219e4fUL;
   tf->codes[19502] = 0x00075242ee3842d5UL;
   tf->codes[19503] = 0x00075252b6c4d0eeUL;
   tf->codes[19504] = 0x000752778ab771d3UL;
   tf->codes[19505] = 0x0007527b6e36d3e8UL;
   tf->codes[19506] = 0x0007527df25c135fUL;
   tf->codes[19507] = 0x000752875343ffecUL;
   tf->codes[19508] = 0x000752b8bbf0de24UL;
   tf->codes[19509] = 0x000752c1329cb39dUL;
   tf->codes[19510] = 0x000752e6068f5482UL;
   tf->codes[19511] = 0x0007531e4bfedfd0UL;
   tf->codes[19512] = 0x0007536e5b88c326UL;
   tf->codes[19513] = 0x0007539defbd7336UL;
   tf->codes[19514] = 0x000753c0ef37e5f3UL;
   tf->codes[19515] = 0x000753da18ac6099UL;
   tf->codes[19516] = 0x000753dc62429a4bUL;
   tf->codes[19517] = 0x000753ea5656fa3cUL;
   tf->codes[19518] = 0x0007543104f8f105UL;
   tf->codes[19519] = 0x0007543b501cf4a6UL;
   tf->codes[19520] = 0x00075467b07f53f0UL;
   tf->codes[19521] = 0x000754690fd9768eUL;
   tf->codes[19522] = 0x000754c32ff857c0UL;
   tf->codes[19523] = 0x000754d2f884e5d9UL;
   tf->codes[19524] = 0x000754da4a659e79UL;
   tf->codes[19525] = 0x000754ebacdb54f5UL;
   tf->codes[19526] = 0x000754f5f7ff5896UL;
   tf->codes[19527] = 0x000754f9db7ebaabUL;
   tf->codes[19528] = 0x000755193208d118UL;
   tf->codes[19529] = 0x000755446da01389UL;
   tf->codes[19530] = 0x000755513ce956a1UL;
   tf->codes[19531] = 0x00075559ee2431dfUL;
   tf->codes[19532] = 0x000755681cc79795UL;
   tf->codes[19533] = 0x000755c98ec73167UL;
   tf->codes[19534] = 0x000755d2efaf1df4UL;
   tf->codes[19535] = 0x000755d5ae636330UL;
   tf->codes[19536] = 0x000755d91cc4b9bbUL;
   tf->codes[19537] = 0x000755de9a2d4433UL;
   tf->codes[19538] = 0x000755ed035fafaeUL;
   tf->codes[19539] = 0x0007561336ac7331UL;
   tf->codes[19540] = 0x0007565885f4475cUL;
   tf->codes[19541] = 0x000756608782114bUL;
   tf->codes[19542] = 0x0007566604ea9bc3UL;
   tf->codes[19543] = 0x000756960e3d575dUL;
   tf->codes[19544] = 0x000756aaa4855e9fUL;
   tf->codes[19545] = 0x000756c910d35df8UL;
   tf->codes[19546] = 0x000756cda3ffd15cUL;
   tf->codes[19547] = 0x0007570e9aaa37e8UL;
   tf->codes[19548] = 0x0007572f8b1d76b8UL;
   tf->codes[19549] = 0x000757336e9cd8cdUL;
   tf->codes[19550] = 0x0007573ede8bf947UL;
   tf->codes[19551] = 0x00075740787521aaUL;
   tf->codes[19552] = 0x0007574b38b730d5UL;
   tf->codes[19553] = 0x000757675b6ef67cUL;
   tf->codes[19554] = 0x00075767d08d0206UL;
   tf->codes[19555] = 0x00075768803a1355UL;
   tf->codes[19556] = 0x000757d4b27bbc52UL;
   tf->codes[19557] = 0x000757d7abbf0753UL;
   tf->codes[19558] = 0x000757e52ab55bbaUL;
   tf->codes[19559] = 0x000757fc0a939caeUL;
   tf->codes[19560] = 0x000758069046a614UL;
   tf->codes[19561] = 0x00075808d9dcdfc6UL;
   tf->codes[19562] = 0x00075855407666ccUL;
   tf->codes[19563] = 0x0007585d7c933680UL;
   tf->codes[19564] = 0x000758771b25bcb0UL;
   tf->codes[19565] = 0x00075883ea6effc8UL;
   tf->codes[19566] = 0x000758c0887bf8b5UL;
   tf->codes[19567] = 0x000758e3c2857137UL;
   tf->codes[19568] = 0x000758ee48387a9dUL;
   tf->codes[19569] = 0x000758ff3590258fUL;
   tf->codes[19570] = 0x0007590c3f686e6cUL;
   tf->codes[19571] = 0x00075941c623b47eUL;
   tf->codes[19572] = 0x00075942eaeed157UL;
   tf->codes[19573] = 0x0007594ff4c71a34UL;
   tf->codes[19574] = 0x00075950df033148UL;
   tf->codes[19575] = 0x00075955722fa4acUL;
   tf->codes[19576] = 0x0007596833ff7dc6UL;
   tf->codes[19577] = 0x000759c5c27fb583UL;
   tf->codes[19578] = 0x000759ceae499686UL;
   tf->codes[19579] = 0x000759d79a137789UL;
   tf->codes[19580] = 0x00075a16f6d4b5b2UL;
   tf->codes[19581] = 0x00075a4b9353e4b0UL;
   tf->codes[19582] = 0x00075a51faf8863cUL;
   tf->codes[19583] = 0x00075ad338a04205UL;
   tf->codes[19584] = 0x00075adc246a2308UL;
   tf->codes[19585] = 0x00075aeb02ba9a0dUL;
   tf->codes[19586] = 0x00075b1b0c0d55a7UL;
   tf->codes[19587] = 0x00075b3fdffff68cUL;
   tf->codes[19588] = 0x00075b6b90b54487UL;
   tf->codes[19589] = 0x00075b76c6155f3cUL;
   tf->codes[19590] = 0x00075b794a3a9eb3UL;
   tf->codes[19591] = 0x00075b8fef89d9e2UL;
   tf->codes[19592] = 0x00075bdf14d7a624UL;
   tf->codes[19593] = 0x00075be666b85ec4UL;
   tf->codes[19594] = 0x00075c1510b0f7c0UL;
   tf->codes[19595] = 0x00075c3f277d1d58UL;
   tf->codes[19596] = 0x00075c455492b91fUL;
   tf->codes[19597] = 0x00075c5816629239UL;
   tf->codes[19598] = 0x00075c5dce5a2276UL;
   tf->codes[19599] = 0x00075c781c99b9f5UL;
   tf->codes[19600] = 0x00075cd117ed7e4eUL;
   tf->codes[19601] = 0x00075cf6266f24f8UL;
   tf->codes[19602] = 0x00075d1f52ff337cUL;
   tf->codes[19603] = 0x00075d2c5cd77c59UL;
   tf->codes[19604] = 0x00075d425279a639UL;
   tf->codes[19605] = 0x00075d533fd1512bUL;
   tf->codes[19606] = 0x00075d5eea4f776aUL;
   tf->codes[19607] = 0x00075d6517651331UL;
   tf->codes[19608] = 0x00075d679b8a52a8UL;
   tf->codes[19609] = 0x00075d7e7b68939cUL;
   tf->codes[19610] = 0x00075d8caa0bf952UL;
   tf->codes[19611] = 0x00075d96f52ffcf3UL;
   tf->codes[19612] = 0x00075d9e0c81afceUL;
   tf->codes[19613] = 0x00075daf6ef7664aUL;
   tf->codes[19614] = 0x00075dcfea4c9990UL;
   tf->codes[19615] = 0x00075de913c11436UL;
   tf->codes[19616] = 0x00075df8672f96c5UL;
   tf->codes[19617] = 0x00075dfb25e3dc01UL;
   tf->codes[19618] = 0x00075e52874e77f7UL;
   tf->codes[19619] = 0x00075e6374a622e9UL;
   tf->codes[19620] = 0x00075e86aeaf9b6bUL;
   tf->codes[19621] = 0x00075eb433dd178eUL;
   tf->codes[19622] = 0x00075edefa564e75UL;
   tf->codes[19623] = 0x00075ef0d1ea107bUL;
   tf->codes[19624] = 0x00075f15e06bb725UL;
   tf->codes[19625] = 0x00075f47f8c5a6acUL;
   tf->codes[19626] = 0x00075f5577bbfb13UL;
   tf->codes[19627] = 0x00075f5920ac5763UL;
   tf->codes[19628] = 0x00075f757df322cfUL;
   tf->codes[19629] = 0x00075f9842de8fc7UL;
   tf->codes[19630] = 0x00075fda98e318f1UL;
   tf->codes[19631] = 0x0007601cb4589c56UL;
   tf->codes[19632] = 0x00076027af29b146UL;
   tf->codes[19633] = 0x0007603d6a3cd561UL;
   tf->codes[19634] = 0x0007605f7f7b310aUL;
   tf->codes[19635] = 0x000760786e60a5ebUL;
   tf->codes[19636] = 0x000760ce70711f43UL;
   tf->codes[19637] = 0x000760e63a8b774bUL;
   tf->codes[19638] = 0x000760e799e599e9UL;
   tf->codes[19639] = 0x000760fe79c3daddUL;
   tf->codes[19640] = 0x000761129aedd695UL;
   tf->codes[19641] = 0x00076117ddc75b48UL;
   tf->codes[19642] = 0x0007612d5e4b799eUL;
   tf->codes[19643] = 0x00076135254a3dc8UL;
   tf->codes[19644] = 0x00076187b8f96095UL;
   tf->codes[19645] = 0x00076189c8009482UL;
   tf->codes[19646] = 0x0007621307361a3aUL;
   tf->codes[19647] = 0x0007627dda1da099UL;
   tf->codes[19648] = 0x0007629da5c5c290UL;
   tf->codes[19649] = 0x000762c2049a57ebUL;
   tf->codes[19650] = 0x00076300771f7f00UL;
   tf->codes[19651] = 0x00076308038f3d65UL;
   tf->codes[19652] = 0x0007630bac7f99b5UL;
   tf->codes[19653] = 0x0007630d4668c218UL;
   tf->codes[19654] = 0x000763233c0aebf8UL;
   tf->codes[19655] = 0x00076344a19c3652UL;
   tf->codes[19656] = 0x0007635170e5796aUL;
   tf->codes[19657] = 0x0007638bffeb3e6aUL;
   tf->codes[19658] = 0x0007638c3a7a442fUL;
   tf->codes[19659] = 0x0007638f6e4c94f5UL;
   tf->codes[19660] = 0x0007639b18cabb34UL;
   tf->codes[19661] = 0x000763a6c348e173UL;
   tf->codes[19662] = 0x000763b39292248bUL;
   tf->codes[19663] = 0x000763cc0c598de2UL;
   tf->codes[19664] = 0x000763d91631d6bfUL;
   tf->codes[19665] = 0x000763ef46630664UL;
   tf->codes[19666] = 0x000763f27a35572aUL;
   tf->codes[19667] = 0x000763fdea2477a4UL;
   tf->codes[19668] = 0x0007641c567276fdUL;
   tf->codes[19669] = 0x0007641d7b3d93d6UL;
   tf->codes[19670] = 0x00076449db9ff320UL;
   tf->codes[19671] = 0x000764528cdace5eUL;
   tf->codes[19672] = 0x000764972c75913aUL;
   tf->codes[19673] = 0x000764edde331be1UL;
   tf->codes[19674] = 0x0007650916aeca74UL;
   tf->codes[19675] = 0x0007657c6042264cUL;
   tf->codes[19676] = 0x00076598f817f77dUL;
   tf->codes[19677] = 0x0007659fd4daa493UL;
   tf->codes[19678] = 0x000765c6b7d47965UL;
   tf->codes[19679] = 0x000765cb1071e704UL;
   tf->codes[19680] = 0x000765ea2c6cf7acUL;
   tf->codes[19681] = 0x000765f1f36bbbd6UL;
   tf->codes[19682] = 0x000765f736454089UL;
   tf->codes[19683] = 0x000765fd635adc50UL;
   tf->codes[19684] = 0x0007660ae25130b7UL;
   tf->codes[19685] = 0x0007660b1ce0367cUL;
   tf->codes[19686] = 0x0007661358fd0630UL;
   tf->codes[19687] = 0x00076642b2a2b07bUL;
   tf->codes[19688] = 0x000766565eaea0a9UL;
   tf->codes[19689] = 0x00076669207e79c3UL;
   tf->codes[19690] = 0x0007666a0aba90d7UL;
   tf->codes[19691] = 0x00076680ea98d1cbUL;
   tf->codes[19692] = 0x000766c3060e5530UL;
   tf->codes[19693] = 0x000766d886927386UL;
   tf->codes[19694] = 0x000766e7da00f615UL;
   tf->codes[19695] = 0x0007671265eb2737UL;
   tf->codes[19696] = 0x000767176e35a625UL;
   tf->codes[19697] = 0x0007673d66f363e3UL;
   tf->codes[19698] = 0x00076750635242c2UL;
   tf->codes[19699] = 0x0007675397249388UL;
   tf->codes[19700] = 0x00076770a4187043UL;
   tf->codes[19701] = 0x00076783db0654e7UL;
   tf->codes[19702] = 0x00076793a392e300UL;
   tf->codes[19703] = 0x000767d6e3d3833eUL;
   tf->codes[19704] = 0x000767f2cbfc4320UL;
   tf->codes[19705] = 0x0007684ec093527aUL;
   tf->codes[19706] = 0x0007687f047513d9UL;
   tf->codes[19707] = 0x00076890dc08d5dfUL;
   tf->codes[19708] = 0x0007689534a6437eUL;
   tf->codes[19709] = 0x0007689ff4e852a9UL;
   tf->codes[19710] = 0x000768bab845f5b2UL;
   tf->codes[19711] = 0x000768d3320d5f09UL;
   tf->codes[19712] = 0x000768f24e086fb1UL;
   tf->codes[19713] = 0x0007691c64d49549UL;
   tf->codes[19714] = 0x0007698821f832bcUL;
   tf->codes[19715] = 0x0007698c7a95a05bUL;
   tf->codes[19716] = 0x00076997aff5bb10UL;
   tf->codes[19717] = 0x000769b8a068f9e0UL;
   tf->codes[19718] = 0x000769c3261c0346UL;
   tf->codes[19719] = 0x000769e9ce86d253UL;
   tf->codes[19720] = 0x000769fccae5b132UL;
   tf->codes[19721] = 0x00076a015e122496UL;
   tf->codes[19722] = 0x00076a45888edbe8UL;
   tf->codes[19723] = 0x00076a4fd3b2df89UL;
   tf->codes[19724] = 0x00076a579ab1a3b3UL;
   tf->codes[19725] = 0x00076a888e407661UL;
   tf->codes[19726] = 0x00076a959818bf3eUL;
   tf->codes[19727] = 0x00076ac407825275UL;
   tf->codes[19728] = 0x00076acae444ff8bUL;
   tf->codes[19729] = 0x00076ad32061cf3fUL;
   tf->codes[19730] = 0x00076ad47fbbf1ddUL;
   tf->codes[19731] = 0x00076ad68ec325caUL;
   tf->codes[19732] = 0x00076ae3989b6ea7UL;
   tf->codes[19733] = 0x00076b044e7fa7b2UL;
   tf->codes[19734] = 0x00076b4878fc5f04UL;
   tf->codes[19735] = 0x00076b94df95e60aUL;
   tf->codes[19736] = 0x00076bbe0c25f48eUL;
   tf->codes[19737] = 0x00076bc55e06ad2eUL;
   tf->codes[19738] = 0x00076bd894f491d2UL;
   tf->codes[19739] = 0x00076bf9fa85dc2cUL;
   tf->codes[19740] = 0x00076bfcf3c9272dUL;
   tf->codes[19741] = 0x00076c34c41aa6f1UL;
   tf->codes[19742] = 0x00076c636e133fedUL;
   tf->codes[19743] = 0x00076c8e348c76d4UL;
   tf->codes[19744] = 0x00076cbf62aa4f47UL;
   tf->codes[19745] = 0x00076cd8c6adcfb2UL;
   tf->codes[19746] = 0x00076cf4744789cfUL;
   tf->codes[19747] = 0x00076cffa9a7a484UL;
   tf->codes[19748] = 0x00076d36ca4c12f9UL;
   tf->codes[19749] = 0x00076d857a7bd3b1UL;
   tf->codes[19750] = 0x00076dbfcef292ecUL;
   tf->codes[19751] = 0x00076e0f2ecf64f3UL;
   tf->codes[19752] = 0x00076e5568535032UL;
   tf->codes[19753] = 0x00076e5ae5bbdaaaUL;
   tf->codes[19754] = 0x00076e6fb692e7b1UL;
   tf->codes[19755] = 0x00076ec0eae7e7e0UL;
   tf->codes[19756] = 0x00076ed5f64dfaacUL;
   tf->codes[19757] = 0x00076efd13d6d543UL;
   tf->codes[19758] = 0x00076f104ac4b9e7UL;
   tf->codes[19759] = 0x00076f3ef4bd52e3UL;
   tf->codes[19760] = 0x00076f4bfe959bc0UL;
   tf->codes[19761] = 0x00076f74f096a47fUL;
   tf->codes[19762] = 0x00076f9fb70fdb66UL;
   tf->codes[19763] = 0x00076fb70c0c27e4UL;
   tf->codes[19764] = 0x00076fda4615a066UL;
   tf->codes[19765] = 0x0007701b0231012dUL;
   tf->codes[19766] = 0x0007701e360351f3UL;
   tf->codes[19767] = 0x0007705e07e29ba6UL;
   tf->codes[19768] = 0x000770a7afc7dd70UL;
   tf->codes[19769] = 0x000770be8fa61e64UL;
   tf->codes[19770] = 0x000770e1c9af96e6UL;
   tf->codes[19771] = 0x000770ed742dbd25UL;
   tf->codes[19772] = 0x000770f2075a3089UL;
   tf->codes[19773] = 0x00077101cfe6bea2UL;
   tf->codes[19774] = 0x0007710def82f06bUL;
   tf->codes[19775] = 0x000771115de446f6UL;
   tf->codes[19776] = 0x0007712e30491decUL;
   tf->codes[19777] = 0x0007714cd726230aUL;
   tf->codes[19778] = 0x000771516a52966eUL;
   tf->codes[19779] = 0x00077157224a26abUL;
   tf->codes[19780] = 0x0007715eaeb9e510UL;
   tf->codes[19781] = 0x00077173ba1ff7dcUL;
   tf->codes[19782] = 0x0007719b4cc6ddfdUL;
   tf->codes[19783] = 0x000771e0d69db7edUL;
   tf->codes[19784] = 0x000771e235f7da8bUL;
   tf->codes[19785] = 0x0007726bafbc6608UL;
   tf->codes[19786] = 0x000772766ffe7533UL;
   tf->codes[19787] = 0x000772aca666cc94UL;
   tf->codes[19788] = 0x000772d4ae2bbe3fUL;
   tf->codes[19789] = 0x000772f146018f70UL;
   tf->codes[19790] = 0x000772f43f44da71UL;
   tf->codes[19791] = 0x0007731e1b81fa44UL;
   tf->codes[19792] = 0x0007731f404d171dUL;
   tf->codes[19793] = 0x00077340e06d673cUL;
   tf->codes[19794] = 0x00077357fadaadf5UL;
   tf->codes[19795] = 0x00077371996d3425UL;
   tf->codes[19796] = 0x0007738df6b3ff91UL;
   tf->codes[19797] = 0x000773919fa45be1UL;
   tf->codes[19798] = 0x0007739498e7a6e2UL;
   tf->codes[19799] = 0x000773d84e4652aaUL;
   tf->codes[19800] = 0x00077403c46c9ae0UL;
   tf->codes[19801] = 0x00077444f5a60731UL;
   tf->codes[19802] = 0x000774502b0621e6UL;
   tf->codes[19803] = 0x0007746570fb3a77UL;
   tf->codes[19804] = 0x0007748f12a95485UL;
   tf->codes[19805] = 0x000774b6dfdf406bUL;
   tf->codes[19806] = 0x000774d3ecd31d26UL;
   tf->codes[19807] = 0x000774f552646780UL;
   tf->codes[19808] = 0x0007751a60e60e2aUL;
   tf->codes[19809] = 0x0007754268aaffd5UL;
   tf->codes[19810] = 0x00077567020e9af5UL;
   tf->codes[19811] = 0x0007756d69b33c81UL;
   tf->codes[19812] = 0x0007758aebc524c6UL;
   tf->codes[19813] = 0x000775b034d5d135UL;
   tf->codes[19814] = 0x000775b7fbd4955fUL;
   tf->codes[19815] = 0x000775ee6ccbf285UL;
   tf->codes[19816] = 0x000775efcc261523UL;
   tf->codes[19817] = 0x0007760378320551UL;
   tf->codes[19818] = 0x0007760aca12bdf1UL;
   tf->codes[19819] = 0x00077643bf2f5a8eUL;
   tf->codes[19820] = 0x0007764bc0bd247dUL;
   tf->codes[19821] = 0x00077655d1522259UL;
   tf->codes[19822] = 0x00077662660c5facUL;
   tf->codes[19823] = 0x0007766d60dd749cUL;
   tf->codes[19824] = 0x00077686c4e0f507UL;
   tf->codes[19825] = 0x0007768a6dd15157UL;
   tf->codes[19826] = 0x0007769b5b28fc49UL;
   tf->codes[19827] = 0x000776c153e6ba07UL;
   tf->codes[19828] = 0x000776e5b2bb4f62UL;
   tf->codes[19829] = 0x000776f8af1a2e41UL;
   tf->codes[19830] = 0x000776fb333f6db8UL;
   tf->codes[19831] = 0x00077770c6690342UL;
   tf->codes[19832] = 0x0007777f2f9b6ebdUL;
   tf->codes[19833] = 0x000777947590874eUL;
   tf->codes[19834] = 0x0007779cb1ad5702UL;
   tf->codes[19835] = 0x000777dfb75ef17bUL;
   tf->codes[19836] = 0x000777f2b3bdd05aUL;
   tf->codes[19837] = 0x000777fd3970d9c0UL;
   tf->codes[19838] = 0x00077805006f9deaUL;
   tf->codes[19839] = 0x00077810aaedc429UL;
   tf->codes[19840] = 0x00077811cfb8e102UL;
   tf->codes[19841] = 0x00077859a325f4a4UL;
   tf->codes[19842] = 0x0007785eab707392UL;
   tf->codes[19843] = 0x0007786dfedef621UL;
   tf->codes[19844] = 0x00077871e25e5836UL;
   tf->codes[19845] = 0x000778721ced5dfbUL;
   tf->codes[19846] = 0x00077897a08d102fUL;
   tf->codes[19847] = 0x000778bb8a439a00UL;
   tf->codes[19848] = 0x000778dc7ab6d8d0UL;
   tf->codes[19849] = 0x000778fc465efac7UL;
   tf->codes[19850] = 0x000779118c541358UL;
   tf->codes[19851] = 0x00077913263d3bbbUL;
   tf->codes[19852] = 0x00077948e7878792UL;
   tf->codes[19853] = 0x0007795b6ec85ae7UL;
   tf->codes[19854] = 0x00077978b64b3d67UL;
   tf->codes[19855] = 0x000779858594807fUL;
   tf->codes[19856] = 0x000779d7a42597c2UL;
   tf->codes[19857] = 0x000779eebe92de7bUL;
   tf->codes[19858] = 0x00077a14b7509c39UL;
   tf->codes[19859] = 0x00077a19fa2a20ecUL;
   tf->codes[19860] = 0x00077a4b2847f95fUL;
   tf->codes[19861] = 0x00077a8e2df993d8UL;
   tf->codes[19862] = 0x00077a90b21ed34fUL;
   tf->codes[19863] = 0x00077a90ecadd914UL;
   tf->codes[19864] = 0x00077abac8eaf8e7UL;
   tf->codes[19865] = 0x00077ac5fe4b139cUL;
   tf->codes[19866] = 0x00077ac6adf824ebUL;
   tf->codes[19867] = 0x00077adf624e9407UL;
   tf->codes[19868] = 0x00077ae763dc5df6UL;
   tf->codes[19869] = 0x00077af3be079584UL;
   tf->codes[19870] = 0x00077af4e2d2b25dUL;
   tf->codes[19871] = 0x00077afce4607c4cUL;
   tf->codes[19872] = 0x00077afd940d8d9bUL;
   tf->codes[19873] = 0x00077b3fea1216c5UL;
   tf->codes[19874] = 0x00077b7de7793250UL;
   tf->codes[19875] = 0x00077baf50261088UL;
   tf->codes[19876] = 0x00077bcbe7fbe1b9UL;
   tf->codes[19877] = 0x00077bf0bbee829eUL;
   tf->codes[19878] = 0x00077bf54f1af602UL;
   tf->codes[19879] = 0x00077bfd50a8bff1UL;
   tf->codes[19880] = 0x00077c18fe427a0eUL;
   tf->codes[19881] = 0x00077c74b84a83a3UL;
   tf->codes[19882] = 0x00077c81fcb1d245UL;
   tf->codes[19883] = 0x00077c9e9487a376UL;
   tf->codes[19884] = 0x00077d0b3be757fdUL;
   tf->codes[19885] = 0x00077d4bbd73b2ffUL;
   tf->codes[19886] = 0x00077de156d47045UL;
   tf->codes[19887] = 0x00077e124a6342f3UL;
   tf->codes[19888] = 0x00077e141edb711bUL;
   tf->codes[19889] = 0x00077e15f3539f43UL;
   tf->codes[19890] = 0x00077e7381d3d700UL;
   tf->codes[19891] = 0x00077e976b8a60d1UL;
   tf->codes[19892] = 0x00077e9fe236364aUL;
   tf->codes[19893] = 0x00077ee740853e62UL;
   tf->codes[19894] = 0x00077efde5d47991UL;
   tf->codes[19895] = 0x00077f1d76ed95c3UL;
   tf->codes[19896] = 0x00077f3ea1efda58UL;
   tf->codes[19897] = 0x00077f775c7d7130UL;
   tf->codes[19898] = 0x00077f7a55c0bc31UL;
   tf->codes[19899] = 0x00077f8849d51c22UL;
   tf->codes[19900] = 0x00077fd092603b4eUL;
   tf->codes[19901] = 0x00077fd97e2a1c51UL;
   tf->codes[19902] = 0x00077fdbc7c05603UL;
   tf->codes[19903] = 0x00077fdd9c38842bUL;
   tf->codes[19904] = 0x000780031fd8365fUL;
   tf->codes[19905] = 0x000780520a96fcdcUL;
   tf->codes[19906] = 0x0007807076e4fc35UL;
   tf->codes[19907] = 0x00078070ec0307bfUL;
   tf->codes[19908] = 0x0007808be9efb08dUL;
   tf->codes[19909] = 0x0007809007fe1867UL;
   tf->codes[19910] = 0x0007809c9cb855baUL;
   tf->codes[19911] = 0x000780ee462b6173UL;
   tf->codes[19912] = 0x000780ef30677887UL;
   tf->codes[19913] = 0x000780fadae59ec6UL;
   tf->codes[19914] = 0x000781118034d9f5UL;
   tf->codes[19915] = 0x00078145a795fd69UL;
   tf->codes[19916] = 0x0007816956bd8175UL;
   tf->codes[19917] = 0x000781c80a08d60bUL;
   tf->codes[19918] = 0x000781cac8bd1b47UL;
   tf->codes[19919] = 0x0007820a9a9c64faUL;
   tf->codes[19920] = 0x00078257eb720314UL;
   tf->codes[19921] = 0x0007826ae7d0e1f3UL;
   tf->codes[19922] = 0x0007827b600a815bUL;
   tf->codes[19923] = 0x00078285709f7f37UL;
   tf->codes[19924] = 0x000782c507efc325UL;
   tf->codes[19925] = 0x000782ee6f0ed76eUL;
   tf->codes[19926] = 0x0007837564ae2374UL;
   tf->codes[19927] = 0x000783c06bed87dcUL;
   tf->codes[19928] = 0x000783c24065b604UL;
   tf->codes[19929] = 0x000783ce2572e208UL;
   tf->codes[19930] = 0x000783d452887dcfUL;
   tf->codes[19931] = 0x000783d7865ace95UL;
   tf->codes[19932] = 0x000783f36e838e77UL;
   tf->codes[19933] = 0x000784078fad8a2fUL;
   tf->codes[19934] = 0x0007840804cb95b9UL;
   tf->codes[19935] = 0x0007841bb0d785e7UL;
   tf->codes[19936] = 0x000784481139e531UL;
   tf->codes[19937] = 0x000784534699ffe6UL;
   tf->codes[19938] = 0x0007848ceb63add2UL;
   tf->codes[19939] = 0x00078499baacf0eaUL;
   tf->codes[19940] = 0x000784c40c081c47UL;
   tf->codes[19941] = 0x000784daebe65d3bUL;
   tf->codes[19942] = 0x000784e3d7b03e3eUL;
   tf->codes[19943] = 0x000784e91a89c2f1UL;
   tf->codes[19944] = 0x000784f0a6f98156UL;
   tf->codes[19945] = 0x000785596ad9d3c8UL;
   tf->codes[19946] = 0x000785befae7d574UL;
   tf->codes[19947] = 0x000785cceefc3565UL;
   tf->codes[19948] = 0x000785de8c00f1a6UL;
   tf->codes[19949] = 0x000785f6561b49aeUL;
   tf->codes[19950] = 0x00078613288020a4UL;
   tf->codes[19951] = 0x0007862d3c30b25eUL;
   tf->codes[19952] = 0x0007864924597240UL;
   tf->codes[19953] = 0x0007865bab9a4595UL;
   tf->codes[19954] = 0x0007869f9b87f722UL;
   tf->codes[19955] = 0x000786be07d5f67bUL;
   tf->codes[19956] = 0x000786c9b2541cbaUL;
   tf->codes[19957] = 0x000786d94051a50eUL;
   tf->codes[19958] = 0x0007874328fd1459UL;
   tf->codes[19959] = 0x0007874ed37b3a98UL;
   tf->codes[19960] = 0x00078770ae2a907cUL;
   tf->codes[19961] = 0x00078775b6750f6aUL;
   tf->codes[19962] = 0x00078778ea476030UL;
   tf->codes[19963] = 0x000787c6eaca0f99UL;
   tf->codes[19964] = 0x000787c9e40d5a9aUL;
   tf->codes[19965] = 0x000787d553fc7b14UL;
   tf->codes[19966] = 0x000787e9afb57c91UL;
   tf->codes[19967] = 0x0007884569bd8626UL;
   tf->codes[19968] = 0x000788473e35b44eUL;
   tf->codes[19969] = 0x00078885762bd59eUL;
   tf->codes[19970] = 0x00078897884e9d69UL;
   tf->codes[19971] = 0x000788c6a76541efUL;
   tf->codes[19972] = 0x000788c87bdd7017UL;
   tf->codes[19973] = 0x00078917dbba421eUL;
   tf->codes[19974] = 0x0007893a2b87a38cUL;
   tf->codes[19975] = 0x0007897619e78b2aUL;
   tf->codes[19976] = 0x000789e62fa8963cUL;
   tf->codes[19977] = 0x000789f33980df19UL;
   tf->codes[19978] = 0x000789f966967ae0UL;
   tf->codes[19979] = 0x00078a4976205e36UL;
   tf->codes[19980] = 0x00078a4a605c754aUL;
   tf->codes[19981] = 0x00078a7fac88b597UL;
   tf->codes[19982] = 0x00078a8a6ccac4c2UL;
   tf->codes[19983] = 0x00078b500f7e3da2UL;
   tf->codes[19984] = 0x00078b5b0a4f5292UL;
   tf->codes[19985] = 0x00078b7d5a1cb400UL;
   tf->codes[19986] = 0x00078b8c72fc30caUL;
   tf->codes[19987] = 0x00078b9bc66ab359UL;
   tf->codes[19988] = 0x00078bc65254e47bUL;
   tf->codes[19989] = 0x00078bcaaaf2521aUL;
   tf->codes[19990] = 0x00078bd187b4ff30UL;
   tf->codes[19991] = 0x00078bdd3233256fUL;
   tf->codes[19992] = 0x00078bed6fddbf12UL;
   tf->codes[19993] = 0x00078c011be9af40UL;
   tf->codes[19994] = 0x00078c07f8ac5c56UL;
   tf->codes[19995] = 0x00078c2c920ff776UL;
   tf->codes[19996] = 0x00078c366815ef8dUL;
   tf->codes[19997] = 0x00078c3d44d89ca3UL;
   tf->codes[19998] = 0x00078c4df7a141d0UL;
   tf->codes[19999] = 0x00078c58f27256c0UL;
   tf->codes[20000] = 0x00078c91e78ef35dUL;
   tf->codes[20001] = 0x00078ca67dd6fa9fUL;
   tf->codes[20002] = 0x00078cb93fa6d3b9UL;
   tf->codes[20003] = 0x00078cd43d937c87UL;
   tf->codes[20004] = 0x00078d699c653408UL;
   tf->codes[20005] = 0x00078d7c23a6075dUL;
   tf->codes[20006] = 0x00078d892d7e503aUL;
   tf->codes[20007] = 0x00078e0a3097063eUL;
   tf->codes[20008] = 0x00078e539ded4243UL;
   tf->codes[20009] = 0x00078e5e5e2f516eUL;
   tf->codes[20010] = 0x00078e753e0d9262UL;
   tf->codes[20011] = 0x00078e8750305a2dUL;
   tf->codes[20012] = 0x00078ec6e7809e1bUL;
   tf->codes[20013] = 0x00078ef1e888dac7UL;
   tf->codes[20014] = 0x00078f447c37fd94UL;
   tf->codes[20015] = 0x00078f64f78d30daUL;
   tf->codes[20016] = 0x00078f8f0e595672UL;
   tf->codes[20017] = 0x00078fae9f7272a4UL;
   tf->codes[20018] = 0x00078fbb342caff7UL;
   tf->codes[20019] = 0x00078fcee038a025UL;
   tf->codes[20020] = 0x00078fd03f92c2c3UL;
   tf->codes[20021] = 0x0007901937caf33eUL;
   tf->codes[20022] = 0x00079044e8804139UL;
   tf->codes[20023] = 0x000790a3d65a9b94UL;
   tf->codes[20024] = 0x000790f50aaf9bc3UL;
   tf->codes[20025] = 0x00079151aef3bc6cUL;
   tf->codes[20026] = 0x000791530e4ddf0aUL;
   tf->codes[20027] = 0x0007917264d7f577UL;
   tf->codes[20028] = 0x000791734f140c8bUL;
   tf->codes[20029] = 0x0007919da06f37e8UL;
   tf->codes[20030] = 0x000791cfb8c9276fUL;
   tf->codes[20031] = 0x000791fdb314af1cUL;
   tf->codes[20032] = 0x000792036b0c3f59UL;
   tf->codes[20033] = 0x0007924e37bc9dfcUL;
   tf->codes[20034] = 0x0007924f5c87bad5UL;
   tf->codes[20035] = 0x0007928bfa94b3c2UL;
   tf->codes[20036] = 0x00079291b28c43ffUL;
   tf->codes[20037] = 0x000792976a83d43cUL;
   tf->codes[20038] = 0x0007929b4e033651UL;
   tf->codes[20039] = 0x000792bcb39480abUL;
   tf->codes[20040] = 0x000792d39372c19fUL;
   tf->codes[20041] = 0x000792e89ed8d46bUL;
   tf->codes[20042] = 0x000792f02b4892d0UL;
   tf->codes[20043] = 0x0007936dbffff249UL;
   tf->codes[20044] = 0x00079372189d5fe8UL;
   tf->codes[20045] = 0x0007938a57d5c37aUL;
   tf->codes[20046] = 0x000793c4372e772bUL;
   tf->codes[20047] = 0x000793faa825d451UL;
   tf->codes[20048] = 0x0007941d32823b84UL;
   tf->codes[20049] = 0x00079470eafc7b2aUL;
   tf->codes[20050] = 0x0007947ea481d556UL;
   tf->codes[20051] = 0x000794df66d45dd9UL;
   tf->codes[20052] = 0x0007951ec3959c02UL;
   tf->codes[20053] = 0x0007954481c453fbUL;
   tf->codes[20054] = 0x000795540fc1dc4fUL;
   tf->codes[20055] = 0x0007956487fb7bb7UL;
   tf->codes[20056] = 0x000795669702afa4UL;
   tf->codes[20057] = 0x00079585786eba87UL;
   tf->codes[20058] = 0x000795d4289e7b3fUL;
   tf->codes[20059] = 0x000795d930e8fa2dUL;
   tf->codes[20060] = 0x000795dacad22290UL;
   tf->codes[20061] = 0x000795e75f8c5fe3UL;
   tf->codes[20062] = 0x000795fb462755d6UL;
   tf->codes[20063] = 0x000795fce0107e39UL;
   tf->codes[20064] = 0x00079657ea6b767fUL;
   tf->codes[20065] = 0x0007966394e99cbeUL;
   tf->codes[20066] = 0x000796668e2ce7bfUL;
   tf->codes[20067] = 0x0007968d3697b6ccUL;
   tf->codes[20068] = 0x000796bdef9783b5UL;
   tf->codes[20069] = 0x000796dbac3871bfUL;
   tf->codes[20070] = 0x00079712924dda6fUL;
   tf->codes[20071] = 0x0007971884d47071UL;
   tf->codes[20072] = 0x0007976cecfbc166UL;
   tf->codes[20073] = 0x000797b152077e7dUL;
   tf->codes[20074] = 0x000797d5b0dc13d8UL;
   tf->codes[20075] = 0x000797eccb495a91UL;
   tf->codes[20076] = 0x0007987c722381d5UL;
   tf->codes[20077] = 0x0007989aa3e27b69UL;
   tf->codes[20078] = 0x000798c6c9b5d4eeUL;
   tf->codes[20079] = 0x000798ce90b49918UL;
   tf->codes[20080] = 0x000798d866ba912fUL;
   tf->codes[20081] = 0x00079973f2a1e477UL;
   tf->codes[20082] = 0x000799c6fb6f12ceUL;
   tf->codes[20083] = 0x000799da325cf772UL;
   tf->codes[20084] = 0x000799dc7bf33124UL;
   tf->codes[20085] = 0x000799dda0be4dfdUL;
   tf->codes[20086] = 0x000799edde68e7a0UL;
   tf->codes[20087] = 0x000799fb97ee41ccUL;
   tf->codes[20088] = 0x000799fd6c666ff4UL;
   tf->codes[20089] = 0x00079a0f7e8937bfUL;
   tf->codes[20090] = 0x00079a499870f135UL;
   tf->codes[20091] = 0x00079a49d2fff6faUL;
   tf->codes[20092] = 0x00079a56dcd83fd7UL;
   tf->codes[20093] = 0x00079a5e2eb8f877UL;
   tf->codes[20094] = 0x00079a6e6c63921aUL;
   tf->codes[20095] = 0x00079af686cdfaf9UL;
   tf->codes[20096] = 0x00079b1184baa3c7UL;
   tf->codes[20097] = 0x00079b42032b6aebUL;
   tf->codes[20098] = 0x00079b4d388b85a0UL;
   tf->codes[20099] = 0x00079b769faa99e9UL;
   tf->codes[20100] = 0x00079b8edee2fd7bUL;
   tf->codes[20101] = 0x00079c126620f2f6UL;
   tf->codes[20102] = 0x00079c4652f310a5UL;
   tf->codes[20103] = 0x00079c535ccb5982UL;
   tf->codes[20104] = 0x00079c811c87db6aUL;
   tf->codes[20105] = 0x00079c9a808b5bd5UL;
   tf->codes[20106] = 0x00079ccf57999098UL;
   tf->codes[20107] = 0x00079ccf9228965dUL;
   tf->codes[20108] = 0x00079cd84363719bUL;
   tf->codes[20109] = 0x00079cfa1e12c77fUL;
   tf->codes[20110] = 0x00079d02cf4da2bdUL;
   tf->codes[20111] = 0x00079d2c366cb706UL;
   tf->codes[20112] = 0x00079d3a9f9f2281UL;
   tf->codes[20113] = 0x00079d41b6f0d55cUL;
   tf->codes[20114] = 0x00079d5a30b83eb3UL;
   tf->codes[20115] = 0x00079d882b03c660UL;
   tf->codes[20116] = 0x00079d99185b7152UL;
   tf->codes[20117] = 0x00079db993b0a498UL;
   tf->codes[20118] = 0x00079dc872011b9dUL;
   tf->codes[20119] = 0x00079df3387a5284UL;
   tf->codes[20120] = 0x00079e49ea37dd2bUL;
   tf->codes[20121] = 0x00079e6bff7638d4UL;
   tf->codes[20122] = 0x00079e6e839b784bUL;
   tf->codes[20123] = 0x00079e85d897c4c9UL;
   tf->codes[20124] = 0x00079e8c403c6655UL;
   tf->codes[20125] = 0x00079eb482905dc5UL;
   tf->codes[20126] = 0x00079edcff735afaUL;
   tf->codes[20127] = 0x00079f1df61dc186UL;
   tf->codes[20128] = 0x00079f449e889093UL;
   tf->codes[20129] = 0x00079f5600fe470fUL;
   tf->codes[20130] = 0x00079f5bf384dd11UL;
   tf->codes[20131] = 0x00079f8c71f5a435UL;
   tf->codes[20132] = 0x00079ff70a4e24cfUL;
   tf->codes[20133] = 0x0007a04b37e66fffUL;
   tf->codes[20134] = 0x0007a04d0c5e9e27UL;
   tf->codes[20135] = 0x0007a06426cbe4e0UL;
   tf->codes[20136] = 0x0007a065fb441308UL;
   tf->codes[20137] = 0x0007a0dc038bb41cUL;
   tf->codes[20138] = 0x0007a0e738ebced1UL;
   tf->codes[20139] = 0x0007a0e9f7a0140dUL;
   tf->codes[20140] = 0x0007a0f2e369f510UL;
   tf->codes[20141] = 0x0007a0f5a21e3a4cUL;
   tf->codes[20142] = 0x0007a0fb1f86c4c4UL;
   tf->codes[20143] = 0x0007a11a3b81d56cUL;
   tf->codes[20144] = 0x0007a1427dd5ccdcUL;
   tf->codes[20145] = 0x0007a166a21b5c72UL;
   tf->codes[20146] = 0x0007a1678c577386UL;
   tf->codes[20147] = 0x0007a17c97bd8652UL;
   tf->codes[20148] = 0x0007a182ff6227deUL;
   tf->codes[20149] = 0x0007a18757ff957dUL;
   tf->codes[20150] = 0x0007a1c4e048a57eUL;
   tf->codes[20151] = 0x0007a1dad5eacf5eUL;
   tf->codes[20152] = 0x0007a21e50ba7561UL;
   tf->codes[20153] = 0x0007a27c8ee7be6dUL;
   tf->codes[20154] = 0x0007a27dee41e10bUL;
   tf->codes[20155] = 0x0007a28a486d1899UL;
   tf->codes[20156] = 0x0007a2af56eebf43UL;
   tf->codes[20157] = 0x0007a3510febae52UL;
   tf->codes[20158] = 0x0007a3c8b21c77c9UL;
   tf->codes[20159] = 0x0007a3d2c2b175a5UL;
   tf->codes[20160] = 0x0007a3de32a0961fUL;
   tf->codes[20161] = 0x0007a3e00718c447UL;
   tf->codes[20162] = 0x0007a46d645cb1d9UL;
   tf->codes[20163] = 0x0007a496565dba98UL;
   tf->codes[20164] = 0x0007a49c8373565fUL;
   tf->codes[20165] = 0x0007a49de2cd78fdUL;
   tf->codes[20166] = 0x0007a49fb745a725UL;
   tf->codes[20167] = 0x0007a4d2f46ab385UL;
   tf->codes[20168] = 0x0007a4dd7a1dbcebUL;
   tf->codes[20169] = 0x0007a54344bac45cUL;
   tf->codes[20170] = 0x0007a590207256ecUL;
   tf->codes[20171] = 0x0007a614575d5db6UL;
   tf->codes[20172] = 0x0007a62928346abdUL;
   tf->codes[20173] = 0x0007a658f6f82092UL;
   tf->codes[20174] = 0x0007a6d9fa10d696UL;
   tf->codes[20175] = 0x0007a6f35e145701UL;
   tf->codes[20176] = 0x0007a6fe937471b6UL;
   tf->codes[20177] = 0x0007a75fcae505c3UL;
   tf->codes[20178] = 0x0007a793080a1223UL;
   tf->codes[20179] = 0x0007a7af9fdfe354UL;
   tf->codes[20180] = 0x0007a7ffaf69c6aaUL;
   tf->codes[20181] = 0x0007a807eb86965eUL;
   tf->codes[20182] = 0x0007a846989ac338UL;
   tf->codes[20183] = 0x0007a85a44a6b366UL;
   tf->codes[20184] = 0x0007a85a7f35b92bUL;
   tf->codes[20185] = 0x0007a85ffc9e43a3UL;
   tf->codes[20186] = 0x0007a8c676e85c63UL;
   tf->codes[20187] = 0x0007a8f0c84387c0UL;
   tf->codes[20188] = 0x0007a90e84e475caUL;
   tf->codes[20189] = 0x0007a93a3599c3c5UL;
   tf->codes[20190] = 0x0007a97e60167b17UL;
   tf->codes[20191] = 0x0007a98af4d0b86aUL;
   tf->codes[20192] = 0x0007a9aa4b5aced7UL;
   tf->codes[20193] = 0x0007a9c0066df2f2UL;
   tf->codes[20194] = 0x0007a9f293e5ee03UL;
   tf->codes[20195] = 0x0007aa113ac2f321UL;
   tf->codes[20196] = 0x0007aa4fe7d71ffbUL;
   tf->codes[20197] = 0x0007aa52a68b6537UL;
   tf->codes[20198] = 0x0007aa56ff28d2d6UL;
   tf->codes[20199] = 0x0007aa7bd31b73bbUL;
   tf->codes[20200] = 0x0007aa839a1a37e5UL;
   tf->codes[20201] = 0x0007aad19a9ce74eUL;
   tf->codes[20202] = 0x0007aaebe8dc7ecdUL;
   tf->codes[20203] = 0x0007aaed82c5a730UL;
   tf->codes[20204] = 0x0007ab1674c6afefUL;
   tf->codes[20205] = 0x0007ab38ff231722UL;
   tf->codes[20206] = 0x0007ab4dcffa2429UL;
   tf->codes[20207] = 0x0007ab4eba363b3dUL;
   tf->codes[20208] = 0x0007abd27c03367dUL;
   tf->codes[20209] = 0x0007abdc8c983459UL;
   tf->codes[20210] = 0x0007abdf10bd73d0UL;
   tf->codes[20211] = 0x0007ac5010ba95f6UL;
   tf->codes[20212] = 0x0007ac5ad0fca521UL;
   tf->codes[20213] = 0x0007accae6bdb033UL;
   tf->codes[20214] = 0x0007ad0e26fe5071UL;
   tf->codes[20215] = 0x0007ad43e8489c48UL;
   tf->codes[20216] = 0x0007ad4f5837bcc2UL;
   tf->codes[20217] = 0x0007ad784a38c581UL;
   tf->codes[20218] = 0x0007adcf368555edUL;
   tf->codes[20219] = 0x0007adda6be570a2UL;
   tf->codes[20220] = 0x0007adf5a4611f35UL;
   tf->codes[20221] = 0x0007ae082ba1f28aUL;
   tf->codes[20222] = 0x0007ae18a3db91f2UL;
   tf->codes[20223] = 0x0007ae85c0595203UL;
   tf->codes[20224] = 0x0007aeabf3a61586UL;
   tf->codes[20225] = 0x0007aec72c21c419UL;
   tf->codes[20226] = 0x0007aef770038578UL;
   tf->codes[20227] = 0x0007aef9447bb3a0UL;
   tf->codes[20228] = 0x0007af04eef9d9dfUL;
   tf->codes[20229] = 0x0007af67fae29c14UL;
   tf->codes[20230] = 0x0007af7d40d7b4a5UL;
   tf->codes[20231] = 0x0007af7ea031d743UL;
   tf->codes[20232] = 0x0007af8a4aaffd82UL;
   tf->codes[20233] = 0x0007afe888dd468eUL;
   tf->codes[20234] = 0x0007afebf73e9d19UL;
   tf->codes[20235] = 0x0007aff13a1821ccUL;
   tf->codes[20236] = 0x0007aff174a72791UL;
   tf->codes[20237] = 0x0007b01056133274UL;
   tf->codes[20238] = 0x0007b06a763213a6UL;
   tf->codes[20239] = 0x0007b06b9afd307fUL;
   tf->codes[20240] = 0x0007b073276ceee4UL;
   tf->codes[20241] = 0x0007b08deaca91edUL;
   tf->codes[20242] = 0x0007b08e9a77a33cUL;
   tf->codes[20243] = 0x0007b097fb5f8fc9UL;
   tf->codes[20244] = 0x0007b0a50537d8a6UL;
   tf->codes[20245] = 0x0007b0abe1fa85bcUL;
   tf->codes[20246] = 0x0007b0d87cebeacbUL;
   tf->codes[20247] = 0x0007b10bba10f72bUL;
   tf->codes[20248] = 0x0007b117648f1d6aUL;
   tf->codes[20249] = 0x0007b11c324a9693UL;
   tf->codes[20250] = 0x0007b136808a2e12UL;
   tf->codes[20251] = 0x0007b14056902629UL;
   tf->codes[20252] = 0x0007b176526977c5UL;
   tf->codes[20253] = 0x0007b177ec52a028UL;
   tf->codes[20254] = 0x0007b1d9d3704584UL;
   tf->codes[20255] = 0x0007b1dcccb39085UL;
   tf->codes[20256] = 0x0007b208b7f7e445UL;
   tf->codes[20257] = 0x0007b20e6fef7482UL;
   tf->codes[20258] = 0x0007b20fcf499720UL;
   tf->codes[20259] = 0x0007b23c6a3afc2fUL;
   tf->codes[20260] = 0x0007b24ca7e595d2UL;
   tf->codes[20261] = 0x0007b2508b64f7e7UL;
   tf->codes[20262] = 0x0007b25593af76d5UL;
   tf->codes[20263] = 0x0007b2576827a4fdUL;
   tf->codes[20264] = 0x0007b26312a5cb3cUL;
   tf->codes[20265] = 0x0007b29cf1fe7eedUL;
   tf->codes[20266] = 0x0007b2c40f875984UL;
   tf->codes[20267] = 0x0007b2cf44e77439UL;
   tf->codes[20268] = 0x0007b2d1195fa261UL;
   tf->codes[20269] = 0x0007b2f6d78e5a5aUL;
   tf->codes[20270] = 0x0007b36eeedd2f5bUL;
   tf->codes[20271] = 0x0007b373477a9cfaUL;
   tf->codes[20272] = 0x0007b377daa7105eUL;
   tf->codes[20273] = 0x0007b38c366011dbUL;
   tf->codes[20274] = 0x0007b3bae058aad7UL;
   tf->codes[20275] = 0x0007b3d2aa7302dfUL;
   tf->codes[20276] = 0x0007b3d8626a931cUL;
   tf->codes[20277] = 0x0007b40c4f3cb0cbUL;
   tf->codes[20278] = 0x0007b4893446fef5UL;
   tf->codes[20279] = 0x0007b4c104987eb9UL;
   tf->codes[20280] = 0x0007b4c1b4459008UL;
   tf->codes[20281] = 0x0007b4c472f9d544UL;
   tf->codes[20282] = 0x0007b4d64a8d974aUL;
   tf->codes[20283] = 0x0007b4dc02852787UL;
   tf->codes[20284] = 0x0007b4f1f8275167UL;
   tf->codes[20285] = 0x0007b55036549a73UL;
   tf->codes[20286] = 0x0007b552ba79d9eaUL;
   tf->codes[20287] = 0x0007b58d497f9eeaUL;
   tf->codes[20288] = 0x0007b5987edfb99fUL;
   tf->codes[20289] = 0x0007b5da9a553d04UL;
   tf->codes[20290] = 0x0007b60476925cd7UL;
   tf->codes[20291] = 0x0007b63c8172e260UL;
   tf->codes[20292] = 0x0007b640da104fffUL;
   tf->codes[20293] = 0x0007b6456d3cc363UL;
   tf->codes[20294] = 0x0007b6d6e88f18cfUL;
   tf->codes[20295] = 0x0007b6e1a8d127faUL;
   tf->codes[20296] = 0x0007b77f43bfaf2fUL;
   tf->codes[20297] = 0x0007b7898ee3b2d0UL;
   tf->codes[20298] = 0x0007b78e5c9f2bf9UL;
   tf->codes[20299] = 0x0007b79e5fbabfd7UL;
   tf->codes[20300] = 0x0007b7f7207f7e6bUL;
   tf->codes[20301] = 0x0007b7fa8ee0d4f6UL;
   tf->codes[20302] = 0x0007b81726b6a627UL;
   tf->codes[20303] = 0x0007b85fe45fd0ddUL;
   tf->codes[20304] = 0x0007b89fb63f1a90UL;
   tf->codes[20305] = 0x0007b8e7148e22a8UL;
   tf->codes[20306] = 0x0007b9133a617c2dUL;
   tf->codes[20307] = 0x0007b95e7c2fe65aUL;
   tf->codes[20308] = 0x0007b9ec1402d9b1UL;
   tf->codes[20309] = 0x0007ba1839d63336UL;
   tf->codes[20310] = 0x0007ba5f5d963589UL;
   tf->codes[20311] = 0x0007bac94641a4d4UL;
   tf->codes[20312] = 0x0007bacbca66e44bUL;
   tf->codes[20313] = 0x0007baf77b1c3246UL;
   tf->codes[20314] = 0x0007bb0ab20a16eaUL;
   tf->codes[20315] = 0x0007bb0d362f5661UL;
   tf->codes[20316] = 0x0007bb0de5dc67b0UL;
   tf->codes[20317] = 0x0007bb5927aad1ddUL;
   tf->codes[20318] = 0x0007bb5e2ff550cbUL;
   tf->codes[20319] = 0x0007bb5e6a845690UL;
   tf->codes[20320] = 0x0007bbb974df4ed6UL;
   tf->codes[20321] = 0x0007bbc34ae546edUL;
   tf->codes[20322] = 0x0007bc669dcb5e5fUL;
   tf->codes[20323] = 0x0007bc7073d15676UL;
   tf->codes[20324] = 0x0007bc83aabf3b1aUL;
   tf->codes[20325] = 0x0007bcc2ccf1737eUL;
   tf->codes[20326] = 0x0007bcc6b070d593UL;
   tf->codes[20327] = 0x0007bcfb1260feccUL;
   tf->codes[20328] = 0x0007bd0caf65bb0dUL;
   tf->codes[20329] = 0x0007bd4da6102199UL;
   tf->codes[20330] = 0x0007bd9872c0803cUL;
   tf->codes[20331] = 0x0007bd9eda6521c8UL;
   tf->codes[20332] = 0x0007bd9fc4a138dcUL;
   tf->codes[20333] = 0x0007bdc2feaab15eUL;
   tf->codes[20334] = 0x0007be505bee9ef0UL;
   tf->codes[20335] = 0x0007be5e8a9204a6UL;
   tf->codes[20336] = 0x0007be9e5c714e59UL;
   tf->codes[20337] = 0x0007bec713e35153UL;
   tf->codes[20338] = 0x0007bec8adcc79b6UL;
   tf->codes[20339] = 0x0007bed1d425607eUL;
   tf->codes[20340] = 0x0007bedf8daabaaaUL;
   tf->codes[20341] = 0x0007bf18f7e562d1UL;
   tf->codes[20342] = 0x0007bf19a7927420UL;
   tf->codes[20343] = 0x0007bf501889d146UL;
   tf->codes[20344] = 0x0007bf5b8878f1c0UL;
   tf->codes[20345] = 0x0007bf6cb05fa277UL;
   tf->codes[20346] = 0x0007bfc5abb366d0UL;
   tf->codes[20347] = 0x0007bfd2b58bafadUL;
   tf->codes[20348] = 0x0007bff0e74aa941UL;
   tf->codes[20349] = 0x0007bff8e8d87330UL;
   tf->codes[20350] = 0x0007c012c1f9ff25UL;
   tf->codes[20351] = 0x0007c04514e2f471UL;
   tf->codes[20352] = 0x0007c05308f75462UL;
   tf->codes[20353] = 0x0007c05d8eaa5dc8UL;
   tf->codes[20354] = 0x0007c075cde2c15aUL;
   tf->codes[20355] = 0x0007c07fde77bf36UL;
   tf->codes[20356] = 0x0007c0c09a931ffdUL;
   tf->codes[20357] = 0x0007c12f8b890e36UL;
   tf->codes[20358] = 0x0007c159a25533ceUL;
   tf->codes[20359] = 0x0007c1adcfed7efeUL;
   tf->codes[20360] = 0x0007c1c524e9cb7cUL;
   tf->codes[20361] = 0x0007c1c81e2d167dUL;
   tf->codes[20362] = 0x0007c1ce4b42b244UL;
   tf->codes[20363] = 0x0007c1ef7644f6d9UL;
   tf->codes[20364] = 0x0007c1fc0aff342cUL;
   tf->codes[20365] = 0x0007c21066b835a9UL;
   tf->codes[20366] = 0x0007c2123b3063d1UL;
   tf->codes[20367] = 0x0007c2578a7837fcUL;
   tf->codes[20368] = 0x0007c274d1fb1a7cUL;
   tf->codes[20369] = 0x0007c28166b557cfUL;
   tf->codes[20370] = 0x0007c2d3bfd574d7UL;
   tf->codes[20371] = 0x0007c2de80178402UL;
   tf->codes[20372] = 0x0007c2f4ead7b96cUL;
   tf->codes[20373] = 0x0007c30ec3f94561UL;
   tf->codes[20374] = 0x0007c3e37f8c3b0bUL;
   tf->codes[20375] = 0x0007c3ec30c71649UL;
   tf->codes[20376] = 0x0007c4586308bf46UL;
   tf->codes[20377] = 0x0007c45912b5d095UL;
   tf->codes[20378] = 0x0007c46f0857fa75UL;
   tf->codes[20379] = 0x0007c4bd7df8b568UL;
   tf->codes[20380] = 0x0007c50b7e7b64d1UL;
   tf->codes[20381] = 0x0007c50d52f392f9UL;
   tf->codes[20382] = 0x0007c51d560f26d7UL;
   tf->codes[20383] = 0x0007c54857176383UL;
   tf->codes[20384] = 0x0007c54aa0ad9d35UL;
   tf->codes[20385] = 0x0007c55142e14486UL;
   tf->codes[20386] = 0x0007c568d26c96c9UL;
   tf->codes[20387] = 0x0007c57bcecb75a8UL;
   tf->codes[20388] = 0x0007c58a728ce6e8UL;
   tf->codes[20389] = 0x0007c5cf8745b54eUL;
   tf->codes[20390] = 0x0007c5daf734d5c8UL;
   tf->codes[20391] = 0x0007c5eea340c5f6UL;
   tf->codes[20392] = 0x0007c6154bab9503UL;
   tf->codes[20393] = 0x0007c64c6c500378UL;
   tf->codes[20394] = 0x0007c667df5ab7d0UL;
   tf->codes[20395] = 0x0007c679f17d7f9bUL;
   tf->codes[20396] = 0x0007c69230b5e32dUL;
   tf->codes[20397] = 0x0007c69effff2645UL;
   tf->codes[20398] = 0x0007c74a547307a6UL;
   tf->codes[20399] = 0x0007c7b318535a18UL;
   tf->codes[20400] = 0x0007c7d10f834de7UL;
   tf->codes[20401] = 0x0007c7d9862f2360UL;
   tf->codes[20402] = 0x0007c7e4f61e43daUL;
   tf->codes[20403] = 0x0007c90d6a2b792aUL;
   tf->codes[20404] = 0x0007c9189f8b93dfUL;
   tf->codes[20405] = 0x0007c952445541cbUL;
   tf->codes[20406] = 0x0007c958abf9e357UL;
   tf->codes[20407] = 0x0007c962f71de6f8UL;
   tf->codes[20408] = 0x0007c964cb961520UL;
   tf->codes[20409] = 0x0007c97a86a9393bUL;
   tf->codes[20410] = 0x0007c9c21f874718UL;
   tf->codes[20411] = 0x0007c9f81b6098b4UL;
   tf->codes[20412] = 0x0007ca42e810f757UL;
   tf->codes[20413] = 0x0007ca52760e7fabUL;
   tf->codes[20414] = 0x0007ca732bf2b8b6UL;
   tf->codes[20415] = 0x0007ca7cc769ab08UL;
   tf->codes[20416] = 0x0007cb155a0db34fUL;
   tf->codes[20417] = 0x0007cb62aae35169UL;
   tf->codes[20418] = 0x0007cb95ad795804UL;
   tf->codes[20419] = 0x0007cbebaf89d15cUL;
   tf->codes[20420] = 0x0007cc1fd6eaf4d0UL;
   tf->codes[20421] = 0x0007cc3014958e73UL;
   tf->codes[20422] = 0x0007cc53c3bd127fUL;
   tf->codes[20423] = 0x0007cc6fabe5d261UL;
   tf->codes[20424] = 0x0007cc71baed064eUL;
   tf->codes[20425] = 0x0007cca8db9174c3UL;
   tf->codes[20426] = 0x0007ccd033a9551fUL;
   tf->codes[20427] = 0x0007cd0b37cd25a9UL;
   tf->codes[20428] = 0x0007cd1498b51236UL;
   tf->codes[20429] = 0x0007cd78544ae5baUL;
   tf->codes[20430] = 0x0007cd7a9de11f6cUL;
   tf->codes[20431] = 0x0007cd97aad4fc27UL;
   tf->codes[20432] = 0x0007cdfba0f9d570UL;
   tf->codes[20433] = 0x0007ce0158f165adUL;
   tf->codes[20434] = 0x0007ce01ce0f7137UL;
   tf->codes[20435] = 0x0007ce6882e88fbcUL;
   tf->codes[20436] = 0x0007ce72ce0c935dUL;
   tf->codes[20437] = 0x0007ced59f664fcdUL;
   tf->codes[20438] = 0x0007ced614845b57UL;
   tf->codes[20439] = 0x0007cef0d7e1fe60UL;
   tf->codes[20440] = 0x0007cf0bd5cea72eUL;
   tf->codes[20441] = 0x0007cf854c779ecdUL;
   tf->codes[20442] = 0x0007cff9bad6177eUL;
   tf->codes[20443] = 0x0007d00ec63c2a4aUL;
   tf->codes[20444] = 0x0007d042036136aaUL;
   tf->codes[20445] = 0x0007d05b2cd5b150UL;
   tf->codes[20446] = 0x0007d05e9b3707dbUL;
   tf->codes[20447] = 0x0007d08c206483feUL;
   tf->codes[20448] = 0x0007d0c2cbeae6e9UL;
   tf->codes[20449] = 0x0007d0c4a0631511UL;
   tf->codes[20450] = 0x0007d1131603d004UL;
   tf->codes[20451] = 0x0007d1238e3d6f6cUL;
   tf->codes[20452] = 0x0007d153d21f30cbUL;
   tf->codes[20453] = 0x0007d1582abc9e6aUL;
   tf->codes[20454] = 0x0007d1869a2631a1UL;
   tf->codes[20455] = 0x0007d19662b2bfbaUL;
   tf->codes[20456] = 0x0007d19a0ba31c0aUL;
   tf->codes[20457] = 0x0007d1b9d74b3e01UL;
   tf->codes[20458] = 0x0007d1cee2b150cdUL;
   tf->codes[20459] = 0x0007d1e6723ca310UL;
   tf->codes[20460] = 0x0007d1f42bc1fd3cUL;
   tf->codes[20461] = 0x0007d1ff2693122cUL;
   tf->codes[20462] = 0x0007d21d92e11185UL;
   tf->codes[20463] = 0x0007d24943965f80UL;
   tf->codes[20464] = 0x0007d2714b5b512bUL;
   tf->codes[20465] = 0x0007d276c8c3dba3UL;
   tf->codes[20466] = 0x0007d27eca51a592UL;
   tf->codes[20467] = 0x0007d2cb6b7a325dUL;
   tf->codes[20468] = 0x0007d2d57c0f3039UL;
   tf->codes[20469] = 0x0007d2edbb4793cbUL;
   tf->codes[20470] = 0x0007d30b77e881d5UL;
   tf->codes[20471] = 0x0007d318f6ded63cUL;
   tf->codes[20472] = 0x0007d37c77e5a3fbUL;
   tf->codes[20473] = 0x0007d37cb274a9c0UL;
   tf->codes[20474] = 0x0007d39f3cd110f3UL;
   tf->codes[20475] = 0x0007d3c61fcae5c5UL;
   tf->codes[20476] = 0x0007d407c6225da0UL;
   tf->codes[20477] = 0x0007d47e7e171003UL;
   tf->codes[20478] = 0x0007d49264b205f6UL;
   tf->codes[20479] = 0x0007d494e8d7456dUL;
   tf->codes[20480] = 0x0007d497e21a906eUL;
   tf->codes[20481] = 0x0007d49fe3a85a5dUL;
   tf->codes[20482] = 0x0007d4b09670ff8aUL;
   tf->codes[20483] = 0x0007d4c7764f407eUL;
   tf->codes[20484] = 0x0007d4ef08f6269fUL;
   tf->codes[20485] = 0x0007d535f227232dUL;
   tf->codes[20486] = 0x0007d540b2693258UL;
   tf->codes[20487] = 0x0007d55423e61cc1UL;
   tf->codes[20488] = 0x0007d56969db3552UL;
   tf->codes[20489] = 0x0007d58467c7de20UL;
   tf->codes[20490] = 0x0007d5946ae371feUL;
   tf->codes[20491] = 0x0007d5af68d01accUL;
   tf->codes[20492] = 0x0007d5f26e81b545UL;
   tf->codes[20493] = 0x0007d60cbcc14cc4UL;
   tf->codes[20494] = 0x0007d61de4a7fd7bUL;
   tf->codes[20495] = 0x0007d63698fe6c97UL;
   tf->codes[20496] = 0x0007d66e2ec0e696UL;
   tf->codes[20497] = 0x0007d6c46b6065b3UL;
   tf->codes[20498] = 0x0007d6c6ef85a52aUL;
   tf->codes[20499] = 0x0007d6e6460fbb97UL;
   tf->codes[20500] = 0x0007d6e7304bd2abUL;
   tf->codes[20501] = 0x0007d6e9b4711222UL;
   tf->codes[20502] = 0x0007d6fadc57c2d9UL;
   tf->codes[20503] = 0x0007d6fc3bb1e577UL;
   tf->codes[20504] = 0x0007d76cc690fc13UL;
   tf->codes[20505] = 0x0007d78edbcf57bcUL;
   tf->codes[20506] = 0x0007d80bfb68ababUL;
   tf->codes[20507] = 0x0007d80cab15bcfaUL;
   tf->codes[20508] = 0x0007d84d67311dc1UL;
   tf->codes[20509] = 0x0007d855dddcf33aUL;
   tf->codes[20510] = 0x0007d85777c61b9dUL;
   tf->codes[20511] = 0x0007d887f636e2c1UL;
   tf->codes[20512] = 0x0007d8e968367c93UL;
   tf->codes[20513] = 0x0007d965d822bf33UL;
   tf->codes[20514] = 0x0007d979bebdb526UL;
   tf->codes[20515] = 0x0007d9cc17ddd22eUL;
   tf->codes[20516] = 0x0007d9ed42e016c3UL;
   tf->codes[20517] = 0x0007d9fd808ab066UL;
   tf->codes[20518] = 0x0007da146068f15aUL;
   tf->codes[20519] = 0x0007da1809594daaUL;
   tf->codes[20520] = 0x0007da36eac5588dUL;
   tf->codes[20521] = 0x0007dacda8f132acUL;
   tf->codes[20522] = 0x0007dad98dfe5eb0UL;
   tf->codes[20523] = 0x0007daea40c703ddUL;
   tf->codes[20524] = 0x0007db1c1e91ed9fUL;
   tf->codes[20525] = 0x0007db1e2d99218cUL;
   tf->codes[20526] = 0x0007db58820fe0c7UL;
   tf->codes[20527] = 0x0007db596c4bf7dbUL;
   tf->codes[20528] = 0x0007db73ba8b8f5aUL;
   tf->codes[20529] = 0x0007db7a5cbf36abUL;
   tf->codes[20530] = 0x0007db8766977f88UL;
   tf->codes[20531] = 0x0007dbafe37a7cbdUL;
   tf->codes[20532] = 0x0007dbe1fbd46c44UL;
   tf->codes[20533] = 0x0007dbf02a77d1faUL;
   tf->codes[20534] = 0x0007dc41d3eaddb3UL;
   tf->codes[20535] = 0x0007dc578efe01ceUL;
   tf->codes[20536] = 0x0007dc7a8e78748bUL;
   tf->codes[20537] = 0x0007dc9133c7afbaUL;
   tf->codes[20538] = 0x0007dcc4365db655UL;
   tf->codes[20539] = 0x0007dcee87b8e1b2UL;
   tf->codes[20540] = 0x0007dcf4b4ce7d79UL;
   tf->codes[20541] = 0x0007dd4af16dfc96UL;
   tf->codes[20542] = 0x0007dd8b72fa5798UL;
   tf->codes[20543] = 0x0007ddc6ec3c33acUL;
   tf->codes[20544] = 0x0007ddda5db91e15UL;
   tf->codes[20545] = 0x0007ddeeb9721f92UL;
   tf->codes[20546] = 0x0007de1736551cc7UL;
   tf->codes[20547] = 0x0007de5fb96f41b8UL;
   tf->codes[20548] = 0x0007de68dfc82880UL;
   tf->codes[20549] = 0x0007de6f0cddc447UL;
   tf->codes[20550] = 0x0007de99d356fb2eUL;
   tf->codes[20551] = 0x0007decac6e5cddcUL;
   tf->codes[20552] = 0x0007ded6abf2f9e0UL;
   tf->codes[20553] = 0x0007def2941bb9c2UL;
   tf->codes[20554] = 0x0007df5e8bce5cfaUL;
   tf->codes[20555] = 0x0007df962190d6f9UL;
   tf->codes[20556] = 0x0007dfd41ef7f284UL;
   tf->codes[20557] = 0x0007dff12bebcf3fUL;
   tf->codes[20558] = 0x0007e005c233d681UL;
   tf->codes[20559] = 0x0007e00bef497248UL;
   tf->codes[20560] = 0x0007e0121c5f0e0fUL;
   tf->codes[20561] = 0x0007e091faaca73aUL;
   tf->codes[20562] = 0x0007e0c363598572UL;
   tf->codes[20563] = 0x0007e0ccfed077c4UL;
   tf->codes[20564] = 0x0007e14d8ccb223eUL;
   tf->codes[20565] = 0x0007e153f46fc3caUL;
   tf->codes[20566] = 0x0007e197e45d7557UL;
   tf->codes[20567] = 0x0007e23e3086d7caUL;
   tf->codes[20568] = 0x0007e24d0ed74ecfUL;
   tf->codes[20569] = 0x0007e24e6e31716dUL;
   tf->codes[20570] = 0x0007e24ea8c07732UL;
   tf->codes[20571] = 0x0007e25f96182224UL;
   tf->codes[20572] = 0x0007e27b43b1dc41UL;
   tf->codes[20573] = 0x0007e29a9a3bf2aeUL;
   tf->codes[20574] = 0x0007e2fda624b4e3UL;
   tf->codes[20575] = 0x0007e3165a7b23ffUL;
   tf->codes[20576] = 0x0007e3198e4d74c5UL;
   tf->codes[20577] = 0x0007e376a7afa0f8UL;
   tf->codes[20578] = 0x0007e37ee3cc70acUL;
   tf->codes[20579] = 0x0007e39046422728UL;
   tf->codes[20580] = 0x0007e393b4a37db3UL;
   tf->codes[20581] = 0x0007e4173be1732eUL;
   tf->codes[20582] = 0x0007e42e90ddbfacUL;
   tf->codes[20583] = 0x0007e435a82f7287UL;
   tf->codes[20584] = 0x0007e44f46c1f8b7UL;
   tf->codes[20585] = 0x0007e46ed7db14e9UL;
   tf->codes[20586] = 0x0007e4dc2ee7dabfUL;
   tf->codes[20587] = 0x0007e4de787e1471UL;
   tf->codes[20588] = 0x0007e4f08aa0dc3cUL;
   tf->codes[20589] = 0x0007e50b888d850aUL;
   tf->codes[20590] = 0x0007e50ce7e7a7a8UL;
   tf->codes[20591] = 0x0007e5152404775cUL;
   tf->codes[20592] = 0x0007e55c82537f74UL;
   tf->codes[20593] = 0x0007e584ff367ca9UL;
   tf->codes[20594] = 0x0007e5d66e1a829dUL;
   tf->codes[20595] = 0x0007e5ef5cfff77eUL;
   tf->codes[20596] = 0x0007e60d542feb4dUL;
   tf->codes[20597] = 0x0007e63fe1a7e65eUL;
   tf->codes[20598] = 0x0007e6443a4553fdUL;
   tf->codes[20599] = 0x0007e6c368e5dbd9UL;
   tf->codes[20600] = 0x0007e6d57b08a3a4UL;
   tf->codes[20601] = 0x0007e717967e2709UL;
   tf->codes[20602] = 0x0007e74a5e8527dfUL;
   tf->codes[20603] = 0x0007e759ec82b033UL;
   tf->codes[20604] = 0x0007e78737212691UL;
   tf->codes[20605] = 0x0007e7df82c7d99bUL;
   tf->codes[20606] = 0x0007e7fdef15d8f4UL;
   tf->codes[20607] = 0x0007e856afda9788UL;
   tf->codes[20608] = 0x0007e8634494d4dbUL;
   tf->codes[20609] = 0x0007e8684cdf53c9UL;
   tf->codes[20610] = 0x0007e8d68e2830b3UL;
   tf->codes[20611] = 0x0007e8f116f6cdf7UL;
   tf->codes[20612] = 0x0007e8f1c6a3df46UL;
   tf->codes[20613] = 0x0007e9616746deceUL;
   tf->codes[20614] = 0x0007e97672acf19aUL;
   tf->codes[20615] = 0x0007e9be461a053cUL;
   tf->codes[20616] = 0x0007e9c29eb772dbUL;
   tf->codes[20617] = 0x0007e9c68236d4f0UL;
   tf->codes[20618] = 0x0007e9e8d204365eUL;
   tf->codes[20619] = 0x0007e9e9472241e8UL;
   tf->codes[20620] = 0x0007e9fd2dbd37dbUL;
   tf->codes[20621] = 0x0007ea186638e66eUL;
   tf->codes[20622] = 0x0007ea55ee81f66fUL;
   tf->codes[20623] = 0x0007ea6f17f67115UL;
   tf->codes[20624] = 0x0007eacd1b94b45cUL;
   tf->codes[20625] = 0x0007eace405fd135UL;
   tf->codes[20626] = 0x0007eadb4a381a12UL;
   tf->codes[20627] = 0x0007eae29c18d2b2UL;
   tf->codes[20628] = 0x0007eae6f4b64051UL;
   tf->codes[20629] = 0x0007eae7def25765UL;
   tf->codes[20630] = 0x0007eaf13fda43f2UL;
   tf->codes[20631] = 0x0007ebc217edd787UL;
   tf->codes[20632] = 0x0007ebcbb364c9d9UL;
   tf->codes[20633] = 0x0007ebd6ae35dec9UL;
   tf->codes[20634] = 0x0007ebf0c1e67083UL;
   tf->codes[20635] = 0x0007ec09763cdf9fUL;
   tf->codes[20636] = 0x0007ec126206c0a2UL;
   tf->codes[20637] = 0x0007ec4a32584066UL;
   tf->codes[20638] = 0x0007ec8aee73a12dUL;
   tf->codes[20639] = 0x0007ecd21233a380UL;
   tf->codes[20640] = 0x0007ecebeb552f75UL;
   tf->codes[20641] = 0x0007ecf3b253f39fUL;
   tf->codes[20642] = 0x0007ed476ace3345UL;
   tf->codes[20643] = 0x0007ed7c074d6243UL;
   tf->codes[20644] = 0x0007ed84b8883d81UL;
   tf->codes[20645] = 0x0007ed94f632d724UL;
   tf->codes[20646] = 0x0007ed96caab054cUL;
   tf->codes[20647] = 0x0007edd0aa03b8fdUL;
   tf->codes[20648] = 0x0007edd368b7fe39UL;
   tf->codes[20649] = 0x0007ee1f94c27f7aUL;
   tf->codes[20650] = 0x0007ee2d4e47d9a6UL;
   tf->codes[20651] = 0x0007ee3a58202283UL;
   tf->codes[20652] = 0x0007ee64e40a53a5UL;
   tf->codes[20653] = 0x0007ee8a67aa05d9UL;
   tf->codes[20654] = 0x0007ee985bbe65caUL;
   tf->codes[20655] = 0x0007eed77df09e2eUL;
   tf->codes[20656] = 0x0007eefd76ae5becUL;
   tf->codes[20657] = 0x0007ef07874359c8UL;
   tf->codes[20658] = 0x0007ef500a5d7eb9UL;
   tf->codes[20659] = 0x0007ef5b7a4c9f33UL;
   tf->codes[20660] = 0x0007effc0e7e7169UL;
   tf->codes[20661] = 0x0007f046db2ed00cUL;
   tf->codes[20662] = 0x0007f0849e06e5d2UL;
   tf->codes[20663] = 0x0007f09dc77b6078UL;
   tf->codes[20664] = 0x0007f173a7d972fbUL;
   tf->codes[20665] = 0x0007f17f17c89375UL;
   tf->codes[20666] = 0x0007f17fc775a4c4UL;
   tf->codes[20667] = 0x0007f1819bedd2ecUL;
   tf->codes[20668] = 0x0007f188b33f85c7UL;
   tf->codes[20669] = 0x0007f1bb7b46869dUL;
   tf->codes[20670] = 0x0007f1c08391058bUL;
   tf->codes[20671] = 0x0007f1ebf9b74dc1UL;
   tf->codes[20672] = 0x0007f21909c6be5aUL;
   tf->codes[20673] = 0x0007f263d6771cfdUL;
   tf->codes[20674] = 0x0007f2c498c9a580UL;
   tf->codes[20675] = 0x0007f2f258862768UL;
   tf->codes[20676] = 0x0007f3490a43b20fUL;
   tf->codes[20677] = 0x0007f376ca0033f7UL;
   tf->codes[20678] = 0x0007f37a72f09047UL;
   tf->codes[20679] = 0x0007f44fde309740UL;
   tf->codes[20680] = 0x0007f47ec2b83601UL;
   tf->codes[20681] = 0x0007f4923435206aUL;
   tf->codes[20682] = 0x0007f4a56b23050eUL;
   tf->codes[20683] = 0x0007f4c5e6783854UL;
   tf->codes[20684] = 0x0007f4cf476024e1UL;
   tf->codes[20685] = 0x0007f4f69f78053dUL;
   tf->codes[20686] = 0x0007f506a293991bUL;
   tf->codes[20687] = 0x0007f50f53ce7459UL;
   tf->codes[20688] = 0x0007f512fcbed0a9UL;
   tf->codes[20689] = 0x0007f5793c79e3a4UL;
   tf->codes[20690] = 0x0007f590cc0535e7UL;
   tf->codes[20691] = 0x0007f5976e38dd38UL;
   tf->codes[20692] = 0x0007f5cf03fb5737UL;
   tf->codes[20693] = 0x0007f654d4cf8664UL;
   tf->codes[20694] = 0x0007f68e3f0a2e8bUL;
   tf->codes[20695] = 0x0007f6caa28821b3UL;
   tf->codes[20696] = 0x0007f6ea33a13de5UL;
   tf->codes[20697] = 0x0007f6faabdadd4dUL;
   tf->codes[20698] = 0x0007f71b27301093UL;
   tf->codes[20699] = 0x0007f757501efdf6UL;
   tf->codes[20700] = 0x0007f7703f0472d7UL;
   tf->codes[20701] = 0x0007f7833b6351b6UL;
   tf->codes[20702] = 0x0007f79eae6e060eUL;
   tf->codes[20703] = 0x0007f7beef34338fUL;
   tf->codes[20704] = 0x0007f7ee48d9dddaUL;
   tf->codes[20705] = 0x0007f7f9b8c8fe54UL;
   tf->codes[20706] = 0x0007f807e76c640aUL;
   tf->codes[20707] = 0x0007f863dc037364UL;
   tf->codes[20708] = 0x0007f87abbe1b458UL;
   tf->codes[20709] = 0x0007f8d2926a5bd8UL;
   tf->codes[20710] = 0x0007f8f93ad52ae5UL;
   tf->codes[20711] = 0x0007f90cac52154eUL;
   tf->codes[20712] = 0x0007f91fe33ff9f2UL;
   tf->codes[20713] = 0x0007f94442148f4dUL;
   tf->codes[20714] = 0x0007f94700c8d489UL;
   tf->codes[20715] = 0x0007f9c8b38e9bdcUL;
   tf->codes[20716] = 0x0007f9d12a3a7155UL;
   tf->codes[20717] = 0x0007f9de3412ba32UL;
   tf->codes[20718] = 0x0007f9f21aadb025UL;
   tf->codes[20719] = 0x0007fa794adc01f0UL;
   tf->codes[20720] = 0x0007fa9e1ecea2d5UL;
   tf->codes[20721] = 0x0007fae99b2c12c7UL;
   tf->codes[20722] = 0x0007faeb35153b2aUL;
   tf->codes[20723] = 0x0007fb38c079df09UL;
   tf->codes[20724] = 0x0007fb451aa51697UL;
   tf->codes[20725] = 0x0007fb49e8608fc0UL;
   tf->codes[20726] = 0x0007fb693eeaa62dUL;
   tf->codes[20727] = 0x0007fb82a2ee2698UL;
   tf->codes[20728] = 0x0007fbc150025372UL;
   tf->codes[20729] = 0x0007fbc5e32ec6d6UL;
   tf->codes[20730] = 0x0007fbd9c9c9bcc9UL;
   tf->codes[20731] = 0x0007fbeab72167bbUL;
   tf->codes[20732] = 0x0007fc4168def262UL;
   tf->codes[20733] = 0x0007fc4cd8ce12dcUL;
   tf->codes[20734] = 0x0007fc534072b468UL;
   tf->codes[20735] = 0x0007fc66ec7ea496UL;
   tf->codes[20736] = 0x0007fc7087f596e8UL;
   tf->codes[20737] = 0x0007fc79ae4e7db0UL;
   tf->codes[20738] = 0x0007fce94ef17d38UL;
   tf->codes[20739] = 0x0007fd0b9ebedea6UL;
   tf->codes[20740] = 0x0007fd65beddbfd8UL;
   tf->codes[20741] = 0x0007fdf26c749c1bUL;
   tf->codes[20742] = 0x0007fdf9be5554bbUL;
   tf->codes[20743] = 0x0007fe0ae63c0572UL;
   tf->codes[20744] = 0x0007fe0b5b5a10fcUL;
   tf->codes[20745] = 0x0007fe465f7de186UL;
   tf->codes[20746] = 0x0007fe56d7b780eeUL;
   tf->codes[20747] = 0x0007fe6999875a08UL;
   tf->codes[20748] = 0x0007fe75f3b29196UL;
   tf->codes[20749] = 0x0007feaa1b13b50aUL;
   tf->codes[20750] = 0x0007feb9e3a04323UL;
   tf->codes[20751] = 0x0007fecf9eb3673eUL;
   tf->codes[20752] = 0x0007fef681ad3c10UL;
   tf->codes[20753] = 0x0007ff10cfecd38fUL;
   tf->codes[20754] = 0x0007ff748b82a713UL;
   tf->codes[20755] = 0x0007ffc759c0cfa5UL;
   tf->codes[20756] = 0x0007ffd75cdc6383UL;
   tf->codes[20757] = 0x000800129b8f39d2UL;
   tf->codes[20758] = 0x00080048d1f79133UL;
   tf->codes[20759] = 0x0008004aa66fbf5bUL;
   tf->codes[20760] = 0x00080052e28c8f0fUL;
   tf->codes[20761] = 0x00080057ead70dfdUL;
   tf->codes[20762] = 0x00080069fcf9d5c8UL;
   tf->codes[20763] = 0x0008006b96e2fe2bUL;
   tf->codes[20764] = 0x000800709f2d7d19UL;
   tf->codes[20765] = 0x0008009bdac4bf8aUL;
   tf->codes[20766] = 0x0008009f0e971050UL;
   tf->codes[20767] = 0x000800c750eb07c0UL;
   tf->codes[20768] = 0x000800c99a814172UL;
   tf->codes[20769] = 0x000800cf5278d1afUL;
   tf->codes[20770] = 0x000800d83e42b2b2UL;
   tf->codes[20771] = 0x000800dd468d31a0UL;
   tf->codes[20772] = 0x000800f217643ea7UL;
   tf->codes[20773] = 0x0008014226ee21fdUL;
   tf->codes[20774] = 0x0008014e468a53c6UL;
   tf->codes[20775] = 0x000801526498bba0UL;
   tf->codes[20776] = 0x0008015cea4bc506UL;
   tf->codes[20777] = 0x00080162a2435543UL;
   tf->codes[20778] = 0x0008016a2eb313a8UL;
   tf->codes[20779] = 0x0008017a6c5dad4bUL;
   tf->codes[20780] = 0x0008017bcbb7cfe9UL;
   tf->codes[20781] = 0x0008018407d49f9dUL;
   tf->codes[20782] = 0x00080192e62516a2UL;
   tf->codes[20783] = 0x0008019ecb3242a6UL;
   tf->codes[20784] = 0x000801c06b5292c5UL;
   tf->codes[20785] = 0x000801c1caacb563UL;
   tf->codes[20786] = 0x000801c44ed1f4daUL;
   tf->codes[20787] = 0x000801cab6769666UL;
   tf->codes[20788] = 0x000801d9cf561330UL;
   tf->codes[20789] = 0x000801ddb2d57545UL;
   tf->codes[20790] = 0x0008020336752779UL;
   tf->codes[20791] = 0x00080216a7f211e2UL;
   tf->codes[20792] = 0x00080241e3895453UL;
   tf->codes[20793] = 0x00080254303b21e3UL;
   tf->codes[20794] = 0x0008025dcbb21435UL;
   tf->codes[20795] = 0x0008025e40d01fbfUL;
   tf->codes[20796] = 0x0008026592b0d85fUL;
   tf->codes[20797] = 0x0008029c3e373b4aUL;
   tf->codes[20798] = 0x000802c988d5b1a8UL;
   tf->codes[20799] = 0x000802cb22beda0bUL;
   tf->codes[20800] = 0x000802cc8218fca9UL;
   tf->codes[20801] = 0x000802cecbaf365bUL;
   tf->codes[20802] = 0x000802d4f8c4d222UL;
   tf->codes[20803] = 0x000802da3b9e56d5UL;
   tf->codes[20804] = 0x000802f39fa1d740UL;
   tf->codes[20805] = 0x000802fa7c648456UL;
   tf->codes[20806] = 0x000803095ab4fb5bUL;
   tf->codes[20807] = 0x0008034c606695d4UL;
   tf->codes[20808] = 0x000803621b79b9efUL;
   tf->codes[20809] = 0x000803763ca3b5a7UL;
   tf->codes[20810] = 0x0008037cded75cf8UL;
   tf->codes[20811] = 0x00080381ac92d621UL;
   tf->codes[20812] = 0x00080394a8f1b500UL;
   tf->codes[20813] = 0x0008039851e21150UL;
   tf->codes[20814] = 0x0008039d5a2c903eUL;
   tf->codes[20815] = 0x0008039eb986b2dcUL;
   tf->codes[20816] = 0x000803c59c8087aeUL;
   tf->codes[20817] = 0x000803d2a658d08bUL;
   tf->codes[20818] = 0x000803db9222b18eUL;
   tf->codes[20819] = 0x000803dbccb1b753UL;
   tf->codes[20820] = 0x000803e68cf3c67eUL;
   tf->codes[20821] = 0x000803ef3e2ea1bcUL;
   tf->codes[20822] = 0x000803f6ca9e6021UL;
   tf->codes[20823] = 0x00080414122142a1UL;
   tf->codes[20824] = 0x000804348d7675e7UL;
   tf->codes[20825] = 0x00080436d70caf99UL;
   tf->codes[20826] = 0x00080443a655f2b1UL;
   tf->codes[20827] = 0x000804541e8f9219UL;
   tf->codes[20828] = 0x0008046d82931284UL;
   tf->codes[20829] = 0x0008047f5a26d48aUL;
   tf->codes[20830] = 0x000804812e9f02b2UL;
   tf->codes[20831] = 0x00080485873c7051UL;
   tf->codes[20832] = 0x000804b4e0e21a9cUL;
   tf->codes[20833] = 0x000804c050d13b16UL;
   tf->codes[20834] = 0x000804ccaafc72a4UL;
   tf->codes[20835] = 0x000804cfdecec36aUL;
   tf->codes[20836] = 0x000804d6bb917080UL;
   tf->codes[20837] = 0x000804e8cdb4384bUL;
   tf->codes[20838] = 0x000804e9f27f5524UL;
   tf->codes[20839] = 0x000804fe88c75c66UL;
   tf->codes[20840] = 0x000805109aea2431UL;
   tf->codes[20841] = 0x0008051568a59d5aUL;
   tf->codes[20842] = 0x0008052e578b123bUL;
   tf->codes[20843] = 0x000805532b7db320UL;
   tf->codes[20844] = 0x0008055af27c774aUL;
   tf->codes[20845] = 0x00080569d0ccee4fUL;
   tf->codes[20846] = 0x0008056a8079ff9eUL;
   tf->codes[20847] = 0x0008058f8efba648UL;
   tf->codes[20848] = 0x000805916373d470UL;
   tf->codes[20849] = 0x000805924dafeb84UL;
   tf->codes[20850] = 0x000805992a72989aUL;
   tf->codes[20851] = 0x0008059f57883461UL;
   tf->codes[20852] = 0x000805ca931f76d2UL;
   tf->codes[20853] = 0x000805d0c0351299UL;
   tf->codes[20854] = 0x000805d6782ca2d6UL;
   tf->codes[20855] = 0x000805ebf8b0c12cUL;
   tf->codes[20856] = 0x0008065f42441d04UL;
   tf->codes[20857] = 0x000806d3b0a295b5UL;
   tf->codes[20858] = 0x0008074734c4f752UL;
   tf->codes[20859] = 0x00080748ceae1fb5UL;
   tf->codes[20860] = 0x0008077653db9bd8UL;
   tf->codes[20861] = 0x000807c53e9a6255UL;
   tf->codes[20862] = 0x000807c628d67969UL;
   tf->codes[20863] = 0x000807d8eaa65283UL;
   tf->codes[20864] = 0x000807e50a42844cUL;
   tf->codes[20865] = 0x000807f1646dbbdaUL;
   tf->codes[20866] = 0x00080813b43b1d48UL;
   tf->codes[20867] = 0x000808425e33b644UL;
   tf->codes[20868] = 0x0008085e465c7626UL;
   tf->codes[20869] = 0x00080861ef4cd276UL;
   tf->codes[20870] = 0x000808629ef9e3c5UL;
   tf->codes[20871] = 0x0008086732265729UL;
   tf->codes[20872] = 0x0008087cb2aa757fUL;
   tf->codes[20873] = 0x0008089f0277d6edUL;
   tf->codes[20874] = 0x000808b65774236bUL;
   tf->codes[20875] = 0x000808bc8489bf32UL;
   tf->codes[20876] = 0x000808d6231c4562UL;
   tf->codes[20877] = 0x000808f2baf21693UL;
   tf->codes[20878] = 0x0008090457f6d2d4UL;
   tf->codes[20879] = 0x0008090fc7e5f34eUL;
   tf->codes[20880] = 0x00080919635ce5a0UL;
   tf->codes[20881] = 0x000809546780b62aUL;
   tf->codes[20882] = 0x00080954a20fbbefUL;
   tf->codes[20883] = 0x000809581071127aUL;
   tf->codes[20884] = 0x0008096dcb843695UL;
   tf->codes[20885] = 0x0008097a9acd79adUL;
   tf->codes[20886] = 0x000809893e8eeaedUL;
   tf->codes[20887] = 0x000809bcf0d202d7UL;
   tf->codes[20888] = 0x000809c73bf60678UL;
   tf->codes[20889] = 0x000809d89e6bbcf4UL;
   tf->codes[20890] = 0x00080a00e0bfb464UL;
   tf->codes[20891] = 0x00080a04fece1c3eUL;
   tf->codes[20892] = 0x00080a1f879cb982UL;
   tf->codes[20893] = 0x00080a592c66676eUL;
   tf->codes[20894] = 0x00080a5b00de9596UL;
   tf->codes[20895] = 0x00080a68f4f2f587UL;
   tf->codes[20896] = 0x00080a6fd1b5a29dUL;
   tf->codes[20897] = 0x00080a930bbf1b1fUL;
   tf->codes[20898] = 0x00080aa88c433975UL;
   tf->codes[20899] = 0x00080ac942277280UL;
   tf->codes[20900] = 0x00080ac9b7457e0aUL;
   tf->codes[20901] = 0x00080adec2ab90d6UL;
   tf->codes[20902] = 0x00080ae7ae7571d9UL;
   tf->codes[20903] = 0x00080af5a289d1caUL;
   tf->codes[20904] = 0x00080af9fb273f69UL;
   tf->codes[20905] = 0x00080afda4179bb9UL;
   tf->codes[20906] = 0x00080b056b165fe3UL;
   tf->codes[20907] = 0x00080b068fe17cbcUL;
   tf->codes[20908] = 0x00080b0f068d5235UL;
   tf->codes[20909] = 0x00080b140ed7d123UL;
   tf->codes[20910] = 0x00080b17f2573338UL;
   tf->codes[20911] = 0x00080b4870c7fa5cUL;
   tf->codes[20912] = 0x00080b52f67b03c2UL;
   tf->codes[20913] = 0x00080b557aa04339UL;
   tf->codes[20914] = 0x00080b6edea3c3a4UL;
   tf->codes[20915] = 0x00080b74969b53e1UL;
   tf->codes[20916] = 0x00080b7546486530UL;
   tf->codes[20917] = 0x00080b8b767994d5UL;
   tf->codes[20918] = 0x00080bce070d23c4UL;
   tf->codes[20919] = 0x00080bd2d4c89cedUL;
   tf->codes[20920] = 0x00080bdbfb2183b5UL;
   tf->codes[20921] = 0x00080bfefa9bf672UL;
   tf->codes[20922] = 0x00080c0b8f5633c5UL;
   tf->codes[20923] = 0x00080c0ec328848bUL;
   tf->codes[20924] = 0x00080c4658eafe8aUL;
   tf->codes[20925] = 0x00080c52b3163618UL;
   tf->codes[20926] = 0x00080c5d38c93f7eUL;
   tf->codes[20927] = 0x00080c6b676ca534UL;
   tf->codes[20928] = 0x00080c78abd3f3d6UL;
   tf->codes[20929] = 0x00080c7f4e079b27UL;
   tf->codes[20930] = 0x00080c7f8896a0ecUL;
   tf->codes[20931] = 0x00080c85f03b4278UL;
   tf->codes[20932] = 0x00080c98777c15cdUL;
   tf->codes[20933] = 0x00080c9afba15544UL;
   tf->codes[20934] = 0x00080cc9307be2b6UL;
   tf->codes[20935] = 0x00080d3562bd8bb3UL;
   tf->codes[20936] = 0x00080d865c83861dUL;
   tf->codes[20937] = 0x00080d969a2e1fc0UL;
   tf->codes[20938] = 0x00080d991e535f37UL;
   tf->codes[20939] = 0x00080d9a088f764bUL;
   tf->codes[20940] = 0x00080dd4d2244110UL;
   tf->codes[20941] = 0x00080df721f1a27eUL;
   tf->codes[20942] = 0x00080e1dca5c718bUL;
   tf->codes[20943] = 0x00080e4597925d71UL;
   tf->codes[20944] = 0x00080e46bc5d7a4aUL;
   tf->codes[20945] = 0x00080e4caee4104cUL;
   tf->codes[20946] = 0x00080e522c4c9ac4UL;
   tf->codes[20947] = 0x00080e56fa0813edUL;
   tf->codes[20948] = 0x00080e597e2d5364UL;
   tf->codes[20949] = 0x00080e5aa2f8703dUL;
   tf->codes[20950] = 0x00080e6aa614041bUL;
   tf->codes[20951] = 0x00080e6d2a394392UL;
   tf->codes[20952] = 0x00080ea8de0a256bUL;
   tf->codes[20953] = 0x00080ed48ebf7366UL;
   tf->codes[20954] = 0x00080ed8e75ce105UL;
   tf->codes[20955] = 0x00080efbe6d753c2UL;
   tf->codes[20956] = 0x00080f1e36a4b530UL;
   tf->codes[20957] = 0x00080f49723bf7a1UL;
   tf->codes[20958] = 0x00080f57a0df5d57UL;
   tf->codes[20959] = 0x00080f5b845ebf6cUL;
   tf->codes[20960] = 0x00080f5c6e9ad680UL;
   tf->codes[20961] = 0x00080f66f44ddfe6UL;
   tf->codes[20962] = 0x00080f6e0b9f92c1UL;
   tf->codes[20963] = 0x00080f9d2ab63747UL;
   tf->codes[20964] = 0x00080fc5e2283a41UL;
   tf->codes[20965] = 0x00080fcaafe3b36aUL;
   tf->codes[20966] = 0x00080fd067db43a7UL;
   tf->codes[20967] = 0x00080fdf80bac071UL;
   tf->codes[20968] = 0x00080feba056f23aUL;
   tf->codes[20969] = 0x0008101be438b399UL;
   tf->codes[20970] = 0x0008106b441585a0UL;
   tf->codes[20971] = 0x00081072d0854405UL;
   tf->codes[20972] = 0x0008107380325554UL;
   tf->codes[20973] = 0x00081080c499a3f6UL;
   tf->codes[20974] = 0x000810817446b545UL;
   tf->codes[20975] = 0x0008108432fafa81UL;
   tf->codes[20976] = 0x000810c05be9e7e4UL;
   tf->codes[20977] = 0x000810d05f057bc2UL;
   tf->codes[20978] = 0x000810d5a1df0075UL;
   tf->codes[20979] = 0x000810ebd210301aUL;
   tf->codes[20980] = 0x00081124c72cccb7UL;
   tf->codes[20981] = 0x0008114507f2fa38UL;
   tf->codes[20982] = 0x00081184d9d243ebUL;
   tf->codes[20983] = 0x00081189a78dbd14UL;
   tf->codes[20984] = 0x000811d2da54f354UL;
   tf->codes[20985] = 0x000811fddb5d3000UL;
   tf->codes[20986] = 0x00081204f2aee2dbUL;
   tf->codes[20987] = 0x00081211124b14a4UL;
   tf->codes[20988] = 0x00081211fc872bb8UL;
   tf->codes[20989] = 0x0008121480ac6b2fUL;
   tf->codes[20990] = 0x00081219fe14f5a7UL;
   tf->codes[20991] = 0x00081242f015fe66UL;
   tf->codes[20992] = 0x0008124deae71356UL;
   tf->codes[20993] = 0x000812569c21ee94UL;
   tf->codes[20994] = 0x0008126e663c469cUL;
   tf->codes[20995] = 0x0008127542fef3b2UL;
   tf->codes[20996] = 0x0008127fc8b1fd18UL;
   tf->codes[20997] = 0x000812933a2ee781UL;
   tf->codes[20998] = 0x00081298b79771f9UL;
   tf->codes[20999] = 0x000812ca5ad355f6UL;
   tf->codes[21000] = 0x000812e6f2a92727UL;
   tf->codes[21001] = 0x000812f1b2eb3652UL;
   tf->codes[21002] = 0x0008131b8f285625UL;
   tf->codes[21003] = 0x0008134655a18d0cUL;
   tf->codes[21004] = 0x00081379583793a7UL;
   tf->codes[21005] = 0x0008138e639da673UL;
   tf->codes[21006] = 0x000813dd88eb72b5UL;
   tf->codes[21007] = 0x000813df22d49b18UL;
   tf->codes[21008] = 0x000813ed16e8fb09UL;
   tf->codes[21009] = 0x000813fad06e5535UL;
   tf->codes[21010] = 0x0008144d9eac7dc7UL;
   tf->codes[21011] = 0x0008146ae62f6047UL;
   tf->codes[21012] = 0x0008148693c91a64UL;
   tf->codes[21013] = 0x0008148cc0deb62bUL;
   tf->codes[21014] = 0x000814b453859c4cUL;
   tf->codes[21015] = 0x000814bd04c0778aUL;
   tf->codes[21016] = 0x000814c0adb0d3daUL;
   tf->codes[21017] = 0x000814c874af9804UL;
   tf->codes[21018] = 0x000814d03bae5c2eUL;
   tf->codes[21019] = 0x000814d802ad2058UL;
   tf->codes[21020] = 0x000814df548dd8f8UL;
   tf->codes[21021] = 0x000814e6a66e9198UL;
   tf->codes[21022] = 0x000814e99fb1dc99UL;
   tf->codes[21023] = 0x0008150cd9bb551bUL;
   tf->codes[21024] = 0x00081514db491f0aUL;
   tf->codes[21025] = 0x00081544aa0cd4dfUL;
   tf->codes[21026] = 0x0008154ebaa1d2bbUL;
   tf->codes[21027] = 0x00081554729962f8UL;
   tf->codes[21028] = 0x00081556bc2f9caaUL;
   tf->codes[21029] = 0x0008155a2a90f335UL;
   tf->codes[21030] = 0x0008157896def28eUL;
   tf->codes[21031] = 0x0008157f73a19fa4UL;
   tf->codes[21032] = 0x000815814819cdccUL;
   tf->codes[21033] = 0x000815b8a34d4206UL;
   tf->codes[21034] = 0x000815c3d8ad5cbbUL;
   tf->codes[21035] = 0x000815c7f6bbc495UL;
   tf->codes[21036] = 0x000815dba2c7b4c3UL;
   tf->codes[21037] = 0x000815e3dee48477UL;
   tf->codes[21038] = 0x000815ea46892603UL;
   tf->codes[21039] = 0x000815f5f1074c42UL;
   tf->codes[21040] = 0x000815fb6e6fd6baUL;
   tf->codes[21041] = 0x00081602fadf951fUL;
   tf->codes[21042] = 0x00081612c36c2338UL;
   tf->codes[21043] = 0x000816525abc6726UL;
   tf->codes[21044] = 0x000816558e8eb7ecUL;
   tf->codes[21045] = 0x0008166c33ddf31bUL;
   tf->codes[21046] = 0x000816938bf5d377UL;
   tf->codes[21047] = 0x000816c1c0d060e9UL;
   tf->codes[21048] = 0x000816d9505bb32cUL;
   tf->codes[21049] = 0x000816dbd480f2a3UL;
   tf->codes[21050] = 0x000816fbdab81a5fUL;
   tf->codes[21051] = 0x000817048bf2f59dUL;
   tf->codes[21052] = 0x000817169e15bd68UL;
   tf->codes[21053] = 0x00081748f0feb2b4UL;
   tf->codes[21054] = 0x00081749661cbe3eUL;
   tf->codes[21055] = 0x000817533c22b655UL;
   tf->codes[21056] = 0x000817c1084d87b5UL;
   tf->codes[21057] = 0x000817c2dcc5b5ddUL;
   tf->codes[21058] = 0x000817c31754bba2UL;
   tf->codes[21059] = 0x000817dc063a3083UL;
   tf->codes[21060] = 0x000817fb2235412bUL;
   tf->codes[21061] = 0x0008180cbf39fd6cUL;
   tf->codes[21062] = 0x000818123ca287e4UL;
   tf->codes[21063] = 0x0008181953f43abfUL;
   tf->codes[21064] = 0x00081836265911b5UL;
   tf->codes[21065] = 0x000818441a6d71a6UL;
   tf->codes[21066] = 0x00081848730adf45UL;
   tf->codes[21067] = 0x0008184af7301ebcUL;
   tf->codes[21068] = 0x0008185d7e70f211UL;
   tf->codes[21069] = 0x00081863ab868dd8UL;
   tf->codes[21070] = 0x0008186928ef1850UL;
   tf->codes[21071] = 0x000818bfdaaca2f7UL;
   tf->codes[21072] = 0x000818d55b30c14dUL;
   tf->codes[21073] = 0x000818d67ffbde26UL;
   tf->codes[21074] = 0x000818def6a7b39fUL;
   tf->codes[21075] = 0x000818e55e4c552bUL;
   tf->codes[21076] = 0x000818e7e27194a2UL;
   tf->codes[21077] = 0x000818ebc5f0f6b7UL;
   tf->codes[21078] = 0x000818fc3e2a961fUL;
   tf->codes[21079] = 0x0008191bcf43b251UL;
   tf->codes[21080] = 0x0008191fb2c31466UL;
   tf->codes[21081] = 0x0008192654f6bbb7UL;
   tf->codes[21082] = 0x0008194e5cbbad62UL;
   tf->codes[21083] = 0x0008194f46f7c476UL;
   tf->codes[21084] = 0x000819565e497751UL;
   tf->codes[21085] = 0x000819836e58e7eaUL;
   tf->codes[21086] = 0x0008199df727852eUL;
   tf->codes[21087] = 0x000819d16edb9753UL;
   tf->codes[21088] = 0x000819d9aaf86707UL;
   tf->codes[21089] = 0x000819df62eff744UL;
   tf->codes[21090] = 0x00081a0b4e344b04UL;
   tf->codes[21091] = 0x00081a138a511ab8UL;
   tf->codes[21092] = 0x00081a16839465b9UL;
   tf->codes[21093] = 0x00081a43ce32dc17UL;
   tf->codes[21094] = 0x00081a6aebbbb6aeUL;
   tf->codes[21095] = 0x00081a6daa6ffbeaUL;
   tf->codes[21096] = 0x00081a6e1f8e0774UL;
   tf->codes[21097] = 0x00081a86d3e47690UL;
   tf->codes[21098] = 0x00081a9b6a2c7dd2UL;
   tf->codes[21099] = 0x00081ac8b4caf430UL;
   tf->codes[21100] = 0x00081b060284fe6cUL;
   tf->codes[21101] = 0x00081b4524b736d0UL;
   tf->codes[21102] = 0x00081b5e88bab73bUL;
   tf->codes[21103] = 0x00081b8de2606186UL;
   tf->codes[21104] = 0x00081bbd76951196UL;
   tf->codes[21105] = 0x00081be2fa34c3caUL;
   tf->codes[21106] = 0x00081bea4c157c6aUL;
   tf->codes[21107] = 0x00081bef8eef011dUL;
   tf->codes[21108] = 0x00081bf45caa7a46UL;
   tf->codes[21109] = 0x00081c1044d33a28UL;
   tf->codes[21110] = 0x00081c1aca86438eUL;
   tf->codes[21111] = 0x00081c1b7a3354ddUL;
   tf->codes[21112] = 0x00081c1e73769fdeUL;
   tf->codes[21113] = 0x00081c534a84d4a1UL;
   tf->codes[21114] = 0x00081c55ceaa1418UL;
   tf->codes[21115] = 0x00081c56f37530f1UL;
   tf->codes[21116] = 0x00081c572e0436b6UL;
   tf->codes[21117] = 0x00081c5eba73f51bUL;
   tf->codes[21118] = 0x00081c626364516bUL;
   tf->codes[21119] = 0x00081c7efb3a229cUL;
   tf->codes[21120] = 0x00081c90983ededdUL;
   tf->codes[21121] = 0x00081cbbd3d6214eUL;
   tf->codes[21122] = 0x00081cc1c65cb750UL;
   tf->codes[21123] = 0x00081cf3a427a112UL;
   tf->codes[21124] = 0x00081d5082fac780UL;
   tf->codes[21125] = 0x00081d5d17b504d3UL;
   tf->codes[21126] = 0x00081d5d8cd3105dUL;
   tf->codes[21127] = 0x00081d6e7a2abb4fUL;
   tf->codes[21128] = 0x00081d7347e63478UL;
   tf->codes[21129] = 0x00081d8644451357UL;
   tf->codes[21130] = 0x00081d964760a735UL;
   tf->codes[21131] = 0x00081dc1f815f530UL;
   tf->codes[21132] = 0x00081dc7b00d856dUL;
   tf->codes[21133] = 0x00081e1db21dfec5UL;
   tf->codes[21134] = 0x00081e1e9c5a15d9UL;
   tf->codes[21135] = 0x00081e50b4b40560UL;
   tf->codes[21136] = 0x00081e5b74f6148bUL;
   tf->codes[21137] = 0x00081e780ccbe5bcUL;
   tf->codes[21138] = 0x00081e91e5ed71b1UL;
   tf->codes[21139] = 0x00081e937fd69a14UL;
   tf->codes[21140] = 0x00081ec229cf3310UL;
   tf->codes[21141] = 0x00081ecf6e3681b2UL;
   tf->codes[21142] = 0x00081ed1b7ccbb64UL;
   tf->codes[21143] = 0x00081ed2dc97d83dUL;
   tf->codes[21144] = 0x00081ed97ecb7f8eUL;
   tf->codes[21145] = 0x00081ef9fa20b2d4UL;
   tf->codes[21146] = 0x00081f1d6eb9311bUL;
   tf->codes[21147] = 0x00081f51961a548fUL;
   tf->codes[21148] = 0x00081f5f8a2eb480UL;
   tf->codes[21149] = 0x00081f750ab2d2d6UL;
   tf->codes[21150] = 0x00081f78ee3234ebUL;
   tf->codes[21151] = 0x00081f8a8b36f12cUL;
   tf->codes[21152] = 0x00081f8c9a3e2519UL;
   tf->codes[21153] = 0x00081f9dfcb3db95UL;
   tf->codes[21154] = 0x00081fc51a3cb62cUL;
   tf->codes[21155] = 0x00081fc6eeb4e454UL;
   tf->codes[21156] = 0x00081fc7d8f0fb68UL;
   tf->codes[21157] = 0x00081fd6b741726dUL;
   tf->codes[21158] = 0x00081fe1b212875dUL;
   tf->codes[21159] = 0x00081fe60aaff4fcUL;
   tf->codes[21160] = 0x00081ff314883dd9UL;
   tf->codes[21161] = 0x00081ffb8b341352UL;
   tf->codes[21162] = 0x0008204fb8cc5e82UL;
   tf->codes[21163] = 0x0008204ff35b6447UL;
   tf->codes[21164] = 0x0008206a7c2a018bUL;
   tf->codes[21165] = 0x0008207576fb167bUL;
   tf->codes[21166] = 0x0008208c1c4a51aaUL;
   tf->codes[21167] = 0x00082093a8ba100fUL;
   tf->codes[21168] = 0x000820d16b9225d5UL;
   tf->codes[21169] = 0x000820d673dca4c3UL;
   tf->codes[21170] = 0x000820dc66633ac5UL;
   tf->codes[21171] = 0x000820e84b7066c9UL;
   tf->codes[21172] = 0x000820f0fcab4207UL;
   tf->codes[21173] = 0x000820f1e6e7591bUL;
   tf->codes[21174] = 0x000820fa98223459UL;
   tf->codes[21175] = 0x000820fef0bfa1f8UL;
   tf->codes[21176] = 0x0008210c6fb5f65fUL;
   tf->codes[21177] = 0x0008211fa6a3db03UL;
   tf->codes[21178] = 0x0008213770be330bUL;
   tf->codes[21179] = 0x0008214898a4e3c2UL;
   tf->codes[21180] = 0x0008215b5a74bcdcUL;
   tf->codes[21181] = 0x00082175a8b4545bUL;
   tf->codes[21182] = 0x0008219a7ca6f540UL;
   tf->codes[21183] = 0x0008219b2c54068fUL;
   tf->codes[21184] = 0x000821c508912662UL;
   tf->codes[21185] = 0x000821c99bbd99c6UL;
   tf->codes[21186] = 0x000821ca10dba550UL;
   tf->codes[21187] = 0x000821f3b289bf5eUL;
   tf->codes[21188] = 0x00082213b8c0e71aUL;
   tf->codes[21189] = 0x00082244e6debf8dUL;
   tf->codes[21190] = 0x000822497a0b32f1UL;
   tf->codes[21191] = 0x0008224b13f45b54UL;
   tf->codes[21192] = 0x00082288d6cc711aUL;
   tf->codes[21193] = 0x0008229d32857297UL;
   tf->codes[21194] = 0x000822c48a9d52f3UL;
   tf->codes[21195] = 0x000822c86e1cb508UL;
   tf->codes[21196] = 0x000822ca4294e330UL;
   tf->codes[21197] = 0x000822e78a17c5b0UL;
   tf->codes[21198] = 0x000822ef16878415UL;
   tf->codes[21199] = 0x000823092a3815cfUL;
   tf->codes[21200] = 0x000823171e4c75c0UL;
   tf->codes[21201] = 0x0008231fcf8750feUL;
   tf->codes[21202] = 0x0008234f9e4b06d3UL;
   tf->codes[21203] = 0x000823646f2213daUL;
   tf->codes[21204] = 0x00082397372914b0UL;
   tf->codes[21205] = 0x000823e69705e6b7UL;
   tf->codes[21206] = 0x000823f15747f5e2UL;
   tf->codes[21207] = 0x000823f1cc66016cUL;
   tf->codes[21208] = 0x000823fd3c5521e6UL;
   tf->codes[21209] = 0x000823fed63e4a49UL;
   tf->codes[21210] = 0x000824384078f270UL;
   tf->codes[21211] = 0x0008247294efb1abUL;
   tf->codes[21212] = 0x000824967ea63b7cUL;
   tf->codes[21213] = 0x0008249cabbbd743UL;
   tf->codes[21214] = 0x0008249dd086f41cUL;
   tf->codes[21215] = 0x000824cbcad27bc9UL;
   tf->codes[21216] = 0x000824cfe8e0e3a3UL;
   tf->codes[21217] = 0x000824e110c7945aUL;
   tf->codes[21218] = 0x000824fb24782614UL;
   tf->codes[21219] = 0x0008254abee3fde0UL;
   tf->codes[21220] = 0x000825b9002cdacaUL;
   tf->codes[21221] = 0x000825bfa260821bUL;
   tf->codes[21222] = 0x000825ef3695322bUL;
   tf->codes[21223] = 0x00082613204bbbfcUL;
   tf->codes[21224] = 0x0008261912d251feUL;
   tf->codes[21225] = 0x0008261987f05d88UL;
   tf->codes[21226] = 0x0008264a7b7f3036UL;
   tf->codes[21227] = 0x00082674924b55ceUL;
   tf->codes[21228] = 0x0008268d46a1c4eaUL;
   tf->codes[21229] = 0x000826c307ec10c1UL;
   tf->codes[21230] = 0x000826d04c535f63UL;
   tf->codes[21231] = 0x000826da2259577aUL;
   tf->codes[21232] = 0x000826dca67e96f1UL;
   tf->codes[21233] = 0x000826e93b38d444UL;
   tf->codes[21234] = 0x000827461a0bfab2UL;
   tf->codes[21235] = 0x0008274c0c9290b4UL;
   tf->codes[21236] = 0x0008274c47219679UL;
   tf->codes[21237] = 0x000827648659fa0bUL;
   tf->codes[21238] = 0x000827670a7f3982UL;
   tf->codes[21239] = 0x000827cf93d0862fUL;
   tf->codes[21240] = 0x000827d87f9a6732UL;
   tf->codes[21241] = 0x000827deacb002f9UL;
   tf->codes[21242] = 0x000827efd496b3b0UL;
   tf->codes[21243] = 0x000827f8c06094b3UL;
   tf->codes[21244] = 0x000828125ef31ae3UL;
   tf->codes[21245] = 0x00082817673d99d1UL;
   tf->codes[21246] = 0x00082851bbb4590cUL;
   tf->codes[21247] = 0x000828547a689e48UL;
   tf->codes[21248] = 0x00082854b4f7a40dUL;
   tf->codes[21249] = 0x0008285a6cef344aUL;
   tf->codes[21250] = 0x0008289153049cfaUL;
   tf->codes[21251] = 0x000828d1d490f7fcUL;
   tf->codes[21252] = 0x0008290c6396bcfcUL;
   tf->codes[21253] = 0x0008290f224b0238UL;
   tf->codes[21254] = 0x00082943beca3136UL;
   tf->codes[21255] = 0x00082995a2cc42b4UL;
   tf->codes[21256] = 0x000829daf21416dfUL;
   tf->codes[21257] = 0x000829e5b256260aUL;
   tf->codes[21258] = 0x000829e627743194UL;
   tf->codes[21259] = 0x000829e8367b6581UL;
   tf->codes[21260] = 0x000829e920b77c95UL;
   tf->codes[21261] = 0x000829eba4dcbc0cUL;
   tf->codes[21262] = 0x000829ee9e20070dUL;
   tf->codes[21263] = 0x000829f072983535UL;
   tf->codes[21264] = 0x000829f20c815d98UL;
   tf->codes[21265] = 0x000829ffc606b7c4UL;
   tf->codes[21266] = 0x00082a3e731ae49eUL;
   tf->codes[21267] = 0x00082a5343f1f1a5UL;
   tf->codes[21268] = 0x00082a5602a636e1UL;
   tf->codes[21269] = 0x00082a59e62598f6UL;
   tf->codes[21270] = 0x00082a6b489b4f72UL;
   tf->codes[21271] = 0x00082a6e074f94aeUL;
   tf->codes[21272] = 0x00082a7434653075UL;
   tf->codes[21273] = 0x00082a89ef785490UL;
   tf->codes[21274] = 0x00082a96bec197a8UL;
   tf->codes[21275] = 0x00082a9f6ffc72e6UL;
   tf->codes[21276] = 0x00082ac94c3992b9UL;
   tf->codes[21277] = 0x00082acaab93b557UL;
   tf->codes[21278] = 0x00082acf043122f6UL;
   tf->codes[21279] = 0x00082ad1133856e3UL;
   tf->codes[21280] = 0x00082ae23b1f079aUL;
   tf->codes[21281] = 0x00082afc4ecf9954UL;
   tf->codes[21282] = 0x00082b399c89a390UL;
   tf->codes[21283] = 0x00082b499fa5376eUL;
   tf->codes[21284] = 0x00082b4b741d6596UL;
   tf->codes[21285] = 0x00082b5166a3fb98UL;
   tf->codes[21286] = 0x00082b7eebd177bbUL;
   tf->codes[21287] = 0x00082bd43e34dfc4UL;
   tf->codes[21288] = 0x00082bdd648dc68cUL;
   tf->codes[21289] = 0x00082bf618e435a8UL;
   tf->codes[21290] = 0x00082bfa36f29d82UL;
   tf->codes[21291] = 0x00082c02730f6d36UL;
   tf->codes[21292] = 0x00082c0cbe3370d7UL;
   tf->codes[21293] = 0x00082c4a0bed7b13UL;
   tf->codes[21294] = 0x00082c8becd3f8b3UL;
   tf->codes[21295] = 0x00082c9637f7fc54UL;
   tf->codes[21296] = 0x00082c9dfef6c07eUL;
   tf->codes[21297] = 0x00082cd9031a9108UL;
   tf->codes[21298] = 0x00082ceb8a5b645dUL;
   tf->codes[21299] = 0x00082cf64a9d7388UL;
   tf->codes[21300] = 0x00082cf76f689061UL;
   tf->codes[21301] = 0x00082d44facd3440UL;
   tf->codes[21302] = 0x00082d5d3a0597d2UL;
   tf->codes[21303] = 0x00082d7872814665UL;
   tf->codes[21304] = 0x00082d86dbb3b1e0UL;
   tf->codes[21305] = 0x00082d98039a6297UL;
   tf->codes[21306] = 0x00082dc28f8493b9UL;
   tf->codes[21307] = 0x00082dceaf20c582UL;
   tf->codes[21308] = 0x00082df7dbb0d406UL;
   tf->codes[21309] = 0x00082e1090074322UL;
   tf->codes[21310] = 0x00082e1b5049524dUL;
   tf->codes[21311] = 0x00082e42a86132a9UL;
   tf->codes[21312] = 0x00082e9a445ad464UL;
   tf->codes[21313] = 0x00082e9a7ee9da29UL;
   tf->codes[21314] = 0x00082eb20e752c6cUL;
   tf->codes[21315] = 0x00082ec3365bdd23UL;
   tf->codes[21316] = 0x00082ec83ea65c11UL;
   tf->codes[21317] = 0x00082edc5fd057c9UL;
   tf->codes[21318] = 0x00082edd849b74a2UL;
   tf->codes[21319] = 0x00082efca096854aUL;
   tf->codes[21320] = 0x00082f104ca27578UL;
   tf->codes[21321] = 0x00082f16eed61cc9UL;
   tf->codes[21322] = 0x00082f4907300c50UL;
   tf->codes[21323] = 0x00082f49b6dd1d9fUL;
   tf->codes[21324] = 0x00082f5ec243306bUL;
   tf->codes[21325] = 0x00082f67ae0d116eUL;
   tf->codes[21326] = 0x00082f74b7e55a4bUL;
   tf->codes[21327] = 0x00082f7651ce82aeUL;
   tf->codes[21328] = 0x00082f7b94a80761UL;
   tf->codes[21329] = 0x00082f814c9f979eUL;
   tf->codes[21330] = 0x00082f940e6f70b8UL;
   tf->codes[21331] = 0x00082faff698309aUL;
   tf->codes[21332] = 0x00082fcd78aa18dfUL;
   tf->codes[21333] = 0x00082fd280f497cdUL;
   tf->codes[21334] = 0x00082fda828261bcUL;
   tf->codes[21335] = 0x00082fec5a1623c2UL;
   tf->codes[21336] = 0x00083016e60054e4UL;
   tf->codes[21337] = 0x0008301b3e9dc283UL;
   tf->codes[21338] = 0x0008301c28d9d997UL;
   tf->codes[21339] = 0x00083040c23d74b7UL;
   tf->codes[21340] = 0x0008304380f1b9f3UL;
   tf->codes[21341] = 0x00083045ca87f3a5UL;
   tf->codes[21342] = 0x0008304c322c9531UL;
   tf->codes[21343] = 0x0008304d56f7b20aUL;
   tf->codes[21344] = 0x0008305a2640f522UL;
   tf->codes[21345] = 0x0008305a9b5f00acUL;
   tf->codes[21346] = 0x0008305bfab9234aUL;
   tf->codes[21347] = 0x0008308f726d356fUL;
   tf->codes[21348] = 0x000830ac0a4306a0UL;
   tf->codes[21349] = 0x000830c18ac724f6UL;
   tf->codes[21350] = 0x000830c3d45d5ea8UL;
   tf->codes[21351] = 0x000830c4be9975bcUL;
   tf->codes[21352] = 0x000830ccfab64570UL;
   tf->codes[21353] = 0x000830fc545befbbUL;
   tf->codes[21354] = 0x000831069f7ff35cUL;
   tf->codes[21355] = 0x00083107c44b1035UL;
   tf->codes[21356] = 0x0008310ba7ca724aUL;
   tf->codes[21357] = 0x000831115fc20287UL;
   tf->codes[21358] = 0x0008311926c0c6b1UL;
   tf->codes[21359] = 0x0008314427c9035dUL;
   tf->codes[21360] = 0x0008314f97b823d7UL;
   tf->codes[21361] = 0x0008316d8ee817a6UL;
   tf->codes[21362] = 0x0008317297329694UL;
   tf->codes[21363] = 0x00083178c448325bUL;
   tf->codes[21364] = 0x0008318fdeb57914UL;
   tf->codes[21365] = 0x0008319e47e7e48fUL;
   tf->codes[21366] = 0x000831cd2c6f8350UL;
   tf->codes[21367] = 0x000831d47e503bf0UL;
   tf->codes[21368] = 0x000831daab65d7b7UL;
   tf->codes[21369] = 0x0008320ed2c6fb2bUL;
   tf->codes[21370] = 0x00083247c7e397c8UL;
   tf->codes[21371] = 0x0008324a4c08d73fUL;
   tf->codes[21372] = 0x0008325c239c9945UL;
   tf->codes[21373] = 0x00083267938bb9bfUL;
   tf->codes[21374] = 0x0008327aca799e63UL;
   tf->codes[21375] = 0x0008329b0b3fcbe4UL;
   tf->codes[21376] = 0x000832ac33267c9bUL;
   tf->codes[21377] = 0x000832d26673401eUL;
   tf->codes[21378] = 0x0008330e1a4421f7UL;
   tf->codes[21379] = 0x0008331c83768d72UL;
   tf->codes[21380] = 0x00083342b6c350f5UL;
   tf->codes[21381] = 0x00083349ce1503d0UL;
   tf->codes[21382] = 0x0008335f4e992226UL;
   tf->codes[21383] = 0x00083366a079dac6UL;
   tf->codes[21384] = 0x00083370767fd2ddUL;
   tf->codes[21385] = 0x00083373aa5223a3UL;
   tf->codes[21386] = 0x00083375f3e85d55UL;
   tf->codes[21387] = 0x0008337babdfed92UL;
   tf->codes[21388] = 0x000833c8c22685e7UL;
   tf->codes[21389] = 0x000833d8ffd11f8aUL;
   tf->codes[21390] = 0x000833ead764e190UL;
   tf->codes[21391] = 0x000833f7a6ae24a8UL;
   tf->codes[21392] = 0x0008340a687dfdc2UL;
   tf->codes[21393] = 0x0008341737c740daUL;
   tf->codes[21394] = 0x0008341c7aa0c58dUL;
   tf->codes[21395] = 0x0008346990e75de2UL;
   tf->codes[21396] = 0x00083469cb7663a7UL;
   tf->codes[21397] = 0x0008348fc4342165UL;
   tf->codes[21398] = 0x0008349073e132b4UL;
   tf->codes[21399] = 0x000834ac5c09f296UL;
   tf->codes[21400] = 0x000834c0f251f9d8UL;
   tf->codes[21401] = 0x000834c8f3dfc3c7UL;
   tf->codes[21402] = 0x000834d797a13507UL;
   tf->codes[21403] = 0x000834d7d2303accUL;
   tf->codes[21404] = 0x000834eb7e3c2afaUL;
   tf->codes[21405] = 0x000834f8881473d7UL;
   tf->codes[21406] = 0x00083504a7b0a5a0UL;
   tf->codes[21407] = 0x0008351310e3111bUL;
   tf->codes[21408] = 0x000835160a265c1cUL;
   tf->codes[21409] = 0x00083554421c7d6cUL;
   tf->codes[21410] = 0x0008356619b03f72UL;
   tf->codes[21411] = 0x0008356cbbe3e6c3UL;
   tf->codes[21412] = 0x00083572e8f9828aUL;
   tf->codes[21413] = 0x00083579509e2416UL;
   tf->codes[21414] = 0x0008359f0eccdc0fUL;
   tf->codes[21415] = 0x000835c3a830772fUL;
   tf->codes[21416] = 0x000835dbacd9d4fcUL;
   tf->codes[21417] = 0x000835f0b83fe7c8UL;
   tf->codes[21418] = 0x000836100ec9fe35UL;
   tf->codes[21419] = 0x000836488ec88f48UL;
   tf->codes[21420] = 0x000836afb8bfb957UL;
   tf->codes[21421] = 0x000836b39c3f1b6cUL;
   tf->codes[21422] = 0x000836b5e5d5551eUL;
   tf->codes[21423] = 0x000836c2efad9dfbUL;
   tf->codes[21424] = 0x000836c782da115fUL;
   tf->codes[21425] = 0x000836d5ec0c7cdaUL;
   tf->codes[21426] = 0x000836d994fcd92aUL;
   tf->codes[21427] = 0x000836f36e1e651fUL;
   tf->codes[21428] = 0x00083716e2b6e366UL;
   tf->codes[21429] = 0x000837455220769dUL;
   tf->codes[21430] = 0x00083774e65526adUL;
   tf->codes[21431] = 0x000837776a7a6624UL;
   tf->codes[21432] = 0x000837d0a05d3042UL;
   tf->codes[21433] = 0x000837fe9aa8b7efUL;
   tf->codes[21434] = 0x0008384ee4c1a10aUL;
   tf->codes[21435] = 0x00083850f3c8d4f7UL;
   tf->codes[21436] = 0x000838580b1a87d2UL;
   tf->codes[21437] = 0x00083865ff2ee7c3UL;
   tf->codes[21438] = 0x0008389d5a625bfdUL;
   tf->codes[21439] = 0x000838c59cb6536dUL;
   tf->codes[21440] = 0x000838ccb4080648UL;
   tf->codes[21441] = 0x000838d1bc528536UL;
   tf->codes[21442] = 0x000838f77a813d2fUL;
   tf->codes[21443] = 0x0008393af550e332UL;
   tf->codes[21444] = 0x0008395ac0f90529UL;
   tf->codes[21445] = 0x0008395bab351c3dUL;
   tf->codes[21446] = 0x00083963acc2e62cUL;
   tf->codes[21447] = 0x0008396a146787b8UL;
   tf->codes[21448] = 0x0008396d82c8de43UL;
   tf->codes[21449] = 0x000839712bb93a93UL;
   tf->codes[21450] = 0x0008398dc38f0bc4UL;
   tf->codes[21451] = 0x000839bad39e7c5dUL;
   tf->codes[21452] = 0x000839c9b1eef362UL;
   tf->codes[21453] = 0x000839d312d6dfefUL;
   tf->codes[21454] = 0x000839d437a1fcc8UL;
   tf->codes[21455] = 0x000839ebc72d4f0bUL;
   tf->codes[21456] = 0x000839fb8fb9dd24UL;
   tf->codes[21457] = 0x00083a1b5b61ff1bUL;
   tf->codes[21458] = 0x00083a3ecffa7d62UL;
   tf->codes[21459] = 0x00083a7b3378708aUL;
   tf->codes[21460] = 0x00083acf9b9fc17fUL;
   tf->codes[21461] = 0x00083ad04b4cd2ceUL;
   tf->codes[21462] = 0x00083adc6ae90497UL;
   tf->codes[21463] = 0x00083af016f4f4c5UL;
   tf->codes[21464] = 0x00083af81882beb4UL;
   tf->codes[21465] = 0x00083b10ccd92dd0UL;
   tf->codes[21466] = 0x00083b1141f7395aUL;
   tf->codes[21467] = 0x00083b1aa2df25e7UL;
   tf->codes[21468] = 0x00083b527330a5abUL;
   tf->codes[21469] = 0x00083b5740ec1ed4UL;
   tf->codes[21470] = 0x00083b594ff352c1UL;
   tf->codes[21471] = 0x00083b5fb797f44dUL;
   tf->codes[21472] = 0x00083bc7cbcb3570UL;
   tf->codes[21473] = 0x00083bd007e80524UL;
   tf->codes[21474] = 0x00083be1df7bc72aUL;
   tf->codes[21475] = 0x00083c08c2759bfcUL;
   tf->codes[21476] = 0x00083c72e5b0110cUL;
   tf->codes[21477] = 0x00083c8c8442973cUL;
   tf->codes[21478] = 0x00083cbcc824589bUL;
   tf->codes[21479] = 0x00083cc48f231cc5UL;
   tf->codes[21480] = 0x00083ce8b368ac5bUL;
   tf->codes[21481] = 0x00083cfb3aa97fb0UL;
   tf->codes[21482] = 0x00083d634edcc0d3UL;
   tf->codes[21483] = 0x00083d64ae36e371UL;
   tf->codes[21484] = 0x00083d738c875a76UL;
   tf->codes[21485] = 0x00083d7ade681316UL;
   tf->codes[21486] = 0x00083dca03b5df58UL;
   tf->codes[21487] = 0x00083dcc12bd1345UL;
   tf->codes[21488] = 0x00083dfe2b1702ccUL;
   tf->codes[21489] = 0x00083e015ee95392UL;
   tf->codes[21490] = 0x00083e0507d9afe2UL;
   tf->codes[21491] = 0x00083e0baa0d5733UL;
   tf->codes[21492] = 0x00083e0cced8740cUL;
   tf->codes[21493] = 0x00083e17548b7d72UL;
   tf->codes[21494] = 0x00083e558c819ec2UL;
   tf->codes[21495] = 0x00083e68c36f8366UL;
   tf->codes[21496] = 0x00083e69388d8ef0UL;
   tf->codes[21497] = 0x00083e6ad276b753UL;
   tf->codes[21498] = 0x00083e7b102150f6UL;
   tf->codes[21499] = 0x00083e917ae18660UL;
   tf->codes[21500] = 0x00083e9a66ab6763UL;
   tf->codes[21501] = 0x00083ec2a8ff5ed3UL;
   tf->codes[21502] = 0x00083ecb94c93fd6UL;
   tf->codes[21503] = 0x00083ecda3d073c3UL;
   tf->codes[21504] = 0x00083ef8df67b634UL;
   tf->codes[21505] = 0x00083f0205c09cfcUL;
   tf->codes[21506] = 0x00083f1f87d28541UL;
   tf->codes[21507] = 0x00083f7a579e77c2UL;
   tf->codes[21508] = 0x00083f7eb03be561UL;
   tf->codes[21509] = 0x00083f95558b2090UL;
   tf->codes[21510] = 0x00083fcd9afaabdeUL;
   tf->codes[21511] = 0x00083fcf6f72da06UL;
   tf->codes[21512] = 0x00083fec7c66b6c1UL;
   tf->codes[21513] = 0x00083fee50dee4e9UL;
   tf->codes[21514] = 0x00083ff14a222feaUL;
   tf->codes[21515] = 0x00083ff73ca8c5ecUL;
   tf->codes[21516] = 0x0008404dee665093UL;
   tf->codes[21517] = 0x00084058aea85fbeUL;
   tf->codes[21518] = 0x000840916935f696UL;
   tf->codes[21519] = 0x000840928e01136fUL;
   tf->codes[21520] = 0x000840a58a5ff24eUL;
   tf->codes[21521] = 0x000840c3f6adf1a7UL;
   tf->codes[21522] = 0x000840c72a80426dUL;
   tf->codes[21523] = 0x000840f1f0f97954UL;
   tf->codes[21524] = 0x00084116ff7b1ffeUL;
   tf->codes[21525] = 0x0008414b9bfa4efcUL;
   tf->codes[21526] = 0x000841570be96f76UL;
   tf->codes[21527] = 0x0008418d4251c6d7UL;
   tf->codes[21528] = 0x0008419cd04f4f2bUL;
   tf->codes[21529] = 0x00084236fcdc7fd5UL;
   tf->codes[21530] = 0x000842568df59c07UL;
   tf->codes[21531] = 0x000842577831b31bUL;
   tf->codes[21532] = 0x00084275e47fb274UL;
   tf->codes[21533] = 0x00084284884123b4UL;
   tf->codes[21534] = 0x0008428537ee3503UL;
   tf->codes[21535] = 0x000842870c66632bUL;
   tf->codes[21536] = 0x00084298344d13e2UL;
   tf->codes[21537] = 0x000842c5445c847bUL;
   tf->codes[21538] = 0x000842c6a3b6a719UL;
   tf->codes[21539] = 0x000842d71bf04681UL;
   tf->codes[21540] = 0x000842f75cb67402UL;
   tf->codes[21541] = 0x000843060077e542UL;
   tf->codes[21542] = 0x0008433818d1d4c9UL;
   tf->codes[21543] = 0x0008434682044044UL;
   tf->codes[21544] = 0x0008434dd3e4f8e4UL;
   tf->codes[21545] = 0x0008434fa85d270cUL;
   tf->codes[21546] = 0x00084351b7645af9UL;
   tf->codes[21547] = 0x00084362a4bc05ebUL;
   tf->codes[21548] = 0x0008436c4032f83dUL;
   tf->codes[21549] = 0x00084371487d772bUL;
   tf->codes[21550] = 0x00084375668bdf05UL;
   tf->codes[21551] = 0x00084378d4ed3590UL;
   tf->codes[21552] = 0x0008445089c3763bUL;
   tf->codes[21553] = 0x00084469038adf92UL;
   tf->codes[21554] = 0x0008447906a67370UL;
   tf->codes[21555] = 0x000844926aa9f3dbUL;
   tf->codes[21556] = 0x000844e4893b0b1eUL;
   tf->codes[21557] = 0x000844f48c569efcUL;
   tf->codes[21558] = 0x000844faf3fb4088UL;
   tf->codes[21559] = 0x000844fe625c9713UL;
   tf->codes[21560] = 0x00084513e2e0b569UL;
   tf->codes[21561] = 0x0008451f52cfd5e3UL;
   tf->codes[21562] = 0x00084553b4bfff1cUL;
   tf->codes[21563] = 0x00084557983f6131UL;
   tf->codes[21564] = 0x0008459e46e157faUL;
   tf->codes[21565] = 0x000845ae0f6de613UL;
   tf->codes[21566] = 0x000845c7e88f7208UL;
   tf->codes[21567] = 0x000845d68c50e348UL;
   tf->codes[21568] = 0x000845d73bfdf497UL;
   tf->codes[21569] = 0x000845dbcf2a67fbUL;
   tf->codes[21570] = 0x000845e2abed1511UL;
   tf->codes[21571] = 0x000845f98bcb5605UL;
   tf->codes[21572] = 0x000845fcbf9da6cbUL;
   tf->codes[21573] = 0x000845fecea4dab8UL;
   tf->codes[21574] = 0x0008460c882a34e4UL;
   tf->codes[21575] = 0x0008460dacf551bdUL;
   tf->codes[21576] = 0x0008461ed4dc0274UL;
   tf->codes[21577] = 0x000846483bfb16bdUL;
   tf->codes[21578] = 0x000846580487a4d6UL;
   tf->codes[21579] = 0x0008465b3859f59cUL;
   tf->codes[21580] = 0x0008466b00e683b5UL;
   tf->codes[21581] = 0x00084673ecb064b8UL;
   tf->codes[21582] = 0x0008467cd87a45bbUL;
   tf->codes[21583] = 0x000846854f261b34UL;
   tf->codes[21584] = 0x0008468b41acb136UL;
   tf->codes[21585] = 0x00084693b85886afUL;
   tf->codes[21586] = 0x000846a2d1380379UL;
   tf->codes[21587] = 0x000846b851bc21cfUL;
   tf->codes[21588] = 0x000846c76a9b9e99UL;
   tf->codes[21589] = 0x000846df6f44fc66UL;
   tf->codes[21590] = 0x000847619728cf43UL;
   tf->codes[21591] = 0x0008476873eb7c59UL;
   tf->codes[21592] = 0x0008477c5a86724cUL;
   tf->codes[21593] = 0x00084783e6f630b1UL;
   tf->codes[21594] = 0x0008478d826d2303UL;
   tf->codes[21595] = 0x000847db82efd26cUL;
   tf->codes[21596] = 0x000847deb6c22332UL;
   tf->codes[21597] = 0x000847ee7f4eb14bUL;
   tf->codes[21598] = 0x000847f262ce1360UL;
   tf->codes[21599] = 0x00084810cf1c12b9UL;
   tf->codes[21600] = 0x00084845a62a477cUL;
   tf->codes[21601] = 0x00084849fec7b51bUL;
   tf->codes[21602] = 0x00084859523637aaUL;
   tf->codes[21603] = 0x000848670bbb91d6UL;
   tf->codes[21604] = 0x0008488e9e6277f7UL;
   tf->codes[21605] = 0x0008489e66ef0610UL;
   tf->codes[21606] = 0x000848af5446b102UL;
   tf->codes[21607] = 0x000848d6ac5e915eUL;
   tf->codes[21608] = 0x000848d80bb8b3fcUL;
   tf->codes[21609] = 0x000848f468ff7f68UL;
   tf->codes[21610] = 0x0008490bf88ad1abUL;
   tf->codes[21611] = 0x0008495f3be705c7UL;
   tf->codes[21612] = 0x000849652e6d9bc9UL;
   tf->codes[21613] = 0x0008497a39d3ae95UL;
   tf->codes[21614] = 0x0008497e57e2166fUL;
   tf->codes[21615] = 0x0008497f7cad3348UL;
   tf->codes[21616] = 0x00084984bf86b7fbUL;
   tf->codes[21617] = 0x0008498693fee623UL;
   tf->codes[21618] = 0x00084992ee2a1db1UL;
   tf->codes[21619] = 0x000849cfc6c61c63UL;
   tf->codes[21620] = 0x000849e00470b606UL;
   tf->codes[21621] = 0x00084a1082e17d2aUL;
   tf->codes[21622] = 0x00084a17d4c235caUL;
   tf->codes[21623] = 0x00084a44e4d1a663UL;
   tf->codes[21624] = 0x00084a4977fe19c7UL;
   tf->codes[21625] = 0x00084a4bfc23593eUL;
   tf->codes[21626] = 0x00084a53889317a3UL;
   tf->codes[21627] = 0x00084a652597d3e4UL;
   tf->codes[21628] = 0x00084a71f4e116fcUL;
   tf->codes[21629] = 0x00084a947f3d7e2fUL;
   tf->codes[21630] = 0x00084ad2421593f5UL;
   tf->codes[21631] = 0x00084ad366e0b0ceUL;
   tf->codes[21632] = 0x00084afd431dd0a1UL;
   tf->codes[21633] = 0x00084b458ba8efcdUL;
   tf->codes[21634] = 0x00084b48fa0a4658UL;
   tf->codes[21635] = 0x00084b4d52a7b3f7UL;
   tf->codes[21636] = 0x00084b651cc20bffUL;
   tf->codes[21637] = 0x00084bd7b6a85688UL;
   tf->codes[21638] = 0x00084bee21688bf2UL;
   tf->codes[21639] = 0x00084c4d0f42e64dUL;
   tf->codes[21640] = 0x00084c4d8460f1d7UL;
   tf->codes[21641] = 0x00084c8b0caa01d8UL;
   tf->codes[21642] = 0x00084c9557ce0579UL;
   tf->codes[21643] = 0x00084cb891d77dfbUL;
   tf->codes[21644] = 0x00084cc610cdd262UL;
   tf->codes[21645] = 0x00084ccc787273eeUL;
   tf->codes[21646] = 0x00084cdbcbe0f67dUL;
   tf->codes[21647] = 0x00084cdc7b8e07ccUL;
   tf->codes[21648] = 0x00084cec7ea99baaUL;
   tf->codes[21649] = 0x00084cedde03be48UL;
   tf->codes[21650] = 0x00084ceec83fd55cUL;
   tf->codes[21651] = 0x00084d1e5c74856cUL;
   tf->codes[21652] = 0x00084d2c5088e55dUL;
   tf->codes[21653] = 0x00084d3994f033ffUL;
   tf->codes[21654] = 0x00084d47c39399b5UL;
   tf->codes[21655] = 0x00084d5a10456745UL;
   tf->codes[21656] = 0x00084d6420da6521UL;
   tf->codes[21657] = 0x00084d6754acb5e7UL;
   tf->codes[21658] = 0x00084d7966cf7db2UL;
   tf->codes[21659] = 0x00084d8b3e633fb8UL;
   tf->codes[21660] = 0x00084dc816ff3e6aUL;
   tf->codes[21661] = 0x00084de8925471b0UL;
   tf->codes[21662] = 0x00084dee84db07b2UL;
   tf->codes[21663] = 0x00084e7246a802f2UL;
   tf->codes[21664] = 0x00084e75ef985f42UL;
   tf->codes[21665] = 0x00084e945be65e9bUL;
   tf->codes[21666] = 0x00084e996430dd89UL;
   tf->codes[21667] = 0x00084ed93610273cUL;
   tf->codes[21668] = 0x00084edd8ead94dbUL;
   tf->codes[21669] = 0x00084f3feae945c1UL;
   tf->codes[21670] = 0x00084f4fb375d3daUL;
   tf->codes[21671] = 0x00084f5e5737451aUL;
   tf->codes[21672] = 0x00084f79ca41f972UL;
   tf->codes[21673] = 0x00084f94531096b6UL;
   tf->codes[21674] = 0x00084f9b2fd343ccUL;
   tf->codes[21675] = 0x00084fd4d49cf1b8UL;
   tf->codes[21676] = 0x00084fed4e645b0fUL;
   tf->codes[21677] = 0x00084ff674bd41d7UL;
   tf->codes[21678] = 0x00084ff933718713UL;
   tf->codes[21679] = 0x00084ffbb796c68aUL;
   tf->codes[21680] = 0x0008500a20c93205UL;
   tf->codes[21681] = 0x0008500e3ed799dfUL;
   tf->codes[21682] = 0x0008504efaf2faa6UL;
   tf->codes[21683] = 0x00085053c8ae73cfUL;
   tf->codes[21684] = 0x000850d2f74efbabUL;
   tf->codes[21685] = 0x000850d6a03f57fbUL;
   tf->codes[21686] = 0x000850ffcccf667fUL;
   tf->codes[21687] = 0x0008514b0e9dd0acUL;
   tf->codes[21688] = 0x0008515434f6b774UL;
   tf->codes[21689] = 0x0008515d5b4f9e3cUL;
   tf->codes[21690] = 0x00085165224e6266UL;
   tf->codes[21691] = 0x000851676be49c18UL;
   tf->codes[21692] = 0x000851b531d845bcUL;
   tf->codes[21693] = 0x000851fa0c020e5dUL;
   tf->codes[21694] = 0x00085203a77900afUL;
   tf->codes[21695] = 0x0008523e367ec5afUL;
   tf->codes[21696] = 0x000852449e23673bUL;
   tf->codes[21697] = 0x0008524f23d670a1UL;
   tf->codes[21698] = 0x00085250f84e9ec9UL;
   tf->codes[21699] = 0x00085259e4187fccUL;
   tf->codes[21700] = 0x0008526170883e31UL;
   tf->codes[21701] = 0x0008526b468e3648UL;
   tf->codes[21702] = 0x0008526ce0775eabUL;
   tf->codes[21703] = 0x000852cb93c2b341UL;
   tf->codes[21704] = 0x000852d35ac1776bUL;
   tf->codes[21705] = 0x000852e06499c048UL;
   tf->codes[21706] = 0x0008534803aef5e1UL;
   tf->codes[21707] = 0x000853700b73e78cUL;
   tf->codes[21708] = 0x0008539d56125deaUL;
   tf->codes[21709] = 0x000853c8cc38a620UL;
   tf->codes[21710] = 0x000853d267af9872UL;
   tf->codes[21711] = 0x000853f73ba23957UL;
   tf->codes[21712] = 0x0008540a72901dfbUL;
   tf->codes[21713] = 0x0008540b5ccc350fUL;
   tf->codes[21714] = 0x0008543fbebc5e48UL;
   tf->codes[21715] = 0x00085453dfe65a00UL;
   tf->codes[21716] = 0x0008547ee0ee96acUL;
   tf->codes[21717] = 0x000854c5ca1f933aUL;
   tf->codes[21718] = 0x000854df2e2313a5UL;
   tf->codes[21719] = 0x000855097f7e3f02UL;
   tf->codes[21720] = 0x00085519f7b7de6aUL;
   tf->codes[21721] = 0x0008554916ce82f0UL;
   tf->codes[21722] = 0x00085550a33e4155UL;
   tf->codes[21723] = 0x0008555f46ffb295UL;
   tf->codes[21724] = 0x0008557ed818cec7UL;
   tf->codes[21725] = 0x0008558ea0a55ce0UL;
   tf->codes[21726] = 0x000855cf2231b7e2UL;
   tf->codes[21727] = 0x0008560642d62657UL;
   tf->codes[21728] = 0x0008561b88cb3ee8UL;
   tf->codes[21729] = 0x0008561e477f8424UL;
   tf->codes[21730] = 0x00085636c146ed7bUL;
   tf->codes[21731] = 0x00085644efea5331UL;
   tf->codes[21732] = 0x0008564e8b614583UL;
   tf->codes[21733] = 0x0008569d3b91063bUL;
   tf->codes[21734] = 0x000856e6a8e74240UL;
   tf->codes[21735] = 0x000856e9679b877cUL;
   tf->codes[21736] = 0x000856f378308558UL;
   tf->codes[21737] = 0x000856f75bafe76dUL;
   tf->codes[21738] = 0x00085703062e0dacUL;
   tf->codes[21739] = 0x000857184c23263dUL;
   tf->codes[21740] = 0x0008574680fdb3afUL;
   tf->codes[21741] = 0x00085755d46c363eUL;
   tf->codes[21742] = 0x0008576e13a499d0UL;
   tf->codes[21743] = 0x0008577d67131c5fUL;
   tf->codes[21744] = 0x000857c0a753bc9dUL;
   tf->codes[21745] = 0x000857c833c37b02UL;
   tf->codes[21746] = 0x000857da0b573d08UL;
   tf->codes[21747] = 0x000857eba85bf949UL;
   tf->codes[21748] = 0x0008585b838dfe96UL;
   tf->codes[21749] = 0x0008586b4c1a8cafUL;
   tf->codes[21750] = 0x00085876f698b2eeUL;
   tf->codes[21751] = 0x000858789081db51UL;
   tf->codes[21752] = 0x0008587d23ae4eb5UL;
   tf->codes[21753] = 0x000858859a5a242eUL;
   tf->codes[21754] = 0x0008588908bb7ab9UL;
   tf->codes[21755] = 0x0008588d26c9e293UL;
   tf->codes[21756] = 0x000858c2ad8528a5UL;
   tf->codes[21757] = 0x000858ec14a43ceeUL;
   tf->codes[21758] = 0x00085940f1e9996dUL;
   tf->codes[21759] = 0x000859412c789f32UL;
   tf->codes[21760] = 0x0008594b027e9749UL;
   tf->codes[21761] = 0x0008594f208cff23UL;
   tf->codes[21762] = 0x0008599818c52f9eUL;
   tf->codes[21763] = 0x000859c981720dd6UL;
   tf->codes[21764] = 0x000859cf73f8a3d8UL;
   tf->codes[21765] = 0x000859d40725173cUL;
   tf->codes[21766] = 0x000859f9ffe2d4faUL;
   tf->codes[21767] = 0x00085a1cc4ce41f2UL;
   tf->codes[21768] = 0x00085a67cc0da65aUL;
   tf->codes[21769] = 0x00085a792e835cd6UL;
   tf->codes[21770] = 0x00085a8379a76077UL;
   tf->codes[21771] = 0x00085a9600e833ccUL;
   tf->codes[21772] = 0x00085a976042566aUL;
   tf->codes[21773] = 0x00085a9eecb214cfUL;
   tf->codes[21774] = 0x00085abc3434f74fUL;
   tf->codes[21775] = 0x00085ae64b011ce7UL;
   tf->codes[21776] = 0x00085af59e6f9f76UL;
   tf->codes[21777] = 0x00085af82294deedUL;
   tf->codes[21778] = 0x00085afb90f63578UL;
   tf->codes[21779] = 0x00085b0ae464b807UL;
   tf->codes[21780] = 0x00085b15a4a6c732UL;
   tf->codes[21781] = 0x00085b4623178e56UL;
   tf->codes[21782] = 0x00085b4cffda3b6cUL;
   tf->codes[21783] = 0x00085b54c6d8ff96UL;
   tf->codes[21784] = 0x00085b7f52c330b8UL;
   tf->codes[21785] = 0x00085bf93e8a33e1UL;
   tf->codes[21786] = 0x00085c07329e93d2UL;
   tf->codes[21787] = 0x00085c0941a5c7bfUL;
   tf->codes[21788] = 0x00085c0a6670e498UL;
   tf->codes[21789] = 0x00085c2f3a63857dUL;
   tf->codes[21790] = 0x00085c502ad6c44dUL;
   tf->codes[21791] = 0x00085c52746cfdffUL;
   tf->codes[21792] = 0x00085c5d6f3e12efUL;
   tf->codes[21793] = 0x00085c7e9a405784UL;
   tf->codes[21794] = 0x00085cd6ab5804c9UL;
   tf->codes[21795] = 0x00085ce0815dfce0UL;
   tf->codes[21796] = 0x00085ce882ebc6cfUL;
   tf->codes[21797] = 0x00085cf467f8f2d3UL;
   tf->codes[21798] = 0x00085d5e50a4621eUL;
   tf->codes[21799] = 0x00085d898c3ba48fUL;
   tf->codes[21800] = 0x00085d94fc2ac509UL;
   tf->codes[21801] = 0x00085dc62a489d7cUL;
   tf->codes[21802] = 0x00085ddc5a79cd21UL;
   tf->codes[21803] = 0x00085de19d5351d4UL;
   tf->codes[21804] = 0x00085df3af76199fUL;
   tf->codes[21805] = 0x00085e242de6e0c3UL;
   tf->codes[21806] = 0x00085e8fb07b7871UL;
   tf->codes[21807] = 0x00085ec9ca6331e7UL;
   tf->codes[21808] = 0x00085edaf249e29eUL;
   tf->codes[21809] = 0x00085eedeea8c17dUL;
   tf->codes[21810] = 0x00085f0668702ad4UL;
   tf->codes[21811] = 0x00085f44daf551e9UL;
   tf->codes[21812] = 0x00085f730fcfdf5bUL;
   tf->codes[21813] = 0x00085f83c2988488UL;
   tf->codes[21814] = 0x00085f9e10d81c07UL;
   tf->codes[21815] = 0x00086015035bd42fUL;
   tf->codes[21816] = 0x0008602874d8be98UL;
   tf->codes[21817] = 0x00086054601d1258UL;
   tf->codes[21818] = 0x0008605ac7c1b3e4UL;
   tf->codes[21819] = 0x0008607a9369d5dbUL;
   tf->codes[21820] = 0x0008608a5bf663f4UL;
   tf->codes[21821] = 0x000860c400c011e0UL;
   tf->codes[21822] = 0x000860c60fc745cdUL;
   tf->codes[21823] = 0x000860d38ebd9a34UL;
   tf->codes[21824] = 0x000860f394f4c1f0UL;
   tf->codes[21825] = 0x000860f3cf83c7b5UL;
   tf->codes[21826] = 0x000860f444a1d33fUL;
   tf->codes[21827] = 0x0008611a77ee96c2UL;
   tf->codes[21828] = 0x0008614b6b7d6970UL;
   tf->codes[21829] = 0x0008614e64c0b471UL;
   tf->codes[21830] = 0x0008614ed9debffbUL;
   tf->codes[21831] = 0x00086158ea73bdd7UL;
   tf->codes[21832] = 0x00086175bcd894cdUL;
   tf->codes[21833] = 0x0008617b74d0250aUL;
   tf->codes[21834] = 0x00086187cefb5c98UL;
   tf->codes[21835] = 0x0008618968e484fbUL;
   tf->codes[21836] = 0x00086193045b774dUL;
   tf->codes[21837] = 0x000861d3fb05ddd9UL;
   tf->codes[21838] = 0x000861ee0eb66f93UL;
   tf->codes[21839] = 0x0008625f0eb391b9UL;
   tf->codes[21840] = 0x0008627f4f79bf3aUL;
   tf->codes[21841] = 0x000862cc2b3151caUL;
   tf->codes[21842] = 0x000862d083cebf69UL;
   tf->codes[21843] = 0x000862f3f8673db0UL;
   tf->codes[21844] = 0x0008631f6e8d85e6UL;
   tf->codes[21845] = 0x00086343cd621b41UL;
   tf->codes[21846] = 0x0008634da3681358UL;
   tf->codes[21847] = 0x00086373d6b4d6dbUL;
   tf->codes[21848] = 0x0008637a3e597867UL;
   tf->codes[21849] = 0x0008638ab69317cfUL;
   tf->codes[21850] = 0x000863c1278a74f5UL;
   tf->codes[21851] = 0x000863edc27bda04UL;
   tf->codes[21852] = 0x000864058c96320cUL;
   tf->codes[21853] = 0x0008641e065d9b63UL;
   tf->codes[21854] = 0x0008644a66bffaadUL;
   tf->codes[21855] = 0x0008644cb056345fUL;
   tf->codes[21856] = 0x000864661459b4caUL;
   tf->codes[21857] = 0x0008646b5733397dUL;
   tf->codes[21858] = 0x00086477ebed76d0UL;
   tf->codes[21859] = 0x000864d0acb23564UL;
   tf->codes[21860] = 0x000864d8e8cf0518UL;
   tf->codes[21861] = 0x000864f162966e6fUL;
   tf->codes[21862] = 0x0008659898fbe7f6UL;
   tf->codes[21863] = 0x000865cc4b3effe0UL;
   tf->codes[21864] = 0x000865d20336901dUL;
   tf->codes[21865] = 0x000865e7be49b438UL;
   tf->codes[21866] = 0x00086631db4d018cUL;
   tf->codes[21867] = 0x0008663424e33b3eUL;
   tf->codes[21868] = 0x0008664a1a85651eUL;
   tf->codes[21869] = 0x0008666fd8b41d17UL;
   tf->codes[21870] = 0x00086675cb3ab319UL;
   tf->codes[21871] = 0x0008668d2036ff97UL;
   tf->codes[21872] = 0x00086698cab525d6UL;
   tf->codes[21873] = 0x0008669ef7cac19dUL;
   tf->codes[21874] = 0x000866b7e6b0367eUL;
   tf->codes[21875] = 0x000866c4f0887f5bUL;
   tf->codes[21876] = 0x000866ce16e16623UL;
   tf->codes[21877] = 0x000866d7ece75e3aUL;
   tf->codes[21878] = 0x000866df3ec816daUL;
   tf->codes[21879] = 0x00086723de62d9b6UL;
   tf->codes[21880] = 0x000867549762a69fUL;
   tf->codes[21881] = 0x0008675f57a4b5caUL;
   tf->codes[21882] = 0x00086773b35db747UL;
   tf->codes[21883] = 0x00086774287bc2d1UL;
   tf->codes[21884] = 0x000867916ffea551UL;
   tf->codes[21885] = 0x0008679b8093a32dUL;
   tf->codes[21886] = 0x0008679c6acfba41UL;
   tf->codes[21887] = 0x000867f3571c4aadUL;
   tf->codes[21888] = 0x000868035a37de8bUL;
   tf->codes[21889] = 0x00086806c8993516UL;
   tf->codes[21890] = 0x0008681c83ac5931UL;
   tf->codes[21891] = 0x00086858377d3b0aUL;
   tf->codes[21892] = 0x0008686ba8fa2573UL;
   tf->codes[21893] = 0x000868bd17de2b67UL;
   tf->codes[21894] = 0x00086966d268e465UL;
   tf->codes[21895] = 0x00086970a86edc7cUL;
   tf->codes[21896] = 0x00086992f83c3deaUL;
   tf->codes[21897] = 0x000869cd874202eaUL;
   tf->codes[21898] = 0x000869dd4fce9103UL;
   tf->codes[21899] = 0x00086a09eabff612UL;
   tf->codes[21900] = 0x00086a160a5c27dbUL;
   tf->codes[21901] = 0x00086a1d96cbe640UL;
   tf->codes[21902] = 0x00086a52334b153eUL;
   tf->codes[21903] = 0x00086a67b3cf3394UL;
   tf->codes[21904] = 0x00086a7c0f883511UL;
   tf->codes[21905] = 0x00086a8b62f6b7a0UL;
   tf->codes[21906] = 0x00086a9a7bd6346aUL;
   tf->codes[21907] = 0x00086acfc80274b7UL;
   tf->codes[21908] = 0x00086af87f7477b1UL;
   tf->codes[21909] = 0x00086b11a8e8f257UL;
   tf->codes[21910] = 0x00086b50908c24f6UL;
   tf->codes[21911] = 0x00086b6944e29412UL;
   tf->codes[21912] = 0x00086bc7830fdd1eUL;
   tf->codes[21913] = 0x00086be9984e38c7UL;
   tf->codes[21914] = 0x00086beea098b7b5UL;
   tf->codes[21915] = 0x00086c0e6c40d9acUL;
   tf->codes[21916] = 0x00086c1b00fb16ffUL;
   tf->codes[21917] = 0x00086c44a2a9310dUL;
   tf->codes[21918] = 0x00086c713d9a961cUL;
   tf->codes[21919] = 0x00086c78ca0a5481UL;
   tf->codes[21920] = 0x00086c8bc6693360UL;
   tf->codes[21921] = 0x00086cd742c6a352UL;
   tf->codes[21922] = 0x00086d9bfb3e051eUL;
   tf->codes[21923] = 0x00086d9fdebd6733UL;
   tf->codes[21924] = 0x00086dcf72f21743UL;
   tf->codes[21925] = 0x00086e04848f51cbUL;
   tf->codes[21926] = 0x00086e0ecfb3556cUL;
   tf->codes[21927] = 0x00086eb6f054e607UL;
   tf->codes[21928] = 0x00086ed7a6391f12UL;
   tf->codes[21929] = 0x00086ee908aed58eUL;
   tf->codes[21930] = 0x00086ef896ac5de2UL;
   tf->codes[21931] = 0x00086f15a3a03a9dUL;
   tf->codes[21932] = 0x00086f3f0abf4ee6UL;
   tf->codes[21933] = 0x00086f511ce216b1UL;
   tf->codes[21934] = 0x00086f7038dd2759UL;
   tf->codes[21935] = 0x00086f750698a082UL;
   tf->codes[21936] = 0x00086fb80c4a3afbUL;
   tf->codes[21937] = 0x00086ffb4c8adb39UL;
   tf->codes[21938] = 0x0008705ff25cc5d1UL;
   tf->codes[21939] = 0x0008707154d27c4dUL;
   tf->codes[21940] = 0x0008708416a25567UL;
   tf->codes[21941] = 0x0008708f869175e1UL;
   tf->codes[21942] = 0x00087097c2ae4595UL;
   tf->codes[21943] = 0x0008709a46d3850cUL;
   tf->codes[21944] = 0x000870efd3c5f2daUL;
   tf->codes[21945] = 0x00087148948ab16eUL;
   tf->codes[21946] = 0x00087196cf9c669cUL;
   tf->codes[21947] = 0x000871c8e7f65623UL;
   tf->codes[21948] = 0x000871cf4f9af7afUL;
   tf->codes[21949] = 0x000871dc5973408cUL;
   tf->codes[21950] = 0x000871fd84758521UL;
   tf->codes[21951] = 0x00087235c9e5106fUL;
   tf->codes[21952] = 0x0008724bbf873a4fUL;
   tf->codes[21953] = 0x000872538685fe79UL;
   tf->codes[21954] = 0x000872970155a47cUL;
   tf->codes[21955] = 0x0008729fb2907fbaUL;
   tf->codes[21956] = 0x0008731f564f1320UL;
   tf->codes[21957] = 0x0008738b1372b093UL;
   tf->codes[21958] = 0x000873cdde954547UL;
   tf->codes[21959] = 0x000873ea766b1678UL;
   tf->codes[21960] = 0x0008741d3e72174eUL;
   tf->codes[21961] = 0x00087451daf1464cUL;
   tf->codes[21962] = 0x000874925c7da14eUL;
   tf->codes[21963] = 0x00087499ae5e59eeUL;
   tf->codes[21964] = 0x000874cf6fa8a5c5UL;
   tf->codes[21965] = 0x000874eddbf6a51eUL;
   tf->codes[21966] = 0x000874f7024f8be6UL;
   tf->codes[21967] = 0x000874fb5aecf985UL;
   tf->codes[21968] = 0x000875123acb3a79UL;
   tf->codes[21969] = 0x0008751daaba5af3UL;
   tf->codes[21970] = 0x0008755e66d5bbbaUL;
   tf->codes[21971] = 0x000875bd54b01615UL;
   tf->codes[21972] = 0x000875cf66d2dde0UL;
   tf->codes[21973] = 0x000875da9c32f895UL;
   tf->codes[21974] = 0x000875ece8e4c625UL;
   tf->codes[21975] = 0x0008765a7a8091c0UL;
   tf->codes[21976] = 0x0008765b2a2da30fUL;
   tf->codes[21977] = 0x0008765ff7e91c38UL;
   tf->codes[21978] = 0x000876657551a6b0UL;
   tf->codes[21979] = 0x000876665f8dbdc4UL;
   tf->codes[21980] = 0x0008767cca4df32eUL;
   tf->codes[21981] = 0x0008768edc70baf9UL;
   tf->codes[21982] = 0x000876b7ce71c3b8UL;
   tf->codes[21983] = 0x0008770ebabe5424UL;
   tf->codes[21984] = 0x000877152262f5b0UL;
   tf->codes[21985] = 0x0008774c08785e60UL;
   tf->codes[21986] = 0x0008776b5f0274cdUL;
   tf->codes[21987] = 0x0008777d369636d3UL;
   tf->codes[21988] = 0x000877991ebef6b5UL;
   tf->codes[21989] = 0x0008779a08fb0dc9UL;
   tf->codes[21990] = 0x0008779cc7af5305UL;
   tf->codes[21991] = 0x000877fb7afaa79bUL;
   tf->codes[21992] = 0x00087805167199edUL;
   tf->codes[21993] = 0x0008781f9f403731UL;
   tf->codes[21994] = 0x00087849f09b628eUL;
   tf->codes[21995] = 0x00087867e7cb565dUL;
   tf->codes[21996] = 0x00087869bc438485UL;
   tf->codes[21997] = 0x0008789ff2abdbe6UL;
   tf->codes[21998] = 0x000878b5732ffa3cUL;
   tf->codes[21999] = 0x000878efc7a6b977UL;
   tf->codes[22000] = 0x0008791b785c0772UL;
   tf->codes[22001] = 0x0008794972a78f1fUL;
   tf->codes[22002] = 0x0008794d90b5f6f9UL;
   tf->codes[22003] = 0x0008799404c8e7fdUL;
   tf->codes[22004] = 0x000879c69240e30eUL;
   tf->codes[22005] = 0x00087a1c94515c66UL;
   tf->codes[22006] = 0x00087a475aca934dUL;
   tf->codes[22007] = 0x00087a763f52320eUL;
   tf->codes[22008] = 0x00087a784e5965fbUL;
   tf->codes[22009] = 0x00087a79e8428e5eUL;
   tf->codes[22010] = 0x00087a830e9b7526UL;
   tf->codes[22011] = 0x00087a846df597c4UL;
   tf->codes[22012] = 0x00087a8d944e7e8cUL;
   tf->codes[22013] = 0x00087ad2e39652b7UL;
   tf->codes[22014] = 0x00087ae9fe039970UL;
   tf->codes[22015] = 0x00087af18a7357d5UL;
   tf->codes[22016] = 0x00087b1414cfbf08UL;
   tf->codes[22017] = 0x00087b1783311593UL;
   tf->codes[22018] = 0x00087b712e31eb3bUL;
   tf->codes[22019] = 0x00087b85c479f27dUL;
   tf->codes[22020] = 0x00087b90f9da0d32UL;
   tf->codes[22021] = 0x00087c194ed37bd6UL;
   tf->codes[22022] = 0x00087c4fbfcad8fcUL;
   tf->codes[22023] = 0x00087c7334635743UL;
   tf->codes[22024] = 0x00087c83e72bfc70UL;
   tf->codes[22025] = 0x00087c907be639c3UL;
   tf->codes[22026] = 0x00087cb0bcac6744UL;
   tf->codes[22027] = 0x00087ccf28fa669dUL;
   tf->codes[22028] = 0x00087d0a67ad3cecUL;
   tf->codes[22029] = 0x00087d461b7e1ec5UL;
   tf->codes[22030] = 0x00087dc71e96d4c9UL;
   tf->codes[22031] = 0x00087dc87df0f767UL;
   tf->codes[22032] = 0x00087dcf20249eb8UL;
   tf->codes[22033] = 0x00087dd462fe236bUL;
   tf->codes[22034] = 0x00087de9e38241c1UL;
   tf->codes[22035] = 0x00087df3f4173f9dUL;
   tf->codes[22036] = 0x00087e4c3fbdf2a7UL;
   tf->codes[22037] = 0x00087e6bd0d70ed9UL;
   tf->codes[22038] = 0x00087ec4570cc7a8UL;
   tf->codes[22039] = 0x00087ef042511b68UL;
   tf->codes[22040] = 0x00087efa1857137fUL;
   tf->codes[22041] = 0x00087f0b403dc436UL;
   tf->codes[22042] = 0x00087f51eedfbaffUL;
   tf->codes[22043] = 0x00087f5856845c8bUL;
   tf->codes[22044] = 0x00087fa98ad95cbaUL;
   tf->codes[22045] = 0x00087fd500ffa4f0UL;
   tf->codes[22046] = 0x00087fddecc985f3UL;
   tf->codes[22047] = 0x00087ff8007a17adUL;
   tf->codes[22048] = 0x0008800d466f303eUL;
   tf->codes[22049] = 0x0008801bea30a17eUL;
   tf->codes[22050] = 0x0008801e33c6db30UL;
   tf->codes[22051] = 0x000880563ea760b9UL;
   tf->codes[22052] = 0x000880655786dd83UL;
   tf->codes[22053] = 0x000880705257f273UL;
   tf->codes[22054] = 0x0008807c71f4243cUL;
   tf->codes[22055] = 0x000880c89dfea57dUL;
   tf->codes[22056] = 0x000880f65dbb2765UL;
   tf->codes[22057] = 0x000880fdea2ae5caUL;
   tf->codes[22058] = 0x000880ff0ef602a3UL;
   tf->codes[22059] = 0x00088110e689c4a9UL;
   tf->codes[22060] = 0x000881195d359a22UL;
   tf->codes[22061] = 0x000881471cf21c0aUL;
   tf->codes[22062] = 0x0008814c9a5aa682UL;
   tf->codes[22063] = 0x000881533c8e4dd3UL;
   tf->codes[22064] = 0x0008819174846f23UL;
   tf->codes[22065] = 0x000881d31adbe6feUL;
   tf->codes[22066] = 0x000881f9c346b60bUL;
   tf->codes[22067] = 0x000881fff05c51d2UL;
   tf->codes[22068] = 0x000882170ac9988bUL;
   tf->codes[22069] = 0x000882366153aef8UL;
   tf->codes[22070] = 0x00088251d45e6350UL;
   tf->codes[22071] = 0x0008826a88b4d26cUL;
   tf->codes[22072] = 0x0008828670dd924eUL;
   tf->codes[22073] = 0x0008829c2bf0b669UL;
   tf->codes[22074] = 0x0008829eb015f5e0UL;
   tf->codes[22075] = 0x000882ca60cb43dbUL;
   tf->codes[22076] = 0x000882e2da92ad32UL;
   tf->codes[22077] = 0x000882f9f4fff3ebUL;
   tf->codes[22078] = 0x0008830b1ce6a4a2UL;
   tf->codes[22079] = 0x000883189bdcf909UL;
   tf->codes[22080] = 0x0008835748f125e3UL;
   tf->codes[22081] = 0x0008835992875f95UL;
   tf->codes[22082] = 0x0008837f162711c9UL;
   tf->codes[22083] = 0x00088390037ebcbbUL;
   tf->codes[22084] = 0x0008839f56ed3f4aUL;
   tf->codes[22085] = 0x000883df635b8ec2UL;
   tf->codes[22086] = 0x000883f29a497366UL;
   tf->codes[22087] = 0x00088419f26153c2UL;
   tf->codes[22088] = 0x0008847e231532d0UL;
   tf->codes[22089] = 0x00088488e35741fbUL;
   tf->codes[22090] = 0x0008848ba20b8737UL;
   tf->codes[22091] = 0x0008849418b75cb0UL;
   tf->codes[22092] = 0x0008849502f373c4UL;
   tf->codes[22093] = 0x000884978718b33bUL;
   tf->codes[22094] = 0x00088497fc36bec5UL;
   tf->codes[22095] = 0x0008849deebd54c7UL;
   tf->codes[22096] = 0x000884afc65116cdUL;
   tf->codes[22097] = 0x000884b0eb1c33a6UL;
   tf->codes[22098] = 0x000884c71b4d634bUL;
   tf->codes[22099] = 0x000884d0b6c4559dUL;
   tf->codes[22100] = 0x000884dc26b37617UL;
   tf->codes[22101] = 0x000884df1ff6c118UL;
   tf->codes[22102] = 0x0008851939de7a8eUL;
   tf->codes[22103] = 0x0008855ec3b5547eUL;
   tf->codes[22104] = 0x0008856a33a474f8UL;
   tf->codes[22105] = 0x0008856f3beef3e6UL;
   tf->codes[22106] = 0x000885afbd7b4ee8UL;
   tf->codes[22107] = 0x000885eafc2e2537UL;
   tf->codes[22108] = 0x000886050fdeb6f1UL;
   tf->codes[22109] = 0x0008863ce03036b5UL;
   tf->codes[22110] = 0x0008865818abe548UL;
   tf->codes[22111] = 0x00088697004f17e7UL;
   tf->codes[22112] = 0x000886d572d43efcUL;
   tf->codes[22113] = 0x00088735105baaa6UL;
   tf->codes[22114] = 0x0008875fd6d4e18dUL;
   tf->codes[22115] = 0x00088761e5dc157aUL;
   tf->codes[22116] = 0x0008876345363818UL;
   tf->codes[22117] = 0x0008876d905a3bb9UL;
   tf->codes[22118] = 0x0008877382e0d1bbUL;
   tf->codes[22119] = 0x0008877900495c33UL;
   tf->codes[22120] = 0x0008885ee3c30294UL;
   tf->codes[22121] = 0x000888754e8337feUL;
   tf->codes[22122] = 0x0008887f24893015UL;
   tf->codes[22123] = 0x000888be0c2c62b4UL;
   tf->codes[22124] = 0x000888ddd7d484abUL;
   tf->codes[22125] = 0x000888efaf6846b1UL;
   tf->codes[22126] = 0x000888f6519bee02UL;
   tf->codes[22127] = 0x00088913d3add647UL;
   tf->codes[22128] = 0x0008893fbef22a07UL;
   tf->codes[22129] = 0x000889448cada330UL;
   tf->codes[22130] = 0x0008894ed7d1a6d1UL;
   tf->codes[22131] = 0x00088971d74c198eUL;
   tf->codes[22132] = 0x0008898c258bb10dUL;
   tf->codes[22133] = 0x00088991686535c0UL;
   tf->codes[22134] = 0x000889b21e496ecbUL;
   tf->codes[22135] = 0x000889ba94f54444UL;
   tf->codes[22136] = 0x000889cfa05b5710UL;
   tf->codes[22137] = 0x000889df2e58df64UL;
   tf->codes[22138] = 0x000889eb888416f2UL;
   tf->codes[22139] = 0x000889f4aedcfdbaUL;
   tf->codes[22140] = 0x00088a3e1c3339bfUL;
   tf->codes[22141] = 0x00088a73a2ee7fd1UL;
   tf->codes[22142] = 0x00088a96dcf7f853UL;
   tf->codes[22143] = 0x00088ac33d5a579dUL;
   tf->codes[22144] = 0x00088afb483add26UL;
   tf->codes[22145] = 0x00088afc3276f43aUL;
   tf->codes[22146] = 0x00088b0852132603UL;
   tf->codes[22147] = 0x00088b11034e0141UL;
   tf->codes[22148] = 0x00088b2e1041ddfcUL;
   tf->codes[22149] = 0x00088b2efa7df510UL;
   tf->codes[22150] = 0x00088b5408ff9bbaUL;
   tf->codes[22151] = 0x00088b694ef4b44bUL;
   tf->codes[22152] = 0x00088b6bd319f3c2UL;
   tf->codes[22153] = 0x00088be5f96ffcb0UL;
   tf->codes[22154] = 0x00088be9dcef5ec5UL;
   tf->codes[22155] = 0x00088bfd13dd4369UL;
   tf->codes[22156] = 0x00088c1f9e39aa9cUL;
   tf->codes[22157] = 0x00088c3ad6b5592fUL;
   tf->codes[22158] = 0x00088c48903ab35bUL;
   tf->codes[22159] = 0x00088c53507cc286UL;
   tf->codes[22160] = 0x00088c85a365b7d2UL;
   tf->codes[22161] = 0x00088c8f044da45fUL;
   tf->codes[22162] = 0x00088c9de29e1b64UL;
   tf->codes[22163] = 0x00088ccbdce9a311UL;
   tf->codes[22164] = 0x00088ceedc6415ceUL;
   tf->codes[22165] = 0x00088cf92788196fUL;
   tf->codes[22166] = 0x00088cfea4f0a3e7UL;
   tf->codes[22167] = 0x00088cff549db536UL;
   tf->codes[22168] = 0x00088d08b585a1c3UL;
   tf->codes[22169] = 0x00088d64e4abb6e2UL;
   tf->codes[22170] = 0x00088d69ecf635d0UL;
   tf->codes[22171] = 0x00088d797af3be24UL;
   tf->codes[22172] = 0x00088d864a3d013cUL;
   tf->codes[22173] = 0x00088d99f648f16aUL;
   tf->codes[22174] = 0x00088dc98a7da17aUL;
   tf->codes[22175] = 0x00088dd0dc5e5a1aUL;
   tf->codes[22176] = 0x00088de95625c371UL;
   tf->codes[22177] = 0x00088def48ac5973UL;
   tf->codes[22178] = 0x00088e6bb8989c13UL;
   tf->codes[22179] = 0x00088eabff95f150UL;
   tf->codes[22180] = 0x00088eda34707ec2UL;
   tf->codes[22181] = 0x00088f1204c1fe86UL;
   tf->codes[22182] = 0x00088f1488e73dfdUL;
   tf->codes[22183] = 0x00088f4c93c7c386UL;
   tf->codes[22184] = 0x00088f55f4afb013UL;
   tf->codes[22185] = 0x00088f67cc437219UL;
   tf->codes[22186] = 0x00088f6d843b0256UL;
   tf->codes[22187] = 0x00088f813046f284UL;
   tf->codes[22188] = 0x00088f9ca351a6dcUL;
   tf->codes[22189] = 0x00088fb5ccc62182UL;
   tf->codes[22190] = 0x00088fd7e2047d2bUL;
   tf->codes[22191] = 0x00088ff2dff125f9UL;
   tf->codes[22192] = 0x00088fff3a1c5d87UL;
   tf->codes[22193] = 0x00089012367b3c66UL;
   tf->codes[22194] = 0x00089012ab9947f0UL;
   tf->codes[22195] = 0x0008902ab042a5bdUL;
   tf->codes[22196] = 0x0008904f49a640ddUL;
   tf->codes[22197] = 0x00089080ece224daUL;
   tf->codes[22198] = 0x0008909b0092b694UL;
   tf->codes[22199] = 0x000890b96ce0b5edUL;
   tf->codes[22200] = 0x000890d93888d7e4UL;
   tf->codes[22201] = 0x000890dbf73d1d20UL;
   tf->codes[22202] = 0x000890fbc2e53f17UL;
   tf->codes[22203] = 0x0008910732d45f91UL;
   tf->codes[22204] = 0x0008911526e8bf82UL;
   tf->codes[22205] = 0x0008913bcf538e8fUL;
   tf->codes[22206] = 0x0008916954810ab2UL;
   tf->codes[22207] = 0x0008916b63883e9fUL;
   tf->codes[22208] = 0x000891c792ae53beUL;
   tf->codes[22209] = 0x000891c7cd3d5983UL;
   tf->codes[22210] = 0x000891ca16d39335UL;
   tf->codes[22211] = 0x000891d5fbe0bf39UL;
   tf->codes[22212] = 0x000891de37fd8eedUL;
   tf->codes[22213] = 0x00089203f62c46e6UL;
   tf->codes[22214] = 0x00089205caa4750eUL;
   tf->codes[22215] = 0x0008924aa4ce3dafUL;
   tf->codes[22216] = 0x0008924fe7a7c262UL;
   tf->codes[22217] = 0x000892505cc5cdecUL;
   tf->codes[22218] = 0x0008925a32cbc603UL;
   tf->codes[22219] = 0x000892626ee895b7UL;
   tf->codes[22220] = 0x000892c19751f5d7UL;
   tf->codes[22221] = 0x000892c74f498614UL;
   tf->codes[22222] = 0x000892d284a9a0c9UL;
   tf->codes[22223] = 0x000892d493b0d4b6UL;
   tf->codes[22224] = 0x000892d717d6142dUL;
   tf->codes[22225] = 0x0008934fded1fa7dUL;
   tf->codes[22226] = 0x00089356bb94a793UL;
   tf->codes[22227] = 0x0008935ef7b17747UL;
   tf->codes[22228] = 0x0008937094b63388UL;
   tf->codes[22229] = 0x0008937c04a55402UL;
   tf->codes[22230] = 0x0008937f3877a4c8UL;
   tf->codes[22231] = 0x0008939c0adc7bbeUL;
   tf->codes[22232] = 0x000893cab4d514baUL;
   tf->codes[22233] = 0x000893d9589685faUL;
   tf->codes[22234] = 0x0008940543dad9baUL;
   tf->codes[22235] = 0x0008940f546fd796UL;
   tf->codes[22236] = 0x0008941c23b91aaeUL;
   tf->codes[22237] = 0x0008944fd5fc3298UL;
   tf->codes[22238] = 0x0008949c7724bf63UL;
   tf->codes[22239] = 0x000894e116bf823fUL;
   tf->codes[22240] = 0x000894e44a91d305UL;
   tf->codes[22241] = 0x000894fd397747e6UL;
   tf->codes[22242] = 0x000894fdae955370UL;
   tf->codes[22243] = 0x0008952abea4c409UL;
   tf->codes[22244] = 0x00089538782a1e35UL;
   tf->codes[22245] = 0x0008954b39f9f74fUL;
   tf->codes[22246] = 0x0008954c5ec51428UL;
   tf->codes[22247] = 0x00089551670f9316UL;
   tf->codes[22248] = 0x0008956eae927596UL;
   tf->codes[22249] = 0x00089571a7d5c097UL;
   tf->codes[22250] = 0x0008958e3fab91c8UL;
   tf->codes[22251] = 0x0008959c6e4ef77eUL;
   tf->codes[22252] = 0x000895fd30a18001UL;
   tf->codes[22253] = 0x0008960de36a252eUL;
   tf->codes[22254] = 0x0008961fbafde734UL;
   tf->codes[22255] = 0x0008969a1be2f5e7UL;
   tf->codes[22256] = 0x000896d978a43410UL;
   tf->codes[22257] = 0x000897857cc526c0UL;
   tf->codes[22258] = 0x0008978a4a809fe9UL;
   tf->codes[22259] = 0x000897ee7b347ef7UL;
   tf->codes[22260] = 0x00089809ee3f334fUL;
   tf->codes[22261] = 0x000898117aaef1b4UL;
   tf->codes[22262] = 0x0008986d34b6fb49UL;
   tf->codes[22263] = 0x000898aea07f6d5fUL;
   tf->codes[22264] = 0x0008996cb6c327daUL;
   tf->codes[22265] = 0x0008996d2be13364UL;
   tf->codes[22266] = 0x000899cbdf2c87faUL;
   tf->codes[22267] = 0x000899f3e6f179a5UL;
   tf->codes[22268] = 0x000899fdbcf771bcUL;
   tf->codes[22269] = 0x00089a4012fbfae6UL;
   tf->codes[22270] = 0x00089a41ace52349UL;
   tf->codes[22271] = 0x00089a559380193cUL;
   tf->codes[22272] = 0x00089a5852345e78UL;
   tf->codes[22273] = 0x00089a5fdea41cddUL;
   tf->codes[22274] = 0x00089a9ec6474f7cUL;
   tf->codes[22275] = 0x00089ab989a4f285UL;
   tf->codes[22276] = 0x00089ac917a27ad9UL;
   tf->codes[22277] = 0x00089ad2b3196d2bUL;
   tf->codes[22278] = 0x00089afbdfa97bafUL;
   tf->codes[22279] = 0x00089b08aef2bec7UL;
   tf->codes[22280] = 0x00089b5883ed9c58UL;
   tf->codes[22281] = 0x00089b6b804c7b37UL;
   tf->codes[22282] = 0x00089b85596e072cUL;
   tf->codes[22283] = 0x00089b8768753b19UL;
   tf->codes[22284] = 0x00089b8b8683a2f3UL;
   tf->codes[22285] = 0x00089b913e7b3330UL;
   tf->codes[22286] = 0x00089bc0d2afe340UL;
   tf->codes[22287] = 0x00089bfc8680c519UL;
   tf->codes[22288] = 0x00089bfd362dd668UL;
   tf->codes[22289] = 0x00089c08e0abfca7UL;
   tf->codes[22290] = 0x00089c7463409455UL;
   tf->codes[22291] = 0x00089c84db7a33bdUL;
   tf->codes[22292] = 0x00089c9344ac9f38UL;
   tf->codes[22293] = 0x00089cd4b075114eUL;
   tf->codes[22294] = 0x00089d0653b0f54bUL;
   tf->codes[22295] = 0x00089d6abef3da1eUL;
   tf->codes[22296] = 0x00089d7a12625cadUL;
   tf->codes[22297] = 0x00089d7d80c3b338UL;
   tf->codes[22298] = 0x00089d9c622fbe1bUL;
   tf->codes[22299] = 0x00089d9d86fadaf4UL;
   tf->codes[22300] = 0x00089e126a775f2fUL;
   tf->codes[22301] = 0x00089e168885c709UL;
   tf->codes[22302] = 0x00089e2cb8b6f6aeUL;
   tf->codes[22303] = 0x00089e5c125ca0f9UL;
   tf->codes[22304] = 0x00089e8120de47a3UL;
   tf->codes[22305] = 0x00089f51be62d573UL;
   tf->codes[22306] = 0x00089f5b9468cd8aUL;
   tf->codes[22307] = 0x00089f709fcee056UL;
   tf->codes[22308] = 0x00089f82b1f1a821UL;
   tf->codes[22309] = 0x00089f844bdad084UL;
   tf->codes[22310] = 0x00089f898eb45537UL;
   tf->codes[22311] = 0x00089f96988c9e14UL;
   tf->codes[22312] = 0x00089f98e222d7c6UL;
   tf->codes[22313] = 0x0008a005fea097d7UL;
   tf->codes[22314] = 0x0008a01eb2f706f3UL;
   tf->codes[22315] = 0x0008a0397654a9fcUL;
   tf->codes[22316] = 0x0008a0493ee13815UL;
   tf->codes[22317] = 0x0008a059076dc62eUL;
   tf->codes[22318] = 0x0008a063c7afd559UL;
   tf->codes[22319] = 0x0008a07c7c064475UL;
   tf->codes[22320] = 0x0008a0956aebb956UL;
   tf->codes[22321] = 0x0008a0ad6f951723UL;
   tf->codes[22322] = 0x0008a0b18da37efdUL;
   tf->codes[22323] = 0x0008a0c6d398978eUL;
   tf->codes[22324] = 0x0008a0daf4c29346UL;
   tf->codes[22325] = 0x0008a0e8e8d6f337UL;
   tf->codes[22326] = 0x0008a141a99bb1cbUL;
   tf->codes[22327] = 0x0008a166f2ac5e3aUL;
   tf->codes[22328] = 0x0008a19c3ed89e87UL;
   tf->codes[22329] = 0x0008a1bd69dae31cUL;
   tf->codes[22330] = 0x0008a1c4f64aa181UL;
   tf->codes[22331] = 0x0008a1c77a6fe0f8UL;
   tf->codes[22332] = 0x0008a1d2ea5f0172UL;
   tf->codes[22333] = 0x0008a1eff752de2dUL;
   tf->codes[22334] = 0x0008a1f70ea49108UL;
   tf->codes[22335] = 0x0008a21c57b53d77UL;
   tf->codes[22336] = 0x0008a235bbb8bde2UL;
   tf->codes[22337] = 0x0008a23c987b6af8UL;
   tf->codes[22338] = 0x0008a2445f7a2f22UL;
   tf->codes[22339] = 0x0008a2580b861f50UL;
   tf->codes[22340] = 0x0008a28a98fe1a61UL;
   tf->codes[22341] = 0x0008a2cb1a8a7563UL;
   tf->codes[22342] = 0x0008a2d5a03d7ec9UL;
   tf->codes[22343] = 0x0008a2f09e2a2797UL;
   tf->codes[22344] = 0x0008a2fa74301faeUL;
   tf->codes[22345] = 0x0008a317bbb3022eUL;
   tf->codes[22346] = 0x0008a398843cb26dUL;
   tf->codes[22347] = 0x0008a39f267059beUL;
   tf->codes[22348] = 0x0008a3bfdc5492c9UL;
   tf->codes[22349] = 0x0008a3dfa7fcb4c0UL;
   tf->codes[22350] = 0x0008a3f403b5b63dUL;
   tf->codes[22351] = 0x0008a3f737880703UL;
   tf->codes[22352] = 0x0008a4457299bc31UL;
   tf->codes[22353] = 0x0008a45b683be611UL;
   tf->codes[22354] = 0x0008a46f4ed6dc04UL;
   tf->codes[22355] = 0x0008a4775064a5f3UL;
   tf->codes[22356] = 0x0008a4980648defeUL;
   tf->codes[22357] = 0x0008a49dbe406f3bUL;
   tf->codes[22358] = 0x0008a4cca2c80dfcUL;
   tf->codes[22359] = 0x0008a4ddcaaebeb3UL;
   tf->codes[22360] = 0x0008a4e382a64ef0UL;
   tf->codes[22361] = 0x0008a4e7a0b4b6caUL;
   tf->codes[22362] = 0x0008a5cb3a982379UL;
   tf->codes[22363] = 0x0008a5e045fe3645UL;
   tf->codes[22364] = 0x0008a6030ae9a33dUL;
   tf->codes[22365] = 0x0008a63f33d890a0UL;
   tf->codes[22366] = 0x0008a64dd79a01e0UL;
   tf->codes[22367] = 0x0008a674ba93d6b2UL;
   tf->codes[22368] = 0x0008a69f467e07d4UL;
   tf->codes[22369] = 0x0008a6e7547a213bUL;
   tf->codes[22370] = 0x0008a6f19f9e24dcUL;
   tf->codes[22371] = 0x0008a74d94353436UL;
   tf->codes[22372] = 0x0008a74f2e1e5c99UL;
   tf->codes[22373] = 0x0008a7567fff1539UL;
   tf->codes[22374] = 0x0008a794b7f53689UL;
   tf->codes[22375] = 0x0008a7eba441c6f5UL;
   tf->codes[22376] = 0x0008a7f66483d620UL;
   tf->codes[22377] = 0x0008a812fc59a751UL;
   tf->codes[22378] = 0x0008a85d8e7b002fUL;
   tf->codes[22379] = 0x0008a87fa3b95bd8UL;
   tf->codes[22380] = 0x0008a88d97cdbbc9UL;
   tf->codes[22381] = 0x0008a8976dd3b3e0UL;
   tf->codes[22382] = 0x0008a89ceb3c3e58UL;
   tf->codes[22383] = 0x0008a8d9fe6742cfUL;
   tf->codes[22384] = 0x0008a8eb9b6bff10UL;
   tf->codes[22385] = 0x0008a949647b3c92UL;
   tf->codes[22386] = 0x0008a94be8a07c09UL;
   tf->codes[22387] = 0x0008a94cd2dc931dUL;
   tf->codes[22388] = 0x0008a964d785f0eaUL;
   tf->codes[22389] = 0x0008a9780e73d58eUL;
   tf->codes[22390] = 0x0008a9821f08d36aUL;
   tf->codes[22391] = 0x0008a993bc0d8fabUL;
   tf->codes[22392] = 0x0008a998c4580e99UL;
   tf->codes[22393] = 0x0008a9d1f403b0fbUL;
   tf->codes[22394] = 0x0008a9dd9e81d73aUL;
   tf->codes[22395] = 0x0008a9ecb7615404UL;
   tf->codes[22396] = 0x0008aa06cb11e5beUL;
   tf->codes[22397] = 0x0008aa16939e73d7UL;
   tf->codes[22398] = 0x0008aa47872d4685UL;
   tf->codes[22399] = 0x0008aa68028279cbUL;
   tf->codes[22400] = 0x0008aa7128db6093UL;
   tf->codes[22401] = 0x0008aa787abc1933UL;
   tf->codes[22402] = 0x0008aa96ac7b12c7UL;
   tf->codes[22403] = 0x0008aa9bef54977aUL;
   tf->codes[22404] = 0x0008aaefe25ddce5UL;
   tf->codes[22405] = 0x0008ab1615aaa068UL;
   tf->codes[22406] = 0x0008ab6207261be4UL;
   tf->codes[22407] = 0x0008ab77c2393fffUL;
   tf->codes[22408] = 0x0008ab98b2ac7ecfUL;
   tf->codes[22409] = 0x0008abdbb85e1948UL;
   tf->codes[22410] = 0x0008abf6b64ac216UL;
   tf->codes[22411] = 0x0008ac0c36cee06cUL;
   tf->codes[22412] = 0x0008ac1e0e62a272UL;
   tf->codes[22413] = 0x0008ac45667a82ceUL;
   tf->codes[22414] = 0x0008ac4b1e72130bUL;
   tf->codes[22415] = 0x0008ac5e8feefd74UL;
   tf->codes[22416] = 0x0008ac661c5ebbd9UL;
   tf->codes[22417] = 0x0008ac94c65754d5UL;
   tf->codes[22418] = 0x0008acc57f5721beUL;
   tf->codes[22419] = 0x0008ace8f3efa005UL;
   tf->codes[22420] = 0x0008acfa56655681UL;
   tf->codes[22421] = 0x0008ad037cbe3d49UL;
   tf->codes[22422] = 0x0008ad6dda87b81eUL;
   tf->codes[22423] = 0x0008ad8d6ba0d450UL;
   tf->codes[22424] = 0x0008ad977c35d22cUL;
   tf->codes[22425] = 0x0008ad9ff2e1a7a5UL;
   tf->codes[22426] = 0x0008adc9948fc1b3UL;
   tf->codes[22427] = 0x0008ae06a7bac62aUL;
   tf->codes[22428] = 0x0008ae192efb997fUL;
   tf->codes[22429] = 0x0008ae1b7891d331UL;
   tf->codes[22430] = 0x0008ae3f9cd762c7UL;
   tf->codes[22431] = 0x0008ae4bbc739490UL;
   tf->codes[22432] = 0x0008ae781cd5f3daUL;
   tf->codes[22433] = 0x0008ae9529c9d095UL;
   tf->codes[22434] = 0x0008af069ee4fe45UL;
   tf->codes[22435] = 0x0008af500c3b3a4aUL;
   tf->codes[22436] = 0x0008af56ae6ee19bUL;
   tf->codes[22437] = 0x0008af7f2b51ded0UL;
   tf->codes[22438] = 0x0008af9a63cd8d63UL;
   tf->codes[22439] = 0x0008afcc41987725UL;
   tf->codes[22440] = 0x0008b0115651458bUL;
   tf->codes[22441] = 0x0008b048ec13bf8aUL;
   tf->codes[22442] = 0x0008b0571ab72540UL;
   tf->codes[22443] = 0x0008b0599edc64b7UL;
   tf->codes[22444] = 0x0008b08f9ab5b653UL;
   tf->codes[22445] = 0x0008b0cfa72405cbUL;
   tf->codes[22446] = 0x0008b0dcb0fc4ea8UL;
   tf->codes[22447] = 0x0008b1094bedb3b7UL;
   tf->codes[22448] = 0x0008b149585c032fUL;
   tf->codes[22449] = 0x0008b15836ac7a34UL;
   tf->codes[22450] = 0x0008b169d3b13675UL;
   tf->codes[22451] = 0x0008b1966ea29b84UL;
   tf->codes[22452] = 0x0008b2076e9fbdaaUL;
   tf->codes[22453] = 0x0008b23e54b5265aUL;
   tf->codes[22454] = 0x0008b24e925fbffdUL;
   tf->codes[22455] = 0x0008b25b2719fd50UL;
   tf->codes[22456] = 0x0008b2732bc35b1dUL;
   tf->codes[22457] = 0x0008b2815a66c0d3UL;
   tf->codes[22458] = 0x0008b293a7188e63UL;
   tf->codes[22459] = 0x0008b2d0f4d2989fUL;
   tf->codes[22460] = 0x0008b2d28ebbc102UL;
   tf->codes[22461] = 0x0008b2deae57f2cbUL;
   tf->codes[22462] = 0x0008b315946d5b7bUL;
   tf->codes[22463] = 0x0008b319b27bc355UL;
   tf->codes[22464] = 0x0008b34d64bedb3fUL;
   tf->codes[22465] = 0x0008b36de0140e85UL;
   tf->codes[22466] = 0x0008b39c4f7da1bcUL;
   tf->codes[22467] = 0x0008b433f7e592efUL;
   tf->codes[22468] = 0x0008b44ebb4335f8UL;
   tf->codes[22469] = 0x0008b45313e0a397UL;
   tf->codes[22470] = 0x0008b45dd422b2c2UL;
   tf->codes[22471] = 0x0008b476887921deUL;
   tf->codes[22472] = 0x0008b48984d800bdUL;
   tf->codes[22473] = 0x0008b48b93df34aaUL;
   tf->codes[22474] = 0x0008b49270a1e1c0UL;
   tf->codes[22475] = 0x0008b49cbbc5e561UL;
   tf->codes[22476] = 0x0008b4c7823f1c48UL;
   tf->codes[22477] = 0x0008b4ce2472c399UL;
   tf->codes[22478] = 0x0008b4f1d39a47a5UL;
   tf->codes[22479] = 0x0008b4fbe42f4581UL;
   tf->codes[22480] = 0x0008b5458c14874bUL;
   tf->codes[22481] = 0x0008b552d07bd5edUL;
   tf->codes[22482] = 0x0008b564e29e9db8UL;
   tf->codes[22483] = 0x0008b59b5395fadeUL;
   tf->codes[22484] = 0x0008b5cda67ef02aUL;
   tf->codes[22485] = 0x0008b5eb2890d86fUL;
   tf->codes[22486] = 0x0008b5f1cac47fc0UL;
   tf->codes[22487] = 0x0008b65c9dac061fUL;
   tf->codes[22488] = 0x0008b68a97f78dccUL;
   tf->codes[22489] = 0x0008b69caa1a5597UL;
   tf->codes[22490] = 0x0008b6f2e6b9d4b4UL;
   tf->codes[22491] = 0x0008b6f9c37c81caUL;
   tf->codes[22492] = 0x0008b6fa73299319UL;
   tf->codes[22493] = 0x0008b712b261f6abUL;
   tf->codes[22494] = 0x0008b716d0705e85UL;
   tf->codes[22495] = 0x0008b717baac7599UL;
   tf->codes[22496] = 0x0008b74a82b3766fUL;
   tf->codes[22497] = 0x0008b755f2a296e9UL;
   tf->codes[22498] = 0x0008b76580a01f3dUL;
   tf->codes[22499] = 0x0008b77f1f32a56dUL;
   tf->codes[22500] = 0x0008b7954f63d512UL;
   tf->codes[22501] = 0x0008b79b7c7970d9UL;
   tf->codes[22502] = 0x0008b7a6b1d98b8eUL;
   tf->codes[22503] = 0x0008b7b430cfdff5UL;
   tf->codes[22504] = 0x0008b7c8c717e737UL;
   tf->codes[22505] = 0x0008b85156a05ba0UL;
   tf->codes[22506] = 0x0008b8544fe3a6a1UL;
   tf->codes[22507] = 0x0008b890b36199c9UL;
   tf->codes[22508] = 0x0008b8e0fd7a82e4UL;
   tf->codes[22509] = 0x0008b8f51ea47e9cUL;
   tf->codes[22510] = 0x0008b945a34c6d7cUL;
   tf->codes[22511] = 0x0008b967436cbd9bUL;
   tf->codes[22512] = 0x0008b983db428eccUL;
   tf->codes[22513] = 0x0008b990356dc65aUL;
   tf->codes[22514] = 0x0008b993de5e22aaUL;
   tf->codes[22515] = 0x0008b9ccd37abf47UL;
   tf->codes[22516] = 0x0008b9df5abb929cUL;
   tf->codes[22517] = 0x0008ba13bcabbbd5UL;
   tf->codes[22518] = 0x0008ba41b6f74382UL;
   tf->codes[22519] = 0x0008ba44b03a8e83UL;
   tf->codes[22520] = 0x0008ba459a76a597UL;
   tf->codes[22521] = 0x0008ba8f07cce19cUL;
   tf->codes[22522] = 0x0008ba96cecba5c6UL;
   tf->codes[22523] = 0x0008ba9b27691365UL;
   tf->codes[22524] = 0x0008ba9c86c33603UL;
   tf->codes[22525] = 0x0008bacf4eca36d9UL;
   tf->codes[22526] = 0x0008baee6ac54781UL;
   tf->codes[22527] = 0x0008baf19e979847UL;
   tf->codes[22528] = 0x0008bb1dc46af1ccUL;
   tf->codes[22529] = 0x0008bbd86c4d55bcUL;
   tf->codes[22530] = 0x0008bc02f83786deUL;
   tf->codes[22531] = 0x0008bc0d08cc84baUL;
   tf->codes[22532] = 0x0008bc41dfdab97dUL;
   tf->codes[22533] = 0x0008bc54dc39985cUL;
   tf->codes[22534] = 0x0008bcea3b0b4fddUL;
   tf->codes[22535] = 0x0008bd17108bbab1UL;
   tf->codes[22536] = 0x0008bd40028cc370UL;
   tf->codes[22537] = 0x0008bd4ee0dd3a75UL;
   tf->codes[22538] = 0x0008bd754eb903bdUL;
   tf->codes[22539] = 0x0008bdc7e268268aUL;
   tf->codes[22540] = 0x0008bdd352574704UL;
   tf->codes[22541] = 0x0008bde230a7be09UL;
   tf->codes[22542] = 0x0008be4a0a4bf967UL;
   tf->codes[22543] = 0x0008be5c56fdc6f7UL;
   tf->codes[22544] = 0x0008be666792c4d3UL;
   tf->codes[22545] = 0x0008be6c5a195ad5UL;
   tf->codes[22546] = 0x0008be6c94a8609aUL;
   tf->codes[22547] = 0x0008be992f99c5a9UL;
   tf->codes[22548] = 0x0008bedfa3acb6adUL;
   tf->codes[22549] = 0x0008bf0a2f96e7cfUL;
   tf->codes[22550] = 0x0008bf0d28da32d0UL;
   tf->codes[22551] = 0x0008bf39c3cb97dfUL;
   tf->codes[22552] = 0x0008bf64ff62da50UL;
   tf->codes[22553] = 0x0008bf6b67077bdcUL;
   tf->codes[22554] = 0x0008bf7e63665abbUL;
   tf->codes[22555] = 0x0008bf936ecc6d87UL;
   tf->codes[22556] = 0x0008bf9801f8e0ebUL;
   tf->codes[22557] = 0x0008bfca8f70dbfcUL;
   tf->codes[22558] = 0x0008bfcd13961b73UL;
   tf->codes[22559] = 0x0008bfd5c4d0f6b1UL;
   tf->codes[22560] = 0x0008bfd883853bedUL;
   tf->codes[22561] = 0x0008bffe0724ee21UL;
   tf->codes[22562] = 0x0008c003bf1c7e5eUL;
   tf->codes[22563] = 0x0008c056183c9b66UL;
   tf->codes[22564] = 0x0008c079c7641f72UL;
   tf->codes[22565] = 0x0008c091cc0d7d3fUL;
   tf->codes[22566] = 0x0008c0d3acf3fadfUL;
   tf->codes[22567] = 0x0008c0e21626665aUL;
   tf->codes[22568] = 0x0008c0f28e6005c2UL;
   tf->codes[22569] = 0x0008c0fc6465fdd9UL;
   tf->codes[22570] = 0x0008c107d4551e53UL;
   tf->codes[22571] = 0x0008c1080ee42418UL;
   tf->codes[22572] = 0x0008c11727c3a0e2UL;
   tf->codes[22573] = 0x0008c11f9e6f765bUL;
   tf->codes[22574] = 0x0008c17356e9b601UL;
   tf->codes[22575] = 0x0008c17983ff51c8UL;
   tf->codes[22576] = 0x0008c17a33ac6317UL;
   tf->codes[22577] = 0x0008c183cf235569UL;
   tf->codes[22578] = 0x0008c1ca4336466dUL;
   tf->codes[22579] = 0x0008c1d3a41e32faUL;
   tf->codes[22580] = 0x0008c1dabb6fe5d5UL;
   tf->codes[22581] = 0x0008c20790f050a9UL;
   tf->codes[22582] = 0x0008c20df894f235UL;
   tf->codes[22583] = 0x0008c21843b8f5d6UL;
   tf->codes[22584] = 0x0008c25a249f7376UL;
   tf->codes[22585] = 0x0008c272d8f5e292UL;
   tf->codes[22586] = 0x0008c2897e451dc1UL;
   tf->codes[22587] = 0x0008c28a688134d5UL;
   tf->codes[22588] = 0x0008c2959de14f8aUL;
   tf->codes[22589] = 0x0008c2ca74ef844dUL;
   tf->codes[22590] = 0x0008c2cbd449a6ebUL;
   tf->codes[22591] = 0x0008c2cde350dad8UL;
   tf->codes[22592] = 0x0008c2e572dc2d1bUL;
   tf->codes[22593] = 0x0008c2f5b086c6beUL;
   tf->codes[22594] = 0x0008c37d1b441e4eUL;
   tf->codes[22595] = 0x0008c3967f479eb9UL;
   tf->codes[22596] = 0x0008c3ce4f991e7dUL;
   tf->codes[22597] = 0x0008c3d10e4d63b9UL;
   tf->codes[22598] = 0x0008c3e52f775f71UL;
   tf->codes[22599] = 0x0008c411554ab8f6UL;
   tf->codes[22600] = 0x0008c41c8aaad3abUL;
   tf->codes[22601] = 0x0008c4578ecea435UL;
   tf->codes[22602] = 0x0008c48e3a550720UL;
   tf->codes[22603] = 0x0008c4bfdd90eb1dUL;
   tf->codes[22604] = 0x0008c4c903e9d1e5UL;
   tf->codes[22605] = 0x0008c4c93e78d7aaUL;
   tf->codes[22606] = 0x0008c4d1efb3b2e8UL;
   tf->codes[22607] = 0x0008c4f9bce99eceUL;
   tf->codes[22608] = 0x0008c5135b7c24feUL;
   tf->codes[22609] = 0x0008c54364cee098UL;
   tf->codes[22610] = 0x0008c554179785c5UL;
   tf->codes[22611] = 0x0008c55d036166c8UL;
   tf->codes[22612] = 0x0008c563e02413deUL;
   tf->codes[22613] = 0x0008c596e2ba1a79UL;
   tf->codes[22614] = 0x0008c5bfd4bb2338UL;
   tf->codes[22615] = 0x0008c5ceed9aa002UL;
   tf->codes[22616] = 0x0008c5d6b499642cUL;
   tf->codes[22617] = 0x0008c5e2248884a6UL;
   tf->codes[22618] = 0x0008c5f177f70735UL;
   tf->codes[22619] = 0x0008c64d6c8e168fUL;
   tf->codes[22620] = 0x0008c652af679b42UL;
   tf->codes[22621] = 0x0008c655a8aae643UL;
   tf->codes[22622] = 0x0008c66aee9ffed4UL;
   tf->codes[22623] = 0x0008c66e97905b24UL;
   tf->codes[22624] = 0x0008c67a7c9d8728UL;
   tf->codes[22625] = 0x0008c6e49fd7fc38UL;
   tf->codes[22626] = 0x0008c6fa5aeb2053UL;
   tf->codes[22627] = 0x0008c75e1680f3d7UL;
   tf->codes[22628] = 0x0008c78e5a62b536UL;
   tf->codes[22629] = 0x0008c7cba81cbf72UL;
   tf->codes[22630] = 0x0008c7d4ce75a63aUL;
   tf->codes[22631] = 0x0008c7fcd63a97e5UL;
   tf->codes[22632] = 0x0008c813066bc78aUL;
   tf->codes[22633] = 0x0008c84593e3c29bUL;
   tf->codes[22634] = 0x0008c8493cd41eebUL;
   tf->codes[22635] = 0x0008c85437a533dbUL;
   tf->codes[22636] = 0x0008c870cf7b050cUL;
   tf->codes[22637] = 0x0008c88aa89c9101UL;
   tf->codes[22638] = 0x0008c8b5e433d372UL;
   tf->codes[22639] = 0x0008c8b7f33b075fUL;
   tf->codes[22640] = 0x0008c8d9935b577eUL;
   tf->codes[22641] = 0x0008c8dd76dab993UL;
   tf->codes[22642] = 0x0008c8e7876fb76fUL;
   tf->codes[22643] = 0x0008c8f038aa92adUL;
   tf->codes[22644] = 0x0008c8ffc6a81b01UL;
   tf->codes[22645] = 0x0008c95294e64393UL;
   tf->codes[22646] = 0x0008c99400aeb5a9UL;
   tf->codes[22647] = 0x0008c9a9bbc1d9c4UL;
   tf->codes[22648] = 0x0008c9bc7d91b2deUL;
   tf->codes[22649] = 0x0008c9fff86158e1UL;
   tf->codes[22650] = 0x0008ca779a922258UL;
   tf->codes[22651] = 0x0008cabfa88e3bbfUL;
   tf->codes[22652] = 0x0008cac4eb67c072UL;
   tf->codes[22653] = 0x0008cac7aa1c05aeUL;
   tf->codes[22654] = 0x0008cad020c7db27UL;
   tf->codes[22655] = 0x0008caec08f09b09UL;
   tf->codes[22656] = 0x0008caf14bca1fbcUL;
   tf->codes[22657] = 0x0008caf5def69320UL;
   tf->codes[22658] = 0x0008cb0d33f2df9eUL;
   tf->codes[22659] = 0x0008cb7a8affa574UL;
   tf->codes[22660] = 0x0008cb83ebe79201UL;
   tf->codes[22661] = 0x0008cb9a1c18c1a6UL;
   tf->codes[22662] = 0x0008cbf0cdd64c4dUL;
   tf->codes[22663] = 0x0008cc5a7bf2b5d3UL;
   tf->codes[22664] = 0x0008cc5e24e31223UL;
   tf->codes[22665] = 0x0008cc6db2e09a77UL;
   tf->codes[22666] = 0x0008cc71965ffc8cUL;
   tf->codes[22667] = 0x0008cc72bb2b1965UL;
   tf->codes[22668] = 0x0008cc7d40de22cbUL;
   tf->codes[22669] = 0x0008cc8f1871e4d1UL;
   tf->codes[22670] = 0x0008cccca0baf4d2UL;
   tf->codes[22671] = 0x0008ccf7dc523743UL;
   tf->codes[22672] = 0x0008cd076a4fbf97UL;
   tf->codes[22673] = 0x0008cd1f346a179fUL;
   tf->codes[22674] = 0x0008cd953cb1b8b3UL;
   tf->codes[22675] = 0x0008cdb2bec3a0f8UL;
   tf->codes[22676] = 0x0008cddc6071bb06UL;
   tf->codes[22677] = 0x0008cdf2cb31f070UL;
   tf->codes[22678] = 0x0008ce6aa7f1bfacUL;
   tf->codes[22679] = 0x0008ce969336136cUL;
   tf->codes[22680] = 0x0008cecaba9736e0UL;
   tf->codes[22681] = 0x0008ced1223bd86cUL;
   tf->codes[22682] = 0x0008ced4cb2c34bcUL;
   tf->codes[22683] = 0x0008ced62a86575aUL;
   tf->codes[22684] = 0x0008cf1845fbdabfUL;
   tf->codes[22685] = 0x0008cf43f6b128baUL;
   tf->codes[22686] = 0x0008cf45cb2956e2UL;
   tf->codes[22687] = 0x0008cf62d81d339dUL;
   tf->codes[22688] = 0x0008d014cec4bc4fUL;
   tf->codes[22689] = 0x0008d01c20a574efUL;
   tf->codes[22690] = 0x0008d05cdcc0d5b6UL;
   tf->codes[22691] = 0x0008d06d54fa751eUL;
   tf->codes[22692] = 0x0008d07ce2f7fd72UL;
   tf->codes[22693] = 0x0008d0834a9c9efeUL;
   tf->codes[22694] = 0x0008d0caa8eba716UL;
   tf->codes[22695] = 0x0008d0db96435208UL;
   tf->codes[22696] = 0x0008d10f83156fb7UL;
   tf->codes[22697] = 0x0008d13edcbb1a02UL;
   tf->codes[22698] = 0x0008d14927df1da3UL;
   tf->codes[22699] = 0x0008d14d45ed857dUL;
   tf->codes[22700] = 0x0008d15ee2f241beUL;
   tf->codes[22701] = 0x0008d18c681fbde1UL;
   tf->codes[22702] = 0x0008d19b0be12f21UL;
   tf->codes[22703] = 0x0008d1be45eaa7a3UL;
   tf->codes[22704] = 0x0008d1d4761bd748UL;
   tf->codes[22705] = 0x0008d1d4eb39e2d2UL;
   tf->codes[22706] = 0x0008d1df365de673UL;
   tf->codes[22707] = 0x0008d1e404195f9cUL;
   tf->codes[22708] = 0x0008d1e56373823aUL;
   tf->codes[22709] = 0x0008d1f2a7dad0dcUL;
   tf->codes[22710] = 0x0008d1f85fd26119UL;
   tf->codes[22711] = 0x0008d203cfc18193UL;
   tf->codes[22712] = 0x0008d20987b911d0UL;
   tf->codes[22713] = 0x0008d209c2481795UL;
   tf->codes[22714] = 0x0008d20ae713346eUL;
   tf->codes[22715] = 0x0008d20b5c313ff8UL;
   tf->codes[22716] = 0x0008d2536a2d595fUL;
   tf->codes[22717] = 0x0008d28affefd35eUL;
   tf->codes[22718] = 0x0008d29d8730a6b3UL;
   tf->codes[22719] = 0x0008d2c97274fa73UL;
   tf->codes[22720] = 0x0008d2da5fcca565UL;
   tf->codes[22721] = 0x0008d2ef30a3b26cUL;
   tf->codes[22722] = 0x0008d3d46470477eUL;
   tf->codes[22723] = 0x0008d41f6bafabe6UL;
   tf->codes[22724] = 0x0008d47916b0818eUL;
   tf->codes[22725] = 0x0008d53c6fcdc0bcUL;
   tf->codes[22726] = 0x0008d550cb86c239UL;
   tf->codes[22727] = 0x0008d55d9ad00551UL;
   tf->codes[22728] = 0x0008d55e0fee10dbUL;
   tf->codes[22729] = 0x0008d567ab65032dUL;
   tf->codes[22730] = 0x0008d592ac6d3fd9UL;
   tf->codes[22731] = 0x0008d6437e49abb2UL;
   tf->codes[22732] = 0x0008d64f6356d7b6UL;
   tf->codes[22733] = 0x0008d650c2b0fa54UL;
   tf->codes[22734] = 0x0008d651e77c172dUL;
   tf->codes[22735] = 0x0008d65973ebd592UL;
   tf->codes[22736] = 0x0008d68d60bdf341UL;
   tf->codes[22737] = 0x0008d6fc8c42e73fUL;
   tf->codes[22738] = 0x0008d72c9595a2d9UL;
   tf->codes[22739] = 0x0008d7d2e1bf054cUL;
   tf->codes[22740] = 0x0008d80dab53d011UL;
   tf->codes[22741] = 0x0008d899e3cca0caUL;
   tf->codes[22742] = 0x0008d9147f40b542UL;
   tf->codes[22743] = 0x0008d91828311192UL;
   tf->codes[22744] = 0x0008d919878b3430UL;
   tf->codes[22745] = 0x0008d91f04f3bea8UL;
   tf->codes[22746] = 0x0008d936947f10ebUL;
   tf->codes[22747] = 0x0008d9453840822bUL;
   tf->codes[22748] = 0x0008d96f147da1feUL;
   tf->codes[22749] = 0x0008d98335a79db6UL;
   tf->codes[22750] = 0x0008d99c5f1c185cUL;
   tf->codes[22751] = 0x0008d9c257d9d61aUL;
   tf->codes[22752] = 0x0008da3b93f3c7f4UL;
   tf->codes[22753] = 0x0008da4cf6697e70UL;
   tf->codes[22754] = 0x0008da51feb3fd5eUL;
   tf->codes[22755] = 0x0008da9454b88688UL;
   tf->codes[22756] = 0x0008da99d2211100UL;
   tf->codes[22757] = 0x0008dacf1e4d514dUL;
   tf->codes[22758] = 0x0008dae847c1cbf3UL;
   tf->codes[22759] = 0x0008daed8a9b50a6UL;
   tf->codes[22760] = 0x0008dafe77f2fb98UL;
   tf->codes[22761] = 0x0008db1c6f22ef67UL;
   tf->codes[22762] = 0x0008db5c06733355UL;
   tf->codes[22763] = 0x0008db6aaa34a495UL;
   tf->codes[22764] = 0x0008dc08ba413754UL;
   tf->codes[22765] = 0x0008dc1a5745f395UL;
   tf->codes[22766] = 0x0008dc57df8f0396UL;
   tf->codes[22767] = 0x0008dc5fa68dc7c0UL;
   tf->codes[22768] = 0x0008dc7cb381a47bUL;
   tf->codes[22769] = 0x0008dc8d2bbb43e3UL;
   tf->codes[22770] = 0x0008dc92e3b2d420UL;
   tf->codes[22771] = 0x0008dccfbc4ed2d2UL;
   tf->codes[22772] = 0x0008dcfd06ed4930UL;
   tf->codes[22773] = 0x0008dd663feba72cUL;
   tf->codes[22774] = 0x0008dd7608783545UL;
   tf->codes[22775] = 0x0008ddc56855074cUL;
   tf->codes[22776] = 0x0008ddcd2f53cb76UL;
   tf->codes[22777] = 0x0008ddefb9b032a9UL;
   tf->codes[22778] = 0x0008de1786e61e8fUL;
   tf->codes[22779] = 0x0008de2b32f20ebdUL;
   tf->codes[22780] = 0x0008de6dc3859dacUL;
   tf->codes[22781] = 0x0008de708239e2e8UL;
   tf->codes[22782] = 0x0008de837e98c1c7UL;
   tf->codes[22783] = 0x0008de979fc2bd7fUL;
   tf->codes[22784] = 0x0008dec9f2abb2cbUL;
   tf->codes[22785] = 0x0008dede4e64b448UL;
   tf->codes[22786] = 0x0008deffb3f5fea2UL;
   tf->codes[22787] = 0x0008df035ce65af2UL;
   tf->codes[22788] = 0x0008df0c833f41baUL;
   tf->codes[22789] = 0x0008df123b36d1f7UL;
   tf->codes[22790] = 0x0008df68b26556d9UL;
   tf->codes[22791] = 0x0008dfdb4c4ba162UL;
   tf->codes[22792] = 0x0008e015a0c2609dUL;
   tf->codes[22793] = 0x0008e018d494b163UL;
   tf->codes[22794] = 0x0008e0bf5b4d199bUL;
   tf->codes[22795] = 0x0008e1108fa219caUL;
   tf->codes[22796] = 0x0008e13d2a937ed9UL;
   tf->codes[22797] = 0x0008e1698af5de23UL;
   tf->codes[22798] = 0x0008e195b0c937a8UL;
   tf->codes[22799] = 0x0008e272a878fd06UL;
   tf->codes[22800] = 0x0008e29239921938UL;
   tf->codes[22801] = 0x0008e2ad377ec206UL;
   tf->codes[22802] = 0x0008e2f83ebe266eUL;
   tf->codes[22803] = 0x0008e33d5376f4d4UL;
   tf->codes[22804] = 0x0008e35383a82479UL;
   tf->codes[22805] = 0x0008e3c3244b2401UL;
   tf->codes[22806] = 0x0008e3f4c78707feUL;
   tf->codes[22807] = 0x0008e41b6ff1d70bUL;
   tf->codes[22808] = 0x0008e473467a7e8bUL;
   tf->codes[22809] = 0x0008e47973901a52UL;
   tf->codes[22810] = 0x0008e50de825babfUL;
   tf->codes[22811] = 0x0008e565beae623fUL;
   tf->codes[22812] = 0x0008e5754cabea93UL;
   tf->codes[22813] = 0x0008e5904a989361UL;
   tf->codes[22814] = 0x0008e59bba87b3dbUL;
   tf->codes[22815] = 0x0008e5d43a8644eeUL;
   tf->codes[22816] = 0x0008e5d60efe7316UL;
   tf->codes[22817] = 0x0008e5f615359ad2UL;
   tf->codes[22818] = 0x0008e61063753251UL;
   tf->codes[22819] = 0x0008e66d07b952faUL;
   tf->codes[22820] = 0x0008e69d4b9b1459UL;
   tf->codes[22821] = 0x0008e6e1eb35d735UL;
   tf->codes[22822] = 0x0008e70b5254eb7eUL;
   tf->codes[22823] = 0x0008e7518bd8d6bdUL;
   tf->codes[22824] = 0x0008e76c89c57f8bUL;
   tf->codes[22825] = 0x0008e76f4879c4c7UL;
   tf->codes[22826] = 0x0008e79f8c5b8626UL;
   tf->codes[22827] = 0x0008e89c8a427340UL;
   tf->codes[22828] = 0x0008e8c0ae8802d6UL;
   tf->codes[22829] = 0x0008e8d1d66eb38dUL;
   tf->codes[22830] = 0x0008e8f71f7f5ffcUL;
   tf->codes[22831] = 0x0008e96909b89936UL;
   tf->codes[22832] = 0x0008e96efc3f2f38UL;
   tf->codes[22833] = 0x0008e982e2da252bUL;
   tf->codes[22834] = 0x0008e9889ad1b568UL;
   tf->codes[22835] = 0x0008e9af7dcb8a3aUL;
   tf->codes[22836] = 0x0008e9ce5f37951dUL;
   tf->codes[22837] = 0x0008e9d5eba75382UL;
   tf->codes[22838] = 0x0008e9dd02f9065dUL;
   tf->codes[22839] = 0x0008e9e7c33b1588UL;
   tf->codes[22840] = 0x0008ea2b3e0abb8bUL;
   tf->codes[22841] = 0x0008ea5938564338UL;
   tf->codes[22842] = 0x0008ea5c6c2893feUL;
   tf->codes[22843] = 0x0008ea5e7b2fc7ebUL;
   tf->codes[22844] = 0x0008ea5ef04dd375UL;
   tf->codes[22845] = 0x0008ea70c7e1957bUL;
   tf->codes[22846] = 0x0008ea8b50b032bfUL;
   tf->codes[22847] = 0x0008ead5a84285d8UL;
   tf->codes[22848] = 0x0008eb1af78a5a03UL;
   tf->codes[22849] = 0x0008eb487cb7d626UL;
   tf->codes[22850] = 0x0008eb65148da757UL;
   tf->codes[22851] = 0x0008eb89adf14277UL;
   tf->codes[22852] = 0x0008eb8d56e19ec7UL;
   tf->codes[22853] = 0x0008eba4e66cf10aUL;
   tf->codes[22854] = 0x0008ebc9f4ee97b4UL;
   tf->codes[22855] = 0x0008ec0708199c2bUL;
   tf->codes[22856] = 0x0008ec541e603480UL;
   tf->codes[22857] = 0x0008ec7d4af04304UL;
   tf->codes[22858] = 0x0008ec8b3f04a2f5UL;
   tf->codes[22859] = 0x0008ec98f889fd21UL;
   tf->codes[22860] = 0x0008ec9f259f98e8UL;
   tf->codes[22861] = 0x0008ed0c7cac5ebeUL;
   tf->codes[22862] = 0x0008ed10d549cc5dUL;
   tf->codes[22863] = 0x0008ed77ff40f66cUL;
   tf->codes[22864] = 0x0008ed8543a8450eUL;
   tf->codes[22865] = 0x0008ed9f5758d6c8UL;
   tf->codes[22866] = 0x0008edc93395f69bUL;
   tf->codes[22867] = 0x0008edcbf24a3bd7UL;
   tf->codes[22868] = 0x0008edfbfb9cf771UL;
   tf->codes[22869] = 0x0008edfc70bb02fbUL;
   tf->codes[22870] = 0x0008ee122bce2716UL;
   tf->codes[22871] = 0x0008ee7746be1d38UL;
   tf->codes[22872] = 0x0008eff87b90111cUL;
   tf->codes[22873] = 0x0008f01acb5d728aUL;
   tf->codes[22874] = 0x0008f03ca60cc86eUL;
   tf->codes[22875] = 0x0008f06fa8a2cf09UL;
   tf->codes[22876] = 0x0008f07e86f3460eUL;
   tf->codes[22877] = 0x0008f07f36a0575dUL;
   tf->codes[22878] = 0x0008f11a12da9956UL;
   tf->codes[22879] = 0x0008f15c68df2280UL;
   tf->codes[22880] = 0x0008f176b71eb9ffUL;
   tf->codes[22881] = 0x0008f182270dda79UL;
   tf->codes[22882] = 0x0008f193fea19c7fUL;
   tf->codes[22883] = 0x0008f1cf77e37893UL;
   tf->codes[22884] = 0x0008f1f23ccee58bUL;
   tf->codes[22885] = 0x0008f22a823e70d9UL;
   tf->codes[22886] = 0x0008f25966c60f9aUL;
   tf->codes[22887] = 0x0008f262c7adfc27UL;
   tf->codes[22888] = 0x0008f2646197248aUL;
   tf->codes[22889] = 0x0008f2929671b1fcUL;
   tf->codes[22890] = 0x0008f2c5d396be5cUL;
   tf->codes[22891] = 0x0008f2cbc61d545eUL;
   tf->codes[22892] = 0x0008f3724cd5bc96UL;
   tf->codes[22893] = 0x0008f388b795f200UL;
   tf->codes[22894] = 0x0008f3d6086b901aUL;
   tf->codes[22895] = 0x0008f4919a8a0b1eUL;
   tf->codes[22896] = 0x0008f4f46be3c78eUL;
   tf->codes[22897] = 0x0008f50bfb6f19d1UL;
   tf->codes[22898] = 0x0008f51b4edd9c60UL;
   tf->codes[22899] = 0x0008f5f4630dffa9UL;
   tf->codes[22900] = 0x0008f5feae32034aUL;
   tf->codes[22901] = 0x0008f6581ea3d32dUL;
   tf->codes[22902] = 0x0008f66896dd7295UL;
   tf->codes[22903] = 0x0008f695a6ece32eUL;
   tf->codes[22904] = 0x0008f6dd3fcaf10bUL;
   tf->codes[22905] = 0x0008f6e282a475beUL;
   tf->codes[22906] = 0x0008f719a348e433UL;
   tf->codes[22907] = 0x0008f7f2f2084d41UL;
   tf->codes[22908] = 0x0008f7fffbe0961eUL;
   tf->codes[22909] = 0x0008f8024576cfd0UL;
   tf->codes[22910] = 0x0008f836a766f909UL;
   tf->codes[22911] = 0x0008f8371c850493UL;
   tf->codes[22912] = 0x0008f8663b9ba919UL;
   tf->codes[22913] = 0x0008f88e08d194ffUL;
   tf->codes[22914] = 0x0008f8d47ce48603UL;
   tf->codes[22915] = 0x0008f8ec46fede0bUL;
   tf->codes[22916] = 0x0008f9462c8eb978UL;
   tf->codes[22917] = 0x0008f94d7e6f7218UL;
   tf->codes[22918] = 0x0008f94e2e1c8367UL;
   tf->codes[22919] = 0x0008f989a75e5f7bUL;
   tf->codes[22920] = 0x0008f9d6bda4f7d0UL;
   tf->codes[22921] = 0x0008f9e38cee3ae8UL;
   tf->codes[22922] = 0x0008f9f7e8a73c65UL;
   tf->codes[22923] = 0x0008f9fe8adae3b6UL;
   tf->codes[22924] = 0x0008fa53a2af45faUL;
   tf->codes[22925] = 0x0008fa98f1f71a25UL;
   tf->codes[22926] = 0x0008fad79f0b46ffUL;
   tf->codes[22927] = 0x0008fb1d28e220efUL;
   tf->codes[22928] = 0x0008fb5b60d8423fUL;
   tf->codes[22929] = 0x0008fb9e2bfad6f3UL;
   tf->codes[22930] = 0x0008fbda1a5abe91UL;
   tf->codes[22931] = 0x0008fbf602837e73UL;
   tf->codes[