/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "FileImageResource.hpp"

#include "ImageManipulation.hpp"

#include "wx/image.h"

using namespace indii;

FileImageResource::FileImageResource(const wxString& path) {
  wxImage img;
  if (img.LoadFile(path)) {
    original = new Image(img.GetWidth(), img.GetHeight());
    convert(img, *original);
    cache = new ImageCache(original);
  } else {
    throw 1;
  }
}

FileImageResource::~FileImageResource() {
  //
}
