/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROPSETPARAM_H
#define _SC_PROPSETPARAM_H

// sc
#include "ScParam.h"
#include "ScParamVisitor.h"
#include "util/String.h"
#include "svn/Revision.h"


/**
 * Parameter class for PropSetCmd.
 */
class PropSetParam : public ScParam
{
public:
  PropSetParam( const sc::String& propName, const sc::String& propVal, const sc::String& path,
    bool recurse ) : _path(path), _propName(propName), _propVal(propVal), _recurse(recurse)
  {
  }

  ~PropSetParam()
  {
  }

  const sc::String& getPropName() const
  {
    return _propName;
  }

  void setPropName( const sc::String& propName )
  {
    _propName = propName;
  }

  const sc::String& getPropVal() const
  {
    return _propVal;
  }

  void setPropVal( const sc::String& val )
  {
    _propVal = val;
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  void setRecurse( bool recurse )
  {
    _recurse = recurse;
  }

  ScParamAccept(PropSetParam);

private:
  // in
  sc::String           _path;
  sc::String           _propName;
  sc::String           _propVal;
  bool                 _recurse;
};

#endif // _SC_PROPSETPARAM_H
