# ifndef _RHEO_DAMPED_NEWTON_H
# define _RHEO_DAMPED_NEWTON_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/damped-newton-generic.h"
#include "rheolef/newton_add_missing.h"

namespace rheolef { 

/*Class:damped_newton
NAME: @code{damped_newton} -- damped Newton nonlinear algorithm
@findex damped\_newton
@cindex nonlinear problem
@cindex Newton method
DESCRIPTION: 
  @noindent
  Nonlinear damped Newton algorithm for the resolution of the following problem:
  @example
       F(u) = 0
  @end example
  A simple call to the algorithm writes:
  @example
    my_problem P;
    field uh (Vh);
    damped_newton (P, uh, tol, max_iter);
  @end example
  In addition to the members required for the Newton algorithm (@pxref{newton algorithm}),
  the @code{space_norm} is required for the damped Newton line search algorithm:
  @example
    class my_problem @{
    public:
      ...
      value_type derivative_trans_mult (const value_type& mrh) const;
      Float space_norm (const value_type& uh) const;
    @};
  @end example
AUTHOR:
   | Pierre.Saramito@imag.fr
    LJK, 38041 Grenoble cedex 9, France
DATE:   14 oct 2009
METHODS: @newton
End:
*/

//<damped_newton:
template <class Problem, class Field, class Real, class Size>
int damped_newton (const Problem& F, Field& u, Real& tol, Size& max_iter, odiststream* p_derr=0)
//>damped_newton:
{
  details::add_missing_damped_newton<Problem> G (F); // TODO: avoid a copy of pb F here: put a reference in G ?
  return damped_newton (G, newton_identity_preconditioner(), u, tol, max_iter, p_derr);
}

}// namespace rheolef
# endif // _RHEO_DAMPED_NEWTON_H
