///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "2m_dualweight.h"
#include "rheolef/ublas_matrix_range.h"
using namespace rheolef;
using namespace std;
using namespace ublas;

void
_2m_dualweight::operator() (const geo_element& K, matrix<Float>& dd) const
{
  if (coordinate_system_type() == fem_helper::cartesian) 
  	fatal_macro("unexpected coordinate system");
  reference_element hat_K = K;
  size_type nj = get_first_basis().size(K);
  size_type ni = get_second_basis().size(K);
  dd.resize (get_second_basis().size(hat_K), get_first_basis().size(hat_K));
  dd.clear();
  // --------------------------------------
  // otherwise, add the (ur/r) (vr/r) r dr dz term
  //   as : ur vr (1/r) dr dz
  // i.e. using the dual `1/r' extra weight
  // --------------------------------------
  ublas::matrix<Float> m_invr;
  set_use_coordinate_system_dual_weight (true);
  build_scalar_mass (K, m_invr);
  set_use_coordinate_system_dual_weight (false);
  size_type k = 0;
  if (coordinate_system_type() == fem_helper::axisymmetric_zr) k++;
  matrix_range<matrix<Float> > dk (dd, range(k*ni,(k+1)*ni), range(k*nj,(k+1)*nj));
  dk = 2.*m_invr;
}
_2m_dualweight::size_type
_2m_dualweight::n_derivative() const
{
  return 0;
}
void
_2m_dualweight::check_after_initialize () const
{
  size_type d = coordinate_dimension();
  check_macro (
	d == get_first_space().n_component() && 
	d == get_second_space().n_component(),
	"unsupported non-vectorial space for `2m_dualweight' form");
}
