#ifndef Application_h
#define Application_h

/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "BaseApplication.h"
#include "Config.h"
#include "CommandLineArguments.h"
#include "Counter.h"
#include "IconEngine.h"

class MainWindow;
class JobInterface;

//* Main Window singleton object
class Application: public BaseApplication, public Counter
{

    //* Qt meta object declaration
    Q_OBJECT

    public:

    //* constructor
    Application( CommandLineArguments );

    //* destructor
    virtual ~Application( void );

    //* create all widgets
    virtual bool realizeWidget( void );

    //* interface
    virtual JobInterface& interface( void ) const
    { return *interface_; }

    //* retrieves top layout
    virtual MainWindow & mainWindow( void ) const
    { return *mainWindow_; }

    //*@name application information
    //@{

    //* command line parser
    CommandLineParser commandLineParser( CommandLineArguments = CommandLineArguments(), bool ignoreWarnings = true ) const;

    //* usage
    void usage( void ) const;

    //* application name
    virtual QString applicationName( void ) const
    { return "Top"; }

    //* application icon
    virtual QIcon applicationIcon( void ) const
    { return IconEngine::get( ":/Top.png" ); }

    // application version
    virtual QString applicationVersion( void ) const
    { return VERSION; }

    //@}

    protected Q_SLOTS:

    //* configuration
    virtual void _configuration( void );

    //* process request from application manager
    virtual bool _processCommand( Server::ServerCommand );

    private:

    //* pointer to top interface
    JobInterface* interface_ = nullptr;

    //* pointer to top widget
    MainWindow *mainWindow_ = nullptr;

};

#endif
