/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.lang.reflect.Constructor;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.VisADAppearance;
import visad.VisADError;
import visad.VisADGroup;
import visad.VisADLineArray;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.MouseBehaviorJ2D;
import visad.java2d.VisADCanvasJ2D;

public class DefaultDisplayRendererJ2D
extends DisplayRendererJ2D {
    private VisADAppearance box = null;
    private VisADAppearance cursor = null;
    private Class mouseBehaviorJ2DClass = null;
    private MouseBehaviorJ2D mouse = null;
    private static final float[] box_verts = new float[]{-1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f};
    private static final float[] cursor_verts = new float[]{0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f};

    public DefaultDisplayRendererJ2D() {
        this.mouseBehaviorJ2DClass = MouseBehaviorJ2D.class;
    }

    public DefaultDisplayRendererJ2D(Class mbj2dClass) {
        this.mouseBehaviorJ2DClass = mbj2dClass;
    }

    public boolean getMode2D() {
        return true;
    }

    public boolean legalDisplayScalar(DisplayRealType type) {
        if (Display.ZAxis.equals(type) || Display.Latitude.equals(type) || Display.Alpha.equals(type)) {
            return false;
        }
        return super.legalDisplayScalar(type);
    }

    public VisADGroup createSceneGraph(VisADCanvasJ2D c) throws DisplayException {
        VisADGroup root = this.getRoot();
        if (root != null) {
            return root;
        }
        try {
            Class[] param = new Class[]{DisplayRendererJ2D.class};
            Constructor mbConstructor = this.mouseBehaviorJ2DClass.getConstructor(param);
            this.mouse = (MouseBehaviorJ2D)mbConstructor.newInstance(this);
        }
        catch (Exception e) {
            throw new VisADError("cannot construct " + this.mouseBehaviorJ2DClass);
        }
        this.getDisplay().setMouseBehavior(this.mouse);
        this.box = new VisADAppearance();
        this.cursor = new VisADAppearance();
        root = this.createBasicSceneGraph(c, this.mouse, this.box, this.cursor);
        VisADLineArray box_array = new VisADLineArray();
        box_array.coordinates = box_verts;
        box_array.vertexCount = 8;
        float[] ctlBox = this.getRendererControl().getBoxColor();
        this.box.red = ctlBox[0];
        this.box.green = ctlBox[1];
        this.box.blue = ctlBox[2];
        this.box.color_flag = true;
        this.box.array = box_array;
        VisADGroup box_on = this.getBoxOnBranch();
        box_on.addChild(this.box);
        VisADLineArray cursor_array = new VisADLineArray();
        cursor_array.coordinates = cursor_verts;
        cursor_array.vertexCount = 4;
        float[] ctlCursor = this.getRendererControl().getCursorColor();
        this.cursor.red = ctlCursor[0];
        this.cursor.green = ctlCursor[1];
        this.cursor.blue = ctlCursor[2];
        this.cursor.color_flag = true;
        this.cursor.array = cursor_array;
        VisADGroup cursor_on = this.getCursorOnBranch();
        cursor_on.addChild(this.cursor);
        return root;
    }

    public void setBoxAspect(double[] aspect) {
        float[] new_verts = new float[box_verts.length];
        for (int i = 0; i < box_verts.length; i += 3) {
            new_verts[i] = (float)((double)box_verts[i] * aspect[0]);
            new_verts[i + 1] = (float)((double)box_verts[i + 1] * aspect[1]);
            new_verts[i + 2] = (float)((double)box_verts[i + 2] * aspect[2]);
        }
        VisADLineArray box_array = (VisADLineArray)this.box.array;
        box_array.coordinates = new_verts;
    }

    public void setLineWidth(float width) {
        this.box.lineWidth = width;
        this.cursor.lineWidth = width;
    }
}

