/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011 OpenFOAM Foundation
     \\/     M anipulation  | Copyright (C) 2018 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::setToFaceZone

Description
    A topoSetSource to select faces based on usage in a faceSet.
    Sets flipMap to true.

    \heading Dictionary parameters
    \table
        Property    | Description                           | Required | Default
        faceSet     | Name of input faceSet                 | yes   |
    \endtable

Note
    The use of keyword \c faceSet is consistent with the setsToFaceZone,
    but inconsistent with setToCellZone and setToPointZone.
    Both of which use \c set instead.

SourceFiles
    setToFaceZone.C

\*---------------------------------------------------------------------------*/

#ifndef setToFaceZone_H
#define setToFaceZone_H

#include "topoSetSource.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                        Class setToFaceZone Declaration
\*---------------------------------------------------------------------------*/

class setToFaceZone
:
    public topoSetSource
{
    // Private data

        //- Add usage string
        static addToUsageTable usage_;

        //- Name of set to use
        word setName_;

public:

    //- Runtime type information
    TypeName("setToFaceZone");

    // Constructors

        //- Construct from components
        setToFaceZone
        (
            const polyMesh& mesh,
            const word& setName
        );

        //- Construct from dictionary
        setToFaceZone(const polyMesh& mesh, const dictionary& dict);

        //- Construct from Istream
        setToFaceZone(const polyMesh& mesh, Istream& is);


    //- Destructor
    virtual ~setToFaceZone() = default;


    // Member Functions

        virtual sourceType setType() const
        {
            return FACEZONESOURCE;
        }

        virtual void applyToSet
        (
            const topoSetSource::setAction action,
            topoSet& set
        ) const;

};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
