; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

declare <8 x float> @llvm.x86.avx.round.ps.256(<8 x float>, i32)
declare <4 x double> @llvm.x86.avx.round.pd.256(<4 x double>, i32)

define <8 x float> @test_round_ps_floor(<8 x float> %a) {
; CHECK-LABEL: @test_round_ps_floor(
; CHECK-NEXT:    [[TMP1:%.*]] = call <8 x float> @llvm.floor.v8f32(<8 x float> [[A:%.*]])
; CHECK-NEXT:    ret <8 x float> [[TMP1]]
;
  %1 = call <8 x float> @llvm.x86.avx.round.ps.256(<8 x float> %a, i32 1)
  ret <8 x float> %1
}

define <8 x float> @test_round_ps_ceil(<8 x float> %a) {
; CHECK-LABEL: @test_round_ps_ceil(
; CHECK-NEXT:    [[TMP1:%.*]] = call <8 x float> @llvm.ceil.v8f32(<8 x float> [[A:%.*]])
; CHECK-NEXT:    ret <8 x float> [[TMP1]]
;
  %1 = call <8 x float> @llvm.x86.avx.round.ps.256(<8 x float> %a, i32 2)
  ret <8 x float> %1
}

define <4 x double> @test_round_pd_floor(<4 x double> %a) {
; CHECK-LABEL: @test_round_pd_floor(
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x double> @llvm.floor.v4f64(<4 x double> [[A:%.*]])
; CHECK-NEXT:    ret <4 x double> [[TMP1]]
;
  %1 = call <4 x double> @llvm.x86.avx.round.pd.256(<4 x double> %a, i32 1)
  ret <4 x double> %1
}

define <4 x double> @test_round_pd_ceil(<4 x double> %a) {
; CHECK-LABEL: @test_round_pd_ceil(
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x double> @llvm.ceil.v4f64(<4 x double> [[A:%.*]])
; CHECK-NEXT:    ret <4 x double> [[TMP1]]
;
  %1 = call <4 x double> @llvm.x86.avx.round.pd.256(<4 x double> %a, i32 2)
  ret <4 x double> %1
}
