
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAccessibleEditableTextInterface.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAccessibleEditableTextInterface>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAccessibleEditableTextInterface

// void QAccessibleEditableTextInterface::deleteText(int startOffset, int endOffset)


static void _init_f_deleteText_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startOffset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endOffset");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_deleteText_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleEditableTextInterface *)cls)->deleteText (arg1, arg2);
}


// void QAccessibleEditableTextInterface::insertText(int offset, const QString &text)


static void _init_f_insertText_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertText_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleEditableTextInterface *)cls)->insertText (arg1, arg2);
}


// void QAccessibleEditableTextInterface::replaceText(int startOffset, int endOffset, const QString &text)


static void _init_f_replaceText_3343 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startOffset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endOffset");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_replaceText_3343 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleEditableTextInterface *)cls)->replaceText (arg1, arg2, arg3);
}


namespace gsi
{

static gsi::Methods methods_QAccessibleEditableTextInterface () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("deleteText", "@brief Method void QAccessibleEditableTextInterface::deleteText(int startOffset, int endOffset)\n", false, &_init_f_deleteText_1426, &_call_f_deleteText_1426);
  methods += new qt_gsi::GenericMethod ("insertText", "@brief Method void QAccessibleEditableTextInterface::insertText(int offset, const QString &text)\n", false, &_init_f_insertText_2684, &_call_f_insertText_2684);
  methods += new qt_gsi::GenericMethod ("replaceText", "@brief Method void QAccessibleEditableTextInterface::replaceText(int startOffset, int endOffset, const QString &text)\n", false, &_init_f_replaceText_3343, &_call_f_replaceText_3343);
  return methods;
}

gsi::Class<QAccessibleEditableTextInterface> decl_QAccessibleEditableTextInterface ("QtGui", "QAccessibleEditableTextInterface_Native",
  methods_QAccessibleEditableTextInterface (),
  "@hide\n@alias QAccessibleEditableTextInterface");

GSI_QTGUI_PUBLIC gsi::Class<QAccessibleEditableTextInterface> &qtdecl_QAccessibleEditableTextInterface () { return decl_QAccessibleEditableTextInterface; }

}


class QAccessibleEditableTextInterface_Adaptor : public QAccessibleEditableTextInterface, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAccessibleEditableTextInterface_Adaptor();

  //  [adaptor ctor] QAccessibleEditableTextInterface::QAccessibleEditableTextInterface()
  QAccessibleEditableTextInterface_Adaptor() : QAccessibleEditableTextInterface()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] void QAccessibleEditableTextInterface::deleteText(int startOffset, int endOffset)
  void cbs_deleteText_1426_0(int startOffset, int endOffset)
  {
    __SUPPRESS_UNUSED_WARNING (startOffset);
    __SUPPRESS_UNUSED_WARNING (endOffset);
    throw qt_gsi::AbstractMethodCalledException("deleteText");
  }

  virtual void deleteText(int startOffset, int endOffset)
  {
    if (cb_deleteText_1426_0.can_issue()) {
      cb_deleteText_1426_0.issue<QAccessibleEditableTextInterface_Adaptor, int, int>(&QAccessibleEditableTextInterface_Adaptor::cbs_deleteText_1426_0, startOffset, endOffset);
    } else {
      throw qt_gsi::AbstractMethodCalledException("deleteText");
    }
  }

  //  [adaptor impl] void QAccessibleEditableTextInterface::insertText(int offset, const QString &text)
  void cbs_insertText_2684_0(int offset, const QString &text)
  {
    __SUPPRESS_UNUSED_WARNING (offset);
    __SUPPRESS_UNUSED_WARNING (text);
    throw qt_gsi::AbstractMethodCalledException("insertText");
  }

  virtual void insertText(int offset, const QString &text)
  {
    if (cb_insertText_2684_0.can_issue()) {
      cb_insertText_2684_0.issue<QAccessibleEditableTextInterface_Adaptor, int, const QString &>(&QAccessibleEditableTextInterface_Adaptor::cbs_insertText_2684_0, offset, text);
    } else {
      throw qt_gsi::AbstractMethodCalledException("insertText");
    }
  }

  //  [adaptor impl] void QAccessibleEditableTextInterface::replaceText(int startOffset, int endOffset, const QString &text)
  void cbs_replaceText_3343_0(int startOffset, int endOffset, const QString &text)
  {
    __SUPPRESS_UNUSED_WARNING (startOffset);
    __SUPPRESS_UNUSED_WARNING (endOffset);
    __SUPPRESS_UNUSED_WARNING (text);
    throw qt_gsi::AbstractMethodCalledException("replaceText");
  }

  virtual void replaceText(int startOffset, int endOffset, const QString &text)
  {
    if (cb_replaceText_3343_0.can_issue()) {
      cb_replaceText_3343_0.issue<QAccessibleEditableTextInterface_Adaptor, int, int, const QString &>(&QAccessibleEditableTextInterface_Adaptor::cbs_replaceText_3343_0, startOffset, endOffset, text);
    } else {
      throw qt_gsi::AbstractMethodCalledException("replaceText");
    }
  }

  gsi::Callback cb_deleteText_1426_0;
  gsi::Callback cb_insertText_2684_0;
  gsi::Callback cb_replaceText_3343_0;
};

QAccessibleEditableTextInterface_Adaptor::~QAccessibleEditableTextInterface_Adaptor() { }

//  Constructor QAccessibleEditableTextInterface::QAccessibleEditableTextInterface() (adaptor class)

static void _init_ctor_QAccessibleEditableTextInterface_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAccessibleEditableTextInterface_Adaptor> ();
}

static void _call_ctor_QAccessibleEditableTextInterface_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleEditableTextInterface_Adaptor *> (new QAccessibleEditableTextInterface_Adaptor ());
}


// void QAccessibleEditableTextInterface::deleteText(int startOffset, int endOffset)

static void _init_cbs_deleteText_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startOffset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endOffset");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_deleteText_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleEditableTextInterface_Adaptor *)cls)->cbs_deleteText_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_deleteText_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleEditableTextInterface_Adaptor *)cls)->cb_deleteText_1426_0 = cb;
}


// void QAccessibleEditableTextInterface::insertText(int offset, const QString &text)

static void _init_cbs_insertText_2684_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_insertText_2684_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleEditableTextInterface_Adaptor *)cls)->cbs_insertText_2684_0 (arg1, arg2);
}

static void _set_callback_cbs_insertText_2684_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleEditableTextInterface_Adaptor *)cls)->cb_insertText_2684_0 = cb;
}


// void QAccessibleEditableTextInterface::replaceText(int startOffset, int endOffset, const QString &text)

static void _init_cbs_replaceText_3343_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startOffset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endOffset");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_replaceText_3343_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QString &arg3 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleEditableTextInterface_Adaptor *)cls)->cbs_replaceText_3343_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_replaceText_3343_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleEditableTextInterface_Adaptor *)cls)->cb_replaceText_3343_0 = cb;
}


namespace gsi
{

gsi::Class<QAccessibleEditableTextInterface> &qtdecl_QAccessibleEditableTextInterface ();

static gsi::Methods methods_QAccessibleEditableTextInterface_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAccessibleEditableTextInterface::QAccessibleEditableTextInterface()\nThis method creates an object of class QAccessibleEditableTextInterface.", &_init_ctor_QAccessibleEditableTextInterface_Adaptor_0, &_call_ctor_QAccessibleEditableTextInterface_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("deleteText", "@hide", false, &_init_cbs_deleteText_1426_0, &_call_cbs_deleteText_1426_0);
  methods += new qt_gsi::GenericMethod ("deleteText", "@brief Virtual method void QAccessibleEditableTextInterface::deleteText(int startOffset, int endOffset)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_deleteText_1426_0, &_call_cbs_deleteText_1426_0, &_set_callback_cbs_deleteText_1426_0);
  methods += new qt_gsi::GenericMethod ("insertText", "@hide", false, &_init_cbs_insertText_2684_0, &_call_cbs_insertText_2684_0);
  methods += new qt_gsi::GenericMethod ("insertText", "@brief Virtual method void QAccessibleEditableTextInterface::insertText(int offset, const QString &text)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertText_2684_0, &_call_cbs_insertText_2684_0, &_set_callback_cbs_insertText_2684_0);
  methods += new qt_gsi::GenericMethod ("replaceText", "@hide", false, &_init_cbs_replaceText_3343_0, &_call_cbs_replaceText_3343_0);
  methods += new qt_gsi::GenericMethod ("replaceText", "@brief Virtual method void QAccessibleEditableTextInterface::replaceText(int startOffset, int endOffset, const QString &text)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_replaceText_3343_0, &_call_cbs_replaceText_3343_0, &_set_callback_cbs_replaceText_3343_0);
  return methods;
}

gsi::Class<QAccessibleEditableTextInterface_Adaptor> decl_QAccessibleEditableTextInterface_Adaptor (qtdecl_QAccessibleEditableTextInterface (), "QtGui", "QAccessibleEditableTextInterface",
  methods_QAccessibleEditableTextInterface_Adaptor (),
  "@qt\n@brief Binding of QAccessibleEditableTextInterface");

}

