<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>
  <!-- $Id: html-stylesheet.xsl 2848 2015-08-24 22:55:09Z brachman $ -->

<!-- Customizations for DACS -->

  <xsl:import href="docbook-xsl/html/docbook.xsl"/>

  <xsl:param name="html.stylesheet">css/dacsdocs.css</xsl:param>
  <xsl:param name="toc.section.depth">3</xsl:param>
  <xsl:param name="annotate.toc">0</xsl:param>
  <xsl:param name="navig.graphics">1</xsl:param>
  <xsl:param name="funcsynopsis.style">ansi-nontabular</xsl:param>

  <!-- See http://www.sagehill.net/docbookxsl/Variablelists.html -->
  <!-- Couldn't make http://www.sagehill.net/docbookxsl/LineBreaks.html work -->
  <xsl:param name="variablelist.term.break.after">1</xsl:param>
  <xsl:param name="variablelist.term.separator"> </xsl:param>

<!-- Shuts up warnings about "missing" refentry markup -->
  <xsl:param name="refentry.meta.get.quietly">1</xsl:param>

<!-- See http://www.sagehill.net/docbookxsl/UsingCSS.html#CustomClass -->
  <xsl:param name="phrase.propagates.style">1</xsl:param>

  <xsl:param name="admon.style">
    <xsl:text>margin-left: 0.125in; margin-right: 0.125in;</xsl:text>
  </xsl:param>

  <!-- Wrap the entire body in a div.  This is for dynamic font selection. -->
  <!-- Refer to the CSS and Javascript files for details. -->
  <!-- The initial size (e.g., para16) must match with the selection image. -->
  <xsl:template match="refentry">
    <div id="refentry" class="para16">
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="processing-instruction('htmlcode')">
    <xsl:variable name="codefile" select="document(normalize-space(.),/)"/>
    <xsl:copy-of select="$codefile/*/node()"/>
  </xsl:template>

  <xsl:template match="sect1" mode="toc">
    <xsl:param name="toc-context" select="."/>
    <xsl:call-template name="subtoc">
      <xsl:with-param name="toc-context" select="$toc-context"/>
      <xsl:with-param name="nodes" 
        select="sect2|refentry|bridgehead[$bridgehead.in.toc != 0]"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="sect2" mode="toc">
    <xsl:param name="toc-context" select="."/>

    <xsl:call-template name="subtoc">
      <xsl:with-param name="toc-context" select="$toc-context"/>
      <xsl:with-param name="nodes" 
        select="sect3|refentry|bridgehead[$bridgehead.in.toc != 0]"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="orderedlist[@role = 'nomarker']">
    <div class="nomarker">
     <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="listitem[@role = 'column1']">
    <div class="column1">
     <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="listitem[@role = 'column2']">
    <div class="column2">
     <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="listitem[@role = 'column2 reset']">
    <div class="column2 reset">
     <xsl:apply-templates/>
    </div>
  </xsl:template>


<xsl:template match="varlistentry[@class = 'addon']">
    <dt>
    <div class="addon">
     <xsl:apply-templates/>
    </div>
    </dt>
</xsl:template>

<xsl:template match="listitem[@class = 'addon']">
    <li class="listitem">
    <div class="addon">
     <xsl:apply-templates/>
    </div>
    </li>
</xsl:template>


  <!-- Customization for some systemitem classes -->
  <!-- XXX there must be an easier way to write these -->

  <!-- Nonstandard... -->
  <!-- An attribute name, or something semantically similar -->
  <xsl:template match="systemitem[@class = 'attrname']">
    <span class="attrname">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="systemitem[@class = 'domainname']">
    <span class="domainname">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Nonstandard... -->
  <!-- Unlike the email tag, this should not become a real link -->
  <xsl:template match="systemitem[@class = 'emailaddr']">
    <span class="emailaddr">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="systemitem[@class = 'groupname']">
    <span class="groupname">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="systemitem[@class = 'ipaddress']">
    <span class="ipaddress">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="systemitem[@class = 'osname']">
    <span class="osname">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Nonstandard... -->
  <!-- A port name or number, or service name -->
  <xsl:template match="systemitem[@class = 'port']">
    <span class="port">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Nonstandard... -->
  <!-- A keyword, directive name, field name, header name, -->
  <!-- or semantically similar name -->
  <xsl:template match="systemitem[@class = 'keyword']">
    <span class="keyword">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="systemitem[@class = 'library']">
    <span class="library">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Nonstandard... -->
  <xsl:template match="systemitem[@class = 'namespace']">
    <span class="namespace">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Nonstandard... something more generic than a filename -->
  <xsl:template match="systemitem[@class = 'path']">
    <span class="path">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Nonstandard... a relative URL -->
  <xsl:template match="systemitem[@class = 'relurl']">
    <span class="relurl">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="systemitem[@class = 'resource']">
    <span class="resource">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="systemitem[@class = 'sysconstant']">
    <span class="sysconstant">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Nonstandard... -->
  <xsl:template match="systemitem[@class = 'uri']">
    <span class="uri">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Nonstandard... -->
  <xsl:template match="systemitem[@class = 'url']">
    <span class="url">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="systemitem[@class = 'username']">
    <span class="username">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Customization for some literal classes -->

  <!-- Nonstandard... software/documentation version -->
  <xsl:template match="literal[@class = 'version']">
    <span class="version">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Nonstandard... programming language -->
  <xsl:template match="literal[@class = 'language']">
    <span class="language">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Customization for some filename classes -->

  <xsl:template match="filename[@class = 'devicefile']">
    <span class="devicefile">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="filename[@class = 'directory']">
    <span class="directory">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <xsl:template match="filename[@class = 'extension']">
    <span class="extension">
     <xsl:apply-templates/>
    </span>
  </xsl:template>

  <!-- Customization for smaller point size code listings, etc. -->
  <xsl:template match="programlisting[@class = 'small_listing']">
    <pre class="small_programlisting">
     <xsl:apply-templates/>
    </pre>
  </xsl:template>

  <!-- This is used to highlight inline code-type snippets. -->
  <xsl:template match="code[@class = 'inline']">
    <code class="inline_code">
     <xsl:apply-templates/>
    </code>
  </xsl:template>

<!-- See http://www.sagehill.net/docbookxsl/CustomGentext.html -->
<xsl:param name="local.l10n.xml" select="document('')"/>
<l:i18n xmlns:l="http://docbook.sourceforge.net/xmlns/l10n/1.0">
  <l:l10n language="en">
    <l:gentext key="RefName" text="NAME"/>
    <l:gentext key="refname" text="NAME"/>
    <l:gentext key="RefSynopsisDiv" text="SYNOPSIS"/>
    <l:gentext key="refsynopsisdiv" text="SYNOPSIS"/>
  </l:l10n>
</l:i18n>

<!--
What I would like is for the tags that get indexed by mkindex
to cause a 'title' attribute to be emitted having the value of the
xreflabel as its value; e.g.,
  <important id="security2" xreflabel="Hello, world"><title>Security</title>
would generate HTML like:
  <h3 class="title" title="Hello, world"><a name="security2"></a>Security</h3>
Same for <note ...> and <tip ...>
-->

<!--
<xsl:template name="important.xreflabel">
  <xsl:param name="target" select="."/>
  <xsl:value-of select="$target/@xreflabel"/>

  <l:i18n xmlns:l="http://docbook.sourceforge.net/xmlns/l10n/1.0">
   <l:l10n language="en">
    <l:gentext key="title" text="SOMETHING"/>
   </l:l10n>
  </l:i18n>
</xsl:template>
-->

</xsl:stylesheet>

