#! /usr/bin/python

# btsutils -- Python module to interact with debbugs servers.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import sys
from btsutils.debbugs import debbugs

def usage():
    print """
Usage: btsutils <query>

<query> must be one of the following:

bug:<bug number>
src:<source package>
pkg:<binary package>
maint:<maintainer>
from:<submitter>
usertag: <tag> [tag2 ... tagN]
"""

if (len(sys.argv) != 2):
    usage()
else:
    try:
        bts = debbugs()
        bugs = bts.query(sys.argv[1])

        print "\nFound %d bugs:\n" % len(bugs)

        for bug in bugs:
            print bug
            print
    except:
        usage()
        raise

# vim: tabstop=4 expandtab shiftwidth=4
