/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "reverse_address.h"
#include "select_first_domain.h"

extern char CHROOT_PATH_BUF[1024];
extern int MAX_CONF_LINE;


void populate_domain_treeview(struct w *widgets)
{
    FILE *fp;
    GtkTreeIter iter;
    gchar *named_conf, *utf8=NULL;
    GtkTreePath *path;
    gboolean edit=0;
    int set_cursorpath=0;
    long conf_size=0;
    char *line, *forward, *forward_address=NULL, *reverse, *reverse_file, *type, *tmp;

    gtk_list_store_clear(widgets->domain_store);

    named_conf = g_strdup_printf("%s/etc/named.conf", CHROOT_PATH_BUF);

    if((fp=fopen(named_conf, "r"))==NULL)
    {
        printf("Couldnt find: %s\n", named_conf);
	g_free(named_conf);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);
    forward = allocate(MAX_CONF_LINE);
    reverse = allocate(MAX_CONF_LINE);
    reverse_file = allocate(MAX_CONF_LINE);
    type = allocate(MAX_CONF_LINE);
    tmp = allocate(MAX_CONF_LINE);

    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strlen(line) > MAX_CONF_LINE-3 )
	  continue;

	/* Skip comments */
	if( strstr(line, "/*") )
	{
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( strstr(line, "*/") )
		  break;
	    }	
	}
	/* Skip comment */
	if( strstr(line, "//") )
	  continue;

	/* Ignore any options */
	if( ! strstr(line, "zone") && strstr(line, "{") && ! strstr(line, "}") )
	while(fgets(line, conf_size, fp)!=NULL)
	if( strstr(line, "}") )
	  break;

	
	/* Forward zone begin */
	if(  strstr(line, "zone ") && strstr(line, "\"")
	&& ! strstr(line, "forward.zone") 
	&& ! strstr(line, "localhost") 
	&& ! strstr(line, "in-addr.arpa") 
	&& ! strstr(line, "hint") )
	{
	    sscanf(line, "%*s %s", forward);
	    snprintf(tmp, 8000, "%s", &forward[1]);
	    snprintf(forward, strlen(tmp), "%s", tmp);

	    /* Dont append root.hints or the local zone */
	    if( ! strcmp(forward, ".") || ! strcmp(forward, "127.0.0") )
	      continue;

	    /* For matching against the reverse zone file */
	    tmp[strlen(tmp)-1]='\0'; /* Cut the last '"' char */
	    snprintf(reverse_file, strlen(tmp)+3, "/%s/", tmp);
	    
	    gtk_list_store_append(GTK_LIST_STORE(widgets->domain_store), &iter);
	    utf8 = g_locale_to_utf8(forward, strlen(forward), NULL, NULL, NULL);
	    gtk_list_store_set(GTK_LIST_STORE(widgets->domain_store), &iter, 0, utf8, -1);
	    set_cursorpath=1;

	    /* DNS Type */
	    while(fgets(line, conf_size, fp)!=NULL)
	    if( strstr(line, "type") && strlen(forward) > 3 )
	    {
		sscanf(line, "%*s %s", type);
		snprintf(tmp, 8000, "%s", type);
		snprintf(type, strlen(tmp), "%s", tmp);
		utf8 = g_locale_to_utf8(type, strlen(type), NULL, NULL, NULL);
		gtk_list_store_set(GTK_LIST_STORE(widgets->domain_store), &iter, 2, utf8, -1);
		break;	    
	    }	    
	}

	
	/* Reverse zone begin */
	if( strstr(line, "zone ") && strstr(line, "in-addr.arpa") 
	&& ! strstr(line, "reverse.zone") )
	{
	    sscanf(line, "%*s %s", reverse);
	    snprintf(tmp, 8000, "%s", &reverse[1]);
	    snprintf(reverse, strlen(tmp)-13, "%s", tmp);

	    /* Dont append root.hints or the local zone */
	    if( ! strcmp(forward, ".") || ! strcmp(forward, "0.0.127") )
	      continue;


	    while(fgets(line, conf_size, fp)!=NULL)
	    if( strstr(line, reverse_file) )
	    {
		if( strlen(line) > MAX_CONF_LINE-3 )
		  continue;

		/* Skip comments */
		if( strstr(line, "/*") )
		{
		    while(fgets(line, conf_size, fp)!=NULL)
		    {
			if( strstr(line, "*/") )
			  break;
		    }	
		}
		/* Skip comment */
		if( strstr(line, "//") )
		continue;

		/* Ignore any options */
		if( ! strstr(line, "zone") && strstr(line, "{") && ! strstr(line, "}") )
		while(fgets(line, conf_size, fp)!=NULL)
		if( strstr(line, "}") )
		  break;

		/* Reverse the network address we get */
		forward_address = reverse_address(reverse);

		utf8 = g_locale_to_utf8(forward_address, strlen(forward_address), NULL, NULL, NULL);
		gtk_list_store_set(GTK_LIST_STORE(widgets->domain_store), &iter, 1, utf8, -1);
		forward[0]='\0';
		free(forward_address);
		reverse[0]='\0';
		reverse_file[0]='\0';
		break;
	    }
	}
    }
    fclose(fp);
    free(line);
    free(forward);
    free(reverse);
    free(reverse_file);
    free(type);
    free(tmp);
    g_free(named_conf);

    if( utf8!=NULL )
      g_free(utf8);

    if( ! set_cursorpath )
      return;


    select_first_domain(widgets);

    
    /* FIXME.. Scroll to the correct global nic subnet and netmask (and if its set) set as curpath */
    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->domain_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
