# Copyright (C) 2005 Aaron Bentley, 2006 Michael Ellerman
# <aaron.bentley@utoronto.ca>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

class NoPyBaz(Exception):
    def __init__(self):
        Exception.__init__(self, "PyBaz is not installed.")
try:
    from bzrlib.errors import BzrCommandError as CommandError
except ImportError:
    class CommandError(Exception):
        pass

class PatchFailed(Exception):
    """Failed applying patch!"""

class NotCheckout(CommandError):
    """Specified path is not a checkout."""
    def __init__(self, path):
        CommandError.__init__(self, "%s is not a checkout" % path)

class UncommittedCheckout(CommandError):
    """This checkout contains uncommitted changes"""
    def __init__(self):
        CommandError.__init__(self, "This checkout has uncommitted changes")
