/**************************************************************************************************
	$Header: /pub/cvsroot/yencode/src/ypost/sock.h,v 1.2 2002/03/21 04:58:31 bboy Exp $

	Copyright (C) 2002  Don Moore <bboy@bboy.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at Your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************************************/

#ifndef _SOCK_H
#define _SOCK_H

#define	DEFAULT_SOCK_TIMEOUT	120

#define	CR		'\r'
#define	LF 	'\n'
#define	CRLF	"\r\n"

#define	sock_setfd(d)			_sock_current_fd = d
#define	_SOCK_CURRENT_FD		((opt_stdout) ? STDOUT_FILENO : _sock_current_fd)
#define	sock_read(b,c)			sock_read_fd(_SOCK_CURRENT_FD, b, c)
#define	sock_gets()				sock_gets_fd(_SOCK_CURRENT_FD)
#define	sock_write(b,c)		sock_write_fd(_SOCK_CURRENT_FD, b, c)
#define	sock_puts(d)			sock_puts_fd(_SOCK_CURRENT_FD, d)
#define	sock_puts_meter(d,c,t,s)	sock_puts_meter_fd(_SOCK_CURRENT_FD, d, c, t, s)


/*
**  Global variables
*/
extern int _sock_current_fd;


/*
**  Function declarations
*/

extern char *addrstr(struct sockaddr_in *sa);
extern struct sockaddr_in *sock_getsockaddr(char *address);
extern int sock_open(struct sockaddr_in *sa);

extern ssize_t sock_read_fd(int fd, unsigned char *buf, size_t count);
extern unsigned char *sock_gets_fd(int fd);
extern void sock_write_fd(int fd, const unsigned char *buf, int count);
extern void sock_puts_fd(int fd, const unsigned char *data);
extern void sock_printf(const char *fmt, ...) __printflike(1,2);
extern long sock_puts_meter_fd(int fd, const unsigned char *data, long current, long total, const char *desc);

#endif /* !_SOCK_H */

/* vi:set ts=3: */
