/*
    This file is part of wmpload - a program to monitor ppp activity for X
    Copyright (C) 1999-2000  Matt Smith <mdsmith@engr.utk.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* wmpload.h */
#ifndef WMPLOAD_H_INC
#define WMPLOAD_H_INC 1

#include <stdio.h>
#include <sys/time.h>	/* struct timeval */

struct if_dat
{
	int s;					/* socket or fd		*/
	char *device;				/* device to monitor 	*/
#ifdef STREAMS
	int dev_n;				/* number of the device */
#endif
#ifdef LINUXPROC
	FILE *file;				/* /proc/net/dev	*/
#endif	
	unsigned long in_bytes;			/* total bytes in 	*/
	unsigned long in_bytes_old;		/* last total bytes in	*/
	unsigned long out_bytes;		/* total bytes out 	*/
	unsigned long out_bytes_old;		/* last total byts out	*/
	struct timeval prev_time;		/* last time 		*/
	struct timeval curr_time;		/* time now		*/
	int history_size;			/* # pts to average over*/
	double *in_history;			/* in history array 	*/
	double *out_history;			/* out history array 	*/
	double in_rate;				/* in rate, bytes/s 	*/
	double out_rate;			/* out rate, bytes/s 	*/
	double in_max;				/* maximum in rate b/s	*/
	double out_max;				/* maximum out rate b/s	*/
	void (*getstats)(struct if_dat*);	/* function to get stats*/
};

typedef struct if_dat if_data;

/* function prototypes */
void ifd_initialize(if_data*, char*, int, int);
void ifd_stop(if_data*);
void getsocket(if_data*);
void get_stat(if_data*);
void ioctl_stat(if_data*);
void die(char*);

#ifdef STREAMS
int strioctl(int, int, void*, int, int);
#endif

#ifdef LINUXPROC
void proc_stat(if_data*);
#endif


#endif /* WMPLOAD_H_INC */
