/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_SERVICE_H
#define _WF_SERVICE_H

#include <iostream>
#include <string>
#include <inttypes.h>

#include "wfprotocol.h"
#include "wfipaddr.h"

/**
 * service: a listening entity.
 * Defined by a protocol, a port, and an IP address.
 */
class wf_service {
 public:
  wf_service(const wf_protocol& protocol, uint16_t port,
	     const wf_ipaddr& ipaddr = 0);
  virtual ~wf_service() {}
  // wf_service(const wf_service&) {} implicit copy constructor

  void protocol_set(const wf_protocol& protocol);
  int16_t protocol_get() const;

  bool port_set(uint16_t port);
  uint16_t port_get() const;

  void ipaddr_set(const wf_ipaddr& ipaddr);
  const wf_ipaddr& ipaddr_get() const;

  string tostr() const;

  ostream& print(ostream& os) const;
  ostream& debugprint(ostream& os) const;

  friend bool operator==(const wf_service& service1,
			 const wf_service& service2);
  friend ostream& operator<<(ostream& os, const wf_service& service);

 private:
  wf_protocol _protocol;
  uint16_t _port;
  wf_ipaddr _ipaddr;
};

#endif
