/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sstream>
#include <netdb.h>

#include "wfprotocol.h"
#include "defs.h"


wf_protocol::wf_protocol() :
  _num(-1)
{}

wf_protocol::wf_protocol(int16_t protocol) {
  set(protocol);
}

wf_protocol::wf_protocol(const string& name) {
  set(name);
}


bool
wf_protocol::set(int16_t protocol) {
  if (protocol < -1)
    return false;
  _num = protocol;
  return true;
}

bool
wf_protocol::set(const string& name) {
  struct protoent* protoent = getprotobyname(name.c_str());
  if (protoent == NULL)
    return false;
  _num = protoent->p_proto;
  return true;
}

int16_t
wf_protocol::get() const {
  return _num;
}


string
wf_protocol::tostr() const {
  ostringstream os;
  struct protoent* protoent = getprotobynumber(_num);
  if (protoent == NULL)
    os << _num;
  else
    os << protoent->p_name;
  return os.str();
}

ostream&
wf_protocol::print(ostream& os) const {
  return os << tostr();
}

bool
operator==(const wf_protocol& protocol1, const wf_protocol& protocol2) {
  return protocol1._num == protocol2._num;
}
