#!/usr/bin/perl -w 
# functions.pl - Other functions for webmin-ldap-skolelinux
#
# $Id: functions.pl,v 1.9 2004/06/16 21:08:18 andreas Exp $


use strict;

my @scriptdirs = qw(/etc/webmin/ldap-users /usr/share/webmin/ldap-users .);

# Call the first executable script in @scriptdirs.  This make it easy
# to change locally which script to call.
sub run_script {
    my ($scriptname, @args) = @_;

    my $done = 0;
    my $retval = 1;
    
    my $output;
    for my $scriptdir (@scriptdirs) {
	my $path = "$scriptdir/$scriptname";
	if ( -x $path) {
	    # from system(), 0 means success.  invert before returning it.
	    my $output .= `$path @args 2>&1`;
	    $retval = ! $?; 
	    $done = 1;
	    last;
	}
    }
    unless ( $done ) {
	$output .= $text{'error'}.": Unable to find any executable ".
	      "script $scriptname in " . join(" ", @scriptdirs) . ".\n";
	$retval = "error";
    }
    return ($retval, $output);
}

# Create a users home directory.
sub create_dir {
    my ($homedir, $uidNumber, $gidNumber) = @_;

    return ("error", undef) unless $uidNumber;

    return run_script("createhomedir", $homedir, $uidNumber, $gidNumber);
}

# Delete a users home directory.
sub delete_dir {
    my ($homedir) = @_;

    return undef unless $homedir;

    return run_script("removehomedir", $homedir);
}

# Check if username (uid) is a valid string.
sub valid_uid {
    my ($uid) = @_;

    return 0 unless $uid;
    return 0 unless (length($uid) < 9);
    return $uid =~ m/^[a-z][a-z0-9]*$/;
}

# Check if groupname (gid) is a valid string.
sub valid_gid {
    my ($gid) = @_;

    return 0 unless $gid;
    return 0 unless (length($gid) < 9);
    return $gid =~ m/^[a-z][a-z0-9]*$/;
}


sub change_samba {
    my ($student_id, $newpass, $rootpass) = @_;

    return ("error", "/usr/bin/smbpasswd not found" ) 
	unless ( -x "/usr/bin/smbpasswd" );
    
    # try to add the user to samba
    open(Writer, "| /usr/bin/smbpasswd -a -s $student_id >/dev/null 2>&1 " );
    print Writer "$newpass\n$newpass\n";
    close Writer;


    # if it failed we change the rootpw samba uses, and try again
    # we assume the ldap admin pw has changed (or it is the first time)
    my $retmsg;
    if($?) {
	$retmsg = $text{"failed_admin_samba"};
# Please add a root user to your samba!	
#        system("/usr/bin/smbpasswd -w $rootpass >/dev/null 2>&1");
#        if($?) {
#            $retmsg = $text{"failed_admin_samba"};
#        }
#        open(Writer, "| /usr/bin/smbpasswd -a -s $student_id" );
#        print Writer "$newpass\n$newpass\n";
#        close Writer;
#        
#        if($?) {
#            $retmsg = $text{"failed_samba", $student_id};
#        }
    }
    
    if($retmsg) {
        return ("error", $retmsg);
    } else {
        return (undef, $text{"added_samba", $student_id});
    }
}


1;
