/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <InductorM.h>

#include <Strings.h>
#include <TwoPorts.h>
#include <VectorFont.h>

#include "../images/inductorm.xpm"

QPixmap* InductorM::pixmap_ = 0;

//-----------------------------------------------------------------
InductorM::InductorM( const QPoint& center )
    : Component( center )
{}

//-----------------------------------------------------------------
InductorM::~InductorM()
{}

//-----------------------------------------------------------------
const QString& InductorM::getCatagory() const
  {
    return Strings::LumpedCatagory;
  }

//-----------------------------------------------------------------
const QString& InductorM::getName() const
  {
    return Strings::InductorMName;
  }

//-----------------------------------------------------------------
const QPixmap& InductorM::getPixmap() const
  {
    if (!pixmap_)
      {
        pixmap_ = new QPixmap(inductorm_xpm);
      }
    return *pixmap_;
  }

//-----------------------------------------------------------------
void InductorM::initComponent()
{
  boundingRect_ = QRect(-16, -20, 32, 40);
  addNode(-24,-16);
  addNode(+24,-16);
  addNode(-24,+16);
  addNode(+24,+16);
  addAttribute( Strings::AttrPrimaryInductance, "L1" );
  addAttribute( Strings::AttrSecondaryInductance, "L2" );
  addAttribute( Strings::AttrCoupleFactor, "K" );
}

//-----------------------------------------------------------------
void InductorM::drawSymbol(QPainter* p)
{
  p->save();
  for (int i=0; i<2; i++)
    {
      p->drawLine(-24,16,-14,16);
      p->drawLine(14,16,24,16);
      p->drawArc(-14,10,12,12,2880,-2880);
      p->drawArc(-6,10,12,12,2880,-2880);
      p->drawArc(+2,10,12,12,2880,-2880);
      p->drawArc(-6,10,4,12,0,-2880);
      p->drawArc(+2,10,4,12,0,-2880);
      p->drawEllipse(-20,10,4,4);
      if (i==0)
        {
          QString text = "1:2";
          p->rotate(90);
          VectorFont::instance()->drawText(text, p, QPoint(-8,4 ) );
          p->rotate(-90);
        }
      p->rotate( 180 );
    }
  p->restore();
}

//-----------------------------------------------------------------
bool InductorM::initSweep()
{
  TReal l1 = l1_;
  TReal l2 = l2_;
  TReal k = k_;
  l1_ = getAttributeValue( "L1" );
  l2_ = getAttributeValue( "L2" );
  k_ = getAttributeValue( "K" );
  l1_ = l1_ * getDimensionValue( Strings::InductanceDim );
  l2_ = l2_ * getDimensionValue( Strings::InductanceDim );
  return ((l1_ != l1) || (l2_ != l2) || (k_ != k));
}

//-----------------------------------------------------------------
void InductorM::addToAdmittanceMatrix( TReal freq, Matrix* yn )
{
  Matrix y;
  TwoPorts::getTransformer( freq, l1_, l2_, k_, y );
  uint nodes [4];
  for ( uint i=0; i<4; i++ )
    {
      nodes[i] = node(i)->getNodeNumber();
    }
  yn->insertTwoPort( y, nodes );
}
