/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef TWOPORTS_H
#define TWOPORTS_H

//---------------------------------------------------------------------------

#include <Types.h>

class Matrix;

class TwoPorts
{
public:
  static void getTLIN(TReal Freq, TReal Z, TReal E, TReal Fo, Matrix& Y);
  static void getTLSC(TReal Freq, TReal Z, TReal E, TReal Fo, TComplex &Y);
  static void getTLOC(TReal Freq, TReal Z, TReal E, TReal Fo, TComplex &Y);
  static void getCLIN(TReal Freq, TReal Ze, TReal Zo, TReal E, TReal Fo, Matrix& Y);
  static void getGYR(TReal R, Matrix& Y);
  static void getTransformer(TReal f, TReal L1, TReal L2, TReal k, Matrix& Y);
  static void getBIPB(TReal Freq, TReal B, TReal Fo, TReal Re, TReal C, Matrix& Y);
  static void getSLIN(TReal Freq, 
		      TReal W,  //Line width
		      TReal S,  //Line spacing
		      TReal L,  //Line length
		      TReal T,  //Conductor thickness
		      TReal H,  //Substrate height
		      TReal Er, //Relative permittivity
		      Matrix& Y);
  static void getMLIN(TReal Freq,
		      TReal W,  //Line width
		      TReal L,  //Line length
		      TReal T,  //Line thickness
		      TReal H,  //Substrate height
		      TReal Er, //Relative permittivity
		      TReal tanRho, //Loss
		      Matrix& Y);
  static void getSCLIN(TReal Freq, 
		       TReal W,  //Line width
		       TReal S,  //Line spacing
		       TReal L,  //Line length
		       TReal H,  //Substrate height
		       TReal Er, //Relative permittivity
		       Matrix& Y);

  static void getCoaxLIN(TReal Freq,
			 TReal W,  //Outer Diameter of the inner conductor
			 TReal L,  //Line length
			 TReal T,  //Thickness of the inner conductor for further calculations (not used for the monent)
			 TReal H,  //Inner Diameter of the outer conductor (shield)
			 TReal Er, //Relative permittivity beween the shield and the inner conductor
			 TReal tanRho, //Loss
			 Matrix& Y);
  
private:
  TwoPorts();
};

#endif
