# Functions for scheduled email notification

do '../web-lib.pl';
&init_config();
&switch_to_remote_user();
&create_user_config_dirs();
&foreign_require("cron", "cron-lib.pl");
&foreign_require("mailbox", "mailbox-lib.pl");
do '../ui-lib.pl';
use Time::Local;

$schedules_dir = "$user_module_config_directory/schedules";
$messages_dir = "$user_module_config_directory/messages";
$cron_cmd = "$user_module_config_directory/email.pl";
$atmode_cmd = "$user_module_config_directory/atmode.pl";

# list_schedules()
# Returns a list of all scheduled messages
sub list_schedules
{
local @rv;
opendir(DIR, $schedules_dir);
foreach $f (readdir(DIR)) {
	next if ($f eq "." || $f eq "..");
	local $sched = &get_schedule($f);
	push(@rv, $sched) if ($sched);
	}
closedir(DIR);
return @rv;
}

# get_schedule(id)
sub get_schedule
{
local $file = "$schedules_dir/$_[0]";
local %sched;
&read_file($file, \%sched);
$sched{'id'} = $_[0];
$sched{'file'} = $file;
$sched{'mfile'} = "$messages_dir/$_[0]";
open(MAIL, $sched{'mfile'});
while(<MAIL>) {
	$sched{'mail'} .= $_;
	}
close(MAIL);
return \%sched;
}

# save_schedule(&sched)
sub save_schedule
{
mkdir($schedules_dir, 0700) if (!-d $schedules_dir);
mkdir($messages_dir, 0700) if (!-d $messages_dir);
$_[0]->{'id'} ||= time().$$;
local $file = $_[0]->{'file'} || "$schedules_dir/$_[0]->{'id'}";
local %copy = %{$_[0]};
delete($copy{'mail'});
&write_file($file, \%copy);
local $mfile = $_[0]->{'mfile'} || "$messages_dir/$_[0]->{'id'}";
open(MAIL, ">$mfile");
print MAIL $_[0]->{'mail'};
close(MAIL);
}

# delete_schedule(&sched)
sub delete_schedule
{
unlink($_[0]->{'file'});
unlink($_[0]->{'mfile'});
}

# find_cron_job(&sched)
# Finds the cron job for some scheduled email
sub find_cron_job
{
local @jobs = &cron::list_cron_jobs();
local ($job) = grep { $_->{'user'} eq $remote_user &&
		      $_->{'command'} eq "$cron_cmd $_[0]->{'id'}" } @jobs;
return $job;
}

# my_email_address([with-name])
sub my_email_address
{
local ($froms, $doms) = &mailbox::list_from_addresses();
if (@$froms) {
	local ($fp) = &mailbox::split_addresses($froms->[0]);
	if ($fp) {
		return $_[0] ? $fp->[2] : $fp->[0];
		}
	}
return $remote_user.'@'.&get_system_hostname();
}

# create_atmode_job()
# If any jobs exist that are scheduled at a specific time, create a cron job
# to check for them once per minute
sub create_atmode_job
{
local @ats = grep { $_->{'at'} } &list_schedules();
if (@ats) {
	local @jobs = &cron::list_cron_jobs();
	local ($job) = grep { $_->{'user'} eq $remote_user &&
			      $_->{'command'} eq $atmode_cmd } @jobs;
	if (!$job) {
		local @mins = map { $_*5 } (0 .. 11);
		$job = { 'command' => $atmode_cmd,
			 'user' => $remote_user,
			 'active' => 1,
			 'mins' => join(",", @mins),
			 'hours' => '*',
			 'days' => '*',
			 'months' => '*',
			 'weekdays' => '*' };
		&cron::create_cron_job($job);
		&cron::create_wrapper($atmode_cmd, $module_name, "atmode.pl");
		}
	}
}

# make_email(&schedule)
sub make_email
{
local ($sched) = @_;
local $myaddr = &my_email_address(1);
return { 'headers' => [ [ 'From' => $sched->{'from'} || $myaddr ],
			[ 'To' => $sched->{'to'} || $myaddr ],
			[ 'Cc' => $sched->{'cc'} ],
			[ 'Bcc' => $sched->{'bcc'} ],
			[ 'Subject' => $sched->{'subject'} ] ],
	  'attach' => [ { 'headers' => [ [ 'Content-type', 'text/plain' ] ],
			  'data' => $sched->{'mail'} } ]
	};
}

1;

